//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package aad

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/aad/mgmt/2020-07-01-preview/aad"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateCreated   ProvisioningState = original.ProvisioningStateCreated
	ProvisioningStateFailed    ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateSucceeded ProvisioningState = original.ProvisioningStateSucceeded
)

type ARMProxyResource = original.ARMProxyResource
type AzureADMetricsClient = original.AzureADMetricsClient
type AzureADMetricsConfig = original.AzureADMetricsConfig
type AzureADMetricsCreateOrUpdateFuture = original.AzureADMetricsCreateOrUpdateFuture
type AzureADMetricsListResult = original.AzureADMetricsListResult
type AzureADMetricsListResultIterator = original.AzureADMetricsListResultIterator
type AzureADMetricsListResultPage = original.AzureADMetricsListResultPage
type AzureADMetricsPropertiesFormat = original.AzureADMetricsPropertiesFormat
type AzureADMetricsUpdateParameter = original.AzureADMetricsUpdateParameter
type AzureEntityResource = original.AzureEntityResource
type AzureResourceBase = original.AzureResourceBase
type BaseClient = original.BaseClient
type ErrorDefinition = original.ErrorDefinition
type ErrorResponse = original.ErrorResponse
type PrivateLinkForAzureAdClient = original.PrivateLinkForAzureAdClient
type PrivateLinkForAzureAdCreateFuture = original.PrivateLinkForAzureAdCreateFuture
type PrivateLinkPolicy = original.PrivateLinkPolicy
type PrivateLinkPolicyListResult = original.PrivateLinkPolicyListResult
type PrivateLinkPolicyListResultIterator = original.PrivateLinkPolicyListResultIterator
type PrivateLinkPolicyListResultPage = original.PrivateLinkPolicyListResultPage
type PrivateLinkPolicyUpdateParameter = original.PrivateLinkPolicyUpdateParameter
type PrivateLinkResource = original.PrivateLinkResource
type PrivateLinkResourceListResult = original.PrivateLinkResourceListResult
type PrivateLinkResourceListResultIterator = original.PrivateLinkResourceListResultIterator
type PrivateLinkResourceListResultPage = original.PrivateLinkResourceListResultPage
type PrivateLinkResourceProperties = original.PrivateLinkResourceProperties
type PrivateLinkResourcesClient = original.PrivateLinkResourcesClient
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type TrackedResource = original.TrackedResource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAzureADMetricsClient(subscriptionID string) AzureADMetricsClient {
	return original.NewAzureADMetricsClient(subscriptionID)
}
func NewAzureADMetricsClientWithBaseURI(baseURI string, subscriptionID string) AzureADMetricsClient {
	return original.NewAzureADMetricsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAzureADMetricsListResultIterator(page AzureADMetricsListResultPage) AzureADMetricsListResultIterator {
	return original.NewAzureADMetricsListResultIterator(page)
}
func NewAzureADMetricsListResultPage(cur AzureADMetricsListResult, getNextPage func(context.Context, AzureADMetricsListResult) (AzureADMetricsListResult, error)) AzureADMetricsListResultPage {
	return original.NewAzureADMetricsListResultPage(cur, getNextPage)
}
func NewPrivateLinkForAzureAdClient(subscriptionID string) PrivateLinkForAzureAdClient {
	return original.NewPrivateLinkForAzureAdClient(subscriptionID)
}
func NewPrivateLinkForAzureAdClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkForAzureAdClient {
	return original.NewPrivateLinkForAzureAdClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkPolicyListResultIterator(page PrivateLinkPolicyListResultPage) PrivateLinkPolicyListResultIterator {
	return original.NewPrivateLinkPolicyListResultIterator(page)
}
func NewPrivateLinkPolicyListResultPage(cur PrivateLinkPolicyListResult, getNextPage func(context.Context, PrivateLinkPolicyListResult) (PrivateLinkPolicyListResult, error)) PrivateLinkPolicyListResultPage {
	return original.NewPrivateLinkPolicyListResultPage(cur, getNextPage)
}
func NewPrivateLinkResourceListResultIterator(page PrivateLinkResourceListResultPage) PrivateLinkResourceListResultIterator {
	return original.NewPrivateLinkResourceListResultIterator(page)
}
func NewPrivateLinkResourceListResultPage(cur PrivateLinkResourceListResult, getNextPage func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)) PrivateLinkResourceListResultPage {
	return original.NewPrivateLinkResourceListResultPage(cur, getNextPage)
}
func NewPrivateLinkResourcesClient(subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClient(subscriptionID)
}
func NewPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
