// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package qapps

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateLibraryItemReview = "AssociateLibraryItemReview"

// AssociateLibraryItemReviewRequest generates a "aws/request.Request" representing the
// client's request for the AssociateLibraryItemReview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateLibraryItemReview for more information on using the AssociateLibraryItemReview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateLibraryItemReviewRequest method.
//	req, resp := client.AssociateLibraryItemReviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/AssociateLibraryItemReview
func (c *QApps) AssociateLibraryItemReviewRequest(input *AssociateLibraryItemReviewInput) (req *request.Request, output *AssociateLibraryItemReviewOutput) {
	op := &request.Operation{
		Name:       opAssociateLibraryItemReview,
		HTTPMethod: "POST",
		HTTPPath:   "/catalog.associateItemRating",
	}

	if input == nil {
		input = &AssociateLibraryItemReviewInput{}
	}

	output = &AssociateLibraryItemReviewOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateLibraryItemReview API operation for QApps.
//
// Associates a rating or review for a library item with the user submitting
// the request. This increments the rating count for the specified library item.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation AssociateLibraryItemReview for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ServiceQuotaExceededException
//     The requested operation could not be completed because it would exceed the
//     service's quota or limit.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/AssociateLibraryItemReview
func (c *QApps) AssociateLibraryItemReview(input *AssociateLibraryItemReviewInput) (*AssociateLibraryItemReviewOutput, error) {
	req, out := c.AssociateLibraryItemReviewRequest(input)
	return out, req.Send()
}

// AssociateLibraryItemReviewWithContext is the same as AssociateLibraryItemReview with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateLibraryItemReview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) AssociateLibraryItemReviewWithContext(ctx aws.Context, input *AssociateLibraryItemReviewInput, opts ...request.Option) (*AssociateLibraryItemReviewOutput, error) {
	req, out := c.AssociateLibraryItemReviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateQAppWithUser = "AssociateQAppWithUser"

// AssociateQAppWithUserRequest generates a "aws/request.Request" representing the
// client's request for the AssociateQAppWithUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateQAppWithUser for more information on using the AssociateQAppWithUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateQAppWithUserRequest method.
//	req, resp := client.AssociateQAppWithUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/AssociateQAppWithUser
func (c *QApps) AssociateQAppWithUserRequest(input *AssociateQAppWithUserInput) (req *request.Request, output *AssociateQAppWithUserOutput) {
	op := &request.Operation{
		Name:       opAssociateQAppWithUser,
		HTTPMethod: "POST",
		HTTPPath:   "/apps.install",
	}

	if input == nil {
		input = &AssociateQAppWithUserInput{}
	}

	output = &AssociateQAppWithUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateQAppWithUser API operation for QApps.
//
// This operation creates a link between the user's identity calling the operation
// and a specific Q App. This is useful to mark the Q App as a favorite for
// the user if the user doesn't own the Amazon Q App so they can still run it
// and see it in their inventory of Q Apps.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation AssociateQAppWithUser for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ServiceQuotaExceededException
//     The requested operation could not be completed because it would exceed the
//     service's quota or limit.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/AssociateQAppWithUser
func (c *QApps) AssociateQAppWithUser(input *AssociateQAppWithUserInput) (*AssociateQAppWithUserOutput, error) {
	req, out := c.AssociateQAppWithUserRequest(input)
	return out, req.Send()
}

// AssociateQAppWithUserWithContext is the same as AssociateQAppWithUser with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateQAppWithUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) AssociateQAppWithUserWithContext(ctx aws.Context, input *AssociateQAppWithUserInput, opts ...request.Option) (*AssociateQAppWithUserOutput, error) {
	req, out := c.AssociateQAppWithUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLibraryItem = "CreateLibraryItem"

// CreateLibraryItemRequest generates a "aws/request.Request" representing the
// client's request for the CreateLibraryItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLibraryItem for more information on using the CreateLibraryItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLibraryItemRequest method.
//	req, resp := client.CreateLibraryItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreateLibraryItem
func (c *QApps) CreateLibraryItemRequest(input *CreateLibraryItemInput) (req *request.Request, output *CreateLibraryItemOutput) {
	op := &request.Operation{
		Name:       opCreateLibraryItem,
		HTTPMethod: "POST",
		HTTPPath:   "/catalog.createItem",
	}

	if input == nil {
		input = &CreateLibraryItemInput{}
	}

	output = &CreateLibraryItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLibraryItem API operation for QApps.
//
// Creates a new library item for an Amazon Q App, allowing it to be discovered
// and used by other allowed users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation CreateLibraryItem for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ServiceQuotaExceededException
//     The requested operation could not be completed because it would exceed the
//     service's quota or limit.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreateLibraryItem
func (c *QApps) CreateLibraryItem(input *CreateLibraryItemInput) (*CreateLibraryItemOutput, error) {
	req, out := c.CreateLibraryItemRequest(input)
	return out, req.Send()
}

// CreateLibraryItemWithContext is the same as CreateLibraryItem with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLibraryItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) CreateLibraryItemWithContext(ctx aws.Context, input *CreateLibraryItemInput, opts ...request.Option) (*CreateLibraryItemOutput, error) {
	req, out := c.CreateLibraryItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateQApp = "CreateQApp"

// CreateQAppRequest generates a "aws/request.Request" representing the
// client's request for the CreateQApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateQApp for more information on using the CreateQApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateQAppRequest method.
//	req, resp := client.CreateQAppRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreateQApp
func (c *QApps) CreateQAppRequest(input *CreateQAppInput) (req *request.Request, output *CreateQAppOutput) {
	op := &request.Operation{
		Name:       opCreateQApp,
		HTTPMethod: "POST",
		HTTPPath:   "/apps.create",
	}

	if input == nil {
		input = &CreateQAppInput{}
	}

	output = &CreateQAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateQApp API operation for QApps.
//
// Creates a new Amazon Q App based on the provided definition. The Q App definition
// specifies the cards and flow of the Q App. This operation also calculates
// the dependencies between the cards by inspecting the references in the prompts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation CreateQApp for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ConflictException
//     The requested operation could not be completed due to a conflict with the
//     current state of the resource.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ServiceQuotaExceededException
//     The requested operation could not be completed because it would exceed the
//     service's quota or limit.
//
//   - ContentTooLargeException
//     The requested operation could not be completed because the content exceeds
//     the maximum allowed size.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreateQApp
func (c *QApps) CreateQApp(input *CreateQAppInput) (*CreateQAppOutput, error) {
	req, out := c.CreateQAppRequest(input)
	return out, req.Send()
}

// CreateQAppWithContext is the same as CreateQApp with the addition of
// the ability to pass a context and additional request options.
//
// See CreateQApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) CreateQAppWithContext(ctx aws.Context, input *CreateQAppInput, opts ...request.Option) (*CreateQAppOutput, error) {
	req, out := c.CreateQAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLibraryItem = "DeleteLibraryItem"

// DeleteLibraryItemRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLibraryItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLibraryItem for more information on using the DeleteLibraryItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLibraryItemRequest method.
//	req, resp := client.DeleteLibraryItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DeleteLibraryItem
func (c *QApps) DeleteLibraryItemRequest(input *DeleteLibraryItemInput) (req *request.Request, output *DeleteLibraryItemOutput) {
	op := &request.Operation{
		Name:       opDeleteLibraryItem,
		HTTPMethod: "POST",
		HTTPPath:   "/catalog.deleteItem",
	}

	if input == nil {
		input = &DeleteLibraryItemInput{}
	}

	output = &DeleteLibraryItemOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLibraryItem API operation for QApps.
//
// Deletes a library item for an Amazon Q App, removing it from the library
// so it can no longer be discovered or used by other users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation DeleteLibraryItem for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ServiceQuotaExceededException
//     The requested operation could not be completed because it would exceed the
//     service's quota or limit.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DeleteLibraryItem
func (c *QApps) DeleteLibraryItem(input *DeleteLibraryItemInput) (*DeleteLibraryItemOutput, error) {
	req, out := c.DeleteLibraryItemRequest(input)
	return out, req.Send()
}

// DeleteLibraryItemWithContext is the same as DeleteLibraryItem with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLibraryItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) DeleteLibraryItemWithContext(ctx aws.Context, input *DeleteLibraryItemInput, opts ...request.Option) (*DeleteLibraryItemOutput, error) {
	req, out := c.DeleteLibraryItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteQApp = "DeleteQApp"

// DeleteQAppRequest generates a "aws/request.Request" representing the
// client's request for the DeleteQApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteQApp for more information on using the DeleteQApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteQAppRequest method.
//	req, resp := client.DeleteQAppRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DeleteQApp
func (c *QApps) DeleteQAppRequest(input *DeleteQAppInput) (req *request.Request, output *DeleteQAppOutput) {
	op := &request.Operation{
		Name:       opDeleteQApp,
		HTTPMethod: "POST",
		HTTPPath:   "/apps.delete",
	}

	if input == nil {
		input = &DeleteQAppInput{}
	}

	output = &DeleteQAppOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteQApp API operation for QApps.
//
// Deletes an Amazon Q App owned by the user. If the Q App was previously published
// to the library, it is also removed from the library.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation DeleteQApp for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DeleteQApp
func (c *QApps) DeleteQApp(input *DeleteQAppInput) (*DeleteQAppOutput, error) {
	req, out := c.DeleteQAppRequest(input)
	return out, req.Send()
}

// DeleteQAppWithContext is the same as DeleteQApp with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteQApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) DeleteQAppWithContext(ctx aws.Context, input *DeleteQAppInput, opts ...request.Option) (*DeleteQAppOutput, error) {
	req, out := c.DeleteQAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateLibraryItemReview = "DisassociateLibraryItemReview"

// DisassociateLibraryItemReviewRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateLibraryItemReview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateLibraryItemReview for more information on using the DisassociateLibraryItemReview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateLibraryItemReviewRequest method.
//	req, resp := client.DisassociateLibraryItemReviewRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DisassociateLibraryItemReview
func (c *QApps) DisassociateLibraryItemReviewRequest(input *DisassociateLibraryItemReviewInput) (req *request.Request, output *DisassociateLibraryItemReviewOutput) {
	op := &request.Operation{
		Name:       opDisassociateLibraryItemReview,
		HTTPMethod: "POST",
		HTTPPath:   "/catalog.disassociateItemRating",
	}

	if input == nil {
		input = &DisassociateLibraryItemReviewInput{}
	}

	output = &DisassociateLibraryItemReviewOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateLibraryItemReview API operation for QApps.
//
// Removes a rating or review previously submitted by the user for a library
// item.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation DisassociateLibraryItemReview for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ServiceQuotaExceededException
//     The requested operation could not be completed because it would exceed the
//     service's quota or limit.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DisassociateLibraryItemReview
func (c *QApps) DisassociateLibraryItemReview(input *DisassociateLibraryItemReviewInput) (*DisassociateLibraryItemReviewOutput, error) {
	req, out := c.DisassociateLibraryItemReviewRequest(input)
	return out, req.Send()
}

// DisassociateLibraryItemReviewWithContext is the same as DisassociateLibraryItemReview with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateLibraryItemReview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) DisassociateLibraryItemReviewWithContext(ctx aws.Context, input *DisassociateLibraryItemReviewInput, opts ...request.Option) (*DisassociateLibraryItemReviewOutput, error) {
	req, out := c.DisassociateLibraryItemReviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateQAppFromUser = "DisassociateQAppFromUser"

// DisassociateQAppFromUserRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateQAppFromUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateQAppFromUser for more information on using the DisassociateQAppFromUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateQAppFromUserRequest method.
//	req, resp := client.DisassociateQAppFromUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DisassociateQAppFromUser
func (c *QApps) DisassociateQAppFromUserRequest(input *DisassociateQAppFromUserInput) (req *request.Request, output *DisassociateQAppFromUserOutput) {
	op := &request.Operation{
		Name:       opDisassociateQAppFromUser,
		HTTPMethod: "POST",
		HTTPPath:   "/apps.uninstall",
	}

	if input == nil {
		input = &DisassociateQAppFromUserInput{}
	}

	output = &DisassociateQAppFromUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateQAppFromUser API operation for QApps.
//
// Disassociates a Q App from a user removing the user's access to run the Q
// App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation DisassociateQAppFromUser for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DisassociateQAppFromUser
func (c *QApps) DisassociateQAppFromUser(input *DisassociateQAppFromUserInput) (*DisassociateQAppFromUserOutput, error) {
	req, out := c.DisassociateQAppFromUserRequest(input)
	return out, req.Send()
}

// DisassociateQAppFromUserWithContext is the same as DisassociateQAppFromUser with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateQAppFromUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) DisassociateQAppFromUserWithContext(ctx aws.Context, input *DisassociateQAppFromUserInput, opts ...request.Option) (*DisassociateQAppFromUserOutput, error) {
	req, out := c.DisassociateQAppFromUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLibraryItem = "GetLibraryItem"

// GetLibraryItemRequest generates a "aws/request.Request" representing the
// client's request for the GetLibraryItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLibraryItem for more information on using the GetLibraryItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLibraryItemRequest method.
//	req, resp := client.GetLibraryItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetLibraryItem
func (c *QApps) GetLibraryItemRequest(input *GetLibraryItemInput) (req *request.Request, output *GetLibraryItemOutput) {
	op := &request.Operation{
		Name:       opGetLibraryItem,
		HTTPMethod: "GET",
		HTTPPath:   "/catalog.getItem",
	}

	if input == nil {
		input = &GetLibraryItemInput{}
	}

	output = &GetLibraryItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLibraryItem API operation for QApps.
//
// Retrieves details about a library item for an Amazon Q App, including its
// metadata, categories, ratings, and usage statistics.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation GetLibraryItem for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetLibraryItem
func (c *QApps) GetLibraryItem(input *GetLibraryItemInput) (*GetLibraryItemOutput, error) {
	req, out := c.GetLibraryItemRequest(input)
	return out, req.Send()
}

// GetLibraryItemWithContext is the same as GetLibraryItem with the addition of
// the ability to pass a context and additional request options.
//
// See GetLibraryItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) GetLibraryItemWithContext(ctx aws.Context, input *GetLibraryItemInput, opts ...request.Option) (*GetLibraryItemOutput, error) {
	req, out := c.GetLibraryItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQApp = "GetQApp"

// GetQAppRequest generates a "aws/request.Request" representing the
// client's request for the GetQApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQApp for more information on using the GetQApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetQAppRequest method.
//	req, resp := client.GetQAppRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQApp
func (c *QApps) GetQAppRequest(input *GetQAppInput) (req *request.Request, output *GetQAppOutput) {
	op := &request.Operation{
		Name:       opGetQApp,
		HTTPMethod: "GET",
		HTTPPath:   "/apps.get",
	}

	if input == nil {
		input = &GetQAppInput{}
	}

	output = &GetQAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetQApp API operation for QApps.
//
// Retrieves the full details of an Q App, including its definition specifying
// the cards and flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation GetQApp for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQApp
func (c *QApps) GetQApp(input *GetQAppInput) (*GetQAppOutput, error) {
	req, out := c.GetQAppRequest(input)
	return out, req.Send()
}

// GetQAppWithContext is the same as GetQApp with the addition of
// the ability to pass a context and additional request options.
//
// See GetQApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) GetQAppWithContext(ctx aws.Context, input *GetQAppInput, opts ...request.Option) (*GetQAppOutput, error) {
	req, out := c.GetQAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQAppSession = "GetQAppSession"

// GetQAppSessionRequest generates a "aws/request.Request" representing the
// client's request for the GetQAppSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQAppSession for more information on using the GetQAppSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetQAppSessionRequest method.
//	req, resp := client.GetQAppSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQAppSession
func (c *QApps) GetQAppSessionRequest(input *GetQAppSessionInput) (req *request.Request, output *GetQAppSessionOutput) {
	op := &request.Operation{
		Name:       opGetQAppSession,
		HTTPMethod: "GET",
		HTTPPath:   "/runtime.getQAppSession",
	}

	if input == nil {
		input = &GetQAppSessionInput{}
	}

	output = &GetQAppSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetQAppSession API operation for QApps.
//
// Retrieves the current state and results for an active session of an Amazon
// Q App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation GetQAppSession for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ServiceQuotaExceededException
//     The requested operation could not be completed because it would exceed the
//     service's quota or limit.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQAppSession
func (c *QApps) GetQAppSession(input *GetQAppSessionInput) (*GetQAppSessionOutput, error) {
	req, out := c.GetQAppSessionRequest(input)
	return out, req.Send()
}

// GetQAppSessionWithContext is the same as GetQAppSession with the addition of
// the ability to pass a context and additional request options.
//
// See GetQAppSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) GetQAppSessionWithContext(ctx aws.Context, input *GetQAppSessionInput, opts ...request.Option) (*GetQAppSessionOutput, error) {
	req, out := c.GetQAppSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportDocument = "ImportDocument"

// ImportDocumentRequest generates a "aws/request.Request" representing the
// client's request for the ImportDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportDocument for more information on using the ImportDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportDocumentRequest method.
//	req, resp := client.ImportDocumentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ImportDocument
func (c *QApps) ImportDocumentRequest(input *ImportDocumentInput) (req *request.Request, output *ImportDocumentOutput) {
	op := &request.Operation{
		Name:       opImportDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/apps.importDocument",
	}

	if input == nil {
		input = &ImportDocumentInput{}
	}

	output = &ImportDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportDocument API operation for QApps.
//
// Uploads a file that can then be used either as a default in a FileUploadCard
// from Q App definition or as a file that is used inside a single Q App run.
// The purpose of the document is determined by a scope parameter that indicates
// whether it is at the app definition level or at the app session level.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation ImportDocument for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ServiceQuotaExceededException
//     The requested operation could not be completed because it would exceed the
//     service's quota or limit.
//
//   - ContentTooLargeException
//     The requested operation could not be completed because the content exceeds
//     the maximum allowed size.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ImportDocument
func (c *QApps) ImportDocument(input *ImportDocumentInput) (*ImportDocumentOutput, error) {
	req, out := c.ImportDocumentRequest(input)
	return out, req.Send()
}

// ImportDocumentWithContext is the same as ImportDocument with the addition of
// the ability to pass a context and additional request options.
//
// See ImportDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) ImportDocumentWithContext(ctx aws.Context, input *ImportDocumentInput, opts ...request.Option) (*ImportDocumentOutput, error) {
	req, out := c.ImportDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLibraryItems = "ListLibraryItems"

// ListLibraryItemsRequest generates a "aws/request.Request" representing the
// client's request for the ListLibraryItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLibraryItems for more information on using the ListLibraryItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLibraryItemsRequest method.
//	req, resp := client.ListLibraryItemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListLibraryItems
func (c *QApps) ListLibraryItemsRequest(input *ListLibraryItemsInput) (req *request.Request, output *ListLibraryItemsOutput) {
	op := &request.Operation{
		Name:       opListLibraryItems,
		HTTPMethod: "GET",
		HTTPPath:   "/catalog.list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLibraryItemsInput{}
	}

	output = &ListLibraryItemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLibraryItems API operation for QApps.
//
// Lists the library items for Amazon Q Apps that are published and available
// for users in your Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation ListLibraryItems for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListLibraryItems
func (c *QApps) ListLibraryItems(input *ListLibraryItemsInput) (*ListLibraryItemsOutput, error) {
	req, out := c.ListLibraryItemsRequest(input)
	return out, req.Send()
}

// ListLibraryItemsWithContext is the same as ListLibraryItems with the addition of
// the ability to pass a context and additional request options.
//
// See ListLibraryItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) ListLibraryItemsWithContext(ctx aws.Context, input *ListLibraryItemsInput, opts ...request.Option) (*ListLibraryItemsOutput, error) {
	req, out := c.ListLibraryItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLibraryItemsPages iterates over the pages of a ListLibraryItems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLibraryItems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLibraryItems operation.
//	pageNum := 0
//	err := client.ListLibraryItemsPages(params,
//	    func(page *qapps.ListLibraryItemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QApps) ListLibraryItemsPages(input *ListLibraryItemsInput, fn func(*ListLibraryItemsOutput, bool) bool) error {
	return c.ListLibraryItemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLibraryItemsPagesWithContext same as ListLibraryItemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) ListLibraryItemsPagesWithContext(ctx aws.Context, input *ListLibraryItemsInput, fn func(*ListLibraryItemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLibraryItemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLibraryItemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLibraryItemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListQApps = "ListQApps"

// ListQAppsRequest generates a "aws/request.Request" representing the
// client's request for the ListQApps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQApps for more information on using the ListQApps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListQAppsRequest method.
//	req, resp := client.ListQAppsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQApps
func (c *QApps) ListQAppsRequest(input *ListQAppsInput) (req *request.Request, output *ListQAppsOutput) {
	op := &request.Operation{
		Name:       opListQApps,
		HTTPMethod: "GET",
		HTTPPath:   "/apps.list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQAppsInput{}
	}

	output = &ListQAppsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListQApps API operation for QApps.
//
// Lists the Amazon Q Apps owned by or associated with the user either because
// they created it or because they used it from the library in the past. The
// user identity is extracted from the credentials used to invoke this operation..
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation ListQApps for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQApps
func (c *QApps) ListQApps(input *ListQAppsInput) (*ListQAppsOutput, error) {
	req, out := c.ListQAppsRequest(input)
	return out, req.Send()
}

// ListQAppsWithContext is the same as ListQApps with the addition of
// the ability to pass a context and additional request options.
//
// See ListQApps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) ListQAppsWithContext(ctx aws.Context, input *ListQAppsInput, opts ...request.Option) (*ListQAppsOutput, error) {
	req, out := c.ListQAppsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQAppsPages iterates over the pages of a ListQApps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQApps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListQApps operation.
//	pageNum := 0
//	err := client.ListQAppsPages(params,
//	    func(page *qapps.ListQAppsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *QApps) ListQAppsPages(input *ListQAppsInput, fn func(*ListQAppsOutput, bool) bool) error {
	return c.ListQAppsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQAppsPagesWithContext same as ListQAppsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) ListQAppsPagesWithContext(ctx aws.Context, input *ListQAppsInput, fn func(*ListQAppsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQAppsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQAppsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListQAppsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListTagsForResource
func (c *QApps) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceARN}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for QApps.
//
// Lists the tags associated with an Amazon Q Apps resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListTagsForResource
func (c *QApps) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPredictQApp = "PredictQApp"

// PredictQAppRequest generates a "aws/request.Request" representing the
// client's request for the PredictQApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PredictQApp for more information on using the PredictQApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PredictQAppRequest method.
//	req, resp := client.PredictQAppRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/PredictQApp
func (c *QApps) PredictQAppRequest(input *PredictQAppInput) (req *request.Request, output *PredictQAppOutput) {
	op := &request.Operation{
		Name:       opPredictQApp,
		HTTPMethod: "POST",
		HTTPPath:   "/apps.predictQApp",
	}

	if input == nil {
		input = &PredictQAppInput{}
	}

	output = &PredictQAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PredictQApp API operation for QApps.
//
// Generates an Amazon Q App definition based on either a conversation or a
// problem statement provided as input.The resulting app definition can be used
// to call CreateQApp. This API doesn't create Amazon Q Apps directly.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation PredictQApp for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/PredictQApp
func (c *QApps) PredictQApp(input *PredictQAppInput) (*PredictQAppOutput, error) {
	req, out := c.PredictQAppRequest(input)
	return out, req.Send()
}

// PredictQAppWithContext is the same as PredictQApp with the addition of
// the ability to pass a context and additional request options.
//
// See PredictQApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) PredictQAppWithContext(ctx aws.Context, input *PredictQAppInput, opts ...request.Option) (*PredictQAppOutput, error) {
	req, out := c.PredictQAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartQAppSession = "StartQAppSession"

// StartQAppSessionRequest generates a "aws/request.Request" representing the
// client's request for the StartQAppSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartQAppSession for more information on using the StartQAppSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartQAppSessionRequest method.
//	req, resp := client.StartQAppSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/StartQAppSession
func (c *QApps) StartQAppSessionRequest(input *StartQAppSessionInput) (req *request.Request, output *StartQAppSessionOutput) {
	op := &request.Operation{
		Name:       opStartQAppSession,
		HTTPMethod: "POST",
		HTTPPath:   "/runtime.startQAppSession",
	}

	if input == nil {
		input = &StartQAppSessionInput{}
	}

	output = &StartQAppSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartQAppSession API operation for QApps.
//
// Starts a new session for an Amazon Q App, allowing inputs to be provided
// and the app to be run.
//
// Each Q App session will be condensed into a single conversation in the web
// experience.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation StartQAppSession for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ServiceQuotaExceededException
//     The requested operation could not be completed because it would exceed the
//     service's quota or limit.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/StartQAppSession
func (c *QApps) StartQAppSession(input *StartQAppSessionInput) (*StartQAppSessionOutput, error) {
	req, out := c.StartQAppSessionRequest(input)
	return out, req.Send()
}

// StartQAppSessionWithContext is the same as StartQAppSession with the addition of
// the ability to pass a context and additional request options.
//
// See StartQAppSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) StartQAppSessionWithContext(ctx aws.Context, input *StartQAppSessionInput, opts ...request.Option) (*StartQAppSessionOutput, error) {
	req, out := c.StartQAppSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopQAppSession = "StopQAppSession"

// StopQAppSessionRequest generates a "aws/request.Request" representing the
// client's request for the StopQAppSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopQAppSession for more information on using the StopQAppSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopQAppSessionRequest method.
//	req, resp := client.StopQAppSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/StopQAppSession
func (c *QApps) StopQAppSessionRequest(input *StopQAppSessionInput) (req *request.Request, output *StopQAppSessionOutput) {
	op := &request.Operation{
		Name:       opStopQAppSession,
		HTTPMethod: "POST",
		HTTPPath:   "/runtime.deleteMiniAppRun",
	}

	if input == nil {
		input = &StopQAppSessionInput{}
	}

	output = &StopQAppSessionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopQAppSession API operation for QApps.
//
// Stops an active session for an Amazon Q App.This deletes all data related
// to the session and makes it invalid for future uses. The results of the session
// will be persisted as part of the conversation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation StopQAppSession for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ServiceQuotaExceededException
//     The requested operation could not be completed because it would exceed the
//     service's quota or limit.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/StopQAppSession
func (c *QApps) StopQAppSession(input *StopQAppSessionInput) (*StopQAppSessionOutput, error) {
	req, out := c.StopQAppSessionRequest(input)
	return out, req.Send()
}

// StopQAppSessionWithContext is the same as StopQAppSession with the addition of
// the ability to pass a context and additional request options.
//
// See StopQAppSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) StopQAppSessionWithContext(ctx aws.Context, input *StopQAppSessionInput, opts ...request.Option) (*StopQAppSessionOutput, error) {
	req, out := c.StopQAppSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/TagResource
func (c *QApps) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceARN}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for QApps.
//
// Associates tags with an Amazon Q Apps resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ConflictException
//     The requested operation could not be completed due to a conflict with the
//     current state of the resource.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/TagResource
func (c *QApps) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UntagResource
func (c *QApps) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceARN}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for QApps.
//
// Disassociates tags from an Amazon Q Apps resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UntagResource
func (c *QApps) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLibraryItem = "UpdateLibraryItem"

// UpdateLibraryItemRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLibraryItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLibraryItem for more information on using the UpdateLibraryItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateLibraryItemRequest method.
//	req, resp := client.UpdateLibraryItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateLibraryItem
func (c *QApps) UpdateLibraryItemRequest(input *UpdateLibraryItemInput) (req *request.Request, output *UpdateLibraryItemOutput) {
	op := &request.Operation{
		Name:       opUpdateLibraryItem,
		HTTPMethod: "POST",
		HTTPPath:   "/catalog.updateItem",
	}

	if input == nil {
		input = &UpdateLibraryItemInput{}
	}

	output = &UpdateLibraryItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLibraryItem API operation for QApps.
//
// Updates the metadata and status of a library item for an Amazon Q App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation UpdateLibraryItem for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateLibraryItem
func (c *QApps) UpdateLibraryItem(input *UpdateLibraryItemInput) (*UpdateLibraryItemOutput, error) {
	req, out := c.UpdateLibraryItemRequest(input)
	return out, req.Send()
}

// UpdateLibraryItemWithContext is the same as UpdateLibraryItem with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLibraryItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) UpdateLibraryItemWithContext(ctx aws.Context, input *UpdateLibraryItemInput, opts ...request.Option) (*UpdateLibraryItemOutput, error) {
	req, out := c.UpdateLibraryItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQApp = "UpdateQApp"

// UpdateQAppRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQApp for more information on using the UpdateQApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateQAppRequest method.
//	req, resp := client.UpdateQAppRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQApp
func (c *QApps) UpdateQAppRequest(input *UpdateQAppInput) (req *request.Request, output *UpdateQAppOutput) {
	op := &request.Operation{
		Name:       opUpdateQApp,
		HTTPMethod: "POST",
		HTTPPath:   "/apps.update",
	}

	if input == nil {
		input = &UpdateQAppInput{}
	}

	output = &UpdateQAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateQApp API operation for QApps.
//
// Updates an existing Amazon Q App, allowing modifications to its title, description,
// and definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation UpdateQApp for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ContentTooLargeException
//     The requested operation could not be completed because the content exceeds
//     the maximum allowed size.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQApp
func (c *QApps) UpdateQApp(input *UpdateQAppInput) (*UpdateQAppOutput, error) {
	req, out := c.UpdateQAppRequest(input)
	return out, req.Send()
}

// UpdateQAppWithContext is the same as UpdateQApp with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) UpdateQAppWithContext(ctx aws.Context, input *UpdateQAppInput, opts ...request.Option) (*UpdateQAppOutput, error) {
	req, out := c.UpdateQAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQAppSession = "UpdateQAppSession"

// UpdateQAppSessionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQAppSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQAppSession for more information on using the UpdateQAppSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateQAppSessionRequest method.
//	req, resp := client.UpdateQAppSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppSession
func (c *QApps) UpdateQAppSessionRequest(input *UpdateQAppSessionInput) (req *request.Request, output *UpdateQAppSessionOutput) {
	op := &request.Operation{
		Name:       opUpdateQAppSession,
		HTTPMethod: "POST",
		HTTPPath:   "/runtime.updateQAppSession",
	}

	if input == nil {
		input = &UpdateQAppSessionInput{}
	}

	output = &UpdateQAppSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateQAppSession API operation for QApps.
//
// Updates the session for a given Q App sessionId. This is only valid when
// at least one card of the session is in the WAITING state. Data for each WAITING
// card can be provided as input. If inputs are not provided, the call will
// be accepted but session will not move forward. Inputs for cards that are
// not in the WAITING status will be ignored.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for QApps's
// API operation UpdateQAppSession for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The requested resource could not be found.
//
//   - AccessDeniedException
//     The client is not authorized to perform the requested operation.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by the service.
//
//   - InternalServerException
//     An internal service error occurred while processing the request.
//
//   - UnauthorizedException
//     The client is not authenticated or authorized to perform the requested operation.
//
//   - ServiceQuotaExceededException
//     The requested operation could not be completed because it would exceed the
//     service's quota or limit.
//
//   - ThrottlingException
//     The requested operation could not be completed because too many requests
//     were sent at once. Wait a bit and try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppSession
func (c *QApps) UpdateQAppSession(input *UpdateQAppSessionInput) (*UpdateQAppSessionOutput, error) {
	req, out := c.UpdateQAppSessionRequest(input)
	return out, req.Send()
}

// UpdateQAppSessionWithContext is the same as UpdateQAppSession with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQAppSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *QApps) UpdateQAppSessionWithContext(ctx aws.Context, input *UpdateQAppSessionInput, opts ...request.Option) (*UpdateQAppSessionOutput, error) {
	req, out := c.UpdateQAppSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The client is not authorized to perform the requested operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The definition of the Q App, specifying the cards and flow.
type AppDefinition struct {
	_ struct{} `type:"structure"`

	// The version of the app definition schema or specification.
	//
	// AppDefinitionVersion is a required field
	AppDefinitionVersion *string `locationName:"appDefinitionVersion" type:"string" required:"true"`

	// A flag indicating whether the Q App's definition can be edited by the user.
	CanEdit *bool `locationName:"canEdit" type:"boolean"`

	// The cards that make up the Q App, such as text input, file upload, or query
	// cards.
	//
	// Cards is a required field
	Cards []*Card `locationName:"cards" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppDefinition) GoString() string {
	return s.String()
}

// SetAppDefinitionVersion sets the AppDefinitionVersion field's value.
func (s *AppDefinition) SetAppDefinitionVersion(v string) *AppDefinition {
	s.AppDefinitionVersion = &v
	return s
}

// SetCanEdit sets the CanEdit field's value.
func (s *AppDefinition) SetCanEdit(v bool) *AppDefinition {
	s.CanEdit = &v
	return s
}

// SetCards sets the Cards field's value.
func (s *AppDefinition) SetCards(v []*Card) *AppDefinition {
	s.Cards = v
	return s
}

// The input for defining an Q App.
type AppDefinitionInput_ struct {
	_ struct{} `type:"structure"`

	// The cards that make up the Q App definition.
	//
	// Cards is a required field
	Cards []*CardInput_ `locationName:"cards" type:"list" required:"true"`

	// The initial prompt displayed when the Q App is started.
	InitialPrompt *string `locationName:"initialPrompt" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppDefinitionInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppDefinitionInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppDefinitionInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AppDefinitionInput_"}
	if s.Cards == nil {
		invalidParams.Add(request.NewErrParamRequired("Cards"))
	}
	if s.Cards != nil {
		for i, v := range s.Cards {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Cards", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCards sets the Cards field's value.
func (s *AppDefinitionInput_) SetCards(v []*CardInput_) *AppDefinitionInput_ {
	s.Cards = v
	return s
}

// SetInitialPrompt sets the InitialPrompt field's value.
func (s *AppDefinitionInput_) SetInitialPrompt(v string) *AppDefinitionInput_ {
	s.InitialPrompt = &v
	return s
}

type AssociateLibraryItemReviewInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// The unique identifier of the library item to associate the review with.
	//
	// LibraryItemId is a required field
	LibraryItemId *string `locationName:"libraryItemId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLibraryItemReviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLibraryItemReviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateLibraryItemReviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateLibraryItemReviewInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.LibraryItemId == nil {
		invalidParams.Add(request.NewErrParamRequired("LibraryItemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociateLibraryItemReviewInput) SetInstanceId(v string) *AssociateLibraryItemReviewInput {
	s.InstanceId = &v
	return s
}

// SetLibraryItemId sets the LibraryItemId field's value.
func (s *AssociateLibraryItemReviewInput) SetLibraryItemId(v string) *AssociateLibraryItemReviewInput {
	s.LibraryItemId = &v
	return s
}

type AssociateLibraryItemReviewOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLibraryItemReviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLibraryItemReviewOutput) GoString() string {
	return s.String()
}

type AssociateQAppWithUserInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Q App to associate with the user.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateQAppWithUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateQAppWithUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateQAppWithUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateQAppWithUserInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *AssociateQAppWithUserInput) SetAppId(v string) *AssociateQAppWithUserInput {
	s.AppId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociateQAppWithUserInput) SetInstanceId(v string) *AssociateQAppWithUserInput {
	s.InstanceId = &v
	return s
}

type AssociateQAppWithUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateQAppWithUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateQAppWithUserOutput) GoString() string {
	return s.String()
}

// The filter criteria used on responses based on document attributes or metadata
// fields.
type AttributeFilter struct {
	_ struct{} `type:"structure"`

	// Performs a logical AND operation on all supplied filters.
	AndAllFilters []*AttributeFilter `locationName:"andAllFilters" type:"list"`

	// Returns true when a document contains all the specified document attributes
	// or metadata fields. Supported for the following document attribute value
	// types (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html):
	// stringListValue.
	ContainsAll *DocumentAttribute `locationName:"containsAll" type:"structure"`

	// Returns true when a document contains any of the specified document attributes
	// or metadata fields. Supported for the following document attribute value
	// types (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html):
	// stringListValue.
	ContainsAny *DocumentAttribute `locationName:"containsAny" type:"structure"`

	// Performs an equals operation on two document attributes or metadata fields.
	// Supported for the following document attribute value types (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html):
	// dateValue, longValue, stringListValue and stringValue.
	EqualsTo *DocumentAttribute `locationName:"equalsTo" type:"structure"`

	// Performs a greater than operation on two document attributes or metadata
	// fields. Supported for the following document attribute value types (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html):
	// dateValue and longValue.
	GreaterThan *DocumentAttribute `locationName:"greaterThan" type:"structure"`

	// Performs a greater than or equals operation on two document attributes or
	// metadata fields. Supported for the following document attribute value types
	// (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html):
	// dateValue and longValue.
	GreaterThanOrEquals *DocumentAttribute `locationName:"greaterThanOrEquals" type:"structure"`

	// Performs a less than operation on two document attributes or metadata fields.
	// Supported for the following document attribute value types (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html):
	// dateValue and longValue.
	LessThan *DocumentAttribute `locationName:"lessThan" type:"structure"`

	// Performs a less than or equals operation on two document attributes or metadata
	// fields.Supported for the following document attribute value type (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html):
	// dateValue and longValue.
	LessThanOrEquals *DocumentAttribute `locationName:"lessThanOrEquals" type:"structure"`

	// Performs a logical NOT operation on all supplied filters.
	NotFilter *AttributeFilter `locationName:"notFilter" type:"structure"`

	// Performs a logical OR operation on all supplied filters.
	OrAllFilters []*AttributeFilter `locationName:"orAllFilters" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeFilter"}
	if s.ContainsAll != nil {
		if err := s.ContainsAll.Validate(); err != nil {
			invalidParams.AddNested("ContainsAll", err.(request.ErrInvalidParams))
		}
	}
	if s.ContainsAny != nil {
		if err := s.ContainsAny.Validate(); err != nil {
			invalidParams.AddNested("ContainsAny", err.(request.ErrInvalidParams))
		}
	}
	if s.EqualsTo != nil {
		if err := s.EqualsTo.Validate(); err != nil {
			invalidParams.AddNested("EqualsTo", err.(request.ErrInvalidParams))
		}
	}
	if s.GreaterThan != nil {
		if err := s.GreaterThan.Validate(); err != nil {
			invalidParams.AddNested("GreaterThan", err.(request.ErrInvalidParams))
		}
	}
	if s.GreaterThanOrEquals != nil {
		if err := s.GreaterThanOrEquals.Validate(); err != nil {
			invalidParams.AddNested("GreaterThanOrEquals", err.(request.ErrInvalidParams))
		}
	}
	if s.LessThan != nil {
		if err := s.LessThan.Validate(); err != nil {
			invalidParams.AddNested("LessThan", err.(request.ErrInvalidParams))
		}
	}
	if s.LessThanOrEquals != nil {
		if err := s.LessThanOrEquals.Validate(); err != nil {
			invalidParams.AddNested("LessThanOrEquals", err.(request.ErrInvalidParams))
		}
	}
	if s.NotFilter != nil {
		if err := s.NotFilter.Validate(); err != nil {
			invalidParams.AddNested("NotFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.OrAllFilters != nil {
		for i, v := range s.OrAllFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OrAllFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAndAllFilters sets the AndAllFilters field's value.
func (s *AttributeFilter) SetAndAllFilters(v []*AttributeFilter) *AttributeFilter {
	s.AndAllFilters = v
	return s
}

// SetContainsAll sets the ContainsAll field's value.
func (s *AttributeFilter) SetContainsAll(v *DocumentAttribute) *AttributeFilter {
	s.ContainsAll = v
	return s
}

// SetContainsAny sets the ContainsAny field's value.
func (s *AttributeFilter) SetContainsAny(v *DocumentAttribute) *AttributeFilter {
	s.ContainsAny = v
	return s
}

// SetEqualsTo sets the EqualsTo field's value.
func (s *AttributeFilter) SetEqualsTo(v *DocumentAttribute) *AttributeFilter {
	s.EqualsTo = v
	return s
}

// SetGreaterThan sets the GreaterThan field's value.
func (s *AttributeFilter) SetGreaterThan(v *DocumentAttribute) *AttributeFilter {
	s.GreaterThan = v
	return s
}

// SetGreaterThanOrEquals sets the GreaterThanOrEquals field's value.
func (s *AttributeFilter) SetGreaterThanOrEquals(v *DocumentAttribute) *AttributeFilter {
	s.GreaterThanOrEquals = v
	return s
}

// SetLessThan sets the LessThan field's value.
func (s *AttributeFilter) SetLessThan(v *DocumentAttribute) *AttributeFilter {
	s.LessThan = v
	return s
}

// SetLessThanOrEquals sets the LessThanOrEquals field's value.
func (s *AttributeFilter) SetLessThanOrEquals(v *DocumentAttribute) *AttributeFilter {
	s.LessThanOrEquals = v
	return s
}

// SetNotFilter sets the NotFilter field's value.
func (s *AttributeFilter) SetNotFilter(v *AttributeFilter) *AttributeFilter {
	s.NotFilter = v
	return s
}

// SetOrAllFilters sets the OrAllFilters field's value.
func (s *AttributeFilter) SetOrAllFilters(v []*AttributeFilter) *AttributeFilter {
	s.OrAllFilters = v
	return s
}

// A card representing a component or step in an Amazon Q App's flow.
type Card struct {
	_ struct{} `type:"structure"`

	// A container for the properties of the file upload card.
	FileUpload *FileUploadCard `locationName:"fileUpload" type:"structure"`

	// A container for the properties of the plugin card.
	QPlugin *QPluginCard `locationName:"qPlugin" type:"structure"`

	// A container for the properties of the query card.
	QQuery *QQueryCard `locationName:"qQuery" type:"structure"`

	// A container for the properties of the text input card.
	TextInput *TextInputCard `locationName:"textInput" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Card) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Card) GoString() string {
	return s.String()
}

// SetFileUpload sets the FileUpload field's value.
func (s *Card) SetFileUpload(v *FileUploadCard) *Card {
	s.FileUpload = v
	return s
}

// SetQPlugin sets the QPlugin field's value.
func (s *Card) SetQPlugin(v *QPluginCard) *Card {
	s.QPlugin = v
	return s
}

// SetQQuery sets the QQuery field's value.
func (s *Card) SetQQuery(v *QQueryCard) *Card {
	s.QQuery = v
	return s
}

// SetTextInput sets the TextInput field's value.
func (s *Card) SetTextInput(v *TextInputCard) *Card {
	s.TextInput = v
	return s
}

// The properties defining an input card in an Amazon Q App.
type CardInput_ struct {
	_ struct{} `type:"structure"`

	// A container for the properties of the file upload input card.
	FileUpload *FileUploadCardInput_ `locationName:"fileUpload" type:"structure"`

	// A container for the properties of the plugin input card.
	QPlugin *QPluginCardInput_ `locationName:"qPlugin" type:"structure"`

	// A container for the properties of the query input card.
	QQuery *QQueryCardInput_ `locationName:"qQuery" type:"structure"`

	// A container for the properties of the text input card.
	TextInput *TextInputCardInput_ `locationName:"textInput" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CardInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CardInput_"}
	if s.FileUpload != nil {
		if err := s.FileUpload.Validate(); err != nil {
			invalidParams.AddNested("FileUpload", err.(request.ErrInvalidParams))
		}
	}
	if s.QPlugin != nil {
		if err := s.QPlugin.Validate(); err != nil {
			invalidParams.AddNested("QPlugin", err.(request.ErrInvalidParams))
		}
	}
	if s.QQuery != nil {
		if err := s.QQuery.Validate(); err != nil {
			invalidParams.AddNested("QQuery", err.(request.ErrInvalidParams))
		}
	}
	if s.TextInput != nil {
		if err := s.TextInput.Validate(); err != nil {
			invalidParams.AddNested("TextInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileUpload sets the FileUpload field's value.
func (s *CardInput_) SetFileUpload(v *FileUploadCardInput_) *CardInput_ {
	s.FileUpload = v
	return s
}

// SetQPlugin sets the QPlugin field's value.
func (s *CardInput_) SetQPlugin(v *QPluginCardInput_) *CardInput_ {
	s.QPlugin = v
	return s
}

// SetQQuery sets the QQuery field's value.
func (s *CardInput_) SetQQuery(v *QQueryCardInput_) *CardInput_ {
	s.QQuery = v
	return s
}

// SetTextInput sets the TextInput field's value.
func (s *CardInput_) SetTextInput(v *TextInputCardInput_) *CardInput_ {
	s.TextInput = v
	return s
}

// The current status and value of a card in an active Amazon Q App session.
type CardStatus struct {
	_ struct{} `type:"structure"`

	// The current state of the card.
	//
	// CurrentState is a required field
	CurrentState *string `locationName:"currentState" type:"string" required:"true" enum:"ExecutionStatus"`

	// The current value or result associated with the card.
	//
	// CurrentValue is a required field
	CurrentValue *string `locationName:"currentValue" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardStatus) GoString() string {
	return s.String()
}

// SetCurrentState sets the CurrentState field's value.
func (s *CardStatus) SetCurrentState(v string) *CardStatus {
	s.CurrentState = &v
	return s
}

// SetCurrentValue sets the CurrentValue field's value.
func (s *CardStatus) SetCurrentValue(v string) *CardStatus {
	s.CurrentValue = &v
	return s
}

// The value or result associated with a card in a Amazon Q App session.
type CardValue struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the card.
	//
	// CardId is a required field
	CardId *string `locationName:"cardId" type:"string" required:"true"`

	// The value or result associated with the card.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CardValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CardValue"}
	if s.CardId == nil {
		invalidParams.Add(request.NewErrParamRequired("CardId"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCardId sets the CardId field's value.
func (s *CardValue) SetCardId(v string) *CardValue {
	s.CardId = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CardValue) SetValue(v string) *CardValue {
	s.Value = &v
	return s
}

// A category used to classify and filter library items for Amazon Q Apps.
type Category struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the category.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The title or name of the category.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Category) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Category) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Category) SetId(v string) *Category {
	s.Id = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Category) SetTitle(v string) *Category {
	s.Title = &v
	return s
}

// The requested operation could not be completed due to a conflict with the
// current state of the resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The unique identifier of the resource
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested operation could not be completed because the content exceeds
// the maximum allowed size.
type ContentTooLargeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The unique identifier of the resource
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentTooLargeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentTooLargeException) GoString() string {
	return s.String()
}

func newErrorContentTooLargeException(v protocol.ResponseMetadata) error {
	return &ContentTooLargeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ContentTooLargeException) Code() string {
	return "ContentTooLargeException"
}

// Message returns the exception's message.
func (s *ContentTooLargeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ContentTooLargeException) OrigErr() error {
	return nil
}

func (s *ContentTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ContentTooLargeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ContentTooLargeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A message in a conversation, used as input for generating an Amazon Q App
// definition.
type ConversationMessage struct {
	_ struct{} `type:"structure"`

	// The text content of the conversation message.
	//
	// Body is a required field
	Body *string `locationName:"body" type:"string" required:"true"`

	// The type of the conversation message.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"Sender"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConversationMessage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConversationMessage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConversationMessage"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *ConversationMessage) SetBody(v string) *ConversationMessage {
	s.Body = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConversationMessage) SetType(v string) *ConversationMessage {
	s.Type = &v
	return s
}

type CreateLibraryItemInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Amazon Q App to publish to the library.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The version of the Amazon Q App to publish to the library.
	//
	// AppVersion is a required field
	AppVersion *int64 `locationName:"appVersion" type:"integer" required:"true"`

	// The categories to associate with the library item for easier discovery.
	//
	// Categories is a required field
	Categories []*string `locationName:"categories" type:"list" required:"true"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLibraryItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLibraryItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLibraryItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLibraryItemInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AppVersion"))
	}
	if s.Categories == nil {
		invalidParams.Add(request.NewErrParamRequired("Categories"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *CreateLibraryItemInput) SetAppId(v string) *CreateLibraryItemInput {
	s.AppId = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *CreateLibraryItemInput) SetAppVersion(v int64) *CreateLibraryItemInput {
	s.AppVersion = &v
	return s
}

// SetCategories sets the Categories field's value.
func (s *CreateLibraryItemInput) SetCategories(v []*string) *CreateLibraryItemInput {
	s.Categories = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateLibraryItemInput) SetInstanceId(v string) *CreateLibraryItemInput {
	s.InstanceId = &v
	return s
}

type CreateLibraryItemOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the library item was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user who created the library item.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The unique identifier of the new library item.
	//
	// LibraryItemId is a required field
	LibraryItemId *string `locationName:"libraryItemId" type:"string" required:"true"`

	// The number of ratings the library item has received from users.
	//
	// RatingCount is a required field
	RatingCount *int64 `locationName:"ratingCount" type:"integer" required:"true"`

	// The status of the new library item, such as "Published".
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`

	// The date and time the library item was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user who last updated the library item.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLibraryItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLibraryItemOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateLibraryItemOutput) SetCreatedAt(v time.Time) *CreateLibraryItemOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CreateLibraryItemOutput) SetCreatedBy(v string) *CreateLibraryItemOutput {
	s.CreatedBy = &v
	return s
}

// SetLibraryItemId sets the LibraryItemId field's value.
func (s *CreateLibraryItemOutput) SetLibraryItemId(v string) *CreateLibraryItemOutput {
	s.LibraryItemId = &v
	return s
}

// SetRatingCount sets the RatingCount field's value.
func (s *CreateLibraryItemOutput) SetRatingCount(v int64) *CreateLibraryItemOutput {
	s.RatingCount = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateLibraryItemOutput) SetStatus(v string) *CreateLibraryItemOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateLibraryItemOutput) SetUpdatedAt(v time.Time) *CreateLibraryItemOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *CreateLibraryItemOutput) SetUpdatedBy(v string) *CreateLibraryItemOutput {
	s.UpdatedBy = &v
	return s
}

type CreateQAppInput struct {
	_ struct{} `type:"structure"`

	// The definition of the new Q App, specifying the cards and flow.
	//
	// AppDefinition is a required field
	AppDefinition *AppDefinitionInput_ `locationName:"appDefinition" type:"structure" required:"true"`

	// The description of the new Q App.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// Optional tags to associate with the new Q App.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The title of the new Q App.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateQAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateQAppInput"}
	if s.AppDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("AppDefinition"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.AppDefinition != nil {
		if err := s.AppDefinition.Validate(); err != nil {
			invalidParams.AddNested("AppDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppDefinition sets the AppDefinition field's value.
func (s *CreateQAppInput) SetAppDefinition(v *AppDefinitionInput_) *CreateQAppInput {
	s.AppDefinition = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateQAppInput) SetDescription(v string) *CreateQAppInput {
	s.Description = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateQAppInput) SetInstanceId(v string) *CreateQAppInput {
	s.InstanceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateQAppInput) SetTags(v map[string]*string) *CreateQAppInput {
	s.Tags = v
	return s
}

// SetTitle sets the Title field's value.
func (s *CreateQAppInput) SetTitle(v string) *CreateQAppInput {
	s.Title = &v
	return s
}

type CreateQAppOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new Q App.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The unique identifier of the new Q App.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The version of the new Q App.
	//
	// AppVersion is a required field
	AppVersion *int64 `locationName:"appVersion" type:"integer" required:"true"`

	// The date and time the Q App was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user who created the Q App.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The description of the new Q App.
	Description *string `locationName:"description" type:"string"`

	// The initial prompt displayed when the Q App is started.
	InitialPrompt *string `locationName:"initialPrompt" type:"string"`

	// The capabilities required to run the Q App, such as file upload or third-party
	// integrations.
	RequiredCapabilities []*string `locationName:"requiredCapabilities" type:"list" enum:"AppRequiredCapability"`

	// The status of the new Q App, such as "Created".
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AppStatus"`

	// The title of the new Q App.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`

	// The date and time the Q App was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user who last updated the Q App.
	//
	// UpdatedBy is a required field
	UpdatedBy *string `locationName:"updatedBy" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQAppOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *CreateQAppOutput) SetAppArn(v string) *CreateQAppOutput {
	s.AppArn = &v
	return s
}

// SetAppId sets the AppId field's value.
func (s *CreateQAppOutput) SetAppId(v string) *CreateQAppOutput {
	s.AppId = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *CreateQAppOutput) SetAppVersion(v int64) *CreateQAppOutput {
	s.AppVersion = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateQAppOutput) SetCreatedAt(v time.Time) *CreateQAppOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CreateQAppOutput) SetCreatedBy(v string) *CreateQAppOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateQAppOutput) SetDescription(v string) *CreateQAppOutput {
	s.Description = &v
	return s
}

// SetInitialPrompt sets the InitialPrompt field's value.
func (s *CreateQAppOutput) SetInitialPrompt(v string) *CreateQAppOutput {
	s.InitialPrompt = &v
	return s
}

// SetRequiredCapabilities sets the RequiredCapabilities field's value.
func (s *CreateQAppOutput) SetRequiredCapabilities(v []*string) *CreateQAppOutput {
	s.RequiredCapabilities = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateQAppOutput) SetStatus(v string) *CreateQAppOutput {
	s.Status = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *CreateQAppOutput) SetTitle(v string) *CreateQAppOutput {
	s.Title = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateQAppOutput) SetUpdatedAt(v time.Time) *CreateQAppOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *CreateQAppOutput) SetUpdatedBy(v string) *CreateQAppOutput {
	s.UpdatedBy = &v
	return s
}

type DeleteLibraryItemInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// The unique identifier of the library item to delete.
	//
	// LibraryItemId is a required field
	LibraryItemId *string `locationName:"libraryItemId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLibraryItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLibraryItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLibraryItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLibraryItemInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.LibraryItemId == nil {
		invalidParams.Add(request.NewErrParamRequired("LibraryItemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DeleteLibraryItemInput) SetInstanceId(v string) *DeleteLibraryItemInput {
	s.InstanceId = &v
	return s
}

// SetLibraryItemId sets the LibraryItemId field's value.
func (s *DeleteLibraryItemInput) SetLibraryItemId(v string) *DeleteLibraryItemInput {
	s.LibraryItemId = &v
	return s
}

type DeleteLibraryItemOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLibraryItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLibraryItemOutput) GoString() string {
	return s.String()
}

type DeleteQAppInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Q App to delete.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteQAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteQAppInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DeleteQAppInput) SetAppId(v string) *DeleteQAppInput {
	s.AppId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DeleteQAppInput) SetInstanceId(v string) *DeleteQAppInput {
	s.InstanceId = &v
	return s
}

type DeleteQAppOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQAppOutput) GoString() string {
	return s.String()
}

type DisassociateLibraryItemReviewInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// The unique identifier of the library item to remove the review from.
	//
	// LibraryItemId is a required field
	LibraryItemId *string `locationName:"libraryItemId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLibraryItemReviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLibraryItemReviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateLibraryItemReviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateLibraryItemReviewInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.LibraryItemId == nil {
		invalidParams.Add(request.NewErrParamRequired("LibraryItemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DisassociateLibraryItemReviewInput) SetInstanceId(v string) *DisassociateLibraryItemReviewInput {
	s.InstanceId = &v
	return s
}

// SetLibraryItemId sets the LibraryItemId field's value.
func (s *DisassociateLibraryItemReviewInput) SetLibraryItemId(v string) *DisassociateLibraryItemReviewInput {
	s.LibraryItemId = &v
	return s
}

type DisassociateLibraryItemReviewOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLibraryItemReviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateLibraryItemReviewOutput) GoString() string {
	return s.String()
}

type DisassociateQAppFromUserInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Q App to disassociate from the user.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateQAppFromUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateQAppFromUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateQAppFromUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateQAppFromUserInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DisassociateQAppFromUserInput) SetAppId(v string) *DisassociateQAppFromUserInput {
	s.AppId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DisassociateQAppFromUserInput) SetInstanceId(v string) *DisassociateQAppFromUserInput {
	s.InstanceId = &v
	return s
}

type DisassociateQAppFromUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateQAppFromUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateQAppFromUserOutput) GoString() string {
	return s.String()
}

// A document attribute or metadata field.
type DocumentAttribute struct {
	_ struct{} `type:"structure"`

	// The identifier for the attribute.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The value of the attribute.
	//
	// Value is a required field
	Value *DocumentAttributeValue `locationName:"value" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentAttribute"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DocumentAttribute) SetName(v string) *DocumentAttribute {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DocumentAttribute) SetValue(v *DocumentAttributeValue) *DocumentAttribute {
	s.Value = v
	return s
}

// The value of a document attribute. You can only provide one value for a document
// attribute.
type DocumentAttributeValue struct {
	_ struct{} `type:"structure"`

	// A date expressed as an ISO 8601 string.
	//
	// It's important for the time zone to be included in the ISO 8601 date-time
	// format. For example, 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time
	// format for March 25th 2012 at 12:30PM (plus 10 seconds) in Central European
	// Time.
	DateValue *time.Time `locationName:"dateValue" type:"timestamp"`

	// A long integer value.
	LongValue *int64 `locationName:"longValue" type:"long"`

	// A list of strings.
	StringListValue []*string `locationName:"stringListValue" type:"list"`

	// A string.
	StringValue *string `locationName:"stringValue" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentAttributeValue) GoString() string {
	return s.String()
}

// SetDateValue sets the DateValue field's value.
func (s *DocumentAttributeValue) SetDateValue(v time.Time) *DocumentAttributeValue {
	s.DateValue = &v
	return s
}

// SetLongValue sets the LongValue field's value.
func (s *DocumentAttributeValue) SetLongValue(v int64) *DocumentAttributeValue {
	s.LongValue = &v
	return s
}

// SetStringListValue sets the StringListValue field's value.
func (s *DocumentAttributeValue) SetStringListValue(v []*string) *DocumentAttributeValue {
	s.StringListValue = v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *DocumentAttributeValue) SetStringValue(v string) *DocumentAttributeValue {
	s.StringValue = &v
	return s
}

// A card in an Amazon Q App that allows the user to upload a file.
type FileUploadCard struct {
	_ struct{} `type:"structure"`

	// A flag indicating if the user can override the default file for the upload
	// card.
	AllowOverride *bool `locationName:"allowOverride" type:"boolean"`

	// Any dependencies or requirements for the file upload card.
	//
	// Dependencies is a required field
	Dependencies []*string `locationName:"dependencies" type:"list" required:"true"`

	// The unique identifier of the file associated with the card.
	FileId *string `locationName:"fileId" type:"string"`

	// The name of the file being uploaded.
	Filename *string `locationName:"filename" type:"string"`

	// The unique identifier of the file upload card.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The title of the file upload card.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`

	// The type of the card.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CardType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileUploadCard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileUploadCard) GoString() string {
	return s.String()
}

// SetAllowOverride sets the AllowOverride field's value.
func (s *FileUploadCard) SetAllowOverride(v bool) *FileUploadCard {
	s.AllowOverride = &v
	return s
}

// SetDependencies sets the Dependencies field's value.
func (s *FileUploadCard) SetDependencies(v []*string) *FileUploadCard {
	s.Dependencies = v
	return s
}

// SetFileId sets the FileId field's value.
func (s *FileUploadCard) SetFileId(v string) *FileUploadCard {
	s.FileId = &v
	return s
}

// SetFilename sets the Filename field's value.
func (s *FileUploadCard) SetFilename(v string) *FileUploadCard {
	s.Filename = &v
	return s
}

// SetId sets the Id field's value.
func (s *FileUploadCard) SetId(v string) *FileUploadCard {
	s.Id = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *FileUploadCard) SetTitle(v string) *FileUploadCard {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *FileUploadCard) SetType(v string) *FileUploadCard {
	s.Type = &v
	return s
}

// Represents a file upload card. It can optionally receive a filename and fileId
// to set a default file. If not received, the user must provide the file when
// the Q App runs.
type FileUploadCardInput_ struct {
	_ struct{} `type:"structure"`

	// A flag indicating if the user can override the default file for the upload
	// card.
	AllowOverride *bool `locationName:"allowOverride" type:"boolean"`

	// The identifier of a pre-uploaded file associated with the card.
	FileId *string `locationName:"fileId" type:"string"`

	// The default filename to use for the file upload card.
	Filename *string `locationName:"filename" type:"string"`

	// The unique identifier of the file upload card.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The title or label of the file upload card.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`

	// The type of the card.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CardType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileUploadCardInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileUploadCardInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FileUploadCardInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FileUploadCardInput_"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowOverride sets the AllowOverride field's value.
func (s *FileUploadCardInput_) SetAllowOverride(v bool) *FileUploadCardInput_ {
	s.AllowOverride = &v
	return s
}

// SetFileId sets the FileId field's value.
func (s *FileUploadCardInput_) SetFileId(v string) *FileUploadCardInput_ {
	s.FileId = &v
	return s
}

// SetFilename sets the Filename field's value.
func (s *FileUploadCardInput_) SetFilename(v string) *FileUploadCardInput_ {
	s.Filename = &v
	return s
}

// SetId sets the Id field's value.
func (s *FileUploadCardInput_) SetId(v string) *FileUploadCardInput_ {
	s.Id = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *FileUploadCardInput_) SetTitle(v string) *FileUploadCardInput_ {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *FileUploadCardInput_) SetType(v string) *FileUploadCardInput_ {
	s.Type = &v
	return s
}

type GetLibraryItemInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the Amazon Q App associated with the library item.
	AppId *string `location:"querystring" locationName:"appId" type:"string"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// The unique identifier of the library item to retrieve.
	//
	// LibraryItemId is a required field
	LibraryItemId *string `location:"querystring" locationName:"libraryItemId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLibraryItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLibraryItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLibraryItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLibraryItemInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.LibraryItemId == nil {
		invalidParams.Add(request.NewErrParamRequired("LibraryItemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetLibraryItemInput) SetAppId(v string) *GetLibraryItemInput {
	s.AppId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetLibraryItemInput) SetInstanceId(v string) *GetLibraryItemInput {
	s.InstanceId = &v
	return s
}

// SetLibraryItemId sets the LibraryItemId field's value.
func (s *GetLibraryItemInput) SetLibraryItemId(v string) *GetLibraryItemInput {
	s.LibraryItemId = &v
	return s
}

type GetLibraryItemOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Q App associated with the library item.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The version of the Q App associated with the library item.
	//
	// AppVersion is a required field
	AppVersion *int64 `locationName:"appVersion" type:"integer" required:"true"`

	// The categories associated with the library item for discovery.
	//
	// Categories is a required field
	Categories []*Category `locationName:"categories" type:"list" required:"true"`

	// The date and time the library item was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user who created the library item.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// Whether the current user has rated the library item.
	IsRatedByUser *bool `locationName:"isRatedByUser" type:"boolean"`

	// The unique identifier of the library item.
	//
	// LibraryItemId is a required field
	LibraryItemId *string `locationName:"libraryItemId" type:"string" required:"true"`

	// The number of ratings the library item has received from users.
	//
	// RatingCount is a required field
	RatingCount *int64 `locationName:"ratingCount" type:"integer" required:"true"`

	// The status of the library item, such as "Published".
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`

	// The date and time the library item was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user who last updated the library item.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`

	// The number of users who have associated the Q App with their account.
	UserCount *int64 `locationName:"userCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLibraryItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLibraryItemOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *GetLibraryItemOutput) SetAppId(v string) *GetLibraryItemOutput {
	s.AppId = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *GetLibraryItemOutput) SetAppVersion(v int64) *GetLibraryItemOutput {
	s.AppVersion = &v
	return s
}

// SetCategories sets the Categories field's value.
func (s *GetLibraryItemOutput) SetCategories(v []*Category) *GetLibraryItemOutput {
	s.Categories = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetLibraryItemOutput) SetCreatedAt(v time.Time) *GetLibraryItemOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetLibraryItemOutput) SetCreatedBy(v string) *GetLibraryItemOutput {
	s.CreatedBy = &v
	return s
}

// SetIsRatedByUser sets the IsRatedByUser field's value.
func (s *GetLibraryItemOutput) SetIsRatedByUser(v bool) *GetLibraryItemOutput {
	s.IsRatedByUser = &v
	return s
}

// SetLibraryItemId sets the LibraryItemId field's value.
func (s *GetLibraryItemOutput) SetLibraryItemId(v string) *GetLibraryItemOutput {
	s.LibraryItemId = &v
	return s
}

// SetRatingCount sets the RatingCount field's value.
func (s *GetLibraryItemOutput) SetRatingCount(v int64) *GetLibraryItemOutput {
	s.RatingCount = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetLibraryItemOutput) SetStatus(v string) *GetLibraryItemOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetLibraryItemOutput) SetUpdatedAt(v time.Time) *GetLibraryItemOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetLibraryItemOutput) SetUpdatedBy(v string) *GetLibraryItemOutput {
	s.UpdatedBy = &v
	return s
}

// SetUserCount sets the UserCount field's value.
func (s *GetLibraryItemOutput) SetUserCount(v int64) *GetLibraryItemOutput {
	s.UserCount = &v
	return s
}

type GetQAppInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the Q App to retrieve.
	//
	// AppId is a required field
	AppId *string `location:"querystring" locationName:"appId" type:"string" required:"true"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQAppInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetQAppInput) SetAppId(v string) *GetQAppInput {
	s.AppId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetQAppInput) SetInstanceId(v string) *GetQAppInput {
	s.InstanceId = &v
	return s
}

type GetQAppOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Q App.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The full definition of the Q App, specifying the cards and flow.
	//
	// AppDefinition is a required field
	AppDefinition *AppDefinition `locationName:"appDefinition" type:"structure" required:"true"`

	// The unique identifier of the Q App.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The version of the Q App.
	//
	// AppVersion is a required field
	AppVersion *int64 `locationName:"appVersion" type:"integer" required:"true"`

	// The date and time the Q App was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user who created the Q App.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The description of the Q App.
	Description *string `locationName:"description" type:"string"`

	// The initial prompt displayed when the Q App is started.
	InitialPrompt *string `locationName:"initialPrompt" type:"string"`

	// The capabilities required to run the Q App, such as file upload or third-party
	// integrations.
	RequiredCapabilities []*string `locationName:"requiredCapabilities" type:"list" enum:"AppRequiredCapability"`

	// The status of the Q App.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AppStatus"`

	// The title of the Q App.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`

	// The date and time the Q App was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user who last updated the Q App.
	//
	// UpdatedBy is a required field
	UpdatedBy *string `locationName:"updatedBy" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQAppOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *GetQAppOutput) SetAppArn(v string) *GetQAppOutput {
	s.AppArn = &v
	return s
}

// SetAppDefinition sets the AppDefinition field's value.
func (s *GetQAppOutput) SetAppDefinition(v *AppDefinition) *GetQAppOutput {
	s.AppDefinition = v
	return s
}

// SetAppId sets the AppId field's value.
func (s *GetQAppOutput) SetAppId(v string) *GetQAppOutput {
	s.AppId = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *GetQAppOutput) SetAppVersion(v int64) *GetQAppOutput {
	s.AppVersion = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetQAppOutput) SetCreatedAt(v time.Time) *GetQAppOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetQAppOutput) SetCreatedBy(v string) *GetQAppOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetQAppOutput) SetDescription(v string) *GetQAppOutput {
	s.Description = &v
	return s
}

// SetInitialPrompt sets the InitialPrompt field's value.
func (s *GetQAppOutput) SetInitialPrompt(v string) *GetQAppOutput {
	s.InitialPrompt = &v
	return s
}

// SetRequiredCapabilities sets the RequiredCapabilities field's value.
func (s *GetQAppOutput) SetRequiredCapabilities(v []*string) *GetQAppOutput {
	s.RequiredCapabilities = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetQAppOutput) SetStatus(v string) *GetQAppOutput {
	s.Status = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *GetQAppOutput) SetTitle(v string) *GetQAppOutput {
	s.Title = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetQAppOutput) SetUpdatedAt(v time.Time) *GetQAppOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetQAppOutput) SetUpdatedBy(v string) *GetQAppOutput {
	s.UpdatedBy = &v
	return s
}

type GetQAppSessionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// The unique identifier of the Q App session to retrieve.
	//
	// SessionId is a required field
	SessionId *string `location:"querystring" locationName:"sessionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQAppSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQAppSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQAppSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQAppSessionInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetQAppSessionInput) SetInstanceId(v string) *GetQAppSessionInput {
	s.InstanceId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *GetQAppSessionInput) SetSessionId(v string) *GetQAppSessionInput {
	s.SessionId = &v
	return s
}

type GetQAppSessionOutput struct {
	_ struct{} `type:"structure"`

	// The current status for each card in the Q App session.
	//
	// CardStatus is a required field
	CardStatus map[string]*CardStatus `locationName:"cardStatus" type:"map" required:"true"`

	// The Amazon Resource Name (ARN) of the Q App session.
	//
	// SessionArn is a required field
	SessionArn *string `locationName:"sessionArn" type:"string" required:"true"`

	// The unique identifier of the Q App session.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" type:"string" required:"true"`

	// The current status of the Q App session.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ExecutionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQAppSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQAppSessionOutput) GoString() string {
	return s.String()
}

// SetCardStatus sets the CardStatus field's value.
func (s *GetQAppSessionOutput) SetCardStatus(v map[string]*CardStatus) *GetQAppSessionOutput {
	s.CardStatus = v
	return s
}

// SetSessionArn sets the SessionArn field's value.
func (s *GetQAppSessionOutput) SetSessionArn(v string) *GetQAppSessionOutput {
	s.SessionArn = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *GetQAppSessionOutput) SetSessionId(v string) *GetQAppSessionOutput {
	s.SessionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetQAppSessionOutput) SetStatus(v string) *GetQAppSessionOutput {
	s.Status = &v
	return s
}

type ImportDocumentInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Q App the file is associated with.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The unique identifier of the card the file is associated with, if applicable.
	//
	// CardId is a required field
	CardId *string `locationName:"cardId" type:"string" required:"true"`

	// The base64-encoded contents of the file to upload.
	//
	// FileContentsBase64 is a required field
	FileContentsBase64 *string `locationName:"fileContentsBase64" type:"string" required:"true"`

	// The name of the file being uploaded.
	//
	// FileName is a required field
	FileName *string `locationName:"fileName" type:"string" required:"true"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// Whether the file is associated with an Q App definition or a specific Q App
	// session.
	//
	// Scope is a required field
	Scope *string `locationName:"scope" type:"string" required:"true" enum:"DocumentScope"`

	// The unique identifier of the Q App session the file is associated with, if
	// applicable.
	SessionId *string `locationName:"sessionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportDocumentInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.CardId == nil {
		invalidParams.Add(request.NewErrParamRequired("CardId"))
	}
	if s.FileContentsBase64 == nil {
		invalidParams.Add(request.NewErrParamRequired("FileContentsBase64"))
	}
	if s.FileName == nil {
		invalidParams.Add(request.NewErrParamRequired("FileName"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *ImportDocumentInput) SetAppId(v string) *ImportDocumentInput {
	s.AppId = &v
	return s
}

// SetCardId sets the CardId field's value.
func (s *ImportDocumentInput) SetCardId(v string) *ImportDocumentInput {
	s.CardId = &v
	return s
}

// SetFileContentsBase64 sets the FileContentsBase64 field's value.
func (s *ImportDocumentInput) SetFileContentsBase64(v string) *ImportDocumentInput {
	s.FileContentsBase64 = &v
	return s
}

// SetFileName sets the FileName field's value.
func (s *ImportDocumentInput) SetFileName(v string) *ImportDocumentInput {
	s.FileName = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ImportDocumentInput) SetInstanceId(v string) *ImportDocumentInput {
	s.InstanceId = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ImportDocumentInput) SetScope(v string) *ImportDocumentInput {
	s.Scope = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *ImportDocumentInput) SetSessionId(v string) *ImportDocumentInput {
	s.SessionId = &v
	return s
}

type ImportDocumentOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier assigned to the uploaded file.
	FileId *string `locationName:"fileId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDocumentOutput) GoString() string {
	return s.String()
}

// SetFileId sets the FileId field's value.
func (s *ImportDocumentOutput) SetFileId(v string) *ImportDocumentOutput {
	s.FileId = &v
	return s
}

// An internal service error occurred while processing the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The number of seconds to wait before retrying the operation
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A library item is a snapshot of an Amazon Q App that can be published so
// the users in their Amazon Q Apps library can discover it, clone it, and run
// it.
type LibraryItemMember struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Q App associated with the library item.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The version of the Q App associated with the library item.
	//
	// AppVersion is a required field
	AppVersion *int64 `locationName:"appVersion" type:"integer" required:"true"`

	// The categories associated with the library item.
	//
	// Categories is a required field
	Categories []*Category `locationName:"categories" type:"list" required:"true"`

	// The date and time the library item was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user who created the library item.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// Whether the current user has rated the library item.
	IsRatedByUser *bool `locationName:"isRatedByUser" type:"boolean"`

	// The unique identifier of the library item.
	//
	// LibraryItemId is a required field
	LibraryItemId *string `locationName:"libraryItemId" type:"string" required:"true"`

	// The number of ratings the library item has received.
	//
	// RatingCount is a required field
	RatingCount *int64 `locationName:"ratingCount" type:"integer" required:"true"`

	// The status of the library item.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`

	// The date and time the library item was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user who last updated the library item.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`

	// The number of users who have the associated Q App.
	UserCount *int64 `locationName:"userCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LibraryItemMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LibraryItemMember) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *LibraryItemMember) SetAppId(v string) *LibraryItemMember {
	s.AppId = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *LibraryItemMember) SetAppVersion(v int64) *LibraryItemMember {
	s.AppVersion = &v
	return s
}

// SetCategories sets the Categories field's value.
func (s *LibraryItemMember) SetCategories(v []*Category) *LibraryItemMember {
	s.Categories = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *LibraryItemMember) SetCreatedAt(v time.Time) *LibraryItemMember {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *LibraryItemMember) SetCreatedBy(v string) *LibraryItemMember {
	s.CreatedBy = &v
	return s
}

// SetIsRatedByUser sets the IsRatedByUser field's value.
func (s *LibraryItemMember) SetIsRatedByUser(v bool) *LibraryItemMember {
	s.IsRatedByUser = &v
	return s
}

// SetLibraryItemId sets the LibraryItemId field's value.
func (s *LibraryItemMember) SetLibraryItemId(v string) *LibraryItemMember {
	s.LibraryItemId = &v
	return s
}

// SetRatingCount sets the RatingCount field's value.
func (s *LibraryItemMember) SetRatingCount(v int64) *LibraryItemMember {
	s.RatingCount = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LibraryItemMember) SetStatus(v string) *LibraryItemMember {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *LibraryItemMember) SetUpdatedAt(v time.Time) *LibraryItemMember {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *LibraryItemMember) SetUpdatedBy(v string) *LibraryItemMember {
	s.UpdatedBy = &v
	return s
}

// SetUserCount sets the UserCount field's value.
func (s *LibraryItemMember) SetUserCount(v int64) *LibraryItemMember {
	s.UserCount = &v
	return s
}

type ListLibraryItemsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Optional category to filter the library items by.
	CategoryId *string `location:"querystring" locationName:"categoryId" type:"string"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// The maximum number of library items to return in the response.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLibraryItemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLibraryItemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLibraryItemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLibraryItemsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoryId sets the CategoryId field's value.
func (s *ListLibraryItemsInput) SetCategoryId(v string) *ListLibraryItemsInput {
	s.CategoryId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListLibraryItemsInput) SetInstanceId(v string) *ListLibraryItemsInput {
	s.InstanceId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListLibraryItemsInput) SetLimit(v int64) *ListLibraryItemsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLibraryItemsInput) SetNextToken(v string) *ListLibraryItemsInput {
	s.NextToken = &v
	return s
}

type ListLibraryItemsOutput struct {
	_ struct{} `type:"structure"`

	// The list of library items meeting the request criteria.
	LibraryItems []*LibraryItemMember `locationName:"libraryItems" type:"list"`

	// The token to use to request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLibraryItemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLibraryItemsOutput) GoString() string {
	return s.String()
}

// SetLibraryItems sets the LibraryItems field's value.
func (s *ListLibraryItemsOutput) SetLibraryItems(v []*LibraryItemMember) *ListLibraryItemsOutput {
	s.LibraryItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLibraryItemsOutput) SetNextToken(v string) *ListLibraryItemsOutput {
	s.NextToken = &v
	return s
}

type ListQAppsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// The maximum number of Q Apps to return in the response.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQAppsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQAppsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListQAppsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListQAppsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListQAppsInput) SetInstanceId(v string) *ListQAppsInput {
	s.InstanceId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListQAppsInput) SetLimit(v int64) *ListQAppsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQAppsInput) SetNextToken(v string) *ListQAppsInput {
	s.NextToken = &v
	return s
}

type ListQAppsOutput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon Q Apps meeting the request criteria.
	//
	// Apps is a required field
	Apps []*UserAppItem `locationName:"apps" type:"list" required:"true"`

	// The token to use to request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQAppsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQAppsOutput) GoString() string {
	return s.String()
}

// SetApps sets the Apps field's value.
func (s *ListQAppsOutput) SetApps(v []*UserAppItem) *ListQAppsOutput {
	s.Apps = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQAppsOutput) SetNextToken(v string) *ListQAppsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource whose tags should be listed.
	//
	// ResourceARN is a required field
	ResourceARN *string `location:"uri" locationName:"resourceARN" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags that are assigned to the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The definition of an Amazon Q App generated based on input such as a conversation
// or problem statement.
type PredictAppDefinition struct {
	_ struct{} `type:"structure"`

	// The definition specifying the cards and flow of the generated Q App.
	//
	// AppDefinition is a required field
	AppDefinition *AppDefinitionInput_ `locationName:"appDefinition" type:"structure" required:"true"`

	// The description of the generated Q App definition.
	Description *string `locationName:"description" type:"string"`

	// The title of the generated Q App definition.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictAppDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictAppDefinition) GoString() string {
	return s.String()
}

// SetAppDefinition sets the AppDefinition field's value.
func (s *PredictAppDefinition) SetAppDefinition(v *AppDefinitionInput_) *PredictAppDefinition {
	s.AppDefinition = v
	return s
}

// SetDescription sets the Description field's value.
func (s *PredictAppDefinition) SetDescription(v string) *PredictAppDefinition {
	s.Description = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *PredictAppDefinition) SetTitle(v string) *PredictAppDefinition {
	s.Title = &v
	return s
}

type PredictQAppInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// The input to generate the Q App definition from, either a conversation or
	// problem statement.
	Options *PredictQAppInputOptions `locationName:"options" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictQAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictQAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredictQAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredictQAppInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Options != nil {
		if err := s.Options.Validate(); err != nil {
			invalidParams.AddNested("Options", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *PredictQAppInput) SetInstanceId(v string) *PredictQAppInput {
	s.InstanceId = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *PredictQAppInput) SetOptions(v *PredictQAppInputOptions) *PredictQAppInput {
	s.Options = v
	return s
}

// The input options for generating an Q App definition.
type PredictQAppInputOptions struct {
	_ struct{} `type:"structure"`

	// A conversation to use as input for generating the Q App definition.
	Conversation []*ConversationMessage `locationName:"conversation" min:"1" type:"list"`

	// A problem statement to use as input for generating the Q App definition.
	ProblemStatement *string `locationName:"problemStatement" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictQAppInputOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictQAppInputOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredictQAppInputOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredictQAppInputOptions"}
	if s.Conversation != nil && len(s.Conversation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Conversation", 1))
	}
	if s.Conversation != nil {
		for i, v := range s.Conversation {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Conversation", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConversation sets the Conversation field's value.
func (s *PredictQAppInputOptions) SetConversation(v []*ConversationMessage) *PredictQAppInputOptions {
	s.Conversation = v
	return s
}

// SetProblemStatement sets the ProblemStatement field's value.
func (s *PredictQAppInputOptions) SetProblemStatement(v string) *PredictQAppInputOptions {
	s.ProblemStatement = &v
	return s
}

type PredictQAppOutput struct {
	_ struct{} `type:"structure"`

	// The generated Q App definition.
	//
	// App is a required field
	App *PredictAppDefinition `locationName:"app" type:"structure" required:"true"`

	// The problem statement extracted from the input conversation, if provided.
	//
	// ProblemStatement is a required field
	ProblemStatement *string `locationName:"problemStatement" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictQAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PredictQAppOutput) GoString() string {
	return s.String()
}

// SetApp sets the App field's value.
func (s *PredictQAppOutput) SetApp(v *PredictAppDefinition) *PredictQAppOutput {
	s.App = v
	return s
}

// SetProblemStatement sets the ProblemStatement field's value.
func (s *PredictQAppOutput) SetProblemStatement(v string) *PredictQAppOutput {
	s.ProblemStatement = &v
	return s
}

// A card in an Q App that integrates with a third-party plugin or service.
type QPluginCard struct {
	_ struct{} `type:"structure"`

	// Any dependencies or requirements for the plugin card.
	//
	// Dependencies is a required field
	Dependencies []*string `locationName:"dependencies" type:"list" required:"true"`

	// The unique identifier of the plugin card.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The unique identifier of the plugin used by the card.
	//
	// PluginId is a required field
	PluginId *string `locationName:"pluginId" type:"string" required:"true"`

	// The type or category of the plugin used by the card.
	//
	// PluginType is a required field
	PluginType *string `locationName:"pluginType" type:"string" required:"true" enum:"PluginType"`

	// The prompt or instructions displayed for the plugin card.
	//
	// Prompt is a required field
	Prompt *string `locationName:"prompt" type:"string" required:"true"`

	// The title or label of the plugin card.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`

	// The type of the card.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CardType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QPluginCard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QPluginCard) GoString() string {
	return s.String()
}

// SetDependencies sets the Dependencies field's value.
func (s *QPluginCard) SetDependencies(v []*string) *QPluginCard {
	s.Dependencies = v
	return s
}

// SetId sets the Id field's value.
func (s *QPluginCard) SetId(v string) *QPluginCard {
	s.Id = &v
	return s
}

// SetPluginId sets the PluginId field's value.
func (s *QPluginCard) SetPluginId(v string) *QPluginCard {
	s.PluginId = &v
	return s
}

// SetPluginType sets the PluginType field's value.
func (s *QPluginCard) SetPluginType(v string) *QPluginCard {
	s.PluginType = &v
	return s
}

// SetPrompt sets the Prompt field's value.
func (s *QPluginCard) SetPrompt(v string) *QPluginCard {
	s.Prompt = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *QPluginCard) SetTitle(v string) *QPluginCard {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *QPluginCard) SetType(v string) *QPluginCard {
	s.Type = &v
	return s
}

// The input shape for defining a plugin card in an Amazon Q App.
type QPluginCardInput_ struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the plugin card.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The unique identifier of the plugin used by the card.
	//
	// PluginId is a required field
	PluginId *string `locationName:"pluginId" min:"36" type:"string" required:"true"`

	// The prompt or instructions displayed for the plugin card.
	//
	// Prompt is a required field
	Prompt *string `locationName:"prompt" type:"string" required:"true"`

	// The title or label of the plugin card.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`

	// The type of the card.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CardType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QPluginCardInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QPluginCardInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QPluginCardInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QPluginCardInput_"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.PluginId == nil {
		invalidParams.Add(request.NewErrParamRequired("PluginId"))
	}
	if s.PluginId != nil && len(*s.PluginId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("PluginId", 36))
	}
	if s.Prompt == nil {
		invalidParams.Add(request.NewErrParamRequired("Prompt"))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *QPluginCardInput_) SetId(v string) *QPluginCardInput_ {
	s.Id = &v
	return s
}

// SetPluginId sets the PluginId field's value.
func (s *QPluginCardInput_) SetPluginId(v string) *QPluginCardInput_ {
	s.PluginId = &v
	return s
}

// SetPrompt sets the Prompt field's value.
func (s *QPluginCardInput_) SetPrompt(v string) *QPluginCardInput_ {
	s.Prompt = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *QPluginCardInput_) SetTitle(v string) *QPluginCardInput_ {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *QPluginCardInput_) SetType(v string) *QPluginCardInput_ {
	s.Type = &v
	return s
}

// A card in a Amazon Q App that generates a response based on the Amazon Q
// Business service.
type QQueryCard struct {
	_ struct{} `type:"structure"`

	// The Amazon Q Business filters applied in this query card when resolving data
	// sources
	AttributeFilter *AttributeFilter `locationName:"attributeFilter" type:"structure"`

	// Any dependencies or requirements for the query card.
	//
	// Dependencies is a required field
	Dependencies []*string `locationName:"dependencies" type:"list" required:"true"`

	// The unique identifier of the query card.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The source or type of output generated by the query card.
	//
	// OutputSource is a required field
	OutputSource *string `locationName:"outputSource" type:"string" required:"true" enum:"CardOutputSource"`

	// The prompt or instructions displayed for the query card.
	//
	// Prompt is a required field
	Prompt *string `locationName:"prompt" type:"string" required:"true"`

	// The title or label of the query card.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`

	// The type of the card.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CardType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QQueryCard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QQueryCard) GoString() string {
	return s.String()
}

// SetAttributeFilter sets the AttributeFilter field's value.
func (s *QQueryCard) SetAttributeFilter(v *AttributeFilter) *QQueryCard {
	s.AttributeFilter = v
	return s
}

// SetDependencies sets the Dependencies field's value.
func (s *QQueryCard) SetDependencies(v []*string) *QQueryCard {
	s.Dependencies = v
	return s
}

// SetId sets the Id field's value.
func (s *QQueryCard) SetId(v string) *QQueryCard {
	s.Id = &v
	return s
}

// SetOutputSource sets the OutputSource field's value.
func (s *QQueryCard) SetOutputSource(v string) *QQueryCard {
	s.OutputSource = &v
	return s
}

// SetPrompt sets the Prompt field's value.
func (s *QQueryCard) SetPrompt(v string) *QQueryCard {
	s.Prompt = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *QQueryCard) SetTitle(v string) *QQueryCard {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *QQueryCard) SetType(v string) *QQueryCard {
	s.Type = &v
	return s
}

// The input shape for defining a query card in an Amazon Q App.
type QQueryCardInput_ struct {
	_ struct{} `type:"structure"`

	// Turns on filtering of responses based on document attributes or metadata
	// fields.
	AttributeFilter *AttributeFilter `locationName:"attributeFilter" type:"structure"`

	// The unique identifier of the query card.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The source or type of output to generate for the query card.
	OutputSource *string `locationName:"outputSource" type:"string" enum:"CardOutputSource"`

	// The prompt or instructions displayed for the query card.
	//
	// Prompt is a required field
	Prompt *string `locationName:"prompt" type:"string" required:"true"`

	// The title or label of the query card.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`

	// The type of the card.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CardType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QQueryCardInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QQueryCardInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QQueryCardInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QQueryCardInput_"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Prompt == nil {
		invalidParams.Add(request.NewErrParamRequired("Prompt"))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.AttributeFilter != nil {
		if err := s.AttributeFilter.Validate(); err != nil {
			invalidParams.AddNested("AttributeFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeFilter sets the AttributeFilter field's value.
func (s *QQueryCardInput_) SetAttributeFilter(v *AttributeFilter) *QQueryCardInput_ {
	s.AttributeFilter = v
	return s
}

// SetId sets the Id field's value.
func (s *QQueryCardInput_) SetId(v string) *QQueryCardInput_ {
	s.Id = &v
	return s
}

// SetOutputSource sets the OutputSource field's value.
func (s *QQueryCardInput_) SetOutputSource(v string) *QQueryCardInput_ {
	s.OutputSource = &v
	return s
}

// SetPrompt sets the Prompt field's value.
func (s *QQueryCardInput_) SetPrompt(v string) *QQueryCardInput_ {
	s.Prompt = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *QQueryCardInput_) SetTitle(v string) *QQueryCardInput_ {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *QQueryCardInput_) SetType(v string) *QQueryCardInput_ {
	s.Type = &v
	return s
}

// The requested resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The unique identifier of the resource
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested operation could not be completed because it would exceed the
// service's quota or limit.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The code of the quota that was exceeded
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// The unique identifier of the resource
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// The code for the service where the quota was exceeded
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartQAppSessionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Q App to start a session for.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The version of the Q App to use for the session.
	//
	// AppVersion is a required field
	AppVersion *int64 `locationName:"appVersion" type:"integer" required:"true"`

	// Optional initial input values to provide for the Q App session.
	InitialValues []*CardValue `locationName:"initialValues" type:"list"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// Optional tags to associate with the new Q App session.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartQAppSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartQAppSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartQAppSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartQAppSessionInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AppVersion"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InitialValues != nil {
		for i, v := range s.InitialValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InitialValues", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *StartQAppSessionInput) SetAppId(v string) *StartQAppSessionInput {
	s.AppId = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *StartQAppSessionInput) SetAppVersion(v int64) *StartQAppSessionInput {
	s.AppVersion = &v
	return s
}

// SetInitialValues sets the InitialValues field's value.
func (s *StartQAppSessionInput) SetInitialValues(v []*CardValue) *StartQAppSessionInput {
	s.InitialValues = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *StartQAppSessionInput) SetInstanceId(v string) *StartQAppSessionInput {
	s.InstanceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartQAppSessionInput) SetTags(v map[string]*string) *StartQAppSessionInput {
	s.Tags = v
	return s
}

type StartQAppSessionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new Q App session.
	//
	// SessionArn is a required field
	SessionArn *string `locationName:"sessionArn" type:"string" required:"true"`

	// The unique identifier of the new Q App session.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartQAppSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartQAppSessionOutput) GoString() string {
	return s.String()
}

// SetSessionArn sets the SessionArn field's value.
func (s *StartQAppSessionOutput) SetSessionArn(v string) *StartQAppSessionOutput {
	s.SessionArn = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StartQAppSessionOutput) SetSessionId(v string) *StartQAppSessionOutput {
	s.SessionId = &v
	return s
}

type StopQAppSessionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// The unique identifier of the Q App session to stop.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopQAppSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopQAppSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopQAppSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopQAppSessionInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *StopQAppSessionInput) SetInstanceId(v string) *StopQAppSessionInput {
	s.InstanceId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *StopQAppSessionInput) SetSessionId(v string) *StopQAppSessionInput {
	s.SessionId = &v
	return s
}

type StopQAppSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopQAppSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopQAppSessionOutput) GoString() string {
	return s.String()
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to tag.
	//
	// ResourceARN is a required field
	ResourceARN *string `location:"uri" locationName:"resourceARN" min:"1" type:"string" required:"true"`

	// The tags to associate with the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A card in an Amazon Q App that allows the user to input text.
type TextInputCard struct {
	_ struct{} `type:"structure"`

	// The default value to pre-populate in the text input field.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// Any dependencies or requirements for the text input card.
	//
	// Dependencies is a required field
	Dependencies []*string `locationName:"dependencies" type:"list" required:"true"`

	// The unique identifier of the text input card.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The placeholder text to display in the text input field.
	Placeholder *string `locationName:"placeholder" type:"string"`

	// The title or label of the text input card.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`

	// The type of the card.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CardType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextInputCard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextInputCard) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *TextInputCard) SetDefaultValue(v string) *TextInputCard {
	s.DefaultValue = &v
	return s
}

// SetDependencies sets the Dependencies field's value.
func (s *TextInputCard) SetDependencies(v []*string) *TextInputCard {
	s.Dependencies = v
	return s
}

// SetId sets the Id field's value.
func (s *TextInputCard) SetId(v string) *TextInputCard {
	s.Id = &v
	return s
}

// SetPlaceholder sets the Placeholder field's value.
func (s *TextInputCard) SetPlaceholder(v string) *TextInputCard {
	s.Placeholder = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *TextInputCard) SetTitle(v string) *TextInputCard {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *TextInputCard) SetType(v string) *TextInputCard {
	s.Type = &v
	return s
}

// The input shape for defining a text input card in an Amazon Q App.
type TextInputCardInput_ struct {
	_ struct{} `type:"structure"`

	// The default value to pre-populate in the text input field.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The unique identifier of the text input card.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The placeholder text to display in the text input field.
	Placeholder *string `locationName:"placeholder" type:"string"`

	// The title or label of the text input card.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`

	// The type of the card.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CardType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextInputCardInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextInputCardInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TextInputCardInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TextInputCardInput_"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *TextInputCardInput_) SetDefaultValue(v string) *TextInputCardInput_ {
	s.DefaultValue = &v
	return s
}

// SetId sets the Id field's value.
func (s *TextInputCardInput_) SetId(v string) *TextInputCardInput_ {
	s.Id = &v
	return s
}

// SetPlaceholder sets the Placeholder field's value.
func (s *TextInputCardInput_) SetPlaceholder(v string) *TextInputCardInput_ {
	s.Placeholder = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *TextInputCardInput_) SetTitle(v string) *TextInputCardInput_ {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *TextInputCardInput_) SetType(v string) *TextInputCardInput_ {
	s.Type = &v
	return s
}

// The requested operation could not be completed because too many requests
// were sent at once. Wait a bit and try again later.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The code of the quota that was exceeded
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// The number of seconds to wait before retrying the operation
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The code for the service where the quota was exceeded
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The client is not authenticated or authorized to perform the requested operation.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource to disassociate the tag from.
	//
	// ResourceARN is a required field
	ResourceARN *string `location:"uri" locationName:"resourceARN" min:"1" type:"string" required:"true"`

	// The keys of the tags to disassociate from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateLibraryItemInput struct {
	_ struct{} `type:"structure"`

	// The new categories to associate with the library item.
	Categories []*string `locationName:"categories" type:"list"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// The unique identifier of the library item to update.
	//
	// LibraryItemId is a required field
	LibraryItemId *string `locationName:"libraryItemId" type:"string" required:"true"`

	// The new status to set for the library item, such as "Published" or "Hidden".
	Status *string `locationName:"status" type:"string" enum:"LibraryItemStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLibraryItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLibraryItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLibraryItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLibraryItemInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.LibraryItemId == nil {
		invalidParams.Add(request.NewErrParamRequired("LibraryItemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategories sets the Categories field's value.
func (s *UpdateLibraryItemInput) SetCategories(v []*string) *UpdateLibraryItemInput {
	s.Categories = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateLibraryItemInput) SetInstanceId(v string) *UpdateLibraryItemInput {
	s.InstanceId = &v
	return s
}

// SetLibraryItemId sets the LibraryItemId field's value.
func (s *UpdateLibraryItemInput) SetLibraryItemId(v string) *UpdateLibraryItemInput {
	s.LibraryItemId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateLibraryItemInput) SetStatus(v string) *UpdateLibraryItemInput {
	s.Status = &v
	return s
}

type UpdateLibraryItemOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Q App associated with the library item.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The version of the Q App associated with the library item.
	//
	// AppVersion is a required field
	AppVersion *int64 `locationName:"appVersion" type:"integer" required:"true"`

	// The categories associated with the updated library item.
	//
	// Categories is a required field
	Categories []*Category `locationName:"categories" type:"list" required:"true"`

	// The date and time the library item was originally created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user who originally created the library item.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// Whether the current user has rated the library item.
	IsRatedByUser *bool `locationName:"isRatedByUser" type:"boolean"`

	// The unique identifier of the updated library item.
	//
	// LibraryItemId is a required field
	LibraryItemId *string `locationName:"libraryItemId" type:"string" required:"true"`

	// The number of ratings the library item has received.
	//
	// RatingCount is a required field
	RatingCount *int64 `locationName:"ratingCount" type:"integer" required:"true"`

	// The new status of the updated library item.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`

	// The date and time the library item was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user who last updated the library item.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`

	// The number of users who have the associated Q App.
	UserCount *int64 `locationName:"userCount" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLibraryItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLibraryItemOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *UpdateLibraryItemOutput) SetAppId(v string) *UpdateLibraryItemOutput {
	s.AppId = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *UpdateLibraryItemOutput) SetAppVersion(v int64) *UpdateLibraryItemOutput {
	s.AppVersion = &v
	return s
}

// SetCategories sets the Categories field's value.
func (s *UpdateLibraryItemOutput) SetCategories(v []*Category) *UpdateLibraryItemOutput {
	s.Categories = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateLibraryItemOutput) SetCreatedAt(v time.Time) *UpdateLibraryItemOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *UpdateLibraryItemOutput) SetCreatedBy(v string) *UpdateLibraryItemOutput {
	s.CreatedBy = &v
	return s
}

// SetIsRatedByUser sets the IsRatedByUser field's value.
func (s *UpdateLibraryItemOutput) SetIsRatedByUser(v bool) *UpdateLibraryItemOutput {
	s.IsRatedByUser = &v
	return s
}

// SetLibraryItemId sets the LibraryItemId field's value.
func (s *UpdateLibraryItemOutput) SetLibraryItemId(v string) *UpdateLibraryItemOutput {
	s.LibraryItemId = &v
	return s
}

// SetRatingCount sets the RatingCount field's value.
func (s *UpdateLibraryItemOutput) SetRatingCount(v int64) *UpdateLibraryItemOutput {
	s.RatingCount = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateLibraryItemOutput) SetStatus(v string) *UpdateLibraryItemOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateLibraryItemOutput) SetUpdatedAt(v time.Time) *UpdateLibraryItemOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *UpdateLibraryItemOutput) SetUpdatedBy(v string) *UpdateLibraryItemOutput {
	s.UpdatedBy = &v
	return s
}

// SetUserCount sets the UserCount field's value.
func (s *UpdateLibraryItemOutput) SetUserCount(v int64) *UpdateLibraryItemOutput {
	s.UserCount = &v
	return s
}

type UpdateQAppInput struct {
	_ struct{} `type:"structure"`

	// The new definition specifying the cards and flow for the Q App.
	AppDefinition *AppDefinitionInput_ `locationName:"appDefinition" type:"structure"`

	// The unique identifier of the Q App to update.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The new description for the Q App.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// The new title for the Q App.
	Title *string `locationName:"title" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateQAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateQAppInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.AppDefinition != nil {
		if err := s.AppDefinition.Validate(); err != nil {
			invalidParams.AddNested("AppDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppDefinition sets the AppDefinition field's value.
func (s *UpdateQAppInput) SetAppDefinition(v *AppDefinitionInput_) *UpdateQAppInput {
	s.AppDefinition = v
	return s
}

// SetAppId sets the AppId field's value.
func (s *UpdateQAppInput) SetAppId(v string) *UpdateQAppInput {
	s.AppId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateQAppInput) SetDescription(v string) *UpdateQAppInput {
	s.Description = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateQAppInput) SetInstanceId(v string) *UpdateQAppInput {
	s.InstanceId = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *UpdateQAppInput) SetTitle(v string) *UpdateQAppInput {
	s.Title = &v
	return s
}

type UpdateQAppOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated Q App.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The unique identifier of the updated Q App.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The new version of the updated Q App.
	//
	// AppVersion is a required field
	AppVersion *int64 `locationName:"appVersion" type:"integer" required:"true"`

	// The date and time the Q App was originally created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user who originally created the Q App.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The new description of the updated Q App.
	Description *string `locationName:"description" type:"string"`

	// The initial prompt for the updated Q App.
	InitialPrompt *string `locationName:"initialPrompt" type:"string"`

	// The capabilities required for the updated Q App.
	RequiredCapabilities []*string `locationName:"requiredCapabilities" type:"list" enum:"AppRequiredCapability"`

	// The status of the updated Q App.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AppStatus"`

	// The new title of the updated Q App.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`

	// The date and time the Q App was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user who last updated the Q App.
	//
	// UpdatedBy is a required field
	UpdatedBy *string `locationName:"updatedBy" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQAppOutput) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *UpdateQAppOutput) SetAppArn(v string) *UpdateQAppOutput {
	s.AppArn = &v
	return s
}

// SetAppId sets the AppId field's value.
func (s *UpdateQAppOutput) SetAppId(v string) *UpdateQAppOutput {
	s.AppId = &v
	return s
}

// SetAppVersion sets the AppVersion field's value.
func (s *UpdateQAppOutput) SetAppVersion(v int64) *UpdateQAppOutput {
	s.AppVersion = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateQAppOutput) SetCreatedAt(v time.Time) *UpdateQAppOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *UpdateQAppOutput) SetCreatedBy(v string) *UpdateQAppOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateQAppOutput) SetDescription(v string) *UpdateQAppOutput {
	s.Description = &v
	return s
}

// SetInitialPrompt sets the InitialPrompt field's value.
func (s *UpdateQAppOutput) SetInitialPrompt(v string) *UpdateQAppOutput {
	s.InitialPrompt = &v
	return s
}

// SetRequiredCapabilities sets the RequiredCapabilities field's value.
func (s *UpdateQAppOutput) SetRequiredCapabilities(v []*string) *UpdateQAppOutput {
	s.RequiredCapabilities = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateQAppOutput) SetStatus(v string) *UpdateQAppOutput {
	s.Status = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *UpdateQAppOutput) SetTitle(v string) *UpdateQAppOutput {
	s.Title = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateQAppOutput) SetUpdatedAt(v time.Time) *UpdateQAppOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *UpdateQAppOutput) SetUpdatedBy(v string) *UpdateQAppOutput {
	s.UpdatedBy = &v
	return s
}

type UpdateQAppSessionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the Amazon Q Business application environment instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"header" locationName:"instance-id" type:"string" required:"true"`

	// The unique identifier of the Q App session to provide input for.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" type:"string" required:"true"`

	// The input values to provide for the current state of the Q App session.
	Values []*CardValue `locationName:"values" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQAppSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQAppSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateQAppSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateQAppSessionInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.Values != nil {
		for i, v := range s.Values {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Values", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateQAppSessionInput) SetInstanceId(v string) *UpdateQAppSessionInput {
	s.InstanceId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *UpdateQAppSessionInput) SetSessionId(v string) *UpdateQAppSessionInput {
	s.SessionId = &v
	return s
}

// SetValues sets the Values field's value.
func (s *UpdateQAppSessionInput) SetValues(v []*CardValue) *UpdateQAppSessionInput {
	s.Values = v
	return s
}

type UpdateQAppSessionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated Q App session.
	//
	// SessionArn is a required field
	SessionArn *string `locationName:"sessionArn" type:"string" required:"true"`

	// The unique identifier of the updated Q App session.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQAppSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateQAppSessionOutput) GoString() string {
	return s.String()
}

// SetSessionArn sets the SessionArn field's value.
func (s *UpdateQAppSessionOutput) SetSessionArn(v string) *UpdateQAppSessionOutput {
	s.SessionArn = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *UpdateQAppSessionOutput) SetSessionId(v string) *UpdateQAppSessionOutput {
	s.SessionId = &v
	return s
}

// An Amazon Q App associated with a user, either owned by the user or favorited.
type UserAppItem struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Q App.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The unique identifier of the Q App.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// A flag indicating whether the user can edit the Q App.
	CanEdit *bool `locationName:"canEdit" type:"boolean"`

	// The date and time the user's association with the Q App was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the Q App.
	Description *string `locationName:"description" type:"string"`

	// The status of the user's association with the Q App.
	Status *string `locationName:"status" type:"string"`

	// The title of the Q App.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserAppItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserAppItem) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *UserAppItem) SetAppArn(v string) *UserAppItem {
	s.AppArn = &v
	return s
}

// SetAppId sets the AppId field's value.
func (s *UserAppItem) SetAppId(v string) *UserAppItem {
	s.AppId = &v
	return s
}

// SetCanEdit sets the CanEdit field's value.
func (s *UserAppItem) SetCanEdit(v bool) *UserAppItem {
	s.CanEdit = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UserAppItem) SetCreatedAt(v time.Time) *UserAppItem {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UserAppItem) SetDescription(v string) *UserAppItem {
	s.Description = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UserAppItem) SetStatus(v string) *UserAppItem {
	s.Status = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *UserAppItem) SetTitle(v string) *UserAppItem {
	s.Title = &v
	return s
}

// The input failed to satisfy the constraints specified by the service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AppRequiredCapabilityFileUpload is a AppRequiredCapability enum value
	AppRequiredCapabilityFileUpload = "FileUpload"

	// AppRequiredCapabilityCreatorMode is a AppRequiredCapability enum value
	AppRequiredCapabilityCreatorMode = "CreatorMode"

	// AppRequiredCapabilityRetrievalMode is a AppRequiredCapability enum value
	AppRequiredCapabilityRetrievalMode = "RetrievalMode"

	// AppRequiredCapabilityPluginMode is a AppRequiredCapability enum value
	AppRequiredCapabilityPluginMode = "PluginMode"
)

// AppRequiredCapability_Values returns all elements of the AppRequiredCapability enum
func AppRequiredCapability_Values() []string {
	return []string{
		AppRequiredCapabilityFileUpload,
		AppRequiredCapabilityCreatorMode,
		AppRequiredCapabilityRetrievalMode,
		AppRequiredCapabilityPluginMode,
	}
}

const (
	// AppStatusPublished is a AppStatus enum value
	AppStatusPublished = "PUBLISHED"

	// AppStatusDraft is a AppStatus enum value
	AppStatusDraft = "DRAFT"

	// AppStatusDeleted is a AppStatus enum value
	AppStatusDeleted = "DELETED"
)

// AppStatus_Values returns all elements of the AppStatus enum
func AppStatus_Values() []string {
	return []string{
		AppStatusPublished,
		AppStatusDraft,
		AppStatusDeleted,
	}
}

const (
	// CardOutputSourceApprovedSources is a CardOutputSource enum value
	CardOutputSourceApprovedSources = "approved-sources"

	// CardOutputSourceLlm is a CardOutputSource enum value
	CardOutputSourceLlm = "llm"
)

// CardOutputSource_Values returns all elements of the CardOutputSource enum
func CardOutputSource_Values() []string {
	return []string{
		CardOutputSourceApprovedSources,
		CardOutputSourceLlm,
	}
}

const (
	// CardTypeTextInput is a CardType enum value
	CardTypeTextInput = "text-input"

	// CardTypeQQuery is a CardType enum value
	CardTypeQQuery = "q-query"

	// CardTypeFileUpload is a CardType enum value
	CardTypeFileUpload = "file-upload"

	// CardTypeQPlugin is a CardType enum value
	CardTypeQPlugin = "q-plugin"
)

// CardType_Values returns all elements of the CardType enum
func CardType_Values() []string {
	return []string{
		CardTypeTextInput,
		CardTypeQQuery,
		CardTypeFileUpload,
		CardTypeQPlugin,
	}
}

const (
	// DocumentScopeApplication is a DocumentScope enum value
	DocumentScopeApplication = "APPLICATION"

	// DocumentScopeSession is a DocumentScope enum value
	DocumentScopeSession = "SESSION"
)

// DocumentScope_Values returns all elements of the DocumentScope enum
func DocumentScope_Values() []string {
	return []string{
		DocumentScopeApplication,
		DocumentScopeSession,
	}
}

const (
	// ExecutionStatusInProgress is a ExecutionStatus enum value
	ExecutionStatusInProgress = "IN_PROGRESS"

	// ExecutionStatusWaiting is a ExecutionStatus enum value
	ExecutionStatusWaiting = "WAITING"

	// ExecutionStatusCompleted is a ExecutionStatus enum value
	ExecutionStatusCompleted = "COMPLETED"
)

// ExecutionStatus_Values returns all elements of the ExecutionStatus enum
func ExecutionStatus_Values() []string {
	return []string{
		ExecutionStatusInProgress,
		ExecutionStatusWaiting,
		ExecutionStatusCompleted,
	}
}

const (
	// LibraryItemStatusPublished is a LibraryItemStatus enum value
	LibraryItemStatusPublished = "PUBLISHED"

	// LibraryItemStatusDisabled is a LibraryItemStatus enum value
	LibraryItemStatusDisabled = "DISABLED"
)

// LibraryItemStatus_Values returns all elements of the LibraryItemStatus enum
func LibraryItemStatus_Values() []string {
	return []string{
		LibraryItemStatusPublished,
		LibraryItemStatusDisabled,
	}
}

const (
	// PluginTypeServiceNow is a PluginType enum value
	PluginTypeServiceNow = "SERVICE_NOW"

	// PluginTypeSalesforce is a PluginType enum value
	PluginTypeSalesforce = "SALESFORCE"

	// PluginTypeJira is a PluginType enum value
	PluginTypeJira = "JIRA"

	// PluginTypeZendesk is a PluginType enum value
	PluginTypeZendesk = "ZENDESK"

	// PluginTypeCustom is a PluginType enum value
	PluginTypeCustom = "CUSTOM"
)

// PluginType_Values returns all elements of the PluginType enum
func PluginType_Values() []string {
	return []string{
		PluginTypeServiceNow,
		PluginTypeSalesforce,
		PluginTypeJira,
		PluginTypeZendesk,
		PluginTypeCustom,
	}
}

const (
	// SenderUser is a Sender enum value
	SenderUser = "USER"

	// SenderSystem is a Sender enum value
	SenderSystem = "SYSTEM"
)

// Sender_Values returns all elements of the Sender enum
func Sender_Values() []string {
	return []string{
		SenderUser,
		SenderSystem,
	}
}
