#
# Copyright 1998 - 2021 Double Precision, Inc.  See COPYING for
# distribution information.
#

# --- Build behavior defines --------------------------------------------------

%{?_without_fax:    %define with_fax 0}
%{!?_without_fax:   %define with_fax 1}

%define alternatives %(test -x /usr/sbin/alternatives && echo 1 || echo 0)

%define is_rhel %(grep -q 'ID_LIKE=.*rhel\\b' /etc/os-release && echo 1 || echo 0)
%define is_rhel7 %(grep -q 'ID_LIKE=.*rhel\\b' /etc/os-release && grep -q -F 'VERSION_ID="7"' /etc/os-release && echo 1 || echo 0)

%define using_systemd %(test -d /lib/systemd && echo 1 || echo 0)

%if 0%{!?dist:1}
%define courier_release %(release="`rpm -q --queryformat='.%{VERSION}' redhat-release 2>/dev/null`" ; if test $? != 0 ; then release="`rpm -q --queryformat='.%{VERSION}' fedora-release 2>/dev/null`" ; if test $? != 0 ; then release="" ; fi ; fi ; echo "$release")
%else
%define courier_release %{nil}
%endif

%define configure CFLAGS="${CFLAGS:-%optflags}" ; export CFLAGS ; CXXFLAGS="${CXXFLAGS:-%optflags}" ; export CXXFLAGS ; FFLAGS="${FFLAGS:-%optflags}" ; export FFLAGS ;  ./configure %{?gpg_option} --host=%{_host} --build=%{_build} --target=%{_target_platform} --program-prefix=%{?_program_prefix} --prefix=%{_prefix} --exec-prefix=%{_exec_prefix} --bindir=%{_bindir} --sbindir=%{_sbindir} --sysconfdir=%{_sysconfdir} --datadir=%{_datadir} --includedir=%{_includedir} --libdir=%{_libdir} --libexecdir=%{_libexecdir} --localstatedir=%{_localstatedir} --sharedstatedir=%{_sharedstatedir} --mandir=%{_mandir} --infodir=%{_infodir}


#
#  RH custom locations.
#
#                <7.X               7.x
#  manpages      /usr/man           /usr/share/man
#  httpd         /home/httpd        /var/www
#  initscripts   /etc/rc.d/init.d   /etc/init.d

%{expand:%%define manpagedir %(if test -d %{_prefix}/share/man ; then echo %{_prefix}/share/man ; else echo %{_prefix}/man ; fi)}

%{expand:%%define apacheinstdir %(if test -d /home/httpd ; then echo /home/httpd ; else echo /var/www ; fi)}

%define	_prefix				/usr/lib/courier
%define _localstatedir			/var/spool/courier
%define	_sysconfdir			/etc/courier
%define	_mandir				%{manpagedir}

%define initdir %(if test -d /etc/init.d/. ; then echo /etc/init.d ; else echo /etc/rc.d/init.d ; fi)

# Change the following if your DocumentRoot and cgibindir differ.  This is
# the default redhat build:

%define	apache_cgibindir		%{apacheinstdir}/cgi-bin
%define apache_documentroot		%{apacheinstdir}/html

%define STATEDIR /var/lib/rpm-state

%if %using_systemd

# systemd-rpm-macros
%define STOP_COURIER \
        if /usr/bin/systemctl --quiet is-active courier \
	then \
	     if test -d %{STATEDIR}/courier \
	     then \
		/usr/bin/systemctl stop courier \
		touch %{STATEDIR}/courier/restart \
	     fi \
	fi

%define RESTART_COURIER \
	if test -f %{STATEDIR}/courier/restart \
	then \
	     rm -f %{STATEDIR}/courier/restart \
	     /usr/bin/systemctl start courier \
	fi
%else
%define STOP_COURIER		%{nil}
%define RESTART_COURIER		%{nil}
%endif

# -----------------------------------------------------------------------------

Summary:          Courier 1.3.12 mail server
Name:             courier
Version:          1.3.12
Release:          1%{?dist}%{courier_release}

Group:            Applications/Mail
License:          GPL
URL:              https://www.courier-mta.org
Packager:         %{PACKAGER}
Source:           http://download.sourceforge.net/courier/courier-1.3.12.tar.bz2
Provides:         smtpdaemon server(smtp)
Provides:         config(courier) = %{version}-%{release}
AutoProv:         no

%if %using_systemd
Requires(pre):      systemd
Requires(post):     systemd
Requires(postun):   systemd
Requires:           systemd
%if 0%(rpm -q centos-release >/dev/null 2>&1 && echo "1"; exit 0)
BuildRequires:      /usr/lib/rpm/macros.d/macros.systemd
%else
BuildRequires:	    systemd-rpm-macros
%endif

%define initscript_courier %{nil}
%else
Requires(post):   /sbin/chkconfig
Requires(preun):  /sbin/chkconfig
Requires(postun): /sbin/service
%define initscript_courier --initscript courier
%endif

Requires:         coreutils
Requires:	  wget
%if %alternatives
Obsoletes:        courier-sendmail-wrapper < 1.3.12
Provides:         /usr/sbin/sendmail /usr/bin/mailq /usr/bin/rmail /usr/bin/newaliases
%endif

BuildRequires:    gcc-c++
%if %is_rhel7
BuildRequires:    glibc-common
%else
BuildRequires:    glibc-langpack-en
%endif
BuildRequires:    courier-authlib-devel
BuildRequires:    rpm >= 4.0.2
BuildRequires:    coreutils
BuildRequires:    binutils
BuildRequires:    sed
BuildRequires:    gawk
BuildRequires:    perl
BuildRequires:    make
BuildRequires:    procps-ng
BuildRequires:    wget
BuildRequires:    gzip
BuildRequires:    hunspell
%{?_with_gpg2:  %define with_gpg2 1}
%{!?_with_gpg2: %define with_gpg2 0}

%if %with_gpg2
BuildRequires: gnupg2
Requires: gnupg2
%define gpg_option --with-gpg2
%else
BuildRequires: gnupg >= 1.0.5
Requires: gnupg >= 1.0.5
%endif
BuildRequires:    expect
BuildRequires:    gdbm-devel
BuildRequires:    pam-devel
BuildRequires:	  libidn2-devel
BuildRequires:    courier-unicode-devel
BuildRequires:	  perl(ExtUtils::Embed)
BuildRequires:	  mailcap
BuildRequires:    openldap-devel

%define use_openssl %(rpm -q openssl-devel >/dev/null 2>&1 && echo 1 && exit 0; echo 0)

%if %use_openssl
BuildRequires:      openssl
BuildRequires:      openssl-devel
BuildRequires:      openssl-perl
%else
BuildRequires:      libgcrypt-devel gnutls-devel /usr/bin/certtool
Requires:	    gnutls-utils
%endif

%if %with_fax
BuildRequires:      groff
BuildRequires:      ghostscript

%if %is_rhel

%else
BuildRequires:      mgetty-sendfax
%endif
BuildRequires:      netpbm-progs
%endif
BuildRequires:      pcre2-devel
BuildRequires:      make
Obsoletes:	courier-smtpauth < 1.3.12

%if 0%{?fedora}
BuildRequires: glibc-langpack-en
BuildRequires: perl-generators
%endif

Requires: courier-authlib-config-%(eval `courierauthconfig --configfiles`; echo "$mailuser-$mailgroup")

%if ! %alternatives
%package sendmail-wrapper
Summary: Courier 1.3.12 soft links for sendmail
Group: Applications/Mail
Requires: courier = %{version}-%{release}
%endif

%package ldap
Summary: Courier 1.3.12 LDAP modules and configuration screen
Group: Application/Mail
Requires: courier = %{version}-%{release}
%if %using_systemd
Requires(preun): systemd
Requires(posttrans): systemd
%endif

%package mysql
Summary: Courier 1.3.12 MySQL configuration screen
Group: Application/Mail
Requires: courier = %{version}-%{release}

%package pgsql
Summary: Courier 1.3.12 PostgreSQL configuration screen
Group: Application/Mail
Requires: courier = %{version}-%{release}

%package pop3d
Summary: Courier 1.3.12 Integrated POP3 server
Group: Applications/Mail
Requires: coreutils
Requires: courier = %{version}-%{release}
%if %using_systemd
Requires(preun): systemd
Requires(posttrans): systemd
%endif

%package imapd
Summary: Courier 1.3.12 Integrated IMAP server
Group: Applications/Mail
Requires: coreutils
Requires: courier = %{version}-%{release}
%if %using_systemd
Requires(preun): systemd
Requires(posttrans): systemd
%endif

%package webmail
Summary: Courier 1.3.12 Integrated HTTP (webmail) server
Group: Applications/Mail
Requires: /etc/cron.hourly
Requires: courier = %{version}-%{release}
Requires: hunspell
BuildRequires:    gzip
%if %with_gpg2
Requires: gnupg2
%define gpg_option --with-gpg2
%else
Requires: gnupg >= 1.0.5
%endif
Requires: httpd-filesystem
%if %using_systemd
Requires(preun): systemd
Requires(posttrans): systemd
%endif

%package webadmin
Summary: Courier 1.3.12 web-based administration tool
Group: Applications/Mail
Requires: courier = %{version}-%{release}
Requires: httpd-filesystem

%package mlm
Summary: Courier 1.3.12 Integrated Mailing List Manager
Group: Applications/Mail
Requires: courier = %{version}-%{release}

%package mlm-web
Summary: Courier 1.3.12 Integrated web-based mailing list interface
Group: Applications/Mail
Requires: courier-mlm = %{version}-%{release}
Requires: httpd-filesystem
%if %using_systemd
Requires(preun): systemd
Requires(posttrans): systemd
%endif

%package maildrop
Summary: Courier 1.3.12 Integrated mail filter
Group: Applications/Mail
Requires: courier = %{version}-%{release}

%package fax
Summary: Courier 1.3.12 fax support
Group: Application/Mail
Requires: courier = %{version}-%{release}
Requires: groff ghostscript netpbm-progs mgetty-sendfax

%package maildrop-wrapper
Summary: Courier 1.3.12 soft links for maildrop
Group: Applications/Mail
Requires: courier-maildrop = %{version}-%{release}

%description
The Courier mail transfer agent (MTA) is an integrated mail/groupware
server based on open commodity protocols, such as ESMTP, IMAP, POP3, LDAP,
SSL, and HTTP. Courier provides ESMTP, IMAP, POP3, webmail, and mailing list
services within a single, consistent, framework.  Individual components can
be enabled or disabled at will.

After installing this RPM, additional information regarding configuring
and using courier can be found in %{_defaultdocdir}.

Particularly, README.REDHAT describes where everything is installed, and
install.html contains the regular installation instructions, which includes
configuration information.  In particular, the courier-webadmin package
will contain the web-based configuration tool, webadmin.  After installing
apache and courier-webadmin, and using the webadmin password
in %{_sysconfdir}/webadmin/password (which is initialized to a random string
by default), you will be able to configure Courier using any web browser.

Available rpmbuild rebuild options:
--without : fax

%if ! %alternatives
%description sendmail-wrapper
This package contains two soft links from /usr/sbin/sendmail and
/usr/lib/sendmail to %{_bindir}/sendmail.  This allows application
that use sendmail to transparently use Courier for sending mail.
%endif

%description pop3d
This package adds POP3 server access to the Courier mail server.
Courier's POP3 server can only be used to access maildir mailboxes.
This server does not support mailbox files.  If you do not need the
ability to download mail with a POP3 client, you do not need to install
this package.

%description imapd
This package adds IMAP server access to the Courier mail server.
Courier's IMAP server can only be used to access maildir mailboxes.
This server does not support mailbox files.  If you do not need the
ability to access mail with an IMAP client, you do not need to install
this package.

This is a different package than the standalone version of the
Courier IMAP server.  You cannot install both this package, and the
standalone version, called "Courier-IMAP".  If you have the standalone
version already installed, installing this package will automatically
remove the standalone version.

%description webmail
This package adds webmail access to the Courier mail server.  Webmail
access is provided via a CGI module that is installed in the apache's
cgi-bin directory.  You must have apache installed.

%description mlm-web
This package installs the web-based mini-interface to the Courier
mailing list manager.  The web access is provided via a CGI module that
is installed in the apache's cgi-bin directory.  You must have apache
installed.

%description webadmin
This package install the web-based administration tool for the Courier
mail server.  The webadmin tool allows the most common administrative
tasks to be done from any web browser.

After installing this tool, initialize %{_sysconfdir}/webadmin/password
to contain the administrative password.
The default configuration permits non-SSL access only from the same server,
and all external logins must use SSL.  See the installation notes
for information on enabling external non-SSL access.

%description fax
This package adds support for faxing E-mail messages.  You need to install
this package if you want the ability to send fax messages simply by
Sending an E-mail to phonenumber@fax.

%description maildrop
This package adds mail filtering abilities to Courier.  Mail filtering
is provided via a customized version of the maildrop mail filter.

You need to install this package if you want the ability to filter
incoming mail.
%description mlm
This package installs couriermlm - a mailing list manager for the
Courier mail server.  If you do not need the ability to manage
mailing lists, you do not need to install this package.

couriermlm is used to set up, maintain, and run a mailing list.
couriermlm automatically processes subscription and unsubscription
requests, and removes undeliverable addresses from the subscription
rolls.  Mailing lists managed by couriermlm require zero human
administrative oversight. couriermlm supports digests, write-only
posting aliases, and moderated mailing lists.

%description maildrop-wrapper
This package installs several soft links from the /usr/local/bin
directory to Courier's integrated maildrop mail filter.  Maildrop is
available as a standalone package, which installs in /usr/local/bin.
If you have applications that expect to find maildrop in /usr/local/bin
you can install this package to create soft links that point to
Courier's integrated maildrop version instead, in order to continue
to use those applications, without needing to reconfigure them.

%description ldap
This package contains LDAP modules and the webadmin configuration screen
for Courier.

%description mysql
This package contains the webadmin MySQL configuration screen for Courier.

%description pgsql
This package contains the webadmin PostgreSQL configuration screen for Courier.

# -----------------------------------------------------------------------------

%prep
%setup -q

%build
%configure -C %{?notice_option} %{?xflags: %{xflags}}

%{__cat} >README.REDHAT <<EOF

This installation of Courier is configured as follows:

Main installation directory:     %{_prefix}
Binary installation directory:   %{_exec_prefix}
Binaries:                        %{_bindir}
Superuser binaries:              %{_sbindir}
Program executables:             %{_libexecdir}
Configuration files:             %{_sysconfdir}
Scripts, other non-binaries:     %{_datadir}
Mail queue, temporary files:     %{_localstatedir}
Manual pages:                    %{_mandir}

EOF

/usr/bin/perl -p -i -e 's@^webadmin=.*@webadmin="%{apache_cgibindir}/webadmin"@' \
	      courier.sysvinit || exit 1

# -----------------------------------------------------------------------------

LANG=C
export LANG
umask 022
%{__make} -s %{_smp_mflags}
%{__make} check
%install
LANG=C
export LANG

umask 022
test "$RPM_BUILD_ROOT" != "" && rm -rf $RPM_BUILD_ROOT
%{__mkdir_p} $RPM_BUILD_ROOT%{_prefix}
%{__mkdir_p} $RPM_BUILD_ROOT/etc/pam.d

%{__make} -s install DESTDIR=$RPM_BUILD_ROOT

%{__install} -m 0444 libs/imap/imapd.pam $RPM_BUILD_ROOT/etc/pam.d/imap
%{__install} -m 0444 courier/module.esmtp/esmtp.authpam $RPM_BUILD_ROOT/etc/pam.d/esmtp
%{__install} -m 0444 libs/imap/pop3d.pam $RPM_BUILD_ROOT/etc/pam.d/pop3
%{__install} -m 0444 libs/sqwebmail/webmail.authpam $RPM_BUILD_ROOT/etc/pam.d/webmail
%{__install} -m 0444 libs/sqwebmail/webmail.authpam $RPM_BUILD_ROOT/etc/pam.d/calendar
%{__rm} -f $RPM_BUILD_ROOT%{_sysconfdir}/*.authpam

# Create permissions.dat

%{__make} install-perms

#
# We're going to create some more config files later, so let's just make
# sure they're processed as all other Courier config files
#

echo '/etc/profile.d/courier.sh 755 bin bin config' >>permissions.dat
echo '/etc/profile.d/courier.csh 755 bin bin config' >>permissions.dat
%if %using_systemd
mkdir -p $RPM_BUILD_ROOT%{STATEDIR}/courier
echo '%{STATEDIR}/courier 755 root root' >>permissions.dat

echo '%{_datadir}/courier.sysvinit 755 bin bin' >>permissions.dat
echo '%{_unitdir}/courier.service 644 root root' >>permissions.dat
%else
echo '%{initdir}/courier 755 bin bin config' >>permissions.dat
%endif

#
#  Translate permissions.dat to spec file format
#

/usr/bin/perl -e '
$buildroot=$ENV{"RPM_BUILD_ROOT"};
$prefix="%{_prefix}";
$exec_prefix="%{_exec_prefix}";

while (<>)
{
	chop if /\n$/;
	my ($file,$mode,$uid,$gid,$special)=split(/ +/);
	$file=$prefix if $file eq "$prefix/.";

	next if $special eq "doc";
	next if $file eq "$prefix/doc";

	# Ignore dir/. entries

	next if $file =~ /\/\.$/;

	# Ignore man directories

	next if $file eq "%{_mandir}";
	next if substr($file, 0, length("%{_mandir}")) eq "%{_mandir}"
		&& substr($file, length("%{_mandir}")) =~ /^\/man[1-9]$/;

	$special="%config" if $special eq "config";
	$special="%dir" if ! -l "$buildroot/$file" && -d "$buildroot/$file";

	my $islink = -l "$ENV{RPM_BUILD_ROOT}/$file";

	$file .= ".*" if $special eq "man";	# For brp-compress

	$special="" unless $special =~ /%/;

	$special="%attr($mode, $uid, $gid) $special" unless $islink;

	print "$special $file\n";
}

' <permissions.dat >filelist1 || exit 1

############################################################################
#
# Break up a single filelist into multiple packages right here.  This is
# going to be ugly.
#

%{__sed} -n '/imap[\.a-z0-9]*$/p;/imapd-ssl/p' <filelist1 | grep -v authpam >filelist.imap
%{__sed} -n '/pop3[\.a-z0-9]*$/p;/pop3d-ssl/p' <filelist1 | grep -v authpam >filelist.pop3
%{__sed} -n '/couriermlm/p' <filelist1 >filelist.mlm
%{__sed} -n '/webmlmd/p' <filelist1 >filelist.webmlm
%{__sed} -n '/maildrop[^/]*$/p;/mailbot/p;/reformail[^/]*$/p' <filelist1 >filelist.maildrop

%{__sed} -n '/15ldap/p;/ldapsearch/p;/courierldapalias/p' <filelist1 | %{__sed} '/sqwebmail/d' >filelist.ldap

%{__sed} -n '/15mysql/p' <filelist1 >filelist.mysql

%{__sed} -n '/15pgsql/p' <filelist1 >filelist.pgsql

%{__sed} -n '/faxmail/p;/35fax/p;/34fax/p' <filelist1 >filelist.fax

%{__mkdir_p} $RPM_BUILD_ROOT/etc/mgetty+sendfax
%{__ln_s} `realpath --relative-to /etc/mgetty+sendfax -m %{_datadir}/faxmail/new_fax` $RPM_BUILD_ROOT/etc/mgetty+sendfax/new_fax

%if ! %with_fax
awk '{print $NF}' filelist.fax |
while read file; do
    %{__rm} -f $RPM_BUILD_ROOT$file
done
%{__rm} -f $RPM_BUILD_ROOT/etc/mgetty+sendfax/new_fax
%endif

# Delete all of the above, AND ldapaddressbook+webmail from the filelist.
# Do not install esmtp.authpam, taken care of elsewhere.
# Do not install htmldoc, taken care of elsewhere

%{__sed} '/imap[\.a-z0-9]*$/d;/imapd-ssl/d;/pop3[\.a-z0-9]*$/d;/pop3d-ssl/d;/couriermlm/d;/webmail/d;/webmlm/d;/authsystem\.passwd/d;/ldapsearch$/d;/ldapaddressbook.dist$/d;/pcpd/d;/calendar/d;/maildrop[^/]*$/d;/mailbot/d;/reformail[^/]*$/d;/15ldap/d;/47webmail/d;/sqwebpasswd/d;/courierldapalias/d;/15mysql/d;/15pgsql/d;/faxmail/d;/35fax/d;/34fax/d;/esmtp\.authpam/d;/htmldoc/d' <filelist1 >filelist


%{__sed} -n '/47webmail/p;/sqwebmail/p;/sqwebpasswd/p;/authsystem\.passwd/p;/webmail-logincache/p;/ldapaddressbook.dist$/p;/pcpd/p;/calendar/p' <filelist1 | sed '/images/d' | sort | uniq >filelist.webmail
echo "%attr(755, root, bin) %{_sbindir}/webmaild" >>filelist.webmail

# Note that we delete all 'webmail's, but extract only 'sqwebmail's.
# This removes all webmail-related stuff from the main filelist,
# and adds everything except the executable, webmail, to filelist.webmail.
# Here's why, we move the webmail binary directly into the cgibindir.

%{__mkdir_p} $RPM_BUILD_ROOT%{apache_cgibindir}
%{__cp} $RPM_BUILD_ROOT%{_libexecdir}/courier/webmail/webmail \
	$RPM_BUILD_ROOT%{apache_cgibindir}/webmail
%{__cp} $RPM_BUILD_ROOT%{_libexecdir}/courier/webmail/webadmin \
	$RPM_BUILD_ROOT%{apache_cgibindir}/webadmin
%{__cp} $RPM_BUILD_ROOT%{_libexecdir}/courier/webmail/webmlm \
	$RPM_BUILD_ROOT%{apache_cgibindir}/webmlm
rm -rf $RPM_BUILD_ROOT%{_libexecdir}/courier/webmail

echo "systemctl try-restart courier.service &" >$RPM_BUILD_ROOT%{_sysconfdir}/webadmin/restartcmd
echo "systemctl restart courier-authlib.service" >$RPM_BUILD_ROOT%{_sysconfdir}/webadmin/restartauthcmd

# Remove the webadmin wrapper from filelist (but keep all html and pl files
# there.

%{__sed} '/courier\/webmail\/webadmin /d' <filelist >filelist.tmp
%{__mv} filelist.tmp filelist

# For the same reason we delete all images from filelist.webmail:

%{__mkdir_p} $RPM_BUILD_ROOT%{apache_documentroot}
%{__mv} $RPM_BUILD_ROOT%{_datadir}/sqwebmail/images $RPM_BUILD_ROOT%{apache_documentroot}/webmail

# Do we need to install a cron job to clean out webmail's cache?

if test -f libs/sqwebmail/cron.cmd
then
	%{__mkdir_p} $RPM_BUILD_ROOT/etc/cron.hourly
	%{__cat} >$RPM_BUILD_ROOT/etc/cron.hourly/courier-webmail-cleancache <<EOF
#!/bin/sh

su - bin -s /bin/sh -c %{_datadir}/sqwebmail/cleancache.pl
EOF

	echo "%attr(555, root, bin) /etc/cron.hourly/courier-webmail-cleancache" >>filelist.webmail
fi

#
# Move .html documentation back to build dir, so that RPM will move it to
# the appropriate docdir
#

%{__rm} -rf htmldoc
%{__mkdir} htmldoc
%{__chmod} 755 htmldoc
%{__cp} $RPM_BUILD_ROOT%{_datadir}/htmldoc/* htmldoc
%{__chmod} a-wx htmldoc/*
rm -rf $RPM_BUILD_ROOT%{_datadir}/htmldoc

#
# Update /etc/skel

%{__mkdir_p} $RPM_BUILD_ROOT/etc/skel
libs/maildir/maildirmake $RPM_BUILD_ROOT/etc/skel/Maildir

############################################################################
#
# Some configuration file tweaking.
#
# Manually set POP3DSTART and IMAPDSTART to yes, they'll go into a separate
# package, so after it's installed they should be runnable.

%{__sed} 's/^POP3DSTART.*/POP3DSTART=YES/' <$RPM_BUILD_ROOT%{_sysconfdir}/pop3d.dist >$RPM_BUILD_ROOT%{_sysconfdir}/pop3d.new
%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/pop3d.new $RPM_BUILD_ROOT%{_sysconfdir}/pop3d.dist

%{__sed} 's/^POP3DSSLSTART.*/POP3DSSLSTART=YES/' <$RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.dist >$RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.new
%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.new $RPM_BUILD_ROOT%{_sysconfdir}/pop3d-ssl.dist

%{__sed} 's/^IMAPDSTART.*/IMAPDSTART=YES/' <$RPM_BUILD_ROOT%{_sysconfdir}/imapd.dist >$RPM_BUILD_ROOT%{_sysconfdir}/imapd.new
%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/imapd.new $RPM_BUILD_ROOT%{_sysconfdir}/imapd.dist

%{__sed} 's/^IMAPDSSLSTART.*/IMAPDSSLSTART=YES/' <$RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.dist >$RPM_BUILD_ROOT%{_sysconfdir}/imapd.new-ssl
%{__mv} $RPM_BUILD_ROOT%{_sysconfdir}/imapd.new-ssl $RPM_BUILD_ROOT%{_sysconfdir}/imapd-ssl.dist

# Convenient init file.

%if %using_systemd
%{__cp} courier.sysvinit $RPM_BUILD_ROOT%{_datadir}/courier.sysvinit
%{__mkdir_p} $RPM_BUILD_ROOT%{_unitdir}
%{__cp} courier.service $RPM_BUILD_ROOT%{_unitdir}
%else
%{__mkdir_p} $RPM_BUILD_ROOT%{initdir}
%{__cp} courier.sysvinit $RPM_BUILD_ROOT%{initdir}/courier
%endif

# Create an initial default DH paramter file, and install a
# monthly script to generate DH parameters

cat >$RPM_BUILD_ROOT/%{_datadir}/dhparams.pem.dist <<ZZ
This file contains default DH parameters for initial use on a new
installation. The startup script copies this file to dhparams.pem,
unless it already exists.

ZZ

sed 's/^chown/echo/' <libs/imap/mkdhparams >libs/imap/mkdhparams.tmp
TLS_DHPARAMS=$RPM_BUILD_ROOT/%{_datadir}/dhparams.pem.dist.tmp %{__spec_rmbuild_shell} libs/imap/mkdhparams.tmp
%{__rm} -f libs/imap/mkdhparams.tmp
cat $RPM_BUILD_ROOT/%{_datadir}/dhparams.pem.dist.tmp >>$RPM_BUILD_ROOT/%{_datadir}/dhparams.pem.dist
%{__rm} -f $RPM_BUILD_ROOT/%{_datadir}/dhparams.pem.dist.tmp
courier/courier-config | grep '^mail' >uidgid
. ./uidgid
%{__rm} -f uidgid
echo "%attr(600, $mailuser, $mailgroup) %{_datadir}/dhparams.pem.dist" >>filelist

%{__mkdir_p} $RPM_BUILD_ROOT/etc/cron.monthly
%{__ln_s} `realpath --relative-to /etc/cron.monthly -m %{_sbindir}/mkdhparams` $RPM_BUILD_ROOT/etc/cron.monthly/courier-mkdhparams
echo "/etc/cron.monthly/courier-mkdhparams" >>filelist

## Loosen up permissions in BUILDROOT bindirs to prevent strip
## "unable to copy file -- permission denied" in mock.
chmod -R a+rw %{buildroot}/usr/lib/courier/libexec/courier
chmod -R a+rw %{buildroot}/usr/lib/courier/sbin
chmod -R a+rw %{buildroot}/usr/lib/courier/bin
chmod -R a+rw %{buildroot}/var/www/cgi-bin

#
# Make up some /etc/profile.d scripts
#

%{__mkdir_p} $RPM_BUILD_ROOT/etc/profile.d
%{__cat} >$RPM_BUILD_ROOT/etc/profile.d/courier.sh <<EOF
if echo "\$PATH" | tr ':' '\012' | grep -F -qx %{_bindir}
then
	:
else
	if test \`id -u\` = 0
	then
		PATH="%{_sbindir}:\$PATH"
	fi
	PATH="%{_bindir}:\$PATH"
	export PATH
fi
EOF

%{__cat} >$RPM_BUILD_ROOT/etc/profile.d/courier.csh <<EOF
echo "\$PATH" | tr ':' '\012' | grep -F -qx %{_bindir}
if ( \$? ) then
	test \`id -u\` = 0
	if ( \$? == 0 ) then
		setenv PATH "%{_sbindir}:\$PATH"
	endif
	setenv PATH "%{_bindir}:\$PATH"
endif
EOF

#
# Create sendmail soft links manually.
#

%{__mkdir_p} $RPM_BUILD_ROOT/usr/sbin
%{__mkdir_p} $RPM_BUILD_ROOT/usr/lib
%{__mkdir_p} $RPM_BUILD_ROOT/usr/bin


%if %alternatives
	%{__ln_s} ../sbin/sendmail $RPM_BUILD_ROOT/usr/lib/sendmail
	%{__ln_s} ../sbin/sendmail $RPM_BUILD_ROOT/usr/bin/sendmail
%else

# Old fashioned stuff

	cat >filelist.sendmail-wrapper <<EOF
%attr(-, root, root) /usr/sbin/sendmail
%attr(-, root, root) /usr/bin/sendmail
%attr(-, root, root) /usr/lib/sendmail
EOF

	%{__ln_s} `realpath --relative-to /usr/sbin -m %{_bindir}/sendmail` $RPM_BUILD_ROOT/usr/sbin/sendmail
	%{__ln_s} `realpath --relative-to /usr/lib -m %{_bindir}/sendmail` $RPM_BUILD_ROOT/usr/lib/sendmail
	%{__ln_s} `realpath --relative-to /usr/bin -m %{_bindir}/sendmail` $RPM_BUILD_ROOT/usr/bin/sendmail
%endif

#
# maildrop wrapper soft links (value added for the RPM)
#

%{__mkdir_p} $RPM_BUILD_ROOT/usr/local/bin

for f in maildirmake maildrop makedat reformail reformime mimegpg deliverquota
do
	%{__ln_s} `realpath --relative-to /usr/local/bin -m %{_bindir}/$f` $RPM_BUILD_ROOT/usr/local/bin/$f
done

#
# The following directories are not created by default, but I want them here.
#

#####################
##
## sysconftool support.  Instead of doing make install-configure, grab all
## the %config .dists from the filelists, and arrange to run sysconftool in
## the postinstallation scripts.  This is done by saving the .dists into
## a file that's included in the installation package.  sysconftool is also
## added to the installation package, and we run the whole thing from
## %post-s.

for f in filelist filelist.pop3 filelist.imap filelist.webmail
do
	ff=`echo $f | %{__sed} 's/filelist/configlist/'`

	/usr/bin/perl -e '
		while (<>)
		{
			chop;
			next unless /\%config.* (.*\.dist)$/;
			print "$1\n";
		} ' < $f >$RPM_BUILD_ROOT/%{_datadir}/$ff
done

%{__cp} sysconftool $RPM_BUILD_ROOT%{_datadir}/sysconftool

cat <<ZZ >>filelist.webmail
%%attr(555, root, bin) %{apache_cgibindir}/webmail
%%attr(644, root, root) %%config(noreplace) /etc/pam.d/webmail
%%attr(644, root, root) %%config(noreplace) /etc/pam.d/calendar
%%attr(755, bin, bin) %%dir %{apache_documentroot}/webmail
%%attr(444, bin, bin) %{apache_documentroot}/webmail/*
%%attr(444, bin, bin) %{_datadir}/configlist.webmail
ZZ

echo %{apache_cgibindir}/webmlm >>filelist.webmlm
echo '%%attr(644, root, root) %{_sysconfdir}/webmlmrc.dist' >>filelist.webmlm

echo '%%attr(511, root, root) %{apache_cgibindir}/webadmin' >filelist.webadmin


# -----------------------------------------------------------------------------

%post

%if %using_systemd
if test -f %{initdir}/courier
then
	/sbin/chkconfig --del courier
	/usr/bin/systemctl stop courier.service || :
fi
%endif

# Somehow the systemd macro ends up corrupting with_fax

%if %with_fax
%define with_fax_flag 1
%else
%define with_fax_flag 0
%endif

%if %using_systemd
%systemd_post courier.service
if [ $1 -eq 1 ]
then
    /usr/bin/systemctl daemon-reload >/dev/null 2>&1 || :
fi
%else
/sbin/chkconfig --del courier
/sbin/chkconfig --add courier
%endif

%{_datadir}/sysconftool `%{__cat} %{_datadir}/configlist` >/dev/null
%if %alternatives
/usr/sbin/alternatives --install /usr/sbin/sendmail mta %{_bindir}/sendmail 91 \
   --slave /usr/bin/mailq mta-mailq %{_bindir}/mailq \
   --slave /usr/bin/rmail mta-rmail %{_bindir}/rmail \
   --slave /usr/bin/newaliases mta-newaliases %{_sbindir}/makealiases %initscript_courier
%endif

%triggerpostun -- courier-sendmail-wrapper
%if %alternatives
/usr/sbin/alternatives --install /usr/sbin/sendmail mta %{_bindir}/sendmail 91 \
   --slave /usr/bin/mailq mta-mailq %{_bindir}/mailq \
   --slave /usr/bin/rmail mta-rmail %{_bindir}/rmail \
   --slave /usr/bin/newaliases mta-newaliases %{_sbindir}/makealiases %initscript_courier
%endif

%postun
%if %alternatives
if test "$1" = 0 ; then
	/usr/sbin/alternatives --remove mta %{_bindir}/sendmail
fi
%endif

%if %using_systemd

/usr/bin/systemctl daemon-reload >/dev/null 2>&1 || :

if test "$1" = "0"
then
	rm -f %{STATEDIR}/courier/restart
fi


%else

if test "$1" != 0
then
        /sbin/service courier condrestart >/dev/null 2>&1
fi

%endif

%pre
%STOP_COURIER

%preun
%if %using_systemd
%systemd_preun courier.service

%STOP_COURIER
%else
if test "$1" = "0"
then
        %{_sbindir}/esmtpd stop
        %{_sbindir}/esmtpd-msa stop
        %{initdir}/courier stop >/dev/null

        /sbin/chkconfig --del courier
fi
%endif

%pre pop3d
%STOP_COURIER

%pre imapd
%STOP_COURIER

%pre ldap
%STOP_COURIER

%pre mlm-web
%STOP_COURIER

%pre webmail
%STOP_COURIER

%pre webadmin
%STOP_COURIER

%preun pop3d
%STOP_COURIER

%preun imapd
%STOP_COURIER

%preun ldap
%STOP_COURIER

%preun mlm-web
%STOP_COURIER

%preun webmail
%STOP_COURIER

%preun webadmin
%STOP_COURIER

%triggerpostun -- courier-pop3d,courier-imapd,courier-ldap,courier-mlm-web,courier-webmail,courier-webadmin
%RESTART_COURIER

%posttrans
%RESTART_COURIER

%posttrans pop3d
%RESTART_COURIER

%posttrans imapd
%RESTART_COURIER

%posttrans ldap
%RESTART_COURIER

%posttrans mlm-web
%RESTART_COURIER

%posttrans webmail
%RESTART_COURIER

%posttrans webadmin
%RESTART_COURIER

%post imapd
%{_datadir}/sysconftool `%{__cat} %{_datadir}/configlist.imap` >/dev/null

%post pop3d
%{_datadir}/sysconftool `%{__cat} %{_datadir}/configlist.pop3` >/dev/null

%post webmail
%{_datadir}/sysconftool `%{__cat} %{_datadir}/configlist.webmail` >/dev/null

%post mlm-web

%{_datadir}/sysconftool %{_sysconfdir}/webmlmrc >/dev/null

if test "$1" -gt 1
then
	%{_bindir}/webmlmd restart %{_sysconfdir}/webmlmrc >/dev/null 2>&1 || :
fi

%post webadmin
if test ! -f %{_sysconfdir}/webadmin/password
then
	dd if=/dev/urandom 2>/dev/null | tr -d -c '[A-Za-z0-9]' 2>/dev/null | dd bs=16 count=1 2>/dev/null >%{_sysconfdir}/webadmin/password.tmp
	echo >>%{_sysconfdir}/webadmin/password.tmp
	mv %{_sysconfdir}/webadmin/password.tmp %{_sysconfdir}/webadmin/password
	chmod 400 %{_sysconfdir}/webadmin/password
	chown --reference=%{_sysconfdir}/webadmin %{_sysconfdir}/webadmin/password
fi

%files -f filelist
%if %alternatives
%attr(-, root, root) /usr/bin/sendmail
%attr(-, root, root) /usr/lib/sendmail
%endif
%attr(644, root, root) %config(noreplace) /etc/pam.d/esmtp
%attr(555, bin, bin) %doc README.REDHAT AUTHORS COPYING
%attr(-, bin, bin) %doc htmldoc/*
%attr(555, bin, bin) %{_datadir}/sysconftool
%attr(444, bin, bin) %{_datadir}/configlist

%attr(-, root, root) /etc/skel/Maildir

%if %alternatives

%else
%files sendmail-wrapper -f filelist.sendmail-wrapper
%endif

%files maildrop-wrapper

%attr(-, bin, bin) /usr/local/bin/*

%files pop3d -f filelist.pop3
%attr(644, root, root) %config(noreplace) /etc/pam.d/pop3
%attr(444, bin, bin) %{_datadir}/configlist.pop3

%files imapd -f filelist.imap
%attr(644, root, root) %config(noreplace) /etc/pam.d/imap
%attr(444, bin, bin) %{_datadir}/configlist.imap

%files webmail -f filelist.webmail

%files mlm-web -f filelist.webmlm

%files webadmin -f filelist.webadmin

%files maildrop -f filelist.maildrop

%files mlm -f filelist.mlm

%files ldap -f filelist.ldap

%files mysql -f filelist.mysql

%files pgsql -f filelist.pgsql

%if %with_fax_flag
%files fax -f filelist.fax
%attr(-, root, root) /etc/mgetty+sendfax/new_fax
%endif

# -----------------------------------------------------------------------------

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%changelog

* Tue Nov 22 2022 Sam Varshavchik <mrsam@courier-mta.com>
- Update Makefile
