// Code generated by smithy-go-codegen DO NOT EDIT.

package s3

import (
	"context"
	"errors"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	internalConfig "github.com/aws/aws-sdk-go-v2/internal/configsources"
	internalcontext "github.com/aws/aws-sdk-go-v2/internal/context"
	"github.com/aws/aws-sdk-go-v2/internal/endpoints"
	"github.com/aws/aws-sdk-go-v2/internal/endpoints/awsrulesfn"
	s3cust "github.com/aws/aws-sdk-go-v2/service/s3/internal/customizations"
	internalendpoints "github.com/aws/aws-sdk-go-v2/service/s3/internal/endpoints"
	smithy "github.com/aws/smithy-go"
	smithyauth "github.com/aws/smithy-go/auth"
	smithyendpoints "github.com/aws/smithy-go/endpoints"
	"github.com/aws/smithy-go/endpoints/private/rulesfn"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"net/http"
	"net/url"
	"os"
	"strings"
)

// EndpointResolverOptions is the service endpoint resolver options
type EndpointResolverOptions = internalendpoints.Options

// EndpointResolver interface for resolving service endpoints.
type EndpointResolver interface {
	ResolveEndpoint(region string, options EndpointResolverOptions) (aws.Endpoint, error)
}

var _ EndpointResolver = &internalendpoints.Resolver{}

// NewDefaultEndpointResolver constructs a new service endpoint resolver
func NewDefaultEndpointResolver() *internalendpoints.Resolver {
	return internalendpoints.New()
}

// EndpointResolverFunc is a helper utility that wraps a function so it satisfies
// the EndpointResolver interface. This is useful when you want to add additional
// endpoint resolving logic, or stub out specific endpoints with custom values.
type EndpointResolverFunc func(region string, options EndpointResolverOptions) (aws.Endpoint, error)

func (fn EndpointResolverFunc) ResolveEndpoint(region string, options EndpointResolverOptions) (endpoint aws.Endpoint, err error) {
	return fn(region, options)
}

// EndpointResolverFromURL returns an EndpointResolver configured using the
// provided endpoint url. By default, the resolved endpoint resolver uses the
// client region as signing region, and the endpoint source is set to
// EndpointSourceCustom.You can provide functional options to configure endpoint
// values for the resolved endpoint.
func EndpointResolverFromURL(url string, optFns ...func(*aws.Endpoint)) EndpointResolver {
	e := aws.Endpoint{URL: url, Source: aws.EndpointSourceCustom}
	for _, fn := range optFns {
		fn(&e)
	}

	return EndpointResolverFunc(
		func(region string, options EndpointResolverOptions) (aws.Endpoint, error) {
			if len(e.SigningRegion) == 0 {
				e.SigningRegion = region
			}
			return e, nil
		},
	)
}

type ResolveEndpoint struct {
	Resolver EndpointResolver
	Options  EndpointResolverOptions
}

func (*ResolveEndpoint) ID() string {
	return "ResolveEndpoint"
}

func (m *ResolveEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	if !awsmiddleware.GetRequiresLegacyEndpoints(ctx) {
		return next.HandleSerialize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	if m.Resolver == nil {
		return out, metadata, fmt.Errorf("expected endpoint resolver to not be nil")
	}

	eo := m.Options
	eo.Logger = middleware.GetLogger(ctx)

	var endpoint aws.Endpoint
	endpoint, err = m.Resolver.ResolveEndpoint(awsmiddleware.GetRegion(ctx), eo)
	if err != nil {
		nf := (&aws.EndpointNotFoundError{})
		if errors.As(err, &nf) {
			ctx = awsmiddleware.SetRequiresLegacyEndpoints(ctx, false)
			return next.HandleSerialize(ctx, in)
		}
		return out, metadata, fmt.Errorf("failed to resolve service endpoint, %w", err)
	}

	req.URL, err = url.Parse(endpoint.URL)
	if err != nil {
		return out, metadata, fmt.Errorf("failed to parse endpoint URL: %w", err)
	}

	if len(awsmiddleware.GetSigningName(ctx)) == 0 {
		signingName := endpoint.SigningName
		if len(signingName) == 0 {
			signingName = "s3"
		}
		ctx = awsmiddleware.SetSigningName(ctx, signingName)
	}
	ctx = awsmiddleware.SetEndpointSource(ctx, endpoint.Source)
	ctx = smithyhttp.SetHostnameImmutable(ctx, endpoint.HostnameImmutable)
	ctx = awsmiddleware.SetSigningRegion(ctx, endpoint.SigningRegion)
	ctx = awsmiddleware.SetPartitionID(ctx, endpoint.PartitionID)
	return next.HandleSerialize(ctx, in)
}
func addResolveEndpointMiddleware(stack *middleware.Stack, o Options) error {
	return stack.Serialize.Insert(&ResolveEndpoint{
		Resolver: o.EndpointResolver,
		Options:  o.EndpointOptions,
	}, "OperationSerializer", middleware.Before)
}

func removeResolveEndpointMiddleware(stack *middleware.Stack) error {
	_, err := stack.Serialize.Remove((&ResolveEndpoint{}).ID())
	return err
}

type wrappedEndpointResolver struct {
	awsResolver aws.EndpointResolverWithOptions
}

func (w *wrappedEndpointResolver) ResolveEndpoint(region string, options EndpointResolverOptions) (endpoint aws.Endpoint, err error) {
	return w.awsResolver.ResolveEndpoint(ServiceID, region, options)
}

type awsEndpointResolverAdaptor func(service, region string) (aws.Endpoint, error)

func (a awsEndpointResolverAdaptor) ResolveEndpoint(service, region string, options ...interface{}) (aws.Endpoint, error) {
	return a(service, region)
}

var _ aws.EndpointResolverWithOptions = awsEndpointResolverAdaptor(nil)

// withEndpointResolver returns an aws.EndpointResolverWithOptions that first delegates endpoint resolution to the awsResolver.
// If awsResolver returns aws.EndpointNotFoundError error, the v1 resolver middleware will swallow the error,
// and set an appropriate context flag such that fallback will occur when EndpointResolverV2 is invoked
// via its middleware.
//
// If another error (besides aws.EndpointNotFoundError) is returned, then that error will be propagated.
func withEndpointResolver(awsResolver aws.EndpointResolver, awsResolverWithOptions aws.EndpointResolverWithOptions) EndpointResolver {
	var resolver aws.EndpointResolverWithOptions

	if awsResolverWithOptions != nil {
		resolver = awsResolverWithOptions
	} else if awsResolver != nil {
		resolver = awsEndpointResolverAdaptor(awsResolver.ResolveEndpoint)
	}

	return &wrappedEndpointResolver{
		awsResolver: resolver,
	}
}

func finalizeClientEndpointResolverOptions(options *Options) {
	options.EndpointOptions.LogDeprecated = options.ClientLogMode.IsDeprecatedUsage()

	if len(options.EndpointOptions.ResolvedRegion) == 0 {
		const fipsInfix = "-fips-"
		const fipsPrefix = "fips-"
		const fipsSuffix = "-fips"

		if strings.Contains(options.Region, fipsInfix) ||
			strings.Contains(options.Region, fipsPrefix) ||
			strings.Contains(options.Region, fipsSuffix) {
			options.EndpointOptions.ResolvedRegion = strings.ReplaceAll(strings.ReplaceAll(strings.ReplaceAll(
				options.Region, fipsInfix, "-"), fipsPrefix, ""), fipsSuffix, "")
			options.EndpointOptions.UseFIPSEndpoint = aws.FIPSEndpointStateEnabled
		}
	}

	if options.EndpointOptions.UseDualStackEndpoint == aws.DualStackEndpointStateUnset {
		if options.UseDualstack {
			options.EndpointOptions.UseDualStackEndpoint = aws.DualStackEndpointStateEnabled
		} else {
			options.EndpointOptions.UseDualStackEndpoint = aws.DualStackEndpointStateDisabled
		}
	}

}

func resolveEndpointResolverV2(options *Options) {
	if options.EndpointResolverV2 == nil {
		options.EndpointResolverV2 = NewDefaultEndpointResolverV2()
	}
}

func resolveBaseEndpoint(cfg aws.Config, o *Options) {
	if cfg.BaseEndpoint != nil {
		o.BaseEndpoint = cfg.BaseEndpoint
	}

	_, g := os.LookupEnv("AWS_ENDPOINT_URL")
	_, s := os.LookupEnv("AWS_ENDPOINT_URL_S3")

	if g && !s {
		return
	}

	value, found, err := internalConfig.ResolveServiceBaseEndpoint(context.Background(), "S3", cfg.ConfigSources)
	if found && err == nil {
		o.BaseEndpoint = &value
	}
}

// EndpointParameters provides the parameters that influence how endpoints are
// resolved.
type EndpointParameters struct {
	// The S3 bucket used to send the request. This is an optional parameter that will
	// be set automatically for operations that are scoped to an S3 bucket.
	//
	// Parameter
	// is required.
	Bucket *string

	// The AWS region used to dispatch the request.
	//
	// Parameter is
	// required.
	//
	// AWS::Region
	Region *string

	// When true, send this request to the FIPS-compliant regional endpoint. If the
	// configured endpoint does not have a FIPS compliant endpoint, dispatching the
	// request will return an error.
	//
	// Defaults to false if no value is
	// provided.
	//
	// AWS::UseFIPS
	UseFIPS *bool

	// When true, use the dual-stack endpoint. If the configured endpoint does not
	// support dual-stack, dispatching the request MAY return an error.
	//
	// Defaults to
	// false if no value is provided.
	//
	// AWS::UseDualStack
	UseDualStack *bool

	// Override the endpoint used to send this request
	//
	// Parameter is
	// required.
	//
	// SDK::Endpoint
	Endpoint *string

	// When true, force a path-style endpoint to be used where the bucket name is part
	// of the path.
	//
	// Defaults to false if no value is
	// provided.
	//
	// AWS::S3::ForcePathStyle
	ForcePathStyle *bool

	// When true, use S3 Accelerate. NOTE: Not all regions support S3
	// accelerate.
	//
	// Defaults to false if no value is provided.
	//
	// AWS::S3::Accelerate
	Accelerate *bool

	// Whether the global endpoint should be used, rather then the regional endpoint
	// for us-east-1.
	//
	// Defaults to false if no value is
	// provided.
	//
	// AWS::S3::UseGlobalEndpoint
	UseGlobalEndpoint *bool

	// Internal parameter to use object lambda endpoint for an operation (eg:
	// WriteGetObjectResponse)
	//
	// Parameter is required.
	UseObjectLambdaEndpoint *bool

	// The S3 Key used to send the request. This is an optional parameter that will be
	// set automatically for operations that are scoped to an S3 Key.
	//
	// Parameter is
	// required.
	Key *string

	// The S3 Prefix used to send the request. This is an optional parameter that will
	// be set automatically for operations that are scoped to an S3 Prefix.
	//
	// Parameter
	// is required.
	Prefix *string

	// Internal parameter to disable Access Point Buckets
	//
	// Parameter is required.
	DisableAccessPoints *bool

	// Whether multi-region access points (MRAP) should be disabled.
	//
	// Defaults to false
	// if no value is provided.
	//
	// AWS::S3::DisableMultiRegionAccessPoints
	DisableMultiRegionAccessPoints *bool

	// When an Access Point ARN is provided and this flag is enabled, the SDK MUST use
	// the ARN's region when constructing the endpoint instead of the client's
	// configured region.
	//
	// Parameter is required.
	//
	// AWS::S3::UseArnRegion
	UseArnRegion *bool

	// Internal parameter to indicate whether S3Express operation should use control
	// plane, (ex. CreateBucket)
	//
	// Parameter is required.
	UseS3ExpressControlEndpoint *bool

	// Parameter to indicate whether S3Express session auth should be
	// disabled
	//
	// Parameter is required.
	DisableS3ExpressSessionAuth *bool
}

// ValidateRequired validates required parameters are set.
func (p EndpointParameters) ValidateRequired() error {
	if p.Accelerate == nil {
		return fmt.Errorf("parameter Accelerate is required")
	}

	if p.DisableMultiRegionAccessPoints == nil {
		return fmt.Errorf("parameter DisableMultiRegionAccessPoints is required")
	}

	if p.ForcePathStyle == nil {
		return fmt.Errorf("parameter ForcePathStyle is required")
	}

	if p.UseDualStack == nil {
		return fmt.Errorf("parameter UseDualStack is required")
	}

	if p.UseFIPS == nil {
		return fmt.Errorf("parameter UseFIPS is required")
	}

	if p.UseGlobalEndpoint == nil {
		return fmt.Errorf("parameter UseGlobalEndpoint is required")
	}

	return nil
}

// WithDefaults returns a shallow copy of EndpointParameterswith default values
// applied to members where applicable.
func (p EndpointParameters) WithDefaults() EndpointParameters {
	if p.Accelerate == nil {
		p.Accelerate = ptr.Bool(false)
	}

	if p.DisableMultiRegionAccessPoints == nil {
		p.DisableMultiRegionAccessPoints = ptr.Bool(false)
	}

	if p.ForcePathStyle == nil {
		p.ForcePathStyle = ptr.Bool(false)
	}

	if p.UseDualStack == nil {
		p.UseDualStack = ptr.Bool(false)
	}

	if p.UseFIPS == nil {
		p.UseFIPS = ptr.Bool(false)
	}

	if p.UseGlobalEndpoint == nil {
		p.UseGlobalEndpoint = ptr.Bool(false)
	}
	return p
}

// EndpointResolverV2 provides the interface for resolving service endpoints.
type EndpointResolverV2 interface {
	// ResolveEndpoint attempts to resolve the endpoint with the provided options,
	// returning the endpoint if found. Otherwise an error is returned.
	ResolveEndpoint(ctx context.Context, params EndpointParameters) (
		smithyendpoints.Endpoint, error,
	)
}

// resolver provides the implementation for resolving endpoints.
type resolver struct{}

func NewDefaultEndpointResolverV2() EndpointResolverV2 {
	return &resolver{}
}

// ResolveEndpoint attempts to resolve the endpoint with the provided options,
// returning the endpoint if found. Otherwise an error is returned.
func (r *resolver) ResolveEndpoint(
	ctx context.Context, params EndpointParameters,
) (
	endpoint smithyendpoints.Endpoint, err error,
) {
	params = params.WithDefaults()
	if err = params.ValidateRequired(); err != nil {
		return endpoint, fmt.Errorf("endpoint parameters are not valid, %w", err)
	}
	_UseFIPS := *params.UseFIPS
	_UseDualStack := *params.UseDualStack
	_ForcePathStyle := *params.ForcePathStyle
	_Accelerate := *params.Accelerate
	_UseGlobalEndpoint := *params.UseGlobalEndpoint
	_DisableMultiRegionAccessPoints := *params.DisableMultiRegionAccessPoints

	if exprVal := params.Region; exprVal != nil {
		_Region := *exprVal
		_ = _Region
		if _Accelerate == true {
			if _UseFIPS == true {
				return endpoint, fmt.Errorf("endpoint rule error, %s", "Accelerate cannot be used with FIPS")
			}
		}
		if _UseDualStack == true {
			if exprVal := params.Endpoint; exprVal != nil {
				_Endpoint := *exprVal
				_ = _Endpoint
				return endpoint, fmt.Errorf("endpoint rule error, %s", "Cannot set dual-stack in combination with a custom endpoint.")
			}
		}
		if exprVal := params.Endpoint; exprVal != nil {
			_Endpoint := *exprVal
			_ = _Endpoint
			if _UseFIPS == true {
				return endpoint, fmt.Errorf("endpoint rule error, %s", "A custom endpoint cannot be combined with FIPS")
			}
		}
		if exprVal := params.Endpoint; exprVal != nil {
			_Endpoint := *exprVal
			_ = _Endpoint
			if _Accelerate == true {
				return endpoint, fmt.Errorf("endpoint rule error, %s", "A custom endpoint cannot be combined with S3 Accelerate")
			}
		}
		if _UseFIPS == true {
			if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
				_partitionResult := *exprVal
				_ = _partitionResult
				if _partitionResult.Name == "aws-cn" {
					return endpoint, fmt.Errorf("endpoint rule error, %s", "Partition does not support FIPS")
				}
			}
		}
		if exprVal := params.Bucket; exprVal != nil {
			_Bucket := *exprVal
			_ = _Bucket
			if exprVal := rulesfn.SubString(_Bucket, 0, 6, true); exprVal != nil {
				_bucketSuffix := *exprVal
				_ = _bucketSuffix
				if _bucketSuffix == "--x-s3" {
					if _UseDualStack == true {
						return endpoint, fmt.Errorf("endpoint rule error, %s", "S3Express does not support Dual-stack.")
					}
					if _Accelerate == true {
						return endpoint, fmt.Errorf("endpoint rule error, %s", "S3Express does not support S3 Accelerate.")
					}
					if exprVal := params.Endpoint; exprVal != nil {
						_Endpoint := *exprVal
						_ = _Endpoint
						if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
							_url := *exprVal
							_ = _url
							if exprVal := params.DisableS3ExpressSessionAuth; exprVal != nil {
								_DisableS3ExpressSessionAuth := *exprVal
								_ = _DisableS3ExpressSessionAuth
								if _DisableS3ExpressSessionAuth == true {
									if _url.IsIp == true {
										_uri_encoded_bucket := rulesfn.URIEncode(_Bucket)
										_ = _uri_encoded_bucket
										uriString := func() string {
											var out strings.Builder
											out.WriteString(_url.Scheme)
											out.WriteString("://")
											out.WriteString(_url.Authority)
											out.WriteString("/")
											out.WriteString(_uri_encoded_bucket)
											out.WriteString(_url.Path)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												out.Set("backend", "S3Express")
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3express")
															smithyhttp.SetSigV4ASigningName(&sp, "s3express")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
									if awsrulesfn.IsVirtualHostableS3Bucket(_Bucket, false) {
										uriString := func() string {
											var out strings.Builder
											out.WriteString(_url.Scheme)
											out.WriteString("://")
											out.WriteString(_Bucket)
											out.WriteString(".")
											out.WriteString(_url.Authority)
											out.WriteString(_url.Path)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												out.Set("backend", "S3Express")
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3express")
															smithyhttp.SetSigV4ASigningName(&sp, "s3express")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
									return endpoint, fmt.Errorf("endpoint rule error, %s", "S3Express bucket name is not a valid virtual hostable name.")
								}
							}
							if _url.IsIp == true {
								_uri_encoded_bucket := rulesfn.URIEncode(_Bucket)
								_ = _uri_encoded_bucket
								uriString := func() string {
									var out strings.Builder
									out.WriteString(_url.Scheme)
									out.WriteString("://")
									out.WriteString(_url.Authority)
									out.WriteString("/")
									out.WriteString(_uri_encoded_bucket)
									out.WriteString(_url.Path)
									return out.String()
								}()

								uri, err := url.Parse(uriString)
								if err != nil {
									return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
								}

								return smithyendpoints.Endpoint{
									URI:     *uri,
									Headers: http.Header{},
									Properties: func() smithy.Properties {
										var out smithy.Properties
										out.Set("backend", "S3Express")
										smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
											{
												SchemeID: "sigv4-s3express",
												SignerProperties: func() smithy.Properties {
													var sp smithy.Properties
													smithyhttp.SetDisableDoubleEncoding(&sp, true)

													smithyhttp.SetSigV4SigningName(&sp, "s3express")
													smithyhttp.SetSigV4ASigningName(&sp, "s3express")

													smithyhttp.SetSigV4SigningRegion(&sp, _Region)
													return sp
												}(),
											},
										})
										return out
									}(),
								}, nil
							}
							if awsrulesfn.IsVirtualHostableS3Bucket(_Bucket, false) {
								uriString := func() string {
									var out strings.Builder
									out.WriteString(_url.Scheme)
									out.WriteString("://")
									out.WriteString(_Bucket)
									out.WriteString(".")
									out.WriteString(_url.Authority)
									out.WriteString(_url.Path)
									return out.String()
								}()

								uri, err := url.Parse(uriString)
								if err != nil {
									return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
								}

								return smithyendpoints.Endpoint{
									URI:     *uri,
									Headers: http.Header{},
									Properties: func() smithy.Properties {
										var out smithy.Properties
										out.Set("backend", "S3Express")
										smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
											{
												SchemeID: "sigv4-s3express",
												SignerProperties: func() smithy.Properties {
													var sp smithy.Properties
													smithyhttp.SetDisableDoubleEncoding(&sp, true)

													smithyhttp.SetSigV4SigningName(&sp, "s3express")
													smithyhttp.SetSigV4ASigningName(&sp, "s3express")

													smithyhttp.SetSigV4SigningRegion(&sp, _Region)
													return sp
												}(),
											},
										})
										return out
									}(),
								}, nil
							}
							return endpoint, fmt.Errorf("endpoint rule error, %s", "S3Express bucket name is not a valid virtual hostable name.")
						}
					}
					if exprVal := params.UseS3ExpressControlEndpoint; exprVal != nil {
						_UseS3ExpressControlEndpoint := *exprVal
						_ = _UseS3ExpressControlEndpoint
						if _UseS3ExpressControlEndpoint == true {
							_uri_encoded_bucket := rulesfn.URIEncode(_Bucket)
							_ = _uri_encoded_bucket
							if !(params.Endpoint != nil) {
								if _UseFIPS == true {
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://s3express-control-fips.")
										out.WriteString(_Region)
										out.WriteString(".amazonaws.com/")
										out.WriteString(_uri_encoded_bucket)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											out.Set("backend", "S3Express")
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3express")
														smithyhttp.SetSigV4ASigningName(&sp, "s3express")

														smithyhttp.SetSigV4SigningRegion(&sp, _Region)
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
								uriString := func() string {
									var out strings.Builder
									out.WriteString("https://s3express-control.")
									out.WriteString(_Region)
									out.WriteString(".amazonaws.com/")
									out.WriteString(_uri_encoded_bucket)
									return out.String()
								}()

								uri, err := url.Parse(uriString)
								if err != nil {
									return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
								}

								return smithyendpoints.Endpoint{
									URI:     *uri,
									Headers: http.Header{},
									Properties: func() smithy.Properties {
										var out smithy.Properties
										out.Set("backend", "S3Express")
										smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
											{
												SchemeID: "aws.auth#sigv4",
												SignerProperties: func() smithy.Properties {
													var sp smithy.Properties
													smithyhttp.SetDisableDoubleEncoding(&sp, true)

													smithyhttp.SetSigV4SigningName(&sp, "s3express")
													smithyhttp.SetSigV4ASigningName(&sp, "s3express")

													smithyhttp.SetSigV4SigningRegion(&sp, _Region)
													return sp
												}(),
											},
										})
										return out
									}(),
								}, nil
							}
							return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
						}
					}
					if awsrulesfn.IsVirtualHostableS3Bucket(_Bucket, false) {
						if exprVal := params.DisableS3ExpressSessionAuth; exprVal != nil {
							_DisableS3ExpressSessionAuth := *exprVal
							_ = _DisableS3ExpressSessionAuth
							if _DisableS3ExpressSessionAuth == true {
								if exprVal := rulesfn.SubString(_Bucket, 6, 14, true); exprVal != nil {
									_s3expressAvailabilityZoneId := *exprVal
									_ = _s3expressAvailabilityZoneId
									if exprVal := rulesfn.SubString(_Bucket, 14, 16, true); exprVal != nil {
										_s3expressAvailabilityZoneDelim := *exprVal
										_ = _s3expressAvailabilityZoneDelim
										if _s3expressAvailabilityZoneDelim == "--" {
											if _UseFIPS == true {
												uriString := func() string {
													var out strings.Builder
													out.WriteString("https://")
													out.WriteString(_Bucket)
													out.WriteString(".s3express-fips-")
													out.WriteString(_s3expressAvailabilityZoneId)
													out.WriteString(".")
													out.WriteString(_Region)
													out.WriteString(".amazonaws.com")
													return out.String()
												}()

												uri, err := url.Parse(uriString)
												if err != nil {
													return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
												}

												return smithyendpoints.Endpoint{
													URI:     *uri,
													Headers: http.Header{},
													Properties: func() smithy.Properties {
														var out smithy.Properties
														out.Set("backend", "S3Express")
														smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
															{
																SchemeID: "aws.auth#sigv4",
																SignerProperties: func() smithy.Properties {
																	var sp smithy.Properties
																	smithyhttp.SetDisableDoubleEncoding(&sp, true)

																	smithyhttp.SetSigV4SigningName(&sp, "s3express")
																	smithyhttp.SetSigV4ASigningName(&sp, "s3express")

																	smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																	return sp
																}(),
															},
														})
														return out
													}(),
												}, nil
											}
											uriString := func() string {
												var out strings.Builder
												out.WriteString("https://")
												out.WriteString(_Bucket)
												out.WriteString(".s3express-")
												out.WriteString(_s3expressAvailabilityZoneId)
												out.WriteString(".")
												out.WriteString(_Region)
												out.WriteString(".amazonaws.com")
												return out.String()
											}()

											uri, err := url.Parse(uriString)
											if err != nil {
												return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
											}

											return smithyendpoints.Endpoint{
												URI:     *uri,
												Headers: http.Header{},
												Properties: func() smithy.Properties {
													var out smithy.Properties
													out.Set("backend", "S3Express")
													smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
														{
															SchemeID: "aws.auth#sigv4",
															SignerProperties: func() smithy.Properties {
																var sp smithy.Properties
																smithyhttp.SetDisableDoubleEncoding(&sp, true)

																smithyhttp.SetSigV4SigningName(&sp, "s3express")
																smithyhttp.SetSigV4ASigningName(&sp, "s3express")

																smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																return sp
															}(),
														},
													})
													return out
												}(),
											}, nil
										}
									}
								}
								if exprVal := rulesfn.SubString(_Bucket, 6, 15, true); exprVal != nil {
									_s3expressAvailabilityZoneId := *exprVal
									_ = _s3expressAvailabilityZoneId
									if exprVal := rulesfn.SubString(_Bucket, 15, 17, true); exprVal != nil {
										_s3expressAvailabilityZoneDelim := *exprVal
										_ = _s3expressAvailabilityZoneDelim
										if _s3expressAvailabilityZoneDelim == "--" {
											if _UseFIPS == true {
												uriString := func() string {
													var out strings.Builder
													out.WriteString("https://")
													out.WriteString(_Bucket)
													out.WriteString(".s3express-fips-")
													out.WriteString(_s3expressAvailabilityZoneId)
													out.WriteString(".")
													out.WriteString(_Region)
													out.WriteString(".amazonaws.com")
													return out.String()
												}()

												uri, err := url.Parse(uriString)
												if err != nil {
													return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
												}

												return smithyendpoints.Endpoint{
													URI:     *uri,
													Headers: http.Header{},
													Properties: func() smithy.Properties {
														var out smithy.Properties
														out.Set("backend", "S3Express")
														smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
															{
																SchemeID: "aws.auth#sigv4",
																SignerProperties: func() smithy.Properties {
																	var sp smithy.Properties
																	smithyhttp.SetDisableDoubleEncoding(&sp, true)

																	smithyhttp.SetSigV4SigningName(&sp, "s3express")
																	smithyhttp.SetSigV4ASigningName(&sp, "s3express")

																	smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																	return sp
																}(),
															},
														})
														return out
													}(),
												}, nil
											}
											uriString := func() string {
												var out strings.Builder
												out.WriteString("https://")
												out.WriteString(_Bucket)
												out.WriteString(".s3express-")
												out.WriteString(_s3expressAvailabilityZoneId)
												out.WriteString(".")
												out.WriteString(_Region)
												out.WriteString(".amazonaws.com")
												return out.String()
											}()

											uri, err := url.Parse(uriString)
											if err != nil {
												return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
											}

											return smithyendpoints.Endpoint{
												URI:     *uri,
												Headers: http.Header{},
												Properties: func() smithy.Properties {
													var out smithy.Properties
													out.Set("backend", "S3Express")
													smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
														{
															SchemeID: "aws.auth#sigv4",
															SignerProperties: func() smithy.Properties {
																var sp smithy.Properties
																smithyhttp.SetDisableDoubleEncoding(&sp, true)

																smithyhttp.SetSigV4SigningName(&sp, "s3express")
																smithyhttp.SetSigV4ASigningName(&sp, "s3express")

																smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																return sp
															}(),
														},
													})
													return out
												}(),
											}, nil
										}
									}
								}
								return endpoint, fmt.Errorf("endpoint rule error, %s", "Unrecognized S3Express bucket name format.")
							}
						}
						if exprVal := rulesfn.SubString(_Bucket, 6, 14, true); exprVal != nil {
							_s3expressAvailabilityZoneId := *exprVal
							_ = _s3expressAvailabilityZoneId
							if exprVal := rulesfn.SubString(_Bucket, 14, 16, true); exprVal != nil {
								_s3expressAvailabilityZoneDelim := *exprVal
								_ = _s3expressAvailabilityZoneDelim
								if _s3expressAvailabilityZoneDelim == "--" {
									if _UseFIPS == true {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://")
											out.WriteString(_Bucket)
											out.WriteString(".s3express-fips-")
											out.WriteString(_s3expressAvailabilityZoneId)
											out.WriteString(".")
											out.WriteString(_Region)
											out.WriteString(".amazonaws.com")
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												out.Set("backend", "S3Express")
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "sigv4-s3express",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3express")
															smithyhttp.SetSigV4ASigningName(&sp, "s3express")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://")
										out.WriteString(_Bucket)
										out.WriteString(".s3express-")
										out.WriteString(_s3expressAvailabilityZoneId)
										out.WriteString(".")
										out.WriteString(_Region)
										out.WriteString(".amazonaws.com")
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											out.Set("backend", "S3Express")
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "sigv4-s3express",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3express")
														smithyhttp.SetSigV4ASigningName(&sp, "s3express")

														smithyhttp.SetSigV4SigningRegion(&sp, _Region)
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
						if exprVal := rulesfn.SubString(_Bucket, 6, 15, true); exprVal != nil {
							_s3expressAvailabilityZoneId := *exprVal
							_ = _s3expressAvailabilityZoneId
							if exprVal := rulesfn.SubString(_Bucket, 15, 17, true); exprVal != nil {
								_s3expressAvailabilityZoneDelim := *exprVal
								_ = _s3expressAvailabilityZoneDelim
								if _s3expressAvailabilityZoneDelim == "--" {
									if _UseFIPS == true {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://")
											out.WriteString(_Bucket)
											out.WriteString(".s3express-fips-")
											out.WriteString(_s3expressAvailabilityZoneId)
											out.WriteString(".")
											out.WriteString(_Region)
											out.WriteString(".amazonaws.com")
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												out.Set("backend", "S3Express")
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "sigv4-s3express",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3express")
															smithyhttp.SetSigV4ASigningName(&sp, "s3express")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://")
										out.WriteString(_Bucket)
										out.WriteString(".s3express-")
										out.WriteString(_s3expressAvailabilityZoneId)
										out.WriteString(".")
										out.WriteString(_Region)
										out.WriteString(".amazonaws.com")
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											out.Set("backend", "S3Express")
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "sigv4-s3express",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3express")
														smithyhttp.SetSigV4ASigningName(&sp, "s3express")

														smithyhttp.SetSigV4SigningRegion(&sp, _Region)
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
						return endpoint, fmt.Errorf("endpoint rule error, %s", "Unrecognized S3Express bucket name format.")
					}
					return endpoint, fmt.Errorf("endpoint rule error, %s", "S3Express bucket name is not a valid virtual hostable name.")
				}
			}
		}
		if !(params.Bucket != nil) {
			if exprVal := params.UseS3ExpressControlEndpoint; exprVal != nil {
				_UseS3ExpressControlEndpoint := *exprVal
				_ = _UseS3ExpressControlEndpoint
				if _UseS3ExpressControlEndpoint == true {
					if exprVal := params.Endpoint; exprVal != nil {
						_Endpoint := *exprVal
						_ = _Endpoint
						if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
							_url := *exprVal
							_ = _url
							uriString := func() string {
								var out strings.Builder
								out.WriteString(_url.Scheme)
								out.WriteString("://")
								out.WriteString(_url.Authority)
								out.WriteString(_url.Path)
								return out.String()
							}()

							uri, err := url.Parse(uriString)
							if err != nil {
								return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
							}

							return smithyendpoints.Endpoint{
								URI:     *uri,
								Headers: http.Header{},
								Properties: func() smithy.Properties {
									var out smithy.Properties
									out.Set("backend", "S3Express")
									smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
										{
											SchemeID: "aws.auth#sigv4",
											SignerProperties: func() smithy.Properties {
												var sp smithy.Properties
												smithyhttp.SetDisableDoubleEncoding(&sp, true)

												smithyhttp.SetSigV4SigningName(&sp, "s3express")
												smithyhttp.SetSigV4ASigningName(&sp, "s3express")

												smithyhttp.SetSigV4SigningRegion(&sp, _Region)
												return sp
											}(),
										},
									})
									return out
								}(),
							}, nil
						}
					}
					if _UseFIPS == true {
						uriString := func() string {
							var out strings.Builder
							out.WriteString("https://s3express-control-fips.")
							out.WriteString(_Region)
							out.WriteString(".amazonaws.com")
							return out.String()
						}()

						uri, err := url.Parse(uriString)
						if err != nil {
							return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
						}

						return smithyendpoints.Endpoint{
							URI:     *uri,
							Headers: http.Header{},
							Properties: func() smithy.Properties {
								var out smithy.Properties
								out.Set("backend", "S3Express")
								smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
									{
										SchemeID: "aws.auth#sigv4",
										SignerProperties: func() smithy.Properties {
											var sp smithy.Properties
											smithyhttp.SetDisableDoubleEncoding(&sp, true)

											smithyhttp.SetSigV4SigningName(&sp, "s3express")
											smithyhttp.SetSigV4ASigningName(&sp, "s3express")

											smithyhttp.SetSigV4SigningRegion(&sp, _Region)
											return sp
										}(),
									},
								})
								return out
							}(),
						}, nil
					}
					uriString := func() string {
						var out strings.Builder
						out.WriteString("https://s3express-control.")
						out.WriteString(_Region)
						out.WriteString(".amazonaws.com")
						return out.String()
					}()

					uri, err := url.Parse(uriString)
					if err != nil {
						return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
					}

					return smithyendpoints.Endpoint{
						URI:     *uri,
						Headers: http.Header{},
						Properties: func() smithy.Properties {
							var out smithy.Properties
							out.Set("backend", "S3Express")
							smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
								{
									SchemeID: "aws.auth#sigv4",
									SignerProperties: func() smithy.Properties {
										var sp smithy.Properties
										smithyhttp.SetDisableDoubleEncoding(&sp, true)

										smithyhttp.SetSigV4SigningName(&sp, "s3express")
										smithyhttp.SetSigV4ASigningName(&sp, "s3express")

										smithyhttp.SetSigV4SigningRegion(&sp, _Region)
										return sp
									}(),
								},
							})
							return out
						}(),
					}, nil
				}
			}
		}
		if exprVal := params.Bucket; exprVal != nil {
			_Bucket := *exprVal
			_ = _Bucket
			if exprVal := rulesfn.SubString(_Bucket, 49, 50, true); exprVal != nil {
				_hardwareType := *exprVal
				_ = _hardwareType
				if exprVal := rulesfn.SubString(_Bucket, 8, 12, true); exprVal != nil {
					_regionPrefix := *exprVal
					_ = _regionPrefix
					if exprVal := rulesfn.SubString(_Bucket, 0, 7, true); exprVal != nil {
						_bucketAliasSuffix := *exprVal
						_ = _bucketAliasSuffix
						if exprVal := rulesfn.SubString(_Bucket, 32, 49, true); exprVal != nil {
							_outpostId := *exprVal
							_ = _outpostId
							if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
								_regionPartition := *exprVal
								_ = _regionPartition
								if _bucketAliasSuffix == "--op-s3" {
									if rulesfn.IsValidHostLabel(_outpostId, false) {
										if _hardwareType == "e" {
											if _regionPrefix == "beta" {
												if !(params.Endpoint != nil) {
													return endpoint, fmt.Errorf("endpoint rule error, %s", "Expected a endpoint to be specified but no endpoint was found")
												}
												if exprVal := params.Endpoint; exprVal != nil {
													_Endpoint := *exprVal
													_ = _Endpoint
													if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
														_url := *exprVal
														_ = _url
														uriString := func() string {
															var out strings.Builder
															out.WriteString("https://")
															out.WriteString(_Bucket)
															out.WriteString(".ec2.")
															out.WriteString(_url.Authority)
															return out.String()
														}()

														uri, err := url.Parse(uriString)
														if err != nil {
															return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
														}

														return smithyendpoints.Endpoint{
															URI:     *uri,
															Headers: http.Header{},
															Properties: func() smithy.Properties {
																var out smithy.Properties
																smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																	{
																		SchemeID: "aws.auth#sigv4",
																		SignerProperties: func() smithy.Properties {
																			var sp smithy.Properties
																			smithyhttp.SetDisableDoubleEncoding(&sp, true)

																			smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																			smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																			smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																			return sp
																		}(),
																	},
																})
																return out
															}(),
														}, nil
													}
												}
												return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
											}
											uriString := func() string {
												var out strings.Builder
												out.WriteString("https://")
												out.WriteString(_Bucket)
												out.WriteString(".ec2.s3-outposts.")
												out.WriteString(_Region)
												out.WriteString(".")
												out.WriteString(_regionPartition.DnsSuffix)
												return out.String()
											}()

											uri, err := url.Parse(uriString)
											if err != nil {
												return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
											}

											return smithyendpoints.Endpoint{
												URI:     *uri,
												Headers: http.Header{},
												Properties: func() smithy.Properties {
													var out smithy.Properties
													smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
														{
															SchemeID: "aws.auth#sigv4",
															SignerProperties: func() smithy.Properties {
																var sp smithy.Properties
																smithyhttp.SetDisableDoubleEncoding(&sp, true)

																smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																return sp
															}(),
														},
													})
													return out
												}(),
											}, nil
										}
										if _hardwareType == "o" {
											if _regionPrefix == "beta" {
												if !(params.Endpoint != nil) {
													return endpoint, fmt.Errorf("endpoint rule error, %s", "Expected a endpoint to be specified but no endpoint was found")
												}
												if exprVal := params.Endpoint; exprVal != nil {
													_Endpoint := *exprVal
													_ = _Endpoint
													if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
														_url := *exprVal
														_ = _url
														uriString := func() string {
															var out strings.Builder
															out.WriteString("https://")
															out.WriteString(_Bucket)
															out.WriteString(".op-")
															out.WriteString(_outpostId)
															out.WriteString(".")
															out.WriteString(_url.Authority)
															return out.String()
														}()

														uri, err := url.Parse(uriString)
														if err != nil {
															return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
														}

														return smithyendpoints.Endpoint{
															URI:     *uri,
															Headers: http.Header{},
															Properties: func() smithy.Properties {
																var out smithy.Properties
																smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																	{
																		SchemeID: "aws.auth#sigv4",
																		SignerProperties: func() smithy.Properties {
																			var sp smithy.Properties
																			smithyhttp.SetDisableDoubleEncoding(&sp, true)

																			smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																			smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																			smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																			return sp
																		}(),
																	},
																})
																return out
															}(),
														}, nil
													}
												}
												return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
											}
											uriString := func() string {
												var out strings.Builder
												out.WriteString("https://")
												out.WriteString(_Bucket)
												out.WriteString(".op-")
												out.WriteString(_outpostId)
												out.WriteString(".s3-outposts.")
												out.WriteString(_Region)
												out.WriteString(".")
												out.WriteString(_regionPartition.DnsSuffix)
												return out.String()
											}()

											uri, err := url.Parse(uriString)
											if err != nil {
												return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
											}

											return smithyendpoints.Endpoint{
												URI:     *uri,
												Headers: http.Header{},
												Properties: func() smithy.Properties {
													var out smithy.Properties
													smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
														{
															SchemeID: "aws.auth#sigv4",
															SignerProperties: func() smithy.Properties {
																var sp smithy.Properties
																smithyhttp.SetDisableDoubleEncoding(&sp, true)

																smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																return sp
															}(),
														},
													})
													return out
												}(),
											}, nil
										}
										return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
											var out strings.Builder
											out.WriteString("Unrecognized hardware type: \"Expected hardware type o or e but got ")
											out.WriteString(_hardwareType)
											out.WriteString("\"")
											return out.String()
										}())
									}
									return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`.")
								}
							}
						}
					}
				}
			}
		}
		if exprVal := params.Bucket; exprVal != nil {
			_Bucket := *exprVal
			_ = _Bucket
			if exprVal := params.Endpoint; exprVal != nil {
				_Endpoint := *exprVal
				_ = _Endpoint
				if !(rulesfn.ParseURL(_Endpoint) != nil) {
					return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
						var out strings.Builder
						out.WriteString("Custom endpoint `")
						out.WriteString(_Endpoint)
						out.WriteString("` was not a valid URI")
						return out.String()
					}())
				}
			}
			if _ForcePathStyle == false {
				if awsrulesfn.IsVirtualHostableS3Bucket(_Bucket, false) {
					if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
						_partitionResult := *exprVal
						_ = _partitionResult
						if rulesfn.IsValidHostLabel(_Region, false) {
							if _Accelerate == true {
								if _partitionResult.Name == "aws-cn" {
									return endpoint, fmt.Errorf("endpoint rule error, %s", "S3 Accelerate cannot be used in this region")
								}
							}
							if _UseDualStack == true {
								if _UseFIPS == true {
									if _Accelerate == false {
										if !(params.Endpoint != nil) {
											if _Region == "aws-global" {
												uriString := func() string {
													var out strings.Builder
													out.WriteString("https://")
													out.WriteString(_Bucket)
													out.WriteString(".s3-fips.dualstack.us-east-1.")
													out.WriteString(_partitionResult.DnsSuffix)
													return out.String()
												}()

												uri, err := url.Parse(uriString)
												if err != nil {
													return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
												}

												return smithyendpoints.Endpoint{
													URI:     *uri,
													Headers: http.Header{},
													Properties: func() smithy.Properties {
														var out smithy.Properties
														smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
															{
																SchemeID: "aws.auth#sigv4",
																SignerProperties: func() smithy.Properties {
																	var sp smithy.Properties
																	smithyhttp.SetDisableDoubleEncoding(&sp, true)

																	smithyhttp.SetSigV4SigningName(&sp, "s3")
																	smithyhttp.SetSigV4ASigningName(&sp, "s3")

																	smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
																	return sp
																}(),
															},
														})
														return out
													}(),
												}, nil
											}
										}
									}
								}
							}
							if _UseDualStack == true {
								if _UseFIPS == true {
									if _Accelerate == false {
										if !(params.Endpoint != nil) {
											if !(_Region == "aws-global") {
												if _UseGlobalEndpoint == true {
													uriString := func() string {
														var out strings.Builder
														out.WriteString("https://")
														out.WriteString(_Bucket)
														out.WriteString(".s3-fips.dualstack.")
														out.WriteString(_Region)
														out.WriteString(".")
														out.WriteString(_partitionResult.DnsSuffix)
														return out.String()
													}()

													uri, err := url.Parse(uriString)
													if err != nil {
														return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
													}

													return smithyendpoints.Endpoint{
														URI:     *uri,
														Headers: http.Header{},
														Properties: func() smithy.Properties {
															var out smithy.Properties
															smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																{
																	SchemeID: "aws.auth#sigv4",
																	SignerProperties: func() smithy.Properties {
																		var sp smithy.Properties
																		smithyhttp.SetDisableDoubleEncoding(&sp, true)

																		smithyhttp.SetSigV4SigningName(&sp, "s3")
																		smithyhttp.SetSigV4ASigningName(&sp, "s3")

																		smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																		return sp
																	}(),
																},
															})
															return out
														}(),
													}, nil
												}
											}
										}
									}
								}
							}
							if _UseDualStack == true {
								if _UseFIPS == true {
									if _Accelerate == false {
										if !(params.Endpoint != nil) {
											if !(_Region == "aws-global") {
												if _UseGlobalEndpoint == false {
													uriString := func() string {
														var out strings.Builder
														out.WriteString("https://")
														out.WriteString(_Bucket)
														out.WriteString(".s3-fips.dualstack.")
														out.WriteString(_Region)
														out.WriteString(".")
														out.WriteString(_partitionResult.DnsSuffix)
														return out.String()
													}()

													uri, err := url.Parse(uriString)
													if err != nil {
														return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
													}

													return smithyendpoints.Endpoint{
														URI:     *uri,
														Headers: http.Header{},
														Properties: func() smithy.Properties {
															var out smithy.Properties
															smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																{
																	SchemeID: "aws.auth#sigv4",
																	SignerProperties: func() smithy.Properties {
																		var sp smithy.Properties
																		smithyhttp.SetDisableDoubleEncoding(&sp, true)

																		smithyhttp.SetSigV4SigningName(&sp, "s3")
																		smithyhttp.SetSigV4ASigningName(&sp, "s3")

																		smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																		return sp
																	}(),
																},
															})
															return out
														}(),
													}, nil
												}
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == true {
									if _Accelerate == false {
										if !(params.Endpoint != nil) {
											if _Region == "aws-global" {
												uriString := func() string {
													var out strings.Builder
													out.WriteString("https://")
													out.WriteString(_Bucket)
													out.WriteString(".s3-fips.us-east-1.")
													out.WriteString(_partitionResult.DnsSuffix)
													return out.String()
												}()

												uri, err := url.Parse(uriString)
												if err != nil {
													return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
												}

												return smithyendpoints.Endpoint{
													URI:     *uri,
													Headers: http.Header{},
													Properties: func() smithy.Properties {
														var out smithy.Properties
														smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
															{
																SchemeID: "aws.auth#sigv4",
																SignerProperties: func() smithy.Properties {
																	var sp smithy.Properties
																	smithyhttp.SetDisableDoubleEncoding(&sp, true)

																	smithyhttp.SetSigV4SigningName(&sp, "s3")
																	smithyhttp.SetSigV4ASigningName(&sp, "s3")

																	smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
																	return sp
																}(),
															},
														})
														return out
													}(),
												}, nil
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == true {
									if _Accelerate == false {
										if !(params.Endpoint != nil) {
											if !(_Region == "aws-global") {
												if _UseGlobalEndpoint == true {
													uriString := func() string {
														var out strings.Builder
														out.WriteString("https://")
														out.WriteString(_Bucket)
														out.WriteString(".s3-fips.")
														out.WriteString(_Region)
														out.WriteString(".")
														out.WriteString(_partitionResult.DnsSuffix)
														return out.String()
													}()

													uri, err := url.Parse(uriString)
													if err != nil {
														return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
													}

													return smithyendpoints.Endpoint{
														URI:     *uri,
														Headers: http.Header{},
														Properties: func() smithy.Properties {
															var out smithy.Properties
															smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																{
																	SchemeID: "aws.auth#sigv4",
																	SignerProperties: func() smithy.Properties {
																		var sp smithy.Properties
																		smithyhttp.SetDisableDoubleEncoding(&sp, true)

																		smithyhttp.SetSigV4SigningName(&sp, "s3")
																		smithyhttp.SetSigV4ASigningName(&sp, "s3")

																		smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																		return sp
																	}(),
																},
															})
															return out
														}(),
													}, nil
												}
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == true {
									if _Accelerate == false {
										if !(params.Endpoint != nil) {
											if !(_Region == "aws-global") {
												if _UseGlobalEndpoint == false {
													uriString := func() string {
														var out strings.Builder
														out.WriteString("https://")
														out.WriteString(_Bucket)
														out.WriteString(".s3-fips.")
														out.WriteString(_Region)
														out.WriteString(".")
														out.WriteString(_partitionResult.DnsSuffix)
														return out.String()
													}()

													uri, err := url.Parse(uriString)
													if err != nil {
														return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
													}

													return smithyendpoints.Endpoint{
														URI:     *uri,
														Headers: http.Header{},
														Properties: func() smithy.Properties {
															var out smithy.Properties
															smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																{
																	SchemeID: "aws.auth#sigv4",
																	SignerProperties: func() smithy.Properties {
																		var sp smithy.Properties
																		smithyhttp.SetDisableDoubleEncoding(&sp, true)

																		smithyhttp.SetSigV4SigningName(&sp, "s3")
																		smithyhttp.SetSigV4ASigningName(&sp, "s3")

																		smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																		return sp
																	}(),
																},
															})
															return out
														}(),
													}, nil
												}
											}
										}
									}
								}
							}
							if _UseDualStack == true {
								if _UseFIPS == false {
									if _Accelerate == true {
										if !(params.Endpoint != nil) {
											if _Region == "aws-global" {
												uriString := func() string {
													var out strings.Builder
													out.WriteString("https://")
													out.WriteString(_Bucket)
													out.WriteString(".s3-accelerate.dualstack.us-east-1.")
													out.WriteString(_partitionResult.DnsSuffix)
													return out.String()
												}()

												uri, err := url.Parse(uriString)
												if err != nil {
													return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
												}

												return smithyendpoints.Endpoint{
													URI:     *uri,
													Headers: http.Header{},
													Properties: func() smithy.Properties {
														var out smithy.Properties
														smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
															{
																SchemeID: "aws.auth#sigv4",
																SignerProperties: func() smithy.Properties {
																	var sp smithy.Properties
																	smithyhttp.SetDisableDoubleEncoding(&sp, true)

																	smithyhttp.SetSigV4SigningName(&sp, "s3")
																	smithyhttp.SetSigV4ASigningName(&sp, "s3")

																	smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
																	return sp
																}(),
															},
														})
														return out
													}(),
												}, nil
											}
										}
									}
								}
							}
							if _UseDualStack == true {
								if _UseFIPS == false {
									if _Accelerate == true {
										if !(params.Endpoint != nil) {
											if !(_Region == "aws-global") {
												if _UseGlobalEndpoint == true {
													uriString := func() string {
														var out strings.Builder
														out.WriteString("https://")
														out.WriteString(_Bucket)
														out.WriteString(".s3-accelerate.dualstack.")
														out.WriteString(_partitionResult.DnsSuffix)
														return out.String()
													}()

													uri, err := url.Parse(uriString)
													if err != nil {
														return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
													}

													return smithyendpoints.Endpoint{
														URI:     *uri,
														Headers: http.Header{},
														Properties: func() smithy.Properties {
															var out smithy.Properties
															smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																{
																	SchemeID: "aws.auth#sigv4",
																	SignerProperties: func() smithy.Properties {
																		var sp smithy.Properties
																		smithyhttp.SetDisableDoubleEncoding(&sp, true)

																		smithyhttp.SetSigV4SigningName(&sp, "s3")
																		smithyhttp.SetSigV4ASigningName(&sp, "s3")

																		smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																		return sp
																	}(),
																},
															})
															return out
														}(),
													}, nil
												}
											}
										}
									}
								}
							}
							if _UseDualStack == true {
								if _UseFIPS == false {
									if _Accelerate == true {
										if !(params.Endpoint != nil) {
											if !(_Region == "aws-global") {
												if _UseGlobalEndpoint == false {
													uriString := func() string {
														var out strings.Builder
														out.WriteString("https://")
														out.WriteString(_Bucket)
														out.WriteString(".s3-accelerate.dualstack.")
														out.WriteString(_partitionResult.DnsSuffix)
														return out.String()
													}()

													uri, err := url.Parse(uriString)
													if err != nil {
														return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
													}

													return smithyendpoints.Endpoint{
														URI:     *uri,
														Headers: http.Header{},
														Properties: func() smithy.Properties {
															var out smithy.Properties
															smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																{
																	SchemeID: "aws.auth#sigv4",
																	SignerProperties: func() smithy.Properties {
																		var sp smithy.Properties
																		smithyhttp.SetDisableDoubleEncoding(&sp, true)

																		smithyhttp.SetSigV4SigningName(&sp, "s3")
																		smithyhttp.SetSigV4ASigningName(&sp, "s3")

																		smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																		return sp
																	}(),
																},
															})
															return out
														}(),
													}, nil
												}
											}
										}
									}
								}
							}
							if _UseDualStack == true {
								if _UseFIPS == false {
									if _Accelerate == false {
										if !(params.Endpoint != nil) {
											if _Region == "aws-global" {
												uriString := func() string {
													var out strings.Builder
													out.WriteString("https://")
													out.WriteString(_Bucket)
													out.WriteString(".s3.dualstack.us-east-1.")
													out.WriteString(_partitionResult.DnsSuffix)
													return out.String()
												}()

												uri, err := url.Parse(uriString)
												if err != nil {
													return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
												}

												return smithyendpoints.Endpoint{
													URI:     *uri,
													Headers: http.Header{},
													Properties: func() smithy.Properties {
														var out smithy.Properties
														smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
															{
																SchemeID: "aws.auth#sigv4",
																SignerProperties: func() smithy.Properties {
																	var sp smithy.Properties
																	smithyhttp.SetDisableDoubleEncoding(&sp, true)

																	smithyhttp.SetSigV4SigningName(&sp, "s3")
																	smithyhttp.SetSigV4ASigningName(&sp, "s3")

																	smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
																	return sp
																}(),
															},
														})
														return out
													}(),
												}, nil
											}
										}
									}
								}
							}
							if _UseDualStack == true {
								if _UseFIPS == false {
									if _Accelerate == false {
										if !(params.Endpoint != nil) {
											if !(_Region == "aws-global") {
												if _UseGlobalEndpoint == true {
													uriString := func() string {
														var out strings.Builder
														out.WriteString("https://")
														out.WriteString(_Bucket)
														out.WriteString(".s3.dualstack.")
														out.WriteString(_Region)
														out.WriteString(".")
														out.WriteString(_partitionResult.DnsSuffix)
														return out.String()
													}()

													uri, err := url.Parse(uriString)
													if err != nil {
														return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
													}

													return smithyendpoints.Endpoint{
														URI:     *uri,
														Headers: http.Header{},
														Properties: func() smithy.Properties {
															var out smithy.Properties
															smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																{
																	SchemeID: "aws.auth#sigv4",
																	SignerProperties: func() smithy.Properties {
																		var sp smithy.Properties
																		smithyhttp.SetDisableDoubleEncoding(&sp, true)

																		smithyhttp.SetSigV4SigningName(&sp, "s3")
																		smithyhttp.SetSigV4ASigningName(&sp, "s3")

																		smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																		return sp
																	}(),
																},
															})
															return out
														}(),
													}, nil
												}
											}
										}
									}
								}
							}
							if _UseDualStack == true {
								if _UseFIPS == false {
									if _Accelerate == false {
										if !(params.Endpoint != nil) {
											if !(_Region == "aws-global") {
												if _UseGlobalEndpoint == false {
													uriString := func() string {
														var out strings.Builder
														out.WriteString("https://")
														out.WriteString(_Bucket)
														out.WriteString(".s3.dualstack.")
														out.WriteString(_Region)
														out.WriteString(".")
														out.WriteString(_partitionResult.DnsSuffix)
														return out.String()
													}()

													uri, err := url.Parse(uriString)
													if err != nil {
														return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
													}

													return smithyendpoints.Endpoint{
														URI:     *uri,
														Headers: http.Header{},
														Properties: func() smithy.Properties {
															var out smithy.Properties
															smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																{
																	SchemeID: "aws.auth#sigv4",
																	SignerProperties: func() smithy.Properties {
																		var sp smithy.Properties
																		smithyhttp.SetDisableDoubleEncoding(&sp, true)

																		smithyhttp.SetSigV4SigningName(&sp, "s3")
																		smithyhttp.SetSigV4ASigningName(&sp, "s3")

																		smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																		return sp
																	}(),
																},
															})
															return out
														}(),
													}, nil
												}
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == false {
									if _Accelerate == false {
										if exprVal := params.Endpoint; exprVal != nil {
											_Endpoint := *exprVal
											_ = _Endpoint
											if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
												_url := *exprVal
												_ = _url
												if _url.IsIp == true {
													if _Region == "aws-global" {
														uriString := func() string {
															var out strings.Builder
															out.WriteString(_url.Scheme)
															out.WriteString("://")
															out.WriteString(_url.Authority)
															out.WriteString(_url.NormalizedPath)
															out.WriteString(_Bucket)
															return out.String()
														}()

														uri, err := url.Parse(uriString)
														if err != nil {
															return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
														}

														return smithyendpoints.Endpoint{
															URI:     *uri,
															Headers: http.Header{},
															Properties: func() smithy.Properties {
																var out smithy.Properties
																smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																	{
																		SchemeID: "aws.auth#sigv4",
																		SignerProperties: func() smithy.Properties {
																			var sp smithy.Properties
																			smithyhttp.SetDisableDoubleEncoding(&sp, true)

																			smithyhttp.SetSigV4SigningName(&sp, "s3")
																			smithyhttp.SetSigV4ASigningName(&sp, "s3")

																			smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
																			return sp
																		}(),
																	},
																})
																return out
															}(),
														}, nil
													}
												}
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == false {
									if _Accelerate == false {
										if exprVal := params.Endpoint; exprVal != nil {
											_Endpoint := *exprVal
											_ = _Endpoint
											if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
												_url := *exprVal
												_ = _url
												if _url.IsIp == false {
													if _Region == "aws-global" {
														uriString := func() string {
															var out strings.Builder
															out.WriteString(_url.Scheme)
															out.WriteString("://")
															out.WriteString(_Bucket)
															out.WriteString(".")
															out.WriteString(_url.Authority)
															out.WriteString(_url.Path)
															return out.String()
														}()

														uri, err := url.Parse(uriString)
														if err != nil {
															return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
														}

														return smithyendpoints.Endpoint{
															URI:     *uri,
															Headers: http.Header{},
															Properties: func() smithy.Properties {
																var out smithy.Properties
																smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																	{
																		SchemeID: "aws.auth#sigv4",
																		SignerProperties: func() smithy.Properties {
																			var sp smithy.Properties
																			smithyhttp.SetDisableDoubleEncoding(&sp, true)

																			smithyhttp.SetSigV4SigningName(&sp, "s3")
																			smithyhttp.SetSigV4ASigningName(&sp, "s3")

																			smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
																			return sp
																		}(),
																	},
																})
																return out
															}(),
														}, nil
													}
												}
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == false {
									if _Accelerate == false {
										if exprVal := params.Endpoint; exprVal != nil {
											_Endpoint := *exprVal
											_ = _Endpoint
											if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
												_url := *exprVal
												_ = _url
												if _url.IsIp == true {
													if !(_Region == "aws-global") {
														if _UseGlobalEndpoint == true {
															if _Region == "us-east-1" {
																uriString := func() string {
																	var out strings.Builder
																	out.WriteString(_url.Scheme)
																	out.WriteString("://")
																	out.WriteString(_url.Authority)
																	out.WriteString(_url.NormalizedPath)
																	out.WriteString(_Bucket)
																	return out.String()
																}()

																uri, err := url.Parse(uriString)
																if err != nil {
																	return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																}

																return smithyendpoints.Endpoint{
																	URI:     *uri,
																	Headers: http.Header{},
																	Properties: func() smithy.Properties {
																		var out smithy.Properties
																		smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																			{
																				SchemeID: "aws.auth#sigv4",
																				SignerProperties: func() smithy.Properties {
																					var sp smithy.Properties
																					smithyhttp.SetDisableDoubleEncoding(&sp, true)

																					smithyhttp.SetSigV4SigningName(&sp, "s3")
																					smithyhttp.SetSigV4ASigningName(&sp, "s3")

																					smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																					return sp
																				}(),
																			},
																		})
																		return out
																	}(),
																}, nil
															}
															uriString := func() string {
																var out strings.Builder
																out.WriteString(_url.Scheme)
																out.WriteString("://")
																out.WriteString(_url.Authority)
																out.WriteString(_url.NormalizedPath)
																out.WriteString(_Bucket)
																return out.String()
															}()

															uri, err := url.Parse(uriString)
															if err != nil {
																return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
															}

															return smithyendpoints.Endpoint{
																URI:     *uri,
																Headers: http.Header{},
																Properties: func() smithy.Properties {
																	var out smithy.Properties
																	smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																		{
																			SchemeID: "aws.auth#sigv4",
																			SignerProperties: func() smithy.Properties {
																				var sp smithy.Properties
																				smithyhttp.SetDisableDoubleEncoding(&sp, true)

																				smithyhttp.SetSigV4SigningName(&sp, "s3")
																				smithyhttp.SetSigV4ASigningName(&sp, "s3")

																				smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																				return sp
																			}(),
																		},
																	})
																	return out
																}(),
															}, nil
														}
													}
												}
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == false {
									if _Accelerate == false {
										if exprVal := params.Endpoint; exprVal != nil {
											_Endpoint := *exprVal
											_ = _Endpoint
											if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
												_url := *exprVal
												_ = _url
												if _url.IsIp == false {
													if !(_Region == "aws-global") {
														if _UseGlobalEndpoint == true {
															if _Region == "us-east-1" {
																uriString := func() string {
																	var out strings.Builder
																	out.WriteString(_url.Scheme)
																	out.WriteString("://")
																	out.WriteString(_Bucket)
																	out.WriteString(".")
																	out.WriteString(_url.Authority)
																	out.WriteString(_url.Path)
																	return out.String()
																}()

																uri, err := url.Parse(uriString)
																if err != nil {
																	return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																}

																return smithyendpoints.Endpoint{
																	URI:     *uri,
																	Headers: http.Header{},
																	Properties: func() smithy.Properties {
																		var out smithy.Properties
																		smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																			{
																				SchemeID: "aws.auth#sigv4",
																				SignerProperties: func() smithy.Properties {
																					var sp smithy.Properties
																					smithyhttp.SetDisableDoubleEncoding(&sp, true)

																					smithyhttp.SetSigV4SigningName(&sp, "s3")
																					smithyhttp.SetSigV4ASigningName(&sp, "s3")

																					smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																					return sp
																				}(),
																			},
																		})
																		return out
																	}(),
																}, nil
															}
															uriString := func() string {
																var out strings.Builder
																out.WriteString(_url.Scheme)
																out.WriteString("://")
																out.WriteString(_Bucket)
																out.WriteString(".")
																out.WriteString(_url.Authority)
																out.WriteString(_url.Path)
																return out.String()
															}()

															uri, err := url.Parse(uriString)
															if err != nil {
																return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
															}

															return smithyendpoints.Endpoint{
																URI:     *uri,
																Headers: http.Header{},
																Properties: func() smithy.Properties {
																	var out smithy.Properties
																	smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																		{
																			SchemeID: "aws.auth#sigv4",
																			SignerProperties: func() smithy.Properties {
																				var sp smithy.Properties
																				smithyhttp.SetDisableDoubleEncoding(&sp, true)

																				smithyhttp.SetSigV4SigningName(&sp, "s3")
																				smithyhttp.SetSigV4ASigningName(&sp, "s3")

																				smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																				return sp
																			}(),
																		},
																	})
																	return out
																}(),
															}, nil
														}
													}
												}
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == false {
									if _Accelerate == false {
										if exprVal := params.Endpoint; exprVal != nil {
											_Endpoint := *exprVal
											_ = _Endpoint
											if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
												_url := *exprVal
												_ = _url
												if _url.IsIp == true {
													if !(_Region == "aws-global") {
														if _UseGlobalEndpoint == false {
															uriString := func() string {
																var out strings.Builder
																out.WriteString(_url.Scheme)
																out.WriteString("://")
																out.WriteString(_url.Authority)
																out.WriteString(_url.NormalizedPath)
																out.WriteString(_Bucket)
																return out.String()
															}()

															uri, err := url.Parse(uriString)
															if err != nil {
																return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
															}

															return smithyendpoints.Endpoint{
																URI:     *uri,
																Headers: http.Header{},
																Properties: func() smithy.Properties {
																	var out smithy.Properties
																	smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																		{
																			SchemeID: "aws.auth#sigv4",
																			SignerProperties: func() smithy.Properties {
																				var sp smithy.Properties
																				smithyhttp.SetDisableDoubleEncoding(&sp, true)

																				smithyhttp.SetSigV4SigningName(&sp, "s3")
																				smithyhttp.SetSigV4ASigningName(&sp, "s3")

																				smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																				return sp
																			}(),
																		},
																	})
																	return out
																}(),
															}, nil
														}
													}
												}
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == false {
									if _Accelerate == false {
										if exprVal := params.Endpoint; exprVal != nil {
											_Endpoint := *exprVal
											_ = _Endpoint
											if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
												_url := *exprVal
												_ = _url
												if _url.IsIp == false {
													if !(_Region == "aws-global") {
														if _UseGlobalEndpoint == false {
															uriString := func() string {
																var out strings.Builder
																out.WriteString(_url.Scheme)
																out.WriteString("://")
																out.WriteString(_Bucket)
																out.WriteString(".")
																out.WriteString(_url.Authority)
																out.WriteString(_url.Path)
																return out.String()
															}()

															uri, err := url.Parse(uriString)
															if err != nil {
																return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
															}

															return smithyendpoints.Endpoint{
																URI:     *uri,
																Headers: http.Header{},
																Properties: func() smithy.Properties {
																	var out smithy.Properties
																	smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																		{
																			SchemeID: "aws.auth#sigv4",
																			SignerProperties: func() smithy.Properties {
																				var sp smithy.Properties
																				smithyhttp.SetDisableDoubleEncoding(&sp, true)

																				smithyhttp.SetSigV4SigningName(&sp, "s3")
																				smithyhttp.SetSigV4ASigningName(&sp, "s3")

																				smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																				return sp
																			}(),
																		},
																	})
																	return out
																}(),
															}, nil
														}
													}
												}
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == false {
									if _Accelerate == true {
										if !(params.Endpoint != nil) {
											if _Region == "aws-global" {
												uriString := func() string {
													var out strings.Builder
													out.WriteString("https://")
													out.WriteString(_Bucket)
													out.WriteString(".s3-accelerate.")
													out.WriteString(_partitionResult.DnsSuffix)
													return out.String()
												}()

												uri, err := url.Parse(uriString)
												if err != nil {
													return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
												}

												return smithyendpoints.Endpoint{
													URI:     *uri,
													Headers: http.Header{},
													Properties: func() smithy.Properties {
														var out smithy.Properties
														smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
															{
																SchemeID: "aws.auth#sigv4",
																SignerProperties: func() smithy.Properties {
																	var sp smithy.Properties
																	smithyhttp.SetDisableDoubleEncoding(&sp, true)

																	smithyhttp.SetSigV4SigningName(&sp, "s3")
																	smithyhttp.SetSigV4ASigningName(&sp, "s3")

																	smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
																	return sp
																}(),
															},
														})
														return out
													}(),
												}, nil
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == false {
									if _Accelerate == true {
										if !(params.Endpoint != nil) {
											if !(_Region == "aws-global") {
												if _UseGlobalEndpoint == true {
													if _Region == "us-east-1" {
														uriString := func() string {
															var out strings.Builder
															out.WriteString("https://")
															out.WriteString(_Bucket)
															out.WriteString(".s3-accelerate.")
															out.WriteString(_partitionResult.DnsSuffix)
															return out.String()
														}()

														uri, err := url.Parse(uriString)
														if err != nil {
															return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
														}

														return smithyendpoints.Endpoint{
															URI:     *uri,
															Headers: http.Header{},
															Properties: func() smithy.Properties {
																var out smithy.Properties
																smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																	{
																		SchemeID: "aws.auth#sigv4",
																		SignerProperties: func() smithy.Properties {
																			var sp smithy.Properties
																			smithyhttp.SetDisableDoubleEncoding(&sp, true)

																			smithyhttp.SetSigV4SigningName(&sp, "s3")
																			smithyhttp.SetSigV4ASigningName(&sp, "s3")

																			smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																			return sp
																		}(),
																	},
																})
																return out
															}(),
														}, nil
													}
													uriString := func() string {
														var out strings.Builder
														out.WriteString("https://")
														out.WriteString(_Bucket)
														out.WriteString(".s3-accelerate.")
														out.WriteString(_partitionResult.DnsSuffix)
														return out.String()
													}()

													uri, err := url.Parse(uriString)
													if err != nil {
														return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
													}

													return smithyendpoints.Endpoint{
														URI:     *uri,
														Headers: http.Header{},
														Properties: func() smithy.Properties {
															var out smithy.Properties
															smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																{
																	SchemeID: "aws.auth#sigv4",
																	SignerProperties: func() smithy.Properties {
																		var sp smithy.Properties
																		smithyhttp.SetDisableDoubleEncoding(&sp, true)

																		smithyhttp.SetSigV4SigningName(&sp, "s3")
																		smithyhttp.SetSigV4ASigningName(&sp, "s3")

																		smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																		return sp
																	}(),
																},
															})
															return out
														}(),
													}, nil
												}
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == false {
									if _Accelerate == true {
										if !(params.Endpoint != nil) {
											if !(_Region == "aws-global") {
												if _UseGlobalEndpoint == false {
													uriString := func() string {
														var out strings.Builder
														out.WriteString("https://")
														out.WriteString(_Bucket)
														out.WriteString(".s3-accelerate.")
														out.WriteString(_partitionResult.DnsSuffix)
														return out.String()
													}()

													uri, err := url.Parse(uriString)
													if err != nil {
														return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
													}

													return smithyendpoints.Endpoint{
														URI:     *uri,
														Headers: http.Header{},
														Properties: func() smithy.Properties {
															var out smithy.Properties
															smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																{
																	SchemeID: "aws.auth#sigv4",
																	SignerProperties: func() smithy.Properties {
																		var sp smithy.Properties
																		smithyhttp.SetDisableDoubleEncoding(&sp, true)

																		smithyhttp.SetSigV4SigningName(&sp, "s3")
																		smithyhttp.SetSigV4ASigningName(&sp, "s3")

																		smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																		return sp
																	}(),
																},
															})
															return out
														}(),
													}, nil
												}
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == false {
									if _Accelerate == false {
										if !(params.Endpoint != nil) {
											if _Region == "aws-global" {
												uriString := func() string {
													var out strings.Builder
													out.WriteString("https://")
													out.WriteString(_Bucket)
													out.WriteString(".s3.")
													out.WriteString(_partitionResult.DnsSuffix)
													return out.String()
												}()

												uri, err := url.Parse(uriString)
												if err != nil {
													return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
												}

												return smithyendpoints.Endpoint{
													URI:     *uri,
													Headers: http.Header{},
													Properties: func() smithy.Properties {
														var out smithy.Properties
														smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
															{
																SchemeID: "aws.auth#sigv4",
																SignerProperties: func() smithy.Properties {
																	var sp smithy.Properties
																	smithyhttp.SetDisableDoubleEncoding(&sp, true)

																	smithyhttp.SetSigV4SigningName(&sp, "s3")
																	smithyhttp.SetSigV4ASigningName(&sp, "s3")

																	smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
																	return sp
																}(),
															},
														})
														return out
													}(),
												}, nil
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == false {
									if _Accelerate == false {
										if !(params.Endpoint != nil) {
											if !(_Region == "aws-global") {
												if _UseGlobalEndpoint == true {
													if _Region == "us-east-1" {
														uriString := func() string {
															var out strings.Builder
															out.WriteString("https://")
															out.WriteString(_Bucket)
															out.WriteString(".s3.")
															out.WriteString(_partitionResult.DnsSuffix)
															return out.String()
														}()

														uri, err := url.Parse(uriString)
														if err != nil {
															return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
														}

														return smithyendpoints.Endpoint{
															URI:     *uri,
															Headers: http.Header{},
															Properties: func() smithy.Properties {
																var out smithy.Properties
																smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																	{
																		SchemeID: "aws.auth#sigv4",
																		SignerProperties: func() smithy.Properties {
																			var sp smithy.Properties
																			smithyhttp.SetDisableDoubleEncoding(&sp, true)

																			smithyhttp.SetSigV4SigningName(&sp, "s3")
																			smithyhttp.SetSigV4ASigningName(&sp, "s3")

																			smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																			return sp
																		}(),
																	},
																})
																return out
															}(),
														}, nil
													}
													uriString := func() string {
														var out strings.Builder
														out.WriteString("https://")
														out.WriteString(_Bucket)
														out.WriteString(".s3.")
														out.WriteString(_Region)
														out.WriteString(".")
														out.WriteString(_partitionResult.DnsSuffix)
														return out.String()
													}()

													uri, err := url.Parse(uriString)
													if err != nil {
														return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
													}

													return smithyendpoints.Endpoint{
														URI:     *uri,
														Headers: http.Header{},
														Properties: func() smithy.Properties {
															var out smithy.Properties
															smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																{
																	SchemeID: "aws.auth#sigv4",
																	SignerProperties: func() smithy.Properties {
																		var sp smithy.Properties
																		smithyhttp.SetDisableDoubleEncoding(&sp, true)

																		smithyhttp.SetSigV4SigningName(&sp, "s3")
																		smithyhttp.SetSigV4ASigningName(&sp, "s3")

																		smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																		return sp
																	}(),
																},
															})
															return out
														}(),
													}, nil
												}
											}
										}
									}
								}
							}
							if _UseDualStack == false {
								if _UseFIPS == false {
									if _Accelerate == false {
										if !(params.Endpoint != nil) {
											if !(_Region == "aws-global") {
												if _UseGlobalEndpoint == false {
													uriString := func() string {
														var out strings.Builder
														out.WriteString("https://")
														out.WriteString(_Bucket)
														out.WriteString(".s3.")
														out.WriteString(_Region)
														out.WriteString(".")
														out.WriteString(_partitionResult.DnsSuffix)
														return out.String()
													}()

													uri, err := url.Parse(uriString)
													if err != nil {
														return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
													}

													return smithyendpoints.Endpoint{
														URI:     *uri,
														Headers: http.Header{},
														Properties: func() smithy.Properties {
															var out smithy.Properties
															smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																{
																	SchemeID: "aws.auth#sigv4",
																	SignerProperties: func() smithy.Properties {
																		var sp smithy.Properties
																		smithyhttp.SetDisableDoubleEncoding(&sp, true)

																		smithyhttp.SetSigV4SigningName(&sp, "s3")
																		smithyhttp.SetSigV4ASigningName(&sp, "s3")

																		smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																		return sp
																	}(),
																},
															})
															return out
														}(),
													}, nil
												}
											}
										}
									}
								}
							}
							return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
						}
						return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid region: region was not a valid DNS name.")
					}
					return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
				}
			}
			if exprVal := params.Endpoint; exprVal != nil {
				_Endpoint := *exprVal
				_ = _Endpoint
				if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
					_url := *exprVal
					_ = _url
					if _url.Scheme == "http" {
						if awsrulesfn.IsVirtualHostableS3Bucket(_Bucket, true) {
							if _ForcePathStyle == false {
								if _UseFIPS == false {
									if _UseDualStack == false {
										if _Accelerate == false {
											if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
												_partitionResult := *exprVal
												_ = _partitionResult
												if rulesfn.IsValidHostLabel(_Region, false) {
													uriString := func() string {
														var out strings.Builder
														out.WriteString(_url.Scheme)
														out.WriteString("://")
														out.WriteString(_Bucket)
														out.WriteString(".")
														out.WriteString(_url.Authority)
														out.WriteString(_url.Path)
														return out.String()
													}()

													uri, err := url.Parse(uriString)
													if err != nil {
														return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
													}

													return smithyendpoints.Endpoint{
														URI:     *uri,
														Headers: http.Header{},
														Properties: func() smithy.Properties {
															var out smithy.Properties
															smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																{
																	SchemeID: "aws.auth#sigv4",
																	SignerProperties: func() smithy.Properties {
																		var sp smithy.Properties
																		smithyhttp.SetDisableDoubleEncoding(&sp, true)

																		smithyhttp.SetSigV4SigningName(&sp, "s3")
																		smithyhttp.SetSigV4ASigningName(&sp, "s3")

																		smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																		return sp
																	}(),
																},
															})
															return out
														}(),
													}, nil
												}
												return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid region: region was not a valid DNS name.")
											}
											return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
										}
									}
								}
							}
						}
					}
				}
			}
			if _ForcePathStyle == false {
				if exprVal := awsrulesfn.ParseARN(_Bucket); exprVal != nil {
					_bucketArn := *exprVal
					_ = _bucketArn
					if exprVal := _bucketArn.ResourceId.Get(0); exprVal != nil {
						_arnType := *exprVal
						_ = _arnType
						if !(_arnType == "") {
							if _bucketArn.Service == "s3-object-lambda" {
								if _arnType == "accesspoint" {
									if exprVal := _bucketArn.ResourceId.Get(1); exprVal != nil {
										_accessPointName := *exprVal
										_ = _accessPointName
										if !(_accessPointName == "") {
											if _UseDualStack == true {
												return endpoint, fmt.Errorf("endpoint rule error, %s", "S3 Object Lambda does not support Dual-stack")
											}
											if _Accelerate == true {
												return endpoint, fmt.Errorf("endpoint rule error, %s", "S3 Object Lambda does not support S3 Accelerate")
											}
											if !(_bucketArn.Region == "") {
												if exprVal := params.DisableAccessPoints; exprVal != nil {
													_DisableAccessPoints := *exprVal
													_ = _DisableAccessPoints
													if _DisableAccessPoints == true {
														return endpoint, fmt.Errorf("endpoint rule error, %s", "Access points are not supported for this operation")
													}
												}
												if !(_bucketArn.ResourceId.Get(2) != nil) {
													if exprVal := params.UseArnRegion; exprVal != nil {
														_UseArnRegion := *exprVal
														_ = _UseArnRegion
														if _UseArnRegion == false {
															if !(_bucketArn.Region == _Region) {
																return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																	var out strings.Builder
																	out.WriteString("Invalid configuration: region from ARN `")
																	out.WriteString(_bucketArn.Region)
																	out.WriteString("` does not match client region `")
																	out.WriteString(_Region)
																	out.WriteString("` and UseArnRegion is `false`")
																	return out.String()
																}())
															}
														}
													}
													if exprVal := awsrulesfn.GetPartition(_bucketArn.Region); exprVal != nil {
														_bucketPartition := *exprVal
														_ = _bucketPartition
														if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
															_partitionResult := *exprVal
															_ = _partitionResult
															if _bucketPartition.Name == _partitionResult.Name {
																if rulesfn.IsValidHostLabel(_bucketArn.Region, true) {
																	if _bucketArn.AccountId == "" {
																		return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: Missing account id")
																	}
																	if rulesfn.IsValidHostLabel(_bucketArn.AccountId, false) {
																		if rulesfn.IsValidHostLabel(_accessPointName, false) {
																			if exprVal := params.Endpoint; exprVal != nil {
																				_Endpoint := *exprVal
																				_ = _Endpoint
																				if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
																					_url := *exprVal
																					_ = _url
																					uriString := func() string {
																						var out strings.Builder
																						out.WriteString(_url.Scheme)
																						out.WriteString("://")
																						out.WriteString(_accessPointName)
																						out.WriteString("-")
																						out.WriteString(_bucketArn.AccountId)
																						out.WriteString(".")
																						out.WriteString(_url.Authority)
																						out.WriteString(_url.Path)
																						return out.String()
																					}()

																					uri, err := url.Parse(uriString)
																					if err != nil {
																						return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																					}

																					return smithyendpoints.Endpoint{
																						URI:     *uri,
																						Headers: http.Header{},
																						Properties: func() smithy.Properties {
																							var out smithy.Properties
																							smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																								{
																									SchemeID: "aws.auth#sigv4",
																									SignerProperties: func() smithy.Properties {
																										var sp smithy.Properties
																										smithyhttp.SetDisableDoubleEncoding(&sp, true)

																										smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
																										smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

																										smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																										return sp
																									}(),
																								},
																							})
																							return out
																						}(),
																					}, nil
																				}
																			}
																			if _UseFIPS == true {
																				uriString := func() string {
																					var out strings.Builder
																					out.WriteString("https://")
																					out.WriteString(_accessPointName)
																					out.WriteString("-")
																					out.WriteString(_bucketArn.AccountId)
																					out.WriteString(".s3-object-lambda-fips.")
																					out.WriteString(_bucketArn.Region)
																					out.WriteString(".")
																					out.WriteString(_bucketPartition.DnsSuffix)
																					return out.String()
																				}()

																				uri, err := url.Parse(uriString)
																				if err != nil {
																					return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																				}

																				return smithyendpoints.Endpoint{
																					URI:     *uri,
																					Headers: http.Header{},
																					Properties: func() smithy.Properties {
																						var out smithy.Properties
																						smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																							{
																								SchemeID: "aws.auth#sigv4",
																								SignerProperties: func() smithy.Properties {
																									var sp smithy.Properties
																									smithyhttp.SetDisableDoubleEncoding(&sp, true)

																									smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
																									smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

																									smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																									return sp
																								}(),
																							},
																						})
																						return out
																					}(),
																				}, nil
																			}
																			uriString := func() string {
																				var out strings.Builder
																				out.WriteString("https://")
																				out.WriteString(_accessPointName)
																				out.WriteString("-")
																				out.WriteString(_bucketArn.AccountId)
																				out.WriteString(".s3-object-lambda.")
																				out.WriteString(_bucketArn.Region)
																				out.WriteString(".")
																				out.WriteString(_bucketPartition.DnsSuffix)
																				return out.String()
																			}()

																			uri, err := url.Parse(uriString)
																			if err != nil {
																				return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																			}

																			return smithyendpoints.Endpoint{
																				URI:     *uri,
																				Headers: http.Header{},
																				Properties: func() smithy.Properties {
																					var out smithy.Properties
																					smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																						{
																							SchemeID: "aws.auth#sigv4",
																							SignerProperties: func() smithy.Properties {
																								var sp smithy.Properties
																								smithyhttp.SetDisableDoubleEncoding(&sp, true)

																								smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
																								smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

																								smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																								return sp
																							}(),
																						},
																					})
																					return out
																				}(),
																			}, nil
																		}
																		return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																			var out strings.Builder
																			out.WriteString("Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `")
																			out.WriteString(_accessPointName)
																			out.WriteString("`")
																			return out.String()
																		}())
																	}
																	return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																		var out strings.Builder
																		out.WriteString("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `")
																		out.WriteString(_bucketArn.AccountId)
																		out.WriteString("`")
																		return out.String()
																	}())
																}
																return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																	var out strings.Builder
																	out.WriteString("Invalid region in ARN: `")
																	out.WriteString(_bucketArn.Region)
																	out.WriteString("` (invalid DNS name)")
																	return out.String()
																}())
															}
															return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																var out strings.Builder
																out.WriteString("Client was configured for partition `")
																out.WriteString(_partitionResult.Name)
																out.WriteString("` but ARN (`")
																out.WriteString(_Bucket)
																out.WriteString("`) has `")
																out.WriteString(_bucketPartition.Name)
																out.WriteString("`")
																return out.String()
															}())
														}
														return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
													}
													return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
												}
												return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: The ARN may only contain a single resource component after `accesspoint`.")
											}
											return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: bucket ARN is missing a region")
										}
									}
									return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided")
								}
								return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
									var out strings.Builder
									out.WriteString("Invalid ARN: Object Lambda ARNs only support `accesspoint` arn types, but found: `")
									out.WriteString(_arnType)
									out.WriteString("`")
									return out.String()
								}())
							}
							if _arnType == "accesspoint" {
								if exprVal := _bucketArn.ResourceId.Get(1); exprVal != nil {
									_accessPointName := *exprVal
									_ = _accessPointName
									if !(_accessPointName == "") {
										if !(_bucketArn.Region == "") {
											if _arnType == "accesspoint" {
												if !(_bucketArn.Region == "") {
													if exprVal := params.DisableAccessPoints; exprVal != nil {
														_DisableAccessPoints := *exprVal
														_ = _DisableAccessPoints
														if _DisableAccessPoints == true {
															return endpoint, fmt.Errorf("endpoint rule error, %s", "Access points are not supported for this operation")
														}
													}
													if !(_bucketArn.ResourceId.Get(2) != nil) {
														if exprVal := params.UseArnRegion; exprVal != nil {
															_UseArnRegion := *exprVal
															_ = _UseArnRegion
															if _UseArnRegion == false {
																if !(_bucketArn.Region == _Region) {
																	return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																		var out strings.Builder
																		out.WriteString("Invalid configuration: region from ARN `")
																		out.WriteString(_bucketArn.Region)
																		out.WriteString("` does not match client region `")
																		out.WriteString(_Region)
																		out.WriteString("` and UseArnRegion is `false`")
																		return out.String()
																	}())
																}
															}
														}
														if exprVal := awsrulesfn.GetPartition(_bucketArn.Region); exprVal != nil {
															_bucketPartition := *exprVal
															_ = _bucketPartition
															if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
																_partitionResult := *exprVal
																_ = _partitionResult
																if _bucketPartition.Name == _partitionResult.Name {
																	if rulesfn.IsValidHostLabel(_bucketArn.Region, true) {
																		if _bucketArn.Service == "s3" {
																			if rulesfn.IsValidHostLabel(_bucketArn.AccountId, false) {
																				if rulesfn.IsValidHostLabel(_accessPointName, false) {
																					if _Accelerate == true {
																						return endpoint, fmt.Errorf("endpoint rule error, %s", "Access Points do not support S3 Accelerate")
																					}
																					if _UseFIPS == true {
																						if _UseDualStack == true {
																							uriString := func() string {
																								var out strings.Builder
																								out.WriteString("https://")
																								out.WriteString(_accessPointName)
																								out.WriteString("-")
																								out.WriteString(_bucketArn.AccountId)
																								out.WriteString(".s3-accesspoint-fips.dualstack.")
																								out.WriteString(_bucketArn.Region)
																								out.WriteString(".")
																								out.WriteString(_bucketPartition.DnsSuffix)
																								return out.String()
																							}()

																							uri, err := url.Parse(uriString)
																							if err != nil {
																								return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																							}

																							return smithyendpoints.Endpoint{
																								URI:     *uri,
																								Headers: http.Header{},
																								Properties: func() smithy.Properties {
																									var out smithy.Properties
																									smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																										{
																											SchemeID: "aws.auth#sigv4",
																											SignerProperties: func() smithy.Properties {
																												var sp smithy.Properties
																												smithyhttp.SetDisableDoubleEncoding(&sp, true)

																												smithyhttp.SetSigV4SigningName(&sp, "s3")
																												smithyhttp.SetSigV4ASigningName(&sp, "s3")

																												smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																												return sp
																											}(),
																										},
																									})
																									return out
																								}(),
																							}, nil
																						}
																					}
																					if _UseFIPS == true {
																						if _UseDualStack == false {
																							uriString := func() string {
																								var out strings.Builder
																								out.WriteString("https://")
																								out.WriteString(_accessPointName)
																								out.WriteString("-")
																								out.WriteString(_bucketArn.AccountId)
																								out.WriteString(".s3-accesspoint-fips.")
																								out.WriteString(_bucketArn.Region)
																								out.WriteString(".")
																								out.WriteString(_bucketPartition.DnsSuffix)
																								return out.String()
																							}()

																							uri, err := url.Parse(uriString)
																							if err != nil {
																								return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																							}

																							return smithyendpoints.Endpoint{
																								URI:     *uri,
																								Headers: http.Header{},
																								Properties: func() smithy.Properties {
																									var out smithy.Properties
																									smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																										{
																											SchemeID: "aws.auth#sigv4",
																											SignerProperties: func() smithy.Properties {
																												var sp smithy.Properties
																												smithyhttp.SetDisableDoubleEncoding(&sp, true)

																												smithyhttp.SetSigV4SigningName(&sp, "s3")
																												smithyhttp.SetSigV4ASigningName(&sp, "s3")

																												smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																												return sp
																											}(),
																										},
																									})
																									return out
																								}(),
																							}, nil
																						}
																					}
																					if _UseFIPS == false {
																						if _UseDualStack == true {
																							uriString := func() string {
																								var out strings.Builder
																								out.WriteString("https://")
																								out.WriteString(_accessPointName)
																								out.WriteString("-")
																								out.WriteString(_bucketArn.AccountId)
																								out.WriteString(".s3-accesspoint.dualstack.")
																								out.WriteString(_bucketArn.Region)
																								out.WriteString(".")
																								out.WriteString(_bucketPartition.DnsSuffix)
																								return out.String()
																							}()

																							uri, err := url.Parse(uriString)
																							if err != nil {
																								return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																							}

																							return smithyendpoints.Endpoint{
																								URI:     *uri,
																								Headers: http.Header{},
																								Properties: func() smithy.Properties {
																									var out smithy.Properties
																									smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																										{
																											SchemeID: "aws.auth#sigv4",
																											SignerProperties: func() smithy.Properties {
																												var sp smithy.Properties
																												smithyhttp.SetDisableDoubleEncoding(&sp, true)

																												smithyhttp.SetSigV4SigningName(&sp, "s3")
																												smithyhttp.SetSigV4ASigningName(&sp, "s3")

																												smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																												return sp
																											}(),
																										},
																									})
																									return out
																								}(),
																							}, nil
																						}
																					}
																					if _UseFIPS == false {
																						if _UseDualStack == false {
																							if exprVal := params.Endpoint; exprVal != nil {
																								_Endpoint := *exprVal
																								_ = _Endpoint
																								if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
																									_url := *exprVal
																									_ = _url
																									uriString := func() string {
																										var out strings.Builder
																										out.WriteString(_url.Scheme)
																										out.WriteString("://")
																										out.WriteString(_accessPointName)
																										out.WriteString("-")
																										out.WriteString(_bucketArn.AccountId)
																										out.WriteString(".")
																										out.WriteString(_url.Authority)
																										out.WriteString(_url.Path)
																										return out.String()
																									}()

																									uri, err := url.Parse(uriString)
																									if err != nil {
																										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																									}

																									return smithyendpoints.Endpoint{
																										URI:     *uri,
																										Headers: http.Header{},
																										Properties: func() smithy.Properties {
																											var out smithy.Properties
																											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																												{
																													SchemeID: "aws.auth#sigv4",
																													SignerProperties: func() smithy.Properties {
																														var sp smithy.Properties
																														smithyhttp.SetDisableDoubleEncoding(&sp, true)

																														smithyhttp.SetSigV4SigningName(&sp, "s3")
																														smithyhttp.SetSigV4ASigningName(&sp, "s3")

																														smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																														return sp
																													}(),
																												},
																											})
																											return out
																										}(),
																									}, nil
																								}
																							}
																						}
																					}
																					if _UseFIPS == false {
																						if _UseDualStack == false {
																							uriString := func() string {
																								var out strings.Builder
																								out.WriteString("https://")
																								out.WriteString(_accessPointName)
																								out.WriteString("-")
																								out.WriteString(_bucketArn.AccountId)
																								out.WriteString(".s3-accesspoint.")
																								out.WriteString(_bucketArn.Region)
																								out.WriteString(".")
																								out.WriteString(_bucketPartition.DnsSuffix)
																								return out.String()
																							}()

																							uri, err := url.Parse(uriString)
																							if err != nil {
																								return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																							}

																							return smithyendpoints.Endpoint{
																								URI:     *uri,
																								Headers: http.Header{},
																								Properties: func() smithy.Properties {
																									var out smithy.Properties
																									smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																										{
																											SchemeID: "aws.auth#sigv4",
																											SignerProperties: func() smithy.Properties {
																												var sp smithy.Properties
																												smithyhttp.SetDisableDoubleEncoding(&sp, true)

																												smithyhttp.SetSigV4SigningName(&sp, "s3")
																												smithyhttp.SetSigV4ASigningName(&sp, "s3")

																												smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																												return sp
																											}(),
																										},
																									})
																									return out
																								}(),
																							}, nil
																						}
																					}
																					return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
																				}
																				return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																					var out strings.Builder
																					out.WriteString("Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `")
																					out.WriteString(_accessPointName)
																					out.WriteString("`")
																					return out.String()
																				}())
																			}
																			return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																				var out strings.Builder
																				out.WriteString("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `")
																				out.WriteString(_bucketArn.AccountId)
																				out.WriteString("`")
																				return out.String()
																			}())
																		}
																		return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																			var out strings.Builder
																			out.WriteString("Invalid ARN: The ARN was not for the S3 service, found: ")
																			out.WriteString(_bucketArn.Service)
																			return out.String()
																		}())
																	}
																	return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																		var out strings.Builder
																		out.WriteString("Invalid region in ARN: `")
																		out.WriteString(_bucketArn.Region)
																		out.WriteString("` (invalid DNS name)")
																		return out.String()
																	}())
																}
																return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																	var out strings.Builder
																	out.WriteString("Client was configured for partition `")
																	out.WriteString(_partitionResult.Name)
																	out.WriteString("` but ARN (`")
																	out.WriteString(_Bucket)
																	out.WriteString("`) has `")
																	out.WriteString(_bucketPartition.Name)
																	out.WriteString("`")
																	return out.String()
																}())
															}
															return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
														}
														return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
													}
													return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: The ARN may only contain a single resource component after `accesspoint`.")
												}
												return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
											}
											return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
										}
										if rulesfn.IsValidHostLabel(_accessPointName, true) {
											if _UseDualStack == true {
												return endpoint, fmt.Errorf("endpoint rule error, %s", "S3 MRAP does not support dual-stack")
											}
											if _UseFIPS == true {
												return endpoint, fmt.Errorf("endpoint rule error, %s", "S3 MRAP does not support FIPS")
											}
											if _Accelerate == true {
												return endpoint, fmt.Errorf("endpoint rule error, %s", "S3 MRAP does not support S3 Accelerate")
											}
											if _DisableMultiRegionAccessPoints == true {
												return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid configuration: Multi-Region Access Point ARNs are disabled.")
											}
											if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
												_mrapPartition := *exprVal
												_ = _mrapPartition
												if _mrapPartition.Name == _bucketArn.Partition {
													uriString := func() string {
														var out strings.Builder
														out.WriteString("https://")
														out.WriteString(_accessPointName)
														out.WriteString(".accesspoint.s3-global.")
														out.WriteString(_mrapPartition.DnsSuffix)
														return out.String()
													}()

													uri, err := url.Parse(uriString)
													if err != nil {
														return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
													}

													return smithyendpoints.Endpoint{
														URI:     *uri,
														Headers: http.Header{},
														Properties: func() smithy.Properties {
															var out smithy.Properties
															smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																{
																	SchemeID: "aws.auth#sigv4a",
																	SignerProperties: func() smithy.Properties {
																		var sp smithy.Properties
																		smithyhttp.SetDisableDoubleEncoding(&sp, true)

																		smithyhttp.SetSigV4SigningName(&sp, "s3")
																		smithyhttp.SetSigV4ASigningName(&sp, "s3")

																		smithyhttp.SetSigV4ASigningRegions(&sp, []string{"*"})
																		return sp
																	}(),
																},
															})
															return out
														}(),
													}, nil
												}
												return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
													var out strings.Builder
													out.WriteString("Client was configured for partition `")
													out.WriteString(_mrapPartition.Name)
													out.WriteString("` but bucket referred to partition `")
													out.WriteString(_bucketArn.Partition)
													out.WriteString("`")
													return out.String()
												}())
											}
											return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
										}
										return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid Access Point Name")
									}
								}
								return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided")
							}
							if _bucketArn.Service == "s3-outposts" {
								if _UseDualStack == true {
									return endpoint, fmt.Errorf("endpoint rule error, %s", "S3 Outposts does not support Dual-stack")
								}
								if _UseFIPS == true {
									return endpoint, fmt.Errorf("endpoint rule error, %s", "S3 Outposts does not support FIPS")
								}
								if _Accelerate == true {
									return endpoint, fmt.Errorf("endpoint rule error, %s", "S3 Outposts does not support S3 Accelerate")
								}
								if exprVal := _bucketArn.ResourceId.Get(4); exprVal != nil {
									_var_275 := *exprVal
									_ = _var_275
									return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid Arn: Outpost Access Point ARN contains sub resources")
								}
								if exprVal := _bucketArn.ResourceId.Get(1); exprVal != nil {
									_outpostId := *exprVal
									_ = _outpostId
									if rulesfn.IsValidHostLabel(_outpostId, false) {
										if exprVal := params.UseArnRegion; exprVal != nil {
											_UseArnRegion := *exprVal
											_ = _UseArnRegion
											if _UseArnRegion == false {
												if !(_bucketArn.Region == _Region) {
													return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
														var out strings.Builder
														out.WriteString("Invalid configuration: region from ARN `")
														out.WriteString(_bucketArn.Region)
														out.WriteString("` does not match client region `")
														out.WriteString(_Region)
														out.WriteString("` and UseArnRegion is `false`")
														return out.String()
													}())
												}
											}
										}
										if exprVal := awsrulesfn.GetPartition(_bucketArn.Region); exprVal != nil {
											_bucketPartition := *exprVal
											_ = _bucketPartition
											if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
												_partitionResult := *exprVal
												_ = _partitionResult
												if _bucketPartition.Name == _partitionResult.Name {
													if rulesfn.IsValidHostLabel(_bucketArn.Region, true) {
														if rulesfn.IsValidHostLabel(_bucketArn.AccountId, false) {
															if exprVal := _bucketArn.ResourceId.Get(2); exprVal != nil {
																_outpostType := *exprVal
																_ = _outpostType
																if exprVal := _bucketArn.ResourceId.Get(3); exprVal != nil {
																	_accessPointName := *exprVal
																	_ = _accessPointName
																	if _outpostType == "accesspoint" {
																		if exprVal := params.Endpoint; exprVal != nil {
																			_Endpoint := *exprVal
																			_ = _Endpoint
																			if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
																				_url := *exprVal
																				_ = _url
																				uriString := func() string {
																					var out strings.Builder
																					out.WriteString("https://")
																					out.WriteString(_accessPointName)
																					out.WriteString("-")
																					out.WriteString(_bucketArn.AccountId)
																					out.WriteString(".")
																					out.WriteString(_outpostId)
																					out.WriteString(".")
																					out.WriteString(_url.Authority)
																					return out.String()
																				}()

																				uri, err := url.Parse(uriString)
																				if err != nil {
																					return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																				}

																				return smithyendpoints.Endpoint{
																					URI:     *uri,
																					Headers: http.Header{},
																					Properties: func() smithy.Properties {
																						var out smithy.Properties
																						smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																							{
																								SchemeID: "aws.auth#sigv4",
																								SignerProperties: func() smithy.Properties {
																									var sp smithy.Properties
																									smithyhttp.SetDisableDoubleEncoding(&sp, true)

																									smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																									smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																									smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																									return sp
																								}(),
																							},
																						})
																						return out
																					}(),
																				}, nil
																			}
																		}
																		uriString := func() string {
																			var out strings.Builder
																			out.WriteString("https://")
																			out.WriteString(_accessPointName)
																			out.WriteString("-")
																			out.WriteString(_bucketArn.AccountId)
																			out.WriteString(".")
																			out.WriteString(_outpostId)
																			out.WriteString(".s3-outposts.")
																			out.WriteString(_bucketArn.Region)
																			out.WriteString(".")
																			out.WriteString(_bucketPartition.DnsSuffix)
																			return out.String()
																		}()

																		uri, err := url.Parse(uriString)
																		if err != nil {
																			return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
																		}

																		return smithyendpoints.Endpoint{
																			URI:     *uri,
																			Headers: http.Header{},
																			Properties: func() smithy.Properties {
																				var out smithy.Properties
																				smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
																					{
																						SchemeID: "aws.auth#sigv4",
																						SignerProperties: func() smithy.Properties {
																							var sp smithy.Properties
																							smithyhttp.SetDisableDoubleEncoding(&sp, true)

																							smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
																							smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

																							smithyhttp.SetSigV4SigningRegion(&sp, _bucketArn.Region)
																							return sp
																						}(),
																					},
																				})
																				return out
																			}(),
																		}, nil
																	}
																	return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
																		var out strings.Builder
																		out.WriteString("Expected an outpost type `accesspoint`, found ")
																		out.WriteString(_outpostType)
																		return out.String()
																	}())
																}
																return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: expected an access point name")
															}
															return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: Expected a 4-component resource")
														}
														return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
															var out strings.Builder
															out.WriteString("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `")
															out.WriteString(_bucketArn.AccountId)
															out.WriteString("`")
															return out.String()
														}())
													}
													return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
														var out strings.Builder
														out.WriteString("Invalid region in ARN: `")
														out.WriteString(_bucketArn.Region)
														out.WriteString("` (invalid DNS name)")
														return out.String()
													}())
												}
												return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
													var out strings.Builder
													out.WriteString("Client was configured for partition `")
													out.WriteString(_partitionResult.Name)
													out.WriteString("` but ARN (`")
													out.WriteString(_Bucket)
													out.WriteString("`) has `")
													out.WriteString(_bucketPartition.Name)
													out.WriteString("`")
													return out.String()
												}())
											}
											return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
										}
										return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
									}
									return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
										var out strings.Builder
										out.WriteString("Invalid ARN: The outpost Id may only contain a-z, A-Z, 0-9 and `-`. Found: `")
										out.WriteString(_outpostId)
										out.WriteString("`")
										return out.String()
									}())
								}
								return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: The Outpost Id was not set")
							}
							return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
								var out strings.Builder
								out.WriteString("Invalid ARN: Unrecognized format: ")
								out.WriteString(_Bucket)
								out.WriteString(" (type: ")
								out.WriteString(_arnType)
								out.WriteString(")")
								return out.String()
							}())
						}
					}
					return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid ARN: No ARN type specified")
				}
			}
			if exprVal := rulesfn.SubString(_Bucket, 0, 4, false); exprVal != nil {
				_arnPrefix := *exprVal
				_ = _arnPrefix
				if _arnPrefix == "arn:" {
					if !(awsrulesfn.ParseARN(_Bucket) != nil) {
						return endpoint, fmt.Errorf("endpoint rule error, %s", func() string {
							var out strings.Builder
							out.WriteString("Invalid ARN: `")
							out.WriteString(_Bucket)
							out.WriteString("` was not a valid ARN")
							return out.String()
						}())
					}
				}
			}
			if _ForcePathStyle == true {
				if exprVal := awsrulesfn.ParseARN(_Bucket); exprVal != nil {
					_var_288 := *exprVal
					_ = _var_288
					return endpoint, fmt.Errorf("endpoint rule error, %s", "Path-style addressing cannot be used with ARN buckets")
				}
			}
			_uri_encoded_bucket := rulesfn.URIEncode(_Bucket)
			_ = _uri_encoded_bucket
			if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
				_partitionResult := *exprVal
				_ = _partitionResult
				if _Accelerate == false {
					if _UseDualStack == true {
						if !(params.Endpoint != nil) {
							if _UseFIPS == true {
								if _Region == "aws-global" {
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://s3-fips.dualstack.us-east-1.")
										out.WriteString(_partitionResult.DnsSuffix)
										out.WriteString("/")
										out.WriteString(_uri_encoded_bucket)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3")
														smithyhttp.SetSigV4ASigningName(&sp, "s3")

														smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
					}
					if _UseDualStack == true {
						if !(params.Endpoint != nil) {
							if _UseFIPS == true {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == true {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3-fips.dualstack.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											out.WriteString("/")
											out.WriteString(_uri_encoded_bucket)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseDualStack == true {
						if !(params.Endpoint != nil) {
							if _UseFIPS == true {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == false {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3-fips.dualstack.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											out.WriteString("/")
											out.WriteString(_uri_encoded_bucket)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseDualStack == false {
						if !(params.Endpoint != nil) {
							if _UseFIPS == true {
								if _Region == "aws-global" {
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://s3-fips.us-east-1.")
										out.WriteString(_partitionResult.DnsSuffix)
										out.WriteString("/")
										out.WriteString(_uri_encoded_bucket)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3")
														smithyhttp.SetSigV4ASigningName(&sp, "s3")

														smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
					}
					if _UseDualStack == false {
						if !(params.Endpoint != nil) {
							if _UseFIPS == true {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == true {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3-fips.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											out.WriteString("/")
											out.WriteString(_uri_encoded_bucket)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseDualStack == false {
						if !(params.Endpoint != nil) {
							if _UseFIPS == true {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == false {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3-fips.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											out.WriteString("/")
											out.WriteString(_uri_encoded_bucket)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseDualStack == true {
						if !(params.Endpoint != nil) {
							if _UseFIPS == false {
								if _Region == "aws-global" {
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://s3.dualstack.us-east-1.")
										out.WriteString(_partitionResult.DnsSuffix)
										out.WriteString("/")
										out.WriteString(_uri_encoded_bucket)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3")
														smithyhttp.SetSigV4ASigningName(&sp, "s3")

														smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
					}
					if _UseDualStack == true {
						if !(params.Endpoint != nil) {
							if _UseFIPS == false {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == true {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3.dualstack.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											out.WriteString("/")
											out.WriteString(_uri_encoded_bucket)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseDualStack == true {
						if !(params.Endpoint != nil) {
							if _UseFIPS == false {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == false {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3.dualstack.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											out.WriteString("/")
											out.WriteString(_uri_encoded_bucket)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseDualStack == false {
						if exprVal := params.Endpoint; exprVal != nil {
							_Endpoint := *exprVal
							_ = _Endpoint
							if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
								_url := *exprVal
								_ = _url
								if _UseFIPS == false {
									if _Region == "aws-global" {
										uriString := func() string {
											var out strings.Builder
											out.WriteString(_url.Scheme)
											out.WriteString("://")
											out.WriteString(_url.Authority)
											out.WriteString(_url.NormalizedPath)
											out.WriteString(_uri_encoded_bucket)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseDualStack == false {
						if exprVal := params.Endpoint; exprVal != nil {
							_Endpoint := *exprVal
							_ = _Endpoint
							if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
								_url := *exprVal
								_ = _url
								if _UseFIPS == false {
									if !(_Region == "aws-global") {
										if _UseGlobalEndpoint == true {
											if _Region == "us-east-1" {
												uriString := func() string {
													var out strings.Builder
													out.WriteString(_url.Scheme)
													out.WriteString("://")
													out.WriteString(_url.Authority)
													out.WriteString(_url.NormalizedPath)
													out.WriteString(_uri_encoded_bucket)
													return out.String()
												}()

												uri, err := url.Parse(uriString)
												if err != nil {
													return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
												}

												return smithyendpoints.Endpoint{
													URI:     *uri,
													Headers: http.Header{},
													Properties: func() smithy.Properties {
														var out smithy.Properties
														smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
															{
																SchemeID: "aws.auth#sigv4",
																SignerProperties: func() smithy.Properties {
																	var sp smithy.Properties
																	smithyhttp.SetDisableDoubleEncoding(&sp, true)

																	smithyhttp.SetSigV4SigningName(&sp, "s3")
																	smithyhttp.SetSigV4ASigningName(&sp, "s3")

																	smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																	return sp
																}(),
															},
														})
														return out
													}(),
												}, nil
											}
											uriString := func() string {
												var out strings.Builder
												out.WriteString(_url.Scheme)
												out.WriteString("://")
												out.WriteString(_url.Authority)
												out.WriteString(_url.NormalizedPath)
												out.WriteString(_uri_encoded_bucket)
												return out.String()
											}()

											uri, err := url.Parse(uriString)
											if err != nil {
												return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
											}

											return smithyendpoints.Endpoint{
												URI:     *uri,
												Headers: http.Header{},
												Properties: func() smithy.Properties {
													var out smithy.Properties
													smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
														{
															SchemeID: "aws.auth#sigv4",
															SignerProperties: func() smithy.Properties {
																var sp smithy.Properties
																smithyhttp.SetDisableDoubleEncoding(&sp, true)

																smithyhttp.SetSigV4SigningName(&sp, "s3")
																smithyhttp.SetSigV4ASigningName(&sp, "s3")

																smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																return sp
															}(),
														},
													})
													return out
												}(),
											}, nil
										}
									}
								}
							}
						}
					}
					if _UseDualStack == false {
						if exprVal := params.Endpoint; exprVal != nil {
							_Endpoint := *exprVal
							_ = _Endpoint
							if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
								_url := *exprVal
								_ = _url
								if _UseFIPS == false {
									if !(_Region == "aws-global") {
										if _UseGlobalEndpoint == false {
											uriString := func() string {
												var out strings.Builder
												out.WriteString(_url.Scheme)
												out.WriteString("://")
												out.WriteString(_url.Authority)
												out.WriteString(_url.NormalizedPath)
												out.WriteString(_uri_encoded_bucket)
												return out.String()
											}()

											uri, err := url.Parse(uriString)
											if err != nil {
												return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
											}

											return smithyendpoints.Endpoint{
												URI:     *uri,
												Headers: http.Header{},
												Properties: func() smithy.Properties {
													var out smithy.Properties
													smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
														{
															SchemeID: "aws.auth#sigv4",
															SignerProperties: func() smithy.Properties {
																var sp smithy.Properties
																smithyhttp.SetDisableDoubleEncoding(&sp, true)

																smithyhttp.SetSigV4SigningName(&sp, "s3")
																smithyhttp.SetSigV4ASigningName(&sp, "s3")

																smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																return sp
															}(),
														},
													})
													return out
												}(),
											}, nil
										}
									}
								}
							}
						}
					}
					if _UseDualStack == false {
						if !(params.Endpoint != nil) {
							if _UseFIPS == false {
								if _Region == "aws-global" {
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://s3.")
										out.WriteString(_partitionResult.DnsSuffix)
										out.WriteString("/")
										out.WriteString(_uri_encoded_bucket)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3")
														smithyhttp.SetSigV4ASigningName(&sp, "s3")

														smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
					}
					if _UseDualStack == false {
						if !(params.Endpoint != nil) {
							if _UseFIPS == false {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == true {
										if _Region == "us-east-1" {
											uriString := func() string {
												var out strings.Builder
												out.WriteString("https://s3.")
												out.WriteString(_partitionResult.DnsSuffix)
												out.WriteString("/")
												out.WriteString(_uri_encoded_bucket)
												return out.String()
											}()

											uri, err := url.Parse(uriString)
											if err != nil {
												return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
											}

											return smithyendpoints.Endpoint{
												URI:     *uri,
												Headers: http.Header{},
												Properties: func() smithy.Properties {
													var out smithy.Properties
													smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
														{
															SchemeID: "aws.auth#sigv4",
															SignerProperties: func() smithy.Properties {
																var sp smithy.Properties
																smithyhttp.SetDisableDoubleEncoding(&sp, true)

																smithyhttp.SetSigV4SigningName(&sp, "s3")
																smithyhttp.SetSigV4ASigningName(&sp, "s3")

																smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																return sp
															}(),
														},
													})
													return out
												}(),
											}, nil
										}
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											out.WriteString("/")
											out.WriteString(_uri_encoded_bucket)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseDualStack == false {
						if !(params.Endpoint != nil) {
							if _UseFIPS == false {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == false {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											out.WriteString("/")
											out.WriteString(_uri_encoded_bucket)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
				}
				return endpoint, fmt.Errorf("endpoint rule error, %s", "Path-style addressing cannot be used with S3 Accelerate")
			}
			return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
		}
		if exprVal := params.UseObjectLambdaEndpoint; exprVal != nil {
			_UseObjectLambdaEndpoint := *exprVal
			_ = _UseObjectLambdaEndpoint
			if _UseObjectLambdaEndpoint == true {
				if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
					_partitionResult := *exprVal
					_ = _partitionResult
					if rulesfn.IsValidHostLabel(_Region, true) {
						if _UseDualStack == true {
							return endpoint, fmt.Errorf("endpoint rule error, %s", "S3 Object Lambda does not support Dual-stack")
						}
						if _Accelerate == true {
							return endpoint, fmt.Errorf("endpoint rule error, %s", "S3 Object Lambda does not support S3 Accelerate")
						}
						if exprVal := params.Endpoint; exprVal != nil {
							_Endpoint := *exprVal
							_ = _Endpoint
							if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
								_url := *exprVal
								_ = _url
								uriString := func() string {
									var out strings.Builder
									out.WriteString(_url.Scheme)
									out.WriteString("://")
									out.WriteString(_url.Authority)
									out.WriteString(_url.Path)
									return out.String()
								}()

								uri, err := url.Parse(uriString)
								if err != nil {
									return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
								}

								return smithyendpoints.Endpoint{
									URI:     *uri,
									Headers: http.Header{},
									Properties: func() smithy.Properties {
										var out smithy.Properties
										smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
											{
												SchemeID: "aws.auth#sigv4",
												SignerProperties: func() smithy.Properties {
													var sp smithy.Properties
													smithyhttp.SetDisableDoubleEncoding(&sp, true)

													smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
													smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

													smithyhttp.SetSigV4SigningRegion(&sp, _Region)
													return sp
												}(),
											},
										})
										return out
									}(),
								}, nil
							}
						}
						if _UseFIPS == true {
							uriString := func() string {
								var out strings.Builder
								out.WriteString("https://s3-object-lambda-fips.")
								out.WriteString(_Region)
								out.WriteString(".")
								out.WriteString(_partitionResult.DnsSuffix)
								return out.String()
							}()

							uri, err := url.Parse(uriString)
							if err != nil {
								return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
							}

							return smithyendpoints.Endpoint{
								URI:     *uri,
								Headers: http.Header{},
								Properties: func() smithy.Properties {
									var out smithy.Properties
									smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
										{
											SchemeID: "aws.auth#sigv4",
											SignerProperties: func() smithy.Properties {
												var sp smithy.Properties
												smithyhttp.SetDisableDoubleEncoding(&sp, true)

												smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
												smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

												smithyhttp.SetSigV4SigningRegion(&sp, _Region)
												return sp
											}(),
										},
									})
									return out
								}(),
							}, nil
						}
						uriString := func() string {
							var out strings.Builder
							out.WriteString("https://s3-object-lambda.")
							out.WriteString(_Region)
							out.WriteString(".")
							out.WriteString(_partitionResult.DnsSuffix)
							return out.String()
						}()

						uri, err := url.Parse(uriString)
						if err != nil {
							return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
						}

						return smithyendpoints.Endpoint{
							URI:     *uri,
							Headers: http.Header{},
							Properties: func() smithy.Properties {
								var out smithy.Properties
								smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
									{
										SchemeID: "aws.auth#sigv4",
										SignerProperties: func() smithy.Properties {
											var sp smithy.Properties
											smithyhttp.SetDisableDoubleEncoding(&sp, true)

											smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
											smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

											smithyhttp.SetSigV4SigningRegion(&sp, _Region)
											return sp
										}(),
									},
								})
								return out
							}(),
						}, nil
					}
					return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid region: region was not a valid DNS name.")
				}
				return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
			}
		}
		if !(params.Bucket != nil) {
			if exprVal := awsrulesfn.GetPartition(_Region); exprVal != nil {
				_partitionResult := *exprVal
				_ = _partitionResult
				if rulesfn.IsValidHostLabel(_Region, true) {
					if _UseFIPS == true {
						if _UseDualStack == true {
							if !(params.Endpoint != nil) {
								if _Region == "aws-global" {
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://s3-fips.dualstack.us-east-1.")
										out.WriteString(_partitionResult.DnsSuffix)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3")
														smithyhttp.SetSigV4ASigningName(&sp, "s3")

														smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
					}
					if _UseFIPS == true {
						if _UseDualStack == true {
							if !(params.Endpoint != nil) {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == true {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3-fips.dualstack.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseFIPS == true {
						if _UseDualStack == true {
							if !(params.Endpoint != nil) {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == false {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3-fips.dualstack.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseFIPS == true {
						if _UseDualStack == false {
							if !(params.Endpoint != nil) {
								if _Region == "aws-global" {
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://s3-fips.us-east-1.")
										out.WriteString(_partitionResult.DnsSuffix)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3")
														smithyhttp.SetSigV4ASigningName(&sp, "s3")

														smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
					}
					if _UseFIPS == true {
						if _UseDualStack == false {
							if !(params.Endpoint != nil) {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == true {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3-fips.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseFIPS == true {
						if _UseDualStack == false {
							if !(params.Endpoint != nil) {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == false {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3-fips.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseFIPS == false {
						if _UseDualStack == true {
							if !(params.Endpoint != nil) {
								if _Region == "aws-global" {
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://s3.dualstack.us-east-1.")
										out.WriteString(_partitionResult.DnsSuffix)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3")
														smithyhttp.SetSigV4ASigningName(&sp, "s3")

														smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
					}
					if _UseFIPS == false {
						if _UseDualStack == true {
							if !(params.Endpoint != nil) {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == true {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3.dualstack.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseFIPS == false {
						if _UseDualStack == true {
							if !(params.Endpoint != nil) {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == false {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3.dualstack.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseFIPS == false {
						if _UseDualStack == false {
							if exprVal := params.Endpoint; exprVal != nil {
								_Endpoint := *exprVal
								_ = _Endpoint
								if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
									_url := *exprVal
									_ = _url
									if _Region == "aws-global" {
										uriString := func() string {
											var out strings.Builder
											out.WriteString(_url.Scheme)
											out.WriteString("://")
											out.WriteString(_url.Authority)
											out.WriteString(_url.Path)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseFIPS == false {
						if _UseDualStack == false {
							if exprVal := params.Endpoint; exprVal != nil {
								_Endpoint := *exprVal
								_ = _Endpoint
								if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
									_url := *exprVal
									_ = _url
									if !(_Region == "aws-global") {
										if _UseGlobalEndpoint == true {
											if _Region == "us-east-1" {
												uriString := func() string {
													var out strings.Builder
													out.WriteString(_url.Scheme)
													out.WriteString("://")
													out.WriteString(_url.Authority)
													out.WriteString(_url.Path)
													return out.String()
												}()

												uri, err := url.Parse(uriString)
												if err != nil {
													return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
												}

												return smithyendpoints.Endpoint{
													URI:     *uri,
													Headers: http.Header{},
													Properties: func() smithy.Properties {
														var out smithy.Properties
														smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
															{
																SchemeID: "aws.auth#sigv4",
																SignerProperties: func() smithy.Properties {
																	var sp smithy.Properties
																	smithyhttp.SetDisableDoubleEncoding(&sp, true)

																	smithyhttp.SetSigV4SigningName(&sp, "s3")
																	smithyhttp.SetSigV4ASigningName(&sp, "s3")

																	smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																	return sp
																}(),
															},
														})
														return out
													}(),
												}, nil
											}
											uriString := func() string {
												var out strings.Builder
												out.WriteString(_url.Scheme)
												out.WriteString("://")
												out.WriteString(_url.Authority)
												out.WriteString(_url.Path)
												return out.String()
											}()

											uri, err := url.Parse(uriString)
											if err != nil {
												return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
											}

											return smithyendpoints.Endpoint{
												URI:     *uri,
												Headers: http.Header{},
												Properties: func() smithy.Properties {
													var out smithy.Properties
													smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
														{
															SchemeID: "aws.auth#sigv4",
															SignerProperties: func() smithy.Properties {
																var sp smithy.Properties
																smithyhttp.SetDisableDoubleEncoding(&sp, true)

																smithyhttp.SetSigV4SigningName(&sp, "s3")
																smithyhttp.SetSigV4ASigningName(&sp, "s3")

																smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																return sp
															}(),
														},
													})
													return out
												}(),
											}, nil
										}
									}
								}
							}
						}
					}
					if _UseFIPS == false {
						if _UseDualStack == false {
							if exprVal := params.Endpoint; exprVal != nil {
								_Endpoint := *exprVal
								_ = _Endpoint
								if exprVal := rulesfn.ParseURL(_Endpoint); exprVal != nil {
									_url := *exprVal
									_ = _url
									if !(_Region == "aws-global") {
										if _UseGlobalEndpoint == false {
											uriString := func() string {
												var out strings.Builder
												out.WriteString(_url.Scheme)
												out.WriteString("://")
												out.WriteString(_url.Authority)
												out.WriteString(_url.Path)
												return out.String()
											}()

											uri, err := url.Parse(uriString)
											if err != nil {
												return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
											}

											return smithyendpoints.Endpoint{
												URI:     *uri,
												Headers: http.Header{},
												Properties: func() smithy.Properties {
													var out smithy.Properties
													smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
														{
															SchemeID: "aws.auth#sigv4",
															SignerProperties: func() smithy.Properties {
																var sp smithy.Properties
																smithyhttp.SetDisableDoubleEncoding(&sp, true)

																smithyhttp.SetSigV4SigningName(&sp, "s3")
																smithyhttp.SetSigV4ASigningName(&sp, "s3")

																smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																return sp
															}(),
														},
													})
													return out
												}(),
											}, nil
										}
									}
								}
							}
						}
					}
					if _UseFIPS == false {
						if _UseDualStack == false {
							if !(params.Endpoint != nil) {
								if _Region == "aws-global" {
									uriString := func() string {
										var out strings.Builder
										out.WriteString("https://s3.")
										out.WriteString(_partitionResult.DnsSuffix)
										return out.String()
									}()

									uri, err := url.Parse(uriString)
									if err != nil {
										return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
									}

									return smithyendpoints.Endpoint{
										URI:     *uri,
										Headers: http.Header{},
										Properties: func() smithy.Properties {
											var out smithy.Properties
											smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
												{
													SchemeID: "aws.auth#sigv4",
													SignerProperties: func() smithy.Properties {
														var sp smithy.Properties
														smithyhttp.SetDisableDoubleEncoding(&sp, true)

														smithyhttp.SetSigV4SigningName(&sp, "s3")
														smithyhttp.SetSigV4ASigningName(&sp, "s3")

														smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
														return sp
													}(),
												},
											})
											return out
										}(),
									}, nil
								}
							}
						}
					}
					if _UseFIPS == false {
						if _UseDualStack == false {
							if !(params.Endpoint != nil) {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == true {
										if _Region == "us-east-1" {
											uriString := func() string {
												var out strings.Builder
												out.WriteString("https://s3.")
												out.WriteString(_partitionResult.DnsSuffix)
												return out.String()
											}()

											uri, err := url.Parse(uriString)
											if err != nil {
												return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
											}

											return smithyendpoints.Endpoint{
												URI:     *uri,
												Headers: http.Header{},
												Properties: func() smithy.Properties {
													var out smithy.Properties
													smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
														{
															SchemeID: "aws.auth#sigv4",
															SignerProperties: func() smithy.Properties {
																var sp smithy.Properties
																smithyhttp.SetDisableDoubleEncoding(&sp, true)

																smithyhttp.SetSigV4SigningName(&sp, "s3")
																smithyhttp.SetSigV4ASigningName(&sp, "s3")

																smithyhttp.SetSigV4SigningRegion(&sp, _Region)
																return sp
															}(),
														},
													})
													return out
												}(),
											}, nil
										}
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					if _UseFIPS == false {
						if _UseDualStack == false {
							if !(params.Endpoint != nil) {
								if !(_Region == "aws-global") {
									if _UseGlobalEndpoint == false {
										uriString := func() string {
											var out strings.Builder
											out.WriteString("https://s3.")
											out.WriteString(_Region)
											out.WriteString(".")
											out.WriteString(_partitionResult.DnsSuffix)
											return out.String()
										}()

										uri, err := url.Parse(uriString)
										if err != nil {
											return endpoint, fmt.Errorf("Failed to parse uri: %s", uriString)
										}

										return smithyendpoints.Endpoint{
											URI:     *uri,
											Headers: http.Header{},
											Properties: func() smithy.Properties {
												var out smithy.Properties
												smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
													{
														SchemeID: "aws.auth#sigv4",
														SignerProperties: func() smithy.Properties {
															var sp smithy.Properties
															smithyhttp.SetDisableDoubleEncoding(&sp, true)

															smithyhttp.SetSigV4SigningName(&sp, "s3")
															smithyhttp.SetSigV4ASigningName(&sp, "s3")

															smithyhttp.SetSigV4SigningRegion(&sp, _Region)
															return sp
														}(),
													},
												})
												return out
											}(),
										}, nil
									}
								}
							}
						}
					}
					return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
				}
				return endpoint, fmt.Errorf("endpoint rule error, %s", "Invalid region: region was not a valid DNS name.")
			}
			return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
		}
		return endpoint, fmt.Errorf("Endpoint resolution failed. Invalid operation or environment input.")
	}
	return endpoint, fmt.Errorf("endpoint rule error, %s", "A region must be set when sending requests to S3.")
}

type endpointParamsBinder interface {
	bindEndpointParams(*EndpointParameters)
}

func bindEndpointParams(input interface{}, options Options) *EndpointParameters {
	params := &EndpointParameters{}

	params.Region = aws.String(endpoints.MapFIPSRegion(options.Region))
	params.UseFIPS = aws.Bool(options.EndpointOptions.UseFIPSEndpoint == aws.FIPSEndpointStateEnabled)
	params.UseDualStack = aws.Bool(options.EndpointOptions.UseDualStackEndpoint == aws.DualStackEndpointStateEnabled)
	params.Endpoint = options.BaseEndpoint
	params.ForcePathStyle = aws.Bool(options.UsePathStyle)
	params.Accelerate = aws.Bool(options.UseAccelerate)
	params.DisableMultiRegionAccessPoints = aws.Bool(options.DisableMultiRegionAccessPoints)
	params.UseArnRegion = aws.Bool(options.UseARNRegion)

	params.DisableS3ExpressSessionAuth = options.DisableS3ExpressSessionAuth

	if b, ok := input.(endpointParamsBinder); ok {
		b.bindEndpointParams(params)
	}

	return params
}

type resolveEndpointV2Middleware struct {
	options Options
}

func (*resolveEndpointV2Middleware) ID() string {
	return "ResolveEndpointV2"
}

func (m *resolveEndpointV2Middleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if awsmiddleware.GetRequiresLegacyEndpoints(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	if m.options.EndpointResolverV2 == nil {
		return out, metadata, fmt.Errorf("expected endpoint resolver to not be nil")
	}

	params := bindEndpointParams(getOperationInput(ctx), m.options)
	endpt, err := m.options.EndpointResolverV2.ResolveEndpoint(ctx, *params)
	if err != nil {
		return out, metadata, fmt.Errorf("failed to resolve service endpoint, %w", err)
	}

	if endpt.URI.RawPath == "" && req.URL.RawPath != "" {
		endpt.URI.RawPath = endpt.URI.Path
	}
	req.URL.Scheme = endpt.URI.Scheme
	req.URL.Host = endpt.URI.Host
	req.URL.Path = smithyhttp.JoinPath(endpt.URI.Path, req.URL.Path)
	req.URL.RawPath = smithyhttp.JoinPath(endpt.URI.RawPath, req.URL.RawPath)
	for k := range endpt.Headers {
		req.Header.Set(k, endpt.Headers.Get(k))
	}

	rscheme := getResolvedAuthScheme(ctx)
	if rscheme == nil {
		return out, metadata, fmt.Errorf("no resolved auth scheme")
	}

	opts, _ := smithyauth.GetAuthOptions(&endpt.Properties)
	for _, o := range opts {
		rscheme.SignerProperties.SetAll(&o.SignerProperties)
	}

	backend := s3cust.GetPropertiesBackend(&endpt.Properties)
	ctx = internalcontext.SetS3Backend(ctx, backend)

	return next.HandleFinalize(ctx, in)
}
