/*
 * BitBucket Server Code Insights API
 *
 * BitBucket Server Code Insights API
 *
 * API version: 1.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package insights

import (
	"bytes"
	_context "context"
	_ioutil "io/ioutil"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

// InsightsApiService InsightsApi service
type InsightsApiService service

type ApiCreateAnnotationsRequest struct {
	ctx             _context.Context
	ApiService      *InsightsApiService
	projectKey      string
	repositorySlug  string
	commitId        string
	reportKey       string
	annotationsList *AnnotationsList
}

func (r ApiCreateAnnotationsRequest) AnnotationsList(annotationsList AnnotationsList) ApiCreateAnnotationsRequest {
	r.annotationsList = &annotationsList
	return r
}

func (r ApiCreateAnnotationsRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.CreateAnnotationsExecute(r)
}

/*
 * CreateAnnotations Add annotations to the given report.
 * The request should be a JSON object mapping the string "annotations" to an array of maps containing the
annotation data, as described below. See also the example request.
A few things to note:

Annotations are an extension of a report, so a report must first exist in order to post annotations.
Annotations are posted separately from the report, and can be posted in bulk using this endpoint.

Only the annotations that are on lines changed in the unified diff will be displayed. This means it is
likely not all annotations posted will be displayed on the pull request It also means that if the user is
viewing a side-by-side diff, commit diff or iterative review diff they will not be able to view the annotations.

A report cannot have more than 1000 annotations by default, however this property is congurable at an
instance level. If the request would result in more than the maximum number of annotations being stored
then the entire request is rejected and no new annotations are stored.

There is no de-duplication of annotations on Bitbucket so be sure that reruns of builds will first delete
the report and annotations before creating them.

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param projectKey The project key
 * @param repositorySlug The repository slug
 * @param commitId The commit ID. This must be a full 40 character commit hash
 * @param reportKey A unique string representing the report as chosen by the reporter. This should be unique enough to not clash with other report's keys. To do this, we recommend namespacing the key using reverse DNS.
 * @return ApiCreateAnnotationsRequest
*/
func (a *InsightsApiService) CreateAnnotations(ctx _context.Context, projectKey string, repositorySlug string, commitId string, reportKey string) ApiCreateAnnotationsRequest {
	return ApiCreateAnnotationsRequest{
		ApiService:     a,
		ctx:            ctx,
		projectKey:     projectKey,
		repositorySlug: repositorySlug,
		commitId:       commitId,
		reportKey:      reportKey,
	}
}

/*
 * Execute executes the request
 */
func (a *InsightsApiService) CreateAnnotationsExecute(r ApiCreateAnnotationsRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "InsightsApiService.CreateAnnotations")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reports/{reportKey}/annotations"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", _neturl.PathEscape(parameterToString(r.projectKey, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", _neturl.PathEscape(parameterToString(r.repositorySlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", _neturl.PathEscape(parameterToString(r.commitId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportKey"+"}", _neturl.PathEscape(parameterToString(r.reportKey, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.annotationsList == nil {
		return nil, reportError("annotationsList is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.annotationsList
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiDeleteAnnotationsRequest struct {
	ctx            _context.Context
	ApiService     *InsightsApiService
	projectKey     string
	repositorySlug string
	commitId       string
	reportKey      string
	externalId     *string
}

func (r ApiDeleteAnnotationsRequest) ExternalId(externalId string) ApiDeleteAnnotationsRequest {
	r.externalId = &externalId
	return r
}

func (r ApiDeleteAnnotationsRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.DeleteAnnotationsExecute(r)
}

/*
 * DeleteAnnotations Delete annotations
 * Delete annotations for a given report that match the given external IDs, or all annotations if no
external IDs are provided.

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param projectKey The project key
 * @param repositorySlug The repository slug
 * @param commitId The commit ID. This must be a full 40 character commit hash
 * @param reportKey A unique string representing the report as chosen by the reporter. This should be unique enough to not clash with other report's keys. To do this, we recommend namespacing the key using reverse DNS.
 * @return ApiDeleteAnnotationsRequest
*/
func (a *InsightsApiService) DeleteAnnotations(ctx _context.Context, projectKey string, repositorySlug string, commitId string, reportKey string) ApiDeleteAnnotationsRequest {
	return ApiDeleteAnnotationsRequest{
		ApiService:     a,
		ctx:            ctx,
		projectKey:     projectKey,
		repositorySlug: repositorySlug,
		commitId:       commitId,
		reportKey:      reportKey,
	}
}

/*
 * Execute executes the request
 */
func (a *InsightsApiService) DeleteAnnotationsExecute(r ApiDeleteAnnotationsRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "InsightsApiService.DeleteAnnotations")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reports/{reportKey}/annotations"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", _neturl.PathEscape(parameterToString(r.projectKey, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", _neturl.PathEscape(parameterToString(r.repositorySlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", _neturl.PathEscape(parameterToString(r.commitId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportKey"+"}", _neturl.PathEscape(parameterToString(r.reportKey, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.externalId != nil {
		localVarQueryParams.Add("externalId", parameterToString(*r.externalId, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiDeleteReportRequest struct {
	ctx            _context.Context
	ApiService     *InsightsApiService
	projectKey     string
	repositorySlug string
	commitId       string
	reportKey      string
}

func (r ApiDeleteReportRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.DeleteReportExecute(r)
}

/*
 * DeleteReport Delete a report for the given commit. Also deletes any annotations associated with this report.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param projectKey The project key
 * @param repositorySlug The repository slug
 * @param commitId The commit ID. This must be a full 40 character commit hash
 * @param reportKey A unique string representing the report as chosen by the reporter. This should be unique enough to not clash with other report's keys. To do this, we recommend namespacing the key using reverse DNS.
 * @return ApiDeleteReportRequest
 */
func (a *InsightsApiService) DeleteReport(ctx _context.Context, projectKey string, repositorySlug string, commitId string, reportKey string) ApiDeleteReportRequest {
	return ApiDeleteReportRequest{
		ApiService:     a,
		ctx:            ctx,
		projectKey:     projectKey,
		repositorySlug: repositorySlug,
		commitId:       commitId,
		reportKey:      reportKey,
	}
}

/*
 * Execute executes the request
 */
func (a *InsightsApiService) DeleteReportExecute(r ApiDeleteReportRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "InsightsApiService.DeleteReport")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reports/{reportKey}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", _neturl.PathEscape(parameterToString(r.projectKey, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", _neturl.PathEscape(parameterToString(r.repositorySlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", _neturl.PathEscape(parameterToString(r.commitId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportKey"+"}", _neturl.PathEscape(parameterToString(r.reportKey, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiGetAnnotationsRequest struct {
	ctx            _context.Context
	ApiService     *InsightsApiService
	projectKey     string
	repositorySlug string
	commitId       string
	externalId     *string
	key            *string
	path           *string
	severity       *string
	type_          *string
}

func (r ApiGetAnnotationsRequest) ExternalId(externalId string) ApiGetAnnotationsRequest {
	r.externalId = &externalId
	return r
}
func (r ApiGetAnnotationsRequest) Key(key string) ApiGetAnnotationsRequest {
	r.key = &key
	return r
}
func (r ApiGetAnnotationsRequest) Path(path string) ApiGetAnnotationsRequest {
	r.path = &path
	return r
}
func (r ApiGetAnnotationsRequest) Severity(severity string) ApiGetAnnotationsRequest {
	r.severity = &severity
	return r
}
func (r ApiGetAnnotationsRequest) Type_(type_ string) ApiGetAnnotationsRequest {
	r.type_ = &type_
	return r
}

func (r ApiGetAnnotationsRequest) Execute() (AnnotationsList, *_nethttp.Response, error) {
	return r.ApiService.GetAnnotationsExecute(r)
}

/*
 * GetAnnotations Retrieve the specified commit's annotations.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param projectKey The project key
 * @param repositorySlug The repository slug
 * @param commitId The commit ID. This must be a full 40 character commit hash
 * @return ApiGetAnnotationsRequest
 */
func (a *InsightsApiService) GetAnnotations(ctx _context.Context, projectKey string, repositorySlug string, commitId string) ApiGetAnnotationsRequest {
	return ApiGetAnnotationsRequest{
		ApiService:     a,
		ctx:            ctx,
		projectKey:     projectKey,
		repositorySlug: repositorySlug,
		commitId:       commitId,
	}
}

/*
 * Execute executes the request
 * @return AnnotationsList
 */
func (a *InsightsApiService) GetAnnotationsExecute(r ApiGetAnnotationsRequest) (AnnotationsList, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  AnnotationsList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "InsightsApiService.GetAnnotations")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/annotations"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", _neturl.PathEscape(parameterToString(r.projectKey, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", _neturl.PathEscape(parameterToString(r.repositorySlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", _neturl.PathEscape(parameterToString(r.commitId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.externalId != nil {
		localVarQueryParams.Add("externalId", parameterToString(*r.externalId, ""))
	}
	if r.key != nil {
		localVarQueryParams.Add("key", parameterToString(*r.key, ""))
	}
	if r.path != nil {
		localVarQueryParams.Add("path", parameterToString(*r.path, ""))
	}
	if r.severity != nil {
		localVarQueryParams.Add("severity", parameterToString(*r.severity, ""))
	}
	if r.type_ != nil {
		localVarQueryParams.Add("type", parameterToString(*r.type_, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetReportRequest struct {
	ctx            _context.Context
	ApiService     *InsightsApiService
	projectKey     string
	repositorySlug string
	commitId       string
	reportKey      string
}

func (r ApiGetReportRequest) Execute() (Report, *_nethttp.Response, error) {
	return r.ApiService.GetReportExecute(r)
}

/*
 * GetReport Retrieve the specified report.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param projectKey The project key
 * @param repositorySlug The repository slug
 * @param commitId The commit ID. This must be a full 40 character commit hash
 * @param reportKey A unique string representing the report as chosen by the reporter. This should be unique enough to not clash with other report's keys. To do this, we recommend namespacing the key using reverse DNS.
 * @return ApiGetReportRequest
 */
func (a *InsightsApiService) GetReport(ctx _context.Context, projectKey string, repositorySlug string, commitId string, reportKey string) ApiGetReportRequest {
	return ApiGetReportRequest{
		ApiService:     a,
		ctx:            ctx,
		projectKey:     projectKey,
		repositorySlug: repositorySlug,
		commitId:       commitId,
		reportKey:      reportKey,
	}
}

/*
 * Execute executes the request
 * @return Report
 */
func (a *InsightsApiService) GetReportExecute(r ApiGetReportRequest) (Report, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Report
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "InsightsApiService.GetReport")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reports/{reportKey}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", _neturl.PathEscape(parameterToString(r.projectKey, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", _neturl.PathEscape(parameterToString(r.repositorySlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", _neturl.PathEscape(parameterToString(r.commitId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportKey"+"}", _neturl.PathEscape(parameterToString(r.reportKey, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetReportAnnotationsRequest struct {
	ctx            _context.Context
	ApiService     *InsightsApiService
	projectKey     string
	repositorySlug string
	commitId       string
	reportKey      string
}

func (r ApiGetReportAnnotationsRequest) Execute() (AnnotationsList, *_nethttp.Response, error) {
	return r.ApiService.GetReportAnnotationsExecute(r)
}

/*
 * GetReportAnnotations Retrieve the specified report's annotations.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param projectKey The project key
 * @param repositorySlug The repository slug
 * @param commitId The commit ID. This must be a full 40 character commit hash
 * @param reportKey A unique string representing the report as chosen by the reporter. This should be unique enough to not clash with other report's keys. To do this, we recommend namespacing the key using reverse DNS.
 * @return ApiGetReportAnnotationsRequest
 */
func (a *InsightsApiService) GetReportAnnotations(ctx _context.Context, projectKey string, repositorySlug string, commitId string, reportKey string) ApiGetReportAnnotationsRequest {
	return ApiGetReportAnnotationsRequest{
		ApiService:     a,
		ctx:            ctx,
		projectKey:     projectKey,
		repositorySlug: repositorySlug,
		commitId:       commitId,
		reportKey:      reportKey,
	}
}

/*
 * Execute executes the request
 * @return AnnotationsList
 */
func (a *InsightsApiService) GetReportAnnotationsExecute(r ApiGetReportAnnotationsRequest) (AnnotationsList, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  AnnotationsList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "InsightsApiService.GetReportAnnotations")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reports/{reportKey}/annotations"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", _neturl.PathEscape(parameterToString(r.projectKey, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", _neturl.PathEscape(parameterToString(r.repositorySlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", _neturl.PathEscape(parameterToString(r.commitId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportKey"+"}", _neturl.PathEscape(parameterToString(r.reportKey, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetReportsRequest struct {
	ctx            _context.Context
	ApiService     *InsightsApiService
	projectKey     string
	repositorySlug string
	commitId       string
	start          *int32
	limit          *int32
}

func (r ApiGetReportsRequest) Start(start int32) ApiGetReportsRequest {
	r.start = &start
	return r
}
func (r ApiGetReportsRequest) Limit(limit int32) ApiGetReportsRequest {
	r.limit = &limit
	return r
}

func (r ApiGetReportsRequest) Execute() (ReportsListResponse, *_nethttp.Response, error) {
	return r.ApiService.GetReportsExecute(r)
}

/*
 * GetReports Get reports list for specified commit
 * Retrieve all reports for the given commit.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param projectKey The project key
 * @param repositorySlug The repository slug
 * @param commitId The commit ID. This must be a full 40 character commit hash
 * @return ApiGetReportsRequest
 */
func (a *InsightsApiService) GetReports(ctx _context.Context, projectKey string, repositorySlug string, commitId string) ApiGetReportsRequest {
	return ApiGetReportsRequest{
		ApiService:     a,
		ctx:            ctx,
		projectKey:     projectKey,
		repositorySlug: repositorySlug,
		commitId:       commitId,
	}
}

/*
 * Execute executes the request
 * @return ReportsListResponse
 */
func (a *InsightsApiService) GetReportsExecute(r ApiGetReportsRequest) (ReportsListResponse, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ReportsListResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "InsightsApiService.GetReports")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reposts"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", _neturl.PathEscape(parameterToString(r.projectKey, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", _neturl.PathEscape(parameterToString(r.repositorySlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", _neturl.PathEscape(parameterToString(r.commitId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.start != nil {
		localVarQueryParams.Add("start", parameterToString(*r.start, ""))
	}
	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiUpdateAnnotationRequest struct {
	ctx            _context.Context
	ApiService     *InsightsApiService
	projectKey     string
	repositorySlug string
	commitId       string
	reportKey      string
	externalId     string
	annotation     *Annotation
}

func (r ApiUpdateAnnotationRequest) Annotation(annotation Annotation) ApiUpdateAnnotationRequest {
	r.annotation = &annotation
	return r
}

func (r ApiUpdateAnnotationRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.UpdateAnnotationExecute(r)
}

/*
 * UpdateAnnotation Create an annotation with the given external ID, or replace it if it already exists.
 * A request to replace an existing annotation will be rejected if the authenticated user was not the
creator of the specified report.

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param projectKey The project key
 * @param repositorySlug The repository slug
 * @param commitId The commit ID. This must be a full 40 character commit hash
 * @param reportKey A unique string representing the report as chosen by the reporter. This should be unique enough to not clash with other report's keys. To do this, we recommend namespacing the key using reverse DNS.
 * @param externalId The external ID of the annotation that is to be updated or created
 * @return ApiUpdateAnnotationRequest
*/
func (a *InsightsApiService) UpdateAnnotation(ctx _context.Context, projectKey string, repositorySlug string, commitId string, reportKey string, externalId string) ApiUpdateAnnotationRequest {
	return ApiUpdateAnnotationRequest{
		ApiService:     a,
		ctx:            ctx,
		projectKey:     projectKey,
		repositorySlug: repositorySlug,
		commitId:       commitId,
		reportKey:      reportKey,
		externalId:     externalId,
	}
}

/*
 * Execute executes the request
 */
func (a *InsightsApiService) UpdateAnnotationExecute(r ApiUpdateAnnotationRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "InsightsApiService.UpdateAnnotation")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reports/{reportKey}/annotations/{externalId}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", _neturl.PathEscape(parameterToString(r.projectKey, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", _neturl.PathEscape(parameterToString(r.repositorySlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", _neturl.PathEscape(parameterToString(r.commitId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportKey"+"}", _neturl.PathEscape(parameterToString(r.reportKey, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"externalId"+"}", _neturl.PathEscape(parameterToString(r.externalId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.annotation
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiUpdateReportRequest struct {
	ctx            _context.Context
	ApiService     *InsightsApiService
	projectKey     string
	repositorySlug string
	commitId       string
	reportKey      string
	report         *Report
}

func (r ApiUpdateReportRequest) Report(report Report) ApiUpdateReportRequest {
	r.report = &report
	return r
}

func (r ApiUpdateReportRequest) Execute() (Report, *_nethttp.Response, error) {
	return r.ApiService.UpdateReportExecute(r)
}

/*
 * UpdateReport Create a new insight report, or replace the existing one.
 * Create a new insight report, or replace the existing one if a report already exists for the given repository,
commit, and report key. A request to replace an existing report will be rejected if the authenticated user
was not the creator of the specified report.
The report key should be a unique string chosen by the reporter and should be unique enough not to potentially
clash with report keys from other reporters. We recommend using reverse DNS namespacing or a similar standard
to ensure that collision is avoided.

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param projectKey The project key
 * @param repositorySlug The repository slug
 * @param commitId The commit ID. This must be a full 40 character commit hash
 * @param reportKey A unique string representing the report as chosen by the reporter. This should be unique enough to not clash with other report's keys. To do this, we recommend namespacing the key using reverse DNS.
 * @return ApiUpdateReportRequest
*/
func (a *InsightsApiService) UpdateReport(ctx _context.Context, projectKey string, repositorySlug string, commitId string, reportKey string) ApiUpdateReportRequest {
	return ApiUpdateReportRequest{
		ApiService:     a,
		ctx:            ctx,
		projectKey:     projectKey,
		repositorySlug: repositorySlug,
		commitId:       commitId,
		reportKey:      reportKey,
	}
}

/*
 * Execute executes the request
 * @return Report
 */
func (a *InsightsApiService) UpdateReportExecute(r ApiUpdateReportRequest) (Report, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Report
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "InsightsApiService.UpdateReport")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reports/{reportKey}"
	localVarPath = strings.Replace(localVarPath, "{"+"projectKey"+"}", _neturl.PathEscape(parameterToString(r.projectKey, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"repositorySlug"+"}", _neturl.PathEscape(parameterToString(r.repositorySlug, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"commitId"+"}", _neturl.PathEscape(parameterToString(r.commitId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"reportKey"+"}", _neturl.PathEscape(parameterToString(r.reportKey, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.report == nil {
		return localVarReturnValue, nil, reportError("report is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.report
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 400 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
