// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datazone

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptPredictions = "AcceptPredictions"

// AcceptPredictionsRequest generates a "aws/request.Request" representing the
// client's request for the AcceptPredictions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptPredictions for more information on using the AcceptPredictions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptPredictionsRequest method.
//	req, resp := client.AcceptPredictionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptPredictions
func (c *DataZone) AcceptPredictionsRequest(input *AcceptPredictionsInput) (req *request.Request, output *AcceptPredictionsOutput) {
	op := &request.Operation{
		Name:       opAcceptPredictions,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/domains/{domainIdentifier}/assets/{identifier}/accept-predictions",
	}

	if input == nil {
		input = &AcceptPredictionsInput{}
	}

	output = &AcceptPredictionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptPredictions API operation for Amazon DataZone.
//
// Accepts automatically generated business-friendly metadata for your Amazon
// DataZone assets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation AcceptPredictions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptPredictions
func (c *DataZone) AcceptPredictions(input *AcceptPredictionsInput) (*AcceptPredictionsOutput, error) {
	req, out := c.AcceptPredictionsRequest(input)
	return out, req.Send()
}

// AcceptPredictionsWithContext is the same as AcceptPredictions with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptPredictions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) AcceptPredictionsWithContext(ctx aws.Context, input *AcceptPredictionsInput, opts ...request.Option) (*AcceptPredictionsOutput, error) {
	req, out := c.AcceptPredictionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcceptSubscriptionRequest = "AcceptSubscriptionRequest"

// AcceptSubscriptionRequestRequest generates a "aws/request.Request" representing the
// client's request for the AcceptSubscriptionRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptSubscriptionRequest for more information on using the AcceptSubscriptionRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptSubscriptionRequestRequest method.
//	req, resp := client.AcceptSubscriptionRequestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptSubscriptionRequest
func (c *DataZone) AcceptSubscriptionRequestRequest(input *AcceptSubscriptionRequestInput) (req *request.Request, output *AcceptSubscriptionRequestOutput) {
	op := &request.Operation{
		Name:       opAcceptSubscriptionRequest,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscription-requests/{identifier}/accept",
	}

	if input == nil {
		input = &AcceptSubscriptionRequestInput{}
	}

	output = &AcceptSubscriptionRequestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptSubscriptionRequest API operation for Amazon DataZone.
//
// Accepts a subscription request to a specific asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation AcceptSubscriptionRequest for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AcceptSubscriptionRequest
func (c *DataZone) AcceptSubscriptionRequest(input *AcceptSubscriptionRequestInput) (*AcceptSubscriptionRequestOutput, error) {
	req, out := c.AcceptSubscriptionRequestRequest(input)
	return out, req.Send()
}

// AcceptSubscriptionRequestWithContext is the same as AcceptSubscriptionRequest with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptSubscriptionRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) AcceptSubscriptionRequestWithContext(ctx aws.Context, input *AcceptSubscriptionRequestInput, opts ...request.Option) (*AcceptSubscriptionRequestOutput, error) {
	req, out := c.AcceptSubscriptionRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateEnvironmentRole = "AssociateEnvironmentRole"

// AssociateEnvironmentRoleRequest generates a "aws/request.Request" representing the
// client's request for the AssociateEnvironmentRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateEnvironmentRole for more information on using the AssociateEnvironmentRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateEnvironmentRoleRequest method.
//	req, resp := client.AssociateEnvironmentRoleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AssociateEnvironmentRole
func (c *DataZone) AssociateEnvironmentRoleRequest(input *AssociateEnvironmentRoleInput) (req *request.Request, output *AssociateEnvironmentRoleOutput) {
	op := &request.Operation{
		Name:       opAssociateEnvironmentRole,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/roles/{environmentRoleArn}",
	}

	if input == nil {
		input = &AssociateEnvironmentRoleInput{}
	}

	output = &AssociateEnvironmentRoleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateEnvironmentRole API operation for Amazon DataZone.
//
// Associates the environment role in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation AssociateEnvironmentRole for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/AssociateEnvironmentRole
func (c *DataZone) AssociateEnvironmentRole(input *AssociateEnvironmentRoleInput) (*AssociateEnvironmentRoleOutput, error) {
	req, out := c.AssociateEnvironmentRoleRequest(input)
	return out, req.Send()
}

// AssociateEnvironmentRoleWithContext is the same as AssociateEnvironmentRole with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateEnvironmentRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) AssociateEnvironmentRoleWithContext(ctx aws.Context, input *AssociateEnvironmentRoleInput, opts ...request.Option) (*AssociateEnvironmentRoleOutput, error) {
	req, out := c.AssociateEnvironmentRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelMetadataGenerationRun = "CancelMetadataGenerationRun"

// CancelMetadataGenerationRunRequest generates a "aws/request.Request" representing the
// client's request for the CancelMetadataGenerationRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelMetadataGenerationRun for more information on using the CancelMetadataGenerationRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelMetadataGenerationRunRequest method.
//	req, resp := client.CancelMetadataGenerationRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelMetadataGenerationRun
func (c *DataZone) CancelMetadataGenerationRunRequest(input *CancelMetadataGenerationRunInput) (req *request.Request, output *CancelMetadataGenerationRunOutput) {
	op := &request.Operation{
		Name:       opCancelMetadataGenerationRun,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/metadata-generation-runs/{identifier}/cancel",
	}

	if input == nil {
		input = &CancelMetadataGenerationRunInput{}
	}

	output = &CancelMetadataGenerationRunOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelMetadataGenerationRun API operation for Amazon DataZone.
//
// Cancels the metadata generation run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CancelMetadataGenerationRun for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelMetadataGenerationRun
func (c *DataZone) CancelMetadataGenerationRun(input *CancelMetadataGenerationRunInput) (*CancelMetadataGenerationRunOutput, error) {
	req, out := c.CancelMetadataGenerationRunRequest(input)
	return out, req.Send()
}

// CancelMetadataGenerationRunWithContext is the same as CancelMetadataGenerationRun with the addition of
// the ability to pass a context and additional request options.
//
// See CancelMetadataGenerationRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CancelMetadataGenerationRunWithContext(ctx aws.Context, input *CancelMetadataGenerationRunInput, opts ...request.Option) (*CancelMetadataGenerationRunOutput, error) {
	req, out := c.CancelMetadataGenerationRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelSubscription = "CancelSubscription"

// CancelSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CancelSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelSubscription for more information on using the CancelSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelSubscriptionRequest method.
//	req, resp := client.CancelSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelSubscription
func (c *DataZone) CancelSubscriptionRequest(input *CancelSubscriptionInput) (req *request.Request, output *CancelSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCancelSubscription,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscriptions/{identifier}/cancel",
	}

	if input == nil {
		input = &CancelSubscriptionInput{}
	}

	output = &CancelSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelSubscription API operation for Amazon DataZone.
//
// Cancels the subscription to the specified asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CancelSubscription for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CancelSubscription
func (c *DataZone) CancelSubscription(input *CancelSubscriptionInput) (*CancelSubscriptionOutput, error) {
	req, out := c.CancelSubscriptionRequest(input)
	return out, req.Send()
}

// CancelSubscriptionWithContext is the same as CancelSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CancelSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CancelSubscriptionWithContext(ctx aws.Context, input *CancelSubscriptionInput, opts ...request.Option) (*CancelSubscriptionOutput, error) {
	req, out := c.CancelSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAsset = "CreateAsset"

// CreateAssetRequest generates a "aws/request.Request" representing the
// client's request for the CreateAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAsset for more information on using the CreateAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAssetRequest method.
//	req, resp := client.CreateAssetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAsset
func (c *DataZone) CreateAssetRequest(input *CreateAssetInput) (req *request.Request, output *CreateAssetOutput) {
	op := &request.Operation{
		Name:       opCreateAsset,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/assets",
	}

	if input == nil {
		input = &CreateAssetInput{}
	}

	output = &CreateAssetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAsset API operation for Amazon DataZone.
//
// Creates an asset in Amazon DataZone catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateAsset for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAsset
func (c *DataZone) CreateAsset(input *CreateAssetInput) (*CreateAssetOutput, error) {
	req, out := c.CreateAssetRequest(input)
	return out, req.Send()
}

// CreateAssetWithContext is the same as CreateAsset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateAssetWithContext(ctx aws.Context, input *CreateAssetInput, opts ...request.Option) (*CreateAssetOutput, error) {
	req, out := c.CreateAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssetFilter = "CreateAssetFilter"

// CreateAssetFilterRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssetFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssetFilter for more information on using the CreateAssetFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAssetFilterRequest method.
//	req, resp := client.CreateAssetFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetFilter
func (c *DataZone) CreateAssetFilterRequest(input *CreateAssetFilterInput) (req *request.Request, output *CreateAssetFilterOutput) {
	op := &request.Operation{
		Name:       opCreateAssetFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters",
	}

	if input == nil {
		input = &CreateAssetFilterInput{}
	}

	output = &CreateAssetFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAssetFilter API operation for Amazon DataZone.
//
// Creates a data asset filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateAssetFilter for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetFilter
func (c *DataZone) CreateAssetFilter(input *CreateAssetFilterInput) (*CreateAssetFilterOutput, error) {
	req, out := c.CreateAssetFilterRequest(input)
	return out, req.Send()
}

// CreateAssetFilterWithContext is the same as CreateAssetFilter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssetFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateAssetFilterWithContext(ctx aws.Context, input *CreateAssetFilterInput, opts ...request.Option) (*CreateAssetFilterOutput, error) {
	req, out := c.CreateAssetFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssetRevision = "CreateAssetRevision"

// CreateAssetRevisionRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssetRevision operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssetRevision for more information on using the CreateAssetRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAssetRevisionRequest method.
//	req, resp := client.CreateAssetRevisionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetRevision
func (c *DataZone) CreateAssetRevisionRequest(input *CreateAssetRevisionInput) (req *request.Request, output *CreateAssetRevisionOutput) {
	op := &request.Operation{
		Name:       opCreateAssetRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/assets/{identifier}/revisions",
	}

	if input == nil {
		input = &CreateAssetRevisionInput{}
	}

	output = &CreateAssetRevisionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAssetRevision API operation for Amazon DataZone.
//
// Creates a revision of the asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateAssetRevision for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetRevision
func (c *DataZone) CreateAssetRevision(input *CreateAssetRevisionInput) (*CreateAssetRevisionOutput, error) {
	req, out := c.CreateAssetRevisionRequest(input)
	return out, req.Send()
}

// CreateAssetRevisionWithContext is the same as CreateAssetRevision with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssetRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateAssetRevisionWithContext(ctx aws.Context, input *CreateAssetRevisionInput, opts ...request.Option) (*CreateAssetRevisionOutput, error) {
	req, out := c.CreateAssetRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssetType = "CreateAssetType"

// CreateAssetTypeRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssetType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssetType for more information on using the CreateAssetType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAssetTypeRequest method.
//	req, resp := client.CreateAssetTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetType
func (c *DataZone) CreateAssetTypeRequest(input *CreateAssetTypeInput) (req *request.Request, output *CreateAssetTypeOutput) {
	op := &request.Operation{
		Name:       opCreateAssetType,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/asset-types",
	}

	if input == nil {
		input = &CreateAssetTypeInput{}
	}

	output = &CreateAssetTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAssetType API operation for Amazon DataZone.
//
// Creates a custom asset type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateAssetType for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateAssetType
func (c *DataZone) CreateAssetType(input *CreateAssetTypeInput) (*CreateAssetTypeOutput, error) {
	req, out := c.CreateAssetTypeRequest(input)
	return out, req.Send()
}

// CreateAssetTypeWithContext is the same as CreateAssetType with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssetType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateAssetTypeWithContext(ctx aws.Context, input *CreateAssetTypeInput, opts ...request.Option) (*CreateAssetTypeOutput, error) {
	req, out := c.CreateAssetTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSource = "CreateDataSource"

// CreateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSource for more information on using the CreateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDataSourceRequest method.
//	req, resp := client.CreateDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataSource
func (c *DataZone) CreateDataSourceRequest(input *CreateDataSourceInput) (req *request.Request, output *CreateDataSourceOutput) {
	op := &request.Operation{
		Name:       opCreateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/data-sources",
	}

	if input == nil {
		input = &CreateDataSourceInput{}
	}

	output = &CreateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSource API operation for Amazon DataZone.
//
// Creates an Amazon DataZone data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateDataSource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDataSource
func (c *DataZone) CreateDataSource(input *CreateDataSourceInput) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	return out, req.Send()
}

// CreateDataSourceWithContext is the same as CreateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateDataSourceWithContext(ctx aws.Context, input *CreateDataSourceInput, opts ...request.Option) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomain for more information on using the CreateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDomainRequest method.
//	req, resp := client.CreateDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDomain
func (c *DataZone) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomain API operation for Amazon DataZone.
//
// Creates an Amazon DataZone domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateDomain for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateDomain
func (c *DataZone) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateDomainWithContext(ctx aws.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEnvironment = "CreateEnvironment"

// CreateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironment for more information on using the CreateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEnvironmentRequest method.
//	req, resp := client.CreateEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironment
func (c *DataZone) CreateEnvironmentRequest(input *CreateEnvironmentInput) (req *request.Request, output *CreateEnvironmentOutput) {
	op := &request.Operation{
		Name:       opCreateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments",
	}

	if input == nil {
		input = &CreateEnvironmentInput{}
	}

	output = &CreateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEnvironment API operation for Amazon DataZone.
//
// Create an Amazon DataZone environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironment
func (c *DataZone) CreateEnvironment(input *CreateEnvironmentInput) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	return out, req.Send()
}

// CreateEnvironmentWithContext is the same as CreateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateEnvironmentWithContext(ctx aws.Context, input *CreateEnvironmentInput, opts ...request.Option) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEnvironmentAction = "CreateEnvironmentAction"

// CreateEnvironmentActionRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironmentAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironmentAction for more information on using the CreateEnvironmentAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEnvironmentActionRequest method.
//	req, resp := client.CreateEnvironmentActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentAction
func (c *DataZone) CreateEnvironmentActionRequest(input *CreateEnvironmentActionInput) (req *request.Request, output *CreateEnvironmentActionOutput) {
	op := &request.Operation{
		Name:       opCreateEnvironmentAction,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions",
	}

	if input == nil {
		input = &CreateEnvironmentActionInput{}
	}

	output = &CreateEnvironmentActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEnvironmentAction API operation for Amazon DataZone.
//
// Creates an action for the environment, for example, creates a console link
// for an analytics tool that is available in this environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateEnvironmentAction for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentAction
func (c *DataZone) CreateEnvironmentAction(input *CreateEnvironmentActionInput) (*CreateEnvironmentActionOutput, error) {
	req, out := c.CreateEnvironmentActionRequest(input)
	return out, req.Send()
}

// CreateEnvironmentActionWithContext is the same as CreateEnvironmentAction with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironmentAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateEnvironmentActionWithContext(ctx aws.Context, input *CreateEnvironmentActionInput, opts ...request.Option) (*CreateEnvironmentActionOutput, error) {
	req, out := c.CreateEnvironmentActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEnvironmentProfile = "CreateEnvironmentProfile"

// CreateEnvironmentProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironmentProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironmentProfile for more information on using the CreateEnvironmentProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEnvironmentProfileRequest method.
//	req, resp := client.CreateEnvironmentProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentProfile
func (c *DataZone) CreateEnvironmentProfileRequest(input *CreateEnvironmentProfileInput) (req *request.Request, output *CreateEnvironmentProfileOutput) {
	op := &request.Operation{
		Name:       opCreateEnvironmentProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environment-profiles",
	}

	if input == nil {
		input = &CreateEnvironmentProfileInput{}
	}

	output = &CreateEnvironmentProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEnvironmentProfile API operation for Amazon DataZone.
//
// Creates an Amazon DataZone environment profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateEnvironmentProfile for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateEnvironmentProfile
func (c *DataZone) CreateEnvironmentProfile(input *CreateEnvironmentProfileInput) (*CreateEnvironmentProfileOutput, error) {
	req, out := c.CreateEnvironmentProfileRequest(input)
	return out, req.Send()
}

// CreateEnvironmentProfileWithContext is the same as CreateEnvironmentProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironmentProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateEnvironmentProfileWithContext(ctx aws.Context, input *CreateEnvironmentProfileInput, opts ...request.Option) (*CreateEnvironmentProfileOutput, error) {
	req, out := c.CreateEnvironmentProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFormType = "CreateFormType"

// CreateFormTypeRequest generates a "aws/request.Request" representing the
// client's request for the CreateFormType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFormType for more information on using the CreateFormType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFormTypeRequest method.
//	req, resp := client.CreateFormTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateFormType
func (c *DataZone) CreateFormTypeRequest(input *CreateFormTypeInput) (req *request.Request, output *CreateFormTypeOutput) {
	op := &request.Operation{
		Name:       opCreateFormType,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/form-types",
	}

	if input == nil {
		input = &CreateFormTypeInput{}
	}

	output = &CreateFormTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFormType API operation for Amazon DataZone.
//
// Creates a metadata form type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateFormType for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateFormType
func (c *DataZone) CreateFormType(input *CreateFormTypeInput) (*CreateFormTypeOutput, error) {
	req, out := c.CreateFormTypeRequest(input)
	return out, req.Send()
}

// CreateFormTypeWithContext is the same as CreateFormType with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFormType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateFormTypeWithContext(ctx aws.Context, input *CreateFormTypeInput, opts ...request.Option) (*CreateFormTypeOutput, error) {
	req, out := c.CreateFormTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGlossary = "CreateGlossary"

// CreateGlossaryRequest generates a "aws/request.Request" representing the
// client's request for the CreateGlossary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGlossary for more information on using the CreateGlossary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGlossaryRequest method.
//	req, resp := client.CreateGlossaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossary
func (c *DataZone) CreateGlossaryRequest(input *CreateGlossaryInput) (req *request.Request, output *CreateGlossaryOutput) {
	op := &request.Operation{
		Name:       opCreateGlossary,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/glossaries",
	}

	if input == nil {
		input = &CreateGlossaryInput{}
	}

	output = &CreateGlossaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGlossary API operation for Amazon DataZone.
//
// Creates an Amazon DataZone business glossary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateGlossary for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossary
func (c *DataZone) CreateGlossary(input *CreateGlossaryInput) (*CreateGlossaryOutput, error) {
	req, out := c.CreateGlossaryRequest(input)
	return out, req.Send()
}

// CreateGlossaryWithContext is the same as CreateGlossary with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGlossary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateGlossaryWithContext(ctx aws.Context, input *CreateGlossaryInput, opts ...request.Option) (*CreateGlossaryOutput, error) {
	req, out := c.CreateGlossaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGlossaryTerm = "CreateGlossaryTerm"

// CreateGlossaryTermRequest generates a "aws/request.Request" representing the
// client's request for the CreateGlossaryTerm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGlossaryTerm for more information on using the CreateGlossaryTerm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGlossaryTermRequest method.
//	req, resp := client.CreateGlossaryTermRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossaryTerm
func (c *DataZone) CreateGlossaryTermRequest(input *CreateGlossaryTermInput) (req *request.Request, output *CreateGlossaryTermOutput) {
	op := &request.Operation{
		Name:       opCreateGlossaryTerm,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/glossary-terms",
	}

	if input == nil {
		input = &CreateGlossaryTermInput{}
	}

	output = &CreateGlossaryTermOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGlossaryTerm API operation for Amazon DataZone.
//
// Creates a business glossary term.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateGlossaryTerm for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGlossaryTerm
func (c *DataZone) CreateGlossaryTerm(input *CreateGlossaryTermInput) (*CreateGlossaryTermOutput, error) {
	req, out := c.CreateGlossaryTermRequest(input)
	return out, req.Send()
}

// CreateGlossaryTermWithContext is the same as CreateGlossaryTerm with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGlossaryTerm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateGlossaryTermWithContext(ctx aws.Context, input *CreateGlossaryTermInput, opts ...request.Option) (*CreateGlossaryTermOutput, error) {
	req, out := c.CreateGlossaryTermRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroupProfile = "CreateGroupProfile"

// CreateGroupProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroupProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroupProfile for more information on using the CreateGroupProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGroupProfileRequest method.
//	req, resp := client.CreateGroupProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGroupProfile
func (c *DataZone) CreateGroupProfileRequest(input *CreateGroupProfileInput) (req *request.Request, output *CreateGroupProfileOutput) {
	op := &request.Operation{
		Name:       opCreateGroupProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/group-profiles",
	}

	if input == nil {
		input = &CreateGroupProfileInput{}
	}

	output = &CreateGroupProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroupProfile API operation for Amazon DataZone.
//
// Creates a group profile in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateGroupProfile for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateGroupProfile
func (c *DataZone) CreateGroupProfile(input *CreateGroupProfileInput) (*CreateGroupProfileOutput, error) {
	req, out := c.CreateGroupProfileRequest(input)
	return out, req.Send()
}

// CreateGroupProfileWithContext is the same as CreateGroupProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroupProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateGroupProfileWithContext(ctx aws.Context, input *CreateGroupProfileInput, opts ...request.Option) (*CreateGroupProfileOutput, error) {
	req, out := c.CreateGroupProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateListingChangeSet = "CreateListingChangeSet"

// CreateListingChangeSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateListingChangeSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateListingChangeSet for more information on using the CreateListingChangeSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateListingChangeSetRequest method.
//	req, resp := client.CreateListingChangeSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateListingChangeSet
func (c *DataZone) CreateListingChangeSetRequest(input *CreateListingChangeSetInput) (req *request.Request, output *CreateListingChangeSetOutput) {
	op := &request.Operation{
		Name:       opCreateListingChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/listings/change-set",
	}

	if input == nil {
		input = &CreateListingChangeSetInput{}
	}

	output = &CreateListingChangeSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateListingChangeSet API operation for Amazon DataZone.
//
// Publishes a listing (a record of an asset at a given time) or removes a listing
// from the catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateListingChangeSet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateListingChangeSet
func (c *DataZone) CreateListingChangeSet(input *CreateListingChangeSetInput) (*CreateListingChangeSetOutput, error) {
	req, out := c.CreateListingChangeSetRequest(input)
	return out, req.Send()
}

// CreateListingChangeSetWithContext is the same as CreateListingChangeSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateListingChangeSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateListingChangeSetWithContext(ctx aws.Context, input *CreateListingChangeSetInput, opts ...request.Option) (*CreateListingChangeSetOutput, error) {
	req, out := c.CreateListingChangeSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProject for more information on using the CreateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProjectRequest method.
//	req, resp := client.CreateProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProject
func (c *DataZone) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/projects",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProject API operation for Amazon DataZone.
//
// Creates an Amazon DataZone project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateProject for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProject
func (c *DataZone) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProjectMembership = "CreateProjectMembership"

// CreateProjectMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateProjectMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProjectMembership for more information on using the CreateProjectMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProjectMembershipRequest method.
//	req, resp := client.CreateProjectMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProjectMembership
func (c *DataZone) CreateProjectMembershipRequest(input *CreateProjectMembershipInput) (req *request.Request, output *CreateProjectMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateProjectMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/projects/{projectIdentifier}/createMembership",
	}

	if input == nil {
		input = &CreateProjectMembershipInput{}
	}

	output = &CreateProjectMembershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateProjectMembership API operation for Amazon DataZone.
//
// Creates a project membership in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateProjectMembership for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateProjectMembership
func (c *DataZone) CreateProjectMembership(input *CreateProjectMembershipInput) (*CreateProjectMembershipOutput, error) {
	req, out := c.CreateProjectMembershipRequest(input)
	return out, req.Send()
}

// CreateProjectMembershipWithContext is the same as CreateProjectMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProjectMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateProjectMembershipWithContext(ctx aws.Context, input *CreateProjectMembershipInput, opts ...request.Option) (*CreateProjectMembershipOutput, error) {
	req, out := c.CreateProjectMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubscriptionGrant = "CreateSubscriptionGrant"

// CreateSubscriptionGrantRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubscriptionGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubscriptionGrant for more information on using the CreateSubscriptionGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSubscriptionGrantRequest method.
//	req, resp := client.CreateSubscriptionGrantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionGrant
func (c *DataZone) CreateSubscriptionGrantRequest(input *CreateSubscriptionGrantInput) (req *request.Request, output *CreateSubscriptionGrantOutput) {
	op := &request.Operation{
		Name:       opCreateSubscriptionGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscription-grants",
	}

	if input == nil {
		input = &CreateSubscriptionGrantInput{}
	}

	output = &CreateSubscriptionGrantOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubscriptionGrant API operation for Amazon DataZone.
//
// Creates a subsscription grant in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateSubscriptionGrant for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionGrant
func (c *DataZone) CreateSubscriptionGrant(input *CreateSubscriptionGrantInput) (*CreateSubscriptionGrantOutput, error) {
	req, out := c.CreateSubscriptionGrantRequest(input)
	return out, req.Send()
}

// CreateSubscriptionGrantWithContext is the same as CreateSubscriptionGrant with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubscriptionGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateSubscriptionGrantWithContext(ctx aws.Context, input *CreateSubscriptionGrantInput, opts ...request.Option) (*CreateSubscriptionGrantOutput, error) {
	req, out := c.CreateSubscriptionGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubscriptionRequest = "CreateSubscriptionRequest"

// CreateSubscriptionRequestRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubscriptionRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubscriptionRequest for more information on using the CreateSubscriptionRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSubscriptionRequestRequest method.
//	req, resp := client.CreateSubscriptionRequestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionRequest
func (c *DataZone) CreateSubscriptionRequestRequest(input *CreateSubscriptionRequestInput) (req *request.Request, output *CreateSubscriptionRequestOutput) {
	op := &request.Operation{
		Name:       opCreateSubscriptionRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscription-requests",
	}

	if input == nil {
		input = &CreateSubscriptionRequestInput{}
	}

	output = &CreateSubscriptionRequestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubscriptionRequest API operation for Amazon DataZone.
//
// Creates a subscription request in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateSubscriptionRequest for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionRequest
func (c *DataZone) CreateSubscriptionRequest(input *CreateSubscriptionRequestInput) (*CreateSubscriptionRequestOutput, error) {
	req, out := c.CreateSubscriptionRequestRequest(input)
	return out, req.Send()
}

// CreateSubscriptionRequestWithContext is the same as CreateSubscriptionRequest with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubscriptionRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateSubscriptionRequestWithContext(ctx aws.Context, input *CreateSubscriptionRequestInput, opts ...request.Option) (*CreateSubscriptionRequestOutput, error) {
	req, out := c.CreateSubscriptionRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubscriptionTarget = "CreateSubscriptionTarget"

// CreateSubscriptionTargetRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubscriptionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubscriptionTarget for more information on using the CreateSubscriptionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSubscriptionTargetRequest method.
//	req, resp := client.CreateSubscriptionTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionTarget
func (c *DataZone) CreateSubscriptionTargetRequest(input *CreateSubscriptionTargetInput) (req *request.Request, output *CreateSubscriptionTargetOutput) {
	op := &request.Operation{
		Name:       opCreateSubscriptionTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets",
	}

	if input == nil {
		input = &CreateSubscriptionTargetInput{}
	}

	output = &CreateSubscriptionTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubscriptionTarget API operation for Amazon DataZone.
//
// Creates a subscription target in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateSubscriptionTarget for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateSubscriptionTarget
func (c *DataZone) CreateSubscriptionTarget(input *CreateSubscriptionTargetInput) (*CreateSubscriptionTargetOutput, error) {
	req, out := c.CreateSubscriptionTargetRequest(input)
	return out, req.Send()
}

// CreateSubscriptionTargetWithContext is the same as CreateSubscriptionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubscriptionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateSubscriptionTargetWithContext(ctx aws.Context, input *CreateSubscriptionTargetInput, opts ...request.Option) (*CreateSubscriptionTargetOutput, error) {
	req, out := c.CreateSubscriptionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserProfile = "CreateUserProfile"

// CreateUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserProfile for more information on using the CreateUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUserProfileRequest method.
//	req, resp := client.CreateUserProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateUserProfile
func (c *DataZone) CreateUserProfileRequest(input *CreateUserProfileInput) (req *request.Request, output *CreateUserProfileOutput) {
	op := &request.Operation{
		Name:       opCreateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/user-profiles",
	}

	if input == nil {
		input = &CreateUserProfileInput{}
	}

	output = &CreateUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserProfile API operation for Amazon DataZone.
//
// Creates a user profile in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation CreateUserProfile for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/CreateUserProfile
func (c *DataZone) CreateUserProfile(input *CreateUserProfileInput) (*CreateUserProfileOutput, error) {
	req, out := c.CreateUserProfileRequest(input)
	return out, req.Send()
}

// CreateUserProfileWithContext is the same as CreateUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) CreateUserProfileWithContext(ctx aws.Context, input *CreateUserProfileInput, opts ...request.Option) (*CreateUserProfileOutput, error) {
	req, out := c.CreateUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAsset = "DeleteAsset"

// DeleteAssetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAsset for more information on using the DeleteAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAssetRequest method.
//	req, resp := client.DeleteAssetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAsset
func (c *DataZone) DeleteAssetRequest(input *DeleteAssetInput) (req *request.Request, output *DeleteAssetOutput) {
	op := &request.Operation{
		Name:       opDeleteAsset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/assets/{identifier}",
	}

	if input == nil {
		input = &DeleteAssetInput{}
	}

	output = &DeleteAssetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAsset API operation for Amazon DataZone.
//
// Delets an asset in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteAsset for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAsset
func (c *DataZone) DeleteAsset(input *DeleteAssetInput) (*DeleteAssetOutput, error) {
	req, out := c.DeleteAssetRequest(input)
	return out, req.Send()
}

// DeleteAssetWithContext is the same as DeleteAsset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteAssetWithContext(ctx aws.Context, input *DeleteAssetInput, opts ...request.Option) (*DeleteAssetOutput, error) {
	req, out := c.DeleteAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssetFilter = "DeleteAssetFilter"

// DeleteAssetFilterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssetFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssetFilter for more information on using the DeleteAssetFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAssetFilterRequest method.
//	req, resp := client.DeleteAssetFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAssetFilter
func (c *DataZone) DeleteAssetFilterRequest(input *DeleteAssetFilterInput) (req *request.Request, output *DeleteAssetFilterOutput) {
	op := &request.Operation{
		Name:       opDeleteAssetFilter,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters/{identifier}",
	}

	if input == nil {
		input = &DeleteAssetFilterInput{}
	}

	output = &DeleteAssetFilterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAssetFilter API operation for Amazon DataZone.
//
// Deletes an asset filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteAssetFilter for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAssetFilter
func (c *DataZone) DeleteAssetFilter(input *DeleteAssetFilterInput) (*DeleteAssetFilterOutput, error) {
	req, out := c.DeleteAssetFilterRequest(input)
	return out, req.Send()
}

// DeleteAssetFilterWithContext is the same as DeleteAssetFilter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssetFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteAssetFilterWithContext(ctx aws.Context, input *DeleteAssetFilterInput, opts ...request.Option) (*DeleteAssetFilterOutput, error) {
	req, out := c.DeleteAssetFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssetType = "DeleteAssetType"

// DeleteAssetTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssetType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssetType for more information on using the DeleteAssetType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAssetTypeRequest method.
//	req, resp := client.DeleteAssetTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAssetType
func (c *DataZone) DeleteAssetTypeRequest(input *DeleteAssetTypeInput) (req *request.Request, output *DeleteAssetTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteAssetType,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/asset-types/{identifier}",
	}

	if input == nil {
		input = &DeleteAssetTypeInput{}
	}

	output = &DeleteAssetTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAssetType API operation for Amazon DataZone.
//
// Deletes an asset type in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteAssetType for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteAssetType
func (c *DataZone) DeleteAssetType(input *DeleteAssetTypeInput) (*DeleteAssetTypeOutput, error) {
	req, out := c.DeleteAssetTypeRequest(input)
	return out, req.Send()
}

// DeleteAssetTypeWithContext is the same as DeleteAssetType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssetType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteAssetTypeWithContext(ctx aws.Context, input *DeleteAssetTypeInput, opts ...request.Option) (*DeleteAssetTypeOutput, error) {
	req, out := c.DeleteAssetTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSource = "DeleteDataSource"

// DeleteDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSource for more information on using the DeleteDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataSourceRequest method.
//	req, resp := client.DeleteDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDataSource
func (c *DataZone) DeleteDataSourceRequest(input *DeleteDataSourceInput) (req *request.Request, output *DeleteDataSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/data-sources/{identifier}",
	}

	if input == nil {
		input = &DeleteDataSourceInput{}
	}

	output = &DeleteDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSource API operation for Amazon DataZone.
//
// Deletes a data source in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteDataSource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDataSource
func (c *DataZone) DeleteDataSource(input *DeleteDataSourceInput) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	return out, req.Send()
}

// DeleteDataSourceWithContext is the same as DeleteDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteDataSourceWithContext(ctx aws.Context, input *DeleteDataSourceInput, opts ...request.Option) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomain for more information on using the DeleteDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDomainRequest method.
//	req, resp := client.DeleteDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDomain
func (c *DataZone) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{identifier}",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	output = &DeleteDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDomain API operation for Amazon DataZone.
//
// Deletes a Amazon DataZone domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteDomain
func (c *DataZone) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	return out, req.Send()
}

// DeleteDomainWithContext is the same as DeleteDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteDomainWithContext(ctx aws.Context, input *DeleteDomainInput, opts ...request.Option) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironment = "DeleteEnvironment"

// DeleteEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironment for more information on using the DeleteEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEnvironmentRequest method.
//	req, resp := client.DeleteEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironment
func (c *DataZone) DeleteEnvironmentRequest(input *DeleteEnvironmentInput) (req *request.Request, output *DeleteEnvironmentOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{identifier}",
	}

	if input == nil {
		input = &DeleteEnvironmentInput{}
	}

	output = &DeleteEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEnvironment API operation for Amazon DataZone.
//
// Deletes an environment in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironment
func (c *DataZone) DeleteEnvironment(input *DeleteEnvironmentInput) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentWithContext is the same as DeleteEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteEnvironmentWithContext(ctx aws.Context, input *DeleteEnvironmentInput, opts ...request.Option) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironmentAction = "DeleteEnvironmentAction"

// DeleteEnvironmentActionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironmentAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironmentAction for more information on using the DeleteEnvironmentAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEnvironmentActionRequest method.
//	req, resp := client.DeleteEnvironmentActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentAction
func (c *DataZone) DeleteEnvironmentActionRequest(input *DeleteEnvironmentActionInput) (req *request.Request, output *DeleteEnvironmentActionOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironmentAction,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions/{identifier}",
	}

	if input == nil {
		input = &DeleteEnvironmentActionInput{}
	}

	output = &DeleteEnvironmentActionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEnvironmentAction API operation for Amazon DataZone.
//
// Deletes an action for the environment, for example, deletes a console link
// for an analytics tool that is available in this environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteEnvironmentAction for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentAction
func (c *DataZone) DeleteEnvironmentAction(input *DeleteEnvironmentActionInput) (*DeleteEnvironmentActionOutput, error) {
	req, out := c.DeleteEnvironmentActionRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentActionWithContext is the same as DeleteEnvironmentAction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironmentAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteEnvironmentActionWithContext(ctx aws.Context, input *DeleteEnvironmentActionInput, opts ...request.Option) (*DeleteEnvironmentActionOutput, error) {
	req, out := c.DeleteEnvironmentActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironmentBlueprintConfiguration = "DeleteEnvironmentBlueprintConfiguration"

// DeleteEnvironmentBlueprintConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironmentBlueprintConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironmentBlueprintConfiguration for more information on using the DeleteEnvironmentBlueprintConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEnvironmentBlueprintConfigurationRequest method.
//	req, resp := client.DeleteEnvironmentBlueprintConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentBlueprintConfiguration
func (c *DataZone) DeleteEnvironmentBlueprintConfigurationRequest(input *DeleteEnvironmentBlueprintConfigurationInput) (req *request.Request, output *DeleteEnvironmentBlueprintConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironmentBlueprintConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environment-blueprint-configurations/{environmentBlueprintIdentifier}",
	}

	if input == nil {
		input = &DeleteEnvironmentBlueprintConfigurationInput{}
	}

	output = &DeleteEnvironmentBlueprintConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEnvironmentBlueprintConfiguration API operation for Amazon DataZone.
//
// Deletes the blueprint configuration in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteEnvironmentBlueprintConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentBlueprintConfiguration
func (c *DataZone) DeleteEnvironmentBlueprintConfiguration(input *DeleteEnvironmentBlueprintConfigurationInput) (*DeleteEnvironmentBlueprintConfigurationOutput, error) {
	req, out := c.DeleteEnvironmentBlueprintConfigurationRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentBlueprintConfigurationWithContext is the same as DeleteEnvironmentBlueprintConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironmentBlueprintConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteEnvironmentBlueprintConfigurationWithContext(ctx aws.Context, input *DeleteEnvironmentBlueprintConfigurationInput, opts ...request.Option) (*DeleteEnvironmentBlueprintConfigurationOutput, error) {
	req, out := c.DeleteEnvironmentBlueprintConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironmentProfile = "DeleteEnvironmentProfile"

// DeleteEnvironmentProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironmentProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironmentProfile for more information on using the DeleteEnvironmentProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEnvironmentProfileRequest method.
//	req, resp := client.DeleteEnvironmentProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentProfile
func (c *DataZone) DeleteEnvironmentProfileRequest(input *DeleteEnvironmentProfileInput) (req *request.Request, output *DeleteEnvironmentProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironmentProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environment-profiles/{identifier}",
	}

	if input == nil {
		input = &DeleteEnvironmentProfileInput{}
	}

	output = &DeleteEnvironmentProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEnvironmentProfile API operation for Amazon DataZone.
//
// Deletes an environment profile in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteEnvironmentProfile for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteEnvironmentProfile
func (c *DataZone) DeleteEnvironmentProfile(input *DeleteEnvironmentProfileInput) (*DeleteEnvironmentProfileOutput, error) {
	req, out := c.DeleteEnvironmentProfileRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentProfileWithContext is the same as DeleteEnvironmentProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironmentProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteEnvironmentProfileWithContext(ctx aws.Context, input *DeleteEnvironmentProfileInput, opts ...request.Option) (*DeleteEnvironmentProfileOutput, error) {
	req, out := c.DeleteEnvironmentProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFormType = "DeleteFormType"

// DeleteFormTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFormType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFormType for more information on using the DeleteFormType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFormTypeRequest method.
//	req, resp := client.DeleteFormTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteFormType
func (c *DataZone) DeleteFormTypeRequest(input *DeleteFormTypeInput) (req *request.Request, output *DeleteFormTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteFormType,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/form-types/{formTypeIdentifier}",
	}

	if input == nil {
		input = &DeleteFormTypeInput{}
	}

	output = &DeleteFormTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFormType API operation for Amazon DataZone.
//
// Delets and metadata form type in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteFormType for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteFormType
func (c *DataZone) DeleteFormType(input *DeleteFormTypeInput) (*DeleteFormTypeOutput, error) {
	req, out := c.DeleteFormTypeRequest(input)
	return out, req.Send()
}

// DeleteFormTypeWithContext is the same as DeleteFormType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFormType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteFormTypeWithContext(ctx aws.Context, input *DeleteFormTypeInput, opts ...request.Option) (*DeleteFormTypeOutput, error) {
	req, out := c.DeleteFormTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGlossary = "DeleteGlossary"

// DeleteGlossaryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGlossary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGlossary for more information on using the DeleteGlossary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGlossaryRequest method.
//	req, resp := client.DeleteGlossaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossary
func (c *DataZone) DeleteGlossaryRequest(input *DeleteGlossaryInput) (req *request.Request, output *DeleteGlossaryOutput) {
	op := &request.Operation{
		Name:       opDeleteGlossary,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/glossaries/{identifier}",
	}

	if input == nil {
		input = &DeleteGlossaryInput{}
	}

	output = &DeleteGlossaryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGlossary API operation for Amazon DataZone.
//
// Deletes a business glossary in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteGlossary for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossary
func (c *DataZone) DeleteGlossary(input *DeleteGlossaryInput) (*DeleteGlossaryOutput, error) {
	req, out := c.DeleteGlossaryRequest(input)
	return out, req.Send()
}

// DeleteGlossaryWithContext is the same as DeleteGlossary with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGlossary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteGlossaryWithContext(ctx aws.Context, input *DeleteGlossaryInput, opts ...request.Option) (*DeleteGlossaryOutput, error) {
	req, out := c.DeleteGlossaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGlossaryTerm = "DeleteGlossaryTerm"

// DeleteGlossaryTermRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGlossaryTerm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGlossaryTerm for more information on using the DeleteGlossaryTerm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGlossaryTermRequest method.
//	req, resp := client.DeleteGlossaryTermRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossaryTerm
func (c *DataZone) DeleteGlossaryTermRequest(input *DeleteGlossaryTermInput) (req *request.Request, output *DeleteGlossaryTermOutput) {
	op := &request.Operation{
		Name:       opDeleteGlossaryTerm,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/glossary-terms/{identifier}",
	}

	if input == nil {
		input = &DeleteGlossaryTermInput{}
	}

	output = &DeleteGlossaryTermOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGlossaryTerm API operation for Amazon DataZone.
//
// Deletes a business glossary term in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteGlossaryTerm for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteGlossaryTerm
func (c *DataZone) DeleteGlossaryTerm(input *DeleteGlossaryTermInput) (*DeleteGlossaryTermOutput, error) {
	req, out := c.DeleteGlossaryTermRequest(input)
	return out, req.Send()
}

// DeleteGlossaryTermWithContext is the same as DeleteGlossaryTerm with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGlossaryTerm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteGlossaryTermWithContext(ctx aws.Context, input *DeleteGlossaryTermInput, opts ...request.Option) (*DeleteGlossaryTermOutput, error) {
	req, out := c.DeleteGlossaryTermRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteListing = "DeleteListing"

// DeleteListingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteListing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteListing for more information on using the DeleteListing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteListingRequest method.
//	req, resp := client.DeleteListingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteListing
func (c *DataZone) DeleteListingRequest(input *DeleteListingInput) (req *request.Request, output *DeleteListingOutput) {
	op := &request.Operation{
		Name:       opDeleteListing,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/listings/{identifier}",
	}

	if input == nil {
		input = &DeleteListingInput{}
	}

	output = &DeleteListingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteListing API operation for Amazon DataZone.
//
// Deletes a listing (a record of an asset at a given time).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteListing for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteListing
func (c *DataZone) DeleteListing(input *DeleteListingInput) (*DeleteListingOutput, error) {
	req, out := c.DeleteListingRequest(input)
	return out, req.Send()
}

// DeleteListingWithContext is the same as DeleteListing with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteListing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteListingWithContext(ctx aws.Context, input *DeleteListingInput, opts ...request.Option) (*DeleteListingOutput, error) {
	req, out := c.DeleteListingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProject for more information on using the DeleteProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProjectRequest method.
//	req, resp := client.DeleteProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProject
func (c *DataZone) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/projects/{identifier}",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProject API operation for Amazon DataZone.
//
// Deletes a project in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteProject for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProject
func (c *DataZone) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProjectMembership = "DeleteProjectMembership"

// DeleteProjectMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProjectMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProjectMembership for more information on using the DeleteProjectMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProjectMembershipRequest method.
//	req, resp := client.DeleteProjectMembershipRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProjectMembership
func (c *DataZone) DeleteProjectMembershipRequest(input *DeleteProjectMembershipInput) (req *request.Request, output *DeleteProjectMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteProjectMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/projects/{projectIdentifier}/deleteMembership",
	}

	if input == nil {
		input = &DeleteProjectMembershipInput{}
	}

	output = &DeleteProjectMembershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProjectMembership API operation for Amazon DataZone.
//
// Deletes project membership in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteProjectMembership for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteProjectMembership
func (c *DataZone) DeleteProjectMembership(input *DeleteProjectMembershipInput) (*DeleteProjectMembershipOutput, error) {
	req, out := c.DeleteProjectMembershipRequest(input)
	return out, req.Send()
}

// DeleteProjectMembershipWithContext is the same as DeleteProjectMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProjectMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteProjectMembershipWithContext(ctx aws.Context, input *DeleteProjectMembershipInput, opts ...request.Option) (*DeleteProjectMembershipOutput, error) {
	req, out := c.DeleteProjectMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubscriptionGrant = "DeleteSubscriptionGrant"

// DeleteSubscriptionGrantRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubscriptionGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubscriptionGrant for more information on using the DeleteSubscriptionGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSubscriptionGrantRequest method.
//	req, resp := client.DeleteSubscriptionGrantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionGrant
func (c *DataZone) DeleteSubscriptionGrantRequest(input *DeleteSubscriptionGrantInput) (req *request.Request, output *DeleteSubscriptionGrantOutput) {
	op := &request.Operation{
		Name:       opDeleteSubscriptionGrant,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscription-grants/{identifier}",
	}

	if input == nil {
		input = &DeleteSubscriptionGrantInput{}
	}

	output = &DeleteSubscriptionGrantOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSubscriptionGrant API operation for Amazon DataZone.
//
// Deletes and subscription grant in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteSubscriptionGrant for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionGrant
func (c *DataZone) DeleteSubscriptionGrant(input *DeleteSubscriptionGrantInput) (*DeleteSubscriptionGrantOutput, error) {
	req, out := c.DeleteSubscriptionGrantRequest(input)
	return out, req.Send()
}

// DeleteSubscriptionGrantWithContext is the same as DeleteSubscriptionGrant with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubscriptionGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteSubscriptionGrantWithContext(ctx aws.Context, input *DeleteSubscriptionGrantInput, opts ...request.Option) (*DeleteSubscriptionGrantOutput, error) {
	req, out := c.DeleteSubscriptionGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubscriptionRequest = "DeleteSubscriptionRequest"

// DeleteSubscriptionRequestRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubscriptionRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubscriptionRequest for more information on using the DeleteSubscriptionRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSubscriptionRequestRequest method.
//	req, resp := client.DeleteSubscriptionRequestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionRequest
func (c *DataZone) DeleteSubscriptionRequestRequest(input *DeleteSubscriptionRequestInput) (req *request.Request, output *DeleteSubscriptionRequestOutput) {
	op := &request.Operation{
		Name:       opDeleteSubscriptionRequest,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscription-requests/{identifier}",
	}

	if input == nil {
		input = &DeleteSubscriptionRequestInput{}
	}

	output = &DeleteSubscriptionRequestOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSubscriptionRequest API operation for Amazon DataZone.
//
// Deletes a subscription request in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteSubscriptionRequest for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionRequest
func (c *DataZone) DeleteSubscriptionRequest(input *DeleteSubscriptionRequestInput) (*DeleteSubscriptionRequestOutput, error) {
	req, out := c.DeleteSubscriptionRequestRequest(input)
	return out, req.Send()
}

// DeleteSubscriptionRequestWithContext is the same as DeleteSubscriptionRequest with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubscriptionRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteSubscriptionRequestWithContext(ctx aws.Context, input *DeleteSubscriptionRequestInput, opts ...request.Option) (*DeleteSubscriptionRequestOutput, error) {
	req, out := c.DeleteSubscriptionRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubscriptionTarget = "DeleteSubscriptionTarget"

// DeleteSubscriptionTargetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubscriptionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubscriptionTarget for more information on using the DeleteSubscriptionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSubscriptionTargetRequest method.
//	req, resp := client.DeleteSubscriptionTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionTarget
func (c *DataZone) DeleteSubscriptionTargetRequest(input *DeleteSubscriptionTargetInput) (req *request.Request, output *DeleteSubscriptionTargetOutput) {
	op := &request.Operation{
		Name:       opDeleteSubscriptionTarget,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets/{identifier}",
	}

	if input == nil {
		input = &DeleteSubscriptionTargetInput{}
	}

	output = &DeleteSubscriptionTargetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSubscriptionTarget API operation for Amazon DataZone.
//
// Deletes a subscription target in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteSubscriptionTarget for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteSubscriptionTarget
func (c *DataZone) DeleteSubscriptionTarget(input *DeleteSubscriptionTargetInput) (*DeleteSubscriptionTargetOutput, error) {
	req, out := c.DeleteSubscriptionTargetRequest(input)
	return out, req.Send()
}

// DeleteSubscriptionTargetWithContext is the same as DeleteSubscriptionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubscriptionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteSubscriptionTargetWithContext(ctx aws.Context, input *DeleteSubscriptionTargetInput, opts ...request.Option) (*DeleteSubscriptionTargetOutput, error) {
	req, out := c.DeleteSubscriptionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTimeSeriesDataPoints = "DeleteTimeSeriesDataPoints"

// DeleteTimeSeriesDataPointsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTimeSeriesDataPoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTimeSeriesDataPoints for more information on using the DeleteTimeSeriesDataPoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTimeSeriesDataPointsRequest method.
//	req, resp := client.DeleteTimeSeriesDataPointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteTimeSeriesDataPoints
func (c *DataZone) DeleteTimeSeriesDataPointsRequest(input *DeleteTimeSeriesDataPointsInput) (req *request.Request, output *DeleteTimeSeriesDataPointsOutput) {
	op := &request.Operation{
		Name:       opDeleteTimeSeriesDataPoints,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/time-series-data-points",
	}

	if input == nil {
		input = &DeleteTimeSeriesDataPointsInput{}
	}

	output = &DeleteTimeSeriesDataPointsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTimeSeriesDataPoints API operation for Amazon DataZone.
//
// Deletes the specified time series form for the specified asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DeleteTimeSeriesDataPoints for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DeleteTimeSeriesDataPoints
func (c *DataZone) DeleteTimeSeriesDataPoints(input *DeleteTimeSeriesDataPointsInput) (*DeleteTimeSeriesDataPointsOutput, error) {
	req, out := c.DeleteTimeSeriesDataPointsRequest(input)
	return out, req.Send()
}

// DeleteTimeSeriesDataPointsWithContext is the same as DeleteTimeSeriesDataPoints with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTimeSeriesDataPoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DeleteTimeSeriesDataPointsWithContext(ctx aws.Context, input *DeleteTimeSeriesDataPointsInput, opts ...request.Option) (*DeleteTimeSeriesDataPointsOutput, error) {
	req, out := c.DeleteTimeSeriesDataPointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateEnvironmentRole = "DisassociateEnvironmentRole"

// DisassociateEnvironmentRoleRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateEnvironmentRole operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateEnvironmentRole for more information on using the DisassociateEnvironmentRole
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateEnvironmentRoleRequest method.
//	req, resp := client.DisassociateEnvironmentRoleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DisassociateEnvironmentRole
func (c *DataZone) DisassociateEnvironmentRoleRequest(input *DisassociateEnvironmentRoleInput) (req *request.Request, output *DisassociateEnvironmentRoleOutput) {
	op := &request.Operation{
		Name:       opDisassociateEnvironmentRole,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/roles/{environmentRoleArn}",
	}

	if input == nil {
		input = &DisassociateEnvironmentRoleInput{}
	}

	output = &DisassociateEnvironmentRoleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateEnvironmentRole API operation for Amazon DataZone.
//
// Disassociates the environment role in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation DisassociateEnvironmentRole for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/DisassociateEnvironmentRole
func (c *DataZone) DisassociateEnvironmentRole(input *DisassociateEnvironmentRoleInput) (*DisassociateEnvironmentRoleOutput, error) {
	req, out := c.DisassociateEnvironmentRoleRequest(input)
	return out, req.Send()
}

// DisassociateEnvironmentRoleWithContext is the same as DisassociateEnvironmentRole with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateEnvironmentRole for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) DisassociateEnvironmentRoleWithContext(ctx aws.Context, input *DisassociateEnvironmentRoleInput, opts ...request.Option) (*DisassociateEnvironmentRoleOutput, error) {
	req, out := c.DisassociateEnvironmentRoleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAsset = "GetAsset"

// GetAssetRequest generates a "aws/request.Request" representing the
// client's request for the GetAsset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAsset for more information on using the GetAsset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAssetRequest method.
//	req, resp := client.GetAssetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAsset
func (c *DataZone) GetAssetRequest(input *GetAssetInput) (req *request.Request, output *GetAssetOutput) {
	op := &request.Operation{
		Name:       opGetAsset,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/assets/{identifier}",
	}

	if input == nil {
		input = &GetAssetInput{}
	}

	output = &GetAssetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAsset API operation for Amazon DataZone.
//
// Gets an Amazon DataZone asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetAsset for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAsset
func (c *DataZone) GetAsset(input *GetAssetInput) (*GetAssetOutput, error) {
	req, out := c.GetAssetRequest(input)
	return out, req.Send()
}

// GetAssetWithContext is the same as GetAsset with the addition of
// the ability to pass a context and additional request options.
//
// See GetAsset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetAssetWithContext(ctx aws.Context, input *GetAssetInput, opts ...request.Option) (*GetAssetOutput, error) {
	req, out := c.GetAssetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssetFilter = "GetAssetFilter"

// GetAssetFilterRequest generates a "aws/request.Request" representing the
// client's request for the GetAssetFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssetFilter for more information on using the GetAssetFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAssetFilterRequest method.
//	req, resp := client.GetAssetFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetFilter
func (c *DataZone) GetAssetFilterRequest(input *GetAssetFilterInput) (req *request.Request, output *GetAssetFilterOutput) {
	op := &request.Operation{
		Name:       opGetAssetFilter,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters/{identifier}",
	}

	if input == nil {
		input = &GetAssetFilterInput{}
	}

	output = &GetAssetFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssetFilter API operation for Amazon DataZone.
//
// Gets an asset filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetAssetFilter for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetFilter
func (c *DataZone) GetAssetFilter(input *GetAssetFilterInput) (*GetAssetFilterOutput, error) {
	req, out := c.GetAssetFilterRequest(input)
	return out, req.Send()
}

// GetAssetFilterWithContext is the same as GetAssetFilter with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssetFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetAssetFilterWithContext(ctx aws.Context, input *GetAssetFilterInput, opts ...request.Option) (*GetAssetFilterOutput, error) {
	req, out := c.GetAssetFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssetType = "GetAssetType"

// GetAssetTypeRequest generates a "aws/request.Request" representing the
// client's request for the GetAssetType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssetType for more information on using the GetAssetType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAssetTypeRequest method.
//	req, resp := client.GetAssetTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetType
func (c *DataZone) GetAssetTypeRequest(input *GetAssetTypeInput) (req *request.Request, output *GetAssetTypeOutput) {
	op := &request.Operation{
		Name:       opGetAssetType,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/asset-types/{identifier}",
	}

	if input == nil {
		input = &GetAssetTypeInput{}
	}

	output = &GetAssetTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssetType API operation for Amazon DataZone.
//
// Gets an Amazon DataZone asset type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetAssetType for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetAssetType
func (c *DataZone) GetAssetType(input *GetAssetTypeInput) (*GetAssetTypeOutput, error) {
	req, out := c.GetAssetTypeRequest(input)
	return out, req.Send()
}

// GetAssetTypeWithContext is the same as GetAssetType with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssetType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetAssetTypeWithContext(ctx aws.Context, input *GetAssetTypeInput, opts ...request.Option) (*GetAssetTypeOutput, error) {
	req, out := c.GetAssetTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataSource = "GetDataSource"

// GetDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the GetDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataSource for more information on using the GetDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataSourceRequest method.
//	req, resp := client.GetDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSource
func (c *DataZone) GetDataSourceRequest(input *GetDataSourceInput) (req *request.Request, output *GetDataSourceOutput) {
	op := &request.Operation{
		Name:       opGetDataSource,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/data-sources/{identifier}",
	}

	if input == nil {
		input = &GetDataSourceInput{}
	}

	output = &GetDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataSource API operation for Amazon DataZone.
//
// Gets an Amazon DataZone data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetDataSource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSource
func (c *DataZone) GetDataSource(input *GetDataSourceInput) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	return out, req.Send()
}

// GetDataSourceWithContext is the same as GetDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetDataSourceWithContext(ctx aws.Context, input *GetDataSourceInput, opts ...request.Option) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataSourceRun = "GetDataSourceRun"

// GetDataSourceRunRequest generates a "aws/request.Request" representing the
// client's request for the GetDataSourceRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataSourceRun for more information on using the GetDataSourceRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataSourceRunRequest method.
//	req, resp := client.GetDataSourceRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSourceRun
func (c *DataZone) GetDataSourceRunRequest(input *GetDataSourceRunInput) (req *request.Request, output *GetDataSourceRunOutput) {
	op := &request.Operation{
		Name:       opGetDataSourceRun,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/data-source-runs/{identifier}",
	}

	if input == nil {
		input = &GetDataSourceRunInput{}
	}

	output = &GetDataSourceRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataSourceRun API operation for Amazon DataZone.
//
// Gets an Amazon DataZone data source run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetDataSourceRun for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDataSourceRun
func (c *DataZone) GetDataSourceRun(input *GetDataSourceRunInput) (*GetDataSourceRunOutput, error) {
	req, out := c.GetDataSourceRunRequest(input)
	return out, req.Send()
}

// GetDataSourceRunWithContext is the same as GetDataSourceRun with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataSourceRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetDataSourceRunWithContext(ctx aws.Context, input *GetDataSourceRunInput, opts ...request.Option) (*GetDataSourceRunOutput, error) {
	req, out := c.GetDataSourceRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomain = "GetDomain"

// GetDomainRequest generates a "aws/request.Request" representing the
// client's request for the GetDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomain for more information on using the GetDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDomainRequest method.
//	req, resp := client.GetDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDomain
func (c *DataZone) GetDomainRequest(input *GetDomainInput) (req *request.Request, output *GetDomainOutput) {
	op := &request.Operation{
		Name:       opGetDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{identifier}",
	}

	if input == nil {
		input = &GetDomainInput{}
	}

	output = &GetDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomain API operation for Amazon DataZone.
//
// Gets an Amazon DataZone domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetDomain for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetDomain
func (c *DataZone) GetDomain(input *GetDomainInput) (*GetDomainOutput, error) {
	req, out := c.GetDomainRequest(input)
	return out, req.Send()
}

// GetDomainWithContext is the same as GetDomain with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetDomainWithContext(ctx aws.Context, input *GetDomainInput, opts ...request.Option) (*GetDomainOutput, error) {
	req, out := c.GetDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironment = "GetEnvironment"

// GetEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironment for more information on using the GetEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEnvironmentRequest method.
//	req, resp := client.GetEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironment
func (c *DataZone) GetEnvironmentRequest(input *GetEnvironmentInput) (req *request.Request, output *GetEnvironmentOutput) {
	op := &request.Operation{
		Name:       opGetEnvironment,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{identifier}",
	}

	if input == nil {
		input = &GetEnvironmentInput{}
	}

	output = &GetEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnvironment API operation for Amazon DataZone.
//
// Gets an Amazon DataZone environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironment
func (c *DataZone) GetEnvironment(input *GetEnvironmentInput) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	return out, req.Send()
}

// GetEnvironmentWithContext is the same as GetEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetEnvironmentWithContext(ctx aws.Context, input *GetEnvironmentInput, opts ...request.Option) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironmentAction = "GetEnvironmentAction"

// GetEnvironmentActionRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironmentAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironmentAction for more information on using the GetEnvironmentAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEnvironmentActionRequest method.
//	req, resp := client.GetEnvironmentActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentAction
func (c *DataZone) GetEnvironmentActionRequest(input *GetEnvironmentActionInput) (req *request.Request, output *GetEnvironmentActionOutput) {
	op := &request.Operation{
		Name:       opGetEnvironmentAction,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions/{identifier}",
	}

	if input == nil {
		input = &GetEnvironmentActionInput{}
	}

	output = &GetEnvironmentActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnvironmentAction API operation for Amazon DataZone.
//
// Gets the specified environment action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetEnvironmentAction for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentAction
func (c *DataZone) GetEnvironmentAction(input *GetEnvironmentActionInput) (*GetEnvironmentActionOutput, error) {
	req, out := c.GetEnvironmentActionRequest(input)
	return out, req.Send()
}

// GetEnvironmentActionWithContext is the same as GetEnvironmentAction with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironmentAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetEnvironmentActionWithContext(ctx aws.Context, input *GetEnvironmentActionInput, opts ...request.Option) (*GetEnvironmentActionOutput, error) {
	req, out := c.GetEnvironmentActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironmentBlueprint = "GetEnvironmentBlueprint"

// GetEnvironmentBlueprintRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironmentBlueprint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironmentBlueprint for more information on using the GetEnvironmentBlueprint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEnvironmentBlueprintRequest method.
//	req, resp := client.GetEnvironmentBlueprintRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprint
func (c *DataZone) GetEnvironmentBlueprintRequest(input *GetEnvironmentBlueprintInput) (req *request.Request, output *GetEnvironmentBlueprintOutput) {
	op := &request.Operation{
		Name:       opGetEnvironmentBlueprint,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environment-blueprints/{identifier}",
	}

	if input == nil {
		input = &GetEnvironmentBlueprintInput{}
	}

	output = &GetEnvironmentBlueprintOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnvironmentBlueprint API operation for Amazon DataZone.
//
// Gets an Amazon DataZone blueprint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetEnvironmentBlueprint for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprint
func (c *DataZone) GetEnvironmentBlueprint(input *GetEnvironmentBlueprintInput) (*GetEnvironmentBlueprintOutput, error) {
	req, out := c.GetEnvironmentBlueprintRequest(input)
	return out, req.Send()
}

// GetEnvironmentBlueprintWithContext is the same as GetEnvironmentBlueprint with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironmentBlueprint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetEnvironmentBlueprintWithContext(ctx aws.Context, input *GetEnvironmentBlueprintInput, opts ...request.Option) (*GetEnvironmentBlueprintOutput, error) {
	req, out := c.GetEnvironmentBlueprintRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironmentBlueprintConfiguration = "GetEnvironmentBlueprintConfiguration"

// GetEnvironmentBlueprintConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironmentBlueprintConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironmentBlueprintConfiguration for more information on using the GetEnvironmentBlueprintConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEnvironmentBlueprintConfigurationRequest method.
//	req, resp := client.GetEnvironmentBlueprintConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprintConfiguration
func (c *DataZone) GetEnvironmentBlueprintConfigurationRequest(input *GetEnvironmentBlueprintConfigurationInput) (req *request.Request, output *GetEnvironmentBlueprintConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetEnvironmentBlueprintConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environment-blueprint-configurations/{environmentBlueprintIdentifier}",
	}

	if input == nil {
		input = &GetEnvironmentBlueprintConfigurationInput{}
	}

	output = &GetEnvironmentBlueprintConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnvironmentBlueprintConfiguration API operation for Amazon DataZone.
//
// Gets the blueprint configuration in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetEnvironmentBlueprintConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentBlueprintConfiguration
func (c *DataZone) GetEnvironmentBlueprintConfiguration(input *GetEnvironmentBlueprintConfigurationInput) (*GetEnvironmentBlueprintConfigurationOutput, error) {
	req, out := c.GetEnvironmentBlueprintConfigurationRequest(input)
	return out, req.Send()
}

// GetEnvironmentBlueprintConfigurationWithContext is the same as GetEnvironmentBlueprintConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironmentBlueprintConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetEnvironmentBlueprintConfigurationWithContext(ctx aws.Context, input *GetEnvironmentBlueprintConfigurationInput, opts ...request.Option) (*GetEnvironmentBlueprintConfigurationOutput, error) {
	req, out := c.GetEnvironmentBlueprintConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironmentProfile = "GetEnvironmentProfile"

// GetEnvironmentProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironmentProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironmentProfile for more information on using the GetEnvironmentProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEnvironmentProfileRequest method.
//	req, resp := client.GetEnvironmentProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentProfile
func (c *DataZone) GetEnvironmentProfileRequest(input *GetEnvironmentProfileInput) (req *request.Request, output *GetEnvironmentProfileOutput) {
	op := &request.Operation{
		Name:       opGetEnvironmentProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environment-profiles/{identifier}",
	}

	if input == nil {
		input = &GetEnvironmentProfileInput{}
	}

	output = &GetEnvironmentProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnvironmentProfile API operation for Amazon DataZone.
//
// Gets an evinronment profile in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetEnvironmentProfile for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetEnvironmentProfile
func (c *DataZone) GetEnvironmentProfile(input *GetEnvironmentProfileInput) (*GetEnvironmentProfileOutput, error) {
	req, out := c.GetEnvironmentProfileRequest(input)
	return out, req.Send()
}

// GetEnvironmentProfileWithContext is the same as GetEnvironmentProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironmentProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetEnvironmentProfileWithContext(ctx aws.Context, input *GetEnvironmentProfileInput, opts ...request.Option) (*GetEnvironmentProfileOutput, error) {
	req, out := c.GetEnvironmentProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFormType = "GetFormType"

// GetFormTypeRequest generates a "aws/request.Request" representing the
// client's request for the GetFormType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFormType for more information on using the GetFormType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFormTypeRequest method.
//	req, resp := client.GetFormTypeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetFormType
func (c *DataZone) GetFormTypeRequest(input *GetFormTypeInput) (req *request.Request, output *GetFormTypeOutput) {
	op := &request.Operation{
		Name:       opGetFormType,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/form-types/{formTypeIdentifier}",
	}

	if input == nil {
		input = &GetFormTypeInput{}
	}

	output = &GetFormTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFormType API operation for Amazon DataZone.
//
// Gets a metadata form type in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetFormType for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetFormType
func (c *DataZone) GetFormType(input *GetFormTypeInput) (*GetFormTypeOutput, error) {
	req, out := c.GetFormTypeRequest(input)
	return out, req.Send()
}

// GetFormTypeWithContext is the same as GetFormType with the addition of
// the ability to pass a context and additional request options.
//
// See GetFormType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetFormTypeWithContext(ctx aws.Context, input *GetFormTypeInput, opts ...request.Option) (*GetFormTypeOutput, error) {
	req, out := c.GetFormTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGlossary = "GetGlossary"

// GetGlossaryRequest generates a "aws/request.Request" representing the
// client's request for the GetGlossary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGlossary for more information on using the GetGlossary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGlossaryRequest method.
//	req, resp := client.GetGlossaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossary
func (c *DataZone) GetGlossaryRequest(input *GetGlossaryInput) (req *request.Request, output *GetGlossaryOutput) {
	op := &request.Operation{
		Name:       opGetGlossary,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/glossaries/{identifier}",
	}

	if input == nil {
		input = &GetGlossaryInput{}
	}

	output = &GetGlossaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGlossary API operation for Amazon DataZone.
//
// Gets a business glossary in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetGlossary for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossary
func (c *DataZone) GetGlossary(input *GetGlossaryInput) (*GetGlossaryOutput, error) {
	req, out := c.GetGlossaryRequest(input)
	return out, req.Send()
}

// GetGlossaryWithContext is the same as GetGlossary with the addition of
// the ability to pass a context and additional request options.
//
// See GetGlossary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetGlossaryWithContext(ctx aws.Context, input *GetGlossaryInput, opts ...request.Option) (*GetGlossaryOutput, error) {
	req, out := c.GetGlossaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGlossaryTerm = "GetGlossaryTerm"

// GetGlossaryTermRequest generates a "aws/request.Request" representing the
// client's request for the GetGlossaryTerm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGlossaryTerm for more information on using the GetGlossaryTerm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGlossaryTermRequest method.
//	req, resp := client.GetGlossaryTermRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossaryTerm
func (c *DataZone) GetGlossaryTermRequest(input *GetGlossaryTermInput) (req *request.Request, output *GetGlossaryTermOutput) {
	op := &request.Operation{
		Name:       opGetGlossaryTerm,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/glossary-terms/{identifier}",
	}

	if input == nil {
		input = &GetGlossaryTermInput{}
	}

	output = &GetGlossaryTermOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGlossaryTerm API operation for Amazon DataZone.
//
// Gets a business glossary term in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetGlossaryTerm for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGlossaryTerm
func (c *DataZone) GetGlossaryTerm(input *GetGlossaryTermInput) (*GetGlossaryTermOutput, error) {
	req, out := c.GetGlossaryTermRequest(input)
	return out, req.Send()
}

// GetGlossaryTermWithContext is the same as GetGlossaryTerm with the addition of
// the ability to pass a context and additional request options.
//
// See GetGlossaryTerm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetGlossaryTermWithContext(ctx aws.Context, input *GetGlossaryTermInput, opts ...request.Option) (*GetGlossaryTermOutput, error) {
	req, out := c.GetGlossaryTermRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroupProfile = "GetGroupProfile"

// GetGroupProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetGroupProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroupProfile for more information on using the GetGroupProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGroupProfileRequest method.
//	req, resp := client.GetGroupProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGroupProfile
func (c *DataZone) GetGroupProfileRequest(input *GetGroupProfileInput) (req *request.Request, output *GetGroupProfileOutput) {
	op := &request.Operation{
		Name:       opGetGroupProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/group-profiles/{groupIdentifier}",
	}

	if input == nil {
		input = &GetGroupProfileInput{}
	}

	output = &GetGroupProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroupProfile API operation for Amazon DataZone.
//
// Gets a group profile in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetGroupProfile for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetGroupProfile
func (c *DataZone) GetGroupProfile(input *GetGroupProfileInput) (*GetGroupProfileOutput, error) {
	req, out := c.GetGroupProfileRequest(input)
	return out, req.Send()
}

// GetGroupProfileWithContext is the same as GetGroupProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroupProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetGroupProfileWithContext(ctx aws.Context, input *GetGroupProfileInput, opts ...request.Option) (*GetGroupProfileOutput, error) {
	req, out := c.GetGroupProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIamPortalLoginUrl = "GetIamPortalLoginUrl"

// GetIamPortalLoginUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetIamPortalLoginUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIamPortalLoginUrl for more information on using the GetIamPortalLoginUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIamPortalLoginUrlRequest method.
//	req, resp := client.GetIamPortalLoginUrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetIamPortalLoginUrl
func (c *DataZone) GetIamPortalLoginUrlRequest(input *GetIamPortalLoginUrlInput) (req *request.Request, output *GetIamPortalLoginUrlOutput) {
	op := &request.Operation{
		Name:       opGetIamPortalLoginUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/get-portal-login-url",
	}

	if input == nil {
		input = &GetIamPortalLoginUrlInput{}
	}

	output = &GetIamPortalLoginUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIamPortalLoginUrl API operation for Amazon DataZone.
//
// Gets the data portal URL for the specified Amazon DataZone domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetIamPortalLoginUrl for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetIamPortalLoginUrl
func (c *DataZone) GetIamPortalLoginUrl(input *GetIamPortalLoginUrlInput) (*GetIamPortalLoginUrlOutput, error) {
	req, out := c.GetIamPortalLoginUrlRequest(input)
	return out, req.Send()
}

// GetIamPortalLoginUrlWithContext is the same as GetIamPortalLoginUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetIamPortalLoginUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetIamPortalLoginUrlWithContext(ctx aws.Context, input *GetIamPortalLoginUrlInput, opts ...request.Option) (*GetIamPortalLoginUrlOutput, error) {
	req, out := c.GetIamPortalLoginUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLineageNode = "GetLineageNode"

// GetLineageNodeRequest generates a "aws/request.Request" representing the
// client's request for the GetLineageNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLineageNode for more information on using the GetLineageNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLineageNodeRequest method.
//	req, resp := client.GetLineageNodeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetLineageNode
func (c *DataZone) GetLineageNodeRequest(input *GetLineageNodeInput) (req *request.Request, output *GetLineageNodeOutput) {
	op := &request.Operation{
		Name:       opGetLineageNode,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/lineage/nodes/{identifier}",
	}

	if input == nil {
		input = &GetLineageNodeInput{}
	}

	output = &GetLineageNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLineageNode API operation for Amazon DataZone.
//
// Gets the data lineage node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetLineageNode for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetLineageNode
func (c *DataZone) GetLineageNode(input *GetLineageNodeInput) (*GetLineageNodeOutput, error) {
	req, out := c.GetLineageNodeRequest(input)
	return out, req.Send()
}

// GetLineageNodeWithContext is the same as GetLineageNode with the addition of
// the ability to pass a context and additional request options.
//
// See GetLineageNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetLineageNodeWithContext(ctx aws.Context, input *GetLineageNodeInput, opts ...request.Option) (*GetLineageNodeOutput, error) {
	req, out := c.GetLineageNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetListing = "GetListing"

// GetListingRequest generates a "aws/request.Request" representing the
// client's request for the GetListing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetListing for more information on using the GetListing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetListingRequest method.
//	req, resp := client.GetListingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetListing
func (c *DataZone) GetListingRequest(input *GetListingInput) (req *request.Request, output *GetListingOutput) {
	op := &request.Operation{
		Name:       opGetListing,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/listings/{identifier}",
	}

	if input == nil {
		input = &GetListingInput{}
	}

	output = &GetListingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetListing API operation for Amazon DataZone.
//
// Gets a listing (a record of an asset at a given time).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetListing for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetListing
func (c *DataZone) GetListing(input *GetListingInput) (*GetListingOutput, error) {
	req, out := c.GetListingRequest(input)
	return out, req.Send()
}

// GetListingWithContext is the same as GetListing with the addition of
// the ability to pass a context and additional request options.
//
// See GetListing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetListingWithContext(ctx aws.Context, input *GetListingInput, opts ...request.Option) (*GetListingOutput, error) {
	req, out := c.GetListingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMetadataGenerationRun = "GetMetadataGenerationRun"

// GetMetadataGenerationRunRequest generates a "aws/request.Request" representing the
// client's request for the GetMetadataGenerationRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMetadataGenerationRun for more information on using the GetMetadataGenerationRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMetadataGenerationRunRequest method.
//	req, resp := client.GetMetadataGenerationRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetMetadataGenerationRun
func (c *DataZone) GetMetadataGenerationRunRequest(input *GetMetadataGenerationRunInput) (req *request.Request, output *GetMetadataGenerationRunOutput) {
	op := &request.Operation{
		Name:       opGetMetadataGenerationRun,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/metadata-generation-runs/{identifier}",
	}

	if input == nil {
		input = &GetMetadataGenerationRunInput{}
	}

	output = &GetMetadataGenerationRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetadataGenerationRun API operation for Amazon DataZone.
//
// Gets a metadata generation run in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetMetadataGenerationRun for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetMetadataGenerationRun
func (c *DataZone) GetMetadataGenerationRun(input *GetMetadataGenerationRunInput) (*GetMetadataGenerationRunOutput, error) {
	req, out := c.GetMetadataGenerationRunRequest(input)
	return out, req.Send()
}

// GetMetadataGenerationRunWithContext is the same as GetMetadataGenerationRun with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetadataGenerationRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetMetadataGenerationRunWithContext(ctx aws.Context, input *GetMetadataGenerationRunInput, opts ...request.Option) (*GetMetadataGenerationRunOutput, error) {
	req, out := c.GetMetadataGenerationRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProject = "GetProject"

// GetProjectRequest generates a "aws/request.Request" representing the
// client's request for the GetProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProject for more information on using the GetProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProjectRequest method.
//	req, resp := client.GetProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetProject
func (c *DataZone) GetProjectRequest(input *GetProjectInput) (req *request.Request, output *GetProjectOutput) {
	op := &request.Operation{
		Name:       opGetProject,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/projects/{identifier}",
	}

	if input == nil {
		input = &GetProjectInput{}
	}

	output = &GetProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProject API operation for Amazon DataZone.
//
// Gets a project in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetProject for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetProject
func (c *DataZone) GetProject(input *GetProjectInput) (*GetProjectOutput, error) {
	req, out := c.GetProjectRequest(input)
	return out, req.Send()
}

// GetProjectWithContext is the same as GetProject with the addition of
// the ability to pass a context and additional request options.
//
// See GetProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetProjectWithContext(ctx aws.Context, input *GetProjectInput, opts ...request.Option) (*GetProjectOutput, error) {
	req, out := c.GetProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSubscription = "GetSubscription"

// GetSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the GetSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSubscription for more information on using the GetSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSubscriptionRequest method.
//	req, resp := client.GetSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscription
func (c *DataZone) GetSubscriptionRequest(input *GetSubscriptionInput) (req *request.Request, output *GetSubscriptionOutput) {
	op := &request.Operation{
		Name:       opGetSubscription,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscriptions/{identifier}",
	}

	if input == nil {
		input = &GetSubscriptionInput{}
	}

	output = &GetSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSubscription API operation for Amazon DataZone.
//
// Gets a subscription in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetSubscription for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscription
func (c *DataZone) GetSubscription(input *GetSubscriptionInput) (*GetSubscriptionOutput, error) {
	req, out := c.GetSubscriptionRequest(input)
	return out, req.Send()
}

// GetSubscriptionWithContext is the same as GetSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See GetSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetSubscriptionWithContext(ctx aws.Context, input *GetSubscriptionInput, opts ...request.Option) (*GetSubscriptionOutput, error) {
	req, out := c.GetSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSubscriptionGrant = "GetSubscriptionGrant"

// GetSubscriptionGrantRequest generates a "aws/request.Request" representing the
// client's request for the GetSubscriptionGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSubscriptionGrant for more information on using the GetSubscriptionGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSubscriptionGrantRequest method.
//	req, resp := client.GetSubscriptionGrantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionGrant
func (c *DataZone) GetSubscriptionGrantRequest(input *GetSubscriptionGrantInput) (req *request.Request, output *GetSubscriptionGrantOutput) {
	op := &request.Operation{
		Name:       opGetSubscriptionGrant,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscription-grants/{identifier}",
	}

	if input == nil {
		input = &GetSubscriptionGrantInput{}
	}

	output = &GetSubscriptionGrantOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSubscriptionGrant API operation for Amazon DataZone.
//
// Gets the subscription grant in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetSubscriptionGrant for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionGrant
func (c *DataZone) GetSubscriptionGrant(input *GetSubscriptionGrantInput) (*GetSubscriptionGrantOutput, error) {
	req, out := c.GetSubscriptionGrantRequest(input)
	return out, req.Send()
}

// GetSubscriptionGrantWithContext is the same as GetSubscriptionGrant with the addition of
// the ability to pass a context and additional request options.
//
// See GetSubscriptionGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetSubscriptionGrantWithContext(ctx aws.Context, input *GetSubscriptionGrantInput, opts ...request.Option) (*GetSubscriptionGrantOutput, error) {
	req, out := c.GetSubscriptionGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSubscriptionRequestDetails = "GetSubscriptionRequestDetails"

// GetSubscriptionRequestDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetSubscriptionRequestDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSubscriptionRequestDetails for more information on using the GetSubscriptionRequestDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSubscriptionRequestDetailsRequest method.
//	req, resp := client.GetSubscriptionRequestDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionRequestDetails
func (c *DataZone) GetSubscriptionRequestDetailsRequest(input *GetSubscriptionRequestDetailsInput) (req *request.Request, output *GetSubscriptionRequestDetailsOutput) {
	op := &request.Operation{
		Name:       opGetSubscriptionRequestDetails,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscription-requests/{identifier}",
	}

	if input == nil {
		input = &GetSubscriptionRequestDetailsInput{}
	}

	output = &GetSubscriptionRequestDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSubscriptionRequestDetails API operation for Amazon DataZone.
//
// Gets the details of the specified subscription request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetSubscriptionRequestDetails for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionRequestDetails
func (c *DataZone) GetSubscriptionRequestDetails(input *GetSubscriptionRequestDetailsInput) (*GetSubscriptionRequestDetailsOutput, error) {
	req, out := c.GetSubscriptionRequestDetailsRequest(input)
	return out, req.Send()
}

// GetSubscriptionRequestDetailsWithContext is the same as GetSubscriptionRequestDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetSubscriptionRequestDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetSubscriptionRequestDetailsWithContext(ctx aws.Context, input *GetSubscriptionRequestDetailsInput, opts ...request.Option) (*GetSubscriptionRequestDetailsOutput, error) {
	req, out := c.GetSubscriptionRequestDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSubscriptionTarget = "GetSubscriptionTarget"

// GetSubscriptionTargetRequest generates a "aws/request.Request" representing the
// client's request for the GetSubscriptionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSubscriptionTarget for more information on using the GetSubscriptionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSubscriptionTargetRequest method.
//	req, resp := client.GetSubscriptionTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionTarget
func (c *DataZone) GetSubscriptionTargetRequest(input *GetSubscriptionTargetInput) (req *request.Request, output *GetSubscriptionTargetOutput) {
	op := &request.Operation{
		Name:       opGetSubscriptionTarget,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets/{identifier}",
	}

	if input == nil {
		input = &GetSubscriptionTargetInput{}
	}

	output = &GetSubscriptionTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSubscriptionTarget API operation for Amazon DataZone.
//
// Gets the subscription target in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetSubscriptionTarget for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetSubscriptionTarget
func (c *DataZone) GetSubscriptionTarget(input *GetSubscriptionTargetInput) (*GetSubscriptionTargetOutput, error) {
	req, out := c.GetSubscriptionTargetRequest(input)
	return out, req.Send()
}

// GetSubscriptionTargetWithContext is the same as GetSubscriptionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See GetSubscriptionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetSubscriptionTargetWithContext(ctx aws.Context, input *GetSubscriptionTargetInput, opts ...request.Option) (*GetSubscriptionTargetOutput, error) {
	req, out := c.GetSubscriptionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTimeSeriesDataPoint = "GetTimeSeriesDataPoint"

// GetTimeSeriesDataPointRequest generates a "aws/request.Request" representing the
// client's request for the GetTimeSeriesDataPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTimeSeriesDataPoint for more information on using the GetTimeSeriesDataPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTimeSeriesDataPointRequest method.
//	req, resp := client.GetTimeSeriesDataPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetTimeSeriesDataPoint
func (c *DataZone) GetTimeSeriesDataPointRequest(input *GetTimeSeriesDataPointInput) (req *request.Request, output *GetTimeSeriesDataPointOutput) {
	op := &request.Operation{
		Name:       opGetTimeSeriesDataPoint,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/time-series-data-points/{identifier}",
	}

	if input == nil {
		input = &GetTimeSeriesDataPointInput{}
	}

	output = &GetTimeSeriesDataPointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTimeSeriesDataPoint API operation for Amazon DataZone.
//
// Gets the existing data point for the asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetTimeSeriesDataPoint for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetTimeSeriesDataPoint
func (c *DataZone) GetTimeSeriesDataPoint(input *GetTimeSeriesDataPointInput) (*GetTimeSeriesDataPointOutput, error) {
	req, out := c.GetTimeSeriesDataPointRequest(input)
	return out, req.Send()
}

// GetTimeSeriesDataPointWithContext is the same as GetTimeSeriesDataPoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetTimeSeriesDataPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetTimeSeriesDataPointWithContext(ctx aws.Context, input *GetTimeSeriesDataPointInput, opts ...request.Option) (*GetTimeSeriesDataPointOutput, error) {
	req, out := c.GetTimeSeriesDataPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserProfile = "GetUserProfile"

// GetUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserProfile for more information on using the GetUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetUserProfileRequest method.
//	req, resp := client.GetUserProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetUserProfile
func (c *DataZone) GetUserProfileRequest(input *GetUserProfileInput) (req *request.Request, output *GetUserProfileOutput) {
	op := &request.Operation{
		Name:       opGetUserProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/user-profiles/{userIdentifier}",
	}

	if input == nil {
		input = &GetUserProfileInput{}
	}

	output = &GetUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserProfile API operation for Amazon DataZone.
//
// Gets a user profile in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation GetUserProfile for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/GetUserProfile
func (c *DataZone) GetUserProfile(input *GetUserProfileInput) (*GetUserProfileOutput, error) {
	req, out := c.GetUserProfileRequest(input)
	return out, req.Send()
}

// GetUserProfileWithContext is the same as GetUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) GetUserProfileWithContext(ctx aws.Context, input *GetUserProfileInput, opts ...request.Option) (*GetUserProfileOutput, error) {
	req, out := c.GetUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssetFilters = "ListAssetFilters"

// ListAssetFiltersRequest generates a "aws/request.Request" representing the
// client's request for the ListAssetFilters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssetFilters for more information on using the ListAssetFilters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAssetFiltersRequest method.
//	req, resp := client.ListAssetFiltersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetFilters
func (c *DataZone) ListAssetFiltersRequest(input *ListAssetFiltersInput) (req *request.Request, output *ListAssetFiltersOutput) {
	op := &request.Operation{
		Name:       opListAssetFilters,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssetFiltersInput{}
	}

	output = &ListAssetFiltersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssetFilters API operation for Amazon DataZone.
//
// Lists asset filters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListAssetFilters for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetFilters
func (c *DataZone) ListAssetFilters(input *ListAssetFiltersInput) (*ListAssetFiltersOutput, error) {
	req, out := c.ListAssetFiltersRequest(input)
	return out, req.Send()
}

// ListAssetFiltersWithContext is the same as ListAssetFilters with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssetFilters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListAssetFiltersWithContext(ctx aws.Context, input *ListAssetFiltersInput, opts ...request.Option) (*ListAssetFiltersOutput, error) {
	req, out := c.ListAssetFiltersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssetFiltersPages iterates over the pages of a ListAssetFilters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssetFilters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAssetFilters operation.
//	pageNum := 0
//	err := client.ListAssetFiltersPages(params,
//	    func(page *datazone.ListAssetFiltersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListAssetFiltersPages(input *ListAssetFiltersInput, fn func(*ListAssetFiltersOutput, bool) bool) error {
	return c.ListAssetFiltersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssetFiltersPagesWithContext same as ListAssetFiltersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListAssetFiltersPagesWithContext(ctx aws.Context, input *ListAssetFiltersInput, fn func(*ListAssetFiltersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssetFiltersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssetFiltersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssetFiltersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssetRevisions = "ListAssetRevisions"

// ListAssetRevisionsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssetRevisions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssetRevisions for more information on using the ListAssetRevisions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAssetRevisionsRequest method.
//	req, resp := client.ListAssetRevisionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetRevisions
func (c *DataZone) ListAssetRevisionsRequest(input *ListAssetRevisionsInput) (req *request.Request, output *ListAssetRevisionsOutput) {
	op := &request.Operation{
		Name:       opListAssetRevisions,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/assets/{identifier}/revisions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssetRevisionsInput{}
	}

	output = &ListAssetRevisionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssetRevisions API operation for Amazon DataZone.
//
// Lists the revisions for the asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListAssetRevisions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListAssetRevisions
func (c *DataZone) ListAssetRevisions(input *ListAssetRevisionsInput) (*ListAssetRevisionsOutput, error) {
	req, out := c.ListAssetRevisionsRequest(input)
	return out, req.Send()
}

// ListAssetRevisionsWithContext is the same as ListAssetRevisions with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssetRevisions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListAssetRevisionsWithContext(ctx aws.Context, input *ListAssetRevisionsInput, opts ...request.Option) (*ListAssetRevisionsOutput, error) {
	req, out := c.ListAssetRevisionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssetRevisionsPages iterates over the pages of a ListAssetRevisions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssetRevisions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAssetRevisions operation.
//	pageNum := 0
//	err := client.ListAssetRevisionsPages(params,
//	    func(page *datazone.ListAssetRevisionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListAssetRevisionsPages(input *ListAssetRevisionsInput, fn func(*ListAssetRevisionsOutput, bool) bool) error {
	return c.ListAssetRevisionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssetRevisionsPagesWithContext same as ListAssetRevisionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListAssetRevisionsPagesWithContext(ctx aws.Context, input *ListAssetRevisionsInput, fn func(*ListAssetRevisionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssetRevisionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssetRevisionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssetRevisionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSourceRunActivities = "ListDataSourceRunActivities"

// ListDataSourceRunActivitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSourceRunActivities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSourceRunActivities for more information on using the ListDataSourceRunActivities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataSourceRunActivitiesRequest method.
//	req, resp := client.ListDataSourceRunActivitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRunActivities
func (c *DataZone) ListDataSourceRunActivitiesRequest(input *ListDataSourceRunActivitiesInput) (req *request.Request, output *ListDataSourceRunActivitiesOutput) {
	op := &request.Operation{
		Name:       opListDataSourceRunActivities,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/data-source-runs/{identifier}/activities",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourceRunActivitiesInput{}
	}

	output = &ListDataSourceRunActivitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSourceRunActivities API operation for Amazon DataZone.
//
// Lists data source run activities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListDataSourceRunActivities for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRunActivities
func (c *DataZone) ListDataSourceRunActivities(input *ListDataSourceRunActivitiesInput) (*ListDataSourceRunActivitiesOutput, error) {
	req, out := c.ListDataSourceRunActivitiesRequest(input)
	return out, req.Send()
}

// ListDataSourceRunActivitiesWithContext is the same as ListDataSourceRunActivities with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSourceRunActivities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListDataSourceRunActivitiesWithContext(ctx aws.Context, input *ListDataSourceRunActivitiesInput, opts ...request.Option) (*ListDataSourceRunActivitiesOutput, error) {
	req, out := c.ListDataSourceRunActivitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourceRunActivitiesPages iterates over the pages of a ListDataSourceRunActivities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSourceRunActivities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataSourceRunActivities operation.
//	pageNum := 0
//	err := client.ListDataSourceRunActivitiesPages(params,
//	    func(page *datazone.ListDataSourceRunActivitiesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListDataSourceRunActivitiesPages(input *ListDataSourceRunActivitiesInput, fn func(*ListDataSourceRunActivitiesOutput, bool) bool) error {
	return c.ListDataSourceRunActivitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourceRunActivitiesPagesWithContext same as ListDataSourceRunActivitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListDataSourceRunActivitiesPagesWithContext(ctx aws.Context, input *ListDataSourceRunActivitiesInput, fn func(*ListDataSourceRunActivitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourceRunActivitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourceRunActivitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourceRunActivitiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSourceRuns = "ListDataSourceRuns"

// ListDataSourceRunsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSourceRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSourceRuns for more information on using the ListDataSourceRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataSourceRunsRequest method.
//	req, resp := client.ListDataSourceRunsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRuns
func (c *DataZone) ListDataSourceRunsRequest(input *ListDataSourceRunsInput) (req *request.Request, output *ListDataSourceRunsOutput) {
	op := &request.Operation{
		Name:       opListDataSourceRuns,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/data-sources/{dataSourceIdentifier}/runs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourceRunsInput{}
	}

	output = &ListDataSourceRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSourceRuns API operation for Amazon DataZone.
//
// Lists data source runs in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListDataSourceRuns for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSourceRuns
func (c *DataZone) ListDataSourceRuns(input *ListDataSourceRunsInput) (*ListDataSourceRunsOutput, error) {
	req, out := c.ListDataSourceRunsRequest(input)
	return out, req.Send()
}

// ListDataSourceRunsWithContext is the same as ListDataSourceRuns with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSourceRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListDataSourceRunsWithContext(ctx aws.Context, input *ListDataSourceRunsInput, opts ...request.Option) (*ListDataSourceRunsOutput, error) {
	req, out := c.ListDataSourceRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourceRunsPages iterates over the pages of a ListDataSourceRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSourceRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataSourceRuns operation.
//	pageNum := 0
//	err := client.ListDataSourceRunsPages(params,
//	    func(page *datazone.ListDataSourceRunsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListDataSourceRunsPages(input *ListDataSourceRunsInput, fn func(*ListDataSourceRunsOutput, bool) bool) error {
	return c.ListDataSourceRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourceRunsPagesWithContext same as ListDataSourceRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListDataSourceRunsPagesWithContext(ctx aws.Context, input *ListDataSourceRunsInput, fn func(*ListDataSourceRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourceRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourceRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourceRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSources = "ListDataSources"

// ListDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSources for more information on using the ListDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataSourcesRequest method.
//	req, resp := client.ListDataSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSources
func (c *DataZone) ListDataSourcesRequest(input *ListDataSourcesInput) (req *request.Request, output *ListDataSourcesOutput) {
	op := &request.Operation{
		Name:       opListDataSources,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/data-sources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourcesInput{}
	}

	output = &ListDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSources API operation for Amazon DataZone.
//
// Lists data sources in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListDataSources for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDataSources
func (c *DataZone) ListDataSources(input *ListDataSourcesInput) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	return out, req.Send()
}

// ListDataSourcesWithContext is the same as ListDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListDataSourcesWithContext(ctx aws.Context, input *ListDataSourcesInput, opts ...request.Option) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourcesPages iterates over the pages of a ListDataSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataSources operation.
//	pageNum := 0
//	err := client.ListDataSourcesPages(params,
//	    func(page *datazone.ListDataSourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListDataSourcesPages(input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool) error {
	return c.ListDataSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourcesPagesWithContext same as ListDataSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListDataSourcesPagesWithContext(ctx aws.Context, input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomains for more information on using the ListDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDomainsRequest method.
//	req, resp := client.ListDomainsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomains
func (c *DataZone) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	output = &ListDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomains API operation for Amazon DataZone.
//
// Lists Amazon DataZone domains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListDomains for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListDomains
func (c *DataZone) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	return out, req.Send()
}

// ListDomainsWithContext is the same as ListDomains with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListDomainsWithContext(ctx aws.Context, input *ListDomainsInput, opts ...request.Option) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainsPages iterates over the pages of a ListDomains operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomains method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDomains operation.
//	pageNum := 0
//	err := client.ListDomainsPages(params,
//	    func(page *datazone.ListDomainsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListDomainsPages(input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool) error {
	return c.ListDomainsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainsPagesWithContext same as ListDomainsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListDomainsPagesWithContext(ctx aws.Context, input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDomainsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironmentActions = "ListEnvironmentActions"

// ListEnvironmentActionsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironmentActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironmentActions for more information on using the ListEnvironmentActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentActionsRequest method.
//	req, resp := client.ListEnvironmentActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentActions
func (c *DataZone) ListEnvironmentActionsRequest(input *ListEnvironmentActionsInput) (req *request.Request, output *ListEnvironmentActionsOutput) {
	op := &request.Operation{
		Name:       opListEnvironmentActions,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentActionsInput{}
	}

	output = &ListEnvironmentActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironmentActions API operation for Amazon DataZone.
//
// Lists existing environment actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListEnvironmentActions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentActions
func (c *DataZone) ListEnvironmentActions(input *ListEnvironmentActionsInput) (*ListEnvironmentActionsOutput, error) {
	req, out := c.ListEnvironmentActionsRequest(input)
	return out, req.Send()
}

// ListEnvironmentActionsWithContext is the same as ListEnvironmentActions with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironmentActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListEnvironmentActionsWithContext(ctx aws.Context, input *ListEnvironmentActionsInput, opts ...request.Option) (*ListEnvironmentActionsOutput, error) {
	req, out := c.ListEnvironmentActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentActionsPages iterates over the pages of a ListEnvironmentActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironmentActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnvironmentActions operation.
//	pageNum := 0
//	err := client.ListEnvironmentActionsPages(params,
//	    func(page *datazone.ListEnvironmentActionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListEnvironmentActionsPages(input *ListEnvironmentActionsInput, fn func(*ListEnvironmentActionsOutput, bool) bool) error {
	return c.ListEnvironmentActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentActionsPagesWithContext same as ListEnvironmentActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListEnvironmentActionsPagesWithContext(ctx aws.Context, input *ListEnvironmentActionsInput, fn func(*ListEnvironmentActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironmentBlueprintConfigurations = "ListEnvironmentBlueprintConfigurations"

// ListEnvironmentBlueprintConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironmentBlueprintConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironmentBlueprintConfigurations for more information on using the ListEnvironmentBlueprintConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentBlueprintConfigurationsRequest method.
//	req, resp := client.ListEnvironmentBlueprintConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprintConfigurations
func (c *DataZone) ListEnvironmentBlueprintConfigurationsRequest(input *ListEnvironmentBlueprintConfigurationsInput) (req *request.Request, output *ListEnvironmentBlueprintConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListEnvironmentBlueprintConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environment-blueprint-configurations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentBlueprintConfigurationsInput{}
	}

	output = &ListEnvironmentBlueprintConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironmentBlueprintConfigurations API operation for Amazon DataZone.
//
// Lists blueprint configurations for a Amazon DataZone environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListEnvironmentBlueprintConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprintConfigurations
func (c *DataZone) ListEnvironmentBlueprintConfigurations(input *ListEnvironmentBlueprintConfigurationsInput) (*ListEnvironmentBlueprintConfigurationsOutput, error) {
	req, out := c.ListEnvironmentBlueprintConfigurationsRequest(input)
	return out, req.Send()
}

// ListEnvironmentBlueprintConfigurationsWithContext is the same as ListEnvironmentBlueprintConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironmentBlueprintConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListEnvironmentBlueprintConfigurationsWithContext(ctx aws.Context, input *ListEnvironmentBlueprintConfigurationsInput, opts ...request.Option) (*ListEnvironmentBlueprintConfigurationsOutput, error) {
	req, out := c.ListEnvironmentBlueprintConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentBlueprintConfigurationsPages iterates over the pages of a ListEnvironmentBlueprintConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironmentBlueprintConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnvironmentBlueprintConfigurations operation.
//	pageNum := 0
//	err := client.ListEnvironmentBlueprintConfigurationsPages(params,
//	    func(page *datazone.ListEnvironmentBlueprintConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListEnvironmentBlueprintConfigurationsPages(input *ListEnvironmentBlueprintConfigurationsInput, fn func(*ListEnvironmentBlueprintConfigurationsOutput, bool) bool) error {
	return c.ListEnvironmentBlueprintConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentBlueprintConfigurationsPagesWithContext same as ListEnvironmentBlueprintConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListEnvironmentBlueprintConfigurationsPagesWithContext(ctx aws.Context, input *ListEnvironmentBlueprintConfigurationsInput, fn func(*ListEnvironmentBlueprintConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentBlueprintConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentBlueprintConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentBlueprintConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironmentBlueprints = "ListEnvironmentBlueprints"

// ListEnvironmentBlueprintsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironmentBlueprints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironmentBlueprints for more information on using the ListEnvironmentBlueprints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentBlueprintsRequest method.
//	req, resp := client.ListEnvironmentBlueprintsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprints
func (c *DataZone) ListEnvironmentBlueprintsRequest(input *ListEnvironmentBlueprintsInput) (req *request.Request, output *ListEnvironmentBlueprintsOutput) {
	op := &request.Operation{
		Name:       opListEnvironmentBlueprints,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environment-blueprints",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentBlueprintsInput{}
	}

	output = &ListEnvironmentBlueprintsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironmentBlueprints API operation for Amazon DataZone.
//
// Lists blueprints in an Amazon DataZone environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListEnvironmentBlueprints for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentBlueprints
func (c *DataZone) ListEnvironmentBlueprints(input *ListEnvironmentBlueprintsInput) (*ListEnvironmentBlueprintsOutput, error) {
	req, out := c.ListEnvironmentBlueprintsRequest(input)
	return out, req.Send()
}

// ListEnvironmentBlueprintsWithContext is the same as ListEnvironmentBlueprints with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironmentBlueprints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListEnvironmentBlueprintsWithContext(ctx aws.Context, input *ListEnvironmentBlueprintsInput, opts ...request.Option) (*ListEnvironmentBlueprintsOutput, error) {
	req, out := c.ListEnvironmentBlueprintsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentBlueprintsPages iterates over the pages of a ListEnvironmentBlueprints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironmentBlueprints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnvironmentBlueprints operation.
//	pageNum := 0
//	err := client.ListEnvironmentBlueprintsPages(params,
//	    func(page *datazone.ListEnvironmentBlueprintsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListEnvironmentBlueprintsPages(input *ListEnvironmentBlueprintsInput, fn func(*ListEnvironmentBlueprintsOutput, bool) bool) error {
	return c.ListEnvironmentBlueprintsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentBlueprintsPagesWithContext same as ListEnvironmentBlueprintsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListEnvironmentBlueprintsPagesWithContext(ctx aws.Context, input *ListEnvironmentBlueprintsInput, fn func(*ListEnvironmentBlueprintsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentBlueprintsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentBlueprintsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentBlueprintsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironmentProfiles = "ListEnvironmentProfiles"

// ListEnvironmentProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironmentProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironmentProfiles for more information on using the ListEnvironmentProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentProfilesRequest method.
//	req, resp := client.ListEnvironmentProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentProfiles
func (c *DataZone) ListEnvironmentProfilesRequest(input *ListEnvironmentProfilesInput) (req *request.Request, output *ListEnvironmentProfilesOutput) {
	op := &request.Operation{
		Name:       opListEnvironmentProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environment-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentProfilesInput{}
	}

	output = &ListEnvironmentProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironmentProfiles API operation for Amazon DataZone.
//
// Lists Amazon DataZone environment profiles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListEnvironmentProfiles for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironmentProfiles
func (c *DataZone) ListEnvironmentProfiles(input *ListEnvironmentProfilesInput) (*ListEnvironmentProfilesOutput, error) {
	req, out := c.ListEnvironmentProfilesRequest(input)
	return out, req.Send()
}

// ListEnvironmentProfilesWithContext is the same as ListEnvironmentProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironmentProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListEnvironmentProfilesWithContext(ctx aws.Context, input *ListEnvironmentProfilesInput, opts ...request.Option) (*ListEnvironmentProfilesOutput, error) {
	req, out := c.ListEnvironmentProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentProfilesPages iterates over the pages of a ListEnvironmentProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironmentProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnvironmentProfiles operation.
//	pageNum := 0
//	err := client.ListEnvironmentProfilesPages(params,
//	    func(page *datazone.ListEnvironmentProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListEnvironmentProfilesPages(input *ListEnvironmentProfilesInput, fn func(*ListEnvironmentProfilesOutput, bool) bool) error {
	return c.ListEnvironmentProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentProfilesPagesWithContext same as ListEnvironmentProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListEnvironmentProfilesPagesWithContext(ctx aws.Context, input *ListEnvironmentProfilesInput, fn func(*ListEnvironmentProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironments = "ListEnvironments"

// ListEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironments for more information on using the ListEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentsRequest method.
//	req, resp := client.ListEnvironmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironments
func (c *DataZone) ListEnvironmentsRequest(input *ListEnvironmentsInput) (req *request.Request, output *ListEnvironmentsOutput) {
	op := &request.Operation{
		Name:       opListEnvironments,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentsInput{}
	}

	output = &ListEnvironmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironments API operation for Amazon DataZone.
//
// Lists Amazon DataZone environments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListEnvironments for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListEnvironments
func (c *DataZone) ListEnvironments(input *ListEnvironmentsInput) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	return out, req.Send()
}

// ListEnvironmentsWithContext is the same as ListEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListEnvironmentsWithContext(ctx aws.Context, input *ListEnvironmentsInput, opts ...request.Option) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentsPages iterates over the pages of a ListEnvironments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnvironments operation.
//	pageNum := 0
//	err := client.ListEnvironmentsPages(params,
//	    func(page *datazone.ListEnvironmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListEnvironmentsPages(input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool) error {
	return c.ListEnvironmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentsPagesWithContext same as ListEnvironmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListEnvironmentsPagesWithContext(ctx aws.Context, input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLineageNodeHistory = "ListLineageNodeHistory"

// ListLineageNodeHistoryRequest generates a "aws/request.Request" representing the
// client's request for the ListLineageNodeHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLineageNodeHistory for more information on using the ListLineageNodeHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLineageNodeHistoryRequest method.
//	req, resp := client.ListLineageNodeHistoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageNodeHistory
func (c *DataZone) ListLineageNodeHistoryRequest(input *ListLineageNodeHistoryInput) (req *request.Request, output *ListLineageNodeHistoryOutput) {
	op := &request.Operation{
		Name:       opListLineageNodeHistory,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/lineage/nodes/{identifier}/history",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLineageNodeHistoryInput{}
	}

	output = &ListLineageNodeHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLineageNodeHistory API operation for Amazon DataZone.
//
// Lists the history of the specified data lineage node.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListLineageNodeHistory for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListLineageNodeHistory
func (c *DataZone) ListLineageNodeHistory(input *ListLineageNodeHistoryInput) (*ListLineageNodeHistoryOutput, error) {
	req, out := c.ListLineageNodeHistoryRequest(input)
	return out, req.Send()
}

// ListLineageNodeHistoryWithContext is the same as ListLineageNodeHistory with the addition of
// the ability to pass a context and additional request options.
//
// See ListLineageNodeHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListLineageNodeHistoryWithContext(ctx aws.Context, input *ListLineageNodeHistoryInput, opts ...request.Option) (*ListLineageNodeHistoryOutput, error) {
	req, out := c.ListLineageNodeHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLineageNodeHistoryPages iterates over the pages of a ListLineageNodeHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLineageNodeHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLineageNodeHistory operation.
//	pageNum := 0
//	err := client.ListLineageNodeHistoryPages(params,
//	    func(page *datazone.ListLineageNodeHistoryOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListLineageNodeHistoryPages(input *ListLineageNodeHistoryInput, fn func(*ListLineageNodeHistoryOutput, bool) bool) error {
	return c.ListLineageNodeHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLineageNodeHistoryPagesWithContext same as ListLineageNodeHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListLineageNodeHistoryPagesWithContext(ctx aws.Context, input *ListLineageNodeHistoryInput, fn func(*ListLineageNodeHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLineageNodeHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLineageNodeHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLineageNodeHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMetadataGenerationRuns = "ListMetadataGenerationRuns"

// ListMetadataGenerationRunsRequest generates a "aws/request.Request" representing the
// client's request for the ListMetadataGenerationRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMetadataGenerationRuns for more information on using the ListMetadataGenerationRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMetadataGenerationRunsRequest method.
//	req, resp := client.ListMetadataGenerationRunsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListMetadataGenerationRuns
func (c *DataZone) ListMetadataGenerationRunsRequest(input *ListMetadataGenerationRunsInput) (req *request.Request, output *ListMetadataGenerationRunsOutput) {
	op := &request.Operation{
		Name:       opListMetadataGenerationRuns,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/metadata-generation-runs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMetadataGenerationRunsInput{}
	}

	output = &ListMetadataGenerationRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMetadataGenerationRuns API operation for Amazon DataZone.
//
// Lists all metadata generation runs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListMetadataGenerationRuns for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListMetadataGenerationRuns
func (c *DataZone) ListMetadataGenerationRuns(input *ListMetadataGenerationRunsInput) (*ListMetadataGenerationRunsOutput, error) {
	req, out := c.ListMetadataGenerationRunsRequest(input)
	return out, req.Send()
}

// ListMetadataGenerationRunsWithContext is the same as ListMetadataGenerationRuns with the addition of
// the ability to pass a context and additional request options.
//
// See ListMetadataGenerationRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListMetadataGenerationRunsWithContext(ctx aws.Context, input *ListMetadataGenerationRunsInput, opts ...request.Option) (*ListMetadataGenerationRunsOutput, error) {
	req, out := c.ListMetadataGenerationRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMetadataGenerationRunsPages iterates over the pages of a ListMetadataGenerationRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMetadataGenerationRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMetadataGenerationRuns operation.
//	pageNum := 0
//	err := client.ListMetadataGenerationRunsPages(params,
//	    func(page *datazone.ListMetadataGenerationRunsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListMetadataGenerationRunsPages(input *ListMetadataGenerationRunsInput, fn func(*ListMetadataGenerationRunsOutput, bool) bool) error {
	return c.ListMetadataGenerationRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMetadataGenerationRunsPagesWithContext same as ListMetadataGenerationRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListMetadataGenerationRunsPagesWithContext(ctx aws.Context, input *ListMetadataGenerationRunsInput, fn func(*ListMetadataGenerationRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMetadataGenerationRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMetadataGenerationRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMetadataGenerationRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNotifications = "ListNotifications"

// ListNotificationsRequest generates a "aws/request.Request" representing the
// client's request for the ListNotifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotifications for more information on using the ListNotifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNotificationsRequest method.
//	req, resp := client.ListNotificationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListNotifications
func (c *DataZone) ListNotificationsRequest(input *ListNotificationsInput) (req *request.Request, output *ListNotificationsOutput) {
	op := &request.Operation{
		Name:       opListNotifications,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/notifications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotificationsInput{}
	}

	output = &ListNotificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotifications API operation for Amazon DataZone.
//
// Lists all Amazon DataZone notifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListNotifications for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListNotifications
func (c *DataZone) ListNotifications(input *ListNotificationsInput) (*ListNotificationsOutput, error) {
	req, out := c.ListNotificationsRequest(input)
	return out, req.Send()
}

// ListNotificationsWithContext is the same as ListNotifications with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListNotificationsWithContext(ctx aws.Context, input *ListNotificationsInput, opts ...request.Option) (*ListNotificationsOutput, error) {
	req, out := c.ListNotificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotificationsPages iterates over the pages of a ListNotifications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotifications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListNotifications operation.
//	pageNum := 0
//	err := client.ListNotificationsPages(params,
//	    func(page *datazone.ListNotificationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListNotificationsPages(input *ListNotificationsInput, fn func(*ListNotificationsOutput, bool) bool) error {
	return c.ListNotificationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotificationsPagesWithContext same as ListNotificationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListNotificationsPagesWithContext(ctx aws.Context, input *ListNotificationsInput, fn func(*ListNotificationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotificationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotificationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNotificationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProjectMemberships = "ListProjectMemberships"

// ListProjectMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjectMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjectMemberships for more information on using the ListProjectMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProjectMembershipsRequest method.
//	req, resp := client.ListProjectMembershipsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectMemberships
func (c *DataZone) ListProjectMembershipsRequest(input *ListProjectMembershipsInput) (req *request.Request, output *ListProjectMembershipsOutput) {
	op := &request.Operation{
		Name:       opListProjectMemberships,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/projects/{projectIdentifier}/memberships",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectMembershipsInput{}
	}

	output = &ListProjectMembershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjectMemberships API operation for Amazon DataZone.
//
// Lists all members of the specified project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListProjectMemberships for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjectMemberships
func (c *DataZone) ListProjectMemberships(input *ListProjectMembershipsInput) (*ListProjectMembershipsOutput, error) {
	req, out := c.ListProjectMembershipsRequest(input)
	return out, req.Send()
}

// ListProjectMembershipsWithContext is the same as ListProjectMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjectMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListProjectMembershipsWithContext(ctx aws.Context, input *ListProjectMembershipsInput, opts ...request.Option) (*ListProjectMembershipsOutput, error) {
	req, out := c.ListProjectMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProjectMembershipsPages iterates over the pages of a ListProjectMemberships operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProjectMemberships method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProjectMemberships operation.
//	pageNum := 0
//	err := client.ListProjectMembershipsPages(params,
//	    func(page *datazone.ListProjectMembershipsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListProjectMembershipsPages(input *ListProjectMembershipsInput, fn func(*ListProjectMembershipsOutput, bool) bool) error {
	return c.ListProjectMembershipsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProjectMembershipsPagesWithContext same as ListProjectMembershipsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListProjectMembershipsPagesWithContext(ctx aws.Context, input *ListProjectMembershipsInput, fn func(*ListProjectMembershipsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProjectMembershipsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProjectMembershipsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProjectMembershipsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjects for more information on using the ListProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProjectsRequest method.
//	req, resp := client.ListProjectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjects
func (c *DataZone) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/projects",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjects API operation for Amazon DataZone.
//
// Lists Amazon DataZone projects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListProjects for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListProjects
func (c *DataZone) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProjectsPages iterates over the pages of a ListProjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProjects operation.
//	pageNum := 0
//	err := client.ListProjectsPages(params,
//	    func(page *datazone.ListProjectsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListProjectsPages(input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool) error {
	return c.ListProjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProjectsPagesWithContext same as ListProjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListProjectsPagesWithContext(ctx aws.Context, input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSubscriptionGrants = "ListSubscriptionGrants"

// ListSubscriptionGrantsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscriptionGrants operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubscriptionGrants for more information on using the ListSubscriptionGrants
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSubscriptionGrantsRequest method.
//	req, resp := client.ListSubscriptionGrantsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionGrants
func (c *DataZone) ListSubscriptionGrantsRequest(input *ListSubscriptionGrantsInput) (req *request.Request, output *ListSubscriptionGrantsOutput) {
	op := &request.Operation{
		Name:       opListSubscriptionGrants,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscription-grants",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSubscriptionGrantsInput{}
	}

	output = &ListSubscriptionGrantsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscriptionGrants API operation for Amazon DataZone.
//
// Lists subscription grants.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListSubscriptionGrants for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionGrants
func (c *DataZone) ListSubscriptionGrants(input *ListSubscriptionGrantsInput) (*ListSubscriptionGrantsOutput, error) {
	req, out := c.ListSubscriptionGrantsRequest(input)
	return out, req.Send()
}

// ListSubscriptionGrantsWithContext is the same as ListSubscriptionGrants with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubscriptionGrants for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListSubscriptionGrantsWithContext(ctx aws.Context, input *ListSubscriptionGrantsInput, opts ...request.Option) (*ListSubscriptionGrantsOutput, error) {
	req, out := c.ListSubscriptionGrantsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSubscriptionGrantsPages iterates over the pages of a ListSubscriptionGrants operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSubscriptionGrants method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSubscriptionGrants operation.
//	pageNum := 0
//	err := client.ListSubscriptionGrantsPages(params,
//	    func(page *datazone.ListSubscriptionGrantsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListSubscriptionGrantsPages(input *ListSubscriptionGrantsInput, fn func(*ListSubscriptionGrantsOutput, bool) bool) error {
	return c.ListSubscriptionGrantsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSubscriptionGrantsPagesWithContext same as ListSubscriptionGrantsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListSubscriptionGrantsPagesWithContext(ctx aws.Context, input *ListSubscriptionGrantsInput, fn func(*ListSubscriptionGrantsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSubscriptionGrantsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSubscriptionGrantsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSubscriptionGrantsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSubscriptionRequests = "ListSubscriptionRequests"

// ListSubscriptionRequestsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscriptionRequests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubscriptionRequests for more information on using the ListSubscriptionRequests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSubscriptionRequestsRequest method.
//	req, resp := client.ListSubscriptionRequestsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionRequests
func (c *DataZone) ListSubscriptionRequestsRequest(input *ListSubscriptionRequestsInput) (req *request.Request, output *ListSubscriptionRequestsOutput) {
	op := &request.Operation{
		Name:       opListSubscriptionRequests,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscription-requests",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSubscriptionRequestsInput{}
	}

	output = &ListSubscriptionRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscriptionRequests API operation for Amazon DataZone.
//
// Lists Amazon DataZone subscription requests.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListSubscriptionRequests for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionRequests
func (c *DataZone) ListSubscriptionRequests(input *ListSubscriptionRequestsInput) (*ListSubscriptionRequestsOutput, error) {
	req, out := c.ListSubscriptionRequestsRequest(input)
	return out, req.Send()
}

// ListSubscriptionRequestsWithContext is the same as ListSubscriptionRequests with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubscriptionRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListSubscriptionRequestsWithContext(ctx aws.Context, input *ListSubscriptionRequestsInput, opts ...request.Option) (*ListSubscriptionRequestsOutput, error) {
	req, out := c.ListSubscriptionRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSubscriptionRequestsPages iterates over the pages of a ListSubscriptionRequests operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSubscriptionRequests method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSubscriptionRequests operation.
//	pageNum := 0
//	err := client.ListSubscriptionRequestsPages(params,
//	    func(page *datazone.ListSubscriptionRequestsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListSubscriptionRequestsPages(input *ListSubscriptionRequestsInput, fn func(*ListSubscriptionRequestsOutput, bool) bool) error {
	return c.ListSubscriptionRequestsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSubscriptionRequestsPagesWithContext same as ListSubscriptionRequestsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListSubscriptionRequestsPagesWithContext(ctx aws.Context, input *ListSubscriptionRequestsInput, fn func(*ListSubscriptionRequestsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSubscriptionRequestsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSubscriptionRequestsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSubscriptionRequestsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSubscriptionTargets = "ListSubscriptionTargets"

// ListSubscriptionTargetsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscriptionTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubscriptionTargets for more information on using the ListSubscriptionTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSubscriptionTargetsRequest method.
//	req, resp := client.ListSubscriptionTargetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionTargets
func (c *DataZone) ListSubscriptionTargetsRequest(input *ListSubscriptionTargetsInput) (req *request.Request, output *ListSubscriptionTargetsOutput) {
	op := &request.Operation{
		Name:       opListSubscriptionTargets,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSubscriptionTargetsInput{}
	}

	output = &ListSubscriptionTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscriptionTargets API operation for Amazon DataZone.
//
// Lists subscription targets in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListSubscriptionTargets for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptionTargets
func (c *DataZone) ListSubscriptionTargets(input *ListSubscriptionTargetsInput) (*ListSubscriptionTargetsOutput, error) {
	req, out := c.ListSubscriptionTargetsRequest(input)
	return out, req.Send()
}

// ListSubscriptionTargetsWithContext is the same as ListSubscriptionTargets with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubscriptionTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListSubscriptionTargetsWithContext(ctx aws.Context, input *ListSubscriptionTargetsInput, opts ...request.Option) (*ListSubscriptionTargetsOutput, error) {
	req, out := c.ListSubscriptionTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSubscriptionTargetsPages iterates over the pages of a ListSubscriptionTargets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSubscriptionTargets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSubscriptionTargets operation.
//	pageNum := 0
//	err := client.ListSubscriptionTargetsPages(params,
//	    func(page *datazone.ListSubscriptionTargetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListSubscriptionTargetsPages(input *ListSubscriptionTargetsInput, fn func(*ListSubscriptionTargetsOutput, bool) bool) error {
	return c.ListSubscriptionTargetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSubscriptionTargetsPagesWithContext same as ListSubscriptionTargetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListSubscriptionTargetsPagesWithContext(ctx aws.Context, input *ListSubscriptionTargetsInput, fn func(*ListSubscriptionTargetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSubscriptionTargetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSubscriptionTargetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSubscriptionTargetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSubscriptions = "ListSubscriptions"

// ListSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubscriptions for more information on using the ListSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSubscriptionsRequest method.
//	req, resp := client.ListSubscriptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptions
func (c *DataZone) ListSubscriptionsRequest(input *ListSubscriptionsInput) (req *request.Request, output *ListSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opListSubscriptions,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscriptions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSubscriptionsInput{}
	}

	output = &ListSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscriptions API operation for Amazon DataZone.
//
// Lists subscriptions in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListSubscriptions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListSubscriptions
func (c *DataZone) ListSubscriptions(input *ListSubscriptionsInput) (*ListSubscriptionsOutput, error) {
	req, out := c.ListSubscriptionsRequest(input)
	return out, req.Send()
}

// ListSubscriptionsWithContext is the same as ListSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListSubscriptionsWithContext(ctx aws.Context, input *ListSubscriptionsInput, opts ...request.Option) (*ListSubscriptionsOutput, error) {
	req, out := c.ListSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSubscriptionsPages iterates over the pages of a ListSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSubscriptions operation.
//	pageNum := 0
//	err := client.ListSubscriptionsPages(params,
//	    func(page *datazone.ListSubscriptionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListSubscriptionsPages(input *ListSubscriptionsInput, fn func(*ListSubscriptionsOutput, bool) bool) error {
	return c.ListSubscriptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSubscriptionsPagesWithContext same as ListSubscriptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListSubscriptionsPagesWithContext(ctx aws.Context, input *ListSubscriptionsInput, fn func(*ListSubscriptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSubscriptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSubscriptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSubscriptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTagsForResource
func (c *DataZone) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon DataZone.
//
// Lists tags for the specified resource in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTagsForResource
func (c *DataZone) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTimeSeriesDataPoints = "ListTimeSeriesDataPoints"

// ListTimeSeriesDataPointsRequest generates a "aws/request.Request" representing the
// client's request for the ListTimeSeriesDataPoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTimeSeriesDataPoints for more information on using the ListTimeSeriesDataPoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTimeSeriesDataPointsRequest method.
//	req, resp := client.ListTimeSeriesDataPointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTimeSeriesDataPoints
func (c *DataZone) ListTimeSeriesDataPointsRequest(input *ListTimeSeriesDataPointsInput) (req *request.Request, output *ListTimeSeriesDataPointsOutput) {
	op := &request.Operation{
		Name:       opListTimeSeriesDataPoints,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/time-series-data-points",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTimeSeriesDataPointsInput{}
	}

	output = &ListTimeSeriesDataPointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTimeSeriesDataPoints API operation for Amazon DataZone.
//
// Lists time series data points.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation ListTimeSeriesDataPoints for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/ListTimeSeriesDataPoints
func (c *DataZone) ListTimeSeriesDataPoints(input *ListTimeSeriesDataPointsInput) (*ListTimeSeriesDataPointsOutput, error) {
	req, out := c.ListTimeSeriesDataPointsRequest(input)
	return out, req.Send()
}

// ListTimeSeriesDataPointsWithContext is the same as ListTimeSeriesDataPoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListTimeSeriesDataPoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListTimeSeriesDataPointsWithContext(ctx aws.Context, input *ListTimeSeriesDataPointsInput, opts ...request.Option) (*ListTimeSeriesDataPointsOutput, error) {
	req, out := c.ListTimeSeriesDataPointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTimeSeriesDataPointsPages iterates over the pages of a ListTimeSeriesDataPoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTimeSeriesDataPoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTimeSeriesDataPoints operation.
//	pageNum := 0
//	err := client.ListTimeSeriesDataPointsPages(params,
//	    func(page *datazone.ListTimeSeriesDataPointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) ListTimeSeriesDataPointsPages(input *ListTimeSeriesDataPointsInput, fn func(*ListTimeSeriesDataPointsOutput, bool) bool) error {
	return c.ListTimeSeriesDataPointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTimeSeriesDataPointsPagesWithContext same as ListTimeSeriesDataPointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) ListTimeSeriesDataPointsPagesWithContext(ctx aws.Context, input *ListTimeSeriesDataPointsInput, fn func(*ListTimeSeriesDataPointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTimeSeriesDataPointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTimeSeriesDataPointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTimeSeriesDataPointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPostLineageEvent = "PostLineageEvent"

// PostLineageEventRequest generates a "aws/request.Request" representing the
// client's request for the PostLineageEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PostLineageEvent for more information on using the PostLineageEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PostLineageEventRequest method.
//	req, resp := client.PostLineageEventRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PostLineageEvent
func (c *DataZone) PostLineageEventRequest(input *PostLineageEventInput) (req *request.Request, output *PostLineageEventOutput) {
	op := &request.Operation{
		Name:       opPostLineageEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/lineage/events",
	}

	if input == nil {
		input = &PostLineageEventInput{}
	}

	output = &PostLineageEventOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PostLineageEvent API operation for Amazon DataZone.
//
// Posts a data lineage event.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation PostLineageEvent for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PostLineageEvent
func (c *DataZone) PostLineageEvent(input *PostLineageEventInput) (*PostLineageEventOutput, error) {
	req, out := c.PostLineageEventRequest(input)
	return out, req.Send()
}

// PostLineageEventWithContext is the same as PostLineageEvent with the addition of
// the ability to pass a context and additional request options.
//
// See PostLineageEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) PostLineageEventWithContext(ctx aws.Context, input *PostLineageEventInput, opts ...request.Option) (*PostLineageEventOutput, error) {
	req, out := c.PostLineageEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPostTimeSeriesDataPoints = "PostTimeSeriesDataPoints"

// PostTimeSeriesDataPointsRequest generates a "aws/request.Request" representing the
// client's request for the PostTimeSeriesDataPoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PostTimeSeriesDataPoints for more information on using the PostTimeSeriesDataPoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PostTimeSeriesDataPointsRequest method.
//	req, resp := client.PostTimeSeriesDataPointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PostTimeSeriesDataPoints
func (c *DataZone) PostTimeSeriesDataPointsRequest(input *PostTimeSeriesDataPointsInput) (req *request.Request, output *PostTimeSeriesDataPointsOutput) {
	op := &request.Operation{
		Name:       opPostTimeSeriesDataPoints,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/time-series-data-points",
	}

	if input == nil {
		input = &PostTimeSeriesDataPointsInput{}
	}

	output = &PostTimeSeriesDataPointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PostTimeSeriesDataPoints API operation for Amazon DataZone.
//
// Posts time series data points to Amazon DataZone for the specified asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation PostTimeSeriesDataPoints for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PostTimeSeriesDataPoints
func (c *DataZone) PostTimeSeriesDataPoints(input *PostTimeSeriesDataPointsInput) (*PostTimeSeriesDataPointsOutput, error) {
	req, out := c.PostTimeSeriesDataPointsRequest(input)
	return out, req.Send()
}

// PostTimeSeriesDataPointsWithContext is the same as PostTimeSeriesDataPoints with the addition of
// the ability to pass a context and additional request options.
//
// See PostTimeSeriesDataPoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) PostTimeSeriesDataPointsWithContext(ctx aws.Context, input *PostTimeSeriesDataPointsInput, opts ...request.Option) (*PostTimeSeriesDataPointsOutput, error) {
	req, out := c.PostTimeSeriesDataPointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEnvironmentBlueprintConfiguration = "PutEnvironmentBlueprintConfiguration"

// PutEnvironmentBlueprintConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutEnvironmentBlueprintConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEnvironmentBlueprintConfiguration for more information on using the PutEnvironmentBlueprintConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutEnvironmentBlueprintConfigurationRequest method.
//	req, resp := client.PutEnvironmentBlueprintConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PutEnvironmentBlueprintConfiguration
func (c *DataZone) PutEnvironmentBlueprintConfigurationRequest(input *PutEnvironmentBlueprintConfigurationInput) (req *request.Request, output *PutEnvironmentBlueprintConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutEnvironmentBlueprintConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environment-blueprint-configurations/{environmentBlueprintIdentifier}",
	}

	if input == nil {
		input = &PutEnvironmentBlueprintConfigurationInput{}
	}

	output = &PutEnvironmentBlueprintConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEnvironmentBlueprintConfiguration API operation for Amazon DataZone.
//
// Writes the configuration for the specified environment blueprint in Amazon
// DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation PutEnvironmentBlueprintConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/PutEnvironmentBlueprintConfiguration
func (c *DataZone) PutEnvironmentBlueprintConfiguration(input *PutEnvironmentBlueprintConfigurationInput) (*PutEnvironmentBlueprintConfigurationOutput, error) {
	req, out := c.PutEnvironmentBlueprintConfigurationRequest(input)
	return out, req.Send()
}

// PutEnvironmentBlueprintConfigurationWithContext is the same as PutEnvironmentBlueprintConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutEnvironmentBlueprintConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) PutEnvironmentBlueprintConfigurationWithContext(ctx aws.Context, input *PutEnvironmentBlueprintConfigurationInput, opts ...request.Option) (*PutEnvironmentBlueprintConfigurationOutput, error) {
	req, out := c.PutEnvironmentBlueprintConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectPredictions = "RejectPredictions"

// RejectPredictionsRequest generates a "aws/request.Request" representing the
// client's request for the RejectPredictions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectPredictions for more information on using the RejectPredictions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RejectPredictionsRequest method.
//	req, resp := client.RejectPredictionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RejectPredictions
func (c *DataZone) RejectPredictionsRequest(input *RejectPredictionsInput) (req *request.Request, output *RejectPredictionsOutput) {
	op := &request.Operation{
		Name:       opRejectPredictions,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/domains/{domainIdentifier}/assets/{identifier}/reject-predictions",
	}

	if input == nil {
		input = &RejectPredictionsInput{}
	}

	output = &RejectPredictionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RejectPredictions API operation for Amazon DataZone.
//
// Rejects automatically generated business-friendly metadata for your Amazon
// DataZone assets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation RejectPredictions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RejectPredictions
func (c *DataZone) RejectPredictions(input *RejectPredictionsInput) (*RejectPredictionsOutput, error) {
	req, out := c.RejectPredictionsRequest(input)
	return out, req.Send()
}

// RejectPredictionsWithContext is the same as RejectPredictions with the addition of
// the ability to pass a context and additional request options.
//
// See RejectPredictions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) RejectPredictionsWithContext(ctx aws.Context, input *RejectPredictionsInput, opts ...request.Option) (*RejectPredictionsOutput, error) {
	req, out := c.RejectPredictionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectSubscriptionRequest = "RejectSubscriptionRequest"

// RejectSubscriptionRequestRequest generates a "aws/request.Request" representing the
// client's request for the RejectSubscriptionRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectSubscriptionRequest for more information on using the RejectSubscriptionRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RejectSubscriptionRequestRequest method.
//	req, resp := client.RejectSubscriptionRequestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RejectSubscriptionRequest
func (c *DataZone) RejectSubscriptionRequestRequest(input *RejectSubscriptionRequestInput) (req *request.Request, output *RejectSubscriptionRequestOutput) {
	op := &request.Operation{
		Name:       opRejectSubscriptionRequest,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscription-requests/{identifier}/reject",
	}

	if input == nil {
		input = &RejectSubscriptionRequestInput{}
	}

	output = &RejectSubscriptionRequestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RejectSubscriptionRequest API operation for Amazon DataZone.
//
// Rejects the specified subscription request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation RejectSubscriptionRequest for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RejectSubscriptionRequest
func (c *DataZone) RejectSubscriptionRequest(input *RejectSubscriptionRequestInput) (*RejectSubscriptionRequestOutput, error) {
	req, out := c.RejectSubscriptionRequestRequest(input)
	return out, req.Send()
}

// RejectSubscriptionRequestWithContext is the same as RejectSubscriptionRequest with the addition of
// the ability to pass a context and additional request options.
//
// See RejectSubscriptionRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) RejectSubscriptionRequestWithContext(ctx aws.Context, input *RejectSubscriptionRequestInput, opts ...request.Option) (*RejectSubscriptionRequestOutput, error) {
	req, out := c.RejectSubscriptionRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeSubscription = "RevokeSubscription"

// RevokeSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the RevokeSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeSubscription for more information on using the RevokeSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RevokeSubscriptionRequest method.
//	req, resp := client.RevokeSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RevokeSubscription
func (c *DataZone) RevokeSubscriptionRequest(input *RevokeSubscriptionInput) (req *request.Request, output *RevokeSubscriptionOutput) {
	op := &request.Operation{
		Name:       opRevokeSubscription,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscriptions/{identifier}/revoke",
	}

	if input == nil {
		input = &RevokeSubscriptionInput{}
	}

	output = &RevokeSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RevokeSubscription API operation for Amazon DataZone.
//
// Revokes a specified subscription in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation RevokeSubscription for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/RevokeSubscription
func (c *DataZone) RevokeSubscription(input *RevokeSubscriptionInput) (*RevokeSubscriptionOutput, error) {
	req, out := c.RevokeSubscriptionRequest(input)
	return out, req.Send()
}

// RevokeSubscriptionWithContext is the same as RevokeSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) RevokeSubscriptionWithContext(ctx aws.Context, input *RevokeSubscriptionInput, opts ...request.Option) (*RevokeSubscriptionOutput, error) {
	req, out := c.RevokeSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearch = "Search"

// SearchRequest generates a "aws/request.Request" representing the
// client's request for the Search operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Search for more information on using the Search
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchRequest method.
//	req, resp := client.SearchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/Search
func (c *DataZone) SearchRequest(input *SearchInput) (req *request.Request, output *SearchOutput) {
	op := &request.Operation{
		Name:       opSearch,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchInput{}
	}

	output = &SearchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Search API operation for Amazon DataZone.
//
// Searches for assets in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation Search for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/Search
func (c *DataZone) Search(input *SearchInput) (*SearchOutput, error) {
	req, out := c.SearchRequest(input)
	return out, req.Send()
}

// SearchWithContext is the same as Search with the addition of
// the ability to pass a context and additional request options.
//
// See Search for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) SearchWithContext(ctx aws.Context, input *SearchInput, opts ...request.Option) (*SearchOutput, error) {
	req, out := c.SearchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchPages iterates over the pages of a Search operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See Search method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a Search operation.
//	pageNum := 0
//	err := client.SearchPages(params,
//	    func(page *datazone.SearchOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) SearchPages(input *SearchInput, fn func(*SearchOutput, bool) bool) error {
	return c.SearchPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchPagesWithContext same as SearchPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) SearchPagesWithContext(ctx aws.Context, input *SearchInput, fn func(*SearchOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchGroupProfiles = "SearchGroupProfiles"

// SearchGroupProfilesRequest generates a "aws/request.Request" representing the
// client's request for the SearchGroupProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchGroupProfiles for more information on using the SearchGroupProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchGroupProfilesRequest method.
//	req, resp := client.SearchGroupProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchGroupProfiles
func (c *DataZone) SearchGroupProfilesRequest(input *SearchGroupProfilesInput) (req *request.Request, output *SearchGroupProfilesOutput) {
	op := &request.Operation{
		Name:       opSearchGroupProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/search-group-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchGroupProfilesInput{}
	}

	output = &SearchGroupProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchGroupProfiles API operation for Amazon DataZone.
//
// Searches group profiles in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation SearchGroupProfiles for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchGroupProfiles
func (c *DataZone) SearchGroupProfiles(input *SearchGroupProfilesInput) (*SearchGroupProfilesOutput, error) {
	req, out := c.SearchGroupProfilesRequest(input)
	return out, req.Send()
}

// SearchGroupProfilesWithContext is the same as SearchGroupProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See SearchGroupProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) SearchGroupProfilesWithContext(ctx aws.Context, input *SearchGroupProfilesInput, opts ...request.Option) (*SearchGroupProfilesOutput, error) {
	req, out := c.SearchGroupProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchGroupProfilesPages iterates over the pages of a SearchGroupProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchGroupProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchGroupProfiles operation.
//	pageNum := 0
//	err := client.SearchGroupProfilesPages(params,
//	    func(page *datazone.SearchGroupProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) SearchGroupProfilesPages(input *SearchGroupProfilesInput, fn func(*SearchGroupProfilesOutput, bool) bool) error {
	return c.SearchGroupProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchGroupProfilesPagesWithContext same as SearchGroupProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) SearchGroupProfilesPagesWithContext(ctx aws.Context, input *SearchGroupProfilesInput, fn func(*SearchGroupProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchGroupProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchGroupProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchGroupProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchListings = "SearchListings"

// SearchListingsRequest generates a "aws/request.Request" representing the
// client's request for the SearchListings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchListings for more information on using the SearchListings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchListingsRequest method.
//	req, resp := client.SearchListingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchListings
func (c *DataZone) SearchListingsRequest(input *SearchListingsInput) (req *request.Request, output *SearchListingsOutput) {
	op := &request.Operation{
		Name:       opSearchListings,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/listings/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchListingsInput{}
	}

	output = &SearchListingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchListings API operation for Amazon DataZone.
//
// Searches listings (records of an asset at a given time) in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation SearchListings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchListings
func (c *DataZone) SearchListings(input *SearchListingsInput) (*SearchListingsOutput, error) {
	req, out := c.SearchListingsRequest(input)
	return out, req.Send()
}

// SearchListingsWithContext is the same as SearchListings with the addition of
// the ability to pass a context and additional request options.
//
// See SearchListings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) SearchListingsWithContext(ctx aws.Context, input *SearchListingsInput, opts ...request.Option) (*SearchListingsOutput, error) {
	req, out := c.SearchListingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchListingsPages iterates over the pages of a SearchListings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchListings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchListings operation.
//	pageNum := 0
//	err := client.SearchListingsPages(params,
//	    func(page *datazone.SearchListingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) SearchListingsPages(input *SearchListingsInput, fn func(*SearchListingsOutput, bool) bool) error {
	return c.SearchListingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchListingsPagesWithContext same as SearchListingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) SearchListingsPagesWithContext(ctx aws.Context, input *SearchListingsInput, fn func(*SearchListingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchListingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchListingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchListingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchTypes = "SearchTypes"

// SearchTypesRequest generates a "aws/request.Request" representing the
// client's request for the SearchTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchTypes for more information on using the SearchTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchTypesRequest method.
//	req, resp := client.SearchTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchTypes
func (c *DataZone) SearchTypesRequest(input *SearchTypesInput) (req *request.Request, output *SearchTypesOutput) {
	op := &request.Operation{
		Name:       opSearchTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/types-search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchTypesInput{}
	}

	output = &SearchTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchTypes API operation for Amazon DataZone.
//
// Searches for types in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation SearchTypes for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchTypes
func (c *DataZone) SearchTypes(input *SearchTypesInput) (*SearchTypesOutput, error) {
	req, out := c.SearchTypesRequest(input)
	return out, req.Send()
}

// SearchTypesWithContext is the same as SearchTypes with the addition of
// the ability to pass a context and additional request options.
//
// See SearchTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) SearchTypesWithContext(ctx aws.Context, input *SearchTypesInput, opts ...request.Option) (*SearchTypesOutput, error) {
	req, out := c.SearchTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchTypesPages iterates over the pages of a SearchTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchTypes operation.
//	pageNum := 0
//	err := client.SearchTypesPages(params,
//	    func(page *datazone.SearchTypesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) SearchTypesPages(input *SearchTypesInput, fn func(*SearchTypesOutput, bool) bool) error {
	return c.SearchTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchTypesPagesWithContext same as SearchTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) SearchTypesPagesWithContext(ctx aws.Context, input *SearchTypesInput, fn func(*SearchTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchUserProfiles = "SearchUserProfiles"

// SearchUserProfilesRequest generates a "aws/request.Request" representing the
// client's request for the SearchUserProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchUserProfiles for more information on using the SearchUserProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchUserProfilesRequest method.
//	req, resp := client.SearchUserProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchUserProfiles
func (c *DataZone) SearchUserProfilesRequest(input *SearchUserProfilesInput) (req *request.Request, output *SearchUserProfilesOutput) {
	op := &request.Operation{
		Name:       opSearchUserProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/search-user-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchUserProfilesInput{}
	}

	output = &SearchUserProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchUserProfiles API operation for Amazon DataZone.
//
// Searches user profiles in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation SearchUserProfiles for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/SearchUserProfiles
func (c *DataZone) SearchUserProfiles(input *SearchUserProfilesInput) (*SearchUserProfilesOutput, error) {
	req, out := c.SearchUserProfilesRequest(input)
	return out, req.Send()
}

// SearchUserProfilesWithContext is the same as SearchUserProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See SearchUserProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) SearchUserProfilesWithContext(ctx aws.Context, input *SearchUserProfilesInput, opts ...request.Option) (*SearchUserProfilesOutput, error) {
	req, out := c.SearchUserProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchUserProfilesPages iterates over the pages of a SearchUserProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchUserProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchUserProfiles operation.
//	pageNum := 0
//	err := client.SearchUserProfilesPages(params,
//	    func(page *datazone.SearchUserProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DataZone) SearchUserProfilesPages(input *SearchUserProfilesInput, fn func(*SearchUserProfilesOutput, bool) bool) error {
	return c.SearchUserProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchUserProfilesPagesWithContext same as SearchUserProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) SearchUserProfilesPagesWithContext(ctx aws.Context, input *SearchUserProfilesInput, fn func(*SearchUserProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchUserProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchUserProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchUserProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartDataSourceRun = "StartDataSourceRun"

// StartDataSourceRunRequest generates a "aws/request.Request" representing the
// client's request for the StartDataSourceRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDataSourceRun for more information on using the StartDataSourceRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDataSourceRunRequest method.
//	req, resp := client.StartDataSourceRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/StartDataSourceRun
func (c *DataZone) StartDataSourceRunRequest(input *StartDataSourceRunInput) (req *request.Request, output *StartDataSourceRunOutput) {
	op := &request.Operation{
		Name:       opStartDataSourceRun,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/data-sources/{dataSourceIdentifier}/runs",
	}

	if input == nil {
		input = &StartDataSourceRunInput{}
	}

	output = &StartDataSourceRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDataSourceRun API operation for Amazon DataZone.
//
// Start the run of the specified data source in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation StartDataSourceRun for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/StartDataSourceRun
func (c *DataZone) StartDataSourceRun(input *StartDataSourceRunInput) (*StartDataSourceRunOutput, error) {
	req, out := c.StartDataSourceRunRequest(input)
	return out, req.Send()
}

// StartDataSourceRunWithContext is the same as StartDataSourceRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartDataSourceRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) StartDataSourceRunWithContext(ctx aws.Context, input *StartDataSourceRunInput, opts ...request.Option) (*StartDataSourceRunOutput, error) {
	req, out := c.StartDataSourceRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMetadataGenerationRun = "StartMetadataGenerationRun"

// StartMetadataGenerationRunRequest generates a "aws/request.Request" representing the
// client's request for the StartMetadataGenerationRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMetadataGenerationRun for more information on using the StartMetadataGenerationRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMetadataGenerationRunRequest method.
//	req, resp := client.StartMetadataGenerationRunRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/StartMetadataGenerationRun
func (c *DataZone) StartMetadataGenerationRunRequest(input *StartMetadataGenerationRunInput) (req *request.Request, output *StartMetadataGenerationRunOutput) {
	op := &request.Operation{
		Name:       opStartMetadataGenerationRun,
		HTTPMethod: "POST",
		HTTPPath:   "/v2/domains/{domainIdentifier}/metadata-generation-runs",
	}

	if input == nil {
		input = &StartMetadataGenerationRunInput{}
	}

	output = &StartMetadataGenerationRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMetadataGenerationRun API operation for Amazon DataZone.
//
// Starts the metadata generation run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation StartMetadataGenerationRun for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/StartMetadataGenerationRun
func (c *DataZone) StartMetadataGenerationRun(input *StartMetadataGenerationRunInput) (*StartMetadataGenerationRunOutput, error) {
	req, out := c.StartMetadataGenerationRunRequest(input)
	return out, req.Send()
}

// StartMetadataGenerationRunWithContext is the same as StartMetadataGenerationRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartMetadataGenerationRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) StartMetadataGenerationRunWithContext(ctx aws.Context, input *StartMetadataGenerationRunInput, opts ...request.Option) (*StartMetadataGenerationRunOutput, error) {
	req, out := c.StartMetadataGenerationRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/TagResource
func (c *DataZone) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon DataZone.
//
// Tags a resource in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/TagResource
func (c *DataZone) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UntagResource
func (c *DataZone) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon DataZone.
//
// Untags a resource in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UntagResource
func (c *DataZone) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAssetFilter = "UpdateAssetFilter"

// UpdateAssetFilterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssetFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAssetFilter for more information on using the UpdateAssetFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAssetFilterRequest method.
//	req, resp := client.UpdateAssetFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateAssetFilter
func (c *DataZone) UpdateAssetFilterRequest(input *UpdateAssetFilterInput) (req *request.Request, output *UpdateAssetFilterOutput) {
	op := &request.Operation{
		Name:       opUpdateAssetFilter,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters/{identifier}",
	}

	if input == nil {
		input = &UpdateAssetFilterInput{}
	}

	output = &UpdateAssetFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAssetFilter API operation for Amazon DataZone.
//
// Updates an asset filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UpdateAssetFilter for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateAssetFilter
func (c *DataZone) UpdateAssetFilter(input *UpdateAssetFilterInput) (*UpdateAssetFilterOutput, error) {
	req, out := c.UpdateAssetFilterRequest(input)
	return out, req.Send()
}

// UpdateAssetFilterWithContext is the same as UpdateAssetFilter with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAssetFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UpdateAssetFilterWithContext(ctx aws.Context, input *UpdateAssetFilterInput, opts ...request.Option) (*UpdateAssetFilterOutput, error) {
	req, out := c.UpdateAssetFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSource for more information on using the UpdateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataSourceRequest method.
//	req, resp := client.UpdateDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateDataSource
func (c *DataZone) UpdateDataSourceRequest(input *UpdateDataSourceInput) (req *request.Request, output *UpdateDataSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/domains/{domainIdentifier}/data-sources/{identifier}",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	output = &UpdateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSource API operation for Amazon DataZone.
//
// Updates the specified data source in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UpdateDataSource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateDataSource
func (c *DataZone) UpdateDataSource(input *UpdateDataSourceInput) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	return out, req.Send()
}

// UpdateDataSourceWithContext is the same as UpdateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UpdateDataSourceWithContext(ctx aws.Context, input *UpdateDataSourceInput, opts ...request.Option) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomain = "UpdateDomain"

// UpdateDomainRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomain for more information on using the UpdateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDomainRequest method.
//	req, resp := client.UpdateDomainRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateDomain
func (c *DataZone) UpdateDomainRequest(input *UpdateDomainInput) (req *request.Request, output *UpdateDomainOutput) {
	op := &request.Operation{
		Name:       opUpdateDomain,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/domains/{identifier}",
	}

	if input == nil {
		input = &UpdateDomainInput{}
	}

	output = &UpdateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomain API operation for Amazon DataZone.
//
// Updates a Amazon DataZone domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UpdateDomain for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateDomain
func (c *DataZone) UpdateDomain(input *UpdateDomainInput) (*UpdateDomainOutput, error) {
	req, out := c.UpdateDomainRequest(input)
	return out, req.Send()
}

// UpdateDomainWithContext is the same as UpdateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UpdateDomainWithContext(ctx aws.Context, input *UpdateDomainInput, opts ...request.Option) (*UpdateDomainOutput, error) {
	req, out := c.UpdateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnvironment = "UpdateEnvironment"

// UpdateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironment for more information on using the UpdateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEnvironmentRequest method.
//	req, resp := client.UpdateEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateEnvironment
func (c *DataZone) UpdateEnvironmentRequest(input *UpdateEnvironmentInput) (req *request.Request, output *UpdateEnvironmentOutput) {
	op := &request.Operation{
		Name:       opUpdateEnvironment,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{identifier}",
	}

	if input == nil {
		input = &UpdateEnvironmentInput{}
	}

	output = &UpdateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnvironment API operation for Amazon DataZone.
//
// Updates the specified environment in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UpdateEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateEnvironment
func (c *DataZone) UpdateEnvironment(input *UpdateEnvironmentInput) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentWithContext is the same as UpdateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UpdateEnvironmentWithContext(ctx aws.Context, input *UpdateEnvironmentInput, opts ...request.Option) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnvironmentAction = "UpdateEnvironmentAction"

// UpdateEnvironmentActionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironmentAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironmentAction for more information on using the UpdateEnvironmentAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEnvironmentActionRequest method.
//	req, resp := client.UpdateEnvironmentActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateEnvironmentAction
func (c *DataZone) UpdateEnvironmentActionRequest(input *UpdateEnvironmentActionInput) (req *request.Request, output *UpdateEnvironmentActionOutput) {
	op := &request.Operation{
		Name:       opUpdateEnvironmentAction,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions/{identifier}",
	}

	if input == nil {
		input = &UpdateEnvironmentActionInput{}
	}

	output = &UpdateEnvironmentActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnvironmentAction API operation for Amazon DataZone.
//
// Updates an environment action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UpdateEnvironmentAction for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateEnvironmentAction
func (c *DataZone) UpdateEnvironmentAction(input *UpdateEnvironmentActionInput) (*UpdateEnvironmentActionOutput, error) {
	req, out := c.UpdateEnvironmentActionRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentActionWithContext is the same as UpdateEnvironmentAction with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironmentAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UpdateEnvironmentActionWithContext(ctx aws.Context, input *UpdateEnvironmentActionInput, opts ...request.Option) (*UpdateEnvironmentActionOutput, error) {
	req, out := c.UpdateEnvironmentActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnvironmentProfile = "UpdateEnvironmentProfile"

// UpdateEnvironmentProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironmentProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironmentProfile for more information on using the UpdateEnvironmentProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEnvironmentProfileRequest method.
//	req, resp := client.UpdateEnvironmentProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateEnvironmentProfile
func (c *DataZone) UpdateEnvironmentProfileRequest(input *UpdateEnvironmentProfileInput) (req *request.Request, output *UpdateEnvironmentProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateEnvironmentProfile,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environment-profiles/{identifier}",
	}

	if input == nil {
		input = &UpdateEnvironmentProfileInput{}
	}

	output = &UpdateEnvironmentProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnvironmentProfile API operation for Amazon DataZone.
//
// Updates the specified environment profile in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UpdateEnvironmentProfile for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateEnvironmentProfile
func (c *DataZone) UpdateEnvironmentProfile(input *UpdateEnvironmentProfileInput) (*UpdateEnvironmentProfileOutput, error) {
	req, out := c.UpdateEnvironmentProfileRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentProfileWithContext is the same as UpdateEnvironmentProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironmentProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UpdateEnvironmentProfileWithContext(ctx aws.Context, input *UpdateEnvironmentProfileInput, opts ...request.Option) (*UpdateEnvironmentProfileOutput, error) {
	req, out := c.UpdateEnvironmentProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGlossary = "UpdateGlossary"

// UpdateGlossaryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGlossary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGlossary for more information on using the UpdateGlossary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGlossaryRequest method.
//	req, resp := client.UpdateGlossaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateGlossary
func (c *DataZone) UpdateGlossaryRequest(input *UpdateGlossaryInput) (req *request.Request, output *UpdateGlossaryOutput) {
	op := &request.Operation{
		Name:       opUpdateGlossary,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/domains/{domainIdentifier}/glossaries/{identifier}",
	}

	if input == nil {
		input = &UpdateGlossaryInput{}
	}

	output = &UpdateGlossaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGlossary API operation for Amazon DataZone.
//
// Updates the business glossary in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UpdateGlossary for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateGlossary
func (c *DataZone) UpdateGlossary(input *UpdateGlossaryInput) (*UpdateGlossaryOutput, error) {
	req, out := c.UpdateGlossaryRequest(input)
	return out, req.Send()
}

// UpdateGlossaryWithContext is the same as UpdateGlossary with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGlossary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UpdateGlossaryWithContext(ctx aws.Context, input *UpdateGlossaryInput, opts ...request.Option) (*UpdateGlossaryOutput, error) {
	req, out := c.UpdateGlossaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGlossaryTerm = "UpdateGlossaryTerm"

// UpdateGlossaryTermRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGlossaryTerm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGlossaryTerm for more information on using the UpdateGlossaryTerm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGlossaryTermRequest method.
//	req, resp := client.UpdateGlossaryTermRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateGlossaryTerm
func (c *DataZone) UpdateGlossaryTermRequest(input *UpdateGlossaryTermInput) (req *request.Request, output *UpdateGlossaryTermOutput) {
	op := &request.Operation{
		Name:       opUpdateGlossaryTerm,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/domains/{domainIdentifier}/glossary-terms/{identifier}",
	}

	if input == nil {
		input = &UpdateGlossaryTermInput{}
	}

	output = &UpdateGlossaryTermOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGlossaryTerm API operation for Amazon DataZone.
//
// Updates a business glossary term in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UpdateGlossaryTerm for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateGlossaryTerm
func (c *DataZone) UpdateGlossaryTerm(input *UpdateGlossaryTermInput) (*UpdateGlossaryTermOutput, error) {
	req, out := c.UpdateGlossaryTermRequest(input)
	return out, req.Send()
}

// UpdateGlossaryTermWithContext is the same as UpdateGlossaryTerm with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGlossaryTerm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UpdateGlossaryTermWithContext(ctx aws.Context, input *UpdateGlossaryTermInput, opts ...request.Option) (*UpdateGlossaryTermOutput, error) {
	req, out := c.UpdateGlossaryTermRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroupProfile = "UpdateGroupProfile"

// UpdateGroupProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroupProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroupProfile for more information on using the UpdateGroupProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGroupProfileRequest method.
//	req, resp := client.UpdateGroupProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateGroupProfile
func (c *DataZone) UpdateGroupProfileRequest(input *UpdateGroupProfileInput) (req *request.Request, output *UpdateGroupProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateGroupProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/domains/{domainIdentifier}/group-profiles/{groupIdentifier}",
	}

	if input == nil {
		input = &UpdateGroupProfileInput{}
	}

	output = &UpdateGroupProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroupProfile API operation for Amazon DataZone.
//
// Updates the specified group profile in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UpdateGroupProfile for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateGroupProfile
func (c *DataZone) UpdateGroupProfile(input *UpdateGroupProfileInput) (*UpdateGroupProfileOutput, error) {
	req, out := c.UpdateGroupProfileRequest(input)
	return out, req.Send()
}

// UpdateGroupProfileWithContext is the same as UpdateGroupProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroupProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UpdateGroupProfileWithContext(ctx aws.Context, input *UpdateGroupProfileInput, opts ...request.Option) (*UpdateGroupProfileOutput, error) {
	req, out := c.UpdateGroupProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProject = "UpdateProject"

// UpdateProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProject for more information on using the UpdateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProjectRequest method.
//	req, resp := client.UpdateProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateProject
func (c *DataZone) UpdateProjectRequest(input *UpdateProjectInput) (req *request.Request, output *UpdateProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateProject,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/domains/{domainIdentifier}/projects/{identifier}",
	}

	if input == nil {
		input = &UpdateProjectInput{}
	}

	output = &UpdateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProject API operation for Amazon DataZone.
//
// Updates the specified project in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UpdateProject for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ServiceQuotaExceededException
//     The request has exceeded the specified service quota.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateProject
func (c *DataZone) UpdateProject(input *UpdateProjectInput) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	return out, req.Send()
}

// UpdateProjectWithContext is the same as UpdateProject with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UpdateProjectWithContext(ctx aws.Context, input *UpdateProjectInput, opts ...request.Option) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSubscriptionGrantStatus = "UpdateSubscriptionGrantStatus"

// UpdateSubscriptionGrantStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSubscriptionGrantStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSubscriptionGrantStatus for more information on using the UpdateSubscriptionGrantStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSubscriptionGrantStatusRequest method.
//	req, resp := client.UpdateSubscriptionGrantStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateSubscriptionGrantStatus
func (c *DataZone) UpdateSubscriptionGrantStatusRequest(input *UpdateSubscriptionGrantStatusInput) (req *request.Request, output *UpdateSubscriptionGrantStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateSubscriptionGrantStatus,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscription-grants/{identifier}/status/{assetIdentifier}",
	}

	if input == nil {
		input = &UpdateSubscriptionGrantStatusInput{}
	}

	output = &UpdateSubscriptionGrantStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSubscriptionGrantStatus API operation for Amazon DataZone.
//
// Updates the status of the specified subscription grant status in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UpdateSubscriptionGrantStatus for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateSubscriptionGrantStatus
func (c *DataZone) UpdateSubscriptionGrantStatus(input *UpdateSubscriptionGrantStatusInput) (*UpdateSubscriptionGrantStatusOutput, error) {
	req, out := c.UpdateSubscriptionGrantStatusRequest(input)
	return out, req.Send()
}

// UpdateSubscriptionGrantStatusWithContext is the same as UpdateSubscriptionGrantStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSubscriptionGrantStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UpdateSubscriptionGrantStatusWithContext(ctx aws.Context, input *UpdateSubscriptionGrantStatusInput, opts ...request.Option) (*UpdateSubscriptionGrantStatusOutput, error) {
	req, out := c.UpdateSubscriptionGrantStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSubscriptionRequest = "UpdateSubscriptionRequest"

// UpdateSubscriptionRequestRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSubscriptionRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSubscriptionRequest for more information on using the UpdateSubscriptionRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSubscriptionRequestRequest method.
//	req, resp := client.UpdateSubscriptionRequestRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateSubscriptionRequest
func (c *DataZone) UpdateSubscriptionRequestRequest(input *UpdateSubscriptionRequestInput) (req *request.Request, output *UpdateSubscriptionRequestOutput) {
	op := &request.Operation{
		Name:       opUpdateSubscriptionRequest,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/domains/{domainIdentifier}/subscription-requests/{identifier}",
	}

	if input == nil {
		input = &UpdateSubscriptionRequestInput{}
	}

	output = &UpdateSubscriptionRequestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSubscriptionRequest API operation for Amazon DataZone.
//
// Updates a specified subscription request in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UpdateSubscriptionRequest for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateSubscriptionRequest
func (c *DataZone) UpdateSubscriptionRequest(input *UpdateSubscriptionRequestInput) (*UpdateSubscriptionRequestOutput, error) {
	req, out := c.UpdateSubscriptionRequestRequest(input)
	return out, req.Send()
}

// UpdateSubscriptionRequestWithContext is the same as UpdateSubscriptionRequest with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSubscriptionRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UpdateSubscriptionRequestWithContext(ctx aws.Context, input *UpdateSubscriptionRequestInput, opts ...request.Option) (*UpdateSubscriptionRequestOutput, error) {
	req, out := c.UpdateSubscriptionRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSubscriptionTarget = "UpdateSubscriptionTarget"

// UpdateSubscriptionTargetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSubscriptionTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSubscriptionTarget for more information on using the UpdateSubscriptionTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSubscriptionTargetRequest method.
//	req, resp := client.UpdateSubscriptionTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateSubscriptionTarget
func (c *DataZone) UpdateSubscriptionTargetRequest(input *UpdateSubscriptionTargetInput) (req *request.Request, output *UpdateSubscriptionTargetOutput) {
	op := &request.Operation{
		Name:       opUpdateSubscriptionTarget,
		HTTPMethod: "PATCH",
		HTTPPath:   "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets/{identifier}",
	}

	if input == nil {
		input = &UpdateSubscriptionTargetInput{}
	}

	output = &UpdateSubscriptionTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSubscriptionTarget API operation for Amazon DataZone.
//
// Updates the specified subscription target in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UpdateSubscriptionTarget for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     There is a conflict while performing this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateSubscriptionTarget
func (c *DataZone) UpdateSubscriptionTarget(input *UpdateSubscriptionTargetInput) (*UpdateSubscriptionTargetOutput, error) {
	req, out := c.UpdateSubscriptionTargetRequest(input)
	return out, req.Send()
}

// UpdateSubscriptionTargetWithContext is the same as UpdateSubscriptionTarget with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSubscriptionTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UpdateSubscriptionTargetWithContext(ctx aws.Context, input *UpdateSubscriptionTargetInput, opts ...request.Option) (*UpdateSubscriptionTargetOutput, error) {
	req, out := c.UpdateSubscriptionTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserProfile = "UpdateUserProfile"

// UpdateUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserProfile for more information on using the UpdateUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserProfileRequest method.
//	req, resp := client.UpdateUserProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateUserProfile
func (c *DataZone) UpdateUserProfileRequest(input *UpdateUserProfileInput) (req *request.Request, output *UpdateUserProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateUserProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/domains/{domainIdentifier}/user-profiles/{userIdentifier}",
	}

	if input == nil {
		input = &UpdateUserProfileInput{}
	}

	output = &UpdateUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUserProfile API operation for Amazon DataZone.
//
// Updates the specified user profile in Amazon DataZone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DataZone's
// API operation UpdateUserProfile for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request has failed because of an unknown error, exception or failure.
//
//   - ResourceNotFoundException
//     The specified resource cannot be found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ValidationException
//     The input fails to satisfy the constraints specified by the Amazon Web Services
//     service.
//
//   - UnauthorizedException
//     You do not have permission to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/UpdateUserProfile
func (c *DataZone) UpdateUserProfile(input *UpdateUserProfileInput) (*UpdateUserProfileOutput, error) {
	req, out := c.UpdateUserProfileRequest(input)
	return out, req.Send()
}

// UpdateUserProfileWithContext is the same as UpdateUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DataZone) UpdateUserProfileWithContext(ctx aws.Context, input *UpdateUserProfileInput, opts ...request.Option) (*UpdateUserProfileOutput, error) {
	req, out := c.UpdateUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Specifies the prediction (aka, the automatically generated piece of metadata)
// and the target (for example, a column name) that can be accepted.
type AcceptChoice struct {
	_ struct{} `type:"structure"`

	// The edit of the prediction.
	//
	// EditedValue is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AcceptChoice's
	// String and GoString methods.
	EditedValue *string `locationName:"editedValue" min:"1" type:"string" sensitive:"true"`

	// Specifies the prediction (aka, the automatically generated piece of metadata)
	// that can be accepted.
	PredictionChoice *int64 `locationName:"predictionChoice" type:"integer"`

	// Specifies the target (for example, a column name) where a prediction can
	// be accepted.
	//
	// PredictionTarget is a required field
	PredictionTarget *string `locationName:"predictionTarget" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptChoice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptChoice) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptChoice) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptChoice"}
	if s.EditedValue != nil && len(*s.EditedValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EditedValue", 1))
	}
	if s.PredictionTarget == nil {
		invalidParams.Add(request.NewErrParamRequired("PredictionTarget"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEditedValue sets the EditedValue field's value.
func (s *AcceptChoice) SetEditedValue(v string) *AcceptChoice {
	s.EditedValue = &v
	return s
}

// SetPredictionChoice sets the PredictionChoice field's value.
func (s *AcceptChoice) SetPredictionChoice(v int64) *AcceptChoice {
	s.PredictionChoice = &v
	return s
}

// SetPredictionTarget sets the PredictionTarget field's value.
func (s *AcceptChoice) SetPredictionTarget(v string) *AcceptChoice {
	s.PredictionTarget = &v
	return s
}

type AcceptPredictionsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the prediction (aka, the automatically generated piece of metadata)
	// and the target (for example, a column name) that can be accepted.
	AcceptChoices []*AcceptChoice `locationName:"acceptChoices" type:"list"`

	// Specifies the rule (or the conditions) under which a prediction can be accepted.
	AcceptRule *AcceptRule `locationName:"acceptRule" type:"structure"`

	// A unique, case-sensitive identifier to ensure idempotency of the request.
	// This field is automatically populated if not provided.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The identifier of the Amazon DataZone domain.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The identifier of the asset.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`

	// The revision that is to be made to the asset.
	Revision *string `location:"querystring" locationName:"revision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptPredictionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptPredictionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptPredictionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptPredictionsInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.Revision != nil && len(*s.Revision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Revision", 1))
	}
	if s.AcceptChoices != nil {
		for i, v := range s.AcceptChoices {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AcceptChoices", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptChoices sets the AcceptChoices field's value.
func (s *AcceptPredictionsInput) SetAcceptChoices(v []*AcceptChoice) *AcceptPredictionsInput {
	s.AcceptChoices = v
	return s
}

// SetAcceptRule sets the AcceptRule field's value.
func (s *AcceptPredictionsInput) SetAcceptRule(v *AcceptRule) *AcceptPredictionsInput {
	s.AcceptRule = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *AcceptPredictionsInput) SetClientToken(v string) *AcceptPredictionsInput {
	s.ClientToken = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *AcceptPredictionsInput) SetDomainIdentifier(v string) *AcceptPredictionsInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *AcceptPredictionsInput) SetIdentifier(v string) *AcceptPredictionsInput {
	s.Identifier = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *AcceptPredictionsInput) SetRevision(v string) *AcceptPredictionsInput {
	s.Revision = &v
	return s
}

type AcceptPredictionsOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" type:"string" required:"true"`

	// The identifier of the Amazon DataZone domain.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The revision that is to be made to the asset.
	//
	// Revision is a required field
	Revision *string `locationName:"revision" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptPredictionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptPredictionsOutput) GoString() string {
	return s.String()
}

// SetAssetId sets the AssetId field's value.
func (s *AcceptPredictionsOutput) SetAssetId(v string) *AcceptPredictionsOutput {
	s.AssetId = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *AcceptPredictionsOutput) SetDomainId(v string) *AcceptPredictionsOutput {
	s.DomainId = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *AcceptPredictionsOutput) SetRevision(v string) *AcceptPredictionsOutput {
	s.Revision = &v
	return s
}

// Specifies the rule and the threshold under which a prediction can be accepted.
type AcceptRule struct {
	_ struct{} `type:"structure"`

	// Specifies whether you want to accept the top prediction for all targets or
	// none.
	Rule *string `locationName:"rule" type:"string" enum:"AcceptRuleBehavior"`

	// The confidence score that specifies the condition at which a prediction can
	// be accepted.
	Threshold *float64 `locationName:"threshold" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptRule) GoString() string {
	return s.String()
}

// SetRule sets the Rule field's value.
func (s *AcceptRule) SetRule(v string) *AcceptRule {
	s.Rule = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *AcceptRule) SetThreshold(v float64) *AcceptRule {
	s.Threshold = &v
	return s
}

type AcceptSubscriptionRequestInput struct {
	_ struct{} `type:"structure"`

	// A description that specifies the reason for accepting the specified subscription
	// request.
	//
	// DecisionComment is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AcceptSubscriptionRequestInput's
	// String and GoString methods.
	DecisionComment *string `locationName:"decisionComment" min:"1" type:"string" sensitive:"true"`

	// The Amazon DataZone domain where the specified subscription request is being
	// accepted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The unique identifier of the subscription request that is to be accepted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptSubscriptionRequestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptSubscriptionRequestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptSubscriptionRequestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptSubscriptionRequestInput"}
	if s.DecisionComment != nil && len(*s.DecisionComment) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DecisionComment", 1))
	}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecisionComment sets the DecisionComment field's value.
func (s *AcceptSubscriptionRequestInput) SetDecisionComment(v string) *AcceptSubscriptionRequestInput {
	s.DecisionComment = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *AcceptSubscriptionRequestInput) SetDomainIdentifier(v string) *AcceptSubscriptionRequestInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *AcceptSubscriptionRequestInput) SetIdentifier(v string) *AcceptSubscriptionRequestInput {
	s.Identifier = &v
	return s
}

type AcceptSubscriptionRequestOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp that specifies when the subscription request was accepted.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Specifies the Amazon DataZone user that accepted the specified subscription
	// request.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// Specifies the reason for accepting the subscription request.
	//
	// DecisionComment is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AcceptSubscriptionRequestOutput's
	// String and GoString methods.
	DecisionComment *string `locationName:"decisionComment" min:"1" type:"string" sensitive:"true"`

	// The unique identifier of the Amazon DataZone domain where the specified subscription
	// request was accepted.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The identifier of the subscription request.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Specifies the reason for requesting a subscription to the asset.
	//
	// RequestReason is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AcceptSubscriptionRequestOutput's
	// String and GoString methods.
	//
	// RequestReason is a required field
	RequestReason *string `locationName:"requestReason" min:"1" type:"string" required:"true" sensitive:"true"`

	// Specifes the ID of the Amazon DataZone user who reviewed the subscription
	// request.
	ReviewerId *string `locationName:"reviewerId" type:"string"`

	// Specifies the status of the subscription request.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"SubscriptionRequestStatus"`

	// Specifies the asset for which the subscription request was created.
	//
	// SubscribedListings is a required field
	SubscribedListings []*SubscribedListing `locationName:"subscribedListings" min:"1" type:"list" required:"true"`

	// Specifies the Amazon DataZone users who are subscribed to the asset specified
	// in the subscription request.
	//
	// SubscribedPrincipals is a required field
	SubscribedPrincipals []*SubscribedPrincipal `locationName:"subscribedPrincipals" min:"1" type:"list" required:"true"`

	// Specifies the timestamp when subscription request was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// Specifies the Amazon DataZone user who updated the subscription request.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptSubscriptionRequestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptSubscriptionRequestOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AcceptSubscriptionRequestOutput) SetCreatedAt(v time.Time) *AcceptSubscriptionRequestOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *AcceptSubscriptionRequestOutput) SetCreatedBy(v string) *AcceptSubscriptionRequestOutput {
	s.CreatedBy = &v
	return s
}

// SetDecisionComment sets the DecisionComment field's value.
func (s *AcceptSubscriptionRequestOutput) SetDecisionComment(v string) *AcceptSubscriptionRequestOutput {
	s.DecisionComment = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *AcceptSubscriptionRequestOutput) SetDomainId(v string) *AcceptSubscriptionRequestOutput {
	s.DomainId = &v
	return s
}

// SetId sets the Id field's value.
func (s *AcceptSubscriptionRequestOutput) SetId(v string) *AcceptSubscriptionRequestOutput {
	s.Id = &v
	return s
}

// SetRequestReason sets the RequestReason field's value.
func (s *AcceptSubscriptionRequestOutput) SetRequestReason(v string) *AcceptSubscriptionRequestOutput {
	s.RequestReason = &v
	return s
}

// SetReviewerId sets the ReviewerId field's value.
func (s *AcceptSubscriptionRequestOutput) SetReviewerId(v string) *AcceptSubscriptionRequestOutput {
	s.ReviewerId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AcceptSubscriptionRequestOutput) SetStatus(v string) *AcceptSubscriptionRequestOutput {
	s.Status = &v
	return s
}

// SetSubscribedListings sets the SubscribedListings field's value.
func (s *AcceptSubscriptionRequestOutput) SetSubscribedListings(v []*SubscribedListing) *AcceptSubscriptionRequestOutput {
	s.SubscribedListings = v
	return s
}

// SetSubscribedPrincipals sets the SubscribedPrincipals field's value.
func (s *AcceptSubscriptionRequestOutput) SetSubscribedPrincipals(v []*SubscribedPrincipal) *AcceptSubscriptionRequestOutput {
	s.SubscribedPrincipals = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AcceptSubscriptionRequestOutput) SetUpdatedAt(v time.Time) *AcceptSubscriptionRequestOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *AcceptSubscriptionRequestOutput) SetUpdatedBy(v string) *AcceptSubscriptionRequestOutput {
	s.UpdatedBy = &v
	return s
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The parameters of the environment action.
type ActionParameters struct {
	_ struct{} `type:"structure"`

	// The console link specified as part of the environment action.
	AwsConsoleLink *AwsConsoleLinkParameters `locationName:"awsConsoleLink" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionParameters) GoString() string {
	return s.String()
}

// SetAwsConsoleLink sets the AwsConsoleLink field's value.
func (s *ActionParameters) SetAwsConsoleLink(v *AwsConsoleLinkParameters) *ActionParameters {
	s.AwsConsoleLink = v
	return s
}

// The configuration details of the asset filter.
type AssetFilterConfiguration struct {
	_ struct{} `type:"structure"`

	// The column configuration of the asset filter.
	ColumnConfiguration *ColumnFilterConfiguration `locationName:"columnConfiguration" type:"structure"`

	// The row configuration of the asset filter.
	RowConfiguration *RowFilterConfiguration `locationName:"rowConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetFilterConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetFilterConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetFilterConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetFilterConfiguration"}
	if s.RowConfiguration != nil {
		if err := s.RowConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RowConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnConfiguration sets the ColumnConfiguration field's value.
func (s *AssetFilterConfiguration) SetColumnConfiguration(v *ColumnFilterConfiguration) *AssetFilterConfiguration {
	s.ColumnConfiguration = v
	return s
}

// SetRowConfiguration sets the RowConfiguration field's value.
func (s *AssetFilterConfiguration) SetRowConfiguration(v *RowFilterConfiguration) *AssetFilterConfiguration {
	s.RowConfiguration = v
	return s
}

// The summary of the asset filter.
type AssetFilterSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the data asset.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" type:"string" required:"true"`

	// The timestamp at which the asset filter was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The description of the asset filter.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssetFilterSummary's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the domain where the asset filter lives.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The effective column names of the asset filter.
	EffectiveColumnNames []*string `locationName:"effectiveColumnNames" type:"list"`

	// The effective row filter of the asset filter.
	EffectiveRowFilter *string `locationName:"effectiveRowFilter" type:"string"`

	// The error message that is displayed if the action does not succeed.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The ID of the asset filter.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the asset filter.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssetFilterSummary's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The status of the asset filter.
	Status *string `locationName:"status" type:"string" enum:"FilterStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetFilterSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetFilterSummary) GoString() string {
	return s.String()
}

// SetAssetId sets the AssetId field's value.
func (s *AssetFilterSummary) SetAssetId(v string) *AssetFilterSummary {
	s.AssetId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AssetFilterSummary) SetCreatedAt(v time.Time) *AssetFilterSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssetFilterSummary) SetDescription(v string) *AssetFilterSummary {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *AssetFilterSummary) SetDomainId(v string) *AssetFilterSummary {
	s.DomainId = &v
	return s
}

// SetEffectiveColumnNames sets the EffectiveColumnNames field's value.
func (s *AssetFilterSummary) SetEffectiveColumnNames(v []*string) *AssetFilterSummary {
	s.EffectiveColumnNames = v
	return s
}

// SetEffectiveRowFilter sets the EffectiveRowFilter field's value.
func (s *AssetFilterSummary) SetEffectiveRowFilter(v string) *AssetFilterSummary {
	s.EffectiveRowFilter = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *AssetFilterSummary) SetErrorMessage(v string) *AssetFilterSummary {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssetFilterSummary) SetId(v string) *AssetFilterSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetFilterSummary) SetName(v string) *AssetFilterSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssetFilterSummary) SetStatus(v string) *AssetFilterSummary {
	s.Status = &v
	return s
}

// A Amazon DataZone inventory asset.
type AssetItem struct {
	_ struct{} `type:"structure"`

	// The additional attributes of a Amazon DataZone inventory asset.
	AdditionalAttributes *AssetItemAdditionalAttributes `locationName:"additionalAttributes" type:"structure"`

	// The timestamp of when the Amazon DataZone inventory asset was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon DataZone user who created the inventory asset.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// The description of an Amazon DataZone inventory asset.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssetItem's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The identifier of the Amazon DataZone domain in which the inventory asset
	// exists.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The external identifier of the Amazon DataZone inventory asset.
	//
	// ExternalIdentifier is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssetItem's
	// String and GoString methods.
	ExternalIdentifier *string `locationName:"externalIdentifier" min:"1" type:"string" sensitive:"true"`

	// The timestamp of when the first revision of the inventory asset was created.
	FirstRevisionCreatedAt *time.Time `locationName:"firstRevisionCreatedAt" type:"timestamp"`

	// The Amazon DataZone user who created the first revision of the inventory
	// asset.
	FirstRevisionCreatedBy *string `locationName:"firstRevisionCreatedBy" type:"string"`

	// The glossary terms attached to the Amazon DataZone inventory asset.
	GlossaryTerms []*string `locationName:"glossaryTerms" min:"1" type:"list"`

	// the identifier of the Amazon DataZone inventory asset.
	//
	// Identifier is a required field
	Identifier *string `locationName:"identifier" type:"string" required:"true"`

	// The name of the Amazon DataZone inventory asset.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssetItem's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The identifier of the Amazon DataZone project that owns the inventory asset.
	//
	// OwningProjectId is a required field
	OwningProjectId *string `locationName:"owningProjectId" type:"string" required:"true"`

	// The identifier of the asset type of the specified Amazon DataZone inventory
	// asset.
	//
	// TypeIdentifier is a required field
	TypeIdentifier *string `locationName:"typeIdentifier" min:"1" type:"string" required:"true"`

	// The revision of the inventory asset type.
	//
	// TypeRevision is a required field
	TypeRevision *string `locationName:"typeRevision" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetItem) GoString() string {
	return s.String()
}

// SetAdditionalAttributes sets the AdditionalAttributes field's value.
func (s *AssetItem) SetAdditionalAttributes(v *AssetItemAdditionalAttributes) *AssetItem {
	s.AdditionalAttributes = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AssetItem) SetCreatedAt(v time.Time) *AssetItem {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *AssetItem) SetCreatedBy(v string) *AssetItem {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssetItem) SetDescription(v string) *AssetItem {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *AssetItem) SetDomainId(v string) *AssetItem {
	s.DomainId = &v
	return s
}

// SetExternalIdentifier sets the ExternalIdentifier field's value.
func (s *AssetItem) SetExternalIdentifier(v string) *AssetItem {
	s.ExternalIdentifier = &v
	return s
}

// SetFirstRevisionCreatedAt sets the FirstRevisionCreatedAt field's value.
func (s *AssetItem) SetFirstRevisionCreatedAt(v time.Time) *AssetItem {
	s.FirstRevisionCreatedAt = &v
	return s
}

// SetFirstRevisionCreatedBy sets the FirstRevisionCreatedBy field's value.
func (s *AssetItem) SetFirstRevisionCreatedBy(v string) *AssetItem {
	s.FirstRevisionCreatedBy = &v
	return s
}

// SetGlossaryTerms sets the GlossaryTerms field's value.
func (s *AssetItem) SetGlossaryTerms(v []*string) *AssetItem {
	s.GlossaryTerms = v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *AssetItem) SetIdentifier(v string) *AssetItem {
	s.Identifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetItem) SetName(v string) *AssetItem {
	s.Name = &v
	return s
}

// SetOwningProjectId sets the OwningProjectId field's value.
func (s *AssetItem) SetOwningProjectId(v string) *AssetItem {
	s.OwningProjectId = &v
	return s
}

// SetTypeIdentifier sets the TypeIdentifier field's value.
func (s *AssetItem) SetTypeIdentifier(v string) *AssetItem {
	s.TypeIdentifier = &v
	return s
}

// SetTypeRevision sets the TypeRevision field's value.
func (s *AssetItem) SetTypeRevision(v string) *AssetItem {
	s.TypeRevision = &v
	return s
}

// The additional attributes of an inventory asset.
type AssetItemAdditionalAttributes struct {
	_ struct{} `type:"structure"`

	// The forms included in the additional attributes of an inventory asset.
	FormsOutput []*FormOutput_ `locationName:"formsOutput" type:"list"`

	// The latest time series data points forms included in the additional attributes
	// of an asset.
	LatestTimeSeriesDataPointFormsOutput []*TimeSeriesDataPointSummaryFormOutput_ `locationName:"latestTimeSeriesDataPointFormsOutput" type:"list"`

	// The read-only forms included in the additional attributes of an inventory
	// asset.
	ReadOnlyFormsOutput []*FormOutput_ `locationName:"readOnlyFormsOutput" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetItemAdditionalAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetItemAdditionalAttributes) GoString() string {
	return s.String()
}

// SetFormsOutput sets the FormsOutput field's value.
func (s *AssetItemAdditionalAttributes) SetFormsOutput(v []*FormOutput_) *AssetItemAdditionalAttributes {
	s.FormsOutput = v
	return s
}

// SetLatestTimeSeriesDataPointFormsOutput sets the LatestTimeSeriesDataPointFormsOutput field's value.
func (s *AssetItemAdditionalAttributes) SetLatestTimeSeriesDataPointFormsOutput(v []*TimeSeriesDataPointSummaryFormOutput_) *AssetItemAdditionalAttributes {
	s.LatestTimeSeriesDataPointFormsOutput = v
	return s
}

// SetReadOnlyFormsOutput sets the ReadOnlyFormsOutput field's value.
func (s *AssetItemAdditionalAttributes) SetReadOnlyFormsOutput(v []*FormOutput_) *AssetItemAdditionalAttributes {
	s.ReadOnlyFormsOutput = v
	return s
}

// An asset published in an Amazon DataZone catalog.
type AssetListing struct {
	_ struct{} `type:"structure"`

	// The identifier of an asset published in an Amazon DataZone catalog.
	AssetId *string `locationName:"assetId" type:"string"`

	// The revision of an asset published in an Amazon DataZone catalog.
	AssetRevision *string `locationName:"assetRevision" min:"1" type:"string"`

	// The type of an asset published in an Amazon DataZone catalog.
	AssetType *string `locationName:"assetType" min:"1" type:"string"`

	// The timestamp of when an asset published in an Amazon DataZone catalog was
	// created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The metadata forms attached to an asset published in an Amazon DataZone catalog.
	Forms *string `locationName:"forms" type:"string"`

	// The glossary terms attached to an asset published in an Amazon DataZone catalog.
	GlossaryTerms []*DetailedGlossaryTerm `locationName:"glossaryTerms" type:"list"`

	// The latest time series data points forms included in the additional attributes
	// of an asset.
	LatestTimeSeriesDataPointForms []*TimeSeriesDataPointSummaryFormOutput_ `locationName:"latestTimeSeriesDataPointForms" type:"list"`

	// The identifier of the project where an asset published in an Amazon DataZone
	// catalog exists.
	OwningProjectId *string `locationName:"owningProjectId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetListing) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetListing) GoString() string {
	return s.String()
}

// SetAssetId sets the AssetId field's value.
func (s *AssetListing) SetAssetId(v string) *AssetListing {
	s.AssetId = &v
	return s
}

// SetAssetRevision sets the AssetRevision field's value.
func (s *AssetListing) SetAssetRevision(v string) *AssetListing {
	s.AssetRevision = &v
	return s
}

// SetAssetType sets the AssetType field's value.
func (s *AssetListing) SetAssetType(v string) *AssetListing {
	s.AssetType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AssetListing) SetCreatedAt(v time.Time) *AssetListing {
	s.CreatedAt = &v
	return s
}

// SetForms sets the Forms field's value.
func (s *AssetListing) SetForms(v string) *AssetListing {
	s.Forms = &v
	return s
}

// SetGlossaryTerms sets the GlossaryTerms field's value.
func (s *AssetListing) SetGlossaryTerms(v []*DetailedGlossaryTerm) *AssetListing {
	s.GlossaryTerms = v
	return s
}

// SetLatestTimeSeriesDataPointForms sets the LatestTimeSeriesDataPointForms field's value.
func (s *AssetListing) SetLatestTimeSeriesDataPointForms(v []*TimeSeriesDataPointSummaryFormOutput_) *AssetListing {
	s.LatestTimeSeriesDataPointForms = v
	return s
}

// SetOwningProjectId sets the OwningProjectId field's value.
func (s *AssetListing) SetOwningProjectId(v string) *AssetListing {
	s.OwningProjectId = &v
	return s
}

// The details of an asset published in an Amazon DataZone catalog.
type AssetListingDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of an asset published in an Amazon DataZone catalog.
	//
	// ListingId is a required field
	ListingId *string `locationName:"listingId" type:"string" required:"true"`

	// The status of an asset published in an Amazon DataZone catalog.
	//
	// ListingStatus is a required field
	ListingStatus *string `locationName:"listingStatus" type:"string" required:"true" enum:"ListingStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetListingDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetListingDetails) GoString() string {
	return s.String()
}

// SetListingId sets the ListingId field's value.
func (s *AssetListingDetails) SetListingId(v string) *AssetListingDetails {
	s.ListingId = &v
	return s
}

// SetListingStatus sets the ListingStatus field's value.
func (s *AssetListingDetails) SetListingStatus(v string) *AssetListingDetails {
	s.ListingStatus = &v
	return s
}

// The details of an asset published in an Amazon DataZone catalog.
type AssetListingItem struct {
	_ struct{} `type:"structure"`

	// The additional attributes of an asset published in an Amazon DataZone catalog.
	AdditionalAttributes *AssetListingItemAdditionalAttributes `locationName:"additionalAttributes" type:"structure"`

	// The timestamp of when an asset published in an Amazon DataZone catalog was
	// created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The description of an asset published in an Amazon DataZone catalog.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssetListingItem's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The identifier of the inventory asset.
	EntityId *string `locationName:"entityId" type:"string"`

	// The revision of the inventory asset.
	EntityRevision *string `locationName:"entityRevision" min:"1" type:"string"`

	// The type of the inventory asset.
	EntityType *string `locationName:"entityType" min:"1" type:"string"`

	// Glossary terms attached to the inventory asset.
	GlossaryTerms []*DetailedGlossaryTerm `locationName:"glossaryTerms" type:"list"`

	// The Amazon DataZone user who created the listing.
	ListingCreatedBy *string `locationName:"listingCreatedBy" type:"string"`

	// The identifier of the listing (asset published in Amazon DataZone catalog).
	ListingId *string `locationName:"listingId" type:"string"`

	// The revision of the listing (asset published in Amazon DataZone catalog).
	ListingRevision *string `locationName:"listingRevision" min:"1" type:"string"`

	// The Amazon DataZone user who updated the listing.
	ListingUpdatedBy *string `locationName:"listingUpdatedBy" type:"string"`

	// The name of the inventory asset.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssetListingItem's
	// String and GoString methods.
	Name *string `locationName:"name" min:"1" type:"string" sensitive:"true"`

	// The identifier of the project that owns the inventory asset.
	OwningProjectId *string `locationName:"owningProjectId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetListingItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetListingItem) GoString() string {
	return s.String()
}

// SetAdditionalAttributes sets the AdditionalAttributes field's value.
func (s *AssetListingItem) SetAdditionalAttributes(v *AssetListingItemAdditionalAttributes) *AssetListingItem {
	s.AdditionalAttributes = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AssetListingItem) SetCreatedAt(v time.Time) *AssetListingItem {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssetListingItem) SetDescription(v string) *AssetListingItem {
	s.Description = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *AssetListingItem) SetEntityId(v string) *AssetListingItem {
	s.EntityId = &v
	return s
}

// SetEntityRevision sets the EntityRevision field's value.
func (s *AssetListingItem) SetEntityRevision(v string) *AssetListingItem {
	s.EntityRevision = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *AssetListingItem) SetEntityType(v string) *AssetListingItem {
	s.EntityType = &v
	return s
}

// SetGlossaryTerms sets the GlossaryTerms field's value.
func (s *AssetListingItem) SetGlossaryTerms(v []*DetailedGlossaryTerm) *AssetListingItem {
	s.GlossaryTerms = v
	return s
}

// SetListingCreatedBy sets the ListingCreatedBy field's value.
func (s *AssetListingItem) SetListingCreatedBy(v string) *AssetListingItem {
	s.ListingCreatedBy = &v
	return s
}

// SetListingId sets the ListingId field's value.
func (s *AssetListingItem) SetListingId(v string) *AssetListingItem {
	s.ListingId = &v
	return s
}

// SetListingRevision sets the ListingRevision field's value.
func (s *AssetListingItem) SetListingRevision(v string) *AssetListingItem {
	s.ListingRevision = &v
	return s
}

// SetListingUpdatedBy sets the ListingUpdatedBy field's value.
func (s *AssetListingItem) SetListingUpdatedBy(v string) *AssetListingItem {
	s.ListingUpdatedBy = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssetListingItem) SetName(v string) *AssetListingItem {
	s.Name = &v
	return s
}

// SetOwningProjectId sets the OwningProjectId field's value.
func (s *AssetListingItem) SetOwningProjectId(v string) *AssetListingItem {
	s.OwningProjectId = &v
	return s
}

// Additional attributes of an inventory asset.
type AssetListingItemAdditionalAttributes struct {
	_ struct{} `type:"structure"`

	// The metadata forms that form additional attributes of the metadata asset.
	Forms *string `locationName:"forms" type:"string"`

	// The latest time series data points forms included in the additional attributes
	// of an asset.
	LatestTimeSeriesDataPointForms []*TimeSeriesDataPointSummaryFormOutput_ `locationName:"latestTimeSeriesDataPointForms" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetListingItemAdditionalAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetListingItemAdditionalAttributes) GoString() string {
	return s.String()
}

// SetForms sets the Forms field's value.
func (s *AssetListingItemAdditionalAttributes) SetForms(v string) *AssetListingItemAdditionalAttributes {
	s.Forms = &v
	return s
}

// SetLatestTimeSeriesDataPointForms sets the LatestTimeSeriesDataPointForms field's value.
func (s *AssetListingItemAdditionalAttributes) SetLatestTimeSeriesDataPointForms(v []*TimeSeriesDataPointSummaryFormOutput_) *AssetListingItemAdditionalAttributes {
	s.LatestTimeSeriesDataPointForms = v
	return s
}

// The revision of an inventory asset.
type AssetRevision struct {
	_ struct{} `type:"structure"`

	// The timestamp of when an inventory asset revison was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon DataZone user who created the asset revision.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// The Amazon DataZone user who created the inventory asset.
	DomainId *string `locationName:"domainId" type:"string"`

	// The identifier of the inventory asset revision.
	Id *string `locationName:"id" type:"string"`

	// The revision details of the inventory asset.
	Revision *string `locationName:"revision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetRevision) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AssetRevision) SetCreatedAt(v time.Time) *AssetRevision {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *AssetRevision) SetCreatedBy(v string) *AssetRevision {
	s.CreatedBy = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *AssetRevision) SetDomainId(v string) *AssetRevision {
	s.DomainId = &v
	return s
}

// SetId sets the Id field's value.
func (s *AssetRevision) SetId(v string) *AssetRevision {
	s.Id = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *AssetRevision) SetRevision(v string) *AssetRevision {
	s.Revision = &v
	return s
}

// The name map for assets.
type AssetTargetNameMap struct {
	_ struct{} `type:"structure"`

	// The identifier of the inventory asset.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" type:"string" required:"true"`

	// The target name in the asset target name map.
	//
	// TargetName is a required field
	TargetName *string `locationName:"targetName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetTargetNameMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetTargetNameMap) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetTargetNameMap) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetTargetNameMap"}
	if s.AssetId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetId"))
	}
	if s.TargetName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetId sets the AssetId field's value.
func (s *AssetTargetNameMap) SetAssetId(v string) *AssetTargetNameMap {
	s.AssetId = &v
	return s
}

// SetTargetName sets the TargetName field's value.
func (s *AssetTargetNameMap) SetTargetName(v string) *AssetTargetNameMap {
	s.TargetName = &v
	return s
}

// The details of the asset type.
type AssetTypeItem struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the asset type was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon DataZone user who created the asset type.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// The description of the asset type.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssetTypeItem's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The identifier of the Amazon DataZone domain where the asset type exists.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The forms included in the details of the asset type.
	//
	// FormsOutput is a required field
	FormsOutput map[string]*FormEntryOutput_ `locationName:"formsOutput" type:"map" required:"true"`

	// The name of the asset type.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The identifier of the Amazon DataZone domain where the asset type was originally
	// created.
	OriginDomainId *string `locationName:"originDomainId" type:"string"`

	// The identifier of the Amazon DataZone project where the asset type exists.
	OriginProjectId *string `locationName:"originProjectId" type:"string"`

	// The identifier of the Amazon DataZone project that owns the asset type.
	//
	// OwningProjectId is a required field
	OwningProjectId *string `locationName:"owningProjectId" type:"string" required:"true"`

	// The revision of the asset type.
	//
	// Revision is a required field
	Revision *string `locationName:"revision" min:"1" type:"string" required:"true"`

	// The timestamp of when the asset type was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`

	// The Amazon DataZone user who updated the asset type.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetTypeItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetTypeItem) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AssetTypeItem) SetCreatedAt(v time.Time) *AssetTypeItem {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *AssetTypeItem) SetCreatedBy(v string) *AssetTypeItem {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssetTypeItem) SetDescription(v string) *AssetTypeItem {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *AssetTypeItem) SetDomainId(v string) *AssetTypeItem {
	s.DomainId = &v
	return s
}

// SetFormsOutput sets the FormsOutput field's value.
func (s *AssetTypeItem) SetFormsOutput(v map[string]*FormEntryOutput_) *AssetTypeItem {
	s.FormsOutput = v
	return s
}

// SetName sets the Name field's value.
func (s *AssetTypeItem) SetName(v string) *AssetTypeItem {
	s.Name = &v
	return s
}

// SetOriginDomainId sets the OriginDomainId field's value.
func (s *AssetTypeItem) SetOriginDomainId(v string) *AssetTypeItem {
	s.OriginDomainId = &v
	return s
}

// SetOriginProjectId sets the OriginProjectId field's value.
func (s *AssetTypeItem) SetOriginProjectId(v string) *AssetTypeItem {
	s.OriginProjectId = &v
	return s
}

// SetOwningProjectId sets the OwningProjectId field's value.
func (s *AssetTypeItem) SetOwningProjectId(v string) *AssetTypeItem {
	s.OwningProjectId = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *AssetTypeItem) SetRevision(v string) *AssetTypeItem {
	s.Revision = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AssetTypeItem) SetUpdatedAt(v time.Time) *AssetTypeItem {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *AssetTypeItem) SetUpdatedBy(v string) *AssetTypeItem {
	s.UpdatedBy = &v
	return s
}

type AssociateEnvironmentRoleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the environment role is associated.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the Amazon DataZone environment.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"environmentIdentifier" type:"string" required:"true"`

	// The ARN of the environment role.
	//
	// EnvironmentRoleArn is a required field
	EnvironmentRoleArn *string `location:"uri" locationName:"environmentRoleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateEnvironmentRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateEnvironmentRoleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateEnvironmentRoleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateEnvironmentRoleInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 1))
	}
	if s.EnvironmentRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentRoleArn"))
	}
	if s.EnvironmentRoleArn != nil && len(*s.EnvironmentRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentRoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *AssociateEnvironmentRoleInput) SetDomainIdentifier(v string) *AssociateEnvironmentRoleInput {
	s.DomainIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *AssociateEnvironmentRoleInput) SetEnvironmentIdentifier(v string) *AssociateEnvironmentRoleInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetEnvironmentRoleArn sets the EnvironmentRoleArn field's value.
func (s *AssociateEnvironmentRoleInput) SetEnvironmentRoleArn(v string) *AssociateEnvironmentRoleInput {
	s.EnvironmentRoleArn = &v
	return s
}

type AssociateEnvironmentRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateEnvironmentRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateEnvironmentRoleOutput) GoString() string {
	return s.String()
}

// The parameters of the console link specified as part of the environment action.
type AwsConsoleLinkParameters struct {
	_ struct{} `type:"structure"`

	// The URI of the console link specified as part of the environment action.
	Uri *string `locationName:"uri" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsConsoleLinkParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsConsoleLinkParameters) GoString() string {
	return s.String()
}

// SetUri sets the Uri field's value.
func (s *AwsConsoleLinkParameters) SetUri(v string) *AwsConsoleLinkParameters {
	s.Uri = &v
	return s
}

// The configuration of the business name generation.
type BusinessNameGenerationConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether the business name generation is enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BusinessNameGenerationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BusinessNameGenerationConfiguration) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *BusinessNameGenerationConfiguration) SetEnabled(v bool) *BusinessNameGenerationConfiguration {
	s.Enabled = &v
	return s
}

type CancelMetadataGenerationRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the metadata generation run
	// is to be cancelled.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the metadata generation run.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMetadataGenerationRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMetadataGenerationRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelMetadataGenerationRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelMetadataGenerationRunInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CancelMetadataGenerationRunInput) SetDomainIdentifier(v string) *CancelMetadataGenerationRunInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *CancelMetadataGenerationRunInput) SetIdentifier(v string) *CancelMetadataGenerationRunInput {
	s.Identifier = &v
	return s
}

type CancelMetadataGenerationRunOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMetadataGenerationRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelMetadataGenerationRunOutput) GoString() string {
	return s.String()
}

type CancelSubscriptionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the Amazon DataZone domain where the subscription
	// request is being cancelled.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The unique identifier of the subscription that is being cancelled.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelSubscriptionInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CancelSubscriptionInput) SetDomainIdentifier(v string) *CancelSubscriptionInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *CancelSubscriptionInput) SetIdentifier(v string) *CancelSubscriptionInput {
	s.Identifier = &v
	return s
}

type CancelSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp that specifies when the request to cancel the subscription
	// was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Specifies the Amazon DataZone user who is cancelling the subscription.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The unique identifier of the Amazon DataZone domain where the subscription
	// is being cancelled.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The identifier of the subscription.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// Specifies whether the permissions to the asset are retained after the subscription
	// is cancelled.
	RetainPermissions *bool `locationName:"retainPermissions" type:"boolean"`

	// The status of the request to cancel the subscription.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"SubscriptionStatus"`

	// The asset to which a subscription is being cancelled.
	//
	// SubscribedListing is a required field
	SubscribedListing *SubscribedListing `locationName:"subscribedListing" type:"structure" required:"true"`

	// The Amazon DataZone user who is made a subscriber to the specified asset
	// by the subscription that is being cancelled.
	//
	// SubscribedPrincipal is a required field
	SubscribedPrincipal *SubscribedPrincipal `locationName:"subscribedPrincipal" type:"structure" required:"true"`

	// The unique ID of the subscripton request for the subscription that is being
	// cancelled.
	SubscriptionRequestId *string `locationName:"subscriptionRequestId" type:"string"`

	// The timestamp that specifies when the subscription was cancelled.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// The Amazon DataZone user that cancelled the subscription.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelSubscriptionOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CancelSubscriptionOutput) SetCreatedAt(v time.Time) *CancelSubscriptionOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CancelSubscriptionOutput) SetCreatedBy(v string) *CancelSubscriptionOutput {
	s.CreatedBy = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CancelSubscriptionOutput) SetDomainId(v string) *CancelSubscriptionOutput {
	s.DomainId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CancelSubscriptionOutput) SetId(v string) *CancelSubscriptionOutput {
	s.Id = &v
	return s
}

// SetRetainPermissions sets the RetainPermissions field's value.
func (s *CancelSubscriptionOutput) SetRetainPermissions(v bool) *CancelSubscriptionOutput {
	s.RetainPermissions = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CancelSubscriptionOutput) SetStatus(v string) *CancelSubscriptionOutput {
	s.Status = &v
	return s
}

// SetSubscribedListing sets the SubscribedListing field's value.
func (s *CancelSubscriptionOutput) SetSubscribedListing(v *SubscribedListing) *CancelSubscriptionOutput {
	s.SubscribedListing = v
	return s
}

// SetSubscribedPrincipal sets the SubscribedPrincipal field's value.
func (s *CancelSubscriptionOutput) SetSubscribedPrincipal(v *SubscribedPrincipal) *CancelSubscriptionOutput {
	s.SubscribedPrincipal = v
	return s
}

// SetSubscriptionRequestId sets the SubscriptionRequestId field's value.
func (s *CancelSubscriptionOutput) SetSubscriptionRequestId(v string) *CancelSubscriptionOutput {
	s.SubscriptionRequestId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CancelSubscriptionOutput) SetUpdatedAt(v time.Time) *CancelSubscriptionOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *CancelSubscriptionOutput) SetUpdatedBy(v string) *CancelSubscriptionOutput {
	s.UpdatedBy = &v
	return s
}

// Part of the provisioning properties of the environment blueprint.
type CloudFormationProperties struct {
	_ struct{} `type:"structure"`

	// The template URL of the cloud formation provisioning properties of the environment
	// blueprint.
	//
	// TemplateUrl is a required field
	TemplateUrl *string `locationName:"templateUrl" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudFormationProperties) GoString() string {
	return s.String()
}

// SetTemplateUrl sets the TemplateUrl field's value.
func (s *CloudFormationProperties) SetTemplateUrl(v string) *CloudFormationProperties {
	s.TemplateUrl = &v
	return s
}

// The column configuration of the asset filter.
type ColumnFilterConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether to include column names.
	IncludedColumnNames []*string `locationName:"includedColumnNames" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnFilterConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnFilterConfiguration) GoString() string {
	return s.String()
}

// SetIncludedColumnNames sets the IncludedColumnNames field's value.
func (s *ColumnFilterConfiguration) SetIncludedColumnNames(v []*string) *ColumnFilterConfiguration {
	s.IncludedColumnNames = v
	return s
}

// The details of the parameters for the configurable environment action.
type ConfigurableActionParameter struct {
	_ struct{} `type:"structure"`

	// The key of the configurable action parameter.
	Key *string `locationName:"key" type:"string"`

	// The value of the configurable action parameter.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurableActionParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurableActionParameter) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ConfigurableActionParameter) SetKey(v string) *ConfigurableActionParameter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConfigurableActionParameter) SetValue(v string) *ConfigurableActionParameter {
	s.Value = &v
	return s
}

// The configurable action of a Amazon DataZone environment.
type ConfigurableEnvironmentAction struct {
	_ struct{} `type:"structure"`

	// The authentication type of a configurable action of a Amazon DataZone environment.
	Auth *string `locationName:"auth" type:"string" enum:"ConfigurableActionTypeAuthorization"`

	// The parameters of a configurable action in a Amazon DataZone environment.
	//
	// Parameters is a required field
	Parameters []*ConfigurableActionParameter `locationName:"parameters" type:"list" required:"true"`

	// The type of a configurable action in a Amazon DataZone environment.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurableEnvironmentAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigurableEnvironmentAction) GoString() string {
	return s.String()
}

// SetAuth sets the Auth field's value.
func (s *ConfigurableEnvironmentAction) SetAuth(v string) *ConfigurableEnvironmentAction {
	s.Auth = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ConfigurableEnvironmentAction) SetParameters(v []*ConfigurableActionParameter) *ConfigurableEnvironmentAction {
	s.Parameters = v
	return s
}

// SetType sets the Type field's value.
func (s *ConfigurableEnvironmentAction) SetType(v string) *ConfigurableEnvironmentAction {
	s.Type = &v
	return s
}

// There is a conflict while performing this action.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAssetFilterInput struct {
	_ struct{} `type:"structure"`

	// The ID of the data asset.
	//
	// AssetIdentifier is a required field
	AssetIdentifier *string `location:"uri" locationName:"assetIdentifier" type:"string" required:"true"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The configuration of the asset filter.
	//
	// Configuration is a required field
	Configuration *AssetFilterConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// The description of the asset filter.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetFilterInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the domain in which you want to create an asset filter.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The name of the asset filter.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetFilterInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssetFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssetFilterInput"}
	if s.AssetIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetIdentifier"))
	}
	if s.AssetIdentifier != nil && len(*s.AssetIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetIdentifier", 1))
	}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetIdentifier sets the AssetIdentifier field's value.
func (s *CreateAssetFilterInput) SetAssetIdentifier(v string) *CreateAssetFilterInput {
	s.AssetIdentifier = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAssetFilterInput) SetClientToken(v string) *CreateAssetFilterInput {
	s.ClientToken = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateAssetFilterInput) SetConfiguration(v *AssetFilterConfiguration) *CreateAssetFilterInput {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAssetFilterInput) SetDescription(v string) *CreateAssetFilterInput {
	s.Description = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateAssetFilterInput) SetDomainIdentifier(v string) *CreateAssetFilterInput {
	s.DomainIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssetFilterInput) SetName(v string) *CreateAssetFilterInput {
	s.Name = &v
	return s
}

type CreateAssetFilterOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the asset.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" type:"string" required:"true"`

	// The configuration of the asset filter.
	//
	// Configuration is a required field
	Configuration *AssetFilterConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// The timestamp at which the asset filter was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The description of the asset filter.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetFilterOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the domain where the asset filter is created.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The column names in the asset filter.
	EffectiveColumnNames []*string `locationName:"effectiveColumnNames" type:"list"`

	// The row filter in the asset filter.
	EffectiveRowFilter *string `locationName:"effectiveRowFilter" type:"string"`

	// The error message that is displayed if the asset filter is not created successfully.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The ID of the asset filter.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the asset filter.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetFilterOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The status of the asset filter.
	Status *string `locationName:"status" type:"string" enum:"FilterStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetFilterOutput) GoString() string {
	return s.String()
}

// SetAssetId sets the AssetId field's value.
func (s *CreateAssetFilterOutput) SetAssetId(v string) *CreateAssetFilterOutput {
	s.AssetId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateAssetFilterOutput) SetConfiguration(v *AssetFilterConfiguration) *CreateAssetFilterOutput {
	s.Configuration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateAssetFilterOutput) SetCreatedAt(v time.Time) *CreateAssetFilterOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAssetFilterOutput) SetDescription(v string) *CreateAssetFilterOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateAssetFilterOutput) SetDomainId(v string) *CreateAssetFilterOutput {
	s.DomainId = &v
	return s
}

// SetEffectiveColumnNames sets the EffectiveColumnNames field's value.
func (s *CreateAssetFilterOutput) SetEffectiveColumnNames(v []*string) *CreateAssetFilterOutput {
	s.EffectiveColumnNames = v
	return s
}

// SetEffectiveRowFilter sets the EffectiveRowFilter field's value.
func (s *CreateAssetFilterOutput) SetEffectiveRowFilter(v string) *CreateAssetFilterOutput {
	s.EffectiveRowFilter = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *CreateAssetFilterOutput) SetErrorMessage(v string) *CreateAssetFilterOutput {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateAssetFilterOutput) SetId(v string) *CreateAssetFilterOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssetFilterOutput) SetName(v string) *CreateAssetFilterOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateAssetFilterOutput) SetStatus(v string) *CreateAssetFilterOutput {
	s.Status = &v
	return s
}

type CreateAssetInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Asset description.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// Amazon DataZone domain where the asset is created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The external identifier of the asset.
	//
	// ExternalIdentifier is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetInput's
	// String and GoString methods.
	ExternalIdentifier *string `locationName:"externalIdentifier" min:"1" type:"string" sensitive:"true"`

	// Metadata forms attached to the asset.
	//
	// FormsInput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetInput's
	// String and GoString methods.
	FormsInput []*FormInput_ `locationName:"formsInput" type:"list" sensitive:"true"`

	// Glossary terms attached to the asset.
	GlossaryTerms []*string `locationName:"glossaryTerms" min:"1" type:"list"`

	// Asset name.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The unique identifier of the project that owns this asset.
	//
	// OwningProjectIdentifier is a required field
	OwningProjectIdentifier *string `locationName:"owningProjectIdentifier" type:"string" required:"true"`

	// The configuration of the automatically generated business-friendly metadata
	// for the asset.
	PredictionConfiguration *PredictionConfiguration `locationName:"predictionConfiguration" type:"structure"`

	// The unique identifier of this asset's type.
	//
	// TypeIdentifier is a required field
	TypeIdentifier *string `locationName:"typeIdentifier" min:"1" type:"string" required:"true"`

	// The revision of this asset's type.
	TypeRevision *string `locationName:"typeRevision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssetInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.ExternalIdentifier != nil && len(*s.ExternalIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalIdentifier", 1))
	}
	if s.GlossaryTerms != nil && len(s.GlossaryTerms) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GlossaryTerms", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OwningProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("OwningProjectIdentifier"))
	}
	if s.TypeIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeIdentifier"))
	}
	if s.TypeIdentifier != nil && len(*s.TypeIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeIdentifier", 1))
	}
	if s.TypeRevision != nil && len(*s.TypeRevision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeRevision", 1))
	}
	if s.FormsInput != nil {
		for i, v := range s.FormsInput {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FormsInput", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAssetInput) SetClientToken(v string) *CreateAssetInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAssetInput) SetDescription(v string) *CreateAssetInput {
	s.Description = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateAssetInput) SetDomainIdentifier(v string) *CreateAssetInput {
	s.DomainIdentifier = &v
	return s
}

// SetExternalIdentifier sets the ExternalIdentifier field's value.
func (s *CreateAssetInput) SetExternalIdentifier(v string) *CreateAssetInput {
	s.ExternalIdentifier = &v
	return s
}

// SetFormsInput sets the FormsInput field's value.
func (s *CreateAssetInput) SetFormsInput(v []*FormInput_) *CreateAssetInput {
	s.FormsInput = v
	return s
}

// SetGlossaryTerms sets the GlossaryTerms field's value.
func (s *CreateAssetInput) SetGlossaryTerms(v []*string) *CreateAssetInput {
	s.GlossaryTerms = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssetInput) SetName(v string) *CreateAssetInput {
	s.Name = &v
	return s
}

// SetOwningProjectIdentifier sets the OwningProjectIdentifier field's value.
func (s *CreateAssetInput) SetOwningProjectIdentifier(v string) *CreateAssetInput {
	s.OwningProjectIdentifier = &v
	return s
}

// SetPredictionConfiguration sets the PredictionConfiguration field's value.
func (s *CreateAssetInput) SetPredictionConfiguration(v *PredictionConfiguration) *CreateAssetInput {
	s.PredictionConfiguration = v
	return s
}

// SetTypeIdentifier sets the TypeIdentifier field's value.
func (s *CreateAssetInput) SetTypeIdentifier(v string) *CreateAssetInput {
	s.TypeIdentifier = &v
	return s
}

// SetTypeRevision sets the TypeRevision field's value.
func (s *CreateAssetInput) SetTypeRevision(v string) *CreateAssetInput {
	s.TypeRevision = &v
	return s
}

type CreateAssetOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the asset was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon DataZone user that created this asset in the catalog.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// The description of the created asset.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain in which the asset was created.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The external identifier of the asset.
	//
	// ExternalIdentifier is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetOutput's
	// String and GoString methods.
	ExternalIdentifier *string `locationName:"externalIdentifier" min:"1" type:"string" sensitive:"true"`

	// The timestamp of when the first revision of the asset took place.
	FirstRevisionCreatedAt *time.Time `locationName:"firstRevisionCreatedAt" type:"timestamp"`

	// The Amazon DataZone user that made the first revision of the asset.
	FirstRevisionCreatedBy *string `locationName:"firstRevisionCreatedBy" type:"string"`

	// The metadata forms that are attached to the created asset.
	//
	// FormsOutput is a required field
	FormsOutput []*FormOutput_ `locationName:"formsOutput" type:"list" required:"true"`

	// The glossary terms that are attached to the created asset.
	GlossaryTerms []*string `locationName:"glossaryTerms" min:"1" type:"list"`

	// The unique identifier of the created asset.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The latest data point that was imported into the time series form for the
	// asset.
	LatestTimeSeriesDataPointFormsOutput []*TimeSeriesDataPointSummaryFormOutput_ `locationName:"latestTimeSeriesDataPointFormsOutput" type:"list"`

	// The details of an asset published in an Amazon DataZone catalog.
	Listing *AssetListingDetails `locationName:"listing" type:"structure"`

	// The name of the created asset.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The ID of the Amazon DataZone project that owns the created asset.
	//
	// OwningProjectId is a required field
	OwningProjectId *string `locationName:"owningProjectId" type:"string" required:"true"`

	// The configuration of the automatically generated business-friendly metadata
	// for the asset.
	PredictionConfiguration *PredictionConfiguration `locationName:"predictionConfiguration" type:"structure"`

	// The read-only metadata forms that are attached to the created asset.
	ReadOnlyFormsOutput []*FormOutput_ `locationName:"readOnlyFormsOutput" type:"list"`

	// The revision of the asset.
	//
	// Revision is a required field
	Revision *string `locationName:"revision" min:"1" type:"string" required:"true"`

	// The identifier of the created asset type.
	//
	// TypeIdentifier is a required field
	TypeIdentifier *string `locationName:"typeIdentifier" min:"1" type:"string" required:"true"`

	// The revision type of the asset.
	//
	// TypeRevision is a required field
	TypeRevision *string `locationName:"typeRevision" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateAssetOutput) SetCreatedAt(v time.Time) *CreateAssetOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CreateAssetOutput) SetCreatedBy(v string) *CreateAssetOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAssetOutput) SetDescription(v string) *CreateAssetOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateAssetOutput) SetDomainId(v string) *CreateAssetOutput {
	s.DomainId = &v
	return s
}

// SetExternalIdentifier sets the ExternalIdentifier field's value.
func (s *CreateAssetOutput) SetExternalIdentifier(v string) *CreateAssetOutput {
	s.ExternalIdentifier = &v
	return s
}

// SetFirstRevisionCreatedAt sets the FirstRevisionCreatedAt field's value.
func (s *CreateAssetOutput) SetFirstRevisionCreatedAt(v time.Time) *CreateAssetOutput {
	s.FirstRevisionCreatedAt = &v
	return s
}

// SetFirstRevisionCreatedBy sets the FirstRevisionCreatedBy field's value.
func (s *CreateAssetOutput) SetFirstRevisionCreatedBy(v string) *CreateAssetOutput {
	s.FirstRevisionCreatedBy = &v
	return s
}

// SetFormsOutput sets the FormsOutput field's value.
func (s *CreateAssetOutput) SetFormsOutput(v []*FormOutput_) *CreateAssetOutput {
	s.FormsOutput = v
	return s
}

// SetGlossaryTerms sets the GlossaryTerms field's value.
func (s *CreateAssetOutput) SetGlossaryTerms(v []*string) *CreateAssetOutput {
	s.GlossaryTerms = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateAssetOutput) SetId(v string) *CreateAssetOutput {
	s.Id = &v
	return s
}

// SetLatestTimeSeriesDataPointFormsOutput sets the LatestTimeSeriesDataPointFormsOutput field's value.
func (s *CreateAssetOutput) SetLatestTimeSeriesDataPointFormsOutput(v []*TimeSeriesDataPointSummaryFormOutput_) *CreateAssetOutput {
	s.LatestTimeSeriesDataPointFormsOutput = v
	return s
}

// SetListing sets the Listing field's value.
func (s *CreateAssetOutput) SetListing(v *AssetListingDetails) *CreateAssetOutput {
	s.Listing = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssetOutput) SetName(v string) *CreateAssetOutput {
	s.Name = &v
	return s
}

// SetOwningProjectId sets the OwningProjectId field's value.
func (s *CreateAssetOutput) SetOwningProjectId(v string) *CreateAssetOutput {
	s.OwningProjectId = &v
	return s
}

// SetPredictionConfiguration sets the PredictionConfiguration field's value.
func (s *CreateAssetOutput) SetPredictionConfiguration(v *PredictionConfiguration) *CreateAssetOutput {
	s.PredictionConfiguration = v
	return s
}

// SetReadOnlyFormsOutput sets the ReadOnlyFormsOutput field's value.
func (s *CreateAssetOutput) SetReadOnlyFormsOutput(v []*FormOutput_) *CreateAssetOutput {
	s.ReadOnlyFormsOutput = v
	return s
}

// SetRevision sets the Revision field's value.
func (s *CreateAssetOutput) SetRevision(v string) *CreateAssetOutput {
	s.Revision = &v
	return s
}

// SetTypeIdentifier sets the TypeIdentifier field's value.
func (s *CreateAssetOutput) SetTypeIdentifier(v string) *CreateAssetOutput {
	s.TypeIdentifier = &v
	return s
}

// SetTypeRevision sets the TypeRevision field's value.
func (s *CreateAssetOutput) SetTypeRevision(v string) *CreateAssetOutput {
	s.TypeRevision = &v
	return s
}

type CreateAssetRevisionInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The revised description of the asset.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetRevisionInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The unique identifier of the domain where the asset is being revised.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The metadata forms to be attached to the asset as part of asset revision.
	//
	// FormsInput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetRevisionInput's
	// String and GoString methods.
	FormsInput []*FormInput_ `locationName:"formsInput" type:"list" sensitive:"true"`

	// The glossary terms to be attached to the asset as part of asset revision.
	GlossaryTerms []*string `locationName:"glossaryTerms" min:"1" type:"list"`

	// The identifier of the asset.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`

	// Te revised name of the asset.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetRevisionInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The configuration of the automatically generated business-friendly metadata
	// for the asset.
	PredictionConfiguration *PredictionConfiguration `locationName:"predictionConfiguration" type:"structure"`

	// The revision type of the asset.
	TypeRevision *string `locationName:"typeRevision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssetRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssetRevisionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.GlossaryTerms != nil && len(s.GlossaryTerms) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GlossaryTerms", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TypeRevision != nil && len(*s.TypeRevision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeRevision", 1))
	}
	if s.FormsInput != nil {
		for i, v := range s.FormsInput {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FormsInput", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAssetRevisionInput) SetClientToken(v string) *CreateAssetRevisionInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAssetRevisionInput) SetDescription(v string) *CreateAssetRevisionInput {
	s.Description = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateAssetRevisionInput) SetDomainIdentifier(v string) *CreateAssetRevisionInput {
	s.DomainIdentifier = &v
	return s
}

// SetFormsInput sets the FormsInput field's value.
func (s *CreateAssetRevisionInput) SetFormsInput(v []*FormInput_) *CreateAssetRevisionInput {
	s.FormsInput = v
	return s
}

// SetGlossaryTerms sets the GlossaryTerms field's value.
func (s *CreateAssetRevisionInput) SetGlossaryTerms(v []*string) *CreateAssetRevisionInput {
	s.GlossaryTerms = v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *CreateAssetRevisionInput) SetIdentifier(v string) *CreateAssetRevisionInput {
	s.Identifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssetRevisionInput) SetName(v string) *CreateAssetRevisionInput {
	s.Name = &v
	return s
}

// SetPredictionConfiguration sets the PredictionConfiguration field's value.
func (s *CreateAssetRevisionInput) SetPredictionConfiguration(v *PredictionConfiguration) *CreateAssetRevisionInput {
	s.PredictionConfiguration = v
	return s
}

// SetTypeRevision sets the TypeRevision field's value.
func (s *CreateAssetRevisionInput) SetTypeRevision(v string) *CreateAssetRevisionInput {
	s.TypeRevision = &v
	return s
}

type CreateAssetRevisionOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the asset revision occured.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon DataZone user who performed the asset revision.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// The revised asset description.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetRevisionOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The unique identifier of the Amazon DataZone domain where the asset was revised.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The external identifier of the asset.
	//
	// ExternalIdentifier is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetRevisionOutput's
	// String and GoString methods.
	ExternalIdentifier *string `locationName:"externalIdentifier" min:"1" type:"string" sensitive:"true"`

	// The timestamp of when the first asset revision occured.
	FirstRevisionCreatedAt *time.Time `locationName:"firstRevisionCreatedAt" type:"timestamp"`

	// The Amazon DataZone user who performed the first asset revision.
	FirstRevisionCreatedBy *string `locationName:"firstRevisionCreatedBy" type:"string"`

	// The metadata forms that were attached to the asset as part of the asset revision.
	//
	// FormsOutput is a required field
	FormsOutput []*FormOutput_ `locationName:"formsOutput" type:"list" required:"true"`

	// The glossary terms that were attached to the asset as part of asset revision.
	GlossaryTerms []*string `locationName:"glossaryTerms" min:"1" type:"list"`

	// The unique identifier of the asset revision.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The latest data point that was imported into the time series form for the
	// asset.
	LatestTimeSeriesDataPointFormsOutput []*TimeSeriesDataPointSummaryFormOutput_ `locationName:"latestTimeSeriesDataPointFormsOutput" type:"list"`

	// The details of an asset published in an Amazon DataZone catalog.
	Listing *AssetListingDetails `locationName:"listing" type:"structure"`

	// The revised name of the asset.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetRevisionOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The unique identifier of the revised project that owns the asset.
	//
	// OwningProjectId is a required field
	OwningProjectId *string `locationName:"owningProjectId" type:"string" required:"true"`

	// The configuration of the automatically generated business-friendly metadata
	// for the asset.
	PredictionConfiguration *PredictionConfiguration `locationName:"predictionConfiguration" type:"structure"`

	// The read-only metadata forms that were attached to the asset as part of the
	// asset revision.
	ReadOnlyFormsOutput []*FormOutput_ `locationName:"readOnlyFormsOutput" type:"list"`

	// The revision of the asset.
	//
	// Revision is a required field
	Revision *string `locationName:"revision" min:"1" type:"string" required:"true"`

	// The identifier of the revision type.
	//
	// TypeIdentifier is a required field
	TypeIdentifier *string `locationName:"typeIdentifier" min:"1" type:"string" required:"true"`

	// The revision type of the asset.
	//
	// TypeRevision is a required field
	TypeRevision *string `locationName:"typeRevision" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetRevisionOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateAssetRevisionOutput) SetCreatedAt(v time.Time) *CreateAssetRevisionOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CreateAssetRevisionOutput) SetCreatedBy(v string) *CreateAssetRevisionOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAssetRevisionOutput) SetDescription(v string) *CreateAssetRevisionOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateAssetRevisionOutput) SetDomainId(v string) *CreateAssetRevisionOutput {
	s.DomainId = &v
	return s
}

// SetExternalIdentifier sets the ExternalIdentifier field's value.
func (s *CreateAssetRevisionOutput) SetExternalIdentifier(v string) *CreateAssetRevisionOutput {
	s.ExternalIdentifier = &v
	return s
}

// SetFirstRevisionCreatedAt sets the FirstRevisionCreatedAt field's value.
func (s *CreateAssetRevisionOutput) SetFirstRevisionCreatedAt(v time.Time) *CreateAssetRevisionOutput {
	s.FirstRevisionCreatedAt = &v
	return s
}

// SetFirstRevisionCreatedBy sets the FirstRevisionCreatedBy field's value.
func (s *CreateAssetRevisionOutput) SetFirstRevisionCreatedBy(v string) *CreateAssetRevisionOutput {
	s.FirstRevisionCreatedBy = &v
	return s
}

// SetFormsOutput sets the FormsOutput field's value.
func (s *CreateAssetRevisionOutput) SetFormsOutput(v []*FormOutput_) *CreateAssetRevisionOutput {
	s.FormsOutput = v
	return s
}

// SetGlossaryTerms sets the GlossaryTerms field's value.
func (s *CreateAssetRevisionOutput) SetGlossaryTerms(v []*string) *CreateAssetRevisionOutput {
	s.GlossaryTerms = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateAssetRevisionOutput) SetId(v string) *CreateAssetRevisionOutput {
	s.Id = &v
	return s
}

// SetLatestTimeSeriesDataPointFormsOutput sets the LatestTimeSeriesDataPointFormsOutput field's value.
func (s *CreateAssetRevisionOutput) SetLatestTimeSeriesDataPointFormsOutput(v []*TimeSeriesDataPointSummaryFormOutput_) *CreateAssetRevisionOutput {
	s.LatestTimeSeriesDataPointFormsOutput = v
	return s
}

// SetListing sets the Listing field's value.
func (s *CreateAssetRevisionOutput) SetListing(v *AssetListingDetails) *CreateAssetRevisionOutput {
	s.Listing = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssetRevisionOutput) SetName(v string) *CreateAssetRevisionOutput {
	s.Name = &v
	return s
}

// SetOwningProjectId sets the OwningProjectId field's value.
func (s *CreateAssetRevisionOutput) SetOwningProjectId(v string) *CreateAssetRevisionOutput {
	s.OwningProjectId = &v
	return s
}

// SetPredictionConfiguration sets the PredictionConfiguration field's value.
func (s *CreateAssetRevisionOutput) SetPredictionConfiguration(v *PredictionConfiguration) *CreateAssetRevisionOutput {
	s.PredictionConfiguration = v
	return s
}

// SetReadOnlyFormsOutput sets the ReadOnlyFormsOutput field's value.
func (s *CreateAssetRevisionOutput) SetReadOnlyFormsOutput(v []*FormOutput_) *CreateAssetRevisionOutput {
	s.ReadOnlyFormsOutput = v
	return s
}

// SetRevision sets the Revision field's value.
func (s *CreateAssetRevisionOutput) SetRevision(v string) *CreateAssetRevisionOutput {
	s.Revision = &v
	return s
}

// SetTypeIdentifier sets the TypeIdentifier field's value.
func (s *CreateAssetRevisionOutput) SetTypeIdentifier(v string) *CreateAssetRevisionOutput {
	s.TypeIdentifier = &v
	return s
}

// SetTypeRevision sets the TypeRevision field's value.
func (s *CreateAssetRevisionOutput) SetTypeRevision(v string) *CreateAssetRevisionOutput {
	s.TypeRevision = &v
	return s
}

type CreateAssetTypeInput struct {
	_ struct{} `type:"structure"`

	// The descripton of the custom asset type.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetTypeInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The unique identifier of the Amazon DataZone domain where the custom asset
	// type is being created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The metadata forms that are to be attached to the custom asset type.
	//
	// FormsInput is a required field
	FormsInput map[string]*FormEntryInput_ `locationName:"formsInput" type:"map" required:"true"`

	// The name of the custom asset type.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The identifier of the Amazon DataZone project that is to own the custom asset
	// type.
	//
	// OwningProjectIdentifier is a required field
	OwningProjectIdentifier *string `locationName:"owningProjectIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssetTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssetTypeInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.FormsInput == nil {
		invalidParams.Add(request.NewErrParamRequired("FormsInput"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OwningProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("OwningProjectIdentifier"))
	}
	if s.FormsInput != nil {
		for i, v := range s.FormsInput {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FormsInput", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateAssetTypeInput) SetDescription(v string) *CreateAssetTypeInput {
	s.Description = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateAssetTypeInput) SetDomainIdentifier(v string) *CreateAssetTypeInput {
	s.DomainIdentifier = &v
	return s
}

// SetFormsInput sets the FormsInput field's value.
func (s *CreateAssetTypeInput) SetFormsInput(v map[string]*FormEntryInput_) *CreateAssetTypeInput {
	s.FormsInput = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssetTypeInput) SetName(v string) *CreateAssetTypeInput {
	s.Name = &v
	return s
}

// SetOwningProjectIdentifier sets the OwningProjectIdentifier field's value.
func (s *CreateAssetTypeInput) SetOwningProjectIdentifier(v string) *CreateAssetTypeInput {
	s.OwningProjectIdentifier = &v
	return s
}

type CreateAssetTypeOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the asset type is to be created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon DataZone user who creates this custom asset type.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// The description of the custom asset type.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAssetTypeOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain in which the asset type was created.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The metadata forms that are attached to the asset type.
	//
	// FormsOutput is a required field
	FormsOutput map[string]*FormEntryOutput_ `locationName:"formsOutput" type:"map" required:"true"`

	// The name of the asset type.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ID of the Amazon DataZone domain where the asset type was originally
	// created.
	OriginDomainId *string `locationName:"originDomainId" type:"string"`

	// The ID of the Amazon DataZone project where the asset type was originally
	// created.
	OriginProjectId *string `locationName:"originProjectId" type:"string"`

	// The ID of the Amazon DataZone project that currently owns this asset type.
	OwningProjectId *string `locationName:"owningProjectId" type:"string"`

	// The revision of the custom asset type.
	//
	// Revision is a required field
	Revision *string `locationName:"revision" min:"1" type:"string" required:"true"`

	// The timestamp of when the custom type was created.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`

	// The Amazon DataZone user that created the custom asset type.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssetTypeOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateAssetTypeOutput) SetCreatedAt(v time.Time) *CreateAssetTypeOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CreateAssetTypeOutput) SetCreatedBy(v string) *CreateAssetTypeOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAssetTypeOutput) SetDescription(v string) *CreateAssetTypeOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateAssetTypeOutput) SetDomainId(v string) *CreateAssetTypeOutput {
	s.DomainId = &v
	return s
}

// SetFormsOutput sets the FormsOutput field's value.
func (s *CreateAssetTypeOutput) SetFormsOutput(v map[string]*FormEntryOutput_) *CreateAssetTypeOutput {
	s.FormsOutput = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssetTypeOutput) SetName(v string) *CreateAssetTypeOutput {
	s.Name = &v
	return s
}

// SetOriginDomainId sets the OriginDomainId field's value.
func (s *CreateAssetTypeOutput) SetOriginDomainId(v string) *CreateAssetTypeOutput {
	s.OriginDomainId = &v
	return s
}

// SetOriginProjectId sets the OriginProjectId field's value.
func (s *CreateAssetTypeOutput) SetOriginProjectId(v string) *CreateAssetTypeOutput {
	s.OriginProjectId = &v
	return s
}

// SetOwningProjectId sets the OwningProjectId field's value.
func (s *CreateAssetTypeOutput) SetOwningProjectId(v string) *CreateAssetTypeOutput {
	s.OwningProjectId = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *CreateAssetTypeOutput) SetRevision(v string) *CreateAssetTypeOutput {
	s.Revision = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateAssetTypeOutput) SetUpdatedAt(v time.Time) *CreateAssetTypeOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *CreateAssetTypeOutput) SetUpdatedBy(v string) *CreateAssetTypeOutput {
	s.UpdatedBy = &v
	return s
}

type CreateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The metadata forms that are to be attached to the assets that this data source
	// works with.
	//
	// AssetFormsInput is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateDataSourceInput's
	// String and GoString methods.
	AssetFormsInput []*FormInput_ `locationName:"assetFormsInput" type:"list" sensitive:"true"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// Specifies the configuration of the data source. It can be set to either glueRunConfiguration
	// or redshiftRunConfiguration.
	Configuration *DataSourceConfigurationInput_ `locationName:"configuration" type:"structure"`

	// The description of the data source.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateDataSourceInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain where the data source is created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// Specifies whether the data source is enabled.
	EnableSetting *string `locationName:"enableSetting" type:"string" enum:"EnableSetting"`

	// The unique identifier of the Amazon DataZone environment to which the data
	// source publishes assets.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `locationName:"environmentIdentifier" type:"string" required:"true"`

	// The name of the data source.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateDataSourceInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The identifier of the Amazon DataZone project in which you want to add this
	// data source.
	//
	// ProjectIdentifier is a required field
	ProjectIdentifier *string `locationName:"projectIdentifier" type:"string" required:"true"`

	// Specifies whether the assets that this data source creates in the inventory
	// are to be also automatically published to the catalog.
	PublishOnImport *bool `locationName:"publishOnImport" type:"boolean"`

	// Specifies whether the business name generation is to be enabled for this
	// data source.
	Recommendation *RecommendationConfiguration `locationName:"recommendation" type:"structure"`

	// The schedule of the data source runs.
	//
	// Schedule is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateDataSourceInput's
	// String and GoString methods.
	Schedule *ScheduleConfiguration `locationName:"schedule" type:"structure" sensitive:"true"`

	// The type of the data source.
	//
	// Type is a required field
	Type *string `locationName:"type" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSourceInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectIdentifier"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}
	if s.AssetFormsInput != nil {
		for i, v := range s.AssetFormsInput {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetFormsInput", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetFormsInput sets the AssetFormsInput field's value.
func (s *CreateDataSourceInput) SetAssetFormsInput(v []*FormInput_) *CreateDataSourceInput {
	s.AssetFormsInput = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDataSourceInput) SetClientToken(v string) *CreateDataSourceInput {
	s.ClientToken = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateDataSourceInput) SetConfiguration(v *DataSourceConfigurationInput_) *CreateDataSourceInput {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDataSourceInput) SetDescription(v string) *CreateDataSourceInput {
	s.Description = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateDataSourceInput) SetDomainIdentifier(v string) *CreateDataSourceInput {
	s.DomainIdentifier = &v
	return s
}

// SetEnableSetting sets the EnableSetting field's value.
func (s *CreateDataSourceInput) SetEnableSetting(v string) *CreateDataSourceInput {
	s.EnableSetting = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *CreateDataSourceInput) SetEnvironmentIdentifier(v string) *CreateDataSourceInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSourceInput) SetName(v string) *CreateDataSourceInput {
	s.Name = &v
	return s
}

// SetProjectIdentifier sets the ProjectIdentifier field's value.
func (s *CreateDataSourceInput) SetProjectIdentifier(v string) *CreateDataSourceInput {
	s.ProjectIdentifier = &v
	return s
}

// SetPublishOnImport sets the PublishOnImport field's value.
func (s *CreateDataSourceInput) SetPublishOnImport(v bool) *CreateDataSourceInput {
	s.PublishOnImport = &v
	return s
}

// SetRecommendation sets the Recommendation field's value.
func (s *CreateDataSourceInput) SetRecommendation(v *RecommendationConfiguration) *CreateDataSourceInput {
	s.Recommendation = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateDataSourceInput) SetSchedule(v *ScheduleConfiguration) *CreateDataSourceInput {
	s.Schedule = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateDataSourceInput) SetType(v string) *CreateDataSourceInput {
	s.Type = &v
	return s
}

type CreateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The metadata forms attached to the assets that this data source creates.
	AssetFormsOutput []*FormOutput_ `locationName:"assetFormsOutput" type:"list"`

	// Specifies the configuration of the data source. It can be set to either glueRunConfiguration
	// or redshiftRunConfiguration.
	Configuration *DataSourceConfigurationOutput_ `locationName:"configuration" type:"structure"`

	// The timestamp of when the data source was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the data source.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateDataSourceOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain in which the data source is created.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// Specifies whether the data source is enabled.
	EnableSetting *string `locationName:"enableSetting" type:"string" enum:"EnableSetting"`

	// The unique identifier of the Amazon DataZone environment to which the data
	// source publishes assets.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// Specifies the error message that is returned if the operation cannot be successfully
	// completed.
	ErrorMessage *DataSourceErrorMessage `locationName:"errorMessage" type:"structure"`

	// The unique identifier of the data source.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The timestamp that specifies when the data source was last run.
	LastRunAt *time.Time `locationName:"lastRunAt" type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the error message that is returned if the operation cannot be successfully
	// completed.
	LastRunErrorMessage *DataSourceErrorMessage `locationName:"lastRunErrorMessage" type:"structure"`

	// The status of the last run of this data source.
	LastRunStatus *string `locationName:"lastRunStatus" type:"string" enum:"DataSourceRunStatus"`

	// The name of the data source.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateDataSourceOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The ID of the Amazon DataZone project to which the data source is added.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" type:"string" required:"true"`

	// Specifies whether the assets that this data source creates in the inventory
	// are to be also automatically published to the catalog.
	PublishOnImport *bool `locationName:"publishOnImport" type:"boolean"`

	// Specifies whether the business name generation is to be enabled for this
	// data source.
	Recommendation *RecommendationConfiguration `locationName:"recommendation" type:"structure"`

	// The schedule of the data source runs.
	//
	// Schedule is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateDataSourceOutput's
	// String and GoString methods.
	Schedule *ScheduleConfiguration `locationName:"schedule" type:"structure" sensitive:"true"`

	// The status of the data source.
	Status *string `locationName:"status" type:"string" enum:"DataSourceStatus"`

	// The type of the data source.
	Type *string `locationName:"type" min:"1" type:"string"`

	// The timestamp of when the data source was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceOutput) GoString() string {
	return s.String()
}

// SetAssetFormsOutput sets the AssetFormsOutput field's value.
func (s *CreateDataSourceOutput) SetAssetFormsOutput(v []*FormOutput_) *CreateDataSourceOutput {
	s.AssetFormsOutput = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateDataSourceOutput) SetConfiguration(v *DataSourceConfigurationOutput_) *CreateDataSourceOutput {
	s.Configuration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateDataSourceOutput) SetCreatedAt(v time.Time) *CreateDataSourceOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDataSourceOutput) SetDescription(v string) *CreateDataSourceOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateDataSourceOutput) SetDomainId(v string) *CreateDataSourceOutput {
	s.DomainId = &v
	return s
}

// SetEnableSetting sets the EnableSetting field's value.
func (s *CreateDataSourceOutput) SetEnableSetting(v string) *CreateDataSourceOutput {
	s.EnableSetting = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateDataSourceOutput) SetEnvironmentId(v string) *CreateDataSourceOutput {
	s.EnvironmentId = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *CreateDataSourceOutput) SetErrorMessage(v *DataSourceErrorMessage) *CreateDataSourceOutput {
	s.ErrorMessage = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateDataSourceOutput) SetId(v string) *CreateDataSourceOutput {
	s.Id = &v
	return s
}

// SetLastRunAt sets the LastRunAt field's value.
func (s *CreateDataSourceOutput) SetLastRunAt(v time.Time) *CreateDataSourceOutput {
	s.LastRunAt = &v
	return s
}

// SetLastRunErrorMessage sets the LastRunErrorMessage field's value.
func (s *CreateDataSourceOutput) SetLastRunErrorMessage(v *DataSourceErrorMessage) *CreateDataSourceOutput {
	s.LastRunErrorMessage = v
	return s
}

// SetLastRunStatus sets the LastRunStatus field's value.
func (s *CreateDataSourceOutput) SetLastRunStatus(v string) *CreateDataSourceOutput {
	s.LastRunStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSourceOutput) SetName(v string) *CreateDataSourceOutput {
	s.Name = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *CreateDataSourceOutput) SetProjectId(v string) *CreateDataSourceOutput {
	s.ProjectId = &v
	return s
}

// SetPublishOnImport sets the PublishOnImport field's value.
func (s *CreateDataSourceOutput) SetPublishOnImport(v bool) *CreateDataSourceOutput {
	s.PublishOnImport = &v
	return s
}

// SetRecommendation sets the Recommendation field's value.
func (s *CreateDataSourceOutput) SetRecommendation(v *RecommendationConfiguration) *CreateDataSourceOutput {
	s.Recommendation = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateDataSourceOutput) SetSchedule(v *ScheduleConfiguration) *CreateDataSourceOutput {
	s.Schedule = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDataSourceOutput) SetStatus(v string) *CreateDataSourceOutput {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateDataSourceOutput) SetType(v string) *CreateDataSourceOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateDataSourceOutput) SetUpdatedAt(v time.Time) *CreateDataSourceOutput {
	s.UpdatedAt = &v
	return s
}

type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The description of the Amazon DataZone domain.
	Description *string `locationName:"description" type:"string"`

	// The domain execution role that is created when an Amazon DataZone domain
	// is created. The domain execution role is created in the Amazon Web Services
	// account that houses the Amazon DataZone domain.
	//
	// DomainExecutionRole is a required field
	DomainExecutionRole *string `locationName:"domainExecutionRole" type:"string" required:"true"`

	// The identifier of the Amazon Web Services Key Management Service (KMS) key
	// that is used to encrypt the Amazon DataZone domain, metadata, and reporting
	// data.
	KmsKeyIdentifier *string `locationName:"kmsKeyIdentifier" min:"1" type:"string"`

	// The name of the Amazon DataZone domain.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The single-sign on configuration of the Amazon DataZone domain.
	SingleSignOn *SingleSignOn `locationName:"singleSignOn" type:"structure"`

	// The tags specified for the Amazon DataZone domain.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.DomainExecutionRole == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainExecutionRole"))
	}
	if s.KmsKeyIdentifier != nil && len(*s.KmsKeyIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyIdentifier", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDomainInput) SetClientToken(v string) *CreateDomainInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDomainInput) SetDescription(v string) *CreateDomainInput {
	s.Description = &v
	return s
}

// SetDomainExecutionRole sets the DomainExecutionRole field's value.
func (s *CreateDomainInput) SetDomainExecutionRole(v string) *CreateDomainInput {
	s.DomainExecutionRole = &v
	return s
}

// SetKmsKeyIdentifier sets the KmsKeyIdentifier field's value.
func (s *CreateDomainInput) SetKmsKeyIdentifier(v string) *CreateDomainInput {
	s.KmsKeyIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDomainInput) SetName(v string) *CreateDomainInput {
	s.Name = &v
	return s
}

// SetSingleSignOn sets the SingleSignOn field's value.
func (s *CreateDomainInput) SetSingleSignOn(v *SingleSignOn) *CreateDomainInput {
	s.SingleSignOn = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDomainInput) SetTags(v map[string]*string) *CreateDomainInput {
	s.Tags = v
	return s
}

type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon DataZone domain.
	Arn *string `locationName:"arn" type:"string"`

	// The description of the Amazon DataZone domain.
	Description *string `locationName:"description" type:"string"`

	// The domain execution role that is created when an Amazon DataZone domain
	// is created. The domain execution role is created in the Amazon Web Services
	// account that houses the Amazon DataZone domain.
	DomainExecutionRole *string `locationName:"domainExecutionRole" type:"string"`

	// The identifier of the Amazon DataZone domain.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The identifier of the Amazon Web Services Key Management Service (KMS) key
	// that is used to encrypt the Amazon DataZone domain, metadata, and reporting
	// data.
	KmsKeyIdentifier *string `locationName:"kmsKeyIdentifier" min:"1" type:"string"`

	// The name of the Amazon DataZone domain.
	Name *string `locationName:"name" type:"string"`

	// The URL of the data portal for this Amazon DataZone domain.
	PortalUrl *string `locationName:"portalUrl" type:"string"`

	// The single-sign on configuration of the Amazon DataZone domain.
	SingleSignOn *SingleSignOn `locationName:"singleSignOn" type:"structure"`

	// The status of the Amazon DataZone domain.
	Status *string `locationName:"status" type:"string" enum:"DomainStatus"`

	// The tags specified for the Amazon DataZone domain.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDomainOutput) SetArn(v string) *CreateDomainOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDomainOutput) SetDescription(v string) *CreateDomainOutput {
	s.Description = &v
	return s
}

// SetDomainExecutionRole sets the DomainExecutionRole field's value.
func (s *CreateDomainOutput) SetDomainExecutionRole(v string) *CreateDomainOutput {
	s.DomainExecutionRole = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateDomainOutput) SetId(v string) *CreateDomainOutput {
	s.Id = &v
	return s
}

// SetKmsKeyIdentifier sets the KmsKeyIdentifier field's value.
func (s *CreateDomainOutput) SetKmsKeyIdentifier(v string) *CreateDomainOutput {
	s.KmsKeyIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDomainOutput) SetName(v string) *CreateDomainOutput {
	s.Name = &v
	return s
}

// SetPortalUrl sets the PortalUrl field's value.
func (s *CreateDomainOutput) SetPortalUrl(v string) *CreateDomainOutput {
	s.PortalUrl = &v
	return s
}

// SetSingleSignOn sets the SingleSignOn field's value.
func (s *CreateDomainOutput) SetSingleSignOn(v *SingleSignOn) *CreateDomainOutput {
	s.SingleSignOn = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDomainOutput) SetStatus(v string) *CreateDomainOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDomainOutput) SetTags(v map[string]*string) *CreateDomainOutput {
	s.Tags = v
	return s
}

type CreateEnvironmentActionInput struct {
	_ struct{} `type:"structure"`

	// The description of the environment action that is being created in the environment.
	Description *string `locationName:"description" type:"string"`

	// The ID of the Amazon DataZone domain in which the environment action is created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the environment in which the environment action is created.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"environmentIdentifier" type:"string" required:"true"`

	// The name of the environment action.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The parameters of the environment action.
	//
	// Parameters is a required field
	Parameters *ActionParameters `locationName:"parameters" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentActionInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentActionInput) SetDescription(v string) *CreateEnvironmentActionInput {
	s.Description = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateEnvironmentActionInput) SetDomainIdentifier(v string) *CreateEnvironmentActionInput {
	s.DomainIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *CreateEnvironmentActionInput) SetEnvironmentIdentifier(v string) *CreateEnvironmentActionInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentActionInput) SetName(v string) *CreateEnvironmentActionInput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateEnvironmentActionInput) SetParameters(v *ActionParameters) *CreateEnvironmentActionInput {
	s.Parameters = v
	return s
}

type CreateEnvironmentActionOutput struct {
	_ struct{} `type:"structure"`

	// The description of the environment action.
	Description *string `locationName:"description" type:"string"`

	// The ID of the domain in which the environment action is created.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The ID of the environment in which the environment is created.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// The ID of the environment action.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the environment action.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The parameters of the environment action.
	//
	// Parameters is a required field
	Parameters *ActionParameters `locationName:"parameters" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentActionOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentActionOutput) SetDescription(v string) *CreateEnvironmentActionOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateEnvironmentActionOutput) SetDomainId(v string) *CreateEnvironmentActionOutput {
	s.DomainId = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateEnvironmentActionOutput) SetEnvironmentId(v string) *CreateEnvironmentActionOutput {
	s.EnvironmentId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateEnvironmentActionOutput) SetId(v string) *CreateEnvironmentActionOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentActionOutput) SetName(v string) *CreateEnvironmentActionOutput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateEnvironmentActionOutput) SetParameters(v *ActionParameters) *CreateEnvironmentActionOutput {
	s.Parameters = v
	return s
}

type CreateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The description of the Amazon DataZone environment.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the Amazon DataZone domain in which the environment is
	// created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the account in which the environment is being created.
	EnvironmentAccountIdentifier *string `locationName:"environmentAccountIdentifier" type:"string"`

	// The region of the account in which the environment is being created.
	EnvironmentAccountRegion *string `locationName:"environmentAccountRegion" type:"string"`

	// The ID of the blueprint with which the environment is being created.
	EnvironmentBlueprintIdentifier *string `locationName:"environmentBlueprintIdentifier" type:"string"`

	// The identifier of the environment profile that is used to create this Amazon
	// DataZone environment.
	//
	// EnvironmentProfileIdentifier is a required field
	EnvironmentProfileIdentifier *string `locationName:"environmentProfileIdentifier" type:"string" required:"true"`

	// The glossary terms that can be used in this Amazon DataZone environment.
	GlossaryTerms []*string `locationName:"glossaryTerms" min:"1" type:"list"`

	// The name of the Amazon DataZone environment.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The identifier of the Amazon DataZone project in which this environment is
	// created.
	//
	// ProjectIdentifier is a required field
	ProjectIdentifier *string `locationName:"projectIdentifier" type:"string" required:"true"`

	// The user parameters of this Amazon DataZone environment.
	UserParameters []*EnvironmentParameter `locationName:"userParameters" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EnvironmentProfileIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentProfileIdentifier"))
	}
	if s.GlossaryTerms != nil && len(s.GlossaryTerms) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GlossaryTerms", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentInput) SetDescription(v string) *CreateEnvironmentInput {
	s.Description = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateEnvironmentInput) SetDomainIdentifier(v string) *CreateEnvironmentInput {
	s.DomainIdentifier = &v
	return s
}

// SetEnvironmentAccountIdentifier sets the EnvironmentAccountIdentifier field's value.
func (s *CreateEnvironmentInput) SetEnvironmentAccountIdentifier(v string) *CreateEnvironmentInput {
	s.EnvironmentAccountIdentifier = &v
	return s
}

// SetEnvironmentAccountRegion sets the EnvironmentAccountRegion field's value.
func (s *CreateEnvironmentInput) SetEnvironmentAccountRegion(v string) *CreateEnvironmentInput {
	s.EnvironmentAccountRegion = &v
	return s
}

// SetEnvironmentBlueprintIdentifier sets the EnvironmentBlueprintIdentifier field's value.
func (s *CreateEnvironmentInput) SetEnvironmentBlueprintIdentifier(v string) *CreateEnvironmentInput {
	s.EnvironmentBlueprintIdentifier = &v
	return s
}

// SetEnvironmentProfileIdentifier sets the EnvironmentProfileIdentifier field's value.
func (s *CreateEnvironmentInput) SetEnvironmentProfileIdentifier(v string) *CreateEnvironmentInput {
	s.EnvironmentProfileIdentifier = &v
	return s
}

// SetGlossaryTerms sets the GlossaryTerms field's value.
func (s *CreateEnvironmentInput) SetGlossaryTerms(v []*string) *CreateEnvironmentInput {
	s.GlossaryTerms = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentInput) SetName(v string) *CreateEnvironmentInput {
	s.Name = &v
	return s
}

// SetProjectIdentifier sets the ProjectIdentifier field's value.
func (s *CreateEnvironmentInput) SetProjectIdentifier(v string) *CreateEnvironmentInput {
	s.ProjectIdentifier = &v
	return s
}

// SetUserParameters sets the UserParameters field's value.
func (s *CreateEnvironmentInput) SetUserParameters(v []*EnvironmentParameter) *CreateEnvironmentInput {
	s.UserParameters = v
	return s
}

type CreateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account in which the Amazon DataZone environment
	// is created.
	AwsAccountId *string `locationName:"awsAccountId" type:"string"`

	// The Amazon Web Services region in which the Amazon DataZone environment is
	// created.
	AwsAccountRegion *string `locationName:"awsAccountRegion" type:"string"`

	// The timestamp of when the environment was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon DataZone user who created this environment.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The deployment properties of this Amazon DataZone environment.
	DeploymentProperties *DeploymentProperties `locationName:"deploymentProperties" type:"structure"`

	// The description of this Amazon DataZone environment.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The identifier of the Amazon DataZone domain in which the environment is
	// created.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The configurable actions of this Amazon DataZone environment.
	EnvironmentActions []*ConfigurableEnvironmentAction `locationName:"environmentActions" type:"list"`

	// The ID of the blueprint with which this Amazon DataZone environment was created.
	EnvironmentBlueprintId *string `locationName:"environmentBlueprintId" type:"string"`

	// The ID of the environment profile with which this Amazon DataZone environment
	// was created.
	EnvironmentProfileId *string `locationName:"environmentProfileId" type:"string"`

	// The glossary terms that can be used in this Amazon DataZone environment.
	GlossaryTerms []*string `locationName:"glossaryTerms" min:"1" type:"list"`

	// The ID of this Amazon DataZone environment.
	Id *string `locationName:"id" type:"string"`

	// The details of the last deployment of this Amazon DataZone environment.
	LastDeployment *Deployment `locationName:"lastDeployment" type:"structure"`

	// The name of this environment.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The ID of the Amazon DataZone project in which this environment is created.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" type:"string" required:"true"`

	// The provider of this Amazon DataZone environment.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true"`

	// The provisioned resources of this Amazon DataZone environment.
	ProvisionedResources []*Resource `locationName:"provisionedResources" type:"list"`

	// The provisioning properties of this Amazon DataZone environment.
	ProvisioningProperties *ProvisioningProperties `locationName:"provisioningProperties" type:"structure"`

	// The status of this Amazon DataZone environment.
	Status *string `locationName:"status" type:"string" enum:"EnvironmentStatus"`

	// The timestamp of when this environment was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user parameters of this Amazon DataZone environment.
	UserParameters []*CustomParameter `locationName:"userParameters" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentOutput) GoString() string {
	return s.String()
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateEnvironmentOutput) SetAwsAccountId(v string) *CreateEnvironmentOutput {
	s.AwsAccountId = &v
	return s
}

// SetAwsAccountRegion sets the AwsAccountRegion field's value.
func (s *CreateEnvironmentOutput) SetAwsAccountRegion(v string) *CreateEnvironmentOutput {
	s.AwsAccountRegion = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateEnvironmentOutput) SetCreatedAt(v time.Time) *CreateEnvironmentOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CreateEnvironmentOutput) SetCreatedBy(v string) *CreateEnvironmentOutput {
	s.CreatedBy = &v
	return s
}

// SetDeploymentProperties sets the DeploymentProperties field's value.
func (s *CreateEnvironmentOutput) SetDeploymentProperties(v *DeploymentProperties) *CreateEnvironmentOutput {
	s.DeploymentProperties = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentOutput) SetDescription(v string) *CreateEnvironmentOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateEnvironmentOutput) SetDomainId(v string) *CreateEnvironmentOutput {
	s.DomainId = &v
	return s
}

// SetEnvironmentActions sets the EnvironmentActions field's value.
func (s *CreateEnvironmentOutput) SetEnvironmentActions(v []*ConfigurableEnvironmentAction) *CreateEnvironmentOutput {
	s.EnvironmentActions = v
	return s
}

// SetEnvironmentBlueprintId sets the EnvironmentBlueprintId field's value.
func (s *CreateEnvironmentOutput) SetEnvironmentBlueprintId(v string) *CreateEnvironmentOutput {
	s.EnvironmentBlueprintId = &v
	return s
}

// SetEnvironmentProfileId sets the EnvironmentProfileId field's value.
func (s *CreateEnvironmentOutput) SetEnvironmentProfileId(v string) *CreateEnvironmentOutput {
	s.EnvironmentProfileId = &v
	return s
}

// SetGlossaryTerms sets the GlossaryTerms field's value.
func (s *CreateEnvironmentOutput) SetGlossaryTerms(v []*string) *CreateEnvironmentOutput {
	s.GlossaryTerms = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateEnvironmentOutput) SetId(v string) *CreateEnvironmentOutput {
	s.Id = &v
	return s
}

// SetLastDeployment sets the LastDeployment field's value.
func (s *CreateEnvironmentOutput) SetLastDeployment(v *Deployment) *CreateEnvironmentOutput {
	s.LastDeployment = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentOutput) SetName(v string) *CreateEnvironmentOutput {
	s.Name = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *CreateEnvironmentOutput) SetProjectId(v string) *CreateEnvironmentOutput {
	s.ProjectId = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *CreateEnvironmentOutput) SetProvider(v string) *CreateEnvironmentOutput {
	s.Provider = &v
	return s
}

// SetProvisionedResources sets the ProvisionedResources field's value.
func (s *CreateEnvironmentOutput) SetProvisionedResources(v []*Resource) *CreateEnvironmentOutput {
	s.ProvisionedResources = v
	return s
}

// SetProvisioningProperties sets the ProvisioningProperties field's value.
func (s *CreateEnvironmentOutput) SetProvisioningProperties(v *ProvisioningProperties) *CreateEnvironmentOutput {
	s.ProvisioningProperties = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateEnvironmentOutput) SetStatus(v string) *CreateEnvironmentOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateEnvironmentOutput) SetUpdatedAt(v time.Time) *CreateEnvironmentOutput {
	s.UpdatedAt = &v
	return s
}

// SetUserParameters sets the UserParameters field's value.
func (s *CreateEnvironmentOutput) SetUserParameters(v []*CustomParameter) *CreateEnvironmentOutput {
	s.UserParameters = v
	return s
}

type CreateEnvironmentProfileInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account in which the Amazon DataZone environment
	// is created.
	AwsAccountId *string `locationName:"awsAccountId" type:"string"`

	// The Amazon Web Services region in which this environment profile is created.
	AwsAccountRegion *string `locationName:"awsAccountRegion" type:"string"`

	// The description of this Amazon DataZone environment profile.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentProfileInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain in which this environment profile is
	// created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the blueprint with which this environment profile is created.
	//
	// EnvironmentBlueprintIdentifier is a required field
	EnvironmentBlueprintIdentifier *string `locationName:"environmentBlueprintIdentifier" type:"string" required:"true"`

	// The name of this Amazon DataZone environment profile.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentProfileInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The identifier of the project in which to create the environment profile.
	//
	// ProjectIdentifier is a required field
	ProjectIdentifier *string `locationName:"projectIdentifier" type:"string" required:"true"`

	// The user parameters of this Amazon DataZone environment profile.
	UserParameters []*EnvironmentParameter `locationName:"userParameters" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentProfileInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EnvironmentBlueprintIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentBlueprintIdentifier"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateEnvironmentProfileInput) SetAwsAccountId(v string) *CreateEnvironmentProfileInput {
	s.AwsAccountId = &v
	return s
}

// SetAwsAccountRegion sets the AwsAccountRegion field's value.
func (s *CreateEnvironmentProfileInput) SetAwsAccountRegion(v string) *CreateEnvironmentProfileInput {
	s.AwsAccountRegion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentProfileInput) SetDescription(v string) *CreateEnvironmentProfileInput {
	s.Description = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateEnvironmentProfileInput) SetDomainIdentifier(v string) *CreateEnvironmentProfileInput {
	s.DomainIdentifier = &v
	return s
}

// SetEnvironmentBlueprintIdentifier sets the EnvironmentBlueprintIdentifier field's value.
func (s *CreateEnvironmentProfileInput) SetEnvironmentBlueprintIdentifier(v string) *CreateEnvironmentProfileInput {
	s.EnvironmentBlueprintIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentProfileInput) SetName(v string) *CreateEnvironmentProfileInput {
	s.Name = &v
	return s
}

// SetProjectIdentifier sets the ProjectIdentifier field's value.
func (s *CreateEnvironmentProfileInput) SetProjectIdentifier(v string) *CreateEnvironmentProfileInput {
	s.ProjectIdentifier = &v
	return s
}

// SetUserParameters sets the UserParameters field's value.
func (s *CreateEnvironmentProfileInput) SetUserParameters(v []*EnvironmentParameter) *CreateEnvironmentProfileInput {
	s.UserParameters = v
	return s
}

type CreateEnvironmentProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID in which this Amazon DataZone environment
	// profile is created.
	AwsAccountId *string `locationName:"awsAccountId" type:"string"`

	// The Amazon Web Services region in which this Amazon DataZone environment
	// profile is created.
	AwsAccountRegion *string `locationName:"awsAccountRegion" type:"string"`

	// The timestamp of when this environment profile was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon DataZone user who created this environment profile.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The description of this Amazon DataZone environment profile.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentProfileOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain in which this environment profile is
	// created.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The ID of the blueprint with which this environment profile is created.
	//
	// EnvironmentBlueprintId is a required field
	EnvironmentBlueprintId *string `locationName:"environmentBlueprintId" type:"string" required:"true"`

	// The ID of this Amazon DataZone environment profile.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of this Amazon DataZone environment profile.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentProfileOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The ID of the Amazon DataZone project in which this environment profile is
	// created.
	ProjectId *string `locationName:"projectId" type:"string"`

	// The timestamp of when this environment profile was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user parameters of this Amazon DataZone environment profile.
	UserParameters []*CustomParameter `locationName:"userParameters" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentProfileOutput) GoString() string {
	return s.String()
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *CreateEnvironmentProfileOutput) SetAwsAccountId(v string) *CreateEnvironmentProfileOutput {
	s.AwsAccountId = &v
	return s
}

// SetAwsAccountRegion sets the AwsAccountRegion field's value.
func (s *CreateEnvironmentProfileOutput) SetAwsAccountRegion(v string) *CreateEnvironmentProfileOutput {
	s.AwsAccountRegion = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateEnvironmentProfileOutput) SetCreatedAt(v time.Time) *CreateEnvironmentProfileOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CreateEnvironmentProfileOutput) SetCreatedBy(v string) *CreateEnvironmentProfileOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentProfileOutput) SetDescription(v string) *CreateEnvironmentProfileOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateEnvironmentProfileOutput) SetDomainId(v string) *CreateEnvironmentProfileOutput {
	s.DomainId = &v
	return s
}

// SetEnvironmentBlueprintId sets the EnvironmentBlueprintId field's value.
func (s *CreateEnvironmentProfileOutput) SetEnvironmentBlueprintId(v string) *CreateEnvironmentProfileOutput {
	s.EnvironmentBlueprintId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateEnvironmentProfileOutput) SetId(v string) *CreateEnvironmentProfileOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentProfileOutput) SetName(v string) *CreateEnvironmentProfileOutput {
	s.Name = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *CreateEnvironmentProfileOutput) SetProjectId(v string) *CreateEnvironmentProfileOutput {
	s.ProjectId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateEnvironmentProfileOutput) SetUpdatedAt(v time.Time) *CreateEnvironmentProfileOutput {
	s.UpdatedAt = &v
	return s
}

// SetUserParameters sets the UserParameters field's value.
func (s *CreateEnvironmentProfileOutput) SetUserParameters(v []*CustomParameter) *CreateEnvironmentProfileOutput {
	s.UserParameters = v
	return s
}

type CreateFormTypeInput struct {
	_ struct{} `type:"structure"`

	// The description of this Amazon DataZone metadata form type.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateFormTypeInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain in which this metadata form type is
	// created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The model of this Amazon DataZone metadata form type.
	//
	// Model is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateFormTypeInput's
	// String and GoString methods.
	//
	// Model is a required field
	Model *Model `locationName:"model" type:"structure" required:"true" sensitive:"true"`

	// The name of this Amazon DataZone metadata form type.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateFormTypeInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The ID of the Amazon DataZone project that owns this metadata form type.
	//
	// OwningProjectIdentifier is a required field
	OwningProjectIdentifier *string `locationName:"owningProjectIdentifier" type:"string" required:"true"`

	// The status of this Amazon DataZone metadata form type.
	Status *string `locationName:"status" type:"string" enum:"FormTypeStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFormTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFormTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFormTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFormTypeInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Model == nil {
		invalidParams.Add(request.NewErrParamRequired("Model"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OwningProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("OwningProjectIdentifier"))
	}
	if s.Model != nil {
		if err := s.Model.Validate(); err != nil {
			invalidParams.AddNested("Model", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateFormTypeInput) SetDescription(v string) *CreateFormTypeInput {
	s.Description = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateFormTypeInput) SetDomainIdentifier(v string) *CreateFormTypeInput {
	s.DomainIdentifier = &v
	return s
}

// SetModel sets the Model field's value.
func (s *CreateFormTypeInput) SetModel(v *Model) *CreateFormTypeInput {
	s.Model = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFormTypeInput) SetName(v string) *CreateFormTypeInput {
	s.Name = &v
	return s
}

// SetOwningProjectIdentifier sets the OwningProjectIdentifier field's value.
func (s *CreateFormTypeInput) SetOwningProjectIdentifier(v string) *CreateFormTypeInput {
	s.OwningProjectIdentifier = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateFormTypeInput) SetStatus(v string) *CreateFormTypeInput {
	s.Status = &v
	return s
}

type CreateFormTypeOutput struct {
	_ struct{} `type:"structure"`

	// The description of this Amazon DataZone metadata form type.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateFormTypeOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain in which this metadata form type is
	// created.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The name of this Amazon DataZone metadata form type.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateFormTypeOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The ID of the Amazon DataZone domain in which this metadata form type was
	// originally created.
	OriginDomainId *string `locationName:"originDomainId" type:"string"`

	// The ID of the project in which this Amazon DataZone metadata form type was
	// originally created.
	OriginProjectId *string `locationName:"originProjectId" type:"string"`

	// The ID of the project that owns this Amazon DataZone metadata form type.
	OwningProjectId *string `locationName:"owningProjectId" type:"string"`

	// The revision of this Amazon DataZone metadata form type.
	//
	// Revision is a required field
	Revision *string `locationName:"revision" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFormTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFormTypeOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateFormTypeOutput) SetDescription(v string) *CreateFormTypeOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateFormTypeOutput) SetDomainId(v string) *CreateFormTypeOutput {
	s.DomainId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFormTypeOutput) SetName(v string) *CreateFormTypeOutput {
	s.Name = &v
	return s
}

// SetOriginDomainId sets the OriginDomainId field's value.
func (s *CreateFormTypeOutput) SetOriginDomainId(v string) *CreateFormTypeOutput {
	s.OriginDomainId = &v
	return s
}

// SetOriginProjectId sets the OriginProjectId field's value.
func (s *CreateFormTypeOutput) SetOriginProjectId(v string) *CreateFormTypeOutput {
	s.OriginProjectId = &v
	return s
}

// SetOwningProjectId sets the OwningProjectId field's value.
func (s *CreateFormTypeOutput) SetOwningProjectId(v string) *CreateFormTypeOutput {
	s.OwningProjectId = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *CreateFormTypeOutput) SetRevision(v string) *CreateFormTypeOutput {
	s.Revision = &v
	return s
}

type CreateGlossaryInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The description of this business glossary.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGlossaryInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain in which this business glossary is created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The name of this business glossary.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGlossaryInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The ID of the project that currently owns business glossary.
	//
	// OwningProjectIdentifier is a required field
	OwningProjectIdentifier *string `locationName:"owningProjectIdentifier" type:"string" required:"true"`

	// The status of this business glossary.
	Status *string `locationName:"status" type:"string" enum:"GlossaryStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGlossaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGlossaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGlossaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGlossaryInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OwningProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("OwningProjectIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateGlossaryInput) SetClientToken(v string) *CreateGlossaryInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateGlossaryInput) SetDescription(v string) *CreateGlossaryInput {
	s.Description = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateGlossaryInput) SetDomainIdentifier(v string) *CreateGlossaryInput {
	s.DomainIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGlossaryInput) SetName(v string) *CreateGlossaryInput {
	s.Name = &v
	return s
}

// SetOwningProjectIdentifier sets the OwningProjectIdentifier field's value.
func (s *CreateGlossaryInput) SetOwningProjectIdentifier(v string) *CreateGlossaryInput {
	s.OwningProjectIdentifier = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateGlossaryInput) SetStatus(v string) *CreateGlossaryInput {
	s.Status = &v
	return s
}

type CreateGlossaryOutput struct {
	_ struct{} `type:"structure"`

	// The description of this business glossary.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGlossaryOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain in which this business glossary is created.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The ID of this business glossary.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of this business glossary.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGlossaryOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The ID of the project that currently owns this business glossary.
	//
	// OwningProjectId is a required field
	OwningProjectId *string `locationName:"owningProjectId" type:"string" required:"true"`

	// The status of this business glossary.
	Status *string `locationName:"status" type:"string" enum:"GlossaryStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGlossaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGlossaryOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateGlossaryOutput) SetDescription(v string) *CreateGlossaryOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateGlossaryOutput) SetDomainId(v string) *CreateGlossaryOutput {
	s.DomainId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateGlossaryOutput) SetId(v string) *CreateGlossaryOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGlossaryOutput) SetName(v string) *CreateGlossaryOutput {
	s.Name = &v
	return s
}

// SetOwningProjectId sets the OwningProjectId field's value.
func (s *CreateGlossaryOutput) SetOwningProjectId(v string) *CreateGlossaryOutput {
	s.OwningProjectId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateGlossaryOutput) SetStatus(v string) *CreateGlossaryOutput {
	s.Status = &v
	return s
}

type CreateGlossaryTermInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the Amazon DataZone domain in which this business glossary term
	// is created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the business glossary in which this term is created.
	//
	// GlossaryIdentifier is a required field
	GlossaryIdentifier *string `locationName:"glossaryIdentifier" type:"string" required:"true"`

	// The long description of this business glossary term.
	//
	// LongDescription is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGlossaryTermInput's
	// String and GoString methods.
	LongDescription *string `locationName:"longDescription" type:"string" sensitive:"true"`

	// The name of this business glossary term.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGlossaryTermInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The short description of this business glossary term.
	//
	// ShortDescription is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGlossaryTermInput's
	// String and GoString methods.
	ShortDescription *string `locationName:"shortDescription" type:"string" sensitive:"true"`

	// The status of this business glossary term.
	Status *string `locationName:"status" type:"string" enum:"GlossaryTermStatus"`

	// The term relations of this business glossary term.
	TermRelations *TermRelations `locationName:"termRelations" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGlossaryTermInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGlossaryTermInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGlossaryTermInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGlossaryTermInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.GlossaryIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GlossaryIdentifier"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TermRelations != nil {
		if err := s.TermRelations.Validate(); err != nil {
			invalidParams.AddNested("TermRelations", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateGlossaryTermInput) SetClientToken(v string) *CreateGlossaryTermInput {
	s.ClientToken = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateGlossaryTermInput) SetDomainIdentifier(v string) *CreateGlossaryTermInput {
	s.DomainIdentifier = &v
	return s
}

// SetGlossaryIdentifier sets the GlossaryIdentifier field's value.
func (s *CreateGlossaryTermInput) SetGlossaryIdentifier(v string) *CreateGlossaryTermInput {
	s.GlossaryIdentifier = &v
	return s
}

// SetLongDescription sets the LongDescription field's value.
func (s *CreateGlossaryTermInput) SetLongDescription(v string) *CreateGlossaryTermInput {
	s.LongDescription = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGlossaryTermInput) SetName(v string) *CreateGlossaryTermInput {
	s.Name = &v
	return s
}

// SetShortDescription sets the ShortDescription field's value.
func (s *CreateGlossaryTermInput) SetShortDescription(v string) *CreateGlossaryTermInput {
	s.ShortDescription = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateGlossaryTermInput) SetStatus(v string) *CreateGlossaryTermInput {
	s.Status = &v
	return s
}

// SetTermRelations sets the TermRelations field's value.
func (s *CreateGlossaryTermInput) SetTermRelations(v *TermRelations) *CreateGlossaryTermInput {
	s.TermRelations = v
	return s
}

type CreateGlossaryTermOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon DataZone domain in which this business glossary term
	// is created.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The ID of the business glossary in which this term is created.
	//
	// GlossaryId is a required field
	GlossaryId *string `locationName:"glossaryId" type:"string" required:"true"`

	// The ID of this business glossary term.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The long description of this business glossary term.
	//
	// LongDescription is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGlossaryTermOutput's
	// String and GoString methods.
	LongDescription *string `locationName:"longDescription" type:"string" sensitive:"true"`

	// The name of this business glossary term.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGlossaryTermOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The short description of this business glossary term.
	//
	// ShortDescription is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGlossaryTermOutput's
	// String and GoString methods.
	ShortDescription *string `locationName:"shortDescription" type:"string" sensitive:"true"`

	// The status of this business glossary term.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"GlossaryTermStatus"`

	// The term relations of this business glossary term.
	TermRelations *TermRelations `locationName:"termRelations" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGlossaryTermOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGlossaryTermOutput) GoString() string {
	return s.String()
}

// SetDomainId sets the DomainId field's value.
func (s *CreateGlossaryTermOutput) SetDomainId(v string) *CreateGlossaryTermOutput {
	s.DomainId = &v
	return s
}

// SetGlossaryId sets the GlossaryId field's value.
func (s *CreateGlossaryTermOutput) SetGlossaryId(v string) *CreateGlossaryTermOutput {
	s.GlossaryId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateGlossaryTermOutput) SetId(v string) *CreateGlossaryTermOutput {
	s.Id = &v
	return s
}

// SetLongDescription sets the LongDescription field's value.
func (s *CreateGlossaryTermOutput) SetLongDescription(v string) *CreateGlossaryTermOutput {
	s.LongDescription = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGlossaryTermOutput) SetName(v string) *CreateGlossaryTermOutput {
	s.Name = &v
	return s
}

// SetShortDescription sets the ShortDescription field's value.
func (s *CreateGlossaryTermOutput) SetShortDescription(v string) *CreateGlossaryTermOutput {
	s.ShortDescription = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateGlossaryTermOutput) SetStatus(v string) *CreateGlossaryTermOutput {
	s.Status = &v
	return s
}

// SetTermRelations sets the TermRelations field's value.
func (s *CreateGlossaryTermOutput) SetTermRelations(v *TermRelations) *CreateGlossaryTermOutput {
	s.TermRelations = v
	return s
}

type CreateGroupProfileInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The identifier of the Amazon DataZone domain in which the group profile is
	// created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The identifier of the group for which the group profile is created.
	//
	// GroupIdentifier is a required field
	GroupIdentifier *string `locationName:"groupIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupProfileInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.GroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateGroupProfileInput) SetClientToken(v string) *CreateGroupProfileInput {
	s.ClientToken = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateGroupProfileInput) SetDomainIdentifier(v string) *CreateGroupProfileInput {
	s.DomainIdentifier = &v
	return s
}

// SetGroupIdentifier sets the GroupIdentifier field's value.
func (s *CreateGroupProfileInput) SetGroupIdentifier(v string) *CreateGroupProfileInput {
	s.GroupIdentifier = &v
	return s
}

type CreateGroupProfileOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon DataZone domain in which the group profile is
	// created.
	DomainId *string `locationName:"domainId" type:"string"`

	// The name of the group for which group profile is created.
	//
	// GroupName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateGroupProfileOutput's
	// String and GoString methods.
	GroupName *string `locationName:"groupName" min:"1" type:"string" sensitive:"true"`

	// The identifier of the group profile.
	Id *string `locationName:"id" type:"string"`

	// The status of the group profile.
	Status *string `locationName:"status" type:"string" enum:"GroupProfileStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGroupProfileOutput) GoString() string {
	return s.String()
}

// SetDomainId sets the DomainId field's value.
func (s *CreateGroupProfileOutput) SetDomainId(v string) *CreateGroupProfileOutput {
	s.DomainId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupProfileOutput) SetGroupName(v string) *CreateGroupProfileOutput {
	s.GroupName = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateGroupProfileOutput) SetId(v string) *CreateGroupProfileOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateGroupProfileOutput) SetStatus(v string) *CreateGroupProfileOutput {
	s.Status = &v
	return s
}

type CreateListingChangeSetInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to publish or unpublish a listing.
	//
	// Action is a required field
	Action *string `locationName:"action" type:"string" required:"true" enum:"ChangeAction"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the Amazon DataZone domain.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the asset.
	//
	// EntityIdentifier is a required field
	EntityIdentifier *string `locationName:"entityIdentifier" type:"string" required:"true"`

	// The revision of an asset.
	EntityRevision *string `locationName:"entityRevision" min:"1" type:"string"`

	// The type of an entity.
	//
	// EntityType is a required field
	EntityType *string `locationName:"entityType" type:"string" required:"true" enum:"EntityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListingChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListingChangeSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateListingChangeSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateListingChangeSetInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EntityIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityIdentifier"))
	}
	if s.EntityRevision != nil && len(*s.EntityRevision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityRevision", 1))
	}
	if s.EntityType == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *CreateListingChangeSetInput) SetAction(v string) *CreateListingChangeSetInput {
	s.Action = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateListingChangeSetInput) SetClientToken(v string) *CreateListingChangeSetInput {
	s.ClientToken = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateListingChangeSetInput) SetDomainIdentifier(v string) *CreateListingChangeSetInput {
	s.DomainIdentifier = &v
	return s
}

// SetEntityIdentifier sets the EntityIdentifier field's value.
func (s *CreateListingChangeSetInput) SetEntityIdentifier(v string) *CreateListingChangeSetInput {
	s.EntityIdentifier = &v
	return s
}

// SetEntityRevision sets the EntityRevision field's value.
func (s *CreateListingChangeSetInput) SetEntityRevision(v string) *CreateListingChangeSetInput {
	s.EntityRevision = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *CreateListingChangeSetInput) SetEntityType(v string) *CreateListingChangeSetInput {
	s.EntityType = &v
	return s
}

type CreateListingChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the listing (a record of an asset at a given time).
	//
	// ListingId is a required field
	ListingId *string `locationName:"listingId" type:"string" required:"true"`

	// The revision of a listing.
	//
	// ListingRevision is a required field
	ListingRevision *string `locationName:"listingRevision" min:"1" type:"string" required:"true"`

	// Specifies the status of the listing.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ListingStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListingChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateListingChangeSetOutput) GoString() string {
	return s.String()
}

// SetListingId sets the ListingId field's value.
func (s *CreateListingChangeSetOutput) SetListingId(v string) *CreateListingChangeSetOutput {
	s.ListingId = &v
	return s
}

// SetListingRevision sets the ListingRevision field's value.
func (s *CreateListingChangeSetOutput) SetListingRevision(v string) *CreateListingChangeSetOutput {
	s.ListingRevision = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateListingChangeSetOutput) SetStatus(v string) *CreateListingChangeSetOutput {
	s.Status = &v
	return s
}

type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// The description of the Amazon DataZone project.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateProjectInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain in which this project is created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The glossary terms that can be used in this Amazon DataZone project.
	GlossaryTerms []*string `locationName:"glossaryTerms" min:"1" type:"list"`

	// The name of the Amazon DataZone project.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateProjectInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.GlossaryTerms != nil && len(s.GlossaryTerms) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GlossaryTerms", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateProjectInput) SetDescription(v string) *CreateProjectInput {
	s.Description = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateProjectInput) SetDomainIdentifier(v string) *CreateProjectInput {
	s.DomainIdentifier = &v
	return s
}

// SetGlossaryTerms sets the GlossaryTerms field's value.
func (s *CreateProjectInput) SetGlossaryTerms(v []*string) *CreateProjectInput {
	s.GlossaryTerms = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProjectInput) SetName(v string) *CreateProjectInput {
	s.Name = &v
	return s
}

type CreateProjectMembershipInput struct {
	_ struct{} `type:"structure"`

	// The designation of the project membership.
	//
	// Designation is a required field
	Designation *string `locationName:"designation" type:"string" required:"true" enum:"UserDesignation"`

	// The ID of the Amazon DataZone domain in which project membership is created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The project member whose project membership was created.
	//
	// Member is a required field
	Member *Member `locationName:"member" type:"structure" required:"true"`

	// The ID of the project for which this project membership was created.
	//
	// ProjectIdentifier is a required field
	ProjectIdentifier *string `location:"uri" locationName:"projectIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectMembershipInput"}
	if s.Designation == nil {
		invalidParams.Add(request.NewErrParamRequired("Designation"))
	}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Member == nil {
		invalidParams.Add(request.NewErrParamRequired("Member"))
	}
	if s.ProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectIdentifier"))
	}
	if s.ProjectIdentifier != nil && len(*s.ProjectIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesignation sets the Designation field's value.
func (s *CreateProjectMembershipInput) SetDesignation(v string) *CreateProjectMembershipInput {
	s.Designation = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateProjectMembershipInput) SetDomainIdentifier(v string) *CreateProjectMembershipInput {
	s.DomainIdentifier = &v
	return s
}

// SetMember sets the Member field's value.
func (s *CreateProjectMembershipInput) SetMember(v *Member) *CreateProjectMembershipInput {
	s.Member = v
	return s
}

// SetProjectIdentifier sets the ProjectIdentifier field's value.
func (s *CreateProjectMembershipInput) SetProjectIdentifier(v string) *CreateProjectMembershipInput {
	s.ProjectIdentifier = &v
	return s
}

type CreateProjectMembershipOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectMembershipOutput) GoString() string {
	return s.String()
}

type CreateProjectOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the project was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon DataZone user who created the project.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The description of the project.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateProjectOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The identifier of the Amazon DataZone domain in which the project was created.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// Specifies the error message that is returned if the operation cannot be successfully
	// completed.
	FailureReasons []*ProjectDeletionError `locationName:"failureReasons" type:"list"`

	// The glossary terms that can be used in the project.
	GlossaryTerms []*string `locationName:"glossaryTerms" min:"1" type:"list"`

	// The ID of the Amazon DataZone project.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The timestamp of when the project was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the project.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateProjectOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The status of the Amazon DataZone project that was created.
	ProjectStatus *string `locationName:"projectStatus" type:"string" enum:"ProjectStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateProjectOutput) SetCreatedAt(v time.Time) *CreateProjectOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CreateProjectOutput) SetCreatedBy(v string) *CreateProjectOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateProjectOutput) SetDescription(v string) *CreateProjectOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateProjectOutput) SetDomainId(v string) *CreateProjectOutput {
	s.DomainId = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *CreateProjectOutput) SetFailureReasons(v []*ProjectDeletionError) *CreateProjectOutput {
	s.FailureReasons = v
	return s
}

// SetGlossaryTerms sets the GlossaryTerms field's value.
func (s *CreateProjectOutput) SetGlossaryTerms(v []*string) *CreateProjectOutput {
	s.GlossaryTerms = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateProjectOutput) SetId(v string) *CreateProjectOutput {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *CreateProjectOutput) SetLastUpdatedAt(v time.Time) *CreateProjectOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProjectOutput) SetName(v string) *CreateProjectOutput {
	s.Name = &v
	return s
}

// SetProjectStatus sets the ProjectStatus field's value.
func (s *CreateProjectOutput) SetProjectStatus(v string) *CreateProjectOutput {
	s.ProjectStatus = &v
	return s
}

type CreateSubscriptionGrantInput struct {
	_ struct{} `type:"structure"`

	// The names of the assets for which the subscription grant is created.
	AssetTargetNames []*AssetTargetNameMap `locationName:"assetTargetNames" type:"list"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The ID of the Amazon DataZone domain in which the subscription grant is created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the environment in which the subscription grant is created.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `locationName:"environmentIdentifier" type:"string" required:"true"`

	// The entity to which the subscription is to be granted.
	//
	// GrantedEntity is a required field
	GrantedEntity *GrantedEntityInput_ `locationName:"grantedEntity" type:"structure" required:"true"`

	// The ID of the subscription target for which the subscription grant is created.
	//
	// SubscriptionTargetIdentifier is a required field
	SubscriptionTargetIdentifier *string `locationName:"subscriptionTargetIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubscriptionGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubscriptionGrantInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.GrantedEntity == nil {
		invalidParams.Add(request.NewErrParamRequired("GrantedEntity"))
	}
	if s.SubscriptionTargetIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionTargetIdentifier"))
	}
	if s.AssetTargetNames != nil {
		for i, v := range s.AssetTargetNames {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AssetTargetNames", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.GrantedEntity != nil {
		if err := s.GrantedEntity.Validate(); err != nil {
			invalidParams.AddNested("GrantedEntity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetTargetNames sets the AssetTargetNames field's value.
func (s *CreateSubscriptionGrantInput) SetAssetTargetNames(v []*AssetTargetNameMap) *CreateSubscriptionGrantInput {
	s.AssetTargetNames = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateSubscriptionGrantInput) SetClientToken(v string) *CreateSubscriptionGrantInput {
	s.ClientToken = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateSubscriptionGrantInput) SetDomainIdentifier(v string) *CreateSubscriptionGrantInput {
	s.DomainIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *CreateSubscriptionGrantInput) SetEnvironmentIdentifier(v string) *CreateSubscriptionGrantInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetGrantedEntity sets the GrantedEntity field's value.
func (s *CreateSubscriptionGrantInput) SetGrantedEntity(v *GrantedEntityInput_) *CreateSubscriptionGrantInput {
	s.GrantedEntity = v
	return s
}

// SetSubscriptionTargetIdentifier sets the SubscriptionTargetIdentifier field's value.
func (s *CreateSubscriptionGrantInput) SetSubscriptionTargetIdentifier(v string) *CreateSubscriptionGrantInput {
	s.SubscriptionTargetIdentifier = &v
	return s
}

type CreateSubscriptionGrantOutput struct {
	_ struct{} `type:"structure"`

	// The assets for which the subscription grant is created.
	Assets []*SubscribedAsset `locationName:"assets" type:"list"`

	// A timestamp of when the subscription grant is created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The Amazon DataZone user who created the subscription grant.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The ID of the Amazon DataZone domain in which the subscription grant is created.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The entity to which the subscription is granted.
	//
	// GrantedEntity is a required field
	GrantedEntity *GrantedEntity `locationName:"grantedEntity" type:"structure" required:"true"`

	// The ID of the subscription grant.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The status of the subscription grant.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"SubscriptionGrantOverallStatus"`

	// The identifier of the subscription grant.
	SubscriptionId *string `locationName:"subscriptionId" type:"string"`

	// The ID of the subscription target for which the subscription grant is created.
	//
	// SubscriptionTargetId is a required field
	SubscriptionTargetId *string `locationName:"subscriptionTargetId" type:"string" required:"true"`

	// A timestamp of when the subscription grant was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// The Amazon DataZone user who updated the subscription grant.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionGrantOutput) GoString() string {
	return s.String()
}

// SetAssets sets the Assets field's value.
func (s *CreateSubscriptionGrantOutput) SetAssets(v []*SubscribedAsset) *CreateSubscriptionGrantOutput {
	s.Assets = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateSubscriptionGrantOutput) SetCreatedAt(v time.Time) *CreateSubscriptionGrantOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CreateSubscriptionGrantOutput) SetCreatedBy(v string) *CreateSubscriptionGrantOutput {
	s.CreatedBy = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateSubscriptionGrantOutput) SetDomainId(v string) *CreateSubscriptionGrantOutput {
	s.DomainId = &v
	return s
}

// SetGrantedEntity sets the GrantedEntity field's value.
func (s *CreateSubscriptionGrantOutput) SetGrantedEntity(v *GrantedEntity) *CreateSubscriptionGrantOutput {
	s.GrantedEntity = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSubscriptionGrantOutput) SetId(v string) *CreateSubscriptionGrantOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateSubscriptionGrantOutput) SetStatus(v string) *CreateSubscriptionGrantOutput {
	s.Status = &v
	return s
}

// SetSubscriptionId sets the SubscriptionId field's value.
func (s *CreateSubscriptionGrantOutput) SetSubscriptionId(v string) *CreateSubscriptionGrantOutput {
	s.SubscriptionId = &v
	return s
}

// SetSubscriptionTargetId sets the SubscriptionTargetId field's value.
func (s *CreateSubscriptionGrantOutput) SetSubscriptionTargetId(v string) *CreateSubscriptionGrantOutput {
	s.SubscriptionTargetId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateSubscriptionGrantOutput) SetUpdatedAt(v time.Time) *CreateSubscriptionGrantOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *CreateSubscriptionGrantOutput) SetUpdatedBy(v string) *CreateSubscriptionGrantOutput {
	s.UpdatedBy = &v
	return s
}

type CreateSubscriptionRequestInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The ID of the Amazon DataZone domain in which the subscription request is
	// created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The reason for the subscription request.
	//
	// RequestReason is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSubscriptionRequestInput's
	// String and GoString methods.
	//
	// RequestReason is a required field
	RequestReason *string `locationName:"requestReason" min:"1" type:"string" required:"true" sensitive:"true"`

	// The published asset for which the subscription grant is to be created.
	//
	// SubscribedListings is a required field
	SubscribedListings []*SubscribedListingInput_ `locationName:"subscribedListings" min:"1" type:"list" required:"true"`

	// The Amazon DataZone principals for whom the subscription request is created.
	//
	// SubscribedPrincipals is a required field
	SubscribedPrincipals []*SubscribedPrincipalInput_ `locationName:"subscribedPrincipals" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionRequestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionRequestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubscriptionRequestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubscriptionRequestInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.RequestReason == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestReason"))
	}
	if s.RequestReason != nil && len(*s.RequestReason) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestReason", 1))
	}
	if s.SubscribedListings == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscribedListings"))
	}
	if s.SubscribedListings != nil && len(s.SubscribedListings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscribedListings", 1))
	}
	if s.SubscribedPrincipals == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscribedPrincipals"))
	}
	if s.SubscribedPrincipals != nil && len(s.SubscribedPrincipals) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubscribedPrincipals", 1))
	}
	if s.SubscribedListings != nil {
		for i, v := range s.SubscribedListings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SubscribedListings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateSubscriptionRequestInput) SetClientToken(v string) *CreateSubscriptionRequestInput {
	s.ClientToken = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateSubscriptionRequestInput) SetDomainIdentifier(v string) *CreateSubscriptionRequestInput {
	s.DomainIdentifier = &v
	return s
}

// SetRequestReason sets the RequestReason field's value.
func (s *CreateSubscriptionRequestInput) SetRequestReason(v string) *CreateSubscriptionRequestInput {
	s.RequestReason = &v
	return s
}

// SetSubscribedListings sets the SubscribedListings field's value.
func (s *CreateSubscriptionRequestInput) SetSubscribedListings(v []*SubscribedListingInput_) *CreateSubscriptionRequestInput {
	s.SubscribedListings = v
	return s
}

// SetSubscribedPrincipals sets the SubscribedPrincipals field's value.
func (s *CreateSubscriptionRequestInput) SetSubscribedPrincipals(v []*SubscribedPrincipalInput_) *CreateSubscriptionRequestInput {
	s.SubscribedPrincipals = v
	return s
}

type CreateSubscriptionRequestOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp of when the subscription request is created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The Amazon DataZone user who created the subscription request.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The decision comment of the subscription request.
	//
	// DecisionComment is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSubscriptionRequestOutput's
	// String and GoString methods.
	DecisionComment *string `locationName:"decisionComment" min:"1" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain in whcih the subscription request is
	// created.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The ID of the subscription request.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The reason for the subscription request.
	//
	// RequestReason is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSubscriptionRequestOutput's
	// String and GoString methods.
	//
	// RequestReason is a required field
	RequestReason *string `locationName:"requestReason" min:"1" type:"string" required:"true" sensitive:"true"`

	// The ID of the reviewer of the subscription request.
	ReviewerId *string `locationName:"reviewerId" type:"string"`

	// The status of the subscription request.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"SubscriptionRequestStatus"`

	// The published asset for which the subscription grant is to be created.
	//
	// SubscribedListings is a required field
	SubscribedListings []*SubscribedListing `locationName:"subscribedListings" min:"1" type:"list" required:"true"`

	// The subscribed principals of the subscription request.
	//
	// SubscribedPrincipals is a required field
	SubscribedPrincipals []*SubscribedPrincipal `locationName:"subscribedPrincipals" min:"1" type:"list" required:"true"`

	// The timestamp of when the subscription request was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// The Amazon DataZone user who updated the subscription request.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionRequestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionRequestOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateSubscriptionRequestOutput) SetCreatedAt(v time.Time) *CreateSubscriptionRequestOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CreateSubscriptionRequestOutput) SetCreatedBy(v string) *CreateSubscriptionRequestOutput {
	s.CreatedBy = &v
	return s
}

// SetDecisionComment sets the DecisionComment field's value.
func (s *CreateSubscriptionRequestOutput) SetDecisionComment(v string) *CreateSubscriptionRequestOutput {
	s.DecisionComment = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateSubscriptionRequestOutput) SetDomainId(v string) *CreateSubscriptionRequestOutput {
	s.DomainId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSubscriptionRequestOutput) SetId(v string) *CreateSubscriptionRequestOutput {
	s.Id = &v
	return s
}

// SetRequestReason sets the RequestReason field's value.
func (s *CreateSubscriptionRequestOutput) SetRequestReason(v string) *CreateSubscriptionRequestOutput {
	s.RequestReason = &v
	return s
}

// SetReviewerId sets the ReviewerId field's value.
func (s *CreateSubscriptionRequestOutput) SetReviewerId(v string) *CreateSubscriptionRequestOutput {
	s.ReviewerId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateSubscriptionRequestOutput) SetStatus(v string) *CreateSubscriptionRequestOutput {
	s.Status = &v
	return s
}

// SetSubscribedListings sets the SubscribedListings field's value.
func (s *CreateSubscriptionRequestOutput) SetSubscribedListings(v []*SubscribedListing) *CreateSubscriptionRequestOutput {
	s.SubscribedListings = v
	return s
}

// SetSubscribedPrincipals sets the SubscribedPrincipals field's value.
func (s *CreateSubscriptionRequestOutput) SetSubscribedPrincipals(v []*SubscribedPrincipal) *CreateSubscriptionRequestOutput {
	s.SubscribedPrincipals = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateSubscriptionRequestOutput) SetUpdatedAt(v time.Time) *CreateSubscriptionRequestOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *CreateSubscriptionRequestOutput) SetUpdatedBy(v string) *CreateSubscriptionRequestOutput {
	s.UpdatedBy = &v
	return s
}

type CreateSubscriptionTargetInput struct {
	_ struct{} `type:"structure"`

	// The asset types that can be included in the subscription target.
	//
	// ApplicableAssetTypes is a required field
	ApplicableAssetTypes []*string `locationName:"applicableAssetTypes" type:"list" required:"true"`

	// The authorized principals of the subscription target.
	//
	// AuthorizedPrincipals is a required field
	AuthorizedPrincipals []*string `locationName:"authorizedPrincipals" min:"1" type:"list" required:"true"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The ID of the Amazon DataZone domain in which subscription target is created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the environment in which subscription target is created.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"environmentIdentifier" type:"string" required:"true"`

	// The manage access role that is used to create the subscription target.
	//
	// ManageAccessRole is a required field
	ManageAccessRole *string `locationName:"manageAccessRole" type:"string" required:"true"`

	// The name of the subscription target.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSubscriptionTargetInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The provider of the subscription target.
	Provider *string `locationName:"provider" type:"string"`

	// The configuration of the subscription target.
	//
	// SubscriptionTargetConfig is a required field
	SubscriptionTargetConfig []*SubscriptionTargetForm `locationName:"subscriptionTargetConfig" type:"list" required:"true"`

	// The type of the subscription target.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubscriptionTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubscriptionTargetInput"}
	if s.ApplicableAssetTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicableAssetTypes"))
	}
	if s.AuthorizedPrincipals == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizedPrincipals"))
	}
	if s.AuthorizedPrincipals != nil && len(s.AuthorizedPrincipals) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizedPrincipals", 1))
	}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 1))
	}
	if s.ManageAccessRole == nil {
		invalidParams.Add(request.NewErrParamRequired("ManageAccessRole"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SubscriptionTargetConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionTargetConfig"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.SubscriptionTargetConfig != nil {
		for i, v := range s.SubscriptionTargetConfig {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SubscriptionTargetConfig", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicableAssetTypes sets the ApplicableAssetTypes field's value.
func (s *CreateSubscriptionTargetInput) SetApplicableAssetTypes(v []*string) *CreateSubscriptionTargetInput {
	s.ApplicableAssetTypes = v
	return s
}

// SetAuthorizedPrincipals sets the AuthorizedPrincipals field's value.
func (s *CreateSubscriptionTargetInput) SetAuthorizedPrincipals(v []*string) *CreateSubscriptionTargetInput {
	s.AuthorizedPrincipals = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateSubscriptionTargetInput) SetClientToken(v string) *CreateSubscriptionTargetInput {
	s.ClientToken = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateSubscriptionTargetInput) SetDomainIdentifier(v string) *CreateSubscriptionTargetInput {
	s.DomainIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *CreateSubscriptionTargetInput) SetEnvironmentIdentifier(v string) *CreateSubscriptionTargetInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetManageAccessRole sets the ManageAccessRole field's value.
func (s *CreateSubscriptionTargetInput) SetManageAccessRole(v string) *CreateSubscriptionTargetInput {
	s.ManageAccessRole = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSubscriptionTargetInput) SetName(v string) *CreateSubscriptionTargetInput {
	s.Name = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *CreateSubscriptionTargetInput) SetProvider(v string) *CreateSubscriptionTargetInput {
	s.Provider = &v
	return s
}

// SetSubscriptionTargetConfig sets the SubscriptionTargetConfig field's value.
func (s *CreateSubscriptionTargetInput) SetSubscriptionTargetConfig(v []*SubscriptionTargetForm) *CreateSubscriptionTargetInput {
	s.SubscriptionTargetConfig = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateSubscriptionTargetInput) SetType(v string) *CreateSubscriptionTargetInput {
	s.Type = &v
	return s
}

type CreateSubscriptionTargetOutput struct {
	_ struct{} `type:"structure"`

	// The asset types that can be included in the subscription target.
	//
	// ApplicableAssetTypes is a required field
	ApplicableAssetTypes []*string `locationName:"applicableAssetTypes" type:"list" required:"true"`

	// The authorised principals of the subscription target.
	//
	// AuthorizedPrincipals is a required field
	AuthorizedPrincipals []*string `locationName:"authorizedPrincipals" min:"1" type:"list" required:"true"`

	// The timestamp of when the subscription target was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The Amazon DataZone user who created the subscription target.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The ID of the Amazon DataZone domain in which the subscription target was
	// created.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The ID of the environment in which the subscription target was created.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// The ID of the subscription target.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The manage access role with which the subscription target was created.
	//
	// ManageAccessRole is a required field
	ManageAccessRole *string `locationName:"manageAccessRole" type:"string" required:"true"`

	// The name of the subscription target.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateSubscriptionTargetOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// ???
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" type:"string" required:"true"`

	// The provider of the subscription target.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true"`

	// The configuration of the subscription target.
	//
	// SubscriptionTargetConfig is a required field
	SubscriptionTargetConfig []*SubscriptionTargetForm `locationName:"subscriptionTargetConfig" type:"list" required:"true"`

	// The type of the subscription target.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`

	// The timestamp of when the subscription target was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`

	// The Amazon DataZone user who updated the subscription target.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubscriptionTargetOutput) GoString() string {
	return s.String()
}

// SetApplicableAssetTypes sets the ApplicableAssetTypes field's value.
func (s *CreateSubscriptionTargetOutput) SetApplicableAssetTypes(v []*string) *CreateSubscriptionTargetOutput {
	s.ApplicableAssetTypes = v
	return s
}

// SetAuthorizedPrincipals sets the AuthorizedPrincipals field's value.
func (s *CreateSubscriptionTargetOutput) SetAuthorizedPrincipals(v []*string) *CreateSubscriptionTargetOutput {
	s.AuthorizedPrincipals = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateSubscriptionTargetOutput) SetCreatedAt(v time.Time) *CreateSubscriptionTargetOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CreateSubscriptionTargetOutput) SetCreatedBy(v string) *CreateSubscriptionTargetOutput {
	s.CreatedBy = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateSubscriptionTargetOutput) SetDomainId(v string) *CreateSubscriptionTargetOutput {
	s.DomainId = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateSubscriptionTargetOutput) SetEnvironmentId(v string) *CreateSubscriptionTargetOutput {
	s.EnvironmentId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSubscriptionTargetOutput) SetId(v string) *CreateSubscriptionTargetOutput {
	s.Id = &v
	return s
}

// SetManageAccessRole sets the ManageAccessRole field's value.
func (s *CreateSubscriptionTargetOutput) SetManageAccessRole(v string) *CreateSubscriptionTargetOutput {
	s.ManageAccessRole = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSubscriptionTargetOutput) SetName(v string) *CreateSubscriptionTargetOutput {
	s.Name = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *CreateSubscriptionTargetOutput) SetProjectId(v string) *CreateSubscriptionTargetOutput {
	s.ProjectId = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *CreateSubscriptionTargetOutput) SetProvider(v string) *CreateSubscriptionTargetOutput {
	s.Provider = &v
	return s
}

// SetSubscriptionTargetConfig sets the SubscriptionTargetConfig field's value.
func (s *CreateSubscriptionTargetOutput) SetSubscriptionTargetConfig(v []*SubscriptionTargetForm) *CreateSubscriptionTargetOutput {
	s.SubscriptionTargetConfig = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateSubscriptionTargetOutput) SetType(v string) *CreateSubscriptionTargetOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateSubscriptionTargetOutput) SetUpdatedAt(v time.Time) *CreateSubscriptionTargetOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *CreateSubscriptionTargetOutput) SetUpdatedBy(v string) *CreateSubscriptionTargetOutput {
	s.UpdatedBy = &v
	return s
}

type CreateUserProfileInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The identifier of the Amazon DataZone domain in which a user profile is created.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The identifier of the user for which the user profile is created.
	//
	// UserIdentifier is a required field
	UserIdentifier *string `locationName:"userIdentifier" type:"string" required:"true"`

	// The user type of the user for which the user profile is created.
	UserType *string `locationName:"userType" type:"string" enum:"UserType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserProfileInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.UserIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("UserIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateUserProfileInput) SetClientToken(v string) *CreateUserProfileInput {
	s.ClientToken = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *CreateUserProfileInput) SetDomainIdentifier(v string) *CreateUserProfileInput {
	s.DomainIdentifier = &v
	return s
}

// SetUserIdentifier sets the UserIdentifier field's value.
func (s *CreateUserProfileInput) SetUserIdentifier(v string) *CreateUserProfileInput {
	s.UserIdentifier = &v
	return s
}

// SetUserType sets the UserType field's value.
func (s *CreateUserProfileInput) SetUserType(v string) *CreateUserProfileInput {
	s.UserType = &v
	return s
}

type CreateUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The details of the user profile in Amazon DataZone.
	Details *UserProfileDetails `locationName:"details" type:"structure"`

	// The identifier of the Amazon DataZone domain in which a user profile is created.
	DomainId *string `locationName:"domainId" type:"string"`

	// The identifier of the user profile.
	Id *string `locationName:"id" type:"string"`

	// The status of the user profile.
	Status *string `locationName:"status" type:"string" enum:"UserProfileStatus"`

	// The type of the user profile.
	Type *string `locationName:"type" type:"string" enum:"UserProfileType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserProfileOutput) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *CreateUserProfileOutput) SetDetails(v *UserProfileDetails) *CreateUserProfileOutput {
	s.Details = v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *CreateUserProfileOutput) SetDomainId(v string) *CreateUserProfileOutput {
	s.DomainId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateUserProfileOutput) SetId(v string) *CreateUserProfileOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateUserProfileOutput) SetStatus(v string) *CreateUserProfileOutput {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateUserProfileOutput) SetType(v string) *CreateUserProfileOutput {
	s.Type = &v
	return s
}

// The details of user parameters of an environment blueprint.
type CustomParameter struct {
	_ struct{} `type:"structure"`

	// The default value of the parameter.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The description of the parameter.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CustomParameter's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The filed type of the parameter.
	//
	// FieldType is a required field
	FieldType *string `locationName:"fieldType" type:"string" required:"true"`

	// Specifies whether the parameter is editable.
	IsEditable *bool `locationName:"isEditable" type:"boolean"`

	// Specifies whether the custom parameter is optional.
	IsOptional *bool `locationName:"isOptional" type:"boolean"`

	// The key name of the parameter.
	//
	// KeyName is a required field
	KeyName *string `locationName:"keyName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomParameter) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *CustomParameter) SetDefaultValue(v string) *CustomParameter {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CustomParameter) SetDescription(v string) *CustomParameter {
	s.Description = &v
	return s
}

// SetFieldType sets the FieldType field's value.
func (s *CustomParameter) SetFieldType(v string) *CustomParameter {
	s.FieldType = &v
	return s
}

// SetIsEditable sets the IsEditable field's value.
func (s *CustomParameter) SetIsEditable(v bool) *CustomParameter {
	s.IsEditable = &v
	return s
}

// SetIsOptional sets the IsOptional field's value.
func (s *CustomParameter) SetIsOptional(v bool) *CustomParameter {
	s.IsOptional = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *CustomParameter) SetKeyName(v string) *CustomParameter {
	s.KeyName = &v
	return s
}

// The configuration of the data source.
type DataSourceConfigurationInput_ struct {
	_ struct{} `type:"structure"`

	// The configuration of the Amazon Web Services Glue data source.
	GlueRunConfiguration *GlueRunConfigurationInput_ `locationName:"glueRunConfiguration" type:"structure"`

	// The configuration of the Amazon Redshift data source.
	RedshiftRunConfiguration *RedshiftRunConfigurationInput_ `locationName:"redshiftRunConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfigurationInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfigurationInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceConfigurationInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceConfigurationInput_"}
	if s.GlueRunConfiguration != nil {
		if err := s.GlueRunConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GlueRunConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RedshiftRunConfiguration != nil {
		if err := s.RedshiftRunConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RedshiftRunConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlueRunConfiguration sets the GlueRunConfiguration field's value.
func (s *DataSourceConfigurationInput_) SetGlueRunConfiguration(v *GlueRunConfigurationInput_) *DataSourceConfigurationInput_ {
	s.GlueRunConfiguration = v
	return s
}

// SetRedshiftRunConfiguration sets the RedshiftRunConfiguration field's value.
func (s *DataSourceConfigurationInput_) SetRedshiftRunConfiguration(v *RedshiftRunConfigurationInput_) *DataSourceConfigurationInput_ {
	s.RedshiftRunConfiguration = v
	return s
}

// The configuration of the data source.
type DataSourceConfigurationOutput_ struct {
	_ struct{} `type:"structure"`

	// The configuration of the Amazon Web Services Glue data source.
	GlueRunConfiguration *GlueRunConfigurationOutput_ `locationName:"glueRunConfiguration" type:"structure"`

	// The configuration of the Amazon Redshift data source.
	RedshiftRunConfiguration *RedshiftRunConfigurationOutput_ `locationName:"redshiftRunConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfigurationOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfigurationOutput_) GoString() string {
	return s.String()
}

// SetGlueRunConfiguration sets the GlueRunConfiguration field's value.
func (s *DataSourceConfigurationOutput_) SetGlueRunConfiguration(v *GlueRunConfigurationOutput_) *DataSourceConfigurationOutput_ {
	s.GlueRunConfiguration = v
	return s
}

// SetRedshiftRunConfiguration sets the RedshiftRunConfiguration field's value.
func (s *DataSourceConfigurationOutput_) SetRedshiftRunConfiguration(v *RedshiftRunConfigurationOutput_) *DataSourceConfigurationOutput_ {
	s.RedshiftRunConfiguration = v
	return s
}

// The details of the error message that is returned if the operation cannot
// be successfully completed.
type DataSourceErrorMessage struct {
	_ struct{} `type:"structure"`

	// The details of the error message that is returned if the operation cannot
	// be successfully completed.
	ErrorDetail *string `locationName:"errorDetail" type:"string"`

	// The type of the error message that is returned if the operation cannot be
	// successfully completed.
	//
	// ErrorType is a required field
	ErrorType *string `locationName:"errorType" type:"string" required:"true" enum:"DataSourceErrorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceErrorMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceErrorMessage) GoString() string {
	return s.String()
}

// SetErrorDetail sets the ErrorDetail field's value.
func (s *DataSourceErrorMessage) SetErrorDetail(v string) *DataSourceErrorMessage {
	s.ErrorDetail = &v
	return s
}

// SetErrorType sets the ErrorType field's value.
func (s *DataSourceErrorMessage) SetErrorType(v string) *DataSourceErrorMessage {
	s.ErrorType = &v
	return s
}

// The activity details of the data source run.
type DataSourceRunActivity struct {
	_ struct{} `type:"structure"`

	// The timestamp of when data source run activity was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The identifier of the asset included in the data source run activity.
	DataAssetId *string `locationName:"dataAssetId" type:"string"`

	// The status of the asset included in the data source run activity.
	//
	// DataAssetStatus is a required field
	DataAssetStatus *string `locationName:"dataAssetStatus" type:"string" required:"true" enum:"DataAssetActivityStatus"`

	// The identifier of the data source for the data source run activity.
	//
	// DataSourceRunId is a required field
	DataSourceRunId *string `locationName:"dataSourceRunId" type:"string" required:"true"`

	// The database included in the data source run activity.
	//
	// Database is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DataSourceRunActivity's
	// String and GoString methods.
	//
	// Database is a required field
	Database *string `locationName:"database" min:"1" type:"string" required:"true" sensitive:"true"`

	// The details of the error message that is returned if the operation cannot
	// be successfully completed.
	ErrorMessage *DataSourceErrorMessage `locationName:"errorMessage" type:"structure"`

	// The project ID included in the data source run activity.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" type:"string" required:"true"`

	// The technical description included in the data source run activity.
	//
	// TechnicalDescription is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DataSourceRunActivity's
	// String and GoString methods.
	TechnicalDescription *string `locationName:"technicalDescription" type:"string" sensitive:"true"`

	// The technical name included in the data source run activity.
	//
	// TechnicalName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DataSourceRunActivity's
	// String and GoString methods.
	//
	// TechnicalName is a required field
	TechnicalName *string `locationName:"technicalName" min:"1" type:"string" required:"true" sensitive:"true"`

	// The timestamp of when data source run activity was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceRunActivity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceRunActivity) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DataSourceRunActivity) SetCreatedAt(v time.Time) *DataSourceRunActivity {
	s.CreatedAt = &v
	return s
}

// SetDataAssetId sets the DataAssetId field's value.
func (s *DataSourceRunActivity) SetDataAssetId(v string) *DataSourceRunActivity {
	s.DataAssetId = &v
	return s
}

// SetDataAssetStatus sets the DataAssetStatus field's value.
func (s *DataSourceRunActivity) SetDataAssetStatus(v string) *DataSourceRunActivity {
	s.DataAssetStatus = &v
	return s
}

// SetDataSourceRunId sets the DataSourceRunId field's value.
func (s *DataSourceRunActivity) SetDataSourceRunId(v string) *DataSourceRunActivity {
	s.DataSourceRunId = &v
	return s
}

// SetDatabase sets the Database field's value.
func (s *DataSourceRunActivity) SetDatabase(v string) *DataSourceRunActivity {
	s.Database = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DataSourceRunActivity) SetErrorMessage(v *DataSourceErrorMessage) *DataSourceRunActivity {
	s.ErrorMessage = v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *DataSourceRunActivity) SetProjectId(v string) *DataSourceRunActivity {
	s.ProjectId = &v
	return s
}

// SetTechnicalDescription sets the TechnicalDescription field's value.
func (s *DataSourceRunActivity) SetTechnicalDescription(v string) *DataSourceRunActivity {
	s.TechnicalDescription = &v
	return s
}

// SetTechnicalName sets the TechnicalName field's value.
func (s *DataSourceRunActivity) SetTechnicalName(v string) *DataSourceRunActivity {
	s.TechnicalName = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DataSourceRunActivity) SetUpdatedAt(v time.Time) *DataSourceRunActivity {
	s.UpdatedAt = &v
	return s
}

// The details of a data source run.
type DataSourceRunSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp of when a data source run was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The identifier of the data source of the data source run.
	//
	// DataSourceId is a required field
	DataSourceId *string `locationName:"dataSourceId" type:"string" required:"true"`

	// The details of the error message that is returned if the operation cannot
	// be successfully completed.
	ErrorMessage *DataSourceErrorMessage `locationName:"errorMessage" type:"structure"`

	// The identifier of the data source run.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The project ID of the data source run.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" type:"string" required:"true"`

	// The asset statistics from the data source run.
	RunStatisticsForAssets *RunStatisticsForAssets `locationName:"runStatisticsForAssets" type:"structure"`

	// The timestamp of when a data source run was started.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The status of the data source run.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DataSourceRunStatus"`

	// The timestamp of when a data source run was stopped.
	StoppedAt *time.Time `locationName:"stoppedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The type of the data source run.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DataSourceRunType"`

	// The timestamp of when a data source run was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceRunSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceRunSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DataSourceRunSummary) SetCreatedAt(v time.Time) *DataSourceRunSummary {
	s.CreatedAt = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DataSourceRunSummary) SetDataSourceId(v string) *DataSourceRunSummary {
	s.DataSourceId = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DataSourceRunSummary) SetErrorMessage(v *DataSourceErrorMessage) *DataSourceRunSummary {
	s.ErrorMessage = v
	return s
}

// SetId sets the Id field's value.
func (s *DataSourceRunSummary) SetId(v string) *DataSourceRunSummary {
	s.Id = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *DataSourceRunSummary) SetProjectId(v string) *DataSourceRunSummary {
	s.ProjectId = &v
	return s
}

// SetRunStatisticsForAssets sets the RunStatisticsForAssets field's value.
func (s *DataSourceRunSummary) SetRunStatisticsForAssets(v *RunStatisticsForAssets) *DataSourceRunSummary {
	s.RunStatisticsForAssets = v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *DataSourceRunSummary) SetStartedAt(v time.Time) *DataSourceRunSummary {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSourceRunSummary) SetStatus(v string) *DataSourceRunSummary {
	s.Status = &v
	return s
}

// SetStoppedAt sets the StoppedAt field's value.
func (s *DataSourceRunSummary) SetStoppedAt(v time.Time) *DataSourceRunSummary {
	s.StoppedAt = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataSourceRunSummary) SetType(v string) *DataSourceRunSummary {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DataSourceRunSummary) SetUpdatedAt(v time.Time) *DataSourceRunSummary {
	s.UpdatedAt = &v
	return s
}

// The details of the data source.
type DataSourceSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the data source was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the data source.
	//
	// DataSourceId is a required field
	DataSourceId *string `locationName:"dataSourceId" type:"string" required:"true"`

	// The ID of the Amazon DataZone domain in which the data source exists.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// Specifies whether the data source is enabled.
	EnableSetting *string `locationName:"enableSetting" type:"string" enum:"EnableSetting"`

	// The ID of the environment in which the data source exists.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// The count of the assets created during the last data source run.
	LastRunAssetCount *int64 `locationName:"lastRunAssetCount" type:"integer"`

	// The timestamp of when the data source run was last performed.
	LastRunAt *time.Time `locationName:"lastRunAt" type:"timestamp" timestampFormat:"iso8601"`

	// The details of the error message that is returned if the operation cannot
	// be successfully completed.
	LastRunErrorMessage *DataSourceErrorMessage `locationName:"lastRunErrorMessage" type:"structure"`

	// The status of the last data source run.
	LastRunStatus *string `locationName:"lastRunStatus" type:"string" enum:"DataSourceRunStatus"`

	// The name of the data source.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DataSourceSummary's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The details of the schedule of the data source runs.
	//
	// Schedule is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DataSourceSummary's
	// String and GoString methods.
	Schedule *ScheduleConfiguration `locationName:"schedule" type:"structure" sensitive:"true"`

	// The status of the data source.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DataSourceStatus"`

	// The type of the data source.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`

	// The timestamp of when the data source was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DataSourceSummary) SetCreatedAt(v time.Time) *DataSourceSummary {
	s.CreatedAt = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DataSourceSummary) SetDataSourceId(v string) *DataSourceSummary {
	s.DataSourceId = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *DataSourceSummary) SetDomainId(v string) *DataSourceSummary {
	s.DomainId = &v
	return s
}

// SetEnableSetting sets the EnableSetting field's value.
func (s *DataSourceSummary) SetEnableSetting(v string) *DataSourceSummary {
	s.EnableSetting = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DataSourceSummary) SetEnvironmentId(v string) *DataSourceSummary {
	s.EnvironmentId = &v
	return s
}

// SetLastRunAssetCount sets the LastRunAssetCount field's value.
func (s *DataSourceSummary) SetLastRunAssetCount(v int64) *DataSourceSummary {
	s.LastRunAssetCount = &v
	return s
}

// SetLastRunAt sets the LastRunAt field's value.
func (s *DataSourceSummary) SetLastRunAt(v time.Time) *DataSourceSummary {
	s.LastRunAt = &v
	return s
}

// SetLastRunErrorMessage sets the LastRunErrorMessage field's value.
func (s *DataSourceSummary) SetLastRunErrorMessage(v *DataSourceErrorMessage) *DataSourceSummary {
	s.LastRunErrorMessage = v
	return s
}

// SetLastRunStatus sets the LastRunStatus field's value.
func (s *DataSourceSummary) SetLastRunStatus(v string) *DataSourceSummary {
	s.LastRunStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSourceSummary) SetName(v string) *DataSourceSummary {
	s.Name = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *DataSourceSummary) SetSchedule(v *ScheduleConfiguration) *DataSourceSummary {
	s.Schedule = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSourceSummary) SetStatus(v string) *DataSourceSummary {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataSourceSummary) SetType(v string) *DataSourceSummary {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DataSourceSummary) SetUpdatedAt(v time.Time) *DataSourceSummary {
	s.UpdatedAt = &v
	return s
}

type DeleteAssetFilterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the data asset.
	//
	// AssetIdentifier is a required field
	AssetIdentifier *string `location:"uri" locationName:"assetIdentifier" type:"string" required:"true"`

	// The ID of the domain where you want to delete an asset filter.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the asset filter that you want to delete.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssetFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssetFilterInput"}
	if s.AssetIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetIdentifier"))
	}
	if s.AssetIdentifier != nil && len(*s.AssetIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetIdentifier", 1))
	}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetIdentifier sets the AssetIdentifier field's value.
func (s *DeleteAssetFilterInput) SetAssetIdentifier(v string) *DeleteAssetFilterInput {
	s.AssetIdentifier = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteAssetFilterInput) SetDomainIdentifier(v string) *DeleteAssetFilterInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteAssetFilterInput) SetIdentifier(v string) *DeleteAssetFilterInput {
	s.Identifier = &v
	return s
}

type DeleteAssetFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetFilterOutput) GoString() string {
	return s.String()
}

type DeleteAssetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the asset is deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The identifier of the asset that is deleted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssetInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteAssetInput) SetDomainIdentifier(v string) *DeleteAssetInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteAssetInput) SetIdentifier(v string) *DeleteAssetInput {
	s.Identifier = &v
	return s
}

type DeleteAssetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetOutput) GoString() string {
	return s.String()
}

type DeleteAssetTypeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the asset type is deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The identifier of the asset type that is deleted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssetTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssetTypeInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteAssetTypeInput) SetDomainIdentifier(v string) *DeleteAssetTypeInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteAssetTypeInput) SetIdentifier(v string) *DeleteAssetTypeInput {
	s.Identifier = &v
	return s
}

type DeleteAssetTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssetTypeOutput) GoString() string {
	return s.String()
}

type DeleteDataSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The ID of the Amazon DataZone domain in which the data source is deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The identifier of the data source that is deleted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`

	// Specifies that the granted permissions are retained in case of a self-subscribe
	// functionality failure for a data source.
	RetainPermissionsOnRevokeFailure *bool `location:"querystring" locationName:"retainPermissionsOnRevokeFailure" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataSourceInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteDataSourceInput) SetClientToken(v string) *DeleteDataSourceInput {
	s.ClientToken = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteDataSourceInput) SetDomainIdentifier(v string) *DeleteDataSourceInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteDataSourceInput) SetIdentifier(v string) *DeleteDataSourceInput {
	s.Identifier = &v
	return s
}

// SetRetainPermissionsOnRevokeFailure sets the RetainPermissionsOnRevokeFailure field's value.
func (s *DeleteDataSourceInput) SetRetainPermissionsOnRevokeFailure(v bool) *DeleteDataSourceInput {
	s.RetainPermissionsOnRevokeFailure = &v
	return s
}

type DeleteDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The asset data forms associated with this data source.
	AssetFormsOutput []*FormOutput_ `locationName:"assetFormsOutput" type:"list"`

	// The configuration of the data source that is deleted.
	Configuration *DataSourceConfigurationOutput_ `locationName:"configuration" type:"structure"`

	// The timestamp of when this data source was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the data source that is deleted.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeleteDataSourceOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain in which the data source is deleted.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The enable setting of the data source that specifies whether the data source
	// is enabled or disabled.
	EnableSetting *string `locationName:"enableSetting" type:"string" enum:"EnableSetting"`

	// The ID of the environemnt associated with this data source.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// Specifies the error message that is returned if the operation cannot be successfully
	// completed.
	ErrorMessage *DataSourceErrorMessage `locationName:"errorMessage" type:"structure"`

	// The ID of the data source that is deleted.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The timestamp of when the data source was last run.
	LastRunAt *time.Time `locationName:"lastRunAt" type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the error message that is returned if the operation cannot be successfully
	// completed.
	LastRunErrorMessage *DataSourceErrorMessage `locationName:"lastRunErrorMessage" type:"structure"`

	// The status of the last run of this data source.
	LastRunStatus *string `locationName:"lastRunStatus" type:"string" enum:"DataSourceRunStatus"`

	// The name of the data source that is deleted.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeleteDataSourceOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The ID of the project in which this data source exists and from which it's
	// deleted.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" type:"string" required:"true"`

	// Specifies whether the assets that this data source creates in the inventory
	// are to be also automatically published to the catalog.
	PublishOnImport *bool `locationName:"publishOnImport" type:"boolean"`

	// Specifies that the granted permissions are retained in case of a self-subscribe
	// functionality failure for a data source.
	RetainPermissionsOnRevokeFailure *bool `locationName:"retainPermissionsOnRevokeFailure" type:"boolean"`

	// The schedule of runs for this data source.
	//
	// Schedule is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DeleteDataSourceOutput's
	// String and GoString methods.
	Schedule *ScheduleConfiguration `locationName:"schedule" type:"structure" sensitive:"true"`

	// Specifies the status of the self-granting functionality.
	SelfGrantStatus *SelfGrantStatusOutput_ `locationName:"selfGrantStatus" type:"structure"`

	// The status of this data source.
	Status *string `locationName:"status" type:"string" enum:"DataSourceStatus"`

	// The type of this data source.
	Type *string `locationName:"type" min:"1" type:"string"`

	// The timestamp of when this data source was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceOutput) GoString() string {
	return s.String()
}

// SetAssetFormsOutput sets the AssetFormsOutput field's value.
func (s *DeleteDataSourceOutput) SetAssetFormsOutput(v []*FormOutput_) *DeleteDataSourceOutput {
	s.AssetFormsOutput = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *DeleteDataSourceOutput) SetConfiguration(v *DataSourceConfigurationOutput_) *DeleteDataSourceOutput {
	s.Configuration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DeleteDataSourceOutput) SetCreatedAt(v time.Time) *DeleteDataSourceOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DeleteDataSourceOutput) SetDescription(v string) *DeleteDataSourceOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *DeleteDataSourceOutput) SetDomainId(v string) *DeleteDataSourceOutput {
	s.DomainId = &v
	return s
}

// SetEnableSetting sets the EnableSetting field's value.
func (s *DeleteDataSourceOutput) SetEnableSetting(v string) *DeleteDataSourceOutput {
	s.EnableSetting = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteDataSourceOutput) SetEnvironmentId(v string) *DeleteDataSourceOutput {
	s.EnvironmentId = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DeleteDataSourceOutput) SetErrorMessage(v *DataSourceErrorMessage) *DeleteDataSourceOutput {
	s.ErrorMessage = v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteDataSourceOutput) SetId(v string) *DeleteDataSourceOutput {
	s.Id = &v
	return s
}

// SetLastRunAt sets the LastRunAt field's value.
func (s *DeleteDataSourceOutput) SetLastRunAt(v time.Time) *DeleteDataSourceOutput {
	s.LastRunAt = &v
	return s
}

// SetLastRunErrorMessage sets the LastRunErrorMessage field's value.
func (s *DeleteDataSourceOutput) SetLastRunErrorMessage(v *DataSourceErrorMessage) *DeleteDataSourceOutput {
	s.LastRunErrorMessage = v
	return s
}

// SetLastRunStatus sets the LastRunStatus field's value.
func (s *DeleteDataSourceOutput) SetLastRunStatus(v string) *DeleteDataSourceOutput {
	s.LastRunStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteDataSourceOutput) SetName(v string) *DeleteDataSourceOutput {
	s.Name = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *DeleteDataSourceOutput) SetProjectId(v string) *DeleteDataSourceOutput {
	s.ProjectId = &v
	return s
}

// SetPublishOnImport sets the PublishOnImport field's value.
func (s *DeleteDataSourceOutput) SetPublishOnImport(v bool) *DeleteDataSourceOutput {
	s.PublishOnImport = &v
	return s
}

// SetRetainPermissionsOnRevokeFailure sets the RetainPermissionsOnRevokeFailure field's value.
func (s *DeleteDataSourceOutput) SetRetainPermissionsOnRevokeFailure(v bool) *DeleteDataSourceOutput {
	s.RetainPermissionsOnRevokeFailure = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *DeleteDataSourceOutput) SetSchedule(v *ScheduleConfiguration) *DeleteDataSourceOutput {
	s.Schedule = v
	return s
}

// SetSelfGrantStatus sets the SelfGrantStatus field's value.
func (s *DeleteDataSourceOutput) SetSelfGrantStatus(v *SelfGrantStatusOutput_) *DeleteDataSourceOutput {
	s.SelfGrantStatus = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteDataSourceOutput) SetStatus(v string) *DeleteDataSourceOutput {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *DeleteDataSourceOutput) SetType(v string) *DeleteDataSourceOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DeleteDataSourceOutput) SetUpdatedAt(v time.Time) *DeleteDataSourceOutput {
	s.UpdatedAt = &v
	return s
}

type DeleteDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string `location:"querystring" locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The identifier of the Amazon Web Services domain that is to be deleted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`

	// Specifies the optional flag to delete all child entities within the domain.
	SkipDeletionCheck *bool `location:"querystring" locationName:"skipDeletionCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteDomainInput) SetClientToken(v string) *DeleteDomainInput {
	s.ClientToken = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteDomainInput) SetIdentifier(v string) *DeleteDomainInput {
	s.Identifier = &v
	return s
}

// SetSkipDeletionCheck sets the SkipDeletionCheck field's value.
func (s *DeleteDomainInput) SetSkipDeletionCheck(v bool) *DeleteDomainInput {
	s.SkipDeletionCheck = &v
	return s
}

type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`

	// The status of the domain.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DomainStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DeleteDomainOutput) SetStatus(v string) *DeleteDomainOutput {
	s.Status = &v
	return s
}

type DeleteEnvironmentActionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which an environment action is deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the environment where an environment action is deleted.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"environmentIdentifier" type:"string" required:"true"`

	// The ID of the environment action that is deleted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentActionInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteEnvironmentActionInput) SetDomainIdentifier(v string) *DeleteEnvironmentActionInput {
	s.DomainIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *DeleteEnvironmentActionInput) SetEnvironmentIdentifier(v string) *DeleteEnvironmentActionInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteEnvironmentActionInput) SetIdentifier(v string) *DeleteEnvironmentActionInput {
	s.Identifier = &v
	return s
}

type DeleteEnvironmentActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentActionOutput) GoString() string {
	return s.String()
}

type DeleteEnvironmentBlueprintConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the blueprint configuration
	// is deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the blueprint the configuration of which is deleted.
	//
	// EnvironmentBlueprintIdentifier is a required field
	EnvironmentBlueprintIdentifier *string `location:"uri" locationName:"environmentBlueprintIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentBlueprintConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentBlueprintConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentBlueprintConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentBlueprintConfigurationInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EnvironmentBlueprintIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentBlueprintIdentifier"))
	}
	if s.EnvironmentBlueprintIdentifier != nil && len(*s.EnvironmentBlueprintIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentBlueprintIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteEnvironmentBlueprintConfigurationInput) SetDomainIdentifier(v string) *DeleteEnvironmentBlueprintConfigurationInput {
	s.DomainIdentifier = &v
	return s
}

// SetEnvironmentBlueprintIdentifier sets the EnvironmentBlueprintIdentifier field's value.
func (s *DeleteEnvironmentBlueprintConfigurationInput) SetEnvironmentBlueprintIdentifier(v string) *DeleteEnvironmentBlueprintConfigurationInput {
	s.EnvironmentBlueprintIdentifier = &v
	return s
}

type DeleteEnvironmentBlueprintConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentBlueprintConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentBlueprintConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the environment is deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The identifier of the environment that is to be deleted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteEnvironmentInput) SetDomainIdentifier(v string) *DeleteEnvironmentInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteEnvironmentInput) SetIdentifier(v string) *DeleteEnvironmentInput {
	s.Identifier = &v
	return s
}

type DeleteEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentOutput) GoString() string {
	return s.String()
}

type DeleteEnvironmentProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the environment profile is
	// deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the environment profile that is deleted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentProfileInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteEnvironmentProfileInput) SetDomainIdentifier(v string) *DeleteEnvironmentProfileInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteEnvironmentProfileInput) SetIdentifier(v string) *DeleteEnvironmentProfileInput {
	s.Identifier = &v
	return s
}

type DeleteEnvironmentProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentProfileOutput) GoString() string {
	return s.String()
}

type DeleteFormTypeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the metadata form type is deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the metadata form type that is deleted.
	//
	// FormTypeIdentifier is a required field
	FormTypeIdentifier *string `location:"uri" locationName:"formTypeIdentifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFormTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFormTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFormTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFormTypeInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.FormTypeIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("FormTypeIdentifier"))
	}
	if s.FormTypeIdentifier != nil && len(*s.FormTypeIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FormTypeIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteFormTypeInput) SetDomainIdentifier(v string) *DeleteFormTypeInput {
	s.DomainIdentifier = &v
	return s
}

// SetFormTypeIdentifier sets the FormTypeIdentifier field's value.
func (s *DeleteFormTypeInput) SetFormTypeIdentifier(v string) *DeleteFormTypeInput {
	s.FormTypeIdentifier = &v
	return s
}

type DeleteFormTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFormTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFormTypeOutput) GoString() string {
	return s.String()
}

type DeleteGlossaryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the business glossary is deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the business glossary that is deleted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGlossaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGlossaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGlossaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGlossaryInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteGlossaryInput) SetDomainIdentifier(v string) *DeleteGlossaryInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteGlossaryInput) SetIdentifier(v string) *DeleteGlossaryInput {
	s.Identifier = &v
	return s
}

type DeleteGlossaryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGlossaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGlossaryOutput) GoString() string {
	return s.String()
}

type DeleteGlossaryTermInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the business glossary term
	// is deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the business glossary term that is deleted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGlossaryTermInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGlossaryTermInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGlossaryTermInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGlossaryTermInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteGlossaryTermInput) SetDomainIdentifier(v string) *DeleteGlossaryTermInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteGlossaryTermInput) SetIdentifier(v string) *DeleteGlossaryTermInput {
	s.Identifier = &v
	return s
}

type DeleteGlossaryTermOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGlossaryTermOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGlossaryTermOutput) GoString() string {
	return s.String()
}

type DeleteListingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the listing to be deleted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteListingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteListingInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteListingInput) SetDomainIdentifier(v string) *DeleteListingInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteListingInput) SetIdentifier(v string) *DeleteListingInput {
	s.Identifier = &v
	return s
}

type DeleteListingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteListingOutput) GoString() string {
	return s.String()
}

type DeleteProjectInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the project is deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The identifier of the project that is to be deleted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`

	// Specifies the optional flag to delete all child entities within the project.
	SkipDeletionCheck *bool `location:"querystring" locationName:"skipDeletionCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteProjectInput) SetDomainIdentifier(v string) *DeleteProjectInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteProjectInput) SetIdentifier(v string) *DeleteProjectInput {
	s.Identifier = &v
	return s
}

// SetSkipDeletionCheck sets the SkipDeletionCheck field's value.
func (s *DeleteProjectInput) SetSkipDeletionCheck(v bool) *DeleteProjectInput {
	s.SkipDeletionCheck = &v
	return s
}

type DeleteProjectMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon DataZone domain where project membership is deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The project member whose project membership is deleted.
	//
	// Member is a required field
	Member *Member `locationName:"member" type:"structure" required:"true"`

	// The ID of the Amazon DataZone project the membership to which is deleted.
	//
	// ProjectIdentifier is a required field
	ProjectIdentifier *string `location:"uri" locationName:"projectIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectMembershipInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Member == nil {
		invalidParams.Add(request.NewErrParamRequired("Member"))
	}
	if s.ProjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectIdentifier"))
	}
	if s.ProjectIdentifier != nil && len(*s.ProjectIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteProjectMembershipInput) SetDomainIdentifier(v string) *DeleteProjectMembershipInput {
	s.DomainIdentifier = &v
	return s
}

// SetMember sets the Member field's value.
func (s *DeleteProjectMembershipInput) SetMember(v *Member) *DeleteProjectMembershipInput {
	s.Member = v
	return s
}

// SetProjectIdentifier sets the ProjectIdentifier field's value.
func (s *DeleteProjectMembershipInput) SetProjectIdentifier(v string) *DeleteProjectMembershipInput {
	s.ProjectIdentifier = &v
	return s
}

type DeleteProjectMembershipOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectMembershipOutput) GoString() string {
	return s.String()
}

type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

type DeleteSubscriptionGrantInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain where the subscription grant is deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the subscription grant that is deleted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubscriptionGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSubscriptionGrantInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteSubscriptionGrantInput) SetDomainIdentifier(v string) *DeleteSubscriptionGrantInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteSubscriptionGrantInput) SetIdentifier(v string) *DeleteSubscriptionGrantInput {
	s.Identifier = &v
	return s
}

type DeleteSubscriptionGrantOutput struct {
	_ struct{} `type:"structure"`

	// The assets for which the subsctiption grant that is deleted gave access.
	Assets []*SubscribedAsset `locationName:"assets" type:"list"`

	// The timestamp of when the subscription grant that is deleted was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The Amazon DataZone user who created the subscription grant that is deleted.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The ID of the Amazon DataZone domain in which the subscription grant is deleted.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The entity to which the subscription is deleted.
	//
	// GrantedEntity is a required field
	GrantedEntity *GrantedEntity `locationName:"grantedEntity" type:"structure" required:"true"`

	// The ID of the subscription grant that is deleted.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The status of the subscription grant that is deleted.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"SubscriptionGrantOverallStatus"`

	// The identifier of the subsctiption whose subscription grant is to be deleted.
	SubscriptionId *string `locationName:"subscriptionId" type:"string"`

	// The ID of the subscription target associated with the subscription grant
	// that is deleted.
	//
	// SubscriptionTargetId is a required field
	SubscriptionTargetId *string `locationName:"subscriptionTargetId" type:"string" required:"true"`

	// The timestamp of when the subscription grant that is deleted was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" required:"true"`

	// The Amazon DataZone user who updated the subscription grant that is deleted.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionGrantOutput) GoString() string {
	return s.String()
}

// SetAssets sets the Assets field's value.
func (s *DeleteSubscriptionGrantOutput) SetAssets(v []*SubscribedAsset) *DeleteSubscriptionGrantOutput {
	s.Assets = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DeleteSubscriptionGrantOutput) SetCreatedAt(v time.Time) *DeleteSubscriptionGrantOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DeleteSubscriptionGrantOutput) SetCreatedBy(v string) *DeleteSubscriptionGrantOutput {
	s.CreatedBy = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *DeleteSubscriptionGrantOutput) SetDomainId(v string) *DeleteSubscriptionGrantOutput {
	s.DomainId = &v
	return s
}

// SetGrantedEntity sets the GrantedEntity field's value.
func (s *DeleteSubscriptionGrantOutput) SetGrantedEntity(v *GrantedEntity) *DeleteSubscriptionGrantOutput {
	s.GrantedEntity = v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteSubscriptionGrantOutput) SetId(v string) *DeleteSubscriptionGrantOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteSubscriptionGrantOutput) SetStatus(v string) *DeleteSubscriptionGrantOutput {
	s.Status = &v
	return s
}

// SetSubscriptionId sets the SubscriptionId field's value.
func (s *DeleteSubscriptionGrantOutput) SetSubscriptionId(v string) *DeleteSubscriptionGrantOutput {
	s.SubscriptionId = &v
	return s
}

// SetSubscriptionTargetId sets the SubscriptionTargetId field's value.
func (s *DeleteSubscriptionGrantOutput) SetSubscriptionTargetId(v string) *DeleteSubscriptionGrantOutput {
	s.SubscriptionTargetId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DeleteSubscriptionGrantOutput) SetUpdatedAt(v time.Time) *DeleteSubscriptionGrantOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *DeleteSubscriptionGrantOutput) SetUpdatedBy(v string) *DeleteSubscriptionGrantOutput {
	s.UpdatedBy = &v
	return s
}

type DeleteSubscriptionRequestInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the subscription request is
	// deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the subscription request that is deleted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionRequestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionRequestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubscriptionRequestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSubscriptionRequestInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteSubscriptionRequestInput) SetDomainIdentifier(v string) *DeleteSubscriptionRequestInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteSubscriptionRequestInput) SetIdentifier(v string) *DeleteSubscriptionRequestInput {
	s.Identifier = &v
	return s
}

type DeleteSubscriptionRequestOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionRequestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionRequestOutput) GoString() string {
	return s.String()
}

type DeleteSubscriptionTargetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the subscription target is
	// deleted.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the Amazon DataZone environment in which the subscription target
	// is deleted.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"environmentIdentifier" type:"string" required:"true"`

	// The ID of the subscription target that is deleted.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubscriptionTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSubscriptionTargetInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteSubscriptionTargetInput) SetDomainIdentifier(v string) *DeleteSubscriptionTargetInput {
	s.DomainIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *DeleteSubscriptionTargetInput) SetEnvironmentIdentifier(v string) *DeleteSubscriptionTargetInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteSubscriptionTargetInput) SetIdentifier(v string) *DeleteSubscriptionTargetInput {
	s.Identifier = &v
	return s
}

type DeleteSubscriptionTargetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubscriptionTargetOutput) GoString() string {
	return s.String()
}

type DeleteTimeSeriesDataPointsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique, case-sensitive identifier to ensure idempotency of the request.
	// This field is automatically populated if not provided.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the Amazon DataZone domain that houses the asset for which you
	// want to delete a time series form.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the asset for which you want to delete a time series form.
	//
	// EntityIdentifier is a required field
	EntityIdentifier *string `location:"uri" locationName:"entityIdentifier" type:"string" required:"true"`

	// The type of the asset for which you want to delete a time series form.
	//
	// EntityType is a required field
	EntityType *string `location:"uri" locationName:"entityType" type:"string" required:"true" enum:"TimeSeriesEntityType"`

	// The name of the time series form that you want to delete.
	//
	// FormName is a required field
	FormName *string `location:"querystring" locationName:"formName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTimeSeriesDataPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTimeSeriesDataPointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTimeSeriesDataPointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTimeSeriesDataPointsInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EntityIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityIdentifier"))
	}
	if s.EntityIdentifier != nil && len(*s.EntityIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityIdentifier", 1))
	}
	if s.EntityType == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityType"))
	}
	if s.EntityType != nil && len(*s.EntityType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityType", 1))
	}
	if s.FormName == nil {
		invalidParams.Add(request.NewErrParamRequired("FormName"))
	}
	if s.FormName != nil && len(*s.FormName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FormName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteTimeSeriesDataPointsInput) SetClientToken(v string) *DeleteTimeSeriesDataPointsInput {
	s.ClientToken = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DeleteTimeSeriesDataPointsInput) SetDomainIdentifier(v string) *DeleteTimeSeriesDataPointsInput {
	s.DomainIdentifier = &v
	return s
}

// SetEntityIdentifier sets the EntityIdentifier field's value.
func (s *DeleteTimeSeriesDataPointsInput) SetEntityIdentifier(v string) *DeleteTimeSeriesDataPointsInput {
	s.EntityIdentifier = &v
	return s
}

// SetEntityType sets the EntityType field's value.
func (s *DeleteTimeSeriesDataPointsInput) SetEntityType(v string) *DeleteTimeSeriesDataPointsInput {
	s.EntityType = &v
	return s
}

// SetFormName sets the FormName field's value.
func (s *DeleteTimeSeriesDataPointsInput) SetFormName(v string) *DeleteTimeSeriesDataPointsInput {
	s.FormName = &v
	return s
}

type DeleteTimeSeriesDataPointsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTimeSeriesDataPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTimeSeriesDataPointsOutput) GoString() string {
	return s.String()
}

// The details of the last deployment of the environment.
type Deployment struct {
	_ struct{} `type:"structure"`

	// The identifier of the last deployment of the environment.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The status of the last deployment of the environment.
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" enum:"DeploymentStatus"`

	// The type of the last deployment of the environment.
	DeploymentType *string `locationName:"deploymentType" type:"string" enum:"DeploymentType"`

	// The failure reason of the last deployment of the environment.
	FailureReason *EnvironmentError `locationName:"failureReason" type:"structure"`

	// Specifies whether the last deployment of the environment is complete.
	IsDeploymentComplete *bool `locationName:"isDeploymentComplete" type:"boolean"`

	// The messages of the last deployment of the environment.
	Messages []*string `locationName:"messages" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Deployment) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *Deployment) SetDeploymentId(v string) *Deployment {
	s.DeploymentId = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *Deployment) SetDeploymentStatus(v string) *Deployment {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *Deployment) SetDeploymentType(v string) *Deployment {
	s.DeploymentType = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *Deployment) SetFailureReason(v *EnvironmentError) *Deployment {
	s.FailureReason = v
	return s
}

// SetIsDeploymentComplete sets the IsDeploymentComplete field's value.
func (s *Deployment) SetIsDeploymentComplete(v bool) *Deployment {
	s.IsDeploymentComplete = &v
	return s
}

// SetMessages sets the Messages field's value.
func (s *Deployment) SetMessages(v []*string) *Deployment {
	s.Messages = v
	return s
}

// The deployment properties of the Amazon DataZone blueprint.
type DeploymentProperties struct {
	_ struct{} `type:"structure"`

	// The end timeout of the environment blueprint deployment.
	EndTimeoutMinutes *int64 `locationName:"endTimeoutMinutes" min:"1" type:"integer"`

	// The start timeout of the environment blueprint deployment.
	StartTimeoutMinutes *int64 `locationName:"startTimeoutMinutes" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentProperties) GoString() string {
	return s.String()
}

// SetEndTimeoutMinutes sets the EndTimeoutMinutes field's value.
func (s *DeploymentProperties) SetEndTimeoutMinutes(v int64) *DeploymentProperties {
	s.EndTimeoutMinutes = &v
	return s
}

// SetStartTimeoutMinutes sets the StartTimeoutMinutes field's value.
func (s *DeploymentProperties) SetStartTimeoutMinutes(v int64) *DeploymentProperties {
	s.StartTimeoutMinutes = &v
	return s
}

// Details of a glossary term attached to the inventory asset.
type DetailedGlossaryTerm struct {
	_ struct{} `type:"structure"`

	// The name of a glossary term attached to the inventory asset.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DetailedGlossaryTerm's
	// String and GoString methods.
	Name *string `locationName:"name" min:"1" type:"string" sensitive:"true"`

	// The shoft description of a glossary term attached to the inventory asset.
	//
	// ShortDescription is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DetailedGlossaryTerm's
	// String and GoString methods.
	ShortDescription *string `locationName:"shortDescription" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetailedGlossaryTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetailedGlossaryTerm) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DetailedGlossaryTerm) SetName(v string) *DetailedGlossaryTerm {
	s.Name = &v
	return s
}

// SetShortDescription sets the ShortDescription field's value.
func (s *DetailedGlossaryTerm) SetShortDescription(v string) *DetailedGlossaryTerm {
	s.ShortDescription = &v
	return s
}

type DisassociateEnvironmentRoleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which an environment role is disassociated.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the environment.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"environmentIdentifier" type:"string" required:"true"`

	// The ARN of the environment role.
	//
	// EnvironmentRoleArn is a required field
	EnvironmentRoleArn *string `location:"uri" locationName:"environmentRoleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateEnvironmentRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateEnvironmentRoleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateEnvironmentRoleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateEnvironmentRoleInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 1))
	}
	if s.EnvironmentRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentRoleArn"))
	}
	if s.EnvironmentRoleArn != nil && len(*s.EnvironmentRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentRoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *DisassociateEnvironmentRoleInput) SetDomainIdentifier(v string) *DisassociateEnvironmentRoleInput {
	s.DomainIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *DisassociateEnvironmentRoleInput) SetEnvironmentIdentifier(v string) *DisassociateEnvironmentRoleInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetEnvironmentRoleArn sets the EnvironmentRoleArn field's value.
func (s *DisassociateEnvironmentRoleInput) SetEnvironmentRoleArn(v string) *DisassociateEnvironmentRoleInput {
	s.EnvironmentRoleArn = &v
	return s
}

type DisassociateEnvironmentRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateEnvironmentRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateEnvironmentRoleOutput) GoString() string {
	return s.String()
}

// A summary of a Amazon DataZone domain.
type DomainSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon DataZone domain.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// A timestamp of when a Amazon DataZone domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of an Amazon DataZone domain.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DomainSummary's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// A timestamp of when a Amazon DataZone domain was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The identifier of the Amazon Web Services account that manages the domain.
	//
	// ManagedAccountId is a required field
	ManagedAccountId *string `locationName:"managedAccountId" type:"string" required:"true"`

	// A name of an Amazon DataZone domain.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DomainSummary's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" sensitive:"true"`

	// The data portal URL for the Amazon DataZone domain.
	PortalUrl *string `locationName:"portalUrl" type:"string"`

	// The status of the Amazon DataZone domain.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DomainStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DomainSummary) SetArn(v string) *DomainSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DomainSummary) SetCreatedAt(v time.Time) *DomainSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DomainSummary) SetDescription(v string) *DomainSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *DomainSummary) SetId(v string) *DomainSummary {
	s.Id = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *DomainSummary) SetLastUpdatedAt(v time.Time) *DomainSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetManagedAccountId sets the ManagedAccountId field's value.
func (s *DomainSummary) SetManagedAccountId(v string) *DomainSummary {
	s.ManagedAccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DomainSummary) SetName(v string) *DomainSummary {
	s.Name = &v
	return s
}

// SetPortalUrl sets the PortalUrl field's value.
func (s *DomainSummary) SetPortalUrl(v string) *DomainSummary {
	s.PortalUrl = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainSummary) SetStatus(v string) *DomainSummary {
	s.Status = &v
	return s
}

// The details about the specified action configured for an environment. For
// example, the details of the specified console links for an analytics tool
// that is available in this environment.
type EnvironmentActionSummary struct {
	_ struct{} `type:"structure"`

	// The environment action description.
	Description *string `locationName:"description" type:"string"`

	// The Amazon DataZone domain ID of the environment action.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The environment ID of the environment action.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// The ID of the environment action.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the environment action.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The parameters of the environment action.
	//
	// Parameters is a required field
	Parameters *ActionParameters `locationName:"parameters" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentActionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentActionSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *EnvironmentActionSummary) SetDescription(v string) *EnvironmentActionSummary {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *EnvironmentActionSummary) SetDomainId(v string) *EnvironmentActionSummary {
	s.DomainId = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *EnvironmentActionSummary) SetEnvironmentId(v string) *EnvironmentActionSummary {
	s.EnvironmentId = &v
	return s
}

// SetId sets the Id field's value.
func (s *EnvironmentActionSummary) SetId(v string) *EnvironmentActionSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *EnvironmentActionSummary) SetName(v string) *EnvironmentActionSummary {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *EnvironmentActionSummary) SetParameters(v *ActionParameters) *EnvironmentActionSummary {
	s.Parameters = v
	return s
}

// The configuration details of an environment blueprint.
type EnvironmentBlueprintConfigurationItem struct {
	_ struct{} `type:"structure"`

	// The timestamp of when an environment blueprint was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The identifier of the Amazon DataZone domain in which an environment blueprint
	// exists.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The enabled Amazon Web Services Regions specified in a blueprint configuration.
	EnabledRegions []*string `locationName:"enabledRegions" type:"list"`

	// The identifier of the environment blueprint.
	//
	// EnvironmentBlueprintId is a required field
	EnvironmentBlueprintId *string `locationName:"environmentBlueprintId" type:"string" required:"true"`

	// The ARN of the manage access role specified in the environment blueprint
	// configuration.
	ManageAccessRoleArn *string `locationName:"manageAccessRoleArn" type:"string"`

	// The provisioning configuration of a blueprint.
	ProvisioningConfigurations []*ProvisioningConfiguration `locationName:"provisioningConfigurations" type:"list"`

	// The ARN of the provisioning role specified in the environment blueprint configuration.
	ProvisioningRoleArn *string `locationName:"provisioningRoleArn" type:"string"`

	// The regional parameters of the environment blueprint.
	RegionalParameters map[string]map[string]*string `locationName:"regionalParameters" type:"map"`

	// The timestamp of when the environment blueprint was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentBlueprintConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentBlueprintConfigurationItem) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EnvironmentBlueprintConfigurationItem) SetCreatedAt(v time.Time) *EnvironmentBlueprintConfigurationItem {
	s.CreatedAt = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *EnvironmentBlueprintConfigurationItem) SetDomainId(v string) *EnvironmentBlueprintConfigurationItem {
	s.DomainId = &v
	return s
}

// SetEnabledRegions sets the EnabledRegions field's value.
func (s *EnvironmentBlueprintConfigurationItem) SetEnabledRegions(v []*string) *EnvironmentBlueprintConfigurationItem {
	s.EnabledRegions = v
	return s
}

// SetEnvironmentBlueprintId sets the EnvironmentBlueprintId field's value.
func (s *EnvironmentBlueprintConfigurationItem) SetEnvironmentBlueprintId(v string) *EnvironmentBlueprintConfigurationItem {
	s.EnvironmentBlueprintId = &v
	return s
}

// SetManageAccessRoleArn sets the ManageAccessRoleArn field's value.
func (s *EnvironmentBlueprintConfigurationItem) SetManageAccessRoleArn(v string) *EnvironmentBlueprintConfigurationItem {
	s.ManageAccessRoleArn = &v
	return s
}

// SetProvisioningConfigurations sets the ProvisioningConfigurations field's value.
func (s *EnvironmentBlueprintConfigurationItem) SetProvisioningConfigurations(v []*ProvisioningConfiguration) *EnvironmentBlueprintConfigurationItem {
	s.ProvisioningConfigurations = v
	return s
}

// SetProvisioningRoleArn sets the ProvisioningRoleArn field's value.
func (s *EnvironmentBlueprintConfigurationItem) SetProvisioningRoleArn(v string) *EnvironmentBlueprintConfigurationItem {
	s.ProvisioningRoleArn = &v
	return s
}

// SetRegionalParameters sets the RegionalParameters field's value.
func (s *EnvironmentBlueprintConfigurationItem) SetRegionalParameters(v map[string]map[string]*string) *EnvironmentBlueprintConfigurationItem {
	s.RegionalParameters = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *EnvironmentBlueprintConfigurationItem) SetUpdatedAt(v time.Time) *EnvironmentBlueprintConfigurationItem {
	s.UpdatedAt = &v
	return s
}

// The details of an environment blueprint summary.
type EnvironmentBlueprintSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp of when an environment blueprint was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The description of a blueprint.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentBlueprintSummary's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The identifier of the blueprint.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the blueprint.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The provider of the blueprint.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true"`

	// The provisioning properties of the blueprint.
	//
	// ProvisioningProperties is a required field
	ProvisioningProperties *ProvisioningProperties `locationName:"provisioningProperties" type:"structure" required:"true"`

	// The timestamp of when the blueprint was enabled.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentBlueprintSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentBlueprintSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EnvironmentBlueprintSummary) SetCreatedAt(v time.Time) *EnvironmentBlueprintSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EnvironmentBlueprintSummary) SetDescription(v string) *EnvironmentBlueprintSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *EnvironmentBlueprintSummary) SetId(v string) *EnvironmentBlueprintSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *EnvironmentBlueprintSummary) SetName(v string) *EnvironmentBlueprintSummary {
	s.Name = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *EnvironmentBlueprintSummary) SetProvider(v string) *EnvironmentBlueprintSummary {
	s.Provider = &v
	return s
}

// SetProvisioningProperties sets the ProvisioningProperties field's value.
func (s *EnvironmentBlueprintSummary) SetProvisioningProperties(v *ProvisioningProperties) *EnvironmentBlueprintSummary {
	s.ProvisioningProperties = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *EnvironmentBlueprintSummary) SetUpdatedAt(v time.Time) *EnvironmentBlueprintSummary {
	s.UpdatedAt = &v
	return s
}

// The failure reasons for the environment deployment.
type EnvironmentError struct {
	_ struct{} `type:"structure"`

	// The error code for the failure reason for the environment deployment.
	Code *string `locationName:"code" type:"string"`

	// The error message for the failure reason for the environment deployment.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *EnvironmentError) SetCode(v string) *EnvironmentError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EnvironmentError) SetMessage(v string) *EnvironmentError {
	s.Message = &v
	return s
}

// The parameter details of an evironment profile.
type EnvironmentParameter struct {
	_ struct{} `type:"structure"`

	// The name of an environment profile parameter.
	Name *string `locationName:"name" type:"string"`

	// The value of an environment profile parameter.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentParameter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *EnvironmentParameter) SetName(v string) *EnvironmentParameter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EnvironmentParameter) SetValue(v string) *EnvironmentParameter {
	s.Value = &v
	return s
}

// The details of an environment profile.
type EnvironmentProfileSummary struct {
	_ struct{} `type:"structure"`

	// The identifier of an Amazon Web Services account in which an environment
	// profile exists.
	AwsAccountId *string `locationName:"awsAccountId" type:"string"`

	// The Amazon Web Services Region in which an environment profile exists.
	AwsAccountRegion *string `locationName:"awsAccountRegion" type:"string"`

	// The timestamp of when an environment profile was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon DataZone user who created the environment profile.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The description of the environment profile.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentProfileSummary's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The identifier of the Amazon DataZone domain in which the environment profile
	// exists.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The identifier of a blueprint with which an environment profile is created.
	//
	// EnvironmentBlueprintId is a required field
	EnvironmentBlueprintId *string `locationName:"environmentBlueprintId" type:"string" required:"true"`

	// The identifier of the environment profile.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the environment profile.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentProfileSummary's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The identifier of a project in which an environment profile exists.
	ProjectId *string `locationName:"projectId" type:"string"`

	// The timestamp of when the environment profile was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentProfileSummary) GoString() string {
	return s.String()
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *EnvironmentProfileSummary) SetAwsAccountId(v string) *EnvironmentProfileSummary {
	s.AwsAccountId = &v
	return s
}

// SetAwsAccountRegion sets the AwsAccountRegion field's value.
func (s *EnvironmentProfileSummary) SetAwsAccountRegion(v string) *EnvironmentProfileSummary {
	s.AwsAccountRegion = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EnvironmentProfileSummary) SetCreatedAt(v time.Time) *EnvironmentProfileSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *EnvironmentProfileSummary) SetCreatedBy(v string) *EnvironmentProfileSummary {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EnvironmentProfileSummary) SetDescription(v string) *EnvironmentProfileSummary {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *EnvironmentProfileSummary) SetDomainId(v string) *EnvironmentProfileSummary {
	s.DomainId = &v
	return s
}

// SetEnvironmentBlueprintId sets the EnvironmentBlueprintId field's value.
func (s *EnvironmentProfileSummary) SetEnvironmentBlueprintId(v string) *EnvironmentProfileSummary {
	s.EnvironmentBlueprintId = &v
	return s
}

// SetId sets the Id field's value.
func (s *EnvironmentProfileSummary) SetId(v string) *EnvironmentProfileSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *EnvironmentProfileSummary) SetName(v string) *EnvironmentProfileSummary {
	s.Name = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *EnvironmentProfileSummary) SetProjectId(v string) *EnvironmentProfileSummary {
	s.ProjectId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *EnvironmentProfileSummary) SetUpdatedAt(v time.Time) *EnvironmentProfileSummary {
	s.UpdatedAt = &v
	return s
}

// The details of an environment.
type EnvironmentSummary struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services account in which an environment
	// exists.
	AwsAccountId *string `locationName:"awsAccountId" type:"string"`

	// The Amazon Web Services Region in which an environment exists.
	AwsAccountRegion *string `locationName:"awsAccountRegion" type:"string"`

	// The timestamp of when the environment was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon DataZone user who created the environment.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The description of the environment.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentSummary's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The identifier of the Amazon DataZone domain in which the environment exists.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The identifier of the environment profile with which the environment was
	// created.
	EnvironmentProfileId *string `locationName:"environmentProfileId" type:"string"`

	// The identifier of the environment.
	Id *string `locationName:"id" type:"string"`

	// The name of the environment.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentSummary's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The identifier of the project in which the environment exists.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" type:"string" required:"true"`

	// The provider of the environment.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true"`

	// The status of the environment.
	Status *string `locationName:"status" type:"string" enum:"EnvironmentStatus"`

	// The timestamp of when the environment was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentSummary) GoString() string {
	return s.String()
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *EnvironmentSummary) SetAwsAccountId(v string) *EnvironmentSummary {
	s.AwsAccountId = &v
	return s
}

// SetAwsAccountRegion sets the AwsAccountRegion field's value.
func (s *EnvironmentSummary) SetAwsAccountRegion(v string) *EnvironmentSummary {
	s.AwsAccountRegion = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EnvironmentSummary) SetCreatedAt(v time.Time) *EnvironmentSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *EnvironmentSummary) SetCreatedBy(v string) *EnvironmentSummary {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EnvironmentSummary) SetDescription(v string) *EnvironmentSummary {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *EnvironmentSummary) SetDomainId(v string) *EnvironmentSummary {
	s.DomainId = &v
	return s
}

// SetEnvironmentProfileId sets the EnvironmentProfileId field's value.
func (s *EnvironmentSummary) SetEnvironmentProfileId(v string) *EnvironmentSummary {
	s.EnvironmentProfileId = &v
	return s
}

// SetId sets the Id field's value.
func (s *EnvironmentSummary) SetId(v string) *EnvironmentSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *EnvironmentSummary) SetName(v string) *EnvironmentSummary {
	s.Name = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *EnvironmentSummary) SetProjectId(v string) *EnvironmentSummary {
	s.ProjectId = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *EnvironmentSummary) SetProvider(v string) *EnvironmentSummary {
	s.Provider = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EnvironmentSummary) SetStatus(v string) *EnvironmentSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *EnvironmentSummary) SetUpdatedAt(v time.Time) *EnvironmentSummary {
	s.UpdatedAt = &v
	return s
}

// Specifies whether the value is equal to an expression.
type EqualToExpression struct {
	_ struct{} `type:"structure"`

	// The name of the column.
	//
	// ColumnName is a required field
	ColumnName *string `locationName:"columnName" type:"string" required:"true"`

	// The value that might be equal to an expression.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EqualToExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EqualToExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EqualToExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EqualToExpression"}
	if s.ColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnName"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnName sets the ColumnName field's value.
func (s *EqualToExpression) SetColumnName(v string) *EqualToExpression {
	s.ColumnName = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EqualToExpression) SetValue(v string) *EqualToExpression {
	s.Value = &v
	return s
}

// Specifies the error message that is returned if the operation cannot be successfully
// completed.
type FailureCause struct {
	_ struct{} `type:"structure"`

	// The description of the error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureCause) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureCause) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *FailureCause) SetMessage(v string) *FailureCause {
	s.Message = &v
	return s
}

// A search filter in Amazon DataZone.
type Filter struct {
	_ struct{} `type:"structure"`

	// A search filter attribute in Amazon DataZone.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" min:"1" type:"string" required:"true"`

	// A search filter value in Amazon DataZone.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Attribute != nil && len(*s.Attribute) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attribute", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *Filter) SetAttribute(v string) *Filter {
	s.Attribute = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Filter) SetValue(v string) *Filter {
	s.Value = &v
	return s
}

// A search filter clause in Amazon DataZone.
type FilterClause struct {
	_ struct{} `type:"structure"`

	// The 'and' search filter clause in Amazon DataZone.
	And []*FilterClause `locationName:"and" min:"1" type:"list"`

	// A search filter in Amazon DataZone.
	Filter *Filter `locationName:"filter" type:"structure"`

	// The 'or' search filter clause in Amazon DataZone.
	Or []*FilterClause `locationName:"or" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterClause) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterClause) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilterClause) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FilterClause"}
	if s.And != nil && len(s.And) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("And", 1))
	}
	if s.Or != nil && len(s.Or) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Or", 1))
	}
	if s.And != nil {
		for i, v := range s.And {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "And", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.Or != nil {
		for i, v := range s.Or {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Or", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnd sets the And field's value.
func (s *FilterClause) SetAnd(v []*FilterClause) *FilterClause {
	s.And = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *FilterClause) SetFilter(v *Filter) *FilterClause {
	s.Filter = v
	return s
}

// SetOr sets the Or field's value.
func (s *FilterClause) SetOr(v []*FilterClause) *FilterClause {
	s.Or = v
	return s
}

// A filter expression in Amazon DataZone.
type FilterExpression struct {
	_ struct{} `type:"structure"`

	// The search filter expression.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true"`

	// The search filter explresison type.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FilterExpressionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilterExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FilterExpression"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *FilterExpression) SetExpression(v string) *FilterExpression {
	s.Expression = &v
	return s
}

// SetType sets the Type field's value.
func (s *FilterExpression) SetType(v string) *FilterExpression {
	s.Type = &v
	return s
}

// The details of the form entry.
type FormEntryInput_ struct {
	_ struct{} `type:"structure"`

	// Specifies whether a form entry is required.
	Required *bool `locationName:"required" type:"boolean"`

	// The type ID of the form entry.
	//
	// TypeIdentifier is a required field
	TypeIdentifier *string `locationName:"typeIdentifier" min:"1" type:"string" required:"true"`

	// The type revision of the form entry.
	//
	// TypeRevision is a required field
	TypeRevision *string `locationName:"typeRevision" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormEntryInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormEntryInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FormEntryInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FormEntryInput_"}
	if s.TypeIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeIdentifier"))
	}
	if s.TypeIdentifier != nil && len(*s.TypeIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeIdentifier", 1))
	}
	if s.TypeRevision == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeRevision"))
	}
	if s.TypeRevision != nil && len(*s.TypeRevision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeRevision", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequired sets the Required field's value.
func (s *FormEntryInput_) SetRequired(v bool) *FormEntryInput_ {
	s.Required = &v
	return s
}

// SetTypeIdentifier sets the TypeIdentifier field's value.
func (s *FormEntryInput_) SetTypeIdentifier(v string) *FormEntryInput_ {
	s.TypeIdentifier = &v
	return s
}

// SetTypeRevision sets the TypeRevision field's value.
func (s *FormEntryInput_) SetTypeRevision(v string) *FormEntryInput_ {
	s.TypeRevision = &v
	return s
}

// The details of the form entry.
type FormEntryOutput_ struct {
	_ struct{} `type:"structure"`

	// Specifies whether a form entry is required.
	Required *bool `locationName:"required" type:"boolean"`

	// The name of the type of the form entry.
	//
	// TypeName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FormEntryOutput_'s
	// String and GoString methods.
	//
	// TypeName is a required field
	TypeName *string `locationName:"typeName" min:"1" type:"string" required:"true" sensitive:"true"`

	// The type revision of the form entry.
	//
	// TypeRevision is a required field
	TypeRevision *string `locationName:"typeRevision" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormEntryOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormEntryOutput_) GoString() string {
	return s.String()
}

// SetRequired sets the Required field's value.
func (s *FormEntryOutput_) SetRequired(v bool) *FormEntryOutput_ {
	s.Required = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *FormEntryOutput_) SetTypeName(v string) *FormEntryOutput_ {
	s.TypeName = &v
	return s
}

// SetTypeRevision sets the TypeRevision field's value.
func (s *FormEntryOutput_) SetTypeRevision(v string) *FormEntryOutput_ {
	s.TypeRevision = &v
	return s
}

// The details of a metadata form.
type FormInput_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The content of the metadata form.
	Content *string `locationName:"content" type:"string"`

	// The name of the metadata form.
	//
	// FormName is a required field
	FormName *string `locationName:"formName" min:"1" type:"string" required:"true"`

	// The ID of the metadata form type.
	TypeIdentifier *string `locationName:"typeIdentifier" min:"1" type:"string"`

	// The revision of the metadata form type.
	TypeRevision *string `locationName:"typeRevision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FormInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FormInput_"}
	if s.FormName == nil {
		invalidParams.Add(request.NewErrParamRequired("FormName"))
	}
	if s.FormName != nil && len(*s.FormName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FormName", 1))
	}
	if s.TypeIdentifier != nil && len(*s.TypeIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeIdentifier", 1))
	}
	if s.TypeRevision != nil && len(*s.TypeRevision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TypeRevision", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *FormInput_) SetContent(v string) *FormInput_ {
	s.Content = &v
	return s
}

// SetFormName sets the FormName field's value.
func (s *FormInput_) SetFormName(v string) *FormInput_ {
	s.FormName = &v
	return s
}

// SetTypeIdentifier sets the TypeIdentifier field's value.
func (s *FormInput_) SetTypeIdentifier(v string) *FormInput_ {
	s.TypeIdentifier = &v
	return s
}

// SetTypeRevision sets the TypeRevision field's value.
func (s *FormInput_) SetTypeRevision(v string) *FormInput_ {
	s.TypeRevision = &v
	return s
}

// The details of a metadata form.
type FormOutput_ struct {
	_ struct{} `type:"structure"`

	// The content of the metadata form.
	Content *string `locationName:"content" type:"string"`

	// The name of the metadata form.
	//
	// FormName is a required field
	FormName *string `locationName:"formName" min:"1" type:"string" required:"true"`

	// The name of the metadata form type.
	//
	// TypeName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FormOutput_'s
	// String and GoString methods.
	TypeName *string `locationName:"typeName" min:"1" type:"string" sensitive:"true"`

	// The revision of the metadata form type.
	TypeRevision *string `locationName:"typeRevision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormOutput_) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *FormOutput_) SetContent(v string) *FormOutput_ {
	s.Content = &v
	return s
}

// SetFormName sets the FormName field's value.
func (s *FormOutput_) SetFormName(v string) *FormOutput_ {
	s.FormName = &v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *FormOutput_) SetTypeName(v string) *FormOutput_ {
	s.TypeName = &v
	return s
}

// SetTypeRevision sets the TypeRevision field's value.
func (s *FormOutput_) SetTypeRevision(v string) *FormOutput_ {
	s.TypeRevision = &v
	return s
}

// The details of the metadata form type.
type FormTypeData struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the metadata form type was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon DataZone user who created teh metadata form type.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// The description of the metadata form type.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FormTypeData's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The identifier of the Amazon DataZone domain in which the form type exists.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The imports specified in the form type.
	Imports []*Import `locationName:"imports" min:"1" type:"list"`

	// The model of the form type.
	//
	// Model is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FormTypeData's
	// String and GoString methods.
	Model *Model `locationName:"model" type:"structure" sensitive:"true"`

	// The name of the form type.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FormTypeData's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The identifier of the Amazon DataZone domain in which the form type was originally
	// created.
	OriginDomainId *string `locationName:"originDomainId" type:"string"`

	// The identifier of the project in which the form type was originally created.
	OriginProjectId *string `locationName:"originProjectId" type:"string"`

	// The identifier of the project that owns the form type.
	OwningProjectId *string `locationName:"owningProjectId" type:"string"`

	// The revision of the form type.
	//
	// Revision is a required field
	Revision *string `locationName:"revision" min:"1" type:"string" required:"true"`

	// The status of the form type.
	Status *string `locationName:"status" type:"string" enum:"FormTypeStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormTypeData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FormTypeData) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FormTypeData) SetCreatedAt(v time.Time) *FormTypeData {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *FormTypeData) SetCreatedBy(v string) *FormTypeData {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *FormTypeData) SetDescription(v string) *FormTypeData {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *FormTypeData) SetDomainId(v string) *FormTypeData {
	s.DomainId = &v
	return s
}

// SetImports sets the Imports field's value.
func (s *FormTypeData) SetImports(v []*Import) *FormTypeData {
	s.Imports = v
	return s
}

// SetModel sets the Model field's value.
func (s *FormTypeData) SetModel(v *Model) *FormTypeData {
	s.Model = v
	return s
}

// SetName sets the Name field's value.
func (s *FormTypeData) SetName(v string) *FormTypeData {
	s.Name = &v
	return s
}

// SetOriginDomainId sets the OriginDomainId field's value.
func (s *FormTypeData) SetOriginDomainId(v string) *FormTypeData {
	s.OriginDomainId = &v
	return s
}

// SetOriginProjectId sets the OriginProjectId field's value.
func (s *FormTypeData) SetOriginProjectId(v string) *FormTypeData {
	s.OriginProjectId = &v
	return s
}

// SetOwningProjectId sets the OwningProjectId field's value.
func (s *FormTypeData) SetOwningProjectId(v string) *FormTypeData {
	s.OwningProjectId = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *FormTypeData) SetRevision(v string) *FormTypeData {
	s.Revision = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FormTypeData) SetStatus(v string) *FormTypeData {
	s.Status = &v
	return s
}

type GetAssetFilterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the data asset.
	//
	// AssetIdentifier is a required field
	AssetIdentifier *string `location:"uri" locationName:"assetIdentifier" type:"string" required:"true"`

	// The ID of the domain where you want to get an asset filter.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the asset filter.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssetFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssetFilterInput"}
	if s.AssetIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AssetIdentifier"))
	}
	if s.AssetIdentifier != nil && len(*s.AssetIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssetIdentifier", 1))
	}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssetIdentifier sets the AssetIdentifier field's value.
func (s *GetAssetFilterInput) SetAssetIdentifier(v string) *GetAssetFilterInput {
	s.AssetIdentifier = &v
	return s
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *GetAssetFilterInput) SetDomainIdentifier(v string) *GetAssetFilterInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetAssetFilterInput) SetIdentifier(v string) *GetAssetFilterInput {
	s.Identifier = &v
	return s
}

type GetAssetFilterOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the data asset.
	//
	// AssetId is a required field
	AssetId *string `locationName:"assetId" type:"string" required:"true"`

	// The configuration of the asset filter.
	//
	// Configuration is a required field
	Configuration *AssetFilterConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// The timestamp at which the asset filter was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The description of the asset filter.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetAssetFilterOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the domain where you want to get an asset filter.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The column names of the asset filter.
	EffectiveColumnNames []*string `locationName:"effectiveColumnNames" type:"list"`

	// The row filter of the asset filter.
	EffectiveRowFilter *string `locationName:"effectiveRowFilter" type:"string"`

	// The error message that is displayed if the action does not complete successfully.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The ID of the asset filter.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the asset filter.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetAssetFilterOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The status of the asset filter.
	Status *string `locationName:"status" type:"string" enum:"FilterStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetFilterOutput) GoString() string {
	return s.String()
}

// SetAssetId sets the AssetId field's value.
func (s *GetAssetFilterOutput) SetAssetId(v string) *GetAssetFilterOutput {
	s.AssetId = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *GetAssetFilterOutput) SetConfiguration(v *AssetFilterConfiguration) *GetAssetFilterOutput {
	s.Configuration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetAssetFilterOutput) SetCreatedAt(v time.Time) *GetAssetFilterOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetAssetFilterOutput) SetDescription(v string) *GetAssetFilterOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *GetAssetFilterOutput) SetDomainId(v string) *GetAssetFilterOutput {
	s.DomainId = &v
	return s
}

// SetEffectiveColumnNames sets the EffectiveColumnNames field's value.
func (s *GetAssetFilterOutput) SetEffectiveColumnNames(v []*string) *GetAssetFilterOutput {
	s.EffectiveColumnNames = v
	return s
}

// SetEffectiveRowFilter sets the EffectiveRowFilter field's value.
func (s *GetAssetFilterOutput) SetEffectiveRowFilter(v string) *GetAssetFilterOutput {
	s.EffectiveRowFilter = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *GetAssetFilterOutput) SetErrorMessage(v string) *GetAssetFilterOutput {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetAssetFilterOutput) SetId(v string) *GetAssetFilterOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAssetFilterOutput) SetName(v string) *GetAssetFilterOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetAssetFilterOutput) SetStatus(v string) *GetAssetFilterOutput {
	s.Status = &v
	return s
}

type GetAssetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain to which the asset belongs.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the Amazon DataZone asset.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`

	// The revision of the Amazon DataZone asset.
	Revision *string `location:"querystring" locationName:"revision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssetInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.Revision != nil && len(*s.Revision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Revision", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *GetAssetInput) SetDomainIdentifier(v string) *GetAssetInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetAssetInput) SetIdentifier(v string) *GetAssetInput {
	s.Identifier = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *GetAssetInput) SetRevision(v string) *GetAssetInput {
	s.Revision = &v
	return s
}

type GetAssetOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the asset was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon DataZone user who created the asset.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// The description of the Amazon DataZone asset.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetAssetOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain to which the asset belongs.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The external ID of the asset.
	//
	// ExternalIdentifier is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetAssetOutput's
	// String and GoString methods.
	ExternalIdentifier *string `locationName:"externalIdentifier" min:"1" type:"string" sensitive:"true"`

	// The timestamp of when the first revision of the asset was created.
	FirstRevisionCreatedAt *time.Time `locationName:"firstRevisionCreatedAt" type:"timestamp"`

	// The Amazon DataZone user who created the first revision of the asset.
	FirstRevisionCreatedBy *string `locationName:"firstRevisionCreatedBy" type:"string"`

	// The metadata forms attached to the asset.
	//
	// FormsOutput is a required field
	FormsOutput []*FormOutput_ `locationName:"formsOutput" type:"list" required:"true"`

	// The business glossary terms attached to the asset.
	GlossaryTerms []*string `locationName:"glossaryTerms" min:"1" type:"list"`

	// The ID of the asset.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The latest data point that was imported into the time series form for the
	// asset.
	LatestTimeSeriesDataPointFormsOutput []*TimeSeriesDataPointSummaryFormOutput_ `locationName:"latestTimeSeriesDataPointFormsOutput" type:"list"`

	// The listing of the asset.
	Listing *AssetListingDetails `locationName:"listing" type:"structure"`

	// The name of the asset.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetAssetOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The ID of the project that owns the asset.
	//
	// OwningProjectId is a required field
	OwningProjectId *string `locationName:"owningProjectId" type:"string" required:"true"`

	// The read-only metadata forms attached to the asset.
	ReadOnlyFormsOutput []*FormOutput_ `locationName:"readOnlyFormsOutput" type:"list"`

	// The revision of the asset.
	//
	// Revision is a required field
	Revision *string `locationName:"revision" min:"1" type:"string" required:"true"`

	// The ID of the asset type.
	//
	// TypeIdentifier is a required field
	TypeIdentifier *string `locationName:"typeIdentifier" min:"1" type:"string" required:"true"`

	// The revision of the asset type.
	//
	// TypeRevision is a required field
	TypeRevision *string `locationName:"typeRevision" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetAssetOutput) SetCreatedAt(v time.Time) *GetAssetOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetAssetOutput) SetCreatedBy(v string) *GetAssetOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetAssetOutput) SetDescription(v string) *GetAssetOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *GetAssetOutput) SetDomainId(v string) *GetAssetOutput {
	s.DomainId = &v
	return s
}

// SetExternalIdentifier sets the ExternalIdentifier field's value.
func (s *GetAssetOutput) SetExternalIdentifier(v string) *GetAssetOutput {
	s.ExternalIdentifier = &v
	return s
}

// SetFirstRevisionCreatedAt sets the FirstRevisionCreatedAt field's value.
func (s *GetAssetOutput) SetFirstRevisionCreatedAt(v time.Time) *GetAssetOutput {
	s.FirstRevisionCreatedAt = &v
	return s
}

// SetFirstRevisionCreatedBy sets the FirstRevisionCreatedBy field's value.
func (s *GetAssetOutput) SetFirstRevisionCreatedBy(v string) *GetAssetOutput {
	s.FirstRevisionCreatedBy = &v
	return s
}

// SetFormsOutput sets the FormsOutput field's value.
func (s *GetAssetOutput) SetFormsOutput(v []*FormOutput_) *GetAssetOutput {
	s.FormsOutput = v
	return s
}

// SetGlossaryTerms sets the GlossaryTerms field's value.
func (s *GetAssetOutput) SetGlossaryTerms(v []*string) *GetAssetOutput {
	s.GlossaryTerms = v
	return s
}

// SetId sets the Id field's value.
func (s *GetAssetOutput) SetId(v string) *GetAssetOutput {
	s.Id = &v
	return s
}

// SetLatestTimeSeriesDataPointFormsOutput sets the LatestTimeSeriesDataPointFormsOutput field's value.
func (s *GetAssetOutput) SetLatestTimeSeriesDataPointFormsOutput(v []*TimeSeriesDataPointSummaryFormOutput_) *GetAssetOutput {
	s.LatestTimeSeriesDataPointFormsOutput = v
	return s
}

// SetListing sets the Listing field's value.
func (s *GetAssetOutput) SetListing(v *AssetListingDetails) *GetAssetOutput {
	s.Listing = v
	return s
}

// SetName sets the Name field's value.
func (s *GetAssetOutput) SetName(v string) *GetAssetOutput {
	s.Name = &v
	return s
}

// SetOwningProjectId sets the OwningProjectId field's value.
func (s *GetAssetOutput) SetOwningProjectId(v string) *GetAssetOutput {
	s.OwningProjectId = &v
	return s
}

// SetReadOnlyFormsOutput sets the ReadOnlyFormsOutput field's value.
func (s *GetAssetOutput) SetReadOnlyFormsOutput(v []*FormOutput_) *GetAssetOutput {
	s.ReadOnlyFormsOutput = v
	return s
}

// SetRevision sets the Revision field's value.
func (s *GetAssetOutput) SetRevision(v string) *GetAssetOutput {
	s.Revision = &v
	return s
}

// SetTypeIdentifier sets the TypeIdentifier field's value.
func (s *GetAssetOutput) SetTypeIdentifier(v string) *GetAssetOutput {
	s.TypeIdentifier = &v
	return s
}

// SetTypeRevision sets the TypeRevision field's value.
func (s *GetAssetOutput) SetTypeRevision(v string) *GetAssetOutput {
	s.TypeRevision = &v
	return s
}

type GetAssetTypeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the asset type exists.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the asset type.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" min:"1" type:"string" required:"true"`

	// The revision of the asset type.
	Revision *string `location:"querystring" locationName:"revision" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssetTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssetTypeInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.Revision != nil && len(*s.Revision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Revision", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *GetAssetTypeInput) SetDomainIdentifier(v string) *GetAssetTypeInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetAssetTypeInput) SetIdentifier(v string) *GetAssetTypeInput {
	s.Identifier = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *GetAssetTypeInput) SetRevision(v string) *GetAssetTypeInput {
	s.Revision = &v
	return s
}

type GetAssetTypeOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the asset type was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon DataZone user who created the asset type.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// The description of the asset type.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetAssetTypeOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain in which the asset type exists.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The metadata forms attached to the asset type.
	//
	// FormsOutput is a required field
	FormsOutput map[string]*FormEntryOutput_ `locationName:"formsOutput" type:"map" required:"true"`

	// The name of the asset type.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ID of the Amazon DataZone domain in which the asset type was originally
	// created.
	OriginDomainId *string `locationName:"originDomainId" type:"string"`

	// The ID of the Amazon DataZone project in which the asset type was originally
	// created.
	OriginProjectId *string `locationName:"originProjectId" type:"string"`

	// The ID of the Amazon DataZone project that owns the asset type.
	//
	// OwningProjectId is a required field
	OwningProjectId *string `locationName:"owningProjectId" type:"string" required:"true"`

	// The revision of the asset type.
	//
	// Revision is a required field
	Revision *string `locationName:"revision" min:"1" type:"string" required:"true"`

	// The timestamp of when the asset type was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`

	// The Amazon DataZone user that updated the asset type.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetTypeOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetAssetTypeOutput) SetCreatedAt(v time.Time) *GetAssetTypeOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetAssetTypeOutput) SetCreatedBy(v string) *GetAssetTypeOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetAssetTypeOutput) SetDescription(v string) *GetAssetTypeOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *GetAssetTypeOutput) SetDomainId(v string) *GetAssetTypeOutput {
	s.DomainId = &v
	return s
}

// SetFormsOutput sets the FormsOutput field's value.
func (s *GetAssetTypeOutput) SetFormsOutput(v map[string]*FormEntryOutput_) *GetAssetTypeOutput {
	s.FormsOutput = v
	return s
}

// SetName sets the Name field's value.
func (s *GetAssetTypeOutput) SetName(v string) *GetAssetTypeOutput {
	s.Name = &v
	return s
}

// SetOriginDomainId sets the OriginDomainId field's value.
func (s *GetAssetTypeOutput) SetOriginDomainId(v string) *GetAssetTypeOutput {
	s.OriginDomainId = &v
	return s
}

// SetOriginProjectId sets the OriginProjectId field's value.
func (s *GetAssetTypeOutput) SetOriginProjectId(v string) *GetAssetTypeOutput {
	s.OriginProjectId = &v
	return s
}

// SetOwningProjectId sets the OwningProjectId field's value.
func (s *GetAssetTypeOutput) SetOwningProjectId(v string) *GetAssetTypeOutput {
	s.OwningProjectId = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *GetAssetTypeOutput) SetRevision(v string) *GetAssetTypeOutput {
	s.Revision = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetAssetTypeOutput) SetUpdatedAt(v time.Time) *GetAssetTypeOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetAssetTypeOutput) SetUpdatedBy(v string) *GetAssetTypeOutput {
	s.UpdatedBy = &v
	return s
}

type GetDataSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the data source exists.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the Amazon DataZone data source.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataSourceInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *GetDataSourceInput) SetDomainIdentifier(v string) *GetDataSourceInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetDataSourceInput) SetIdentifier(v string) *GetDataSourceInput {
	s.Identifier = &v
	return s
}

type GetDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The metadata forms attached to the assets created by this data source.
	AssetFormsOutput []*FormOutput_ `locationName:"assetFormsOutput" type:"list"`

	// The configuration of the data source.
	Configuration *DataSourceConfigurationOutput_ `locationName:"configuration" type:"structure"`

	// The timestamp of when the data source was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the data source.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetDataSourceOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the Amazon DataZone domain in which the data source exists.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// Specifies whether this data source is enabled or not.
	EnableSetting *string `locationName:"enableSetting" type:"string" enum:"EnableSetting"`

	// The ID of the environment where this data source creates and publishes assets,
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// Specifies the error message that is returned if the operation cannot be successfully
	// completed.
	ErrorMessage *DataSourceErrorMessage `locationName:"errorMessage" type:"structure"`

	// The ID of the data source.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The number of assets created by the data source during its last run.
	LastRunAssetCount *int64 `locationName:"lastRunAssetCount" type:"integer"`

	// The timestamp of the last run of the data source.
	LastRunAt *time.Time `locationName:"lastRunAt" type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the error message that is returned if the operation cannot be successfully
	// completed.
	LastRunErrorMessage *DataSourceErrorMessage `locationName:"lastRunErrorMessage" type:"structure"`

	// The status of the last run of the data source.
	LastRunStatus *string `locationName:"lastRunStatus" type:"string" enum:"DataSourceRunStatus"`

	// The name of the data source.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetDataSourceOutput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The ID of the project where the data source creates and publishes assets.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" type:"string" required:"true"`

	// Specifies whether the assets that this data source creates in the inventory
	// are to be also automatically published to the catalog.
	PublishOnImport *bool `locationName:"publishOnImport" type:"boolean"`

	// The recommendation configuration of the data source.
	Recommendation *RecommendationConfiguration `locationName:"recommendation" type:"structure"`

	// The schedule of the data source runs.
	//
	// Schedule is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetDataSourceOutput's
	// String and GoString methods.
	Schedule *ScheduleConfiguration `locationName:"schedule" type:"structure" sensitive:"true"`

	// Specifies the status of the self-granting functionality.
	SelfGrantStatus *SelfGrantStatusOutput_ `locationName:"selfGrantStatus" type:"structure"`

	// The status of the data source.
	Status *string `locationName:"status" type:"string" enum:"DataSourceStatus"`

	// The type of the data source.
	Type *string `locationName:"type" min:"1" type:"string"`

	// The timestamp of when the data source was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceOutput) GoString() string {
	return s.String()
}

// SetAssetFormsOutput sets the AssetFormsOutput field's value.
func (s *GetDataSourceOutput) SetAssetFormsOutput(v []*FormOutput_) *GetDataSourceOutput {
	s.AssetFormsOutput = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *GetDataSourceOutput) SetConfiguration(v *DataSourceConfigurationOutput_) *GetDataSourceOutput {
	s.Configuration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetDataSourceOutput) SetCreatedAt(v time.Time) *GetDataSourceOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDataSourceOutput) SetDescription(v string) *GetDataSourceOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *GetDataSourceOutput) SetDomainId(v string) *GetDataSourceOutput {
	s.DomainId = &v
	return s
}

// SetEnableSetting sets the EnableSetting field's value.
func (s *GetDataSourceOutput) SetEnableSetting(v string) *GetDataSourceOutput {
	s.EnableSetting = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetDataSourceOutput) SetEnvironmentId(v string) *GetDataSourceOutput {
	s.EnvironmentId = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *GetDataSourceOutput) SetErrorMessage(v *DataSourceErrorMessage) *GetDataSourceOutput {
	s.ErrorMessage = v
	return s
}

// SetId sets the Id field's value.
func (s *GetDataSourceOutput) SetId(v string) *GetDataSourceOutput {
	s.Id = &v
	return s
}

// SetLastRunAssetCount sets the LastRunAssetCount field's value.
func (s *GetDataSourceOutput) SetLastRunAssetCount(v int64) *GetDataSourceOutput {
	s.LastRunAssetCount = &v
	return s
}

// SetLastRunAt sets the LastRunAt field's value.
func (s *GetDataSourceOutput) SetLastRunAt(v time.Time) *GetDataSourceOutput {
	s.LastRunAt = &v
	return s
}

// SetLastRunErrorMessage sets the LastRunErrorMessage field's value.
func (s *GetDataSourceOutput) SetLastRunErrorMessage(v *DataSourceErrorMessage) *GetDataSourceOutput {
	s.LastRunErrorMessage = v
	return s
}

// SetLastRunStatus sets the LastRunStatus field's value.
func (s *GetDataSourceOutput) SetLastRunStatus(v string) *GetDataSourceOutput {
	s.LastRunStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDataSourceOutput) SetName(v string) *GetDataSourceOutput {
	s.Name = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *GetDataSourceOutput) SetProjectId(v string) *GetDataSourceOutput {
	s.ProjectId = &v
	return s
}

// SetPublishOnImport sets the PublishOnImport field's value.
func (s *GetDataSourceOutput) SetPublishOnImport(v bool) *GetDataSourceOutput {
	s.PublishOnImport = &v
	return s
}

// SetRecommendation sets the Recommendation field's value.
func (s *GetDataSourceOutput) SetRecommendation(v *RecommendationConfiguration) *GetDataSourceOutput {
	s.Recommendation = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *GetDataSourceOutput) SetSchedule(v *ScheduleConfiguration) *GetDataSourceOutput {
	s.Schedule = v
	return s
}

// SetSelfGrantStatus sets the SelfGrantStatus field's value.
func (s *GetDataSourceOutput) SetSelfGrantStatus(v *SelfGrantStatusOutput_) *GetDataSourceOutput {
	s.SelfGrantStatus = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDataSourceOutput) SetStatus(v string) *GetDataSourceOutput {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetDataSourceOutput) SetType(v string) *GetDataSourceOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetDataSourceOutput) SetUpdatedAt(v time.Time) *GetDataSourceOutput {
	s.UpdatedAt = &v
	return s
}

type GetDataSourceRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the domain in which this data source run was performed.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the data source run.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataSourceRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataSourceRunInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *GetDataSourceRunInput) SetDomainIdentifier(v string) *GetDataSourceRunInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetDataSourceRunInput) SetIdentifier(v string) *GetDataSourceRunInput {
	s.Identifier = &v
	return s
}

type GetDataSourceRunOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the data source run was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The configuration snapshot of the data source run.
	DataSourceConfigurationSnapshot *string `locationName:"dataSourceConfigurationSnapshot" type:"string"`

	// The ID of the data source for this data source run.
	//
	// DataSourceId is a required field
	DataSourceId *string `locationName:"dataSourceId" type:"string" required:"true"`

	// The ID of the domain in which this data source run was performed.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// Specifies the error message that is returned if the operation cannot be successfully
	// completed.
	ErrorMessage *DataSourceErrorMessage `locationName:"errorMessage" type:"structure"`

	// The ID of the data source run.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The ID of the project in which this data source run occured.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" type:"string" required:"true"`

	// The asset statistics from this data source run.
	RunStatisticsForAssets *RunStatisticsForAssets `locationName:"runStatisticsForAssets" type:"structure"`

	// The timestamp of when this data source run started.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The status of this data source run.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DataSourceRunStatus"`

	// The timestamp of when this data source run stopped.
	StoppedAt *time.Time `locationName:"stoppedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The type of this data source run.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DataSourceRunType"`

	// The timestamp of when this data source run was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceRunOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetDataSourceRunOutput) SetCreatedAt(v time.Time) *GetDataSourceRunOutput {
	s.CreatedAt = &v
	return s
}

// SetDataSourceConfigurationSnapshot sets the DataSourceConfigurationSnapshot field's value.
func (s *GetDataSourceRunOutput) SetDataSourceConfigurationSnapshot(v string) *GetDataSourceRunOutput {
	s.DataSourceConfigurationSnapshot = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *GetDataSourceRunOutput) SetDataSourceId(v string) *GetDataSourceRunOutput {
	s.DataSourceId = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *GetDataSourceRunOutput) SetDomainId(v string) *GetDataSourceRunOutput {
	s.DomainId = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *GetDataSourceRunOutput) SetErrorMessage(v *DataSourceErrorMessage) *GetDataSourceRunOutput {
	s.ErrorMessage = v
	return s
}

// SetId sets the Id field's value.
func (s *GetDataSourceRunOutput) SetId(v string) *GetDataSourceRunOutput {
	s.Id = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *GetDataSourceRunOutput) SetProjectId(v string) *GetDataSourceRunOutput {
	s.ProjectId = &v
	return s
}

// SetRunStatisticsForAssets sets the RunStatisticsForAssets field's value.
func (s *GetDataSourceRunOutput) SetRunStatisticsForAssets(v *RunStatisticsForAssets) *GetDataSourceRunOutput {
	s.RunStatisticsForAssets = v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *GetDataSourceRunOutput) SetStartedAt(v time.Time) *GetDataSourceRunOutput {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDataSourceRunOutput) SetStatus(v string) *GetDataSourceRunOutput {
	s.Status = &v
	return s
}

// SetStoppedAt sets the StoppedAt field's value.
func (s *GetDataSourceRunOutput) SetStoppedAt(v time.Time) *GetDataSourceRunOutput {
	s.StoppedAt = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetDataSourceRunOutput) SetType(v string) *GetDataSourceRunOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetDataSourceRunOutput) SetUpdatedAt(v time.Time) *GetDataSourceRunOutput {
	s.UpdatedAt = &v
	return s
}

type GetDomainInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the specified Amazon DataZone domain.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetDomainInput) SetIdentifier(v string) *GetDomainInput {
	s.Identifier = &v
	return s
}

type GetDomainOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the specified Amazon DataZone domain.
	Arn *string `locationName:"arn" type:"string"`

	// The timestamp of when the Amazon DataZone domain was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The description of the Amazon DataZone domain.
	Description *string `locationName:"description" type:"string"`

	// The domain execution role with which the Amazon DataZone domain is created.
	//
	// DomainExecutionRole is a required field
	DomainExecutionRole *string `locationName:"domainExecutionRole" type:"string" required:"true"`

	// The identifier of the specified Amazon DataZone domain.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The identifier of the Amazon Web Services Key Management Service (KMS) key
	// that is used to encrypt the Amazon DataZone domain, metadata, and reporting
	// data.
	KmsKeyIdentifier *string `locationName:"kmsKeyIdentifier" min:"1" type:"string"`

	// The timestamp of when the Amazon DataZone domain was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the Amazon DataZone domain.
	Name *string `locationName:"name" type:"string"`

	// The URL of the data portal for this Amazon DataZone domain.
	PortalUrl *string `locationName:"portalUrl" type:"string"`

	// The single sing-on option of the specified Amazon DataZone domain.
	SingleSignOn *SingleSignOn `locationName:"singleSignOn" type:"structure"`

	// The status of the specified Amazon DataZone domain.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DomainStatus"`

	// The tags specified for the Amazon DataZone domain.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetDomainOutput) SetArn(v string) *GetDomainOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetDomainOutput) SetCreatedAt(v time.Time) *GetDomainOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDomainOutput) SetDescription(v string) *GetDomainOutput {
	s.Description = &v
	return s
}

// SetDomainExecutionRole sets the DomainExecutionRole field's value.
func (s *GetDomainOutput) SetDomainExecutionRole(v string) *GetDomainOutput {
	s.DomainExecutionRole = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetDomainOutput) SetId(v string) *GetDomainOutput {
	s.Id = &v
	return s
}

// SetKmsKeyIdentifier sets the KmsKeyIdentifier field's value.
func (s *GetDomainOutput) SetKmsKeyIdentifier(v string) *GetDomainOutput {
	s.KmsKeyIdentifier = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetDomainOutput) SetLastUpdatedAt(v time.Time) *GetDomainOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDomainOutput) SetName(v string) *GetDomainOutput {
	s.Name = &v
	return s
}

// SetPortalUrl sets the PortalUrl field's value.
func (s *GetDomainOutput) SetPortalUrl(v string) *GetDomainOutput {
	s.PortalUrl = &v
	return s
}

// SetSingleSignOn sets the SingleSignOn field's value.
func (s *GetDomainOutput) SetSingleSignOn(v *SingleSignOn) *GetDomainOutput {
	s.SingleSignOn = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDomainOutput) SetStatus(v string) *GetDomainOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDomainOutput) SetTags(v map[string]*string) *GetDomainOutput {
	s.Tags = v
	return s
}

type GetEnvironmentActionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain in which the GetEnvironmentAction API
	// is invoked.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The environment ID of the environment action.
	//
	// EnvironmentIdentifier is a required field
	EnvironmentIdentifier *string `location:"uri" locationName:"environmentIdentifier" type:"string" required:"true"`

	// The ID of the environment action
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnvironmentActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnvironmentActionInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EnvironmentIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIdentifier"))
	}
	if s.EnvironmentIdentifier != nil && len(*s.EnvironmentIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *GetEnvironmentActionInput) SetDomainIdentifier(v string) *GetEnvironmentActionInput {
	s.DomainIdentifier = &v
	return s
}

// SetEnvironmentIdentifier sets the EnvironmentIdentifier field's value.
func (s *GetEnvironmentActionInput) SetEnvironmentIdentifier(v string) *GetEnvironmentActionInput {
	s.EnvironmentIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetEnvironmentActionInput) SetIdentifier(v string) *GetEnvironmentActionInput {
	s.Identifier = &v
	return s
}

type GetEnvironmentActionOutput struct {
	_ struct{} `type:"structure"`

	// The description of the environment action.
	Description *string `locationName:"description" type:"string"`

	// The ID of the Amazon DataZone domain in which the environment action lives.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The environment ID of the environment action.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// The ID of the environment action.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the environment action.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The parameters of the environment action.
	//
	// Parameters is a required field
	Parameters *ActionParameters `locationName:"parameters" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentActionOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GetEnvironmentActionOutput) SetDescription(v string) *GetEnvironmentActionOutput {
	s.Description = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *GetEnvironmentActionOutput) SetDomainId(v string) *GetEnvironmentActionOutput {
	s.DomainId = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *GetEnvironmentActionOutput) SetEnvironmentId(v string) *GetEnvironmentActionOutput {
	s.EnvironmentId = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetEnvironmentActionOutput) SetId(v string) *GetEnvironmentActionOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetEnvironmentActionOutput) SetName(v string) *GetEnvironmentActionOutput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetEnvironmentActionOutput) SetParameters(v *ActionParameters) *GetEnvironmentActionOutput {
	s.Parameters = v
	return s
}

type GetEnvironmentBlueprintConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain where this blueprint exists.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// He ID of the blueprint.
	//
	// EnvironmentBlueprintIdentifier is a required field
	EnvironmentBlueprintIdentifier *string `location:"uri" locationName:"environmentBlueprintIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentBlueprintConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentBlueprintConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnvironmentBlueprintConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnvironmentBlueprintConfigurationInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.EnvironmentBlueprintIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentBlueprintIdentifier"))
	}
	if s.EnvironmentBlueprintIdentifier != nil && len(*s.EnvironmentBlueprintIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentBlueprintIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *GetEnvironmentBlueprintConfigurationInput) SetDomainIdentifier(v string) *GetEnvironmentBlueprintConfigurationInput {
	s.DomainIdentifier = &v
	return s
}

// SetEnvironmentBlueprintIdentifier sets the EnvironmentBlueprintIdentifier field's value.
func (s *GetEnvironmentBlueprintConfigurationInput) SetEnvironmentBlueprintIdentifier(v string) *GetEnvironmentBlueprintConfigurationInput {
	s.EnvironmentBlueprintIdentifier = &v
	return s
}

type GetEnvironmentBlueprintConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when this blueprint was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The ID of the Amazon DataZone domain where this blueprint exists.
	//
	// DomainId is a required field
	DomainId *string `locationName:"domainId" type:"string" required:"true"`

	// The Amazon Web Services regions in which this blueprint is enabled.
	EnabledRegions []*string `locationName:"enabledRegions" type:"list"`

	// The ID of the blueprint.
	//
	// EnvironmentBlueprintId is a required field
	EnvironmentBlueprintId *string `locationName:"environmentBlueprintId" type:"string" required:"true"`

	// The ARN of the manage access role with which this blueprint is created.
	ManageAccessRoleArn *string `locationName:"manageAccessRoleArn" type:"string"`

	// The provisioning configuration of a blueprint.
	ProvisioningConfigurations []*ProvisioningConfiguration `locationName:"provisioningConfigurations" type:"list"`

	// The ARN of the provisioning role with which this blueprint is created.
	ProvisioningRoleArn *string `locationName:"provisioningRoleArn" type:"string"`

	// The regional parameters of the blueprint.
	RegionalParameters map[string]map[string]*string `locationName:"regionalParameters" type:"map"`

	// The timestamp of when this blueprint was upated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentBlueprintConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentBlueprintConfigurationOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetEnvironmentBlueprintConfigurationOutput) SetCreatedAt(v time.Time) *GetEnvironmentBlueprintConfigurationOutput {
	s.CreatedAt = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *GetEnvironmentBlueprintConfigurationOutput) SetDomainId(v string) *GetEnvironmentBlueprintConfigurationOutput {
	s.DomainId = &v
	return s
}

// SetEnabledRegions sets the EnabledRegions field's value.
func (s *GetEnvironmentBlueprintConfigurationOutput) SetEnabledRegions(v []*string) *GetEnvironmentBlueprintConfigurationOutput {
	s.EnabledRegions = v
	return s
}

// SetEnvironmentBlueprintId sets the EnvironmentBlueprintId field's value.
func (s *GetEnvironmentBlueprintConfigurationOutput) SetEnvironmentBlueprintId(v string) *GetEnvironmentBlueprintConfigurationOutput {
	s.EnvironmentBlueprintId = &v
	return s
}

// SetManageAccessRoleArn sets the ManageAccessRoleArn field's value.
func (s *GetEnvironmentBlueprintConfigurationOutput) SetManageAccessRoleArn(v string) *GetEnvironmentBlueprintConfigurationOutput {
	s.ManageAccessRoleArn = &v
	return s
}

// SetProvisioningConfigurations sets the ProvisioningConfigurations field's value.
func (s *GetEnvironmentBlueprintConfigurationOutput) SetProvisioningConfigurations(v []*ProvisioningConfiguration) *GetEnvironmentBlueprintConfigurationOutput {
	s.ProvisioningConfigurations = v
	return s
}

// SetProvisioningRoleArn sets the ProvisioningRoleArn field's value.
func (s *GetEnvironmentBlueprintConfigurationOutput) SetProvisioningRoleArn(v string) *GetEnvironmentBlueprintConfigurationOutput {
	s.ProvisioningRoleArn = &v
	return s
}

// SetRegionalParameters sets the RegionalParameters field's value.
func (s *GetEnvironmentBlueprintConfigurationOutput) SetRegionalParameters(v map[string]map[string]*string) *GetEnvironmentBlueprintConfigurationOutput {
	s.RegionalParameters = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetEnvironmentBlueprintConfigurationOutput) SetUpdatedAt(v time.Time) *GetEnvironmentBlueprintConfigurationOutput {
	s.UpdatedAt = &v
	return s
}

type GetEnvironmentBlueprintInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the domain in which this blueprint exists.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of this Amazon DataZone blueprint.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentBlueprintInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentBlueprintInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnvironmentBlueprintInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnvironmentBlueprintInput"}
	if s.DomainIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainIdentifier"))
	}
	if s.DomainIdentifier != nil && len(*s.DomainIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainIdentifier", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainIdentifier sets the DomainIdentifier field's value.
func (s *GetEnvironmentBlueprintInput) SetDomainIdentifier(v string) *GetEnvironmentBlueprintInput {
	s.DomainIdentifier = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetEnvironmentBlueprintInput) SetIdentifier(v string) *GetEnvironmentBlueprintInput {
	s.Identifier = &v
	return s
}

type GetEnvironmentBlueprintOutput struct {
	_ struct{} `type:"structure"`

	// A timestamp of when this blueprint was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The deployment properties of this Amazon DataZone blueprint.
	DeploymentProperties *DeploymentProperties `locationName:"deploymentProperties" type:"structure"`

	// The description of this Amazon DataZone blueprint.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetEnvironmentBlueprintOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The glossary terms attached to this Amazon DataZone blueprint.
	GlossaryTerms []*string `locationName:"glossaryTerms" min:"1" type:"list"`

	// The ID of this Amazon DataZone blueprint.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of this Amazon DataZone blueprint.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The provider of this Amazon DataZone blueprint.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true"`

	// The provisioning properties of this Amazon DataZone blueprint.
	//
	// ProvisioningProperties is a required field
	ProvisioningProperties *ProvisioningProperties `locationName:"provisioningProperties" type:"structure" required:"true"`

	// The timestamp of when this blueprint was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user parameters of this blueprint.
	UserParameters []*CustomParameter `locationName:"userParameters" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentBlueprintOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentBlueprintOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetEnvironmentBlueprintOutput) SetCreatedAt(v time.Time) *GetEnvironmentBlueprintOutput {
	s.CreatedAt = &v
	return s
}

// SetDeploymentProperties sets the DeploymentProperties field's value.
func (s *GetEnvironmentBlueprintOutput) SetDeploymentProperties(v *DeploymentProperties) *GetEnvironmentBlueprintOutput {
	s.DeploymentProperties = v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetEnvironmentBlueprintOutput) SetDescription(v string) *GetEnvironmentBlueprintOutput {
	s.Description = &v
	return s
}

// SetGlossaryTerms sets the GlossaryTerms field's value.
func (s *GetEnvironmentBlueprintOutput) SetGlossaryTerms(v []*string) *GetEnvironmentBlueprintOutput {
	s.GlossaryTerms = v
	return s
}

// SetId sets the Id field's value.
func (s *GetEnvironmentBlueprintOutput) SetId(v string) *GetEnvironmentBlueprintOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetEnvironmentBlueprintOutput) SetName(v string) *GetEnvironmentBlueprintOutput {
	s.Name = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *GetEnvironmentBlueprintOutput) SetProvider(v string) *GetEnvironmentBlueprintOutput {
	s.Provider = &v
	return s
}

// SetProvisioningProperties sets the ProvisioningProperties field's value.
func (s *GetEnvironmentBlueprintOutput) SetProvisioningProperties(v *ProvisioningProperties) *GetEnvironmentBlueprintOutput {
	s.ProvisioningProperties = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetEnvironmentBlueprintOutput) SetUpdatedAt(v time.Time) *GetEnvironmentBlueprintOutput {
	s.UpdatedAt = &v
	return s
}

// SetUserParameters sets the UserParameters field's value.
func (s *GetEnvironmentBlueprintOutput) SetUserParameters(v []*CustomParameter) *GetEnvironmentBlueprintOutput {
	s.UserParameters = v
	return s
}

type GetEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Amazon DataZone domain where the environment exists.
	//
	// DomainIdentifier is a required field
	DomainIdentifier *string `location:"uri" locationName:"domainIdentifier" type:"string" required:"true"`

	// The ID of the Amazon DataZone environment.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: