/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.mvel.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.MissingFormatArgumentException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.files.MPPPath;
import org.islandoftex.arara.core.localization.LanguageController;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J!\u0010\t\u001a\u00020\b2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\fJ$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eH\u0007J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0004H\u0007\u00a8\u0006\u0014"}, d2={"Lorg/islandoftex/arara/mvel/utils/MethodUtils;", "", "()V", "checkRegex", "", "file", "Lorg/islandoftex/arara/api/files/MPPPath;", "regex", "", "generateString", "objects", "", "([Ljava/lang/Object;)Ljava/lang/String;", "replicateList", "", "pattern", "values", "writeToFile", "text", "append", "mvel"})
@SourceDebugExtension(value={"SMAP\nMethodUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodUtils.kt\norg/islandoftex/arara/mvel/utils/MethodUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n11065#2:103\n11400#2,3:104\n766#3:107\n857#3,2:108\n1549#3:110\n1620#3,3:111\n*S KotlinDebug\n*F\n+ 1 MethodUtils.kt\norg/islandoftex/arara/mvel/utils/MethodUtils\n*L\n49#1:103\n49#1:104,3\n49#1:107\n49#1:108,2\n70#1:110\n70#1:111,3\n*E\n"})
public final class MethodUtils {
    @NotNull
    public static final MethodUtils INSTANCE = new MethodUtils();

    private MethodUtils() {
    }

    @JvmStatic
    public static final boolean checkRegex(@NotNull MPPPath file, @NotNull String regex) throws AraraException {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(regex, "regex");
        try {
            String text2 = file.readText();
            Regex pattern = new Regex(regex);
            return pattern.containsMatchIn(text2);
        }
        catch (IOException exception) {
            String string = LanguageController.getMessages().getERROR_CHECKREGEX_IO_EXCEPTION();
            Object[] objectArray = new Object[]{file.getFileName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
            throw new AraraException(string2, exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String generateString(Object ... objects) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(objects, "objects");
        Object[] $this$map$iv = objects;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Object> replicateList(@NotNull String pattern, @NotNull List<? extends Object> values2) throws AraraException {
        List list;
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Intrinsics.checkNotNullParameter(values2, "values");
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = values2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = pattern;
                Object[] objectArray = new Object[]{it};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
                collection.add(string2);
            }
            list = (List)destination$iv$iv;
        }
        catch (MissingFormatArgumentException exception) {
            throw new AraraException(LanguageController.getMessages().getERROR_REPLICATELIST_MISSING_FORMAT_ARGUMENTS_EXCEPTION(), exception);
        }
        return list;
    }

    @JvmStatic
    public static final boolean writeToFile(@NotNull MPPPath file, @NotNull String text2, boolean append) {
        boolean bl;
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(text2, "text");
        try {
            file.writeText(text2, append);
            bl = true;
        }
        catch (IOException _) {
            bl = false;
        }
        return bl;
    }
}

