import React from 'react';
import { MessageExample } from './MessageExample';
import { Href, Markdown, Schema, Bindings, Tags, Extensions, } from '../../components';
import { useConfig } from '../../contexts';
import { CommonHelpers } from '../../helpers';
import { CONTENT_TYPES_SITE, EXTERAL_DOCUMENTATION_TEXT, } from '../../constants';
export var Message = function (_a) {
    var message = _a.message, messageName = _a.messageName, index = _a.index, _b = _a.showExamples, showExamples = _b === void 0 ? false : _b;
    var config = useConfig();
    if (!message) {
        return null;
    }
    var messageId = typeof message.id === 'function' && message.id();
    var title = message.title();
    var summary = message.summary();
    var payload = message.payload();
    var headers = message.headers();
    var correlationId = message.correlationId();
    var contentType = message.contentType();
    var externalDocs = message.externalDocs();
    var showInfoList = contentType !== null && contentType !== void 0 ? contentType : externalDocs;
    return (React.createElement("div", { className: "panel-item" },
        React.createElement("div", { className: "panel-item--center px-8" },
            React.createElement("div", { className: "shadow rounded bg-gray-200 p-4 border" },
                React.createElement("div", null,
                    index !== undefined && (React.createElement("strong", { className: "text-gray-700 mr-2" },
                        "#",
                        index)),
                    title && React.createElement("span", { className: "text-gray-700 mr-2" }, title)),
                summary && React.createElement("p", { className: "text-gray-600 text-sm" }, summary),
                showInfoList && (React.createElement("ul", { className: "leading-normal mt-2 mb-4 space-x-2 space-y-2" },
                    contentType && (React.createElement("li", { className: "inline-block" },
                        React.createElement(Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: "".concat(CONTENT_TYPES_SITE, "/").concat(contentType) },
                            React.createElement("span", null, contentType)))),
                    externalDocs && (React.createElement("li", { className: "inline-block" },
                        React.createElement(Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: externalDocs.url() },
                            React.createElement("span", null, EXTERAL_DOCUMENTATION_TEXT)))))),
                messageId && (React.createElement("div", { className: "border bg-gray-100 rounded px-4 py-2 mt-2" },
                    React.createElement("div", { className: "text-sm text-gray-700" },
                        "Message ID",
                        React.createElement("span", { className: "bg-orange-600 text-white rounded text-xs ml-2 py-0 px-2" }, messageId)))),
                correlationId && (React.createElement("div", { className: "border bg-gray-100 rounded px-4 py-2 mt-2" },
                    React.createElement("div", { className: "text-sm text-gray-700" },
                        "Correlation ID",
                        React.createElement("span", { className: "bg-orange-600 text-white rounded text-xs ml-2 py-0 px-2" }, correlationId.location())),
                    correlationId.hasDescription() && (React.createElement("div", { className: "mt-2" },
                        React.createElement(Markdown, null, correlationId.description()))))),
                message.hasDescription() && (React.createElement("div", { className: "mt-2" },
                    React.createElement(Markdown, null, message.description()))),
                payload && (React.createElement("div", { className: "mt-2", id: messageName
                        ? CommonHelpers.getIdentifier("message-".concat(messageName, "-payload"), config)
                        : undefined },
                    React.createElement(Schema, { schemaName: "Payload", schema: payload }))),
                headers && (React.createElement("div", { className: "mt-2", id: messageName
                        ? CommonHelpers.getIdentifier("message-".concat(messageName, "-headers"), config)
                        : undefined },
                    React.createElement(Schema, { schemaName: "Headers", schema: headers }))),
                message.bindings().length > 0 && (React.createElement("div", { className: "mt-2" },
                    React.createElement(Bindings, { name: "Message specific information", bindings: message.bindings() }))),
                React.createElement(Extensions, { item: message }),
                message.tags().length > 0 && (React.createElement("div", { className: "mt-2" },
                    React.createElement(Tags, { tags: message.tags() }))))),
        showExamples && (React.createElement("div", { className: "panel-item--right px-8" },
            React.createElement(MessageExample, { message: message })))));
};
//# sourceMappingURL=Message.js.map