/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl;

import com.intellij.util.text.EditDistance;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0001\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u00a8\u0006\n"}, d2={"calculateSimilarity", "", "", "other", "limitLengthRatio", "cumulativeSum", "", "randomPass", "", "probability", "intellij.fullLine.core.completion"})
public final class CoreUtilsKt {
    public static final double calculateSimilarity(@NotNull String $this$calculateSimilarity, @NotNull String other, double limitLengthRatio) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateSimilarity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int maxLength = Math.max($this$calculateSimilarity.length(), Math.max(other.length(), 1));
        int limit = (int)((double)maxLength * limitLengthRatio);
        double editDistance = EditDistance.optimalAlignment((CharSequence)$this$calculateSimilarity, (CharSequence)other, (boolean)true, (int)limit);
        if (editDistance > (double)limit) {
            return 0.0;
        }
        double editDistanceNormalized = editDistance / (double)maxLength;
        return 1.0 - editDistanceNormalized;
    }

    public static /* synthetic */ double calculateSimilarity$default(String string, String string2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        return CoreUtilsKt.calculateSimilarity(string, string2, d);
    }

    @NotNull
    public static final double[] cumulativeSum(@NotNull double[] $this$cumulativeSum) {
        Intrinsics.checkNotNullParameter((Object)$this$cumulativeSum, (String)"<this>");
        double[] result2 = new double[$this$cumulativeSum.length];
        if (result2.length == 0) {
            return result2;
        }
        result2[0] = $this$cumulativeSum[0];
        int n = $this$cumulativeSum.length;
        for (int i = 1; i < n; ++i) {
            result2[i] = result2[i - 1] + $this$cumulativeSum[i];
        }
        return result2;
    }

    public static final boolean randomPass(double probability) {
        return probability >= 1.0 || probability > 0.0 && Random.Default.nextDouble() < probability;
    }
}

