/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.openapi.application.PathManager;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"MAX_LOG_FILE_COUNT", "", "LOG_FILENAME_SUFFIX_FORMAT", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "Ljava/time/format/DateTimeFormatter;", "LOG_PATH_DIR", "Ljava/nio/file/Path;", "millisToDate", "Ljava/time/LocalDateTime;", "millis", "", "intellij.javascript.impl"})
public final class MessageStreamLoggerServiceKt {
    private static final int MAX_LOG_FILE_COUNT = 5;
    private static final DateTimeFormatter LOG_FILENAME_SUFFIX_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss-SSS");
    @NotNull
    private static final Path LOG_PATH_DIR;

    @NotNull
    public static final LocalDateTime millisToDate(long millis) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofInstant(...)");
        return localDateTime;
    }

    public static final /* synthetic */ DateTimeFormatter access$getLOG_FILENAME_SUFFIX_FORMAT$p() {
        return LOG_FILENAME_SUFFIX_FORMAT;
    }

    public static final /* synthetic */ Path access$getLOG_PATH_DIR$p() {
        return LOG_PATH_DIR;
    }

    static {
        Path path2 = Path.of(PathManager.getLogPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        Path path3 = path2;
        Path path4 = path3.resolve("services");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        LOG_PATH_DIR = path4;
    }
}

