/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.usageView.UsageInfo;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CssDuplocateVisitor
implements DuplocateVisitor {
    private final Map<IntSet, MyDuplicateData> duplicatesMap = new HashMap<IntSet, MyDuplicateData>();
    private final Int2ObjectMap<List<CssDeclaration>> cache = new Int2ObjectOpenHashMap();
    private final FragmentsCollector myCollector;
    private final int myLowerBound;

    public CssDuplocateVisitor(FragmentsCollector collector, int lowerBound) {
        this.myCollector = collector;
        this.myLowerBound = lowerBound;
    }

    private static int cache(Int2ObjectMap<List<CssDeclaration>> cache, @NotNull CssDeclaration element) {
        ArrayList<CssDeclaration> elements;
        if (element == null) {
            CssDuplocateVisitor.$$$reportNull$$$0(0);
        }
        int hash = CssPsiUtil.hashCodeForElement(element);
        if (cache == null) {
            cache = new Int2ObjectOpenHashMap();
        }
        if ((elements = (ArrayList<CssDeclaration>)cache.get(hash)) == null) {
            elements = new ArrayList<CssDeclaration>();
            cache.put(hash, elements);
        }
        elements.add(element);
        return hash;
    }

    private static IntSet intersect(IntSet s1, IntSet s2) {
        IntOpenHashSet result = new IntOpenHashSet();
        IntIterator it = s1.iterator();
        while (it.hasNext()) {
            int n = it.nextInt();
            if (!s2.contains(n)) continue;
            result.add(n);
        }
        return result;
    }

    private static void addDuplicate(Map<IntSet, MyDuplicateData> duplicatesMap, MyDuplicateData duplicateData) {
        MyDuplicateData concurrent = duplicatesMap.get(duplicateData.myDeclarationHashes);
        if (concurrent == null || concurrent.myBlocks.size() < duplicateData.myBlocks.size()) {
            duplicatesMap.put(duplicateData.myDeclarationHashes, duplicateData);
        }
    }

    private void addNewDuplicates(CssBlock block, IntSet declarationHashes, Map<IntSet, MyDuplicateData> duplicatesMap) {
        boolean addTrivialDuplicate = true;
        ArrayList<MyDuplicateData> newDuplicateDataList = new ArrayList<MyDuplicateData>();
        for (MyDuplicateData duplicateData : duplicatesMap.values()) {
            IntSet candidateDeclHashes = CssDuplocateVisitor.intersect(declarationHashes, duplicateData.myDeclarationHashes);
            int n = candidateDeclHashes.size();
            if (n < this.myLowerBound) continue;
            if (n == declarationHashes.size()) {
                addTrivialDuplicate = false;
            }
            MyDuplicateData newDuplicateData = new MyDuplicateData();
            newDuplicateData.myDeclarationHashes = candidateDeclHashes;
            newDuplicateData.myBlocks = new HashSet<CssBlock>(duplicateData.myBlocks);
            newDuplicateData.myBlocks.add(block);
            newDuplicateDataList.add(newDuplicateData);
        }
        if (addTrivialDuplicate) {
            CssDuplocateVisitor.addDuplicate(duplicatesMap, new MyDuplicateData(block, declarationHashes));
        }
        for (MyDuplicateData newDuplicateData : newDuplicateDataList) {
            CssDuplocateVisitor.addDuplicate(duplicatesMap, newDuplicateData);
        }
    }

    private void addPattern(Collection<List<CssDeclaration>> pattern, int hash) {
        ArrayList<PsiFragment> fragmentList = new ArrayList<PsiFragment>();
        for (List<CssDeclaration> block : pattern) {
            block.sort(Comparator.comparingInt(PsiElement::getTextOffset));
            PsiFragment fragment = new PsiFragment(block){

                public boolean isEqual(PsiElement[] elements, int discardCost) {
                    return true;
                }

                public UsageInfo getUsageInfo() {
                    PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement[])this.getElements());
                    PsiElement ruleset = PsiTreeUtil.getParentOfType((PsiElement)(parent = PsiTreeUtil.getParentOfType((PsiElement)parent, CssBlock.class, (boolean)false)), CssRuleset.class, (boolean)false);
                    if (ruleset != null) {
                        parent = ruleset;
                    }
                    return parent != null ? new UsageInfo(parent) : null;
                }
            };
            fragmentList.add(fragment);
        }
        fragmentList.sort(Comparator.comparingInt(PsiFragment::getStartOffset));
        PsiFragment[] fragments = fragmentList.toArray(new PsiFragment[0]);
        PsiFragment first = fragments[0];
        int cost = first.getElements().length;
        for (PsiFragment fragment : fragments) {
            this.myCollector.add(hash, cost, fragment);
        }
    }

    public void visitNode(@NotNull PsiElement node) {
        PsiFile file;
        if (node == null) {
            CssDuplocateVisitor.$$$reportNull$$$0(1);
        }
        if ((file = node.getContainingFile()) instanceof StylesheetFile || file instanceof XmlFile) {
            file.accept((PsiElementVisitor)new CssElementVisitor(){

                @Override
                public void visitCssBlock(CssBlock block) {
                    CssDeclaration[] declarations = block.getDeclarations();
                    if (declarations.length >= CssDuplocateVisitor.this.myLowerBound) {
                        IntOpenHashSet blockHashes = new IntOpenHashSet();
                        for (CssDeclaration declaration : declarations) {
                            int declarationHash = CssDuplocateVisitor.cache(CssDuplocateVisitor.this.cache, declaration);
                            blockHashes.add(declarationHash);
                        }
                        CssDuplocateVisitor.this.addNewDuplicates(block, (IntSet)blockHashes, CssDuplocateVisitor.this.duplicatesMap);
                    }
                    block.acceptChildren(this);
                }

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    element.acceptChildren((PsiElementVisitor)this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dupLocator/CssDuplocateVisitor$2", "visitElement"));
                }
            });
        }
    }

    public void hashingFinished() {
        ApplicationManager.getApplication().runReadAction(() -> {
            for (MyDuplicateData duplicateData : this.duplicatesMap.values()) {
                if (duplicateData.isTrivial()) continue;
                HashMap<CssBlock, List> rulesets2declarations = new HashMap<CssBlock, List>();
                IntIterator it = duplicateData.myDeclarationHashes.iterator();
                while (it.hasNext()) {
                    int hash = it.nextInt();
                    for (CssDeclaration declaration : (List)this.cache.get(hash)) {
                        CssBlock ruleset = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)declaration, CssBlock.class);
                        assert (ruleset != null);
                        if (!duplicateData.myBlocks.contains(ruleset)) continue;
                        rulesets2declarations.computeIfAbsent(ruleset, k -> new ArrayList()).add(declaration);
                    }
                }
                this.addPattern(rulesets2declarations.values(), duplicateData.myDeclarationHashes.hashCode());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/CssDuplocateVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "cache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyDuplicateData {
        Set<CssBlock> myBlocks;
        IntSet myDeclarationHashes;

        MyDuplicateData() {
        }

        boolean isTrivial() {
            return this.myBlocks.size() == 1;
        }

        MyDuplicateData(CssBlock ruleset, IntSet declarationHashes) {
            this.myBlocks = new HashSet<CssBlock>();
            this.myBlocks.add(ruleset);
            this.myDeclarationHashes = declarationHashes;
        }
    }
}

