/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.emmet.CssEmmetParser;
import com.intellij.codeInsight.template.emmet.EmmetParser;
import com.intellij.codeInsight.template.emmet.configuration.CssEmmetConfigurable;
import com.intellij.codeInsight.template.emmet.configuration.CssEmmetOptions;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.livetemplate.CssDeclarationBlockTemplateContextType;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssZenCodingGenerator
extends ZenCodingGenerator {
    protected boolean isAllowedChar(char c) {
        return c == ',' || super.isAllowedChar(c);
    }

    @NotNull
    public EmmetParser createParser(List<ZenCodingToken> tokens, CustomTemplateCallback callback, ZenCodingGenerator generator, boolean surroundWithTemplate) {
        boolean inDeclarationBlock = false;
        PsiElement context = callback.getContext();
        Set applicableContextTypes = TemplateManagerImpl.getApplicableContextTypes((TemplateActionContext)TemplateActionContext.expanding((PsiFile)context.getContainingFile(), (int)context.getTextOffset()));
        for (TemplateContextType type : applicableContextTypes) {
            if (!(type instanceof CssDeclarationBlockTemplateContextType)) continue;
            inDeclarationBlock = true;
            break;
        }
        return new CssEmmetParser(tokens, new CssEmmetCustomTemplateCallback(callback), inDeclarationBlock, generator);
    }

    @Nullable
    public Configurable createConfigurable() {
        return new CssEmmetConfigurable();
    }

    public boolean hasCompletionItem() {
        CssEmmetOptions options = CssEmmetOptions.getInstance();
        return options.isCssEmmetEnabled() && options.isFuzzySearchEnabled();
    }

    public void disableEmmet() {
        CssEmmetOptions.getInstance().setCssEmmetEnabled(false);
    }

    public boolean isEnabled() {
        return CssEmmetOptions.getInstance().isCssEmmetEnabled();
    }

    private static class CssEmmetCustomTemplateCallback
    extends CustomTemplateCallback {
        CssEmmetCustomTemplateCallback(CustomTemplateCallback callback) {
            super(callback.getEditor(), callback.getFile());
        }

        @NotNull
        public List<TemplateImpl> findApplicableTemplates(@NotNull String key) {
            List templates;
            if (key == null) {
                CssEmmetCustomTemplateCallback.$$$reportNull$$$0(0);
            }
            List list = (templates = super.findApplicableTemplates(key)).isEmpty() && StringUtil.containsChar((String)key, (char)'-') ? super.findApplicableTemplates(key.replace('-', ':')) : templates;
            if (list == null) {
                CssEmmetCustomTemplateCallback.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/emmet/CssZenCodingGenerator$CssEmmetCustomTemplateCallback";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/emmet/CssZenCodingGenerator$CssEmmetCustomTemplateCallback";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findApplicableTemplates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findApplicableTemplates";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

