/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.BufferedInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/intellij/indexing/shared/util/CountingInputStream;", "Ljava/io/InputStream;", "inputStream", "<init>", "(Ljava/io/InputStream;)V", "Ljava/io/BufferedInputStream;", "getInputStream", "()Ljava/io/BufferedInputStream;", "hasher", "Lcom/google/common/hash/Hasher;", "getHasher", "()Lcom/google/common/hash/Hasher;", "bytesRead", "", "getBytesRead", "()J", "setBytesRead", "(J)V", "read", "", "b", "", "off", "len", "close", "", "intellij.indexing.shared"})
final class CountingInputStream
extends InputStream {
    @NotNull
    private final BufferedInputStream inputStream;
    @NotNull
    private final Hasher hasher;
    private long bytesRead;

    public CountingInputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        InputStream inputStream2 = inputStream;
        int n = 0x100000;
        this.inputStream = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n);
        Hasher hasher = Hashing.sha256().newHasher();
        Intrinsics.checkNotNullExpressionValue((Object)hasher, (String)"newHasher(...)");
        this.hasher = hasher;
    }

    @NotNull
    public final BufferedInputStream getInputStream() {
        return this.inputStream;
    }

    @NotNull
    public final Hasher getHasher() {
        return this.hasher;
    }

    public final long getBytesRead() {
        return this.bytesRead;
    }

    public final void setBytesRead(long l) {
        this.bytesRead = l;
    }

    @Override
    public int read() {
        byte[] tmp = new byte[1];
        if (this.read(tmp, 0, 1) != 1) {
            return -1;
        }
        return tmp[0] & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int sz = this.inputStream.read(b, off, len);
        if (sz > 0) {
            this.bytesRead += (long)sz;
            this.hasher.putBytes(b, off, sz);
        }
        return sz;
    }

    @Override
    public void close() {
        this.inputStream.close();
    }
}

