/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.ide.actions.cache.CacheInconsistencyProblem;
import com.intellij.ide.actions.cache.ProjectRecoveryScope;
import com.intellij.ide.actions.cache.RecoveryAction;
import com.intellij.ide.actions.cache.RecoveryScope;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUtilImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.FileBasedIndexTumbler;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R%\u0010\b\u001a\u00130\t\u00a2\u0006\u000e\b\n\u0012\n\b\u000b\u0012\u0006\b\n0\f8\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/indexing/shared/platform/impl/DropSharedIndexesAction;", "Lcom/intellij/ide/actions/cache/RecoveryAction;", "<init>", "()V", "performanceRate", "", "getPerformanceRate", "()I", "presentableName", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "getPresentableName", "()Ljava/lang/String;", "actionKey", "getActionKey", "performSync", "", "Lcom/intellij/ide/actions/cache/CacheInconsistencyProblem;", "recoveryScope", "Lcom/intellij/ide/actions/cache/RecoveryScope;", "canBeApplied", "", "intellij.indexing.shared"})
public final class DropSharedIndexesAction
implements RecoveryAction {
    public int getPerformanceRate() {
        return 2000;
    }

    @NotNull
    public String getPresentableName() {
        String string = SharedIndexesBundle.message("drop.shared.indexes.recovery.action.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getActionKey() {
        return "drop-shared-index";
    }

    @NotNull
    public List<CacheInconsistencyProblem> performSync(@NotNull RecoveryScope recoveryScope) {
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        SharedIndexChunkConfiguration.getInstance().markOpenChunksAsExcluded(false, "drop shared indexes recovery action");
        ActionsKt.invokeAndWaitIfNeeded$default(null, DropSharedIndexesAction::performSync$lambda$0, (int)1, null);
        DumbUtilImpl.waitForSmartMode((Project)recoveryScope.getProject());
        return CollectionsKt.emptyList();
    }

    public boolean canBeApplied(@NotNull RecoveryScope recoveryScope) {
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        return recoveryScope instanceof ProjectRecoveryScope && (DumbService.Companion.isDumb(((ProjectRecoveryScope)recoveryScope).getProject()) || SharedIndexChunkConfiguration.getInstance().hasAnyChunk(true));
    }

    private static final Unit performSync$lambda$0() {
        FileBasedIndexTumbler tumbler = new FileBasedIndexTumbler("Drop shared indexes recovery action");
        tumbler.turnOff();
        FileBasedIndexTumbler.turnOn$default((FileBasedIndexTumbler)tumbler, null, (int)1, null);
        return Unit.INSTANCE;
    }
}

