/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.core.jdkmath;

import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import org.apache.commons.math4.core.jdkmath.AccurateMath;

public final class JdkMath {
    public static final double PI;
    public static final double E;
    private static final String PROPERTY_KEY = "org.apache.commons.math.jdkmath";
    private static final IntUnaryOperator ABS_INT;
    private static final LongUnaryOperator ABS_LONG;
    private static final FloatUnaryOperator ABS_FLOAT;
    private static final DoubleUnaryOperator ABS_DOUBLE;
    private static final DoubleUnaryOperator ACOS;
    private static final DoubleUnaryOperator ACOSH;
    private static final IntBinaryOperator ADDEXACT_INT;
    private static final LongBinaryOperator ADDEXACT_LONG;
    private static final DoubleUnaryOperator ASIN;
    private static final DoubleUnaryOperator ASINH;
    private static final DoubleUnaryOperator ATAN;
    private static final DoubleBinaryOperator ATAN2;
    private static final DoubleUnaryOperator ATANH;
    private static final DoubleUnaryOperator CBRT;
    private static final DoubleUnaryOperator CEIL;
    private static final FloatBinaryOperator COPYSIGN_FLOAT;
    private static final DoubleBinaryOperator COPYSIGN_DOUBLE;
    private static final DoubleUnaryOperator COS;
    private static final DoubleUnaryOperator COSH;
    private static final IntUnaryOperator DECREMENTEXACT_INT;
    private static final LongUnaryOperator DECREMENTEXACT_LONG;
    private static final DoubleUnaryOperator EXP;
    private static final DoubleUnaryOperator EXPM1;
    private static final DoubleUnaryOperator FLOOR;
    private static final IntBinaryOperator FLOORDIV_INT;
    private static final LongBinaryOperator FLOORDIV_LONG;
    private static final IntBinaryOperator FLOORMOD_INT;
    private static final LongBinaryOperator FLOORMOD_LONG;
    private static final FloatToIntFunction GETEXPONENT_FLOAT;
    private static final DoubleToIntFunction GETEXPONENT_DOUBLE;
    private static final DoubleBinaryOperator HYPOT;
    private static final DoubleBinaryOperator IEEEREMAINDER;
    private static final IntUnaryOperator INCREMENTEXACT_INT;
    private static final LongUnaryOperator INCREMENTEXACT_LONG;
    private static final DoubleUnaryOperator LOG;
    private static final DoubleUnaryOperator LOG10;
    private static final DoubleUnaryOperator LOG1P;
    private static final IntBinaryOperator MAX_INT;
    private static final LongBinaryOperator MAX_LONG;
    private static final FloatBinaryOperator MAX_FLOAT;
    private static final DoubleBinaryOperator MAX_DOUBLE;
    private static final IntBinaryOperator MIN_INT;
    private static final LongBinaryOperator MIN_LONG;
    private static final FloatBinaryOperator MIN_FLOAT;
    private static final DoubleBinaryOperator MIN_DOUBLE;
    private static final IntBinaryOperator MULTIPLYEXACT_INT;
    private static final LongBinaryOperator MULTIPLYEXACT_LONG;
    private static final IntUnaryOperator NEGATEEXACT_INT;
    private static final LongUnaryOperator NEGATEEXACT_LONG;
    private static final FloatDouble2FloatOperator NEXTAFTER_FLOAT;
    private static final DoubleBinaryOperator NEXTAFTER_DOUBLE;
    private static final FloatUnaryOperator NEXTDOWN_FLOAT;
    private static final DoubleUnaryOperator NEXTDOWN_DOUBLE;
    private static final FloatUnaryOperator NEXTUP_FLOAT;
    private static final DoubleUnaryOperator NEXTUP_DOUBLE;
    private static final DoubleBinaryOperator POW;
    private static final DoubleSupplier RANDOM;
    private static final DoubleUnaryOperator RINT;
    private static final DoubleToLongFunction ROUND_DOUBLE;
    private static final FloatToIntFunction ROUND_FLOAT;
    private static final DoubleInt2DoubleOperator SCALB_DOUBLE;
    private static final FloatInt2FloatOperator SCALB_FLOAT;
    private static final FloatUnaryOperator SIGNUM_FLOAT;
    private static final DoubleUnaryOperator SIGNUM_DOUBLE;
    private static final DoubleUnaryOperator SIN;
    private static final DoubleUnaryOperator SINH;
    private static final DoubleUnaryOperator SQRT;
    private static final IntBinaryOperator SUBTRACTEXACT_INT;
    private static final LongBinaryOperator SUBTRACTEXACT_LONG;
    private static final DoubleUnaryOperator TAN;
    private static final DoubleUnaryOperator TANH;
    private static final DoubleUnaryOperator TODEGREES;
    private static final LongToIntFunction TOINTEXACT;
    private static final DoubleUnaryOperator TORADIANS;
    private static final DoubleUnaryOperator ULP_DOUBLE;
    private static final FloatUnaryOperator ULP_FLOAT;

    private JdkMath() {
    }

    public static int abs(int x) {
        return ABS_INT.applyAsInt(x);
    }

    public static long abs(long x) {
        return ABS_LONG.applyAsLong(x);
    }

    public static float abs(float x) {
        return ABS_FLOAT.applyAsFloat(x);
    }

    public static double abs(double x) {
        return ABS_DOUBLE.applyAsDouble(x);
    }

    public static double acos(double x) {
        return ACOS.applyAsDouble(x);
    }

    public static double acosh(double x) {
        return ACOSH.applyAsDouble(x);
    }

    public static int addExact(int x, int y) {
        return ADDEXACT_INT.applyAsInt(x, y);
    }

    public static long addExact(long x, long y) {
        return ADDEXACT_LONG.applyAsLong(x, y);
    }

    public static double asin(double x) {
        return ASIN.applyAsDouble(x);
    }

    public static double asinh(double x) {
        return ASINH.applyAsDouble(x);
    }

    public static double atan(double x) {
        return ATAN.applyAsDouble(x);
    }

    public static double atan2(double y, double x) {
        return ATAN2.applyAsDouble(y, x);
    }

    public static double atanh(double x) {
        return ATANH.applyAsDouble(x);
    }

    public static double cbrt(double x) {
        return CBRT.applyAsDouble(x);
    }

    public static double ceil(double x) {
        return CEIL.applyAsDouble(x);
    }

    public static float copySign(float x, float y) {
        return COPYSIGN_FLOAT.applyAsFloat(x, y);
    }

    public static double copySign(double x, double y) {
        return COPYSIGN_DOUBLE.applyAsDouble(x, y);
    }

    public static double cos(double x) {
        return COS.applyAsDouble(x);
    }

    public static double cosh(double x) {
        return COSH.applyAsDouble(x);
    }

    public static int decrementExact(int x) {
        return DECREMENTEXACT_INT.applyAsInt(x);
    }

    public static long decrementExact(long x) {
        return DECREMENTEXACT_LONG.applyAsLong(x);
    }

    public static double exp(double x) {
        return EXP.applyAsDouble(x);
    }

    public static double expm1(double x) {
        return EXPM1.applyAsDouble(x);
    }

    public static double floor(double x) {
        return FLOOR.applyAsDouble(x);
    }

    public static int floorDiv(int x, int y) {
        return FLOORDIV_INT.applyAsInt(x, y);
    }

    public static long floorDiv(long x, long y) {
        return FLOORDIV_LONG.applyAsLong(x, y);
    }

    public static int floorMod(int x, int y) {
        return FLOORMOD_INT.applyAsInt(x, y);
    }

    public static long floorMod(long x, long y) {
        return FLOORMOD_LONG.applyAsLong(x, y);
    }

    public static int getExponent(float x) {
        return GETEXPONENT_FLOAT.applyAsInt(x);
    }

    public static int getExponent(double x) {
        return GETEXPONENT_DOUBLE.applyAsInt(x);
    }

    public static double hypot(double x, double y) {
        return HYPOT.applyAsDouble(x, y);
    }

    public static double IEEEremainder(double x, double y) {
        return IEEEREMAINDER.applyAsDouble(x, y);
    }

    public static int incrementExact(int x) {
        return INCREMENTEXACT_INT.applyAsInt(x);
    }

    public static long incrementExact(long x) {
        return INCREMENTEXACT_LONG.applyAsLong(x);
    }

    public static double log(double x) {
        return LOG.applyAsDouble(x);
    }

    public static double log10(double x) {
        return LOG10.applyAsDouble(x);
    }

    public static double log1p(double x) {
        return LOG1P.applyAsDouble(x);
    }

    public static int max(int x, int y) {
        return MAX_INT.applyAsInt(x, y);
    }

    public static long max(long x, long y) {
        return MAX_LONG.applyAsLong(x, y);
    }

    public static float max(float x, float y) {
        return MAX_FLOAT.applyAsFloat(x, y);
    }

    public static double max(double x, double y) {
        return MAX_DOUBLE.applyAsDouble(x, y);
    }

    public static int min(int x, int y) {
        return MIN_INT.applyAsInt(x, y);
    }

    public static long min(long x, long y) {
        return MIN_LONG.applyAsLong(x, y);
    }

    public static float min(float x, float y) {
        return MIN_FLOAT.applyAsFloat(x, y);
    }

    public static double min(double x, double y) {
        return MIN_DOUBLE.applyAsDouble(x, y);
    }

    public static int multiplyExact(int x, int y) {
        return MULTIPLYEXACT_INT.applyAsInt(x, y);
    }

    public static long multiplyExact(long x, long y) {
        return MULTIPLYEXACT_LONG.applyAsLong(x, y);
    }

    public static int negateExact(int x) {
        return NEGATEEXACT_INT.applyAsInt(x);
    }

    public static long negateExact(long x) {
        return NEGATEEXACT_LONG.applyAsLong(x);
    }

    public static double nextAfter(double x, double y) {
        return NEXTAFTER_DOUBLE.applyAsDouble(x, y);
    }

    public static float nextAfter(float x, double y) {
        return NEXTAFTER_FLOAT.applyAsFloat(x, y);
    }

    public static double nextDown(double x) {
        return NEXTDOWN_DOUBLE.applyAsDouble(x);
    }

    public static float nextDown(float x) {
        return NEXTDOWN_FLOAT.applyAsFloat(x);
    }

    public static double nextUp(double x) {
        return NEXTUP_DOUBLE.applyAsDouble(x);
    }

    public static float nextUp(float x) {
        return NEXTUP_FLOAT.applyAsFloat(x);
    }

    public static double pow(double x, double y) {
        return POW.applyAsDouble(x, y);
    }

    public static double random() {
        return RANDOM.getAsDouble();
    }

    public static double rint(double x) {
        return RINT.applyAsDouble(x);
    }

    public static int round(float x) {
        return ROUND_FLOAT.applyAsInt(x);
    }

    public static long round(double x) {
        return ROUND_DOUBLE.applyAsLong(x);
    }

    public static double scalb(double x, int y) {
        return SCALB_DOUBLE.applyAsDouble(x, y);
    }

    public static float scalb(float x, int y) {
        return SCALB_FLOAT.applyAsFloat(x, y);
    }

    public static double signum(double x) {
        return SIGNUM_DOUBLE.applyAsDouble(x);
    }

    public static float signum(float x) {
        return SIGNUM_FLOAT.applyAsFloat(x);
    }

    public static double sin(double x) {
        return SIN.applyAsDouble(x);
    }

    public static double sinh(double x) {
        return SINH.applyAsDouble(x);
    }

    public static double sqrt(double x) {
        return SQRT.applyAsDouble(x);
    }

    public static int subtractExact(int x, int y) {
        return SUBTRACTEXACT_INT.applyAsInt(x, y);
    }

    public static long subtractExact(long x, long y) {
        return SUBTRACTEXACT_LONG.applyAsLong(x, y);
    }

    public static double tan(double x) {
        return TAN.applyAsDouble(x);
    }

    public static double tanh(double x) {
        return TANH.applyAsDouble(x);
    }

    public static double toDegrees(double x) {
        return TODEGREES.applyAsDouble(x);
    }

    public static int toIntExact(long x) {
        return TOINTEXACT.applyAsInt(x);
    }

    public static double toRadians(double x) {
        return TORADIANS.applyAsDouble(x);
    }

    public static double ulp(double x) {
        return ULP_DOUBLE.applyAsDouble(x);
    }

    public static float ulp(float x) {
        return ULP_FLOAT.applyAsFloat(x);
    }

    static {
        String prop = System.getProperty(PROPERTY_KEY);
        Impl impl = prop != null ? Impl.valueOf(prop) : Impl.CM;
        switch (impl) {
            case CM: {
                PI = Math.PI;
                E = Math.E;
                ABS_INT = AccurateMath::abs;
                ABS_LONG = AccurateMath::abs;
                ABS_FLOAT = AccurateMath::abs;
                ABS_DOUBLE = AccurateMath::abs;
                ACOS = AccurateMath::acos;
                ACOSH = AccurateMath::acosh;
                ADDEXACT_INT = AccurateMath::addExact;
                ADDEXACT_LONG = AccurateMath::addExact;
                ASIN = AccurateMath::asin;
                ASINH = AccurateMath::asinh;
                ATAN = AccurateMath::atan;
                ATAN2 = AccurateMath::atan2;
                ATANH = AccurateMath::atanh;
                CBRT = AccurateMath::cbrt;
                CEIL = AccurateMath::ceil;
                COPYSIGN_FLOAT = AccurateMath::copySign;
                COPYSIGN_DOUBLE = AccurateMath::copySign;
                COS = AccurateMath::cos;
                COSH = AccurateMath::cosh;
                DECREMENTEXACT_INT = AccurateMath::decrementExact;
                DECREMENTEXACT_LONG = AccurateMath::decrementExact;
                EXP = AccurateMath::exp;
                EXPM1 = AccurateMath::expm1;
                FLOOR = AccurateMath::floor;
                FLOORDIV_INT = AccurateMath::floorDiv;
                FLOORDIV_LONG = AccurateMath::floorDiv;
                FLOORMOD_INT = AccurateMath::floorMod;
                FLOORMOD_LONG = AccurateMath::floorMod;
                GETEXPONENT_FLOAT = AccurateMath::getExponent;
                GETEXPONENT_DOUBLE = AccurateMath::getExponent;
                HYPOT = AccurateMath::hypot;
                IEEEREMAINDER = AccurateMath::IEEEremainder;
                INCREMENTEXACT_INT = AccurateMath::incrementExact;
                INCREMENTEXACT_LONG = AccurateMath::incrementExact;
                LOG = AccurateMath::log;
                LOG10 = AccurateMath::log10;
                LOG1P = AccurateMath::log1p;
                MAX_INT = AccurateMath::max;
                MAX_LONG = AccurateMath::max;
                MAX_FLOAT = AccurateMath::max;
                MAX_DOUBLE = AccurateMath::max;
                MIN_INT = AccurateMath::min;
                MIN_LONG = AccurateMath::min;
                MIN_FLOAT = AccurateMath::min;
                MIN_DOUBLE = AccurateMath::min;
                MULTIPLYEXACT_INT = AccurateMath::multiplyExact;
                MULTIPLYEXACT_LONG = AccurateMath::multiplyExact;
                NEGATEEXACT_INT = Math::negateExact;
                NEGATEEXACT_LONG = Math::negateExact;
                NEXTAFTER_FLOAT = AccurateMath::nextAfter;
                NEXTAFTER_DOUBLE = AccurateMath::nextAfter;
                NEXTDOWN_FLOAT = AccurateMath::nextDown;
                NEXTDOWN_DOUBLE = AccurateMath::nextDown;
                NEXTUP_FLOAT = AccurateMath::nextUp;
                NEXTUP_DOUBLE = AccurateMath::nextUp;
                POW = AccurateMath::pow;
                RANDOM = Math::random;
                RINT = AccurateMath::rint;
                ROUND_DOUBLE = AccurateMath::round;
                ROUND_FLOAT = AccurateMath::round;
                SCALB_DOUBLE = AccurateMath::scalb;
                SCALB_FLOAT = AccurateMath::scalb;
                SIGNUM_DOUBLE = AccurateMath::signum;
                SIGNUM_FLOAT = AccurateMath::signum;
                SQRT = Math::sqrt;
                SIN = AccurateMath::sin;
                SINH = AccurateMath::sinh;
                SUBTRACTEXACT_INT = AccurateMath::subtractExact;
                SUBTRACTEXACT_LONG = AccurateMath::subtractExact;
                TAN = AccurateMath::tan;
                TANH = AccurateMath::tanh;
                TODEGREES = AccurateMath::toDegrees;
                TOINTEXACT = AccurateMath::toIntExact;
                TORADIANS = AccurateMath::toRadians;
                ULP_DOUBLE = AccurateMath::ulp;
                ULP_FLOAT = AccurateMath::ulp;
                break;
            }
            case JDK: {
                PI = Math.PI;
                E = Math.E;
                ABS_INT = Math::abs;
                ABS_LONG = Math::abs;
                ABS_FLOAT = Math::abs;
                ABS_DOUBLE = Math::abs;
                ACOS = Math::acos;
                ACOSH = AccurateMath::acosh;
                ADDEXACT_INT = Math::addExact;
                ADDEXACT_LONG = Math::addExact;
                ASIN = Math::asin;
                ASINH = AccurateMath::asinh;
                ATAN = Math::atan;
                ATAN2 = Math::atan2;
                ATANH = AccurateMath::atanh;
                CBRT = Math::cbrt;
                CEIL = Math::ceil;
                COPYSIGN_FLOAT = Math::copySign;
                COPYSIGN_DOUBLE = Math::copySign;
                COS = Math::cos;
                COSH = Math::cosh;
                DECREMENTEXACT_INT = Math::decrementExact;
                DECREMENTEXACT_LONG = Math::decrementExact;
                EXP = Math::exp;
                EXPM1 = Math::expm1;
                FLOOR = Math::floor;
                FLOORDIV_INT = Math::floorDiv;
                FLOORDIV_LONG = Math::floorDiv;
                FLOORMOD_INT = Math::floorMod;
                FLOORMOD_LONG = Math::floorMod;
                GETEXPONENT_FLOAT = Math::getExponent;
                GETEXPONENT_DOUBLE = Math::getExponent;
                HYPOT = Math::hypot;
                IEEEREMAINDER = Math::IEEEremainder;
                INCREMENTEXACT_INT = Math::incrementExact;
                INCREMENTEXACT_LONG = Math::incrementExact;
                LOG = Math::log;
                LOG10 = Math::log10;
                LOG1P = Math::log1p;
                MAX_INT = Math::max;
                MAX_LONG = Math::max;
                MAX_FLOAT = Math::max;
                MAX_DOUBLE = Math::max;
                MIN_INT = Math::min;
                MIN_LONG = Math::min;
                MIN_FLOAT = Math::min;
                MIN_DOUBLE = Math::min;
                MULTIPLYEXACT_INT = Math::multiplyExact;
                MULTIPLYEXACT_LONG = Math::multiplyExact;
                NEGATEEXACT_INT = Math::negateExact;
                NEGATEEXACT_LONG = Math::negateExact;
                NEXTAFTER_FLOAT = Math::nextAfter;
                NEXTAFTER_DOUBLE = Math::nextAfter;
                NEXTDOWN_FLOAT = Math::nextDown;
                NEXTDOWN_DOUBLE = Math::nextDown;
                NEXTUP_FLOAT = Math::nextUp;
                NEXTUP_DOUBLE = Math::nextUp;
                POW = Math::pow;
                RANDOM = Math::random;
                RINT = Math::rint;
                ROUND_DOUBLE = Math::round;
                ROUND_FLOAT = Math::round;
                SCALB_DOUBLE = Math::scalb;
                SCALB_FLOAT = Math::scalb;
                SIGNUM_DOUBLE = Math::signum;
                SIGNUM_FLOAT = Math::signum;
                SIN = Math::sin;
                SINH = Math::sinh;
                SQRT = Math::sqrt;
                SUBTRACTEXACT_INT = Math::subtractExact;
                SUBTRACTEXACT_LONG = Math::subtractExact;
                TAN = Math::tan;
                TANH = Math::tanh;
                TODEGREES = Math::toDegrees;
                TOINTEXACT = Math::toIntExact;
                TORADIANS = Math::toRadians;
                ULP_DOUBLE = Math::ulp;
                ULP_FLOAT = Math::ulp;
                break;
            }
            default: {
                throw new IllegalStateException("Internal error");
            }
        }
    }

    private static interface DoubleInt2DoubleOperator {
        public double applyAsDouble(double var1, int var3);
    }

    private static interface FloatInt2FloatOperator {
        public float applyAsFloat(float var1, int var2);
    }

    private static interface FloatToIntFunction {
        public int applyAsInt(float var1);
    }

    private static interface FloatDouble2FloatOperator {
        public float applyAsFloat(float var1, double var2);
    }

    private static interface FloatBinaryOperator {
        public float applyAsFloat(float var1, float var2);
    }

    private static interface FloatUnaryOperator {
        public float applyAsFloat(float var1);
    }

    public static enum Impl {
        CM,
        JDK;

    }
}

