/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.project;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.layout.LayoutOrientation;
import com.intellij.openapi.graph.layout.LayoutStage;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.layout.hierarchic.Layerer;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.OrderEntryNavigatable;
import com.intellij.openapi.module.impl.scopes.LibraryScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.packageDependencies.actions.AnalyzeDependenciesOnSpecifiedTargetAction;
import com.intellij.pom.Navigatable;
import com.intellij.uml.java.project.ModuleDependenciesProvider;
import com.intellij.uml.java.project.ModuleItem;
import com.intellij.uml.java.project.ModulesUmlDnDProvider;
import com.intellij.uml.java.project.ModulesUmlEdge;
import com.intellij.uml.java.project.actions.AddModuleAction;
import com.intellij.uml.java.project.actions.ShowModuleCyclesAction;
import com.intellij.uml.java.project.actions.ShowPathsToModuleAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
public final class ModulesUmlExtras
extends CommonDiagramExtras<ModuleItem> {
    private final ModulesUmlDnDProvider dndProvider = new ModulesUmlDnDProvider();
    private final List<AnAction> myExtraActions = Arrays.asList(new AnAction[]{new ShowPathsToModuleAction(), new ShowModuleCyclesAction()});
    private static final DiagramElementsProvider[] PROVIDERS = new DiagramElementsProvider[]{new ModuleDependenciesProvider()};

    public ModulesUmlDnDProvider getDnDProvider() {
        return this.dndProvider;
    }

    public DiagramAddElementAction getAddElementHandler() {
        return new AddModuleAction();
    }

    @Override
    public DiagramElementsProvider<ModuleItem> @NotNull [] getElementsProviders() {
        if (PROVIDERS == null) {
            ModulesUmlExtras.$$$reportNull$$$0(0);
        }
        return PROVIDERS;
    }

    @Override
    @NotNull
    public List<AnAction> getExtraActions() {
        List<AnAction> list = this.myExtraActions;
        if (list == null) {
            ModulesUmlExtras.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public Layouter getCustomLayouter(GraphSettings settings, Project project) {
        HierarchicGroupLayouter layouter = GraphManager.getGraphManager().createHierarchicGroupLayouter();
        layouter.setOrientationLayouter((LayoutStage)GraphManager.getGraphManager().createOrientationLayouter(LayoutOrientation.LEFT_TO_RIGHT));
        layouter.setMinimalNodeDistance(20.0);
        layouter.setMinimalLayerDistance(50.0);
        layouter.setLayerer((Layerer)GraphManager.getGraphManager().createBFSLayerer());
        return layouter;
    }

    @Override
    public void uiDataSnapshot(@NotNull DataSink sink, @NotNull List<DiagramNode<ModuleItem>> nodes, @NotNull DiagramBuilder builder) {
        if (sink == null) {
            ModulesUmlExtras.$$$reportNull$$$0(2);
        }
        if (nodes == null) {
            ModulesUmlExtras.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            ModulesUmlExtras.$$$reportNull$$$0(4);
        }
        if (!nodes.isEmpty()) {
            if (nodes.size() == 1) {
                DiagramNode<ModuleItem> node = nodes.get(0);
                sink.lazy(LangDataKeys.MODULE_CONTEXT, () -> {
                    ModuleItem moduleItem = (ModuleItem)node.getIdentifyingElement();
                    return moduleItem.isModule() ? moduleItem.getModule() : null;
                });
                sink.lazy(LangDataKeys.LIBRARY, () -> {
                    ModuleItem moduleItem = (ModuleItem)node.getIdentifyingElement();
                    return moduleItem.isLibrary() ? moduleItem.getLibrary() : null;
                });
                sink.lazy(CommonDataKeys.NAVIGATABLE_ARRAY, () -> {
                    ModuleItem moduleItem = (ModuleItem)node.getIdentifyingElement();
                    Navigatable navigatable = moduleItem.getNavigatable();
                    return new Navigatable[]{navigatable};
                });
            }
            if (nodes.size() > 1) {
                sink.lazy(LangDataKeys.MODULE_CONTEXT_ARRAY, () -> {
                    ArrayList<Module> modules = new ArrayList<Module>();
                    for (DiagramNode node : nodes) {
                        if (!((ModuleItem)node.getIdentifyingElement()).isModule()) continue;
                        modules.add(((ModuleItem)node.getIdentifyingElement()).getModule());
                    }
                    return modules.toArray(Module.EMPTY_ARRAY);
                });
            }
        } else {
            DiagramEdge<?> edge;
            List<DiagramEdge<?>> edges = DiagramSelectionService.getInstance().getSelectedEdges(builder);
            if (edges.size() == 1 && (edge = edges.get(0)) instanceof ModulesUmlEdge) {
                ModulesUmlEdge modulesEdge = (ModulesUmlEdge)edge;
                sink.lazy(CommonDataKeys.NAVIGATABLE_ARRAY, () -> {
                    Navigatable[] navigatableArray;
                    ModuleItem srcElement = (ModuleItem)modulesEdge.getSource().getIdentifyingElement();
                    if (srcElement.isModule()) {
                        Navigatable[] navigatableArray2 = new Navigatable[1];
                        navigatableArray = navigatableArray2;
                        navigatableArray2[0] = new OrderEntryNavigatable(srcElement.getModule(), (OrderEntry)modulesEdge.findOrderEntry());
                    } else {
                        navigatableArray = null;
                    }
                    return navigatableArray;
                });
                sink.lazy(LangDataKeys.MODULE_CONTEXT_ARRAY, () -> {
                    Module[] moduleArray;
                    ModuleItem srcElement = (ModuleItem)modulesEdge.getSource().getIdentifyingElement();
                    ModuleItem trgElement = (ModuleItem)modulesEdge.getTarget().getIdentifyingElement();
                    if (srcElement.isModule() && trgElement.isModule()) {
                        Module[] moduleArray2 = new Module[2];
                        moduleArray2[0] = srcElement.getModule();
                        moduleArray = moduleArray2;
                        moduleArray2[1] = trgElement.getModule();
                    } else {
                        moduleArray = null;
                    }
                    return moduleArray;
                });
                sink.lazy(LangDataKeys.MODULE_CONTEXT, () -> {
                    ModuleItem srcElement = (ModuleItem)modulesEdge.getSource().getIdentifyingElement();
                    return srcElement.isModule() ? srcElement.getModule() : null;
                });
                sink.lazy(AnalyzeDependenciesOnSpecifiedTargetAction.TARGET_SCOPE_KEY, () -> {
                    ModuleItem srcElement = (ModuleItem)modulesEdge.getSource().getIdentifyingElement();
                    ModuleItem trgElement = (ModuleItem)modulesEdge.getTarget().getIdentifyingElement();
                    return trgElement.isModule() ? trgElement.getModule().getModuleScope() : (trgElement.isLibrary() ? new LibraryScope(srcElement.getProject(), trgElement.getLibrary()) : null);
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/project/ModulesUmlExtras";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraActions";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/project/ModulesUmlExtras";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

