/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import java.util.Objects;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.util.ProjectionMath;

public abstract class AzimuthalProjection
extends Projection {
    public static final int NORTH_POLE = 1;
    public static final int SOUTH_POLE = 2;
    public static final int EQUATOR = 3;
    public static final int OBLIQUE = 4;
    protected int mode;
    protected double sinphi0;
    protected double cosphi0;
    private double mapRadius = 90.0;

    public AzimuthalProjection() {
        this(Math.toRadians(45.0), Math.toRadians(45.0));
    }

    public AzimuthalProjection(double projectionLatitude, double projectionLongitude) {
        this.projectionLatitude = projectionLatitude;
        this.projectionLongitude = projectionLongitude;
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) < 1.0E-10) {
            this.mode = this.projectionLatitude < 0.0 ? 2 : 1;
        } else if (Math.abs(this.projectionLatitude) > 1.0E-10) {
            this.mode = 4;
            this.sinphi0 = Math.sin(this.projectionLatitude);
            this.cosphi0 = Math.cos(this.projectionLatitude);
        } else {
            this.mode = 3;
        }
    }

    @Override
    public boolean inside(double lon, double lat) {
        return ProjectionMath.greatCircleDistance(Math.toRadians(lon), Math.toRadians(lat), this.projectionLongitude, this.projectionLatitude) < Math.toRadians(this.mapRadius);
    }

    public void setMapRadius(double mapRadius) {
        this.mapRadius = mapRadius;
    }

    public double getMapRadius() {
        return this.mapRadius;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof AzimuthalProjection) {
            AzimuthalProjection p2 = (AzimuthalProjection)that;
            return this.mode == p2.mode && this.sinphi0 == p2.sinphi0 && this.cosphi0 == p2.cosphi0 && this.mapRadius == p2.mapRadius && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mode, this.sinphi0, this.cosphi0, this.mapRadius, super.hashCode());
    }
}

