/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbEditorModelListener;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbEditorModelTracker<T>
implements Disposable,
DbEditorModelListener {
    private final DbEditorModelController myController;
    private final Set<T> myModified;
    private String myAssertionOnModification;
    private String myAssertionOnExtraModification;

    public DbEditorModelTracker(@NotNull DbEditorModelController controller) {
        if (controller == null) {
            DbEditorModelTracker.$$$reportNull$$$0(0);
        }
        this.myModified = Collections.synchronizedSet(new LinkedHashSet());
        this.myController = controller;
        Disposer.register((Disposable)this.myController, (Disposable)this);
        this.myController.getEventDispatcher().addListener((EventListener)this, (Disposable)this);
    }

    public void addModifications(@NotNull Iterable<T> models2) {
        if (models2 == null) {
            DbEditorModelTracker.$$$reportNull$$$0(1);
        }
        ContainerUtil.addAll(this.myModified, models2);
    }

    @Override
    public void created(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbEditorModelTracker.$$$reportNull$$$0(2);
        }
        this.add(model);
    }

    @Override
    public void modified(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbEditorModelTracker.$$$reportNull$$$0(3);
        }
        this.add(model);
    }

    @Override
    public void removed(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbEditorModelTracker.$$$reportNull$$$0(4);
        }
        this.add(model);
    }

    protected void add(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbEditorModelTracker.$$$reportNull$$$0(5);
        }
        this.add(DbModelRef.create(model));
    }

    protected abstract void add(@NotNull DbModelRef<?, ?> var1);

    protected void addImpl(T v) {
        if (this.myModified.add(v) && this.myAssertionOnExtraModification != null) {
            throw new AssertionError((Object)this.myAssertionOnExtraModification);
        }
        if (this.myAssertionOnModification != null) {
            throw new AssertionError((Object)this.myAssertionOnModification);
        }
    }

    public void setAssertionOnModification(@Nullable String assertionOnModification) {
        this.myAssertionOnModification = assertionOnModification;
    }

    public void setAssertionOnExtraModification(@Nullable String assertionOnExtraModification) {
        this.myAssertionOnExtraModification = assertionOnExtraModification;
    }

    public void dispose() {
    }

    @NotNull
    public Iterable<T> getModified() {
        Set<T> set = this.myModified;
        if (set == null) {
            DbEditorModelTracker.$$$reportNull$$$0(6);
        }
        return set;
    }

    public boolean hasModifications() {
        return !this.myModified.isEmpty();
    }

    public void clearModified() {
        this.myModified.clear();
    }

    public void modifyAll() {
        this.myModified.clear();
        for (DbModelRef<?, ?> ref2 : this.myController.getAllModelsRefs()) {
            this.add(ref2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DbEditorModelTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DbEditorModelTracker";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addModifications";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "created";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "modified";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    public static class ByRef
    extends DbEditorModelTracker<DbModelRef<?, ?>> {
        public ByRef(@NotNull DbEditorModelController controller) {
            if (controller == null) {
                ByRef.$$$reportNull$$$0(0);
            }
            super(controller);
        }

        @Override
        protected void add(@NotNull DbModelRef<?, ?> ref2) {
            if (ref2 == null) {
                ByRef.$$$reportNull$$$0(1);
            }
            this.addImpl(ref2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/model/DbEditorModelTracker$ByRef";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

