/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.diff.DbDiffElement;
import com.intellij.database.model.diff.DbDiffRoot;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffModelHolder;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.dir.DTree;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.JavaCoroutines;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DbMigrationAction
extends IconWithTextAction
implements DirDiffModelHolder {
    private final Direction myDirection;
    private DirDiffModel myModel;

    public DbMigrationAction(Direction direction) {
        super(DatabaseBundle.message(direction == Direction.FORWARD ? "apply.right.to.the.left" : "apply.left.to.the.right", new Object[0]));
        this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
        this.getTemplatePresentation().setIcon(EmptyIcon.ICON_0);
        this.myDirection = direction;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DbMigrationAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DbMigrationAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(!this.myModel.getElements().isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DbMigrationAction.$$$reportNull$$$0(2);
        }
        DirDiffModel m = this.myModel;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        try {
            DbMigrationAction.migrate(m, this.myDirection);
        }
        catch (UnsupportedOperationException uoe) {
            Component source = e.getInputEvent().getComponent();
            Messages.showErrorDialog((Component)source, (String)GridUtilCore.getMessage((Throwable)uoe), (String)DatabaseBundle.message("dialog.title.migration.available", new Object[0]));
        }
    }

    private static BasicModel getModel(DirDiffModel model, boolean src, boolean isPrimary) {
        DbDiffRoot r = ((DbDiffElement)(src ? model.getSourceDir() : model.getTargetDir())).getRoot();
        if (isPrimary) {
            return r.getModel();
        }
        return (BasicModel)ObjectUtils.notNull((Object)r.getAltModel(), (Object)r.getModel());
    }

    private static BasicElement getElement(DTree d, boolean src, boolean isPrimary) {
        DbDiffElement e = (DbDiffElement)(src ? d.getSource() : d.getTarget());
        if (e == null) {
            return null;
        }
        return isPrimary ? e.getValue() : e.getAltElement();
    }

    public static void migrate(DirDiffModel model, Direction direction) {
        boolean isFromSrc = direction == Direction.FORWARD;
        DbDiffRoot root = ((DbDiffElement)(isFromSrc ? model.getSourceDir() : model.getTargetDir())).getRoot();
        SqlDataSource sqlTgt = (SqlDataSource)ObjectUtils.tryCast((Object)root.getDataSource().getDelegate(), SqlDataSource.class);
        if (sqlTgt != null) {
            DbMigrationAction.performFileMigration(root.getProject(), model, isFromSrc, sqlTgt);
        } else {
            DbMigrationAction.performAlterMigration(root.getProject(), model, isFromSrc);
        }
    }

    private static void performFileMigration(@NotNull Project project, DirDiffModel model, boolean isFromSrc, SqlDataSource sqlTgt) {
        if (project == null) {
            DbMigrationAction.$$$reportNull$$$0(3);
        }
        DbMigrationAction.createFileMigration(project, model, isFromSrc, sqlTgt);
    }

    private static void performAlterMigration(final @NotNull Project project, final DirDiffModel model, final boolean isFromSrc) {
        if (project == null) {
            DbMigrationAction.$$$reportNull$$$0(4);
        }
        new Task.Modal(project, DatabaseBundle.message("dialog.title.generating.migration.script", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                AlterScriptGenerator generator = new AlterScriptGenerator(project, model, isFromSrc);
                ScriptingResult initialResult = generator.generate();
                ApplicationManager.getApplication().invokeLater(() -> DbMigrationAction.showAlterScript(initialResult, generator, project, model, isFromSrc));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/model/diff/DbMigrationAction$1", "run"));
            }
        }.queue();
    }

    private static void showAlterScript(final ScriptingResult initialResult, final AlterScriptGenerator generator, Project project, DirDiffModel model, boolean isFromSrc) {
        DiffElement source = isFromSrc ? model.getSourceDir() : model.getTargetDir();
        DiffElement target2 = isFromSrc ? model.getTargetDir() : model.getSourceDir();
        DbDataSource sourceDataSource = ((DbDiffElement)source).getRoot().getDataSource();
        SearchPath sourceSearchPath = DbMigrationAction.getSearchPath((DbDiffElement)source, sourceDataSource);
        String dialogTitle = DatabaseBundle.message("dialog.title.to.migration", source.getPresentablePath(), target2.getPresentablePath());
        DatabaseScriptDialog dialog = new DatabaseScriptDialog(project, sourceDataSource.getDelegateDataSource(), sourceSearchPath, dialogTitle){
            final AlterScriptGenerator myGenerator;
            private ProgressIndicator current;
            {
                super(arg0, arg1, arg2, arg3);
                this.myGenerator = generator;
            }

            @Override
            protected void init() {
                super.init();
                this.setOKButtonText(DatabaseBundle.message("dialog.button.migration.script.execute", new Object[0]));
                this.updateText(initialResult);
            }

            @Override
            protected ScriptingTask getTask() {
                return this.myGenerator.createTask();
            }

            @Override
            @Nullable
            protected Object applyAndGetTask(@NotNull @NotNull Continuation<? super @NotNull ScriptingTask> $completion) {
                if ($completion == null) {
                    2.$$$reportNull$$$0(0);
                }
                return JavaCoroutines.suspendJava(c2 -> c2.resume((Object)this.getTask()), $completion);
            }

            @Override
            protected void settingsChanged(ScriptingOptions options) {
                this.myGenerator.setOptions(options);
                this.generate();
            }

            private synchronized void generate() {
                this.myLoadingPanel.startLoading();
                if (this.current != null) {
                    this.current.cancel();
                }
                this.current = new EmptyProgressIndicator();
                this.generateAsync(this.current);
            }

            private void generateAsync(ProgressIndicator indicator) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    Runnable process2 = () -> {
                        ScriptingResult result2 = this.myGenerator.generate();
                        indicator.checkCanceled();
                        if (this.isDisposed()) {
                            return;
                        }
                        UIUtil.invokeLaterIfNeeded(() -> {
                            this.updateText(result2);
                            this.myLoadingPanel.stopLoading();
                        });
                    };
                    ProgressManager.getInstance().runProcess(process2, indicator);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "$completion", "com/intellij/database/model/diff/DbMigrationAction$2", "applyAndGetTask"));
            }
        };
        dialog.initAndShow();
    }

    @Nullable
    public static SearchPath getSearchPath(DbDiffElement source, DbDataSource sourceDataSource) {
        DasNamespace sourceNamespace = DbImplUtilCore.getSearchPathObjectForSwitch(sourceDataSource, (DasObject)source.getValue());
        return ObjectPaths.searchPathOf((DasObject)ObjectUtils.tryCast((Object)sourceNamespace, BasicNamespace.class));
    }

    @NotNull
    public static ScriptingAlterTask prepareMigrationTask(DirDiffModel model, boolean isFromSrc, ScriptingOptions options) {
        BasicModel src = DbMigrationAction.getModel(model, isFromSrc, true);
        BasicModModel tgt = (BasicModModel)DbMigrationAction.getModel(model, !isFromSrc, false);
        ScriptingAlterTaskBuilder builder = new ScriptingAlterTaskBuilder(src, tgt);
        DbMigrationAction.consumeChanged(model, isFromSrc, (PairConsumer<BasicElement, BasicElement>)((PairConsumer)(srcE, tgtE) -> {
            if (srcE != null || tgtE != null) {
                builder.getCorrespondence().add(ElementDelta.create(srcE, tgtE));
            }
        }));
        builder.setOptions(options);
        ScriptingAlterTask scriptingAlterTask = builder.build();
        if (scriptingAlterTask == null) {
            DbMigrationAction.$$$reportNull$$$0(5);
        }
        return scriptingAlterTask;
    }

    private static void createFileMigration(@NotNull Project project, DirDiffModel model, boolean isFromSrc, SqlDataSource sqlTgt) {
        if (project == null) {
            DbMigrationAction.$$$reportNull$$$0(6);
        }
        BasicModModel tgt = (BasicModModel)DbMigrationAction.getModel(model, !isFromSrc, false);
        ScriptingSingleModelTaskBuilder builder = new ScriptingSingleModelTaskBuilder((BasicModel)tgt, ScriptCategory.CREATE_COMPLETE);
        DbMigrationAction.consumeChanged(model, isFromSrc, (PairConsumer<BasicElement, BasicElement>)((PairConsumer)(srcE, tgtE) -> {
            if (tgtE != null) {
                builder.getElements().add((BasicElement)tgtE);
            }
        }));
        DumpToDdlDataSourceActionKt.generate(project, sqlTgt, builder, true);
    }

    private static void consumeChanged(DirDiffModel model, boolean isFromSrc, PairConsumer<BasicElement, BasicElement> consumer) {
        boolean ignoreAlter;
        List elements = model.getElements();
        Map diffs = ContainerUtil.map2Map((Collection)elements, e -> Pair.create((Object)Couple.of((Object)e.getSource(), (Object)e.getTarget()), (Object)e.getOperation()));
        DTree rt = (DTree)JBIterable.generate((Object)((DirDiffElementImpl)elements.get(0)).getNode(), DTree::getParent).last();
        boolean ignoreCreate = !model.getSettings().showNewOnSource;
        boolean ignoreDrop = !model.getSettings().showNewOnTarget;
        boolean bl = ignoreAlter = !model.getSettings().showDifferent;
        if (isFromSrc) {
            boolean tmp = ignoreCreate;
            ignoreCreate = ignoreDrop;
            ignoreDrop = tmp;
        }
        for (DTree e2 : (JBTreeTraverser)JBTreeTraverser.from(DTree::getChildren).withRoot((Object)rt)) {
            if (DbMigrationAction.isIgnored(diffs, e2, isFromSrc)) continue;
            BasicElement srcE = DbMigrationAction.getElement(e2, isFromSrc, true);
            BasicElement tgtE = DbMigrationAction.getElement(e2, !isFromSrc, false);
            if (srcE == null && ignoreCreate || tgtE == null && ignoreDrop || srcE != null && tgtE != null && e2.getType() == DiffType.CHANGED && ignoreAlter) continue;
            consumer.consume((Object)srcE, (Object)tgtE);
        }
    }

    private static boolean isIgnored(@Unmodifiable Map<Couple<DiffElement>, DirDiffOperation> diffs, DTree e, boolean isFromSrc) {
        if (DbMigrationAction.getOperation(diffs, e) == DirDiffOperation.NONE) {
            return true;
        }
        if (DbMigrationAction.getOperation(diffs, e) == DirDiffOperation.DELETE && isFromSrc == (e.getSource() == null)) {
            return true;
        }
        Collection children2 = e.getChildren();
        if (ContainerUtil.find((Iterable)children2, c2 -> c2.getType() != DiffType.EQUAL) == null) {
            return false;
        }
        return ContainerUtil.find((Iterable)children2, c2 -> c2.getType() != DiffType.EQUAL && DbMigrationAction.getOperation(diffs, c2) != DirDiffOperation.NONE) == null;
    }

    private static DirDiffOperation getOperation(@Unmodifiable Map<Couple<DiffElement>, DirDiffOperation> diffs, DTree e) {
        return diffs.get(Pair.create((Object)e.getSource(), (Object)e.getTarget()));
    }

    public void setModel(DirDiffModel model) {
        this.myModel = model;
        String source = this.myModel.getSourceDir().getPresentablePath();
        String target2 = this.myModel.getTargetDir().getPresentablePath();
        this.getTemplatePresentation().setDescription(DatabaseBundle.message("action.DbMigrationAction.migrate.to.state.description", this.myDirection == Direction.FORWARD ? target2 : source, this.myDirection == Direction.FORWARD ? source : target2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/diff/DbMigrationAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/diff/DbMigrationAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareMigrationTask";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performFileMigration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performAlterMigration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFileMigration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6 -> new IllegalArgumentException(string);
        };
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }

    private static class AlterScriptGenerator {
        final Project project;
        final ScriptingAlterTaskBuilder builder;

        AlterScriptGenerator(Project project, DirDiffModel model, boolean isFromSrc) {
            this.project = project;
            BasicModel src = DbMigrationAction.getModel(model, isFromSrc, true);
            BasicModModel tgt = (BasicModModel)DbMigrationAction.getModel(model, !isFromSrc, false);
            this.builder = new ScriptingAlterTaskBuilder(src, tgt);
            DbMigrationAction.consumeChanged(model, isFromSrc, (PairConsumer<BasicElement, BasicElement>)((PairConsumer)(srcE, tgtE) -> {
                if (srcE != null || tgtE != null) {
                    this.builder.getCorrespondence().add(ElementDelta.create(srcE, tgtE));
                }
            }));
            DiffElement source = isFromSrc ? model.getSourceDir() : model.getTargetDir();
            this.setOptions(((DbDiffElement)source).getRoot().createOptions());
        }

        synchronized ScriptingTask createTask() {
            return this.builder.build();
        }

        synchronized void setOptions(ScriptingOptions options) {
            this.builder.setOptions(options);
        }

        @RequiresBackgroundThread
        ScriptingResult generate() {
            ThreadingAssertions.assertBackgroundThread();
            return ScriptGenerators.INSTANCE.makeScript(this.project, this.createTask());
        }
    }
}

