/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hive;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.hive.introspector.HiveIntrospector;
import com.intellij.database.dialects.hive.model.HiveFunction;
import com.intellij.database.dialects.hive.model.HiveFunctionBase;
import com.intellij.database.dialects.hive.model.HiveIndex;
import com.intellij.database.dialects.hive.model.HiveLikeColumn;
import com.intellij.database.dialects.hive.model.HiveMatView;
import com.intellij.database.dialects.hive.model.HiveSchema;
import com.intellij.database.dialects.hive.model.HiveTable;
import com.intellij.database.dialects.hive.model.HiveTableColumn;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnSortingOrder;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.hive.HiveTypes;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001b\u0010\u001e\u001a\r\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0002\b!2\u0006\u0010\"\u001a\u00020#H\u0002J$\u0010$\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00050&H\u0002J$\u0010(\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00050&H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\b\u001a\u00020#H\u0002J \u0010,\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020-2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006."}, d2={"Lcom/intellij/database/dialects/hive/HiveObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "<init>", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/model/properties/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "buildIndex", "Lcom/intellij/database/dialects/hive/model/HiveIndex;", "buildFunction", "Lcom/intellij/database/dialects/hive/model/HiveFunctionBase;", "buildMatView", "Lcom/intellij/database/dialects/hive/model/HiveMatView;", "buildLikeColumn", "Lcom/intellij/database/dialects/hive/model/HiveLikeColumn;", "buildTable", "Lcom/intellij/database/dialects/hive/model/HiveTable;", "findProperties", "", "Lcom/intellij/database/model/NameValue;", "Lorg/jetbrains/annotations/NotNull;", "el", "Lcom/intellij/psi/PsiElement;", "forEachColumnDef", "action", "Lkotlin/Function1;", "Lcom/intellij/sql/psi/SqlColumnDefinition;", "forEachColumnRef", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "findAndUnescapeString", "", "buildSchema", "Lcom/intellij/database/dialects/hive/model/HiveSchema;", "intellij.database.dialects.hive"})
@SourceDebugExtension(value={"SMAP\nHiveObjectBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiveObjectBuilder.kt\ncom/intellij/database/dialects/hive/HiveObjectBuilder\n+ 2 SqlObjectBuilderImpl.kt\ncom/intellij/database/dialects/base/SqlObjectBuilderImpl\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,282:1\n625#2,5:283\n614#2,10:288\n625#2,5:298\n614#2,10:303\n625#2,5:313\n614#2,7:319\n614#2,10:326\n621#2,3:336\n615#2:339\n637#2:340\n625#2,5:341\n614#2,7:346\n614#2,10:353\n614#2,10:370\n614#2,10:380\n621#2,3:390\n615#2:393\n625#2,5:398\n614#2,10:403\n1#3:318\n1557#4:363\n1628#4,3:364\n1863#4,2:368\n455#5:367\n13402#6,2:394\n13402#6,2:396\n*S KotlinDebug\n*F\n+ 1 HiveObjectBuilder.kt\ncom/intellij/database/dialects/hive/HiveObjectBuilder\n*L\n61#1:283,5\n69#1:288,10\n87#1:298,5\n95#1:303,10\n113#1:313,5\n125#1:319,7\n140#1:326,10\n125#1:336,3\n125#1:339\n161#1:340\n161#1:341,5\n162#1:346,7\n168#1:353,10\n186#1:370,10\n193#1:380,10\n162#1:390,3\n162#1:393\n258#1:398,5\n269#1:403,10\n176#1:363\n176#1:364,3\n177#1:368,2\n177#1:367\n229#1:394,2\n238#1:396,2\n*E\n"})
public final class HiveObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof HiveSchema) {
            this.buildSchema((HiveSchema)obj2, source, context);
        } else if (basicModElement instanceof HiveTable) {
            this.buildTable((HiveTable)obj2, source, context);
        } else if (basicModElement instanceof HiveLikeColumn) {
            this.buildLikeColumn((HiveLikeColumn)obj2, source, context);
        } else if (basicModElement instanceof HiveMatView) {
            this.buildMatView((HiveMatView)obj2, source, context);
        } else if (basicModElement instanceof HiveFunctionBase) {
            this.buildFunction((HiveFunctionBase)obj2, source, context);
        } else if (basicModElement instanceof HiveIndex) {
            this.buildIndex((HiveIndex)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    @Override
    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text2, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return Intrinsics.areEqual((Object)path.kind, (Object)ObjectKind.ROUTINE) ? TextRange.EMPTY_RANGE : super.getCompactDefinition(path, text2, def);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildIndex(HiveIndex obj2, DasObject source, SqlObjectBuilder.Context context) {
        HiveIndex stubbed;
        BasicElement basicElement;
        super.buildIndex(obj2, source, context);
        if (context.isStubBuilder()) {
            return;
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed2 = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof HiveIndex) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement2 instanceof HiveIndex)) {
                basicElement2 = null;
            }
            basicElement = (HiveIndex)basicElement2;
        } else {
            basicElement = null;
        }
        if ((stubbed = (HiveIndex)basicElement) != null) {
            obj2.setType(stubbed.getType());
            obj2.setIndexTableRef(stubbed.getIndexTableRef());
        } else {
            void this_$iv;
            String type = null;
            String indexTableName = null;
            SqlObjectBuilderImpl $i$f$stubbed2 = this;
            PsiElement el$iv = (PsiElement)(source instanceof SqlCreateIndexStatement ? (SqlCreateIndexStatement)source : null);
            boolean $i$f$forEachChild = false;
            void var10_12 = this_$iv;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement first2;
                PsiElement el = tmp$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)el), (Object)SqlCompositeElementTypes.SQL_CLAUSE) || el.getFirstChild() == null) continue;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)first2);
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_AS)) {
                    type = this.findString(first2);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_IN)) continue;
                indexTableName = this.findString(first2);
            }
            obj2.setType(type);
            obj2.setIndexTableRef(BasicNameReference.create(indexTableName));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildFunction(HiveFunctionBase obj2, DasObject source, SqlObjectBuilder.Context context) {
        block8: {
            void this_$iv;
            block7: {
                HiveFunctionBase stubbed;
                BasicElement basicElement;
                super.buildRoutine(obj2, source, context);
                SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
                DasObject $this$stubbed$iv = source;
                boolean $i$f$stubbed = false;
                DasObject dasObject = $this$stubbed$iv;
                if (dasObject instanceof HiveFunctionBase) {
                    basicElement = (BasicElement)$this$stubbed$iv;
                } else if (dasObject instanceof SqlStubbedElement) {
                    StubElement stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
                    SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
                    BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
                    if (!(basicElement2 instanceof HiveFunctionBase)) {
                        basicElement2 = null;
                    }
                    basicElement = (HiveFunctionBase)basicElement2;
                } else {
                    basicElement = null;
                }
                if ((stubbed = (HiveFunctionBase)basicElement) == null) break block7;
                obj2.setClassName(stubbed.getClassName());
                HiveFunction hiveFunction = obj2 instanceof HiveFunction ? (HiveFunction)obj2 : null;
                if (hiveFunction == null) break block8;
                HiveFunction hiveFunction2 = stubbed instanceof HiveFunction ? (HiveFunction)stubbed : null;
                hiveFunction.setTemporary(hiveFunction2 != null ? hiveFunction2.isTemporary() : false);
                break block8;
            }
            String className = null;
            boolean isTemporary = false;
            SqlObjectBuilderImpl $i$f$stubbed = this;
            PsiElement el$iv = (PsiElement)(source instanceof SqlCreateFunctionStatementImpl ? (SqlCreateFunctionStatementImpl)((Object)source) : null);
            boolean $i$f$forEachChild = false;
            void var10_13 = this_$iv;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement el = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)el);
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) {
                    if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)el.getFirstChild()), (Object)HiveTypes.HIVE_AS)) continue;
                    SqlStringLiteralExpression sqlStringLiteralExpression = (SqlStringLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)el, SqlStringLiteralExpression.class);
                    className = sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : null;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_TEMPORARY)) continue;
                isTemporary = true;
            }
            obj2.setClassName(className);
            HiveFunction hiveFunction = obj2 instanceof HiveFunction ? (HiveFunction)obj2 : null;
            if (hiveFunction == null) break block8;
            hiveFunction.setTemporary(isTemporary);
        }
    }

    private final void buildMatView(HiveMatView obj2, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement(obj2, source, context);
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)() -> HiveObjectBuilder.buildMatView$lambda$2(this, source)));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLikeColumn(HiveLikeColumn obj2, DasObject source, SqlObjectBuilder.Context context) {
        HiveLikeColumn stubbed;
        BasicElement basicElement;
        super.buildBasicElement(obj2, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed2 = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof HiveLikeColumn) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement2 instanceof HiveLikeColumn)) {
                basicElement2 = null;
            }
            basicElement = (HiveLikeColumn)basicElement2;
        } else {
            basicElement = null;
        }
        if ((stubbed = (HiveLikeColumn)basicElement) != null) {
            obj2.setComment(stubbed.getComment());
            if (stubbed instanceof HiveTableColumn && obj2 instanceof HiveTableColumn) {
                ((HiveTableColumn)obj2).setType(((HiveTableColumn)stubbed).getType());
            }
        } else {
            String string;
            HiveLikeColumn hiveLikeColumn = obj2;
            PsiElement psiElement = source instanceof PsiElement ? (PsiElement)source : null;
            IElementType iElementType = HiveTypes.HIVE_COMMENT_CLAUSE;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"HIVE_COMMENT_CLAUSE");
            PsiElement psiElement2 = this.findChild(psiElement, iElementType);
            if (psiElement2 != null) {
                void it;
                PsiElement $i$f$stubbed2 = psiElement2;
                HiveLikeColumn hiveLikeColumn2 = hiveLikeColumn;
                boolean bl = false;
                PsiElement psiElement3 = it.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getFirstChild(...)");
                string = this.findAndUnescapeString(psiElement3);
                hiveLikeColumn = hiveLikeColumn2;
            } else {
                string = null;
            }
            hiveLikeColumn.setComment(string);
            if (obj2 instanceof HiveTableColumn) {
                void this_$iv;
                Ref.ObjectRef type = new Ref.ObjectRef();
                type.element = HiveTableColumnType.REGULAR;
                Ref.ObjectRef sorting = new Ref.ObjectRef();
                sorting.element = HiveTableColumnSortingOrder.NONE;
                SqlObjectBuilderImpl it = this;
                PsiElement el$iv = PsiTreeUtil.getParentOfType((PsiElement)(source instanceof PsiElement ? (PsiElement)source : null), SqlCreateTableStatement.class);
                boolean $i$f$forEachChild = false;
                void var10_16 = this_$iv;
                PsiElement psiElement4 = el$iv;
                PsiElement first$iv$iv = psiElement4 != null ? psiElement4.getFirstChild() : null;
                boolean $i$f$forEachSibling = false;
                for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    IElementType iElementType2;
                    PsiElement el = tmp$iv$iv;
                    boolean bl = false;
                    PsiElement psiElement5 = el.getFirstChild();
                    Object object = iElementType2 = psiElement5 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement5) : null;
                    if (Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_PARTITIONED)) {
                        this.forEachColumnDef(el, (Function1<? super SqlColumnDefinition, Unit>)((Function1)arg_0 -> HiveObjectBuilder.buildLikeColumn$lambda$8$lambda$4(obj2, type, arg_0)));
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_CLUSTERED)) continue;
                    this.forEachColumnRef(el, (Function1<? super SqlReferenceExpression, Unit>)((Function1)arg_0 -> HiveObjectBuilder.buildLikeColumn$lambda$8$lambda$5(obj2, type, arg_0)));
                    SqlObjectBuilderImpl this_$iv2 = this;
                    boolean $i$f$forEachChild2 = false;
                    SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this_$iv2;
                    PsiElement first$iv$iv2 = el.getFirstChild();
                    boolean $i$f$forEachSibling2 = false;
                    for (PsiElement tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        PsiElement innerEl = tmp$iv$iv2;
                        boolean bl2 = false;
                        PsiElement psiElement6 = innerEl.getFirstChild();
                        if (!Intrinsics.areEqual((Object)(psiElement6 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement6) : null), (Object)HiveTypes.HIVE_SORTED)) continue;
                        this.forEachColumnRef(innerEl, (Function1<? super SqlReferenceExpression, Unit>)((Function1)arg_0 -> HiveObjectBuilder.buildLikeColumn$lambda$8$lambda$7$lambda$6(obj2, sorting, arg_0)));
                    }
                }
                ((HiveTableColumn)obj2).setType((HiveTableColumnType)((Object)type.element));
                ((HiveTableColumn)obj2).setSorting((HiveTableColumnSortingOrder)((Object)sorting.element));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTable(HiveTable obj2, DasObject source, SqlObjectBuilder.Context context) {
        BasicElement basicElement;
        void this_$iv;
        super.buildBasicElement(obj2, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbedOrBuild$iv = source;
        boolean $i$f$stubbedOrBuild = false;
        BasicElement basicElement2 = this_$iv;
        DasObject $this$stubbed$iv$iv = $this$stubbedOrBuild$iv;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv$iv;
        if (dasObject instanceof HiveTable) {
            basicElement = (BasicElement)$this$stubbed$iv$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv$iv)).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement3 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement3 instanceof HiveTable)) {
                basicElement3 = null;
            }
            basicElement = (HiveTable)basicElement3;
        } else {
            basicElement = null;
        }
        BasicElement basicElement4 = basicElement;
        if (basicElement == null) {
            void this_$iv2;
            Object obj3 = ((BasicObjectNode)obj2).getMetaObject().newDataObject();
            if (obj3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.hive.model.HiveTable");
            }
            basicElement2 = (HiveTable)obj3;
            HiveTable $this$buildTable_u24lambda_u2417 = (HiveTable)basicElement2;
            boolean bl = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
            PsiElement el$iv = source instanceof PsiElement ? (PsiElement)source : null;
            boolean $i$f$forEachChild = false;
            void var18_17 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                Object tmp$iv$iv2;
                boolean $i$f$forEachSibling2;
                PsiElement first$iv$iv2;
                boolean $i$f$forEachChild2;
                SqlObjectBuilderImpl this_$iv3;
                IElementType iElementType;
                PsiElement el = tmp$iv$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)el), (Object)HiveTypes.HIVE_EXTERNAL)) {
                    $this$buildTable_u24lambda_u2417.setExternal(true);
                } else if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)el), (Object)HiveTypes.HIVE_TEMPORARY)) {
                    $this$buildTable_u24lambda_u2417.setTemporary(true);
                }
                PsiElement psiElement2 = el.getFirstChild();
                Object object = iElementType = psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_COMMENT)) {
                    PsiElement psiElement3 = el.getFirstChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getFirstChild(...)");
                    $this$buildTable_u24lambda_u2417.setComment(this.findAndUnescapeString(psiElement3));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_CLUSTERED)) {
                    this_$iv3 = this;
                    $i$f$forEachChild2 = false;
                    SqlObjectBuilderImpl sqlObjectBuilderImpl3 = this_$iv3;
                    first$iv$iv2 = el.getFirstChild();
                    $i$f$forEachSibling2 = false;
                    for (tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        PsiElement innerEl = tmp$iv$iv2;
                        boolean bl3 = false;
                        PsiElement psiElement4 = innerEl.getFirstChild();
                        if (!Intrinsics.areEqual((Object)(psiElement4 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement4) : null), (Object)HiveTypes.HIVE_INTO)) continue;
                        Integer n = this.findInt(innerEl);
                        $this$buildTable_u24lambda_u2417.setBucketsNum(n != null ? n : 0);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_SKEWED)) {
                    void $this$forEach$iv;
                    SqlReferenceList refList = (SqlReferenceList)PsiTreeUtil.getChildOfType((PsiElement)el, SqlReferenceList.class);
                    Object object2 = refList;
                    if (object2 != null && (object2 = object2.getReferenceList()) != null) {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = (Iterable)object2;
                        boolean $i$f$map = false;
                        tmp$iv$iv2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl4 = false;
                            collection.add(it.getName());
                        }
                        List it = (List)destination$iv$iv;
                        boolean bl5 = false;
                        $this$buildTable_u24lambda_u2417.setSkewedByColumns(it);
                    }
                    Object $this$childrenOfType$iv = el;
                    boolean $i$f$childrenOfType = false;
                    List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, SqlClause.class);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
                    $this$childrenOfType$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IElementType $i$f$mapTo;
                        SqlClause clause = (SqlClause)element$iv;
                        boolean bl6 = false;
                        PsiElement psiElement5 = clause.getFirstChild();
                        Object object3 = $i$f$mapTo = psiElement5 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement5) : null;
                        if (Intrinsics.areEqual((Object)$i$f$mapTo, (Object)HiveTypes.HIVE_ON)) {
                            if ((SqlClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)clause), SqlClause.class) != null) {
                                SqlClause it;
                                boolean bl7 = false;
                                $this$buildTable_u24lambda_u2417.setSkewedByValues(it.getText());
                            }
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)$i$f$mapTo, (Object)HiveTypes.HIVE_STORED)) continue;
                        $this$buildTable_u24lambda_u2417.setStoredAsDirectories(true);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_ROW)) {
                    $this$buildTable_u24lambda_u2417.setRowFormatSerde(this.findString(el.getFirstChild()));
                    this_$iv3 = this;
                    $i$f$forEachChild2 = false;
                    SqlObjectBuilderImpl $i$f$forEach = this_$iv3;
                    first$iv$iv2 = el.getFirstChild();
                    $i$f$forEachSibling2 = false;
                    for (tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        Object it = tmp$iv$iv2;
                        boolean bl8 = false;
                        if (!(it instanceof SqlClause)) continue;
                        PsiElement psiElement6 = ((SqlClause)it).getFirstChild();
                        if (!Intrinsics.areEqual((Object)(psiElement6 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement6) : null), (Object)HiveTypes.HIVE_SERDEPROPERTIES)) continue;
                        $this$buildTable_u24lambda_u2417.setSerdeProperties(this.findProperties((PsiElement)it));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_STORED)) {
                    this_$iv3 = this;
                    $i$f$forEachChild2 = false;
                    SqlObjectBuilderImpl this_$iv$iv = this_$iv3;
                    first$iv$iv2 = el.getFirstChild();
                    $i$f$forEachSibling2 = false;
                    for (tmp$iv$iv2 = first$iv$iv2; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        IElementType iElementType2;
                        PsiElement first2;
                        Object it = tmp$iv$iv2;
                        boolean bl9 = false;
                        if (!(it instanceof SqlClause)) continue;
                        PsiElement psiElement7 = first2 = ((SqlClause)it).getFirstChild();
                        Object object4 = iElementType2 = psiElement7 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement7) : null;
                        if (Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_INPUTFORMAT)) {
                            $this$buildTable_u24lambda_u2417.setInputFormat(this.findString(first2));
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_OUTPUTFORMAT)) {
                            $this$buildTable_u24lambda_u2417.setOutputFormat(this.findString(first2));
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_OUTPUTDRIVER)) {
                            $this$buildTable_u24lambda_u2417.setOutputDriver(this.findString(first2));
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)iElementType2, (Object)HiveTypes.HIVE_INPUTDRIVER)) continue;
                        $this$buildTable_u24lambda_u2417.setInputDriver(this.findString(first2));
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_LOCATION)) {
                    PsiElement psiElement8 = el.getFirstChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement8, (String)"getFirstChild(...)");
                    $this$buildTable_u24lambda_u2417.setLocation(this.findAndUnescapeString(psiElement8));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_TBLPROPERTIES)) continue;
                $this$buildTable_u24lambda_u2417.setProperties(this.findProperties(el));
            }
            basicElement4 = basicElement2;
        }
        HiveTable stubbed = (HiveTable)basicElement4;
        obj2.setComment(stubbed.getComment());
        obj2.setExternal(stubbed.isExternal());
        obj2.setTemporary(stubbed.isTemporary());
        obj2.setBucketsNum(stubbed.getBucketsNum());
        obj2.setSkewedByColumns(stubbed.getSkewedByColumns());
        obj2.setSkewedByValues(stubbed.getSkewedByValues());
        obj2.setStoredAsDirectories(stubbed.isStoredAsDirectories());
        obj2.setRowFormatSerde(stubbed.getRowFormatSerde());
        obj2.setSerdeProperties(stubbed.getSerdeProperties());
        obj2.setInputFormat(stubbed.getInputFormat());
        obj2.setOutputFormat(stubbed.getOutputFormat());
        obj2.setInputDriver(stubbed.getInputDriver());
        obj2.setOutputDriver(stubbed.getOutputDriver());
        obj2.setLocation(stubbed.getLocation());
        obj2.setProperties(stubbed.getProperties());
    }

    private final List<NameValue> findProperties(PsiElement el) {
        List properties2;
        block1: {
            properties2 = new ArrayList();
            SqlSetAssignment[] sqlSetAssignmentArray = (SqlSetAssignment[])PsiTreeUtil.getChildrenOfType((PsiElement)el, SqlSetAssignment.class);
            if (sqlSetAssignmentArray == null) break block1;
            SqlSetAssignment[] $this$forEach$iv = sqlSetAssignmentArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                String value;
                SqlSetAssignment element$iv;
                SqlSetAssignment prop = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                SqlElement sqlElement = prop.getLValue();
                SqlStringLiteralExpression sqlStringLiteralExpression = sqlElement instanceof SqlStringLiteralExpression ? (SqlStringLiteralExpression)sqlElement : null;
                String key2 = sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : null;
                SqlElement sqlElement2 = prop.getRValue();
                SqlStringLiteralExpression sqlStringLiteralExpression2 = sqlElement2 instanceof SqlStringLiteralExpression ? (SqlStringLiteralExpression)sqlElement2 : null;
                String string = value = sqlStringLiteralExpression2 != null ? sqlStringLiteralExpression2.getValue() : null;
                if (key2 == null || value == null || HiveIntrospector.Companion.getIGNORED_PROPERTIES().contains(key2)) continue;
                properties2.add(new NameValue(key2, value));
            }
        }
        return properties2;
    }

    private final void forEachColumnDef(PsiElement el, Function1<? super SqlColumnDefinition, Unit> action) {
        block1: {
            SqlColumnDefinition[] sqlColumnDefinitionArray = (SqlColumnDefinition[])PsiTreeUtil.getChildrenOfType((PsiElement)el, SqlColumnDefinition.class);
            if (sqlColumnDefinitionArray == null) break block1;
            SqlColumnDefinition[] $this$forEach$iv = sqlColumnDefinitionArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                SqlColumnDefinition element$iv;
                SqlColumnDefinition c2 = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)c2);
                action.invoke((Object)c2);
            }
        }
    }

    private final void forEachColumnRef(PsiElement el, Function1<? super SqlReferenceExpression, Unit> action) {
        SqlReferenceList refList = (SqlReferenceList)PsiTreeUtil.getChildOfType((PsiElement)el, SqlReferenceList.class);
        if (refList == null) {
            return;
        }
        for (SqlReferenceExpression ref2 : refList.getReferenceList()) {
            Intrinsics.checkNotNull((Object)ref2);
            action.invoke((Object)ref2);
        }
    }

    private final String findAndUnescapeString(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_STRING_LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_STRING_LITERAL");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlCompositeElementType);
        SqlStringLiteralExpressionImpl sqlStringLiteralExpressionImpl = psiElement instanceof SqlStringLiteralExpressionImpl ? (SqlStringLiteralExpressionImpl)psiElement : null;
        if (sqlStringLiteralExpressionImpl == null) {
            return null;
        }
        SqlStringLiteralExpressionImpl stringLiteral = sqlStringLiteralExpressionImpl;
        return StringUtil.unescapeChar((String)StringUtil.unescapeChar((String)StringUtil.unquoteString((String)stringLiteral.getText()), (char)'\"'), (char)'\'');
    }

    /*
     * WARNING - void declaration
     */
    private final void buildSchema(HiveSchema obj2, DasObject source, SqlObjectBuilder.Context context) {
        HiveSchema stubbed;
        BasicElement basicElement;
        if (!context.isIntrospector()) {
            super.buildNamespace(obj2, source, context);
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        Object object = $this$stubbed$iv;
        if (object instanceof HiveSchema) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (object instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)((Object)$this$stubbed$iv)).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            BasicElement basicElement2 = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(basicElement2 instanceof HiveSchema)) {
                basicElement2 = null;
            }
            basicElement = (HiveSchema)basicElement2;
        } else {
            basicElement = null;
        }
        if ((stubbed = (HiveSchema)basicElement) != null) {
            obj2.setOwnerRef(stubbed.getOwnerRef());
            obj2.setProperties(stubbed.getProperties());
            obj2.setLocation(stubbed.getLocation());
            obj2.setComment(stubbed.getComment());
        } else {
            void this_$iv;
            List<NameValue> properties2 = null;
            properties2 = CollectionsKt.emptyList();
            String location = null;
            String comment = null;
            object = this;
            PsiElement el$iv = (PsiElement)(source instanceof SqlCreateStatement ? (SqlCreateStatement)source : null);
            boolean $i$f$forEachChild = false;
            void var11_12 = this_$iv;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement el = tmp$iv$iv;
                boolean bl = false;
                PsiElement psiElement2 = el.getFirstChild();
                Object object2 = iElementType = psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_DBPROPERTIES)) {
                    properties2 = this.findProperties(el);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_LOCATION)) {
                    PsiElement psiElement3 = el.getFirstChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getFirstChild(...)");
                    location = this.findAndUnescapeString(psiElement3);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)HiveTypes.HIVE_COMMENT)) continue;
                PsiElement psiElement4 = el.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getFirstChild(...)");
                comment = this.findAndUnescapeString(psiElement4);
            }
            obj2.setOwnerRef(null);
            obj2.setProperties(properties2);
            obj2.setLocation(location);
            obj2.setComment(comment);
        }
    }

    private static final CompositeText buildMatView$lambda$2(HiveObjectBuilder this$0, DasObject $source) {
        return this$0.getViewQuery($source, CompositeText.Kind.ORIGINAL_TEXT);
    }

    private static final Unit buildLikeColumn$lambda$8$lambda$4(HiveLikeColumn $obj, Ref.ObjectRef $type, SqlColumnDefinition c2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        if (StringsKt.equals((String)c2.getName(), (String)((HiveTableColumn)$obj).getName(), (boolean)true)) {
            $type.element = HiveTableColumnType.PARTITIONING;
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildLikeColumn$lambda$8$lambda$5(HiveLikeColumn $obj, Ref.ObjectRef $type, SqlReferenceExpression c2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        if (StringsKt.equals((String)c2.getName(), (String)((HiveTableColumn)$obj).getName(), (boolean)true)) {
            $type.element = HiveTableColumnType.CLUSTERING;
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildLikeColumn$lambda$8$lambda$7$lambda$6(HiveLikeColumn $obj, Ref.ObjectRef $sorting, SqlReferenceExpression ref2) {
        Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
        if (StringsKt.equals((String)ref2.getName(), (String)((HiveTableColumn)$obj).getName(), (boolean)true)) {
            PsiElement psiElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)((PsiElement)ref2));
            HiveTableColumnSortingOrder s = Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)HiveTypes.HIVE_DESC) ? HiveTableColumnSortingOrder.DESC : HiveTableColumnSortingOrder.ASC;
            $sorting.element = s;
        }
        return Unit.INSTANCE;
    }
}

