/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.RegexParser;
import com.oracle.truffle.regex.tregex.parser.RegexValidator;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import java.util.function.BiPredicate;

public abstract class RegexFlavor {
    protected static final int BACKREFERENCES_TO_UNMATCHED_GROUPS_FAIL = 1;
    protected static final int EMPTY_CHECKS_MONITOR_CAPTURE_GROUPS = 2;
    protected static final int NESTED_CAPTURE_GROUPS_KEPT_ON_LOOP_REENTRY = 4;
    protected static final int FAILING_EMPTY_CHECKS_DONT_BACKTRACK = 8;
    protected static final int USES_LAST_GROUP_RESULT_FIELD = 16;
    protected static final int LOOKBEHINDS_RUN_LEFT_TO_RIGHT = 32;
    protected static final int NEEDS_GROUP_START_POSITIONS = 64;
    protected static final int HAS_CONDITIONAL_BACKREFERENCES = 128;
    protected static final int SUPPORTS_RECURSIVE_BACKREFERENCES = 256;
    private final int traits;

    protected RegexFlavor(int traits) {
        this.traits = traits;
    }

    public abstract RegexParser createParser(RegexLanguage var1, RegexSource var2, CompilationBuffer var3);

    public abstract RegexValidator createValidator(RegexLanguage var1, RegexSource var2, CompilationBuffer var3);

    public abstract BiPredicate<Integer, Integer> getEqualsIgnoreCasePredicate(RegexAST var1);

    private boolean hasTrait(int traitMask) {
        return (this.traits & traitMask) != 0;
    }

    public boolean backreferencesToUnmatchedGroupsFail() {
        return this.hasTrait(1);
    }

    public boolean supportsRecursiveBackreferences() {
        return this.hasTrait(256);
    }

    public boolean emptyChecksMonitorCaptureGroups() {
        return this.hasTrait(2);
    }

    public boolean nestedCaptureGroupsKeptOnLoopReentry() {
        return this.hasTrait(4);
    }

    public boolean failingEmptyChecksDontBacktrack() {
        return this.hasTrait(8);
    }

    public boolean canHaveEmptyLoopIterations() {
        return this.emptyChecksMonitorCaptureGroups() || this.failingEmptyChecksDontBacktrack();
    }

    public boolean usesLastGroupResultField() {
        return this.hasTrait(16);
    }

    public boolean lookBehindsRunLeftToRight() {
        return this.hasTrait(32);
    }

    public boolean needsGroupStartPositions() {
        return this.hasTrait(64);
    }

    public boolean hasConditionalBackReferences() {
        return this.hasTrait(128);
    }

    public boolean matchesTransitionsStepByStep() {
        return this.emptyChecksMonitorCaptureGroups() || this.hasConditionalBackReferences();
    }
}

