/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.parser.JSRegexLexer;
import com.oracle.truffle.regex.tregex.parser.RegexASTBuilder;
import com.oracle.truffle.regex.tregex.parser.RegexParser;
import com.oracle.truffle.regex.tregex.parser.RegexParserGlobals;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.tregex.string.Encodings;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public final class JSRegexParser
implements RegexParser {
    private static final EnumSet<Token.Kind> QUANTIFIER_PREV = EnumSet.of(Token.Kind.literalChar, new Token.Kind[]{Token.Kind.charClass, Token.Kind.charClassEnd, Token.Kind.classSet, Token.Kind.groupEnd, Token.Kind.backReference});
    private final RegexParserGlobals globals;
    private final RegexSource source;
    private final RegexFlags flags;
    private final JSRegexLexer lexer;
    private final RegexASTBuilder astBuilder;
    private final CodePointSetAccumulator curCharClass = new CodePointSetAccumulator();

    @CompilerDirectives.TruffleBoundary
    public JSRegexParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) throws RegexSyntaxException {
        this.globals = language.parserGlobals;
        this.source = source;
        this.flags = RegexFlags.parseFlags(source);
        this.lexer = new JSRegexLexer(source, this.flags, compilationBuffer);
        this.astBuilder = new RegexASTBuilder(language, source, this.flags, this.flags.isEitherUnicode(), compilationBuffer);
    }

    public static Group parseRootLess(RegexLanguage language, String pattern) throws RegexSyntaxException {
        return new JSRegexParser(language, new RegexSource(pattern, "", RegexOptions.DEFAULT, null), new CompilationBuffer(Encodings.UTF_16_RAW)).parse(false).getRoot();
    }

    @Override
    public RegexFlags getFlags() {
        return this.flags;
    }

    @Override
    public AbstractRegexObject getNamedCaptureGroups() {
        return AbstractRegexObject.createNamedCaptureGroupMapListInt(this.lexer.getNamedCaptureGroups());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public RegexAST parse() throws RegexSyntaxException {
        return this.parse(true);
    }

    private RegexAST parse(boolean rootCapture) throws RegexSyntaxException {
        this.astBuilder.pushRootGroup(rootCapture);
        Token token = null;
        block20: while (this.lexer.hasNext()) {
            Token.Kind prevKind = token == null ? null : token.kind;
            token = this.lexer.next();
            if (!this.source.getOptions().getFlavor().nestedCaptureGroupsKeptOnLoopReentry() && token.kind != Token.Kind.quantifier && this.astBuilder.getCurTerm() != null && this.astBuilder.getCurTerm().isBackReference() && this.astBuilder.getCurTerm().asBackReference().isNestedOrForwardReference() && !JSRegexParser.isNestedInLookBehindAssertion(this.astBuilder.getCurTerm())) {
                this.astBuilder.removeCurTerm();
            }
            switch (token.kind) {
                case caret: {
                    if (prevKind == Token.Kind.caret) continue block20;
                    if (this.flags.isMultiline()) {
                        this.astBuilder.addCopy(token, this.globals.getJsMultiLineCaretSubstitution());
                        continue block20;
                    }
                    this.astBuilder.addPositionAssertion(token);
                    continue block20;
                }
                case dollar: {
                    if (prevKind == Token.Kind.dollar) continue block20;
                    if (this.flags.isMultiline()) {
                        this.astBuilder.addCopy(token, this.globals.getJsMultiLineDollarSubsitution());
                        continue block20;
                    }
                    this.astBuilder.addPositionAssertion(token);
                    continue block20;
                }
                case wordBoundary: {
                    if (prevKind == Token.Kind.wordBoundary) continue block20;
                    if (prevKind == Token.Kind.nonWordBoundary) {
                        this.astBuilder.replaceCurTermWithDeadNode();
                        continue block20;
                    }
                    if (this.flags.isEitherUnicode() && this.flags.isIgnoreCase()) {
                        this.astBuilder.addCopy(token, this.globals.getJsUnicodeIgnoreCaseWordBoundarySubstitution());
                        continue block20;
                    }
                    this.astBuilder.addCopy(token, this.globals.getJsWordBoundarySubstitution());
                    continue block20;
                }
                case nonWordBoundary: {
                    if (prevKind == Token.Kind.nonWordBoundary) continue block20;
                    if (prevKind == Token.Kind.wordBoundary) {
                        this.astBuilder.replaceCurTermWithDeadNode();
                        continue block20;
                    }
                    if (this.flags.isEitherUnicode() && this.flags.isIgnoreCase()) {
                        this.astBuilder.addCopy(token, this.globals.getJsUnicodeIgnoreCaseNonWordBoundarySubsitution());
                        continue block20;
                    }
                    this.astBuilder.addCopy(token, this.globals.getJsNonWordBoundarySubstitution());
                    continue block20;
                }
                case backReference: {
                    this.astBuilder.addBackReference((Token.BackReference)token, this.flags.isIgnoreCase());
                    continue block20;
                }
                case quantifier: {
                    if (this.astBuilder.getCurTerm() == null || !QUANTIFIER_PREV.contains((Object)prevKind)) {
                        throw this.syntaxError("Quantifier without target");
                    }
                    if (prevKind == Token.Kind.quantifier) {
                        throw this.syntaxError("Quantifier on quantifier");
                    }
                    if (this.flags.isEitherUnicode() && this.astBuilder.getCurTerm().isLookAheadAssertion()) {
                        throw this.syntaxError("Quantifier on lookahead assertion");
                    }
                    if (this.astBuilder.getCurTerm().isLookBehindAssertion()) {
                        throw this.syntaxError("Quantifier on lookbehind assertion");
                    }
                    this.astBuilder.addQuantifier((Token.Quantifier)token);
                    continue block20;
                }
                case alternation: {
                    this.astBuilder.nextSequence();
                    continue block20;
                }
                case captureGroupBegin: {
                    this.astBuilder.pushCaptureGroup(token);
                    continue block20;
                }
                case nonCaptureGroupBegin: {
                    this.astBuilder.pushGroup(token);
                    continue block20;
                }
                case lookAheadAssertionBegin: {
                    this.astBuilder.pushLookAheadAssertion(token, ((Token.LookAheadAssertionBegin)token).isNegated());
                    continue block20;
                }
                case lookBehindAssertionBegin: {
                    this.astBuilder.pushLookBehindAssertion(token, ((Token.LookBehindAssertionBegin)token).isNegated());
                    continue block20;
                }
                case groupEnd: {
                    if (this.astBuilder.getCurGroup().getParent() instanceof RegexASTRootNode) {
                        throw this.syntaxError("Unmatched ')'");
                    }
                    this.astBuilder.popGroup(token);
                    continue block20;
                }
                case literalChar: {
                    this.literalChar(((Token.LiteralCharacter)token).getCodePoint());
                    continue block20;
                }
                case charClass: {
                    this.astBuilder.addCharClass((Token.CharacterClass)token);
                    continue block20;
                }
                case charClassBegin: {
                    this.curCharClass.clear();
                    continue block20;
                }
                case charClassAtom: {
                    this.curCharClass.addSet(((Token.CharacterClassAtom)token).getContents());
                    continue block20;
                }
                case charClassEnd: {
                    boolean wasSingleChar;
                    boolean bl = wasSingleChar = !this.lexer.isCurCharClassInverted() && this.curCharClass.matchesSingleChar();
                    if (this.flags.isIgnoreCase()) {
                        this.lexer.caseFoldUnfold(this.curCharClass);
                    }
                    CodePointSet cps = this.curCharClass.toCodePointSet();
                    this.astBuilder.addCharClass(this.lexer.isCurCharClassInverted() ? cps.createInverse(this.source.getEncoding()) : cps, wasSingleChar);
                    continue block20;
                }
                case classSet: {
                    this.astBuilder.addClassSet((Token.ClassSet)token, this.flags.isIgnoreCase() ? CaseFoldData.CaseFoldUnfoldAlgorithm.ECMAScriptUnicode : null);
                    continue block20;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (!this.astBuilder.curGroupIsRoot()) {
            throw this.syntaxError("Unterminated group");
        }
        RegexAST ast = this.astBuilder.popRootGroup();
        this.checkNamedCaptureGroups(ast);
        return ast;
    }

    private void literalChar(int codePoint) {
        if (this.flags.isIgnoreCase()) {
            this.curCharClass.clear();
            this.curCharClass.addCodePoint(codePoint);
            this.lexer.caseFoldUnfold(this.curCharClass);
            this.astBuilder.addCharClass(this.curCharClass.toCodePointSet(), true);
        } else {
            this.astBuilder.addCharClass(CodePointSet.create(codePoint));
        }
    }

    private static boolean isNestedInLookBehindAssertion(Term t) {
        RegexASTSubtreeRootNode parent = t.getSubTreeParent();
        while (parent.isLookAroundAssertion()) {
            if (parent.isLookBehindAssertion()) {
                return true;
            }
            parent = parent.getParent().getSubTreeParent();
        }
        return false;
    }

    private void checkNamedCaptureGroups(RegexAST ast) {
        if (this.lexer.getNamedCaptureGroups() != null) {
            for (Map.Entry<String, List<Integer>> entry : this.lexer.getNamedCaptureGroups().entrySet()) {
                for (int i = 0; i < entry.getValue().size() - 1; ++i) {
                    for (int j = i + 1; j < entry.getValue().size(); ++j) {
                        if (!JSRegexParser.canBothParticipate(ast.getGroup(entry.getValue().get(i)), ast.getGroup(entry.getValue().get(j)))) continue;
                        throw this.syntaxError("Multiple named capture groups with the same name");
                    }
                }
            }
        }
    }

    private static boolean canBothParticipate(Group a, Group b) {
        EconomicMap<Group, Integer> ancestorsA = EconomicMap.create(Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        Group ancestorA = a;
        while (ancestorA != null && !ancestorA.getParent().isRoot()) {
            Sequence sequenceA = ancestorA.getParent().isSubtreeRoot() ? ancestorA.getParent().getParent().asSequence() : ancestorA.getParent().asSequence();
            ancestorA = sequenceA.getParent().asGroup();
            int indexA = ancestorA.getAlternatives().indexOf(sequenceA);
            assert (indexA >= 0);
            ancestorsA.put(ancestorA, indexA);
        }
        Group ancestorB = b;
        while (ancestorB != null && !ancestorB.getParent().isRoot()) {
            Sequence sequenceB = ancestorB.getParent().isSubtreeRoot() ? ancestorB.getParent().getParent().asSequence() : ancestorB.getParent().asSequence();
            if (!ancestorsA.containsKey(ancestorB = sequenceB.getParent().asGroup())) continue;
            int indexA = (Integer)ancestorsA.get(ancestorB);
            int indexB = ancestorB.getAlternatives().indexOf(sequenceB);
            assert (indexB >= 0);
            return indexA == indexB;
        }
        throw CompilerDirectives.shouldNotReachHere("no common ancestor found for named capture groups in regexp");
    }

    private RegexSyntaxException syntaxError(String msg) {
        return RegexSyntaxException.createPattern(this.source, msg, this.lexer.getLastTokenPosition());
    }
}

