/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.temporal.TemporalDifferenceDateNode;
import com.oracle.truffle.js.nodes.temporal.TemporalMoveRelativeDateNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.MoveRelativeDateResult;
import com.oracle.truffle.js.runtime.builtins.temporal.NanosecondsToDaysResult;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalRoundDurationNode
extends JavaScriptBaseNode {
    protected TemporalRoundDurationNode() {
    }

    public final JSTemporalDurationRecord execute(double y, double m, double w, double d, double h, double min, double sec, double milsec, double micsec, double nsec, double increment, TemporalUtil.Unit unit, TemporalUtil.RoundingMode roundingMode) {
        return this.execute(y, m, w, d, h, min, sec, milsec, micsec, nsec, increment, unit, roundingMode, null, null, null, null, null);
    }

    public final JSTemporalDurationRecord execute(double y, double m, double w, double d, double h, double min, double sec, double milsec, double micsec, double nsec, double increment, TemporalUtil.Unit unit, TemporalUtil.RoundingMode roundingMode, JSTemporalPlainDateObject plainRelativeTo, CalendarMethodsRecord calendarRec) {
        return this.execute(y, m, w, d, h, min, sec, milsec, micsec, nsec, increment, unit, roundingMode, plainRelativeTo, null, calendarRec, null, null);
    }

    public abstract JSTemporalDurationRecord execute(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, TemporalUtil.Unit var23, TemporalUtil.RoundingMode var24, JSTemporalPlainDateObject var25, JSTemporalZonedDateTimeObject var26, CalendarMethodsRecord var27, TimeZoneMethodsRecord var28, JSTemporalPlainDateTimeObject var29);

    @Specialization
    protected JSTemporalDurationRecord round(double years, double months, double weeks, double d, double h, double min, double sec, double milsec, double micsec, double nsec, double increment, TemporalUtil.Unit unit, TemporalUtil.RoundingMode roundingMode, JSTemporalPlainDateObject plainRelativeTo, JSTemporalZonedDateTimeObject zonedRelativeTo, CalendarMethodsRecord calendarRec, TimeZoneMethodsRecord timeZoneRec, JSTemporalPlainDateTimeObject precalculatedPlainDateTime, @Cached TemporalDifferenceDateNode differenceDateNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile unitYMWD, @Cached InlinedBranchProfile yearBranch, @Cached InlinedBranchProfile monthBranch, @Cached InlinedBranchProfile weekBranch, @Cached InlinedBranchProfile dayOrLessBranch, @Cached TemporalMoveRelativeDateNode moveRelativeDateNode) {
        double fractionalSeconds;
        assert (plainRelativeTo == null && zonedRelativeTo == null || calendarRec != null && calendarRec.dateAdd() != null && calendarRec.dateUntil() != null);
        double days = d;
        double hours = h;
        double minutes = min;
        double seconds = sec;
        double microseconds = micsec;
        double milliseconds = milsec;
        double nanoseconds = nsec;
        if ((unit == TemporalUtil.Unit.YEAR || unit == TemporalUtil.Unit.MONTH || unit == TemporalUtil.Unit.WEEK) && plainRelativeTo == null) {
            errorBranch.enter(this);
            throw TemporalErrors.createRangeErrorRelativeToNotUndefined(unit);
        }
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        if (unitYMWD.profile(this, unit == TemporalUtil.Unit.YEAR || unit == TemporalUtil.Unit.MONTH || unit == TemporalUtil.Unit.WEEK || unit == TemporalUtil.Unit.DAY)) {
            BigInt totalNs = TemporalUtil.totalDurationNanoseconds(0.0, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
            JSTemporalZonedDateTimeObject intermediate = null;
            if (zonedRelativeTo != null) {
                intermediate = TemporalUtil.moveRelativeZonedDateTime(ctx, realm, zonedRelativeTo, calendarRec, timeZoneRec, TemporalUtil.dtol(years), TemporalUtil.dtol(months), TemporalUtil.dtol(weeks), TemporalUtil.dtol(days), precalculatedPlainDateTime);
                NanosecondsToDaysResult result2 = TemporalUtil.nanosecondsToDays(ctx, realm, totalNs, intermediate, timeZoneRec);
                days = TemporalRoundDurationNode.calculateDays(days, result2);
            } else {
                days += nanoseconds / 8.64E13;
            }
            hours = 0.0;
            minutes = 0.0;
            seconds = 0.0;
            milliseconds = 0.0;
            microseconds = 0.0;
            nanoseconds = 0.0;
            fractionalSeconds = 0.0;
        } else {
            fractionalSeconds = TemporalUtil.roundDurationCalculateFractionalSeconds(seconds, milliseconds, microseconds, nanoseconds);
        }
        switch (unit) {
            case YEAR: {
                yearBranch.enter(this);
                return this.getUnitYear(increment, roundingMode, years, months, weeks, days, hours, minutes, seconds, microseconds, milliseconds, nanoseconds, plainRelativeTo, calendarRec, moveRelativeDateNode, differenceDateNode, this, dayOrLessBranch);
            }
            case MONTH: {
                monthBranch.enter(this);
                return this.getUnitMonth(increment, roundingMode, years, months, weeks, days, hours, minutes, seconds, microseconds, milliseconds, nanoseconds, plainRelativeTo, calendarRec, moveRelativeDateNode, differenceDateNode, this, dayOrLessBranch);
            }
            case WEEK: {
                weekBranch.enter(this);
                return this.getUnitWeek(increment, roundingMode, years, months, weeks, days, hours, minutes, seconds, microseconds, milliseconds, nanoseconds, plainRelativeTo, calendarRec, moveRelativeDateNode, differenceDateNode, this, dayOrLessBranch);
            }
            case DAY: {
                dayOrLessBranch.enter(this);
                return TemporalRoundDurationNode.getUnitDay(increment, roundingMode, years, months, weeks, days, hours, minutes, seconds, microseconds, milliseconds, nanoseconds);
            }
            case HOUR: {
                dayOrLessBranch.enter(this);
                return TemporalRoundDurationNode.getUnitHour(increment, roundingMode, years, months, weeks, days, hours, minutes, fractionalSeconds);
            }
            case MINUTE: {
                dayOrLessBranch.enter(this);
                return TemporalRoundDurationNode.getUnitMinute(increment, roundingMode, years, months, weeks, days, hours, minutes, fractionalSeconds);
            }
            case SECOND: {
                dayOrLessBranch.enter(this);
                return TemporalRoundDurationNode.getUnitSecond(increment, roundingMode, years, months, weeks, days, hours, minutes, fractionalSeconds);
            }
            case MILLISECOND: {
                dayOrLessBranch.enter(this);
                return TemporalRoundDurationNode.getUnitMillisecond(increment, roundingMode, years, months, weeks, days, hours, minutes, seconds, microseconds, milliseconds, nanoseconds);
            }
            case MICROSECOND: {
                dayOrLessBranch.enter(this);
                return TemporalRoundDurationNode.getUnitMicrosecond(increment, roundingMode, years, months, weeks, days, hours, minutes, seconds, microseconds, milliseconds, nanoseconds);
            }
            case NANOSECOND: {
                dayOrLessBranch.enter(this);
                return TemporalRoundDurationNode.getUnitNanosecond(increment, roundingMode, years, months, weeks, days, hours, minutes, seconds, microseconds, milliseconds, nanoseconds);
            }
        }
        throw Errors.shouldNotReachHere();
    }

    private static JSTemporalDurationRecord getUnitNanosecond(double increment, TemporalUtil.RoundingMode roundingMode, double years, double months, double weeks, double days, double hours, double minutes, double seconds, double microseconds, double milliseconds, double nanosecondsP) {
        double nanoseconds;
        double remainder = nanoseconds = nanosecondsP;
        nanoseconds = TemporalUtil.roundNumberToIncrement(nanoseconds, increment, roundingMode);
        return JSTemporalDurationRecord.createWeeksRemainder(years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds, remainder -= nanoseconds);
    }

    private static JSTemporalDurationRecord getUnitMicrosecond(double increment, TemporalUtil.RoundingMode roundingMode, double years, double months, double weeks, double days, double hours, double minutes, double seconds, double microsecondsP, double milliseconds, double nanoseconds) {
        double microseconds = microsecondsP;
        double fractionalMicroseconds = nanoseconds * 0.001 + microseconds;
        microseconds = TemporalUtil.roundNumberToIncrement(fractionalMicroseconds, increment, roundingMode);
        double remainder = fractionalMicroseconds - microseconds;
        return JSTemporalDurationRecord.createWeeksRemainder(years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, 0.0, remainder);
    }

    private static JSTemporalDurationRecord getUnitMillisecond(double increment, TemporalUtil.RoundingMode roundingMode, double years, double months, double weeks, double days, double hours, double minutes, double seconds, double microseconds, double millisecondsP, double nanoseconds) {
        double milliseconds = millisecondsP;
        double fractionalMilliseconds = nanoseconds * 1.0E-6 + microseconds * 0.001 + milliseconds;
        milliseconds = TemporalUtil.roundNumberToIncrement(fractionalMilliseconds, increment, roundingMode);
        double remainder = fractionalMilliseconds - milliseconds;
        return JSTemporalDurationRecord.createWeeksRemainder(years, months, weeks, days, hours, minutes, seconds, milliseconds, 0.0, 0.0, remainder);
    }

    private static JSTemporalDurationRecord getUnitMinute(double increment, TemporalUtil.RoundingMode roundingMode, double years, double months, double weeks, double days, double hours, double minutesP, double fractionalSeconds) {
        double minutes = minutesP;
        double fractionalMinutes = fractionalSeconds / 60.0 + minutes;
        minutes = TemporalUtil.roundNumberToIncrement(fractionalMinutes, increment, roundingMode);
        double remainder = fractionalMinutes - minutes;
        return JSTemporalDurationRecord.createWeeksRemainder(years, months, weeks, days, hours, minutes, 0.0, 0.0, 0.0, 0.0, remainder);
    }

    private static JSTemporalDurationRecord getUnitHour(double increment, TemporalUtil.RoundingMode roundingMode, double years, double months, double weeks, double days, double hoursP, double minutes, double fractionalSeconds) {
        double hours = hoursP;
        double fractionalHours = (fractionalSeconds / 60.0 + minutes) / 60.0 + hours;
        hours = TemporalUtil.roundNumberToIncrement(fractionalHours, increment, roundingMode);
        double remainder = fractionalHours - hours;
        return JSTemporalDurationRecord.createWeeksRemainder(years, months, weeks, days, hours, 0.0, 0.0, 0.0, 0.0, 0.0, remainder);
    }

    private static JSTemporalDurationRecord getUnitDay(double increment, TemporalUtil.RoundingMode roundingMode, double years, double months, double weeks, double daysP, double hours, double minutes, double seconds, double microseconds, double milliseconds, double nanoseconds) {
        double fractionalDays = daysP;
        double days = TemporalUtil.roundNumberToIncrement(daysP, increment, roundingMode);
        double remainder = fractionalDays - days;
        return JSTemporalDurationRecord.createWeeksRemainder(years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds, remainder);
    }

    private JSTemporalDurationRecord getUnitWeek(double increment, TemporalUtil.RoundingMode roundingMode, double years, double months, double weeksP, double daysP, double hours, double minutes, double seconds, double microseconds, double milliseconds, double nanoseconds, JSTemporalPlainDateObject relativeToP, CalendarMethodsRecord calendarRec, TemporalMoveRelativeDateNode moveRelativeDateNode, TemporalDifferenceDateNode differenceDateNode, Node node, InlinedBranchProfile errorBranch) {
        double daysPassed;
        double sign;
        JSTemporalDurationObject oneWeek;
        double weeks = weeksP;
        double fractionalDays = daysP;
        JSTemporalPlainDateObject relativeTo = relativeToP;
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        ISODateRecord isoResult = TemporalUtil.addISODate(relativeTo.getYear(), relativeTo.getMonth(), relativeTo.getDay(), 0.0, 0.0, 0.0, JSRuntime.truncateDouble(fractionalDays), TemporalUtil.Overflow.CONSTRAIN);
        JSTemporalPlainDateObject wholeDaysLater = JSTemporalPlainDate.create(ctx, this.getRealm(), isoResult.year(), isoResult.month(), isoResult.day(), calendarRec.receiver(), node, errorBranch);
        JSObject untilOptions = this.createUntilOptions(TemporalUtil.Unit.WEEK);
        JSTemporalDurationObject timePassed = differenceDateNode.execute(calendarRec, relativeTo, wholeDaysLater, TemporalUtil.Unit.WEEK, untilOptions);
        double weeksPassed = timePassed.getWeeks();
        weeks += weeksPassed;
        JSTemporalDurationObject weeksPassedDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, 0.0, 0.0, weeksPassed, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        MoveRelativeDateResult moveResult = moveRelativeDateNode.execute(calendarRec, relativeTo, weeksPassedDuration);
        relativeTo = moveResult.relativeTo();
        double oneWeekDays = (moveResult = moveRelativeDateNode.execute(calendarRec, relativeTo, oneWeek = JSTemporalDuration.createTemporalDuration(ctx, realm, 0.0, 0.0, sign = (fractionalDays -= (daysPassed = (double)moveResult.days())) < 0.0 ? -1.0 : 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch))).days();
        if (oneWeekDays == 0.0) {
            errorBranch.enter(node);
            throw Errors.createRangeError("dateAdd of one week moved date by 0 days");
        }
        double fractionalWeeks = weeks + fractionalDays / Math.abs(oneWeekDays);
        weeks = TemporalUtil.roundNumberToIncrement(fractionalWeeks, increment, roundingMode);
        double remainder = fractionalWeeks - weeks;
        return JSTemporalDurationRecord.createWeeksRemainder(years, months, weeks, 0.0, hours, minutes, seconds, milliseconds, microseconds, nanoseconds, remainder);
    }

    private JSTemporalDurationRecord getUnitMonth(double increment, TemporalUtil.RoundingMode roundingMode, double years, double monthsP, double weeks, double daysP, double hours, double minutes, double seconds, double microseconds, double milliseconds, double nanoseconds, JSTemporalPlainDateObject relativeToP, CalendarMethodsRecord calendarRec, TemporalMoveRelativeDateNode moveRelativeDateNode, TemporalDifferenceDateNode differenceDateNode, Node node, InlinedBranchProfile errorBranch) {
        double daysPassed;
        double sign;
        JSTemporalDurationObject oneMonth;
        double months = monthsP;
        double fractionalDays = daysP;
        JSTemporalPlainDateObject relativeTo = relativeToP;
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        JSTemporalDurationObject yearsMonths = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
        JSTemporalPlainDateObject yearsMonthsLater = TemporalUtil.calendarDateAdd(calendarRec, relativeTo, yearsMonths, Undefined.instance);
        JSTemporalDurationObject yearsMonthsWeeks = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, weeks, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
        JSTemporalPlainDateObject yearsMonthsWeeksLater = TemporalUtil.calendarDateAdd(calendarRec, relativeTo, yearsMonthsWeeks, Undefined.instance);
        double weeksInDays = TemporalUtil.daysUntil(yearsMonthsLater, yearsMonthsWeeksLater);
        relativeTo = yearsMonthsLater;
        ISODateRecord isoResult = TemporalUtil.addISODate(relativeTo.getYear(), relativeTo.getMonth(), relativeTo.getDay(), 0.0, 0.0, 0.0, JSRuntime.truncateDouble(fractionalDays += weeksInDays), TemporalUtil.Overflow.CONSTRAIN);
        JSTemporalPlainDateObject wholeDaysLater = JSTemporalPlainDate.create(ctx, this.getRealm(), isoResult.year(), isoResult.month(), isoResult.day(), calendarRec.receiver(), node, errorBranch);
        JSObject untilOptions = this.createUntilOptions(TemporalUtil.Unit.MONTH);
        JSTemporalDurationObject timePassed = differenceDateNode.execute(calendarRec, relativeTo, wholeDaysLater, TemporalUtil.Unit.MONTH, untilOptions);
        double monthsPassed = timePassed.getMonths();
        months += monthsPassed;
        JSTemporalDurationObject monthsPassedDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, 0.0, monthsPassed, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
        MoveRelativeDateResult moveResult = moveRelativeDateNode.execute(calendarRec, relativeTo, monthsPassedDuration);
        relativeTo = moveResult.relativeTo();
        double oneMonthDays = (moveResult = moveRelativeDateNode.execute(calendarRec, relativeTo, oneMonth = JSTemporalDuration.createTemporalDuration(ctx, realm, 0.0, sign = (fractionalDays -= (daysPassed = (double)moveResult.days())) < 0.0 ? -1.0 : 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch))).days();
        if (oneMonthDays == 0.0) {
            errorBranch.enter(node);
            throw Errors.createRangeError("dateAdd of one month moved date by 0 days");
        }
        double fractionalMonths = months + fractionalDays / Math.abs(oneMonthDays);
        months = TemporalUtil.roundNumberToIncrement(fractionalMonths, increment, roundingMode);
        double remainder = fractionalMonths - months;
        return JSTemporalDurationRecord.createWeeksRemainder(years, months, 0.0, 0.0, hours, minutes, seconds, milliseconds, microseconds, nanoseconds, remainder);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSTemporalDurationRecord getUnitSecond(double increment, TemporalUtil.RoundingMode roundingMode, double years, double months, double weeks, double days, double hours, double minutes, double fractionalSeconds) {
        double seconds = TemporalUtil.roundNumberToIncrement(fractionalSeconds, increment, roundingMode);
        double remainder = fractionalSeconds - seconds;
        return JSTemporalDurationRecord.createWeeksRemainder(years, months, weeks, days, hours, minutes, seconds, 0.0, 0.0, 0.0, remainder);
    }

    private JSTemporalDurationRecord getUnitYear(double increment, TemporalUtil.RoundingMode roundingMode, double yearsP, double months, double weeks, double daysP, double hours, double minutes, double seconds, double microseconds, double milliseconds, double nanoseconds, JSTemporalPlainDateObject relativeToP, CalendarMethodsRecord calendarRec, TemporalMoveRelativeDateNode moveRelativeDateNode, TemporalDifferenceDateNode differenceDateNode, Node node, InlinedBranchProfile errorBranch) {
        double daysPassed;
        double sign;
        JSTemporalDurationObject oneYear;
        double years = yearsP;
        double fractionalDays = daysP;
        JSTemporalPlainDateObject relativeTo = relativeToP;
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        JSTemporalDurationObject yearsDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, years, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
        JSTemporalPlainDateObject yearsLater = TemporalUtil.calendarDateAdd(calendarRec, relativeTo, yearsDuration);
        JSTemporalDurationObject yearsMonthsWeeks = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, weeks, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
        JSTemporalPlainDateObject yearsMonthsWeeksLater = TemporalUtil.calendarDateAdd(calendarRec, relativeTo, yearsMonthsWeeks);
        double monthsWeeksInDays = TemporalUtil.daysUntil(yearsLater, yearsMonthsWeeksLater);
        relativeTo = yearsLater;
        ISODateRecord isoResult = TemporalUtil.addISODate(relativeTo.getYear(), relativeTo.getMonth(), relativeTo.getDay(), 0.0, 0.0, 0.0, JSRuntime.truncateDouble(fractionalDays += monthsWeeksInDays), TemporalUtil.Overflow.CONSTRAIN);
        JSTemporalPlainDateObject wholeDaysLater = JSTemporalPlainDate.create(ctx, this.getRealm(), isoResult.year(), isoResult.month(), isoResult.day(), calendarRec.receiver(), node, errorBranch);
        JSObject untilOptions = this.createUntilOptions(TemporalUtil.Unit.YEAR);
        JSTemporalDurationObject timePassed = differenceDateNode.execute(calendarRec, relativeTo, wholeDaysLater, TemporalUtil.Unit.YEAR, untilOptions);
        double yearsPassed = timePassed.getYears();
        years += yearsPassed;
        JSTemporalDurationObject yearsPassedDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, yearsPassed, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
        MoveRelativeDateResult moveResult = moveRelativeDateNode.execute(calendarRec, relativeTo, yearsPassedDuration);
        relativeTo = moveResult.relativeTo();
        double oneYearDays = (moveResult = moveRelativeDateNode.execute(calendarRec, relativeTo, oneYear = JSTemporalDuration.createTemporalDuration(ctx, realm, sign = (fractionalDays -= (daysPassed = (double)moveResult.days())) < 0.0 ? -1.0 : 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch))).days();
        if (oneYearDays == 0.0) {
            errorBranch.enter(node);
            throw Errors.createRangeError("dateAdd of one year moved date by 0 days");
        }
        double fractionalYears = years + fractionalDays / Math.abs(oneYearDays);
        years = TemporalUtil.roundNumberToIncrement(fractionalYears, increment, roundingMode);
        double remainder = fractionalYears - years;
        return JSTemporalDurationRecord.createWeeksRemainder(years, 0.0, 0.0, 0.0, hours, minutes, seconds, milliseconds, microseconds, nanoseconds, remainder);
    }

    private JSObject createUntilOptions(TemporalUtil.Unit largestUnit) {
        JSContext ctx = this.getLanguage().getJSContext();
        JSObject untilOptions = JSOrdinary.createWithNullPrototype(ctx);
        TemporalUtil.createDataPropertyOrThrow(ctx, untilOptions, TemporalConstants.LARGEST_UNIT, largestUnit.toTruffleString());
        return untilOptions;
    }

    @CompilerDirectives.TruffleBoundary
    private static double calculateDays(double days, NanosecondsToDaysResult result2) {
        return days + TemporalUtil.bitod(result2.days().add(result2.nanoseconds().divide(result2.dayLength().abs())));
    }
}

