/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNodeGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Null;

@ImportStatic(value={JSConfig.class})
@GenerateUncached
public abstract class JSCollectionsNormalizeNode
extends JavaScriptBaseNode {
    public abstract Object execute(Object var1);

    @NeverDefault
    public static JSCollectionsNormalizeNode create() {
        return JSCollectionsNormalizeNodeGen.create();
    }

    @Specialization
    static int doInt(int value2) {
        return value2;
    }

    @Specialization
    static Object doDouble(double value2) {
        return JSSet.normalizeDouble(value2);
    }

    @Specialization
    static TruffleString doString(TruffleString value2) {
        return value2;
    }

    @Specialization
    static boolean doBoolean(boolean value2) {
        return value2;
    }

    @Specialization
    static Object doDynamicObject(JSDynamicObject object) {
        return object;
    }

    @Specialization
    static Symbol doSymbol(Symbol value2) {
        return value2;
    }

    @Specialization
    static BigInt doBigInt(BigInt value2) {
        return value2;
    }

    @Specialization
    static Object doLong(long value2) {
        if (JSRuntime.longFitsInDouble(value2)) {
            return JSCollectionsNormalizeNode.doDouble(value2);
        }
        return BigInt.valueOf(value2);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObject(value)"}, limit="InteropLibraryLimit")
    final Object doForeignObject(Object value2, @CachedLibrary(value="value") InteropLibrary interop) {
        if (interop.isNull(value2)) {
            return Null.instance;
        }
        try {
            if (interop.isBoolean(value2)) {
                return JSCollectionsNormalizeNode.doBoolean(interop.asBoolean(value2));
            }
            if (interop.isString(value2)) {
                return JSCollectionsNormalizeNode.doString(interop.asTruffleString(value2));
            }
            if (interop.isNumber(value2)) {
                if (interop.fitsInInt(value2)) {
                    return JSCollectionsNormalizeNode.doInt(interop.asInt(value2));
                }
                if (interop.fitsInDouble(value2)) {
                    return JSCollectionsNormalizeNode.doDouble(interop.asDouble(value2));
                }
                if (interop.fitsInLong(value2)) {
                    return JSCollectionsNormalizeNode.doLong(interop.asLong(value2));
                }
                if (interop.fitsInBigInteger(value2)) {
                    return JSCollectionsNormalizeNode.doBigInt(BigInt.fromBigInteger(interop.asBigInteger(value2)));
                }
                assert (value2 instanceof TruffleObject);
                return value2;
            }
            return value2;
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorUnboxException(value2, e, this);
        }
    }
}

