/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions;

import com.intellij.httpClient.actions.HttpClientActionsUsage;
import com.intellij.httpClient.actions.HttpRequestOpenCollectionExternalProvider;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpClientDataKeys;
import com.intellij.httpClient.http.request.HttpRequestCollectionProvider;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.environment.HttpClientSelectedEnvironments;
import com.intellij.httpClient.http.request.notification.HttpClientNotificationWhatsNewService;
import com.intellij.httpClient.http.request.notification.HttpClientWhatsNewContentService;
import com.intellij.httpClient.http.request.run.HttpRequestHistoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestOpenCollectionAction
extends AnAction {
    private static final String HELP_ID = "Http_client_in__product__code_editor";
    private static final String FIRST_OTHER = "graphql-requests.http";
    private static final Set<String> OTHER_EXAMPLE_FILES = Set.of("graphql-requests.http", "ws-requests.http", "whats-new.http");

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(0);
        }
        if ((project = event.getProject()) == null || project.isDefault()) {
            this.showErrorBalloon(project, event, RestClientBundle.message("http.request.open.requests.collection.action.failed.default.project", new Object[0]));
            return;
        }
        boolean success = this.showOpenFilePopup(project, event);
        if (!success) {
            this.showErrorBalloon(project, event, RestClientBundle.message("http.request.open.requests.collection.action.failed.no.file", new Object[0]));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public boolean showOpenFilePopup(@NotNull Project project, @NotNull AnActionEvent event) {
        JComponent hyperlinkLabel;
        CollectionFiles files;
        if (project == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(2);
        }
        if (event == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(3);
        }
        if ((files = CollectionFiles.create()) == null) {
            return false;
        }
        ListPopupImpl requestsCollectionPopup = this.createPopup(project, files);
        if ("HttpClient.NotificationPanel".equals(event.getPlace()) && (hyperlinkLabel = (JComponent)event.getDataContext().getData(HttpClientDataKeys.EXAMPLES_TOOLBAR_HYPERLINK_LABEL)) != null) {
            requestsCollectionPopup.showUnderneathOf((Component)hyperlinkLabel);
        } else {
            requestsCollectionPopup.show(HttpRequestOpenCollectionAction.findBestPopupLocation(event));
        }
        return true;
    }

    @NotNull
    private ListPopupImpl createPopup(final @NotNull Project project, final @NotNull CollectionFiles collection) {
        if (project == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(4);
        }
        if (collection == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(5);
        }
        String title = RestClientBundle.message("action.HTTPClient.OpenCollection.text", new Object[0]);
        return new ListPopupImpl(project, (ListPopupStep)new BaseListPopupStep<String>(title, collection.getOrderedActions()){

            @Nullable
            public ListSeparator getSeparatorAbove(@NlsActions.ActionText String value2) {
                if (collection.isOpenHelp(value2) || collection.isFirstOther(value2)) {
                    return new ListSeparator();
                }
                return super.getSeparatorAbove((Object)value2);
            }

            public PopupStep<?> onChosen(String action, boolean finalChoice) {
                return this.doFinalStep(() -> {
                    if (collection.isOpenHelp(action)) {
                        HelpManager.getInstance().invokeHelp(HttpRequestOpenCollectionAction.HELP_ID);
                        HttpClientActionsUsage.COLLECTION_POPUP_OPTION_CHOSEN.log(project, (Object)"HTTP Client Help");
                        return;
                    }
                    HttpRequestOpenCollectionAction.openCollectionFile(project, collection, action);
                });
            }

            @NotNull
            public String getTextFor(@NlsContexts.ListItem String value2) {
                Object object = collection.isPromotedWhatsNew(value2) ? "*" + value2 : value2;
                if (object == null) {
                    2.$$$reportNull$$$0(0);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/httpClient/actions/HttpRequestOpenCollectionAction$2", "getTextFor"));
            }
        }){

            protected ListCellRenderer<?> getListElementRenderer() {
                return new PopupListElementRenderer<Object>((ListPopupImpl)this){

                    protected void customizeComponent(JList<?> list2, Object value2, boolean isSelected) {
                        String actionText;
                        super.customizeComponent(list2, value2, isSelected);
                        Font listFont = UIUtil.getListFont();
                        this.myTextLabel.setFont(value2 instanceof String && collection.isPromotedWhatsNew(actionText = (String)value2) ? listFont.deriveFont(1) : listFont);
                    }
                };
            }
        };
    }

    @IntellijInternalApi
    @ApiStatus.Internal
    public static void openWhatsNewFile(@NotNull Project project) {
        CollectionFiles files;
        if (project == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(6);
        }
        if ((files = CollectionFiles.create()) == null) {
            return;
        }
        HttpRequestOpenCollectionAction.openCollectionFile(project, files, RestClientBundle.message("http.request.collection.whats.new", new Object[0]));
    }

    private static void openCollectionFile(@NotNull Project project, @NotNull CollectionFiles collection, @NotNull String action) {
        if (project == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(7);
        }
        if (collection == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(8);
        }
        if (action == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(9);
        }
        ModalityState modalityState = ModalityState.defaultModalityState();
        AppExecutorUtil.getAppExecutorService().execute(() -> {
            VirtualFile selectedFile = collection.findCollectionFile(action);
            if (selectedFile != null) {
                if (collection.isPromotedWhatsNew(action)) {
                    HttpClientNotificationWhatsNewService.getInstance().whatsNewIsNotNeededAnymore();
                }
                ReadAction.nonBlocking(() -> PsiManager.getInstance((Project)project).findFile(selectedFile) != null ? selectedFile : null).finishOnUiThread(modalityState, vFile -> {
                    if (vFile != null) {
                        HttpClientSelectedEnvironments selectedEnvironments = HttpClientSelectedEnvironments.getInstance(project);
                        if (collection.isBuiltin(action) && !selectedEnvironments.hasFileAnySelection$intellij_restClient((VirtualFile)vFile)) {
                            selectedEnvironments.set((VirtualFile)vFile, "test");
                        }
                        HttpClientActionsUsage.COLLECTION_POPUP_OPTION_CHOSEN.log(project, (Object)vFile.getName());
                        FileEditorManager.getInstance((Project)project).openFile(vFile, true);
                    }
                }).submit((Executor)AppExecutorUtil.getAppExecutorService());
            }
        });
    }

    @NotNull
    @NlsContexts.ListItem
    public static String getCollectionName(@NotNull String fileName) {
        String fallbackVariant;
        String name;
        String presentableName;
        if (fileName == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(10);
        }
        if (StringUtil.isNotEmpty((String)(presentableName = RestClientBundle.INSTANCE.messageOrNull("http.request.collection." + (name = FileUtil.getNameWithoutExtension((String)fileName)).replace("-", "."), new Object[0])))) {
            String string = presentableName;
            if (string == null) {
                HttpRequestOpenCollectionAction.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = fallbackVariant = String.join((CharSequence)" ", StringUtil.wordsToBeginFromUpperCase((String)name).split("-"));
        if (string == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(12);
        }
        return string;
    }

    void showErrorBalloon(@Nullable Project project, @NotNull AnActionEvent event, @NotNull @NlsContexts.PopupContent String message) {
        if (event == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(13);
        }
        if (message == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(14);
        }
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null).setFadeoutTime(2000L);
        if (project != null) {
            builder.setDisposable((Disposable)HttpRequestHistoryManager.getInstance(project));
        }
        builder.createBalloon().show(HttpRequestOpenCollectionAction.findBestPopupLocation(event), Balloon.Position.below);
    }

    @NotNull
    private static RelativePoint findBestPopupLocation(@NotNull AnActionEvent event) {
        if (event == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(15);
        }
        InputEvent inputEvent = event.getInputEvent();
        if ("ContextToolbar".equals(event.getPlace()) && inputEvent instanceof MouseEvent) {
            return new RelativePoint((MouseEvent)inputEvent);
        }
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(event.getDataContext());
        if (relativePoint == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(16);
        }
        return relativePoint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 11, 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/actions/HttpRequestOpenCollectionAction";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/actions/HttpRequestOpenCollectionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findBestPopupLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showOpenFilePopup";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openWhatsNewFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "openCollectionFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showErrorBalloon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findBestPopupLocation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 11, 12, 16 -> new IllegalStateException(string);
        };
    }

    private static class CollectionFiles {
        private final Map<@NlsActions.ActionText String, String> myBuiltinFiles;
        private final Map<@NlsActions.ActionText String, VirtualFile> myProvidedFiles;
        private final VirtualFile myRoot;
        private final String myFirstOther;

        private CollectionFiles(@NotNull Map<@NlsActions.ActionText String, String> files, @NotNull Map<@NlsActions.ActionText String, VirtualFile> providedFiles, @NotNull VirtualFile root) {
            if (files == null) {
                CollectionFiles.$$$reportNull$$$0(0);
            }
            if (providedFiles == null) {
                CollectionFiles.$$$reportNull$$$0(1);
            }
            if (root == null) {
                CollectionFiles.$$$reportNull$$$0(2);
            }
            this.myFirstOther = HttpRequestOpenCollectionAction.getCollectionName(HttpRequestOpenCollectionAction.FIRST_OTHER);
            this.myBuiltinFiles = files;
            this.myProvidedFiles = providedFiles;
            this.myRoot = root;
        }

        @Nullable
        static CollectionFiles create() {
            VirtualFile root = HttpRequestCollectionProvider.getCollectionFolder();
            if (root == null) {
                return null;
            }
            Map builtinFiles = (Map)((StreamEx)StreamEx.of((Object[])root.getChildren()).filter(file -> FileUtilRt.extensionEquals((String)file.getPath(), (String)HttpRequestFileType.INSTANCE.getDefaultExtension()))).map(file -> file.getName()).collect(Collectors.toMap(name -> HttpRequestOpenCollectionAction.getCollectionName(name), name -> name));
            if (builtinFiles.isEmpty()) {
                return null;
            }
            HashMap<String, VirtualFile> providedFiles = new HashMap<String, VirtualFile>();
            for (HttpRequestOpenCollectionExternalProvider provider : HttpRequestOpenCollectionExternalProvider.getProviders()) {
                providedFiles.putAll(provider.provideCollectionFiles());
            }
            return new CollectionFiles(builtinFiles, providedFiles, root);
        }

        @NotNull List<@NlsActions.ActionText String> getOrderedActions() {
            ArrayList<String> actions = new ArrayList<String>(this.myBuiltinFiles.keySet());
            actions.addAll(this.myProvidedFiles.keySet());
            actions.sort(new ExampleCollectionComparator());
            actions.add(RestClientBundle.message("http.request.collection.open.help", new Object[0]));
            ArrayList<String> arrayList = actions;
            if (arrayList == null) {
                CollectionFiles.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        @Nullable
        VirtualFile findCollectionFile(@NotNull String actionText) {
            if (actionText == null) {
                CollectionFiles.$$$reportNull$$$0(4);
            }
            if (this.myBuiltinFiles.containsKey(actionText)) {
                String fileName = this.myBuiltinFiles.get(actionText);
                return this.findSelectedFile(fileName, actionText);
            }
            return this.myProvidedFiles.get(actionText);
        }

        boolean isBuiltin(@NotNull String actionText) {
            if (actionText == null) {
                CollectionFiles.$$$reportNull$$$0(5);
            }
            return this.myBuiltinFiles.containsKey(actionText);
        }

        boolean isOpenHelp(@NotNull String actionText) {
            if (actionText == null) {
                CollectionFiles.$$$reportNull$$$0(6);
            }
            return RestClientBundle.message("http.request.collection.open.help", new Object[0]).equals(actionText);
        }

        boolean isFirstOther(@NotNull String actionText) {
            if (actionText == null) {
                CollectionFiles.$$$reportNull$$$0(7);
            }
            return this.myFirstOther.equals(actionText);
        }

        boolean isPromotedWhatsNew(@NotNull String actionText) {
            if (actionText == null) {
                CollectionFiles.$$$reportNull$$$0(8);
            }
            return HttpClientNotificationWhatsNewService.getInstance().isWhatsNewNeeded() && CollectionFiles.isWhatsNewCollection(actionText);
        }

        @RequiresBackgroundThread
        @Nullable
        private VirtualFile findSelectedFile(@NotNull String name, @NotNull String action) {
            if (name == null) {
                CollectionFiles.$$$reportNull$$$0(9);
            }
            if (action == null) {
                CollectionFiles.$$$reportNull$$$0(10);
            }
            ThreadingAssertions.assertBackgroundThread();
            if (CollectionFiles.isWhatsNewCollection(action)) {
                return HttpClientWhatsNewContentService.getInstance().getWhatsNewFile();
            }
            return ((StreamEx)StreamEx.of((Object[])this.myRoot.getChildren()).filter(file -> FileUtil.namesEqual((String)file.getName(), (String)name))).findAny().orElse(null);
        }

        private static boolean isWhatsNewCollection(String collectionName) {
            if (collectionName == null) {
                return false;
            }
            String message = RestClientBundle.message("http.request.collection.whats.new", new Object[0]);
            return message.equals(collectionName) || message.equals(StringUtil.trimStart((String)collectionName, (String)"*"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "providedFiles";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/actions/HttpRequestOpenCollectionAction$CollectionFiles";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionText";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/actions/HttpRequestOpenCollectionAction$CollectionFiles";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrderedActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findCollectionFile";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isBuiltin";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isOpenHelp";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isFirstOther";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isPromotedWhatsNew";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "findSelectedFile";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }

        private class ExampleCollectionComparator
        implements Comparator<String> {
            private ExampleCollectionComparator() {
            }

            @Override
            public int compare(String o1, String o2) {
                boolean isSecondOther;
                boolean isFirstOther;
                if (HttpClientNotificationWhatsNewService.getInstance().isWhatsNewNeeded()) {
                    if (CollectionFiles.isWhatsNewCollection(o1)) {
                        return -1;
                    }
                    if (CollectionFiles.isWhatsNewCollection(o2)) {
                        return 1;
                    }
                } else {
                    if (CollectionFiles.isWhatsNewCollection(o1)) {
                        return 1;
                    }
                    if (CollectionFiles.isWhatsNewCollection(o2)) {
                        return -1;
                    }
                }
                if ((isFirstOther = this.isOtherExample(o1)) == (isSecondOther = this.isOtherExample(o2))) {
                    return o1.compareTo(o2);
                }
                if (isFirstOther) {
                    return 1;
                }
                return -1;
            }

            private boolean isOtherExample(@NotNull String exampleName) {
                if (exampleName == null) {
                    ExampleCollectionComparator.$$$reportNull$$$0(0);
                }
                if (OTHER_EXAMPLE_FILES.stream().map(HttpRequestOpenCollectionAction::getCollectionName).anyMatch(exampleName::equalsIgnoreCase)) {
                    return true;
                }
                return CollectionFiles.this.myProvidedFiles.containsKey(exampleName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exampleName", "com/intellij/httpClient/actions/HttpRequestOpenCollectionAction$CollectionFiles$ExampleCollectionComparator", "isOtherExample"));
            }
        }
    }
}

