/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.history.CommitFileState;
import com.intellij.vcs.log.history.FileHistory;
import com.intellij.vcs.log.history.FileHistoryFilterer;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0013\u001a\u00020\u0014*\u00020\nH\u0007J\u0019\u0010\u0015\u001a\u00020\u0016*\u00020\u00162\u0006\u0010\t\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0017J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000fH\u0007J\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u0019*\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000fH\u0007J\u0014\u0010\u001c\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000fH\u0007J\u0012\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001e*\u00020\nH\u0007R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\t\u001a\u00020\u0006*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryPaths;", "", "<init>", "()V", "FILE_HISTORY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/vcs/log/history/FileHistory;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "fileHistory", "Lcom/intellij/vcs/log/VcsLogDataPack;", "getFileHistory", "(Lcom/intellij/vcs/log/VcsLogDataPack;)Lcom/intellij/vcs/log/history/FileHistory;", "commitToFileStateMap", "", "", "Lcom/intellij/vcs/log/history/CommitFileState;", "getCommitToFileStateMap", "(Lcom/intellij/vcs/log/VcsLogDataPack;)Ljava/util/Map;", "hasPathsInformation", "", "withFileHistory", "Lcom/intellij/vcs/log/visible/VisiblePack;", "withFileHistory$intellij_platform_vcs_log_impl", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "commit", "filePathOrDefault", "isDeletedInCommit", "filePaths", "", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistoryPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryPaths.kt\ncom/intellij/vcs/log/history/FileHistoryPaths\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1628#2,3:51\n*S KotlinDebug\n*F\n+ 1 FileHistoryPaths.kt\ncom/intellij/vcs/log/history/FileHistoryPaths\n*L\n46#1:51,3\n*E\n"})
public final class FileHistoryPaths {
    @NotNull
    public static final FileHistoryPaths INSTANCE = new FileHistoryPaths();
    @NotNull
    private static final Key<FileHistory> FILE_HISTORY;

    private FileHistoryPaths() {
    }

    @NotNull
    public final FileHistory getFileHistory(@NotNull VcsLogDataPack $this$fileHistory) {
        Intrinsics.checkNotNullParameter((Object)$this$fileHistory, (String)"<this>");
        if (!($this$fileHistory instanceof VisiblePack)) {
            return FileHistory.Companion.getEMPTY$intellij_platform_vcs_log_impl();
        }
        FileHistory fileHistory = (FileHistory)FILE_HISTORY.get((UserDataHolder)$this$fileHistory);
        if (fileHistory == null) {
            fileHistory = FileHistory.Companion.getEMPTY$intellij_platform_vcs_log_impl();
        }
        return fileHistory;
    }

    private final Map<Integer, CommitFileState> getCommitToFileStateMap(VcsLogDataPack $this$commitToFileStateMap) {
        return this.getFileHistory($this$commitToFileStateMap).getCommitToFileStateMap$intellij_platform_vcs_log_impl();
    }

    @JvmStatic
    public static final boolean hasPathsInformation(@NotNull VcsLogDataPack $this$hasPathsInformation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasPathsInformation, (String)"<this>");
        if (!($this$hasPathsInformation instanceof VisiblePack)) {
            return false;
        }
        return FILE_HISTORY.isIn((UserDataHolder)$this$hasPathsInformation);
    }

    @NotNull
    public final VisiblePack withFileHistory$intellij_platform_vcs_log_impl(@NotNull VisiblePack $this$withFileHistory, @NotNull FileHistory fileHistory) {
        Intrinsics.checkNotNullParameter((Object)$this$withFileHistory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileHistory, (String)"fileHistory");
        $this$withFileHistory.putUserData(FILE_HISTORY, fileHistory);
        return $this$withFileHistory;
    }

    @JvmStatic
    @Nullable
    public static final FilePath filePath(@NotNull VcsLogDataPack $this$filePath, int commit) {
        Intrinsics.checkNotNullParameter((Object)$this$filePath, (String)"<this>");
        CommitFileState commitFileState = INSTANCE.getCommitToFileStateMap($this$filePath).get(commit);
        return commitFileState != null ? commitFileState.getFilePath() : null;
    }

    @JvmStatic
    @Nullable
    public static final FilePath filePathOrDefault(@NotNull VcsLogDataPack $this$filePathOrDefault, int commit) {
        Intrinsics.checkNotNullParameter((Object)$this$filePathOrDefault, (String)"<this>");
        CommitFileState commitFileState = INSTANCE.getCommitToFileStateMap($this$filePathOrDefault).get(commit);
        if (commitFileState == null || (commitFileState = commitFileState.getFilePath()) == null) {
            VcsLogFilterCollection vcsLogFilterCollection = $this$filePathOrDefault.getFilters();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"getFilters(...)");
            commitFileState = FileHistoryFilterer.Companion.getFilePath(vcsLogFilterCollection);
        }
        return commitFileState;
    }

    @JvmStatic
    public static final boolean isDeletedInCommit(@NotNull VcsLogDataPack $this$isDeletedInCommit, int commit) {
        Intrinsics.checkNotNullParameter((Object)$this$isDeletedInCommit, (String)"<this>");
        CommitFileState commitFileState = INSTANCE.getCommitToFileStateMap($this$isDeletedInCommit).get(commit);
        return commitFileState != null ? commitFileState.getDeleted() : false;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Set<FilePath> filePaths(@NotNull VcsLogDataPack $this$filePaths) {
        void var2_2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$filePaths, (String)"<this>");
        Iterable iterable = INSTANCE.getCommitToFileStateMap($this$filePaths).values();
        Set set = CollectionFactory.createCustomHashingStrategySet(FileHistoryKt.FILE_PATH_HASHING_STRATEGY);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createCustomHashingStrategySet(...)");
        Collection destination$iv = set;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            CommitFileState commitFileState = (CommitFileState)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getFilePath());
        }
        return (Set)var2_2;
    }

    static {
        Key key = Key.create((String)"FILE_HISTORY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        FILE_HISTORY = key;
    }
}

