/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.project;

import com.intellij.indexing.shared.generator.IndexChunk;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/intellij/indexing/shared/ultimate/project/ProjectIndexChunk;", "Lcom/intellij/indexing/shared/generator/IndexChunk;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "name", "", "Lorg/jetbrains/annotations/NotNull;", "getName", "()Ljava/lang/String;", "kind", "getKind", "rootIterators", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "getRootIterators", "()Ljava/util/List;", "toString", "intellij.indexing.shared.ultimate"})
public final class ProjectIndexChunk
implements IndexChunk {
    @NotNull
    private final Project project;
    @NotNull
    private final String name;
    @NotNull
    private final String kind;

    public ProjectIndexChunk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        String string = FileUtil.sanitizeFileName((String)this.project.getName(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sanitizeFileName(...)");
        this.name = string;
        this.kind = "project";
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getKind() {
        return this.kind;
    }

    @NotNull
    public List<IndexableFilesIterator> getRootIterators() {
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        FileBasedIndexImpl fileBasedIndex2 = (FileBasedIndexImpl)fileBasedIndex;
        List list = fileBasedIndex2.getIndexableFilesProviders(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIndexableFilesProviders(...)");
        return list;
    }

    @NotNull
    public String toString() {
        return "Project Index Chunk for '" + this.getName() + "'";
    }
}

