/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.parsing.parser.args;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.jinja.Jinja2Bundle;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.jinja.template.parsing.parser.DjangoTemplateParsing;
import com.intellij.jinja.template.psi.Jinja2TemplateElementTypes;
import com.intellij.lang.PsiBuilder;
import com.jetbrains.django.lang.template.parsing.parser.args.DjangoTagArgument;
import com.jetbrains.django.ui.DjangoBundle;
import java.util.Set;

public class DjangoIdArgument
extends DjangoTagArgument {
    private final Set<String> myOptions;

    public DjangoIdArgument(String ... options) {
        this.myOptions = Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])options));
    }

    @Override
    public boolean parse(PsiBuilder builder, DjangoTemplateParsing templateParser) {
        if (builder.getTokenType() != DjangoTemplateTokenTypes.ID) {
            this.setError(Jinja2Bundle.message("django.parsing.error.identifier.expected", new Object[0]));
            return false;
        }
        PsiBuilder.Marker id = builder.mark();
        if (!this.myOptions.contains(builder.getTokenText())) {
            templateParser.errorAdvance(DjangoBundle.message("django.parsing.error.expected.one.of", DjangoIdArgument.options(this.myOptions)));
            id.drop();
            return false;
        }
        builder.advanceLexer();
        id.done(Jinja2TemplateElementTypes.NAMED_EXPR);
        return true;
    }

    private static String options(Set<String> options) {
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        for (String s : options) {
            if (flag) {
                sb.append(", ");
            }
            sb.append(s);
            flag = true;
        }
        return sb.toString();
    }
}

