/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.providers;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.scientific.py.tables.api.PyDevdID;
import com.intellij.scientific.py.tables.commands.DSTableParserKt;
import com.intellij.scientific.py.tables.panel.statistics.PyStatisticsTableHeaderDescriptionFormatting;
import com.intellij.scientific.py.tables.providers.PyDevdTableDataProviderWithAdditionalData;
import com.intellij.scientific.tables.DSTableBundle;
import com.intellij.scientific.tables.DSTableDataException;
import com.intellij.scientific.tables.DSTableRawData;
import com.intellij.scientific.tables.DataId;
import com.intellij.scientific.tables.api.ColumnDescriptionStatistics;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.DescriptionStatisticsValue;
import com.intellij.scientific.tables.api.FilterComparisonType;
import com.intellij.scientific.tables.api.FilterExpression;
import com.intellij.scientific.tables.api.StatisticsTooltipFields;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u0014J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lcom/intellij/scientific/py/tables/providers/PyPolarsBaseProvider;", "Lcom/intellij/scientific/py/tables/providers/PyDevdTableDataProviderWithAdditionalData;", "<init>", "()V", "pydevdId", "Lcom/intellij/scientific/py/tables/api/PyDevdID;", "getPydevdId", "()Lcom/intellij/scientific/py/tables/api/PyDevdID;", "parseStaticTableToTableData", "Lcom/intellij/scientific/tables/DSTableRawData;", "id", "Lcom/intellij/scientific/tables/DataId;", "table", "", "parseStaticTableToFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "text", "isFallbackToStaticTableSupported", "", "composeFilterCommandOneColumn", "columnVariable", "filterExpression", "Lcom/intellij/scientific/tables/api/FilterExpression$SingleExpression;", "parseDescribeCommandResult", "", "Lcom/intellij/scientific/tables/api/ColumnDescriptionStatistics;", "dataFrameRowsCount", "", "describeCommandResult", "getSupportedFilterComparisonTypes", "Lcom/intellij/scientific/tables/api/FilterComparisonType;", "PolarsBaseUtils", "ForTestsPolarsDescribeParsingObject", "intellij.scientific.py.tables"})
public abstract class PyPolarsBaseProvider
extends PyDevdTableDataProviderWithAdditionalData {
    @NotNull
    public static final PolarsBaseUtils PolarsBaseUtils = new PolarsBaseUtils(null);
    @NotNull
    private final PyDevdID pydevdId = PyDevdID.POLARS;
    @NotNull
    private static final Set<String> integerStatistics;
    @NotNull
    private static final Map<String, String> statisticsNamesMap;

    @Override
    @NotNull
    public PyDevdID getPydevdId() {
        return this.pydevdId;
    }

    @NotNull
    public DSTableRawData parseStaticTableToTableData(@NotNull DataId id, @NotNull String table) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return DSTableParserKt.parseTableHtmlToData(id, table);
    }

    @NotNull
    public DSDataFrameInfo parseStaticTableToFrameInfo(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        DSDataFrameInfo dSDataFrameInfo = PolarsBaseUtils.extractFrameInfo(text);
        if (dSDataFrameInfo == null) {
            Attachment[] attachmentArray = new Attachment[]{new Attachment("data.txt", text)};
            throw new RuntimeExceptionWithAttachments("Can't extract table info from the data", attachmentArray);
        }
        return dSDataFrameInfo;
    }

    public boolean isFallbackToStaticTableSupported() {
        return true;
    }

    @Override
    @NotNull
    public String composeFilterCommandOneColumn(@NotNull String columnVariable, @NotNull FilterExpression.SingleExpression filterExpression) {
        Intrinsics.checkNotNullParameter((Object)columnVariable, (String)"columnVariable");
        Intrinsics.checkNotNullParameter((Object)filterExpression, (String)"filterExpression");
        return switch (WhenMappings.$EnumSwitchMapping$0[filterExpression.getCondition().ordinal()]) {
            case 1 -> columnVariable + ".is_null()";
            case 2 -> columnVariable + ".is_not_null()";
            case 3 -> columnVariable + ".is_nan()";
            case 4 -> columnVariable + ".is_not_nan()";
            case 5 -> columnVariable + ".is_in(" + filterExpression.getFilterValue() + ")";
            case 6 -> "~" + columnVariable + ".is_in(" + filterExpression.getFilterValue() + ")";
            case 7 -> columnVariable + ".str.contains(" + filterExpression.getFilterValue() + ")";
            case 8 -> columnVariable + ".str.starts_with(" + filterExpression.getFilterValue() + ")";
            case 9 -> columnVariable + ".str.ends_with(" + filterExpression.getFilterValue() + ")";
            default -> this.composeFilterCommandOneColumnCommon(columnVariable, filterExpression);
        };
    }

    @Override
    @Nullable
    protected List<ColumnDescriptionStatistics> parseDescribeCommandResult(int dataFrameRowsCount, @NotNull String describeCommandResult) {
        Intrinsics.checkNotNullParameter((Object)describeCommandResult, (String)"describeCommandResult");
        return PolarsBaseUtils.parseDescribeCommandResult(dataFrameRowsCount, describeCommandResult);
    }

    @NotNull
    public List<FilterComparisonType> getSupportedFilterComparisonTypes() {
        return CollectionsKt.toList((Iterable)((Iterable)FilterComparisonType.getEntries()));
    }

    static {
        Object[] objectArray = new String[]{"\"count\"", "\"null_count\""};
        integerStatistics = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"\"null_count\"", (Object)StatisticsTooltipFields.INSTANCE.getMissing()), TuplesKt.to((Object)"\"count\"", (Object)StatisticsTooltipFields.INSTANCE.getCount()), TuplesKt.to((Object)"\"5%\"", (Object)StatisticsTooltipFields.INSTANCE.getPercentile5()), TuplesKt.to((Object)"\"25%\"", (Object)StatisticsTooltipFields.INSTANCE.getPercentile25()), TuplesKt.to((Object)"\"50%\"", (Object)StatisticsTooltipFields.INSTANCE.getMedian()), TuplesKt.to((Object)"\"75%\"", (Object)StatisticsTooltipFields.INSTANCE.getPercentile75()), TuplesKt.to((Object)"\"95%\"", (Object)StatisticsTooltipFields.INSTANCE.getPercentile95()), TuplesKt.to((Object)"\"std\"", (Object)StatisticsTooltipFields.INSTANCE.getStdDeviation()), TuplesKt.to((Object)"\"min\"", (Object)StatisticsTooltipFields.INSTANCE.getMin()), TuplesKt.to((Object)"\"max\"", (Object)StatisticsTooltipFields.INSTANCE.getMax()), TuplesKt.to((Object)"\"mean\"", (Object)StatisticsTooltipFields.INSTANCE.getMean())};
        statisticsNamesMap = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/scientific/py/tables/providers/PyPolarsBaseProvider$ForTestsPolarsDescribeParsingObject;", "", "<init>", "()V", "parseDescribeCommandResult", "", "Lcom/intellij/scientific/tables/api/ColumnDescriptionStatistics;", "dataFrameRowsCount", "", "describeCommandResult", "", "intellij.scientific.py.tables"})
    @TestOnly
    public static final class ForTestsPolarsDescribeParsingObject {
        @NotNull
        public static final ForTestsPolarsDescribeParsingObject INSTANCE = new ForTestsPolarsDescribeParsingObject();

        private ForTestsPolarsDescribeParsingObject() {
        }

        @Nullable
        public final List<ColumnDescriptionStatistics> parseDescribeCommandResult(int dataFrameRowsCount, @NotNull String describeCommandResult) {
            Intrinsics.checkNotNullParameter((Object)describeCommandResult, (String)"describeCommandResult");
            return PolarsBaseUtils.parseDescribeCommandResult(dataFrameRowsCount, describeCommandResult);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/scientific/py/tables/providers/PyPolarsBaseProvider$PolarsBaseUtils;", "", "<init>", "()V", "extractFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "text", "", "parseDescribeCommandResult", "", "Lcom/intellij/scientific/tables/api/ColumnDescriptionStatistics;", "dataFrameRowsCount", "", "describeCommandResult", "makeMissingStatisticFirst", "", "columnDescriptionInfo", "", "Lcom/intellij/scientific/tables/api/DescriptionStatisticsValue;", "countValuesStatistic", "integerStatistics", "", "statisticsNamesMap", "", "PolarsStatistics", "intellij.scientific.py.tables"})
    @SourceDebugExtension(value={"SMAP\nPyPolarsBaseProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPolarsBaseProvider.kt\ncom/intellij/scientific/py/tables/providers/PyPolarsBaseProvider$PolarsBaseUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1557#2:203\n1628#2,3:204\n1557#2:208\n1628#2,3:209\n360#2,7:212\n230#2,2:219\n360#2,7:221\n1#3:207\n*S KotlinDebug\n*F\n+ 1 PyPolarsBaseProvider.kt\ncom/intellij/scientific/py/tables/providers/PyPolarsBaseProvider$PolarsBaseUtils\n*L\n56#1:203\n56#1:204,3\n103#1:208\n103#1:209,3\n136#1:212,7\n153#1:219,2\n159#1:221,7\n*E\n"})
    public static final class PolarsBaseUtils {
        private PolarsBaseUtils() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final DSDataFrameInfo extractFrameInfo(@NotNull String text) {
            Object object;
            ArrayList<Integer> arrayList;
            ArrayList<Integer> destination$iv$iv22;
            List list;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Document jsoupParsed = Jsoup.parse((String)text);
            String shape = jsoupParsed.select("small").text();
            Regex regex = new Regex("shape: \\(([0-9_]+), ?([0-9_]+)?\\)");
            Intrinsics.checkNotNull((Object)shape);
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)shape, (int)0, (int)2, null);
            if (matchResult != null && (list = matchResult.getGroupValues()) != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = list;
                boolean $i$f$map = false;
                void var10_9 = $this$map$iv;
                destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    arrayList = destination$iv$iv22;
                    boolean bl = false;
                    arrayList.add(StringsKt.toIntOrNull((String)StringsKt.replace$default((String)it, (String)"_", (String)"", (boolean)false, (int)4, null)));
                }
            } else {
                return null;
            }
            List list2 = destination$iv$iv22;
            Integer rows = (Integer)list2.get(1);
            Integer columns = (Integer)list2.get(2);
            if (rows == null) {
                return null;
            }
            boolean isSeries = columns == null;
            DSTableDataType type = isSeries ? DSTableDataType.POLARS_SERIES : DSTableDataType.POLARS_DATA_FRAME;
            Intrinsics.checkNotNull((Object)jsoupParsed);
            List<String> columnNames = DSTableParserKt.getColsFromDocument(jsoupParsed);
            int destination$iv$iv22 = columnNames.size();
            ArrayList<Integer> $i$f$mapTo = new ArrayList<Integer>(destination$iv$iv22);
            int n = 0;
            while (n < destination$iv$iv22) {
                int n2;
                int it = n2 = n++;
                arrayList = $i$f$mapTo;
                boolean bl = false;
                arrayList.add(null);
            }
            List columnTypes = $i$f$mapTo;
            int parsedRowsSize = jsoupParsed.select("table[class=dataframe]").select("tbody").select("tr").size();
            if (isSeries) {
                object = 1;
            } else {
                object = columns;
                if (object == null) {
                    object = "";
                }
            }
            Integer columnsCountToDisplay = object;
            Object[] objectArray = new Object[]{rows, columnsCountToDisplay};
            String dimensions = DSTableBundle.message((String)"ds.table.dimensions.info", (Object[])objectArray);
            return new DSDataFrameInfo(parsedRowsSize, 0, columnNames, columnTypes, dimensions, type, type.getDocumentationUrl(), null, null, null, 896, null);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<ColumnDescriptionStatistics> parseDescribeCommandResult(int dataFrameRowsCount, @NotNull String describeCommandResult) {
            void $this$mapTo$iv$iv;
            DSTableRawData dSTableRawData;
            Intrinsics.checkNotNullParameter((Object)describeCommandResult, (String)"describeCommandResult");
            if (StringsKt.isBlank((CharSequence)describeCommandResult)) {
                return null;
            }
            try {
                dSTableRawData = DSTableParserKt.parseTableHtmlToData(new DataId(0, 1, null), describeCommandResult);
            }
            catch (DSTableDataException dSTableDataException) {
                return null;
            }
            DSTableRawData describeResultsParsed = dSTableRawData;
            if (describeResultsParsed.getCols() == null) {
                return CollectionsKt.emptyList();
            }
            List transposedDescribeResults = new ArrayList();
            List list = describeResultsParsed.getCols();
            Intrinsics.checkNotNull((Object)list);
            Iterable $this$map$iv = (Iterable)list.get(0);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object object = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
            List statisticsNames = (List)destination$iv$iv;
            List list2 = describeResultsParsed.getCols();
            Intrinsics.checkNotNull((Object)list2);
            Iterator iterator2 = ((Iterable)list2).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int columnIndex = n++;
                List currentColumnStatValues = (List)iterator2.next();
                if (columnIndex == 0) continue;
                List currentColumnDescInfo = new ArrayList();
                List curColumnStatNameToStatValue = CollectionsKt.zip((Iterable)statisticsNames, (Iterable)currentColumnStatValues);
                for (Object object : curColumnStatNameToStatValue) {
                    String statName = (String)object.component1();
                    Object statValue = object.component2();
                    UtilKt.addIfNotNull((List)currentColumnDescInfo, (Object)PyStatisticsTableHeaderDescriptionFormatting.INSTANCE.formatDescriptionPair(statName, statValue.toString(), integerStatistics, statisticsNamesMap));
                }
                this.countValuesStatistic(dataFrameRowsCount, currentColumnDescInfo);
                this.makeMissingStatisticFirst(currentColumnDescInfo);
                transposedDescribeResults.add(new ColumnDescriptionStatistics(currentColumnDescInfo));
            }
            return transposedDescribeResults;
        }

        private final void makeMissingStatisticFirst(List<DescriptionStatisticsValue> columnDescriptionInfo) {
            int missingStatisticsIndex;
            block3: {
                int n;
                List<DescriptionStatisticsValue> $this$indexOfFirst$iv = columnDescriptionInfo;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<DescriptionStatisticsValue> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    DescriptionStatisticsValue item$iv;
                    DescriptionStatisticsValue it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getStatisticsName(), (Object)StatisticsTooltipFields.INSTANCE.getMissing())) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = missingStatisticsIndex = -1;
            }
            if (missingStatisticsIndex >= 0) {
                DescriptionStatisticsValue missingStatistics = columnDescriptionInfo.remove(missingStatisticsIndex);
                columnDescriptionInfo.add(0, missingStatistics);
            }
        }

        private final void countValuesStatistic(int dataFrameRowsCount, List<DescriptionStatisticsValue> columnDescriptionInfo) {
            int countStatisticsIndex;
            int countValue;
            block7: {
                int n;
                Object element$iv2;
                block6: {
                    Iterable $this$first$iv = columnDescriptionInfo;
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        DescriptionStatisticsValue it = (DescriptionStatisticsValue)element$iv2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getStatisticsName(), (Object)StatisticsTooltipFields.INSTANCE.getMissing())) continue;
                        break block6;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                DescriptionStatisticsValue missingStatistics = (DescriptionStatisticsValue)element$iv2;
                if (Intrinsics.areEqual((Object)missingStatistics.getStatisticsValue(), (Object)"0")) {
                    return;
                }
                Integer n2 = StringsKt.toIntOrNull((String)missingStatistics.getStatisticsValue());
                if (n2 == null) {
                    return;
                }
                int parsedMissing = n2;
                countValue = dataFrameRowsCount - parsedMissing;
                List<DescriptionStatisticsValue> $this$indexOfFirst$iv = columnDescriptionInfo;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<DescriptionStatisticsValue> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    DescriptionStatisticsValue item$iv;
                    DescriptionStatisticsValue it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getStatisticsName(), (Object)StatisticsTooltipFields.INSTANCE.getCount())) {
                        n = index$iv;
                        break block7;
                    }
                    ++index$iv;
                }
                n = countStatisticsIndex = -1;
            }
            if (countStatisticsIndex < 0) {
                return;
            }
            columnDescriptionInfo.set(countStatisticsIndex, DescriptionStatisticsValue.copy$default((DescriptionStatisticsValue)columnDescriptionInfo.get(countStatisticsIndex), null, (String)String.valueOf(countValue), (int)1, null));
        }

        public /* synthetic */ PolarsBaseUtils(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/scientific/py/tables/providers/PyPolarsBaseProvider$PolarsBaseUtils$PolarsStatistics;", "", "<init>", "()V", "count", "", "missing", "percentile5", "percentile25", "median", "percentile75", "percentile95", "stdDeviation", "min", "max", "mean", "intellij.scientific.py.tables"})
        private static final class PolarsStatistics {
            @NotNull
            public static final PolarsStatistics INSTANCE = new PolarsStatistics();
            @NotNull
            public static final String count = "\"count\"";
            @NotNull
            public static final String missing = "\"null_count\"";
            @NotNull
            public static final String percentile5 = "\"5%\"";
            @NotNull
            public static final String percentile25 = "\"25%\"";
            @NotNull
            public static final String median = "\"50%\"";
            @NotNull
            public static final String percentile75 = "\"75%\"";
            @NotNull
            public static final String percentile95 = "\"95%\"";
            @NotNull
            public static final String stdDeviation = "\"std\"";
            @NotNull
            public static final String min = "\"min\"";
            @NotNull
            public static final String max = "\"max\"";
            @NotNull
            public static final String mean = "\"mean\"";

            private PolarsStatistics() {
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilterComparisonType.values().length];
            try {
                nArray[FilterComparisonType.IS_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.IS_NOT_NONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.IS_NAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.IS_NOT_NAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.IN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.NOT_IN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.CONTAINS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.STARTS_WITH.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.ENDS_WITH.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

