/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.python.profiler.ProfileSessionKt;
import com.intellij.python.profiler.ProfilerCommunication;
import java.net.ServerSocket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/python/profiler/ProfileSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "serverSocket", "Ljava/net/ServerSocket;", "name", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Lcom/intellij/execution/ExecutionResult;Ljava/net/ServerSocket;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "profilerCommunication", "Lcom/intellij/python/profiler/ProfilerCommunication;", "getProfilerCommunication", "()Lcom/intellij/python/profiler/ProfilerCommunication;", "contentDescriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "getContentDescriptor", "()Lcom/intellij/execution/ui/RunContentDescriptor;", "intellij.python.profiler"})
public final class ProfileSession {
    @NotNull
    private final Project project;
    @NotNull
    private final ProfilerCommunication profilerCommunication;
    @NotNull
    private final RunContentDescriptor contentDescriptor;

    public ProfileSession(@NotNull Project project, @NotNull Sdk sdk, @NotNull ExecutionResult executionResult, @NotNull ServerSocket serverSocket2, @NlsSafe @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
        Intrinsics.checkNotNullParameter((Object)serverSocket2, (String)"serverSocket");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.project = project;
        this.profilerCommunication = new ProfilerCommunication(this.project, sdk, serverSocket2, executionResult.getProcessHandler());
        ExecutionConsole executionConsole = executionResult.getExecutionConsole();
        Intrinsics.checkNotNull((Object)executionConsole, (String)"null cannot be cast to non-null type com.intellij.execution.ui.ConsoleView");
        ConsoleView consoleView = (ConsoleView)executionConsole;
        ProcessHandler processHandler = executionResult.getProcessHandler();
        Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
        this.contentDescriptor = ProfileSessionKt.access$buildProfileRunContentDescriptor(this.project, consoleView, processHandler, this.profilerCommunication, name);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProfilerCommunication getProfilerCommunication() {
        return this.profilerCommunication;
    }

    @NotNull
    public final RunContentDescriptor getContentDescriptor() {
        return this.contentDescriptor;
    }
}

