/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trialPromotion;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.platform.trialPromotion.StandardTrialPromotionBundle;
import com.intellij.ui.LicensingFacade;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/trialPromotion/TrialStateUtils;", "", "<init>", "()V", "getExpiresInDays", "", "()Ljava/lang/Integer;", "getTrialLengthDays", "showTrialEndedDialog", "", "showRegister", "intellij.platform.trialPromotion"})
public final class TrialStateUtils {
    @NotNull
    public static final TrialStateUtils INSTANCE = new TrialStateUtils();

    private TrialStateUtils() {
    }

    @Nullable
    public final Integer getExpiresInDays() {
        Object object = LicensingFacade.getInstance();
        if (object == null || (object = ((LicensingFacade)object).expirationDate) == null) {
            return null;
        }
        Object date = object;
        return (int)ChronoUnit.DAYS.between(Instant.now(), ((Date)date).toInstant());
    }

    public final int getTrialLengthDays() {
        Date date;
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        if (licensingFacade == null) {
            return 0;
        }
        LicensingFacade license = licensingFacade;
        Date date2 = license.getLicenseExpirationDate();
        if (date2 == null) {
            return 0;
        }
        Date expirationDate = date2;
        String metadata = license.metadata;
        if (metadata == null || metadata.length() < 20) {
            return 0;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
            String string = metadata.substring(2, 10);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return 0;
        }
        Date generationDate = date;
        long result = Math.max(ChronoUnit.DAYS.between(generationDate.toInstant(), expirationDate.toInstant()), 0L);
        return (int)result;
    }

    public final void showTrialEndedDialog() {
        int answer2 = Messages.showYesNoDialog((String)StandardTrialPromotionBundle.INSTANCE.message("trial.state.trial.ended.dialog.text", new Object[0]), (String)StandardTrialPromotionBundle.INSTANCE.message("trial.state.trial.ended.dialog.title", new Object[0]), (String)StandardTrialPromotionBundle.INSTANCE.message("trial.state.trial.ended.dialog.add.license", new Object[0]), (String)StandardTrialPromotionBundle.INSTANCE.message("trial.state.trial.ended.dialog.restart", new Object[0]), (Icon)Messages.getInformationIcon());
        if (answer2 == 0) {
            this.showRegister();
        } else {
            ApplicationManagerEx.getApplicationEx().restart(true);
        }
    }

    public final void showRegister() {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("Register");
        if (anAction == null) {
            return;
        }
        AnAction registerAction = anAction;
        AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)SimpleDataContext.builder().build(), null, (String)"", (ActionUiKind)ActionUiKind.NONE, null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        ActionUtil.performActionDumbAwareWithCallbacks((AnAction)registerAction, (AnActionEvent)anActionEvent);
    }
}

