/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.Flags;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8ImportantStringsHolder;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapGraphEdgeType;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class V8FlagsCalculator {
    private final Flags myFlags;
    private final V8CachingReader myReader;
    private V8HeapEntry myGcRoots;
    private V8HeapEntry myDocumentDOMRoot;
    private V8HeapEntry myRoot;
    private List<V8HeapEntry> myImmediateRootChildren;
    private V8HeapEntry myDetachedDOMTreesRoot;

    public V8FlagsCalculator(int numNodes, V8CachingReader reader, V8ImportantStringsHolder stringsHolder) {
        this.myReader = reader;
        this.myFlags = new Flags(numNodes);
        this.myImmediateRootChildren = new ArrayList<V8HeapEntry>();
        this.myRoot = this.myReader.getNode(0L);
        for (V8HeapEdge edge : this.myReader.getChildren(this.myRoot)) {
            V8HeapEntry node = this.myReader.getNode(edge.getToIndex());
            this.myImmediateRootChildren.add(node);
            long nameId = node.getNameId();
            if (nameId == stringsHolder.get("(Detached DOM trees)")) {
                this.myDetachedDOMTreesRoot = node;
                continue;
            }
            if (nameId == stringsHolder.get("(Document DOM trees)")) {
                this.myDocumentDOMRoot = node;
                continue;
            }
            if (nameId != stringsHolder.get("(GC roots)")) continue;
            this.myGcRoots = node;
        }
    }

    public Flags execute() {
        this.markDetachedDOMTreeNodes();
        this.markQueriableHeapObjects();
        this.markPageOwnedNodes();
        this.myRoot = null;
        this.myImmediateRootChildren = null;
        return this.myFlags;
    }

    private void markDetachedDOMTreeNodes() {
        if (this.myDetachedDOMTreesRoot == null) {
            return;
        }
        String secondPattern = "Detached DOM tree";
        for (V8HeapEdge edge : this.myReader.getChildren(this.myDetachedDOMTreesRoot)) {
            V8HeapEntry child = this.myReader.getNode(edge.getToIndex());
            if (!V8HeapNodeType.kObject.equals((Object)child.getType()) && !V8HeapNodeType.kNative.equals((Object)child.getType()) || !this.myReader.getString(child.getNameId()).startsWith("Detached DOM tree")) continue;
            for (V8HeapEdge heapEdge : this.myReader.getChildren(child)) {
                this.myFlags.addDetachedFlag((int)heapEdge.getToIndex());
            }
        }
    }

    private void markQueriableHeapObjects() {
        ArrayDeque<V8HeapEntry> queue = new ArrayDeque<V8HeapEntry>();
        for (V8HeapEntry child : this.myImmediateRootChildren) {
            if (V8HeapNodeType.kSynthetic.equals((Object)child.getType())) continue;
            queue.add(child);
        }
        while (!queue.isEmpty()) {
            V8HeapEntry entry = (V8HeapEntry)queue.removeFirst();
            if (this.myFlags.isQueriable((int)entry.getId())) continue;
            this.myFlags.addQueriableFlag((int)entry.getId());
            for (V8HeapEdge edge : this.myReader.getChildren(entry)) {
                if (V8HeapGraphEdgeType.isInternalKind(edge.getType()) || this.myFlags.isQueriable((int)edge.getToIndex())) continue;
                queue.add(this.myReader.getNode(edge.getToIndex()));
            }
        }
    }

    private void markPageOwnedNodes() {
        ArrayDeque<Long> queue = new ArrayDeque<Long>();
        for (V8HeapEdge edge : this.myReader.getChildren(this.myRoot)) {
            if ((!edge.getType().equals((Object)V8HeapGraphEdgeType.kElement) || this.myDocumentDOMRoot == null || edge.getToIndex() != this.myDocumentDOMRoot.getId()) && !edge.getType().equals((Object)V8HeapGraphEdgeType.kShortcut)) continue;
            queue.add(edge.getToIndex());
            this.myFlags.addVisited((int)edge.getToIndex());
        }
        while (!queue.isEmpty()) {
            Long index = (Long)queue.removeLast();
            int idx = index.intValue();
            this.myFlags.addPage(idx);
            this.myFlags.clearVisited(idx);
            for (V8HeapEdge edge : this.myReader.getChildrenByNodeId(index)) {
                if (this.myFlags.visitedAndPage((int)edge.getToIndex()) || V8HeapGraphEdgeType.kWeak.equals((Object)edge.getType())) continue;
                this.myFlags.addVisited((int)edge.getToIndex());
                queue.add(edge.getToIndex());
            }
        }
    }

    public V8HeapEntry getDocumentDOMRoot() {
        return this.myDocumentDOMRoot;
    }

    public V8HeapEntry getGcRoots() {
        return this.myGcRoots;
    }

    public V8HeapEntry getDetachedDOMTreesRoot() {
        return this.myDetachedDOMTreesRoot;
    }
}

