/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.ReSTService;
import com.jetbrains.python.defaultProjectAwareService.PyDefaultProjectAwareModuleConfiguratorImpl;
import com.jetbrains.python.defaultProjectAwareService.PyDefaultProjectAwareServiceModuleConfigurator;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.PyDocumentationSettingsDetector;
import com.jetbrains.python.packaging.PyPackageRequirementsSettings;
import com.jetbrains.python.testing.TestRunnerService;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class PyDefaultProjectAwareServiceConfigurator
implements DirectoryProjectConfigurator {
    private static final PyDocumentationSettingsDetector PY_DOCUMENTATION_SETTINGS_DETECTOR = new PyDocumentationSettingsDetector();

    PyDefaultProjectAwareServiceConfigurator() {
    }

    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean isProjectCreatedWithWizard) {
        Application application;
        if (project == null) {
            PyDefaultProjectAwareServiceConfigurator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            PyDefaultProjectAwareServiceConfigurator.$$$reportNull$$$0(1);
        }
        if (moduleRef == null) {
            PyDefaultProjectAwareServiceConfigurator.$$$reportNull$$$0(2);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode()) {
            return;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!(ModuleType.get((Module)module) instanceof PythonModuleTypeBase)) continue;
            PyDefaultProjectAwareServiceConfigurator.updateServices(module, isProjectCreatedWithWizard);
            break;
        }
    }

    private static void updateServices(@NotNull Module module, boolean newProject) {
        if (module == null) {
            PyDefaultProjectAwareServiceConfigurator.$$$reportNull$$$0(3);
        }
        List<PyDefaultProjectAwareServiceModuleConfigurator> configurators = Arrays.asList(TestRunnerService.getConfigurator(), new PyDefaultProjectAwareModuleConfiguratorImpl(PyDocumentationSettings.SERVICE_CLASSES, PY_DOCUMENTATION_SETTINGS_DETECTOR), ReSTService.getConfigurator(), PyPackageRequirementsSettings.getConfigurator());
        for (PyDefaultProjectAwareServiceModuleConfigurator configurator : configurators) {
            configurator.configureModule(module, newProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/configuration/PyDefaultProjectAwareServiceConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateServices";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

