/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.util.Iterator;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncPushProducer;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityProducer;
import org.apache.hc.core5.http.nio.support.BasicPushProducer;
import org.apache.hc.core5.util.Args;

public class AsyncPushBuilder {
    private int status;
    private HeaderGroup headerGroup;
    private AsyncEntityProducer entityProducer;

    AsyncPushBuilder() {
    }

    AsyncPushBuilder(int status2) {
        this.status = status2;
    }

    public static AsyncPushBuilder create(int status2) {
        Args.checkRange(status2, 100, 599, "HTTP status code");
        return new AsyncPushBuilder(status2);
    }

    public Header[] getHeaders(String name2) {
        return this.headerGroup != null ? this.headerGroup.getHeaders(name2) : null;
    }

    public AsyncPushBuilder setHeaders(Header ... headers) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.setHeaders(headers);
        return this;
    }

    public Header getFirstHeader(String name2) {
        return this.headerGroup != null ? this.headerGroup.getFirstHeader(name2) : null;
    }

    public Header getLastHeader(String name2) {
        return this.headerGroup != null ? this.headerGroup.getLastHeader(name2) : null;
    }

    public AsyncPushBuilder addHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.addHeader(header);
        return this;
    }

    public AsyncPushBuilder addHeader(String name2, String value) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.addHeader(new BasicHeader(name2, value));
        return this;
    }

    public AsyncPushBuilder removeHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.removeHeader(header);
        return this;
    }

    public AsyncPushBuilder removeHeaders(String name2) {
        if (name2 == null || this.headerGroup == null) {
            return this;
        }
        Iterator<Header> i = this.headerGroup.headerIterator();
        while (i.hasNext()) {
            Header header = i.next();
            if (!name2.equalsIgnoreCase(header.getName())) continue;
            i.remove();
        }
        return this;
    }

    public AsyncPushBuilder setHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.setHeader(header);
        return this;
    }

    public AsyncPushBuilder setHeader(String name2, String value) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.setHeader(new BasicHeader(name2, value));
        return this;
    }

    public AsyncEntityProducer getEntity() {
        return this.entityProducer;
    }

    public AsyncPushBuilder setEntity(AsyncEntityProducer entityProducer) {
        this.entityProducer = entityProducer;
        return this;
    }

    public AsyncPushBuilder setEntity(String content2, ContentType contentType) {
        this.entityProducer = new BasicAsyncEntityProducer(content2, contentType);
        return this;
    }

    public AsyncPushBuilder setEntity(String content2) {
        this.entityProducer = new BasicAsyncEntityProducer(content2);
        return this;
    }

    public AsyncPushBuilder setEntity(byte[] content2, ContentType contentType) {
        this.entityProducer = new BasicAsyncEntityProducer(content2, contentType);
        return this;
    }

    public AsyncPushProducer build() {
        BasicHttpResponse response = new BasicHttpResponse(this.status);
        if (this.headerGroup != null) {
            response.setHeaders(this.headerGroup.getHeaders());
        }
        return new BasicPushProducer(response, this.entityProducer);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AsyncPushProducer [method=");
        builder.append(this.status);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", headerGroup=");
        builder.append(this.headerGroup);
        builder.append(", entity=");
        builder.append(this.entityProducer != null ? this.entityProducer.getClass() : null);
        builder.append("]");
        return builder.toString();
    }
}

