/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.CustomFoldRegionRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/notebooks/visualization/ui/CellCustomFoldingRender;", "Lcom/intellij/openapi/editor/CustomFoldRegionRenderer;", "component", "Ljavax/swing/JPanel;", "gutterIconProvider", "Lkotlin/Function0;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "<init>", "(Ljavax/swing/JPanel;Lkotlin/jvm/functions/Function0;)V", "getComponent", "()Ljavax/swing/JPanel;", "getGutterIconProvider", "()Lkotlin/jvm/functions/Function0;", "calcWidthInPixels", "", "region", "Lcom/intellij/openapi/editor/CustomFoldRegion;", "calcHeightInPixels", "paint", "", "g", "Ljava/awt/Graphics2D;", "targetRegion", "Ljava/awt/geom/Rectangle2D;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "calcGutterIconRenderer", "intellij.notebooks.visualization"})
public final class CellCustomFoldingRender
implements CustomFoldRegionRenderer {
    @NotNull
    private final JPanel component;
    @NotNull
    private final Function0<GutterIconRenderer> gutterIconProvider;

    public CellCustomFoldingRender(@NotNull JPanel component, @NotNull Function0<? extends GutterIconRenderer> gutterIconProvider) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter(gutterIconProvider, (String)"gutterIconProvider");
        this.component = component;
        this.gutterIconProvider = gutterIconProvider;
    }

    @NotNull
    public final JPanel getComponent() {
        return this.component;
    }

    @NotNull
    public final Function0<GutterIconRenderer> getGutterIconProvider() {
        return this.gutterIconProvider;
    }

    public int calcWidthInPixels(@NotNull CustomFoldRegion region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        int width = this.component.getWidth();
        if (width == 0) {
            Dimension dimension = this.component.getPreferredSize();
            return dimension != null ? dimension.width : 0;
        }
        return width;
    }

    public int calcHeightInPixels(@NotNull CustomFoldRegion region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        int height = this.component.getHeight();
        if (height == 0) {
            Dimension dimension = this.component.getPreferredSize();
            return dimension != null ? dimension.height : 0;
        }
        return height;
    }

    public void paint(@NotNull CustomFoldRegion region, @NotNull Graphics2D g, @NotNull Rectangle2D targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
    }

    @Nullable
    public GutterIconRenderer calcGutterIconRenderer(@NotNull CustomFoldRegion region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        return (GutterIconRenderer)this.gutterIconProvider.invoke();
    }
}

