import { HKT2, Type2, Type3, URIS2, URIS3 } from './HKT';
/**
 * @since 1.0.0
 */
export interface Bifunctor<F> {
    readonly URI: F;
    readonly bimap: <L, A, M, B>(fla: HKT2<F, L, A>, f: (l: L) => M, g: (a: A) => B) => HKT2<F, M, B>;
}
export interface Bifunctor2<F extends URIS2> {
    readonly URI: F;
    readonly bimap: <L, A, M, B>(fla: Type2<F, L, A>, f: (l: L) => M, g: (a: A) => B) => Type2<F, M, B>;
}
export interface Bifunctor3<F extends URIS3> {
    readonly URI: F;
    readonly bimap: <U, L, A, M, B>(fla: Type3<F, U, L, A>, f: (l: L) => M, g: (a: A) => B) => Type3<F, U, M, B>;
}
export interface Bifunctor3C<F extends URIS3, U> {
    readonly URI: F;
    readonly _U: U;
    readonly bimap: <L, A, M, B>(fla: Type3<F, U, L, A>, f: (l: L) => M, g: (a: A) => B) => Type3<F, U, M, B>;
}
