// Code generated by execgen; DO NOT EDIT.
// Copyright 2019 The Cockroach Authors.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//     http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
// implied. See the License for the specific language governing
// permissions and limitations under the License.

package exec

import (
	"fmt"

	"github.com/cockroachdb/apd"
	"github.com/cockroachdb/cockroach/pkg/sql/exec/coldata"
	"github.com/cockroachdb/cockroach/pkg/sql/exec/types"
)

// buildLeftGroups takes a []group and expands each group into the output by repeating
// each row in the group numRepeats times. For example, given an input table:
//  L1 |  L2
//  --------
//  1  |  a
//  1  |  b
// and leftGroups = [{startIdx: 0, endIdx: 2, numRepeats: 3}]
// then buildLeftGroups expands this to
//  L1 |  L2
//  --------
//  1  |  a
//  1  |  a
//  1  |  a
//  1  |  b
//  1  |  b
//  1  |  b
// Note: this is different from buildRightGroups in that each row of group is repeated
// numRepeats times, instead of a simple copy of the group as a whole.
// SIDE EFFECTS: writes into c.output (and c.savedOutput if applicable).
func (c *mergeJoinOp) buildLeftGroups(
	leftGroups []group,
	groupsLen int,
	colOffset int,
	input *mergeJoinInput,
	bat coldata.Batch,
	sel []uint16,
	destStartIdx uint16,
) (uint16, int) {
	savedOutCount := 0
	outCount := uint16(0)
	// Loop over every column.
	for _, colIdx := range input.outCols {
		savedOutCount = 0
		outCount = 0
		outStartIdx := int(destStartIdx)
		out := c.output.ColVec(int(colIdx))
		savedOut := c.savedOutput.ColVec(int(colIdx))
		src := bat.ColVec(int(colIdx))
		colType := input.sourceTypes[colIdx]

		switch colType {
		case types.Bool:
			srcCol := src.Bool()
			outCol := out.Bool()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								// TODO (georgeutsin): update template language to automatically generate template function function parameter definitions from expressions passed in.
								t_dest := out
								t_destStartIdx := outStartIdx
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx
								for i := 0; i < batchSize; i++ {
									t_dest.Bool()[i+t_destStartIdx] = t_src.Bool()[t_sel[i+t_srcStartIdx]]
								}

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx

								toCol := append(t_dest.Bool()[:t_destStartIdx], make([]bool, batchSize)...)
								fromCol := t_src.Bool()

								for i := 0; i < batchSize; i++ {
									toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
								}

								savedOut.SetCol(toCol)

								if batchSize > 0 {
									savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
								}

								savedOutCount++
							}
						}
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								copy(outCol[outStartIdx:], srcCol[srcStartIdx:srcEndIdx])

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx

								batchSize := t_srcEndIdx - t_srcStartIdx
								outputLen := t_destStartIdx + batchSize

								if outputLen > (len(savedOut.Bool())) {
									t_dest.SetCol(append(t_dest.Bool()[:t_destStartIdx], t_src.Bool()[t_srcStartIdx:t_srcEndIdx]...))
								} else {
									copy(t_dest.Bool()[t_destStartIdx:], t_src.Bool()[t_srcStartIdx:t_srcEndIdx])
								}

								if batchSize > 0 {
									t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
								}

								savedOutCount++
							}
						}
					}
				}
			}
		case types.Bytes:
			srcCol := src.Bytes()
			outCol := out.Bytes()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								// TODO (georgeutsin): update template language to automatically generate template function function parameter definitions from expressions passed in.
								t_dest := out
								t_destStartIdx := outStartIdx
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx
								for i := 0; i < batchSize; i++ {
									t_dest.Bytes()[i+t_destStartIdx] = t_src.Bytes()[t_sel[i+t_srcStartIdx]]
								}

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx

								toCol := append(t_dest.Bytes()[:t_destStartIdx], make([][]byte, batchSize)...)
								fromCol := t_src.Bytes()

								for i := 0; i < batchSize; i++ {
									toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
								}

								savedOut.SetCol(toCol)

								if batchSize > 0 {
									savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
								}

								savedOutCount++
							}
						}
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								copy(outCol[outStartIdx:], srcCol[srcStartIdx:srcEndIdx])

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx

								batchSize := t_srcEndIdx - t_srcStartIdx
								outputLen := t_destStartIdx + batchSize

								if outputLen > (len(savedOut.Bytes())) {
									t_dest.SetCol(append(t_dest.Bytes()[:t_destStartIdx], t_src.Bytes()[t_srcStartIdx:t_srcEndIdx]...))
								} else {
									copy(t_dest.Bytes()[t_destStartIdx:], t_src.Bytes()[t_srcStartIdx:t_srcEndIdx])
								}

								if batchSize > 0 {
									t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
								}

								savedOutCount++
							}
						}
					}
				}
			}
		case types.Decimal:
			srcCol := src.Decimal()
			outCol := out.Decimal()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								// TODO (georgeutsin): update template language to automatically generate template function function parameter definitions from expressions passed in.
								t_dest := out
								t_destStartIdx := outStartIdx
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx
								for i := 0; i < batchSize; i++ {
									t_dest.Decimal()[i+t_destStartIdx] = t_src.Decimal()[t_sel[i+t_srcStartIdx]]
								}

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx

								toCol := append(t_dest.Decimal()[:t_destStartIdx], make([]apd.Decimal, batchSize)...)
								fromCol := t_src.Decimal()

								for i := 0; i < batchSize; i++ {
									toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
								}

								savedOut.SetCol(toCol)

								if batchSize > 0 {
									savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
								}

								savedOutCount++
							}
						}
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								copy(outCol[outStartIdx:], srcCol[srcStartIdx:srcEndIdx])

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx

								batchSize := t_srcEndIdx - t_srcStartIdx
								outputLen := t_destStartIdx + batchSize

								if outputLen > (len(savedOut.Decimal())) {
									t_dest.SetCol(append(t_dest.Decimal()[:t_destStartIdx], t_src.Decimal()[t_srcStartIdx:t_srcEndIdx]...))
								} else {
									copy(t_dest.Decimal()[t_destStartIdx:], t_src.Decimal()[t_srcStartIdx:t_srcEndIdx])
								}

								if batchSize > 0 {
									t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
								}

								savedOutCount++
							}
						}
					}
				}
			}
		case types.Int8:
			srcCol := src.Int8()
			outCol := out.Int8()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								// TODO (georgeutsin): update template language to automatically generate template function function parameter definitions from expressions passed in.
								t_dest := out
								t_destStartIdx := outStartIdx
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx
								for i := 0; i < batchSize; i++ {
									t_dest.Int8()[i+t_destStartIdx] = t_src.Int8()[t_sel[i+t_srcStartIdx]]
								}

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx

								toCol := append(t_dest.Int8()[:t_destStartIdx], make([]int8, batchSize)...)
								fromCol := t_src.Int8()

								for i := 0; i < batchSize; i++ {
									toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
								}

								savedOut.SetCol(toCol)

								if batchSize > 0 {
									savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
								}

								savedOutCount++
							}
						}
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								copy(outCol[outStartIdx:], srcCol[srcStartIdx:srcEndIdx])

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx

								batchSize := t_srcEndIdx - t_srcStartIdx
								outputLen := t_destStartIdx + batchSize

								if outputLen > (len(savedOut.Int8())) {
									t_dest.SetCol(append(t_dest.Int8()[:t_destStartIdx], t_src.Int8()[t_srcStartIdx:t_srcEndIdx]...))
								} else {
									copy(t_dest.Int8()[t_destStartIdx:], t_src.Int8()[t_srcStartIdx:t_srcEndIdx])
								}

								if batchSize > 0 {
									t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
								}

								savedOutCount++
							}
						}
					}
				}
			}
		case types.Int16:
			srcCol := src.Int16()
			outCol := out.Int16()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								// TODO (georgeutsin): update template language to automatically generate template function function parameter definitions from expressions passed in.
								t_dest := out
								t_destStartIdx := outStartIdx
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx
								for i := 0; i < batchSize; i++ {
									t_dest.Int16()[i+t_destStartIdx] = t_src.Int16()[t_sel[i+t_srcStartIdx]]
								}

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx

								toCol := append(t_dest.Int16()[:t_destStartIdx], make([]int16, batchSize)...)
								fromCol := t_src.Int16()

								for i := 0; i < batchSize; i++ {
									toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
								}

								savedOut.SetCol(toCol)

								if batchSize > 0 {
									savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
								}

								savedOutCount++
							}
						}
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								copy(outCol[outStartIdx:], srcCol[srcStartIdx:srcEndIdx])

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx

								batchSize := t_srcEndIdx - t_srcStartIdx
								outputLen := t_destStartIdx + batchSize

								if outputLen > (len(savedOut.Int16())) {
									t_dest.SetCol(append(t_dest.Int16()[:t_destStartIdx], t_src.Int16()[t_srcStartIdx:t_srcEndIdx]...))
								} else {
									copy(t_dest.Int16()[t_destStartIdx:], t_src.Int16()[t_srcStartIdx:t_srcEndIdx])
								}

								if batchSize > 0 {
									t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
								}

								savedOutCount++
							}
						}
					}
				}
			}
		case types.Int32:
			srcCol := src.Int32()
			outCol := out.Int32()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								// TODO (georgeutsin): update template language to automatically generate template function function parameter definitions from expressions passed in.
								t_dest := out
								t_destStartIdx := outStartIdx
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx
								for i := 0; i < batchSize; i++ {
									t_dest.Int32()[i+t_destStartIdx] = t_src.Int32()[t_sel[i+t_srcStartIdx]]
								}

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx

								toCol := append(t_dest.Int32()[:t_destStartIdx], make([]int32, batchSize)...)
								fromCol := t_src.Int32()

								for i := 0; i < batchSize; i++ {
									toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
								}

								savedOut.SetCol(toCol)

								if batchSize > 0 {
									savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
								}

								savedOutCount++
							}
						}
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								copy(outCol[outStartIdx:], srcCol[srcStartIdx:srcEndIdx])

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx

								batchSize := t_srcEndIdx - t_srcStartIdx
								outputLen := t_destStartIdx + batchSize

								if outputLen > (len(savedOut.Int32())) {
									t_dest.SetCol(append(t_dest.Int32()[:t_destStartIdx], t_src.Int32()[t_srcStartIdx:t_srcEndIdx]...))
								} else {
									copy(t_dest.Int32()[t_destStartIdx:], t_src.Int32()[t_srcStartIdx:t_srcEndIdx])
								}

								if batchSize > 0 {
									t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
								}

								savedOutCount++
							}
						}
					}
				}
			}
		case types.Int64:
			srcCol := src.Int64()
			outCol := out.Int64()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								// TODO (georgeutsin): update template language to automatically generate template function function parameter definitions from expressions passed in.
								t_dest := out
								t_destStartIdx := outStartIdx
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx
								for i := 0; i < batchSize; i++ {
									t_dest.Int64()[i+t_destStartIdx] = t_src.Int64()[t_sel[i+t_srcStartIdx]]
								}

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx

								toCol := append(t_dest.Int64()[:t_destStartIdx], make([]int64, batchSize)...)
								fromCol := t_src.Int64()

								for i := 0; i < batchSize; i++ {
									toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
								}

								savedOut.SetCol(toCol)

								if batchSize > 0 {
									savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
								}

								savedOutCount++
							}
						}
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								copy(outCol[outStartIdx:], srcCol[srcStartIdx:srcEndIdx])

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx

								batchSize := t_srcEndIdx - t_srcStartIdx
								outputLen := t_destStartIdx + batchSize

								if outputLen > (len(savedOut.Int64())) {
									t_dest.SetCol(append(t_dest.Int64()[:t_destStartIdx], t_src.Int64()[t_srcStartIdx:t_srcEndIdx]...))
								} else {
									copy(t_dest.Int64()[t_destStartIdx:], t_src.Int64()[t_srcStartIdx:t_srcEndIdx])
								}

								if batchSize > 0 {
									t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
								}

								savedOutCount++
							}
						}
					}
				}
			}
		case types.Float32:
			srcCol := src.Float32()
			outCol := out.Float32()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								// TODO (georgeutsin): update template language to automatically generate template function function parameter definitions from expressions passed in.
								t_dest := out
								t_destStartIdx := outStartIdx
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx
								for i := 0; i < batchSize; i++ {
									t_dest.Float32()[i+t_destStartIdx] = t_src.Float32()[t_sel[i+t_srcStartIdx]]
								}

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx

								toCol := append(t_dest.Float32()[:t_destStartIdx], make([]float32, batchSize)...)
								fromCol := t_src.Float32()

								for i := 0; i < batchSize; i++ {
									toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
								}

								savedOut.SetCol(toCol)

								if batchSize > 0 {
									savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
								}

								savedOutCount++
							}
						}
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								copy(outCol[outStartIdx:], srcCol[srcStartIdx:srcEndIdx])

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx

								batchSize := t_srcEndIdx - t_srcStartIdx
								outputLen := t_destStartIdx + batchSize

								if outputLen > (len(savedOut.Float32())) {
									t_dest.SetCol(append(t_dest.Float32()[:t_destStartIdx], t_src.Float32()[t_srcStartIdx:t_srcEndIdx]...))
								} else {
									copy(t_dest.Float32()[t_destStartIdx:], t_src.Float32()[t_srcStartIdx:t_srcEndIdx])
								}

								if batchSize > 0 {
									t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
								}

								savedOutCount++
							}
						}
					}
				}
			}
		case types.Float64:
			srcCol := src.Float64()
			outCol := out.Float64()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								// TODO (georgeutsin): update template language to automatically generate template function function parameter definitions from expressions passed in.
								t_dest := out
								t_destStartIdx := outStartIdx
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx
								for i := 0; i < batchSize; i++ {
									t_dest.Float64()[i+t_destStartIdx] = t_src.Float64()[t_sel[i+t_srcStartIdx]]
								}

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx
								t_sel := sel

								batchSize := t_srcEndIdx - t_srcStartIdx

								toCol := append(t_dest.Float64()[:t_destStartIdx], make([]float64, batchSize)...)
								fromCol := t_src.Float64()

								for i := 0; i < batchSize; i++ {
									toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
								}

								savedOut.SetCol(toCol)

								if batchSize > 0 {
									savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
								}

								savedOutCount++
							}
						}
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					leftGroup := leftGroups[i]
					// Loop over every row in the group.
					for curSrcStartIdx := leftGroup.rowStartIdx; curSrcStartIdx < leftGroup.rowEndIdx; curSrcStartIdx++ {
						// Repeat each row numRepeats times.
						for k := 0; k < leftGroup.numRepeats; k++ {
							srcStartIdx := curSrcStartIdx
							srcEndIdx := curSrcStartIdx + 1
							if outStartIdx < int(c.outputBatchSize) {

								copy(outCol[outStartIdx:], srcCol[srcStartIdx:srcEndIdx])

								outStartIdx++
								outCount++
							} else {
								t_dest := savedOut
								t_destStartIdx := c.savedOutputEndIdx + savedOutCount
								t_src := src
								t_srcStartIdx := srcStartIdx
								t_srcEndIdx := srcEndIdx

								batchSize := t_srcEndIdx - t_srcStartIdx
								outputLen := t_destStartIdx + batchSize

								if outputLen > (len(savedOut.Float64())) {
									t_dest.SetCol(append(t_dest.Float64()[:t_destStartIdx], t_src.Float64()[t_srcStartIdx:t_srcEndIdx]...))
								} else {
									copy(t_dest.Float64()[t_destStartIdx:], t_src.Float64()[t_srcStartIdx:t_srcEndIdx])
								}

								if batchSize > 0 {
									t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
								}

								savedOutCount++
							}
						}
					}
				}
			}
		default:
			panic(fmt.Sprintf("unhandled type %d", colType))
		}
	}

	if len(input.outCols) == 0 {
		outCount = c.getExpectedOutCount(leftGroups, groupsLen)
	}

	return outCount, savedOutCount
}

// buildRightGroups takes a []group and repeats each group numRepeats times.
// For example, given an input table:
//  R1 |  R2
//  --------
//  1  |  a
//  1  |  b
// and rightGroups = [{startIdx: 0, endIdx: 2, numRepeats: 3}]
// then buildRightGroups expands this to
//  R1 |  R2
//  --------
//  1  |  a
//  1  |  b
//  1  |  a
//  1  |  b
//  1  |  a
//  1  |  b
// Note: this is different from buildLeftGroups in that each group is not expanded,
// but directly copied numRepeats times.
// SIDE EFFECTS: writes into c.output (and c.savedOutput if applicable).
func (c *mergeJoinOp) buildRightGroups(
	rightGroups []group,
	groupsLen int,
	colOffset int,
	input *mergeJoinInput,
	bat coldata.Batch,
	sel []uint16,
	destStartIdx uint16,
) {
	savedOutputCount := 0
	// Loop over every column.
	for _, colIdx := range input.outCols {
		savedOutputCount = 0
		outStartIdx := int(destStartIdx)
		out := c.output.ColVec(int(colIdx) + colOffset)
		savedOut := c.savedOutput.ColVec(int(colIdx) + colOffset)
		src := bat.ColVec(int(colIdx))
		colType := input.sourceTypes[colIdx]

		switch colType {
		case types.Bool:
			srcCol := src.Bool()
			outCol := out.Bool()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						t_dest := out
						t_destStartIdx := outStartIdx
						t_src := src
						t_srcStartIdx := rightGroup.rowStartIdx
						t_srcEndIdx := rightGroup.rowStartIdx + toAppend
						t_sel := sel

						batchSize := t_srcEndIdx - t_srcStartIdx
						for i := 0; i < batchSize; i++ {
							t_dest.Bool()[i+t_destStartIdx] = t_src.Bool()[t_sel[i+t_srcStartIdx]]
						}

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx
							t_sel := sel

							batchSize := t_srcEndIdx - t_srcStartIdx

							toCol := append(t_dest.Bool()[:t_destStartIdx], make([]bool, batchSize)...)
							fromCol := t_src.Bool()

							for i := 0; i < batchSize; i++ {
								toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
							}

							savedOut.SetCol(toCol)

							if batchSize > 0 {
								savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						copy(outCol[outStartIdx:], srcCol[rightGroup.rowStartIdx:rightGroup.rowStartIdx+toAppend])

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx

							batchSize := t_srcEndIdx - t_srcStartIdx
							outputLen := t_destStartIdx + batchSize

							if outputLen > (len(savedOut.Bool())) {
								t_dest.SetCol(append(t_dest.Bool()[:t_destStartIdx], t_src.Bool()[t_srcStartIdx:t_srcEndIdx]...))
							} else {
								copy(t_dest.Bool()[t_destStartIdx:], t_src.Bool()[t_srcStartIdx:t_srcEndIdx])
							}

							if batchSize > 0 {
								t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			}
		case types.Bytes:
			srcCol := src.Bytes()
			outCol := out.Bytes()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						t_dest := out
						t_destStartIdx := outStartIdx
						t_src := src
						t_srcStartIdx := rightGroup.rowStartIdx
						t_srcEndIdx := rightGroup.rowStartIdx + toAppend
						t_sel := sel

						batchSize := t_srcEndIdx - t_srcStartIdx
						for i := 0; i < batchSize; i++ {
							t_dest.Bytes()[i+t_destStartIdx] = t_src.Bytes()[t_sel[i+t_srcStartIdx]]
						}

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx
							t_sel := sel

							batchSize := t_srcEndIdx - t_srcStartIdx

							toCol := append(t_dest.Bytes()[:t_destStartIdx], make([][]byte, batchSize)...)
							fromCol := t_src.Bytes()

							for i := 0; i < batchSize; i++ {
								toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
							}

							savedOut.SetCol(toCol)

							if batchSize > 0 {
								savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						copy(outCol[outStartIdx:], srcCol[rightGroup.rowStartIdx:rightGroup.rowStartIdx+toAppend])

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx

							batchSize := t_srcEndIdx - t_srcStartIdx
							outputLen := t_destStartIdx + batchSize

							if outputLen > (len(savedOut.Bytes())) {
								t_dest.SetCol(append(t_dest.Bytes()[:t_destStartIdx], t_src.Bytes()[t_srcStartIdx:t_srcEndIdx]...))
							} else {
								copy(t_dest.Bytes()[t_destStartIdx:], t_src.Bytes()[t_srcStartIdx:t_srcEndIdx])
							}

							if batchSize > 0 {
								t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			}
		case types.Decimal:
			srcCol := src.Decimal()
			outCol := out.Decimal()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						t_dest := out
						t_destStartIdx := outStartIdx
						t_src := src
						t_srcStartIdx := rightGroup.rowStartIdx
						t_srcEndIdx := rightGroup.rowStartIdx + toAppend
						t_sel := sel

						batchSize := t_srcEndIdx - t_srcStartIdx
						for i := 0; i < batchSize; i++ {
							t_dest.Decimal()[i+t_destStartIdx] = t_src.Decimal()[t_sel[i+t_srcStartIdx]]
						}

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx
							t_sel := sel

							batchSize := t_srcEndIdx - t_srcStartIdx

							toCol := append(t_dest.Decimal()[:t_destStartIdx], make([]apd.Decimal, batchSize)...)
							fromCol := t_src.Decimal()

							for i := 0; i < batchSize; i++ {
								toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
							}

							savedOut.SetCol(toCol)

							if batchSize > 0 {
								savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						copy(outCol[outStartIdx:], srcCol[rightGroup.rowStartIdx:rightGroup.rowStartIdx+toAppend])

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx

							batchSize := t_srcEndIdx - t_srcStartIdx
							outputLen := t_destStartIdx + batchSize

							if outputLen > (len(savedOut.Decimal())) {
								t_dest.SetCol(append(t_dest.Decimal()[:t_destStartIdx], t_src.Decimal()[t_srcStartIdx:t_srcEndIdx]...))
							} else {
								copy(t_dest.Decimal()[t_destStartIdx:], t_src.Decimal()[t_srcStartIdx:t_srcEndIdx])
							}

							if batchSize > 0 {
								t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			}
		case types.Int8:
			srcCol := src.Int8()
			outCol := out.Int8()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						t_dest := out
						t_destStartIdx := outStartIdx
						t_src := src
						t_srcStartIdx := rightGroup.rowStartIdx
						t_srcEndIdx := rightGroup.rowStartIdx + toAppend
						t_sel := sel

						batchSize := t_srcEndIdx - t_srcStartIdx
						for i := 0; i < batchSize; i++ {
							t_dest.Int8()[i+t_destStartIdx] = t_src.Int8()[t_sel[i+t_srcStartIdx]]
						}

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx
							t_sel := sel

							batchSize := t_srcEndIdx - t_srcStartIdx

							toCol := append(t_dest.Int8()[:t_destStartIdx], make([]int8, batchSize)...)
							fromCol := t_src.Int8()

							for i := 0; i < batchSize; i++ {
								toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
							}

							savedOut.SetCol(toCol)

							if batchSize > 0 {
								savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						copy(outCol[outStartIdx:], srcCol[rightGroup.rowStartIdx:rightGroup.rowStartIdx+toAppend])

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx

							batchSize := t_srcEndIdx - t_srcStartIdx
							outputLen := t_destStartIdx + batchSize

							if outputLen > (len(savedOut.Int8())) {
								t_dest.SetCol(append(t_dest.Int8()[:t_destStartIdx], t_src.Int8()[t_srcStartIdx:t_srcEndIdx]...))
							} else {
								copy(t_dest.Int8()[t_destStartIdx:], t_src.Int8()[t_srcStartIdx:t_srcEndIdx])
							}

							if batchSize > 0 {
								t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			}
		case types.Int16:
			srcCol := src.Int16()
			outCol := out.Int16()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						t_dest := out
						t_destStartIdx := outStartIdx
						t_src := src
						t_srcStartIdx := rightGroup.rowStartIdx
						t_srcEndIdx := rightGroup.rowStartIdx + toAppend
						t_sel := sel

						batchSize := t_srcEndIdx - t_srcStartIdx
						for i := 0; i < batchSize; i++ {
							t_dest.Int16()[i+t_destStartIdx] = t_src.Int16()[t_sel[i+t_srcStartIdx]]
						}

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx
							t_sel := sel

							batchSize := t_srcEndIdx - t_srcStartIdx

							toCol := append(t_dest.Int16()[:t_destStartIdx], make([]int16, batchSize)...)
							fromCol := t_src.Int16()

							for i := 0; i < batchSize; i++ {
								toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
							}

							savedOut.SetCol(toCol)

							if batchSize > 0 {
								savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						copy(outCol[outStartIdx:], srcCol[rightGroup.rowStartIdx:rightGroup.rowStartIdx+toAppend])

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx

							batchSize := t_srcEndIdx - t_srcStartIdx
							outputLen := t_destStartIdx + batchSize

							if outputLen > (len(savedOut.Int16())) {
								t_dest.SetCol(append(t_dest.Int16()[:t_destStartIdx], t_src.Int16()[t_srcStartIdx:t_srcEndIdx]...))
							} else {
								copy(t_dest.Int16()[t_destStartIdx:], t_src.Int16()[t_srcStartIdx:t_srcEndIdx])
							}

							if batchSize > 0 {
								t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			}
		case types.Int32:
			srcCol := src.Int32()
			outCol := out.Int32()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						t_dest := out
						t_destStartIdx := outStartIdx
						t_src := src
						t_srcStartIdx := rightGroup.rowStartIdx
						t_srcEndIdx := rightGroup.rowStartIdx + toAppend
						t_sel := sel

						batchSize := t_srcEndIdx - t_srcStartIdx
						for i := 0; i < batchSize; i++ {
							t_dest.Int32()[i+t_destStartIdx] = t_src.Int32()[t_sel[i+t_srcStartIdx]]
						}

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx
							t_sel := sel

							batchSize := t_srcEndIdx - t_srcStartIdx

							toCol := append(t_dest.Int32()[:t_destStartIdx], make([]int32, batchSize)...)
							fromCol := t_src.Int32()

							for i := 0; i < batchSize; i++ {
								toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
							}

							savedOut.SetCol(toCol)

							if batchSize > 0 {
								savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						copy(outCol[outStartIdx:], srcCol[rightGroup.rowStartIdx:rightGroup.rowStartIdx+toAppend])

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx

							batchSize := t_srcEndIdx - t_srcStartIdx
							outputLen := t_destStartIdx + batchSize

							if outputLen > (len(savedOut.Int32())) {
								t_dest.SetCol(append(t_dest.Int32()[:t_destStartIdx], t_src.Int32()[t_srcStartIdx:t_srcEndIdx]...))
							} else {
								copy(t_dest.Int32()[t_destStartIdx:], t_src.Int32()[t_srcStartIdx:t_srcEndIdx])
							}

							if batchSize > 0 {
								t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			}
		case types.Int64:
			srcCol := src.Int64()
			outCol := out.Int64()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						t_dest := out
						t_destStartIdx := outStartIdx
						t_src := src
						t_srcStartIdx := rightGroup.rowStartIdx
						t_srcEndIdx := rightGroup.rowStartIdx + toAppend
						t_sel := sel

						batchSize := t_srcEndIdx - t_srcStartIdx
						for i := 0; i < batchSize; i++ {
							t_dest.Int64()[i+t_destStartIdx] = t_src.Int64()[t_sel[i+t_srcStartIdx]]
						}

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx
							t_sel := sel

							batchSize := t_srcEndIdx - t_srcStartIdx

							toCol := append(t_dest.Int64()[:t_destStartIdx], make([]int64, batchSize)...)
							fromCol := t_src.Int64()

							for i := 0; i < batchSize; i++ {
								toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
							}

							savedOut.SetCol(toCol)

							if batchSize > 0 {
								savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						copy(outCol[outStartIdx:], srcCol[rightGroup.rowStartIdx:rightGroup.rowStartIdx+toAppend])

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx

							batchSize := t_srcEndIdx - t_srcStartIdx
							outputLen := t_destStartIdx + batchSize

							if outputLen > (len(savedOut.Int64())) {
								t_dest.SetCol(append(t_dest.Int64()[:t_destStartIdx], t_src.Int64()[t_srcStartIdx:t_srcEndIdx]...))
							} else {
								copy(t_dest.Int64()[t_destStartIdx:], t_src.Int64()[t_srcStartIdx:t_srcEndIdx])
							}

							if batchSize > 0 {
								t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			}
		case types.Float32:
			srcCol := src.Float32()
			outCol := out.Float32()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						t_dest := out
						t_destStartIdx := outStartIdx
						t_src := src
						t_srcStartIdx := rightGroup.rowStartIdx
						t_srcEndIdx := rightGroup.rowStartIdx + toAppend
						t_sel := sel

						batchSize := t_srcEndIdx - t_srcStartIdx
						for i := 0; i < batchSize; i++ {
							t_dest.Float32()[i+t_destStartIdx] = t_src.Float32()[t_sel[i+t_srcStartIdx]]
						}

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx
							t_sel := sel

							batchSize := t_srcEndIdx - t_srcStartIdx

							toCol := append(t_dest.Float32()[:t_destStartIdx], make([]float32, batchSize)...)
							fromCol := t_src.Float32()

							for i := 0; i < batchSize; i++ {
								toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
							}

							savedOut.SetCol(toCol)

							if batchSize > 0 {
								savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						copy(outCol[outStartIdx:], srcCol[rightGroup.rowStartIdx:rightGroup.rowStartIdx+toAppend])

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx

							batchSize := t_srcEndIdx - t_srcStartIdx
							outputLen := t_destStartIdx + batchSize

							if outputLen > (len(savedOut.Float32())) {
								t_dest.SetCol(append(t_dest.Float32()[:t_destStartIdx], t_src.Float32()[t_srcStartIdx:t_srcEndIdx]...))
							} else {
								copy(t_dest.Float32()[t_destStartIdx:], t_src.Float32()[t_srcStartIdx:t_srcEndIdx])
							}

							if batchSize > 0 {
								t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			}
		case types.Float64:
			srcCol := src.Float64()
			outCol := out.Float64()

			if sel != nil {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						t_dest := out
						t_destStartIdx := outStartIdx
						t_src := src
						t_srcStartIdx := rightGroup.rowStartIdx
						t_srcEndIdx := rightGroup.rowStartIdx + toAppend
						t_sel := sel

						batchSize := t_srcEndIdx - t_srcStartIdx
						for i := 0; i < batchSize; i++ {
							t_dest.Float64()[i+t_destStartIdx] = t_src.Float64()[t_sel[i+t_srcStartIdx]]
						}

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx
							t_sel := sel

							batchSize := t_srcEndIdx - t_srcStartIdx

							toCol := append(t_dest.Float64()[:t_destStartIdx], make([]float64, batchSize)...)
							fromCol := t_src.Float64()

							for i := 0; i < batchSize; i++ {
								toCol[i+t_destStartIdx] = fromCol[t_sel[i+t_srcStartIdx]]
							}

							savedOut.SetCol(toCol)

							if batchSize > 0 {
								savedOut.ExtendNullsWithSel(t_src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize), t_sel)
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			} else {
				// Loop over every group.
				for i := 0; i < groupsLen; i++ {
					rightGroup := rightGroups[i]
					// Repeat every group numRepeats times.
					for k := 0; k < rightGroup.numRepeats; k++ {
						toAppend := rightGroup.rowEndIdx - rightGroup.rowStartIdx
						if outStartIdx+toAppend > int(c.outputBatchSize) {
							toAppend = int(c.outputBatchSize) - outStartIdx
						}

						copy(outCol[outStartIdx:], srcCol[rightGroup.rowStartIdx:rightGroup.rowStartIdx+toAppend])

						if toAppend < rightGroup.rowEndIdx-rightGroup.rowStartIdx {
							t_dest := savedOut
							t_destStartIdx := c.savedOutputEndIdx + savedOutputCount
							t_src := src
							t_srcStartIdx := (rightGroup.rowStartIdx) + toAppend
							t_srcEndIdx := rightGroup.rowEndIdx

							batchSize := t_srcEndIdx - t_srcStartIdx
							outputLen := t_destStartIdx + batchSize

							if outputLen > (len(savedOut.Float64())) {
								t_dest.SetCol(append(t_dest.Float64()[:t_destStartIdx], t_src.Float64()[t_srcStartIdx:t_srcEndIdx]...))
							} else {
								copy(t_dest.Float64()[t_destStartIdx:], t_src.Float64()[t_srcStartIdx:t_srcEndIdx])
							}

							if batchSize > 0 {
								t_dest.ExtendNulls(src, uint64(t_destStartIdx), uint16(t_srcStartIdx), uint16(batchSize))
							}
						}

						outStartIdx += toAppend
						savedOutputCount += (rightGroup.rowEndIdx - rightGroup.rowStartIdx) - toAppend
					}
				}
			}
		default:
			panic(fmt.Sprintf("unhandled type %d", colType))
		}
	}
}
