// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: roachpb/data.proto

package roachpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import enginepb "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import bytes "bytes"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// ValueType defines a set of type constants placed in the "tag" field of Value
// messages. These are defined as a protocol buffer enumeration so that they
// can be used portably between our Go and C code. The tags are used by the
// RocksDB Merge Operator to perform specialized merges.
type ValueType int32

const (
	// This is a subset of the SQL column type values, representing the underlying
	// storage for various types. The DELIMITED_foo entries each represent a foo
	// variant that self-delimits length.
	ValueType_UNKNOWN           ValueType = 0
	ValueType_INT               ValueType = 1
	ValueType_FLOAT             ValueType = 2
	ValueType_BYTES             ValueType = 3
	ValueType_DELIMITED_BYTES   ValueType = 8
	ValueType_TIME              ValueType = 4
	ValueType_DECIMAL           ValueType = 5
	ValueType_DELIMITED_DECIMAL ValueType = 9
	ValueType_DURATION          ValueType = 6
	// TUPLE represents a DTuple, encoded as repeated pairs of varint field number
	// followed by a value encoded Datum.
	ValueType_TUPLE    ValueType = 10
	ValueType_BITARRAY ValueType = 11
	// TIMESERIES is applied to values which contain InternalTimeSeriesData.
	ValueType_TIMESERIES ValueType = 100
)

var ValueType_name = map[int32]string{
	0:   "UNKNOWN",
	1:   "INT",
	2:   "FLOAT",
	3:   "BYTES",
	8:   "DELIMITED_BYTES",
	4:   "TIME",
	5:   "DECIMAL",
	9:   "DELIMITED_DECIMAL",
	6:   "DURATION",
	10:  "TUPLE",
	11:  "BITARRAY",
	100: "TIMESERIES",
}
var ValueType_value = map[string]int32{
	"UNKNOWN":           0,
	"INT":               1,
	"FLOAT":             2,
	"BYTES":             3,
	"DELIMITED_BYTES":   8,
	"TIME":              4,
	"DECIMAL":           5,
	"DELIMITED_DECIMAL": 9,
	"DURATION":          6,
	"TUPLE":             10,
	"BITARRAY":          11,
	"TIMESERIES":        100,
}

func (x ValueType) String() string {
	return proto.EnumName(ValueType_name, int32(x))
}
func (ValueType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{0}
}

// ReplicaChangeType is a parameter of ChangeReplicasTrigger.
type ReplicaChangeType int32

const (
	ADD_REPLICA    ReplicaChangeType = 0
	REMOVE_REPLICA ReplicaChangeType = 1
)

var ReplicaChangeType_name = map[int32]string{
	0: "ADD_REPLICA",
	1: "REMOVE_REPLICA",
}
var ReplicaChangeType_value = map[string]int32{
	"ADD_REPLICA":    0,
	"REMOVE_REPLICA": 1,
}

func (x ReplicaChangeType) String() string {
	return proto.EnumName(ReplicaChangeType_name, int32(x))
}
func (ReplicaChangeType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{1}
}

// TransactionStatus specifies possible states for a transaction.
type TransactionStatus int32

const (
	// PENDING is the default state for a new transaction. Transactions
	// move from PENDING to one of COMMITTED or ABORTED. Mutations made
	// as part of a PENDING transactions are recorded as "intents" in
	// the underlying MVCC model.
	PENDING TransactionStatus = 0
	// COMMITTED is the state for a transaction which has been
	// committed. Mutations made as part of a transaction which is moved
	// into COMMITTED state become durable and visible to other
	// transactions, moving from "intents" to permanent versioned
	// values.
	COMMITTED TransactionStatus = 1
	// ABORTED is the state for a transaction which has been aborted.
	// Mutations made as part of a transaction which is moved into
	// ABORTED state are deleted and are never made visible to other
	// transactions.
	ABORTED TransactionStatus = 2
)

var TransactionStatus_name = map[int32]string{
	0: "PENDING",
	1: "COMMITTED",
	2: "ABORTED",
}
var TransactionStatus_value = map[string]int32{
	"PENDING":   0,
	"COMMITTED": 1,
	"ABORTED":   2,
}

func (x TransactionStatus) String() string {
	return proto.EnumName(TransactionStatus_name, int32(x))
}
func (TransactionStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{2}
}

// Span is a key range with an inclusive start Key and an exclusive end Key.
type Span struct {
	// The start key of the key range.
	Key Key `protobuf:"bytes,3,opt,name=key,proto3,casttype=Key" json:"key,omitempty"`
	// The end key of the key range. The value is empty if the key range
	// contains only a single key. Otherwise, it must order strictly after Key.
	// In such a case, the Span encompasses the key range from Key to EndKey,
	// including Key and excluding EndKey.
	EndKey               Key      `protobuf:"bytes,4,opt,name=end_key,json=endKey,proto3,casttype=Key" json:"end_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Span) Reset()      { *m = Span{} }
func (*Span) ProtoMessage() {}
func (*Span) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{0}
}
func (m *Span) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Span) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *Span) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Span.Merge(dst, src)
}
func (m *Span) XXX_Size() int {
	return m.Size()
}
func (m *Span) XXX_DiscardUnknown() {
	xxx_messageInfo_Span.DiscardUnknown(m)
}

var xxx_messageInfo_Span proto.InternalMessageInfo

// Value specifies the value at a key. Multiple values at the same key are
// supported based on timestamp. The data stored within a value is typed
// (ValueType) and custom encoded into the raw_bytes field. A custom encoding
// is used instead of separate proto fields to avoid proto overhead and to
// avoid unnecessary encoding and decoding as the value gets read from disk and
// passed through the network. The format is:
//
//   <4-byte-checksum><1-byte-tag><encoded-data>
//
// A CRC-32-IEEE checksum is computed from the associated key, tag and encoded
// data, in that order.
//
// TODO(peter): Is a 4-byte checksum overkill when most (all?) values
// will be less than 64KB?
type Value struct {
	// raw_bytes contains the encoded value and checksum.
	RawBytes []byte `protobuf:"bytes,1,opt,name=raw_bytes,json=rawBytes,proto3" json:"raw_bytes,omitempty"`
	// Timestamp of value.
	Timestamp            hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Value) Reset()         { *m = Value{} }
func (m *Value) String() string { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()    {}
func (*Value) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{1}
}
func (m *Value) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Value) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *Value) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Value.Merge(dst, src)
}
func (m *Value) XXX_Size() int {
	return m.Size()
}
func (m *Value) XXX_DiscardUnknown() {
	xxx_messageInfo_Value.DiscardUnknown(m)
}

var xxx_messageInfo_Value proto.InternalMessageInfo

// KeyValue is a pair of Key and Value for returned Key/Value pairs
// from ScanRequest/ScanResponse. It embeds a Key and a Value.
type KeyValue struct {
	Key                  Key      `protobuf:"bytes,1,opt,name=key,proto3,casttype=Key" json:"key,omitempty"`
	Value                Value    `protobuf:"bytes,2,opt,name=value,proto3" json:"value"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyValue) Reset()         { *m = KeyValue{} }
func (m *KeyValue) String() string { return proto.CompactTextString(m) }
func (*KeyValue) ProtoMessage()    {}
func (*KeyValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{2}
}
func (m *KeyValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeyValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *KeyValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyValue.Merge(dst, src)
}
func (m *KeyValue) XXX_Size() int {
	return m.Size()
}
func (m *KeyValue) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyValue.DiscardUnknown(m)
}

var xxx_messageInfo_KeyValue proto.InternalMessageInfo

// A StoreIdent uniquely identifies a store in the cluster. The
// StoreIdent is written to the underlying storage engine at a
// store-reserved system key (KeyLocalIdent).
type StoreIdent struct {
	ClusterID            github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"cluster_id"`
	NodeID               NodeID                                              `protobuf:"varint,2,opt,name=node_id,json=nodeId,proto3,casttype=NodeID" json:"node_id,omitempty"`
	StoreID              StoreID                                             `protobuf:"varint,3,opt,name=store_id,json=storeId,proto3,casttype=StoreID" json:"store_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *StoreIdent) Reset()         { *m = StoreIdent{} }
func (m *StoreIdent) String() string { return proto.CompactTextString(m) }
func (*StoreIdent) ProtoMessage()    {}
func (*StoreIdent) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{3}
}
func (m *StoreIdent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StoreIdent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *StoreIdent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreIdent.Merge(dst, src)
}
func (m *StoreIdent) XXX_Size() int {
	return m.Size()
}
func (m *StoreIdent) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreIdent.DiscardUnknown(m)
}

var xxx_messageInfo_StoreIdent proto.InternalMessageInfo

// A SplitTrigger is run after a successful commit of an AdminSplit
// command. It provides the updated left hand side of the split's
// range descriptor (left_desc) and the new range descriptor covering
// the right hand side of the split (right_desc). This information
// allows the final bookkeeping for the split to be completed and the
// new range put into operation.
type SplitTrigger struct {
	LeftDesc             RangeDescriptor `protobuf:"bytes,1,opt,name=left_desc,json=leftDesc,proto3" json:"left_desc"`
	RightDesc            RangeDescriptor `protobuf:"bytes,2,opt,name=right_desc,json=rightDesc,proto3" json:"right_desc"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *SplitTrigger) Reset()         { *m = SplitTrigger{} }
func (m *SplitTrigger) String() string { return proto.CompactTextString(m) }
func (*SplitTrigger) ProtoMessage()    {}
func (*SplitTrigger) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{4}
}
func (m *SplitTrigger) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SplitTrigger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *SplitTrigger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitTrigger.Merge(dst, src)
}
func (m *SplitTrigger) XXX_Size() int {
	return m.Size()
}
func (m *SplitTrigger) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitTrigger.DiscardUnknown(m)
}

var xxx_messageInfo_SplitTrigger proto.InternalMessageInfo

// A MergeTrigger is run after a successful commit of an AdminMerge
// command. It provides the updated left hand side of the split's
// range descriptor (left_desc) that now encompasses what was
// originally both ranges and the soon-to-be-invalid range descriptor
// that used to cover the subsumed, right hand side of the merge
// (right_desc). This information allows the final bookkeeping for the
// merge to be completed and put into operation.
type MergeTrigger struct {
	LeftDesc       RangeDescriptor    `protobuf:"bytes,1,opt,name=left_desc,json=leftDesc,proto3" json:"left_desc"`
	RightDesc      RangeDescriptor    `protobuf:"bytes,2,opt,name=right_desc,json=rightDesc,proto3" json:"right_desc"`
	RightMVCCStats enginepb.MVCCStats `protobuf:"bytes,4,opt,name=right_mvcc_stats,json=rightMvccStats,proto3" json:"right_mvcc_stats"`
	// FreezeStart is a timestamp that is guaranteed to be greater than the
	// timestamps at which any requests were serviced by the responding replica
	// before it stopped responding to requests altogether (in anticipation of
	// being subsumed). It is suitable for use as the timestamp cache's low water
	// mark for the keys previously owned by the subsumed range.
	FreezeStart          hlc.Timestamp `protobuf:"bytes,5,opt,name=freeze_start,json=freezeStart,proto3" json:"freeze_start"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *MergeTrigger) Reset()         { *m = MergeTrigger{} }
func (m *MergeTrigger) String() string { return proto.CompactTextString(m) }
func (*MergeTrigger) ProtoMessage()    {}
func (*MergeTrigger) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{5}
}
func (m *MergeTrigger) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MergeTrigger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MergeTrigger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeTrigger.Merge(dst, src)
}
func (m *MergeTrigger) XXX_Size() int {
	return m.Size()
}
func (m *MergeTrigger) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeTrigger.DiscardUnknown(m)
}

var xxx_messageInfo_MergeTrigger proto.InternalMessageInfo

type ChangeReplicasTrigger struct {
	ChangeType ReplicaChangeType `protobuf:"varint,1,opt,name=change_type,json=changeType,proto3,enum=cockroach.roachpb.ReplicaChangeType" json:"change_type,omitempty"`
	// The replica being modified.
	Replica ReplicaDescriptor `protobuf:"bytes,2,opt,name=replica,proto3" json:"replica"`
	// The new replica list with this change applied.
	UpdatedReplicas      []ReplicaDescriptor `protobuf:"bytes,3,rep,name=updated_replicas,json=updatedReplicas,proto3" json:"updated_replicas"`
	NextReplicaID        ReplicaID           `protobuf:"varint,4,opt,name=next_replica_id,json=nextReplicaId,proto3,casttype=ReplicaID" json:"next_replica_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ChangeReplicasTrigger) Reset()      { *m = ChangeReplicasTrigger{} }
func (*ChangeReplicasTrigger) ProtoMessage() {}
func (*ChangeReplicasTrigger) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{6}
}
func (m *ChangeReplicasTrigger) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ChangeReplicasTrigger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ChangeReplicasTrigger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChangeReplicasTrigger.Merge(dst, src)
}
func (m *ChangeReplicasTrigger) XXX_Size() int {
	return m.Size()
}
func (m *ChangeReplicasTrigger) XXX_DiscardUnknown() {
	xxx_messageInfo_ChangeReplicasTrigger.DiscardUnknown(m)
}

var xxx_messageInfo_ChangeReplicasTrigger proto.InternalMessageInfo

// ModifiedSpanTrigger indicates that a specific span has been modified.
// This can be used to trigger scan-and-gossip for the given span.
type ModifiedSpanTrigger struct {
	SystemConfigSpan bool `protobuf:"varint,1,opt,name=system_config_span,json=systemConfigSpan,proto3" json:"system_config_span,omitempty"`
	// node_liveness_span is set to indicate that node liveness records
	// need re-gossiping after modification or range lease updates. The
	// span is set to a single key when nodes update their liveness records
	// with heartbeats to extend the expiration timestamp. Changes to the
	// range lease for the range containing node liveness triggers re-gossip
	// of the entire node liveness key range.
	NodeLivenessSpan     *Span    `protobuf:"bytes,2,opt,name=node_liveness_span,json=nodeLivenessSpan,proto3" json:"node_liveness_span,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ModifiedSpanTrigger) Reset()         { *m = ModifiedSpanTrigger{} }
func (m *ModifiedSpanTrigger) String() string { return proto.CompactTextString(m) }
func (*ModifiedSpanTrigger) ProtoMessage()    {}
func (*ModifiedSpanTrigger) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{7}
}
func (m *ModifiedSpanTrigger) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ModifiedSpanTrigger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ModifiedSpanTrigger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModifiedSpanTrigger.Merge(dst, src)
}
func (m *ModifiedSpanTrigger) XXX_Size() int {
	return m.Size()
}
func (m *ModifiedSpanTrigger) XXX_DiscardUnknown() {
	xxx_messageInfo_ModifiedSpanTrigger.DiscardUnknown(m)
}

var xxx_messageInfo_ModifiedSpanTrigger proto.InternalMessageInfo

// InternalCommitTrigger encapsulates all of the internal-only commit triggers.
// Only one may be set.
type InternalCommitTrigger struct {
	SplitTrigger          *SplitTrigger          `protobuf:"bytes,1,opt,name=split_trigger,json=splitTrigger,proto3" json:"split_trigger,omitempty"`
	MergeTrigger          *MergeTrigger          `protobuf:"bytes,2,opt,name=merge_trigger,json=mergeTrigger,proto3" json:"merge_trigger,omitempty"`
	ChangeReplicasTrigger *ChangeReplicasTrigger `protobuf:"bytes,3,opt,name=change_replicas_trigger,json=changeReplicasTrigger,proto3" json:"change_replicas_trigger,omitempty"`
	ModifiedSpanTrigger   *ModifiedSpanTrigger   `protobuf:"bytes,4,opt,name=modified_span_trigger,json=modifiedSpanTrigger,proto3" json:"modified_span_trigger,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}               `json:"-"`
	XXX_sizecache         int32                  `json:"-"`
}

func (m *InternalCommitTrigger) Reset()         { *m = InternalCommitTrigger{} }
func (m *InternalCommitTrigger) String() string { return proto.CompactTextString(m) }
func (*InternalCommitTrigger) ProtoMessage()    {}
func (*InternalCommitTrigger) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{8}
}
func (m *InternalCommitTrigger) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InternalCommitTrigger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *InternalCommitTrigger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InternalCommitTrigger.Merge(dst, src)
}
func (m *InternalCommitTrigger) XXX_Size() int {
	return m.Size()
}
func (m *InternalCommitTrigger) XXX_DiscardUnknown() {
	xxx_messageInfo_InternalCommitTrigger.DiscardUnknown(m)
}

var xxx_messageInfo_InternalCommitTrigger proto.InternalMessageInfo

func (m *InternalCommitTrigger) GetSplitTrigger() *SplitTrigger {
	if m != nil {
		return m.SplitTrigger
	}
	return nil
}

func (m *InternalCommitTrigger) GetMergeTrigger() *MergeTrigger {
	if m != nil {
		return m.MergeTrigger
	}
	return nil
}

func (m *InternalCommitTrigger) GetChangeReplicasTrigger() *ChangeReplicasTrigger {
	if m != nil {
		return m.ChangeReplicasTrigger
	}
	return nil
}

func (m *InternalCommitTrigger) GetModifiedSpanTrigger() *ModifiedSpanTrigger {
	if m != nil {
		return m.ModifiedSpanTrigger
	}
	return nil
}

type ObservedTimestamp struct {
	NodeID               NodeID        `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=NodeID" json:"node_id,omitempty"`
	Timestamp            hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ObservedTimestamp) Reset()         { *m = ObservedTimestamp{} }
func (m *ObservedTimestamp) String() string { return proto.CompactTextString(m) }
func (*ObservedTimestamp) ProtoMessage()    {}
func (*ObservedTimestamp) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{9}
}
func (m *ObservedTimestamp) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ObservedTimestamp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ObservedTimestamp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObservedTimestamp.Merge(dst, src)
}
func (m *ObservedTimestamp) XXX_Size() int {
	return m.Size()
}
func (m *ObservedTimestamp) XXX_DiscardUnknown() {
	xxx_messageInfo_ObservedTimestamp.DiscardUnknown(m)
}

var xxx_messageInfo_ObservedTimestamp proto.InternalMessageInfo

// A Transaction is a unit of work performed on the database.
// Cockroach transactions always operate at the serializable isolation
// level. Each Cockroach transaction is assigned a random priority.
// This priority will be used to decide whether a transaction will be
// aborted during contention.
//
// If you add fields to Transaction you'll need to update
// Transaction.Clone. Failure to do so will result in test failures.
type Transaction struct {
	// The transaction metadata. These are persisted with every intent.
	enginepb.TxnMeta `protobuf:"bytes,1,opt,name=meta,proto3,embedded=meta" json:"meta"`
	// A free-text identifier for debug purposes.
	Name          string            `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Status        TransactionStatus `protobuf:"varint,4,opt,name=status,proto3,enum=cockroach.roachpb.TransactionStatus" json:"status,omitempty"`
	LastHeartbeat hlc.Timestamp     `protobuf:"bytes,5,opt,name=last_heartbeat,json=lastHeartbeat,proto3" json:"last_heartbeat"`
	// The original timestamp at which the transaction started. For serializable
	// transactions, if the timestamp drifts from the original timestamp, the
	// transaction will retry unless we manage to "refresh the reads" - see
	// refreshed_timestamp.
	//
	// This timestamp is the one at which all reads occur, unless
	// refreshed_timestamp is set.
	//
	// Note that writes do not occur at this timestamp; they instead occur at the
	// provisional commit timestamp, meta.Timestamp.
	OrigTimestamp hlc.Timestamp `protobuf:"bytes,6,opt,name=orig_timestamp,json=origTimestamp,proto3" json:"orig_timestamp"`
	// Initial Timestamp + clock skew. Reads which encounter values with
	// timestamps between timestamp and max_timestamp trigger a txn
	// retry error, unless the node being read is listed in observed_timestamps
	// (in which case no more read uncertainty can occur).
	// The case max_timestamp < timestamp is possible for transactions which have
	// been pushed; in this case, max_timestamp should be ignored.
	MaxTimestamp hlc.Timestamp `protobuf:"bytes,7,opt,name=max_timestamp,json=maxTimestamp,proto3" json:"max_timestamp"`
	// The refreshed timestamp is the timestamp at which the transaction
	// can commit without necessitating a serializable restart. This
	// value is forwarded to the transaction's current timestamp (meta.timestamp)
	// if the transaction coordinator is able to refresh all refreshable spans
	// encountered during the course of the txn. If set, this takes precedence
	// over orig_timestamp and is the timestamp at which the transaction reads
	// going forward.
	//
	// We need to keep track of both refresh_timestamp and orig_timestamp (instead
	// of simply overwriting the orig_timestamp after refreshes) because the
	// orig_timestamp needs to be used as a lower bound timestamp for the
	// time-bound iterator used to resolve intents - i.e. there can be intents to
	// resolve up to the timestamp that the txn started with.
	RefreshedTimestamp hlc.Timestamp `protobuf:"bytes,15,opt,name=refreshed_timestamp,json=refreshedTimestamp,proto3" json:"refreshed_timestamp"`
	// A list of <NodeID, timestamp> pairs. The list maps NodeIDs to timestamps
	// as observed from their local clock during this transaction. The purpose of
	// this map is to avoid uncertainty related restarts which normally occur
	// when reading a value in the near future as per the max_timestamp field.
	//
	// Morally speaking, having an entry for a node in this map means that this
	// node has been visited before, and that no more uncertainty restarts are
	// expected for operations served from it. However, this is not entirely
	// accurate. For example, say a txn starts with orig_timestamp=1 (and some
	// large max_timestamp). It then reads key "a" from node A, registering an
	// entry `A -> 5` in the process (`5` happens to be a timestamp taken off
	// that node's clock at the end of the read).
	// Now assume that some other transaction writes and commits a value at key "b"
	// and timestamp 4 (again, served by node A), and our transaction attempts to
	// read that key. Since there is an entry in its observed_timestamps for A,
	// our uncertainty window is `[orig_timestamp, 5) = [1, 5)` but the value at
	// key "b" is in that window, and so we will restart. However, we will restart
	// with a timestamp that is at least high as our entry in the map for node A,
	// so no future operation on node A will be uncertain.
	//
	// Thus, expressed properly, you could say that when a node has been read from
	// successfully before, uncertainty on that node is restricted to values with
	// timestamps in the interval [orig_timestamp, first_visit_timestamp), and
	// that no node will trigger restarts more than once (and in fact, usually
	// the first restart also bumps the txn timestamp enough to clear all other
	// nodes).
	//
	// When this list holds a corresponding entry for the node the current
	// request is executing on, we can run the command with the map's timestamp
	// as the top boundary of our uncertainty interval, limiting (and often
	// avoiding) uncertainty restarts.
	//
	// When a transaction is first initialized on a node, it may use a timestamp
	// from the local hybrid logical clock to initialize the corresponding entry
	// in the map. In particular, if `orig_timestamp` is taken from that node's
	// clock, we may add that to the map, which eliminates read uncertainty for
	// reads on that node.
	//
	// The slice of observed timestamps is kept sorted by NodeID. Use
	// Transaction.UpdateObservedTimestamp to maintain the sorted order. The
	// slice should be treated as immutable and all updates should be performed
	// on a copy of the slice.
	ObservedTimestamps []ObservedTimestamp `protobuf:"bytes,8,rep,name=observed_timestamps,json=observedTimestamps,proto3" json:"observed_timestamps"`
	// Writing is true if the transaction has previously sent a Begin transaction
	// (i.e. if it ever attempted to perform a write, so if it ever attempted to
	// leave intents (across retries)). The flag will be set even if the BeginTxn
	// batch failed.
	// When set, the AbortCache must be checked by reads so that they don't miss
	// to see the txn's previous writes.
	// TODO(nvanbenschoten): This comment is only true when interacting with 2.1
	// nodes. This field can be completely removed in 19.2.
	DeprecatedWriting bool `protobuf:"varint,9,opt,name=deprecated_writing,json=deprecatedWriting,proto3" json:"deprecated_writing,omitempty"`
	// If this is true, the transaction must retry. Relevant only for
	// SNAPSHOT transactions: a SERIALIZABLE transaction would have to
	// retry anyway due to its commit timestamp having moved forward (whenever
	// write_too_old is set, meta.Timestamp has been pushed above orig_timestamp).
	// This bool is set instead of immediately returning a txn retry
	// error so that intents can continue to be laid down, minimizing
	// work required on txn restart.
	WriteTooOld bool `protobuf:"varint,12,opt,name=write_too_old,json=writeTooOld,proto3" json:"write_too_old,omitempty"`
	// The slice should be treated as immutable and all updates should be
	// performed on a copy of the slice.
	Intents []Span `protobuf:"bytes,11,rep,name=intents,proto3" json:"intents"`
	// Epoch zero timestamp is used to keep track of the earliest timestamp
	// that any epoch of the transaction used. This is set only if the
	// transaction is restarted and the epoch is bumped. It is used during
	// intent resolution to more efficiently scan for intents.
	EpochZeroTimestamp hlc.Timestamp `protobuf:"bytes,14,opt,name=epoch_zero_timestamp,json=epochZeroTimestamp,proto3" json:"epoch_zero_timestamp"`
	// This flag is set if the transaction's original timestamp was
	// "leaked" beyond the transaction (i.e. if returned via NOW() or
	// transaction_timestamp()). If true, this prevents optimizations
	// which commit at a higher timestamp without resorting to a
	// client-side retry.
	OrigTimestampWasObserved bool     `protobuf:"varint,16,opt,name=orig_timestamp_was_observed,json=origTimestampWasObserved,proto3" json:"orig_timestamp_was_observed,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *Transaction) Reset()      { *m = Transaction{} }
func (*Transaction) ProtoMessage() {}
func (*Transaction) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{10}
}
func (m *Transaction) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Transaction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *Transaction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Transaction.Merge(dst, src)
}
func (m *Transaction) XXX_Size() int {
	return m.Size()
}
func (m *Transaction) XXX_DiscardUnknown() {
	xxx_messageInfo_Transaction.DiscardUnknown(m)
}

var xxx_messageInfo_Transaction proto.InternalMessageInfo

// A TransactionRecord message contains the subset of the fields in a
// Transaction message that must be persisted in a transaction record.
// It can be thought of as a mask for the fields in Transaction that
// end up persisted in a transaction record.
//
// The message type is wire-compatible with persisted Transaction protos,
// but avoids the overhead of the fields in Transaction that don't need to
// be persisted in a transaction record. It also serves as a specification
// for the fields that must be present in a transaction record.
//
// NOTE: any changes to this type must be reflected in the AsRecord and
// AsTransaction methods.
type TransactionRecord struct {
	// See comments on Transaction proto.
	enginepb.TxnMeta `protobuf:"bytes,1,opt,name=meta,proto3,embedded=meta" json:"meta"`
	Status           TransactionStatus `protobuf:"varint,4,opt,name=status,proto3,enum=cockroach.roachpb.TransactionStatus" json:"status,omitempty"`
	LastHeartbeat    hlc.Timestamp     `protobuf:"bytes,5,opt,name=last_heartbeat,json=lastHeartbeat,proto3" json:"last_heartbeat"`
	// TODO(nvanbenschoten): We can't accurately determine this value from
	// intents, so we'd like to avoid ever needing to synthesize it. 2.1 nodes
	// will assert that it is set, so we set it for now, but we should stop doing
	// that in the future. Removing this in 2.3 shouldn't cause any issues.
	OrigTimestamp        hlc.Timestamp `protobuf:"bytes,6,opt,name=orig_timestamp,json=origTimestamp,proto3" json:"orig_timestamp"`
	Intents              []Span        `protobuf:"bytes,11,rep,name=intents,proto3" json:"intents"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *TransactionRecord) Reset()         { *m = TransactionRecord{} }
func (m *TransactionRecord) String() string { return proto.CompactTextString(m) }
func (*TransactionRecord) ProtoMessage()    {}
func (*TransactionRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{11}
}
func (m *TransactionRecord) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TransactionRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TransactionRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionRecord.Merge(dst, src)
}
func (m *TransactionRecord) XXX_Size() int {
	return m.Size()
}
func (m *TransactionRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionRecord.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionRecord proto.InternalMessageInfo

// A Intent is a Span together with a Transaction metadata and its status.
type Intent struct {
	Span                 `protobuf:"bytes,1,opt,name=span,proto3,embedded=span" json:"span"`
	Txn                  enginepb.TxnMeta  `protobuf:"bytes,2,opt,name=txn,proto3" json:"txn"`
	Status               TransactionStatus `protobuf:"varint,3,opt,name=status,proto3,enum=cockroach.roachpb.TransactionStatus" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Intent) Reset()         { *m = Intent{} }
func (m *Intent) String() string { return proto.CompactTextString(m) }
func (*Intent) ProtoMessage()    {}
func (*Intent) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{12}
}
func (m *Intent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Intent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *Intent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent.Merge(dst, src)
}
func (m *Intent) XXX_Size() int {
	return m.Size()
}
func (m *Intent) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent.DiscardUnknown(m)
}

var xxx_messageInfo_Intent proto.InternalMessageInfo

// A SequencedWrite is a point write to a key with a certain sequence number.
//
// TODO(nvanbenschoten/tschottdorf): This message type can be used as the
// PromisedWrites repeated field in EndTransaction in the parallel commits
// proposal (#24194).
type SequencedWrite struct {
	// The key that the write was made at.
	Key Key `protobuf:"bytes,1,opt,name=key,proto3,casttype=Key" json:"key,omitempty"`
	// The sequence number of the request that created the write.
	Sequence             int32    `protobuf:"varint,2,opt,name=sequence,proto3" json:"sequence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SequencedWrite) Reset()         { *m = SequencedWrite{} }
func (m *SequencedWrite) String() string { return proto.CompactTextString(m) }
func (*SequencedWrite) ProtoMessage()    {}
func (*SequencedWrite) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{13}
}
func (m *SequencedWrite) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SequencedWrite) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *SequencedWrite) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SequencedWrite.Merge(dst, src)
}
func (m *SequencedWrite) XXX_Size() int {
	return m.Size()
}
func (m *SequencedWrite) XXX_DiscardUnknown() {
	xxx_messageInfo_SequencedWrite.DiscardUnknown(m)
}

var xxx_messageInfo_SequencedWrite proto.InternalMessageInfo

// Lease contains information about range leases including the
// expiration and lease holder.
type Lease struct {
	// The start is a timestamp at which the lease begins. This value
	// must be greater than the last lease expiration or the lease request
	// is considered invalid.
	Start hlc.Timestamp `protobuf:"bytes,1,opt,name=start,proto3" json:"start"`
	// The expiration is a timestamp at which the lease expires. This means that
	// a new lease can be granted for a later timestamp.
	Expiration *hlc.Timestamp `protobuf:"bytes,2,opt,name=expiration,proto3" json:"expiration,omitempty" cockroachdb:"randnullable"`
	// The address of the would-be lease holder.
	Replica ReplicaDescriptor `protobuf:"bytes,3,opt,name=replica,proto3" json:"replica"`
	// The start of the lease stasis period. This field is deprecated.
	DeprecatedStartStasis *hlc.Timestamp `protobuf:"bytes,4,opt,name=deprecated_start_stasis,json=deprecatedStartStasis,proto3" json:"deprecated_start_stasis,omitempty" cockroachdb:"randnullable"`
	// The current timestamp when this lease has been proposed. Used after a
	// transfer and after a node restart to enforce that a node only uses leases
	// proposed after the time of the said transfer or restart. This is nullable
	// to help with the rollout (such that a lease applied by some nodes before
	// the rollout and some nodes after the rollout is serialized the same).
	// TODO(andrei): Make this non-nullable after the rollout.
	ProposedTS *hlc.Timestamp `protobuf:"bytes,5,opt,name=proposed_ts,json=proposedTs,proto3" json:"proposed_ts,omitempty"`
	// The epoch of the lease holder's node liveness entry. If this value
	// is non-zero, the start and expiration values are ignored.
	Epoch int64 `protobuf:"varint,6,opt,name=epoch,proto3" json:"epoch,omitempty"`
	// A zero-indexed sequence number which is incremented during the acquisition
	// of each new range lease that is not equivalent to the previous range lease
	// (i.e. an acquisition that implies a leaseholder change). The sequence
	// number is used to detect lease changes between command proposal and
	// application without requiring that we send the entire lease through Raft.
	// Lease sequence numbers are a reflection of the "lease equivalency" property
	// (see Lease.Equivalent). Two adjacent leases that are equivalent will have
	// the same sequence number and two adjacent leases that are not equivalent
	// will have different sequence numbers.
	Sequence             LeaseSequence `protobuf:"varint,7,opt,name=sequence,proto3,casttype=LeaseSequence" json:"sequence,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Lease) Reset()      { *m = Lease{} }
func (*Lease) ProtoMessage() {}
func (*Lease) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{14}
}
func (m *Lease) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Lease) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *Lease) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Lease.Merge(dst, src)
}
func (m *Lease) XXX_Size() int {
	return m.Size()
}
func (m *Lease) XXX_DiscardUnknown() {
	xxx_messageInfo_Lease.DiscardUnknown(m)
}

var xxx_messageInfo_Lease proto.InternalMessageInfo

// AbortSpanEntry contains information about a transaction which has
// been aborted. It's written to a range's AbortSpan if the range
// may have contained intents of the aborted txn. In the event that
// the same transaction attempts to read keys it may have written
// previously, this entry informs the transaction that it has aborted
// and must start fresh with an updated priority.
type AbortSpanEntry struct {
	// The key of the associated transaction.
	Key Key `protobuf:"bytes,1,opt,name=key,proto3,casttype=Key" json:"key,omitempty"`
	// The candidate commit timestamp the transaction record held at the time
	// it was aborted.
	Timestamp hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp"`
	// The priority of the transaction.
	Priority             int32    `protobuf:"varint,3,opt,name=priority,proto3" json:"priority,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AbortSpanEntry) Reset()         { *m = AbortSpanEntry{} }
func (m *AbortSpanEntry) String() string { return proto.CompactTextString(m) }
func (*AbortSpanEntry) ProtoMessage()    {}
func (*AbortSpanEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{15}
}
func (m *AbortSpanEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AbortSpanEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *AbortSpanEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AbortSpanEntry.Merge(dst, src)
}
func (m *AbortSpanEntry) XXX_Size() int {
	return m.Size()
}
func (m *AbortSpanEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_AbortSpanEntry.DiscardUnknown(m)
}

var xxx_messageInfo_AbortSpanEntry proto.InternalMessageInfo

// TxnCoordMeta is metadata held by a transaction coordinator. This
// message is defined here because it is used in several layers of the
// system (internal/client, sql/distsqlrun, kv).
type TxnCoordMeta struct {
	// txn is a copy of the transaction record, updated with each request.
	Txn Transaction `protobuf:"bytes,1,opt,name=txn,proto3" json:"txn"`
	// intents stores key spans affected by this transaction through
	// this coordinator. These spans allow the coordinator to set the
	// list of intent spans in the EndTransactionRequest when the
	// transaction is finalized.
	Intents []Span `protobuf:"bytes,2,rep,name=intents,proto3" json:"intents"`
	// command_count indicates how many requests have been sent through
	// this transaction. Reset on retryable txn errors.
	CommandCount int32 `protobuf:"varint,3,opt,name=command_count,json=commandCount,proto3" json:"command_count,omitempty"`
	// refresh_reads and refresh_writes store key spans which were read
	// or, less frequently, written during a transaction. These fields
	// are utilized for SERIALIZABLE transactions in the event a
	// transaction experiences a retry error. In that case, the
	// coordinator uses the Refresh and RefreshRange RPCs to verify that
	// no write has occurred to the spans more recently than the txn's
	// original timestamp, and updates the affected timestamp caches to
	// the transaction's refreshed timestamp. On failure, the retry
	// error is propagated. On success, the transaction's original and
	// current timestamps are forwarded to the refresh timestamp, and
	// the transaction can continue.
	RefreshReads  []Span `protobuf:"bytes,4,rep,name=refresh_reads,json=refreshReads,proto3" json:"refresh_reads"`
	RefreshWrites []Span `protobuf:"bytes,5,rep,name=refresh_writes,json=refreshWrites,proto3" json:"refresh_writes"`
	// refresh_invalid indicates that spans were discarded or not collected
	// (i.e. because of a dist SQL processor running a version before refreshing
	// was introduced). This is false if all spans encountered during the
	// transaction which need refreshing have been collected to the refresh_reads
	// and refresh_writes span slices.
	RefreshInvalid bool `protobuf:"varint,7,opt,name=refresh_invalid,json=refreshInvalid,proto3" json:"refresh_invalid,omitempty"`
	// outstanding_writes stores all writes that are outstanding and have
	// not yet been resolved. Any client wishing to send a request that
	// overlaps with them must chain on to their success using a QueryIntent
	// request.
	OutstandingWrites    []SequencedWrite `protobuf:"bytes,8,rep,name=outstanding_writes,json=outstandingWrites,proto3" json:"outstanding_writes"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *TxnCoordMeta) Reset()         { *m = TxnCoordMeta{} }
func (m *TxnCoordMeta) String() string { return proto.CompactTextString(m) }
func (*TxnCoordMeta) ProtoMessage()    {}
func (*TxnCoordMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_a87162148e6fc734, []int{16}
}
func (m *TxnCoordMeta) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TxnCoordMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TxnCoordMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TxnCoordMeta.Merge(dst, src)
}
func (m *TxnCoordMeta) XXX_Size() int {
	return m.Size()
}
func (m *TxnCoordMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_TxnCoordMeta.DiscardUnknown(m)
}

var xxx_messageInfo_TxnCoordMeta proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Span)(nil), "cockroach.roachpb.Span")
	proto.RegisterType((*Value)(nil), "cockroach.roachpb.Value")
	proto.RegisterType((*KeyValue)(nil), "cockroach.roachpb.KeyValue")
	proto.RegisterType((*StoreIdent)(nil), "cockroach.roachpb.StoreIdent")
	proto.RegisterType((*SplitTrigger)(nil), "cockroach.roachpb.SplitTrigger")
	proto.RegisterType((*MergeTrigger)(nil), "cockroach.roachpb.MergeTrigger")
	proto.RegisterType((*ChangeReplicasTrigger)(nil), "cockroach.roachpb.ChangeReplicasTrigger")
	proto.RegisterType((*ModifiedSpanTrigger)(nil), "cockroach.roachpb.ModifiedSpanTrigger")
	proto.RegisterType((*InternalCommitTrigger)(nil), "cockroach.roachpb.InternalCommitTrigger")
	proto.RegisterType((*ObservedTimestamp)(nil), "cockroach.roachpb.ObservedTimestamp")
	proto.RegisterType((*Transaction)(nil), "cockroach.roachpb.Transaction")
	proto.RegisterType((*TransactionRecord)(nil), "cockroach.roachpb.TransactionRecord")
	proto.RegisterType((*Intent)(nil), "cockroach.roachpb.Intent")
	proto.RegisterType((*SequencedWrite)(nil), "cockroach.roachpb.SequencedWrite")
	proto.RegisterType((*Lease)(nil), "cockroach.roachpb.Lease")
	proto.RegisterType((*AbortSpanEntry)(nil), "cockroach.roachpb.AbortSpanEntry")
	proto.RegisterType((*TxnCoordMeta)(nil), "cockroach.roachpb.TxnCoordMeta")
	proto.RegisterEnum("cockroach.roachpb.ValueType", ValueType_name, ValueType_value)
	proto.RegisterEnum("cockroach.roachpb.ReplicaChangeType", ReplicaChangeType_name, ReplicaChangeType_value)
	proto.RegisterEnum("cockroach.roachpb.TransactionStatus", TransactionStatus_name, TransactionStatus_value)
}
func (this *Span) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Span)
	if !ok {
		that2, ok := that.(Span)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Key, that1.Key) {
		return false
	}
	if !bytes.Equal(this.EndKey, that1.EndKey) {
		return false
	}
	return true
}
func (this *Value) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value)
	if !ok {
		that2, ok := that.(Value)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.RawBytes, that1.RawBytes) {
		return false
	}
	if !this.Timestamp.Equal(&that1.Timestamp) {
		return false
	}
	return true
}
func (this *SplitTrigger) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SplitTrigger)
	if !ok {
		that2, ok := that.(SplitTrigger)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LeftDesc.Equal(&that1.LeftDesc) {
		return false
	}
	if !this.RightDesc.Equal(&that1.RightDesc) {
		return false
	}
	return true
}
func (this *MergeTrigger) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MergeTrigger)
	if !ok {
		that2, ok := that.(MergeTrigger)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LeftDesc.Equal(&that1.LeftDesc) {
		return false
	}
	if !this.RightDesc.Equal(&that1.RightDesc) {
		return false
	}
	if !this.RightMVCCStats.Equal(&that1.RightMVCCStats) {
		return false
	}
	if !this.FreezeStart.Equal(&that1.FreezeStart) {
		return false
	}
	return true
}
func (this *ChangeReplicasTrigger) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ChangeReplicasTrigger)
	if !ok {
		that2, ok := that.(ChangeReplicasTrigger)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ChangeType != that1.ChangeType {
		return false
	}
	if !this.Replica.Equal(&that1.Replica) {
		return false
	}
	if len(this.UpdatedReplicas) != len(that1.UpdatedReplicas) {
		return false
	}
	for i := range this.UpdatedReplicas {
		if !this.UpdatedReplicas[i].Equal(&that1.UpdatedReplicas[i]) {
			return false
		}
	}
	if this.NextReplicaID != that1.NextReplicaID {
		return false
	}
	return true
}
func (this *ModifiedSpanTrigger) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ModifiedSpanTrigger)
	if !ok {
		that2, ok := that.(ModifiedSpanTrigger)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SystemConfigSpan != that1.SystemConfigSpan {
		return false
	}
	if !this.NodeLivenessSpan.Equal(that1.NodeLivenessSpan) {
		return false
	}
	return true
}
func (this *InternalCommitTrigger) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*InternalCommitTrigger)
	if !ok {
		that2, ok := that.(InternalCommitTrigger)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SplitTrigger.Equal(that1.SplitTrigger) {
		return false
	}
	if !this.MergeTrigger.Equal(that1.MergeTrigger) {
		return false
	}
	if !this.ChangeReplicasTrigger.Equal(that1.ChangeReplicasTrigger) {
		return false
	}
	if !this.ModifiedSpanTrigger.Equal(that1.ModifiedSpanTrigger) {
		return false
	}
	return true
}
func (this *ObservedTimestamp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ObservedTimestamp)
	if !ok {
		that2, ok := that.(ObservedTimestamp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NodeID != that1.NodeID {
		return false
	}
	if !this.Timestamp.Equal(&that1.Timestamp) {
		return false
	}
	return true
}
func (this *Transaction) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Transaction)
	if !ok {
		that2, ok := that.(Transaction)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TxnMeta.Equal(&that1.TxnMeta) {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if !this.LastHeartbeat.Equal(&that1.LastHeartbeat) {
		return false
	}
	if !this.OrigTimestamp.Equal(&that1.OrigTimestamp) {
		return false
	}
	if !this.MaxTimestamp.Equal(&that1.MaxTimestamp) {
		return false
	}
	if !this.RefreshedTimestamp.Equal(&that1.RefreshedTimestamp) {
		return false
	}
	if len(this.ObservedTimestamps) != len(that1.ObservedTimestamps) {
		return false
	}
	for i := range this.ObservedTimestamps {
		if !this.ObservedTimestamps[i].Equal(&that1.ObservedTimestamps[i]) {
			return false
		}
	}
	if this.DeprecatedWriting != that1.DeprecatedWriting {
		return false
	}
	if this.WriteTooOld != that1.WriteTooOld {
		return false
	}
	if len(this.Intents) != len(that1.Intents) {
		return false
	}
	for i := range this.Intents {
		if !this.Intents[i].Equal(&that1.Intents[i]) {
			return false
		}
	}
	if !this.EpochZeroTimestamp.Equal(&that1.EpochZeroTimestamp) {
		return false
	}
	if this.OrigTimestampWasObserved != that1.OrigTimestampWasObserved {
		return false
	}
	return true
}
func (this *TransactionRecord) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TransactionRecord)
	if !ok {
		that2, ok := that.(TransactionRecord)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TxnMeta.Equal(&that1.TxnMeta) {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if !this.LastHeartbeat.Equal(&that1.LastHeartbeat) {
		return false
	}
	if !this.OrigTimestamp.Equal(&that1.OrigTimestamp) {
		return false
	}
	if len(this.Intents) != len(that1.Intents) {
		return false
	}
	for i := range this.Intents {
		if !this.Intents[i].Equal(&that1.Intents[i]) {
			return false
		}
	}
	return true
}
func (this *Intent) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Intent)
	if !ok {
		that2, ok := that.(Intent)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Span.Equal(&that1.Span) {
		return false
	}
	if !this.Txn.Equal(&that1.Txn) {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	return true
}
func (this *AbortSpanEntry) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AbortSpanEntry)
	if !ok {
		that2, ok := that.(AbortSpanEntry)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Key, that1.Key) {
		return false
	}
	if !this.Timestamp.Equal(&that1.Timestamp) {
		return false
	}
	if this.Priority != that1.Priority {
		return false
	}
	return true
}
func (m *Span) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	return i, nil
}

func (m *Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.RawBytes) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.RawBytes)))
		i += copy(dAtA[i:], m.RawBytes)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Timestamp.Size()))
	n1, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	return i, nil
}

func (m *KeyValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyValue) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Value.Size()))
	n2, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	return i, nil
}

func (m *StoreIdent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreIdent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.ClusterID.Size()))
	n3, err := m.ClusterID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.NodeID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintData(dAtA, i, uint64(m.NodeID))
	}
	if m.StoreID != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintData(dAtA, i, uint64(m.StoreID))
	}
	return i, nil
}

func (m *SplitTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SplitTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.LeftDesc.Size()))
	n4, err := m.LeftDesc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.RightDesc.Size()))
	n5, err := m.RightDesc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	return i, nil
}

func (m *MergeTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.LeftDesc.Size()))
	n6, err := m.LeftDesc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.RightDesc.Size()))
	n7, err := m.RightDesc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	dAtA[i] = 0x22
	i++
	i = encodeVarintData(dAtA, i, uint64(m.RightMVCCStats.Size()))
	n8, err := m.RightMVCCStats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	dAtA[i] = 0x2a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.FreezeStart.Size()))
	n9, err := m.FreezeStart.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	return i, nil
}

func (m *ChangeReplicasTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChangeReplicasTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ChangeType != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintData(dAtA, i, uint64(m.ChangeType))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Replica.Size()))
	n10, err := m.Replica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	if len(m.UpdatedReplicas) > 0 {
		for _, msg := range m.UpdatedReplicas {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.NextReplicaID != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintData(dAtA, i, uint64(m.NextReplicaID))
	}
	return i, nil
}

func (m *ModifiedSpanTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ModifiedSpanTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SystemConfigSpan {
		dAtA[i] = 0x8
		i++
		if m.SystemConfigSpan {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.NodeLivenessSpan != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintData(dAtA, i, uint64(m.NodeLivenessSpan.Size()))
		n11, err := m.NodeLivenessSpan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}

func (m *InternalCommitTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InternalCommitTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SplitTrigger != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(m.SplitTrigger.Size()))
		n12, err := m.SplitTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.MergeTrigger != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintData(dAtA, i, uint64(m.MergeTrigger.Size()))
		n13, err := m.MergeTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.ChangeReplicasTrigger != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintData(dAtA, i, uint64(m.ChangeReplicasTrigger.Size()))
		n14, err := m.ChangeReplicasTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.ModifiedSpanTrigger != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintData(dAtA, i, uint64(m.ModifiedSpanTrigger.Size()))
		n15, err := m.ModifiedSpanTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}

func (m *ObservedTimestamp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ObservedTimestamp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintData(dAtA, i, uint64(m.NodeID))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Timestamp.Size()))
	n16, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n16
	return i, nil
}

func (m *Transaction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Transaction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.TxnMeta.Size()))
	n17, err := m.TxnMeta.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n17
	if len(m.Name) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Status != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Status))
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.LastHeartbeat.Size()))
	n18, err := m.LastHeartbeat.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	dAtA[i] = 0x32
	i++
	i = encodeVarintData(dAtA, i, uint64(m.OrigTimestamp.Size()))
	n19, err := m.OrigTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n19
	dAtA[i] = 0x3a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.MaxTimestamp.Size()))
	n20, err := m.MaxTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n20
	if len(m.ObservedTimestamps) > 0 {
		for _, msg := range m.ObservedTimestamps {
			dAtA[i] = 0x42
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DeprecatedWriting {
		dAtA[i] = 0x48
		i++
		if m.DeprecatedWriting {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Intents) > 0 {
		for _, msg := range m.Intents {
			dAtA[i] = 0x5a
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.WriteTooOld {
		dAtA[i] = 0x60
		i++
		if m.WriteTooOld {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	dAtA[i] = 0x72
	i++
	i = encodeVarintData(dAtA, i, uint64(m.EpochZeroTimestamp.Size()))
	n21, err := m.EpochZeroTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n21
	dAtA[i] = 0x7a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.RefreshedTimestamp.Size()))
	n22, err := m.RefreshedTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n22
	if m.OrigTimestampWasObserved {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		if m.OrigTimestampWasObserved {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *TransactionRecord) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransactionRecord) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.TxnMeta.Size()))
	n23, err := m.TxnMeta.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n23
	if m.Status != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Status))
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.LastHeartbeat.Size()))
	n24, err := m.LastHeartbeat.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n24
	dAtA[i] = 0x32
	i++
	i = encodeVarintData(dAtA, i, uint64(m.OrigTimestamp.Size()))
	n25, err := m.OrigTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n25
	if len(m.Intents) > 0 {
		for _, msg := range m.Intents {
			dAtA[i] = 0x5a
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Intent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Intent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Span.Size()))
	n26, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n26
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Txn.Size()))
	n27, err := m.Txn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n27
	if m.Status != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Status))
	}
	return i, nil
}

func (m *SequencedWrite) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SequencedWrite) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if m.Sequence != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Sequence))
	}
	return i, nil
}

func (m *Lease) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Lease) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Start.Size()))
	n28, err := m.Start.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n28
	if m.Expiration != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Expiration.Size()))
		n29, err := m.Expiration.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Replica.Size()))
	n30, err := m.Replica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n30
	if m.DeprecatedStartStasis != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintData(dAtA, i, uint64(m.DeprecatedStartStasis.Size()))
		n31, err := m.DeprecatedStartStasis.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	if m.ProposedTS != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintData(dAtA, i, uint64(m.ProposedTS.Size()))
		n32, err := m.ProposedTS.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	if m.Epoch != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Epoch))
	}
	if m.Sequence != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Sequence))
	}
	return i, nil
}

func (m *AbortSpanEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AbortSpanEntry) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Timestamp.Size()))
	n33, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n33
	if m.Priority != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Priority))
	}
	return i, nil
}

func (m *TxnCoordMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TxnCoordMeta) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Txn.Size()))
	n34, err := m.Txn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n34
	if len(m.Intents) > 0 {
		for _, msg := range m.Intents {
			dAtA[i] = 0x12
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.CommandCount != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintData(dAtA, i, uint64(m.CommandCount))
	}
	if len(m.RefreshReads) > 0 {
		for _, msg := range m.RefreshReads {
			dAtA[i] = 0x22
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RefreshWrites) > 0 {
		for _, msg := range m.RefreshWrites {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.RefreshInvalid {
		dAtA[i] = 0x38
		i++
		if m.RefreshInvalid {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.OutstandingWrites) > 0 {
		for _, msg := range m.OutstandingWrites {
			dAtA[i] = 0x42
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeVarintData(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedSpan(r randyData, easy bool) *Span {
	this := &Span{}
	v1 := r.Intn(100)
	this.Key = make(Key, v1)
	for i := 0; i < v1; i++ {
		this.Key[i] = byte(r.Intn(256))
	}
	v2 := r.Intn(100)
	this.EndKey = make(Key, v2)
	for i := 0; i < v2; i++ {
		this.EndKey[i] = byte(r.Intn(256))
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedObservedTimestamp(r randyData, easy bool) *ObservedTimestamp {
	this := &ObservedTimestamp{}
	this.NodeID = NodeID(r.Int31())
	if r.Intn(2) == 0 {
		this.NodeID *= -1
	}
	v3 := hlc.NewPopulatedTimestamp(r, easy)
	this.Timestamp = *v3
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedTransaction(r randyData, easy bool) *Transaction {
	this := &Transaction{}
	v4 := enginepb.NewPopulatedTxnMeta(r, easy)
	this.TxnMeta = *v4
	this.Name = string(randStringData(r))
	this.Status = TransactionStatus([]int32{0, 1, 2}[r.Intn(3)])
	v5 := hlc.NewPopulatedTimestamp(r, easy)
	this.LastHeartbeat = *v5
	v6 := hlc.NewPopulatedTimestamp(r, easy)
	this.OrigTimestamp = *v6
	v7 := hlc.NewPopulatedTimestamp(r, easy)
	this.MaxTimestamp = *v7
	if r.Intn(10) != 0 {
		v8 := r.Intn(5)
		this.ObservedTimestamps = make([]ObservedTimestamp, v8)
		for i := 0; i < v8; i++ {
			v9 := NewPopulatedObservedTimestamp(r, easy)
			this.ObservedTimestamps[i] = *v9
		}
	}
	this.DeprecatedWriting = bool(bool(r.Intn(2) == 0))
	if r.Intn(10) != 0 {
		v10 := r.Intn(5)
		this.Intents = make([]Span, v10)
		for i := 0; i < v10; i++ {
			v11 := NewPopulatedSpan(r, easy)
			this.Intents[i] = *v11
		}
	}
	this.WriteTooOld = bool(bool(r.Intn(2) == 0))
	v12 := hlc.NewPopulatedTimestamp(r, easy)
	this.EpochZeroTimestamp = *v12
	v13 := hlc.NewPopulatedTimestamp(r, easy)
	this.RefreshedTimestamp = *v13
	this.OrigTimestampWasObserved = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedTransactionRecord(r randyData, easy bool) *TransactionRecord {
	this := &TransactionRecord{}
	v14 := enginepb.NewPopulatedTxnMeta(r, easy)
	this.TxnMeta = *v14
	this.Status = TransactionStatus([]int32{0, 1, 2}[r.Intn(3)])
	v15 := hlc.NewPopulatedTimestamp(r, easy)
	this.LastHeartbeat = *v15
	v16 := hlc.NewPopulatedTimestamp(r, easy)
	this.OrigTimestamp = *v16
	if r.Intn(10) != 0 {
		v17 := r.Intn(5)
		this.Intents = make([]Span, v17)
		for i := 0; i < v17; i++ {
			v18 := NewPopulatedSpan(r, easy)
			this.Intents[i] = *v18
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedLease(r randyData, easy bool) *Lease {
	this := &Lease{}
	v19 := hlc.NewPopulatedTimestamp(r, easy)
	this.Start = *v19
	if r.Intn(10) != 0 {
		this.Expiration = hlc.NewPopulatedTimestamp(r, easy)
	}
	v20 := NewPopulatedReplicaDescriptor(r, easy)
	this.Replica = *v20
	if r.Intn(10) != 0 {
		this.DeprecatedStartStasis = hlc.NewPopulatedTimestamp(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ProposedTS = hlc.NewPopulatedTimestamp(r, easy)
	}
	this.Epoch = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Epoch *= -1
	}
	this.Sequence = LeaseSequence(r.Int63())
	if r.Intn(2) == 0 {
		this.Sequence *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedAbortSpanEntry(r randyData, easy bool) *AbortSpanEntry {
	this := &AbortSpanEntry{}
	v21 := r.Intn(100)
	this.Key = make(Key, v21)
	for i := 0; i < v21; i++ {
		this.Key[i] = byte(r.Intn(256))
	}
	v22 := hlc.NewPopulatedTimestamp(r, easy)
	this.Timestamp = *v22
	this.Priority = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.Priority *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyData interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneData(r randyData) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringData(r randyData) string {
	v23 := r.Intn(100)
	tmps := make([]rune, v23)
	for i := 0; i < v23; i++ {
		tmps[i] = randUTF8RuneData(r)
	}
	return string(tmps)
}
func randUnrecognizedData(r randyData, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldData(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldData(dAtA []byte, r randyData, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateData(dAtA, uint64(key))
		v24 := r.Int63()
		if r.Intn(2) == 0 {
			v24 *= -1
		}
		dAtA = encodeVarintPopulateData(dAtA, uint64(v24))
	case 1:
		dAtA = encodeVarintPopulateData(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateData(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateData(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateData(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateData(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Span) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	return n
}

func (m *Value) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.RawBytes)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *KeyValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = m.Value.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *StoreIdent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ClusterID.Size()
	n += 1 + l + sovData(uint64(l))
	if m.NodeID != 0 {
		n += 1 + sovData(uint64(m.NodeID))
	}
	if m.StoreID != 0 {
		n += 1 + sovData(uint64(m.StoreID))
	}
	return n
}

func (m *SplitTrigger) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.LeftDesc.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.RightDesc.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *MergeTrigger) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.LeftDesc.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.RightDesc.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.RightMVCCStats.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.FreezeStart.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *ChangeReplicasTrigger) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ChangeType != 0 {
		n += 1 + sovData(uint64(m.ChangeType))
	}
	l = m.Replica.Size()
	n += 1 + l + sovData(uint64(l))
	if len(m.UpdatedReplicas) > 0 {
		for _, e := range m.UpdatedReplicas {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.NextReplicaID != 0 {
		n += 1 + sovData(uint64(m.NextReplicaID))
	}
	return n
}

func (m *ModifiedSpanTrigger) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SystemConfigSpan {
		n += 2
	}
	if m.NodeLivenessSpan != nil {
		l = m.NodeLivenessSpan.Size()
		n += 1 + l + sovData(uint64(l))
	}
	return n
}

func (m *InternalCommitTrigger) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SplitTrigger != nil {
		l = m.SplitTrigger.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.MergeTrigger != nil {
		l = m.MergeTrigger.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.ChangeReplicasTrigger != nil {
		l = m.ChangeReplicasTrigger.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.ModifiedSpanTrigger != nil {
		l = m.ModifiedSpanTrigger.Size()
		n += 1 + l + sovData(uint64(l))
	}
	return n
}

func (m *ObservedTimestamp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovData(uint64(m.NodeID))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *Transaction) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.TxnMeta.Size()
	n += 1 + l + sovData(uint64(l))
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovData(uint64(m.Status))
	}
	l = m.LastHeartbeat.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.OrigTimestamp.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.MaxTimestamp.Size()
	n += 1 + l + sovData(uint64(l))
	if len(m.ObservedTimestamps) > 0 {
		for _, e := range m.ObservedTimestamps {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.DeprecatedWriting {
		n += 2
	}
	if len(m.Intents) > 0 {
		for _, e := range m.Intents {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.WriteTooOld {
		n += 2
	}
	l = m.EpochZeroTimestamp.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.RefreshedTimestamp.Size()
	n += 1 + l + sovData(uint64(l))
	if m.OrigTimestampWasObserved {
		n += 3
	}
	return n
}

func (m *TransactionRecord) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.TxnMeta.Size()
	n += 1 + l + sovData(uint64(l))
	if m.Status != 0 {
		n += 1 + sovData(uint64(m.Status))
	}
	l = m.LastHeartbeat.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.OrigTimestamp.Size()
	n += 1 + l + sovData(uint64(l))
	if len(m.Intents) > 0 {
		for _, e := range m.Intents {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	return n
}

func (m *Intent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.Txn.Size()
	n += 1 + l + sovData(uint64(l))
	if m.Status != 0 {
		n += 1 + sovData(uint64(m.Status))
	}
	return n
}

func (m *SequencedWrite) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.Sequence != 0 {
		n += 1 + sovData(uint64(m.Sequence))
	}
	return n
}

func (m *Lease) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Start.Size()
	n += 1 + l + sovData(uint64(l))
	if m.Expiration != nil {
		l = m.Expiration.Size()
		n += 1 + l + sovData(uint64(l))
	}
	l = m.Replica.Size()
	n += 1 + l + sovData(uint64(l))
	if m.DeprecatedStartStasis != nil {
		l = m.DeprecatedStartStasis.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.ProposedTS != nil {
		l = m.ProposedTS.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.Epoch != 0 {
		n += 1 + sovData(uint64(m.Epoch))
	}
	if m.Sequence != 0 {
		n += 1 + sovData(uint64(m.Sequence))
	}
	return n
}

func (m *AbortSpanEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovData(uint64(l))
	if m.Priority != 0 {
		n += 1 + sovData(uint64(m.Priority))
	}
	return n
}

func (m *TxnCoordMeta) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Txn.Size()
	n += 1 + l + sovData(uint64(l))
	if len(m.Intents) > 0 {
		for _, e := range m.Intents {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.CommandCount != 0 {
		n += 1 + sovData(uint64(m.CommandCount))
	}
	if len(m.RefreshReads) > 0 {
		for _, e := range m.RefreshReads {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if len(m.RefreshWrites) > 0 {
		for _, e := range m.RefreshWrites {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.RefreshInvalid {
		n += 2
	}
	if len(m.OutstandingWrites) > 0 {
		for _, e := range m.OutstandingWrites {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	return n
}

func sovData(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozData(x uint64) (n int) {
	return sovData(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Span) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Span: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Span: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawBytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawBytes = append(m.RawBytes[:0], dAtA[iNdEx:postIndex]...)
			if m.RawBytes == nil {
				m.RawBytes = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreIdent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreIdent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreIdent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ClusterID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SplitTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SplitTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SplitTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeftDesc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LeftDesc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RightDesc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RightDesc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeftDesc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LeftDesc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RightDesc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RightDesc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RightMVCCStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RightMVCCStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FreezeStart", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FreezeStart.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChangeReplicasTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChangeReplicasTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChangeReplicasTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeType", wireType)
			}
			m.ChangeType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ChangeType |= (ReplicaChangeType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Replica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatedReplicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpdatedReplicas = append(m.UpdatedReplicas, ReplicaDescriptor{})
			if err := m.UpdatedReplicas[len(m.UpdatedReplicas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextReplicaID", wireType)
			}
			m.NextReplicaID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextReplicaID |= (ReplicaID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ModifiedSpanTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ModifiedSpanTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ModifiedSpanTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SystemConfigSpan", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SystemConfigSpan = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeLivenessSpan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NodeLivenessSpan == nil {
				m.NodeLivenessSpan = &Span{}
			}
			if err := m.NodeLivenessSpan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InternalCommitTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InternalCommitTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InternalCommitTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SplitTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SplitTrigger == nil {
				m.SplitTrigger = &SplitTrigger{}
			}
			if err := m.SplitTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MergeTrigger == nil {
				m.MergeTrigger = &MergeTrigger{}
			}
			if err := m.MergeTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeReplicasTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ChangeReplicasTrigger == nil {
				m.ChangeReplicasTrigger = &ChangeReplicasTrigger{}
			}
			if err := m.ChangeReplicasTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ModifiedSpanTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ModifiedSpanTrigger == nil {
				m.ModifiedSpanTrigger = &ModifiedSpanTrigger{}
			}
			if err := m.ModifiedSpanTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ObservedTimestamp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ObservedTimestamp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ObservedTimestamp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Transaction) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Transaction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Transaction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (TransactionStatus(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LastHeartbeat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrigTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OrigTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MaxTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObservedTimestamps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ObservedTimestamps = append(m.ObservedTimestamps, ObservedTimestamp{})
			if err := m.ObservedTimestamps[len(m.ObservedTimestamps)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedWriting", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DeprecatedWriting = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Intents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Intents = append(m.Intents, Span{})
			if err := m.Intents[len(m.Intents)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteTooOld", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WriteTooOld = bool(v != 0)
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EpochZeroTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EpochZeroTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshedTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RefreshedTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrigTimestampWasObserved", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.OrigTimestampWasObserved = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransactionRecord) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransactionRecord: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransactionRecord: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (TransactionStatus(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LastHeartbeat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrigTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OrigTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Intents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Intents = append(m.Intents, Span{})
			if err := m.Intents[len(m.Intents)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Intent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Intent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Intent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (TransactionStatus(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SequencedWrite) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SequencedWrite: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SequencedWrite: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Lease) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Lease: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Lease: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Start.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expiration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Expiration == nil {
				m.Expiration = &hlc.Timestamp{}
			}
			if err := m.Expiration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Replica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedStartStasis", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedStartStasis == nil {
				m.DeprecatedStartStasis = &hlc.Timestamp{}
			}
			if err := m.DeprecatedStartStasis.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposedTS", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProposedTS == nil {
				m.ProposedTS = &hlc.Timestamp{}
			}
			if err := m.ProposedTS.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Epoch", wireType)
			}
			m.Epoch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Epoch |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= (LeaseSequence(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AbortSpanEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AbortSpanEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AbortSpanEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxnCoordMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxnCoordMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxnCoordMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Intents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Intents = append(m.Intents, Span{})
			if err := m.Intents[len(m.Intents)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommandCount", wireType)
			}
			m.CommandCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommandCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshReads", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RefreshReads = append(m.RefreshReads, Span{})
			if err := m.RefreshReads[len(m.RefreshReads)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshWrites", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RefreshWrites = append(m.RefreshWrites, Span{})
			if err := m.RefreshWrites[len(m.RefreshWrites)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshInvalid", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RefreshInvalid = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutstandingWrites", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OutstandingWrites = append(m.OutstandingWrites, SequencedWrite{})
			if err := m.OutstandingWrites[len(m.OutstandingWrites)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipData(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowData
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowData
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowData
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthData
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowData
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipData(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthData = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowData   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("roachpb/data.proto", fileDescriptor_data_a87162148e6fc734) }

var fileDescriptor_data_a87162148e6fc734 = []byte{
	// 1947 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x58, 0xcf, 0x6f, 0xdb, 0xc8,
	0xf5, 0x37, 0x45, 0x4a, 0xa2, 0x9e, 0x7e, 0x98, 0x9e, 0xc4, 0x89, 0xbe, 0x59, 0x7c, 0xa5, 0xac,
	0xb6, 0x68, 0x83, 0x60, 0x23, 0xa3, 0x49, 0x7f, 0xa0, 0x46, 0x5b, 0x40, 0xbf, 0x92, 0x50, 0xb1,
	0xe4, 0x80, 0xa2, 0x13, 0x6c, 0x16, 0x0b, 0x96, 0x26, 0xc7, 0x32, 0x11, 0x89, 0x54, 0x87, 0x23,
	0xc7, 0xde, 0xbf, 0x60, 0x6f, 0xdd, 0x43, 0x0f, 0x3d, 0x06, 0xe8, 0xad, 0xf7, 0xa2, 0xfb, 0x1f,
	0x34, 0x97, 0x02, 0x7b, 0x6b, 0xd1, 0x83, 0xd0, 0xaa, 0x97, 0x02, 0xbd, 0xf5, 0x18, 0xa0, 0x40,
	0x31, 0x33, 0xa4, 0x44, 0xd7, 0x8a, 0x21, 0xef, 0xee, 0xa1, 0xe8, 0xc5, 0x9e, 0x79, 0xf3, 0xde,
	0xe7, 0xcd, 0xbc, 0x1f, 0x9f, 0x19, 0x0a, 0x10, 0x09, 0x6c, 0xe7, 0x78, 0x72, 0xb8, 0xe3, 0xda,
	0xd4, 0xae, 0x4f, 0x48, 0x40, 0x03, 0xb4, 0xe5, 0x04, 0xce, 0x4b, 0x2e, 0xaf, 0x47, 0xab, 0xb7,
	0x6e, 0xc4, 0x6a, 0x63, 0x4c, 0xed, 0xa5, 0xea, 0xad, 0x5a, 0x48, 0x03, 0x62, 0x0f, 0xf1, 0x0e,
	0xf6, 0x87, 0x9e, 0x1f, 0xff, 0x63, 0x7a, 0x27, 0x8e, 0x13, 0xe9, 0x7c, 0x70, 0x99, 0xce, 0x83,
	0x48, 0xa9, 0x3c, 0xa5, 0xde, 0x68, 0xe7, 0x78, 0xe4, 0xec, 0x50, 0x6f, 0x8c, 0x43, 0x6a, 0x8f,
	0x27, 0xd1, 0xca, 0xf5, 0x61, 0x30, 0x0c, 0xf8, 0x70, 0x87, 0x8d, 0x84, 0xb4, 0xf6, 0x09, 0x28,
	0x83, 0x89, 0xed, 0xa3, 0xff, 0x03, 0xf9, 0x25, 0x3e, 0x2b, 0xcb, 0xb7, 0xa5, 0x3b, 0x85, 0x66,
	0xf6, 0xed, 0xac, 0x2a, 0x3f, 0xc1, 0x67, 0x06, 0x93, 0xa1, 0xdb, 0x90, 0xc5, 0xbe, 0x6b, 0xb1,
	0x65, 0xe5, 0xfc, 0x72, 0x06, 0xfb, 0xee, 0x13, 0x7c, 0xb6, 0x5b, 0xf8, 0xd5, 0xeb, 0xea, 0xc6,
	0x17, 0xaf, 0xab, 0xd2, 0xdf, 0x5f, 0x57, 0xa5, 0xae, 0xa2, 0x4a, 0x5a, 0xaa, 0xab, 0xa8, 0x29,
	0x4d, 0xae, 0x8d, 0x21, 0xfd, 0xcc, 0x1e, 0x4d, 0x31, 0x7a, 0x0f, 0x72, 0xc4, 0x7e, 0x65, 0x1d,
	0x9e, 0x51, 0x1c, 0x96, 0x25, 0x06, 0x63, 0xa8, 0xc4, 0x7e, 0xd5, 0x64, 0x73, 0xd4, 0x80, 0xdc,
	0x62, 0xb7, 0xe5, 0xd4, 0x6d, 0xe9, 0x4e, 0xfe, 0xfe, 0xff, 0xd7, 0x97, 0xc1, 0x63, 0x47, 0xaa,
	0x1f, 0x8f, 0x9c, 0xba, 0x19, 0x2b, 0x35, 0x95, 0x37, 0xb3, 0xea, 0x86, 0xb1, 0xb4, 0xda, 0x55,
	0x98, 0xeb, 0xda, 0xc7, 0xa0, 0x3e, 0xc1, 0x67, 0xc2, 0x63, 0x74, 0x22, 0x69, 0xc5, 0x89, 0xbe,
	0x07, 0xe9, 0x13, 0xa6, 0x13, 0xf9, 0x2a, 0xd7, 0x2f, 0x24, 0xaa, 0xce, 0x31, 0x22, 0x37, 0x42,
	0xb9, 0xf6, 0x47, 0x09, 0x60, 0x40, 0x03, 0x82, 0x75, 0x17, 0xfb, 0x14, 0x0d, 0x01, 0x9c, 0xd1,
	0x34, 0xa4, 0x98, 0x58, 0x9e, 0x1b, 0xb9, 0x79, 0xcc, 0xf4, 0xff, 0x3c, 0xab, 0x3e, 0x18, 0x7a,
	0xf4, 0x78, 0x7a, 0x58, 0x77, 0x82, 0xf1, 0xce, 0x02, 0xdb, 0x3d, 0x5c, 0x8e, 0x77, 0x26, 0x2f,
	0x87, 0x3b, 0x3c, 0x55, 0xd3, 0xa9, 0xe7, 0xd6, 0x0f, 0x0e, 0xf4, 0xf6, 0x7c, 0x56, 0xcd, 0xb5,
	0x04, 0xa0, 0xde, 0x36, 0x72, 0x11, 0xb6, 0xee, 0xa2, 0x7b, 0x90, 0xf5, 0x03, 0x17, 0x33, 0x2f,
	0x6c, 0xbf, 0xe9, 0xe6, 0xf5, 0xf9, 0xac, 0x9a, 0xe9, 0x07, 0x2e, 0xd6, 0xdb, 0x6f, 0x17, 0x23,
	0x23, 0xc3, 0x94, 0x74, 0x17, 0x7d, 0x17, 0x54, 0x56, 0x28, 0x5c, 0x5f, 0xe6, 0xfa, 0x37, 0xe6,
	0xb3, 0x6a, 0x56, 0xec, 0x9c, 0x19, 0xc4, 0x43, 0x23, 0x1b, 0x8a, 0xd3, 0xd4, 0x7e, 0x23, 0x41,
	0x61, 0x30, 0x19, 0x79, 0xd4, 0x24, 0xde, 0x70, 0x88, 0x09, 0xea, 0x40, 0x6e, 0x84, 0x8f, 0xa8,
	0xe5, 0xe2, 0xd0, 0xe1, 0x47, 0xcb, 0xdf, 0xaf, 0xad, 0x08, 0x92, 0x61, 0xfb, 0x43, 0xdc, 0xc6,
	0xa1, 0x43, 0xbc, 0x09, 0x0d, 0x48, 0x14, 0x2e, 0x95, 0x99, 0x32, 0x29, 0x7a, 0x04, 0x40, 0xbc,
	0xe1, 0x71, 0x84, 0x93, 0xba, 0x22, 0x4e, 0x8e, 0xdb, 0x32, 0xb1, 0xc8, 0x6e, 0x57, 0x51, 0x65,
	0x4d, 0xa9, 0xcd, 0x53, 0x50, 0xe8, 0x61, 0x32, 0xc4, 0xff, 0xa5, 0x9b, 0x45, 0x3e, 0x68, 0x02,
	0x88, 0xf5, 0xa5, 0x15, 0x52, 0x9b, 0x86, 0xbc, 0x71, 0xf2, 0xf7, 0x3f, 0x4c, 0xc0, 0x45, 0xcd,
	0x5c, 0x17, 0x5d, 0x5c, 0x8f, 0x9b, 0xb9, 0xde, 0x7b, 0xd6, 0x6a, 0x0d, 0x98, 0x4d, 0xf3, 0x06,
	0x03, 0x9e, 0xcf, 0xaa, 0x25, 0x83, 0xa1, 0x2d, 0xe4, 0x46, 0x89, 0xa3, 0xf7, 0x4e, 0x1c, 0x87,
	0xcf, 0xd1, 0x43, 0x28, 0x1c, 0x11, 0x8c, 0x3f, 0xc5, 0xcc, 0x17, 0xa1, 0xe5, 0xf4, 0xfa, 0x0d,
	0x94, 0x17, 0x86, 0x03, 0x66, 0x77, 0x2e, 0xc8, 0x7f, 0x48, 0xc1, 0x76, 0xeb, 0x98, 0x9d, 0xd4,
	0xc0, 0x93, 0x91, 0xe7, 0xd8, 0xe1, 0x32, 0xda, 0x79, 0x87, 0x2f, 0x58, 0xf4, 0x6c, 0x82, 0x79,
	0xbc, 0x4b, 0xf7, 0xbf, 0xb5, 0x2a, 0x4e, 0xc2, 0x50, 0xa0, 0x98, 0x67, 0x13, 0x6c, 0x80, 0xb3,
	0x18, 0xa3, 0x36, 0x64, 0x89, 0x50, 0x88, 0x42, 0x7d, 0x09, 0xc4, 0x85, 0x60, 0xc7, 0xa6, 0xe8,
	0x00, 0xb4, 0xe9, 0xc4, 0xb5, 0x29, 0x76, 0xad, 0x48, 0x14, 0x96, 0xe5, 0xdb, 0xf2, 0x15, 0xe1,
	0x36, 0x23, 0x8c, 0xf8, 0xa8, 0xe8, 0x21, 0x6c, 0xfa, 0xf8, 0x94, 0xc6, 0x98, 0xac, 0x93, 0x14,
	0xde, 0x49, 0x95, 0xf9, 0xac, 0x5a, 0xec, 0xe3, 0x53, 0x1a, 0xa9, 0xf2, 0x7e, 0xca, 0x2d, 0x26,
	0x46, 0xd1, 0x4f, 0xac, 0xb9, 0xbb, 0x2a, 0xe3, 0x45, 0x4e, 0x4c, 0x9f, 0x4b, 0x70, 0xad, 0x17,
	0xb8, 0xde, 0x91, 0x87, 0x5d, 0xc6, 0xb7, 0x71, 0x34, 0x3f, 0x04, 0x14, 0x9e, 0x85, 0x14, 0x8f,
	0x2d, 0x27, 0xf0, 0x8f, 0xbc, 0xa1, 0x15, 0x4e, 0x6c, 0x9f, 0x07, 0x55, 0x35, 0x34, 0xb1, 0xd2,
	0xe2, 0x0b, 0x9c, 0xa4, 0x3b, 0x80, 0x38, 0x13, 0x8c, 0xbc, 0x13, 0xec, 0xe3, 0x30, 0x14, 0xda,
	0x22, 0x7e, 0x37, 0x57, 0x1c, 0x98, 0x19, 0x19, 0x1a, 0x33, 0xd9, 0x8b, 0x2c, 0x98, 0x24, 0xe2,
	0xca, 0x7f, 0xa4, 0x60, 0x5b, 0xf7, 0x29, 0x26, 0xbe, 0x3d, 0x6a, 0x05, 0xe3, 0xf1, 0xb2, 0xfb,
	0xdb, 0x50, 0x0c, 0x19, 0x1b, 0x58, 0x54, 0x08, 0xa2, 0xa6, 0xaa, 0xae, 0xf4, 0xb0, 0x64, 0x0d,
	0xa3, 0x10, 0x26, 0x39, 0xa4, 0x0d, 0xc5, 0x31, 0x6b, 0xd3, 0x05, 0x4a, 0xea, 0x9d, 0x28, 0xc9,
	0x76, 0x36, 0x0a, 0xe3, 0x64, 0x73, 0xff, 0x0c, 0x6e, 0x46, 0xe5, 0x16, 0x27, 0x78, 0x81, 0x27,
	0x73, 0xbc, 0x3b, 0x2b, 0xf0, 0x56, 0x56, 0xae, 0xb1, 0xed, 0xac, 0x2c, 0xe8, 0x17, 0xb0, 0x3d,
	0x8e, 0x32, 0xc3, 0xe3, 0xb9, 0xc0, 0x17, 0x3d, 0xfb, 0xed, 0x55, 0xfb, 0xbd, 0x98, 0x49, 0xe3,
	0xda, 0xf8, 0xa2, 0x70, 0x57, 0xfd, 0x2c, 0xba, 0x14, 0x6b, 0xbf, 0x90, 0x60, 0x6b, 0xff, 0x30,
	0xc4, 0xe4, 0x04, 0xbb, 0x8b, 0x2e, 0x4c, 0x52, 0xbb, 0xb4, 0x06, 0xb5, 0x7f, 0x03, 0xf7, 0xa4,
	0x1a, 0x5f, 0xd3, 0xb5, 0xb7, 0x19, 0xc8, 0x9b, 0xc4, 0xf6, 0x43, 0xdb, 0xa1, 0x5e, 0xe0, 0xa3,
	0xc7, 0xa0, 0xb0, 0x47, 0x49, 0x94, 0xec, 0xbb, 0x6b, 0x50, 0x95, 0x79, 0xea, 0xf7, 0x30, 0xb5,
	0x9b, 0x2a, 0x73, 0xf2, 0xe5, 0xac, 0x2a, 0x19, 0x1c, 0x01, 0x21, 0x50, 0x7c, 0x7b, 0x2c, 0x6e,
	0xd7, 0x9c, 0xc1, 0xc7, 0xe8, 0xc7, 0x90, 0x61, 0x4c, 0x38, 0x15, 0x54, 0xb8, 0x9a, 0x31, 0x12,
	0xbb, 0x19, 0x70, 0x5d, 0x23, 0xb2, 0x41, 0x5d, 0x28, 0x8d, 0xec, 0x90, 0x5a, 0xc7, 0xd8, 0x26,
	0xf4, 0x10, 0xdb, 0x57, 0x22, 0xb9, 0x22, 0x33, 0x7d, 0x1c, 0x5b, 0x32, 0xac, 0x80, 0x78, 0x43,
	0x6b, 0x19, 0xc9, 0xcc, 0x15, 0xb0, 0x98, 0xe9, 0x32, 0x7f, 0x8f, 0xa1, 0x38, 0xb6, 0x4f, 0x13,
	0x50, 0xd9, 0xf5, 0xa1, 0x0a, 0x63, 0xfb, 0x74, 0x89, 0xf4, 0x31, 0x5c, 0x0b, 0xa2, 0xf2, 0x58,
	0xc2, 0x85, 0x65, 0xf5, 0x9d, 0x64, 0x76, 0xa1, 0x98, 0x22, 0x58, 0x14, 0xfc, 0xe7, 0x42, 0x88,
	0xee, 0x01, 0x72, 0xf1, 0x84, 0x60, 0x87, 0x33, 0xe5, 0x2b, 0xe2, 0x51, 0xcf, 0x1f, 0x96, 0x73,
	0x9c, 0x65, 0xb6, 0x96, 0x2b, 0xcf, 0xc5, 0x02, 0xfa, 0x21, 0x64, 0x3d, 0x9f, 0x62, 0x9f, 0x86,
	0xe5, 0x3c, 0xf7, 0xff, 0x2e, 0x6e, 0x89, 0xe9, 0x38, 0xd2, 0x46, 0x35, 0x28, 0x32, 0x70, 0x6c,
	0xd1, 0x20, 0xb0, 0x82, 0x91, 0x5b, 0x2e, 0x70, 0x17, 0x79, 0x2e, 0x34, 0x83, 0x60, 0x7f, 0xe4,
	0xa2, 0x03, 0xb8, 0x8e, 0x27, 0x81, 0x73, 0x6c, 0x7d, 0x8a, 0x49, 0x90, 0x88, 0x5c, 0x69, 0xfd,
	0xc8, 0x21, 0x0e, 0xf0, 0x02, 0x93, 0x60, 0x19, 0x3f, 0x13, 0xae, 0x11, 0x7c, 0x44, 0x70, 0x78,
	0x9c, 0x0c, 0x60, 0x79, 0xf3, 0x0a, 0xa8, 0x0b, 0xfb, 0x25, 0xea, 0x4f, 0xe0, 0xbd, 0xf3, 0xb5,
	0x62, 0xbd, 0xb2, 0x43, 0x2b, 0x8e, 0x70, 0x59, 0xe3, 0xc7, 0x2b, 0x9f, 0xab, 0x89, 0xe7, 0x76,
	0x18, 0xa7, 0xe6, 0xc2, 0xbb, 0x58, 0xd6, 0x94, 0xae, 0xa2, 0x16, 0xb5, 0x52, 0xed, 0x0b, 0x19,
	0xb6, 0x12, 0xe5, 0x6e, 0x60, 0x27, 0x20, 0xee, 0x37, 0xd8, 0x82, 0xff, 0x9b, 0xed, 0xf6, 0x55,
	0x0b, 0x73, 0xc9, 0x7a, 0xe2, 0xb3, 0x64, 0x91, 0x8a, 0xac, 0xa6, 0x76, 0x15, 0x55, 0xd5, 0x72,
	0x5d, 0x45, 0xcd, 0x69, 0xd0, 0x55, 0x54, 0xd0, 0xf2, 0x5d, 0x45, 0x2d, 0x68, 0x45, 0x91, 0xa8,
	0xae, 0xa2, 0x96, 0xb4, 0xcd, 0xae, 0xa2, 0x6e, 0x6a, 0x5a, 0x57, 0x51, 0x35, 0x6d, 0xab, 0xf6,
	0x7b, 0x09, 0x32, 0x3a, 0xc7, 0x45, 0xdf, 0x07, 0x65, 0x71, 0x5f, 0x5f, 0xb2, 0x99, 0x44, 0x72,
	0x98, 0x3a, 0x6a, 0x82, 0x4c, 0x4f, 0xe3, 0x7b, 0xfb, 0x2a, 0x59, 0x16, 0xa7, 0x62, 0xc6, 0x89,
	0x04, 0xcb, 0x57, 0x4f, 0x70, 0xf4, 0x02, 0x78, 0x04, 0xa5, 0x01, 0xfe, 0xf9, 0x14, 0xfb, 0x8e,
	0xe8, 0xfd, 0x4b, 0xbf, 0x99, 0x6e, 0x81, 0x1a, 0x46, 0xca, 0xe2, 0x33, 0xc4, 0x58, 0xcc, 0x6b,
	0xff, 0x92, 0x21, 0xbd, 0x87, 0xed, 0x10, 0xa3, 0x1f, 0x41, 0x5a, 0x3c, 0x42, 0xa5, 0xf5, 0x93,
	0x2c, 0x2c, 0xd0, 0x27, 0x00, 0xf8, 0x74, 0xe2, 0x11, 0x9b, 0xed, 0x77, 0xbd, 0xdb, 0xad, 0xf2,
	0xcf, 0x59, 0xf5, 0x56, 0xe2, 0xfb, 0x6a, 0xb7, 0x46, 0x6c, 0xdf, 0xf5, 0xa7, 0xa3, 0x91, 0x7d,
	0x38, 0xc2, 0x35, 0x23, 0x01, 0x98, 0x7c, 0x70, 0xca, 0x5f, 0xfd, 0xc1, 0x39, 0x85, 0x9b, 0x09,
	0x26, 0xe5, 0x1b, 0x67, 0x7f, 0x43, 0x2f, 0x7e, 0xe2, 0x7f, 0xcd, 0x1d, 0x6f, 0x2f, 0xd1, 0xf9,
	0xa3, 0x7c, 0xc0, 0xb1, 0x51, 0x1f, 0xf2, 0x13, 0x12, 0x4c, 0x82, 0x90, 0x91, 0x5b, 0xb8, 0x5e,
	0x37, 0x96, 0xe6, 0xb3, 0x2a, 0x3c, 0x8d, 0xac, 0xcc, 0x81, 0x01, 0x31, 0x82, 0x19, 0xa2, 0xeb,
	0x90, 0xe6, 0x1c, 0xca, 0x7b, 0x51, 0x36, 0xc4, 0x04, 0xdd, 0x4b, 0xa4, 0x98, 0x5d, 0x64, 0x72,
	0x73, 0xeb, 0xed, 0xac, 0x5a, 0xe4, 0x99, 0x8d, 0x0b, 0x65, 0x99, 0x75, 0xf1, 0xba, 0x65, 0x8d,
	0x55, 0xfb, 0xa5, 0x04, 0xa5, 0xc6, 0x61, 0x40, 0x28, 0x2b, 0xf7, 0x8e, 0x4f, 0xc9, 0xd9, 0x65,
	0x95, 0xf4, 0xf5, 0x5f, 0x31, 0xac, 0x18, 0x27, 0xc4, 0x0b, 0x88, 0x47, 0xc5, 0x4f, 0x16, 0x69,
	0x63, 0x31, 0x4f, 0xbc, 0x70, 0x7e, 0x2b, 0x43, 0xc1, 0x3c, 0xf5, 0x5b, 0x41, 0x40, 0x5c, 0xd6,
	0x3f, 0xe8, 0x07, 0xa2, 0xf1, 0x44, 0x6d, 0x56, 0x2e, 0xef, 0x98, 0x64, 0xb3, 0x25, 0x78, 0x27,
	0x75, 0xa5, 0x0b, 0xf1, 0x03, 0x28, 0x3a, 0xc1, 0x78, 0x6c, 0xfb, 0xae, 0xe5, 0x04, 0x53, 0x9f,
	0x46, 0x9b, 0x2d, 0x44, 0xc2, 0x16, 0x93, 0xa1, 0x26, 0x14, 0xa3, 0xab, 0xc7, 0x22, 0xd8, 0x76,
	0x59, 0x25, 0xad, 0xe1, 0xa3, 0x10, 0xd9, 0x18, 0xcc, 0x04, 0xb5, 0xa1, 0x14, 0x63, 0xf0, 0xcb,
	0x96, 0xd5, 0xc8, 0x1a, 0x20, 0xb1, 0x63, 0xde, 0xfd, 0x21, 0xfa, 0x0e, 0x6c, 0xc6, 0x28, 0x9e,
	0x7f, 0x62, 0x8f, 0x3c, 0x97, 0xd7, 0x81, 0x6a, 0xc4, 0xe0, 0xba, 0x90, 0xa2, 0x67, 0x80, 0x82,
	0x29, 0x0d, 0xa9, 0xed, 0xbb, 0x9e, 0x3f, 0x8c, 0x5d, 0x8a, 0xc7, 0xca, 0xfb, 0xab, 0x5c, 0x9e,
	0xa3, 0x99, 0xc8, 0xf9, 0x56, 0x02, 0x42, 0x6c, 0xa0, 0xab, 0xa8, 0x19, 0x2d, 0x7b, 0xf7, 0x77,
	0x12, 0xe4, 0xf8, 0xef, 0x2f, 0xfc, 0x4b, 0x31, 0x0f, 0xd9, 0x83, 0xfe, 0x93, 0xfe, 0xfe, 0xf3,
	0xbe, 0xb6, 0x81, 0xb2, 0x20, 0xeb, 0x7d, 0x53, 0x93, 0x50, 0x0e, 0xd2, 0x0f, 0xf7, 0xf6, 0x1b,
	0xa6, 0x96, 0x62, 0xc3, 0xe6, 0x47, 0x66, 0x67, 0xa0, 0xc9, 0xe8, 0x1a, 0x6c, 0xb6, 0x3b, 0x7b,
	0x7a, 0x4f, 0x37, 0x3b, 0x6d, 0x4b, 0x08, 0x55, 0xa4, 0x82, 0x62, 0xea, 0xbd, 0x8e, 0xa6, 0x30,
	0xa8, 0x76, 0xa7, 0xa5, 0xf7, 0x1a, 0x7b, 0x5a, 0x1a, 0x6d, 0xc3, 0xd6, 0x52, 0x37, 0x16, 0xe7,
	0x50, 0x01, 0xd4, 0xf6, 0x81, 0xd1, 0x30, 0xf5, 0xfd, 0xbe, 0x96, 0x61, 0xd8, 0xe6, 0xc1, 0xd3,
	0xbd, 0x8e, 0x06, 0x6c, 0xa1, 0xa9, 0x9b, 0x0d, 0xc3, 0x68, 0x7c, 0xa4, 0xe5, 0x51, 0x09, 0x80,
	0x81, 0x0e, 0x3a, 0x86, 0xde, 0x19, 0x68, 0x6e, 0x8d, 0xdd, 0x25, 0xd9, 0xbb, 0x3f, 0x85, 0xad,
	0x0b, 0x9f, 0xbd, 0x68, 0x13, 0xf2, 0x8d, 0x76, 0xdb, 0x32, 0x3a, 0x4f, 0xf7, 0xf4, 0x56, 0x43,
	0xdb, 0x40, 0x08, 0x4a, 0x46, 0xa7, 0xb7, 0xff, 0xac, 0xb3, 0x90, 0x49, 0xb7, 0x94, 0xcf, 0x7e,
	0x5d, 0xd9, 0xb8, 0xdb, 0x3c, 0xf7, 0x2a, 0x10, 0xa4, 0xcd, 0x76, 0xfd, 0xb4, 0xd3, 0x6f, 0xeb,
	0xfd, 0x47, 0xda, 0x06, 0x2a, 0x42, 0xae, 0xb5, 0xdf, 0xeb, 0xe9, 0xa6, 0xd9, 0x69, 0x6b, 0x12,
	0x5b, 0x6b, 0x34, 0xf7, 0x0d, 0x36, 0x49, 0x09, 0x8c, 0xe6, 0xfb, 0x6f, 0xfe, 0x5a, 0xd9, 0x78,
	0x33, 0xaf, 0x48, 0x5f, 0xce, 0x2b, 0xd2, 0x9f, 0xe6, 0x15, 0xe9, 0x2f, 0xf3, 0x8a, 0xf4, 0xf9,
	0xdf, 0x2a, 0x1b, 0x2f, 0xb2, 0x51, 0x3a, 0x0e, 0x33, 0xfc, 0xb7, 0xbf, 0x07, 0xff, 0x0e, 0x00,
	0x00, 0xff, 0xff, 0x5a, 0xf7, 0x66, 0xe3, 0xb5, 0x14, 0x00, 0x00,
}
