#!/bin/ksh
# execute.sh
# $Id: execute.sh,v 1.3 2001/09/01 00:56:46 gwiley Exp $
# Glen Wiley, gwiley@ieee.org
#
#  tests of execution features for pdv utilities
#
# TODO: negative tests - bogus arguments etc.

#-------------------- TEST: simple file package with exec

print "BEGIN TEST:"
print "TARGET: pdv stub, pdvmkpkg"
print "GOAL:   test executable handling"
print "EXPECT: exit status 0, matching diag. message"

cat > shell.tmp <<-EOF
#!/bin/ksh

print "kilroy was here"
print "whoopee - I'm alive...."
EOF
chmod +x shell.tmp

../pdvmkpkg -e ./shell.tmp -o shell.tmp -c pkg.tmp shell.tmp
print "exit status = $?"
rm -f shell.tmp
./pkg.tmp
print "exit status = $?"

print "package data follows:"
cat shell.tmp
set -- `ls -l shell.tmp`
print "end package data"
print "extracted package file size: $5"

rm -f shell.tmp exec.tmp pkg.tmp

print "END TEST"

#-------------------- TEST: execute with compress filter

print "BEGIN TEST:"
print "TARGET: pdv stub, pdvmkpkg"
print "GOAL:   test executable handling using compressed file"
print "EXPECT: exit status 0, matching diag. message"

cat > shell.tmp <<-EOF
#!/bin/ksh

print "kilroy was here"
print "whoopee - I'm alive...."
EOF
chmod +x shell.tmp
compress -f shell.tmp

../pdvmkpkg -C -e ./shell.tmp -o shell.tmp -c pkg.tmp shell.tmp.Z
print "exit status = $?"
rm -f shell.tmp shell.tmp.Z
./pkg.tmp
print "exit status = $?"

print "package data follows:"
cat shell.tmp
set -- `ls -l shell.tmp`
print "end package data"
print "extracted package file size: $5"

rm -f exec.tmp pkg.tmp shell.tmp shell.tmp.Z

print "END TEST"

return 0
# execute.sh
