#!/bin/ksh
# basic.sh
# $Id: basic.sh,v 1.4 2001/09/30 01:33:46 gwiley Exp $
# Glen Wiley, gwiley@ieee.org
#
# basic tests for pdv utilities
#
# TODO: negative tests - bogus arguments etc.

#-------------------- TEST: empty pkg run

print "BEGIN TEST:"
print "TARGET: pdv stub"
print "GOAL:   empty arg. list, missing pkg, force an error"
print "EXPECT: exit status 1, matching diag. message"

../pdv

print "exit status = $?"
print "END TEST"

print "BEGIN TEST:"
print "TARGET: pdv stub version option"
print "GOAL:   get version message from stub"
print "EXPECT: similar diag. message"

# remove the actual version number - just want to be sure the msg showed up
../pdv -v | sed 's/[0-9]\.*//g'

print "exit status = $?"
print "END TEST"

print "BEGIN TEST:"
print "TARGET: pdvmkpkg"
print "GOAL:   empty arg. list should deliver consistent diagnostic"
print "EXPECT: exit status 1, matching diag. message"

../pdvmkpkg

print "exit status = $?"
print "END TEST"

#-------------------- TEST: simple file package

print "BEGIN TEST:"
print "TARGET: pdvmkpkg, pdv"
print "GOAL:   build pkg with 1 file, no filters, execute the package"
print "EXPECT: pdv, pdvmkpkg exit status 0, valid package extract"
print "        the extracted file should match the original file"

cat > sourcedata.tmp <<-EOF
This is a simple text file used in basic tests of pdvmkpkg.
This file should end up as is after extraction.
EOF

print "run mkpkg: ../pdvmkpkg -o pkgdata.tmp -c pkg.tmp sourcedata.tmp"
../pdvmkpkg -o pkgdata.tmp -c pkg.tmp sourcedata.tmp
print "exit status = $?"

print "run pkg:"
./pkg.tmp
print "exit status = $?"

print "package data follows:"
cat pkgdata.tmp
set -- `ls -l pkgdata.tmp`
print "end package data"
print "extracted package file size: $5"

rm -f pkgdata.tmp pkg.tmp

print "END TEST"

#-------------------- TEST: simple file package with default output name
# relies on sourcedata.tmp created in previous test

print "BEGIN TEST:"
print "TARGET: pdvmkpkg, pdv"
print "GOAL:   test default payload output name"
print "EXPECT: pdv, pdvmkpkg exit status 0, valid package extract"
print "        the extracted file should match the original file"
print "        default payload name should be used for output name"

print "run pdvmkpkg"
../pdvmkpkg -c pkg.tmp sourcedata.tmp
print "exit status = $?"
rm -f sourcedata.tmp
print "run pkg"
./pkg.tmp
print "exit status = $?"

print "package data follows:"
cat sourcedata.tmp
set -- `ls -l sourcedata.tmp`
print "end package data"
print "extracted package file size: $5"

rm -f pkg.tmp

print "END TEST"

#-------------------- TEST: simple file package with help message
# relies on sourcedata.tmp created in previous test

print "BEGIN TEST:"
print "TARGET: pdvmkpkg, pdv"
print "GOAL:   test help message handling"
print "EXPECT: pdv, pdvmkpkg exit status 0, valid package extract"
print "        the extracted file should match the original file"
print "        user help message should be properly displayed"

cat > helpmsg.tmp <<-EOF
This is a user supplied help message.

There are multiple lines in this message.


end of help message
EOF

print "run pdvmkpkg: ../pdvmkpkg -H helpmsg.tmp -c pkg.tmp sourcedata.tmp"
../pdvmkpkg -H helpmsg.tmp -c pkg.tmp sourcedata.tmp
print "exit status = $?"
print "run pkg: ./pkg.tmp -h"
./pkg.tmp -h
print "exit status (expect 1) = $?"
print "run pkg: ./pkg.tmp"
./pkg.tmp
print "exit status = $?"

print "package data follows:"
cat sourcedata.tmp
set -- `ls -l sourcedata.tmp`
print "end package data"
print "extracted package file size: $5"

rm -f pkg.tmp pkgdata.tmp helpmsg.tmp

print "END TEST"

#-------------------- TEST: simple file package with agreement message

print "BEGIN TEST:"
print "TARGET: pdvmkpkg, pdv"
print "GOAL:   test agreement message handling"
print "EXPECT: pdv, pdvmkpkg exit status 0, valid package extract"
print "        the extracted file should match the original file"
print "        user agreement message should be properly displayed"

cat > agrmsg.tmp <<-EOF
This is an agreement message.

There are multiple lines in this message.


end of agreement message
EOF

# create the package

print "run pdvmkpkg: ../pdvmkpkg -a agrmsg.tmp -c pkg.tmp sourcedata.tmp"
../pdvmkpkg -a agrmsg.tmp -c pkg.tmp sourcedata.tmp
print "exit status = $?"

# execute the package - answer yes to the prompt

print "run pkg: ./pkg.tmp, answer 'yes' to prompt"
./pkg.tmp << EOF
yes
EOF
print "exit status = $?"
print "package data follows:"
cat sourcedata.tmp
set -- `ls -l sourcedata.tmp`
print "end package data"
print "extracted package file size: $5"
rm -f sourcedata.tmp

# execute the package - answer no to the prompt
# there should be no package data - we should get some errors here

print "run pkg: ./pkg.tmp, answer 'no' to prompt"
./pkg.tmp << EOF
no
EOF
print "exit status = $?"
print "package data follows:"
if [ -f sourcedata.tmp ]
then
	print "error: sourcedata.tmp should not have been extracted"
else
	print "sourcedata.tmp not found - this is good"
fi

rm -f agrmsg.tmp sourcedata.tmp pkg.tmp pkgdata.tmp helpmsg.tmp

print "END TEST"

return 0
# basic.sh
