//---------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
// This file is automatically generated.  Please do not edit it directly.
//
// File name: D2D1_1.h
//---------------------------------------------------------------------------
#ifdef _MSC_VER
#pragma once
#endif // #ifdef _MSC_VER

#ifndef _D2D1_1_H_
#define _D2D1_1_H_

#ifndef _D2D1_H_
#include <d2d1.h>
#endif // #ifndef _D2D1_H_
#ifndef _D2D1_EFFECTS_
#include <d2d1effects.h>
#endif // #ifndef _D2D1_EFFECTS_

#if !WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)
#include <dxgi.h>
#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */

#include <winapifamily.h>

#pragma region Application Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)

typedef interface ID2D1ColorContext ID2D1ColorContext;
typedef interface IWICColorContext IWICColorContext;
typedef interface IWICImagingFactory IWICImagingFactory;
typedef interface IPrintDocumentPackageTarget IPrintDocumentPackageTarget;
typedef interface IDWriteFactory IDWriteFactory;
typedef struct DWRITE_GLYPH_RUN_DESCRIPTION DWRITE_GLYPH_RUN_DESCRIPTION;
typedef struct D2D1_PROPERTY_BINDING D2D1_PROPERTY_BINDING;

//+-----------------------------------------------------------------------------
//
//  Function Pointer:
//      PD2D1_EFFECT_FACTORY
//
//  Synopsis:
//      Function pointer to construct a new effect once registered.
//
//------------------------------------------------------------------------------
typedef HRESULT (CALLBACK *PD2D1_EFFECT_FACTORY)(
    _Outptr_ IUnknown **effectImpl
    );

#ifndef D2D_USE_C_DEFINITIONS

interface ID2D1Device;
interface ID2D1Effect;
#else

typedef interface ID2D1Device ID2D1Device;
typedef interface ID2D1Effect ID2D1Effect;

#endif
#define D2D1_INVALID_PROPERTY_INDEX UINT_MAX
typedef D2D_RECT_L D2D1_RECT_L;
typedef D2D_POINT_2L D2D1_POINT_2L;

//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_PROPERTY_TYPE
//
//  Synopsis:
//      This defines the valid property types that can be used in an effect property
//      interface.
//
//------------------------------------------------------------------------------
typedef enum D2D1_PROPERTY_TYPE
{
        D2D1_PROPERTY_TYPE_UNKNOWN = 0,
        D2D1_PROPERTY_TYPE_STRING = 1,
        D2D1_PROPERTY_TYPE_BOOL = 2,
        D2D1_PROPERTY_TYPE_UINT32 = 3,
        D2D1_PROPERTY_TYPE_INT32 = 4,
        D2D1_PROPERTY_TYPE_FLOAT = 5,
        D2D1_PROPERTY_TYPE_VECTOR2 = 6,
        D2D1_PROPERTY_TYPE_VECTOR3 = 7,
        D2D1_PROPERTY_TYPE_VECTOR4 = 8,
        D2D1_PROPERTY_TYPE_BLOB = 9,
        D2D1_PROPERTY_TYPE_IUNKNOWN = 10,
        D2D1_PROPERTY_TYPE_ENUM = 11,
        D2D1_PROPERTY_TYPE_ARRAY = 12,
        D2D1_PROPERTY_TYPE_CLSID = 13,
        D2D1_PROPERTY_TYPE_MATRIX_3X2 = 14,
        D2D1_PROPERTY_TYPE_MATRIX_4X3 = 15,
        D2D1_PROPERTY_TYPE_MATRIX_4X4 = 16,
        D2D1_PROPERTY_TYPE_MATRIX_5X4 = 17,
        D2D1_PROPERTY_TYPE_COLOR_CONTEXT = 18,
        D2D1_PROPERTY_TYPE_FORCE_DWORD = 0xffffffff

} D2D1_PROPERTY_TYPE;


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_PROPERTY
//
//  Synopsis:
//      This defines the list of system properties present on the root effect property
//      interface.
//
//------------------------------------------------------------------------------
typedef enum D2D1_PROPERTY
{
        D2D1_PROPERTY_CLSID = 0x80000000,
        D2D1_PROPERTY_DISPLAYNAME = 0x80000001,
        D2D1_PROPERTY_AUTHOR = 0x80000002,
        D2D1_PROPERTY_CATEGORY = 0x80000003,
        D2D1_PROPERTY_DESCRIPTION = 0x80000004,
        D2D1_PROPERTY_INPUTS = 0x80000005,
        D2D1_PROPERTY_CACHED = 0x80000006,
        D2D1_PROPERTY_PRECISION = 0x80000007,
        D2D1_PROPERTY_MIN_INPUTS = 0x80000008,
        D2D1_PROPERTY_MAX_INPUTS = 0x80000009,
        D2D1_PROPERTY_FORCE_DWORD = 0xffffffff

} D2D1_PROPERTY;


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_SUBPROPERTY
//
//  Synopsis:
//      This defines the indices of sub-properties that may be present on any parent
//      property.
//
//------------------------------------------------------------------------------
typedef enum D2D1_SUBPROPERTY
{
        D2D1_SUBPROPERTY_DISPLAYNAME = 0x80000000,
        D2D1_SUBPROPERTY_ISREADONLY = 0x80000001,
        D2D1_SUBPROPERTY_MIN = 0x80000002,
        D2D1_SUBPROPERTY_MAX = 0x80000003,
        D2D1_SUBPROPERTY_DEFAULT = 0x80000004,
        D2D1_SUBPROPERTY_FIELDS = 0x80000005,
        D2D1_SUBPROPERTY_INDEX = 0x80000006,
        D2D1_SUBPROPERTY_FORCE_DWORD = 0xffffffff

} D2D1_SUBPROPERTY;


//+-----------------------------------------------------------------------------
//
//  Flag:
//      D2D1_BITMAP_OPTIONS
//
//  Synopsis:
//      Specifies how the bitmap can be used.
//
//------------------------------------------------------------------------------
typedef enum D2D1_BITMAP_OPTIONS
{
        
        //
        // The bitmap is created with default properties.
        //
        D2D1_BITMAP_OPTIONS_NONE = 0x00000000,
        
        //
        // The bitmap can be specified as a target in ID2D1DeviceContext::SetTarget
        //
        D2D1_BITMAP_OPTIONS_TARGET = 0x00000001,
        
        //
        // The bitmap cannot be used as an input to DrawBitmap, DrawImage, in a bitmap
        // brush or as an input to an effect.
        //
        D2D1_BITMAP_OPTIONS_CANNOT_DRAW = 0x00000002,
        
        //
        // The bitmap can be read from the CPU.
        //
        D2D1_BITMAP_OPTIONS_CPU_READ = 0x00000004,
        
        //
        // The bitmap works with the ID2D1GdiInteropRenderTarget::GetDC API.
        //
        D2D1_BITMAP_OPTIONS_GDI_COMPATIBLE = 0x00000008,
        D2D1_BITMAP_OPTIONS_FORCE_DWORD = 0xffffffff

} D2D1_BITMAP_OPTIONS;

DEFINE_ENUM_FLAG_OPERATORS(D2D1_BITMAP_OPTIONS);


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_COMPOSITE_MODE
//
//  Synopsis:
//      Specifies the composite mode that will be applied.
//
//------------------------------------------------------------------------------
typedef enum D2D1_COMPOSITE_MODE
{
        D2D1_COMPOSITE_MODE_SOURCE_OVER = 0,
        D2D1_COMPOSITE_MODE_DESTINATION_OVER = 1,
        D2D1_COMPOSITE_MODE_SOURCE_IN = 2,
        D2D1_COMPOSITE_MODE_DESTINATION_IN = 3,
        D2D1_COMPOSITE_MODE_SOURCE_OUT = 4,
        D2D1_COMPOSITE_MODE_DESTINATION_OUT = 5,
        D2D1_COMPOSITE_MODE_SOURCE_ATOP = 6,
        D2D1_COMPOSITE_MODE_DESTINATION_ATOP = 7,
        D2D1_COMPOSITE_MODE_XOR = 8,
        D2D1_COMPOSITE_MODE_PLUS = 9,
        D2D1_COMPOSITE_MODE_SOURCE_COPY = 10,
        D2D1_COMPOSITE_MODE_BOUNDED_SOURCE_COPY = 11,
        D2D1_COMPOSITE_MODE_MASK_INVERT = 12,
        D2D1_COMPOSITE_MODE_FORCE_DWORD = 0xffffffff

} D2D1_COMPOSITE_MODE;


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_BUFFER_PRECISION
//
//  Synopsis:
//      This specifies the precision that should be used in buffers allocated by D2D.
//
//------------------------------------------------------------------------------
typedef enum D2D1_BUFFER_PRECISION
{
        D2D1_BUFFER_PRECISION_UNKNOWN = 0,
        D2D1_BUFFER_PRECISION_8BPC_UNORM = 1,
        D2D1_BUFFER_PRECISION_8BPC_UNORM_SRGB = 2,
        D2D1_BUFFER_PRECISION_16BPC_UNORM = 3,
        D2D1_BUFFER_PRECISION_16BPC_FLOAT = 4,
        D2D1_BUFFER_PRECISION_32BPC_FLOAT = 5,
        D2D1_BUFFER_PRECISION_FORCE_DWORD = 0xffffffff

} D2D1_BUFFER_PRECISION;


//+-----------------------------------------------------------------------------
//
//  Flag:
//      D2D1_MAP_OPTIONS
//
//  Synopsis:
//      This describes how the individual mapping operation should be performed.
//
//------------------------------------------------------------------------------
typedef enum D2D1_MAP_OPTIONS
{
        
        //
        // The mapped pointer has undefined behavior.
        //
        D2D1_MAP_OPTIONS_NONE = 0,
        
        //
        // The mapped pointer can be read from.
        //
        D2D1_MAP_OPTIONS_READ = 1,
        
        //
        // The mapped pointer can be written to.
        //
        D2D1_MAP_OPTIONS_WRITE = 2,
        
        //
        // The previous contents of the bitmap are discarded when it is mapped.
        //
        D2D1_MAP_OPTIONS_DISCARD = 4,
        D2D1_MAP_OPTIONS_FORCE_DWORD = 0xffffffff

} D2D1_MAP_OPTIONS;

DEFINE_ENUM_FLAG_OPERATORS(D2D1_MAP_OPTIONS);


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_INTERPOLATION_MODE
//
//  Synopsis:
//      This is used to specify the quality of image scaling with
//      ID2D1DeviceContext::DrawImage and with the 2D Affine Transform Effect.
//
//------------------------------------------------------------------------------
typedef enum D2D1_INTERPOLATION_MODE
{
        D2D1_INTERPOLATION_MODE_NEAREST_NEIGHBOR = D2D1_INTERPOLATION_MODE_DEFINITION_NEAREST_NEIGHBOR,
        D2D1_INTERPOLATION_MODE_LINEAR = D2D1_INTERPOLATION_MODE_DEFINITION_LINEAR,
        D2D1_INTERPOLATION_MODE_CUBIC = D2D1_INTERPOLATION_MODE_DEFINITION_CUBIC,
        D2D1_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR = D2D1_INTERPOLATION_MODE_DEFINITION_MULTI_SAMPLE_LINEAR,
        D2D1_INTERPOLATION_MODE_ANISOTROPIC = D2D1_INTERPOLATION_MODE_DEFINITION_ANISOTROPIC,
        D2D1_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC = D2D1_INTERPOLATION_MODE_DEFINITION_HIGH_QUALITY_CUBIC,
        D2D1_INTERPOLATION_MODE_FORCE_DWORD = 0xffffffff

} D2D1_INTERPOLATION_MODE;


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_UNIT_MODE
//
//  Synopsis:
//      This specifies what units should be accepted by the D2D API.
//
//------------------------------------------------------------------------------
typedef enum D2D1_UNIT_MODE
{
        D2D1_UNIT_MODE_DIPS = 0,
        D2D1_UNIT_MODE_PIXELS = 1,
        D2D1_UNIT_MODE_FORCE_DWORD = 0xffffffff

} D2D1_UNIT_MODE;


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_COLOR_SPACE
//
//  Synopsis:
//      Defines a color space.
//
//------------------------------------------------------------------------------
typedef enum D2D1_COLOR_SPACE
{
        
        //
        // The color space is described by accompanying data, such as a color profile.
        //
        D2D1_COLOR_SPACE_CUSTOM = 0,
        
        //
        // The sRGB color space.
        //
        D2D1_COLOR_SPACE_SRGB = 1,
        
        //
        // The scRGB color space.
        //
        D2D1_COLOR_SPACE_SCRGB = 2,
        D2D1_COLOR_SPACE_FORCE_DWORD = 0xffffffff

} D2D1_COLOR_SPACE;


//+-----------------------------------------------------------------------------
//
//  Flag:
//      D2D1_DEVICE_CONTEXT_OPTIONS
//
//  Synopsis:
//      This specifies options that apply to the device context for its lifetime.
//
//------------------------------------------------------------------------------
typedef enum D2D1_DEVICE_CONTEXT_OPTIONS
{
        D2D1_DEVICE_CONTEXT_OPTIONS_NONE = 0,
        
        //
        // Geometry rendering will be performed on many threads in parallel, a single
        // thread is the default.
        //
        D2D1_DEVICE_CONTEXT_OPTIONS_ENABLE_MULTITHREADED_OPTIMIZATIONS = 1,
        D2D1_DEVICE_CONTEXT_OPTIONS_FORCE_DWORD = 0xffffffff

} D2D1_DEVICE_CONTEXT_OPTIONS;

DEFINE_ENUM_FLAG_OPERATORS(D2D1_DEVICE_CONTEXT_OPTIONS);


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_STROKE_TRANSFORM_TYPE
//
//------------------------------------------------------------------------------
typedef enum D2D1_STROKE_TRANSFORM_TYPE
{
        
        //
        // The stroke respects the world transform, the DPI, and the stroke width.
        //
        D2D1_STROKE_TRANSFORM_TYPE_NORMAL = 0,
        
        //
        // The stroke does not respect the world transform, but it does respect the DPI and
        // the stroke width.
        //
        D2D1_STROKE_TRANSFORM_TYPE_FIXED = 1,
        
        //
        // The stroke is forced to one pixel wide.
        //
        D2D1_STROKE_TRANSFORM_TYPE_HAIRLINE = 2,
        D2D1_STROKE_TRANSFORM_TYPE_FORCE_DWORD = 0xffffffff

} D2D1_STROKE_TRANSFORM_TYPE;


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_PRIMITIVE_BLEND
//
//  Synopsis:
//      A blend mode that applies to all primitives drawn on the context.
//
//------------------------------------------------------------------------------
typedef enum D2D1_PRIMITIVE_BLEND
{
        D2D1_PRIMITIVE_BLEND_SOURCE_OVER = 0,
        D2D1_PRIMITIVE_BLEND_COPY = 1,
        D2D1_PRIMITIVE_BLEND_MIN = 2,
        D2D1_PRIMITIVE_BLEND_ADD = 3,
        D2D1_PRIMITIVE_BLEND_FORCE_DWORD = 0xffffffff

} D2D1_PRIMITIVE_BLEND;


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_THREADING_MODE
//
//  Synopsis:
//      This specifies the threading mode used while simultaneously creating the device,
//      factory, and device context.
//
//------------------------------------------------------------------------------
typedef enum D2D1_THREADING_MODE
{
        
        //
        // Resources may only be invoked serially.  Reference counts on resources are
        // interlocked, however, resource and render target state is not protected from
        // multi-threaded access
        //
        D2D1_THREADING_MODE_SINGLE_THREADED = D2D1_FACTORY_TYPE_SINGLE_THREADED,
        
        //
        // Resources may be invoked from multiple threads. Resources use interlocked
        // reference counting and their state is protected.
        //
        D2D1_THREADING_MODE_MULTI_THREADED = D2D1_FACTORY_TYPE_MULTI_THREADED,
        D2D1_THREADING_MODE_FORCE_DWORD = 0xffffffff

} D2D1_THREADING_MODE;


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_COLOR_INTERPOLATION_MODE
//
//  Synopsis:
//      This specifies how colors are interpolated.
//
//------------------------------------------------------------------------------
typedef enum D2D1_COLOR_INTERPOLATION_MODE
{
        
        //
        // Colors will be interpolated in straight alpha space.
        //
        D2D1_COLOR_INTERPOLATION_MODE_STRAIGHT = 0,
        
        //
        // Colors will be interpolated in premultiplied alpha space.
        //
        D2D1_COLOR_INTERPOLATION_MODE_PREMULTIPLIED = 1,
        D2D1_COLOR_INTERPOLATION_MODE_FORCE_DWORD = 0xffffffff

} D2D1_COLOR_INTERPOLATION_MODE;

typedef D2D_VECTOR_2F D2D1_VECTOR_2F;
typedef D2D_VECTOR_3F D2D1_VECTOR_3F;
typedef D2D_VECTOR_4F D2D1_VECTOR_4F;

//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_BITMAP_PROPERTIES1
//
//  Synopsis:
//      Extended bitmap properties.
//
//------------------------------------------------------------------------------
typedef struct D2D1_BITMAP_PROPERTIES1
{
    D2D1_PIXEL_FORMAT pixelFormat;
    FLOAT dpiX;
    FLOAT dpiY;
    
    //
    // Specifies how the bitmap can be used.
    //
    D2D1_BITMAP_OPTIONS bitmapOptions;
    _Field_size_opt_(1) ID2D1ColorContext *colorContext;

} D2D1_BITMAP_PROPERTIES1;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_MAPPED_RECT
//
//  Synopsis:
//      Describes mapped memory from the ID2D1Bitmap1::Map API.
//
//------------------------------------------------------------------------------
typedef struct D2D1_MAPPED_RECT
{
    UINT32 pitch;
    BYTE *bits;

} D2D1_MAPPED_RECT;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_RENDERING_CONTROLS
//
//  Synopsis:
//      This controls advanced settings of the Direct2D imaging pipeline.
//
//------------------------------------------------------------------------------
typedef struct D2D1_RENDERING_CONTROLS
{
    
    //
    // The default buffer precision, used if the precision isn't otherwise specified.
    //
    D2D1_BUFFER_PRECISION bufferPrecision;
    
    //
    // The size of allocated tiles used to render imaging effects.
    //
    D2D1_SIZE_U tileSize;

} D2D1_RENDERING_CONTROLS;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_EFFECT_INPUT_DESCRIPTION
//
//  Synopsis:
//      This identifies a certain input connection of a certain effect.
//
//------------------------------------------------------------------------------
typedef struct D2D1_EFFECT_INPUT_DESCRIPTION
{
    
    //
    // The effect whose input connection is being specified.
    //
    ID2D1Effect *effect;
    
    //
    // The index of the input connection into the specified effect.
    //
    UINT32 inputIndex;
    
    //
    // The rectangle which would be available on the specified input connection during
    // render operations.
    //
    D2D1_RECT_F inputRectangle;

} D2D1_EFFECT_INPUT_DESCRIPTION;

typedef D2D_MATRIX_4X3_F D2D1_MATRIX_4X3_F;
typedef D2D_MATRIX_4X4_F D2D1_MATRIX_4X4_F;
typedef D2D_MATRIX_5X4_F D2D1_MATRIX_5X4_F;

//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_POINT_DESCRIPTION
//
//  Synopsis:
//      Describes a point along a path.
//
//------------------------------------------------------------------------------
typedef struct D2D1_POINT_DESCRIPTION
{
    D2D1_POINT_2F point;
    D2D1_POINT_2F unitTangentVector;
    UINT32 endSegment;
    UINT32 endFigure;
    FLOAT lengthToEndSegment;

} D2D1_POINT_DESCRIPTION;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_IMAGE_BRUSH_PROPERTIES
//
//  Synopsis:
//      Creation properties for an image brush.
//
//------------------------------------------------------------------------------
typedef struct D2D1_IMAGE_BRUSH_PROPERTIES
{
    D2D1_RECT_F sourceRectangle;
    D2D1_EXTEND_MODE extendModeX;
    D2D1_EXTEND_MODE extendModeY;
    D2D1_INTERPOLATION_MODE interpolationMode;

} D2D1_IMAGE_BRUSH_PROPERTIES;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_BITMAP_BRUSH_PROPERTIES1
//
//------------------------------------------------------------------------------
typedef struct D2D1_BITMAP_BRUSH_PROPERTIES1
{
    D2D1_EXTEND_MODE extendModeX;
    D2D1_EXTEND_MODE extendModeY;
    D2D1_INTERPOLATION_MODE interpolationMode;

} D2D1_BITMAP_BRUSH_PROPERTIES1;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_STROKE_STYLE_PROPERTIES1
//
//  Synopsis:
//      This defines how geometries should be drawn and widened.
//
//------------------------------------------------------------------------------
typedef struct D2D1_STROKE_STYLE_PROPERTIES1
{
    D2D1_CAP_STYLE startCap;
    D2D1_CAP_STYLE endCap;
    D2D1_CAP_STYLE dashCap;
    D2D1_LINE_JOIN lineJoin;
    FLOAT miterLimit;
    D2D1_DASH_STYLE dashStyle;
    FLOAT dashOffset;
    
    //
    // How the nib of the stroke is influenced by the context properties.
    //
    D2D1_STROKE_TRANSFORM_TYPE transformType;

} D2D1_STROKE_STYLE_PROPERTIES1;


//+-----------------------------------------------------------------------------
//
//  Flag:
//      D2D1_LAYER_OPTIONS1
//
//  Synopsis:
//      Specifies how the layer contents should be prepared.
//
//------------------------------------------------------------------------------
typedef enum D2D1_LAYER_OPTIONS1
{
        D2D1_LAYER_OPTIONS1_NONE = 0,
        D2D1_LAYER_OPTIONS1_INITIALIZE_FROM_BACKGROUND = 1,
        D2D1_LAYER_OPTIONS1_IGNORE_ALPHA = 2,
        D2D1_LAYER_OPTIONS1_FORCE_DWORD = 0xffffffff

} D2D1_LAYER_OPTIONS1;

DEFINE_ENUM_FLAG_OPERATORS(D2D1_LAYER_OPTIONS1);


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_LAYER_PARAMETERS1
//
//  Synopsis:
//      All parameters related to pushing a layer.
//
//------------------------------------------------------------------------------
typedef struct D2D1_LAYER_PARAMETERS1
{
    D2D1_RECT_F contentBounds;
    _Field_size_opt_(1) ID2D1Geometry *geometricMask;
    D2D1_ANTIALIAS_MODE maskAntialiasMode;
    D2D1_MATRIX_3X2_F maskTransform;
    FLOAT opacity;
    _Field_size_opt_(1) ID2D1Brush *opacityBrush;
    D2D1_LAYER_OPTIONS1 layerOptions;

} D2D1_LAYER_PARAMETERS1;


//+-----------------------------------------------------------------------------
//
//  Enum:
//      D2D1_PRINT_FONT_SUBSET_MODE
//
//------------------------------------------------------------------------------
typedef enum D2D1_PRINT_FONT_SUBSET_MODE
{
        
        //
        // Subset for used glyphs, send and discard font resource after every five pages
        //
        D2D1_PRINT_FONT_SUBSET_MODE_DEFAULT = 0,
        
        //
        // Subset for used glyphs, send and discard font resource after each page
        //
        D2D1_PRINT_FONT_SUBSET_MODE_EACHPAGE = 1,
        
        //
        // Do not subset, reuse font for all pages, send it after first page
        //
        D2D1_PRINT_FONT_SUBSET_MODE_NONE = 2,
        D2D1_PRINT_FONT_SUBSET_MODE_FORCE_DWORD = 0xffffffff

} D2D1_PRINT_FONT_SUBSET_MODE;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_DRAWING_STATE_DESCRIPTION1
//
//  Synopsis:
//      This describes the drawing state.
//
//------------------------------------------------------------------------------
typedef struct D2D1_DRAWING_STATE_DESCRIPTION1
{
    D2D1_ANTIALIAS_MODE antialiasMode;
    D2D1_TEXT_ANTIALIAS_MODE textAntialiasMode;
    D2D1_TAG tag1;
    D2D1_TAG tag2;
    D2D1_MATRIX_3X2_F transform;
    D2D1_PRIMITIVE_BLEND primitiveBlend;
    D2D1_UNIT_MODE unitMode;

} D2D1_DRAWING_STATE_DESCRIPTION1;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_PRINT_CONTROL_PROPERTIES
//
//------------------------------------------------------------------------------
typedef struct D2D1_PRINT_CONTROL_PROPERTIES
{
    D2D1_PRINT_FONT_SUBSET_MODE fontSubset;
    
    //
    // DPI for rasterization of all unsupported D2D commands or options, defaults to
    // 150.0
    //
    FLOAT rasterDPI;
    
    //
    // Color space for vector graphics in XPS package
    //
    D2D1_COLOR_SPACE colorSpace;

} D2D1_PRINT_CONTROL_PROPERTIES;


//+-----------------------------------------------------------------------------
//
//  Struct:
//      D2D1_CREATION_PROPERTIES
//
//  Synopsis:
//      This specifies the options while simultaneously creating the device, factory,
//      and device context.
//
//------------------------------------------------------------------------------
typedef struct D2D1_CREATION_PROPERTIES
{
    
    //
    // Describes locking behavior of D2D resources
    //
    D2D1_THREADING_MODE threadingMode;
    D2D1_DEBUG_LEVEL debugLevel;
    D2D1_DEVICE_CONTEXT_OPTIONS options;

} D2D1_CREATION_PROPERTIES;


#ifndef D2D_USE_C_DEFINITIONS



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1GdiMetafileSink
//
//  Synopsis:
//      User-implementable interface for introspecting on a metafile.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("82237326-8111-4f7c-bcf4-b5c1175564fe") ID2D1GdiMetafileSink  : public IUnknown
{
    
    
    //
    // Callback for examining a metafile record.
    //
    STDMETHOD(ProcessRecord)(
        DWORD recordType,
        _In_opt_ CONST void *recordData,
        DWORD recordDataSize 
        ) PURE;
}; // interface ID2D1GdiMetafileSink



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1GdiMetafile
//
//  Synopsis:
//      Interface encapsulating a GDI/GDI+ metafile.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("2f543dc3-cfc1-4211-864f-cfd91c6f3395") ID2D1GdiMetafile  : public ID2D1Resource
{
    
    
    //
    // Play the metafile into a caller-supplied sink interface.
    //
    STDMETHOD(Stream)(
        _In_ ID2D1GdiMetafileSink *sink 
        ) PURE;
    
    
    //
    // Gets the bounds of the metafile.
    //
    STDMETHOD(GetBounds)(
        _Out_ D2D1_RECT_F *bounds 
        ) PURE;
}; // interface ID2D1GdiMetafile



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1CommandSink
//
//  Synopsis:
//      Caller-supplied implementation of an interface to receive the recorded command
//      list.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("54d7898a-a061-40a7-bec7-e465bcba2c4f") ID2D1CommandSink  : public IUnknown
{
    
    STDMETHOD(BeginDraw)(
        ) PURE;
    
    STDMETHOD(EndDraw)(
        ) PURE;
    
    STDMETHOD(SetAntialiasMode)(
        D2D1_ANTIALIAS_MODE antialiasMode 
        ) PURE;
    
    STDMETHOD(SetTags)(
        D2D1_TAG tag1,
        D2D1_TAG tag2 
        ) PURE;
    
    STDMETHOD(SetTextAntialiasMode)(
        D2D1_TEXT_ANTIALIAS_MODE textAntialiasMode 
        ) PURE;
    
    STDMETHOD(SetTextRenderingParams)(
        _In_opt_ IDWriteRenderingParams *textRenderingParams 
        ) PURE;
    
    STDMETHOD(SetTransform)(
        _In_ CONST D2D1_MATRIX_3X2_F *transform 
        ) PURE;
    
    STDMETHOD(SetPrimitiveBlend)(
        D2D1_PRIMITIVE_BLEND primitiveBlend 
        ) PURE;
    
    STDMETHOD(SetUnitMode)(
        D2D1_UNIT_MODE unitMode 
        ) PURE;
    
    STDMETHOD(Clear)(
        _In_opt_ CONST D2D1_COLOR_F *color 
        ) PURE;
    
    STDMETHOD(DrawGlyphRun)(
        D2D1_POINT_2F baselineOrigin,
        _In_ CONST DWRITE_GLYPH_RUN *glyphRun,
        _In_opt_ CONST DWRITE_GLYPH_RUN_DESCRIPTION *glyphRunDescription,
        _In_ ID2D1Brush *foregroundBrush,
        DWRITE_MEASURING_MODE measuringMode 
        ) PURE;
    
    STDMETHOD(DrawLine)(
        D2D1_POINT_2F point0,
        D2D1_POINT_2F point1,
        _In_ ID2D1Brush *brush,
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle 
        ) PURE;
    
    STDMETHOD(DrawGeometry)(
        _In_ ID2D1Geometry *geometry,
        _In_ ID2D1Brush *brush,
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle 
        ) PURE;
    
    STDMETHOD(DrawRectangle)(
        _In_ CONST D2D1_RECT_F *rect,
        _In_ ID2D1Brush *brush,
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle 
        ) PURE;
    
    STDMETHOD(DrawBitmap)(
        _In_ ID2D1Bitmap *bitmap,
        _In_opt_ CONST D2D1_RECT_F *destinationRectangle,
        FLOAT opacity,
        D2D1_INTERPOLATION_MODE interpolationMode,
        _In_opt_ CONST D2D1_RECT_F *sourceRectangle,
        _In_opt_ CONST D2D1_MATRIX_4X4_F *perspectiveTransform 
        ) PURE;
    
    STDMETHOD(DrawImage)(
        _In_ ID2D1Image *image,
        _In_opt_ CONST D2D1_POINT_2F *targetOffset,
        _In_opt_ CONST D2D1_RECT_F *imageRectangle,
        D2D1_INTERPOLATION_MODE interpolationMode,
        D2D1_COMPOSITE_MODE compositeMode 
        ) PURE;
    
    STDMETHOD(DrawGdiMetafile)(
        _In_ ID2D1GdiMetafile *gdiMetafile,
        _In_opt_ CONST D2D1_POINT_2F *targetOffset 
        ) PURE;
    
    STDMETHOD(FillMesh)(
        _In_ ID2D1Mesh *mesh,
        _In_ ID2D1Brush *brush 
        ) PURE;
    
    STDMETHOD(FillOpacityMask)(
        _In_ ID2D1Bitmap *opacityMask,
        _In_ ID2D1Brush *brush,
        _In_opt_ CONST D2D1_RECT_F *destinationRectangle,
        _In_opt_ CONST D2D1_RECT_F *sourceRectangle 
        ) PURE;
    
    STDMETHOD(FillGeometry)(
        _In_ ID2D1Geometry *geometry,
        _In_ ID2D1Brush *brush,
        _In_opt_ ID2D1Brush *opacityBrush 
        ) PURE;
    
    STDMETHOD(FillRectangle)(
        _In_ CONST D2D1_RECT_F *rect,
        _In_ ID2D1Brush *brush 
        ) PURE;
    
    STDMETHOD(PushAxisAlignedClip)(
        _In_ CONST D2D1_RECT_F *clipRect,
        D2D1_ANTIALIAS_MODE antialiasMode 
        ) PURE;
    
    STDMETHOD(PushLayer)(
        _In_ CONST D2D1_LAYER_PARAMETERS1 *layerParameters1,
        _In_opt_ ID2D1Layer *layer 
        ) PURE;
    
    STDMETHOD(PopAxisAlignedClip)(
        ) PURE;
    
    STDMETHOD(PopLayer)(
        ) PURE;
}; // interface ID2D1CommandSink



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1CommandList
//
//  Synopsis:
//      The commandList interface.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("b4f34a19-2383-4d76-94f6-ec343657c3dc") ID2D1CommandList  : public ID2D1Image
{
    
    
    //
    // Play the command list into a caller-supplied sink interface.
    //
    STDMETHOD(Stream)(
        _In_ ID2D1CommandSink *sink 
        ) PURE;
    
    
    //
    // Marks the command list as ready for use.
    //
    STDMETHOD(Close)(
        ) PURE;
}; // interface ID2D1CommandList



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1PrintControl
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("2c1d867d-c290-41c8-ae7e-34a98702e9a5") ID2D1PrintControl  : public IUnknown
{
    
    STDMETHOD(AddPage)(
        _In_ ID2D1CommandList *commandList,
        D2D_SIZE_F pageSize,
        _In_opt_ IStream *pagePrintTicketStream,
        _Out_opt_ D2D1_TAG *tag1 = NULL,
        _Out_opt_ D2D1_TAG *tag2 = NULL 
        ) PURE;
    
    STDMETHOD(Close)(
        ) PURE;
}; // interface ID2D1PrintControl



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1ImageBrush
//
//  Synopsis:
//      Provides a brush that can take any effect, command list or bitmap and use it to
//      fill a 2D shape.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("fe9e984d-3f95-407c-b5db-cb94d4e8f87c") ID2D1ImageBrush  : public ID2D1Brush
{
    
    STDMETHOD_(void, SetImage)(
        _In_opt_ ID2D1Image *image 
        ) PURE;
    
    STDMETHOD_(void, SetExtendModeX)(
        D2D1_EXTEND_MODE extendModeX 
        ) PURE;
    
    STDMETHOD_(void, SetExtendModeY)(
        D2D1_EXTEND_MODE extendModeY 
        ) PURE;
    
    STDMETHOD_(void, SetInterpolationMode)(
        D2D1_INTERPOLATION_MODE interpolationMode 
        ) PURE;
    
    STDMETHOD_(void, SetSourceRectangle)(
        _In_ CONST D2D1_RECT_F *sourceRectangle 
        ) PURE;
    
    STDMETHOD_(void, GetImage)(
        _Outptr_ ID2D1Image **image 
        ) CONST PURE;
    
    STDMETHOD_(D2D1_EXTEND_MODE, GetExtendModeX)(
        ) CONST PURE;
    
    STDMETHOD_(D2D1_EXTEND_MODE, GetExtendModeY)(
        ) CONST PURE;
    
    STDMETHOD_(D2D1_INTERPOLATION_MODE, GetInterpolationMode)(
        ) CONST PURE;
    
    STDMETHOD_(void, GetSourceRectangle)(
        _Out_ D2D1_RECT_F *sourceRectangle 
        ) CONST PURE;
}; // interface ID2D1ImageBrush



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1BitmapBrush1
//
//  Synopsis:
//      A bitmap brush allows a bitmap to be used to fill a geometry.  Interpolation
//      mode is specified with D2D1_INTERPOLATION_MODE
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("41343a53-e41a-49a2-91cd-21793bbb62e5") ID2D1BitmapBrush1  : public ID2D1BitmapBrush
{
    
    
    //
    // Sets the interpolation mode used when this brush is used.
    //
    STDMETHOD_(void, SetInterpolationMode1)(
        D2D1_INTERPOLATION_MODE interpolationMode 
        ) PURE;
    
    STDMETHOD_(D2D1_INTERPOLATION_MODE, GetInterpolationMode1)(
        ) CONST PURE;
}; // interface ID2D1BitmapBrush1



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1StrokeStyle1
//
//  Synopsis:
//      Extends a stroke style to allow nominal width strokes.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("10a72a66-e91c-43f4-993f-ddf4b82b0b4a") ID2D1StrokeStyle1  : public ID2D1StrokeStyle
{
    
    STDMETHOD_(D2D1_STROKE_TRANSFORM_TYPE, GetStrokeTransformType)(
        ) CONST PURE;
}; // interface ID2D1StrokeStyle1



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1PathGeometry1
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("62baa2d2-ab54-41b7-b872-787e0106a421") ID2D1PathGeometry1  : public ID2D1PathGeometry
{
    
    STDMETHOD(ComputePointAndSegmentAtLength)(
        FLOAT length,
        UINT32 startSegment,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        FLOAT flatteningTolerance,
        _Out_ D2D1_POINT_DESCRIPTION *pointDescription 
        ) CONST PURE;
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    ComputePointAndSegmentAtLength(
        FLOAT length,
        UINT32 startSegment,
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        FLOAT flatteningTolerance,
        _Out_ D2D1_POINT_DESCRIPTION *pointDescription 
        ) CONST  
    {
        return ComputePointAndSegmentAtLength(length, startSegment, &worldTransform, flatteningTolerance, pointDescription);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    ComputePointAndSegmentAtLength(
        FLOAT length,
        UINT32 startSegment,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        _Out_ D2D1_POINT_DESCRIPTION *pointDescription 
        ) CONST  
    {
        return ComputePointAndSegmentAtLength(length, startSegment, worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, pointDescription);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    ComputePointAndSegmentAtLength(
        FLOAT length,
        UINT32 startSegment,
        CONST D2D1_MATRIX_3X2_F &worldTransform,
        _Out_ D2D1_POINT_DESCRIPTION *pointDescription 
        ) CONST  
    {
        return ComputePointAndSegmentAtLength(length, startSegment, &worldTransform, D2D1_DEFAULT_FLATTENING_TOLERANCE, pointDescription);
    }
}; // interface ID2D1PathGeometry1



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1Properties
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("483473d7-cd46-4f9d-9d3a-3112aa80159d") ID2D1Properties  : public IUnknown
{
    
    
    //
    // Returns the total number of custom properties in this interface.
    //
    STDMETHOD_(UINT32, GetPropertyCount)(
        ) CONST PURE;
    
    
    //
    // Retrieves the property name from the given property index.
    //
    STDMETHOD(GetPropertyName)(
        UINT32 index,
        _Out_writes_(nameCount) PWSTR name,
        UINT32 nameCount 
        ) CONST PURE;
    
    
    //
    // Returns the length of the property name from the given index.
    //
    STDMETHOD_(UINT32, GetPropertyNameLength)(
        UINT32 index 
        ) CONST PURE;
    
    
    //
    // Retrieves the type of the given property.
    //
    STDMETHOD_(D2D1_PROPERTY_TYPE, GetType)(
        UINT32 index 
        ) CONST PURE;
    
    
    //
    // Retrieves the property index for the given property name.
    //
    STDMETHOD_(UINT32, GetPropertyIndex)(
        _In_ PCWSTR name 
        ) CONST PURE;
    
    
    //
    // Sets the value of the given property using its name.
    //
    STDMETHOD(SetValueByName)(
        _In_ PCWSTR name,
        D2D1_PROPERTY_TYPE type,
        _In_reads_(dataSize) CONST BYTE *data,
        UINT32 dataSize 
        ) PURE;
    
    
    //
    // Sets the given value using the property index.
    //
    STDMETHOD(SetValue)(
        UINT32 index,
        D2D1_PROPERTY_TYPE type,
        _In_reads_(dataSize) CONST BYTE *data,
        UINT32 dataSize 
        ) PURE;
    
    
    //
    // Retrieves the given property or sub-property by name. '.' is the delimiter for
    // sub-properties.
    //
    STDMETHOD(GetValueByName)(
        _In_ PCWSTR name,
        D2D1_PROPERTY_TYPE type,
        _Out_writes_(dataSize) BYTE *data,
        UINT32 dataSize 
        ) CONST PURE;
    
    
    //
    // Retrieves the given value by index.
    //
    STDMETHOD(GetValue)(
        UINT32 index,
        D2D1_PROPERTY_TYPE type,
        _Out_writes_(dataSize) BYTE *data,
        UINT32 dataSize 
        ) CONST PURE;
    
    
    //
    // Returns the value size for the given property index.
    //
    STDMETHOD_(UINT32, GetValueSize)(
        UINT32 index 
        ) CONST PURE;
    
    
    //
    // Retrieves the sub-properties of the given property by index.
    //
    STDMETHOD(GetSubProperties)(
        UINT32 index,
        _Outptr_result_maybenull_ ID2D1Properties **subProperties 
        ) CONST PURE;
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetValueByName(
        _In_ PCWSTR name,
        _In_reads_(dataSize) CONST BYTE *data,
        UINT32 dataSize 
        )  
    {
        return SetValueByName(name, D2D1_PROPERTY_TYPE_UNKNOWN, data, dataSize);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    SetValue(
        UINT32 index,
        _In_reads_(dataSize) CONST BYTE *data,
        UINT32 dataSize 
        )  
    {
        return SetValue(index, D2D1_PROPERTY_TYPE_UNKNOWN, data, dataSize);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetValueByName(
        _In_ PCWSTR name,
        _Out_writes_(dataSize) BYTE *data,
        UINT32 dataSize 
        ) CONST  
    {
        return GetValueByName(name, D2D1_PROPERTY_TYPE_UNKNOWN, data, dataSize);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    GetValue(
        UINT32 index,
        _Out_writes_(dataSize) BYTE *data,
        UINT32 dataSize 
        ) CONST  
    {
        return GetValue(index, D2D1_PROPERTY_TYPE_UNKNOWN, data, dataSize);
    }
    
    //
    // Templatized helper functions:
    //
    template<typename T>
    HRESULT GetValueByName(
        _In_ PCWSTR propertyName,
        _Out_ T *value
        ) const
    {
        return GetValueByName(propertyName, reinterpret_cast<BYTE *>(value), sizeof(*value));
    }
    
    template<typename T>
    T GetValueByName(
        _In_ PCWSTR propertyName
        ) const
    {
        T value;
        HRESULT ignoreHr = GetValueByName(propertyName, reinterpret_cast<BYTE *>(&value), sizeof(value));
        UNREFERENCED_PARAMETER(ignoreHr);
    
        return value;
    }
    
    
    template<typename T>
    HRESULT SetValueByName(
        _In_ PCWSTR propertyName,
        _In_ const T &value
        )
    {
        return SetValueByName(propertyName, reinterpret_cast<const BYTE *>(&value), sizeof(value));
    }
    
    template<typename U>
    HRESULT GetValue(
        U index,
        _Out_writes_(dataSize) BYTE *data,
        UINT32 dataSize
        ) CONST
    {
        return GetValue(static_cast<UINT32>(index), data, dataSize);
    }
    
    template<typename T, typename U>
    HRESULT GetValue(
        U index,
        _Out_ T *value
        ) const
    {
        return GetValue(static_cast<UINT32>(index), reinterpret_cast<BYTE *>(value), sizeof(*value));
    }
    
    template<typename T, typename U>
    T GetValue(
        U index
        ) const
    {
        T value;
        HRESULT ignoreHr = GetValue(static_cast<UINT32>(index), reinterpret_cast<BYTE *>(&value), sizeof(value));
    
        // Unreferenced variable:
        ignoreHr;
    
        return value;
    }
    
    template<typename U>
    HRESULT SetValue(
        U index,
        _In_reads_(dataSize) CONST BYTE *data,
        UINT32 dataSize
        )
    {
        return SetValue(static_cast<UINT32>(index), data, dataSize);
    }
    
    template<typename T, typename U>
    HRESULT SetValue(
        U index,
        _In_ const T &value
        )
    {
        return SetValue(static_cast<UINT32>(index), reinterpret_cast<const BYTE *>(&value), sizeof(value));
    }
    
    template<typename U>
    HRESULT GetPropertyName(
        U index,
        _Out_writes_(nameCount) PWSTR name,
        UINT32 nameCount
        ) CONST
    {
        return GetPropertyName(static_cast<UINT32>(index), name, nameCount);
    }
    
    template<typename U>
    UINT32 GetPropertyNameLength(
        U index
        ) CONST
    {
        return GetPropertyNameLength(static_cast<UINT32>(index));
    }
    
    template<typename U>
    D2D1_PROPERTY_TYPE GetType(
        U index
        ) CONST
    {
        return GetType(static_cast<UINT32>(index));
    }
    
    
    template<typename U>
    UINT32 GetValueSize(
        U index
        ) CONST
    {
        return GetValueSize(static_cast<UINT32>(index));
    }
    
    template<typename U>
    HRESULT GetSubProperties(
        U index,
        _Outptr_result_maybenull_ ID2D1Properties **subProperties
        ) CONST
    {
        return GetSubProperties(static_cast<UINT32>(index), subProperties);
    }
}; // interface ID2D1Properties



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1Effect
//
//  Synopsis:
//      The effect interface. Properties control how the effect is rendered. The effect
//      is Drawn with the DrawImage call.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("28211a43-7d89-476f-8181-2d6159b220ad") ID2D1Effect  : public ID2D1Properties
{
    
    
    //
    // Sets the input to the given effect. The input can be a concrete bitmap or the
    // output of another effect.
    //
    STDMETHOD_(void, SetInput)(
        UINT32 index,
        _In_opt_ ID2D1Image *input,
        BOOL invalidate = TRUE 
        ) PURE;
    
    
    //
    // If the effect supports a variable number of inputs, this sets the number of
    // input that are currently active on the effect.
    //
    STDMETHOD(SetInputCount)(
        UINT32 inputCount 
        ) PURE;
    
    
    //
    // Returns the input image to the effect. The input could be another effect or a
    // bitmap.
    //
    STDMETHOD_(void, GetInput)(
        UINT32 index,
        _Outptr_result_maybenull_ ID2D1Image **input 
        ) CONST PURE;
    
    
    //
    // This returns the number of input that are bound into this effect.
    //
    STDMETHOD_(UINT32, GetInputCount)(
        ) CONST PURE;
    
    
    //
    // Returns the output image of the given effect. This can be set as the input to
    // another effect or can be drawn with DrawImage.
    //
    STDMETHOD_(void, GetOutput)(
        _Outptr_ ID2D1Image **outputImage 
        ) CONST PURE;
    
    COM_DECLSPEC_NOTHROW
    void
    SetInputEffect(
        UINT32 index,
        _In_opt_ ID2D1Effect *inputEffect,
        BOOL invalidate = TRUE 
        )  
    {
        
        ID2D1Image *output = NULL;
        if (inputEffect != NULL)
        {
            inputEffect->GetOutput(&output);
        }
        SetInput(index, output, invalidate);
        if (output != NULL)
        {
            output->Release();
        }
    }
}; // interface ID2D1Effect



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1Bitmap1
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("a898a84c-3873-4588-b08b-ebbf978df041") ID2D1Bitmap1  : public ID2D1Bitmap
{
    
    
    //
    // Retrieves the color context information associated with the bitmap.
    //
    STDMETHOD_(void, GetColorContext)(
        _Outptr_result_maybenull_ ID2D1ColorContext **colorContext 
        ) CONST PURE;
    
    
    //
    // Retrieves the bitmap options used when creating the API.
    //
    STDMETHOD_(D2D1_BITMAP_OPTIONS, GetOptions)(
        ) CONST PURE;
    
    
    //
    // Retrieves the DXGI surface from the corresponding bitmap, if the bitmap was
    // created from a device derived from a D3D device.
    //
    STDMETHOD(GetSurface)(
        _Outptr_result_maybenull_ IDXGISurface **dxgiSurface 
        ) CONST PURE;
    
    
    //
    // Maps the given bitmap into memory. The bitmap must have been created with the
    // D2D1_BITMAP_OPTIONS_CPU_READ flag.
    //
    STDMETHOD(Map)(
        D2D1_MAP_OPTIONS options,
        _Out_ D2D1_MAPPED_RECT *mappedRect 
        ) PURE;
    
    
    //
    // Unmaps the given bitmap from memory.
    //
    STDMETHOD(Unmap)(
        ) PURE;
}; // interface ID2D1Bitmap1



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1ColorContext
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("1c4820bb-5771-4518-a581-2fe4dd0ec657") ID2D1ColorContext  : public ID2D1Resource
{
    
    
    //
    // Retrieves the color space of the color context.
    //
    STDMETHOD_(D2D1_COLOR_SPACE, GetColorSpace)(
        ) CONST PURE;
    
    
    //
    // Retrieves the size of the color profile, in bytes.
    //
    STDMETHOD_(UINT32, GetProfileSize)(
        ) CONST PURE;
    
    
    //
    // Retrieves the color profile bytes.
    //
    STDMETHOD(GetProfile)(
        _Out_writes_(profileSize) BYTE *profile,
        UINT32 profileSize 
        ) CONST PURE;
}; // interface ID2D1ColorContext



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1GradientStopCollection1
//
//  Synopsis:
//      Represents an collection of gradient stops that can then be the source resource
//      for either a linear or radial gradient brush.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("ae1572f4-5dd0-4777-998b-9279472ae63b") ID2D1GradientStopCollection1  : public ID2D1GradientStopCollection
{
    
    
    //
    // Copies the gradient stops from the collection into the caller's memory. If this
    // object was created using ID2D1DeviceContext::CreateGradientStopCollection, this
    // method returns the same values as were specified in the creation method. If this
    // object was created using ID2D1RenderTarget::CreateGradientStopCollection, the
    // stops returned here will first be transformed into the gamma space specified by
    // the colorInterpolationGamma parameter.
    //
    STDMETHOD_(void, GetGradientStops1)(
        _Out_writes_to_(gradientStopsCount, _Inexpressible_("Retrieved through GetGradientStopCount()") ) D2D1_GRADIENT_STOP *gradientStops,
        UINT32 gradientStopsCount 
        ) CONST PURE;
    
    
    //
    // Returns the color space in which interpolation occurs. If this object was
    // created using ID2D1RenderTarget::CreateGradientStopCollection, this method
    // returns the color space related to the color interpolation gamma.
    //
    STDMETHOD_(D2D1_COLOR_SPACE, GetPreInterpolationSpace)(
        ) CONST PURE;
    
    
    //
    // Returns the color space colors will be converted to after interpolation occurs.
    // If this object was created using
    // ID2D1RenderTarget::CreateGradientStopCollection, this method returns
    // D2D1_COLOR_SPACE_SRGB.
    //
    STDMETHOD_(D2D1_COLOR_SPACE, GetPostInterpolationSpace)(
        ) CONST PURE;
    
    
    //
    // Returns the buffer precision of this gradient. If this object was created using
    // ID2D1RenderTarget::CreateGradientStopCollection, this method returns
    // D2D1_BUFFER_PRECISION_8BPC_UNORM.
    //
    STDMETHOD_(D2D1_BUFFER_PRECISION, GetBufferPrecision)(
        ) CONST PURE;
    
    
    //
    // Returns the interpolation mode used to interpolate colors in the gradient.
    //
    STDMETHOD_(D2D1_COLOR_INTERPOLATION_MODE, GetColorInterpolationMode)(
        ) CONST PURE;
}; // interface ID2D1GradientStopCollection1



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1DrawingStateBlock1
//
//  Synopsis:
//      Represents drawing state.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("689f1f85-c72e-4e33-8f19-85754efd5ace") ID2D1DrawingStateBlock1  : public ID2D1DrawingStateBlock
{
    
    
    //
    // Retrieves the state currently contained within this state block resource.
    //
    STDMETHOD_(void, GetDescription)(
        _Out_ D2D1_DRAWING_STATE_DESCRIPTION1 *stateDescription 
        ) CONST PURE;
    
    using ID2D1DrawingStateBlock::GetDescription;
    
    
    //
    // Sets the state description of this state block resource.
    //
    STDMETHOD_(void, SetDescription)(
        _In_ CONST D2D1_DRAWING_STATE_DESCRIPTION1 *stateDescription 
        ) PURE;
    
    using ID2D1DrawingStateBlock::SetDescription;
}; // interface ID2D1DrawingStateBlock1



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1DeviceContext
//
//  Synopsis:
//      The device context represents a set of state and a command buffer that is used
//      to render to a target bitmap.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("e8f7fe7a-191c-466d-ad95-975678bda998") ID2D1DeviceContext  : public ID2D1RenderTarget
{
    
    
    //
    // Creates a bitmap with extended bitmap properties, potentially from a block of
    // memory.
    //
    STDMETHOD(CreateBitmap)(
        D2D1_SIZE_U size,
        _In_opt_ CONST void *sourceData,
        UINT32 pitch,
        _In_ CONST D2D1_BITMAP_PROPERTIES1 *bitmapProperties,
        _Outptr_ ID2D1Bitmap1 **bitmap 
        ) PURE;
    
    using ID2D1RenderTarget::CreateBitmap;
    
    
    //
    // Create a D2D bitmap by copying a WIC bitmap.
    //
    STDMETHOD(CreateBitmapFromWicBitmap)(
        _In_ IWICBitmapSource *wicBitmapSource,
        _In_opt_ CONST D2D1_BITMAP_PROPERTIES1 *bitmapProperties,
        _Outptr_ ID2D1Bitmap1 **bitmap 
        ) PURE;
    
    using ID2D1RenderTarget::CreateBitmapFromWicBitmap;
    
    
    //
    // Creates a color context from a color space.  If the space is Custom, the context
    // is initialized from the profile/profileSize arguments.  Otherwise the context is
    // initialized with the profile bytes associated with the space and
    // profile/profileSize are ignored.
    //
    STDMETHOD(CreateColorContext)(
        D2D1_COLOR_SPACE space,
        _In_reads_opt_(profileSize) CONST BYTE *profile,
        UINT32 profileSize,
        _Outptr_ ID2D1ColorContext **colorContext 
        ) PURE;
    
    STDMETHOD(CreateColorContextFromFilename)(
        _In_ PCWSTR filename,
        _Outptr_ ID2D1ColorContext **colorContext 
        ) PURE;
    
    STDMETHOD(CreateColorContextFromWicColorContext)(
        _In_ IWICColorContext *wicColorContext,
        _Outptr_ ID2D1ColorContext **colorContext 
        ) PURE;
    
    
    //
    // Creates a bitmap from a DXGI surface with a set of extended properties.
    //
    STDMETHOD(CreateBitmapFromDxgiSurface)(
        _In_ IDXGISurface *surface,
        _In_opt_ CONST D2D1_BITMAP_PROPERTIES1 *bitmapProperties,
        _Outptr_ ID2D1Bitmap1 **bitmap 
        ) PURE;
    
    
    //
    // Create a new effect, the effect must either be built in or previously registered
    // through ID2D1Factory1::RegisterEffectFromStream or
    // ID2D1Factory1::RegisterEffectFromString.
    //
    STDMETHOD(CreateEffect)(
        _In_ REFCLSID effectId,
        _Outptr_ ID2D1Effect **effect 
        ) PURE;
    
    
    //
    // A gradient stop collection represents a set of stops in an ideal unit length.
    // This is the source resource for a linear gradient and radial gradient brush.
    //
    STDMETHOD(CreateGradientStopCollection)(
        _In_reads_(straightAlphaGradientStopsCount) CONST D2D1_GRADIENT_STOP *straightAlphaGradientStops,
        _In_range_(>=,1) UINT32 straightAlphaGradientStopsCount,
        
        //
        // Specifies both the input color space and the space in which the color
        // interpolation occurs.
        //
        D2D1_COLOR_SPACE preInterpolationSpace,
        
        //
        // Specifies the color space colors will be converted to after interpolation
        // occurs.
        //
        D2D1_COLOR_SPACE postInterpolationSpace,
        
        //
        // Specifies the precision in which the gradient buffer will be held.
        //
        D2D1_BUFFER_PRECISION bufferPrecision,
        
        //
        // Specifies how the gradient will be extended outside of the unit length.
        //
        D2D1_EXTEND_MODE extendMode,
        
        //
        // Determines if colors will be interpolated in straight alpha or premultiplied
        // alpha space.
        //
        D2D1_COLOR_INTERPOLATION_MODE colorInterpolationMode,
        _Outptr_ ID2D1GradientStopCollection1 **gradientStopCollection1 
        ) PURE;
    
    using ID2D1RenderTarget::CreateGradientStopCollection;
    
    
    //
    // Creates an image brush, the input image can be any type of image, including a
    // bitmap, effect and a command list.
    //
    STDMETHOD(CreateImageBrush)(
        _In_opt_ ID2D1Image *image,
        _In_ CONST D2D1_IMAGE_BRUSH_PROPERTIES *imageBrushProperties,
        _In_opt_ CONST D2D1_BRUSH_PROPERTIES *brushProperties,
        _Outptr_ ID2D1ImageBrush **imageBrush 
        ) PURE;
    
    STDMETHOD(CreateBitmapBrush)(
        _In_opt_ ID2D1Bitmap *bitmap,
        _In_opt_ CONST D2D1_BITMAP_BRUSH_PROPERTIES1 *bitmapBrushProperties,
        _In_opt_ CONST D2D1_BRUSH_PROPERTIES *brushProperties,
        _Outptr_ ID2D1BitmapBrush1 **bitmapBrush 
        ) PURE;
    
    using ID2D1RenderTarget::CreateBitmapBrush;
    
    
    //
    // Creates a new command list.
    //
    STDMETHOD(CreateCommandList)(
        _Outptr_ ID2D1CommandList **commandList 
        ) PURE;
    
    
    //
    // Indicates whether the format is supported by D2D.
    //
    STDMETHOD_(BOOL, IsDxgiFormatSupported)(
        DXGI_FORMAT format 
        ) CONST PURE;
    
    
    //
    // Indicates whether the buffer precision is supported by D2D.
    //
    STDMETHOD_(BOOL, IsBufferPrecisionSupported)(
        D2D1_BUFFER_PRECISION bufferPrecision 
        ) CONST PURE;
    
    
    //
    // This retrieves the local-space bounds in DIPs of the current image using the
    // device context DPI.
    //
    STDMETHOD(GetImageLocalBounds)(
        _In_ ID2D1Image *image,
        _Out_ D2D1_RECT_F *localBounds 
        ) CONST PURE;
    
    
    //
    // This retrieves the world-space bounds in DIPs of the current image using the
    // device context DPI.
    //
    STDMETHOD(GetImageWorldBounds)(
        _In_ ID2D1Image *image,
        _Out_ D2D1_RECT_F *worldBounds 
        ) CONST PURE;
    
    
    //
    // Retrieves the world-space bounds in DIPs of the glyph run using the device
    // context DPI.
    //
    STDMETHOD(GetGlyphRunWorldBounds)(
        D2D1_POINT_2F baselineOrigin,
        _In_ CONST DWRITE_GLYPH_RUN *glyphRun,
        DWRITE_MEASURING_MODE measuringMode,
        _Out_ D2D1_RECT_F *bounds 
        ) CONST PURE;
    
    
    //
    // Retrieves the device associated with this device context.
    //
    STDMETHOD_(void, GetDevice)(
        _Outptr_ ID2D1Device **device 
        ) CONST PURE;
    
    
    //
    // Sets the target for this device context to point to the given image. The image
    // can be a command list or a bitmap created with the D2D1_BITMAP_OPTIONS_TARGET
    // flag.
    //
    STDMETHOD_(void, SetTarget)(
        _In_opt_ ID2D1Image *image 
        ) PURE;
    
    
    //
    // Gets the target that this device context is currently pointing to.
    //
    STDMETHOD_(void, GetTarget)(
        _Outptr_result_maybenull_ ID2D1Image **image 
        ) CONST PURE;
    
    
    //
    // Sets tuning parameters for internal rendering inside the device context.
    //
    STDMETHOD_(void, SetRenderingControls)(
        _In_ CONST D2D1_RENDERING_CONTROLS *renderingControls 
        ) PURE;
    
    
    //
    // This retrieves the rendering controls currently selected into the device
    // context.
    //
    STDMETHOD_(void, GetRenderingControls)(
        _Out_ D2D1_RENDERING_CONTROLS *renderingControls 
        ) CONST PURE;
    
    
    //
    // Changes the primitive blending mode for all of the rendering operations.
    //
    STDMETHOD_(void, SetPrimitiveBlend)(
        D2D1_PRIMITIVE_BLEND primitiveBlend 
        ) PURE;
    
    
    //
    // Returns the primitive blend currently selected into the device context.
    //
    STDMETHOD_(D2D1_PRIMITIVE_BLEND, GetPrimitiveBlend)(
        ) CONST PURE;
    
    
    //
    // Changes the units used for all of the rendering operations.
    //
    STDMETHOD_(void, SetUnitMode)(
        D2D1_UNIT_MODE unitMode 
        ) PURE;
    
    
    //
    // Returns the unit mode currently set on the device context.
    //
    STDMETHOD_(D2D1_UNIT_MODE, GetUnitMode)(
        ) CONST PURE;
    
    
    //
    // Draws the glyph run with an extended description to describe the glyphs.
    //
    STDMETHOD_(void, DrawGlyphRun)(
        D2D1_POINT_2F baselineOrigin,
        _In_ CONST DWRITE_GLYPH_RUN *glyphRun,
        _In_opt_ CONST DWRITE_GLYPH_RUN_DESCRIPTION *glyphRunDescription,
        _In_ ID2D1Brush *foregroundBrush,
        DWRITE_MEASURING_MODE measuringMode = DWRITE_MEASURING_MODE_NATURAL 
        ) PURE;
    
    using ID2D1RenderTarget::DrawGlyphRun;
    
    
    //
    // Draw an image to the device context. The image represents either a concrete
    // bitmap or the output of an effect graph.
    //
    STDMETHOD_(void, DrawImage)(
        _In_ ID2D1Image *image,
        _In_opt_ CONST D2D1_POINT_2F *targetOffset = NULL,
        _In_opt_ CONST D2D1_RECT_F *imageRectangle = NULL,
        D2D1_INTERPOLATION_MODE interpolationMode = D2D1_INTERPOLATION_MODE_LINEAR,
        D2D1_COMPOSITE_MODE compositeMode = D2D1_COMPOSITE_MODE_SOURCE_OVER 
        ) PURE;
    
    
    //
    // Draw a metafile to the device context.
    //
    STDMETHOD_(void, DrawGdiMetafile)(
        _In_ ID2D1GdiMetafile *gdiMetafile,
        _In_opt_ CONST D2D1_POINT_2F *targetOffset = NULL 
        ) PURE;
    
    STDMETHOD_(void, DrawBitmap)(
        _In_ ID2D1Bitmap *bitmap,
        _In_opt_ CONST D2D1_RECT_F *destinationRectangle,
        FLOAT opacity,
        D2D1_INTERPOLATION_MODE interpolationMode,
        _In_opt_ CONST D2D1_RECT_F *sourceRectangle = NULL,
        _In_opt_ CONST D2D1_MATRIX_4X4_F *perspectiveTransform = NULL 
        ) PURE;
    
    using ID2D1RenderTarget::DrawBitmap;
    
    
    //
    // Push a layer on the device context.
    //
    STDMETHOD_(void, PushLayer)(
        _In_ CONST D2D1_LAYER_PARAMETERS1 *layerParameters,
        _In_opt_ ID2D1Layer *layer 
        ) PURE;
    
    using ID2D1RenderTarget::PushLayer;
    
    
    //
    // This indicates that a portion of an effect's input is invalid. This method can
    // be called many times.
    //
    STDMETHOD(InvalidateEffectInputRectangle)(
        _In_ ID2D1Effect *effect,
        UINT32 input,
        _In_ CONST D2D1_RECT_F *inputRectangle 
        ) PURE;
    
    
    //
    // Gets the number of invalid ouptut rectangles that have accumulated at the
    // effect.
    //
    STDMETHOD(GetEffectInvalidRectangleCount)(
        _In_ ID2D1Effect *effect,
        _Out_ UINT32 *rectangleCount 
        ) PURE;
    
    
    //
    // Gets the invalid rectangles that are at the output of the effect.
    //
    STDMETHOD(GetEffectInvalidRectangles)(
        _In_ ID2D1Effect *effect,
        _Out_writes_(rectanglesCount) D2D1_RECT_F *rectangles,
        UINT32 rectanglesCount 
        ) PURE;
    
    
    //
    // Gets the maximum region of each specified input which would be used during a
    // subsequent rendering operation
    //
    STDMETHOD(GetEffectRequiredInputRectangles)(
        _In_ ID2D1Effect *renderEffect,
        _In_opt_ CONST D2D1_RECT_F *renderImageRectangle,
        _In_reads_(inputCount) CONST D2D1_EFFECT_INPUT_DESCRIPTION *inputDescriptions,
        _Out_writes_(inputCount) D2D1_RECT_F *requiredInputRects,
        UINT32 inputCount 
        ) PURE;
    
    
    //
    // Fill using the alpha channel of the supplied opacity mask bitmap. The brush
    // opacity will be modulated by the mask. The render target antialiasing mode must
    // be set to aliased.
    //
    STDMETHOD_(void, FillOpacityMask)(
        _In_ ID2D1Bitmap *opacityMask,
        _In_ ID2D1Brush *brush,
        _In_opt_ CONST D2D1_RECT_F *destinationRectangle = NULL,
        _In_opt_ CONST D2D1_RECT_F *sourceRectangle = NULL 
        ) PURE;
    
    using ID2D1RenderTarget::FillOpacityMask;
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateBitmap(
        D2D1_SIZE_U size,
        _In_opt_ CONST void *sourceData,
        UINT32 pitch,
        CONST D2D1_BITMAP_PROPERTIES1 &bitmapProperties,
        _Outptr_ ID2D1Bitmap1 **bitmap 
        )  
    {
        return CreateBitmap(size, sourceData, pitch, &bitmapProperties, bitmap);
    }
    
    
    //
    // Create a D2D bitmap by copying a WIC bitmap.
    //
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateBitmapFromWicBitmap(
        _In_ IWICBitmapSource *wicBitmapSource,
        CONST D2D1_BITMAP_PROPERTIES1 &bitmapProperties,
        _Outptr_ ID2D1Bitmap1 **bitmap 
        )  
    {
        return CreateBitmapFromWicBitmap(wicBitmapSource, &bitmapProperties, bitmap);
    }
    
    
    //
    // Create a D2D bitmap by copying a WIC bitmap.
    //
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateBitmapFromWicBitmap(
        _In_ IWICBitmapSource *wicBitmapSource,
        _Outptr_ ID2D1Bitmap1 **bitmap 
        )  
    {
        return CreateBitmapFromWicBitmap(wicBitmapSource, NULL, bitmap);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateBitmapFromDxgiSurface(
        _In_ IDXGISurface *surface,
        CONST D2D1_BITMAP_PROPERTIES1 &bitmapProperties,
        _Outptr_ ID2D1Bitmap1 **bitmap 
        )  
    {
        return CreateBitmapFromDxgiSurface(surface, &bitmapProperties, bitmap);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateImageBrush(
        _In_opt_ ID2D1Image *image,
        CONST D2D1_IMAGE_BRUSH_PROPERTIES &imageBrushProperties,
        CONST D2D1_BRUSH_PROPERTIES &brushProperties,
        _Outptr_ ID2D1ImageBrush **imageBrush 
        )  
    {
        return CreateImageBrush(image, &imageBrushProperties, &brushProperties, imageBrush);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateImageBrush(
        _In_opt_ ID2D1Image *image,
        CONST D2D1_IMAGE_BRUSH_PROPERTIES &imageBrushProperties,
        _Outptr_ ID2D1ImageBrush **imageBrush 
        )  
    {
        return CreateImageBrush(image,&imageBrushProperties, NULL, imageBrush);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateBitmapBrush(
        _In_opt_ ID2D1Bitmap *bitmap,
        _Outptr_ ID2D1BitmapBrush1 **bitmapBrush 
        )  
    {
        return CreateBitmapBrush(bitmap, NULL, NULL, bitmapBrush);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateBitmapBrush(
        _In_opt_ ID2D1Bitmap *bitmap,
        CONST D2D1_BITMAP_BRUSH_PROPERTIES1 &bitmapBrushProperties,
        _Outptr_ ID2D1BitmapBrush1 **bitmapBrush 
        )  
    {
        return CreateBitmapBrush(bitmap, &bitmapBrushProperties, NULL, bitmapBrush);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateBitmapBrush(
        _In_opt_ ID2D1Bitmap *bitmap,
        CONST D2D1_BITMAP_BRUSH_PROPERTIES1 &bitmapBrushProperties,
        CONST D2D1_BRUSH_PROPERTIES &brushProperties,
        _Outptr_ ID2D1BitmapBrush1 **bitmapBrush 
        )  
    {
        return CreateBitmapBrush(bitmap, &bitmapBrushProperties, &brushProperties, bitmapBrush);
    }
    
    
    //
    // Draws the output of the effect as an image.
    //
    COM_DECLSPEC_NOTHROW
    void
    DrawImage(
        _In_ ID2D1Effect *effect,
        _In_opt_ CONST D2D1_POINT_2F *targetOffset = NULL,
        _In_opt_ CONST D2D1_RECT_F *imageRectangle = NULL,
        D2D1_INTERPOLATION_MODE interpolationMode = D2D1_INTERPOLATION_MODE_LINEAR,
        D2D1_COMPOSITE_MODE compositeMode = D2D1_COMPOSITE_MODE_SOURCE_OVER 
        )  
    {
        
        ID2D1Image *output = NULL;
        effect->GetOutput(&output);
        DrawImage(output, targetOffset, imageRectangle, interpolationMode, compositeMode);
        output->Release();
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawImage(
        _In_ ID2D1Image *image,
        D2D1_INTERPOLATION_MODE interpolationMode,
        D2D1_COMPOSITE_MODE compositeMode = D2D1_COMPOSITE_MODE_SOURCE_OVER 
        )  
    {
        DrawImage(image, NULL, NULL, interpolationMode, compositeMode);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawImage(
        _In_ ID2D1Effect *effect,
        D2D1_INTERPOLATION_MODE interpolationMode,
        D2D1_COMPOSITE_MODE compositeMode = D2D1_COMPOSITE_MODE_SOURCE_OVER 
        )  
    {
        DrawImage(effect, NULL, NULL, interpolationMode, compositeMode);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawImage(
        _In_ ID2D1Image *image,
        D2D1_POINT_2F targetOffset,
        D2D1_INTERPOLATION_MODE interpolationMode = D2D1_INTERPOLATION_MODE_LINEAR,
        D2D1_COMPOSITE_MODE compositeMode = D2D1_COMPOSITE_MODE_SOURCE_OVER 
        )  
    {
        DrawImage(image, &targetOffset, NULL, interpolationMode, compositeMode);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawImage(
        _In_ ID2D1Effect *effect,
        D2D1_POINT_2F targetOffset,
        D2D1_INTERPOLATION_MODE interpolationMode = D2D1_INTERPOLATION_MODE_LINEAR,
        D2D1_COMPOSITE_MODE compositeMode = D2D1_COMPOSITE_MODE_SOURCE_OVER 
        )  
    {
        DrawImage(effect, &targetOffset, NULL, interpolationMode, compositeMode);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawImage(
        _In_ ID2D1Image *image,
        D2D1_POINT_2F targetOffset,
        CONST D2D1_RECT_F &imageRectangle,
        D2D1_INTERPOLATION_MODE interpolationMode = D2D1_INTERPOLATION_MODE_LINEAR,
        D2D1_COMPOSITE_MODE compositeMode = D2D1_COMPOSITE_MODE_SOURCE_OVER 
        )  
    {
        DrawImage(image, &targetOffset, &imageRectangle, interpolationMode, compositeMode);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawImage(
        _In_ ID2D1Effect *effect,
        D2D1_POINT_2F targetOffset,
        CONST D2D1_RECT_F &imageRectangle,
        D2D1_INTERPOLATION_MODE interpolationMode = D2D1_INTERPOLATION_MODE_LINEAR,
        D2D1_COMPOSITE_MODE compositeMode = D2D1_COMPOSITE_MODE_SOURCE_OVER 
        )  
    {
        DrawImage(effect, &targetOffset, &imageRectangle, interpolationMode, compositeMode);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    PushLayer(
        CONST D2D1_LAYER_PARAMETERS1 &layerParameters,
        _In_opt_ ID2D1Layer *layer 
        )  
    {
        PushLayer(&layerParameters, layer);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawGdiMetafile(
        _In_ ID2D1GdiMetafile *gdiMetafile,
        D2D1_POINT_2F targetOffset 
        )  
    {
        DrawGdiMetafile(gdiMetafile, &targetOffset);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawBitmap(
        _In_ ID2D1Bitmap *bitmap,
        CONST D2D1_RECT_F &destinationRectangle,
        FLOAT opacity,
        D2D1_INTERPOLATION_MODE interpolationMode,
        _In_opt_ CONST D2D1_RECT_F *sourceRectangle = NULL,
        _In_opt_ CONST D2D1_MATRIX_4X4_F *perspectiveTransform = NULL 
        )  
    {
        DrawBitmap(bitmap, &destinationRectangle, opacity, interpolationMode, sourceRectangle, perspectiveTransform);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawBitmap(
        _In_ ID2D1Bitmap *bitmap,
        CONST D2D1_RECT_F &destinationRectangle,
        FLOAT opacity,
        D2D1_INTERPOLATION_MODE interpolationMode,
        CONST D2D1_RECT_F &sourceRectangle,
        _In_opt_ CONST D2D1_MATRIX_4X4_F *perspectiveTransform = NULL 
        )  
    {
        DrawBitmap(bitmap, &destinationRectangle, opacity, interpolationMode, &sourceRectangle, perspectiveTransform);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    DrawBitmap(
        _In_ ID2D1Bitmap *bitmap,
        CONST D2D1_RECT_F &destinationRectangle,
        FLOAT opacity,
        D2D1_INTERPOLATION_MODE interpolationMode,
        CONST D2D1_RECT_F &sourceRectangle,
        CONST D2D1_MATRIX_4X4_F &perspectiveTransform 
        )  
    {
        DrawBitmap(bitmap, &destinationRectangle, opacity, interpolationMode, &sourceRectangle, &perspectiveTransform);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    FillOpacityMask(
        _In_ ID2D1Bitmap *opacityMask,
        _In_ ID2D1Brush *brush,
        CONST D2D1_RECT_F &destinationRectangle,
        _In_opt_ CONST D2D1_RECT_F *sourceRectangle = NULL 
        )  
    {
        FillOpacityMask(opacityMask, brush, &destinationRectangle, sourceRectangle);
    }
    
    COM_DECLSPEC_NOTHROW
    void
    FillOpacityMask(
        _In_ ID2D1Bitmap *opacityMask,
        _In_ ID2D1Brush *brush,
        CONST D2D1_RECT_F &destinationRectangle,
        CONST D2D1_RECT_F &sourceRectangle 
        )  
    {
        FillOpacityMask(opacityMask, brush, &destinationRectangle, &sourceRectangle);
    }
    
    
    //
    // Sets tuning parameters for internal rendering inside the device context.
    //
    COM_DECLSPEC_NOTHROW
    void
    SetRenderingControls(
        CONST D2D1_RENDERING_CONTROLS &renderingControls 
        )  
    {
        return SetRenderingControls(&renderingControls);
    }
}; // interface ID2D1DeviceContext



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1Device
//
//  Synopsis:
//      The device defines a resource domain whose objects and device contexts can be
//      used together.
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("47dd575d-ac05-4cdd-8049-9b02cd16f44c") ID2D1Device  : public ID2D1Resource
{
    
    
    //
    // Creates a new device context with no initially assigned target.
    //
    STDMETHOD(CreateDeviceContext)(
        D2D1_DEVICE_CONTEXT_OPTIONS options,
        _Outptr_ ID2D1DeviceContext **deviceContext 
        ) PURE;
    
    
    //
    // Creates a D2D print control.
    //
    STDMETHOD(CreatePrintControl)(
        _In_ IWICImagingFactory *wicFactory,
        _In_ IPrintDocumentPackageTarget *documentTarget,
        _In_opt_ CONST D2D1_PRINT_CONTROL_PROPERTIES *printControlProperties,
        _Outptr_ ID2D1PrintControl **printControl 
        ) PURE;
    
    
    //
    // Sets the maximum amount of texture memory to maintain before evicting caches.
    //
    STDMETHOD_(void, SetMaximumTextureMemory)(
        UINT64 maximumInBytes 
        ) PURE;
    
    
    //
    // Gets the maximum amount of texture memory to maintain before evicting caches.
    //
    STDMETHOD_(UINT64, GetMaximumTextureMemory)(
        ) CONST PURE;
    
    
    //
    // Clears all resources that are cached but not held in use by the application
    // through an interface reference.
    //
    STDMETHOD_(void, ClearResources)(
        UINT32 millisecondsSinceUse = 0 
        ) PURE;
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreatePrintControl(
        _In_ IWICImagingFactory *wicFactory,
        _In_ IPrintDocumentPackageTarget *documentTarget,
        CONST D2D1_PRINT_CONTROL_PROPERTIES &printControlProperties,
        _Outptr_ ID2D1PrintControl **printControl 
        )  
    {
        return CreatePrintControl(wicFactory, documentTarget, &printControlProperties, printControl);
    }
}; // interface ID2D1Device



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1Factory1
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("bb12d362-daee-4b9a-aa1d-14ba401cfa1f") ID2D1Factory1  : public ID2D1Factory
{
    
    
    //
    // This creates a new Direct2D device from the given IDXGIDevice.
    //
    STDMETHOD(CreateDevice)(
        _In_ IDXGIDevice *dxgiDevice,
        _Outptr_ ID2D1Device **d2dDevice 
        ) PURE;
    
    
    //
    // This creates a stroke style with the ability to preserve stroke width in various
    // ways.
    //
    STDMETHOD(CreateStrokeStyle)(
        _In_ CONST D2D1_STROKE_STYLE_PROPERTIES1 *strokeStyleProperties,
        _In_reads_opt_(dashesCount) CONST FLOAT *dashes,
        UINT32 dashesCount,
        _Outptr_ ID2D1StrokeStyle1 **strokeStyle 
        ) PURE;
    
    using ID2D1Factory::CreateStrokeStyle;
    
    
    //
    // Creates a path geometry with new operational methods.
    //
    STDMETHOD(CreatePathGeometry)(
        _Outptr_ ID2D1PathGeometry1 **pathGeometry 
        ) PURE;
    
    using ID2D1Factory::CreatePathGeometry;
    
    
    //
    // Creates a new drawing state block, this can be used in subsequent
    // SaveDrawingState and RestoreDrawingState operations on the render target.
    //
    STDMETHOD(CreateDrawingStateBlock)(
        _In_opt_ CONST D2D1_DRAWING_STATE_DESCRIPTION1 *drawingStateDescription,
        _In_opt_ IDWriteRenderingParams *textRenderingParams,
        _Outptr_ ID2D1DrawingStateBlock1 **drawingStateBlock 
        ) PURE;
    
    using ID2D1Factory::CreateDrawingStateBlock;
    
    
    //
    // Creates a new GDI metafile.
    //
    STDMETHOD(CreateGdiMetafile)(
        _In_ IStream *metafileStream,
        _Outptr_ ID2D1GdiMetafile **metafile 
        ) PURE;
    
    
    //
    // This globally registers the given effect. The effect can later be instantiated
    // by using the registered class id. The effect registration is reference counted.
    //
    STDMETHOD(RegisterEffectFromStream)(
        _In_ REFCLSID classId,
        _In_ IStream *propertyXml,
        _In_reads_opt_(bindingsCount) CONST D2D1_PROPERTY_BINDING *bindings,
        UINT32 bindingsCount,
        _In_ CONST PD2D1_EFFECT_FACTORY effectFactory 
        ) PURE;
    
    
    //
    // This globally registers the given effect. The effect can later be instantiated
    // by using the registered class id. The effect registration is reference counted.
    //
    STDMETHOD(RegisterEffectFromString)(
        _In_ REFCLSID classId,
        _In_ PCWSTR propertyXml,
        _In_reads_opt_(bindingsCount) CONST D2D1_PROPERTY_BINDING *bindings,
        UINT32 bindingsCount,
        _In_ CONST PD2D1_EFFECT_FACTORY effectFactory 
        ) PURE;
    
    
    //
    // This unregisters the given effect by its class id, you need to call
    // UnregisterEffect for every call to ID2D1Factory1::RegisterEffectFromStream and
    // ID2D1Factory1::RegisterEffectFromString to completely unregister it.
    //
    STDMETHOD(UnregisterEffect)(
        _In_ REFCLSID classId 
        ) PURE;
    
    
    //
    // This returns all of the registered effects in the process, including any
    // built-in effects.
    //
    STDMETHOD(GetRegisteredEffects)(
        _Out_writes_to_opt_(effectsCount, *effectsReturned) CLSID *effects,
        UINT32 effectsCount,
        
        //
        // The number of effects returned into the passed in effects array.
        //
        _Out_opt_ UINT32 *effectsReturned,
        
        //
        // The number of effects currently registered in the system.
        //
        _Out_opt_ UINT32 *effectsRegistered 
        ) CONST PURE;
    
    
    //
    // This retrieves the effect properties for the given effect, all of the effect
    // properties will be set to a default value since an effect is not instantiated to
    // implement the returned property interface.
    //
    STDMETHOD(GetEffectProperties)(
        _In_ REFCLSID effectId,
        _Outptr_ ID2D1Properties **properties 
        ) CONST PURE;
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateStrokeStyle(
        CONST D2D1_STROKE_STYLE_PROPERTIES1 &strokeStyleProperties,
        _In_reads_opt_(dashesCount) CONST FLOAT *dashes,
        UINT32 dashesCount,
        _Outptr_ ID2D1StrokeStyle1 **strokeStyle 
        )  
    {
        return CreateStrokeStyle(&strokeStyleProperties, dashes, dashesCount, strokeStyle);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateDrawingStateBlock(
        CONST D2D1_DRAWING_STATE_DESCRIPTION1 &drawingStateDescription,
        _Outptr_ ID2D1DrawingStateBlock1 **drawingStateBlock 
        )  
    {
        return CreateDrawingStateBlock(&drawingStateDescription, NULL, drawingStateBlock);
    }
    
    COM_DECLSPEC_NOTHROW
    HRESULT
    CreateDrawingStateBlock(
        _Outptr_ ID2D1DrawingStateBlock1 **drawingStateBlock 
        )  
    {
        return CreateDrawingStateBlock(NULL, NULL, drawingStateBlock);
    }
}; // interface ID2D1Factory1



//+-----------------------------------------------------------------------------
//
//  Interface:
//      ID2D1Multithread
//
//------------------------------------------------------------------------------
interface DX_DECLARE_INTERFACE("31e6e7bc-e0ff-4d46-8c64-a0a8c41c15d3") ID2D1Multithread  : public IUnknown
{
    
    
    //
    // Returns whether the D2D factory was created with
    // D2D1_FACTORY_TYPE_MULTI_THREADED.
    //
    STDMETHOD_(BOOL, GetMultithreadProtected)(
        ) CONST PURE;
    
    
    //
    // Enters the D2D API critical section, if it exists.
    //
    STDMETHOD_(void, Enter)(
        ) PURE;
    
    
    //
    // Leaves the D2D API critical section, if it exists.
    //
    STDMETHOD_(void, Leave)(
        ) PURE;
}; // interface ID2D1Multithread



#endif


EXTERN_C CONST IID IID_ID2D1GdiMetafileSink;
EXTERN_C CONST IID IID_ID2D1GdiMetafile;
EXTERN_C CONST IID IID_ID2D1CommandSink;
EXTERN_C CONST IID IID_ID2D1CommandList;
EXTERN_C CONST IID IID_ID2D1PrintControl;
EXTERN_C CONST IID IID_ID2D1ImageBrush;
EXTERN_C CONST IID IID_ID2D1BitmapBrush1;
EXTERN_C CONST IID IID_ID2D1StrokeStyle1;
EXTERN_C CONST IID IID_ID2D1PathGeometry1;
EXTERN_C CONST IID IID_ID2D1Properties;
EXTERN_C CONST IID IID_ID2D1Effect;
EXTERN_C CONST IID IID_ID2D1Bitmap1;
EXTERN_C CONST IID IID_ID2D1ColorContext;
EXTERN_C CONST IID IID_ID2D1GradientStopCollection1;
EXTERN_C CONST IID IID_ID2D1DrawingStateBlock1;
EXTERN_C CONST IID IID_ID2D1DeviceContext;
EXTERN_C CONST IID IID_ID2D1Device;
EXTERN_C CONST IID IID_ID2D1Factory1;
EXTERN_C CONST IID IID_ID2D1Multithread;


#ifdef D2D_USE_C_DEFINITIONS


typedef interface ID2D1GdiMetafileSink ID2D1GdiMetafileSink;

typedef struct ID2D1GdiMetafileSinkVtbl
{
    
    IUnknownVtbl Base;
    
    
    STDMETHOD(ProcessRecord)(
        ID2D1GdiMetafileSink *This,
        DWORD recordType,
        _In_opt_ CONST void *recordData,
        DWORD recordDataSize 
        ) PURE;
} ID2D1GdiMetafileSinkVtbl;

interface ID2D1GdiMetafileSink
{
    CONST struct ID2D1GdiMetafileSinkVtbl *lpVtbl;
};


#define ID2D1GdiMetafileSink_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1GdiMetafileSink_AddRef(This) \
    ((This)->lpVtbl->Base.AddRef((IUnknown *)This))

#define ID2D1GdiMetafileSink_Release(This) \
    ((This)->lpVtbl->Base.Release((IUnknown *)This))

#define ID2D1GdiMetafileSink_ProcessRecord(This, recordType, recordData, recordDataSize) \
    ((This)->lpVtbl->ProcessRecord(This, recordType, recordData, recordDataSize))

typedef interface ID2D1GdiMetafile ID2D1GdiMetafile;

typedef struct ID2D1GdiMetafileVtbl
{
    
    ID2D1ResourceVtbl Base;
    
    
    STDMETHOD(Stream)(
        ID2D1GdiMetafile *This,
        _In_ ID2D1GdiMetafileSink *sink 
        ) PURE;
    
    STDMETHOD(GetBounds)(
        ID2D1GdiMetafile *This,
        _Out_ D2D1_RECT_F *bounds 
        ) PURE;
} ID2D1GdiMetafileVtbl;

interface ID2D1GdiMetafile
{
    CONST struct ID2D1GdiMetafileVtbl *lpVtbl;
};


#define ID2D1GdiMetafile_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1GdiMetafile_AddRef(This) \
    ((This)->lpVtbl->Base.Base.AddRef((IUnknown *)This))

#define ID2D1GdiMetafile_Release(This) \
    ((This)->lpVtbl->Base.Base.Release((IUnknown *)This))

#define ID2D1GdiMetafile_GetFactory(This, factory) \
    ((This)->lpVtbl->Base.GetFactory((ID2D1Resource *)This, factory))

#define ID2D1GdiMetafile_Stream(This, sink) \
    ((This)->lpVtbl->Stream(This, sink))

#define ID2D1GdiMetafile_GetBounds(This, bounds) \
    ((This)->lpVtbl->GetBounds(This, bounds))

typedef interface ID2D1CommandSink ID2D1CommandSink;

typedef struct ID2D1CommandSinkVtbl
{
    
    IUnknownVtbl Base;
    
    
    STDMETHOD(BeginDraw)(
        ID2D1CommandSink *This 
        ) PURE;
    
    STDMETHOD(EndDraw)(
        ID2D1CommandSink *This 
        ) PURE;
    
    STDMETHOD(SetAntialiasMode)(
        ID2D1CommandSink *This,
        D2D1_ANTIALIAS_MODE antialiasMode 
        ) PURE;
    
    STDMETHOD(SetTags)(
        ID2D1CommandSink *This,
        D2D1_TAG tag1,
        D2D1_TAG tag2 
        ) PURE;
    
    STDMETHOD(SetTextAntialiasMode)(
        ID2D1CommandSink *This,
        D2D1_TEXT_ANTIALIAS_MODE textAntialiasMode 
        ) PURE;
    
    STDMETHOD(SetTextRenderingParams)(
        ID2D1CommandSink *This,
        _In_opt_ IDWriteRenderingParams *textRenderingParams 
        ) PURE;
    
    STDMETHOD(SetTransform)(
        ID2D1CommandSink *This,
        _In_ CONST D2D1_MATRIX_3X2_F *transform 
        ) PURE;
    
    STDMETHOD(SetPrimitiveBlend)(
        ID2D1CommandSink *This,
        D2D1_PRIMITIVE_BLEND primitiveBlend 
        ) PURE;
    
    STDMETHOD(SetUnitMode)(
        ID2D1CommandSink *This,
        D2D1_UNIT_MODE unitMode 
        ) PURE;
    
    STDMETHOD(Clear)(
        ID2D1CommandSink *This,
        _In_opt_ CONST D2D1_COLOR_F *color 
        ) PURE;
    
    STDMETHOD(DrawGlyphRun)(
        ID2D1CommandSink *This,
        D2D1_POINT_2F baselineOrigin,
        _In_ CONST DWRITE_GLYPH_RUN *glyphRun,
        _In_opt_ CONST DWRITE_GLYPH_RUN_DESCRIPTION *glyphRunDescription,
        _In_ ID2D1Brush *foregroundBrush,
        DWRITE_MEASURING_MODE measuringMode 
        ) PURE;
    
    STDMETHOD(DrawLine)(
        ID2D1CommandSink *This,
        D2D1_POINT_2F point0,
        D2D1_POINT_2F point1,
        _In_ ID2D1Brush *brush,
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle 
        ) PURE;
    
    STDMETHOD(DrawGeometry)(
        ID2D1CommandSink *This,
        _In_ ID2D1Geometry *geometry,
        _In_ ID2D1Brush *brush,
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle 
        ) PURE;
    
    STDMETHOD(DrawRectangle)(
        ID2D1CommandSink *This,
        _In_ CONST D2D1_RECT_F *rect,
        _In_ ID2D1Brush *brush,
        FLOAT strokeWidth,
        _In_opt_ ID2D1StrokeStyle *strokeStyle 
        ) PURE;
    
    STDMETHOD(DrawBitmap)(
        ID2D1CommandSink *This,
        _In_ ID2D1Bitmap *bitmap,
        _In_opt_ CONST D2D1_RECT_F *destinationRectangle,
        FLOAT opacity,
        D2D1_INTERPOLATION_MODE interpolationMode,
        _In_opt_ CONST D2D1_RECT_F *sourceRectangle,
        _In_opt_ CONST D2D1_MATRIX_4X4_F *perspectiveTransform 
        ) PURE;
    
    STDMETHOD(DrawImage)(
        ID2D1CommandSink *This,
        _In_ ID2D1Image *image,
        _In_opt_ CONST D2D1_POINT_2F *targetOffset,
        _In_opt_ CONST D2D1_RECT_F *imageRectangle,
        D2D1_INTERPOLATION_MODE interpolationMode,
        D2D1_COMPOSITE_MODE compositeMode 
        ) PURE;
    
    STDMETHOD(DrawGdiMetafile)(
        ID2D1CommandSink *This,
        _In_ ID2D1GdiMetafile *gdiMetafile,
        _In_opt_ CONST D2D1_POINT_2F *targetOffset 
        ) PURE;
    
    STDMETHOD(FillMesh)(
        ID2D1CommandSink *This,
        _In_ ID2D1Mesh *mesh,
        _In_ ID2D1Brush *brush 
        ) PURE;
    
    STDMETHOD(FillOpacityMask)(
        ID2D1CommandSink *This,
        _In_ ID2D1Bitmap *opacityMask,
        _In_ ID2D1Brush *brush,
        _In_opt_ CONST D2D1_RECT_F *destinationRectangle,
        _In_opt_ CONST D2D1_RECT_F *sourceRectangle 
        ) PURE;
    
    STDMETHOD(FillGeometry)(
        ID2D1CommandSink *This,
        _In_ ID2D1Geometry *geometry,
        _In_ ID2D1Brush *brush,
        _In_opt_ ID2D1Brush *opacityBrush 
        ) PURE;
    
    STDMETHOD(FillRectangle)(
        ID2D1CommandSink *This,
        _In_ CONST D2D1_RECT_F *rect,
        _In_ ID2D1Brush *brush 
        ) PURE;
    
    STDMETHOD(PushAxisAlignedClip)(
        ID2D1CommandSink *This,
        _In_ CONST D2D1_RECT_F *clipRect,
        D2D1_ANTIALIAS_MODE antialiasMode 
        ) PURE;
    
    STDMETHOD(PushLayer)(
        ID2D1CommandSink *This,
        _In_ CONST D2D1_LAYER_PARAMETERS1 *layerParameters1,
        _In_opt_ ID2D1Layer *layer 
        ) PURE;
    
    STDMETHOD(PopAxisAlignedClip)(
        ID2D1CommandSink *This 
        ) PURE;
    
    STDMETHOD(PopLayer)(
        ID2D1CommandSink *This 
        ) PURE;
} ID2D1CommandSinkVtbl;

interface ID2D1CommandSink
{
    CONST struct ID2D1CommandSinkVtbl *lpVtbl;
};


#define ID2D1CommandSink_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1CommandSink_AddRef(This) \
    ((This)->lpVtbl->Base.AddRef((IUnknown *)This))

#define ID2D1CommandSink_Release(This) \
    ((This)->lpVtbl->Base.Release((IUnknown *)This))

#define ID2D1CommandSink_BeginDraw(This) \
    ((This)->lpVtbl->BeginDraw(This))

#define ID2D1CommandSink_EndDraw(This) \
    ((This)->lpVtbl->EndDraw(This))

#define ID2D1CommandSink_SetAntialiasMode(This, antialiasMode) \
    ((This)->lpVtbl->SetAntialiasMode(This, antialiasMode))

#define ID2D1CommandSink_SetTags(This, tag1, tag2) \
    ((This)->lpVtbl->SetTags(This, tag1, tag2))

#define ID2D1CommandSink_SetTextAntialiasMode(This, textAntialiasMode) \
    ((This)->lpVtbl->SetTextAntialiasMode(This, textAntialiasMode))

#define ID2D1CommandSink_SetTextRenderingParams(This, textRenderingParams) \
    ((This)->lpVtbl->SetTextRenderingParams(This, textRenderingParams))

#define ID2D1CommandSink_SetTransform(This, transform) \
    ((This)->lpVtbl->SetTransform(This, transform))

#define ID2D1CommandSink_SetPrimitiveBlend(This, primitiveBlend) \
    ((This)->lpVtbl->SetPrimitiveBlend(This, primitiveBlend))

#define ID2D1CommandSink_SetUnitMode(This, unitMode) \
    ((This)->lpVtbl->SetUnitMode(This, unitMode))

#define ID2D1CommandSink_Clear(This, color) \
    ((This)->lpVtbl->Clear(This, color))

#define ID2D1CommandSink_DrawGlyphRun(This, baselineOrigin, glyphRun, glyphRunDescription, foregroundBrush, measuringMode) \
    ((This)->lpVtbl->DrawGlyphRun(This, baselineOrigin, glyphRun, glyphRunDescription, foregroundBrush, measuringMode))

#define ID2D1CommandSink_DrawLine(This, point0, point1, brush, strokeWidth, strokeStyle) \
    ((This)->lpVtbl->DrawLine(This, point0, point1, brush, strokeWidth, strokeStyle))

#define ID2D1CommandSink_DrawGeometry(This, geometry, brush, strokeWidth, strokeStyle) \
    ((This)->lpVtbl->DrawGeometry(This, geometry, brush, strokeWidth, strokeStyle))

#define ID2D1CommandSink_DrawRectangle(This, rect, brush, strokeWidth, strokeStyle) \
    ((This)->lpVtbl->DrawRectangle(This, rect, brush, strokeWidth, strokeStyle))

#define ID2D1CommandSink_DrawBitmap(This, bitmap, destinationRectangle, opacity, interpolationMode, sourceRectangle, perspectiveTransform) \
    ((This)->lpVtbl->DrawBitmap(This, bitmap, destinationRectangle, opacity, interpolationMode, sourceRectangle, perspectiveTransform))

#define ID2D1CommandSink_DrawImage(This, image, targetOffset, imageRectangle, interpolationMode, compositeMode) \
    ((This)->lpVtbl->DrawImage(This, image, targetOffset, imageRectangle, interpolationMode, compositeMode))

#define ID2D1CommandSink_DrawGdiMetafile(This, gdiMetafile, targetOffset) \
    ((This)->lpVtbl->DrawGdiMetafile(This, gdiMetafile, targetOffset))

#define ID2D1CommandSink_FillMesh(This, mesh, brush) \
    ((This)->lpVtbl->FillMesh(This, mesh, brush))

#define ID2D1CommandSink_FillOpacityMask(This, opacityMask, brush, destinationRectangle, sourceRectangle) \
    ((This)->lpVtbl->FillOpacityMask(This, opacityMask, brush, destinationRectangle, sourceRectangle))

#define ID2D1CommandSink_FillGeometry(This, geometry, brush, opacityBrush) \
    ((This)->lpVtbl->FillGeometry(This, geometry, brush, opacityBrush))

#define ID2D1CommandSink_FillRectangle(This, rect, brush) \
    ((This)->lpVtbl->FillRectangle(This, rect, brush))

#define ID2D1CommandSink_PushAxisAlignedClip(This, clipRect, antialiasMode) \
    ((This)->lpVtbl->PushAxisAlignedClip(This, clipRect, antialiasMode))

#define ID2D1CommandSink_PushLayer(This, layerParameters1, layer) \
    ((This)->lpVtbl->PushLayer(This, layerParameters1, layer))

#define ID2D1CommandSink_PopAxisAlignedClip(This) \
    ((This)->lpVtbl->PopAxisAlignedClip(This))

#define ID2D1CommandSink_PopLayer(This) \
    ((This)->lpVtbl->PopLayer(This))

typedef interface ID2D1CommandList ID2D1CommandList;

typedef struct ID2D1CommandListVtbl
{
    
    ID2D1ImageVtbl Base;
    
    
    STDMETHOD(Stream)(
        ID2D1CommandList *This,
        _In_ ID2D1CommandSink *sink 
        ) PURE;
    
    STDMETHOD(Close)(
        ID2D1CommandList *This 
        ) PURE;
} ID2D1CommandListVtbl;

interface ID2D1CommandList
{
    CONST struct ID2D1CommandListVtbl *lpVtbl;
};


#define ID2D1CommandList_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1CommandList_AddRef(This) \
    ((This)->lpVtbl->Base.Base.Base.AddRef((IUnknown *)This))

#define ID2D1CommandList_Release(This) \
    ((This)->lpVtbl->Base.Base.Base.Release((IUnknown *)This))

#define ID2D1CommandList_GetFactory(This, factory) \
    ((This)->lpVtbl->Base.Base.GetFactory((ID2D1Resource *)This, factory))

#define ID2D1CommandList_Stream(This, sink) \
    ((This)->lpVtbl->Stream(This, sink))

#define ID2D1CommandList_Close(This) \
    ((This)->lpVtbl->Close(This))

typedef interface ID2D1PrintControl ID2D1PrintControl;

typedef struct ID2D1PrintControlVtbl
{
    
    IUnknownVtbl Base;
    
    
    STDMETHOD(AddPage)(
        ID2D1PrintControl *This,
        _In_ ID2D1CommandList *commandList,
        D2D_SIZE_F pageSize,
        _In_opt_ IStream *pagePrintTicketStream,
        _Out_opt_ D2D1_TAG *tag1,
        _Out_opt_ D2D1_TAG *tag2 
        ) PURE;
    
    STDMETHOD(Close)(
        ID2D1PrintControl *This 
        ) PURE;
} ID2D1PrintControlVtbl;

interface ID2D1PrintControl
{
    CONST struct ID2D1PrintControlVtbl *lpVtbl;
};


#define ID2D1PrintControl_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1PrintControl_AddRef(This) \
    ((This)->lpVtbl->Base.AddRef((IUnknown *)This))

#define ID2D1PrintControl_Release(This) \
    ((This)->lpVtbl->Base.Release((IUnknown *)This))

#define ID2D1PrintControl_AddPage(This, commandList, pageSize, pagePrintTicketStream, tag1, tag2) \
    ((This)->lpVtbl->AddPage(This, commandList, pageSize, pagePrintTicketStream, tag1, tag2))

#define ID2D1PrintControl_Close(This) \
    ((This)->lpVtbl->Close(This))

typedef interface ID2D1ImageBrush ID2D1ImageBrush;

typedef struct ID2D1ImageBrushVtbl
{
    
    ID2D1BrushVtbl Base;
    
    
    STDMETHOD_(void, SetImage)(
        ID2D1ImageBrush *This,
        _In_opt_ ID2D1Image *image 
        ) PURE;
    
    STDMETHOD_(void, SetExtendModeX)(
        ID2D1ImageBrush *This,
        D2D1_EXTEND_MODE extendModeX 
        ) PURE;
    
    STDMETHOD_(void, SetExtendModeY)(
        ID2D1ImageBrush *This,
        D2D1_EXTEND_MODE extendModeY 
        ) PURE;
    
    STDMETHOD_(void, SetInterpolationMode)(
        ID2D1ImageBrush *This,
        D2D1_INTERPOLATION_MODE interpolationMode 
        ) PURE;
    
    STDMETHOD_(void, SetSourceRectangle)(
        ID2D1ImageBrush *This,
        _In_ CONST D2D1_RECT_F *sourceRectangle 
        ) PURE;
    
    STDMETHOD_(void, GetImage)(
        ID2D1ImageBrush *This,
        _Outptr_ ID2D1Image **image 
        ) PURE;
    
    STDMETHOD_(D2D1_EXTEND_MODE, GetExtendModeX)(
        ID2D1ImageBrush *This 
        ) PURE;
    
    STDMETHOD_(D2D1_EXTEND_MODE, GetExtendModeY)(
        ID2D1ImageBrush *This 
        ) PURE;
    
    STDMETHOD_(D2D1_INTERPOLATION_MODE, GetInterpolationMode)(
        ID2D1ImageBrush *This 
        ) PURE;
    
    STDMETHOD_(void, GetSourceRectangle)(
        ID2D1ImageBrush *This,
        _Out_ D2D1_RECT_F *sourceRectangle 
        ) PURE;
} ID2D1ImageBrushVtbl;

interface ID2D1ImageBrush
{
    CONST struct ID2D1ImageBrushVtbl *lpVtbl;
};


#define ID2D1ImageBrush_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1ImageBrush_AddRef(This) \
    ((This)->lpVtbl->Base.Base.Base.AddRef((IUnknown *)This))

#define ID2D1ImageBrush_Release(This) \
    ((This)->lpVtbl->Base.Base.Base.Release((IUnknown *)This))

#define ID2D1ImageBrush_GetFactory(This, factory) \
    ((This)->lpVtbl->Base.Base.GetFactory((ID2D1Resource *)This, factory))

#define ID2D1ImageBrush_SetOpacity(This, opacity) \
    ((This)->lpVtbl->Base.SetOpacity((ID2D1Brush *)This, opacity))

#define ID2D1ImageBrush_SetTransform(This, transform) \
    ((This)->lpVtbl->Base.SetTransform((ID2D1Brush *)This, transform))

#define ID2D1ImageBrush_GetOpacity(This) \
    ((This)->lpVtbl->Base.GetOpacity((ID2D1Brush *)This))

#define ID2D1ImageBrush_GetTransform(This, transform) \
    ((This)->lpVtbl->Base.GetTransform((ID2D1Brush *)This, transform))

#define ID2D1ImageBrush_SetImage(This, image) \
    ((This)->lpVtbl->SetImage(This, image))

#define ID2D1ImageBrush_SetExtendModeX(This, extendModeX) \
    ((This)->lpVtbl->SetExtendModeX(This, extendModeX))

#define ID2D1ImageBrush_SetExtendModeY(This, extendModeY) \
    ((This)->lpVtbl->SetExtendModeY(This, extendModeY))

#define ID2D1ImageBrush_SetInterpolationMode(This, interpolationMode) \
    ((This)->lpVtbl->SetInterpolationMode(This, interpolationMode))

#define ID2D1ImageBrush_SetSourceRectangle(This, sourceRectangle) \
    ((This)->lpVtbl->SetSourceRectangle(This, sourceRectangle))

#define ID2D1ImageBrush_GetImage(This, image) \
    ((This)->lpVtbl->GetImage(This, image))

#define ID2D1ImageBrush_GetExtendModeX(This) \
    ((This)->lpVtbl->GetExtendModeX(This))

#define ID2D1ImageBrush_GetExtendModeY(This) \
    ((This)->lpVtbl->GetExtendModeY(This))

#define ID2D1ImageBrush_GetInterpolationMode(This) \
    ((This)->lpVtbl->GetInterpolationMode(This))

#define ID2D1ImageBrush_GetSourceRectangle(This, sourceRectangle) \
    ((This)->lpVtbl->GetSourceRectangle(This, sourceRectangle))

typedef interface ID2D1BitmapBrush1 ID2D1BitmapBrush1;

typedef struct ID2D1BitmapBrush1Vtbl
{
    
    ID2D1BitmapBrushVtbl Base;
    
    
    STDMETHOD_(void, SetInterpolationMode1)(
        ID2D1BitmapBrush1 *This,
        D2D1_INTERPOLATION_MODE interpolationMode 
        ) PURE;
    
    STDMETHOD_(D2D1_INTERPOLATION_MODE, GetInterpolationMode1)(
        ID2D1BitmapBrush1 *This 
        ) PURE;
} ID2D1BitmapBrush1Vtbl;

interface ID2D1BitmapBrush1
{
    CONST struct ID2D1BitmapBrush1Vtbl *lpVtbl;
};


#define ID2D1BitmapBrush1_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1BitmapBrush1_AddRef(This) \
    ((This)->lpVtbl->Base.Base.Base.Base.AddRef((IUnknown *)This))

#define ID2D1BitmapBrush1_Release(This) \
    ((This)->lpVtbl->Base.Base.Base.Base.Release((IUnknown *)This))

#define ID2D1BitmapBrush1_GetFactory(This, factory) \
    ((This)->lpVtbl->Base.Base.Base.GetFactory((ID2D1Resource *)This, factory))

#define ID2D1BitmapBrush1_SetOpacity(This, opacity) \
    ((This)->lpVtbl->Base.Base.SetOpacity((ID2D1Brush *)This, opacity))

#define ID2D1BitmapBrush1_SetTransform(This, transform) \
    ((This)->lpVtbl->Base.Base.SetTransform((ID2D1Brush *)This, transform))

#define ID2D1BitmapBrush1_GetOpacity(This) \
    ((This)->lpVtbl->Base.Base.GetOpacity((ID2D1Brush *)This))

#define ID2D1BitmapBrush1_GetTransform(This, transform) \
    ((This)->lpVtbl->Base.Base.GetTransform((ID2D1Brush *)This, transform))

#define ID2D1BitmapBrush1_SetExtendModeX(This, extendModeX) \
    ((This)->lpVtbl->Base.SetExtendModeX((ID2D1BitmapBrush *)This, extendModeX))

#define ID2D1BitmapBrush1_SetExtendModeY(This, extendModeY) \
    ((This)->lpVtbl->Base.SetExtendModeY((ID2D1BitmapBrush *)This, extendModeY))

#define ID2D1BitmapBrush1_SetInterpolationMode(This, interpolationMode) \
    ((This)->lpVtbl->Base.SetInterpolationMode((ID2D1BitmapBrush *)This, interpolationMode))

#define ID2D1BitmapBrush1_SetBitmap(This, bitmap) \
    ((This)->lpVtbl->Base.SetBitmap((ID2D1BitmapBrush *)This, bitmap))

#define ID2D1BitmapBrush1_GetExtendModeX(This) \
    ((This)->lpVtbl->Base.GetExtendModeX((ID2D1BitmapBrush *)This))

#define ID2D1BitmapBrush1_GetExtendModeY(This) \
    ((This)->lpVtbl->Base.GetExtendModeY((ID2D1BitmapBrush *)This))

#define ID2D1BitmapBrush1_GetInterpolationMode(This) \
    ((This)->lpVtbl->Base.GetInterpolationMode((ID2D1BitmapBrush *)This))

#define ID2D1BitmapBrush1_GetBitmap(This, bitmap) \
    ((This)->lpVtbl->Base.GetBitmap((ID2D1BitmapBrush *)This, bitmap))

#define ID2D1BitmapBrush1_SetInterpolationMode1(This, interpolationMode) \
    ((This)->lpVtbl->SetInterpolationMode1(This, interpolationMode))

#define ID2D1BitmapBrush1_GetInterpolationMode1(This) \
    ((This)->lpVtbl->GetInterpolationMode1(This))

typedef interface ID2D1StrokeStyle1 ID2D1StrokeStyle1;

typedef struct ID2D1StrokeStyle1Vtbl
{
    
    ID2D1StrokeStyleVtbl Base;
    
    
    STDMETHOD_(D2D1_STROKE_TRANSFORM_TYPE, GetStrokeTransformType)(
        ID2D1StrokeStyle1 *This 
        ) PURE;
} ID2D1StrokeStyle1Vtbl;

interface ID2D1StrokeStyle1
{
    CONST struct ID2D1StrokeStyle1Vtbl *lpVtbl;
};


#define ID2D1StrokeStyle1_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1StrokeStyle1_AddRef(This) \
    ((This)->lpVtbl->Base.Base.Base.AddRef((IUnknown *)This))

#define ID2D1StrokeStyle1_Release(This) \
    ((This)->lpVtbl->Base.Base.Base.Release((IUnknown *)This))

#define ID2D1StrokeStyle1_GetFactory(This, factory) \
    ((This)->lpVtbl->Base.Base.GetFactory((ID2D1Resource *)This, factory))

#define ID2D1StrokeStyle1_GetStartCap(This) \
    ((This)->lpVtbl->Base.GetStartCap((ID2D1StrokeStyle *)This))

#define ID2D1StrokeStyle1_GetEndCap(This) \
    ((This)->lpVtbl->Base.GetEndCap((ID2D1StrokeStyle *)This))

#define ID2D1StrokeStyle1_GetDashCap(This) \
    ((This)->lpVtbl->Base.GetDashCap((ID2D1StrokeStyle *)This))

#define ID2D1StrokeStyle1_GetMiterLimit(This) \
    ((This)->lpVtbl->Base.GetMiterLimit((ID2D1StrokeStyle *)This))

#define ID2D1StrokeStyle1_GetLineJoin(This) \
    ((This)->lpVtbl->Base.GetLineJoin((ID2D1StrokeStyle *)This))

#define ID2D1StrokeStyle1_GetDashOffset(This) \
    ((This)->lpVtbl->Base.GetDashOffset((ID2D1StrokeStyle *)This))

#define ID2D1StrokeStyle1_GetDashStyle(This) \
    ((This)->lpVtbl->Base.GetDashStyle((ID2D1StrokeStyle *)This))

#define ID2D1StrokeStyle1_GetDashesCount(This) \
    ((This)->lpVtbl->Base.GetDashesCount((ID2D1StrokeStyle *)This))

#define ID2D1StrokeStyle1_GetDashes(This, dashes, dashesCount) \
    ((This)->lpVtbl->Base.GetDashes((ID2D1StrokeStyle *)This, dashes, dashesCount))

#define ID2D1StrokeStyle1_GetStrokeTransformType(This) \
    ((This)->lpVtbl->GetStrokeTransformType(This))

typedef interface ID2D1PathGeometry1 ID2D1PathGeometry1;

typedef struct ID2D1PathGeometry1Vtbl
{
    
    ID2D1PathGeometryVtbl Base;
    
    
    STDMETHOD(ComputePointAndSegmentAtLength)(
        ID2D1PathGeometry1 *This,
        FLOAT length,
        UINT32 startSegment,
        _In_opt_ CONST D2D1_MATRIX_3X2_F *worldTransform,
        FLOAT flatteningTolerance,
        _Out_ D2D1_POINT_DESCRIPTION *pointDescription 
        ) PURE;
} ID2D1PathGeometry1Vtbl;

interface ID2D1PathGeometry1
{
    CONST struct ID2D1PathGeometry1Vtbl *lpVtbl;
};


#define ID2D1PathGeometry1_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1PathGeometry1_AddRef(This) \
    ((This)->lpVtbl->Base.Base.Base.Base.AddRef((IUnknown *)This))

#define ID2D1PathGeometry1_Release(This) \
    ((This)->lpVtbl->Base.Base.Base.Base.Release((IUnknown *)This))

#define ID2D1PathGeometry1_GetFactory(This, factory) \
    ((This)->lpVtbl->Base.Base.Base.GetFactory((ID2D1Resource *)This, factory))

#define ID2D1PathGeometry1_GetBounds(This, worldTransform, bounds) \
    ((This)->lpVtbl->Base.Base.GetBounds((ID2D1Geometry *)This, worldTransform, bounds))

#define ID2D1PathGeometry1_GetWidenedBounds(This, strokeWidth, strokeStyle, worldTransform, flatteningTolerance, bounds) \
    ((This)->lpVtbl->Base.Base.GetWidenedBounds((ID2D1Geometry *)This, strokeWidth, strokeStyle, worldTransform, flatteningTolerance, bounds))

#define ID2D1PathGeometry1_StrokeContainsPoint(This, point, strokeWidth, strokeStyle, worldTransform, flatteningTolerance, contains) \
    ((This)->lpVtbl->Base.Base.StrokeContainsPoint((ID2D1Geometry *)This, point, strokeWidth, strokeStyle, worldTransform, flatteningTolerance, contains))

#define ID2D1PathGeometry1_FillContainsPoint(This, point, worldTransform, flatteningTolerance, contains) \
    ((This)->lpVtbl->Base.Base.FillContainsPoint((ID2D1Geometry *)This, point, worldTransform, flatteningTolerance, contains))

#define ID2D1PathGeometry1_CompareWithGeometry(This, inputGeometry, inputGeometryTransform, flatteningTolerance, relation) \
    ((This)->lpVtbl->Base.Base.CompareWithGeometry((ID2D1Geometry *)This, inputGeometry, inputGeometryTransform, flatteningTolerance, relation))

#define ID2D1PathGeometry1_Simplify(This, simplificationOption, worldTransform, flatteningTolerance, geometrySink) \
    ((This)->lpVtbl->Base.Base.Simplify((ID2D1Geometry *)This, simplificationOption, worldTransform, flatteningTolerance, geometrySink))

#define ID2D1PathGeometry1_Tessellate(This, worldTransform, flatteningTolerance, tessellationSink) \
    ((This)->lpVtbl->Base.Base.Tessellate((ID2D1Geometry *)This, worldTransform, flatteningTolerance, tessellationSink))

#define ID2D1PathGeometry1_CombineWithGeometry(This, inputGeometry, combineMode, inputGeometryTransform, flatteningTolerance, geometrySink) \
    ((This)->lpVtbl->Base.Base.CombineWithGeometry((ID2D1Geometry *)This, inputGeometry, combineMode, inputGeometryTransform, flatteningTolerance, geometrySink))

#define ID2D1PathGeometry1_Outline(This, worldTransform, flatteningTolerance, geometrySink) \
    ((This)->lpVtbl->Base.Base.Outline((ID2D1Geometry *)This, worldTransform, flatteningTolerance, geometrySink))

#define ID2D1PathGeometry1_ComputeArea(This, worldTransform, flatteningTolerance, area) \
    ((This)->lpVtbl->Base.Base.ComputeArea((ID2D1Geometry *)This, worldTransform, flatteningTolerance, area))

#define ID2D1PathGeometry1_ComputeLength(This, worldTransform, flatteningTolerance, length) \
    ((This)->lpVtbl->Base.Base.ComputeLength((ID2D1Geometry *)This, worldTransform, flatteningTolerance, length))

#define ID2D1PathGeometry1_ComputePointAtLength(This, length, worldTransform, flatteningTolerance, point, unitTangentVector) \
    ((This)->lpVtbl->Base.Base.ComputePointAtLength((ID2D1Geometry *)This, length, worldTransform, flatteningTolerance, point, unitTangentVector))

#define ID2D1PathGeometry1_Widen(This, strokeWidth, strokeStyle, worldTransform, flatteningTolerance, geometrySink) \
    ((This)->lpVtbl->Base.Base.Widen((ID2D1Geometry *)This, strokeWidth, strokeStyle, worldTransform, flatteningTolerance, geometrySink))

#define ID2D1PathGeometry1_Open(This, geometrySink) \
    ((This)->lpVtbl->Base.Open((ID2D1PathGeometry *)This, geometrySink))

#define ID2D1PathGeometry1_Stream(This, geometrySink) \
    ((This)->lpVtbl->Base.Stream((ID2D1PathGeometry *)This, geometrySink))

#define ID2D1PathGeometry1_GetSegmentCount(This, count) \
    ((This)->lpVtbl->Base.GetSegmentCount((ID2D1PathGeometry *)This, count))

#define ID2D1PathGeometry1_GetFigureCount(This, count) \
    ((This)->lpVtbl->Base.GetFigureCount((ID2D1PathGeometry *)This, count))

#define ID2D1PathGeometry1_ComputePointAndSegmentAtLength(This, length, startSegment, worldTransform, flatteningTolerance, pointDescription) \
    ((This)->lpVtbl->ComputePointAndSegmentAtLength(This, length, startSegment, worldTransform, flatteningTolerance, pointDescription))

typedef interface ID2D1Properties ID2D1Properties;

typedef struct ID2D1PropertiesVtbl
{
    
    IUnknownVtbl Base;
    
    
    STDMETHOD_(UINT32, GetPropertyCount)(
        ID2D1Properties *This 
        ) PURE;
    
    STDMETHOD(GetPropertyName)(
        ID2D1Properties *This,
        UINT32 index,
        _Out_writes_(nameCount) PWSTR name,
        UINT32 nameCount 
        ) PURE;
    
    STDMETHOD_(UINT32, GetPropertyNameLength)(
        ID2D1Properties *This,
        UINT32 index 
        ) PURE;
    
    STDMETHOD_(D2D1_PROPERTY_TYPE, GetType)(
        ID2D1Properties *This,
        UINT32 index 
        ) PURE;
    
    STDMETHOD_(UINT32, GetPropertyIndex)(
        ID2D1Properties *This,
        _In_ PCWSTR name 
        ) PURE;
    
    STDMETHOD(SetValueByName)(
        ID2D1Properties *This,
        _In_ PCWSTR name,
        D2D1_PROPERTY_TYPE type,
        _In_reads_(dataSize) CONST BYTE *data,
        UINT32 dataSize 
        ) PURE;
    
    STDMETHOD(SetValue)(
        ID2D1Properties *This,
        UINT32 index,
        D2D1_PROPERTY_TYPE type,
        _In_reads_(dataSize) CONST BYTE *data,
        UINT32 dataSize 
        ) PURE;
    
    STDMETHOD(GetValueByName)(
        ID2D1Properties *This,
        _In_ PCWSTR name,
        D2D1_PROPERTY_TYPE type,
        _Out_writes_(dataSize) BYTE *data,
        UINT32 dataSize 
        ) PURE;
    
    STDMETHOD(GetValue)(
        ID2D1Properties *This,
        UINT32 index,
        D2D1_PROPERTY_TYPE type,
        _Out_writes_(dataSize) BYTE *data,
        UINT32 dataSize 
        ) PURE;
    
    STDMETHOD_(UINT32, GetValueSize)(
        ID2D1Properties *This,
        UINT32 index 
        ) PURE;
    
    STDMETHOD(GetSubProperties)(
        ID2D1Properties *This,
        UINT32 index,
        _Outptr_result_maybenull_ ID2D1Properties **subProperties 
        ) PURE;
} ID2D1PropertiesVtbl;

interface ID2D1Properties
{
    CONST struct ID2D1PropertiesVtbl *lpVtbl;
};


#define ID2D1Properties_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1Properties_AddRef(This) \
    ((This)->lpVtbl->Base.AddRef((IUnknown *)This))

#define ID2D1Properties_Release(This) \
    ((This)->lpVtbl->Base.Release((IUnknown *)This))

#define ID2D1Properties_GetPropertyCount(This) \
    ((This)->lpVtbl->GetPropertyCount(This))

#define ID2D1Properties_GetPropertyName(This, index, name, nameCount) \
    ((This)->lpVtbl->GetPropertyName(This, index, name, nameCount))

#define ID2D1Properties_GetPropertyNameLength(This, index) \
    ((This)->lpVtbl->GetPropertyNameLength(This, index))

#define ID2D1Properties_GetType(This, index) \
    ((This)->lpVtbl->GetType(This, index))

#define ID2D1Properties_GetPropertyIndex(This, name) \
    ((This)->lpVtbl->GetPropertyIndex(This, name))

#define ID2D1Properties_SetValueByName(This, name, type, data, dataSize) \
    ((This)->lpVtbl->SetValueByName(This, name, type, data, dataSize))

#define ID2D1Properties_SetValue(This, index, type, data, dataSize) \
    ((This)->lpVtbl->SetValue(This, index, type, data, dataSize))

#define ID2D1Properties_GetValueByName(This, name, type, data, dataSize) \
    ((This)->lpVtbl->GetValueByName(This, name, type, data, dataSize))

#define ID2D1Properties_GetValue(This, index, type, data, dataSize) \
    ((This)->lpVtbl->GetValue(This, index, type, data, dataSize))

#define ID2D1Properties_GetValueSize(This, index) \
    ((This)->lpVtbl->GetValueSize(This, index))

#define ID2D1Properties_GetSubProperties(This, index, subProperties) \
    ((This)->lpVtbl->GetSubProperties(This, index, subProperties))

typedef interface ID2D1Effect ID2D1Effect;

typedef struct ID2D1EffectVtbl
{
    
    ID2D1PropertiesVtbl Base;
    
    
    STDMETHOD_(void, SetInput)(
        ID2D1Effect *This,
        UINT32 index,
        _In_opt_ ID2D1Image *input,
        BOOL invalidate 
        ) PURE;
    
    STDMETHOD(SetInputCount)(
        ID2D1Effect *This,
        UINT32 inputCount 
        ) PURE;
    
    STDMETHOD_(void, GetInput)(
        ID2D1Effect *This,
        UINT32 index,
        _Outptr_result_maybenull_ ID2D1Image **input 
        ) PURE;
    
    STDMETHOD_(UINT32, GetInputCount)(
        ID2D1Effect *This 
        ) PURE;
    
    STDMETHOD_(void, GetOutput)(
        ID2D1Effect *This,
        _Outptr_ ID2D1Image **outputImage 
        ) PURE;
} ID2D1EffectVtbl;

interface ID2D1Effect
{
    CONST struct ID2D1EffectVtbl *lpVtbl;
};


#define ID2D1Effect_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1Effect_AddRef(This) \
    ((This)->lpVtbl->Base.Base.AddRef((IUnknown *)This))

#define ID2D1Effect_Release(This) \
    ((This)->lpVtbl->Base.Base.Release((IUnknown *)This))

#define ID2D1Effect_GetPropertyCount(This) \
    ((This)->lpVtbl->Base.GetPropertyCount((ID2D1Properties *)This))

#define ID2D1Effect_GetPropertyName(This, index, name, nameCount) \
    ((This)->lpVtbl->Base.GetPropertyName((ID2D1Properties *)This, index, name, nameCount))

#define ID2D1Effect_GetPropertyNameLength(This, index) \
    ((This)->lpVtbl->Base.GetPropertyNameLength((ID2D1Properties *)This, index))

#define ID2D1Effect_GetType(This, index) \
    ((This)->lpVtbl->Base.GetType((ID2D1Properties *)This, index))

#define ID2D1Effect_GetPropertyIndex(This, name) \
    ((This)->lpVtbl->Base.GetPropertyIndex((ID2D1Properties *)This, name))

#define ID2D1Effect_SetValueByName(This, name, type, data, dataSize) \
    ((This)->lpVtbl->Base.SetValueByName((ID2D1Properties *)This, name, type, data, dataSize))

#define ID2D1Effect_SetValue(This, index, type, data, dataSize) \
    ((This)->lpVtbl->Base.SetValue((ID2D1Properties *)This, index, type, data, dataSize))

#define ID2D1Effect_GetValueByName(This, name, type, data, dataSize) \
    ((This)->lpVtbl->Base.GetValueByName((ID2D1Properties *)This, name, type, data, dataSize))

#define ID2D1Effect_GetValue(This, index, type, data, dataSize) \
    ((This)->lpVtbl->Base.GetValue((ID2D1Properties *)This, index, type, data, dataSize))

#define ID2D1Effect_GetValueSize(This, index) \
    ((This)->lpVtbl->Base.GetValueSize((ID2D1Properties *)This, index))

#define ID2D1Effect_GetSubProperties(This, index, subProperties) \
    ((This)->lpVtbl->Base.GetSubProperties((ID2D1Properties *)This, index, subProperties))

#define ID2D1Effect_SetInput(This, index, input, invalidate) \
    ((This)->lpVtbl->SetInput(This, index, input, invalidate))

#define ID2D1Effect_SetInputCount(This, inputCount) \
    ((This)->lpVtbl->SetInputCount(This, inputCount))

#define ID2D1Effect_GetInput(This, index, input) \
    ((This)->lpVtbl->GetInput(This, index, input))

#define ID2D1Effect_GetInputCount(This) \
    ((This)->lpVtbl->GetInputCount(This))

#define ID2D1Effect_GetOutput(This, outputImage) \
    ((This)->lpVtbl->GetOutput(This, outputImage))

typedef interface ID2D1Bitmap1 ID2D1Bitmap1;

typedef struct ID2D1Bitmap1Vtbl
{
    
    ID2D1BitmapVtbl Base;
    
    
    STDMETHOD_(void, GetColorContext)(
        ID2D1Bitmap1 *This,
        _Outptr_result_maybenull_ ID2D1ColorContext **colorContext 
        ) PURE;
    
    STDMETHOD_(D2D1_BITMAP_OPTIONS, GetOptions)(
        ID2D1Bitmap1 *This 
        ) PURE;
    
    STDMETHOD(GetSurface)(
        ID2D1Bitmap1 *This,
        _Outptr_result_maybenull_ IDXGISurface **dxgiSurface 
        ) PURE;
    
    STDMETHOD(Map)(
        ID2D1Bitmap1 *This,
        D2D1_MAP_OPTIONS options,
        _Out_ D2D1_MAPPED_RECT *mappedRect 
        ) PURE;
    
    STDMETHOD(Unmap)(
        ID2D1Bitmap1 *This 
        ) PURE;
} ID2D1Bitmap1Vtbl;

interface ID2D1Bitmap1
{
    CONST struct ID2D1Bitmap1Vtbl *lpVtbl;
};


#define ID2D1Bitmap1_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1Bitmap1_AddRef(This) \
    ((This)->lpVtbl->Base.Base.Base.Base.AddRef((IUnknown *)This))

#define ID2D1Bitmap1_Release(This) \
    ((This)->lpVtbl->Base.Base.Base.Base.Release((IUnknown *)This))

#define ID2D1Bitmap1_GetFactory(This, factory) \
    ((This)->lpVtbl->Base.Base.Base.GetFactory((ID2D1Resource *)This, factory))

#define ID2D1Bitmap1_GetSize(This) \
    ((This)->lpVtbl->Base.GetSize((ID2D1Bitmap *)This))

#define ID2D1Bitmap1_GetPixelSize(This) \
    ((This)->lpVtbl->Base.GetPixelSize((ID2D1Bitmap *)This))

#define ID2D1Bitmap1_GetPixelFormat(This) \
    ((This)->lpVtbl->Base.GetPixelFormat((ID2D1Bitmap *)This))

#define ID2D1Bitmap1_GetDpi(This, dpiX, dpiY) \
    ((This)->lpVtbl->Base.GetDpi((ID2D1Bitmap *)This, dpiX, dpiY))

#define ID2D1Bitmap1_CopyFromBitmap(This, destPoint, bitmap, srcRect) \
    ((This)->lpVtbl->Base.CopyFromBitmap((ID2D1Bitmap *)This, destPoint, bitmap, srcRect))

#define ID2D1Bitmap1_CopyFromRenderTarget(This, destPoint, renderTarget, srcRect) \
    ((This)->lpVtbl->Base.CopyFromRenderTarget((ID2D1Bitmap *)This, destPoint, renderTarget, srcRect))

#define ID2D1Bitmap1_CopyFromMemory(This, dstRect, srcData, pitch) \
    ((This)->lpVtbl->Base.CopyFromMemory((ID2D1Bitmap *)This, dstRect, srcData, pitch))

#define ID2D1Bitmap1_GetColorContext(This, colorContext) \
    ((This)->lpVtbl->GetColorContext(This, colorContext))

#define ID2D1Bitmap1_GetOptions(This) \
    ((This)->lpVtbl->GetOptions(This))

#define ID2D1Bitmap1_GetSurface(This, dxgiSurface) \
    ((This)->lpVtbl->GetSurface(This, dxgiSurface))

#define ID2D1Bitmap1_Map(This, options, mappedRect) \
    ((This)->lpVtbl->Map(This, options, mappedRect))

#define ID2D1Bitmap1_Unmap(This) \
    ((This)->lpVtbl->Unmap(This))

typedef interface ID2D1ColorContext ID2D1ColorContext;

typedef struct ID2D1ColorContextVtbl
{
    
    ID2D1ResourceVtbl Base;
    
    
    STDMETHOD_(D2D1_COLOR_SPACE, GetColorSpace)(
        ID2D1ColorContext *This 
        ) PURE;
    
    STDMETHOD_(UINT32, GetProfileSize)(
        ID2D1ColorContext *This 
        ) PURE;
    
    STDMETHOD(GetProfile)(
        ID2D1ColorContext *This,
        _Out_writes_(profileSize) BYTE *profile,
        UINT32 profileSize 
        ) PURE;
} ID2D1ColorContextVtbl;

interface ID2D1ColorContext
{
    CONST struct ID2D1ColorContextVtbl *lpVtbl;
};


#define ID2D1ColorContext_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1ColorContext_AddRef(This) \
    ((This)->lpVtbl->Base.Base.AddRef((IUnknown *)This))

#define ID2D1ColorContext_Release(This) \
    ((This)->lpVtbl->Base.Base.Release((IUnknown *)This))

#define ID2D1ColorContext_GetFactory(This, factory) \
    ((This)->lpVtbl->Base.GetFactory((ID2D1Resource *)This, factory))

#define ID2D1ColorContext_GetColorSpace(This) \
    ((This)->lpVtbl->GetColorSpace(This))

#define ID2D1ColorContext_GetProfileSize(This) \
    ((This)->lpVtbl->GetProfileSize(This))

#define ID2D1ColorContext_GetProfile(This, profile, profileSize) \
    ((This)->lpVtbl->GetProfile(This, profile, profileSize))

typedef interface ID2D1GradientStopCollection1 ID2D1GradientStopCollection1;

typedef struct ID2D1GradientStopCollection1Vtbl
{
    
    ID2D1GradientStopCollectionVtbl Base;
    
    
    STDMETHOD_(void, GetGradientStops1)(
        ID2D1GradientStopCollection1 *This,
        _Out_writes_to_(gradientStopsCount, _Inexpressible_("Retrieved through GetGradientStopCount()") ) D2D1_GRADIENT_STOP *gradientStops,
        UINT32 gradientStopsCount 
        ) PURE;
    
    STDMETHOD_(D2D1_COLOR_SPACE, GetPreInterpolationSpace)(
        ID2D1GradientStopCollection1 *This 
        ) PURE;
    
    STDMETHOD_(D2D1_COLOR_SPACE, GetPostInterpolationSpace)(
        ID2D1GradientStopCollection1 *This 
        ) PURE;
    
    STDMETHOD_(D2D1_BUFFER_PRECISION, GetBufferPrecision)(
        ID2D1GradientStopCollection1 *This 
        ) PURE;
    
    STDMETHOD_(D2D1_COLOR_INTERPOLATION_MODE, GetColorInterpolationMode)(
        ID2D1GradientStopCollection1 *This 
        ) PURE;
} ID2D1GradientStopCollection1Vtbl;

interface ID2D1GradientStopCollection1
{
    CONST struct ID2D1GradientStopCollection1Vtbl *lpVtbl;
};


#define ID2D1GradientStopCollection1_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1GradientStopCollection1_AddRef(This) \
    ((This)->lpVtbl->Base.Base.Base.AddRef((IUnknown *)This))

#define ID2D1GradientStopCollection1_Release(This) \
    ((This)->lpVtbl->Base.Base.Base.Release((IUnknown *)This))

#define ID2D1GradientStopCollection1_GetFactory(This, factory) \
    ((This)->lpVtbl->Base.Base.GetFactory((ID2D1Resource *)This, factory))

#define ID2D1GradientStopCollection1_GetGradientStopCount(This) \
    ((This)->lpVtbl->Base.GetGradientStopCount((ID2D1GradientStopCollection *)This))

#define ID2D1GradientStopCollection1_GetGradientStops(This, gradientStops, gradientStopsCount) \
    ((This)->lpVtbl->Base.GetGradientStops((ID2D1GradientStopCollection *)This, gradientStops, gradientStopsCount))

#define ID2D1GradientStopCollection1_GetColorInterpolationGamma(This) \
    ((This)->lpVtbl->Base.GetColorInterpolationGamma((ID2D1GradientStopCollection *)This))

#define ID2D1GradientStopCollection1_GetExtendMode(This) \
    ((This)->lpVtbl->Base.GetExtendMode((ID2D1GradientStopCollection *)This))

#define ID2D1GradientStopCollection1_GetGradientStops1(This, gradientStops, gradientStopsCount) \
    ((This)->lpVtbl->GetGradientStops1(This, gradientStops, gradientStopsCount))

#define ID2D1GradientStopCollection1_GetPreInterpolationSpace(This) \
    ((This)->lpVtbl->GetPreInterpolationSpace(This))

#define ID2D1GradientStopCollection1_GetPostInterpolationSpace(This) \
    ((This)->lpVtbl->GetPostInterpolationSpace(This))

#define ID2D1GradientStopCollection1_GetBufferPrecision(This) \
    ((This)->lpVtbl->GetBufferPrecision(This))

#define ID2D1GradientStopCollection1_GetColorInterpolationMode(This) \
    ((This)->lpVtbl->GetColorInterpolationMode(This))

typedef interface ID2D1DrawingStateBlock1 ID2D1DrawingStateBlock1;

typedef struct ID2D1DrawingStateBlock1Vtbl
{
    
    ID2D1DrawingStateBlockVtbl Base;
    
    
    STDMETHOD_(void, GetDescription)(
        ID2D1DrawingStateBlock1 *This,
        _Out_ D2D1_DRAWING_STATE_DESCRIPTION1 *stateDescription 
        ) PURE;
    
    STDMETHOD_(void, SetDescription)(
        ID2D1DrawingStateBlock1 *This,
        _In_ CONST D2D1_DRAWING_STATE_DESCRIPTION1 *stateDescription 
        ) PURE;
} ID2D1DrawingStateBlock1Vtbl;

interface ID2D1DrawingStateBlock1
{
    CONST struct ID2D1DrawingStateBlock1Vtbl *lpVtbl;
};


#define ID2D1DrawingStateBlock1_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1DrawingStateBlock1_AddRef(This) \
    ((This)->lpVtbl->Base.Base.Base.AddRef((IUnknown *)This))

#define ID2D1DrawingStateBlock1_Release(This) \
    ((This)->lpVtbl->Base.Base.Base.Release((IUnknown *)This))

#define ID2D1DrawingStateBlock1_GetFactory(This, factory) \
    ((This)->lpVtbl->Base.Base.GetFactory((ID2D1Resource *)This, factory))

#define ID2D1DrawingStateBlock1_SetTextRenderingParams(This, textRenderingParams) \
    ((This)->lpVtbl->Base.SetTextRenderingParams((ID2D1DrawingStateBlock *)This, textRenderingParams))

#define ID2D1DrawingStateBlock1_GetTextRenderingParams(This, textRenderingParams) \
    ((This)->lpVtbl->Base.GetTextRenderingParams((ID2D1DrawingStateBlock *)This, textRenderingParams))

#define ID2D1DrawingStateBlock1_GetDescription(This, stateDescription) \
    ((This)->lpVtbl->GetDescription(This, stateDescription))

#define ID2D1DrawingStateBlock1_SetDescription(This, stateDescription) \
    ((This)->lpVtbl->SetDescription(This, stateDescription))

typedef interface ID2D1DeviceContext ID2D1DeviceContext;

typedef struct ID2D1DeviceContextVtbl
{
    
    ID2D1RenderTargetVtbl Base;
    
    
    STDMETHOD(CreateBitmap)(
        ID2D1DeviceContext *This,
        D2D1_SIZE_U size,
        _In_opt_ CONST void *sourceData,
        UINT32 pitch,
        _In_ CONST D2D1_BITMAP_PROPERTIES1 *bitmapProperties,
        _Outptr_ ID2D1Bitmap1 **bitmap 
        ) PURE;
    
    STDMETHOD(CreateBitmapFromWicBitmap)(
        ID2D1DeviceContext *This,
        _In_ IWICBitmapSource *wicBitmapSource,
        _In_opt_ CONST D2D1_BITMAP_PROPERTIES1 *bitmapProperties,
        _Outptr_ ID2D1Bitmap1 **bitmap 
        ) PURE;
    
    STDMETHOD(CreateColorContext)(
        ID2D1DeviceContext *This,
        D2D1_COLOR_SPACE space,
        _In_reads_opt_(profileSize) CONST BYTE *profile,
        UINT32 profileSize,
        _Outptr_ ID2D1ColorContext **colorContext 
        ) PURE;
    
    STDMETHOD(CreateColorContextFromFilename)(
        ID2D1DeviceContext *This,
        _In_ PCWSTR filename,
        _Outptr_ ID2D1ColorContext **colorContext 
        ) PURE;
    
    STDMETHOD(CreateColorContextFromWicColorContext)(
        ID2D1DeviceContext *This,
        _In_ IWICColorContext *wicColorContext,
        _Outptr_ ID2D1ColorContext **colorContext 
        ) PURE;
    
    STDMETHOD(CreateBitmapFromDxgiSurface)(
        ID2D1DeviceContext *This,
        _In_ IDXGISurface *surface,
        _In_opt_ CONST D2D1_BITMAP_PROPERTIES1 *bitmapProperties,
        _Outptr_ ID2D1Bitmap1 **bitmap 
        ) PURE;
    
    STDMETHOD(CreateEffect)(
        ID2D1DeviceContext *This,
        _In_ REFCLSID effectId,
        _Outptr_ ID2D1Effect **effect 
        ) PURE;
    
    STDMETHOD(CreateGradientStopCollection)(
        ID2D1DeviceContext *This,
        _In_reads_(straightAlphaGradientStopsCount) CONST D2D1_GRADIENT_STOP *straightAlphaGradientStops,
        _In_range_(>=,1) UINT32 straightAlphaGradientStopsCount,
        D2D1_COLOR_SPACE preInterpolationSpace,
        D2D1_COLOR_SPACE postInterpolationSpace,
        D2D1_BUFFER_PRECISION bufferPrecision,
        D2D1_EXTEND_MODE extendMode,
        D2D1_COLOR_INTERPOLATION_MODE colorInterpolationMode,
        _Outptr_ ID2D1GradientStopCollection1 **gradientStopCollection1 
        ) PURE;
    
    STDMETHOD(CreateImageBrush)(
        ID2D1DeviceContext *This,
        _In_opt_ ID2D1Image *image,
        _In_ CONST D2D1_IMAGE_BRUSH_PROPERTIES *imageBrushProperties,
        _In_opt_ CONST D2D1_BRUSH_PROPERTIES *brushProperties,
        _Outptr_ ID2D1ImageBrush **imageBrush 
        ) PURE;
    
    STDMETHOD(CreateBitmapBrush)(
        ID2D1DeviceContext *This,
        _In_opt_ ID2D1Bitmap *bitmap,
        _In_opt_ CONST D2D1_BITMAP_BRUSH_PROPERTIES1 *bitmapBrushProperties,
        _In_opt_ CONST D2D1_BRUSH_PROPERTIES *brushProperties,
        _Outptr_ ID2D1BitmapBrush1 **bitmapBrush 
        ) PURE;
    
    STDMETHOD(CreateCommandList)(
        ID2D1DeviceContext *This,
        _Outptr_ ID2D1CommandList **commandList 
        ) PURE;
    
    STDMETHOD_(BOOL, IsDxgiFormatSupported)(
        ID2D1DeviceContext *This,
        DXGI_FORMAT format 
        ) PURE;
    
    STDMETHOD_(BOOL, IsBufferPrecisionSupported)(
        ID2D1DeviceContext *This,
        D2D1_BUFFER_PRECISION bufferPrecision 
        ) PURE;
    
    STDMETHOD(GetImageLocalBounds)(
        ID2D1DeviceContext *This,
        _In_ ID2D1Image *image,
        _Out_ D2D1_RECT_F *localBounds 
        ) PURE;
    
    STDMETHOD(GetImageWorldBounds)(
        ID2D1DeviceContext *This,
        _In_ ID2D1Image *image,
        _Out_ D2D1_RECT_F *worldBounds 
        ) PURE;
    
    STDMETHOD(GetGlyphRunWorldBounds)(
        ID2D1DeviceContext *This,
        D2D1_POINT_2F baselineOrigin,
        _In_ CONST DWRITE_GLYPH_RUN *glyphRun,
        DWRITE_MEASURING_MODE measuringMode,
        _Out_ D2D1_RECT_F *bounds 
        ) PURE;
    
    STDMETHOD_(void, GetDevice)(
        ID2D1DeviceContext *This,
        _Outptr_ ID2D1Device **device 
        ) PURE;
    
    STDMETHOD_(void, SetTarget)(
        ID2D1DeviceContext *This,
        _In_opt_ ID2D1Image *image 
        ) PURE;
    
    STDMETHOD_(void, GetTarget)(
        ID2D1DeviceContext *This,
        _Outptr_result_maybenull_ ID2D1Image **image 
        ) PURE;
    
    STDMETHOD_(void, SetRenderingControls)(
        ID2D1DeviceContext *This,
        _In_ CONST D2D1_RENDERING_CONTROLS *renderingControls 
        ) PURE;
    
    STDMETHOD_(void, GetRenderingControls)(
        ID2D1DeviceContext *This,
        _Out_ D2D1_RENDERING_CONTROLS *renderingControls 
        ) PURE;
    
    STDMETHOD_(void, SetPrimitiveBlend)(
        ID2D1DeviceContext *This,
        D2D1_PRIMITIVE_BLEND primitiveBlend 
        ) PURE;
    
    STDMETHOD_(D2D1_PRIMITIVE_BLEND, GetPrimitiveBlend)(
        ID2D1DeviceContext *This 
        ) PURE;
    
    STDMETHOD_(void, SetUnitMode)(
        ID2D1DeviceContext *This,
        D2D1_UNIT_MODE unitMode 
        ) PURE;
    
    STDMETHOD_(D2D1_UNIT_MODE, GetUnitMode)(
        ID2D1DeviceContext *This 
        ) PURE;
    
    STDMETHOD_(void, DrawGlyphRun)(
        ID2D1DeviceContext *This,
        D2D1_POINT_2F baselineOrigin,
        _In_ CONST DWRITE_GLYPH_RUN *glyphRun,
        _In_opt_ CONST DWRITE_GLYPH_RUN_DESCRIPTION *glyphRunDescription,
        _In_ ID2D1Brush *foregroundBrush,
        DWRITE_MEASURING_MODE measuringMode 
        ) PURE;
    
    STDMETHOD_(void, DrawImage)(
        ID2D1DeviceContext *This,
        _In_ ID2D1Image *image,
        _In_opt_ CONST D2D1_POINT_2F *targetOffset,
        _In_opt_ CONST D2D1_RECT_F *imageRectangle,
        D2D1_INTERPOLATION_MODE interpolationMode,
        D2D1_COMPOSITE_MODE compositeMode 
        ) PURE;
    
    STDMETHOD_(void, DrawGdiMetafile)(
        ID2D1DeviceContext *This,
        _In_ ID2D1GdiMetafile *gdiMetafile,
        _In_opt_ CONST D2D1_POINT_2F *targetOffset 
        ) PURE;
    
    STDMETHOD_(void, DrawBitmap)(
        ID2D1DeviceContext *This,
        _In_ ID2D1Bitmap *bitmap,
        _In_opt_ CONST D2D1_RECT_F *destinationRectangle,
        FLOAT opacity,
        D2D1_INTERPOLATION_MODE interpolationMode,
        _In_opt_ CONST D2D1_RECT_F *sourceRectangle,
        _In_opt_ CONST D2D1_MATRIX_4X4_F *perspectiveTransform 
        ) PURE;
    
    STDMETHOD_(void, PushLayer)(
        ID2D1DeviceContext *This,
        _In_ CONST D2D1_LAYER_PARAMETERS1 *layerParameters,
        _In_opt_ ID2D1Layer *layer 
        ) PURE;
    
    STDMETHOD(InvalidateEffectInputRectangle)(
        ID2D1DeviceContext *This,
        _In_ ID2D1Effect *effect,
        UINT32 input,
        _In_ CONST D2D1_RECT_F *inputRectangle 
        ) PURE;
    
    STDMETHOD(GetEffectInvalidRectangleCount)(
        ID2D1DeviceContext *This,
        _In_ ID2D1Effect *effect,
        _Out_ UINT32 *rectangleCount 
        ) PURE;
    
    STDMETHOD(GetEffectInvalidRectangles)(
        ID2D1DeviceContext *This,
        _In_ ID2D1Effect *effect,
        _Out_writes_(rectanglesCount) D2D1_RECT_F *rectangles,
        UINT32 rectanglesCount 
        ) PURE;
    
    STDMETHOD(GetEffectRequiredInputRectangles)(
        ID2D1DeviceContext *This,
        _In_ ID2D1Effect *renderEffect,
        _In_opt_ CONST D2D1_RECT_F *renderImageRectangle,
        _In_reads_(inputCount) CONST D2D1_EFFECT_INPUT_DESCRIPTION *inputDescriptions,
        _Out_writes_(inputCount) D2D1_RECT_F *requiredInputRects,
        UINT32 inputCount 
        ) PURE;
    
    STDMETHOD_(void, FillOpacityMask)(
        ID2D1DeviceContext *This,
        _In_ ID2D1Bitmap *opacityMask,
        _In_ ID2D1Brush *brush,
        _In_opt_ CONST D2D1_RECT_F *destinationRectangle,
        _In_opt_ CONST D2D1_RECT_F *sourceRectangle 
        ) PURE;
} ID2D1DeviceContextVtbl;

interface ID2D1DeviceContext
{
    CONST struct ID2D1DeviceContextVtbl *lpVtbl;
};


#define ID2D1DeviceContext_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1DeviceContext_AddRef(This) \
    ((This)->lpVtbl->Base.Base.Base.AddRef((IUnknown *)This))

#define ID2D1DeviceContext_Release(This) \
    ((This)->lpVtbl->Base.Base.Base.Release((IUnknown *)This))

#define ID2D1DeviceContext_GetFactory(This, factory) \
    ((This)->lpVtbl->Base.Base.GetFactory((ID2D1Resource *)This, factory))

#define ID2D1DeviceContext_CreateSharedBitmap(This, riid, data, bitmapProperties, bitmap) \
    ((This)->lpVtbl->Base.CreateSharedBitmap((ID2D1RenderTarget *)This, riid, data, bitmapProperties, bitmap))

#define ID2D1DeviceContext_CreateSolidColorBrush(This, color, brushProperties, solidColorBrush) \
    ((This)->lpVtbl->Base.CreateSolidColorBrush((ID2D1RenderTarget *)This, color, brushProperties, solidColorBrush))

#define ID2D1DeviceContext_CreateLinearGradientBrush(This, linearGradientBrushProperties, brushProperties, gradientStopCollection, linearGradientBrush) \
    ((This)->lpVtbl->Base.CreateLinearGradientBrush((ID2D1RenderTarget *)This, linearGradientBrushProperties, brushProperties, gradientStopCollection, linearGradientBrush))

#define ID2D1DeviceContext_CreateRadialGradientBrush(This, radialGradientBrushProperties, brushProperties, gradientStopCollection, radialGradientBrush) \
    ((This)->lpVtbl->Base.CreateRadialGradientBrush((ID2D1RenderTarget *)This, radialGradientBrushProperties, brushProperties, gradientStopCollection, radialGradientBrush))

#define ID2D1DeviceContext_CreateCompatibleRenderTarget(This, desiredSize, desiredPixelSize, desiredFormat, options, bitmapRenderTarget) \
    ((This)->lpVtbl->Base.CreateCompatibleRenderTarget((ID2D1RenderTarget *)This, desiredSize, desiredPixelSize, desiredFormat, options, bitmapRenderTarget))

#define ID2D1DeviceContext_CreateLayer(This, size, layer) \
    ((This)->lpVtbl->Base.CreateLayer((ID2D1RenderTarget *)This, size, layer))

#define ID2D1DeviceContext_CreateMesh(This, mesh) \
    ((This)->lpVtbl->Base.CreateMesh((ID2D1RenderTarget *)This, mesh))

#define ID2D1DeviceContext_DrawLine(This, point0, point1, brush, strokeWidth, strokeStyle) \
    ((This)->lpVtbl->Base.DrawLine((ID2D1RenderTarget *)This, point0, point1, brush, strokeWidth, strokeStyle))

#define ID2D1DeviceContext_DrawRectangle(This, rect, brush, strokeWidth, strokeStyle) \
    ((This)->lpVtbl->Base.DrawRectangle((ID2D1RenderTarget *)This, rect, brush, strokeWidth, strokeStyle))

#define ID2D1DeviceContext_FillRectangle(This, rect, brush) \
    ((This)->lpVtbl->Base.FillRectangle((ID2D1RenderTarget *)This, rect, brush))

#define ID2D1DeviceContext_DrawRoundedRectangle(This, roundedRect, brush, strokeWidth, strokeStyle) \
    ((This)->lpVtbl->Base.DrawRoundedRectangle((ID2D1RenderTarget *)This, roundedRect, brush, strokeWidth, strokeStyle))

#define ID2D1DeviceContext_FillRoundedRectangle(This, roundedRect, brush) \
    ((This)->lpVtbl->Base.FillRoundedRectangle((ID2D1RenderTarget *)This, roundedRect, brush))

#define ID2D1DeviceContext_DrawEllipse(This, ellipse, brush, strokeWidth, strokeStyle) \
    ((This)->lpVtbl->Base.DrawEllipse((ID2D1RenderTarget *)This, ellipse, brush, strokeWidth, strokeStyle))

#define ID2D1DeviceContext_FillEllipse(This, ellipse, brush) \
    ((This)->lpVtbl->Base.FillEllipse((ID2D1RenderTarget *)This, ellipse, brush))

#define ID2D1DeviceContext_DrawGeometry(This, geometry, brush, strokeWidth, strokeStyle) \
    ((This)->lpVtbl->Base.DrawGeometry((ID2D1RenderTarget *)This, geometry, brush, strokeWidth, strokeStyle))

#define ID2D1DeviceContext_FillGeometry(This, geometry, brush, opacityBrush) \
    ((This)->lpVtbl->Base.FillGeometry((ID2D1RenderTarget *)This, geometry, brush, opacityBrush))

#define ID2D1DeviceContext_FillMesh(This, mesh, brush) \
    ((This)->lpVtbl->Base.FillMesh((ID2D1RenderTarget *)This, mesh, brush))

#define ID2D1DeviceContext_DrawText(This, string, stringLength, textFormat, layoutRect, defaultForegroundBrush, options, measuringMode) \
    ((This)->lpVtbl->Base.DrawText((ID2D1RenderTarget *)This, string, stringLength, textFormat, layoutRect, defaultForegroundBrush, options, measuringMode))

#define ID2D1DeviceContext_DrawTextLayout(This, origin, textLayout, defaultForegroundBrush, options) \
    ((This)->lpVtbl->Base.DrawTextLayout((ID2D1RenderTarget *)This, origin, textLayout, defaultForegroundBrush, options))

#define ID2D1DeviceContext_SetTransform(This, transform) \
    ((This)->lpVtbl->Base.SetTransform((ID2D1RenderTarget *)This, transform))

#define ID2D1DeviceContext_GetTransform(This, transform) \
    ((This)->lpVtbl->Base.GetTransform((ID2D1RenderTarget *)This, transform))

#define ID2D1DeviceContext_SetAntialiasMode(This, antialiasMode) \
    ((This)->lpVtbl->Base.SetAntialiasMode((ID2D1RenderTarget *)This, antialiasMode))

#define ID2D1DeviceContext_GetAntialiasMode(This) \
    ((This)->lpVtbl->Base.GetAntialiasMode((ID2D1RenderTarget *)This))

#define ID2D1DeviceContext_SetTextAntialiasMode(This, textAntialiasMode) \
    ((This)->lpVtbl->Base.SetTextAntialiasMode((ID2D1RenderTarget *)This, textAntialiasMode))

#define ID2D1DeviceContext_GetTextAntialiasMode(This) \
    ((This)->lpVtbl->Base.GetTextAntialiasMode((ID2D1RenderTarget *)This))

#define ID2D1DeviceContext_SetTextRenderingParams(This, textRenderingParams) \
    ((This)->lpVtbl->Base.SetTextRenderingParams((ID2D1RenderTarget *)This, textRenderingParams))

#define ID2D1DeviceContext_GetTextRenderingParams(This, textRenderingParams) \
    ((This)->lpVtbl->Base.GetTextRenderingParams((ID2D1RenderTarget *)This, textRenderingParams))

#define ID2D1DeviceContext_SetTags(This, tag1, tag2) \
    ((This)->lpVtbl->Base.SetTags((ID2D1RenderTarget *)This, tag1, tag2))

#define ID2D1DeviceContext_GetTags(This, tag1, tag2) \
    ((This)->lpVtbl->Base.GetTags((ID2D1RenderTarget *)This, tag1, tag2))

#define ID2D1DeviceContext_PopLayer(This) \
    ((This)->lpVtbl->Base.PopLayer((ID2D1RenderTarget *)This))

#define ID2D1DeviceContext_Flush(This, tag1, tag2) \
    ((This)->lpVtbl->Base.Flush((ID2D1RenderTarget *)This, tag1, tag2))

#define ID2D1DeviceContext_SaveDrawingState(This, drawingStateBlock) \
    ((This)->lpVtbl->Base.SaveDrawingState((ID2D1RenderTarget *)This, drawingStateBlock))

#define ID2D1DeviceContext_RestoreDrawingState(This, drawingStateBlock) \
    ((This)->lpVtbl->Base.RestoreDrawingState((ID2D1RenderTarget *)This, drawingStateBlock))

#define ID2D1DeviceContext_PushAxisAlignedClip(This, clipRect, antialiasMode) \
    ((This)->lpVtbl->Base.PushAxisAlignedClip((ID2D1RenderTarget *)This, clipRect, antialiasMode))

#define ID2D1DeviceContext_PopAxisAlignedClip(This) \
    ((This)->lpVtbl->Base.PopAxisAlignedClip((ID2D1RenderTarget *)This))

#define ID2D1DeviceContext_Clear(This, clearColor) \
    ((This)->lpVtbl->Base.Clear((ID2D1RenderTarget *)This, clearColor))

#define ID2D1DeviceContext_BeginDraw(This) \
    ((This)->lpVtbl->Base.BeginDraw((ID2D1RenderTarget *)This))

#define ID2D1DeviceContext_EndDraw(This, tag1, tag2) \
    ((This)->lpVtbl->Base.EndDraw((ID2D1RenderTarget *)This, tag1, tag2))

#define ID2D1DeviceContext_GetPixelFormat(This) \
    ((This)->lpVtbl->Base.GetPixelFormat((ID2D1RenderTarget *)This))

#define ID2D1DeviceContext_SetDpi(This, dpiX, dpiY) \
    ((This)->lpVtbl->Base.SetDpi((ID2D1RenderTarget *)This, dpiX, dpiY))

#define ID2D1DeviceContext_GetDpi(This, dpiX, dpiY) \
    ((This)->lpVtbl->Base.GetDpi((ID2D1RenderTarget *)This, dpiX, dpiY))

#define ID2D1DeviceContext_GetSize(This) \
    ((This)->lpVtbl->Base.GetSize((ID2D1RenderTarget *)This))

#define ID2D1DeviceContext_GetPixelSize(This) \
    ((This)->lpVtbl->Base.GetPixelSize((ID2D1RenderTarget *)This))

#define ID2D1DeviceContext_GetMaximumBitmapSize(This) \
    ((This)->lpVtbl->Base.GetMaximumBitmapSize((ID2D1RenderTarget *)This))

#define ID2D1DeviceContext_IsSupported(This, renderTargetProperties) \
    ((This)->lpVtbl->Base.IsSupported((ID2D1RenderTarget *)This, renderTargetProperties))

#define ID2D1DeviceContext_CreateBitmap(This, size, sourceData, pitch, bitmapProperties, bitmap) \
    ((This)->lpVtbl->CreateBitmap(This, size, sourceData, pitch, bitmapProperties, bitmap))

#define ID2D1DeviceContext_CreateBitmapFromWicBitmap(This, wicBitmapSource, bitmapProperties, bitmap) \
    ((This)->lpVtbl->CreateBitmapFromWicBitmap(This, wicBitmapSource, bitmapProperties, bitmap))

#define ID2D1DeviceContext_CreateColorContext(This, space, profile, profileSize, colorContext) \
    ((This)->lpVtbl->CreateColorContext(This, space, profile, profileSize, colorContext))

#define ID2D1DeviceContext_CreateColorContextFromFilename(This, filename, colorContext) \
    ((This)->lpVtbl->CreateColorContextFromFilename(This, filename, colorContext))

#define ID2D1DeviceContext_CreateColorContextFromWicColorContext(This, wicColorContext, colorContext) \
    ((This)->lpVtbl->CreateColorContextFromWicColorContext(This, wicColorContext, colorContext))

#define ID2D1DeviceContext_CreateBitmapFromDxgiSurface(This, surface, bitmapProperties, bitmap) \
    ((This)->lpVtbl->CreateBitmapFromDxgiSurface(This, surface, bitmapProperties, bitmap))

#define ID2D1DeviceContext_CreateEffect(This, effectId, effect) \
    ((This)->lpVtbl->CreateEffect(This, effectId, effect))

#define ID2D1DeviceContext_CreateGradientStopCollection(This, straightAlphaGradientStops, straightAlphaGradientStopsCount, preInterpolationSpace, postInterpolationSpace, bufferPrecision, extendMode, colorInterpolationMode, gradientStopCollection1) \
    ((This)->lpVtbl->CreateGradientStopCollection(This, straightAlphaGradientStops, straightAlphaGradientStopsCount, preInterpolationSpace, postInterpolationSpace, bufferPrecision, extendMode, colorInterpolationMode, gradientStopCollection1))

#define ID2D1DeviceContext_CreateImageBrush(This, image, imageBrushProperties, brushProperties, imageBrush) \
    ((This)->lpVtbl->CreateImageBrush(This, image, imageBrushProperties, brushProperties, imageBrush))

#define ID2D1DeviceContext_CreateBitmapBrush(This, bitmap, bitmapBrushProperties, brushProperties, bitmapBrush) \
    ((This)->lpVtbl->CreateBitmapBrush(This, bitmap, bitmapBrushProperties, brushProperties, bitmapBrush))

#define ID2D1DeviceContext_CreateCommandList(This, commandList) \
    ((This)->lpVtbl->CreateCommandList(This, commandList))

#define ID2D1DeviceContext_IsDxgiFormatSupported(This, format) \
    ((This)->lpVtbl->IsDxgiFormatSupported(This, format))

#define ID2D1DeviceContext_IsBufferPrecisionSupported(This, bufferPrecision) \
    ((This)->lpVtbl->IsBufferPrecisionSupported(This, bufferPrecision))

#define ID2D1DeviceContext_GetImageLocalBounds(This, image, localBounds) \
    ((This)->lpVtbl->GetImageLocalBounds(This, image, localBounds))

#define ID2D1DeviceContext_GetImageWorldBounds(This, image, worldBounds) \
    ((This)->lpVtbl->GetImageWorldBounds(This, image, worldBounds))

#define ID2D1DeviceContext_GetGlyphRunWorldBounds(This, baselineOrigin, glyphRun, measuringMode, bounds) \
    ((This)->lpVtbl->GetGlyphRunWorldBounds(This, baselineOrigin, glyphRun, measuringMode, bounds))

#define ID2D1DeviceContext_GetDevice(This, device) \
    ((This)->lpVtbl->GetDevice(This, device))

#define ID2D1DeviceContext_SetTarget(This, image) \
    ((This)->lpVtbl->SetTarget(This, image))

#define ID2D1DeviceContext_GetTarget(This, image) \
    ((This)->lpVtbl->GetTarget(This, image))

#define ID2D1DeviceContext_SetRenderingControls(This, renderingControls) \
    ((This)->lpVtbl->SetRenderingControls(This, renderingControls))

#define ID2D1DeviceContext_GetRenderingControls(This, renderingControls) \
    ((This)->lpVtbl->GetRenderingControls(This, renderingControls))

#define ID2D1DeviceContext_SetPrimitiveBlend(This, primitiveBlend) \
    ((This)->lpVtbl->SetPrimitiveBlend(This, primitiveBlend))

#define ID2D1DeviceContext_GetPrimitiveBlend(This) \
    ((This)->lpVtbl->GetPrimitiveBlend(This))

#define ID2D1DeviceContext_SetUnitMode(This, unitMode) \
    ((This)->lpVtbl->SetUnitMode(This, unitMode))

#define ID2D1DeviceContext_GetUnitMode(This) \
    ((This)->lpVtbl->GetUnitMode(This))

#define ID2D1DeviceContext_DrawGlyphRun(This, baselineOrigin, glyphRun, glyphRunDescription, foregroundBrush, measuringMode) \
    ((This)->lpVtbl->DrawGlyphRun(This, baselineOrigin, glyphRun, glyphRunDescription, foregroundBrush, measuringMode))

#define ID2D1DeviceContext_DrawImage(This, image, targetOffset, imageRectangle, interpolationMode, compositeMode) \
    ((This)->lpVtbl->DrawImage(This, image, targetOffset, imageRectangle, interpolationMode, compositeMode))

#define ID2D1DeviceContext_DrawGdiMetafile(This, gdiMetafile, targetOffset) \
    ((This)->lpVtbl->DrawGdiMetafile(This, gdiMetafile, targetOffset))

#define ID2D1DeviceContext_DrawBitmap(This, bitmap, destinationRectangle, opacity, interpolationMode, sourceRectangle, perspectiveTransform) \
    ((This)->lpVtbl->DrawBitmap(This, bitmap, destinationRectangle, opacity, interpolationMode, sourceRectangle, perspectiveTransform))

#define ID2D1DeviceContext_PushLayer(This, layerParameters, layer) \
    ((This)->lpVtbl->PushLayer(This, layerParameters, layer))

#define ID2D1DeviceContext_InvalidateEffectInputRectangle(This, effect, input, inputRectangle) \
    ((This)->lpVtbl->InvalidateEffectInputRectangle(This, effect, input, inputRectangle))

#define ID2D1DeviceContext_GetEffectInvalidRectangleCount(This, effect, rectangleCount) \
    ((This)->lpVtbl->GetEffectInvalidRectangleCount(This, effect, rectangleCount))

#define ID2D1DeviceContext_GetEffectInvalidRectangles(This, effect, rectangles, rectanglesCount) \
    ((This)->lpVtbl->GetEffectInvalidRectangles(This, effect, rectangles, rectanglesCount))

#define ID2D1DeviceContext_GetEffectRequiredInputRectangles(This, renderEffect, renderImageRectangle, inputDescriptions, requiredInputRects, inputCount) \
    ((This)->lpVtbl->GetEffectRequiredInputRectangles(This, renderEffect, renderImageRectangle, inputDescriptions, requiredInputRects, inputCount))

#define ID2D1DeviceContext_FillOpacityMask(This, opacityMask, brush, destinationRectangle, sourceRectangle) \
    ((This)->lpVtbl->FillOpacityMask(This, opacityMask, brush, destinationRectangle, sourceRectangle))

typedef interface ID2D1Device ID2D1Device;

typedef struct ID2D1DeviceVtbl
{
    
    ID2D1ResourceVtbl Base;
    
    
    STDMETHOD(CreateDeviceContext)(
        ID2D1Device *This,
        D2D1_DEVICE_CONTEXT_OPTIONS options,
        _Outptr_ ID2D1DeviceContext **deviceContext 
        ) PURE;
    
    STDMETHOD(CreatePrintControl)(
        ID2D1Device *This,
        _In_ IWICImagingFactory *wicFactory,
        _In_ IPrintDocumentPackageTarget *documentTarget,
        _In_opt_ CONST D2D1_PRINT_CONTROL_PROPERTIES *printControlProperties,
        _Outptr_ ID2D1PrintControl **printControl 
        ) PURE;
    
    STDMETHOD_(void, SetMaximumTextureMemory)(
        ID2D1Device *This,
        UINT64 maximumInBytes 
        ) PURE;
    
    STDMETHOD_(UINT64, GetMaximumTextureMemory)(
        ID2D1Device *This 
        ) PURE;
    
    STDMETHOD_(void, ClearResources)(
        ID2D1Device *This,
        UINT32 millisecondsSinceUse 
        ) PURE;
} ID2D1DeviceVtbl;

interface ID2D1Device
{
    CONST struct ID2D1DeviceVtbl *lpVtbl;
};


#define ID2D1Device_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1Device_AddRef(This) \
    ((This)->lpVtbl->Base.Base.AddRef((IUnknown *)This))

#define ID2D1Device_Release(This) \
    ((This)->lpVtbl->Base.Base.Release((IUnknown *)This))

#define ID2D1Device_GetFactory(This, factory) \
    ((This)->lpVtbl->Base.GetFactory((ID2D1Resource *)This, factory))

#define ID2D1Device_CreateDeviceContext(This, options, deviceContext) \
    ((This)->lpVtbl->CreateDeviceContext(This, options, deviceContext))

#define ID2D1Device_CreatePrintControl(This, wicFactory, documentTarget, printControlProperties, printControl) \
    ((This)->lpVtbl->CreatePrintControl(This, wicFactory, documentTarget, printControlProperties, printControl))

#define ID2D1Device_SetMaximumTextureMemory(This, maximumInBytes) \
    ((This)->lpVtbl->SetMaximumTextureMemory(This, maximumInBytes))

#define ID2D1Device_GetMaximumTextureMemory(This) \
    ((This)->lpVtbl->GetMaximumTextureMemory(This))

#define ID2D1Device_ClearResources(This, millisecondsSinceUse) \
    ((This)->lpVtbl->ClearResources(This, millisecondsSinceUse))

typedef interface ID2D1Factory1 ID2D1Factory1;

typedef struct ID2D1Factory1Vtbl
{
    
    ID2D1FactoryVtbl Base;
    
    
    STDMETHOD(CreateDevice)(
        ID2D1Factory1 *This,
        _In_ IDXGIDevice *dxgiDevice,
        _Outptr_ ID2D1Device **d2dDevice 
        ) PURE;
    
    STDMETHOD(CreateStrokeStyle)(
        ID2D1Factory1 *This,
        _In_ CONST D2D1_STROKE_STYLE_PROPERTIES1 *strokeStyleProperties,
        _In_reads_opt_(dashesCount) CONST FLOAT *dashes,
        UINT32 dashesCount,
        _Outptr_ ID2D1StrokeStyle1 **strokeStyle 
        ) PURE;
    
    STDMETHOD(CreatePathGeometry)(
        ID2D1Factory1 *This,
        _Outptr_ ID2D1PathGeometry1 **pathGeometry 
        ) PURE;
    
    STDMETHOD(CreateDrawingStateBlock)(
        ID2D1Factory1 *This,
        _In_opt_ CONST D2D1_DRAWING_STATE_DESCRIPTION1 *drawingStateDescription,
        _In_opt_ IDWriteRenderingParams *textRenderingParams,
        _Outptr_ ID2D1DrawingStateBlock1 **drawingStateBlock 
        ) PURE;
    
    STDMETHOD(CreateGdiMetafile)(
        ID2D1Factory1 *This,
        _In_ IStream *metafileStream,
        _Outptr_ ID2D1GdiMetafile **metafile 
        ) PURE;
    
    STDMETHOD(RegisterEffectFromStream)(
        ID2D1Factory1 *This,
        _In_ REFCLSID classId,
        _In_ IStream *propertyXml,
        _In_reads_opt_(bindingsCount) CONST D2D1_PROPERTY_BINDING *bindings,
        UINT32 bindingsCount,
        _In_ CONST PD2D1_EFFECT_FACTORY effectFactory 
        ) PURE;
    
    STDMETHOD(RegisterEffectFromString)(
        ID2D1Factory1 *This,
        _In_ REFCLSID classId,
        _In_ PCWSTR propertyXml,
        _In_reads_opt_(bindingsCount) CONST D2D1_PROPERTY_BINDING *bindings,
        UINT32 bindingsCount,
        _In_ CONST PD2D1_EFFECT_FACTORY effectFactory 
        ) PURE;
    
    STDMETHOD(UnregisterEffect)(
        ID2D1Factory1 *This,
        _In_ REFCLSID classId 
        ) PURE;
    
    STDMETHOD(GetRegisteredEffects)(
        ID2D1Factory1 *This,
        _Out_writes_to_opt_(effectsCount, *effectsReturned) CLSID *effects,
        UINT32 effectsCount,
        _Out_opt_ UINT32 *effectsReturned,
        _Out_opt_ UINT32 *effectsRegistered 
        ) PURE;
    
    STDMETHOD(GetEffectProperties)(
        ID2D1Factory1 *This,
        _In_ REFCLSID effectId,
        _Outptr_ ID2D1Properties **properties 
        ) PURE;
} ID2D1Factory1Vtbl;

interface ID2D1Factory1
{
    CONST struct ID2D1Factory1Vtbl *lpVtbl;
};


#define ID2D1Factory1_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1Factory1_AddRef(This) \
    ((This)->lpVtbl->Base.Base.AddRef((IUnknown *)This))

#define ID2D1Factory1_Release(This) \
    ((This)->lpVtbl->Base.Base.Release((IUnknown *)This))

#define ID2D1Factory1_ReloadSystemMetrics(This) \
    ((This)->lpVtbl->Base.ReloadSystemMetrics((ID2D1Factory *)This))

#define ID2D1Factory1_GetDesktopDpi(This, dpiX, dpiY) \
    ((This)->lpVtbl->Base.GetDesktopDpi((ID2D1Factory *)This, dpiX, dpiY))

#define ID2D1Factory1_CreateRectangleGeometry(This, rectangle, rectangleGeometry) \
    ((This)->lpVtbl->Base.CreateRectangleGeometry((ID2D1Factory *)This, rectangle, rectangleGeometry))

#define ID2D1Factory1_CreateRoundedRectangleGeometry(This, roundedRectangle, roundedRectangleGeometry) \
    ((This)->lpVtbl->Base.CreateRoundedRectangleGeometry((ID2D1Factory *)This, roundedRectangle, roundedRectangleGeometry))

#define ID2D1Factory1_CreateEllipseGeometry(This, ellipse, ellipseGeometry) \
    ((This)->lpVtbl->Base.CreateEllipseGeometry((ID2D1Factory *)This, ellipse, ellipseGeometry))

#define ID2D1Factory1_CreateGeometryGroup(This, fillMode, geometries, geometriesCount, geometryGroup) \
    ((This)->lpVtbl->Base.CreateGeometryGroup((ID2D1Factory *)This, fillMode, geometries, geometriesCount, geometryGroup))

#define ID2D1Factory1_CreateTransformedGeometry(This, sourceGeometry, transform, transformedGeometry) \
    ((This)->lpVtbl->Base.CreateTransformedGeometry((ID2D1Factory *)This, sourceGeometry, transform, transformedGeometry))

#define ID2D1Factory1_CreateWicBitmapRenderTarget(This, target, renderTargetProperties, renderTarget) \
    ((This)->lpVtbl->Base.CreateWicBitmapRenderTarget((ID2D1Factory *)This, target, renderTargetProperties, renderTarget))

#define ID2D1Factory1_CreateHwndRenderTarget(This, renderTargetProperties, hwndRenderTargetProperties, hwndRenderTarget) \
    ((This)->lpVtbl->Base.CreateHwndRenderTarget((ID2D1Factory *)This, renderTargetProperties, hwndRenderTargetProperties, hwndRenderTarget))

#define ID2D1Factory1_CreateDxgiSurfaceRenderTarget(This, dxgiSurface, renderTargetProperties, renderTarget) \
    ((This)->lpVtbl->Base.CreateDxgiSurfaceRenderTarget((ID2D1Factory *)This, dxgiSurface, renderTargetProperties, renderTarget))

#define ID2D1Factory1_CreateDCRenderTarget(This, renderTargetProperties, dcRenderTarget) \
    ((This)->lpVtbl->Base.CreateDCRenderTarget((ID2D1Factory *)This, renderTargetProperties, dcRenderTarget))

#define ID2D1Factory1_CreateDevice(This, dxgiDevice, d2dDevice) \
    ((This)->lpVtbl->CreateDevice(This, dxgiDevice, d2dDevice))

#define ID2D1Factory1_CreateStrokeStyle(This, strokeStyleProperties, dashes, dashesCount, strokeStyle) \
    ((This)->lpVtbl->CreateStrokeStyle(This, strokeStyleProperties, dashes, dashesCount, strokeStyle))

#define ID2D1Factory1_CreatePathGeometry(This, pathGeometry) \
    ((This)->lpVtbl->CreatePathGeometry(This, pathGeometry))

#define ID2D1Factory1_CreateDrawingStateBlock(This, drawingStateDescription, textRenderingParams, drawingStateBlock) \
    ((This)->lpVtbl->CreateDrawingStateBlock(This, drawingStateDescription, textRenderingParams, drawingStateBlock))

#define ID2D1Factory1_CreateGdiMetafile(This, metafileStream, metafile) \
    ((This)->lpVtbl->CreateGdiMetafile(This, metafileStream, metafile))

#define ID2D1Factory1_RegisterEffectFromStream(This, classId, propertyXml, bindings, bindingsCount, effectFactory) \
    ((This)->lpVtbl->RegisterEffectFromStream(This, classId, propertyXml, bindings, bindingsCount, effectFactory))

#define ID2D1Factory1_RegisterEffectFromString(This, classId, propertyXml, bindings, bindingsCount, effectFactory) \
    ((This)->lpVtbl->RegisterEffectFromString(This, classId, propertyXml, bindings, bindingsCount, effectFactory))

#define ID2D1Factory1_UnregisterEffect(This, classId) \
    ((This)->lpVtbl->UnregisterEffect(This, classId))

#define ID2D1Factory1_GetRegisteredEffects(This, effects, effectsCount, effectsReturned, effectsRegistered) \
    ((This)->lpVtbl->GetRegisteredEffects(This, effects, effectsCount, effectsReturned, effectsRegistered))

#define ID2D1Factory1_GetEffectProperties(This, effectId, properties) \
    ((This)->lpVtbl->GetEffectProperties(This, effectId, properties))

typedef interface ID2D1Multithread ID2D1Multithread;

typedef struct ID2D1MultithreadVtbl
{
    
    IUnknownVtbl Base;
    
    
    STDMETHOD_(BOOL, GetMultithreadProtected)(
        ID2D1Multithread *This 
        ) PURE;
    
    STDMETHOD_(void, Enter)(
        ID2D1Multithread *This 
        ) PURE;
    
    STDMETHOD_(void, Leave)(
        ID2D1Multithread *This 
        ) PURE;
} ID2D1MultithreadVtbl;

interface ID2D1Multithread
{
    CONST struct ID2D1MultithreadVtbl *lpVtbl;
};


#define ID2D1Multithread_QueryInterface(This, riid, ppv) \
    ((This)->lpVtbl->Base.QueryInterface((IUnknown *)This, riid, ppv))

#define ID2D1Multithread_AddRef(This) \
    ((This)->lpVtbl->Base.AddRef((IUnknown *)This))

#define ID2D1Multithread_Release(This) \
    ((This)->lpVtbl->Base.Release((IUnknown *)This))

#define ID2D1Multithread_GetMultithreadProtected(This) \
    ((This)->lpVtbl->GetMultithreadProtected(This))

#define ID2D1Multithread_Enter(This) \
    ((This)->lpVtbl->Enter(This))

#define ID2D1Multithread_Leave(This) \
    ((This)->lpVtbl->Leave(This))


#endif

           
#ifdef __cplusplus
extern "C"
{
#endif

    HRESULT WINAPI 
    D2D1CreateDevice(
        _In_ IDXGIDevice *dxgiDevice,
        _In_opt_ CONST D2D1_CREATION_PROPERTIES *creationProperties,
        _Outptr_ ID2D1Device **d2dDevice
        ); 
        
    HRESULT WINAPI 
    D2D1CreateDeviceContext(
        _In_ IDXGISurface *dxgiSurface,
        _In_opt_ CONST D2D1_CREATION_PROPERTIES *creationProperties,
        _Outptr_ ID2D1DeviceContext **d2dDeviceContext
        ); 

    D2D1_COLOR_F WINAPI
    D2D1ConvertColorSpace(
        D2D1_COLOR_SPACE sourceColorSpace,
        D2D1_COLOR_SPACE destinationColorSpace,
        _In_ CONST D2D1_COLOR_F* color
        );
            
    void WINAPI
    D2D1SinCos(
      _In_ FLOAT angle,
      _Out_ FLOAT *s,
      _Out_ FLOAT *c
      );
           
    FLOAT WINAPI
    D2D1Tan(
        _In_ FLOAT angle
        );
        
    FLOAT WINAPI
    D2D1Vec3Length(
      _In_ FLOAT x,
      _In_ FLOAT y,
      _In_ FLOAT z
      );
        
#ifdef __cplusplus
}
#endif
        
#include <d2d1_1helper.h>


#ifndef D2D_USE_C_DEFINITIONS

inline HRESULT 
D2D1CreateDevice(
    _In_ IDXGIDevice *dxgiDevice,
    _In_ CONST D2D1_CREATION_PROPERTIES &creationProperties,
    _Outptr_ ID2D1Device **d2dDevice
    ) 
{

    return
        D2D1CreateDevice(
            dxgiDevice,
            &creationProperties,
            d2dDevice);
} 
    
inline HRESULT 
D2D1CreateDeviceContext(
    _In_ IDXGISurface *dxgiSurface,
    _In_ CONST D2D1_CREATION_PROPERTIES &creationProperties,
    _Outptr_ ID2D1DeviceContext **d2dDeviceContext
    ) 
{
    return
        D2D1CreateDeviceContext(
            dxgiSurface,
            &creationProperties,
            d2dDeviceContext);
}

#endif // #ifndef D2D_USE_C_DEFINITIONS

#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP) */
#pragma endregion
#endif // #ifndef _D2D1_1_H_
