//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// Specifies whether a buffer will be modified between the time it is bound and a compute
/// or render pipeline is executed in a draw or dispatch.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlmutability?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLMutability(pub NSUInteger);
impl MTLMutability {
    #[doc(alias = "MTLMutabilityDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "MTLMutabilityMutable")]
    pub const Mutable: Self = Self(1);
    #[doc(alias = "MTLMutabilityImmutable")]
    pub const Immutable: Self = Self(2);
}

unsafe impl Encode for MTLMutability {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLMutability {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlshadervalidation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLShaderValidation(pub NSInteger);
impl MTLShaderValidation {
    #[doc(alias = "MTLShaderValidationDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "MTLShaderValidationEnabled")]
    pub const Enabled: Self = Self(1);
    #[doc(alias = "MTLShaderValidationDisabled")]
    pub const Disabled: Self = Self(2);
}

unsafe impl Encode for MTLShaderValidation {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLShaderValidation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlpipelinebufferdescriptor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLPipelineBufferDescriptor;
);

extern_conformance!(
    unsafe impl NSCopying for MTLPipelineBufferDescriptor {}
);

unsafe impl CopyingHelper for MTLPipelineBufferDescriptor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLPipelineBufferDescriptor {}
);

impl MTLPipelineBufferDescriptor {
    extern_methods!(
        /// Buffer mutability. Defaults to MTLMutabilityDefault: mutable for standard buffers, immutable for argument buffers
        #[unsafe(method(mutability))]
        #[unsafe(method_family = none)]
        pub fn mutability(&self) -> MTLMutability;

        /// Setter for [`mutability`][Self::mutability].
        #[unsafe(method(setMutability:))]
        #[unsafe(method_family = none)]
        pub fn setMutability(&self, mutability: MTLMutability);
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLPipelineBufferDescriptor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlpipelinebufferdescriptorarray?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLPipelineBufferDescriptorArray;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLPipelineBufferDescriptorArray {}
);

impl MTLPipelineBufferDescriptorArray {
    extern_methods!(
        #[unsafe(method(objectAtIndexedSubscript:))]
        #[unsafe(method_family = none)]
        pub unsafe fn objectAtIndexedSubscript(
            &self,
            buffer_index: NSUInteger,
        ) -> Retained<MTLPipelineBufferDescriptor>;

        #[unsafe(method(setObject:atIndexedSubscript:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setObject_atIndexedSubscript(
            &self,
            buffer: Option<&MTLPipelineBufferDescriptor>,
            buffer_index: NSUInteger,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLPipelineBufferDescriptorArray {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
