// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The details on the use of the guardrail.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GuardrailUsage {
    /// <p>The topic policy units processed by the guardrail.</p>
    pub topic_policy_units: i32,
    /// <p>The content policy units processed by the guardrail.</p>
    pub content_policy_units: i32,
    /// <p>The word policy units processed by the guardrail.</p>
    pub word_policy_units: i32,
    /// <p>The sensitive information policy units processed by the guardrail.</p>
    pub sensitive_information_policy_units: i32,
    /// <p>The sensitive information policy free units processed by the guardrail.</p>
    pub sensitive_information_policy_free_units: i32,
    /// <p>The contextual grounding policy units processed by the guardrail.</p>
    pub contextual_grounding_policy_units: i32,
    /// <p>The content policy image units processed by the guardrail.</p>
    pub content_policy_image_units: ::std::option::Option<i32>,
}
impl GuardrailUsage {
    /// <p>The topic policy units processed by the guardrail.</p>
    pub fn topic_policy_units(&self) -> i32 {
        self.topic_policy_units
    }
    /// <p>The content policy units processed by the guardrail.</p>
    pub fn content_policy_units(&self) -> i32 {
        self.content_policy_units
    }
    /// <p>The word policy units processed by the guardrail.</p>
    pub fn word_policy_units(&self) -> i32 {
        self.word_policy_units
    }
    /// <p>The sensitive information policy units processed by the guardrail.</p>
    pub fn sensitive_information_policy_units(&self) -> i32 {
        self.sensitive_information_policy_units
    }
    /// <p>The sensitive information policy free units processed by the guardrail.</p>
    pub fn sensitive_information_policy_free_units(&self) -> i32 {
        self.sensitive_information_policy_free_units
    }
    /// <p>The contextual grounding policy units processed by the guardrail.</p>
    pub fn contextual_grounding_policy_units(&self) -> i32 {
        self.contextual_grounding_policy_units
    }
    /// <p>The content policy image units processed by the guardrail.</p>
    pub fn content_policy_image_units(&self) -> ::std::option::Option<i32> {
        self.content_policy_image_units
    }
}
impl GuardrailUsage {
    /// Creates a new builder-style object to manufacture [`GuardrailUsage`](crate::types::GuardrailUsage).
    pub fn builder() -> crate::types::builders::GuardrailUsageBuilder {
        crate::types::builders::GuardrailUsageBuilder::default()
    }
}

/// A builder for [`GuardrailUsage`](crate::types::GuardrailUsage).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GuardrailUsageBuilder {
    pub(crate) topic_policy_units: ::std::option::Option<i32>,
    pub(crate) content_policy_units: ::std::option::Option<i32>,
    pub(crate) word_policy_units: ::std::option::Option<i32>,
    pub(crate) sensitive_information_policy_units: ::std::option::Option<i32>,
    pub(crate) sensitive_information_policy_free_units: ::std::option::Option<i32>,
    pub(crate) contextual_grounding_policy_units: ::std::option::Option<i32>,
    pub(crate) content_policy_image_units: ::std::option::Option<i32>,
}
impl GuardrailUsageBuilder {
    /// <p>The topic policy units processed by the guardrail.</p>
    /// This field is required.
    pub fn topic_policy_units(mut self, input: i32) -> Self {
        self.topic_policy_units = ::std::option::Option::Some(input);
        self
    }
    /// <p>The topic policy units processed by the guardrail.</p>
    pub fn set_topic_policy_units(mut self, input: ::std::option::Option<i32>) -> Self {
        self.topic_policy_units = input;
        self
    }
    /// <p>The topic policy units processed by the guardrail.</p>
    pub fn get_topic_policy_units(&self) -> &::std::option::Option<i32> {
        &self.topic_policy_units
    }
    /// <p>The content policy units processed by the guardrail.</p>
    /// This field is required.
    pub fn content_policy_units(mut self, input: i32) -> Self {
        self.content_policy_units = ::std::option::Option::Some(input);
        self
    }
    /// <p>The content policy units processed by the guardrail.</p>
    pub fn set_content_policy_units(mut self, input: ::std::option::Option<i32>) -> Self {
        self.content_policy_units = input;
        self
    }
    /// <p>The content policy units processed by the guardrail.</p>
    pub fn get_content_policy_units(&self) -> &::std::option::Option<i32> {
        &self.content_policy_units
    }
    /// <p>The word policy units processed by the guardrail.</p>
    /// This field is required.
    pub fn word_policy_units(mut self, input: i32) -> Self {
        self.word_policy_units = ::std::option::Option::Some(input);
        self
    }
    /// <p>The word policy units processed by the guardrail.</p>
    pub fn set_word_policy_units(mut self, input: ::std::option::Option<i32>) -> Self {
        self.word_policy_units = input;
        self
    }
    /// <p>The word policy units processed by the guardrail.</p>
    pub fn get_word_policy_units(&self) -> &::std::option::Option<i32> {
        &self.word_policy_units
    }
    /// <p>The sensitive information policy units processed by the guardrail.</p>
    /// This field is required.
    pub fn sensitive_information_policy_units(mut self, input: i32) -> Self {
        self.sensitive_information_policy_units = ::std::option::Option::Some(input);
        self
    }
    /// <p>The sensitive information policy units processed by the guardrail.</p>
    pub fn set_sensitive_information_policy_units(mut self, input: ::std::option::Option<i32>) -> Self {
        self.sensitive_information_policy_units = input;
        self
    }
    /// <p>The sensitive information policy units processed by the guardrail.</p>
    pub fn get_sensitive_information_policy_units(&self) -> &::std::option::Option<i32> {
        &self.sensitive_information_policy_units
    }
    /// <p>The sensitive information policy free units processed by the guardrail.</p>
    /// This field is required.
    pub fn sensitive_information_policy_free_units(mut self, input: i32) -> Self {
        self.sensitive_information_policy_free_units = ::std::option::Option::Some(input);
        self
    }
    /// <p>The sensitive information policy free units processed by the guardrail.</p>
    pub fn set_sensitive_information_policy_free_units(mut self, input: ::std::option::Option<i32>) -> Self {
        self.sensitive_information_policy_free_units = input;
        self
    }
    /// <p>The sensitive information policy free units processed by the guardrail.</p>
    pub fn get_sensitive_information_policy_free_units(&self) -> &::std::option::Option<i32> {
        &self.sensitive_information_policy_free_units
    }
    /// <p>The contextual grounding policy units processed by the guardrail.</p>
    /// This field is required.
    pub fn contextual_grounding_policy_units(mut self, input: i32) -> Self {
        self.contextual_grounding_policy_units = ::std::option::Option::Some(input);
        self
    }
    /// <p>The contextual grounding policy units processed by the guardrail.</p>
    pub fn set_contextual_grounding_policy_units(mut self, input: ::std::option::Option<i32>) -> Self {
        self.contextual_grounding_policy_units = input;
        self
    }
    /// <p>The contextual grounding policy units processed by the guardrail.</p>
    pub fn get_contextual_grounding_policy_units(&self) -> &::std::option::Option<i32> {
        &self.contextual_grounding_policy_units
    }
    /// <p>The content policy image units processed by the guardrail.</p>
    pub fn content_policy_image_units(mut self, input: i32) -> Self {
        self.content_policy_image_units = ::std::option::Option::Some(input);
        self
    }
    /// <p>The content policy image units processed by the guardrail.</p>
    pub fn set_content_policy_image_units(mut self, input: ::std::option::Option<i32>) -> Self {
        self.content_policy_image_units = input;
        self
    }
    /// <p>The content policy image units processed by the guardrail.</p>
    pub fn get_content_policy_image_units(&self) -> &::std::option::Option<i32> {
        &self.content_policy_image_units
    }
    /// Consumes the builder and constructs a [`GuardrailUsage`](crate::types::GuardrailUsage).
    /// This method will fail if any of the following fields are not set:
    /// - [`topic_policy_units`](crate::types::builders::GuardrailUsageBuilder::topic_policy_units)
    /// - [`content_policy_units`](crate::types::builders::GuardrailUsageBuilder::content_policy_units)
    /// - [`word_policy_units`](crate::types::builders::GuardrailUsageBuilder::word_policy_units)
    /// - [`sensitive_information_policy_units`](crate::types::builders::GuardrailUsageBuilder::sensitive_information_policy_units)
    /// - [`sensitive_information_policy_free_units`](crate::types::builders::GuardrailUsageBuilder::sensitive_information_policy_free_units)
    /// - [`contextual_grounding_policy_units`](crate::types::builders::GuardrailUsageBuilder::contextual_grounding_policy_units)
    pub fn build(self) -> ::std::result::Result<crate::types::GuardrailUsage, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::GuardrailUsage {
            topic_policy_units: self.topic_policy_units.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "topic_policy_units",
                    "topic_policy_units was not specified but it is required when building GuardrailUsage",
                )
            })?,
            content_policy_units: self.content_policy_units.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "content_policy_units",
                    "content_policy_units was not specified but it is required when building GuardrailUsage",
                )
            })?,
            word_policy_units: self.word_policy_units.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "word_policy_units",
                    "word_policy_units was not specified but it is required when building GuardrailUsage",
                )
            })?,
            sensitive_information_policy_units: self.sensitive_information_policy_units.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "sensitive_information_policy_units",
                    "sensitive_information_policy_units was not specified but it is required when building GuardrailUsage",
                )
            })?,
            sensitive_information_policy_free_units: self.sensitive_information_policy_free_units.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "sensitive_information_policy_free_units",
                    "sensitive_information_policy_free_units was not specified but it is required when building GuardrailUsage",
                )
            })?,
            contextual_grounding_policy_units: self.contextual_grounding_policy_units.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "contextual_grounding_policy_units",
                    "contextual_grounding_policy_units was not specified but it is required when building GuardrailUsage",
                )
            })?,
            content_policy_image_units: self.content_policy_image_units,
        })
    }
}
