// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"
#include "Rivet/Projections/Beam.hh"

namespace Rivet {


  /// @brief 
  class CRYSTAL_BALL_1992_I306832 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(CRYSTAL_BALL_1992_I306832);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      // Initialise and register projections
      declare(Beam(), "Beams");
      declare(FinalState(), "FS");
      // histograms
      book(_c[0],"TMP/c_mu");
      book(_c[1],"TMP/c_energy");
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      // get the axis, direction of incoming positron
      const ParticlePair& beams = apply<Beam>(event, "Beams").beams();
      Vector3 axis1 = beams.first .momentum().p3().unit();
      Vector3 axis2 = beams.second.momentum().p3().unit();
      if(beams.first.pid()<0) swap(axis1,axis2);
      _c[1]->fill((beams.first.momentum()+beams.second.momentum()).mass()/MeV);
      // loop over FS particles
      Particles fs = apply<FinalState>(event,"FS").particles();
      Particles mm,mp;
      for(const Particle & p : fs) {
	if(p.abspid()==PID::MUON) {
	  if(p.pid()>0) mm.push_back(p);
	  else          mp.push_back(p);
	}
	else if(p.pid()!=PID::GAMMA)
	  vetoEvent;
      }
      if(mm.size()==1 && mp.size()==1) {
	_c[0]->fill();
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      double fact = crossSection()/ sumOfWeights() /picobarn;
      double energy = _c[1]->val()/ sumOfWeights();
      double sig_m = _c[0]->val()*fact;
      double err_m = _c[0]->err()*fact;
      for(unsigned int ix=0;ix<2;++ix) {
	Scatter2D temphisto(refData(1+ix, 1, 1));
	Scatter2DPtr cross;
	book(cross, 1+ix, 1, 1);
	double deltaE=1e30;
	unsigned int ipoint=100000000;
	for (size_t b = 0; b < temphisto.numPoints(); b++) {
	  double test = abs(temphisto.point(b).x()-energy);
	  if(test<deltaE) {
	    deltaE=test;
	    ipoint=b;
	  }
	}
	if(deltaE>10.) continue;
	for (size_t b = 0; b < temphisto.numPoints(); b++) {
	  const double x  = temphisto.point(b).x();
	  pair<double,double> ex = temphisto.point(b).xErrs();
	  if (b!=ipoint)
	    cross  ->addPoint(x, 0., ex, make_pair(0.,.0));
	  else
	    cross  ->addPoint(x, sig_m, ex, make_pair(err_m,err_m));
	}
      }
    }

    /// @}


    /// @name Histograms
    /// @{
    CounterPtr _c[2];
    /// @}


  };


  RIVET_DECLARE_PLUGIN(CRYSTAL_BALL_1992_I306832);

}
