#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 655
#define LARGE_STATE_COUNT 208
#define SYMBOL_COUNT 178
#define ALIAS_COUNT 5
#define TOKEN_COUNT 101
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 10
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 28

enum {
  sym_identifier = 1,
  anon_sym_COMMA = 2,
  anon_sym_package = 3,
  anon_sym_import = 4,
  anon_sym_DOT = 5,
  anon_sym__ = 6,
  anon_sym_LPAREN = 7,
  anon_sym_RPAREN = 8,
  anon_sym_let = 9,
  anon_sym_if = 10,
  anon_sym_for = 11,
  anon_sym_number = 12,
  anon_sym_float = 13,
  anon_sym_float32 = 14,
  anon_sym_float64 = 15,
  anon_sym_uint = 16,
  anon_sym_uint8 = 17,
  anon_sym_uint16 = 18,
  anon_sym_uint32 = 19,
  anon_sym_uint64 = 20,
  anon_sym_uint128 = 21,
  anon_sym_int = 22,
  anon_sym_int8 = 23,
  anon_sym_int16 = 24,
  anon_sym_int32 = 25,
  anon_sym_int64 = 26,
  anon_sym_int128 = 27,
  anon_sym_string = 28,
  anon_sym_bytes = 29,
  anon_sym_bool = 30,
  anon_sym_AT = 31,
  anon_sym_DASH = 32,
  anon_sym_LBRACK = 33,
  anon_sym_RBRACK = 34,
  anon_sym_LBRACE = 35,
  anon_sym_RBRACE = 36,
  anon_sym_LT = 37,
  anon_sym_GT = 38,
  anon_sym_EQ = 39,
  anon_sym_STAR = 40,
  aux_sym__attr_item_token1 = 41,
  sym_attr_path = 42,
  anon_sym_len = 43,
  anon_sym_close = 44,
  anon_sym_and = 45,
  anon_sym_or = 46,
  anon_sym_div = 47,
  anon_sym_mod = 48,
  anon_sym_quo = 49,
  anon_sym_rem = 50,
  anon_sym_DOT_DOT_DOT = 51,
  anon_sym_BANG = 52,
  anon_sym_QMARK = 53,
  anon_sym_COLON = 54,
  anon_sym_in = 55,
  anon_sym_PLUS = 56,
  anon_sym_SLASH = 57,
  anon_sym_PIPE = 58,
  anon_sym_AMP = 59,
  anon_sym_PIPE_PIPE = 60,
  anon_sym_AMP_AMP = 61,
  anon_sym_EQ_EQ = 62,
  anon_sym_EQ_TILDE = 63,
  anon_sym_BANG_TILDE = 64,
  anon_sym_BANG_EQ = 65,
  anon_sym_LT_EQ = 66,
  anon_sym_GT_EQ = 67,
  sym_bottom = 68,
  anon_sym_true = 69,
  anon_sym_false = 70,
  sym_null = 71,
  sym_number = 72,
  sym_float = 73,
  aux_sym_si_unit_token1 = 74,
  sym_escape_char = 75,
  sym_escape_byte = 76,
  aux_sym__escape_unicode_token1 = 77,
  anon_sym_DQUOTE = 78,
  aux_sym__simple_string_lit_token1 = 79,
  anon_sym_SQUOTE = 80,
  aux_sym__simple_bytes_lit_token1 = 81,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 82,
  anon_sym_SQUOTE_SQUOTE_SQUOTE = 83,
  anon_sym_POUND_DQUOTE = 84,
  anon_sym_DQUOTE_POUND = 85,
  anon_sym_POUND_SQUOTE = 86,
  anon_sym_SQUOTE_POUND = 87,
  anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE = 88,
  anon_sym_DQUOTE_DQUOTE_DQUOTE_POUND = 89,
  anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE = 90,
  anon_sym_SQUOTE_SQUOTE_SQUOTE_POUND = 91,
  anon_sym_BSLASH_LPAREN = 92,
  anon_sym_BSLASH_POUND_LPAREN = 93,
  sym_comment = 94,
  sym__multi_str_content = 95,
  sym__multi_bytes_content = 96,
  sym__raw_str_content = 97,
  sym__raw_bytes_content = 98,
  sym__multi_raw_str_content = 99,
  sym__multi_raw_bytes_content = 100,
  sym_source_file = 101,
  sym__package_identifier = 102,
  sym_package_clause = 103,
  sym_import_declaration = 104,
  sym_import_spec = 105,
  sym_import_spec_list = 106,
  sym_attribute = 107,
  sym__attr_token = 108,
  sym__attr_item = 109,
  sym_package_path = 110,
  sym_builtin_function = 111,
  sym__declaration = 112,
  sym__list_elem = 113,
  sym_list_lit = 114,
  sym_struct_lit = 115,
  sym_ellipsis = 116,
  sym__embedding = 117,
  sym__label_name = 118,
  sym__label_alias_expr = 119,
  sym_required = 120,
  sym_optional = 121,
  sym__label_expr = 122,
  sym_label = 123,
  sym_field = 124,
  sym__value = 125,
  sym_for_clause = 126,
  sym_guard_clause = 127,
  sym_let_clause = 128,
  sym__clause = 129,
  sym_comprehension = 130,
  sym__alias_expr = 131,
  sym_parenthesized_expression = 132,
  sym_expression = 133,
  sym_primary_expression = 134,
  sym_binary_expression = 135,
  sym_unary_expression = 136,
  sym_call_expression = 137,
  sym_index_expression = 138,
  sym_selector_expression = 139,
  sym_arguments = 140,
  sym__literal = 141,
  sym_primitive_type = 142,
  sym_top = 143,
  sym_boolean = 144,
  sym_si_unit = 145,
  sym__escape_unicode = 146,
  sym_string = 147,
  sym__simple_string_lit = 148,
  sym__simple_bytes_lit = 149,
  sym__multiline_string_lit = 150,
  sym__multiline_bytes_lit = 151,
  sym__simple_raw_string_lit = 152,
  sym__simple_raw_bytes_lit = 153,
  sym__multiline_raw_string_lit = 154,
  sym__multiline_raw_bytes_lit = 155,
  sym_interpolation = 156,
  sym_raw_interpolation = 157,
  aux_sym_source_file_repeat1 = 158,
  aux_sym_source_file_repeat2 = 159,
  aux_sym_import_spec_list_repeat1 = 160,
  aux_sym_attribute_repeat1 = 161,
  aux_sym_attribute_repeat2 = 162,
  aux_sym_package_path_repeat1 = 163,
  aux_sym__list_elem_repeat1 = 164,
  aux_sym_list_lit_repeat1 = 165,
  aux_sym_struct_lit_repeat1 = 166,
  aux_sym_field_repeat1 = 167,
  aux_sym_comprehension_repeat1 = 168,
  aux_sym_arguments_repeat1 = 169,
  aux_sym__simple_string_lit_repeat1 = 170,
  aux_sym__simple_bytes_lit_repeat1 = 171,
  aux_sym__multiline_string_lit_repeat1 = 172,
  aux_sym__multiline_bytes_lit_repeat1 = 173,
  aux_sym__simple_raw_string_lit_repeat1 = 174,
  aux_sym__simple_raw_bytes_lit_repeat1 = 175,
  aux_sym__multiline_raw_string_lit_repeat1 = 176,
  aux_sym__multiline_raw_bytes_lit_repeat1 = 177,
  alias_sym_dynamic = 178,
  alias_sym_package_identifier = 179,
  alias_sym_pointer_type = 180,
  alias_sym_slice_type = 181,
  alias_sym_value = 182,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_COMMA] = ",",
  [anon_sym_package] = "package",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym__] = "_",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_let] = "let",
  [anon_sym_if] = "if",
  [anon_sym_for] = "for",
  [anon_sym_number] = "number",
  [anon_sym_float] = "float",
  [anon_sym_float32] = "float32",
  [anon_sym_float64] = "float64",
  [anon_sym_uint] = "uint",
  [anon_sym_uint8] = "uint8",
  [anon_sym_uint16] = "uint16",
  [anon_sym_uint32] = "uint32",
  [anon_sym_uint64] = "uint64",
  [anon_sym_uint128] = "uint128",
  [anon_sym_int] = "int",
  [anon_sym_int8] = "int8",
  [anon_sym_int16] = "int16",
  [anon_sym_int32] = "int32",
  [anon_sym_int64] = "int64",
  [anon_sym_int128] = "int128",
  [anon_sym_string] = "string",
  [anon_sym_bytes] = "bytes",
  [anon_sym_bool] = "bool",
  [anon_sym_AT] = "@",
  [anon_sym_DASH] = "-",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_EQ] = "=",
  [anon_sym_STAR] = "*",
  [aux_sym__attr_item_token1] = "_attr_item_token1",
  [sym_attr_path] = "attr_path",
  [anon_sym_len] = "len",
  [anon_sym_close] = "close",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_div] = "div",
  [anon_sym_mod] = "mod",
  [anon_sym_quo] = "quo",
  [anon_sym_rem] = "rem",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_BANG] = "!",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_in] = "in",
  [anon_sym_PLUS] = "+",
  [anon_sym_SLASH] = "/",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_BANG_TILDE] = "!~",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [sym_bottom] = "bottom",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_null] = "null",
  [sym_number] = "number",
  [sym_float] = "float",
  [aux_sym_si_unit_token1] = "si_unit_token1",
  [sym_escape_char] = "escape_char",
  [sym_escape_byte] = "escape_byte",
  [aux_sym__escape_unicode_token1] = "escape_unicode",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__simple_string_lit_token1] = "_simple_string_lit_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym__simple_bytes_lit_token1] = "_simple_bytes_lit_token1",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = "'''",
  [anon_sym_POUND_DQUOTE] = "#\"",
  [anon_sym_DQUOTE_POUND] = "\"#",
  [anon_sym_POUND_SQUOTE] = "#'",
  [anon_sym_SQUOTE_POUND] = "'#",
  [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = "#\"\"\"",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE_POUND] = "\"\"\"#",
  [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = "#'''",
  [anon_sym_SQUOTE_SQUOTE_SQUOTE_POUND] = "'''#",
  [anon_sym_BSLASH_LPAREN] = "\\(",
  [anon_sym_BSLASH_POUND_LPAREN] = "\\#(",
  [sym_comment] = "comment",
  [sym__multi_str_content] = "_multi_str_content",
  [sym__multi_bytes_content] = "_multi_bytes_content",
  [sym__raw_str_content] = "_raw_str_content",
  [sym__raw_bytes_content] = "_raw_bytes_content",
  [sym__multi_raw_str_content] = "_multi_raw_str_content",
  [sym__multi_raw_bytes_content] = "_multi_raw_bytes_content",
  [sym_source_file] = "source_file",
  [sym__package_identifier] = "_package_identifier",
  [sym_package_clause] = "package_clause",
  [sym_import_declaration] = "import_declaration",
  [sym_import_spec] = "import_spec",
  [sym_import_spec_list] = "import_spec_list",
  [sym_attribute] = "attribute",
  [sym__attr_token] = "_attr_token",
  [sym__attr_item] = "_attr_item",
  [sym_package_path] = "package_path",
  [sym_builtin_function] = "builtin_function",
  [sym__declaration] = "_declaration",
  [sym__list_elem] = "_list_elem",
  [sym_list_lit] = "list_lit",
  [sym_struct_lit] = "struct_lit",
  [sym_ellipsis] = "ellipsis",
  [sym__embedding] = "_embedding",
  [sym__label_name] = "_label_name",
  [sym__label_alias_expr] = "_label_alias_expr",
  [sym_required] = "required",
  [sym_optional] = "optional",
  [sym__label_expr] = "_label_expr",
  [sym_label] = "label",
  [sym_field] = "field",
  [sym__value] = "_value",
  [sym_for_clause] = "for_clause",
  [sym_guard_clause] = "guard_clause",
  [sym_let_clause] = "let_clause",
  [sym__clause] = "_clause",
  [sym_comprehension] = "comprehension",
  [sym__alias_expr] = "_alias_expr",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_call_expression] = "call_expression",
  [sym_index_expression] = "index_expression",
  [sym_selector_expression] = "selector_expression",
  [sym_arguments] = "arguments",
  [sym__literal] = "_literal",
  [sym_primitive_type] = "primitive_type",
  [sym_top] = "top",
  [sym_boolean] = "boolean",
  [sym_si_unit] = "si_unit",
  [sym__escape_unicode] = "_escape_unicode",
  [sym_string] = "string",
  [sym__simple_string_lit] = "_simple_string_lit",
  [sym__simple_bytes_lit] = "_simple_bytes_lit",
  [sym__multiline_string_lit] = "_multiline_string_lit",
  [sym__multiline_bytes_lit] = "_multiline_bytes_lit",
  [sym__simple_raw_string_lit] = "_simple_raw_string_lit",
  [sym__simple_raw_bytes_lit] = "_simple_raw_bytes_lit",
  [sym__multiline_raw_string_lit] = "_multiline_raw_string_lit",
  [sym__multiline_raw_bytes_lit] = "_multiline_raw_bytes_lit",
  [sym_interpolation] = "interpolation",
  [sym_raw_interpolation] = "raw_interpolation",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_source_file_repeat2] = "source_file_repeat2",
  [aux_sym_import_spec_list_repeat1] = "import_spec_list_repeat1",
  [aux_sym_attribute_repeat1] = "attribute_repeat1",
  [aux_sym_attribute_repeat2] = "attribute_repeat2",
  [aux_sym_package_path_repeat1] = "package_path_repeat1",
  [aux_sym__list_elem_repeat1] = "_list_elem_repeat1",
  [aux_sym_list_lit_repeat1] = "list_lit_repeat1",
  [aux_sym_struct_lit_repeat1] = "struct_lit_repeat1",
  [aux_sym_field_repeat1] = "field_repeat1",
  [aux_sym_comprehension_repeat1] = "comprehension_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym__simple_string_lit_repeat1] = "_simple_string_lit_repeat1",
  [aux_sym__simple_bytes_lit_repeat1] = "_simple_bytes_lit_repeat1",
  [aux_sym__multiline_string_lit_repeat1] = "_multiline_string_lit_repeat1",
  [aux_sym__multiline_bytes_lit_repeat1] = "_multiline_bytes_lit_repeat1",
  [aux_sym__simple_raw_string_lit_repeat1] = "_simple_raw_string_lit_repeat1",
  [aux_sym__simple_raw_bytes_lit_repeat1] = "_simple_raw_bytes_lit_repeat1",
  [aux_sym__multiline_raw_string_lit_repeat1] = "_multiline_raw_string_lit_repeat1",
  [aux_sym__multiline_raw_bytes_lit_repeat1] = "_multiline_raw_bytes_lit_repeat1",
  [alias_sym_dynamic] = "dynamic",
  [alias_sym_package_identifier] = "package_identifier",
  [alias_sym_pointer_type] = "pointer_type",
  [alias_sym_slice_type] = "slice_type",
  [alias_sym_value] = "value",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym__] = anon_sym__,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_float32] = anon_sym_float32,
  [anon_sym_float64] = anon_sym_float64,
  [anon_sym_uint] = anon_sym_uint,
  [anon_sym_uint8] = anon_sym_uint8,
  [anon_sym_uint16] = anon_sym_uint16,
  [anon_sym_uint32] = anon_sym_uint32,
  [anon_sym_uint64] = anon_sym_uint64,
  [anon_sym_uint128] = anon_sym_uint128,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_int8] = anon_sym_int8,
  [anon_sym_int16] = anon_sym_int16,
  [anon_sym_int32] = anon_sym_int32,
  [anon_sym_int64] = anon_sym_int64,
  [anon_sym_int128] = anon_sym_int128,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_bytes] = anon_sym_bytes,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_STAR] = anon_sym_STAR,
  [aux_sym__attr_item_token1] = aux_sym__attr_item_token1,
  [sym_attr_path] = sym_attr_path,
  [anon_sym_len] = anon_sym_len,
  [anon_sym_close] = anon_sym_close,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_div] = anon_sym_div,
  [anon_sym_mod] = anon_sym_mod,
  [anon_sym_quo] = anon_sym_quo,
  [anon_sym_rem] = anon_sym_rem,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_TILDE] = anon_sym_EQ_TILDE,
  [anon_sym_BANG_TILDE] = anon_sym_BANG_TILDE,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [sym_bottom] = sym_bottom,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_null] = sym_null,
  [sym_number] = sym_number,
  [sym_float] = sym_float,
  [aux_sym_si_unit_token1] = aux_sym_si_unit_token1,
  [sym_escape_char] = sym_escape_char,
  [sym_escape_byte] = sym_escape_byte,
  [aux_sym__escape_unicode_token1] = aux_sym__escape_unicode_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__simple_string_lit_token1] = aux_sym__simple_string_lit_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym__simple_bytes_lit_token1] = aux_sym__simple_bytes_lit_token1,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE_SQUOTE,
  [anon_sym_POUND_DQUOTE] = anon_sym_POUND_DQUOTE,
  [anon_sym_DQUOTE_POUND] = anon_sym_DQUOTE_POUND,
  [anon_sym_POUND_SQUOTE] = anon_sym_POUND_SQUOTE,
  [anon_sym_SQUOTE_POUND] = anon_sym_SQUOTE_POUND,
  [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE_POUND] = anon_sym_DQUOTE_DQUOTE_DQUOTE_POUND,
  [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE,
  [anon_sym_SQUOTE_SQUOTE_SQUOTE_POUND] = anon_sym_SQUOTE_SQUOTE_SQUOTE_POUND,
  [anon_sym_BSLASH_LPAREN] = anon_sym_BSLASH_LPAREN,
  [anon_sym_BSLASH_POUND_LPAREN] = anon_sym_BSLASH_POUND_LPAREN,
  [sym_comment] = sym_comment,
  [sym__multi_str_content] = sym__multi_str_content,
  [sym__multi_bytes_content] = sym__multi_bytes_content,
  [sym__raw_str_content] = sym__raw_str_content,
  [sym__raw_bytes_content] = sym__raw_bytes_content,
  [sym__multi_raw_str_content] = sym__multi_raw_str_content,
  [sym__multi_raw_bytes_content] = sym__multi_raw_bytes_content,
  [sym_source_file] = sym_source_file,
  [sym__package_identifier] = sym__package_identifier,
  [sym_package_clause] = sym_package_clause,
  [sym_import_declaration] = sym_import_declaration,
  [sym_import_spec] = sym_import_spec,
  [sym_import_spec_list] = sym_import_spec_list,
  [sym_attribute] = sym_attribute,
  [sym__attr_token] = sym__attr_token,
  [sym__attr_item] = sym__attr_item,
  [sym_package_path] = sym_package_path,
  [sym_builtin_function] = sym_builtin_function,
  [sym__declaration] = sym__declaration,
  [sym__list_elem] = sym__list_elem,
  [sym_list_lit] = sym_list_lit,
  [sym_struct_lit] = sym_struct_lit,
  [sym_ellipsis] = sym_ellipsis,
  [sym__embedding] = sym__embedding,
  [sym__label_name] = sym__label_name,
  [sym__label_alias_expr] = sym__label_alias_expr,
  [sym_required] = sym_required,
  [sym_optional] = sym_optional,
  [sym__label_expr] = sym__label_expr,
  [sym_label] = sym_label,
  [sym_field] = sym_field,
  [sym__value] = sym__value,
  [sym_for_clause] = sym_for_clause,
  [sym_guard_clause] = sym_guard_clause,
  [sym_let_clause] = sym_let_clause,
  [sym__clause] = sym__clause,
  [sym_comprehension] = sym_comprehension,
  [sym__alias_expr] = sym__alias_expr,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_index_expression] = sym_index_expression,
  [sym_selector_expression] = sym_selector_expression,
  [sym_arguments] = sym_arguments,
  [sym__literal] = sym__literal,
  [sym_primitive_type] = sym_primitive_type,
  [sym_top] = sym_top,
  [sym_boolean] = sym_boolean,
  [sym_si_unit] = sym_si_unit,
  [sym__escape_unicode] = sym__escape_unicode,
  [sym_string] = sym_string,
  [sym__simple_string_lit] = sym__simple_string_lit,
  [sym__simple_bytes_lit] = sym__simple_bytes_lit,
  [sym__multiline_string_lit] = sym__multiline_string_lit,
  [sym__multiline_bytes_lit] = sym__multiline_bytes_lit,
  [sym__simple_raw_string_lit] = sym__simple_raw_string_lit,
  [sym__simple_raw_bytes_lit] = sym__simple_raw_bytes_lit,
  [sym__multiline_raw_string_lit] = sym__multiline_raw_string_lit,
  [sym__multiline_raw_bytes_lit] = sym__multiline_raw_bytes_lit,
  [sym_interpolation] = sym_interpolation,
  [sym_raw_interpolation] = sym_raw_interpolation,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_source_file_repeat2] = aux_sym_source_file_repeat2,
  [aux_sym_import_spec_list_repeat1] = aux_sym_import_spec_list_repeat1,
  [aux_sym_attribute_repeat1] = aux_sym_attribute_repeat1,
  [aux_sym_attribute_repeat2] = aux_sym_attribute_repeat2,
  [aux_sym_package_path_repeat1] = aux_sym_package_path_repeat1,
  [aux_sym__list_elem_repeat1] = aux_sym__list_elem_repeat1,
  [aux_sym_list_lit_repeat1] = aux_sym_list_lit_repeat1,
  [aux_sym_struct_lit_repeat1] = aux_sym_struct_lit_repeat1,
  [aux_sym_field_repeat1] = aux_sym_field_repeat1,
  [aux_sym_comprehension_repeat1] = aux_sym_comprehension_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym__simple_string_lit_repeat1] = aux_sym__simple_string_lit_repeat1,
  [aux_sym__simple_bytes_lit_repeat1] = aux_sym__simple_bytes_lit_repeat1,
  [aux_sym__multiline_string_lit_repeat1] = aux_sym__multiline_string_lit_repeat1,
  [aux_sym__multiline_bytes_lit_repeat1] = aux_sym__multiline_bytes_lit_repeat1,
  [aux_sym__simple_raw_string_lit_repeat1] = aux_sym__simple_raw_string_lit_repeat1,
  [aux_sym__simple_raw_bytes_lit_repeat1] = aux_sym__simple_raw_bytes_lit_repeat1,
  [aux_sym__multiline_raw_string_lit_repeat1] = aux_sym__multiline_raw_string_lit_repeat1,
  [aux_sym__multiline_raw_bytes_lit_repeat1] = aux_sym__multiline_raw_bytes_lit_repeat1,
  [alias_sym_dynamic] = alias_sym_dynamic,
  [alias_sym_package_identifier] = alias_sym_package_identifier,
  [alias_sym_pointer_type] = alias_sym_pointer_type,
  [alias_sym_slice_type] = alias_sym_slice_type,
  [alias_sym_value] = alias_sym_value,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__attr_item_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_attr_path] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_len] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_close] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_quo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_bottom] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_si_unit_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_char] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_byte] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__escape_unicode_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__simple_string_lit_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__simple_bytes_lit_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE_SQUOTE_SQUOTE_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_POUND_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__multi_str_content] = {
    .visible = false,
    .named = true,
  },
  [sym__multi_bytes_content] = {
    .visible = false,
    .named = true,
  },
  [sym__raw_str_content] = {
    .visible = false,
    .named = true,
  },
  [sym__raw_bytes_content] = {
    .visible = false,
    .named = true,
  },
  [sym__multi_raw_str_content] = {
    .visible = false,
    .named = true,
  },
  [sym__multi_raw_bytes_content] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__package_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_package_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_import_spec_list] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__attr_token] = {
    .visible = false,
    .named = true,
  },
  [sym__attr_item] = {
    .visible = false,
    .named = true,
  },
  [sym_package_path] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin_function] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__list_elem] = {
    .visible = false,
    .named = true,
  },
  [sym_list_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_ellipsis] = {
    .visible = true,
    .named = true,
  },
  [sym__embedding] = {
    .visible = false,
    .named = true,
  },
  [sym__label_name] = {
    .visible = false,
    .named = true,
  },
  [sym__label_alias_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_required] = {
    .visible = true,
    .named = true,
  },
  [sym_optional] = {
    .visible = true,
    .named = true,
  },
  [sym__label_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym__value] = {
    .visible = false,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_guard_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_let_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__clause] = {
    .visible = false,
    .named = true,
  },
  [sym_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym__alias_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_selector_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [sym_top] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_si_unit] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_unicode] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_string_lit] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_bytes_lit] = {
    .visible = false,
    .named = true,
  },
  [sym__multiline_string_lit] = {
    .visible = false,
    .named = true,
  },
  [sym__multiline_bytes_lit] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_raw_string_lit] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_raw_bytes_lit] = {
    .visible = false,
    .named = true,
  },
  [sym__multiline_raw_string_lit] = {
    .visible = false,
    .named = true,
  },
  [sym__multiline_raw_bytes_lit] = {
    .visible = false,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_interpolation] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_source_file_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_spec_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_package_path_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_elem_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comprehension_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_string_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_bytes_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiline_string_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiline_bytes_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_raw_string_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_raw_bytes_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiline_raw_string_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiline_raw_bytes_lit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_dynamic] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_package_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pointer_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_slice_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_value] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_argument = 2,
  field_condition = 3,
  field_function = 4,
  field_left = 5,
  field_name = 6,
  field_operator = 7,
  field_path = 8,
  field_right = 9,
  field_unit = 10,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_argument] = "argument",
  [field_condition] = "condition",
  [field_function] = "function",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_path] = "path",
  [field_right] = "right",
  [field_unit] = "unit",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [6] = {.index = 1, .length = 1},
  [7] = {.index = 2, .length = 1},
  [8] = {.index = 3, .length = 1},
  [9] = {.index = 4, .length = 2},
  [10] = {.index = 0, .length = 1},
  [11] = {.index = 6, .length = 1},
  [12] = {.index = 7, .length = 1},
  [13] = {.index = 8, .length = 2},
  [14] = {.index = 0, .length = 1},
  [15] = {.index = 10, .length = 2},
  [16] = {.index = 12, .length = 1},
  [17] = {.index = 12, .length = 1},
  [18] = {.index = 13, .length = 2},
  [19] = {.index = 15, .length = 1},
  [20] = {.index = 16, .length = 3},
  [22] = {.index = 19, .length = 2},
  [23] = {.index = 21, .length = 2},
  [24] = {.index = 23, .length = 1},
  [26] = {.index = 24, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_alias, 0, .inherited = true},
  [1] =
    {field_path, 0},
  [2] =
    {field_function, 0},
  [3] =
    {field_condition, 1},
  [4] =
    {field_argument, 1},
    {field_operator, 0},
  [6] =
    {field_unit, 1},
  [7] =
    {field_alias, 1, .inherited = true},
  [8] =
    {field_alias, 0, .inherited = true},
    {field_alias, 1, .inherited = true},
  [10] =
    {field_name, 0},
    {field_path, 1},
  [12] =
    {field_alias, 0},
  [13] =
    {field_alias, 1, .inherited = true},
    {field_alias, 2, .inherited = true},
  [15] =
    {field_alias, 2, .inherited = true},
  [16] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [19] =
    {field_left, 1},
    {field_right, 3},
  [21] =
    {field_alias, 2, .inherited = true},
    {field_alias, 3, .inherited = true},
  [23] =
    {field_alias, 3, .inherited = true},
  [24] =
    {field_alias, 3, .inherited = true},
    {field_alias, 4, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [3] = {
    [0] = alias_sym_dynamic,
  },
  [4] = {
    [0] = sym_string,
  },
  [5] = {
    [0] = alias_sym_package_identifier,
  },
  [10] = {
    [0] = sym_optional,
  },
  [14] = {
    [0] = alias_sym_value,
  },
  [17] = {
    [0] = sym_identifier,
  },
  [21] = {
    [2] = sym_string,
  },
  [25] = {
    [1] = alias_sym_pointer_type,
  },
  [27] = {
    [2] = alias_sym_slice_type,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__attr_item, 3,
    sym__attr_item,
    alias_sym_pointer_type,
    alias_sym_slice_type,
  sym__alias_expr, 3,
    sym__alias_expr,
    alias_sym_value,
    sym_optional,
  sym_parenthesized_expression, 2,
    sym_parenthesized_expression,
    alias_sym_dynamic,
  sym__simple_string_lit, 2,
    sym__simple_string_lit,
    sym_string,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 4,
  [7] = 7,
  [8] = 7,
  [9] = 9,
  [10] = 7,
  [11] = 3,
  [12] = 9,
  [13] = 4,
  [14] = 9,
  [15] = 3,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 26,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 25,
  [35] = 35,
  [36] = 21,
  [37] = 23,
  [38] = 38,
  [39] = 25,
  [40] = 26,
  [41] = 41,
  [42] = 42,
  [43] = 23,
  [44] = 28,
  [45] = 21,
  [46] = 46,
  [47] = 47,
  [48] = 28,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 67,
  [69] = 69,
  [70] = 69,
  [71] = 71,
  [72] = 72,
  [73] = 72,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 81,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 88,
  [92] = 92,
  [93] = 88,
  [94] = 86,
  [95] = 89,
  [96] = 87,
  [97] = 97,
  [98] = 89,
  [99] = 88,
  [100] = 89,
  [101] = 87,
  [102] = 102,
  [103] = 103,
  [104] = 90,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 92,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 110,
  [114] = 85,
  [115] = 112,
  [116] = 109,
  [117] = 107,
  [118] = 106,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 157,
  [189] = 162,
  [190] = 190,
  [191] = 154,
  [192] = 192,
  [193] = 155,
  [194] = 153,
  [195] = 156,
  [196] = 196,
  [197] = 197,
  [198] = 152,
  [199] = 168,
  [200] = 165,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 132,
  [209] = 134,
  [210] = 119,
  [211] = 211,
  [212] = 149,
  [213] = 146,
  [214] = 121,
  [215] = 148,
  [216] = 216,
  [217] = 217,
  [218] = 137,
  [219] = 219,
  [220] = 220,
  [221] = 138,
  [222] = 150,
  [223] = 223,
  [224] = 139,
  [225] = 225,
  [226] = 151,
  [227] = 227,
  [228] = 228,
  [229] = 145,
  [230] = 230,
  [231] = 144,
  [232] = 232,
  [233] = 141,
  [234] = 130,
  [235] = 235,
  [236] = 236,
  [237] = 140,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 257,
  [259] = 257,
  [260] = 260,
  [261] = 261,
  [262] = 260,
  [263] = 261,
  [264] = 260,
  [265] = 261,
  [266] = 266,
  [267] = 267,
  [268] = 266,
  [269] = 269,
  [270] = 267,
  [271] = 267,
  [272] = 266,
  [273] = 269,
  [274] = 266,
  [275] = 269,
  [276] = 267,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 279,
  [281] = 281,
  [282] = 282,
  [283] = 277,
  [284] = 278,
  [285] = 285,
  [286] = 132,
  [287] = 150,
  [288] = 281,
  [289] = 289,
  [290] = 137,
  [291] = 119,
  [292] = 292,
  [293] = 138,
  [294] = 121,
  [295] = 139,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 151,
  [300] = 149,
  [301] = 146,
  [302] = 145,
  [303] = 303,
  [304] = 148,
  [305] = 144,
  [306] = 134,
  [307] = 140,
  [308] = 131,
  [309] = 142,
  [310] = 160,
  [311] = 282,
  [312] = 141,
  [313] = 130,
  [314] = 147,
  [315] = 315,
  [316] = 142,
  [317] = 130,
  [318] = 318,
  [319] = 297,
  [320] = 151,
  [321] = 292,
  [322] = 145,
  [323] = 289,
  [324] = 121,
  [325] = 138,
  [326] = 326,
  [327] = 131,
  [328] = 139,
  [329] = 160,
  [330] = 147,
  [331] = 144,
  [332] = 141,
  [333] = 298,
  [334] = 140,
  [335] = 148,
  [336] = 146,
  [337] = 150,
  [338] = 149,
  [339] = 119,
  [340] = 132,
  [341] = 341,
  [342] = 134,
  [343] = 137,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 121,
  [348] = 119,
  [349] = 144,
  [350] = 150,
  [351] = 134,
  [352] = 148,
  [353] = 132,
  [354] = 137,
  [355] = 138,
  [356] = 139,
  [357] = 151,
  [358] = 149,
  [359] = 146,
  [360] = 145,
  [361] = 141,
  [362] = 130,
  [363] = 140,
  [364] = 133,
  [365] = 129,
  [366] = 160,
  [367] = 123,
  [368] = 125,
  [369] = 169,
  [370] = 161,
  [371] = 371,
  [372] = 170,
  [373] = 131,
  [374] = 374,
  [375] = 164,
  [376] = 159,
  [377] = 166,
  [378] = 156,
  [379] = 152,
  [380] = 168,
  [381] = 165,
  [382] = 153,
  [383] = 154,
  [384] = 167,
  [385] = 163,
  [386] = 147,
  [387] = 387,
  [388] = 128,
  [389] = 142,
  [390] = 162,
  [391] = 157,
  [392] = 155,
  [393] = 158,
  [394] = 394,
  [395] = 181,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 173,
  [400] = 180,
  [401] = 175,
  [402] = 182,
  [403] = 176,
  [404] = 177,
  [405] = 171,
  [406] = 174,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 183,
  [411] = 411,
  [412] = 412,
  [413] = 412,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 415,
  [421] = 418,
  [422] = 415,
  [423] = 417,
  [424] = 419,
  [425] = 416,
  [426] = 419,
  [427] = 417,
  [428] = 417,
  [429] = 419,
  [430] = 235,
  [431] = 223,
  [432] = 432,
  [433] = 119,
  [434] = 121,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 441,
  [445] = 445,
  [446] = 443,
  [447] = 445,
  [448] = 442,
  [449] = 442,
  [450] = 440,
  [451] = 440,
  [452] = 452,
  [453] = 452,
  [454] = 439,
  [455] = 439,
  [456] = 456,
  [457] = 439,
  [458] = 456,
  [459] = 459,
  [460] = 445,
  [461] = 452,
  [462] = 443,
  [463] = 456,
  [464] = 445,
  [465] = 441,
  [466] = 443,
  [467] = 441,
  [468] = 442,
  [469] = 469,
  [470] = 470,
  [471] = 440,
  [472] = 452,
  [473] = 452,
  [474] = 440,
  [475] = 439,
  [476] = 442,
  [477] = 456,
  [478] = 441,
  [479] = 445,
  [480] = 443,
  [481] = 443,
  [482] = 445,
  [483] = 441,
  [484] = 456,
  [485] = 456,
  [486] = 442,
  [487] = 439,
  [488] = 440,
  [489] = 452,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 494,
  [497] = 490,
  [498] = 490,
  [499] = 494,
  [500] = 495,
  [501] = 501,
  [502] = 493,
  [503] = 492,
  [504] = 504,
  [505] = 505,
  [506] = 505,
  [507] = 507,
  [508] = 504,
  [509] = 492,
  [510] = 510,
  [511] = 505,
  [512] = 495,
  [513] = 501,
  [514] = 501,
  [515] = 494,
  [516] = 279,
  [517] = 490,
  [518] = 501,
  [519] = 504,
  [520] = 493,
  [521] = 505,
  [522] = 495,
  [523] = 523,
  [524] = 524,
  [525] = 501,
  [526] = 493,
  [527] = 492,
  [528] = 278,
  [529] = 495,
  [530] = 493,
  [531] = 493,
  [532] = 504,
  [533] = 504,
  [534] = 505,
  [535] = 505,
  [536] = 492,
  [537] = 492,
  [538] = 277,
  [539] = 490,
  [540] = 495,
  [541] = 494,
  [542] = 490,
  [543] = 501,
  [544] = 504,
  [545] = 494,
  [546] = 546,
  [547] = 281,
  [548] = 282,
  [549] = 127,
  [550] = 140,
  [551] = 551,
  [552] = 552,
  [553] = 125,
  [554] = 123,
  [555] = 131,
  [556] = 142,
  [557] = 160,
  [558] = 147,
  [559] = 298,
  [560] = 297,
  [561] = 561,
  [562] = 292,
  [563] = 289,
  [564] = 561,
  [565] = 551,
  [566] = 126,
  [567] = 134,
  [568] = 148,
  [569] = 150,
  [570] = 132,
  [571] = 137,
  [572] = 138,
  [573] = 139,
  [574] = 151,
  [575] = 149,
  [576] = 146,
  [577] = 145,
  [578] = 144,
  [579] = 141,
  [580] = 130,
  [581] = 581,
  [582] = 582,
  [583] = 341,
  [584] = 128,
  [585] = 561,
  [586] = 326,
  [587] = 303,
  [588] = 318,
  [589] = 282,
  [590] = 551,
  [591] = 315,
  [592] = 135,
  [593] = 136,
  [594] = 143,
  [595] = 551,
  [596] = 561,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 315,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 599,
  [607] = 303,
  [608] = 608,
  [609] = 603,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 613,
  [616] = 616,
  [617] = 603,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 621,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 630,
  [632] = 632,
  [633] = 633,
  [634] = 633,
  [635] = 630,
  [636] = 636,
  [637] = 637,
  [638] = 638,
  [639] = 639,
  [640] = 638,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 630,
  [645] = 645,
  [646] = 638,
  [647] = 647,
  [648] = 648,
  [649] = 645,
  [650] = 645,
  [651] = 651,
  [652] = 652,
  [653] = 633,
  [654] = 628,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 880
            ? (c < 192
              ? (c < 170
                ? (c < 'A'
                  ? c == '$'
                  : (c <= 'Z' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 736
                ? (c < 248
                  ? (c >= 216 && c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 750
                  ? c == 748
                  : c <= 750)))))
            : (c <= 884 || (c < 910
              ? (c < 902
                ? (c < 890
                  ? (c >= 886 && c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 908
                  ? (c >= 904 && c <= 906)
                  : c <= 908)))
              : (c <= 929 || (c < 1162
                ? (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : c <= 1153)
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 6688
    ? (c < 2984
      ? (c < 2365
        ? (c < 1488
          ? (c < 886
            ? (c < 216
              ? (c < 181
                ? (c < 'a'
                  ? (c >= 'A' && c <= 'Z')
                  : (c <= 'z' || c == 170))
                : (c <= 181 || (c < 192
                  ? c == 186
                  : c <= 214)))
              : (c <= 246 || (c < 748
                ? (c < 710
                  ? (c >= 248 && c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))
                : (c <= 748 || (c < 880
                  ? c == 750
                  : c <= 884)))))
            : (c <= 887 || (c < 931
              ? (c < 904
                ? (c < 895
                  ? (c >= 890 && c <= 893)
                  : (c <= 895 || c == 902))
                : (c <= 906 || (c < 910
                  ? c == 908
                  : c <= 929)))
              : (c <= 1013 || (c < 1329
                ? (c < 1162
                  ? (c >= 1015 && c <= 1153)
                  : c <= 1327)
                : (c <= 1366 || (c < 1376
                  ? c == 1369
                  : c <= 1416)))))))
          : (c <= 1514 || (c < 1994
            ? (c < 1774
              ? (c < 1649
                ? (c < 1568
                  ? (c >= 1519 && c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))
                : (c <= 1747 || (c < 1765
                  ? c == 1749
                  : c <= 1766)))
              : (c <= 1775 || (c < 1810
                ? (c < 1791
                  ? (c >= 1786 && c <= 1788)
                  : (c <= 1791 || c == 1808))
                : (c <= 1839 || (c < 1969
                  ? (c >= 1869 && c <= 1957)
                  : c <= 1969)))))
            : (c <= 2026 || (c < 2112
              ? (c < 2074
                ? (c < 2042
                  ? (c >= 2036 && c <= 2037)
                  : (c <= 2042 || (c >= 2048 && c <= 2069)))
                : (c <= 2074 || (c < 2088
                  ? c == 2084
                  : c <= 2088)))
              : (c <= 2136 || (c < 2185
                ? (c < 2160
                  ? (c >= 2144 && c <= 2154)
                  : c <= 2183)
                : (c <= 2190 || (c < 2308
                  ? (c >= 2208 && c <= 2249)
                  : c <= 2361)))))))))
        : (c <= 2365 || (c < 2703
          ? (c < 2544
            ? (c < 2474
              ? (c < 2437
                ? (c < 2392
                  ? c == 2384
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2451
                  ? (c >= 2447 && c <= 2448)
                  : c <= 2472)))
              : (c <= 2480 || (c < 2510
                ? (c < 2486
                  ? c == 2482
                  : (c <= 2489 || c == 2493))
                : (c <= 2510 || (c < 2527
                  ? (c >= 2524 && c <= 2525)
                  : c <= 2529)))))
            : (c <= 2545 || (c < 2613
              ? (c < 2579
                ? (c < 2565
                  ? c == 2556
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2610
                  ? (c >= 2602 && c <= 2608)
                  : c <= 2611)))
              : (c <= 2614 || (c < 2654
                ? (c < 2649
                  ? (c >= 2616 && c <= 2617)
                  : c <= 2652)
                : (c <= 2654 || (c < 2693
                  ? (c >= 2674 && c <= 2676)
                  : c <= 2701)))))))
          : (c <= 2705 || (c < 2869
            ? (c < 2784
              ? (c < 2741
                ? (c < 2730
                  ? (c >= 2707 && c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2768
                  ? c == 2749
                  : c <= 2768)))
              : (c <= 2785 || (c < 2835
                ? (c < 2821
                  ? c == 2809
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))
                : (c <= 2856 || (c < 2866
                  ? (c >= 2858 && c <= 2864)
                  : c <= 2867)))))
            : (c <= 2873 || (c < 2958
              ? (c < 2929
                ? (c < 2908
                  ? c == 2877
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2929 || (c < 2949
                  ? c == 2947
                  : c <= 2954)))
              : (c <= 2960 || (c < 2972
                ? (c < 2969
                  ? (c >= 2962 && c <= 2965)
                  : c <= 2970)
                : (c <= 2972 || (c < 2979
                  ? (c >= 2974 && c <= 2975)
                  : c <= 2980)))))))))))
      : (c <= 2986 || (c < 4176
        ? (c < 3423
          ? (c < 3218
            ? (c < 3133
              ? (c < 3086
                ? (c < 3024
                  ? (c >= 2990 && c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))
                : (c <= 3088 || (c < 3114
                  ? (c >= 3090 && c <= 3112)
                  : c <= 3129)))
              : (c <= 3133 || (c < 3200
                ? (c < 3165
                  ? (c >= 3160 && c <= 3162)
                  : (c <= 3165 || (c >= 3168 && c <= 3169)))
                : (c <= 3200 || (c < 3214
                  ? (c >= 3205 && c <= 3212)
                  : c <= 3216)))))
            : (c <= 3240 || (c < 3332
              ? (c < 3293
                ? (c < 3253
                  ? (c >= 3242 && c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3313
                  ? (c >= 3296 && c <= 3297)
                  : c <= 3314)))
              : (c <= 3340 || (c < 3389
                ? (c < 3346
                  ? (c >= 3342 && c <= 3344)
                  : c <= 3386)
                : (c <= 3389 || (c < 3412
                  ? c == 3406
                  : c <= 3414)))))))
          : (c <= 3425 || (c < 3749
            ? (c < 3585
              ? (c < 3507
                ? (c < 3461
                  ? (c >= 3450 && c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3520
                  ? c == 3517
                  : c <= 3526)))
              : (c <= 3632 || (c < 3716
                ? (c < 3648
                  ? (c >= 3634 && c <= 3635)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3724
                  ? (c >= 3718 && c <= 3722)
                  : c <= 3747)))))
            : (c <= 3749 || (c < 3840
              ? (c < 3776
                ? (c < 3762
                  ? (c >= 3751 && c <= 3760)
                  : (c <= 3763 || c == 3773))
                : (c <= 3780 || (c < 3804
                  ? c == 3782
                  : c <= 3807)))
              : (c <= 3840 || (c < 3976
                ? (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : c <= 3948)
                : (c <= 3980 || (c < 4159
                  ? (c >= 4096 && c <= 4138)
                  : c <= 4159)))))))))
        : (c <= 4181 || (c < 4992
          ? (c < 4696
            ? (c < 4256
              ? (c < 4206
                ? (c < 4193
                  ? (c >= 4186 && c <= 4189)
                  : (c <= 4193 || (c >= 4197 && c <= 4198)))
                : (c <= 4208 || (c < 4238
                  ? (c >= 4213 && c <= 4225)
                  : c <= 4238)))
              : (c <= 4293 || (c < 4348
                ? (c < 4301
                  ? c == 4295
                  : (c <= 4301 || (c >= 4304 && c <= 4346)))
                : (c <= 4680 || (c < 4688
                  ? (c >= 4682 && c <= 4685)
                  : c <= 4694)))))
            : (c <= 4696 || (c < 4800
              ? (c < 4752
                ? (c < 4704
                  ? (c >= 4698 && c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4792
                  ? (c >= 4786 && c <= 4789)
                  : c <= 4798)))
              : (c <= 4800 || (c < 4824
                ? (c < 4808
                  ? (c >= 4802 && c <= 4805)
                  : c <= 4822)
                : (c <= 4880 || (c < 4888
                  ? (c >= 4882 && c <= 4885)
                  : c <= 4954)))))))
          : (c <= 5007 || (c < 6103
            ? (c < 5873
              ? (c < 5743
                ? (c < 5112
                  ? (c >= 5024 && c <= 5109)
                  : (c <= 5117 || (c >= 5121 && c <= 5740)))
                : (c <= 5759 || (c < 5792
                  ? (c >= 5761 && c <= 5786)
                  : c <= 5866)))
              : (c <= 5880 || (c < 5984
                ? (c < 5919
                  ? (c >= 5888 && c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6016
                  ? (c >= 5998 && c <= 6000)
                  : c <= 6067)))))
            : (c <= 6103 || (c < 6400
              ? (c < 6279
                ? (c < 6176
                  ? c == 6108
                  : (c <= 6264 || (c >= 6272 && c <= 6276)))
                : (c <= 6312 || (c < 6320
                  ? c == 6314
                  : c <= 6389)))
              : (c <= 6430 || (c < 6528
                ? (c < 6512
                  ? (c >= 6480 && c <= 6509)
                  : c <= 6516)
                : (c <= 6571 || (c < 6656
                  ? (c >= 6576 && c <= 6601)
                  : c <= 6678)))))))))))))
    : (c <= 6740 || (c < 43261
      ? (c < 11264
        ? (c < 8064
          ? (c < 7406
            ? (c < 7168
              ? (c < 7043
                ? (c < 6917
                  ? c == 6823
                  : (c <= 6963 || (c >= 6981 && c <= 6988)))
                : (c <= 7072 || (c < 7098
                  ? (c >= 7086 && c <= 7087)
                  : c <= 7141)))
              : (c <= 7203 || (c < 7312
                ? (c < 7258
                  ? (c >= 7245 && c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))
                : (c <= 7354 || (c < 7401
                  ? (c >= 7357 && c <= 7359)
                  : c <= 7404)))))
            : (c <= 7411 || (c < 8008
              ? (c < 7680
                ? (c < 7418
                  ? (c >= 7413 && c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))
                : (c <= 7957 || (c < 7968
                  ? (c >= 7960 && c <= 7965)
                  : c <= 8005)))
              : (c <= 8013 || (c < 8027
                ? (c < 8025
                  ? (c >= 8016 && c <= 8023)
                  : c <= 8025)
                : (c <= 8027 || (c < 8031
                  ? c == 8029
                  : c <= 8061)))))))
          : (c <= 8116 || (c < 8455
            ? (c < 8160
              ? (c < 8134
                ? (c < 8126
                  ? (c >= 8118 && c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))
                : (c <= 8140 || (c < 8150
                  ? (c >= 8144 && c <= 8147)
                  : c <= 8155)))
              : (c <= 8172 || (c < 8319
                ? (c < 8182
                  ? (c >= 8178 && c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8450
                  ? (c >= 8336 && c <= 8348)
                  : c <= 8450)))))
            : (c <= 8455 || (c < 8490
              ? (c < 8484
                ? (c < 8469
                  ? (c >= 8458 && c <= 8467)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8488
                  ? c == 8486
                  : c <= 8488)))
              : (c <= 8493 || (c < 8517
                ? (c < 8508
                  ? (c >= 8495 && c <= 8505)
                  : c <= 8511)
                : (c <= 8521 || (c < 8579
                  ? c == 8526
                  : c <= 8580)))))))))
        : (c <= 11492 || (c < 12704
          ? (c < 11720
            ? (c < 11631
              ? (c < 11559
                ? (c < 11506
                  ? (c >= 11499 && c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11568
                  ? c == 11565
                  : c <= 11623)))
              : (c <= 11631 || (c < 11696
                ? (c < 11680
                  ? (c >= 11648 && c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))
                : (c <= 11702 || (c < 11712
                  ? (c >= 11704 && c <= 11710)
                  : c <= 11718)))))
            : (c <= 11726 || (c < 12353
              ? (c < 12293
                ? (c < 11736
                  ? (c >= 11728 && c <= 11734)
                  : (c <= 11742 || c == 11823))
                : (c <= 12294 || (c < 12347
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)))
              : (c <= 12438 || (c < 12540
                ? (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : c <= 12538)
                : (c <= 12543 || (c < 12593
                  ? (c >= 12549 && c <= 12591)
                  : c <= 12686)))))))
          : (c <= 12735 || (c < 42786
            ? (c < 42240
              ? (c < 19968
                ? (c < 13312
                  ? (c >= 12784 && c <= 12799)
                  : (c <= 13312 || c == 19903))
                : (c <= 19968 || (c < 42192
                  ? (c >= 40959 && c <= 42124)
                  : c <= 42237)))
              : (c <= 42508 || (c < 42623
                ? (c < 42538
                  ? (c >= 42512 && c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42775
                  ? (c >= 42656 && c <= 42725)
                  : c <= 42783)))))
            : (c <= 42888 || (c < 43015
              ? (c < 42965
                ? (c < 42960
                  ? (c >= 42891 && c <= 42954)
                  : (c <= 42961 || c == 42963))
                : (c <= 42969 || (c < 43011
                  ? (c >= 42994 && c <= 43009)
                  : c <= 43013)))
              : (c <= 43018 || (c < 43138
                ? (c < 43072
                  ? (c >= 43020 && c <= 43042)
                  : c <= 43123)
                : (c <= 43187 || (c < 43259
                  ? (c >= 43250 && c <= 43255)
                  : c <= 43259)))))))))))
      : (c <= 43262 || (c < 65345
        ? (c < 43816
          ? (c < 43646
            ? (c < 43494
              ? (c < 43396
                ? (c < 43312
                  ? (c >= 43274 && c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43488
                  ? c == 43471
                  : c <= 43492)))
              : (c <= 43503 || (c < 43588
                ? (c < 43520
                  ? (c >= 43514 && c <= 43518)
                  : (c <= 43560 || (c >= 43584 && c <= 43586)))
                : (c <= 43595 || (c < 43642
                  ? (c >= 43616 && c <= 43638)
                  : c <= 43642)))))
            : (c <= 43695 || (c < 43744
              ? (c < 43712
                ? (c < 43701
                  ? c == 43697
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))
                : (c <= 43712 || (c < 43739
                  ? c == 43714
                  : c <= 43741)))
              : (c <= 43754 || (c < 43785
                ? (c < 43777
                  ? (c >= 43762 && c <= 43764)
                  : c <= 43782)
                : (c <= 43790 || (c < 43808
                  ? (c >= 43793 && c <= 43798)
                  : c <= 43814)))))))
          : (c <= 43822 || (c < 64298
            ? (c < 55243
              ? (c < 44032
                ? (c < 43868
                  ? (c >= 43824 && c <= 43866)
                  : (c <= 43881 || (c >= 43888 && c <= 44002)))
                : (c <= 44032 || (c < 55216
                  ? c == 55203
                  : c <= 55238)))
              : (c <= 55291 || (c < 64275
                ? (c < 64112
                  ? (c >= 63744 && c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))
                : (c <= 64279 || (c < 64287
                  ? c == 64285
                  : c <= 64296)))))
            : (c <= 64310 || (c < 64848
              ? (c < 64323
                ? (c < 64318
                  ? (c >= 64312 && c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64467
                  ? (c >= 64326 && c <= 64433)
                  : c <= 64829)))
              : (c <= 64911 || (c < 65136
                ? (c < 65008
                  ? (c >= 64914 && c <= 64967)
                  : c <= 65019)
                : (c <= 65140 || (c < 65313
                  ? (c >= 65142 && c <= 65276)
                  : c <= 65338)))))))))
        : (c <= 65370 || (c < 66928
          ? (c < 66208
            ? (c < 65549
              ? (c < 65490
                ? (c < 65474
                  ? (c >= 65382 && c <= 65470)
                  : (c <= 65479 || (c >= 65482 && c <= 65487)))
                : (c <= 65495 || (c < 65536
                  ? (c >= 65498 && c <= 65500)
                  : c <= 65547)))
              : (c <= 65574 || (c < 65616
                ? (c < 65596
                  ? (c >= 65576 && c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))
                : (c <= 65629 || (c < 66176
                  ? (c >= 65664 && c <= 65786)
                  : c <= 66204)))))
            : (c <= 66256 || (c < 66504
              ? (c < 66384
                ? (c < 66349
                  ? (c >= 66304 && c <= 66335)
                  : (c <= 66368 || (c >= 66370 && c <= 66377)))
                : (c <= 66421 || (c < 66464
                  ? (c >= 66432 && c <= 66461)
                  : c <= 66499)))
              : (c <= 66511 || (c < 66776
                ? (c < 66736
                  ? (c >= 66560 && c <= 66717)
                  : c <= 66771)
                : (c <= 66811 || (c < 66864
                  ? (c >= 66816 && c <= 66855)
                  : c <= 66915)))))))
          : (c <= 66938 || (c < 67506
            ? (c < 67003
              ? (c < 66967
                ? (c < 66956
                  ? (c >= 66940 && c <= 66954)
                  : (c <= 66962 || (c >= 66964 && c <= 66965)))
                : (c <= 66977 || (c < 66995
                  ? (c >= 66979 && c <= 66993)
                  : c <= 67001)))
              : (c <= 67004 || (c < 67424
                ? (c < 67392
                  ? (c >= 67072 && c <= 67382)
                  : c <= 67413)
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 750
            ? (c < 186
              ? (c < 'a'
                ? (c < 'A'
                  ? c == '$'
                  : (c <= 'Z' || c == '_'))
                : (c <= 'z' || (c < 181
                  ? c == 170
                  : c <= 181)))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1162
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_4(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 880
            ? (c < 192
              ? (c < 170
                ? (c < 'A'
                  ? (c >= '0' && c <= '9')
                  : (c <= 'Z' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 736
                ? (c < 248
                  ? (c >= 216 && c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 750
                  ? c == 748
                  : c <= 750)))))
            : (c <= 884 || (c < 910
              ? (c < 902
                ? (c < 890
                  ? (c >= 886 && c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 908
                  ? (c >= 904 && c <= 906)
                  : c <= 908)))
              : (c <= 929 || (c < 1162
                ? (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : c <= 1153)
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_identifier_character_set_5(int32_t c) {
  return (c < 6576
    ? (c < 2974
      ? (c < 2208
        ? (c < 1369
          ? (c < 748
            ? (c < 181
              ? (c < '_'
                ? (c < '0'
                  ? c == '$'
                  : (c <= '9' || (c >= 'A' && c <= 'Z')))
                : (c <= '_' || (c < 170
                  ? (c >= 'a' && c <= 'z')
                  : c <= 170)))
              : (c <= 181 || (c < 248
                ? (c < 192
                  ? c == 186
                  : (c <= 214 || (c >= 216 && c <= 246)))
                : (c <= 705 || (c < 736
                  ? (c >= 710 && c <= 721)
                  : c <= 740)))))
            : (c <= 748 || (c < 904
              ? (c < 890
                ? (c < 880
                  ? c == 750
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 902
                  ? c == 895
                  : c <= 902)))
              : (c <= 906 || (c < 1015
                ? (c < 910
                  ? c == 908
                  : (c <= 929 || (c >= 931 && c <= 1013)))
                : (c <= 1153 || (c < 1329
                  ? (c >= 1162 && c <= 1327)
                  : c <= 1366)))))))
          : (c <= 1369 || (c < 1869
            ? (c < 1749
              ? (c < 1568
                ? (c < 1488
                  ? (c >= 1376 && c <= 1416)
                  : (c <= 1514 || (c >= 1519 && c <= 1522)))
                : (c <= 1610 || (c < 1649
                  ? (c >= 1646 && c <= 1647)
                  : c <= 1747)))
              : (c <= 1749 || (c < 1791
                ? (c < 1774
                  ? (c >= 1765 && c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1810
                  ? c == 1808
                  : c <= 1839)))))
            : (c <= 1957 || (c < 2084
              ? (c < 2042
                ? (c < 1994
                  ? c == 1969
                  : (c <= 2026 || (c >= 2036 && c <= 2037)))
                : (c <= 2042 || (c < 2074
                  ? (c >= 2048 && c <= 2069)
                  : c <= 2074)))
              : (c <= 2084 || (c < 2144
                ? (c < 2112
                  ? c == 2088
                  : c <= 2136)
                : (c <= 2154 || (c < 2185
                  ? (c >= 2160 && c <= 2183)
                  : c <= 2190)))))))))
        : (c <= 2249 || (c < 2674
          ? (c < 2524
            ? (c < 2447
              ? (c < 2392
                ? (c < 2365
                  ? (c >= 2308 && c <= 2361)
                  : (c <= 2365 || c == 2384))
                : (c <= 2401 || (c < 2437
                  ? (c >= 2417 && c <= 2432)
                  : c <= 2444)))
              : (c <= 2448 || (c < 2486
                ? (c < 2474
                  ? (c >= 2451 && c <= 2472)
                  : (c <= 2480 || c == 2482))
                : (c <= 2489 || (c < 2510
                  ? c == 2493
                  : c <= 2510)))))
            : (c <= 2525 || (c < 2602
              ? (c < 2565
                ? (c < 2544
                  ? (c >= 2527 && c <= 2529)
                  : (c <= 2545 || c == 2556))
                : (c <= 2570 || (c < 2579
                  ? (c >= 2575 && c <= 2576)
                  : c <= 2600)))
              : (c <= 2608 || (c < 2616
                ? (c < 2613
                  ? (c >= 2610 && c <= 2611)
                  : c <= 2614)
                : (c <= 2617 || (c < 2654
                  ? (c >= 2649 && c <= 2652)
                  : c <= 2654)))))))
          : (c <= 2676 || (c < 2858
            ? (c < 2749
              ? (c < 2730
                ? (c < 2703
                  ? (c >= 2693 && c <= 2701)
                  : (c <= 2705 || (c >= 2707 && c <= 2728)))
                : (c <= 2736 || (c < 2741
                  ? (c >= 2738 && c <= 2739)
                  : c <= 2745)))
              : (c <= 2749 || (c < 2821
                ? (c < 2784
                  ? c == 2768
                  : (c <= 2785 || c == 2809))
                : (c <= 2828 || (c < 2835
                  ? (c >= 2831 && c <= 2832)
                  : c <= 2856)))))
            : (c <= 2864 || (c < 2947
              ? (c < 2908
                ? (c < 2869
                  ? (c >= 2866 && c <= 2867)
                  : (c <= 2873 || c == 2877))
                : (c <= 2909 || (c < 2929
                  ? (c >= 2911 && c <= 2913)
                  : c <= 2929)))
              : (c <= 2947 || (c < 2962
                ? (c < 2958
                  ? (c >= 2949 && c <= 2954)
                  : c <= 2960)
                : (c <= 2965 || (c < 2972
                  ? (c >= 2969 && c <= 2970)
                  : c <= 2972)))))))))))
      : (c <= 2975 || (c < 4096
        ? (c < 3406
          ? (c < 3205
            ? (c < 3090
              ? (c < 3024
                ? (c < 2984
                  ? (c >= 2979 && c <= 2980)
                  : (c <= 2986 || (c >= 2990 && c <= 3001)))
                : (c <= 3024 || (c < 3086
                  ? (c >= 3077 && c <= 3084)
                  : c <= 3088)))
              : (c <= 3112 || (c < 3165
                ? (c < 3133
                  ? (c >= 3114 && c <= 3129)
                  : (c <= 3133 || (c >= 3160 && c <= 3162)))
                : (c <= 3165 || (c < 3200
                  ? (c >= 3168 && c <= 3169)
                  : c <= 3200)))))
            : (c <= 3212 || (c < 3296
              ? (c < 3253
                ? (c < 3218
                  ? (c >= 3214 && c <= 3216)
                  : (c <= 3240 || (c >= 3242 && c <= 3251)))
                : (c <= 3257 || (c < 3293
                  ? c == 3261
                  : c <= 3294)))
              : (c <= 3297 || (c < 3342
                ? (c < 3332
                  ? (c >= 3313 && c <= 3314)
                  : c <= 3340)
                : (c <= 3344 || (c < 3389
                  ? (c >= 3346 && c <= 3386)
                  : c <= 3389)))))))
          : (c <= 3406 || (c < 3718
            ? (c < 3517
              ? (c < 3461
                ? (c < 3423
                  ? (c >= 3412 && c <= 3414)
                  : (c <= 3425 || (c >= 3450 && c <= 3455)))
                : (c <= 3478 || (c < 3507
                  ? (c >= 3482 && c <= 3505)
                  : c <= 3515)))
              : (c <= 3517 || (c < 3648
                ? (c < 3585
                  ? (c >= 3520 && c <= 3526)
                  : (c <= 3632 || (c >= 3634 && c <= 3635)))
                : (c <= 3654 || (c < 3716
                  ? (c >= 3713 && c <= 3714)
                  : c <= 3716)))))
            : (c <= 3722 || (c < 3782
              ? (c < 3762
                ? (c < 3749
                  ? (c >= 3724 && c <= 3747)
                  : (c <= 3749 || (c >= 3751 && c <= 3760)))
                : (c <= 3763 || (c < 3776
                  ? c == 3773
                  : c <= 3780)))
              : (c <= 3782 || (c < 3904
                ? (c < 3840
                  ? (c >= 3804 && c <= 3807)
                  : c <= 3840)
                : (c <= 3911 || (c < 3976
                  ? (c >= 3913 && c <= 3948)
                  : c <= 3980)))))))))
        : (c <= 4138 || (c < 4882
          ? (c < 4682
            ? (c < 4213
              ? (c < 4193
                ? (c < 4176
                  ? c == 4159
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))
                : (c <= 4193 || (c < 4206
                  ? (c >= 4197 && c <= 4198)
                  : c <= 4208)))
              : (c <= 4225 || (c < 4301
                ? (c < 4256
                  ? c == 4238
                  : (c <= 4293 || c == 4295))
                : (c <= 4301 || (c < 4348
                  ? (c >= 4304 && c <= 4346)
                  : c <= 4680)))))
            : (c <= 4685 || (c < 4786
              ? (c < 4704
                ? (c < 4696
                  ? (c >= 4688 && c <= 4694)
                  : (c <= 4696 || (c >= 4698 && c <= 4701)))
                : (c <= 4744 || (c < 4752
                  ? (c >= 4746 && c <= 4749)
                  : c <= 4784)))
              : (c <= 4789 || (c < 4802
                ? (c < 4800
                  ? (c >= 4792 && c <= 4798)
                  : c <= 4800)
                : (c <= 4805 || (c < 4824
                  ? (c >= 4808 && c <= 4822)
                  : c <= 4880)))))))
          : (c <= 4885 || (c < 5998
            ? (c < 5761
              ? (c < 5112
                ? (c < 4992
                  ? (c >= 4888 && c <= 4954)
                  : (c <= 5007 || (c >= 5024 && c <= 5109)))
                : (c <= 5117 || (c < 5743
                  ? (c >= 5121 && c <= 5740)
                  : c <= 5759)))
              : (c <= 5786 || (c < 5919
                ? (c < 5873
                  ? (c >= 5792 && c <= 5866)
                  : (c <= 5880 || (c >= 5888 && c <= 5905)))
                : (c <= 5937 || (c < 5984
                  ? (c >= 5952 && c <= 5969)
                  : c <= 5996)))))
            : (c <= 6000 || (c < 6314
              ? (c < 6176
                ? (c < 6103
                  ? (c >= 6016 && c <= 6067)
                  : (c <= 6103 || c == 6108))
                : (c <= 6264 || (c < 6279
                  ? (c >= 6272 && c <= 6276)
                  : c <= 6312)))
              : (c <= 6314 || (c < 6480
                ? (c < 6400
                  ? (c >= 6320 && c <= 6389)
                  : c <= 6430)
                : (c <= 6509 || (c < 6528
                  ? (c >= 6512 && c <= 6516)
                  : c <= 6571)))))))))))))
    : (c <= 6601 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7357
            ? (c < 7086
              ? (c < 6917
                ? (c < 6688
                  ? (c >= 6656 && c <= 6678)
                  : (c <= 6740 || c == 6823))
                : (c <= 6963 || (c < 7043
                  ? (c >= 6981 && c <= 6988)
                  : c <= 7072)))
              : (c <= 7087 || (c < 7258
                ? (c < 7168
                  ? (c >= 7098 && c <= 7141)
                  : (c <= 7203 || (c >= 7245 && c <= 7247)))
                : (c <= 7293 || (c < 7312
                  ? (c >= 7296 && c <= 7304)
                  : c <= 7354)))))
            : (c <= 7359 || (c < 7960
              ? (c < 7418
                ? (c < 7406
                  ? (c >= 7401 && c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7680
                  ? (c >= 7424 && c <= 7615)
                  : c <= 7957)))
              : (c <= 7965 || (c < 8025
                ? (c < 8008
                  ? (c >= 7968 && c <= 8005)
                  : (c <= 8013 || (c >= 8016 && c <= 8023)))
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_attr_path_character_set_1(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 880
            ? (c < 192
              ? (c < 170
                ? (c < 'A'
                  ? (c >= '.' && c <= '9')
                  : (c <= 'Z' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 736
                ? (c < 248
                  ? (c >= 216 && c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 750
                  ? c == 748
                  : c <= 750)))))
            : (c <= 884 || (c < 910
              ? (c < 902
                ? (c < 890
                  ? (c >= 886 && c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 908
                  ? (c >= 904 && c <= 906)
                  : c <= 908)))
              : (c <= 929 || (c < 1162
                ? (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : c <= 1153)
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_attr_path_character_set_2(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 750
            ? (c < 186
              ? (c < 'a'
                ? (c < '0'
                  ? c == '.'
                  : (c <= '9' || (c >= 'A' && c <= 'Z')))
                : (c <= 'z' || (c < 181
                  ? c == 170
                  : c <= 181)))
              : (c <= 186 || (c < 710
                ? (c < 216
                  ? (c >= 192 && c <= 214)
                  : (c <= 246 || (c >= 248 && c <= 705)))
                : (c <= 721 || (c < 748
                  ? (c >= 736 && c <= 740)
                  : c <= 748)))))
            : (c <= 750 || (c < 908
              ? (c < 895
                ? (c < 886
                  ? (c >= 880 && c <= 884)
                  : (c <= 887 || (c >= 890 && c <= 893)))
                : (c <= 895 || (c < 904
                  ? c == 902
                  : c <= 906)))
              : (c <= 908 || (c < 1162
                ? (c < 931
                  ? (c >= 910 && c <= 929)
                  : (c <= 1013 || (c >= 1015 && c <= 1153)))
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_attr_path_character_set_3(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 880
            ? (c < 192
              ? (c < 170
                ? (c < 'A'
                  ? c == '.'
                  : (c <= 'Z' || (c >= 'a' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 736
                ? (c < 248
                  ? (c >= 216 && c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 750
                  ? c == 748
                  : c <= 750)))))
            : (c <= 884 || (c < 910
              ? (c < 902
                ? (c < 890
                  ? (c >= 886 && c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 908
                  ? (c >= 904 && c <= 906)
                  : c <= 908)))
              : (c <= 929 || (c < 1162
                ? (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : c <= 1153)
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_attr_path_character_set_4(int32_t c) {
  return (c < 6688
    ? (c < 2984
      ? (c < 2365
        ? (c < 1488
          ? (c < 886
            ? (c < 216
              ? (c < 181
                ? (c < 'g'
                  ? (c >= 'G' && c <= 'Z')
                  : (c <= 'z' || c == 170))
                : (c <= 181 || (c < 192
                  ? c == 186
                  : c <= 214)))
              : (c <= 246 || (c < 748
                ? (c < 710
                  ? (c >= 248 && c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))
                : (c <= 748 || (c < 880
                  ? c == 750
                  : c <= 884)))))
            : (c <= 887 || (c < 931
              ? (c < 904
                ? (c < 895
                  ? (c >= 890 && c <= 893)
                  : (c <= 895 || c == 902))
                : (c <= 906 || (c < 910
                  ? c == 908
                  : c <= 929)))
              : (c <= 1013 || (c < 1329
                ? (c < 1162
                  ? (c >= 1015 && c <= 1153)
                  : c <= 1327)
                : (c <= 1366 || (c < 1376
                  ? c == 1369
                  : c <= 1416)))))))
          : (c <= 1514 || (c < 1994
            ? (c < 1774
              ? (c < 1649
                ? (c < 1568
                  ? (c >= 1519 && c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))
                : (c <= 1747 || (c < 1765
                  ? c == 1749
                  : c <= 1766)))
              : (c <= 1775 || (c < 1810
                ? (c < 1791
                  ? (c >= 1786 && c <= 1788)
                  : (c <= 1791 || c == 1808))
                : (c <= 1839 || (c < 1969
                  ? (c >= 1869 && c <= 1957)
                  : c <= 1969)))))
            : (c <= 2026 || (c < 2112
              ? (c < 2074
                ? (c < 2042
                  ? (c >= 2036 && c <= 2037)
                  : (c <= 2042 || (c >= 2048 && c <= 2069)))
                : (c <= 2074 || (c < 2088
                  ? c == 2084
                  : c <= 2088)))
              : (c <= 2136 || (c < 2185
                ? (c < 2160
                  ? (c >= 2144 && c <= 2154)
                  : c <= 2183)
                : (c <= 2190 || (c < 2308
                  ? (c >= 2208 && c <= 2249)
                  : c <= 2361)))))))))
        : (c <= 2365 || (c < 2703
          ? (c < 2544
            ? (c < 2474
              ? (c < 2437
                ? (c < 2392
                  ? c == 2384
                  : (c <= 2401 || (c >= 2417 && c <= 2432)))
                : (c <= 2444 || (c < 2451
                  ? (c >= 2447 && c <= 2448)
                  : c <= 2472)))
              : (c <= 2480 || (c < 2510
                ? (c < 2486
                  ? c == 2482
                  : (c <= 2489 || c == 2493))
                : (c <= 2510 || (c < 2527
                  ? (c >= 2524 && c <= 2525)
                  : c <= 2529)))))
            : (c <= 2545 || (c < 2613
              ? (c < 2579
                ? (c < 2565
                  ? c == 2556
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))
                : (c <= 2600 || (c < 2610
                  ? (c >= 2602 && c <= 2608)
                  : c <= 2611)))
              : (c <= 2614 || (c < 2654
                ? (c < 2649
                  ? (c >= 2616 && c <= 2617)
                  : c <= 2652)
                : (c <= 2654 || (c < 2693
                  ? (c >= 2674 && c <= 2676)
                  : c <= 2701)))))))
          : (c <= 2705 || (c < 2869
            ? (c < 2784
              ? (c < 2741
                ? (c < 2730
                  ? (c >= 2707 && c <= 2728)
                  : (c <= 2736 || (c >= 2738 && c <= 2739)))
                : (c <= 2745 || (c < 2768
                  ? c == 2749
                  : c <= 2768)))
              : (c <= 2785 || (c < 2835
                ? (c < 2821
                  ? c == 2809
                  : (c <= 2828 || (c >= 2831 && c <= 2832)))
                : (c <= 2856 || (c < 2866
                  ? (c >= 2858 && c <= 2864)
                  : c <= 2867)))))
            : (c <= 2873 || (c < 2958
              ? (c < 2929
                ? (c < 2908
                  ? c == 2877
                  : (c <= 2909 || (c >= 2911 && c <= 2913)))
                : (c <= 2929 || (c < 2949
                  ? c == 2947
                  : c <= 2954)))
              : (c <= 2960 || (c < 2972
                ? (c < 2969
                  ? (c >= 2962 && c <= 2965)
                  : c <= 2970)
                : (c <= 2972 || (c < 2979
                  ? (c >= 2974 && c <= 2975)
                  : c <= 2980)))))))))))
      : (c <= 2986 || (c < 4176
        ? (c < 3423
          ? (c < 3218
            ? (c < 3133
              ? (c < 3086
                ? (c < 3024
                  ? (c >= 2990 && c <= 3001)
                  : (c <= 3024 || (c >= 3077 && c <= 3084)))
                : (c <= 3088 || (c < 3114
                  ? (c >= 3090 && c <= 3112)
                  : c <= 3129)))
              : (c <= 3133 || (c < 3200
                ? (c < 3165
                  ? (c >= 3160 && c <= 3162)
                  : (c <= 3165 || (c >= 3168 && c <= 3169)))
                : (c <= 3200 || (c < 3214
                  ? (c >= 3205 && c <= 3212)
                  : c <= 3216)))))
            : (c <= 3240 || (c < 3332
              ? (c < 3293
                ? (c < 3253
                  ? (c >= 3242 && c <= 3251)
                  : (c <= 3257 || c == 3261))
                : (c <= 3294 || (c < 3313
                  ? (c >= 3296 && c <= 3297)
                  : c <= 3314)))
              : (c <= 3340 || (c < 3389
                ? (c < 3346
                  ? (c >= 3342 && c <= 3344)
                  : c <= 3386)
                : (c <= 3389 || (c < 3412
                  ? c == 3406
                  : c <= 3414)))))))
          : (c <= 3425 || (c < 3749
            ? (c < 3585
              ? (c < 3507
                ? (c < 3461
                  ? (c >= 3450 && c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3520
                  ? c == 3517
                  : c <= 3526)))
              : (c <= 3632 || (c < 3716
                ? (c < 3648
                  ? (c >= 3634 && c <= 3635)
                  : (c <= 3654 || (c >= 3713 && c <= 3714)))
                : (c <= 3716 || (c < 3724
                  ? (c >= 3718 && c <= 3722)
                  : c <= 3747)))))
            : (c <= 3749 || (c < 3840
              ? (c < 3776
                ? (c < 3762
                  ? (c >= 3751 && c <= 3760)
                  : (c <= 3763 || c == 3773))
                : (c <= 3780 || (c < 3804
                  ? c == 3782
                  : c <= 3807)))
              : (c <= 3840 || (c < 3976
                ? (c < 3913
                  ? (c >= 3904 && c <= 3911)
                  : c <= 3948)
                : (c <= 3980 || (c < 4159
                  ? (c >= 4096 && c <= 4138)
                  : c <= 4159)))))))))
        : (c <= 4181 || (c < 4992
          ? (c < 4696
            ? (c < 4256
              ? (c < 4206
                ? (c < 4193
                  ? (c >= 4186 && c <= 4189)
                  : (c <= 4193 || (c >= 4197 && c <= 4198)))
                : (c <= 4208 || (c < 4238
                  ? (c >= 4213 && c <= 4225)
                  : c <= 4238)))
              : (c <= 4293 || (c < 4348
                ? (c < 4301
                  ? c == 4295
                  : (c <= 4301 || (c >= 4304 && c <= 4346)))
                : (c <= 4680 || (c < 4688
                  ? (c >= 4682 && c <= 4685)
                  : c <= 4694)))))
            : (c <= 4696 || (c < 4800
              ? (c < 4752
                ? (c < 4704
                  ? (c >= 4698 && c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4792
                  ? (c >= 4786 && c <= 4789)
                  : c <= 4798)))
              : (c <= 4800 || (c < 4824
                ? (c < 4808
                  ? (c >= 4802 && c <= 4805)
                  : c <= 4822)
                : (c <= 4880 || (c < 4888
                  ? (c >= 4882 && c <= 4885)
                  : c <= 4954)))))))
          : (c <= 5007 || (c < 6103
            ? (c < 5873
              ? (c < 5743
                ? (c < 5112
                  ? (c >= 5024 && c <= 5109)
                  : (c <= 5117 || (c >= 5121 && c <= 5740)))
                : (c <= 5759 || (c < 5792
                  ? (c >= 5761 && c <= 5786)
                  : c <= 5866)))
              : (c <= 5880 || (c < 5984
                ? (c < 5919
                  ? (c >= 5888 && c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6016
                  ? (c >= 5998 && c <= 6000)
                  : c <= 6067)))))
            : (c <= 6103 || (c < 6400
              ? (c < 6279
                ? (c < 6176
                  ? c == 6108
                  : (c <= 6264 || (c >= 6272 && c <= 6276)))
                : (c <= 6312 || (c < 6320
                  ? c == 6314
                  : c <= 6389)))
              : (c <= 6430 || (c < 6528
                ? (c < 6512
                  ? (c >= 6480 && c <= 6509)
                  : c <= 6516)
                : (c <= 6571 || (c < 6656
                  ? (c >= 6576 && c <= 6601)
                  : c <= 6678)))))))))))))
    : (c <= 6740 || (c < 43261
      ? (c < 11264
        ? (c < 8064
          ? (c < 7406
            ? (c < 7168
              ? (c < 7043
                ? (c < 6917
                  ? c == 6823
                  : (c <= 6963 || (c >= 6981 && c <= 6988)))
                : (c <= 7072 || (c < 7098
                  ? (c >= 7086 && c <= 7087)
                  : c <= 7141)))
              : (c <= 7203 || (c < 7312
                ? (c < 7258
                  ? (c >= 7245 && c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))
                : (c <= 7354 || (c < 7401
                  ? (c >= 7357 && c <= 7359)
                  : c <= 7404)))))
            : (c <= 7411 || (c < 8008
              ? (c < 7680
                ? (c < 7418
                  ? (c >= 7413 && c <= 7414)
                  : (c <= 7418 || (c >= 7424 && c <= 7615)))
                : (c <= 7957 || (c < 7968
                  ? (c >= 7960 && c <= 7965)
                  : c <= 8005)))
              : (c <= 8013 || (c < 8027
                ? (c < 8025
                  ? (c >= 8016 && c <= 8023)
                  : c <= 8025)
                : (c <= 8027 || (c < 8031
                  ? c == 8029
                  : c <= 8061)))))))
          : (c <= 8116 || (c < 8455
            ? (c < 8160
              ? (c < 8134
                ? (c < 8126
                  ? (c >= 8118 && c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))
                : (c <= 8140 || (c < 8150
                  ? (c >= 8144 && c <= 8147)
                  : c <= 8155)))
              : (c <= 8172 || (c < 8319
                ? (c < 8182
                  ? (c >= 8178 && c <= 8180)
                  : (c <= 8188 || c == 8305))
                : (c <= 8319 || (c < 8450
                  ? (c >= 8336 && c <= 8348)
                  : c <= 8450)))))
            : (c <= 8455 || (c < 8490
              ? (c < 8484
                ? (c < 8469
                  ? (c >= 8458 && c <= 8467)
                  : (c <= 8469 || (c >= 8473 && c <= 8477)))
                : (c <= 8484 || (c < 8488
                  ? c == 8486
                  : c <= 8488)))
              : (c <= 8493 || (c < 8517
                ? (c < 8508
                  ? (c >= 8495 && c <= 8505)
                  : c <= 8511)
                : (c <= 8521 || (c < 8579
                  ? c == 8526
                  : c <= 8580)))))))))
        : (c <= 11492 || (c < 12704
          ? (c < 11720
            ? (c < 11631
              ? (c < 11559
                ? (c < 11506
                  ? (c >= 11499 && c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11568
                  ? c == 11565
                  : c <= 11623)))
              : (c <= 11631 || (c < 11696
                ? (c < 11680
                  ? (c >= 11648 && c <= 11670)
                  : (c <= 11686 || (c >= 11688 && c <= 11694)))
                : (c <= 11702 || (c < 11712
                  ? (c >= 11704 && c <= 11710)
                  : c <= 11718)))))
            : (c <= 11726 || (c < 12353
              ? (c < 12293
                ? (c < 11736
                  ? (c >= 11728 && c <= 11734)
                  : (c <= 11742 || c == 11823))
                : (c <= 12294 || (c < 12347
                  ? (c >= 12337 && c <= 12341)
                  : c <= 12348)))
              : (c <= 12438 || (c < 12540
                ? (c < 12449
                  ? (c >= 12445 && c <= 12447)
                  : c <= 12538)
                : (c <= 12543 || (c < 12593
                  ? (c >= 12549 && c <= 12591)
                  : c <= 12686)))))))
          : (c <= 12735 || (c < 42786
            ? (c < 42240
              ? (c < 19968
                ? (c < 13312
                  ? (c >= 12784 && c <= 12799)
                  : (c <= 13312 || c == 19903))
                : (c <= 19968 || (c < 42192
                  ? (c >= 40959 && c <= 42124)
                  : c <= 42237)))
              : (c <= 42508 || (c < 42623
                ? (c < 42538
                  ? (c >= 42512 && c <= 42527)
                  : (c <= 42539 || (c >= 42560 && c <= 42606)))
                : (c <= 42653 || (c < 42775
                  ? (c >= 42656 && c <= 42725)
                  : c <= 42783)))))
            : (c <= 42888 || (c < 43015
              ? (c < 42965
                ? (c < 42960
                  ? (c >= 42891 && c <= 42954)
                  : (c <= 42961 || c == 42963))
                : (c <= 42969 || (c < 43011
                  ? (c >= 42994 && c <= 43009)
                  : c <= 43013)))
              : (c <= 43018 || (c < 43138
                ? (c < 43072
                  ? (c >= 43020 && c <= 43042)
                  : c <= 43123)
                : (c <= 43187 || (c < 43259
                  ? (c >= 43250 && c <= 43255)
                  : c <= 43259)))))))))))
      : (c <= 43262 || (c < 65345
        ? (c < 43816
          ? (c < 43646
            ? (c < 43494
              ? (c < 43396
                ? (c < 43312
                  ? (c >= 43274 && c <= 43301)
                  : (c <= 43334 || (c >= 43360 && c <= 43388)))
                : (c <= 43442 || (c < 43488
                  ? c == 43471
                  : c <= 43492)))
              : (c <= 43503 || (c < 43588
                ? (c < 43520
                  ? (c >= 43514 && c <= 43518)
                  : (c <= 43560 || (c >= 43584 && c <= 43586)))
                : (c <= 43595 || (c < 43642
                  ? (c >= 43616 && c <= 43638)
                  : c <= 43642)))))
            : (c <= 43695 || (c < 43744
              ? (c < 43712
                ? (c < 43701
                  ? c == 43697
                  : (c <= 43702 || (c >= 43705 && c <= 43709)))
                : (c <= 43712 || (c < 43739
                  ? c == 43714
                  : c <= 43741)))
              : (c <= 43754 || (c < 43785
                ? (c < 43777
                  ? (c >= 43762 && c <= 43764)
                  : c <= 43782)
                : (c <= 43790 || (c < 43808
                  ? (c >= 43793 && c <= 43798)
                  : c <= 43814)))))))
          : (c <= 43822 || (c < 64298
            ? (c < 55243
              ? (c < 44032
                ? (c < 43868
                  ? (c >= 43824 && c <= 43866)
                  : (c <= 43881 || (c >= 43888 && c <= 44002)))
                : (c <= 44032 || (c < 55216
                  ? c == 55203
                  : c <= 55238)))
              : (c <= 55291 || (c < 64275
                ? (c < 64112
                  ? (c >= 63744 && c <= 64109)
                  : (c <= 64217 || (c >= 64256 && c <= 64262)))
                : (c <= 64279 || (c < 64287
                  ? c == 64285
                  : c <= 64296)))))
            : (c <= 64310 || (c < 64848
              ? (c < 64323
                ? (c < 64318
                  ? (c >= 64312 && c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64467
                  ? (c >= 64326 && c <= 64433)
                  : c <= 64829)))
              : (c <= 64911 || (c < 65136
                ? (c < 65008
                  ? (c >= 64914 && c <= 64967)
                  : c <= 65019)
                : (c <= 65140 || (c < 65313
                  ? (c >= 65142 && c <= 65276)
                  : c <= 65338)))))))))
        : (c <= 65370 || (c < 66928
          ? (c < 66208
            ? (c < 65549
              ? (c < 65490
                ? (c < 65474
                  ? (c >= 65382 && c <= 65470)
                  : (c <= 65479 || (c >= 65482 && c <= 65487)))
                : (c <= 65495 || (c < 65536
                  ? (c >= 65498 && c <= 65500)
                  : c <= 65547)))
              : (c <= 65574 || (c < 65616
                ? (c < 65596
                  ? (c >= 65576 && c <= 65594)
                  : (c <= 65597 || (c >= 65599 && c <= 65613)))
                : (c <= 65629 || (c < 66176
                  ? (c >= 65664 && c <= 65786)
                  : c <= 66204)))))
            : (c <= 66256 || (c < 66504
              ? (c < 66384
                ? (c < 66349
                  ? (c >= 66304 && c <= 66335)
                  : (c <= 66368 || (c >= 66370 && c <= 66377)))
                : (c <= 66421 || (c < 66464
                  ? (c >= 66432 && c <= 66461)
                  : c <= 66499)))
              : (c <= 66511 || (c < 66776
                ? (c < 66736
                  ? (c >= 66560 && c <= 66717)
                  : c <= 66771)
                : (c <= 66811 || (c < 66864
                  ? (c >= 66816 && c <= 66855)
                  : c <= 66915)))))))
          : (c <= 66938 || (c < 67506
            ? (c < 67003
              ? (c < 66967
                ? (c < 66956
                  ? (c >= 66940 && c <= 66954)
                  : (c <= 66962 || (c >= 66964 && c <= 66965)))
                : (c <= 66977 || (c < 66995
                  ? (c >= 66979 && c <= 66993)
                  : c <= 67001)))
              : (c <= 67004 || (c < 67424
                ? (c < 67392
                  ? (c >= 67072 && c <= 67382)
                  : c <= 67413)
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_attr_path_character_set_5(int32_t c) {
  return (c < 6656
    ? (c < 2979
      ? (c < 2308
        ? (c < 1376
          ? (c < 880
            ? (c < 192
              ? (c < 170
                ? (c < 'G'
                  ? c == '.'
                  : (c <= 'Z' || (c >= 'g' && c <= 'z')))
                : (c <= 170 || (c < 186
                  ? c == 181
                  : c <= 186)))
              : (c <= 214 || (c < 736
                ? (c < 248
                  ? (c >= 216 && c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))
                : (c <= 740 || (c < 750
                  ? c == 748
                  : c <= 750)))))
            : (c <= 884 || (c < 910
              ? (c < 902
                ? (c < 890
                  ? (c >= 886 && c <= 887)
                  : (c <= 893 || c == 895))
                : (c <= 902 || (c < 908
                  ? (c >= 904 && c <= 906)
                  : c <= 908)))
              : (c <= 929 || (c < 1162
                ? (c < 1015
                  ? (c >= 931 && c <= 1013)
                  : c <= 1153)
                : (c <= 1327 || (c < 1369
                  ? (c >= 1329 && c <= 1366)
                  : c <= 1369)))))))
          : (c <= 1416 || (c < 1969
            ? (c < 1765
              ? (c < 1646
                ? (c < 1519
                  ? (c >= 1488 && c <= 1514)
                  : (c <= 1522 || (c >= 1568 && c <= 1610)))
                : (c <= 1647 || (c < 1749
                  ? (c >= 1649 && c <= 1747)
                  : c <= 1749)))
              : (c <= 1766 || (c < 1808
                ? (c < 1786
                  ? (c >= 1774 && c <= 1775)
                  : (c <= 1788 || c == 1791))
                : (c <= 1808 || (c < 1869
                  ? (c >= 1810 && c <= 1839)
                  : c <= 1957)))))
            : (c <= 1969 || (c < 2088
              ? (c < 2048
                ? (c < 2036
                  ? (c >= 1994 && c <= 2026)
                  : (c <= 2037 || c == 2042))
                : (c <= 2069 || (c < 2084
                  ? c == 2074
                  : c <= 2084)))
              : (c <= 2088 || (c < 2160
                ? (c < 2144
                  ? (c >= 2112 && c <= 2136)
                  : c <= 2154)
                : (c <= 2183 || (c < 2208
                  ? (c >= 2185 && c <= 2190)
                  : c <= 2249)))))))))
        : (c <= 2361 || (c < 2693
          ? (c < 2527
            ? (c < 2451
              ? (c < 2417
                ? (c < 2384
                  ? c == 2365
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2447
                  ? (c >= 2437 && c <= 2444)
                  : c <= 2448)))
              : (c <= 2472 || (c < 2493
                ? (c < 2482
                  ? (c >= 2474 && c <= 2480)
                  : (c <= 2482 || (c >= 2486 && c <= 2489)))
                : (c <= 2493 || (c < 2524
                  ? c == 2510
                  : c <= 2525)))))
            : (c <= 2529 || (c < 2610
              ? (c < 2575
                ? (c < 2556
                  ? (c >= 2544 && c <= 2545)
                  : (c <= 2556 || (c >= 2565 && c <= 2570)))
                : (c <= 2576 || (c < 2602
                  ? (c >= 2579 && c <= 2600)
                  : c <= 2608)))
              : (c <= 2611 || (c < 2649
                ? (c < 2616
                  ? (c >= 2613 && c <= 2614)
                  : c <= 2617)
                : (c <= 2652 || (c < 2674
                  ? c == 2654
                  : c <= 2676)))))))
          : (c <= 2701 || (c < 2866
            ? (c < 2768
              ? (c < 2738
                ? (c < 2707
                  ? (c >= 2703 && c <= 2705)
                  : (c <= 2728 || (c >= 2730 && c <= 2736)))
                : (c <= 2739 || (c < 2749
                  ? (c >= 2741 && c <= 2745)
                  : c <= 2749)))
              : (c <= 2768 || (c < 2831
                ? (c < 2809
                  ? (c >= 2784 && c <= 2785)
                  : (c <= 2809 || (c >= 2821 && c <= 2828)))
                : (c <= 2832 || (c < 2858
                  ? (c >= 2835 && c <= 2856)
                  : c <= 2864)))))
            : (c <= 2867 || (c < 2949
              ? (c < 2911
                ? (c < 2877
                  ? (c >= 2869 && c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2947
                  ? c == 2929
                  : c <= 2947)))
              : (c <= 2954 || (c < 2969
                ? (c < 2962
                  ? (c >= 2958 && c <= 2960)
                  : c <= 2965)
                : (c <= 2970 || (c < 2974
                  ? c == 2972
                  : c <= 2975)))))))))))
      : (c <= 2980 || (c < 4159
        ? (c < 3412
          ? (c < 3214
            ? (c < 3114
              ? (c < 3077
                ? (c < 2990
                  ? (c >= 2984 && c <= 2986)
                  : (c <= 3001 || c == 3024))
                : (c <= 3084 || (c < 3090
                  ? (c >= 3086 && c <= 3088)
                  : c <= 3112)))
              : (c <= 3129 || (c < 3168
                ? (c < 3160
                  ? c == 3133
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3205
                  ? c == 3200
                  : c <= 3212)))))
            : (c <= 3216 || (c < 3313
              ? (c < 3261
                ? (c < 3242
                  ? (c >= 3218 && c <= 3240)
                  : (c <= 3251 || (c >= 3253 && c <= 3257)))
                : (c <= 3261 || (c < 3296
                  ? (c >= 3293 && c <= 3294)
                  : c <= 3297)))
              : (c <= 3314 || (c < 3346
                ? (c < 3342
                  ? (c >= 3332 && c <= 3340)
                  : c <= 3344)
                : (c <= 3386 || (c < 3406
                  ? c == 3389
                  : c <= 3406)))))))
          : (c <= 3414 || (c < 3724
            ? (c < 3520
              ? (c < 3482
                ? (c < 3450
                  ? (c >= 3423 && c <= 3425)
                  : (c <= 3455 || (c >= 3461 && c <= 3478)))
                : (c <= 3505 || (c < 3517
                  ? (c >= 3507 && c <= 3515)
                  : c <= 3517)))
              : (c <= 3526 || (c < 3713
                ? (c < 3634
                  ? (c >= 3585 && c <= 3632)
                  : (c <= 3635 || (c >= 3648 && c <= 3654)))
                : (c <= 3714 || (c < 3718
                  ? c == 3716
                  : c <= 3722)))))
            : (c <= 3747 || (c < 3804
              ? (c < 3773
                ? (c < 3751
                  ? c == 3749
                  : (c <= 3760 || (c >= 3762 && c <= 3763)))
                : (c <= 3773 || (c < 3782
                  ? (c >= 3776 && c <= 3780)
                  : c <= 3782)))
              : (c <= 3807 || (c < 3913
                ? (c < 3904
                  ? c == 3840
                  : c <= 3911)
                : (c <= 3948 || (c < 4096
                  ? (c >= 3976 && c <= 3980)
                  : c <= 4138)))))))))
        : (c <= 4159 || (c < 4888
          ? (c < 4688
            ? (c < 4238
              ? (c < 4197
                ? (c < 4186
                  ? (c >= 4176 && c <= 4181)
                  : (c <= 4189 || c == 4193))
                : (c <= 4198 || (c < 4213
                  ? (c >= 4206 && c <= 4208)
                  : c <= 4225)))
              : (c <= 4238 || (c < 4304
                ? (c < 4295
                  ? (c >= 4256 && c <= 4293)
                  : (c <= 4295 || c == 4301))
                : (c <= 4346 || (c < 4682
                  ? (c >= 4348 && c <= 4680)
                  : c <= 4685)))))
            : (c <= 4694 || (c < 4792
              ? (c < 4746
                ? (c < 4698
                  ? c == 4696
                  : (c <= 4701 || (c >= 4704 && c <= 4744)))
                : (c <= 4749 || (c < 4786
                  ? (c >= 4752 && c <= 4784)
                  : c <= 4789)))
              : (c <= 4798 || (c < 4808
                ? (c < 4802
                  ? c == 4800
                  : c <= 4805)
                : (c <= 4822 || (c < 4882
                  ? (c >= 4824 && c <= 4880)
                  : c <= 4885)))))))
          : (c <= 4954 || (c < 6016
            ? (c < 5792
              ? (c < 5121
                ? (c < 5024
                  ? (c >= 4992 && c <= 5007)
                  : (c <= 5109 || (c >= 5112 && c <= 5117)))
                : (c <= 5740 || (c < 5761
                  ? (c >= 5743 && c <= 5759)
                  : c <= 5786)))
              : (c <= 5866 || (c < 5952
                ? (c < 5888
                  ? (c >= 5873 && c <= 5880)
                  : (c <= 5905 || (c >= 5919 && c <= 5937)))
                : (c <= 5969 || (c < 5998
                  ? (c >= 5984 && c <= 5996)
                  : c <= 6000)))))
            : (c <= 6067 || (c < 6320
              ? (c < 6272
                ? (c < 6108
                  ? c == 6103
                  : (c <= 6108 || (c >= 6176 && c <= 6264)))
                : (c <= 6276 || (c < 6314
                  ? (c >= 6279 && c <= 6312)
                  : c <= 6314)))
              : (c <= 6389 || (c < 6512
                ? (c < 6480
                  ? (c >= 6400 && c <= 6430)
                  : c <= 6509)
                : (c <= 6516 || (c < 6576
                  ? (c >= 6528 && c <= 6571)
                  : c <= 6601)))))))))))))
    : (c <= 6678 || (c < 43259
      ? (c < 8579
        ? (c < 8031
          ? (c < 7401
            ? (c < 7098
              ? (c < 6981
                ? (c < 6823
                  ? (c >= 6688 && c <= 6740)
                  : (c <= 6823 || (c >= 6917 && c <= 6963)))
                : (c <= 6988 || (c < 7086
                  ? (c >= 7043 && c <= 7072)
                  : c <= 7087)))
              : (c <= 7141 || (c < 7296
                ? (c < 7245
                  ? (c >= 7168 && c <= 7203)
                  : (c <= 7247 || (c >= 7258 && c <= 7293)))
                : (c <= 7304 || (c < 7357
                  ? (c >= 7312 && c <= 7354)
                  : c <= 7359)))))
            : (c <= 7404 || (c < 7968
              ? (c < 7424
                ? (c < 7413
                  ? (c >= 7406 && c <= 7411)
                  : (c <= 7414 || c == 7418))
                : (c <= 7615 || (c < 7960
                  ? (c >= 7680 && c <= 7957)
                  : c <= 7965)))
              : (c <= 8005 || (c < 8025
                ? (c < 8016
                  ? (c >= 8008 && c <= 8013)
                  : c <= 8023)
                : (c <= 8025 || (c < 8029
                  ? c == 8027
                  : c <= 8029)))))))
          : (c <= 8061 || (c < 8450
            ? (c < 8150
              ? (c < 8130
                ? (c < 8118
                  ? (c >= 8064 && c <= 8116)
                  : (c <= 8124 || c == 8126))
                : (c <= 8132 || (c < 8144
                  ? (c >= 8134 && c <= 8140)
                  : c <= 8147)))
              : (c <= 8155 || (c < 8305
                ? (c < 8178
                  ? (c >= 8160 && c <= 8172)
                  : (c <= 8180 || (c >= 8182 && c <= 8188)))
                : (c <= 8305 || (c < 8336
                  ? c == 8319
                  : c <= 8348)))))
            : (c <= 8450 || (c < 8488
              ? (c < 8473
                ? (c < 8458
                  ? c == 8455
                  : (c <= 8467 || c == 8469))
                : (c <= 8477 || (c < 8486
                  ? c == 8484
                  : c <= 8486)))
              : (c <= 8488 || (c < 8508
                ? (c < 8495
                  ? (c >= 8490 && c <= 8493)
                  : c <= 8505)
                : (c <= 8511 || (c < 8526
                  ? (c >= 8517 && c <= 8521)
                  : c <= 8526)))))))))
        : (c <= 8580 || (c < 12593
          ? (c < 11712
            ? (c < 11568
              ? (c < 11520
                ? (c < 11499
                  ? (c >= 11264 && c <= 11492)
                  : (c <= 11502 || (c >= 11506 && c <= 11507)))
                : (c <= 11557 || (c < 11565
                  ? c == 11559
                  : c <= 11565)))
              : (c <= 11623 || (c < 11688
                ? (c < 11648
                  ? c == 11631
                  : (c <= 11670 || (c >= 11680 && c <= 11686)))
                : (c <= 11694 || (c < 11704
                  ? (c >= 11696 && c <= 11702)
                  : c <= 11710)))))
            : (c <= 11718 || (c < 12347
              ? (c < 11823
                ? (c < 11728
                  ? (c >= 11720 && c <= 11726)
                  : (c <= 11734 || (c >= 11736 && c <= 11742)))
                : (c <= 11823 || (c < 12337
                  ? (c >= 12293 && c <= 12294)
                  : c <= 12341)))
              : (c <= 12348 || (c < 12449
                ? (c < 12445
                  ? (c >= 12353 && c <= 12438)
                  : c <= 12447)
                : (c <= 12538 || (c < 12549
                  ? (c >= 12540 && c <= 12543)
                  : c <= 12591)))))))
          : (c <= 12686 || (c < 42775
            ? (c < 42192
              ? (c < 19903
                ? (c < 12784
                  ? (c >= 12704 && c <= 12735)
                  : (c <= 12799 || c == 13312))
                : (c <= 19903 || (c < 40959
                  ? c == 19968
                  : c <= 42124)))
              : (c <= 42237 || (c < 42560
                ? (c < 42512
                  ? (c >= 42240 && c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42656
                  ? (c >= 42623 && c <= 42653)
                  : c <= 42725)))))
            : (c <= 42783 || (c < 43011
              ? (c < 42963
                ? (c < 42891
                  ? (c >= 42786 && c <= 42888)
                  : (c <= 42954 || (c >= 42960 && c <= 42961)))
                : (c <= 42963 || (c < 42994
                  ? (c >= 42965 && c <= 42969)
                  : c <= 43009)))
              : (c <= 43013 || (c < 43072
                ? (c < 43020
                  ? (c >= 43015 && c <= 43018)
                  : c <= 43042)
                : (c <= 43123 || (c < 43250
                  ? (c >= 43138 && c <= 43187)
                  : c <= 43255)))))))))))
      : (c <= 43259 || (c < 65313
        ? (c < 43808
          ? (c < 43642
            ? (c < 43488
              ? (c < 43360
                ? (c < 43274
                  ? (c >= 43261 && c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43471
                  ? (c >= 43396 && c <= 43442)
                  : c <= 43471)))
              : (c <= 43492 || (c < 43584
                ? (c < 43514
                  ? (c >= 43494 && c <= 43503)
                  : (c <= 43518 || (c >= 43520 && c <= 43560)))
                : (c <= 43586 || (c < 43616
                  ? (c >= 43588 && c <= 43595)
                  : c <= 43638)))))
            : (c <= 43642 || (c < 43739
              ? (c < 43705
                ? (c < 43697
                  ? (c >= 43646 && c <= 43695)
                  : (c <= 43697 || (c >= 43701 && c <= 43702)))
                : (c <= 43709 || (c < 43714
                  ? c == 43712
                  : c <= 43714)))
              : (c <= 43741 || (c < 43777
                ? (c < 43762
                  ? (c >= 43744 && c <= 43754)
                  : c <= 43764)
                : (c <= 43782 || (c < 43793
                  ? (c >= 43785 && c <= 43790)
                  : c <= 43798)))))))
          : (c <= 43814 || (c < 64287
            ? (c < 55216
              ? (c < 43888
                ? (c < 43824
                  ? (c >= 43816 && c <= 43822)
                  : (c <= 43866 || (c >= 43868 && c <= 43881)))
                : (c <= 44002 || (c < 55203
                  ? c == 44032
                  : c <= 55203)))
              : (c <= 55238 || (c < 64256
                ? (c < 63744
                  ? (c >= 55243 && c <= 55291)
                  : (c <= 64109 || (c >= 64112 && c <= 64217)))
                : (c <= 64262 || (c < 64285
                  ? (c >= 64275 && c <= 64279)
                  : c <= 64285)))))
            : (c <= 64296 || (c < 64467
              ? (c < 64320
                ? (c < 64312
                  ? (c >= 64298 && c <= 64310)
                  : (c <= 64316 || c == 64318))
                : (c <= 64321 || (c < 64326
                  ? (c >= 64323 && c <= 64324)
                  : c <= 64433)))
              : (c <= 64829 || (c < 65008
                ? (c < 64914
                  ? (c >= 64848 && c <= 64911)
                  : c <= 64967)
                : (c <= 65019 || (c < 65142
                  ? (c >= 65136 && c <= 65140)
                  : c <= 65276)))))))))
        : (c <= 65338 || (c < 66864
          ? (c < 66176
            ? (c < 65536
              ? (c < 65482
                ? (c < 65382
                  ? (c >= 65345 && c <= 65370)
                  : (c <= 65470 || (c >= 65474 && c <= 65479)))
                : (c <= 65487 || (c < 65498
                  ? (c >= 65490 && c <= 65495)
                  : c <= 65500)))
              : (c <= 65547 || (c < 65599
                ? (c < 65576
                  ? (c >= 65549 && c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))
                : (c <= 65613 || (c < 65664
                  ? (c >= 65616 && c <= 65629)
                  : c <= 65786)))))
            : (c <= 66204 || (c < 66464
              ? (c < 66370
                ? (c < 66304
                  ? (c >= 66208 && c <= 66256)
                  : (c <= 66335 || (c >= 66349 && c <= 66368)))
                : (c <= 66377 || (c < 66432
                  ? (c >= 66384 && c <= 66421)
                  : c <= 66461)))
              : (c <= 66499 || (c < 66736
                ? (c < 66560
                  ? (c >= 66504 && c <= 66511)
                  : c <= 66717)
                : (c <= 66771 || (c < 66816
                  ? (c >= 66776 && c <= 66811)
                  : c <= 66855)))))))
          : (c <= 66915 || (c < 67506
            ? (c < 66995
              ? (c < 66964
                ? (c < 66940
                  ? (c >= 66928 && c <= 66938)
                  : (c <= 66954 || (c >= 66956 && c <= 66962)))
                : (c <= 66965 || (c < 66979
                  ? (c >= 66967 && c <= 66977)
                  : c <= 66993)))
              : (c <= 67001 || (c < 67424
                ? (c < 67072
                  ? (c >= 67003 && c <= 67004)
                  : (c <= 67382 || (c >= 67392 && c <= 67413)))
                : (c <= 67431 || (c < 67463
                  ? (c >= 67456 && c <= 67461)
                  : c <= 67504)))))
            : (c <= 67514 || (c < 67680
              ? (c < 67639
                ? (c < 67592
                  ? (c >= 67584 && c <= 67589)
                  : (c <= 67592 || (c >= 67594 && c <= 67637)))
                : (c <= 67640 || (c < 67647
                  ? c == 67644
                  : c <= 67669)))
              : (c <= 67702 || (c < 67828
                ? (c < 67808
                  ? (c >= 67712 && c <= 67742)
                  : c <= 67826)
                : (c <= 67829 || (c < 67872
                  ? (c >= 67840 && c <= 67861)
                  : c <= 67883)))))))))))))));
}

static inline bool sym_escape_char_character_set_1(int32_t c) {
  return (c < 'f'
    ? (c < '/'
      ? (c < '\''
        ? c == '"'
        : c <= '\'')
      : (c <= '/' || (c < 'a'
        ? c == '\\'
        : c <= 'b')))
    : (c <= 'f' || (c < 't'
      ? (c < 'r'
        ? c == 'n'
        : c <= 'r')
      : (c <= 't' || c == 'v'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(80);
      if (lookahead == '!') ADVANCE(147);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '&') ADVANCE(154);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(151);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == ':') ADVANCE(149);
      if (lookahead == '<') ADVANCE(101);
      if (lookahead == '=') ADVANCE(105);
      if (lookahead == '>') ADVANCE(103);
      if (lookahead == '?') ADVANCE(148);
      if (lookahead == '@') ADVANCE(93);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '\\') ADVANCE(62);
      if (lookahead == ']') ADVANCE(97);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '|') ADVANCE(153);
      if (lookahead == '}') ADVANCE(99);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(78)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(33)
      if (lookahead == '\'') ADVANCE(185);
      if (lookahead == '/') ADVANCE(188);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(187);
      if (lookahead != 0) ADVANCE(189);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(23)
      if (lookahead == '"') ADVANCE(180);
      if (lookahead == '/') ADVANCE(183);
      if (lookahead == '\\') ADVANCE(60);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(182);
      if (lookahead != 0) ADVANCE(184);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(147);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(151);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(176);
      if (lookahead == '/') ADVANCE(40);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == ':') ADVANCE(149);
      if (lookahead == '<') ADVANCE(101);
      if (lookahead == '=') ADVANCE(106);
      if (lookahead == '>') ADVANCE(103);
      if (lookahead == '?') ADVANCE(148);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(146);
      if (lookahead == '"') ADVANCE(180);
      if (lookahead == '#') ADVANCE(91);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '.') ADVANCE(82);
      if (lookahead == '/') ADVANCE(40);
      if (lookahead == ':') ADVANCE(149);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '?') ADVANCE(148);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == ']') ADVANCE(97);
      if (lookahead == '_') ADVANCE(89);
      if (lookahead == '}') ADVANCE(99);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(42);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '&') ADVANCE(154);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(150);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(94);
      if (lookahead == '.') ADVANCE(82);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead == '<') ADVANCE(101);
      if (lookahead == '=') ADVANCE(43);
      if (lookahead == '>') ADVANCE(103);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == ']') ADVANCE(97);
      if (lookahead == '_') ADVANCE(89);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '|') ADVANCE(153);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(42);
      if (lookahead == '"') ADVANCE(25);
      if (lookahead == '#') ADVANCE(91);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '&') ADVANCE(154);
      if (lookahead == '\'') ADVANCE(28);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(150);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(94);
      if (lookahead == '.') ADVANCE(82);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead == '<') ADVANCE(101);
      if (lookahead == '=') ADVANCE(43);
      if (lookahead == '>') ADVANCE(103);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '\\') ADVANCE(26);
      if (lookahead == ']') ADVANCE(97);
      if (lookahead == '_') ADVANCE(89);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '|') ADVANCE(153);
      if (lookahead == '}') ADVANCE(99);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(42);
      if (lookahead == '"') ADVANCE(25);
      if (lookahead == '#') ADVANCE(91);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '&') ADVANCE(154);
      if (lookahead == '\'') ADVANCE(28);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(150);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(94);
      if (lookahead == '.') ADVANCE(82);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead == '<') ADVANCE(101);
      if (lookahead == '=') ADVANCE(43);
      if (lookahead == '>') ADVANCE(103);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '\\') ADVANCE(63);
      if (lookahead == ']') ADVANCE(97);
      if (lookahead == '_') ADVANCE(89);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '|') ADVANCE(153);
      if (lookahead == '}') ADVANCE(99);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(125);
      if (lookahead == '/') ADVANCE(124);
      if (lookahead == '0') ADVANCE(128);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(109);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(90);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 9:
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(110);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(111);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(112);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(113);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(114);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(115);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(116);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 16:
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(117);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == ']') ADVANCE(97);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(118);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 18:
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '}') ADVANCE(99);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(119);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 19:
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(120);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 20:
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(121);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 21:
      if (lookahead == '"') ADVANCE(190);
      END_STATE();
    case 22:
      if (lookahead == '"') ADVANCE(196);
      END_STATE();
    case 23:
      if (lookahead == '"') ADVANCE(180);
      if (lookahead == '/') ADVANCE(40);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(23)
      END_STATE();
    case 24:
      if (lookahead == '"') ADVANCE(29);
      END_STATE();
    case 25:
      if (lookahead == '"') ADVANCE(24);
      if (lookahead == '#') ADVANCE(193);
      END_STATE();
    case 26:
      if (lookahead == '#') ADVANCE(36);
      END_STATE();
    case 27:
      if (lookahead == '#') ADVANCE(36);
      if (lookahead == '(') ADVANCE(200);
      END_STATE();
    case 28:
      if (lookahead == '#') ADVANCE(195);
      if (lookahead == '\'') ADVANCE(34);
      END_STATE();
    case 29:
      if (lookahead == '#') ADVANCE(197);
      END_STATE();
    case 30:
      if (lookahead == '#') ADVANCE(199);
      END_STATE();
    case 31:
      if (lookahead == '\'') ADVANCE(191);
      END_STATE();
    case 32:
      if (lookahead == '\'') ADVANCE(198);
      END_STATE();
    case 33:
      if (lookahead == '\'') ADVANCE(185);
      if (lookahead == '/') ADVANCE(40);
      if (lookahead == '\\') ADVANCE(35);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(33)
      END_STATE();
    case 34:
      if (lookahead == '\'') ADVANCE(30);
      END_STATE();
    case 35:
      if (lookahead == '(') ADVANCE(200);
      END_STATE();
    case 36:
      if (lookahead == '(') ADVANCE(201);
      END_STATE();
    case 37:
      if (lookahead == '.') ADVANCE(145);
      END_STATE();
    case 38:
      if (lookahead == '.') ADVANCE(47);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(45);
      if (lookahead == '_') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(38);
      END_STATE();
    case 39:
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == '_') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(168);
      END_STATE();
    case 40:
      if (lookahead == '/') ADVANCE(202);
      END_STATE();
    case 41:
      if (lookahead == '/') ADVANCE(77);
      if (sym_attr_path_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 42:
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '~') ADVANCE(159);
      END_STATE();
    case 43:
      if (lookahead == '=') ADVANCE(157);
      if (lookahead == '~') ADVANCE(158);
      END_STATE();
    case 44:
      if (lookahead == '_') ADVANCE(163);
      END_STATE();
    case 45:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(174);
      END_STATE();
    case 46:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(45);
      if (lookahead == '_') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 47:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 48:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(170);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(171);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(178);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(50);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(167);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(172);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(166);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(175);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(174);
      END_STATE();
    case 57:
      if (sym_escape_char_character_set_1(lookahead)) ADVANCE(177);
      if (lookahead == '#') ADVANCE(59);
      if (lookahead == '(') ADVANCE(200);
      if (lookahead == 'U') ADVANCE(76);
      if (lookahead == 'u') ADVANCE(72);
      if (lookahead == 'x') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(51);
      END_STATE();
    case 58:
      if (sym_escape_char_character_set_1(lookahead)) ADVANCE(177);
      if (lookahead == '#') ADVANCE(59);
      if (lookahead == '(') ADVANCE(201);
      if (lookahead == 'U') ADVANCE(76);
      if (lookahead == 'u') ADVANCE(72);
      if (lookahead == 'x') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(51);
      END_STATE();
    case 59:
      if (sym_escape_char_character_set_1(lookahead)) ADVANCE(177);
      if (lookahead == '#') ADVANCE(59);
      if (lookahead == 'U') ADVANCE(76);
      if (lookahead == 'u') ADVANCE(72);
      if (lookahead == 'x') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(51);
      END_STATE();
    case 60:
      if (sym_escape_char_character_set_1(lookahead)) ADVANCE(177);
      if (lookahead == '#') ADVANCE(61);
      if (lookahead == '(') ADVANCE(200);
      if (lookahead == 'U') ADVANCE(76);
      if (lookahead == 'u') ADVANCE(72);
      END_STATE();
    case 61:
      if (sym_escape_char_character_set_1(lookahead)) ADVANCE(177);
      if (lookahead == '#') ADVANCE(61);
      if (lookahead == 'U') ADVANCE(76);
      if (lookahead == 'u') ADVANCE(72);
      END_STATE();
    case 62:
      if (sym_escape_char_character_set_1(lookahead)) ADVANCE(177);
      if (lookahead == '#') ADVANCE(58);
      if (lookahead == '(') ADVANCE(200);
      if (lookahead == 'U') ADVANCE(76);
      if (lookahead == 'u') ADVANCE(72);
      if (lookahead == 'x') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(51);
      END_STATE();
    case 63:
      if (sym_escape_char_character_set_1(lookahead)) ADVANCE(177);
      if (lookahead == '#') ADVANCE(58);
      if (lookahead == 'U') ADVANCE(76);
      if (lookahead == 'u') ADVANCE(72);
      if (lookahead == 'x') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(51);
      END_STATE();
    case 64:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(168);
      END_STATE();
    case 65:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 66:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(38);
      END_STATE();
    case 67:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(178);
      END_STATE();
    case 68:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(179);
      END_STATE();
    case 69:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 70:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(68);
      END_STATE();
    case 71:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      END_STATE();
    case 72:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(71);
      END_STATE();
    case 73:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(72);
      END_STATE();
    case 74:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      END_STATE();
    case 75:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(74);
      END_STATE();
    case 76:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(75);
      END_STATE();
    case 77:
      if (sym_attr_path_character_set_2(lookahead)) ADVANCE(41);
      END_STATE();
    case 78:
      if (eof) ADVANCE(80);
      if (lookahead == '!') ADVANCE(147);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '&') ADVANCE(154);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(151);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(83);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == ':') ADVANCE(149);
      if (lookahead == '<') ADVANCE(101);
      if (lookahead == '=') ADVANCE(105);
      if (lookahead == '>') ADVANCE(103);
      if (lookahead == '?') ADVANCE(148);
      if (lookahead == '@') ADVANCE(93);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead == ']') ADVANCE(97);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '|') ADVANCE(153);
      if (lookahead == '}') ADVANCE(99);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(78)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      END_STATE();
    case 79:
      if (eof) ADVANCE(80);
      if (lookahead == '!') ADVANCE(147);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '&') ADVANCE(154);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(151);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(173);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead == '0') ADVANCE(164);
      if (lookahead == '<') ADVANCE(101);
      if (lookahead == '=') ADVANCE(43);
      if (lookahead == '>') ADVANCE(103);
      if (lookahead == '@') ADVANCE(93);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == ']') ADVANCE(97);
      if (lookahead == '_') ADVANCE(88);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '|') ADVANCE(153);
      if (lookahead == '}') ADVANCE(99);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(79)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(37);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(175);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(175);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(192);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(194);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(91);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(92);
      if (lookahead == '|') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(92);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(91);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(92);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$' ||
          lookahead == '_') ADVANCE(92);
      if (lookahead == '.') ADVANCE(142);
      if (lookahead == '/') ADVANCE(144);
      if (sym_identifier_character_set_4(lookahead)) ADVANCE(90);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(92);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_5(lookahead)) ADVANCE(92);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(176);
      if (lookahead == '0') ADVANCE(165);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(166);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(161);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(162);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(157);
      if (lookahead == '~') ADVANCE(158);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '~') ADVANCE(158);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(125);
      if (lookahead == '/') ADVANCE(124);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(109);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(90);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '_') ADVANCE(108);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(110);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '_') ADVANCE(108);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '_') ADVANCE(108);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(112);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '_') ADVANCE(108);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '=') ADVANCE(104);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(113);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '_') ADVANCE(108);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == ',') ADVANCE(81);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(114);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '_') ADVANCE(108);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '{') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(115);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '_') ADVANCE(108);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == ')') ADVANCE(86);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(116);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '_') ADVANCE(108);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(117);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '_') ADVANCE(108);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == ']') ADVANCE(97);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(118);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '_') ADVANCE(108);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '}') ADVANCE(99);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(119);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '_') ADVANCE(108);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '(') ADVANCE(85);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(120);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '_') ADVANCE(108);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '"') ADVANCE(181);
      if (lookahead == '#') ADVANCE(87);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(92);
      if (lookahead == '\'') ADVANCE(186);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '+') ADVANCE(126);
      if (lookahead == '-') ADVANCE(122);
      if (lookahead == '.') ADVANCE(127);
      if (lookahead == '/') ADVANCE(123);
      if (lookahead == '[') ADVANCE(96);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(121);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          lookahead != '_') ADVANCE(108);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '.') ADVANCE(176);
      if (lookahead == '0') ADVANCE(165);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(166);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '/') ADVANCE(202);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '/') ADVANCE(202);
      if (sym_attr_path_character_set_1(lookahead)) ADVANCE(41);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (sym_attr_path_character_set_3(lookahead)) ADVANCE(142);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == '0') ADVANCE(169);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(172);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym__attr_item_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(175);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '.') ADVANCE(136);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == '0') ADVANCE(129);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(143);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(130);
      if (lookahead == '_') ADVANCE(52);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(139);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(140);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(142);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '.') ADVANCE(136);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(143);
      if (lookahead == '_') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(142);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '.') ADVANCE(141);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == '_') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(131);
      if (sym_attr_path_character_set_4(lookahead)) ADVANCE(142);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '.') ADVANCE(138);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(143);
      if (lookahead == '_') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(131);
      if (sym_attr_path_character_set_4(lookahead)) ADVANCE(142);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == '_') ADVANCE(48);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(132);
      if (sym_attr_path_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == '_') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(133);
      if (sym_attr_path_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == '_') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(134);
      if (sym_attr_path_character_set_3(lookahead)) ADVANCE(142);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(143);
      if (lookahead == '_') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (sym_attr_path_character_set_3(lookahead)) ADVANCE(142);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(135);
      if (sym_attr_path_character_set_3(lookahead)) ADVANCE(142);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(143);
      if (lookahead == '_') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(137);
      if (sym_attr_path_character_set_5(lookahead)) ADVANCE(142);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(137);
      if (sym_attr_path_character_set_5(lookahead)) ADVANCE(142);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '/') ADVANCE(144);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(132);
      if (sym_attr_path_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '/') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(133);
      if (sym_attr_path_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '/') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(137);
      if (sym_attr_path_character_set_5(lookahead)) ADVANCE(142);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '/') ADVANCE(144);
      if (sym_attr_path_character_set_1(lookahead)) ADVANCE(142);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_attr_path);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(56);
      if (lookahead == '/') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(134);
      if (sym_attr_path_character_set_3(lookahead)) ADVANCE(142);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_attr_path);
      if (sym_attr_path_character_set_2(lookahead)) ADVANCE(142);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(160);
      if (lookahead == '~') ADVANCE(159);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '0') ADVANCE(169);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(172);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(202);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(155);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(156);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_BANG_TILDE);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_bottom);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(176);
      if (lookahead == '0') ADVANCE(167);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(45);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(39);
      if (lookahead == '_') ADVANCE(52);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(48);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(49);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(167);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(176);
      if (lookahead == '0') ADVANCE(166);
      if (lookahead == '_') ADVANCE(54);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(49);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(166);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(176);
      if (lookahead == '_') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(176);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(45);
      if (lookahead == '_') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(167);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(47);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(45);
      if (lookahead == '_') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(168);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '0') ADVANCE(172);
      if (lookahead == '_') ADVANCE(53);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(49);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(172);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(48);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(170);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(171);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '.') ADVANCE(37);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(175);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(174);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(45);
      if (lookahead == '_') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(175);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(175);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_escape_char);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_escape_byte);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(aux_sym__escape_unicode_token1);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(21);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym__simple_string_lit_token1);
      if (lookahead == '/') ADVANCE(183);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(182);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym__simple_string_lit_token1);
      if (lookahead == '/') ADVANCE(184);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym__simple_string_lit_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '\'') ADVANCE(31);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym__simple_bytes_lit_token1);
      if (lookahead == '/') ADVANCE(188);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(187);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(189);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym__simple_bytes_lit_token1);
      if (lookahead == '/') ADVANCE(189);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(189);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym__simple_bytes_lit_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(189);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_POUND_DQUOTE);
      if (lookahead == '"') ADVANCE(22);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_DQUOTE_POUND);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_POUND_SQUOTE);
      if (lookahead == '\'') ADVANCE(32);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_SQUOTE_POUND);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE_POUND);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE_SQUOTE_POUND);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_BSLASH_LPAREN);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_BSLASH_POUND_LPAREN);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(202);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'G' ||
          lookahead == 'K' ||
          lookahead == 'M' ||
          lookahead == 'P' ||
          lookahead == 'T') ADVANCE(1);
      if (lookahead == '_') ADVANCE(2);
      if (lookahead == 'a') ADVANCE(3);
      if (lookahead == 'b') ADVANCE(4);
      if (lookahead == 'c') ADVANCE(5);
      if (lookahead == 'd') ADVANCE(6);
      if (lookahead == 'f') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'm') ADVANCE(10);
      if (lookahead == 'n') ADVANCE(11);
      if (lookahead == 'o') ADVANCE(12);
      if (lookahead == 'p') ADVANCE(13);
      if (lookahead == 'q') ADVANCE(14);
      if (lookahead == 'r') ADVANCE(15);
      if (lookahead == 's') ADVANCE(16);
      if (lookahead == 't') ADVANCE(17);
      if (lookahead == 'u') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      END_STATE();
    case 1:
      ACCEPT_TOKEN(aux_sym_si_unit_token1);
      if (lookahead == 'i') ADVANCE(20);
      END_STATE();
    case 2:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 3:
      if (lookahead == 'n') ADVANCE(21);
      END_STATE();
    case 4:
      if (lookahead == 'o') ADVANCE(22);
      if (lookahead == 'y') ADVANCE(23);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(24);
      END_STATE();
    case 6:
      if (lookahead == 'i') ADVANCE(25);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(26);
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(29);
      if (lookahead == 'm') ADVANCE(30);
      if (lookahead == 'n') ADVANCE(31);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 10:
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 11:
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 12:
      if (lookahead == 'r') ADVANCE(35);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(36);
      END_STATE();
    case 14:
      if (lookahead == 'u') ADVANCE(37);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 16:
      if (lookahead == 't') ADVANCE(39);
      END_STATE();
    case 17:
      if (lookahead == 'r') ADVANCE(40);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(41);
      END_STATE();
    case 19:
      if (lookahead == '_') ADVANCE(2);
      if (lookahead == 'a') ADVANCE(3);
      if (lookahead == 'b') ADVANCE(4);
      if (lookahead == 'c') ADVANCE(5);
      if (lookahead == 'd') ADVANCE(6);
      if (lookahead == 'f') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'm') ADVANCE(10);
      if (lookahead == 'n') ADVANCE(11);
      if (lookahead == 'o') ADVANCE(12);
      if (lookahead == 'p') ADVANCE(13);
      if (lookahead == 'q') ADVANCE(14);
      if (lookahead == 'r') ADVANCE(15);
      if (lookahead == 's') ADVANCE(16);
      if (lookahead == 't') ADVANCE(17);
      if (lookahead == 'u') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      END_STATE();
    case 20:
      ACCEPT_TOKEN(aux_sym_si_unit_token1);
      END_STATE();
    case 21:
      if (lookahead == 'd') ADVANCE(42);
      END_STATE();
    case 22:
      if (lookahead == 'o') ADVANCE(43);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 24:
      if (lookahead == 'o') ADVANCE(45);
      END_STATE();
    case 25:
      if (lookahead == 'v') ADVANCE(46);
      END_STATE();
    case 26:
      if (lookahead == 'l') ADVANCE(47);
      END_STATE();
    case 27:
      if (lookahead == 'o') ADVANCE(48);
      END_STATE();
    case 28:
      if (lookahead == 'r') ADVANCE(49);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 30:
      if (lookahead == 'p') ADVANCE(50);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 't') ADVANCE(51);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(52);
      if (lookahead == 't') ADVANCE(53);
      END_STATE();
    case 33:
      if (lookahead == 'd') ADVANCE(54);
      END_STATE();
    case 34:
      if (lookahead == 'l') ADVANCE(55);
      if (lookahead == 'm') ADVANCE(56);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 36:
      if (lookahead == 'c') ADVANCE(57);
      END_STATE();
    case 37:
      if (lookahead == 'o') ADVANCE(58);
      END_STATE();
    case 38:
      if (lookahead == 'm') ADVANCE(59);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(60);
      END_STATE();
    case 40:
      if (lookahead == 'u') ADVANCE(61);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(62);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 43:
      if (lookahead == 'l') ADVANCE(63);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(64);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(65);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_div);
      END_STATE();
    case 47:
      if (lookahead == 's') ADVANCE(66);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(67);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 50:
      if (lookahead == 'o') ADVANCE(68);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == '1') ADVANCE(69);
      if (lookahead == '3') ADVANCE(70);
      if (lookahead == '6') ADVANCE(71);
      if (lookahead == '8') ADVANCE(72);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_len);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_mod);
      END_STATE();
    case 55:
      if (lookahead == 'l') ADVANCE(73);
      END_STATE();
    case 56:
      if (lookahead == 'b') ADVANCE(74);
      END_STATE();
    case 57:
      if (lookahead == 'k') ADVANCE(75);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_quo);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_rem);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(76);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(77);
      END_STATE();
    case 62:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 64:
      if (lookahead == 's') ADVANCE(79);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(81);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 68:
      if (lookahead == 'r') ADVANCE(83);
      END_STATE();
    case 69:
      if (lookahead == '2') ADVANCE(84);
      if (lookahead == '6') ADVANCE(85);
      END_STATE();
    case 70:
      if (lookahead == '2') ADVANCE(86);
      END_STATE();
    case 71:
      if (lookahead == '4') ADVANCE(87);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_int8);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(88);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(89);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(90);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_uint);
      if (lookahead == '1') ADVANCE(91);
      if (lookahead == '3') ADVANCE(92);
      if (lookahead == '6') ADVANCE(93);
      if (lookahead == '8') ADVANCE(94);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_bytes);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_close);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_float);
      if (lookahead == '3') ADVANCE(95);
      if (lookahead == '6') ADVANCE(96);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 84:
      if (lookahead == '8') ADVANCE(98);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_int16);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_int32);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_int64);
      END_STATE();
    case 88:
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 89:
      if (lookahead == 'g') ADVANCE(100);
      END_STATE();
    case 90:
      if (lookahead == 'g') ADVANCE(101);
      END_STATE();
    case 91:
      if (lookahead == '2') ADVANCE(102);
      if (lookahead == '6') ADVANCE(103);
      END_STATE();
    case 92:
      if (lookahead == '2') ADVANCE(104);
      END_STATE();
    case 93:
      if (lookahead == '4') ADVANCE(105);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_uint8);
      END_STATE();
    case 95:
      if (lookahead == '2') ADVANCE(106);
      END_STATE();
    case 96:
      if (lookahead == '4') ADVANCE(107);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_int128);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 102:
      if (lookahead == '8') ADVANCE(109);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_uint16);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_uint32);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_uint64);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_float32);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_float64);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_uint128);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 79},
  [2] = {.lex_state = 79},
  [3] = {.lex_state = 79},
  [4] = {.lex_state = 79},
  [5] = {.lex_state = 79},
  [6] = {.lex_state = 79},
  [7] = {.lex_state = 79},
  [8] = {.lex_state = 79},
  [9] = {.lex_state = 79},
  [10] = {.lex_state = 79},
  [11] = {.lex_state = 79},
  [12] = {.lex_state = 79},
  [13] = {.lex_state = 79},
  [14] = {.lex_state = 79},
  [15] = {.lex_state = 79},
  [16] = {.lex_state = 79},
  [17] = {.lex_state = 79},
  [18] = {.lex_state = 79},
  [19] = {.lex_state = 79},
  [20] = {.lex_state = 79},
  [21] = {.lex_state = 79},
  [22] = {.lex_state = 79},
  [23] = {.lex_state = 79},
  [24] = {.lex_state = 79},
  [25] = {.lex_state = 79},
  [26] = {.lex_state = 79},
  [27] = {.lex_state = 79},
  [28] = {.lex_state = 79},
  [29] = {.lex_state = 79},
  [30] = {.lex_state = 79},
  [31] = {.lex_state = 79},
  [32] = {.lex_state = 79},
  [33] = {.lex_state = 79},
  [34] = {.lex_state = 79},
  [35] = {.lex_state = 79},
  [36] = {.lex_state = 79},
  [37] = {.lex_state = 79},
  [38] = {.lex_state = 79},
  [39] = {.lex_state = 79},
  [40] = {.lex_state = 79},
  [41] = {.lex_state = 79},
  [42] = {.lex_state = 79},
  [43] = {.lex_state = 79},
  [44] = {.lex_state = 79},
  [45] = {.lex_state = 79},
  [46] = {.lex_state = 79},
  [47] = {.lex_state = 79},
  [48] = {.lex_state = 79},
  [49] = {.lex_state = 79},
  [50] = {.lex_state = 79},
  [51] = {.lex_state = 79},
  [52] = {.lex_state = 79},
  [53] = {.lex_state = 79},
  [54] = {.lex_state = 79},
  [55] = {.lex_state = 79},
  [56] = {.lex_state = 79},
  [57] = {.lex_state = 79},
  [58] = {.lex_state = 79},
  [59] = {.lex_state = 79},
  [60] = {.lex_state = 79},
  [61] = {.lex_state = 79},
  [62] = {.lex_state = 79},
  [63] = {.lex_state = 79},
  [64] = {.lex_state = 79},
  [65] = {.lex_state = 79},
  [66] = {.lex_state = 79},
  [67] = {.lex_state = 79},
  [68] = {.lex_state = 79},
  [69] = {.lex_state = 79},
  [70] = {.lex_state = 79},
  [71] = {.lex_state = 79},
  [72] = {.lex_state = 79},
  [73] = {.lex_state = 79},
  [74] = {.lex_state = 3},
  [75] = {.lex_state = 79},
  [76] = {.lex_state = 79},
  [77] = {.lex_state = 79},
  [78] = {.lex_state = 3},
  [79] = {.lex_state = 3},
  [80] = {.lex_state = 3},
  [81] = {.lex_state = 3},
  [82] = {.lex_state = 3},
  [83] = {.lex_state = 3},
  [84] = {.lex_state = 3},
  [85] = {.lex_state = 3},
  [86] = {.lex_state = 3},
  [87] = {.lex_state = 3},
  [88] = {.lex_state = 3},
  [89] = {.lex_state = 3},
  [90] = {.lex_state = 3},
  [91] = {.lex_state = 3},
  [92] = {.lex_state = 3},
  [93] = {.lex_state = 3},
  [94] = {.lex_state = 3},
  [95] = {.lex_state = 3},
  [96] = {.lex_state = 3},
  [97] = {.lex_state = 3},
  [98] = {.lex_state = 3},
  [99] = {.lex_state = 3},
  [100] = {.lex_state = 3},
  [101] = {.lex_state = 3},
  [102] = {.lex_state = 3},
  [103] = {.lex_state = 3},
  [104] = {.lex_state = 3},
  [105] = {.lex_state = 3},
  [106] = {.lex_state = 3},
  [107] = {.lex_state = 3},
  [108] = {.lex_state = 3},
  [109] = {.lex_state = 3},
  [110] = {.lex_state = 3},
  [111] = {.lex_state = 3},
  [112] = {.lex_state = 3},
  [113] = {.lex_state = 3},
  [114] = {.lex_state = 3},
  [115] = {.lex_state = 3},
  [116] = {.lex_state = 3},
  [117] = {.lex_state = 3},
  [118] = {.lex_state = 3},
  [119] = {.lex_state = 0},
  [120] = {.lex_state = 0},
  [121] = {.lex_state = 0},
  [122] = {.lex_state = 3},
  [123] = {.lex_state = 0},
  [124] = {.lex_state = 3},
  [125] = {.lex_state = 0},
  [126] = {.lex_state = 0},
  [127] = {.lex_state = 0},
  [128] = {.lex_state = 0},
  [129] = {.lex_state = 0},
  [130] = {.lex_state = 0},
  [131] = {.lex_state = 0},
  [132] = {.lex_state = 0},
  [133] = {.lex_state = 0},
  [134] = {.lex_state = 0},
  [135] = {.lex_state = 0},
  [136] = {.lex_state = 0},
  [137] = {.lex_state = 0},
  [138] = {.lex_state = 0},
  [139] = {.lex_state = 0},
  [140] = {.lex_state = 0},
  [141] = {.lex_state = 0},
  [142] = {.lex_state = 0},
  [143] = {.lex_state = 0},
  [144] = {.lex_state = 0},
  [145] = {.lex_state = 0},
  [146] = {.lex_state = 0},
  [147] = {.lex_state = 0},
  [148] = {.lex_state = 0},
  [149] = {.lex_state = 0},
  [150] = {.lex_state = 0},
  [151] = {.lex_state = 0},
  [152] = {.lex_state = 0},
  [153] = {.lex_state = 0},
  [154] = {.lex_state = 0},
  [155] = {.lex_state = 0},
  [156] = {.lex_state = 0},
  [157] = {.lex_state = 0},
  [158] = {.lex_state = 0},
  [159] = {.lex_state = 0},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 0},
  [163] = {.lex_state = 0},
  [164] = {.lex_state = 0},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 0},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 0},
  [169] = {.lex_state = 0},
  [170] = {.lex_state = 0},
  [171] = {.lex_state = 79},
  [172] = {.lex_state = 79},
  [173] = {.lex_state = 79},
  [174] = {.lex_state = 79},
  [175] = {.lex_state = 79},
  [176] = {.lex_state = 79},
  [177] = {.lex_state = 79},
  [178] = {.lex_state = 79},
  [179] = {.lex_state = 79},
  [180] = {.lex_state = 79},
  [181] = {.lex_state = 79},
  [182] = {.lex_state = 79},
  [183] = {.lex_state = 79},
  [184] = {.lex_state = 0},
  [185] = {.lex_state = 79},
  [186] = {.lex_state = 79},
  [187] = {.lex_state = 79},
  [188] = {.lex_state = 79},
  [189] = {.lex_state = 79},
  [190] = {.lex_state = 79},
  [191] = {.lex_state = 79},
  [192] = {.lex_state = 79},
  [193] = {.lex_state = 79},
  [194] = {.lex_state = 79},
  [195] = {.lex_state = 79},
  [196] = {.lex_state = 79},
  [197] = {.lex_state = 79},
  [198] = {.lex_state = 79},
  [199] = {.lex_state = 79},
  [200] = {.lex_state = 79},
  [201] = {.lex_state = 79},
  [202] = {.lex_state = 79},
  [203] = {.lex_state = 79},
  [204] = {.lex_state = 79},
  [205] = {.lex_state = 79},
  [206] = {.lex_state = 79},
  [207] = {.lex_state = 79},
  [208] = {.lex_state = 79},
  [209] = {.lex_state = 79},
  [210] = {.lex_state = 79},
  [211] = {.lex_state = 79},
  [212] = {.lex_state = 79},
  [213] = {.lex_state = 79},
  [214] = {.lex_state = 79},
  [215] = {.lex_state = 79},
  [216] = {.lex_state = 79},
  [217] = {.lex_state = 79},
  [218] = {.lex_state = 79},
  [219] = {.lex_state = 79},
  [220] = {.lex_state = 79},
  [221] = {.lex_state = 79},
  [222] = {.lex_state = 79},
  [223] = {.lex_state = 79},
  [224] = {.lex_state = 79},
  [225] = {.lex_state = 79},
  [226] = {.lex_state = 79},
  [227] = {.lex_state = 79},
  [228] = {.lex_state = 79},
  [229] = {.lex_state = 79},
  [230] = {.lex_state = 79},
  [231] = {.lex_state = 79},
  [232] = {.lex_state = 79},
  [233] = {.lex_state = 79},
  [234] = {.lex_state = 79},
  [235] = {.lex_state = 79},
  [236] = {.lex_state = 79},
  [237] = {.lex_state = 79},
  [238] = {.lex_state = 79},
  [239] = {.lex_state = 79},
  [240] = {.lex_state = 79},
  [241] = {.lex_state = 79},
  [242] = {.lex_state = 79},
  [243] = {.lex_state = 9},
  [244] = {.lex_state = 79},
  [245] = {.lex_state = 79},
  [246] = {.lex_state = 79},
  [247] = {.lex_state = 3},
  [248] = {.lex_state = 14},
  [249] = {.lex_state = 14},
  [250] = {.lex_state = 14},
  [251] = {.lex_state = 14},
  [252] = {.lex_state = 14},
  [253] = {.lex_state = 18},
  [254] = {.lex_state = 15},
  [255] = {.lex_state = 17},
  [256] = {.lex_state = 16},
  [257] = {.lex_state = 19},
  [258] = {.lex_state = 19},
  [259] = {.lex_state = 19},
  [260] = {.lex_state = 8},
  [261] = {.lex_state = 8},
  [262] = {.lex_state = 8},
  [263] = {.lex_state = 8},
  [264] = {.lex_state = 8},
  [265] = {.lex_state = 8},
  [266] = {.lex_state = 20},
  [267] = {.lex_state = 20},
  [268] = {.lex_state = 20},
  [269] = {.lex_state = 20},
  [270] = {.lex_state = 20},
  [271] = {.lex_state = 20},
  [272] = {.lex_state = 20},
  [273] = {.lex_state = 20},
  [274] = {.lex_state = 20},
  [275] = {.lex_state = 20},
  [276] = {.lex_state = 20},
  [277] = {.lex_state = 12},
  [278] = {.lex_state = 12},
  [279] = {.lex_state = 12},
  [280] = {.lex_state = 13},
  [281] = {.lex_state = 12},
  [282] = {.lex_state = 10},
  [283] = {.lex_state = 13},
  [284] = {.lex_state = 13},
  [285] = {.lex_state = 11},
  [286] = {.lex_state = 10},
  [287] = {.lex_state = 10},
  [288] = {.lex_state = 13},
  [289] = {.lex_state = 10},
  [290] = {.lex_state = 10},
  [291] = {.lex_state = 10},
  [292] = {.lex_state = 10},
  [293] = {.lex_state = 10},
  [294] = {.lex_state = 10},
  [295] = {.lex_state = 10},
  [296] = {.lex_state = 11},
  [297] = {.lex_state = 10},
  [298] = {.lex_state = 10},
  [299] = {.lex_state = 10},
  [300] = {.lex_state = 10},
  [301] = {.lex_state = 10},
  [302] = {.lex_state = 10},
  [303] = {.lex_state = 11},
  [304] = {.lex_state = 10},
  [305] = {.lex_state = 10},
  [306] = {.lex_state = 10},
  [307] = {.lex_state = 10},
  [308] = {.lex_state = 10},
  [309] = {.lex_state = 10},
  [310] = {.lex_state = 10},
  [311] = {.lex_state = 11},
  [312] = {.lex_state = 10},
  [313] = {.lex_state = 10},
  [314] = {.lex_state = 10},
  [315] = {.lex_state = 10},
  [316] = {.lex_state = 11},
  [317] = {.lex_state = 11},
  [318] = {.lex_state = 11},
  [319] = {.lex_state = 11},
  [320] = {.lex_state = 11},
  [321] = {.lex_state = 11},
  [322] = {.lex_state = 11},
  [323] = {.lex_state = 11},
  [324] = {.lex_state = 11},
  [325] = {.lex_state = 11},
  [326] = {.lex_state = 11},
  [327] = {.lex_state = 11},
  [328] = {.lex_state = 11},
  [329] = {.lex_state = 11},
  [330] = {.lex_state = 11},
  [331] = {.lex_state = 11},
  [332] = {.lex_state = 11},
  [333] = {.lex_state = 11},
  [334] = {.lex_state = 11},
  [335] = {.lex_state = 11},
  [336] = {.lex_state = 11},
  [337] = {.lex_state = 11},
  [338] = {.lex_state = 11},
  [339] = {.lex_state = 11},
  [340] = {.lex_state = 11},
  [341] = {.lex_state = 11},
  [342] = {.lex_state = 11},
  [343] = {.lex_state = 11},
  [344] = {.lex_state = 14},
  [345] = {.lex_state = 14},
  [346] = {.lex_state = 14},
  [347] = {.lex_state = 5},
  [348] = {.lex_state = 5},
  [349] = {.lex_state = 5},
  [350] = {.lex_state = 5},
  [351] = {.lex_state = 5},
  [352] = {.lex_state = 5},
  [353] = {.lex_state = 5},
  [354] = {.lex_state = 5},
  [355] = {.lex_state = 5},
  [356] = {.lex_state = 5},
  [357] = {.lex_state = 5},
  [358] = {.lex_state = 5},
  [359] = {.lex_state = 5},
  [360] = {.lex_state = 5},
  [361] = {.lex_state = 5},
  [362] = {.lex_state = 5},
  [363] = {.lex_state = 5},
  [364] = {.lex_state = 7},
  [365] = {.lex_state = 7},
  [366] = {.lex_state = 7},
  [367] = {.lex_state = 7},
  [368] = {.lex_state = 7},
  [369] = {.lex_state = 7},
  [370] = {.lex_state = 7},
  [371] = {.lex_state = 5},
  [372] = {.lex_state = 7},
  [373] = {.lex_state = 7},
  [374] = {.lex_state = 5},
  [375] = {.lex_state = 7},
  [376] = {.lex_state = 7},
  [377] = {.lex_state = 7},
  [378] = {.lex_state = 7},
  [379] = {.lex_state = 7},
  [380] = {.lex_state = 7},
  [381] = {.lex_state = 7},
  [382] = {.lex_state = 7},
  [383] = {.lex_state = 7},
  [384] = {.lex_state = 7},
  [385] = {.lex_state = 7},
  [386] = {.lex_state = 7},
  [387] = {.lex_state = 5},
  [388] = {.lex_state = 7},
  [389] = {.lex_state = 7},
  [390] = {.lex_state = 7},
  [391] = {.lex_state = 7},
  [392] = {.lex_state = 7},
  [393] = {.lex_state = 7},
  [394] = {.lex_state = 5},
  [395] = {.lex_state = 7},
  [396] = {.lex_state = 5},
  [397] = {.lex_state = 5},
  [398] = {.lex_state = 5},
  [399] = {.lex_state = 7},
  [400] = {.lex_state = 7},
  [401] = {.lex_state = 7},
  [402] = {.lex_state = 7},
  [403] = {.lex_state = 7},
  [404] = {.lex_state = 7},
  [405] = {.lex_state = 7},
  [406] = {.lex_state = 7},
  [407] = {.lex_state = 5},
  [408] = {.lex_state = 7},
  [409] = {.lex_state = 7},
  [410] = {.lex_state = 7},
  [411] = {.lex_state = 7},
  [412] = {.lex_state = 5},
  [413] = {.lex_state = 5},
  [414] = {.lex_state = 5},
  [415] = {.lex_state = 5},
  [416] = {.lex_state = 5},
  [417] = {.lex_state = 5},
  [418] = {.lex_state = 0},
  [419] = {.lex_state = 5},
  [420] = {.lex_state = 5},
  [421] = {.lex_state = 0},
  [422] = {.lex_state = 5},
  [423] = {.lex_state = 5},
  [424] = {.lex_state = 5},
  [425] = {.lex_state = 5},
  [426] = {.lex_state = 5},
  [427] = {.lex_state = 5},
  [428] = {.lex_state = 5},
  [429] = {.lex_state = 5},
  [430] = {.lex_state = 5},
  [431] = {.lex_state = 5},
  [432] = {.lex_state = 5},
  [433] = {.lex_state = 4},
  [434] = {.lex_state = 4},
  [435] = {.lex_state = 7},
  [436] = {.lex_state = 7},
  [437] = {.lex_state = 7},
  [438] = {.lex_state = 1},
  [439] = {.lex_state = 1},
  [440] = {.lex_state = 7, .external_lex_state = 2},
  [441] = {.lex_state = 1},
  [442] = {.lex_state = 7, .external_lex_state = 3},
  [443] = {.lex_state = 0, .external_lex_state = 4},
  [444] = {.lex_state = 1},
  [445] = {.lex_state = 7, .external_lex_state = 2},
  [446] = {.lex_state = 0, .external_lex_state = 4},
  [447] = {.lex_state = 7, .external_lex_state = 2},
  [448] = {.lex_state = 7, .external_lex_state = 3},
  [449] = {.lex_state = 7, .external_lex_state = 3},
  [450] = {.lex_state = 7, .external_lex_state = 2},
  [451] = {.lex_state = 7, .external_lex_state = 2},
  [452] = {.lex_state = 0, .external_lex_state = 4},
  [453] = {.lex_state = 0, .external_lex_state = 4},
  [454] = {.lex_state = 1},
  [455] = {.lex_state = 1},
  [456] = {.lex_state = 7, .external_lex_state = 3},
  [457] = {.lex_state = 1},
  [458] = {.lex_state = 7, .external_lex_state = 3},
  [459] = {.lex_state = 0, .external_lex_state = 4},
  [460] = {.lex_state = 7, .external_lex_state = 2},
  [461] = {.lex_state = 0, .external_lex_state = 4},
  [462] = {.lex_state = 0, .external_lex_state = 4},
  [463] = {.lex_state = 7, .external_lex_state = 3},
  [464] = {.lex_state = 7, .external_lex_state = 2},
  [465] = {.lex_state = 1},
  [466] = {.lex_state = 0, .external_lex_state = 4},
  [467] = {.lex_state = 1},
  [468] = {.lex_state = 7, .external_lex_state = 3},
  [469] = {.lex_state = 7, .external_lex_state = 2},
  [470] = {.lex_state = 7, .external_lex_state = 3},
  [471] = {.lex_state = 7, .external_lex_state = 2},
  [472] = {.lex_state = 0, .external_lex_state = 4},
  [473] = {.lex_state = 0, .external_lex_state = 4},
  [474] = {.lex_state = 7, .external_lex_state = 2},
  [475] = {.lex_state = 1},
  [476] = {.lex_state = 7, .external_lex_state = 3},
  [477] = {.lex_state = 7, .external_lex_state = 3},
  [478] = {.lex_state = 1},
  [479] = {.lex_state = 7, .external_lex_state = 2},
  [480] = {.lex_state = 0, .external_lex_state = 4},
  [481] = {.lex_state = 0, .external_lex_state = 4},
  [482] = {.lex_state = 7, .external_lex_state = 2},
  [483] = {.lex_state = 1},
  [484] = {.lex_state = 7, .external_lex_state = 3},
  [485] = {.lex_state = 7, .external_lex_state = 3},
  [486] = {.lex_state = 7, .external_lex_state = 3},
  [487] = {.lex_state = 1},
  [488] = {.lex_state = 7, .external_lex_state = 2},
  [489] = {.lex_state = 0, .external_lex_state = 4},
  [490] = {.lex_state = 7, .external_lex_state = 5},
  [491] = {.lex_state = 7, .external_lex_state = 5},
  [492] = {.lex_state = 7, .external_lex_state = 6},
  [493] = {.lex_state = 2},
  [494] = {.lex_state = 0, .external_lex_state = 7},
  [495] = {.lex_state = 7, .external_lex_state = 6},
  [496] = {.lex_state = 0, .external_lex_state = 7},
  [497] = {.lex_state = 7, .external_lex_state = 5},
  [498] = {.lex_state = 7, .external_lex_state = 5},
  [499] = {.lex_state = 0, .external_lex_state = 7},
  [500] = {.lex_state = 7, .external_lex_state = 6},
  [501] = {.lex_state = 2},
  [502] = {.lex_state = 2},
  [503] = {.lex_state = 7, .external_lex_state = 6},
  [504] = {.lex_state = 0, .external_lex_state = 7},
  [505] = {.lex_state = 7, .external_lex_state = 5},
  [506] = {.lex_state = 7, .external_lex_state = 5},
  [507] = {.lex_state = 4},
  [508] = {.lex_state = 0, .external_lex_state = 7},
  [509] = {.lex_state = 7, .external_lex_state = 6},
  [510] = {.lex_state = 7, .external_lex_state = 6},
  [511] = {.lex_state = 7, .external_lex_state = 5},
  [512] = {.lex_state = 7, .external_lex_state = 6},
  [513] = {.lex_state = 2},
  [514] = {.lex_state = 2},
  [515] = {.lex_state = 0, .external_lex_state = 7},
  [516] = {.lex_state = 4},
  [517] = {.lex_state = 7, .external_lex_state = 5},
  [518] = {.lex_state = 2},
  [519] = {.lex_state = 0, .external_lex_state = 7},
  [520] = {.lex_state = 2},
  [521] = {.lex_state = 7, .external_lex_state = 5},
  [522] = {.lex_state = 7, .external_lex_state = 6},
  [523] = {.lex_state = 0, .external_lex_state = 7},
  [524] = {.lex_state = 2},
  [525] = {.lex_state = 2},
  [526] = {.lex_state = 2},
  [527] = {.lex_state = 7, .external_lex_state = 6},
  [528] = {.lex_state = 4},
  [529] = {.lex_state = 7, .external_lex_state = 6},
  [530] = {.lex_state = 2},
  [531] = {.lex_state = 2},
  [532] = {.lex_state = 0, .external_lex_state = 7},
  [533] = {.lex_state = 0, .external_lex_state = 7},
  [534] = {.lex_state = 7, .external_lex_state = 5},
  [535] = {.lex_state = 7, .external_lex_state = 5},
  [536] = {.lex_state = 7, .external_lex_state = 6},
  [537] = {.lex_state = 7, .external_lex_state = 6},
  [538] = {.lex_state = 4},
  [539] = {.lex_state = 7, .external_lex_state = 5},
  [540] = {.lex_state = 7, .external_lex_state = 6},
  [541] = {.lex_state = 0, .external_lex_state = 7},
  [542] = {.lex_state = 7, .external_lex_state = 5},
  [543] = {.lex_state = 2},
  [544] = {.lex_state = 0, .external_lex_state = 7},
  [545] = {.lex_state = 0, .external_lex_state = 7},
  [546] = {.lex_state = 7},
  [547] = {.lex_state = 4},
  [548] = {.lex_state = 4},
  [549] = {.lex_state = 4},
  [550] = {.lex_state = 4},
  [551] = {.lex_state = 7, .external_lex_state = 2},
  [552] = {.lex_state = 4},
  [553] = {.lex_state = 4},
  [554] = {.lex_state = 4},
  [555] = {.lex_state = 4},
  [556] = {.lex_state = 4},
  [557] = {.lex_state = 4},
  [558] = {.lex_state = 4},
  [559] = {.lex_state = 4},
  [560] = {.lex_state = 4},
  [561] = {.lex_state = 1},
  [562] = {.lex_state = 4},
  [563] = {.lex_state = 4},
  [564] = {.lex_state = 0, .external_lex_state = 4},
  [565] = {.lex_state = 7, .external_lex_state = 3},
  [566] = {.lex_state = 4},
  [567] = {.lex_state = 4},
  [568] = {.lex_state = 4},
  [569] = {.lex_state = 4},
  [570] = {.lex_state = 4},
  [571] = {.lex_state = 4},
  [572] = {.lex_state = 4},
  [573] = {.lex_state = 4},
  [574] = {.lex_state = 4},
  [575] = {.lex_state = 4},
  [576] = {.lex_state = 4},
  [577] = {.lex_state = 4},
  [578] = {.lex_state = 4},
  [579] = {.lex_state = 4},
  [580] = {.lex_state = 4},
  [581] = {.lex_state = 7},
  [582] = {.lex_state = 4},
  [583] = {.lex_state = 4},
  [584] = {.lex_state = 4},
  [585] = {.lex_state = 0, .external_lex_state = 7},
  [586] = {.lex_state = 4},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 4},
  [589] = {.lex_state = 7},
  [590] = {.lex_state = 7, .external_lex_state = 5},
  [591] = {.lex_state = 4},
  [592] = {.lex_state = 4},
  [593] = {.lex_state = 4},
  [594] = {.lex_state = 4},
  [595] = {.lex_state = 7, .external_lex_state = 6},
  [596] = {.lex_state = 2},
  [597] = {.lex_state = 4},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 4},
  [601] = {.lex_state = 4},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 4},
  [604] = {.lex_state = 4},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 4},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 4},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 4},
  [612] = {.lex_state = 4},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 4},
  [618] = {.lex_state = 4},
  [619] = {.lex_state = 7},
  [620] = {.lex_state = 7},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 7},
  [623] = {.lex_state = 7},
  [624] = {.lex_state = 5},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 7},
  [627] = {.lex_state = 7},
  [628] = {.lex_state = 4},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 7},
  [634] = {.lex_state = 7},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 4},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 4},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 4},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 7},
  [653] = {.lex_state = 7},
  [654] = {.lex_state = 4},
};

enum {
  ts_external_token__multi_str_content = 0,
  ts_external_token__multi_bytes_content = 1,
  ts_external_token__raw_str_content = 2,
  ts_external_token__raw_bytes_content = 3,
  ts_external_token__multi_raw_str_content = 4,
  ts_external_token__multi_raw_bytes_content = 5,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__multi_str_content] = sym__multi_str_content,
  [ts_external_token__multi_bytes_content] = sym__multi_bytes_content,
  [ts_external_token__raw_str_content] = sym__raw_str_content,
  [ts_external_token__raw_bytes_content] = sym__raw_bytes_content,
  [ts_external_token__multi_raw_str_content] = sym__multi_raw_str_content,
  [ts_external_token__multi_raw_bytes_content] = sym__multi_raw_bytes_content,
};

static const bool ts_external_scanner_states[8][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__multi_str_content] = true,
    [ts_external_token__multi_bytes_content] = true,
    [ts_external_token__raw_str_content] = true,
    [ts_external_token__raw_bytes_content] = true,
    [ts_external_token__multi_raw_str_content] = true,
    [ts_external_token__multi_raw_bytes_content] = true,
  },
  [2] = {
    [ts_external_token__raw_bytes_content] = true,
  },
  [3] = {
    [ts_external_token__multi_raw_bytes_content] = true,
  },
  [4] = {
    [ts_external_token__multi_bytes_content] = true,
  },
  [5] = {
    [ts_external_token__raw_str_content] = true,
  },
  [6] = {
    [ts_external_token__multi_raw_str_content] = true,
  },
  [7] = {
    [ts_external_token__multi_str_content] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_float32] = ACTIONS(1),
    [anon_sym_float64] = ACTIONS(1),
    [anon_sym_uint] = ACTIONS(1),
    [anon_sym_uint8] = ACTIONS(1),
    [anon_sym_uint16] = ACTIONS(1),
    [anon_sym_uint32] = ACTIONS(1),
    [anon_sym_uint64] = ACTIONS(1),
    [anon_sym_uint128] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_int8] = ACTIONS(1),
    [anon_sym_int16] = ACTIONS(1),
    [anon_sym_int32] = ACTIONS(1),
    [anon_sym_int64] = ACTIONS(1),
    [anon_sym_int128] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_bytes] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_len] = ACTIONS(1),
    [anon_sym_close] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_div] = ACTIONS(1),
    [anon_sym_mod] = ACTIONS(1),
    [anon_sym_quo] = ACTIONS(1),
    [anon_sym_rem] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_BANG_TILDE] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [sym_bottom] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [aux_sym_si_unit_token1] = ACTIONS(1),
    [sym_escape_char] = ACTIONS(1),
    [sym_escape_byte] = ACTIONS(1),
    [aux_sym__escape_unicode_token1] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_POUND_DQUOTE] = ACTIONS(1),
    [anon_sym_POUND_SQUOTE] = ACTIONS(1),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(1),
    [anon_sym_BSLASH_POUND_LPAREN] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym__multi_str_content] = ACTIONS(1),
    [sym__multi_bytes_content] = ACTIONS(1),
    [sym__raw_str_content] = ACTIONS(1),
    [sym__raw_bytes_content] = ACTIONS(1),
    [sym__multi_raw_str_content] = ACTIONS(1),
    [sym__multi_raw_bytes_content] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(636),
    [sym_package_clause] = STATE(19),
    [sym_import_declaration] = STATE(17),
    [sym_attribute] = STATE(2),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(31),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(31),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(31),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(31),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat1] = STATE(17),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_package] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_package_clause] = STATE(16),
    [sym_import_declaration] = STATE(20),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(27),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(27),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(27),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(27),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat1] = STATE(20),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(63),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_package] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_attribute] = STATE(8),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(206),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(206),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(206),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(206),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_struct_lit_repeat1] = STATE(8),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(65),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(67),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym_attribute] = STATE(5),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(206),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(206),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(206),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(206),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_struct_lit_repeat1] = STATE(5),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(69),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(71),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym_attribute] = STATE(5),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(206),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(206),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(206),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(206),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_struct_lit_repeat1] = STATE(5),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(73),
    [anon_sym_COMMA] = ACTIONS(76),
    [anon_sym__] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(82),
    [anon_sym_let] = ACTIONS(85),
    [anon_sym_if] = ACTIONS(88),
    [anon_sym_for] = ACTIONS(91),
    [anon_sym_number] = ACTIONS(94),
    [anon_sym_float] = ACTIONS(94),
    [anon_sym_float32] = ACTIONS(94),
    [anon_sym_float64] = ACTIONS(94),
    [anon_sym_uint] = ACTIONS(94),
    [anon_sym_uint8] = ACTIONS(94),
    [anon_sym_uint16] = ACTIONS(94),
    [anon_sym_uint32] = ACTIONS(94),
    [anon_sym_uint64] = ACTIONS(94),
    [anon_sym_uint128] = ACTIONS(94),
    [anon_sym_int] = ACTIONS(94),
    [anon_sym_int8] = ACTIONS(94),
    [anon_sym_int16] = ACTIONS(94),
    [anon_sym_int32] = ACTIONS(94),
    [anon_sym_int64] = ACTIONS(94),
    [anon_sym_int128] = ACTIONS(94),
    [anon_sym_string] = ACTIONS(94),
    [anon_sym_bytes] = ACTIONS(94),
    [anon_sym_bool] = ACTIONS(94),
    [anon_sym_AT] = ACTIONS(97),
    [anon_sym_DASH] = ACTIONS(100),
    [anon_sym_LBRACK] = ACTIONS(103),
    [anon_sym_LBRACE] = ACTIONS(106),
    [anon_sym_RBRACE] = ACTIONS(109),
    [anon_sym_LT] = ACTIONS(100),
    [anon_sym_GT] = ACTIONS(100),
    [anon_sym_STAR] = ACTIONS(111),
    [anon_sym_len] = ACTIONS(114),
    [anon_sym_close] = ACTIONS(114),
    [anon_sym_and] = ACTIONS(114),
    [anon_sym_or] = ACTIONS(114),
    [anon_sym_div] = ACTIONS(114),
    [anon_sym_mod] = ACTIONS(114),
    [anon_sym_quo] = ACTIONS(114),
    [anon_sym_rem] = ACTIONS(114),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(117),
    [anon_sym_BANG] = ACTIONS(100),
    [anon_sym_PLUS] = ACTIONS(100),
    [anon_sym_EQ_TILDE] = ACTIONS(111),
    [anon_sym_BANG_TILDE] = ACTIONS(111),
    [anon_sym_BANG_EQ] = ACTIONS(111),
    [anon_sym_LT_EQ] = ACTIONS(111),
    [anon_sym_GT_EQ] = ACTIONS(111),
    [sym_bottom] = ACTIONS(120),
    [anon_sym_true] = ACTIONS(123),
    [anon_sym_false] = ACTIONS(123),
    [sym_null] = ACTIONS(126),
    [sym_number] = ACTIONS(126),
    [sym_float] = ACTIONS(129),
    [anon_sym_DQUOTE] = ACTIONS(132),
    [anon_sym_SQUOTE] = ACTIONS(135),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(138),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(141),
    [anon_sym_POUND_DQUOTE] = ACTIONS(144),
    [anon_sym_POUND_SQUOTE] = ACTIONS(147),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(150),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(153),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym_attribute] = STATE(5),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(206),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(206),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(206),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(206),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_struct_lit_repeat1] = STATE(5),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(156),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(158),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym_attribute] = STATE(5),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(206),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(206),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(206),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(206),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_struct_lit_repeat1] = STATE(5),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(160),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(162),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym_attribute] = STATE(5),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(206),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(206),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(206),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(206),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_struct_lit_repeat1] = STATE(5),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(164),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(166),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym_attribute] = STATE(6),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(206),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(206),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(206),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(206),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_struct_lit_repeat1] = STATE(6),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(168),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(170),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym_attribute] = STATE(5),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(206),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(206),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(206),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(206),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_struct_lit_repeat1] = STATE(5),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(172),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(174),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym_attribute] = STATE(10),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(206),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(206),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(206),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(206),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_struct_lit_repeat1] = STATE(10),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(176),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(178),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym_attribute] = STATE(4),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(206),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(206),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(206),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(206),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_struct_lit_repeat1] = STATE(4),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(180),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(182),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym_attribute] = STATE(5),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(206),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(206),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(206),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(206),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_struct_lit_repeat1] = STATE(5),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(184),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(186),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym_attribute] = STATE(13),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(206),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(206),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(206),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(206),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_struct_lit_repeat1] = STATE(13),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(188),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(190),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym_attribute] = STATE(7),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(206),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(206),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(206),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(206),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_struct_lit_repeat1] = STATE(7),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(192),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(194),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym_import_declaration] = STATE(18),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(42),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(42),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(42),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(42),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat1] = STATE(18),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(196),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym_import_declaration] = STATE(203),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(49),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(49),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(49),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(49),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat1] = STATE(203),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(63),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym_import_declaration] = STATE(203),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(32),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(32),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(32),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(32),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat1] = STATE(203),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(198),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym_import_declaration] = STATE(20),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(24),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(24),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(24),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(24),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat1] = STATE(20),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(63),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym_import_declaration] = STATE(203),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(35),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(35),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(35),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(35),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat1] = STATE(203),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(196),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_attribute] = STATE(12),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(11),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(11),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(11),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(11),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(200),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(46),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(202),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(204),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_attribute] = STATE(207),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(205),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(205),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(205),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(205),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(206),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(29),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(208),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(210),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym_attribute] = STATE(207),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(205),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(205),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(205),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(205),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(212),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_attribute] = STATE(207),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(205),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(205),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(205),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(205),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(214),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(50),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(208),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(216),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym_attribute] = STATE(207),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(205),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(205),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(205),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(205),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(218),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(46),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(220),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(222),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym_attribute] = STATE(207),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(205),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(205),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(205),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(205),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(224),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(38),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(226),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(228),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(47),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(230),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(232),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(46),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(202),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(234),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym_attribute] = STATE(207),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(205),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(205),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(205),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(205),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(236),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(22),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(238),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(240),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym_attribute] = STATE(14),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(15),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(15),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(15),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(15),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(242),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym_attribute] = STATE(207),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(205),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(205),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(205),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(205),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(46),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(246),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(248),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym_attribute] = STATE(207),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(205),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(205),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(205),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(205),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(250),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym_attribute] = STATE(207),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(205),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(205),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(205),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(205),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(252),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(46),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(220),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(254),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(33),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(238),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(256),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym_attribute] = STATE(207),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(205),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(205),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(205),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(205),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(258),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym_attribute] = STATE(207),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(205),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(205),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(205),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(205),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(260),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym_attribute] = STATE(9),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(3),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(3),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(3),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(3),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(262),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(46),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(264),
    [sym_identifier] = ACTIONS(266),
    [anon_sym_COMMA] = ACTIONS(269),
    [anon_sym__] = ACTIONS(272),
    [anon_sym_LPAREN] = ACTIONS(275),
    [anon_sym_let] = ACTIONS(278),
    [anon_sym_if] = ACTIONS(281),
    [anon_sym_for] = ACTIONS(284),
    [anon_sym_number] = ACTIONS(287),
    [anon_sym_float] = ACTIONS(287),
    [anon_sym_float32] = ACTIONS(287),
    [anon_sym_float64] = ACTIONS(287),
    [anon_sym_uint] = ACTIONS(287),
    [anon_sym_uint8] = ACTIONS(287),
    [anon_sym_uint16] = ACTIONS(287),
    [anon_sym_uint32] = ACTIONS(287),
    [anon_sym_uint64] = ACTIONS(287),
    [anon_sym_uint128] = ACTIONS(287),
    [anon_sym_int] = ACTIONS(287),
    [anon_sym_int8] = ACTIONS(287),
    [anon_sym_int16] = ACTIONS(287),
    [anon_sym_int32] = ACTIONS(287),
    [anon_sym_int64] = ACTIONS(287),
    [anon_sym_int128] = ACTIONS(287),
    [anon_sym_string] = ACTIONS(287),
    [anon_sym_bytes] = ACTIONS(287),
    [anon_sym_bool] = ACTIONS(287),
    [anon_sym_DASH] = ACTIONS(290),
    [anon_sym_LBRACK] = ACTIONS(293),
    [anon_sym_LBRACE] = ACTIONS(296),
    [anon_sym_LT] = ACTIONS(290),
    [anon_sym_GT] = ACTIONS(290),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_len] = ACTIONS(302),
    [anon_sym_close] = ACTIONS(302),
    [anon_sym_and] = ACTIONS(302),
    [anon_sym_or] = ACTIONS(302),
    [anon_sym_div] = ACTIONS(302),
    [anon_sym_mod] = ACTIONS(302),
    [anon_sym_quo] = ACTIONS(302),
    [anon_sym_rem] = ACTIONS(302),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(305),
    [anon_sym_BANG] = ACTIONS(290),
    [anon_sym_PLUS] = ACTIONS(290),
    [anon_sym_EQ_TILDE] = ACTIONS(299),
    [anon_sym_BANG_TILDE] = ACTIONS(299),
    [anon_sym_BANG_EQ] = ACTIONS(299),
    [anon_sym_LT_EQ] = ACTIONS(299),
    [anon_sym_GT_EQ] = ACTIONS(299),
    [sym_bottom] = ACTIONS(308),
    [anon_sym_true] = ACTIONS(311),
    [anon_sym_false] = ACTIONS(311),
    [sym_null] = ACTIONS(314),
    [sym_number] = ACTIONS(314),
    [sym_float] = ACTIONS(317),
    [anon_sym_DQUOTE] = ACTIONS(320),
    [anon_sym_SQUOTE] = ACTIONS(323),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(326),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(329),
    [anon_sym_POUND_DQUOTE] = ACTIONS(332),
    [anon_sym_POUND_SQUOTE] = ACTIONS(335),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(338),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(341),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(46),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(344),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(346),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [sym_attribute] = STATE(207),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(205),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(205),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(205),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(205),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_RBRACE] = ACTIONS(348),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(41),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(208),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(350),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(228),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(228),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(228),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(228),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_source_file_repeat2] = STATE(46),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(220),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_COMMA] = ACTIONS(352),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym_attribute] = STATE(207),
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(205),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(205),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(205),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(205),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(354),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(356),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(358),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(360),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(360),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(362),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(364),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(360),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(364),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(366),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(368),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(368),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(354),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [ts_builtin_sym_end] = ACTIONS(368),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym_builtin_function] = STATE(621),
    [sym__declaration] = STATE(219),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(219),
    [sym__embedding] = STATE(202),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_field] = STATE(219),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_let_clause] = STATE(219),
    [sym_comprehension] = STATE(202),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(74),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(17),
    [anon_sym_if] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym_builtin_function] = STATE(621),
    [sym__list_elem] = STATE(246),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(246),
    [sym__embedding] = STATE(216),
    [sym__label_alias_expr] = STATE(641),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_comprehension] = STATE(216),
    [sym__alias_expr] = STATE(242),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_list_lit_repeat1] = STATE(69),
    [sym_identifier] = ACTIONS(370),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(372),
    [anon_sym_for] = ACTIONS(374),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_RBRACK] = ACTIONS(380),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym_builtin_function] = STATE(621),
    [sym__list_elem] = STATE(246),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(246),
    [sym__embedding] = STATE(216),
    [sym__label_alias_expr] = STATE(641),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_comprehension] = STATE(216),
    [sym__alias_expr] = STATE(242),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_list_lit_repeat1] = STATE(70),
    [sym_identifier] = ACTIONS(370),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(372),
    [anon_sym_for] = ACTIONS(374),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_RBRACK] = ACTIONS(382),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym_builtin_function] = STATE(621),
    [sym__list_elem] = STATE(246),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(246),
    [sym__embedding] = STATE(216),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_comprehension] = STATE(216),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_list_lit_repeat1] = STATE(71),
    [sym_identifier] = ACTIONS(370),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(372),
    [anon_sym_for] = ACTIONS(374),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_RBRACK] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym_builtin_function] = STATE(621),
    [sym__list_elem] = STATE(246),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(246),
    [sym__embedding] = STATE(216),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_comprehension] = STATE(216),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_list_lit_repeat1] = STATE(71),
    [sym_identifier] = ACTIONS(370),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(372),
    [anon_sym_for] = ACTIONS(374),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_RBRACK] = ACTIONS(386),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [sym_builtin_function] = STATE(621),
    [sym__list_elem] = STATE(246),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(246),
    [sym__embedding] = STATE(216),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_comprehension] = STATE(216),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_list_lit_repeat1] = STATE(71),
    [sym_identifier] = ACTIONS(388),
    [anon_sym__] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(394),
    [anon_sym_if] = ACTIONS(397),
    [anon_sym_for] = ACTIONS(400),
    [anon_sym_number] = ACTIONS(403),
    [anon_sym_float] = ACTIONS(403),
    [anon_sym_float32] = ACTIONS(403),
    [anon_sym_float64] = ACTIONS(403),
    [anon_sym_uint] = ACTIONS(403),
    [anon_sym_uint8] = ACTIONS(403),
    [anon_sym_uint16] = ACTIONS(403),
    [anon_sym_uint32] = ACTIONS(403),
    [anon_sym_uint64] = ACTIONS(403),
    [anon_sym_uint128] = ACTIONS(403),
    [anon_sym_int] = ACTIONS(403),
    [anon_sym_int8] = ACTIONS(403),
    [anon_sym_int16] = ACTIONS(403),
    [anon_sym_int32] = ACTIONS(403),
    [anon_sym_int64] = ACTIONS(403),
    [anon_sym_int128] = ACTIONS(403),
    [anon_sym_string] = ACTIONS(403),
    [anon_sym_bytes] = ACTIONS(403),
    [anon_sym_bool] = ACTIONS(403),
    [anon_sym_DASH] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(409),
    [anon_sym_RBRACK] = ACTIONS(412),
    [anon_sym_LBRACE] = ACTIONS(414),
    [anon_sym_LT] = ACTIONS(406),
    [anon_sym_GT] = ACTIONS(406),
    [anon_sym_STAR] = ACTIONS(417),
    [anon_sym_len] = ACTIONS(420),
    [anon_sym_close] = ACTIONS(420),
    [anon_sym_and] = ACTIONS(420),
    [anon_sym_or] = ACTIONS(420),
    [anon_sym_div] = ACTIONS(420),
    [anon_sym_mod] = ACTIONS(420),
    [anon_sym_quo] = ACTIONS(420),
    [anon_sym_rem] = ACTIONS(420),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(423),
    [anon_sym_BANG] = ACTIONS(406),
    [anon_sym_PLUS] = ACTIONS(406),
    [anon_sym_EQ_TILDE] = ACTIONS(417),
    [anon_sym_BANG_TILDE] = ACTIONS(417),
    [anon_sym_BANG_EQ] = ACTIONS(417),
    [anon_sym_LT_EQ] = ACTIONS(417),
    [anon_sym_GT_EQ] = ACTIONS(417),
    [sym_bottom] = ACTIONS(426),
    [anon_sym_true] = ACTIONS(429),
    [anon_sym_false] = ACTIONS(429),
    [sym_null] = ACTIONS(432),
    [sym_number] = ACTIONS(432),
    [sym_float] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(438),
    [anon_sym_SQUOTE] = ACTIONS(441),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(444),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(447),
    [anon_sym_POUND_DQUOTE] = ACTIONS(450),
    [anon_sym_POUND_SQUOTE] = ACTIONS(453),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(456),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(459),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [sym_builtin_function] = STATE(621),
    [sym__list_elem] = STATE(246),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(246),
    [sym__embedding] = STATE(216),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_comprehension] = STATE(216),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_list_lit_repeat1] = STATE(70),
    [sym_identifier] = ACTIONS(370),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(372),
    [anon_sym_for] = ACTIONS(374),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_RBRACK] = ACTIONS(382),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [sym_builtin_function] = STATE(621),
    [sym__list_elem] = STATE(246),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(246),
    [sym__embedding] = STATE(216),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_comprehension] = STATE(216),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_list_lit_repeat1] = STATE(69),
    [sym_identifier] = ACTIONS(370),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(372),
    [anon_sym_for] = ACTIONS(374),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_RBRACK] = ACTIONS(380),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym__value] = STATE(196),
    [sym__alias_expr] = STATE(201),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [aux_sym_field_repeat1] = STATE(80),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(462),
    [anon_sym_if] = ACTIONS(462),
    [anon_sym_for] = ACTIONS(462),
    [anon_sym_number] = ACTIONS(23),
    [anon_sym_float] = ACTIONS(23),
    [anon_sym_float32] = ACTIONS(23),
    [anon_sym_float64] = ACTIONS(23),
    [anon_sym_uint] = ACTIONS(23),
    [anon_sym_uint8] = ACTIONS(23),
    [anon_sym_uint16] = ACTIONS(23),
    [anon_sym_uint32] = ACTIONS(23),
    [anon_sym_uint64] = ACTIONS(23),
    [anon_sym_uint128] = ACTIONS(23),
    [anon_sym_int] = ACTIONS(23),
    [anon_sym_int8] = ACTIONS(23),
    [anon_sym_int16] = ACTIONS(23),
    [anon_sym_int32] = ACTIONS(23),
    [anon_sym_int64] = ACTIONS(23),
    [anon_sym_int128] = ACTIONS(23),
    [anon_sym_string] = ACTIONS(23),
    [anon_sym_bytes] = ACTIONS(23),
    [anon_sym_bool] = ACTIONS(23),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(240),
    [sym__embedding] = STATE(239),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_comprehension] = STATE(239),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [sym_identifier] = ACTIONS(370),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(372),
    [anon_sym_for] = ACTIONS(374),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_RBRACK] = ACTIONS(466),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_ellipsis] = STATE(241),
    [sym__embedding] = STATE(239),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_comprehension] = STATE(239),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [sym_identifier] = ACTIONS(370),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(372),
    [anon_sym_for] = ACTIONS(374),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_RBRACK] = ACTIONS(468),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(45),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(172),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [ts_builtin_sym_end] = ACTIONS(470),
    [sym_identifier] = ACTIONS(472),
    [anon_sym_COMMA] = ACTIONS(470),
    [anon_sym__] = ACTIONS(472),
    [anon_sym_LPAREN] = ACTIONS(470),
    [anon_sym_let] = ACTIONS(472),
    [anon_sym_if] = ACTIONS(472),
    [anon_sym_for] = ACTIONS(472),
    [anon_sym_number] = ACTIONS(472),
    [anon_sym_float] = ACTIONS(472),
    [anon_sym_float32] = ACTIONS(472),
    [anon_sym_float64] = ACTIONS(472),
    [anon_sym_uint] = ACTIONS(472),
    [anon_sym_uint8] = ACTIONS(472),
    [anon_sym_uint16] = ACTIONS(472),
    [anon_sym_uint32] = ACTIONS(472),
    [anon_sym_uint64] = ACTIONS(472),
    [anon_sym_uint128] = ACTIONS(472),
    [anon_sym_int] = ACTIONS(472),
    [anon_sym_int8] = ACTIONS(472),
    [anon_sym_int16] = ACTIONS(472),
    [anon_sym_int32] = ACTIONS(472),
    [anon_sym_int64] = ACTIONS(472),
    [anon_sym_int128] = ACTIONS(472),
    [anon_sym_string] = ACTIONS(472),
    [anon_sym_bytes] = ACTIONS(472),
    [anon_sym_bool] = ACTIONS(472),
    [anon_sym_AT] = ACTIONS(470),
    [anon_sym_DASH] = ACTIONS(472),
    [anon_sym_LBRACK] = ACTIONS(470),
    [anon_sym_RBRACK] = ACTIONS(470),
    [anon_sym_LBRACE] = ACTIONS(470),
    [anon_sym_RBRACE] = ACTIONS(470),
    [anon_sym_LT] = ACTIONS(472),
    [anon_sym_GT] = ACTIONS(472),
    [anon_sym_STAR] = ACTIONS(470),
    [anon_sym_len] = ACTIONS(472),
    [anon_sym_close] = ACTIONS(472),
    [anon_sym_and] = ACTIONS(472),
    [anon_sym_or] = ACTIONS(472),
    [anon_sym_div] = ACTIONS(472),
    [anon_sym_mod] = ACTIONS(472),
    [anon_sym_quo] = ACTIONS(472),
    [anon_sym_rem] = ACTIONS(472),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(470),
    [anon_sym_BANG] = ACTIONS(472),
    [anon_sym_PLUS] = ACTIONS(472),
    [anon_sym_EQ_TILDE] = ACTIONS(470),
    [anon_sym_BANG_TILDE] = ACTIONS(470),
    [anon_sym_BANG_EQ] = ACTIONS(470),
    [anon_sym_LT_EQ] = ACTIONS(470),
    [anon_sym_GT_EQ] = ACTIONS(470),
    [sym_bottom] = ACTIONS(470),
    [anon_sym_true] = ACTIONS(472),
    [anon_sym_false] = ACTIONS(472),
    [sym_null] = ACTIONS(472),
    [sym_number] = ACTIONS(472),
    [sym_float] = ACTIONS(472),
    [anon_sym_DQUOTE] = ACTIONS(472),
    [anon_sym_SQUOTE] = ACTIONS(472),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(470),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(470),
    [anon_sym_POUND_DQUOTE] = ACTIONS(472),
    [anon_sym_POUND_SQUOTE] = ACTIONS(472),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(470),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(470),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym__embedding] = STATE(239),
    [sym_for_clause] = STATE(435),
    [sym_guard_clause] = STATE(435),
    [sym_comprehension] = STATE(239),
    [sym__alias_expr] = STATE(192),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(179),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [sym_identifier] = ACTIONS(370),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(372),
    [anon_sym_for] = ACTIONS(374),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(642),
    [sym_optional] = STATE(642),
    [sym__label_expr] = STATE(642),
    [sym_parenthesized_expression] = STATE(143),
    [sym_expression] = STATE(178),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(127),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(136),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [sym_identifier] = ACTIONS(474),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_let] = ACTIONS(476),
    [anon_sym_if] = ACTIONS(476),
    [anon_sym_for] = ACTIONS(476),
    [anon_sym_number] = ACTIONS(478),
    [anon_sym_float] = ACTIONS(478),
    [anon_sym_float32] = ACTIONS(478),
    [anon_sym_float64] = ACTIONS(478),
    [anon_sym_uint] = ACTIONS(478),
    [anon_sym_uint8] = ACTIONS(478),
    [anon_sym_uint16] = ACTIONS(478),
    [anon_sym_uint32] = ACTIONS(478),
    [anon_sym_uint64] = ACTIONS(478),
    [anon_sym_uint128] = ACTIONS(478),
    [anon_sym_int] = ACTIONS(478),
    [anon_sym_int8] = ACTIONS(478),
    [anon_sym_int16] = ACTIONS(478),
    [anon_sym_int32] = ACTIONS(478),
    [anon_sym_int64] = ACTIONS(478),
    [anon_sym_int128] = ACTIONS(478),
    [anon_sym_string] = ACTIONS(478),
    [anon_sym_bytes] = ACTIONS(478),
    [anon_sym_bool] = ACTIONS(478),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(647),
    [sym_optional] = STATE(647),
    [sym__label_expr] = STATE(647),
    [sym_label] = STATE(648),
    [sym_parenthesized_expression] = STATE(594),
    [sym_primary_expression] = STATE(624),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(549),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(593),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [aux_sym_field_repeat1] = STATE(80),
    [sym_identifier] = ACTIONS(480),
    [anon_sym__] = ACTIONS(483),
    [anon_sym_LPAREN] = ACTIONS(486),
    [anon_sym_let] = ACTIONS(489),
    [anon_sym_if] = ACTIONS(489),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_number] = ACTIONS(492),
    [anon_sym_float] = ACTIONS(492),
    [anon_sym_float32] = ACTIONS(492),
    [anon_sym_float64] = ACTIONS(492),
    [anon_sym_uint] = ACTIONS(492),
    [anon_sym_uint8] = ACTIONS(492),
    [anon_sym_uint16] = ACTIONS(492),
    [anon_sym_uint32] = ACTIONS(492),
    [anon_sym_uint64] = ACTIONS(492),
    [anon_sym_uint128] = ACTIONS(492),
    [anon_sym_int] = ACTIONS(492),
    [anon_sym_int8] = ACTIONS(492),
    [anon_sym_int16] = ACTIONS(492),
    [anon_sym_int32] = ACTIONS(492),
    [anon_sym_int64] = ACTIONS(492),
    [anon_sym_int128] = ACTIONS(492),
    [anon_sym_string] = ACTIONS(492),
    [anon_sym_bytes] = ACTIONS(492),
    [anon_sym_bool] = ACTIONS(492),
    [anon_sym_DASH] = ACTIONS(495),
    [anon_sym_LBRACK] = ACTIONS(497),
    [anon_sym_LBRACE] = ACTIONS(500),
    [anon_sym_LT] = ACTIONS(495),
    [anon_sym_GT] = ACTIONS(495),
    [anon_sym_STAR] = ACTIONS(503),
    [anon_sym_len] = ACTIONS(505),
    [anon_sym_close] = ACTIONS(505),
    [anon_sym_and] = ACTIONS(505),
    [anon_sym_or] = ACTIONS(505),
    [anon_sym_div] = ACTIONS(505),
    [anon_sym_mod] = ACTIONS(505),
    [anon_sym_quo] = ACTIONS(505),
    [anon_sym_rem] = ACTIONS(505),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_PLUS] = ACTIONS(495),
    [anon_sym_EQ_TILDE] = ACTIONS(503),
    [anon_sym_BANG_TILDE] = ACTIONS(503),
    [anon_sym_BANG_EQ] = ACTIONS(503),
    [anon_sym_LT_EQ] = ACTIONS(503),
    [anon_sym_GT_EQ] = ACTIONS(503),
    [sym_bottom] = ACTIONS(508),
    [anon_sym_true] = ACTIONS(511),
    [anon_sym_false] = ACTIONS(511),
    [sym_null] = ACTIONS(514),
    [sym_number] = ACTIONS(514),
    [sym_float] = ACTIONS(517),
    [anon_sym_DQUOTE] = ACTIONS(520),
    [anon_sym_SQUOTE] = ACTIONS(523),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(526),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(529),
    [anon_sym_POUND_DQUOTE] = ACTIONS(532),
    [anon_sym_POUND_SQUOTE] = ACTIONS(535),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(538),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(541),
    [sym_comment] = ACTIONS(3),
  },
  [81] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(413),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [aux_sym_arguments_repeat1] = STATE(615),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_COMMA] = ACTIONS(546),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_RPAREN] = ACTIONS(552),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [82] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(412),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [aux_sym_arguments_repeat1] = STATE(613),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_COMMA] = ACTIONS(546),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_RPAREN] = ACTIONS(588),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(408),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_EQ] = ACTIONS(590),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_QMARK] = ACTIONS(592),
    [anon_sym_COLON] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [84] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(414),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_COMMA] = ACTIONS(594),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_RPAREN] = ACTIONS(594),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [85] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(395),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [86] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(173),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [sym_identifier] = ACTIONS(596),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(420),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [88] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(426),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [89] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(427),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [90] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(182),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [sym_identifier] = ACTIONS(596),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [91] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(419),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [92] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(410),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [93] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(429),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [94] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(399),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [95] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(428),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [96] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(422),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [97] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(425),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [98] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(417),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [99] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(424),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [100] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(423),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [101] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(415),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [102] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(178),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [sym_identifier] = ACTIONS(596),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [103] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(409),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [104] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(402),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [105] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(408),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [106] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(406),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [107] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(401),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [108] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(183),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [sym_identifier] = ACTIONS(596),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [109] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(403),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [110] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(405),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [111] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(411),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [112] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym_parenthesized_expression] = STATE(375),
    [sym_expression] = STATE(404),
    [sym_primary_expression] = STATE(376),
    [sym_binary_expression] = STATE(400),
    [sym_unary_expression] = STATE(400),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(364),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(351),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(544),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(550),
    [anon_sym_number] = ACTIONS(554),
    [anon_sym_float] = ACTIONS(554),
    [anon_sym_float32] = ACTIONS(554),
    [anon_sym_float64] = ACTIONS(554),
    [anon_sym_uint] = ACTIONS(554),
    [anon_sym_uint8] = ACTIONS(554),
    [anon_sym_uint16] = ACTIONS(554),
    [anon_sym_uint32] = ACTIONS(554),
    [anon_sym_uint64] = ACTIONS(554),
    [anon_sym_uint128] = ACTIONS(554),
    [anon_sym_int] = ACTIONS(554),
    [anon_sym_int8] = ACTIONS(554),
    [anon_sym_int16] = ACTIONS(554),
    [anon_sym_int32] = ACTIONS(554),
    [anon_sym_int64] = ACTIONS(554),
    [anon_sym_int128] = ACTIONS(554),
    [anon_sym_string] = ACTIONS(554),
    [anon_sym_bytes] = ACTIONS(554),
    [anon_sym_bool] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(558),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(562),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_EQ_TILDE] = ACTIONS(562),
    [anon_sym_BANG_TILDE] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(572),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [113] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(171),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [sym_identifier] = ACTIONS(596),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [114] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(181),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [sym_identifier] = ACTIONS(596),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [115] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(177),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [sym_identifier] = ACTIONS(596),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [116] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(176),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [sym_identifier] = ACTIONS(596),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [117] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(175),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [sym_identifier] = ACTIONS(596),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [118] = {
    [sym_builtin_function] = STATE(621),
    [sym_list_lit] = STATE(164),
    [sym_struct_lit] = STATE(164),
    [sym_parenthesized_expression] = STATE(164),
    [sym_expression] = STATE(174),
    [sym_primary_expression] = STATE(159),
    [sym_binary_expression] = STATE(180),
    [sym_unary_expression] = STATE(180),
    [sym_call_expression] = STATE(164),
    [sym_index_expression] = STATE(164),
    [sym_selector_expression] = STATE(133),
    [sym__literal] = STATE(164),
    [sym_primitive_type] = STATE(164),
    [sym_top] = STATE(164),
    [sym_boolean] = STATE(164),
    [sym_si_unit] = STATE(164),
    [sym_string] = STATE(164),
    [sym__simple_string_lit] = STATE(134),
    [sym__simple_bytes_lit] = STATE(134),
    [sym__multiline_string_lit] = STATE(134),
    [sym__multiline_bytes_lit] = STATE(134),
    [sym__simple_raw_string_lit] = STATE(134),
    [sym__simple_raw_bytes_lit] = STATE(134),
    [sym__multiline_raw_string_lit] = STATE(134),
    [sym__multiline_raw_bytes_lit] = STATE(134),
    [sym_identifier] = ACTIONS(596),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_number] = ACTIONS(376),
    [anon_sym_float] = ACTIONS(376),
    [anon_sym_float32] = ACTIONS(376),
    [anon_sym_float64] = ACTIONS(376),
    [anon_sym_uint] = ACTIONS(376),
    [anon_sym_uint8] = ACTIONS(376),
    [anon_sym_uint16] = ACTIONS(376),
    [anon_sym_uint32] = ACTIONS(376),
    [anon_sym_uint64] = ACTIONS(376),
    [anon_sym_uint128] = ACTIONS(376),
    [anon_sym_int] = ACTIONS(376),
    [anon_sym_int8] = ACTIONS(376),
    [anon_sym_int16] = ACTIONS(376),
    [anon_sym_int32] = ACTIONS(376),
    [anon_sym_int64] = ACTIONS(376),
    [anon_sym_int128] = ACTIONS(376),
    [anon_sym_string] = ACTIONS(376),
    [anon_sym_bytes] = ACTIONS(376),
    [anon_sym_bool] = ACTIONS(376),
    [anon_sym_DASH] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(27),
    [anon_sym_GT] = ACTIONS(27),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_EQ_TILDE] = ACTIONS(33),
    [anon_sym_BANG_TILDE] = ACTIONS(33),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(33),
    [anon_sym_GT_EQ] = ACTIONS(33),
    [sym_bottom] = ACTIONS(39),
    [anon_sym_true] = ACTIONS(41),
    [anon_sym_false] = ACTIONS(41),
    [sym_null] = ACTIONS(43),
    [sym_number] = ACTIONS(43),
    [sym_float] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(47),
    [anon_sym_SQUOTE] = ACTIONS(49),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(51),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(53),
    [anon_sym_POUND_DQUOTE] = ACTIONS(55),
    [anon_sym_POUND_SQUOTE] = ACTIONS(57),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(59),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [119] = {
    [ts_builtin_sym_end] = ACTIONS(598),
    [sym_identifier] = ACTIONS(600),
    [anon_sym_COMMA] = ACTIONS(598),
    [anon_sym_DOT] = ACTIONS(600),
    [anon_sym__] = ACTIONS(600),
    [anon_sym_LPAREN] = ACTIONS(598),
    [anon_sym_RPAREN] = ACTIONS(598),
    [anon_sym_let] = ACTIONS(600),
    [anon_sym_if] = ACTIONS(600),
    [anon_sym_for] = ACTIONS(600),
    [anon_sym_number] = ACTIONS(600),
    [anon_sym_float] = ACTIONS(600),
    [anon_sym_float32] = ACTIONS(600),
    [anon_sym_float64] = ACTIONS(600),
    [anon_sym_uint] = ACTIONS(600),
    [anon_sym_uint8] = ACTIONS(600),
    [anon_sym_uint16] = ACTIONS(600),
    [anon_sym_uint32] = ACTIONS(600),
    [anon_sym_uint64] = ACTIONS(600),
    [anon_sym_uint128] = ACTIONS(600),
    [anon_sym_int] = ACTIONS(600),
    [anon_sym_int8] = ACTIONS(600),
    [anon_sym_int16] = ACTIONS(600),
    [anon_sym_int32] = ACTIONS(600),
    [anon_sym_int64] = ACTIONS(600),
    [anon_sym_int128] = ACTIONS(600),
    [anon_sym_string] = ACTIONS(600),
    [anon_sym_bytes] = ACTIONS(600),
    [anon_sym_bool] = ACTIONS(600),
    [anon_sym_AT] = ACTIONS(598),
    [anon_sym_DASH] = ACTIONS(600),
    [anon_sym_LBRACK] = ACTIONS(598),
    [anon_sym_RBRACK] = ACTIONS(598),
    [anon_sym_LBRACE] = ACTIONS(598),
    [anon_sym_RBRACE] = ACTIONS(598),
    [anon_sym_LT] = ACTIONS(600),
    [anon_sym_GT] = ACTIONS(600),
    [anon_sym_STAR] = ACTIONS(598),
    [anon_sym_len] = ACTIONS(600),
    [anon_sym_close] = ACTIONS(600),
    [anon_sym_and] = ACTIONS(600),
    [anon_sym_or] = ACTIONS(600),
    [anon_sym_div] = ACTIONS(600),
    [anon_sym_mod] = ACTIONS(600),
    [anon_sym_quo] = ACTIONS(600),
    [anon_sym_rem] = ACTIONS(600),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(598),
    [anon_sym_BANG] = ACTIONS(600),
    [anon_sym_QMARK] = ACTIONS(598),
    [anon_sym_COLON] = ACTIONS(598),
    [anon_sym_PLUS] = ACTIONS(600),
    [anon_sym_SLASH] = ACTIONS(600),
    [anon_sym_PIPE] = ACTIONS(600),
    [anon_sym_AMP] = ACTIONS(600),
    [anon_sym_PIPE_PIPE] = ACTIONS(598),
    [anon_sym_AMP_AMP] = ACTIONS(598),
    [anon_sym_EQ_EQ] = ACTIONS(598),
    [anon_sym_EQ_TILDE] = ACTIONS(598),
    [anon_sym_BANG_TILDE] = ACTIONS(598),
    [anon_sym_BANG_EQ] = ACTIONS(598),
    [anon_sym_LT_EQ] = ACTIONS(598),
    [anon_sym_GT_EQ] = ACTIONS(598),
    [sym_bottom] = ACTIONS(598),
    [anon_sym_true] = ACTIONS(600),
    [anon_sym_false] = ACTIONS(600),
    [sym_null] = ACTIONS(600),
    [sym_number] = ACTIONS(600),
    [sym_float] = ACTIONS(600),
    [anon_sym_DQUOTE] = ACTIONS(600),
    [anon_sym_SQUOTE] = ACTIONS(600),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(598),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(598),
    [anon_sym_POUND_DQUOTE] = ACTIONS(600),
    [anon_sym_POUND_SQUOTE] = ACTIONS(600),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(598),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(598),
    [sym_comment] = ACTIONS(3),
  },
  [120] = {
    [sym_arguments] = STATE(166),
    [ts_builtin_sym_end] = ACTIONS(602),
    [sym_identifier] = ACTIONS(604),
    [anon_sym_COMMA] = ACTIONS(602),
    [anon_sym_DOT] = ACTIONS(604),
    [anon_sym__] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(606),
    [anon_sym_let] = ACTIONS(604),
    [anon_sym_if] = ACTIONS(604),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_number] = ACTIONS(604),
    [anon_sym_float] = ACTIONS(604),
    [anon_sym_float32] = ACTIONS(604),
    [anon_sym_float64] = ACTIONS(604),
    [anon_sym_uint] = ACTIONS(604),
    [anon_sym_uint8] = ACTIONS(604),
    [anon_sym_uint16] = ACTIONS(604),
    [anon_sym_uint32] = ACTIONS(604),
    [anon_sym_uint64] = ACTIONS(604),
    [anon_sym_uint128] = ACTIONS(604),
    [anon_sym_int] = ACTIONS(604),
    [anon_sym_int8] = ACTIONS(604),
    [anon_sym_int16] = ACTIONS(604),
    [anon_sym_int32] = ACTIONS(604),
    [anon_sym_int64] = ACTIONS(604),
    [anon_sym_int128] = ACTIONS(604),
    [anon_sym_string] = ACTIONS(604),
    [anon_sym_bytes] = ACTIONS(604),
    [anon_sym_bool] = ACTIONS(604),
    [anon_sym_AT] = ACTIONS(602),
    [anon_sym_DASH] = ACTIONS(604),
    [anon_sym_LBRACK] = ACTIONS(602),
    [anon_sym_LBRACE] = ACTIONS(602),
    [anon_sym_RBRACE] = ACTIONS(602),
    [anon_sym_LT] = ACTIONS(604),
    [anon_sym_GT] = ACTIONS(604),
    [anon_sym_EQ] = ACTIONS(608),
    [anon_sym_STAR] = ACTIONS(602),
    [anon_sym_len] = ACTIONS(604),
    [anon_sym_close] = ACTIONS(604),
    [anon_sym_and] = ACTIONS(604),
    [anon_sym_or] = ACTIONS(604),
    [anon_sym_div] = ACTIONS(604),
    [anon_sym_mod] = ACTIONS(604),
    [anon_sym_quo] = ACTIONS(604),
    [anon_sym_rem] = ACTIONS(604),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(602),
    [anon_sym_BANG] = ACTIONS(610),
    [anon_sym_QMARK] = ACTIONS(612),
    [anon_sym_COLON] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(604),
    [anon_sym_SLASH] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(604),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE_PIPE] = ACTIONS(602),
    [anon_sym_AMP_AMP] = ACTIONS(602),
    [anon_sym_EQ_EQ] = ACTIONS(602),
    [anon_sym_EQ_TILDE] = ACTIONS(602),
    [anon_sym_BANG_TILDE] = ACTIONS(602),
    [anon_sym_BANG_EQ] = ACTIONS(602),
    [anon_sym_LT_EQ] = ACTIONS(602),
    [anon_sym_GT_EQ] = ACTIONS(602),
    [sym_bottom] = ACTIONS(602),
    [anon_sym_true] = ACTIONS(604),
    [anon_sym_false] = ACTIONS(604),
    [sym_null] = ACTIONS(604),
    [sym_number] = ACTIONS(604),
    [sym_float] = ACTIONS(604),
    [anon_sym_DQUOTE] = ACTIONS(604),
    [anon_sym_SQUOTE] = ACTIONS(604),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(602),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(602),
    [anon_sym_POUND_DQUOTE] = ACTIONS(604),
    [anon_sym_POUND_SQUOTE] = ACTIONS(604),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(602),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(602),
    [sym_comment] = ACTIONS(3),
  },
  [121] = {
    [ts_builtin_sym_end] = ACTIONS(614),
    [sym_identifier] = ACTIONS(616),
    [anon_sym_COMMA] = ACTIONS(614),
    [anon_sym_DOT] = ACTIONS(616),
    [anon_sym__] = ACTIONS(616),
    [anon_sym_LPAREN] = ACTIONS(614),
    [anon_sym_RPAREN] = ACTIONS(614),
    [anon_sym_let] = ACTIONS(616),
    [anon_sym_if] = ACTIONS(616),
    [anon_sym_for] = ACTIONS(616),
    [anon_sym_number] = ACTIONS(616),
    [anon_sym_float] = ACTIONS(616),
    [anon_sym_float32] = ACTIONS(616),
    [anon_sym_float64] = ACTIONS(616),
    [anon_sym_uint] = ACTIONS(616),
    [anon_sym_uint8] = ACTIONS(616),
    [anon_sym_uint16] = ACTIONS(616),
    [anon_sym_uint32] = ACTIONS(616),
    [anon_sym_uint64] = ACTIONS(616),
    [anon_sym_uint128] = ACTIONS(616),
    [anon_sym_int] = ACTIONS(616),
    [anon_sym_int8] = ACTIONS(616),
    [anon_sym_int16] = ACTIONS(616),
    [anon_sym_int32] = ACTIONS(616),
    [anon_sym_int64] = ACTIONS(616),
    [anon_sym_int128] = ACTIONS(616),
    [anon_sym_string] = ACTIONS(616),
    [anon_sym_bytes] = ACTIONS(616),
    [anon_sym_bool] = ACTIONS(616),
    [anon_sym_AT] = ACTIONS(614),
    [anon_sym_DASH] = ACTIONS(616),
    [anon_sym_LBRACK] = ACTIONS(614),
    [anon_sym_RBRACK] = ACTIONS(614),
    [anon_sym_LBRACE] = ACTIONS(614),
    [anon_sym_RBRACE] = ACTIONS(614),
    [anon_sym_LT] = ACTIONS(616),
    [anon_sym_GT] = ACTIONS(616),
    [anon_sym_STAR] = ACTIONS(614),
    [anon_sym_len] = ACTIONS(616),
    [anon_sym_close] = ACTIONS(616),
    [anon_sym_and] = ACTIONS(616),
    [anon_sym_or] = ACTIONS(616),
    [anon_sym_div] = ACTIONS(616),
    [anon_sym_mod] = ACTIONS(616),
    [anon_sym_quo] = ACTIONS(616),
    [anon_sym_rem] = ACTIONS(616),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(614),
    [anon_sym_BANG] = ACTIONS(616),
    [anon_sym_QMARK] = ACTIONS(614),
    [anon_sym_COLON] = ACTIONS(614),
    [anon_sym_PLUS] = ACTIONS(616),
    [anon_sym_SLASH] = ACTIONS(616),
    [anon_sym_PIPE] = ACTIONS(616),
    [anon_sym_AMP] = ACTIONS(616),
    [anon_sym_PIPE_PIPE] = ACTIONS(614),
    [anon_sym_AMP_AMP] = ACTIONS(614),
    [anon_sym_EQ_EQ] = ACTIONS(614),
    [anon_sym_EQ_TILDE] = ACTIONS(614),
    [anon_sym_BANG_TILDE] = ACTIONS(614),
    [anon_sym_BANG_EQ] = ACTIONS(614),
    [anon_sym_LT_EQ] = ACTIONS(614),
    [anon_sym_GT_EQ] = ACTIONS(614),
    [sym_bottom] = ACTIONS(614),
    [anon_sym_true] = ACTIONS(616),
    [anon_sym_false] = ACTIONS(616),
    [sym_null] = ACTIONS(616),
    [sym_number] = ACTIONS(616),
    [sym_float] = ACTIONS(616),
    [anon_sym_DQUOTE] = ACTIONS(616),
    [anon_sym_SQUOTE] = ACTIONS(616),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(614),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(614),
    [anon_sym_POUND_DQUOTE] = ACTIONS(616),
    [anon_sym_POUND_SQUOTE] = ACTIONS(616),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(614),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(614),
    [sym_comment] = ACTIONS(3),
  },
  [122] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(637),
    [sym_optional] = STATE(637),
    [sym__label_expr] = STATE(637),
    [sym_parenthesized_expression] = STATE(594),
    [sym_primary_expression] = STATE(624),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(549),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(593),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(618),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(620),
    [anon_sym_let] = ACTIONS(476),
    [anon_sym_if] = ACTIONS(476),
    [anon_sym_for] = ACTIONS(476),
    [anon_sym_number] = ACTIONS(622),
    [anon_sym_float] = ACTIONS(622),
    [anon_sym_float32] = ACTIONS(622),
    [anon_sym_float64] = ACTIONS(622),
    [anon_sym_uint] = ACTIONS(622),
    [anon_sym_uint8] = ACTIONS(622),
    [anon_sym_uint16] = ACTIONS(622),
    [anon_sym_uint32] = ACTIONS(622),
    [anon_sym_uint64] = ACTIONS(622),
    [anon_sym_uint128] = ACTIONS(622),
    [anon_sym_int] = ACTIONS(622),
    [anon_sym_int8] = ACTIONS(622),
    [anon_sym_int16] = ACTIONS(622),
    [anon_sym_int32] = ACTIONS(622),
    [anon_sym_int64] = ACTIONS(622),
    [anon_sym_int128] = ACTIONS(622),
    [anon_sym_string] = ACTIONS(622),
    [anon_sym_bytes] = ACTIONS(622),
    [anon_sym_bool] = ACTIONS(622),
    [anon_sym_LBRACK] = ACTIONS(624),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(626),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [123] = {
    [ts_builtin_sym_end] = ACTIONS(628),
    [sym_identifier] = ACTIONS(630),
    [anon_sym_COMMA] = ACTIONS(628),
    [anon_sym_DOT] = ACTIONS(630),
    [anon_sym__] = ACTIONS(630),
    [anon_sym_LPAREN] = ACTIONS(628),
    [anon_sym_let] = ACTIONS(630),
    [anon_sym_if] = ACTIONS(630),
    [anon_sym_for] = ACTIONS(630),
    [anon_sym_number] = ACTIONS(630),
    [anon_sym_float] = ACTIONS(630),
    [anon_sym_float32] = ACTIONS(630),
    [anon_sym_float64] = ACTIONS(630),
    [anon_sym_uint] = ACTIONS(630),
    [anon_sym_uint8] = ACTIONS(630),
    [anon_sym_uint16] = ACTIONS(630),
    [anon_sym_uint32] = ACTIONS(630),
    [anon_sym_uint64] = ACTIONS(630),
    [anon_sym_uint128] = ACTIONS(630),
    [anon_sym_int] = ACTIONS(630),
    [anon_sym_int8] = ACTIONS(630),
    [anon_sym_int16] = ACTIONS(630),
    [anon_sym_int32] = ACTIONS(630),
    [anon_sym_int64] = ACTIONS(630),
    [anon_sym_int128] = ACTIONS(630),
    [anon_sym_string] = ACTIONS(630),
    [anon_sym_bytes] = ACTIONS(630),
    [anon_sym_bool] = ACTIONS(630),
    [anon_sym_AT] = ACTIONS(628),
    [anon_sym_DASH] = ACTIONS(630),
    [anon_sym_LBRACK] = ACTIONS(628),
    [anon_sym_RBRACK] = ACTIONS(628),
    [anon_sym_LBRACE] = ACTIONS(628),
    [anon_sym_RBRACE] = ACTIONS(628),
    [anon_sym_LT] = ACTIONS(630),
    [anon_sym_GT] = ACTIONS(630),
    [anon_sym_STAR] = ACTIONS(628),
    [anon_sym_len] = ACTIONS(630),
    [anon_sym_close] = ACTIONS(630),
    [anon_sym_and] = ACTIONS(630),
    [anon_sym_or] = ACTIONS(630),
    [anon_sym_div] = ACTIONS(630),
    [anon_sym_mod] = ACTIONS(630),
    [anon_sym_quo] = ACTIONS(630),
    [anon_sym_rem] = ACTIONS(630),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(628),
    [anon_sym_BANG] = ACTIONS(630),
    [anon_sym_QMARK] = ACTIONS(628),
    [anon_sym_COLON] = ACTIONS(628),
    [anon_sym_PLUS] = ACTIONS(630),
    [anon_sym_SLASH] = ACTIONS(630),
    [anon_sym_PIPE] = ACTIONS(630),
    [anon_sym_AMP] = ACTIONS(630),
    [anon_sym_PIPE_PIPE] = ACTIONS(628),
    [anon_sym_AMP_AMP] = ACTIONS(628),
    [anon_sym_EQ_EQ] = ACTIONS(628),
    [anon_sym_EQ_TILDE] = ACTIONS(628),
    [anon_sym_BANG_TILDE] = ACTIONS(628),
    [anon_sym_BANG_EQ] = ACTIONS(628),
    [anon_sym_LT_EQ] = ACTIONS(628),
    [anon_sym_GT_EQ] = ACTIONS(628),
    [sym_bottom] = ACTIONS(628),
    [anon_sym_true] = ACTIONS(630),
    [anon_sym_false] = ACTIONS(630),
    [sym_null] = ACTIONS(630),
    [sym_number] = ACTIONS(630),
    [sym_float] = ACTIONS(630),
    [anon_sym_DQUOTE] = ACTIONS(630),
    [anon_sym_SQUOTE] = ACTIONS(630),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(628),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(628),
    [anon_sym_POUND_DQUOTE] = ACTIONS(630),
    [anon_sym_POUND_SQUOTE] = ACTIONS(630),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(628),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(628),
    [sym_comment] = ACTIONS(3),
  },
  [124] = {
    [sym_builtin_function] = STATE(625),
    [sym_list_lit] = STATE(375),
    [sym_struct_lit] = STATE(375),
    [sym__label_name] = STATE(604),
    [sym_required] = STATE(642),
    [sym_optional] = STATE(642),
    [sym__label_expr] = STATE(642),
    [sym_parenthesized_expression] = STATE(594),
    [sym_primary_expression] = STATE(624),
    [sym_call_expression] = STATE(375),
    [sym_index_expression] = STATE(375),
    [sym_selector_expression] = STATE(549),
    [sym__literal] = STATE(375),
    [sym_primitive_type] = STATE(375),
    [sym_top] = STATE(375),
    [sym_boolean] = STATE(375),
    [sym_si_unit] = STATE(375),
    [sym_string] = STATE(375),
    [sym__simple_string_lit] = STATE(593),
    [sym__simple_bytes_lit] = STATE(351),
    [sym__multiline_string_lit] = STATE(351),
    [sym__multiline_bytes_lit] = STATE(351),
    [sym__simple_raw_string_lit] = STATE(351),
    [sym__simple_raw_bytes_lit] = STATE(351),
    [sym__multiline_raw_string_lit] = STATE(351),
    [sym__multiline_raw_bytes_lit] = STATE(351),
    [sym_identifier] = ACTIONS(618),
    [anon_sym__] = ACTIONS(548),
    [anon_sym_LPAREN] = ACTIONS(620),
    [anon_sym_let] = ACTIONS(476),
    [anon_sym_if] = ACTIONS(476),
    [anon_sym_for] = ACTIONS(476),
    [anon_sym_number] = ACTIONS(622),
    [anon_sym_float] = ACTIONS(622),
    [anon_sym_float32] = ACTIONS(622),
    [anon_sym_float64] = ACTIONS(622),
    [anon_sym_uint] = ACTIONS(622),
    [anon_sym_uint8] = ACTIONS(622),
    [anon_sym_uint16] = ACTIONS(622),
    [anon_sym_uint32] = ACTIONS(622),
    [anon_sym_uint64] = ACTIONS(622),
    [anon_sym_uint128] = ACTIONS(622),
    [anon_sym_int] = ACTIONS(622),
    [anon_sym_int8] = ACTIONS(622),
    [anon_sym_int16] = ACTIONS(622),
    [anon_sym_int32] = ACTIONS(622),
    [anon_sym_int64] = ACTIONS(622),
    [anon_sym_int128] = ACTIONS(622),
    [anon_sym_string] = ACTIONS(622),
    [anon_sym_bytes] = ACTIONS(622),
    [anon_sym_bool] = ACTIONS(622),
    [anon_sym_LBRACK] = ACTIONS(624),
    [anon_sym_LBRACE] = ACTIONS(560),
    [anon_sym_len] = ACTIONS(35),
    [anon_sym_close] = ACTIONS(35),
    [anon_sym_and] = ACTIONS(35),
    [anon_sym_or] = ACTIONS(35),
    [anon_sym_div] = ACTIONS(35),
    [anon_sym_mod] = ACTIONS(35),
    [anon_sym_quo] = ACTIONS(35),
    [anon_sym_rem] = ACTIONS(35),
    [sym_bottom] = ACTIONS(564),
    [anon_sym_true] = ACTIONS(566),
    [anon_sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_float] = ACTIONS(570),
    [anon_sym_DQUOTE] = ACTIONS(626),
    [anon_sym_SQUOTE] = ACTIONS(574),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(576),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(578),
    [anon_sym_POUND_DQUOTE] = ACTIONS(580),
    [anon_sym_POUND_SQUOTE] = ACTIONS(582),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(584),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(586),
    [sym_comment] = ACTIONS(3),
  },
  [125] = {
    [ts_builtin_sym_end] = ACTIONS(632),
    [sym_identifier] = ACTIONS(634),
    [anon_sym_COMMA] = ACTIONS(632),
    [anon_sym_DOT] = ACTIONS(634),
    [anon_sym__] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(632),
    [anon_sym_let] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_number] = ACTIONS(634),
    [anon_sym_float] = ACTIONS(634),
    [anon_sym_float32] = ACTIONS(634),
    [anon_sym_float64] = ACTIONS(634),
    [anon_sym_uint] = ACTIONS(634),
    [anon_sym_uint8] = ACTIONS(634),
    [anon_sym_uint16] = ACTIONS(634),
    [anon_sym_uint32] = ACTIONS(634),
    [anon_sym_uint64] = ACTIONS(634),
    [anon_sym_uint128] = ACTIONS(634),
    [anon_sym_int] = ACTIONS(634),
    [anon_sym_int8] = ACTIONS(634),
    [anon_sym_int16] = ACTIONS(634),
    [anon_sym_int32] = ACTIONS(634),
    [anon_sym_int64] = ACTIONS(634),
    [anon_sym_int128] = ACTIONS(634),
    [anon_sym_string] = ACTIONS(634),
    [anon_sym_bytes] = ACTIONS(634),
    [anon_sym_bool] = ACTIONS(634),
    [anon_sym_AT] = ACTIONS(632),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_LBRACK] = ACTIONS(632),
    [anon_sym_RBRACK] = ACTIONS(632),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_RBRACE] = ACTIONS(632),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(634),
    [anon_sym_STAR] = ACTIONS(632),
    [anon_sym_len] = ACTIONS(634),
    [anon_sym_close] = ACTIONS(634),
    [anon_sym_and] = ACTIONS(634),
    [anon_sym_or] = ACTIONS(634),
    [anon_sym_div] = ACTIONS(634),
    [anon_sym_mod] = ACTIONS(634),
    [anon_sym_quo] = ACTIONS(634),
    [anon_sym_rem] = ACTIONS(634),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(632),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_QMARK] = ACTIONS(632),
    [anon_sym_COLON] = ACTIONS(632),
    [anon_sym_PLUS] = ACTIONS(634),
    [anon_sym_SLASH] = ACTIONS(634),
    [anon_sym_PIPE] = ACTIONS(634),
    [anon_sym_AMP] = ACTIONS(634),
    [anon_sym_PIPE_PIPE] = ACTIONS(632),
    [anon_sym_AMP_AMP] = ACTIONS(632),
    [anon_sym_EQ_EQ] = ACTIONS(632),
    [anon_sym_EQ_TILDE] = ACTIONS(632),
    [anon_sym_BANG_TILDE] = ACTIONS(632),
    [anon_sym_BANG_EQ] = ACTIONS(632),
    [anon_sym_LT_EQ] = ACTIONS(632),
    [anon_sym_GT_EQ] = ACTIONS(632),
    [sym_bottom] = ACTIONS(632),
    [anon_sym_true] = ACTIONS(634),
    [anon_sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_number] = ACTIONS(634),
    [sym_float] = ACTIONS(634),
    [anon_sym_DQUOTE] = ACTIONS(634),
    [anon_sym_SQUOTE] = ACTIONS(634),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(632),
    [anon_sym_POUND_DQUOTE] = ACTIONS(634),
    [anon_sym_POUND_SQUOTE] = ACTIONS(634),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(632),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(632),
    [sym_comment] = ACTIONS(3),
  },
  [126] = {
    [ts_builtin_sym_end] = ACTIONS(636),
    [sym_identifier] = ACTIONS(638),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_DOT] = ACTIONS(638),
    [anon_sym__] = ACTIONS(638),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_let] = ACTIONS(638),
    [anon_sym_if] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(638),
    [anon_sym_number] = ACTIONS(638),
    [anon_sym_float] = ACTIONS(638),
    [anon_sym_float32] = ACTIONS(638),
    [anon_sym_float64] = ACTIONS(638),
    [anon_sym_uint] = ACTIONS(638),
    [anon_sym_uint8] = ACTIONS(638),
    [anon_sym_uint16] = ACTIONS(638),
    [anon_sym_uint32] = ACTIONS(638),
    [anon_sym_uint64] = ACTIONS(638),
    [anon_sym_uint128] = ACTIONS(638),
    [anon_sym_int] = ACTIONS(638),
    [anon_sym_int8] = ACTIONS(638),
    [anon_sym_int16] = ACTIONS(638),
    [anon_sym_int32] = ACTIONS(638),
    [anon_sym_int64] = ACTIONS(638),
    [anon_sym_int128] = ACTIONS(638),
    [anon_sym_string] = ACTIONS(638),
    [anon_sym_bytes] = ACTIONS(638),
    [anon_sym_bool] = ACTIONS(638),
    [anon_sym_AT] = ACTIONS(636),
    [anon_sym_DASH] = ACTIONS(638),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(636),
    [anon_sym_LT] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(638),
    [anon_sym_EQ] = ACTIONS(590),
    [anon_sym_STAR] = ACTIONS(636),
    [anon_sym_len] = ACTIONS(638),
    [anon_sym_close] = ACTIONS(638),
    [anon_sym_and] = ACTIONS(638),
    [anon_sym_or] = ACTIONS(638),
    [anon_sym_div] = ACTIONS(638),
    [anon_sym_mod] = ACTIONS(638),
    [anon_sym_quo] = ACTIONS(638),
    [anon_sym_rem] = ACTIONS(638),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(636),
    [anon_sym_BANG] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(592),
    [anon_sym_COLON] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(638),
    [anon_sym_SLASH] = ACTIONS(638),
    [anon_sym_PIPE] = ACTIONS(638),
    [anon_sym_AMP] = ACTIONS(638),
    [anon_sym_PIPE_PIPE] = ACTIONS(636),
    [anon_sym_AMP_AMP] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(636),
    [anon_sym_EQ_TILDE] = ACTIONS(636),
    [anon_sym_BANG_TILDE] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(636),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [sym_bottom] = ACTIONS(636),
    [anon_sym_true] = ACTIONS(638),
    [anon_sym_false] = ACTIONS(638),
    [sym_null] = ACTIONS(638),
    [sym_number] = ACTIONS(638),
    [sym_float] = ACTIONS(638),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_SQUOTE] = ACTIONS(638),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(636),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(636),
    [anon_sym_POUND_DQUOTE] = ACTIONS(638),
    [anon_sym_POUND_SQUOTE] = ACTIONS(638),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(636),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(636),
    [sym_comment] = ACTIONS(3),
  },
  [127] = {
    [sym_arguments] = STATE(166),
    [ts_builtin_sym_end] = ACTIONS(602),
    [sym_identifier] = ACTIONS(604),
    [anon_sym_COMMA] = ACTIONS(602),
    [anon_sym_DOT] = ACTIONS(604),
    [anon_sym__] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(606),
    [anon_sym_let] = ACTIONS(604),
    [anon_sym_if] = ACTIONS(604),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_number] = ACTIONS(604),
    [anon_sym_float] = ACTIONS(604),
    [anon_sym_float32] = ACTIONS(604),
    [anon_sym_float64] = ACTIONS(604),
    [anon_sym_uint] = ACTIONS(604),
    [anon_sym_uint8] = ACTIONS(604),
    [anon_sym_uint16] = ACTIONS(604),
    [anon_sym_uint32] = ACTIONS(604),
    [anon_sym_uint64] = ACTIONS(604),
    [anon_sym_uint128] = ACTIONS(604),
    [anon_sym_int] = ACTIONS(604),
    [anon_sym_int8] = ACTIONS(604),
    [anon_sym_int16] = ACTIONS(604),
    [anon_sym_int32] = ACTIONS(604),
    [anon_sym_int64] = ACTIONS(604),
    [anon_sym_int128] = ACTIONS(604),
    [anon_sym_string] = ACTIONS(604),
    [anon_sym_bytes] = ACTIONS(604),
    [anon_sym_bool] = ACTIONS(604),
    [anon_sym_AT] = ACTIONS(602),
    [anon_sym_DASH] = ACTIONS(604),
    [anon_sym_LBRACK] = ACTIONS(602),
    [anon_sym_LBRACE] = ACTIONS(602),
    [anon_sym_RBRACE] = ACTIONS(602),
    [anon_sym_LT] = ACTIONS(604),
    [anon_sym_GT] = ACTIONS(604),
    [anon_sym_STAR] = ACTIONS(602),
    [anon_sym_len] = ACTIONS(604),
    [anon_sym_close] = ACTIONS(604),
    [anon_sym_and] = ACTIONS(604),
    [anon_sym_or] = ACTIONS(604),
    [anon_sym_div] = ACTIONS(604),
    [anon_sym_mod] = ACTIONS(604),
    [anon_sym_quo] = ACTIONS(604),
    [anon_sym_rem] = ACTIONS(604),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(602),
    [anon_sym_BANG] = ACTIONS(610),
    [anon_sym_QMARK] = ACTIONS(612),
    [anon_sym_COLON] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(604),
    [anon_sym_SLASH] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(604),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE_PIPE] = ACTIONS(602),
    [anon_sym_AMP_AMP] = ACTIONS(602),
    [anon_sym_EQ_EQ] = ACTIONS(602),
    [anon_sym_EQ_TILDE] = ACTIONS(602),
    [anon_sym_BANG_TILDE] = ACTIONS(602),
    [anon_sym_BANG_EQ] = ACTIONS(602),
    [anon_sym_LT_EQ] = ACTIONS(602),
    [anon_sym_GT_EQ] = ACTIONS(602),
    [sym_bottom] = ACTIONS(602),
    [anon_sym_true] = ACTIONS(604),
    [anon_sym_false] = ACTIONS(604),
    [sym_null] = ACTIONS(604),
    [sym_number] = ACTIONS(604),
    [sym_float] = ACTIONS(604),
    [anon_sym_DQUOTE] = ACTIONS(604),
    [anon_sym_SQUOTE] = ACTIONS(604),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(602),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(602),
    [anon_sym_POUND_DQUOTE] = ACTIONS(604),
    [anon_sym_POUND_SQUOTE] = ACTIONS(604),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(602),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(602),
    [sym_comment] = ACTIONS(3),
  },
  [128] = {
    [ts_builtin_sym_end] = ACTIONS(640),
    [sym_identifier] = ACTIONS(642),
    [anon_sym_COMMA] = ACTIONS(640),
    [anon_sym_DOT] = ACTIONS(642),
    [anon_sym__] = ACTIONS(642),
    [anon_sym_LPAREN] = ACTIONS(640),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_if] = ACTIONS(642),
    [anon_sym_for] = ACTIONS(642),
    [anon_sym_number] = ACTIONS(642),
    [anon_sym_float] = ACTIONS(642),
    [anon_sym_float32] = ACTIONS(642),
    [anon_sym_float64] = ACTIONS(642),
    [anon_sym_uint] = ACTIONS(642),
    [anon_sym_uint8] = ACTIONS(642),
    [anon_sym_uint16] = ACTIONS(642),
    [anon_sym_uint32] = ACTIONS(642),
    [anon_sym_uint64] = ACTIONS(642),
    [anon_sym_uint128] = ACTIONS(642),
    [anon_sym_int] = ACTIONS(642),
    [anon_sym_int8] = ACTIONS(642),
    [anon_sym_int16] = ACTIONS(642),
    [anon_sym_int32] = ACTIONS(642),
    [anon_sym_int64] = ACTIONS(642),
    [anon_sym_int128] = ACTIONS(642),
    [anon_sym_string] = ACTIONS(642),
    [anon_sym_bytes] = ACTIONS(642),
    [anon_sym_bool] = ACTIONS(642),
    [anon_sym_AT] = ACTIONS(640),
    [anon_sym_DASH] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(640),
    [anon_sym_RBRACK] = ACTIONS(640),
    [anon_sym_LBRACE] = ACTIONS(640),
    [anon_sym_RBRACE] = ACTIONS(640),
    [anon_sym_LT] = ACTIONS(642),
    [anon_sym_GT] = ACTIONS(642),
    [anon_sym_STAR] = ACTIONS(640),
    [anon_sym_len] = ACTIONS(642),
    [anon_sym_close] = ACTIONS(642),
    [anon_sym_and] = ACTIONS(642),
    [anon_sym_or] = ACTIONS(642),
    [anon_sym_div] = ACTIONS(642),
    [anon_sym_mod] = ACTIONS(642),
    [anon_sym_quo] = ACTIONS(642),
    [anon_sym_rem] = ACTIONS(642),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(640),
    [anon_sym_BANG] = ACTIONS(642),
    [anon_sym_QMARK] = ACTIONS(640),
    [anon_sym_COLON] = ACTIONS(640),
    [anon_sym_PLUS] = ACTIONS(642),
    [anon_sym_SLASH] = ACTIONS(642),
    [anon_sym_PIPE] = ACTIONS(642),
    [anon_sym_AMP] = ACTIONS(642),
    [anon_sym_PIPE_PIPE] = ACTIONS(640),
    [anon_sym_AMP_AMP] = ACTIONS(640),
    [anon_sym_EQ_EQ] = ACTIONS(640),
    [anon_sym_EQ_TILDE] = ACTIONS(640),
    [anon_sym_BANG_TILDE] = ACTIONS(640),
    [anon_sym_BANG_EQ] = ACTIONS(640),
    [anon_sym_LT_EQ] = ACTIONS(640),
    [anon_sym_GT_EQ] = ACTIONS(640),
    [sym_bottom] = ACTIONS(640),
    [anon_sym_true] = ACTIONS(642),
    [anon_sym_false] = ACTIONS(642),
    [sym_null] = ACTIONS(642),
    [sym_number] = ACTIONS(642),
    [sym_float] = ACTIONS(642),
    [anon_sym_DQUOTE] = ACTIONS(642),
    [anon_sym_SQUOTE] = ACTIONS(642),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(640),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(640),
    [anon_sym_POUND_DQUOTE] = ACTIONS(642),
    [anon_sym_POUND_SQUOTE] = ACTIONS(642),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(640),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(640),
    [sym_comment] = ACTIONS(3),
  },
  [129] = {
    [ts_builtin_sym_end] = ACTIONS(644),
    [sym_identifier] = ACTIONS(646),
    [anon_sym_COMMA] = ACTIONS(644),
    [anon_sym_DOT] = ACTIONS(646),
    [anon_sym__] = ACTIONS(646),
    [anon_sym_LPAREN] = ACTIONS(644),
    [anon_sym_let] = ACTIONS(646),
    [anon_sym_if] = ACTIONS(646),
    [anon_sym_for] = ACTIONS(646),
    [anon_sym_number] = ACTIONS(646),
    [anon_sym_float] = ACTIONS(646),
    [anon_sym_float32] = ACTIONS(646),
    [anon_sym_float64] = ACTIONS(646),
    [anon_sym_uint] = ACTIONS(646),
    [anon_sym_uint8] = ACTIONS(646),
    [anon_sym_uint16] = ACTIONS(646),
    [anon_sym_uint32] = ACTIONS(646),
    [anon_sym_uint64] = ACTIONS(646),
    [anon_sym_uint128] = ACTIONS(646),
    [anon_sym_int] = ACTIONS(646),
    [anon_sym_int8] = ACTIONS(646),
    [anon_sym_int16] = ACTIONS(646),
    [anon_sym_int32] = ACTIONS(646),
    [anon_sym_int64] = ACTIONS(646),
    [anon_sym_int128] = ACTIONS(646),
    [anon_sym_string] = ACTIONS(646),
    [anon_sym_bytes] = ACTIONS(646),
    [anon_sym_bool] = ACTIONS(646),
    [anon_sym_AT] = ACTIONS(644),
    [anon_sym_DASH] = ACTIONS(646),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(644),
    [anon_sym_LBRACE] = ACTIONS(644),
    [anon_sym_RBRACE] = ACTIONS(644),
    [anon_sym_LT] = ACTIONS(646),
    [anon_sym_GT] = ACTIONS(646),
    [anon_sym_STAR] = ACTIONS(644),
    [anon_sym_len] = ACTIONS(646),
    [anon_sym_close] = ACTIONS(646),
    [anon_sym_and] = ACTIONS(646),
    [anon_sym_or] = ACTIONS(646),
    [anon_sym_div] = ACTIONS(646),
    [anon_sym_mod] = ACTIONS(646),
    [anon_sym_quo] = ACTIONS(646),
    [anon_sym_rem] = ACTIONS(646),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(644),
    [anon_sym_BANG] = ACTIONS(646),
    [anon_sym_PLUS] = ACTIONS(646),
    [anon_sym_SLASH] = ACTIONS(646),
    [anon_sym_PIPE] = ACTIONS(646),
    [anon_sym_AMP] = ACTIONS(646),
    [anon_sym_PIPE_PIPE] = ACTIONS(644),
    [anon_sym_AMP_AMP] = ACTIONS(644),
    [anon_sym_EQ_EQ] = ACTIONS(644),
    [anon_sym_EQ_TILDE] = ACTIONS(644),
    [anon_sym_BANG_TILDE] = ACTIONS(644),
    [anon_sym_BANG_EQ] = ACTIONS(644),
    [anon_sym_LT_EQ] = ACTIONS(644),
    [anon_sym_GT_EQ] = ACTIONS(644),
    [sym_bottom] = ACTIONS(644),
    [anon_sym_true] = ACTIONS(646),
    [anon_sym_false] = ACTIONS(646),
    [sym_null] = ACTIONS(646),
    [sym_number] = ACTIONS(646),
    [sym_float] = ACTIONS(646),
    [aux_sym_si_unit_token1] = ACTIONS(648),
    [anon_sym_DQUOTE] = ACTIONS(646),
    [anon_sym_SQUOTE] = ACTIONS(646),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(644),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(644),
    [anon_sym_POUND_DQUOTE] = ACTIONS(646),
    [anon_sym_POUND_SQUOTE] = ACTIONS(646),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(644),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(644),
    [sym_comment] = ACTIONS(3),
  },
  [130] = {
    [ts_builtin_sym_end] = ACTIONS(650),
    [sym_identifier] = ACTIONS(652),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(652),
    [anon_sym__] = ACTIONS(652),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [anon_sym_let] = ACTIONS(652),
    [anon_sym_if] = ACTIONS(652),
    [anon_sym_for] = ACTIONS(652),
    [anon_sym_number] = ACTIONS(652),
    [anon_sym_float] = ACTIONS(652),
    [anon_sym_float32] = ACTIONS(652),
    [anon_sym_float64] = ACTIONS(652),
    [anon_sym_uint] = ACTIONS(652),
    [anon_sym_uint8] = ACTIONS(652),
    [anon_sym_uint16] = ACTIONS(652),
    [anon_sym_uint32] = ACTIONS(652),
    [anon_sym_uint64] = ACTIONS(652),
    [anon_sym_uint128] = ACTIONS(652),
    [anon_sym_int] = ACTIONS(652),
    [anon_sym_int8] = ACTIONS(652),
    [anon_sym_int16] = ACTIONS(652),
    [anon_sym_int32] = ACTIONS(652),
    [anon_sym_int64] = ACTIONS(652),
    [anon_sym_int128] = ACTIONS(652),
    [anon_sym_string] = ACTIONS(652),
    [anon_sym_bytes] = ACTIONS(652),
    [anon_sym_bool] = ACTIONS(652),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(652),
    [anon_sym_LBRACK] = ACTIONS(650),
    [anon_sym_RBRACK] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_LT] = ACTIONS(652),
    [anon_sym_GT] = ACTIONS(652),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_len] = ACTIONS(652),
    [anon_sym_close] = ACTIONS(652),
    [anon_sym_and] = ACTIONS(652),
    [anon_sym_or] = ACTIONS(652),
    [anon_sym_div] = ACTIONS(652),
    [anon_sym_mod] = ACTIONS(652),
    [anon_sym_quo] = ACTIONS(652),
    [anon_sym_rem] = ACTIONS(652),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_PLUS] = ACTIONS(652),
    [anon_sym_SLASH] = ACTIONS(652),
    [anon_sym_PIPE] = ACTIONS(652),
    [anon_sym_AMP] = ACTIONS(652),
    [anon_sym_PIPE_PIPE] = ACTIONS(650),
    [anon_sym_AMP_AMP] = ACTIONS(650),
    [anon_sym_EQ_EQ] = ACTIONS(650),
    [anon_sym_EQ_TILDE] = ACTIONS(650),
    [anon_sym_BANG_TILDE] = ACTIONS(650),
    [anon_sym_BANG_EQ] = ACTIONS(650),
    [anon_sym_LT_EQ] = ACTIONS(650),
    [anon_sym_GT_EQ] = ACTIONS(650),
    [sym_bottom] = ACTIONS(650),
    [anon_sym_true] = ACTIONS(652),
    [anon_sym_false] = ACTIONS(652),
    [sym_null] = ACTIONS(652),
    [sym_number] = ACTIONS(652),
    [sym_float] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(652),
    [anon_sym_SQUOTE] = ACTIONS(652),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(650),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(650),
    [anon_sym_POUND_DQUOTE] = ACTIONS(652),
    [anon_sym_POUND_SQUOTE] = ACTIONS(652),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(650),
    [sym_comment] = ACTIONS(3),
  },
  [131] = {
    [ts_builtin_sym_end] = ACTIONS(654),
    [sym_identifier] = ACTIONS(656),
    [anon_sym_COMMA] = ACTIONS(654),
    [anon_sym_DOT] = ACTIONS(656),
    [anon_sym__] = ACTIONS(656),
    [anon_sym_LPAREN] = ACTIONS(654),
    [anon_sym_RPAREN] = ACTIONS(654),
    [anon_sym_let] = ACTIONS(656),
    [anon_sym_if] = ACTIONS(656),
    [anon_sym_for] = ACTIONS(656),
    [anon_sym_number] = ACTIONS(656),
    [anon_sym_float] = ACTIONS(656),
    [anon_sym_float32] = ACTIONS(656),
    [anon_sym_float64] = ACTIONS(656),
    [anon_sym_uint] = ACTIONS(656),
    [anon_sym_uint8] = ACTIONS(656),
    [anon_sym_uint16] = ACTIONS(656),
    [anon_sym_uint32] = ACTIONS(656),
    [anon_sym_uint64] = ACTIONS(656),
    [anon_sym_uint128] = ACTIONS(656),
    [anon_sym_int] = ACTIONS(656),
    [anon_sym_int8] = ACTIONS(656),
    [anon_sym_int16] = ACTIONS(656),
    [anon_sym_int32] = ACTIONS(656),
    [anon_sym_int64] = ACTIONS(656),
    [anon_sym_int128] = ACTIONS(656),
    [anon_sym_string] = ACTIONS(656),
    [anon_sym_bytes] = ACTIONS(656),
    [anon_sym_bool] = ACTIONS(656),
    [anon_sym_AT] = ACTIONS(654),
    [anon_sym_DASH] = ACTIONS(656),
    [anon_sym_LBRACK] = ACTIONS(654),
    [anon_sym_RBRACK] = ACTIONS(654),
    [anon_sym_LBRACE] = ACTIONS(654),
    [anon_sym_RBRACE] = ACTIONS(654),
    [anon_sym_LT] = ACTIONS(656),
    [anon_sym_GT] = ACTIONS(656),
    [anon_sym_STAR] = ACTIONS(654),
    [anon_sym_len] = ACTIONS(656),
    [anon_sym_close] = ACTIONS(656),
    [anon_sym_and] = ACTIONS(656),
    [anon_sym_or] = ACTIONS(656),
    [anon_sym_div] = ACTIONS(656),
    [anon_sym_mod] = ACTIONS(656),
    [anon_sym_quo] = ACTIONS(656),
    [anon_sym_rem] = ACTIONS(656),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(654),
    [anon_sym_BANG] = ACTIONS(656),
    [anon_sym_PLUS] = ACTIONS(656),
    [anon_sym_SLASH] = ACTIONS(656),
    [anon_sym_PIPE] = ACTIONS(656),
    [anon_sym_AMP] = ACTIONS(656),
    [anon_sym_PIPE_PIPE] = ACTIONS(654),
    [anon_sym_AMP_AMP] = ACTIONS(654),
    [anon_sym_EQ_EQ] = ACTIONS(654),
    [anon_sym_EQ_TILDE] = ACTIONS(654),
    [anon_sym_BANG_TILDE] = ACTIONS(654),
    [anon_sym_BANG_EQ] = ACTIONS(654),
    [anon_sym_LT_EQ] = ACTIONS(654),
    [anon_sym_GT_EQ] = ACTIONS(654),
    [sym_bottom] = ACTIONS(654),
    [anon_sym_true] = ACTIONS(656),
    [anon_sym_false] = ACTIONS(656),
    [sym_null] = ACTIONS(656),
    [sym_number] = ACTIONS(656),
    [sym_float] = ACTIONS(656),
    [anon_sym_DQUOTE] = ACTIONS(656),
    [anon_sym_SQUOTE] = ACTIONS(656),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(654),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(654),
    [anon_sym_POUND_DQUOTE] = ACTIONS(656),
    [anon_sym_POUND_SQUOTE] = ACTIONS(656),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(654),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(654),
    [sym_comment] = ACTIONS(3),
  },
  [132] = {
    [ts_builtin_sym_end] = ACTIONS(658),
    [sym_identifier] = ACTIONS(660),
    [anon_sym_COMMA] = ACTIONS(658),
    [anon_sym_DOT] = ACTIONS(660),
    [anon_sym__] = ACTIONS(660),
    [anon_sym_LPAREN] = ACTIONS(658),
    [anon_sym_RPAREN] = ACTIONS(658),
    [anon_sym_let] = ACTIONS(660),
    [anon_sym_if] = ACTIONS(660),
    [anon_sym_for] = ACTIONS(660),
    [anon_sym_number] = ACTIONS(660),
    [anon_sym_float] = ACTIONS(660),
    [anon_sym_float32] = ACTIONS(660),
    [anon_sym_float64] = ACTIONS(660),
    [anon_sym_uint] = ACTIONS(660),
    [anon_sym_uint8] = ACTIONS(660),
    [anon_sym_uint16] = ACTIONS(660),
    [anon_sym_uint32] = ACTIONS(660),
    [anon_sym_uint64] = ACTIONS(660),
    [anon_sym_uint128] = ACTIONS(660),
    [anon_sym_int] = ACTIONS(660),
    [anon_sym_int8] = ACTIONS(660),
    [anon_sym_int16] = ACTIONS(660),
    [anon_sym_int32] = ACTIONS(660),
    [anon_sym_int64] = ACTIONS(660),
    [anon_sym_int128] = ACTIONS(660),
    [anon_sym_string] = ACTIONS(660),
    [anon_sym_bytes] = ACTIONS(660),
    [anon_sym_bool] = ACTIONS(660),
    [anon_sym_AT] = ACTIONS(658),
    [anon_sym_DASH] = ACTIONS(660),
    [anon_sym_LBRACK] = ACTIONS(658),
    [anon_sym_RBRACK] = ACTIONS(658),
    [anon_sym_LBRACE] = ACTIONS(658),
    [anon_sym_RBRACE] = ACTIONS(658),
    [anon_sym_LT] = ACTIONS(660),
    [anon_sym_GT] = ACTIONS(660),
    [anon_sym_STAR] = ACTIONS(658),
    [anon_sym_len] = ACTIONS(660),
    [anon_sym_close] = ACTIONS(660),
    [anon_sym_and] = ACTIONS(660),
    [anon_sym_or] = ACTIONS(660),
    [anon_sym_div] = ACTIONS(660),
    [anon_sym_mod] = ACTIONS(660),
    [anon_sym_quo] = ACTIONS(660),
    [anon_sym_rem] = ACTIONS(660),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(658),
    [anon_sym_BANG] = ACTIONS(660),
    [anon_sym_PLUS] = ACTIONS(660),
    [anon_sym_SLASH] = ACTIONS(660),
    [anon_sym_PIPE] = ACTIONS(660),
    [anon_sym_AMP] = ACTIONS(660),
    [anon_sym_PIPE_PIPE] = ACTIONS(658),
    [anon_sym_AMP_AMP] = ACTIONS(658),
    [anon_sym_EQ_EQ] = ACTIONS(658),
    [anon_sym_EQ_TILDE] = ACTIONS(658),
    [anon_sym_BANG_TILDE] = ACTIONS(658),
    [anon_sym_BANG_EQ] = ACTIONS(658),
    [anon_sym_LT_EQ] = ACTIONS(658),
    [anon_sym_GT_EQ] = ACTIONS(658),
    [sym_bottom] = ACTIONS(658),
    [anon_sym_true] = ACTIONS(660),
    [anon_sym_false] = ACTIONS(660),
    [sym_null] = ACTIONS(660),
    [sym_number] = ACTIONS(660),
    [sym_float] = ACTIONS(660),
    [anon_sym_DQUOTE] = ACTIONS(660),
    [anon_sym_SQUOTE] = ACTIONS(660),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(658),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(658),
    [anon_sym_POUND_DQUOTE] = ACTIONS(660),
    [anon_sym_POUND_SQUOTE] = ACTIONS(660),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(658),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(658),
    [sym_comment] = ACTIONS(3),
  },
  [133] = {
    [sym_arguments] = STATE(166),
    [ts_builtin_sym_end] = ACTIONS(602),
    [sym_identifier] = ACTIONS(604),
    [anon_sym_COMMA] = ACTIONS(602),
    [anon_sym_DOT] = ACTIONS(604),
    [anon_sym__] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(606),
    [anon_sym_let] = ACTIONS(604),
    [anon_sym_if] = ACTIONS(604),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_number] = ACTIONS(604),
    [anon_sym_float] = ACTIONS(604),
    [anon_sym_float32] = ACTIONS(604),
    [anon_sym_float64] = ACTIONS(604),
    [anon_sym_uint] = ACTIONS(604),
    [anon_sym_uint8] = ACTIONS(604),
    [anon_sym_uint16] = ACTIONS(604),
    [anon_sym_uint32] = ACTIONS(604),
    [anon_sym_uint64] = ACTIONS(604),
    [anon_sym_uint128] = ACTIONS(604),
    [anon_sym_int] = ACTIONS(604),
    [anon_sym_int8] = ACTIONS(604),
    [anon_sym_int16] = ACTIONS(604),
    [anon_sym_int32] = ACTIONS(604),
    [anon_sym_int64] = ACTIONS(604),
    [anon_sym_int128] = ACTIONS(604),
    [anon_sym_string] = ACTIONS(604),
    [anon_sym_bytes] = ACTIONS(604),
    [anon_sym_bool] = ACTIONS(604),
    [anon_sym_AT] = ACTIONS(602),
    [anon_sym_DASH] = ACTIONS(604),
    [anon_sym_LBRACK] = ACTIONS(602),
    [anon_sym_RBRACK] = ACTIONS(602),
    [anon_sym_LBRACE] = ACTIONS(602),
    [anon_sym_RBRACE] = ACTIONS(602),
    [anon_sym_LT] = ACTIONS(604),
    [anon_sym_GT] = ACTIONS(604),
    [anon_sym_STAR] = ACTIONS(602),
    [anon_sym_len] = ACTIONS(604),
    [anon_sym_close] = ACTIONS(604),
    [anon_sym_and] = ACTIONS(604),
    [anon_sym_or] = ACTIONS(604),
    [anon_sym_div] = ACTIONS(604),
    [anon_sym_mod] = ACTIONS(604),
    [anon_sym_quo] = ACTIONS(604),
    [anon_sym_rem] = ACTIONS(604),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(602),
    [anon_sym_BANG] = ACTIONS(604),
    [anon_sym_PLUS] = ACTIONS(604),
    [anon_sym_SLASH] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(604),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE_PIPE] = ACTIONS(602),
    [anon_sym_AMP_AMP] = ACTIONS(602),
    [anon_sym_EQ_EQ] = ACTIONS(602),
    [anon_sym_EQ_TILDE] = ACTIONS(602),
    [anon_sym_BANG_TILDE] = ACTIONS(602),
    [anon_sym_BANG_EQ] = ACTIONS(602),
    [anon_sym_LT_EQ] = ACTIONS(602),
    [anon_sym_GT_EQ] = ACTIONS(602),
    [sym_bottom] = ACTIONS(602),
    [anon_sym_true] = ACTIONS(604),
    [anon_sym_false] = ACTIONS(604),
    [sym_null] = ACTIONS(604),
    [sym_number] = ACTIONS(604),
    [sym_float] = ACTIONS(604),
    [anon_sym_DQUOTE] = ACTIONS(604),
    [anon_sym_SQUOTE] = ACTIONS(604),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(602),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(602),
    [anon_sym_POUND_DQUOTE] = ACTIONS(604),
    [anon_sym_POUND_SQUOTE] = ACTIONS(604),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(602),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(602),
    [sym_comment] = ACTIONS(3),
  },
  [134] = {
    [ts_builtin_sym_end] = ACTIONS(662),
    [sym_identifier] = ACTIONS(664),
    [anon_sym_COMMA] = ACTIONS(662),
    [anon_sym_DOT] = ACTIONS(664),
    [anon_sym__] = ACTIONS(664),
    [anon_sym_LPAREN] = ACTIONS(662),
    [anon_sym_RPAREN] = ACTIONS(662),
    [anon_sym_let] = ACTIONS(664),
    [anon_sym_if] = ACTIONS(664),
    [anon_sym_for] = ACTIONS(664),
    [anon_sym_number] = ACTIONS(664),
    [anon_sym_float] = ACTIONS(664),
    [anon_sym_float32] = ACTIONS(664),
    [anon_sym_float64] = ACTIONS(664),
    [anon_sym_uint] = ACTIONS(664),
    [anon_sym_uint8] = ACTIONS(664),
    [anon_sym_uint16] = ACTIONS(664),
    [anon_sym_uint32] = ACTIONS(664),
    [anon_sym_uint64] = ACTIONS(664),
    [anon_sym_uint128] = ACTIONS(664),
    [anon_sym_int] = ACTIONS(664),
    [anon_sym_int8] = ACTIONS(664),
    [anon_sym_int16] = ACTIONS(664),
    [anon_sym_int32] = ACTIONS(664),
    [anon_sym_int64] = ACTIONS(664),
    [anon_sym_int128] = ACTIONS(664),
    [anon_sym_string] = ACTIONS(664),
    [anon_sym_bytes] = ACTIONS(664),
    [anon_sym_bool] = ACTIONS(664),
    [anon_sym_AT] = ACTIONS(662),
    [anon_sym_DASH] = ACTIONS(664),
    [anon_sym_LBRACK] = ACTIONS(662),
    [anon_sym_RBRACK] = ACTIONS(662),
    [anon_sym_LBRACE] = ACTIONS(662),
    [anon_sym_RBRACE] = ACTIONS(662),
    [anon_sym_LT] = ACTIONS(664),
    [anon_sym_GT] = ACTIONS(664),
    [anon_sym_STAR] = ACTIONS(662),
    [anon_sym_len] = ACTIONS(664),
    [anon_sym_close] = ACTIONS(664),
    [anon_sym_and] = ACTIONS(664),
    [anon_sym_or] = ACTIONS(664),
    [anon_sym_div] = ACTIONS(664),
    [anon_sym_mod] = ACTIONS(664),
    [anon_sym_quo] = ACTIONS(664),
    [anon_sym_rem] = ACTIONS(664),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(662),
    [anon_sym_BANG] = ACTIONS(664),
    [anon_sym_PLUS] = ACTIONS(664),
    [anon_sym_SLASH] = ACTIONS(664),
    [anon_sym_PIPE] = ACTIONS(664),
    [anon_sym_AMP] = ACTIONS(664),
    [anon_sym_PIPE_PIPE] = ACTIONS(662),
    [anon_sym_AMP_AMP] = ACTIONS(662),
    [anon_sym_EQ_EQ] = ACTIONS(662),
    [anon_sym_EQ_TILDE] = ACTIONS(662),
    [anon_sym_BANG_TILDE] = ACTIONS(662),
    [anon_sym_BANG_EQ] = ACTIONS(662),
    [anon_sym_LT_EQ] = ACTIONS(662),
    [anon_sym_GT_EQ] = ACTIONS(662),
    [sym_bottom] = ACTIONS(662),
    [anon_sym_true] = ACTIONS(664),
    [anon_sym_false] = ACTIONS(664),
    [sym_null] = ACTIONS(664),
    [sym_number] = ACTIONS(664),
    [sym_float] = ACTIONS(664),
    [anon_sym_DQUOTE] = ACTIONS(664),
    [anon_sym_SQUOTE] = ACTIONS(664),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(662),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(662),
    [anon_sym_POUND_DQUOTE] = ACTIONS(664),
    [anon_sym_POUND_SQUOTE] = ACTIONS(664),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(662),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(662),
    [sym_comment] = ACTIONS(3),
  },
  [135] = {
    [ts_builtin_sym_end] = ACTIONS(636),
    [sym_identifier] = ACTIONS(638),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_DOT] = ACTIONS(638),
    [anon_sym__] = ACTIONS(638),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_let] = ACTIONS(638),
    [anon_sym_if] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(638),
    [anon_sym_number] = ACTIONS(638),
    [anon_sym_float] = ACTIONS(638),
    [anon_sym_float32] = ACTIONS(638),
    [anon_sym_float64] = ACTIONS(638),
    [anon_sym_uint] = ACTIONS(638),
    [anon_sym_uint8] = ACTIONS(638),
    [anon_sym_uint16] = ACTIONS(638),
    [anon_sym_uint32] = ACTIONS(638),
    [anon_sym_uint64] = ACTIONS(638),
    [anon_sym_uint128] = ACTIONS(638),
    [anon_sym_int] = ACTIONS(638),
    [anon_sym_int8] = ACTIONS(638),
    [anon_sym_int16] = ACTIONS(638),
    [anon_sym_int32] = ACTIONS(638),
    [anon_sym_int64] = ACTIONS(638),
    [anon_sym_int128] = ACTIONS(638),
    [anon_sym_string] = ACTIONS(638),
    [anon_sym_bytes] = ACTIONS(638),
    [anon_sym_bool] = ACTIONS(638),
    [anon_sym_AT] = ACTIONS(636),
    [anon_sym_DASH] = ACTIONS(638),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(636),
    [anon_sym_LT] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(638),
    [anon_sym_STAR] = ACTIONS(636),
    [anon_sym_len] = ACTIONS(638),
    [anon_sym_close] = ACTIONS(638),
    [anon_sym_and] = ACTIONS(638),
    [anon_sym_or] = ACTIONS(638),
    [anon_sym_div] = ACTIONS(638),
    [anon_sym_mod] = ACTIONS(638),
    [anon_sym_quo] = ACTIONS(638),
    [anon_sym_rem] = ACTIONS(638),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(636),
    [anon_sym_BANG] = ACTIONS(638),
    [anon_sym_QMARK] = ACTIONS(592),
    [anon_sym_COLON] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(638),
    [anon_sym_SLASH] = ACTIONS(638),
    [anon_sym_PIPE] = ACTIONS(638),
    [anon_sym_AMP] = ACTIONS(638),
    [anon_sym_PIPE_PIPE] = ACTIONS(636),
    [anon_sym_AMP_AMP] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(636),
    [anon_sym_EQ_TILDE] = ACTIONS(636),
    [anon_sym_BANG_TILDE] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(636),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [sym_bottom] = ACTIONS(636),
    [anon_sym_true] = ACTIONS(638),
    [anon_sym_false] = ACTIONS(638),
    [sym_null] = ACTIONS(638),
    [sym_number] = ACTIONS(638),
    [sym_float] = ACTIONS(638),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_SQUOTE] = ACTIONS(638),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(636),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(636),
    [anon_sym_POUND_DQUOTE] = ACTIONS(638),
    [anon_sym_POUND_SQUOTE] = ACTIONS(638),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(636),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(636),
    [sym_comment] = ACTIONS(3),
  },
  [136] = {
    [ts_builtin_sym_end] = ACTIONS(662),
    [sym_identifier] = ACTIONS(664),
    [anon_sym_COMMA] = ACTIONS(662),
    [anon_sym_DOT] = ACTIONS(664),
    [anon_sym__] = ACTIONS(664),
    [anon_sym_LPAREN] = ACTIONS(662),
    [anon_sym_let] = ACTIONS(664),
    [anon_sym_if] = ACTIONS(664),
    [anon_sym_for] = ACTIONS(664),
    [anon_sym_number] = ACTIONS(664),
    [anon_sym_float] = ACTIONS(664),
    [anon_sym_float32] = ACTIONS(664),
    [anon_sym_float64] = ACTIONS(664),
    [anon_sym_uint] = ACTIONS(664),
    [anon_sym_uint8] = ACTIONS(664),
    [anon_sym_uint16] = ACTIONS(664),
    [anon_sym_uint32] = ACTIONS(664),
    [anon_sym_uint64] = ACTIONS(664),
    [anon_sym_uint128] = ACTIONS(664),
    [anon_sym_int] = ACTIONS(664),
    [anon_sym_int8] = ACTIONS(664),
    [anon_sym_int16] = ACTIONS(664),
    [anon_sym_int32] = ACTIONS(664),
    [anon_sym_int64] = ACTIONS(664),
    [anon_sym_int128] = ACTIONS(664),
    [anon_sym_string] = ACTIONS(664),
    [anon_sym_bytes] = ACTIONS(664),
    [anon_sym_bool] = ACTIONS(664),
    [anon_sym_AT] = ACTIONS(662),
    [anon_sym_DASH] = ACTIONS(664),
    [anon_sym_LBRACK] = ACTIONS(662),
    [anon_sym_LBRACE] = ACTIONS(662),
    [anon_sym_RBRACE] = ACTIONS(662),
    [anon_sym_LT] = ACTIONS(664),
    [anon_sym_GT] = ACTIONS(664),
    [anon_sym_STAR] = ACTIONS(662),
    [anon_sym_len] = ACTIONS(664),
    [anon_sym_close] = ACTIONS(664),
    [anon_sym_and] = ACTIONS(664),
    [anon_sym_or] = ACTIONS(664),
    [anon_sym_div] = ACTIONS(664),
    [anon_sym_mod] = ACTIONS(664),
    [anon_sym_quo] = ACTIONS(664),
    [anon_sym_rem] = ACTIONS(664),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(662),
    [anon_sym_BANG] = ACTIONS(666),
    [anon_sym_QMARK] = ACTIONS(668),
    [anon_sym_COLON] = ACTIONS(668),
    [anon_sym_PLUS] = ACTIONS(664),
    [anon_sym_SLASH] = ACTIONS(664),
    [anon_sym_PIPE] = ACTIONS(664),
    [anon_sym_AMP] = ACTIONS(664),
    [anon_sym_PIPE_PIPE] = ACTIONS(662),
    [anon_sym_AMP_AMP] = ACTIONS(662),
    [anon_sym_EQ_EQ] = ACTIONS(662),
    [anon_sym_EQ_TILDE] = ACTIONS(662),
    [anon_sym_BANG_TILDE] = ACTIONS(662),
    [anon_sym_BANG_EQ] = ACTIONS(662),
    [anon_sym_LT_EQ] = ACTIONS(662),
    [anon_sym_GT_EQ] = ACTIONS(662),
    [sym_bottom] = ACTIONS(662),
    [anon_sym_true] = ACTIONS(664),
    [anon_sym_false] = ACTIONS(664),
    [sym_null] = ACTIONS(664),
    [sym_number] = ACTIONS(664),
    [sym_float] = ACTIONS(664),
    [anon_sym_DQUOTE] = ACTIONS(664),
    [anon_sym_SQUOTE] = ACTIONS(664),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(662),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(662),
    [anon_sym_POUND_DQUOTE] = ACTIONS(664),
    [anon_sym_POUND_SQUOTE] = ACTIONS(664),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(662),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(662),
    [sym_comment] = ACTIONS(3),
  },
  [137] = {
    [ts_builtin_sym_end] = ACTIONS(670),
    [sym_identifier] = ACTIONS(672),
    [anon_sym_COMMA] = ACTIONS(670),
    [anon_sym_DOT] = ACTIONS(672),
    [anon_sym__] = ACTIONS(672),
    [anon_sym_LPAREN] = ACTIONS(670),
    [anon_sym_RPAREN] = ACTIONS(670),
    [anon_sym_let] = ACTIONS(672),
    [anon_sym_if] = ACTIONS(672),
    [anon_sym_for] = ACTIONS(672),
    [anon_sym_number] = ACTIONS(672),
    [anon_sym_float] = ACTIONS(672),
    [anon_sym_float32] = ACTIONS(672),
    [anon_sym_float64] = ACTIONS(672),
    [anon_sym_uint] = ACTIONS(672),
    [anon_sym_uint8] = ACTIONS(672),
    [anon_sym_uint16] = ACTIONS(672),
    [anon_sym_uint32] = ACTIONS(672),
    [anon_sym_uint64] = ACTIONS(672),
    [anon_sym_uint128] = ACTIONS(672),
    [anon_sym_int] = ACTIONS(672),
    [anon_sym_int8] = ACTIONS(672),
    [anon_sym_int16] = ACTIONS(672),
    [anon_sym_int32] = ACTIONS(672),
    [anon_sym_int64] = ACTIONS(672),
    [anon_sym_int128] = ACTIONS(672),
    [anon_sym_string] = ACTIONS(672),
    [anon_sym_bytes] = ACTIONS(672),
    [anon_sym_bool] = ACTIONS(672),
    [anon_sym_AT] = ACTIONS(670),
    [anon_sym_DASH] = ACTIONS(672),
    [anon_sym_LBRACK] = ACTIONS(670),
    [anon_sym_RBRACK] = ACTIONS(670),
    [anon_sym_LBRACE] = ACTIONS(670),
    [anon_sym_RBRACE] = ACTIONS(670),
    [anon_sym_LT] = ACTIONS(672),
    [anon_sym_GT] = ACTIONS(672),
    [anon_sym_STAR] = ACTIONS(670),
    [anon_sym_len] = ACTIONS(672),
    [anon_sym_close] = ACTIONS(672),
    [anon_sym_and] = ACTIONS(672),
    [anon_sym_or] = ACTIONS(672),
    [anon_sym_div] = ACTIONS(672),
    [anon_sym_mod] = ACTIONS(672),
    [anon_sym_quo] = ACTIONS(672),
    [anon_sym_rem] = ACTIONS(672),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(670),
    [anon_sym_BANG] = ACTIONS(672),
    [anon_sym_PLUS] = ACTIONS(672),
    [anon_sym_SLASH] = ACTIONS(672),
    [anon_sym_PIPE] = ACTIONS(672),
    [anon_sym_AMP] = ACTIONS(672),
    [anon_sym_PIPE_PIPE] = ACTIONS(670),
    [anon_sym_AMP_AMP] = ACTIONS(670),
    [anon_sym_EQ_EQ] = ACTIONS(670),
    [anon_sym_EQ_TILDE] = ACTIONS(670),
    [anon_sym_BANG_TILDE] = ACTIONS(670),
    [anon_sym_BANG_EQ] = ACTIONS(670),
    [anon_sym_LT_EQ] = ACTIONS(670),
    [anon_sym_GT_EQ] = ACTIONS(670),
    [sym_bottom] = ACTIONS(670),
    [anon_sym_true] = ACTIONS(672),
    [anon_sym_false] = ACTIONS(672),
    [sym_null] = ACTIONS(672),
    [sym_number] = ACTIONS(672),
    [sym_float] = ACTIONS(672),
    [anon_sym_DQUOTE] = ACTIONS(672),
    [anon_sym_SQUOTE] = ACTIONS(672),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(670),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(670),
    [anon_sym_POUND_DQUOTE] = ACTIONS(672),
    [anon_sym_POUND_SQUOTE] = ACTIONS(672),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(670),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(670),
    [sym_comment] = ACTIONS(3),
  },
  [138] = {
    [ts_builtin_sym_end] = ACTIONS(674),
    [sym_identifier] = ACTIONS(676),
    [anon_sym_COMMA] = ACTIONS(674),
    [anon_sym_DOT] = ACTIONS(676),
    [anon_sym__] = ACTIONS(676),
    [anon_sym_LPAREN] = ACTIONS(674),
    [anon_sym_RPAREN] = ACTIONS(674),
    [anon_sym_let] = ACTIONS(676),
    [anon_sym_if] = ACTIONS(676),
    [anon_sym_for] = ACTIONS(676),
    [anon_sym_number] = ACTIONS(676),
    [anon_sym_float] = ACTIONS(676),
    [anon_sym_float32] = ACTIONS(676),
    [anon_sym_float64] = ACTIONS(676),
    [anon_sym_uint] = ACTIONS(676),
    [anon_sym_uint8] = ACTIONS(676),
    [anon_sym_uint16] = ACTIONS(676),
    [anon_sym_uint32] = ACTIONS(676),
    [anon_sym_uint64] = ACTIONS(676),
    [anon_sym_uint128] = ACTIONS(676),
    [anon_sym_int] = ACTIONS(676),
    [anon_sym_int8] = ACTIONS(676),
    [anon_sym_int16] = ACTIONS(676),
    [anon_sym_int32] = ACTIONS(676),
    [anon_sym_int64] = ACTIONS(676),
    [anon_sym_int128] = ACTIONS(676),
    [anon_sym_string] = ACTIONS(676),
    [anon_sym_bytes] = ACTIONS(676),
    [anon_sym_bool] = ACTIONS(676),
    [anon_sym_AT] = ACTIONS(674),
    [anon_sym_DASH] = ACTIONS(676),
    [anon_sym_LBRACK] = ACTIONS(674),
    [anon_sym_RBRACK] = ACTIONS(674),
    [anon_sym_LBRACE] = ACTIONS(674),
    [anon_sym_RBRACE] = ACTIONS(674),
    [anon_sym_LT] = ACTIONS(676),
    [anon_sym_GT] = ACTIONS(676),
    [anon_sym_STAR] = ACTIONS(674),
    [anon_sym_len] = ACTIONS(676),
    [anon_sym_close] = ACTIONS(676),
    [anon_sym_and] = ACTIONS(676),
    [anon_sym_or] = ACTIONS(676),
    [anon_sym_div] = ACTIONS(676),
    [anon_sym_mod] = ACTIONS(676),
    [anon_sym_quo] = ACTIONS(676),
    [anon_sym_rem] = ACTIONS(676),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(674),
    [anon_sym_BANG] = ACTIONS(676),
    [anon_sym_PLUS] = ACTIONS(676),
    [anon_sym_SLASH] = ACTIONS(676),
    [anon_sym_PIPE] = ACTIONS(676),
    [anon_sym_AMP] = ACTIONS(676),
    [anon_sym_PIPE_PIPE] = ACTIONS(674),
    [anon_sym_AMP_AMP] = ACTIONS(674),
    [anon_sym_EQ_EQ] = ACTIONS(674),
    [anon_sym_EQ_TILDE] = ACTIONS(674),
    [anon_sym_BANG_TILDE] = ACTIONS(674),
    [anon_sym_BANG_EQ] = ACTIONS(674),
    [anon_sym_LT_EQ] = ACTIONS(674),
    [anon_sym_GT_EQ] = ACTIONS(674),
    [sym_bottom] = ACTIONS(674),
    [anon_sym_true] = ACTIONS(676),
    [anon_sym_false] = ACTIONS(676),
    [sym_null] = ACTIONS(676),
    [sym_number] = ACTIONS(676),
    [sym_float] = ACTIONS(676),
    [anon_sym_DQUOTE] = ACTIONS(676),
    [anon_sym_SQUOTE] = ACTIONS(676),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(674),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(674),
    [anon_sym_POUND_DQUOTE] = ACTIONS(676),
    [anon_sym_POUND_SQUOTE] = ACTIONS(676),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(674),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(674),
    [sym_comment] = ACTIONS(3),
  },
  [139] = {
    [ts_builtin_sym_end] = ACTIONS(678),
    [sym_identifier] = ACTIONS(680),
    [anon_sym_COMMA] = ACTIONS(678),
    [anon_sym_DOT] = ACTIONS(680),
    [anon_sym__] = ACTIONS(680),
    [anon_sym_LPAREN] = ACTIONS(678),
    [anon_sym_RPAREN] = ACTIONS(678),
    [anon_sym_let] = ACTIONS(680),
    [anon_sym_if] = ACTIONS(680),
    [anon_sym_for] = ACTIONS(680),
    [anon_sym_number] = ACTIONS(680),
    [anon_sym_float] = ACTIONS(680),
    [anon_sym_float32] = ACTIONS(680),
    [anon_sym_float64] = ACTIONS(680),
    [anon_sym_uint] = ACTIONS(680),
    [anon_sym_uint8] = ACTIONS(680),
    [anon_sym_uint16] = ACTIONS(680),
    [anon_sym_uint32] = ACTIONS(680),
    [anon_sym_uint64] = ACTIONS(680),
    [anon_sym_uint128] = ACTIONS(680),
    [anon_sym_int] = ACTIONS(680),
    [anon_sym_int8] = ACTIONS(680),
    [anon_sym_int16] = ACTIONS(680),
    [anon_sym_int32] = ACTIONS(680),
    [anon_sym_int64] = ACTIONS(680),
    [anon_sym_int128] = ACTIONS(680),
    [anon_sym_string] = ACTIONS(680),
    [anon_sym_bytes] = ACTIONS(680),
    [anon_sym_bool] = ACTIONS(680),
    [anon_sym_AT] = ACTIONS(678),
    [anon_sym_DASH] = ACTIONS(680),
    [anon_sym_LBRACK] = ACTIONS(678),
    [anon_sym_RBRACK] = ACTIONS(678),
    [anon_sym_LBRACE] = ACTIONS(678),
    [anon_sym_RBRACE] = ACTIONS(678),
    [anon_sym_LT] = ACTIONS(680),
    [anon_sym_GT] = ACTIONS(680),
    [anon_sym_STAR] = ACTIONS(678),
    [anon_sym_len] = ACTIONS(680),
    [anon_sym_close] = ACTIONS(680),
    [anon_sym_and] = ACTIONS(680),
    [anon_sym_or] = ACTIONS(680),
    [anon_sym_div] = ACTIONS(680),
    [anon_sym_mod] = ACTIONS(680),
    [anon_sym_quo] = ACTIONS(680),
    [anon_sym_rem] = ACTIONS(680),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(678),
    [anon_sym_BANG] = ACTIONS(680),
    [anon_sym_PLUS] = ACTIONS(680),
    [anon_sym_SLASH] = ACTIONS(680),
    [anon_sym_PIPE] = ACTIONS(680),
    [anon_sym_AMP] = ACTIONS(680),
    [anon_sym_PIPE_PIPE] = ACTIONS(678),
    [anon_sym_AMP_AMP] = ACTIONS(678),
    [anon_sym_EQ_EQ] = ACTIONS(678),
    [anon_sym_EQ_TILDE] = ACTIONS(678),
    [anon_sym_BANG_TILDE] = ACTIONS(678),
    [anon_sym_BANG_EQ] = ACTIONS(678),
    [anon_sym_LT_EQ] = ACTIONS(678),
    [anon_sym_GT_EQ] = ACTIONS(678),
    [sym_bottom] = ACTIONS(678),
    [anon_sym_true] = ACTIONS(680),
    [anon_sym_false] = ACTIONS(680),
    [sym_null] = ACTIONS(680),
    [sym_number] = ACTIONS(680),
    [sym_float] = ACTIONS(680),
    [anon_sym_DQUOTE] = ACTIONS(680),
    [anon_sym_SQUOTE] = ACTIONS(680),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(678),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(678),
    [anon_sym_POUND_DQUOTE] = ACTIONS(680),
    [anon_sym_POUND_SQUOTE] = ACTIONS(680),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(678),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(678),
    [sym_comment] = ACTIONS(3),
  },
  [140] = {
    [ts_builtin_sym_end] = ACTIONS(682),
    [sym_identifier] = ACTIONS(684),
    [anon_sym_COMMA] = ACTIONS(682),
    [anon_sym_DOT] = ACTIONS(684),
    [anon_sym__] = ACTIONS(684),
    [anon_sym_LPAREN] = ACTIONS(682),
    [anon_sym_RPAREN] = ACTIONS(682),
    [anon_sym_let] = ACTIONS(684),
    [anon_sym_if] = ACTIONS(684),
    [anon_sym_for] = ACTIONS(684),
    [anon_sym_number] = ACTIONS(684),
    [anon_sym_float] = ACTIONS(684),
    [anon_sym_float32] = ACTIONS(684),
    [anon_sym_float64] = ACTIONS(684),
    [anon_sym_uint] = ACTIONS(684),
    [anon_sym_uint8] = ACTIONS(684),
    [anon_sym_uint16] = ACTIONS(684),
    [anon_sym_uint32] = ACTIONS(684),
    [anon_sym_uint64] = ACTIONS(684),
    [anon_sym_uint128] = ACTIONS(684),
    [anon_sym_int] = ACTIONS(684),
    [anon_sym_int8] = ACTIONS(684),
    [anon_sym_int16] = ACTIONS(684),
    [anon_sym_int32] = ACTIONS(684),
    [anon_sym_int64] = ACTIONS(684),
    [anon_sym_int128] = ACTIONS(684),
    [anon_sym_string] = ACTIONS(684),
    [anon_sym_bytes] = ACTIONS(684),
    [anon_sym_bool] = ACTIONS(684),
    [anon_sym_AT] = ACTIONS(682),
    [anon_sym_DASH] = ACTIONS(684),
    [anon_sym_LBRACK] = ACTIONS(682),
    [anon_sym_RBRACK] = ACTIONS(682),
    [anon_sym_LBRACE] = ACTIONS(682),
    [anon_sym_RBRACE] = ACTIONS(682),
    [anon_sym_LT] = ACTIONS(684),
    [anon_sym_GT] = ACTIONS(684),
    [anon_sym_STAR] = ACTIONS(682),
    [anon_sym_len] = ACTIONS(684),
    [anon_sym_close] = ACTIONS(684),
    [anon_sym_and] = ACTIONS(684),
    [anon_sym_or] = ACTIONS(684),
    [anon_sym_div] = ACTIONS(684),
    [anon_sym_mod] = ACTIONS(684),
    [anon_sym_quo] = ACTIONS(684),
    [anon_sym_rem] = ACTIONS(684),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(682),
    [anon_sym_BANG] = ACTIONS(684),
    [anon_sym_PLUS] = ACTIONS(684),
    [anon_sym_SLASH] = ACTIONS(684),
    [anon_sym_PIPE] = ACTIONS(684),
    [anon_sym_AMP] = ACTIONS(684),
    [anon_sym_PIPE_PIPE] = ACTIONS(682),
    [anon_sym_AMP_AMP] = ACTIONS(682),
    [anon_sym_EQ_EQ] = ACTIONS(682),
    [anon_sym_EQ_TILDE] = ACTIONS(682),
    [anon_sym_BANG_TILDE] = ACTIONS(682),
    [anon_sym_BANG_EQ] = ACTIONS(682),
    [anon_sym_LT_EQ] = ACTIONS(682),
    [anon_sym_GT_EQ] = ACTIONS(682),
    [sym_bottom] = ACTIONS(682),
    [anon_sym_true] = ACTIONS(684),
    [anon_sym_false] = ACTIONS(684),
    [sym_null] = ACTIONS(684),
    [sym_number] = ACTIONS(684),
    [sym_float] = ACTIONS(684),
    [anon_sym_DQUOTE] = ACTIONS(684),
    [anon_sym_SQUOTE] = ACTIONS(684),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(682),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(682),
    [anon_sym_POUND_DQUOTE] = ACTIONS(684),
    [anon_sym_POUND_SQUOTE] = ACTIONS(684),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(682),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(682),
    [sym_comment] = ACTIONS(3),
  },
  [141] = {
    [ts_builtin_sym_end] = ACTIONS(686),
    [sym_identifier] = ACTIONS(688),
    [anon_sym_COMMA] = ACTIONS(686),
    [anon_sym_DOT] = ACTIONS(688),
    [anon_sym__] = ACTIONS(688),
    [anon_sym_LPAREN] = ACTIONS(686),
    [anon_sym_RPAREN] = ACTIONS(686),
    [anon_sym_let] = ACTIONS(688),
    [anon_sym_if] = ACTIONS(688),
    [anon_sym_for] = ACTIONS(688),
    [anon_sym_number] = ACTIONS(688),
    [anon_sym_float] = ACTIONS(688),
    [anon_sym_float32] = ACTIONS(688),
    [anon_sym_float64] = ACTIONS(688),
    [anon_sym_uint] = ACTIONS(688),
    [anon_sym_uint8] = ACTIONS(688),
    [anon_sym_uint16] = ACTIONS(688),
    [anon_sym_uint32] = ACTIONS(688),
    [anon_sym_uint64] = ACTIONS(688),
    [anon_sym_uint128] = ACTIONS(688),
    [anon_sym_int] = ACTIONS(688),
    [anon_sym_int8] = ACTIONS(688),
    [anon_sym_int16] = ACTIONS(688),
    [anon_sym_int32] = ACTIONS(688),
    [anon_sym_int64] = ACTIONS(688),
    [anon_sym_int128] = ACTIONS(688),
    [anon_sym_string] = ACTIONS(688),
    [anon_sym_bytes] = ACTIONS(688),
    [anon_sym_bool] = ACTIONS(688),
    [anon_sym_AT] = ACTIONS(686),
    [anon_sym_DASH] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(686),
    [anon_sym_RBRACK] = ACTIONS(686),
    [anon_sym_LBRACE] = ACTIONS(686),
    [anon_sym_RBRACE] = ACTIONS(686),
    [anon_sym_LT] = ACTIONS(688),
    [anon_sym_GT] = ACTIONS(688),
    [anon_sym_STAR] = ACTIONS(686),
    [anon_sym_len] = ACTIONS(688),
    [anon_sym_close] = ACTIONS(688),
    [anon_sym_and] = ACTIONS(688),
    [anon_sym_or] = ACTIONS(688),
    [anon_sym_div] = ACTIONS(688),
    [anon_sym_mod] = ACTIONS(688),
    [anon_sym_quo] = ACTIONS(688),
    [anon_sym_rem] = ACTIONS(688),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(686),
    [anon_sym_BANG] = ACTIONS(688),
    [anon_sym_PLUS] = ACTIONS(688),
    [anon_sym_SLASH] = ACTIONS(688),
    [anon_sym_PIPE] = ACTIONS(688),
    [anon_sym_AMP] = ACTIONS(688),
    [anon_sym_PIPE_PIPE] = ACTIONS(686),
    [anon_sym_AMP_AMP] = ACTIONS(686),
    [anon_sym_EQ_EQ] = ACTIONS(686),
    [anon_sym_EQ_TILDE] = ACTIONS(686),
    [anon_sym_BANG_TILDE] = ACTIONS(686),
    [anon_sym_BANG_EQ] = ACTIONS(686),
    [anon_sym_LT_EQ] = ACTIONS(686),
    [anon_sym_GT_EQ] = ACTIONS(686),
    [sym_bottom] = ACTIONS(686),
    [anon_sym_true] = ACTIONS(688),
    [anon_sym_false] = ACTIONS(688),
    [sym_null] = ACTIONS(688),
    [sym_number] = ACTIONS(688),
    [sym_float] = ACTIONS(688),
    [anon_sym_DQUOTE] = ACTIONS(688),
    [anon_sym_SQUOTE] = ACTIONS(688),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(686),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(686),
    [anon_sym_POUND_DQUOTE] = ACTIONS(688),
    [anon_sym_POUND_SQUOTE] = ACTIONS(688),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(686),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(686),
    [sym_comment] = ACTIONS(3),
  },
  [142] = {
    [ts_builtin_sym_end] = ACTIONS(690),
    [sym_identifier] = ACTIONS(692),
    [anon_sym_COMMA] = ACTIONS(690),
    [anon_sym_DOT] = ACTIONS(692),
    [anon_sym__] = ACTIONS(692),
    [anon_sym_LPAREN] = ACTIONS(690),
    [anon_sym_RPAREN] = ACTIONS(690),
    [anon_sym_let] = ACTIONS(692),
    [anon_sym_if] = ACTIONS(692),
    [anon_sym_for] = ACTIONS(692),
    [anon_sym_number] = ACTIONS(692),
    [anon_sym_float] = ACTIONS(692),
    [anon_sym_float32] = ACTIONS(692),
    [anon_sym_float64] = ACTIONS(692),
    [anon_sym_uint] = ACTIONS(692),
    [anon_sym_uint8] = ACTIONS(692),
    [anon_sym_uint16] = ACTIONS(692),
    [anon_sym_uint32] = ACTIONS(692),
    [anon_sym_uint64] = ACTIONS(692),
    [anon_sym_uint128] = ACTIONS(692),
    [anon_sym_int] = ACTIONS(692),
    [anon_sym_int8] = ACTIONS(692),
    [anon_sym_int16] = ACTIONS(692),
    [anon_sym_int32] = ACTIONS(692),
    [anon_sym_int64] = ACTIONS(692),
    [anon_sym_int128] = ACTIONS(692),
    [anon_sym_string] = ACTIONS(692),
    [anon_sym_bytes] = ACTIONS(692),
    [anon_sym_bool] = ACTIONS(692),
    [anon_sym_AT] = ACTIONS(690),
    [anon_sym_DASH] = ACTIONS(692),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(690),
    [anon_sym_LBRACE] = ACTIONS(690),
    [anon_sym_RBRACE] = ACTIONS(690),
    [anon_sym_LT] = ACTIONS(692),
    [anon_sym_GT] = ACTIONS(692),
    [anon_sym_STAR] = ACTIONS(690),
    [anon_sym_len] = ACTIONS(692),
    [anon_sym_close] = ACTIONS(692),
    [anon_sym_and] = ACTIONS(692),
    [anon_sym_or] = ACTIONS(692),
    [anon_sym_div] = ACTIONS(692),
    [anon_sym_mod] = ACTIONS(692),
    [anon_sym_quo] = ACTIONS(692),
    [anon_sym_rem] = ACTIONS(692),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(690),
    [anon_sym_BANG] = ACTIONS(692),
    [anon_sym_PLUS] = ACTIONS(692),
    [anon_sym_SLASH] = ACTIONS(692),
    [anon_sym_PIPE] = ACTIONS(692),
    [anon_sym_AMP] = ACTIONS(692),
    [anon_sym_PIPE_PIPE] = ACTIONS(690),
    [anon_sym_AMP_AMP] = ACTIONS(690),
    [anon_sym_EQ_EQ] = ACTIONS(690),
    [anon_sym_EQ_TILDE] = ACTIONS(690),
    [anon_sym_BANG_TILDE] = ACTIONS(690),
    [anon_sym_BANG_EQ] = ACTIONS(690),
    [anon_sym_LT_EQ] = ACTIONS(690),
    [anon_sym_GT_EQ] = ACTIONS(690),
    [sym_bottom] = ACTIONS(690),
    [anon_sym_true] = ACTIONS(692),
    [anon_sym_false] = ACTIONS(692),
    [sym_null] = ACTIONS(692),
    [sym_number] = ACTIONS(692),
    [sym_float] = ACTIONS(692),
    [anon_sym_DQUOTE] = ACTIONS(692),
    [anon_sym_SQUOTE] = ACTIONS(692),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(690),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(690),
    [anon_sym_POUND_DQUOTE] = ACTIONS(692),
    [anon_sym_POUND_SQUOTE] = ACTIONS(692),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(690),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(690),
    [sym_comment] = ACTIONS(3),
  },
  [143] = {
    [ts_builtin_sym_end] = ACTIONS(602),
    [sym_identifier] = ACTIONS(604),
    [anon_sym_COMMA] = ACTIONS(602),
    [anon_sym_DOT] = ACTIONS(604),
    [anon_sym__] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(602),
    [anon_sym_let] = ACTIONS(604),
    [anon_sym_if] = ACTIONS(604),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_number] = ACTIONS(604),
    [anon_sym_float] = ACTIONS(604),
    [anon_sym_float32] = ACTIONS(604),
    [anon_sym_float64] = ACTIONS(604),
    [anon_sym_uint] = ACTIONS(604),
    [anon_sym_uint8] = ACTIONS(604),
    [anon_sym_uint16] = ACTIONS(604),
    [anon_sym_uint32] = ACTIONS(604),
    [anon_sym_uint64] = ACTIONS(604),
    [anon_sym_uint128] = ACTIONS(604),
    [anon_sym_int] = ACTIONS(604),
    [anon_sym_int8] = ACTIONS(604),
    [anon_sym_int16] = ACTIONS(604),
    [anon_sym_int32] = ACTIONS(604),
    [anon_sym_int64] = ACTIONS(604),
    [anon_sym_int128] = ACTIONS(604),
    [anon_sym_string] = ACTIONS(604),
    [anon_sym_bytes] = ACTIONS(604),
    [anon_sym_bool] = ACTIONS(604),
    [anon_sym_AT] = ACTIONS(602),
    [anon_sym_DASH] = ACTIONS(604),
    [anon_sym_LBRACK] = ACTIONS(602),
    [anon_sym_LBRACE] = ACTIONS(602),
    [anon_sym_RBRACE] = ACTIONS(602),
    [anon_sym_LT] = ACTIONS(604),
    [anon_sym_GT] = ACTIONS(604),
    [anon_sym_STAR] = ACTIONS(602),
    [anon_sym_len] = ACTIONS(604),
    [anon_sym_close] = ACTIONS(604),
    [anon_sym_and] = ACTIONS(604),
    [anon_sym_or] = ACTIONS(604),
    [anon_sym_div] = ACTIONS(604),
    [anon_sym_mod] = ACTIONS(604),
    [anon_sym_quo] = ACTIONS(604),
    [anon_sym_rem] = ACTIONS(604),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(602),
    [anon_sym_BANG] = ACTIONS(694),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(604),
    [anon_sym_SLASH] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(604),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE_PIPE] = ACTIONS(602),
    [anon_sym_AMP_AMP] = ACTIONS(602),
    [anon_sym_EQ_EQ] = ACTIONS(602),
    [anon_sym_EQ_TILDE] = ACTIONS(602),
    [anon_sym_BANG_TILDE] = ACTIONS(602),
    [anon_sym_BANG_EQ] = ACTIONS(602),
    [anon_sym_LT_EQ] = ACTIONS(602),
    [anon_sym_GT_EQ] = ACTIONS(602),
    [sym_bottom] = ACTIONS(602),
    [anon_sym_true] = ACTIONS(604),
    [anon_sym_false] = ACTIONS(604),
    [sym_null] = ACTIONS(604),
    [sym_number] = ACTIONS(604),
    [sym_float] = ACTIONS(604),
    [anon_sym_DQUOTE] = ACTIONS(604),
    [anon_sym_SQUOTE] = ACTIONS(604),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(602),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(602),
    [anon_sym_POUND_DQUOTE] = ACTIONS(604),
    [anon_sym_POUND_SQUOTE] = ACTIONS(604),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(602),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(602),
    [sym_comment] = ACTIONS(3),
  },
  [144] = {
    [ts_builtin_sym_end] = ACTIONS(698),
    [sym_identifier] = ACTIONS(700),
    [anon_sym_COMMA] = ACTIONS(698),
    [anon_sym_DOT] = ACTIONS(700),
    [anon_sym__] = ACTIONS(700),
    [anon_sym_LPAREN] = ACTIONS(698),
    [anon_sym_RPAREN] = ACTIONS(698),
    [anon_sym_let] = ACTIONS(700),
    [anon_sym_if] = ACTIONS(700),
    [anon_sym_for] = ACTIONS(700),
    [anon_sym_number] = ACTIONS(700),
    [anon_sym_float] = ACTIONS(700),
    [anon_sym_float32] = ACTIONS(700),
    [anon_sym_float64] = ACTIONS(700),
    [anon_sym_uint] = ACTIONS(700),
    [anon_sym_uint8] = ACTIONS(700),
    [anon_sym_uint16] = ACTIONS(700),
    [anon_sym_uint32] = ACTIONS(700),
    [anon_sym_uint64] = ACTIONS(700),
    [anon_sym_uint128] = ACTIONS(700),
    [anon_sym_int] = ACTIONS(700),
    [anon_sym_int8] = ACTIONS(700),
    [anon_sym_int16] = ACTIONS(700),
    [anon_sym_int32] = ACTIONS(700),
    [anon_sym_int64] = ACTIONS(700),
    [anon_sym_int128] = ACTIONS(700),
    [anon_sym_string] = ACTIONS(700),
    [anon_sym_bytes] = ACTIONS(700),
    [anon_sym_bool] = ACTIONS(700),
    [anon_sym_AT] = ACTIONS(698),
    [anon_sym_DASH] = ACTIONS(700),
    [anon_sym_LBRACK] = ACTIONS(698),
    [anon_sym_RBRACK] = ACTIONS(698),
    [anon_sym_LBRACE] = ACTIONS(698),
    [anon_sym_RBRACE] = ACTIONS(698),
    [anon_sym_LT] = ACTIONS(700),
    [anon_sym_GT] = ACTIONS(700),
    [anon_sym_STAR] = ACTIONS(698),
    [anon_sym_len] = ACTIONS(700),
    [anon_sym_close] = ACTIONS(700),
    [anon_sym_and] = ACTIONS(700),
    [anon_sym_or] = ACTIONS(700),
    [anon_sym_div] = ACTIONS(700),
    [anon_sym_mod] = ACTIONS(700),
    [anon_sym_quo] = ACTIONS(700),
    [anon_sym_rem] = ACTIONS(700),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(698),
    [anon_sym_BANG] = ACTIONS(700),
    [anon_sym_PLUS] = ACTIONS(700),
    [anon_sym_SLASH] = ACTIONS(700),
    [anon_sym_PIPE] = ACTIONS(700),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_PIPE_PIPE] = ACTIONS(698),
    [anon_sym_AMP_AMP] = ACTIONS(698),
    [anon_sym_EQ_EQ] = ACTIONS(698),
    [anon_sym_EQ_TILDE] = ACTIONS(698),
    [anon_sym_BANG_TILDE] = ACTIONS(698),
    [anon_sym_BANG_EQ] = ACTIONS(698),
    [anon_sym_LT_EQ] = ACTIONS(698),
    [anon_sym_GT_EQ] = ACTIONS(698),
    [sym_bottom] = ACTIONS(698),
    [anon_sym_true] = ACTIONS(700),
    [anon_sym_false] = ACTIONS(700),
    [sym_null] = ACTIONS(700),
    [sym_number] = ACTIONS(700),
    [sym_float] = ACTIONS(700),
    [anon_sym_DQUOTE] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(700),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(698),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(698),
    [anon_sym_POUND_DQUOTE] = ACTIONS(700),
    [anon_sym_POUND_SQUOTE] = ACTIONS(700),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(698),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(698),
    [sym_comment] = ACTIONS(3),
  },
  [145] = {
    [ts_builtin_sym_end] = ACTIONS(702),
    [sym_identifier] = ACTIONS(704),
    [anon_sym_COMMA] = ACTIONS(702),
    [anon_sym_DOT] = ACTIONS(704),
    [anon_sym__] = ACTIONS(704),
    [anon_sym_LPAREN] = ACTIONS(702),
    [anon_sym_RPAREN] = ACTIONS(702),
    [anon_sym_let] = ACTIONS(704),
    [anon_sym_if] = ACTIONS(704),
    [anon_sym_for] = ACTIONS(704),
    [anon_sym_number] = ACTIONS(704),
    [anon_sym_float] = ACTIONS(704),
    [anon_sym_float32] = ACTIONS(704),
    [anon_sym_float64] = ACTIONS(704),
    [anon_sym_uint] = ACTIONS(704),
    [anon_sym_uint8] = ACTIONS(704),
    [anon_sym_uint16] = ACTIONS(704),
    [anon_sym_uint32] = ACTIONS(704),
    [anon_sym_uint64] = ACTIONS(704),
    [anon_sym_uint128] = ACTIONS(704),
    [anon_sym_int] = ACTIONS(704),
    [anon_sym_int8] = ACTIONS(704),
    [anon_sym_int16] = ACTIONS(704),
    [anon_sym_int32] = ACTIONS(704),
    [anon_sym_int64] = ACTIONS(704),
    [anon_sym_int128] = ACTIONS(704),
    [anon_sym_string] = ACTIONS(704),
    [anon_sym_bytes] = ACTIONS(704),
    [anon_sym_bool] = ACTIONS(704),
    [anon_sym_AT] = ACTIONS(702),
    [anon_sym_DASH] = ACTIONS(704),
    [anon_sym_LBRACK] = ACTIONS(702),
    [anon_sym_RBRACK] = ACTIONS(702),
    [anon_sym_LBRACE] = ACTIONS(702),
    [anon_sym_RBRACE] = ACTIONS(702),
    [anon_sym_LT] = ACTIONS(704),
    [anon_sym_GT] = ACTIONS(704),
    [anon_sym_STAR] = ACTIONS(702),
    [anon_sym_len] = ACTIONS(704),
    [anon_sym_close] = ACTIONS(704),
    [anon_sym_and] = ACTIONS(704),
    [anon_sym_or] = ACTIONS(704),
    [anon_sym_div] = ACTIONS(704),
    [anon_sym_mod] = ACTIONS(704),
    [anon_sym_quo] = ACTIONS(704),
    [anon_sym_rem] = ACTIONS(704),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(702),
    [anon_sym_BANG] = ACTIONS(704),
    [anon_sym_PLUS] = ACTIONS(704),
    [anon_sym_SLASH] = ACTIONS(704),
    [anon_sym_PIPE] = ACTIONS(704),
    [anon_sym_AMP] = ACTIONS(704),
    [anon_sym_PIPE_PIPE] = ACTIONS(702),
    [anon_sym_AMP_AMP] = ACTIONS(702),
    [anon_sym_EQ_EQ] = ACTIONS(702),
    [anon_sym_EQ_TILDE] = ACTIONS(702),
    [anon_sym_BANG_TILDE] = ACTIONS(702),
    [anon_sym_BANG_EQ] = ACTIONS(702),
    [anon_sym_LT_EQ] = ACTIONS(702),
    [anon_sym_GT_EQ] = ACTIONS(702),
    [sym_bottom] = ACTIONS(702),
    [anon_sym_true] = ACTIONS(704),
    [anon_sym_false] = ACTIONS(704),
    [sym_null] = ACTIONS(704),
    [sym_number] = ACTIONS(704),
    [sym_float] = ACTIONS(704),
    [anon_sym_DQUOTE] = ACTIONS(704),
    [anon_sym_SQUOTE] = ACTIONS(704),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(702),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(702),
    [anon_sym_POUND_DQUOTE] = ACTIONS(704),
    [anon_sym_POUND_SQUOTE] = ACTIONS(704),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(702),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(702),
    [sym_comment] = ACTIONS(3),
  },
  [146] = {
    [ts_builtin_sym_end] = ACTIONS(706),
    [sym_identifier] = ACTIONS(708),
    [anon_sym_COMMA] = ACTIONS(706),
    [anon_sym_DOT] = ACTIONS(708),
    [anon_sym__] = ACTIONS(708),
    [anon_sym_LPAREN] = ACTIONS(706),
    [anon_sym_RPAREN] = ACTIONS(706),
    [anon_sym_let] = ACTIONS(708),
    [anon_sym_if] = ACTIONS(708),
    [anon_sym_for] = ACTIONS(708),
    [anon_sym_number] = ACTIONS(708),
    [anon_sym_float] = ACTIONS(708),
    [anon_sym_float32] = ACTIONS(708),
    [anon_sym_float64] = ACTIONS(708),
    [anon_sym_uint] = ACTIONS(708),
    [anon_sym_uint8] = ACTIONS(708),
    [anon_sym_uint16] = ACTIONS(708),
    [anon_sym_uint32] = ACTIONS(708),
    [anon_sym_uint64] = ACTIONS(708),
    [anon_sym_uint128] = ACTIONS(708),
    [anon_sym_int] = ACTIONS(708),
    [anon_sym_int8] = ACTIONS(708),
    [anon_sym_int16] = ACTIONS(708),
    [anon_sym_int32] = ACTIONS(708),
    [anon_sym_int64] = ACTIONS(708),
    [anon_sym_int128] = ACTIONS(708),
    [anon_sym_string] = ACTIONS(708),
    [anon_sym_bytes] = ACTIONS(708),
    [anon_sym_bool] = ACTIONS(708),
    [anon_sym_AT] = ACTIONS(706),
    [anon_sym_DASH] = ACTIONS(708),
    [anon_sym_LBRACK] = ACTIONS(706),
    [anon_sym_RBRACK] = ACTIONS(706),
    [anon_sym_LBRACE] = ACTIONS(706),
    [anon_sym_RBRACE] = ACTIONS(706),
    [anon_sym_LT] = ACTIONS(708),
    [anon_sym_GT] = ACTIONS(708),
    [anon_sym_STAR] = ACTIONS(706),
    [anon_sym_len] = ACTIONS(708),
    [anon_sym_close] = ACTIONS(708),
    [anon_sym_and] = ACTIONS(708),
    [anon_sym_or] = ACTIONS(708),
    [anon_sym_div] = ACTIONS(708),
    [anon_sym_mod] = ACTIONS(708),
    [anon_sym_quo] = ACTIONS(708),
    [anon_sym_rem] = ACTIONS(708),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(706),
    [anon_sym_BANG] = ACTIONS(708),
    [anon_sym_PLUS] = ACTIONS(708),
    [anon_sym_SLASH] = ACTIONS(708),
    [anon_sym_PIPE] = ACTIONS(708),
    [anon_sym_AMP] = ACTIONS(708),
    [anon_sym_PIPE_PIPE] = ACTIONS(706),
    [anon_sym_AMP_AMP] = ACTIONS(706),
    [anon_sym_EQ_EQ] = ACTIONS(706),
    [anon_sym_EQ_TILDE] = ACTIONS(706),
    [anon_sym_BANG_TILDE] = ACTIONS(706),
    [anon_sym_BANG_EQ] = ACTIONS(706),
    [anon_sym_LT_EQ] = ACTIONS(706),
    [anon_sym_GT_EQ] = ACTIONS(706),
    [sym_bottom] = ACTIONS(706),
    [anon_sym_true] = ACTIONS(708),
    [anon_sym_false] = ACTIONS(708),
    [sym_null] = ACTIONS(708),
    [sym_number] = ACTIONS(708),
    [sym_float] = ACTIONS(708),
    [anon_sym_DQUOTE] = ACTIONS(708),
    [anon_sym_SQUOTE] = ACTIONS(708),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(706),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(706),
    [anon_sym_POUND_DQUOTE] = ACTIONS(708),
    [anon_sym_POUND_SQUOTE] = ACTIONS(708),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(706),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(706),
    [sym_comment] = ACTIONS(3),
  },
  [147] = {
    [ts_builtin_sym_end] = ACTIONS(710),
    [sym_identifier] = ACTIONS(712),
    [anon_sym_COMMA] = ACTIONS(710),
    [anon_sym_DOT] = ACTIONS(712),
    [anon_sym__] = ACTIONS(712),
    [anon_sym_LPAREN] = ACTIONS(710),
    [anon_sym_RPAREN] = ACTIONS(710),
    [anon_sym_let] = ACTIONS(712),
    [anon_sym_if] = ACTIONS(712),
    [anon_sym_for] = ACTIONS(712),
    [anon_sym_number] = ACTIONS(712),
    [anon_sym_float] = ACTIONS(712),
    [anon_sym_float32] = ACTIONS(712),
    [anon_sym_float64] = ACTIONS(712),
    [anon_sym_uint] = ACTIONS(712),
    [anon_sym_uint8] = ACTIONS(712),
    [anon_sym_uint16] = ACTIONS(712),
    [anon_sym_uint32] = ACTIONS(712),
    [anon_sym_uint64] = ACTIONS(712),
    [anon_sym_uint128] = ACTIONS(712),
    [anon_sym_int] = ACTIONS(712),
    [anon_sym_int8] = ACTIONS(712),
    [anon_sym_int16] = ACTIONS(712),
    [anon_sym_int32] = ACTIONS(712),
    [anon_sym_int64] = ACTIONS(712),
    [anon_sym_int128] = ACTIONS(712),
    [anon_sym_string] = ACTIONS(712),
    [anon_sym_bytes] = ACTIONS(712),
    [anon_sym_bool] = ACTIONS(712),
    [anon_sym_AT] = ACTIONS(710),
    [anon_sym_DASH] = ACTIONS(712),
    [anon_sym_LBRACK] = ACTIONS(710),
    [anon_sym_RBRACK] = ACTIONS(710),
    [anon_sym_LBRACE] = ACTIONS(710),
    [anon_sym_RBRACE] = ACTIONS(710),
    [anon_sym_LT] = ACTIONS(712),
    [anon_sym_GT] = ACTIONS(712),
    [anon_sym_STAR] = ACTIONS(710),
    [anon_sym_len] = ACTIONS(712),
    [anon_sym_close] = ACTIONS(712),
    [anon_sym_and] = ACTIONS(712),
    [anon_sym_or] = ACTIONS(712),
    [anon_sym_div] = ACTIONS(712),
    [anon_sym_mod] = ACTIONS(712),
    [anon_sym_quo] = ACTIONS(712),
    [anon_sym_rem] = ACTIONS(712),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(710),
    [anon_sym_BANG] = ACTIONS(712),
    [anon_sym_PLUS] = ACTIONS(712),
    [anon_sym_SLASH] = ACTIONS(712),
    [anon_sym_PIPE] = ACTIONS(712),
    [anon_sym_AMP] = ACTIONS(712),
    [anon_sym_PIPE_PIPE] = ACTIONS(710),
    [anon_sym_AMP_AMP] = ACTIONS(710),
    [anon_sym_EQ_EQ] = ACTIONS(710),
    [anon_sym_EQ_TILDE] = ACTIONS(710),
    [anon_sym_BANG_TILDE] = ACTIONS(710),
    [anon_sym_BANG_EQ] = ACTIONS(710),
    [anon_sym_LT_EQ] = ACTIONS(710),
    [anon_sym_GT_EQ] = ACTIONS(710),
    [sym_bottom] = ACTIONS(710),
    [anon_sym_true] = ACTIONS(712),
    [anon_sym_false] = ACTIONS(712),
    [sym_null] = ACTIONS(712),
    [sym_number] = ACTIONS(712),
    [sym_float] = ACTIONS(712),
    [anon_sym_DQUOTE] = ACTIONS(712),
    [anon_sym_SQUOTE] = ACTIONS(712),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(710),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(710),
    [anon_sym_POUND_DQUOTE] = ACTIONS(712),
    [anon_sym_POUND_SQUOTE] = ACTIONS(712),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(710),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(710),
    [sym_comment] = ACTIONS(3),
  },
  [148] = {
    [ts_builtin_sym_end] = ACTIONS(714),
    [sym_identifier] = ACTIONS(716),
    [anon_sym_COMMA] = ACTIONS(714),
    [anon_sym_DOT] = ACTIONS(716),
    [anon_sym__] = ACTIONS(716),
    [anon_sym_LPAREN] = ACTIONS(714),
    [anon_sym_RPAREN] = ACTIONS(714),
    [anon_sym_let] = ACTIONS(716),
    [anon_sym_if] = ACTIONS(716),
    [anon_sym_for] = ACTIONS(716),
    [anon_sym_number] = ACTIONS(716),
    [anon_sym_float] = ACTIONS(716),
    [anon_sym_float32] = ACTIONS(716),
    [anon_sym_float64] = ACTIONS(716),
    [anon_sym_uint] = ACTIONS(716),
    [anon_sym_uint8] = ACTIONS(716),
    [anon_sym_uint16] = ACTIONS(716),
    [anon_sym_uint32] = ACTIONS(716),
    [anon_sym_uint64] = ACTIONS(716),
    [anon_sym_uint128] = ACTIONS(716),
    [anon_sym_int] = ACTIONS(716),
    [anon_sym_int8] = ACTIONS(716),
    [anon_sym_int16] = ACTIONS(716),
    [anon_sym_int32] = ACTIONS(716),
    [anon_sym_int64] = ACTIONS(716),
    [anon_sym_int128] = ACTIONS(716),
    [anon_sym_string] = ACTIONS(716),
    [anon_sym_bytes] = ACTIONS(716),
    [anon_sym_bool] = ACTIONS(716),
    [anon_sym_AT] = ACTIONS(714),
    [anon_sym_DASH] = ACTIONS(716),
    [anon_sym_LBRACK] = ACTIONS(714),
    [anon_sym_RBRACK] = ACTIONS(714),
    [anon_sym_LBRACE] = ACTIONS(714),
    [anon_sym_RBRACE] = ACTIONS(714),
    [anon_sym_LT] = ACTIONS(716),
    [anon_sym_GT] = ACTIONS(716),
    [anon_sym_STAR] = ACTIONS(714),
    [anon_sym_len] = ACTIONS(716),
    [anon_sym_close] = ACTIONS(716),
    [anon_sym_and] = ACTIONS(716),
    [anon_sym_or] = ACTIONS(716),
    [anon_sym_div] = ACTIONS(716),
    [anon_sym_mod] = ACTIONS(716),
    [anon_sym_quo] = ACTIONS(716),
    [anon_sym_rem] = ACTIONS(716),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(714),
    [anon_sym_BANG] = ACTIONS(716),
    [anon_sym_PLUS] = ACTIONS(716),
    [anon_sym_SLASH] = ACTIONS(716),
    [anon_sym_PIPE] = ACTIONS(716),
    [anon_sym_AMP] = ACTIONS(716),
    [anon_sym_PIPE_PIPE] = ACTIONS(714),
    [anon_sym_AMP_AMP] = ACTIONS(714),
    [anon_sym_EQ_EQ] = ACTIONS(714),
    [anon_sym_EQ_TILDE] = ACTIONS(714),
    [anon_sym_BANG_TILDE] = ACTIONS(714),
    [anon_sym_BANG_EQ] = ACTIONS(714),
    [anon_sym_LT_EQ] = ACTIONS(714),
    [anon_sym_GT_EQ] = ACTIONS(714),
    [sym_bottom] = ACTIONS(714),
    [anon_sym_true] = ACTIONS(716),
    [anon_sym_false] = ACTIONS(716),
    [sym_null] = ACTIONS(716),
    [sym_number] = ACTIONS(716),
    [sym_float] = ACTIONS(716),
    [anon_sym_DQUOTE] = ACTIONS(716),
    [anon_sym_SQUOTE] = ACTIONS(716),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(714),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(714),
    [anon_sym_POUND_DQUOTE] = ACTIONS(716),
    [anon_sym_POUND_SQUOTE] = ACTIONS(716),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(714),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(714),
    [sym_comment] = ACTIONS(3),
  },
  [149] = {
    [ts_builtin_sym_end] = ACTIONS(718),
    [sym_identifier] = ACTIONS(720),
    [anon_sym_COMMA] = ACTIONS(718),
    [anon_sym_DOT] = ACTIONS(720),
    [anon_sym__] = ACTIONS(720),
    [anon_sym_LPAREN] = ACTIONS(718),
    [anon_sym_RPAREN] = ACTIONS(718),
    [anon_sym_let] = ACTIONS(720),
    [anon_sym_if] = ACTIONS(720),
    [anon_sym_for] = ACTIONS(720),
    [anon_sym_number] = ACTIONS(720),
    [anon_sym_float] = ACTIONS(720),
    [anon_sym_float32] = ACTIONS(720),
    [anon_sym_float64] = ACTIONS(720),
    [anon_sym_uint] = ACTIONS(720),
    [anon_sym_uint8] = ACTIONS(720),
    [anon_sym_uint16] = ACTIONS(720),
    [anon_sym_uint32] = ACTIONS(720),
    [anon_sym_uint64] = ACTIONS(720),
    [anon_sym_uint128] = ACTIONS(720),
    [anon_sym_int] = ACTIONS(720),
    [anon_sym_int8] = ACTIONS(720),
    [anon_sym_int16] = ACTIONS(720),
    [anon_sym_int32] = ACTIONS(720),
    [anon_sym_int64] = ACTIONS(720),
    [anon_sym_int128] = ACTIONS(720),
    [anon_sym_string] = ACTIONS(720),
    [anon_sym_bytes] = ACTIONS(720),
    [anon_sym_bool] = ACTIONS(720),
    [anon_sym_AT] = ACTIONS(718),
    [anon_sym_DASH] = ACTIONS(720),
    [anon_sym_LBRACK] = ACTIONS(718),
    [anon_sym_RBRACK] = ACTIONS(718),
    [anon_sym_LBRACE] = ACTIONS(718),
    [anon_sym_RBRACE] = ACTIONS(718),
    [anon_sym_LT] = ACTIONS(720),
    [anon_sym_GT] = ACTIONS(720),
    [anon_sym_STAR] = ACTIONS(718),
    [anon_sym_len] = ACTIONS(720),
    [anon_sym_close] = ACTIONS(720),
    [anon_sym_and] = ACTIONS(720),
    [anon_sym_or] = ACTIONS(720),
    [anon_sym_div] = ACTIONS(720),
    [anon_sym_mod] = ACTIONS(720),
    [anon_sym_quo] = ACTIONS(720),
    [anon_sym_rem] = ACTIONS(720),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(718),
    [anon_sym_BANG] = ACTIONS(720),
    [anon_sym_PLUS] = ACTIONS(720),
    [anon_sym_SLASH] = ACTIONS(720),
    [anon_sym_PIPE] = ACTIONS(720),
    [anon_sym_AMP] = ACTIONS(720),
    [anon_sym_PIPE_PIPE] = ACTIONS(718),
    [anon_sym_AMP_AMP] = ACTIONS(718),
    [anon_sym_EQ_EQ] = ACTIONS(718),
    [anon_sym_EQ_TILDE] = ACTIONS(718),
    [anon_sym_BANG_TILDE] = ACTIONS(718),
    [anon_sym_BANG_EQ] = ACTIONS(718),
    [anon_sym_LT_EQ] = ACTIONS(718),
    [anon_sym_GT_EQ] = ACTIONS(718),
    [sym_bottom] = ACTIONS(718),
    [anon_sym_true] = ACTIONS(720),
    [anon_sym_false] = ACTIONS(720),
    [sym_null] = ACTIONS(720),
    [sym_number] = ACTIONS(720),
    [sym_float] = ACTIONS(720),
    [anon_sym_DQUOTE] = ACTIONS(720),
    [anon_sym_SQUOTE] = ACTIONS(720),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(718),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(718),
    [anon_sym_POUND_DQUOTE] = ACTIONS(720),
    [anon_sym_POUND_SQUOTE] = ACTIONS(720),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(718),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(718),
    [sym_comment] = ACTIONS(3),
  },
  [150] = {
    [ts_builtin_sym_end] = ACTIONS(722),
    [sym_identifier] = ACTIONS(724),
    [anon_sym_COMMA] = ACTIONS(722),
    [anon_sym_DOT] = ACTIONS(724),
    [anon_sym__] = ACTIONS(724),
    [anon_sym_LPAREN] = ACTIONS(722),
    [anon_sym_RPAREN] = ACTIONS(722),
    [anon_sym_let] = ACTIONS(724),
    [anon_sym_if] = ACTIONS(724),
    [anon_sym_for] = ACTIONS(724),
    [anon_sym_number] = ACTIONS(724),
    [anon_sym_float] = ACTIONS(724),
    [anon_sym_float32] = ACTIONS(724),
    [anon_sym_float64] = ACTIONS(724),
    [anon_sym_uint] = ACTIONS(724),
    [anon_sym_uint8] = ACTIONS(724),
    [anon_sym_uint16] = ACTIONS(724),
    [anon_sym_uint32] = ACTIONS(724),
    [anon_sym_uint64] = ACTIONS(724),
    [anon_sym_uint128] = ACTIONS(724),
    [anon_sym_int] = ACTIONS(724),
    [anon_sym_int8] = ACTIONS(724),
    [anon_sym_int16] = ACTIONS(724),
    [anon_sym_int32] = ACTIONS(724),
    [anon_sym_int64] = ACTIONS(724),
    [anon_sym_int128] = ACTIONS(724),
    [anon_sym_string] = ACTIONS(724),
    [anon_sym_bytes] = ACTIONS(724),
    [anon_sym_bool] = ACTIONS(724),
    [anon_sym_AT] = ACTIONS(722),
    [anon_sym_DASH] = ACTIONS(724),
    [anon_sym_LBRACK] = ACTIONS(722),
    [anon_sym_RBRACK] = ACTIONS(722),
    [anon_sym_LBRACE] = ACTIONS(722),
    [anon_sym_RBRACE] = ACTIONS(722),
    [anon_sym_LT] = ACTIONS(724),
    [anon_sym_GT] = ACTIONS(724),
    [anon_sym_STAR] = ACTIONS(722),
    [anon_sym_len] = ACTIONS(724),
    [anon_sym_close] = ACTIONS(724),
    [anon_sym_and] = ACTIONS(724),
    [anon_sym_or] = ACTIONS(724),
    [anon_sym_div] = ACTIONS(724),
    [anon_sym_mod] = ACTIONS(724),
    [anon_sym_quo] = ACTIONS(724),
    [anon_sym_rem] = ACTIONS(724),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(722),
    [anon_sym_BANG] = ACTIONS(724),
    [anon_sym_PLUS] = ACTIONS(724),
    [anon_sym_SLASH] = ACTIONS(724),
    [anon_sym_PIPE] = ACTIONS(724),
    [anon_sym_AMP] = ACTIONS(724),
    [anon_sym_PIPE_PIPE] = ACTIONS(722),
    [anon_sym_AMP_AMP] = ACTIONS(722),
    [anon_sym_EQ_EQ] = ACTIONS(722),
    [anon_sym_EQ_TILDE] = ACTIONS(722),
    [anon_sym_BANG_TILDE] = ACTIONS(722),
    [anon_sym_BANG_EQ] = ACTIONS(722),
    [anon_sym_LT_EQ] = ACTIONS(722),
    [anon_sym_GT_EQ] = ACTIONS(722),
    [sym_bottom] = ACTIONS(722),
    [anon_sym_true] = ACTIONS(724),
    [anon_sym_false] = ACTIONS(724),
    [sym_null] = ACTIONS(724),
    [sym_number] = ACTIONS(724),
    [sym_float] = ACTIONS(724),
    [anon_sym_DQUOTE] = ACTIONS(724),
    [anon_sym_SQUOTE] = ACTIONS(724),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(722),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(722),
    [anon_sym_POUND_DQUOTE] = ACTIONS(724),
    [anon_sym_POUND_SQUOTE] = ACTIONS(724),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(722),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(722),
    [sym_comment] = ACTIONS(3),
  },
  [151] = {
    [ts_builtin_sym_end] = ACTIONS(726),
    [sym_identifier] = ACTIONS(728),
    [anon_sym_COMMA] = ACTIONS(726),
    [anon_sym_DOT] = ACTIONS(728),
    [anon_sym__] = ACTIONS(728),
    [anon_sym_LPAREN] = ACTIONS(726),
    [anon_sym_RPAREN] = ACTIONS(726),
    [anon_sym_let] = ACTIONS(728),
    [anon_sym_if] = ACTIONS(728),
    [anon_sym_for] = ACTIONS(728),
    [anon_sym_number] = ACTIONS(728),
    [anon_sym_float] = ACTIONS(728),
    [anon_sym_float32] = ACTIONS(728),
    [anon_sym_float64] = ACTIONS(728),
    [anon_sym_uint] = ACTIONS(728),
    [anon_sym_uint8] = ACTIONS(728),
    [anon_sym_uint16] = ACTIONS(728),
    [anon_sym_uint32] = ACTIONS(728),
    [anon_sym_uint64] = ACTIONS(728),
    [anon_sym_uint128] = ACTIONS(728),
    [anon_sym_int] = ACTIONS(728),
    [anon_sym_int8] = ACTIONS(728),
    [anon_sym_int16] = ACTIONS(728),
    [anon_sym_int32] = ACTIONS(728),
    [anon_sym_int64] = ACTIONS(728),
    [anon_sym_int128] = ACTIONS(728),
    [anon_sym_string] = ACTIONS(728),
    [anon_sym_bytes] = ACTIONS(728),
    [anon_sym_bool] = ACTIONS(728),
    [anon_sym_AT] = ACTIONS(726),
    [anon_sym_DASH] = ACTIONS(728),
    [anon_sym_LBRACK] = ACTIONS(726),
    [anon_sym_RBRACK] = ACTIONS(726),
    [anon_sym_LBRACE] = ACTIONS(726),
    [anon_sym_RBRACE] = ACTIONS(726),
    [anon_sym_LT] = ACTIONS(728),
    [anon_sym_GT] = ACTIONS(728),
    [anon_sym_STAR] = ACTIONS(726),
    [anon_sym_len] = ACTIONS(728),
    [anon_sym_close] = ACTIONS(728),
    [anon_sym_and] = ACTIONS(728),
    [anon_sym_or] = ACTIONS(728),
    [anon_sym_div] = ACTIONS(728),
    [anon_sym_mod] = ACTIONS(728),
    [anon_sym_quo] = ACTIONS(728),
    [anon_sym_rem] = ACTIONS(728),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(726),
    [anon_sym_BANG] = ACTIONS(728),
    [anon_sym_PLUS] = ACTIONS(728),
    [anon_sym_SLASH] = ACTIONS(728),
    [anon_sym_PIPE] = ACTIONS(728),
    [anon_sym_AMP] = ACTIONS(728),
    [anon_sym_PIPE_PIPE] = ACTIONS(726),
    [anon_sym_AMP_AMP] = ACTIONS(726),
    [anon_sym_EQ_EQ] = ACTIONS(726),
    [anon_sym_EQ_TILDE] = ACTIONS(726),
    [anon_sym_BANG_TILDE] = ACTIONS(726),
    [anon_sym_BANG_EQ] = ACTIONS(726),
    [anon_sym_LT_EQ] = ACTIONS(726),
    [anon_sym_GT_EQ] = ACTIONS(726),
    [sym_bottom] = ACTIONS(726),
    [anon_sym_true] = ACTIONS(728),
    [anon_sym_false] = ACTIONS(728),
    [sym_null] = ACTIONS(728),
    [sym_number] = ACTIONS(728),
    [sym_float] = ACTIONS(728),
    [anon_sym_DQUOTE] = ACTIONS(728),
    [anon_sym_SQUOTE] = ACTIONS(728),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(726),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(726),
    [anon_sym_POUND_DQUOTE] = ACTIONS(728),
    [anon_sym_POUND_SQUOTE] = ACTIONS(728),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(726),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(726),
    [sym_comment] = ACTIONS(3),
  },
  [152] = {
    [ts_builtin_sym_end] = ACTIONS(730),
    [sym_identifier] = ACTIONS(732),
    [anon_sym_COMMA] = ACTIONS(730),
    [anon_sym_DOT] = ACTIONS(732),
    [anon_sym__] = ACTIONS(732),
    [anon_sym_LPAREN] = ACTIONS(730),
    [anon_sym_let] = ACTIONS(732),
    [anon_sym_if] = ACTIONS(732),
    [anon_sym_for] = ACTIONS(732),
    [anon_sym_number] = ACTIONS(732),
    [anon_sym_float] = ACTIONS(732),
    [anon_sym_float32] = ACTIONS(732),
    [anon_sym_float64] = ACTIONS(732),
    [anon_sym_uint] = ACTIONS(732),
    [anon_sym_uint8] = ACTIONS(732),
    [anon_sym_uint16] = ACTIONS(732),
    [anon_sym_uint32] = ACTIONS(732),
    [anon_sym_uint64] = ACTIONS(732),
    [anon_sym_uint128] = ACTIONS(732),
    [anon_sym_int] = ACTIONS(732),
    [anon_sym_int8] = ACTIONS(732),
    [anon_sym_int16] = ACTIONS(732),
    [anon_sym_int32] = ACTIONS(732),
    [anon_sym_int64] = ACTIONS(732),
    [anon_sym_int128] = ACTIONS(732),
    [anon_sym_string] = ACTIONS(732),
    [anon_sym_bytes] = ACTIONS(732),
    [anon_sym_bool] = ACTIONS(732),
    [anon_sym_AT] = ACTIONS(730),
    [anon_sym_DASH] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(730),
    [anon_sym_RBRACK] = ACTIONS(730),
    [anon_sym_LBRACE] = ACTIONS(730),
    [anon_sym_RBRACE] = ACTIONS(730),
    [anon_sym_LT] = ACTIONS(732),
    [anon_sym_GT] = ACTIONS(732),
    [anon_sym_STAR] = ACTIONS(730),
    [anon_sym_len] = ACTIONS(732),
    [anon_sym_close] = ACTIONS(732),
    [anon_sym_and] = ACTIONS(732),
    [anon_sym_or] = ACTIONS(732),
    [anon_sym_div] = ACTIONS(732),
    [anon_sym_mod] = ACTIONS(732),
    [anon_sym_quo] = ACTIONS(732),
    [anon_sym_rem] = ACTIONS(732),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(730),
    [anon_sym_BANG] = ACTIONS(732),
    [anon_sym_PLUS] = ACTIONS(732),
    [anon_sym_SLASH] = ACTIONS(732),
    [anon_sym_PIPE] = ACTIONS(732),
    [anon_sym_AMP] = ACTIONS(732),
    [anon_sym_PIPE_PIPE] = ACTIONS(730),
    [anon_sym_AMP_AMP] = ACTIONS(730),
    [anon_sym_EQ_EQ] = ACTIONS(730),
    [anon_sym_EQ_TILDE] = ACTIONS(730),
    [anon_sym_BANG_TILDE] = ACTIONS(730),
    [anon_sym_BANG_EQ] = ACTIONS(730),
    [anon_sym_LT_EQ] = ACTIONS(730),
    [anon_sym_GT_EQ] = ACTIONS(730),
    [sym_bottom] = ACTIONS(730),
    [anon_sym_true] = ACTIONS(732),
    [anon_sym_false] = ACTIONS(732),
    [sym_null] = ACTIONS(732),
    [sym_number] = ACTIONS(732),
    [sym_float] = ACTIONS(732),
    [anon_sym_DQUOTE] = ACTIONS(732),
    [anon_sym_SQUOTE] = ACTIONS(732),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(730),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(730),
    [anon_sym_POUND_DQUOTE] = ACTIONS(732),
    [anon_sym_POUND_SQUOTE] = ACTIONS(732),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(730),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(730),
    [sym_comment] = ACTIONS(3),
  },
  [153] = {
    [ts_builtin_sym_end] = ACTIONS(734),
    [sym_identifier] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym_DOT] = ACTIONS(736),
    [anon_sym__] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(734),
    [anon_sym_let] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_number] = ACTIONS(736),
    [anon_sym_float] = ACTIONS(736),
    [anon_sym_float32] = ACTIONS(736),
    [anon_sym_float64] = ACTIONS(736),
    [anon_sym_uint] = ACTIONS(736),
    [anon_sym_uint8] = ACTIONS(736),
    [anon_sym_uint16] = ACTIONS(736),
    [anon_sym_uint32] = ACTIONS(736),
    [anon_sym_uint64] = ACTIONS(736),
    [anon_sym_uint128] = ACTIONS(736),
    [anon_sym_int] = ACTIONS(736),
    [anon_sym_int8] = ACTIONS(736),
    [anon_sym_int16] = ACTIONS(736),
    [anon_sym_int32] = ACTIONS(736),
    [anon_sym_int64] = ACTIONS(736),
    [anon_sym_int128] = ACTIONS(736),
    [anon_sym_string] = ACTIONS(736),
    [anon_sym_bytes] = ACTIONS(736),
    [anon_sym_bool] = ACTIONS(736),
    [anon_sym_AT] = ACTIONS(734),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_RBRACE] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_len] = ACTIONS(736),
    [anon_sym_close] = ACTIONS(736),
    [anon_sym_and] = ACTIONS(736),
    [anon_sym_or] = ACTIONS(736),
    [anon_sym_div] = ACTIONS(736),
    [anon_sym_mod] = ACTIONS(736),
    [anon_sym_quo] = ACTIONS(736),
    [anon_sym_rem] = ACTIONS(736),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_SLASH] = ACTIONS(736),
    [anon_sym_PIPE] = ACTIONS(736),
    [anon_sym_AMP] = ACTIONS(736),
    [anon_sym_PIPE_PIPE] = ACTIONS(734),
    [anon_sym_AMP_AMP] = ACTIONS(734),
    [anon_sym_EQ_EQ] = ACTIONS(734),
    [anon_sym_EQ_TILDE] = ACTIONS(734),
    [anon_sym_BANG_TILDE] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [sym_bottom] = ACTIONS(734),
    [anon_sym_true] = ACTIONS(736),
    [anon_sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_number] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(734),
    [anon_sym_POUND_DQUOTE] = ACTIONS(736),
    [anon_sym_POUND_SQUOTE] = ACTIONS(736),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(734),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(734),
    [sym_comment] = ACTIONS(3),
  },
  [154] = {
    [ts_builtin_sym_end] = ACTIONS(738),
    [sym_identifier] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_let] = ACTIONS(740),
    [anon_sym_if] = ACTIONS(740),
    [anon_sym_for] = ACTIONS(740),
    [anon_sym_number] = ACTIONS(740),
    [anon_sym_float] = ACTIONS(740),
    [anon_sym_float32] = ACTIONS(740),
    [anon_sym_float64] = ACTIONS(740),
    [anon_sym_uint] = ACTIONS(740),
    [anon_sym_uint8] = ACTIONS(740),
    [anon_sym_uint16] = ACTIONS(740),
    [anon_sym_uint32] = ACTIONS(740),
    [anon_sym_uint64] = ACTIONS(740),
    [anon_sym_uint128] = ACTIONS(740),
    [anon_sym_int] = ACTIONS(740),
    [anon_sym_int8] = ACTIONS(740),
    [anon_sym_int16] = ACTIONS(740),
    [anon_sym_int32] = ACTIONS(740),
    [anon_sym_int64] = ACTIONS(740),
    [anon_sym_int128] = ACTIONS(740),
    [anon_sym_string] = ACTIONS(740),
    [anon_sym_bytes] = ACTIONS(740),
    [anon_sym_bool] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_LBRACK] = ACTIONS(738),
    [anon_sym_RBRACK] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_LT] = ACTIONS(740),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_len] = ACTIONS(740),
    [anon_sym_close] = ACTIONS(740),
    [anon_sym_and] = ACTIONS(740),
    [anon_sym_or] = ACTIONS(740),
    [anon_sym_div] = ACTIONS(740),
    [anon_sym_mod] = ACTIONS(740),
    [anon_sym_quo] = ACTIONS(740),
    [anon_sym_rem] = ACTIONS(740),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(740),
    [anon_sym_PIPE_PIPE] = ACTIONS(738),
    [anon_sym_AMP_AMP] = ACTIONS(738),
    [anon_sym_EQ_EQ] = ACTIONS(738),
    [anon_sym_EQ_TILDE] = ACTIONS(738),
    [anon_sym_BANG_TILDE] = ACTIONS(738),
    [anon_sym_BANG_EQ] = ACTIONS(738),
    [anon_sym_LT_EQ] = ACTIONS(738),
    [anon_sym_GT_EQ] = ACTIONS(738),
    [sym_bottom] = ACTIONS(738),
    [anon_sym_true] = ACTIONS(740),
    [anon_sym_false] = ACTIONS(740),
    [sym_null] = ACTIONS(740),
    [sym_number] = ACTIONS(740),
    [sym_float] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(738),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(738),
    [anon_sym_POUND_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND_SQUOTE] = ACTIONS(740),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(738),
    [sym_comment] = ACTIONS(3),
  },
  [155] = {
    [ts_builtin_sym_end] = ACTIONS(742),
    [sym_identifier] = ACTIONS(744),
    [anon_sym_COMMA] = ACTIONS(742),
    [anon_sym_DOT] = ACTIONS(744),
    [anon_sym__] = ACTIONS(744),
    [anon_sym_LPAREN] = ACTIONS(742),
    [anon_sym_let] = ACTIONS(744),
    [anon_sym_if] = ACTIONS(744),
    [anon_sym_for] = ACTIONS(744),
    [anon_sym_number] = ACTIONS(744),
    [anon_sym_float] = ACTIONS(744),
    [anon_sym_float32] = ACTIONS(744),
    [anon_sym_float64] = ACTIONS(744),
    [anon_sym_uint] = ACTIONS(744),
    [anon_sym_uint8] = ACTIONS(744),
    [anon_sym_uint16] = ACTIONS(744),
    [anon_sym_uint32] = ACTIONS(744),
    [anon_sym_uint64] = ACTIONS(744),
    [anon_sym_uint128] = ACTIONS(744),
    [anon_sym_int] = ACTIONS(744),
    [anon_sym_int8] = ACTIONS(744),
    [anon_sym_int16] = ACTIONS(744),
    [anon_sym_int32] = ACTIONS(744),
    [anon_sym_int64] = ACTIONS(744),
    [anon_sym_int128] = ACTIONS(744),
    [anon_sym_string] = ACTIONS(744),
    [anon_sym_bytes] = ACTIONS(744),
    [anon_sym_bool] = ACTIONS(744),
    [anon_sym_AT] = ACTIONS(742),
    [anon_sym_DASH] = ACTIONS(744),
    [anon_sym_LBRACK] = ACTIONS(742),
    [anon_sym_RBRACK] = ACTIONS(742),
    [anon_sym_LBRACE] = ACTIONS(742),
    [anon_sym_RBRACE] = ACTIONS(742),
    [anon_sym_LT] = ACTIONS(744),
    [anon_sym_GT] = ACTIONS(744),
    [anon_sym_STAR] = ACTIONS(742),
    [anon_sym_len] = ACTIONS(744),
    [anon_sym_close] = ACTIONS(744),
    [anon_sym_and] = ACTIONS(744),
    [anon_sym_or] = ACTIONS(744),
    [anon_sym_div] = ACTIONS(744),
    [anon_sym_mod] = ACTIONS(744),
    [anon_sym_quo] = ACTIONS(744),
    [anon_sym_rem] = ACTIONS(744),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(742),
    [anon_sym_BANG] = ACTIONS(744),
    [anon_sym_PLUS] = ACTIONS(744),
    [anon_sym_SLASH] = ACTIONS(744),
    [anon_sym_PIPE] = ACTIONS(744),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_PIPE_PIPE] = ACTIONS(742),
    [anon_sym_AMP_AMP] = ACTIONS(742),
    [anon_sym_EQ_EQ] = ACTIONS(742),
    [anon_sym_EQ_TILDE] = ACTIONS(742),
    [anon_sym_BANG_TILDE] = ACTIONS(742),
    [anon_sym_BANG_EQ] = ACTIONS(742),
    [anon_sym_LT_EQ] = ACTIONS(742),
    [anon_sym_GT_EQ] = ACTIONS(742),
    [sym_bottom] = ACTIONS(742),
    [anon_sym_true] = ACTIONS(744),
    [anon_sym_false] = ACTIONS(744),
    [sym_null] = ACTIONS(744),
    [sym_number] = ACTIONS(744),
    [sym_float] = ACTIONS(744),
    [anon_sym_DQUOTE] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(744),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(742),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(742),
    [anon_sym_POUND_DQUOTE] = ACTIONS(744),
    [anon_sym_POUND_SQUOTE] = ACTIONS(744),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(742),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(742),
    [sym_comment] = ACTIONS(3),
  },
  [156] = {
    [ts_builtin_sym_end] = ACTIONS(746),
    [sym_identifier] = ACTIONS(748),
    [anon_sym_COMMA] = ACTIONS(746),
    [anon_sym_DOT] = ACTIONS(748),
    [anon_sym__] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(746),
    [anon_sym_let] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_number] = ACTIONS(748),
    [anon_sym_float] = ACTIONS(748),
    [anon_sym_float32] = ACTIONS(748),
    [anon_sym_float64] = ACTIONS(748),
    [anon_sym_uint] = ACTIONS(748),
    [anon_sym_uint8] = ACTIONS(748),
    [anon_sym_uint16] = ACTIONS(748),
    [anon_sym_uint32] = ACTIONS(748),
    [anon_sym_uint64] = ACTIONS(748),
    [anon_sym_uint128] = ACTIONS(748),
    [anon_sym_int] = ACTIONS(748),
    [anon_sym_int8] = ACTIONS(748),
    [anon_sym_int16] = ACTIONS(748),
    [anon_sym_int32] = ACTIONS(748),
    [anon_sym_int64] = ACTIONS(748),
    [anon_sym_int128] = ACTIONS(748),
    [anon_sym_string] = ACTIONS(748),
    [anon_sym_bytes] = ACTIONS(748),
    [anon_sym_bool] = ACTIONS(748),
    [anon_sym_AT] = ACTIONS(746),
    [anon_sym_DASH] = ACTIONS(748),
    [anon_sym_LBRACK] = ACTIONS(746),
    [anon_sym_RBRACK] = ACTIONS(746),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_RBRACE] = ACTIONS(746),
    [anon_sym_LT] = ACTIONS(748),
    [anon_sym_GT] = ACTIONS(748),
    [anon_sym_STAR] = ACTIONS(746),
    [anon_sym_len] = ACTIONS(748),
    [anon_sym_close] = ACTIONS(748),
    [anon_sym_and] = ACTIONS(748),
    [anon_sym_or] = ACTIONS(748),
    [anon_sym_div] = ACTIONS(748),
    [anon_sym_mod] = ACTIONS(748),
    [anon_sym_quo] = ACTIONS(748),
    [anon_sym_rem] = ACTIONS(748),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(746),
    [anon_sym_BANG] = ACTIONS(748),
    [anon_sym_PLUS] = ACTIONS(748),
    [anon_sym_SLASH] = ACTIONS(748),
    [anon_sym_PIPE] = ACTIONS(748),
    [anon_sym_AMP] = ACTIONS(748),
    [anon_sym_PIPE_PIPE] = ACTIONS(746),
    [anon_sym_AMP_AMP] = ACTIONS(746),
    [anon_sym_EQ_EQ] = ACTIONS(746),
    [anon_sym_EQ_TILDE] = ACTIONS(746),
    [anon_sym_BANG_TILDE] = ACTIONS(746),
    [anon_sym_BANG_EQ] = ACTIONS(746),
    [anon_sym_LT_EQ] = ACTIONS(746),
    [anon_sym_GT_EQ] = ACTIONS(746),
    [sym_bottom] = ACTIONS(746),
    [anon_sym_true] = ACTIONS(748),
    [anon_sym_false] = ACTIONS(748),
    [sym_null] = ACTIONS(748),
    [sym_number] = ACTIONS(748),
    [sym_float] = ACTIONS(748),
    [anon_sym_DQUOTE] = ACTIONS(748),
    [anon_sym_SQUOTE] = ACTIONS(748),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(746),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(746),
    [anon_sym_POUND_DQUOTE] = ACTIONS(748),
    [anon_sym_POUND_SQUOTE] = ACTIONS(748),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(746),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(746),
    [sym_comment] = ACTIONS(3),
  },
  [157] = {
    [ts_builtin_sym_end] = ACTIONS(750),
    [sym_identifier] = ACTIONS(752),
    [anon_sym_COMMA] = ACTIONS(750),
    [anon_sym_DOT] = ACTIONS(752),
    [anon_sym__] = ACTIONS(752),
    [anon_sym_LPAREN] = ACTIONS(750),
    [anon_sym_let] = ACTIONS(752),
    [anon_sym_if] = ACTIONS(752),
    [anon_sym_for] = ACTIONS(752),
    [anon_sym_number] = ACTIONS(752),
    [anon_sym_float] = ACTIONS(752),
    [anon_sym_float32] = ACTIONS(752),
    [anon_sym_float64] = ACTIONS(752),
    [anon_sym_uint] = ACTIONS(752),
    [anon_sym_uint8] = ACTIONS(752),
    [anon_sym_uint16] = ACTIONS(752),
    [anon_sym_uint32] = ACTIONS(752),
    [anon_sym_uint64] = ACTIONS(752),
    [anon_sym_uint128] = ACTIONS(752),
    [anon_sym_int] = ACTIONS(752),
    [anon_sym_int8] = ACTIONS(752),
    [anon_sym_int16] = ACTIONS(752),
    [anon_sym_int32] = ACTIONS(752),
    [anon_sym_int64] = ACTIONS(752),
    [anon_sym_int128] = ACTIONS(752),
    [anon_sym_string] = ACTIONS(752),
    [anon_sym_bytes] = ACTIONS(752),
    [anon_sym_bool] = ACTIONS(752),
    [anon_sym_AT] = ACTIONS(750),
    [anon_sym_DASH] = ACTIONS(752),
    [anon_sym_LBRACK] = ACTIONS(750),
    [anon_sym_RBRACK] = ACTIONS(750),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_RBRACE] = ACTIONS(750),
    [anon_sym_LT] = ACTIONS(752),
    [anon_sym_GT] = ACTIONS(752),
    [anon_sym_STAR] = ACTIONS(750),
    [anon_sym_len] = ACTIONS(752),
    [anon_sym_close] = ACTIONS(752),
    [anon_sym_and] = ACTIONS(752),
    [anon_sym_or] = ACTIONS(752),
    [anon_sym_div] = ACTIONS(752),
    [anon_sym_mod] = ACTIONS(752),
    [anon_sym_quo] = ACTIONS(752),
    [anon_sym_rem] = ACTIONS(752),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(750),
    [anon_sym_BANG] = ACTIONS(752),
    [anon_sym_PLUS] = ACTIONS(752),
    [anon_sym_SLASH] = ACTIONS(752),
    [anon_sym_PIPE] = ACTIONS(752),
    [anon_sym_AMP] = ACTIONS(752),
    [anon_sym_PIPE_PIPE] = ACTIONS(750),
    [anon_sym_AMP_AMP] = ACTIONS(750),
    [anon_sym_EQ_EQ] = ACTIONS(750),
    [anon_sym_EQ_TILDE] = ACTIONS(750),
    [anon_sym_BANG_TILDE] = ACTIONS(750),
    [anon_sym_BANG_EQ] = ACTIONS(750),
    [anon_sym_LT_EQ] = ACTIONS(750),
    [anon_sym_GT_EQ] = ACTIONS(750),
    [sym_bottom] = ACTIONS(750),
    [anon_sym_true] = ACTIONS(752),
    [anon_sym_false] = ACTIONS(752),
    [sym_null] = ACTIONS(752),
    [sym_number] = ACTIONS(752),
    [sym_float] = ACTIONS(752),
    [anon_sym_DQUOTE] = ACTIONS(752),
    [anon_sym_SQUOTE] = ACTIONS(752),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(750),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(750),
    [anon_sym_POUND_DQUOTE] = ACTIONS(752),
    [anon_sym_POUND_SQUOTE] = ACTIONS(752),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(750),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(750),
    [sym_comment] = ACTIONS(3),
  },
  [158] = {
    [ts_builtin_sym_end] = ACTIONS(754),
    [sym_identifier] = ACTIONS(756),
    [anon_sym_COMMA] = ACTIONS(754),
    [anon_sym_DOT] = ACTIONS(756),
    [anon_sym__] = ACTIONS(756),
    [anon_sym_LPAREN] = ACTIONS(754),
    [anon_sym_let] = ACTIONS(756),
    [anon_sym_if] = ACTIONS(756),
    [anon_sym_for] = ACTIONS(756),
    [anon_sym_number] = ACTIONS(756),
    [anon_sym_float] = ACTIONS(756),
    [anon_sym_float32] = ACTIONS(756),
    [anon_sym_float64] = ACTIONS(756),
    [anon_sym_uint] = ACTIONS(756),
    [anon_sym_uint8] = ACTIONS(756),
    [anon_sym_uint16] = ACTIONS(756),
    [anon_sym_uint32] = ACTIONS(756),
    [anon_sym_uint64] = ACTIONS(756),
    [anon_sym_uint128] = ACTIONS(756),
    [anon_sym_int] = ACTIONS(756),
    [anon_sym_int8] = ACTIONS(756),
    [anon_sym_int16] = ACTIONS(756),
    [anon_sym_int32] = ACTIONS(756),
    [anon_sym_int64] = ACTIONS(756),
    [anon_sym_int128] = ACTIONS(756),
    [anon_sym_string] = ACTIONS(756),
    [anon_sym_bytes] = ACTIONS(756),
    [anon_sym_bool] = ACTIONS(756),
    [anon_sym_AT] = ACTIONS(754),
    [anon_sym_DASH] = ACTIONS(756),
    [anon_sym_LBRACK] = ACTIONS(754),
    [anon_sym_RBRACK] = ACTIONS(754),
    [anon_sym_LBRACE] = ACTIONS(754),
    [anon_sym_RBRACE] = ACTIONS(754),
    [anon_sym_LT] = ACTIONS(756),
    [anon_sym_GT] = ACTIONS(756),
    [anon_sym_STAR] = ACTIONS(754),
    [anon_sym_len] = ACTIONS(756),
    [anon_sym_close] = ACTIONS(756),
    [anon_sym_and] = ACTIONS(756),
    [anon_sym_or] = ACTIONS(756),
    [anon_sym_div] = ACTIONS(756),
    [anon_sym_mod] = ACTIONS(756),
    [anon_sym_quo] = ACTIONS(756),
    [anon_sym_rem] = ACTIONS(756),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(754),
    [anon_sym_BANG] = ACTIONS(756),
    [anon_sym_PLUS] = ACTIONS(756),
    [anon_sym_SLASH] = ACTIONS(756),
    [anon_sym_PIPE] = ACTIONS(756),
    [anon_sym_AMP] = ACTIONS(756),
    [anon_sym_PIPE_PIPE] = ACTIONS(754),
    [anon_sym_AMP_AMP] = ACTIONS(754),
    [anon_sym_EQ_EQ] = ACTIONS(754),
    [anon_sym_EQ_TILDE] = ACTIONS(754),
    [anon_sym_BANG_TILDE] = ACTIONS(754),
    [anon_sym_BANG_EQ] = ACTIONS(754),
    [anon_sym_LT_EQ] = ACTIONS(754),
    [anon_sym_GT_EQ] = ACTIONS(754),
    [sym_bottom] = ACTIONS(754),
    [anon_sym_true] = ACTIONS(756),
    [anon_sym_false] = ACTIONS(756),
    [sym_null] = ACTIONS(756),
    [sym_number] = ACTIONS(756),
    [sym_float] = ACTIONS(756),
    [anon_sym_DQUOTE] = ACTIONS(756),
    [anon_sym_SQUOTE] = ACTIONS(756),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(754),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(754),
    [anon_sym_POUND_DQUOTE] = ACTIONS(756),
    [anon_sym_POUND_SQUOTE] = ACTIONS(756),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(754),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(754),
    [sym_comment] = ACTIONS(3),
  },
  [159] = {
    [ts_builtin_sym_end] = ACTIONS(758),
    [sym_identifier] = ACTIONS(760),
    [anon_sym_COMMA] = ACTIONS(758),
    [anon_sym_DOT] = ACTIONS(762),
    [anon_sym__] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_let] = ACTIONS(760),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_for] = ACTIONS(760),
    [anon_sym_number] = ACTIONS(760),
    [anon_sym_float] = ACTIONS(760),
    [anon_sym_float32] = ACTIONS(760),
    [anon_sym_float64] = ACTIONS(760),
    [anon_sym_uint] = ACTIONS(760),
    [anon_sym_uint8] = ACTIONS(760),
    [anon_sym_uint16] = ACTIONS(760),
    [anon_sym_uint32] = ACTIONS(760),
    [anon_sym_uint64] = ACTIONS(760),
    [anon_sym_uint128] = ACTIONS(760),
    [anon_sym_int] = ACTIONS(760),
    [anon_sym_int8] = ACTIONS(760),
    [anon_sym_int16] = ACTIONS(760),
    [anon_sym_int32] = ACTIONS(760),
    [anon_sym_int64] = ACTIONS(760),
    [anon_sym_int128] = ACTIONS(760),
    [anon_sym_string] = ACTIONS(760),
    [anon_sym_bytes] = ACTIONS(760),
    [anon_sym_bool] = ACTIONS(760),
    [anon_sym_AT] = ACTIONS(758),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_LBRACK] = ACTIONS(758),
    [anon_sym_RBRACK] = ACTIONS(758),
    [anon_sym_LBRACE] = ACTIONS(758),
    [anon_sym_RBRACE] = ACTIONS(758),
    [anon_sym_LT] = ACTIONS(760),
    [anon_sym_GT] = ACTIONS(760),
    [anon_sym_STAR] = ACTIONS(758),
    [anon_sym_len] = ACTIONS(760),
    [anon_sym_close] = ACTIONS(760),
    [anon_sym_and] = ACTIONS(760),
    [anon_sym_or] = ACTIONS(760),
    [anon_sym_div] = ACTIONS(760),
    [anon_sym_mod] = ACTIONS(760),
    [anon_sym_quo] = ACTIONS(760),
    [anon_sym_rem] = ACTIONS(760),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(758),
    [anon_sym_BANG] = ACTIONS(760),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_SLASH] = ACTIONS(760),
    [anon_sym_PIPE] = ACTIONS(760),
    [anon_sym_AMP] = ACTIONS(760),
    [anon_sym_PIPE_PIPE] = ACTIONS(758),
    [anon_sym_AMP_AMP] = ACTIONS(758),
    [anon_sym_EQ_EQ] = ACTIONS(758),
    [anon_sym_EQ_TILDE] = ACTIONS(758),
    [anon_sym_BANG_TILDE] = ACTIONS(758),
    [anon_sym_BANG_EQ] = ACTIONS(758),
    [anon_sym_LT_EQ] = ACTIONS(758),
    [anon_sym_GT_EQ] = ACTIONS(758),
    [sym_bottom] = ACTIONS(758),
    [anon_sym_true] = ACTIONS(760),
    [anon_sym_false] = ACTIONS(760),
    [sym_null] = ACTIONS(760),
    [sym_number] = ACTIONS(760),
    [sym_float] = ACTIONS(760),
    [anon_sym_DQUOTE] = ACTIONS(760),
    [anon_sym_SQUOTE] = ACTIONS(760),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(758),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(758),
    [anon_sym_POUND_DQUOTE] = ACTIONS(760),
    [anon_sym_POUND_SQUOTE] = ACTIONS(760),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(758),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(758),
    [sym_comment] = ACTIONS(3),
  },
  [160] = {
    [ts_builtin_sym_end] = ACTIONS(636),
    [sym_identifier] = ACTIONS(638),
    [anon_sym_COMMA] = ACTIONS(636),
    [anon_sym_DOT] = ACTIONS(638),
    [anon_sym__] = ACTIONS(638),
    [anon_sym_LPAREN] = ACTIONS(636),
    [anon_sym_let] = ACTIONS(638),
    [anon_sym_if] = ACTIONS(638),
    [anon_sym_for] = ACTIONS(638),
    [anon_sym_number] = ACTIONS(638),
    [anon_sym_float] = ACTIONS(638),
    [anon_sym_float32] = ACTIONS(638),
    [anon_sym_float64] = ACTIONS(638),
    [anon_sym_uint] = ACTIONS(638),
    [anon_sym_uint8] = ACTIONS(638),
    [anon_sym_uint16] = ACTIONS(638),
    [anon_sym_uint32] = ACTIONS(638),
    [anon_sym_uint64] = ACTIONS(638),
    [anon_sym_uint128] = ACTIONS(638),
    [anon_sym_int] = ACTIONS(638),
    [anon_sym_int8] = ACTIONS(638),
    [anon_sym_int16] = ACTIONS(638),
    [anon_sym_int32] = ACTIONS(638),
    [anon_sym_int64] = ACTIONS(638),
    [anon_sym_int128] = ACTIONS(638),
    [anon_sym_string] = ACTIONS(638),
    [anon_sym_bytes] = ACTIONS(638),
    [anon_sym_bool] = ACTIONS(638),
    [anon_sym_AT] = ACTIONS(636),
    [anon_sym_DASH] = ACTIONS(638),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_RBRACK] = ACTIONS(636),
    [anon_sym_LBRACE] = ACTIONS(636),
    [anon_sym_RBRACE] = ACTIONS(636),
    [anon_sym_LT] = ACTIONS(638),
    [anon_sym_GT] = ACTIONS(638),
    [anon_sym_STAR] = ACTIONS(636),
    [anon_sym_len] = ACTIONS(638),
    [anon_sym_close] = ACTIONS(638),
    [anon_sym_and] = ACTIONS(638),
    [anon_sym_or] = ACTIONS(638),
    [anon_sym_div] = ACTIONS(638),
    [anon_sym_mod] = ACTIONS(638),
    [anon_sym_quo] = ACTIONS(638),
    [anon_sym_rem] = ACTIONS(638),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(636),
    [anon_sym_BANG] = ACTIONS(638),
    [anon_sym_PLUS] = ACTIONS(638),
    [anon_sym_SLASH] = ACTIONS(638),
    [anon_sym_PIPE] = ACTIONS(638),
    [anon_sym_AMP] = ACTIONS(638),
    [anon_sym_PIPE_PIPE] = ACTIONS(636),
    [anon_sym_AMP_AMP] = ACTIONS(636),
    [anon_sym_EQ_EQ] = ACTIONS(636),
    [anon_sym_EQ_TILDE] = ACTIONS(636),
    [anon_sym_BANG_TILDE] = ACTIONS(636),
    [anon_sym_BANG_EQ] = ACTIONS(636),
    [anon_sym_LT_EQ] = ACTIONS(636),
    [anon_sym_GT_EQ] = ACTIONS(636),
    [sym_bottom] = ACTIONS(636),
    [anon_sym_true] = ACTIONS(638),
    [anon_sym_false] = ACTIONS(638),
    [sym_null] = ACTIONS(638),
    [sym_number] = ACTIONS(638),
    [sym_float] = ACTIONS(638),
    [anon_sym_DQUOTE] = ACTIONS(638),
    [anon_sym_SQUOTE] = ACTIONS(638),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(636),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(636),
    [anon_sym_POUND_DQUOTE] = ACTIONS(638),
    [anon_sym_POUND_SQUOTE] = ACTIONS(638),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(636),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(636),
    [sym_comment] = ACTIONS(3),
  },
  [161] = {
    [ts_builtin_sym_end] = ACTIONS(764),
    [sym_identifier] = ACTIONS(766),
    [anon_sym_COMMA] = ACTIONS(764),
    [anon_sym_DOT] = ACTIONS(766),
    [anon_sym__] = ACTIONS(766),
    [anon_sym_LPAREN] = ACTIONS(764),
    [anon_sym_let] = ACTIONS(766),
    [anon_sym_if] = ACTIONS(766),
    [anon_sym_for] = ACTIONS(766),
    [anon_sym_number] = ACTIONS(766),
    [anon_sym_float] = ACTIONS(766),
    [anon_sym_float32] = ACTIONS(766),
    [anon_sym_float64] = ACTIONS(766),
    [anon_sym_uint] = ACTIONS(766),
    [anon_sym_uint8] = ACTIONS(766),
    [anon_sym_uint16] = ACTIONS(766),
    [anon_sym_uint32] = ACTIONS(766),
    [anon_sym_uint64] = ACTIONS(766),
    [anon_sym_uint128] = ACTIONS(766),
    [anon_sym_int] = ACTIONS(766),
    [anon_sym_int8] = ACTIONS(766),
    [anon_sym_int16] = ACTIONS(766),
    [anon_sym_int32] = ACTIONS(766),
    [anon_sym_int64] = ACTIONS(766),
    [anon_sym_int128] = ACTIONS(766),
    [anon_sym_string] = ACTIONS(766),
    [anon_sym_bytes] = ACTIONS(766),
    [anon_sym_bool] = ACTIONS(766),
    [anon_sym_AT] = ACTIONS(764),
    [anon_sym_DASH] = ACTIONS(766),
    [anon_sym_LBRACK] = ACTIONS(764),
    [anon_sym_RBRACK] = ACTIONS(764),
    [anon_sym_LBRACE] = ACTIONS(764),
    [anon_sym_RBRACE] = ACTIONS(764),
    [anon_sym_LT] = ACTIONS(766),
    [anon_sym_GT] = ACTIONS(766),
    [anon_sym_STAR] = ACTIONS(764),
    [anon_sym_len] = ACTIONS(766),
    [anon_sym_close] = ACTIONS(766),
    [anon_sym_and] = ACTIONS(766),
    [anon_sym_or] = ACTIONS(766),
    [anon_sym_div] = ACTIONS(766),
    [anon_sym_mod] = ACTIONS(766),
    [anon_sym_quo] = ACTIONS(766),
    [anon_sym_rem] = ACTIONS(766),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(764),
    [anon_sym_BANG] = ACTIONS(766),
    [anon_sym_PLUS] = ACTIONS(766),
    [anon_sym_SLASH] = ACTIONS(766),
    [anon_sym_PIPE] = ACTIONS(766),
    [anon_sym_AMP] = ACTIONS(766),
    [anon_sym_PIPE_PIPE] = ACTIONS(764),
    [anon_sym_AMP_AMP] = ACTIONS(764),
    [anon_sym_EQ_EQ] = ACTIONS(764),
    [anon_sym_EQ_TILDE] = ACTIONS(764),
    [anon_sym_BANG_TILDE] = ACTIONS(764),
    [anon_sym_BANG_EQ] = ACTIONS(764),
    [anon_sym_LT_EQ] = ACTIONS(764),
    [anon_sym_GT_EQ] = ACTIONS(764),
    [sym_bottom] = ACTIONS(764),
    [anon_sym_true] = ACTIONS(766),
    [anon_sym_false] = ACTIONS(766),
    [sym_null] = ACTIONS(766),
    [sym_number] = ACTIONS(766),
    [sym_float] = ACTIONS(766),
    [anon_sym_DQUOTE] = ACTIONS(766),
    [anon_sym_SQUOTE] = ACTIONS(766),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(764),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(764),
    [anon_sym_POUND_DQUOTE] = ACTIONS(766),
    [anon_sym_POUND_SQUOTE] = ACTIONS(766),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(764),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(764),
    [sym_comment] = ACTIONS(3),
  },
  [162] = {
    [ts_builtin_sym_end] = ACTIONS(768),
    [sym_identifier] = ACTIONS(770),
    [anon_sym_COMMA] = ACTIONS(768),
    [anon_sym_DOT] = ACTIONS(770),
    [anon_sym__] = ACTIONS(770),
    [anon_sym_LPAREN] = ACTIONS(768),
    [anon_sym_let] = ACTIONS(770),
    [anon_sym_if] = ACTIONS(770),
    [anon_sym_for] = ACTIONS(770),
    [anon_sym_number] = ACTIONS(770),
    [anon_sym_float] = ACTIONS(770),
    [anon_sym_float32] = ACTIONS(770),
    [anon_sym_float64] = ACTIONS(770),
    [anon_sym_uint] = ACTIONS(770),
    [anon_sym_uint8] = ACTIONS(770),
    [anon_sym_uint16] = ACTIONS(770),
    [anon_sym_uint32] = ACTIONS(770),
    [anon_sym_uint64] = ACTIONS(770),
    [anon_sym_uint128] = ACTIONS(770),
    [anon_sym_int] = ACTIONS(770),
    [anon_sym_int8] = ACTIONS(770),
    [anon_sym_int16] = ACTIONS(770),
    [anon_sym_int32] = ACTIONS(770),
    [anon_sym_int64] = ACTIONS(770),
    [anon_sym_int128] = ACTIONS(770),
    [anon_sym_string] = ACTIONS(770),
    [anon_sym_bytes] = ACTIONS(770),
    [anon_sym_bool] = ACTIONS(770),
    [anon_sym_AT] = ACTIONS(768),
    [anon_sym_DASH] = ACTIONS(770),
    [anon_sym_LBRACK] = ACTIONS(768),
    [anon_sym_RBRACK] = ACTIONS(768),
    [anon_sym_LBRACE] = ACTIONS(768),
    [anon_sym_RBRACE] = ACTIONS(768),
    [anon_sym_LT] = ACTIONS(770),
    [anon_sym_GT] = ACTIONS(770),
    [anon_sym_STAR] = ACTIONS(768),
    [anon_sym_len] = ACTIONS(770),
    [anon_sym_close] = ACTIONS(770),
    [anon_sym_and] = ACTIONS(770),
    [anon_sym_or] = ACTIONS(770),
    [anon_sym_div] = ACTIONS(770),
    [anon_sym_mod] = ACTIONS(770),
    [anon_sym_quo] = ACTIONS(770),
    [anon_sym_rem] = ACTIONS(770),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(770),
    [anon_sym_PLUS] = ACTIONS(770),
    [anon_sym_SLASH] = ACTIONS(770),
    [anon_sym_PIPE] = ACTIONS(770),
    [anon_sym_AMP] = ACTIONS(770),
    [anon_sym_PIPE_PIPE] = ACTIONS(768),
    [anon_sym_AMP_AMP] = ACTIONS(768),
    [anon_sym_EQ_EQ] = ACTIONS(768),
    [anon_sym_EQ_TILDE] = ACTIONS(768),
    [anon_sym_BANG_TILDE] = ACTIONS(768),
    [anon_sym_BANG_EQ] = ACTIONS(768),
    [anon_sym_LT_EQ] = ACTIONS(768),
    [anon_sym_GT_EQ] = ACTIONS(768),
    [sym_bottom] = ACTIONS(768),
    [anon_sym_true] = ACTIONS(770),
    [anon_sym_false] = ACTIONS(770),
    [sym_null] = ACTIONS(770),
    [sym_number] = ACTIONS(770),
    [sym_float] = ACTIONS(770),
    [anon_sym_DQUOTE] = ACTIONS(770),
    [anon_sym_SQUOTE] = ACTIONS(770),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(768),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(768),
    [anon_sym_POUND_DQUOTE] = ACTIONS(770),
    [anon_sym_POUND_SQUOTE] = ACTIONS(770),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(768),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(768),
    [sym_comment] = ACTIONS(3),
  },
  [163] = {
    [ts_builtin_sym_end] = ACTIONS(772),
    [sym_identifier] = ACTIONS(774),
    [anon_sym_COMMA] = ACTIONS(772),
    [anon_sym_DOT] = ACTIONS(774),
    [anon_sym__] = ACTIONS(774),
    [anon_sym_LPAREN] = ACTIONS(772),
    [anon_sym_let] = ACTIONS(774),
    [anon_sym_if] = ACTIONS(774),
    [anon_sym_for] = ACTIONS(774),
    [anon_sym_number] = ACTIONS(774),
    [anon_sym_float] = ACTIONS(774),
    [anon_sym_float32] = ACTIONS(774),
    [anon_sym_float64] = ACTIONS(774),
    [anon_sym_uint] = ACTIONS(774),
    [anon_sym_uint8] = ACTIONS(774),
    [anon_sym_uint16] = ACTIONS(774),
    [anon_sym_uint32] = ACTIONS(774),
    [anon_sym_uint64] = ACTIONS(774),
    [anon_sym_uint128] = ACTIONS(774),
    [anon_sym_int] = ACTIONS(774),
    [anon_sym_int8] = ACTIONS(774),
    [anon_sym_int16] = ACTIONS(774),
    [anon_sym_int32] = ACTIONS(774),
    [anon_sym_int64] = ACTIONS(774),
    [anon_sym_int128] = ACTIONS(774),
    [anon_sym_string] = ACTIONS(774),
    [anon_sym_bytes] = ACTIONS(774),
    [anon_sym_bool] = ACTIONS(774),
    [anon_sym_AT] = ACTIONS(772),
    [anon_sym_DASH] = ACTIONS(774),
    [anon_sym_LBRACK] = ACTIONS(772),
    [anon_sym_RBRACK] = ACTIONS(772),
    [anon_sym_LBRACE] = ACTIONS(772),
    [anon_sym_RBRACE] = ACTIONS(772),
    [anon_sym_LT] = ACTIONS(774),
    [anon_sym_GT] = ACTIONS(774),
    [anon_sym_STAR] = ACTIONS(772),
    [anon_sym_len] = ACTIONS(774),
    [anon_sym_close] = ACTIONS(774),
    [anon_sym_and] = ACTIONS(774),
    [anon_sym_or] = ACTIONS(774),
    [anon_sym_div] = ACTIONS(774),
    [anon_sym_mod] = ACTIONS(774),
    [anon_sym_quo] = ACTIONS(774),
    [anon_sym_rem] = ACTIONS(774),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(772),
    [anon_sym_BANG] = ACTIONS(774),
    [anon_sym_PLUS] = ACTIONS(774),
    [anon_sym_SLASH] = ACTIONS(774),
    [anon_sym_PIPE] = ACTIONS(774),
    [anon_sym_AMP] = ACTIONS(774),
    [anon_sym_PIPE_PIPE] = ACTIONS(772),
    [anon_sym_AMP_AMP] = ACTIONS(772),
    [anon_sym_EQ_EQ] = ACTIONS(772),
    [anon_sym_EQ_TILDE] = ACTIONS(772),
    [anon_sym_BANG_TILDE] = ACTIONS(772),
    [anon_sym_BANG_EQ] = ACTIONS(772),
    [anon_sym_LT_EQ] = ACTIONS(772),
    [anon_sym_GT_EQ] = ACTIONS(772),
    [sym_bottom] = ACTIONS(772),
    [anon_sym_true] = ACTIONS(774),
    [anon_sym_false] = ACTIONS(774),
    [sym_null] = ACTIONS(774),
    [sym_number] = ACTIONS(774),
    [sym_float] = ACTIONS(774),
    [anon_sym_DQUOTE] = ACTIONS(774),
    [anon_sym_SQUOTE] = ACTIONS(774),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(772),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(772),
    [anon_sym_POUND_DQUOTE] = ACTIONS(774),
    [anon_sym_POUND_SQUOTE] = ACTIONS(774),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(772),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(772),
    [sym_comment] = ACTIONS(3),
  },
  [164] = {
    [ts_builtin_sym_end] = ACTIONS(602),
    [sym_identifier] = ACTIONS(604),
    [anon_sym_COMMA] = ACTIONS(602),
    [anon_sym_DOT] = ACTIONS(604),
    [anon_sym__] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(602),
    [anon_sym_let] = ACTIONS(604),
    [anon_sym_if] = ACTIONS(604),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_number] = ACTIONS(604),
    [anon_sym_float] = ACTIONS(604),
    [anon_sym_float32] = ACTIONS(604),
    [anon_sym_float64] = ACTIONS(604),
    [anon_sym_uint] = ACTIONS(604),
    [anon_sym_uint8] = ACTIONS(604),
    [anon_sym_uint16] = ACTIONS(604),
    [anon_sym_uint32] = ACTIONS(604),
    [anon_sym_uint64] = ACTIONS(604),
    [anon_sym_uint128] = ACTIONS(604),
    [anon_sym_int] = ACTIONS(604),
    [anon_sym_int8] = ACTIONS(604),
    [anon_sym_int16] = ACTIONS(604),
    [anon_sym_int32] = ACTIONS(604),
    [anon_sym_int64] = ACTIONS(604),
    [anon_sym_int128] = ACTIONS(604),
    [anon_sym_string] = ACTIONS(604),
    [anon_sym_bytes] = ACTIONS(604),
    [anon_sym_bool] = ACTIONS(604),
    [anon_sym_AT] = ACTIONS(602),
    [anon_sym_DASH] = ACTIONS(604),
    [anon_sym_LBRACK] = ACTIONS(602),
    [anon_sym_RBRACK] = ACTIONS(602),
    [anon_sym_LBRACE] = ACTIONS(602),
    [anon_sym_RBRACE] = ACTIONS(602),
    [anon_sym_LT] = ACTIONS(604),
    [anon_sym_GT] = ACTIONS(604),
    [anon_sym_STAR] = ACTIONS(602),
    [anon_sym_len] = ACTIONS(604),
    [anon_sym_close] = ACTIONS(604),
    [anon_sym_and] = ACTIONS(604),
    [anon_sym_or] = ACTIONS(604),
    [anon_sym_div] = ACTIONS(604),
    [anon_sym_mod] = ACTIONS(604),
    [anon_sym_quo] = ACTIONS(604),
    [anon_sym_rem] = ACTIONS(604),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(602),
    [anon_sym_BANG] = ACTIONS(604),
    [anon_sym_PLUS] = ACTIONS(604),
    [anon_sym_SLASH] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(604),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE_PIPE] = ACTIONS(602),
    [anon_sym_AMP_AMP] = ACTIONS(602),
    [anon_sym_EQ_EQ] = ACTIONS(602),
    [anon_sym_EQ_TILDE] = ACTIONS(602),
    [anon_sym_BANG_TILDE] = ACTIONS(602),
    [anon_sym_BANG_EQ] = ACTIONS(602),
    [anon_sym_LT_EQ] = ACTIONS(602),
    [anon_sym_GT_EQ] = ACTIONS(602),
    [sym_bottom] = ACTIONS(602),
    [anon_sym_true] = ACTIONS(604),
    [anon_sym_false] = ACTIONS(604),
    [sym_null] = ACTIONS(604),
    [sym_number] = ACTIONS(604),
    [sym_float] = ACTIONS(604),
    [anon_sym_DQUOTE] = ACTIONS(604),
    [anon_sym_SQUOTE] = ACTIONS(604),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(602),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(602),
    [anon_sym_POUND_DQUOTE] = ACTIONS(604),
    [anon_sym_POUND_SQUOTE] = ACTIONS(604),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(602),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(602),
    [sym_comment] = ACTIONS(3),
  },
  [165] = {
    [ts_builtin_sym_end] = ACTIONS(776),
    [sym_identifier] = ACTIONS(778),
    [anon_sym_COMMA] = ACTIONS(776),
    [anon_sym_DOT] = ACTIONS(778),
    [anon_sym__] = ACTIONS(778),
    [anon_sym_LPAREN] = ACTIONS(776),
    [anon_sym_let] = ACTIONS(778),
    [anon_sym_if] = ACTIONS(778),
    [anon_sym_for] = ACTIONS(778),
    [anon_sym_number] = ACTIONS(778),
    [anon_sym_float] = ACTIONS(778),
    [anon_sym_float32] = ACTIONS(778),
    [anon_sym_float64] = ACTIONS(778),
    [anon_sym_uint] = ACTIONS(778),
    [anon_sym_uint8] = ACTIONS(778),
    [anon_sym_uint16] = ACTIONS(778),
    [anon_sym_uint32] = ACTIONS(778),
    [anon_sym_uint64] = ACTIONS(778),
    [anon_sym_uint128] = ACTIONS(778),
    [anon_sym_int] = ACTIONS(778),
    [anon_sym_int8] = ACTIONS(778),
    [anon_sym_int16] = ACTIONS(778),
    [anon_sym_int32] = ACTIONS(778),
    [anon_sym_int64] = ACTIONS(778),
    [anon_sym_int128] = ACTIONS(778),
    [anon_sym_string] = ACTIONS(778),
    [anon_sym_bytes] = ACTIONS(778),
    [anon_sym_bool] = ACTIONS(778),
    [anon_sym_AT] = ACTIONS(776),
    [anon_sym_DASH] = ACTIONS(778),
    [anon_sym_LBRACK] = ACTIONS(776),
    [anon_sym_RBRACK] = ACTIONS(776),
    [anon_sym_LBRACE] = ACTIONS(776),
    [anon_sym_RBRACE] = ACTIONS(776),
    [anon_sym_LT] = ACTIONS(778),
    [anon_sym_GT] = ACTIONS(778),
    [anon_sym_STAR] = ACTIONS(776),
    [anon_sym_len] = ACTIONS(778),
    [anon_sym_close] = ACTIONS(778),
    [anon_sym_and] = ACTIONS(778),
    [anon_sym_or] = ACTIONS(778),
    [anon_sym_div] = ACTIONS(778),
    [anon_sym_mod] = ACTIONS(778),
    [anon_sym_quo] = ACTIONS(778),
    [anon_sym_rem] = ACTIONS(778),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(776),
    [anon_sym_BANG] = ACTIONS(778),
    [anon_sym_PLUS] = ACTIONS(778),
    [anon_sym_SLASH] = ACTIONS(778),
    [anon_sym_PIPE] = ACTIONS(778),
    [anon_sym_AMP] = ACTIONS(778),
    [anon_sym_PIPE_PIPE] = ACTIONS(776),
    [anon_sym_AMP_AMP] = ACTIONS(776),
    [anon_sym_EQ_EQ] = ACTIONS(776),
    [anon_sym_EQ_TILDE] = ACTIONS(776),
    [anon_sym_BANG_TILDE] = ACTIONS(776),
    [anon_sym_BANG_EQ] = ACTIONS(776),
    [anon_sym_LT_EQ] = ACTIONS(776),
    [anon_sym_GT_EQ] = ACTIONS(776),
    [sym_bottom] = ACTIONS(776),
    [anon_sym_true] = ACTIONS(778),
    [anon_sym_false] = ACTIONS(778),
    [sym_null] = ACTIONS(778),
    [sym_number] = ACTIONS(778),
    [sym_float] = ACTIONS(778),
    [anon_sym_DQUOTE] = ACTIONS(778),
    [anon_sym_SQUOTE] = ACTIONS(778),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(776),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(776),
    [anon_sym_POUND_DQUOTE] = ACTIONS(778),
    [anon_sym_POUND_SQUOTE] = ACTIONS(778),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(776),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(776),
    [sym_comment] = ACTIONS(3),
  },
  [166] = {
    [ts_builtin_sym_end] = ACTIONS(780),
    [sym_identifier] = ACTIONS(782),
    [anon_sym_COMMA] = ACTIONS(780),
    [anon_sym_DOT] = ACTIONS(782),
    [anon_sym__] = ACTIONS(782),
    [anon_sym_LPAREN] = ACTIONS(780),
    [anon_sym_let] = ACTIONS(782),
    [anon_sym_if] = ACTIONS(782),
    [anon_sym_for] = ACTIONS(782),
    [anon_sym_number] = ACTIONS(782),
    [anon_sym_float] = ACTIONS(782),
    [anon_sym_float32] = ACTIONS(782),
    [anon_sym_float64] = ACTIONS(782),
    [anon_sym_uint] = ACTIONS(782),
    [anon_sym_uint8] = ACTIONS(782),
    [anon_sym_uint16] = ACTIONS(782),
    [anon_sym_uint32] = ACTIONS(782),
    [anon_sym_uint64] = ACTIONS(782),
    [anon_sym_uint128] = ACTIONS(782),
    [anon_sym_int] = ACTIONS(782),
    [anon_sym_int8] = ACTIONS(782),
    [anon_sym_int16] = ACTIONS(782),
    [anon_sym_int32] = ACTIONS(782),
    [anon_sym_int64] = ACTIONS(782),
    [anon_sym_int128] = ACTIONS(782),
    [anon_sym_string] = ACTIONS(782),
    [anon_sym_bytes] = ACTIONS(782),
    [anon_sym_bool] = ACTIONS(782),
    [anon_sym_AT] = ACTIONS(780),
    [anon_sym_DASH] = ACTIONS(782),
    [anon_sym_LBRACK] = ACTIONS(780),
    [anon_sym_RBRACK] = ACTIONS(780),
    [anon_sym_LBRACE] = ACTIONS(780),
    [anon_sym_RBRACE] = ACTIONS(780),
    [anon_sym_LT] = ACTIONS(782),
    [anon_sym_GT] = ACTIONS(782),
    [anon_sym_STAR] = ACTIONS(780),
    [anon_sym_len] = ACTIONS(782),
    [anon_sym_close] = ACTIONS(782),
    [anon_sym_and] = ACTIONS(782),
    [anon_sym_or] = ACTIONS(782),
    [anon_sym_div] = ACTIONS(782),
    [anon_sym_mod] = ACTIONS(782),
    [anon_sym_quo] = ACTIONS(782),
    [anon_sym_rem] = ACTIONS(782),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(780),
    [anon_sym_BANG] = ACTIONS(782),
    [anon_sym_PLUS] = ACTIONS(782),
    [anon_sym_SLASH] = ACTIONS(782),
    [anon_sym_PIPE] = ACTIONS(782),
    [anon_sym_AMP] = ACTIONS(782),
    [anon_sym_PIPE_PIPE] = ACTIONS(780),
    [anon_sym_AMP_AMP] = ACTIONS(780),
    [anon_sym_EQ_EQ] = ACTIONS(780),
    [anon_sym_EQ_TILDE] = ACTIONS(780),
    [anon_sym_BANG_TILDE] = ACTIONS(780),
    [anon_sym_BANG_EQ] = ACTIONS(780),
    [anon_sym_LT_EQ] = ACTIONS(780),
    [anon_sym_GT_EQ] = ACTIONS(780),
    [sym_bottom] = ACTIONS(780),
    [anon_sym_true] = ACTIONS(782),
    [anon_sym_false] = ACTIONS(782),
    [sym_null] = ACTIONS(782),
    [sym_number] = ACTIONS(782),
    [sym_float] = ACTIONS(782),
    [anon_sym_DQUOTE] = ACTIONS(782),
    [anon_sym_SQUOTE] = ACTIONS(782),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(780),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(780),
    [anon_sym_POUND_DQUOTE] = ACTIONS(782),
    [anon_sym_POUND_SQUOTE] = ACTIONS(782),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(780),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(780),
    [sym_comment] = ACTIONS(3),
  },
  [167] = {
    [ts_builtin_sym_end] = ACTIONS(784),
    [sym_identifier] = ACTIONS(786),
    [anon_sym_COMMA] = ACTIONS(784),
    [anon_sym_DOT] = ACTIONS(786),
    [anon_sym__] = ACTIONS(786),
    [anon_sym_LPAREN] = ACTIONS(784),
    [anon_sym_let] = ACTIONS(786),
    [anon_sym_if] = ACTIONS(786),
    [anon_sym_for] = ACTIONS(786),
    [anon_sym_number] = ACTIONS(786),
    [anon_sym_float] = ACTIONS(786),
    [anon_sym_float32] = ACTIONS(786),
    [anon_sym_float64] = ACTIONS(786),
    [anon_sym_uint] = ACTIONS(786),
    [anon_sym_uint8] = ACTIONS(786),
    [anon_sym_uint16] = ACTIONS(786),
    [anon_sym_uint32] = ACTIONS(786),
    [anon_sym_uint64] = ACTIONS(786),
    [anon_sym_uint128] = ACTIONS(786),
    [anon_sym_int] = ACTIONS(786),
    [anon_sym_int8] = ACTIONS(786),
    [anon_sym_int16] = ACTIONS(786),
    [anon_sym_int32] = ACTIONS(786),
    [anon_sym_int64] = ACTIONS(786),
    [anon_sym_int128] = ACTIONS(786),
    [anon_sym_string] = ACTIONS(786),
    [anon_sym_bytes] = ACTIONS(786),
    [anon_sym_bool] = ACTIONS(786),
    [anon_sym_AT] = ACTIONS(784),
    [anon_sym_DASH] = ACTIONS(786),
    [anon_sym_LBRACK] = ACTIONS(784),
    [anon_sym_RBRACK] = ACTIONS(784),
    [anon_sym_LBRACE] = ACTIONS(784),
    [anon_sym_RBRACE] = ACTIONS(784),
    [anon_sym_LT] = ACTIONS(786),
    [anon_sym_GT] = ACTIONS(786),
    [anon_sym_STAR] = ACTIONS(784),
    [anon_sym_len] = ACTIONS(786),
    [anon_sym_close] = ACTIONS(786),
    [anon_sym_and] = ACTIONS(786),
    [anon_sym_or] = ACTIONS(786),
    [anon_sym_div] = ACTIONS(786),
    [anon_sym_mod] = ACTIONS(786),
    [anon_sym_quo] = ACTIONS(786),
    [anon_sym_rem] = ACTIONS(786),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(784),
    [anon_sym_BANG] = ACTIONS(786),
    [anon_sym_PLUS] = ACTIONS(786),
    [anon_sym_SLASH] = ACTIONS(786),
    [anon_sym_PIPE] = ACTIONS(786),
    [anon_sym_AMP] = ACTIONS(786),
    [anon_sym_PIPE_PIPE] = ACTIONS(784),
    [anon_sym_AMP_AMP] = ACTIONS(784),
    [anon_sym_EQ_EQ] = ACTIONS(784),
    [anon_sym_EQ_TILDE] = ACTIONS(784),
    [anon_sym_BANG_TILDE] = ACTIONS(784),
    [anon_sym_BANG_EQ] = ACTIONS(784),
    [anon_sym_LT_EQ] = ACTIONS(784),
    [anon_sym_GT_EQ] = ACTIONS(784),
    [sym_bottom] = ACTIONS(784),
    [anon_sym_true] = ACTIONS(786),
    [anon_sym_false] = ACTIONS(786),
    [sym_null] = ACTIONS(786),
    [sym_number] = ACTIONS(786),
    [sym_float] = ACTIONS(786),
    [anon_sym_DQUOTE] = ACTIONS(786),
    [anon_sym_SQUOTE] = ACTIONS(786),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(784),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(784),
    [anon_sym_POUND_DQUOTE] = ACTIONS(786),
    [anon_sym_POUND_SQUOTE] = ACTIONS(786),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(784),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(784),
    [sym_comment] = ACTIONS(3),
  },
  [168] = {
    [ts_builtin_sym_end] = ACTIONS(788),
    [sym_identifier] = ACTIONS(790),
    [anon_sym_COMMA] = ACTIONS(788),
    [anon_sym_DOT] = ACTIONS(790),
    [anon_sym__] = ACTIONS(790),
    [anon_sym_LPAREN] = ACTIONS(788),
    [anon_sym_let] = ACTIONS(790),
    [anon_sym_if] = ACTIONS(790),
    [anon_sym_for] = ACTIONS(790),
    [anon_sym_number] = ACTIONS(790),
    [anon_sym_float] = ACTIONS(790),
    [anon_sym_float32] = ACTIONS(790),
    [anon_sym_float64] = ACTIONS(790),
    [anon_sym_uint] = ACTIONS(790),
    [anon_sym_uint8] = ACTIONS(790),
    [anon_sym_uint16] = ACTIONS(790),
    [anon_sym_uint32] = ACTIONS(790),
    [anon_sym_uint64] = ACTIONS(790),
    [anon_sym_uint128] = ACTIONS(790),
    [anon_sym_int] = ACTIONS(790),
    [anon_sym_int8] = ACTIONS(790),
    [anon_sym_int16] = ACTIONS(790),
    [anon_sym_int32] = ACTIONS(790),
    [anon_sym_int64] = ACTIONS(790),
    [anon_sym_int128] = ACTIONS(790),
    [anon_sym_string] = ACTIONS(790),
    [anon_sym_bytes] = ACTIONS(790),
    [anon_sym_bool] = ACTIONS(790),
    [anon_sym_AT] = ACTIONS(788),
    [anon_sym_DASH] = ACTIONS(790),
    [anon_sym_LBRACK] = ACTIONS(788),
    [anon_sym_RBRACK] = ACTIONS(788),
    [anon_sym_LBRACE] = ACTIONS(788),
    [anon_sym_RBRACE] = ACTIONS(788),
    [anon_sym_LT] = ACTIONS(790),
    [anon_sym_GT] = ACTIONS(790),
    [anon_sym_STAR] = ACTIONS(788),
    [anon_sym_len] = ACTIONS(790),
    [anon_sym_close] = ACTIONS(790),
    [anon_sym_and] = ACTIONS(790),
    [anon_sym_or] = ACTIONS(790),
    [anon_sym_div] = ACTIONS(790),
    [anon_sym_mod] = ACTIONS(790),
    [anon_sym_quo] = ACTIONS(790),
    [anon_sym_rem] = ACTIONS(790),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(788),
    [anon_sym_BANG] = ACTIONS(790),
    [anon_sym_PLUS] = ACTIONS(790),
    [anon_sym_SLASH] = ACTIONS(790),
    [anon_sym_PIPE] = ACTIONS(790),
    [anon_sym_AMP] = ACTIONS(790),
    [anon_sym_PIPE_PIPE] = ACTIONS(788),
    [anon_sym_AMP_AMP] = ACTIONS(788),
    [anon_sym_EQ_EQ] = ACTIONS(788),
    [anon_sym_EQ_TILDE] = ACTIONS(788),
    [anon_sym_BANG_TILDE] = ACTIONS(788),
    [anon_sym_BANG_EQ] = ACTIONS(788),
    [anon_sym_LT_EQ] = ACTIONS(788),
    [anon_sym_GT_EQ] = ACTIONS(788),
    [sym_bottom] = ACTIONS(788),
    [anon_sym_true] = ACTIONS(790),
    [anon_sym_false] = ACTIONS(790),
    [sym_null] = ACTIONS(790),
    [sym_number] = ACTIONS(790),
    [sym_float] = ACTIONS(790),
    [anon_sym_DQUOTE] = ACTIONS(790),
    [anon_sym_SQUOTE] = ACTIONS(790),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(788),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(788),
    [anon_sym_POUND_DQUOTE] = ACTIONS(790),
    [anon_sym_POUND_SQUOTE] = ACTIONS(790),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(788),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(788),
    [sym_comment] = ACTIONS(3),
  },
  [169] = {
    [ts_builtin_sym_end] = ACTIONS(792),
    [sym_identifier] = ACTIONS(794),
    [anon_sym_COMMA] = ACTIONS(792),
    [anon_sym_DOT] = ACTIONS(794),
    [anon_sym__] = ACTIONS(794),
    [anon_sym_LPAREN] = ACTIONS(792),
    [anon_sym_let] = ACTIONS(794),
    [anon_sym_if] = ACTIONS(794),
    [anon_sym_for] = ACTIONS(794),
    [anon_sym_number] = ACTIONS(794),
    [anon_sym_float] = ACTIONS(794),
    [anon_sym_float32] = ACTIONS(794),
    [anon_sym_float64] = ACTIONS(794),
    [anon_sym_uint] = ACTIONS(794),
    [anon_sym_uint8] = ACTIONS(794),
    [anon_sym_uint16] = ACTIONS(794),
    [anon_sym_uint32] = ACTIONS(794),
    [anon_sym_uint64] = ACTIONS(794),
    [anon_sym_uint128] = ACTIONS(794),
    [anon_sym_int] = ACTIONS(794),
    [anon_sym_int8] = ACTIONS(794),
    [anon_sym_int16] = ACTIONS(794),
    [anon_sym_int32] = ACTIONS(794),
    [anon_sym_int64] = ACTIONS(794),
    [anon_sym_int128] = ACTIONS(794),
    [anon_sym_string] = ACTIONS(794),
    [anon_sym_bytes] = ACTIONS(794),
    [anon_sym_bool] = ACTIONS(794),
    [anon_sym_AT] = ACTIONS(792),
    [anon_sym_DASH] = ACTIONS(794),
    [anon_sym_LBRACK] = ACTIONS(792),
    [anon_sym_RBRACK] = ACTIONS(792),
    [anon_sym_LBRACE] = ACTIONS(792),
    [anon_sym_RBRACE] = ACTIONS(792),
    [anon_sym_LT] = ACTIONS(794),
    [anon_sym_GT] = ACTIONS(794),
    [anon_sym_STAR] = ACTIONS(792),
    [anon_sym_len] = ACTIONS(794),
    [anon_sym_close] = ACTIONS(794),
    [anon_sym_and] = ACTIONS(794),
    [anon_sym_or] = ACTIONS(794),
    [anon_sym_div] = ACTIONS(794),
    [anon_sym_mod] = ACTIONS(794),
    [anon_sym_quo] = ACTIONS(794),
    [anon_sym_rem] = ACTIONS(794),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(792),
    [anon_sym_BANG] = ACTIONS(794),
    [anon_sym_PLUS] = ACTIONS(794),
    [anon_sym_SLASH] = ACTIONS(794),
    [anon_sym_PIPE] = ACTIONS(794),
    [anon_sym_AMP] = ACTIONS(794),
    [anon_sym_PIPE_PIPE] = ACTIONS(792),
    [anon_sym_AMP_AMP] = ACTIONS(792),
    [anon_sym_EQ_EQ] = ACTIONS(792),
    [anon_sym_EQ_TILDE] = ACTIONS(792),
    [anon_sym_BANG_TILDE] = ACTIONS(792),
    [anon_sym_BANG_EQ] = ACTIONS(792),
    [anon_sym_LT_EQ] = ACTIONS(792),
    [anon_sym_GT_EQ] = ACTIONS(792),
    [sym_bottom] = ACTIONS(792),
    [anon_sym_true] = ACTIONS(794),
    [anon_sym_false] = ACTIONS(794),
    [sym_null] = ACTIONS(794),
    [sym_number] = ACTIONS(794),
    [sym_float] = ACTIONS(794),
    [anon_sym_DQUOTE] = ACTIONS(794),
    [anon_sym_SQUOTE] = ACTIONS(794),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(792),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(792),
    [anon_sym_POUND_DQUOTE] = ACTIONS(794),
    [anon_sym_POUND_SQUOTE] = ACTIONS(794),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(792),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(792),
    [sym_comment] = ACTIONS(3),
  },
  [170] = {
    [ts_builtin_sym_end] = ACTIONS(796),
    [sym_identifier] = ACTIONS(798),
    [anon_sym_COMMA] = ACTIONS(796),
    [anon_sym_DOT] = ACTIONS(798),
    [anon_sym__] = ACTIONS(798),
    [anon_sym_LPAREN] = ACTIONS(796),
    [anon_sym_let] = ACTIONS(798),
    [anon_sym_if] = ACTIONS(798),
    [anon_sym_for] = ACTIONS(798),
    [anon_sym_number] = ACTIONS(798),
    [anon_sym_float] = ACTIONS(798),
    [anon_sym_float32] = ACTIONS(798),
    [anon_sym_float64] = ACTIONS(798),
    [anon_sym_uint] = ACTIONS(798),
    [anon_sym_uint8] = ACTIONS(798),
    [anon_sym_uint16] = ACTIONS(798),
    [anon_sym_uint32] = ACTIONS(798),
    [anon_sym_uint64] = ACTIONS(798),
    [anon_sym_uint128] = ACTIONS(798),
    [anon_sym_int] = ACTIONS(798),
    [anon_sym_int8] = ACTIONS(798),
    [anon_sym_int16] = ACTIONS(798),
    [anon_sym_int32] = ACTIONS(798),
    [anon_sym_int64] = ACTIONS(798),
    [anon_sym_int128] = ACTIONS(798),
    [anon_sym_string] = ACTIONS(798),
    [anon_sym_bytes] = ACTIONS(798),
    [anon_sym_bool] = ACTIONS(798),
    [anon_sym_AT] = ACTIONS(796),
    [anon_sym_DASH] = ACTIONS(798),
    [anon_sym_LBRACK] = ACTIONS(796),
    [anon_sym_RBRACK] = ACTIONS(796),
    [anon_sym_LBRACE] = ACTIONS(796),
    [anon_sym_RBRACE] = ACTIONS(796),
    [anon_sym_LT] = ACTIONS(798),
    [anon_sym_GT] = ACTIONS(798),
    [anon_sym_STAR] = ACTIONS(796),
    [anon_sym_len] = ACTIONS(798),
    [anon_sym_close] = ACTIONS(798),
    [anon_sym_and] = ACTIONS(798),
    [anon_sym_or] = ACTIONS(798),
    [anon_sym_div] = ACTIONS(798),
    [anon_sym_mod] = ACTIONS(798),
    [anon_sym_quo] = ACTIONS(798),
    [anon_sym_rem] = ACTIONS(798),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(796),
    [anon_sym_BANG] = ACTIONS(798),
    [anon_sym_PLUS] = ACTIONS(798),
    [anon_sym_SLASH] = ACTIONS(798),
    [anon_sym_PIPE] = ACTIONS(798),
    [anon_sym_AMP] = ACTIONS(798),
    [anon_sym_PIPE_PIPE] = ACTIONS(796),
    [anon_sym_AMP_AMP] = ACTIONS(796),
    [anon_sym_EQ_EQ] = ACTIONS(796),
    [anon_sym_EQ_TILDE] = ACTIONS(796),
    [anon_sym_BANG_TILDE] = ACTIONS(796),
    [anon_sym_BANG_EQ] = ACTIONS(796),
    [anon_sym_LT_EQ] = ACTIONS(796),
    [anon_sym_GT_EQ] = ACTIONS(796),
    [sym_bottom] = ACTIONS(796),
    [anon_sym_true] = ACTIONS(798),
    [anon_sym_false] = ACTIONS(798),
    [sym_null] = ACTIONS(798),
    [sym_number] = ACTIONS(798),
    [sym_float] = ACTIONS(798),
    [anon_sym_DQUOTE] = ACTIONS(798),
    [anon_sym_SQUOTE] = ACTIONS(798),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(796),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(796),
    [anon_sym_POUND_DQUOTE] = ACTIONS(798),
    [anon_sym_POUND_SQUOTE] = ACTIONS(798),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(796),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(796),
    [sym_comment] = ACTIONS(3),
  },
  [171] = {
    [ts_builtin_sym_end] = ACTIONS(800),
    [sym_identifier] = ACTIONS(802),
    [anon_sym_COMMA] = ACTIONS(800),
    [anon_sym__] = ACTIONS(802),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_let] = ACTIONS(802),
    [anon_sym_if] = ACTIONS(802),
    [anon_sym_for] = ACTIONS(802),
    [anon_sym_number] = ACTIONS(802),
    [anon_sym_float] = ACTIONS(802),
    [anon_sym_float32] = ACTIONS(802),
    [anon_sym_float64] = ACTIONS(802),
    [anon_sym_uint] = ACTIONS(802),
    [anon_sym_uint8] = ACTIONS(802),
    [anon_sym_uint16] = ACTIONS(802),
    [anon_sym_uint32] = ACTIONS(802),
    [anon_sym_uint64] = ACTIONS(802),
    [anon_sym_uint128] = ACTIONS(802),
    [anon_sym_int] = ACTIONS(802),
    [anon_sym_int8] = ACTIONS(802),
    [anon_sym_int16] = ACTIONS(802),
    [anon_sym_int32] = ACTIONS(802),
    [anon_sym_int64] = ACTIONS(802),
    [anon_sym_int128] = ACTIONS(802),
    [anon_sym_string] = ACTIONS(802),
    [anon_sym_bytes] = ACTIONS(802),
    [anon_sym_bool] = ACTIONS(802),
    [anon_sym_AT] = ACTIONS(800),
    [anon_sym_DASH] = ACTIONS(802),
    [anon_sym_LBRACK] = ACTIONS(800),
    [anon_sym_RBRACK] = ACTIONS(800),
    [anon_sym_LBRACE] = ACTIONS(800),
    [anon_sym_RBRACE] = ACTIONS(800),
    [anon_sym_LT] = ACTIONS(802),
    [anon_sym_GT] = ACTIONS(802),
    [anon_sym_STAR] = ACTIONS(804),
    [anon_sym_len] = ACTIONS(802),
    [anon_sym_close] = ACTIONS(802),
    [anon_sym_and] = ACTIONS(802),
    [anon_sym_or] = ACTIONS(802),
    [anon_sym_div] = ACTIONS(802),
    [anon_sym_mod] = ACTIONS(802),
    [anon_sym_quo] = ACTIONS(802),
    [anon_sym_rem] = ACTIONS(802),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(800),
    [anon_sym_BANG] = ACTIONS(802),
    [anon_sym_PLUS] = ACTIONS(802),
    [anon_sym_SLASH] = ACTIONS(806),
    [anon_sym_PIPE] = ACTIONS(802),
    [anon_sym_AMP] = ACTIONS(802),
    [anon_sym_PIPE_PIPE] = ACTIONS(800),
    [anon_sym_AMP_AMP] = ACTIONS(800),
    [anon_sym_EQ_EQ] = ACTIONS(800),
    [anon_sym_EQ_TILDE] = ACTIONS(800),
    [anon_sym_BANG_TILDE] = ACTIONS(800),
    [anon_sym_BANG_EQ] = ACTIONS(800),
    [anon_sym_LT_EQ] = ACTIONS(800),
    [anon_sym_GT_EQ] = ACTIONS(800),
    [sym_bottom] = ACTIONS(800),
    [anon_sym_true] = ACTIONS(802),
    [anon_sym_false] = ACTIONS(802),
    [sym_null] = ACTIONS(802),
    [sym_number] = ACTIONS(802),
    [sym_float] = ACTIONS(802),
    [anon_sym_DQUOTE] = ACTIONS(802),
    [anon_sym_SQUOTE] = ACTIONS(802),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(800),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(800),
    [anon_sym_POUND_DQUOTE] = ACTIONS(802),
    [anon_sym_POUND_SQUOTE] = ACTIONS(802),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(800),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(800),
    [sym_comment] = ACTIONS(3),
  },
  [172] = {
    [ts_builtin_sym_end] = ACTIONS(808),
    [sym_identifier] = ACTIONS(810),
    [anon_sym_COMMA] = ACTIONS(808),
    [anon_sym__] = ACTIONS(810),
    [anon_sym_LPAREN] = ACTIONS(808),
    [anon_sym_let] = ACTIONS(810),
    [anon_sym_if] = ACTIONS(810),
    [anon_sym_for] = ACTIONS(810),
    [anon_sym_number] = ACTIONS(810),
    [anon_sym_float] = ACTIONS(810),
    [anon_sym_float32] = ACTIONS(810),
    [anon_sym_float64] = ACTIONS(810),
    [anon_sym_uint] = ACTIONS(810),
    [anon_sym_uint8] = ACTIONS(810),
    [anon_sym_uint16] = ACTIONS(810),
    [anon_sym_uint32] = ACTIONS(810),
    [anon_sym_uint64] = ACTIONS(810),
    [anon_sym_uint128] = ACTIONS(810),
    [anon_sym_int] = ACTIONS(810),
    [anon_sym_int8] = ACTIONS(810),
    [anon_sym_int16] = ACTIONS(810),
    [anon_sym_int32] = ACTIONS(810),
    [anon_sym_int64] = ACTIONS(810),
    [anon_sym_int128] = ACTIONS(810),
    [anon_sym_string] = ACTIONS(810),
    [anon_sym_bytes] = ACTIONS(810),
    [anon_sym_bool] = ACTIONS(810),
    [anon_sym_AT] = ACTIONS(808),
    [anon_sym_DASH] = ACTIONS(812),
    [anon_sym_LBRACK] = ACTIONS(808),
    [anon_sym_RBRACK] = ACTIONS(808),
    [anon_sym_LBRACE] = ACTIONS(808),
    [anon_sym_RBRACE] = ACTIONS(808),
    [anon_sym_LT] = ACTIONS(814),
    [anon_sym_GT] = ACTIONS(814),
    [anon_sym_STAR] = ACTIONS(804),
    [anon_sym_len] = ACTIONS(810),
    [anon_sym_close] = ACTIONS(810),
    [anon_sym_and] = ACTIONS(810),
    [anon_sym_or] = ACTIONS(810),
    [anon_sym_div] = ACTIONS(810),
    [anon_sym_mod] = ACTIONS(810),
    [anon_sym_quo] = ACTIONS(810),
    [anon_sym_rem] = ACTIONS(810),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(808),
    [anon_sym_BANG] = ACTIONS(810),
    [anon_sym_PLUS] = ACTIONS(812),
    [anon_sym_SLASH] = ACTIONS(806),
    [anon_sym_PIPE] = ACTIONS(816),
    [anon_sym_AMP] = ACTIONS(818),
    [anon_sym_PIPE_PIPE] = ACTIONS(820),
    [anon_sym_AMP_AMP] = ACTIONS(822),
    [anon_sym_EQ_EQ] = ACTIONS(824),
    [anon_sym_EQ_TILDE] = ACTIONS(824),
    [anon_sym_BANG_TILDE] = ACTIONS(824),
    [anon_sym_BANG_EQ] = ACTIONS(824),
    [anon_sym_LT_EQ] = ACTIONS(824),
    [anon_sym_GT_EQ] = ACTIONS(824),
    [sym_bottom] = ACTIONS(808),
    [anon_sym_true] = ACTIONS(810),
    [anon_sym_false] = ACTIONS(810),
    [sym_null] = ACTIONS(810),
    [sym_number] = ACTIONS(810),
    [sym_float] = ACTIONS(810),
    [anon_sym_DQUOTE] = ACTIONS(810),
    [anon_sym_SQUOTE] = ACTIONS(810),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(808),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(808),
    [anon_sym_POUND_DQUOTE] = ACTIONS(810),
    [anon_sym_POUND_SQUOTE] = ACTIONS(810),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(808),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(808),
    [sym_comment] = ACTIONS(3),
  },
  [173] = {
    [ts_builtin_sym_end] = ACTIONS(800),
    [sym_identifier] = ACTIONS(802),
    [anon_sym_COMMA] = ACTIONS(800),
    [anon_sym__] = ACTIONS(802),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_let] = ACTIONS(802),
    [anon_sym_if] = ACTIONS(802),
    [anon_sym_for] = ACTIONS(802),
    [anon_sym_number] = ACTIONS(802),
    [anon_sym_float] = ACTIONS(802),
    [anon_sym_float32] = ACTIONS(802),
    [anon_sym_float64] = ACTIONS(802),
    [anon_sym_uint] = ACTIONS(802),
    [anon_sym_uint8] = ACTIONS(802),
    [anon_sym_uint16] = ACTIONS(802),
    [anon_sym_uint32] = ACTIONS(802),
    [anon_sym_uint64] = ACTIONS(802),
    [anon_sym_uint128] = ACTIONS(802),
    [anon_sym_int] = ACTIONS(802),
    [anon_sym_int8] = ACTIONS(802),
    [anon_sym_int16] = ACTIONS(802),
    [anon_sym_int32] = ACTIONS(802),
    [anon_sym_int64] = ACTIONS(802),
    [anon_sym_int128] = ACTIONS(802),
    [anon_sym_string] = ACTIONS(802),
    [anon_sym_bytes] = ACTIONS(802),
    [anon_sym_bool] = ACTIONS(802),
    [anon_sym_AT] = ACTIONS(800),
    [anon_sym_DASH] = ACTIONS(812),
    [anon_sym_LBRACK] = ACTIONS(800),
    [anon_sym_RBRACK] = ACTIONS(800),
    [anon_sym_LBRACE] = ACTIONS(800),
    [anon_sym_RBRACE] = ACTIONS(800),
    [anon_sym_LT] = ACTIONS(814),
    [anon_sym_GT] = ACTIONS(814),
    [anon_sym_STAR] = ACTIONS(804),
    [anon_sym_len] = ACTIONS(802),
    [anon_sym_close] = ACTIONS(802),
    [anon_sym_and] = ACTIONS(802),
    [anon_sym_or] = ACTIONS(802),
    [anon_sym_div] = ACTIONS(802),
    [anon_sym_mod] = ACTIONS(802),
    [anon_sym_quo] = ACTIONS(802),
    [anon_sym_rem] = ACTIONS(802),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(800),
    [anon_sym_BANG] = ACTIONS(802),
    [anon_sym_PLUS] = ACTIONS(812),
    [anon_sym_SLASH] = ACTIONS(806),
    [anon_sym_PIPE] = ACTIONS(802),
    [anon_sym_AMP] = ACTIONS(802),
    [anon_sym_PIPE_PIPE] = ACTIONS(800),
    [anon_sym_AMP_AMP] = ACTIONS(800),
    [anon_sym_EQ_EQ] = ACTIONS(824),
    [anon_sym_EQ_TILDE] = ACTIONS(824),
    [anon_sym_BANG_TILDE] = ACTIONS(824),
    [anon_sym_BANG_EQ] = ACTIONS(824),
    [anon_sym_LT_EQ] = ACTIONS(824),
    [anon_sym_GT_EQ] = ACTIONS(824),
    [sym_bottom] = ACTIONS(800),
    [anon_sym_true] = ACTIONS(802),
    [anon_sym_false] = ACTIONS(802),
    [sym_null] = ACTIONS(802),
    [sym_number] = ACTIONS(802),
    [sym_float] = ACTIONS(802),
    [anon_sym_DQUOTE] = ACTIONS(802),
    [anon_sym_SQUOTE] = ACTIONS(802),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(800),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(800),
    [anon_sym_POUND_DQUOTE] = ACTIONS(802),
    [anon_sym_POUND_SQUOTE] = ACTIONS(802),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(800),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(800),
    [sym_comment] = ACTIONS(3),
  },
  [174] = {
    [ts_builtin_sym_end] = ACTIONS(800),
    [sym_identifier] = ACTIONS(802),
    [anon_sym_COMMA] = ACTIONS(800),
    [anon_sym__] = ACTIONS(802),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_let] = ACTIONS(802),
    [anon_sym_if] = ACTIONS(802),
    [anon_sym_for] = ACTIONS(802),
    [anon_sym_number] = ACTIONS(802),
    [anon_sym_float] = ACTIONS(802),
    [anon_sym_float32] = ACTIONS(802),
    [anon_sym_float64] = ACTIONS(802),
    [anon_sym_uint] = ACTIONS(802),
    [anon_sym_uint8] = ACTIONS(802),
    [anon_sym_uint16] = ACTIONS(802),
    [anon_sym_uint32] = ACTIONS(802),
    [anon_sym_uint64] = ACTIONS(802),
    [anon_sym_uint128] = ACTIONS(802),
    [anon_sym_int] = ACTIONS(802),
    [anon_sym_int8] = ACTIONS(802),
    [anon_sym_int16] = ACTIONS(802),
    [anon_sym_int32] = ACTIONS(802),
    [anon_sym_int64] = ACTIONS(802),
    [anon_sym_int128] = ACTIONS(802),
    [anon_sym_string] = ACTIONS(802),
    [anon_sym_bytes] = ACTIONS(802),
    [anon_sym_bool] = ACTIONS(802),
    [anon_sym_AT] = ACTIONS(800),
    [anon_sym_DASH] = ACTIONS(812),
    [anon_sym_LBRACK] = ACTIONS(800),
    [anon_sym_RBRACK] = ACTIONS(800),
    [anon_sym_LBRACE] = ACTIONS(800),
    [anon_sym_RBRACE] = ACTIONS(800),
    [anon_sym_LT] = ACTIONS(814),
    [anon_sym_GT] = ACTIONS(814),
    [anon_sym_STAR] = ACTIONS(804),
    [anon_sym_len] = ACTIONS(802),
    [anon_sym_close] = ACTIONS(802),
    [anon_sym_and] = ACTIONS(802),
    [anon_sym_or] = ACTIONS(802),
    [anon_sym_div] = ACTIONS(802),
    [anon_sym_mod] = ACTIONS(802),
    [anon_sym_quo] = ACTIONS(802),
    [anon_sym_rem] = ACTIONS(802),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(800),
    [anon_sym_BANG] = ACTIONS(802),
    [anon_sym_PLUS] = ACTIONS(812),
    [anon_sym_SLASH] = ACTIONS(806),
    [anon_sym_PIPE] = ACTIONS(802),
    [anon_sym_AMP] = ACTIONS(802),
    [anon_sym_PIPE_PIPE] = ACTIONS(800),
    [anon_sym_AMP_AMP] = ACTIONS(822),
    [anon_sym_EQ_EQ] = ACTIONS(824),
    [anon_sym_EQ_TILDE] = ACTIONS(824),
    [anon_sym_BANG_TILDE] = ACTIONS(824),
    [anon_sym_BANG_EQ] = ACTIONS(824),
    [anon_sym_LT_EQ] = ACTIONS(824),
    [anon_sym_GT_EQ] = ACTIONS(824),
    [sym_bottom] = ACTIONS(800),
    [anon_sym_true] = ACTIONS(802),
    [anon_sym_false] = ACTIONS(802),
    [sym_null] = ACTIONS(802),
    [sym_number] = ACTIONS(802),
    [sym_float] = ACTIONS(802),
    [anon_sym_DQUOTE] = ACTIONS(802),
    [anon_sym_SQUOTE] = ACTIONS(802),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(800),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(800),
    [anon_sym_POUND_DQUOTE] = ACTIONS(802),
    [anon_sym_POUND_SQUOTE] = ACTIONS(802),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(800),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(800),
    [sym_comment] = ACTIONS(3),
  },
  [175] = {
    [ts_builtin_sym_end] = ACTIONS(800),
    [sym_identifier] = ACTIONS(802),
    [anon_sym_COMMA] = ACTIONS(800),
    [anon_sym__] = ACTIONS(802),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_let] = ACTIONS(802),
    [anon_sym_if] = ACTIONS(802),
    [anon_sym_for] = ACTIONS(802),
    [anon_sym_number] = ACTIONS(802),
    [anon_sym_float] = ACTIONS(802),
    [anon_sym_float32] = ACTIONS(802),
    [anon_sym_float64] = ACTIONS(802),
    [anon_sym_uint] = ACTIONS(802),
    [anon_sym_uint8] = ACTIONS(802),
    [anon_sym_uint16] = ACTIONS(802),
    [anon_sym_uint32] = ACTIONS(802),
    [anon_sym_uint64] = ACTIONS(802),
    [anon_sym_uint128] = ACTIONS(802),
    [anon_sym_int] = ACTIONS(802),
    [anon_sym_int8] = ACTIONS(802),
    [anon_sym_int16] = ACTIONS(802),
    [anon_sym_int32] = ACTIONS(802),
    [anon_sym_int64] = ACTIONS(802),
    [anon_sym_int128] = ACTIONS(802),
    [anon_sym_string] = ACTIONS(802),
    [anon_sym_bytes] = ACTIONS(802),
    [anon_sym_bool] = ACTIONS(802),
    [anon_sym_AT] = ACTIONS(800),
    [anon_sym_DASH] = ACTIONS(812),
    [anon_sym_LBRACK] = ACTIONS(800),
    [anon_sym_RBRACK] = ACTIONS(800),
    [anon_sym_LBRACE] = ACTIONS(800),
    [anon_sym_RBRACE] = ACTIONS(800),
    [anon_sym_LT] = ACTIONS(814),
    [anon_sym_GT] = ACTIONS(814),
    [anon_sym_STAR] = ACTIONS(804),
    [anon_sym_len] = ACTIONS(802),
    [anon_sym_close] = ACTIONS(802),
    [anon_sym_and] = ACTIONS(802),
    [anon_sym_or] = ACTIONS(802),
    [anon_sym_div] = ACTIONS(802),
    [anon_sym_mod] = ACTIONS(802),
    [anon_sym_quo] = ACTIONS(802),
    [anon_sym_rem] = ACTIONS(802),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(800),
    [anon_sym_BANG] = ACTIONS(802),
    [anon_sym_PLUS] = ACTIONS(812),
    [anon_sym_SLASH] = ACTIONS(806),
    [anon_sym_PIPE] = ACTIONS(802),
    [anon_sym_AMP] = ACTIONS(802),
    [anon_sym_PIPE_PIPE] = ACTIONS(820),
    [anon_sym_AMP_AMP] = ACTIONS(822),
    [anon_sym_EQ_EQ] = ACTIONS(824),
    [anon_sym_EQ_TILDE] = ACTIONS(824),
    [anon_sym_BANG_TILDE] = ACTIONS(824),
    [anon_sym_BANG_EQ] = ACTIONS(824),
    [anon_sym_LT_EQ] = ACTIONS(824),
    [anon_sym_GT_EQ] = ACTIONS(824),
    [sym_bottom] = ACTIONS(800),
    [anon_sym_true] = ACTIONS(802),
    [anon_sym_false] = ACTIONS(802),
    [sym_null] = ACTIONS(802),
    [sym_number] = ACTIONS(802),
    [sym_float] = ACTIONS(802),
    [anon_sym_DQUOTE] = ACTIONS(802),
    [anon_sym_SQUOTE] = ACTIONS(802),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(800),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(800),
    [anon_sym_POUND_DQUOTE] = ACTIONS(802),
    [anon_sym_POUND_SQUOTE] = ACTIONS(802),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(800),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(800),
    [sym_comment] = ACTIONS(3),
  },
  [176] = {
    [ts_builtin_sym_end] = ACTIONS(800),
    [sym_identifier] = ACTIONS(802),
    [anon_sym_COMMA] = ACTIONS(800),
    [anon_sym__] = ACTIONS(802),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_let] = ACTIONS(802),
    [anon_sym_if] = ACTIONS(802),
    [anon_sym_for] = ACTIONS(802),
    [anon_sym_number] = ACTIONS(802),
    [anon_sym_float] = ACTIONS(802),
    [anon_sym_float32] = ACTIONS(802),
    [anon_sym_float64] = ACTIONS(802),
    [anon_sym_uint] = ACTIONS(802),
    [anon_sym_uint8] = ACTIONS(802),
    [anon_sym_uint16] = ACTIONS(802),
    [anon_sym_uint32] = ACTIONS(802),
    [anon_sym_uint64] = ACTIONS(802),
    [anon_sym_uint128] = ACTIONS(802),
    [anon_sym_int] = ACTIONS(802),
    [anon_sym_int8] = ACTIONS(802),
    [anon_sym_int16] = ACTIONS(802),
    [anon_sym_int32] = ACTIONS(802),
    [anon_sym_int64] = ACTIONS(802),
    [anon_sym_int128] = ACTIONS(802),
    [anon_sym_string] = ACTIONS(802),
    [anon_sym_bytes] = ACTIONS(802),
    [anon_sym_bool] = ACTIONS(802),
    [anon_sym_AT] = ACTIONS(800),
    [anon_sym_DASH] = ACTIONS(812),
    [anon_sym_LBRACK] = ACTIONS(800),
    [anon_sym_RBRACK] = ACTIONS(800),
    [anon_sym_LBRACE] = ACTIONS(800),
    [anon_sym_RBRACE] = ACTIONS(800),
    [anon_sym_LT] = ACTIONS(814),
    [anon_sym_GT] = ACTIONS(814),
    [anon_sym_STAR] = ACTIONS(804),
    [anon_sym_len] = ACTIONS(802),
    [anon_sym_close] = ACTIONS(802),
    [anon_sym_and] = ACTIONS(802),
    [anon_sym_or] = ACTIONS(802),
    [anon_sym_div] = ACTIONS(802),
    [anon_sym_mod] = ACTIONS(802),
    [anon_sym_quo] = ACTIONS(802),
    [anon_sym_rem] = ACTIONS(802),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(800),
    [anon_sym_BANG] = ACTIONS(802),
    [anon_sym_PLUS] = ACTIONS(812),
    [anon_sym_SLASH] = ACTIONS(806),
    [anon_sym_PIPE] = ACTIONS(802),
    [anon_sym_AMP] = ACTIONS(818),
    [anon_sym_PIPE_PIPE] = ACTIONS(820),
    [anon_sym_AMP_AMP] = ACTIONS(822),
    [anon_sym_EQ_EQ] = ACTIONS(824),
    [anon_sym_EQ_TILDE] = ACTIONS(824),
    [anon_sym_BANG_TILDE] = ACTIONS(824),
    [anon_sym_BANG_EQ] = ACTIONS(824),
    [anon_sym_LT_EQ] = ACTIONS(824),
    [anon_sym_GT_EQ] = ACTIONS(824),
    [sym_bottom] = ACTIONS(800),
    [anon_sym_true] = ACTIONS(802),
    [anon_sym_false] = ACTIONS(802),
    [sym_null] = ACTIONS(802),
    [sym_number] = ACTIONS(802),
    [sym_float] = ACTIONS(802),
    [anon_sym_DQUOTE] = ACTIONS(802),
    [anon_sym_SQUOTE] = ACTIONS(802),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(800),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(800),
    [anon_sym_POUND_DQUOTE] = ACTIONS(802),
    [anon_sym_POUND_SQUOTE] = ACTIONS(802),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(800),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(800),
    [sym_comment] = ACTIONS(3),
  },
  [177] = {
    [ts_builtin_sym_end] = ACTIONS(800),
    [sym_identifier] = ACTIONS(802),
    [anon_sym_COMMA] = ACTIONS(800),
    [anon_sym__] = ACTIONS(802),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_let] = ACTIONS(802),
    [anon_sym_if] = ACTIONS(802),
    [anon_sym_for] = ACTIONS(802),
    [anon_sym_number] = ACTIONS(802),
    [anon_sym_float] = ACTIONS(802),
    [anon_sym_float32] = ACTIONS(802),
    [anon_sym_float64] = ACTIONS(802),
    [anon_sym_uint] = ACTIONS(802),
    [anon_sym_uint8] = ACTIONS(802),
    [anon_sym_uint16] = ACTIONS(802),
    [anon_sym_uint32] = ACTIONS(802),
    [anon_sym_uint64] = ACTIONS(802),
    [anon_sym_uint128] = ACTIONS(802),
    [anon_sym_int] = ACTIONS(802),
    [anon_sym_int8] = ACTIONS(802),
    [anon_sym_int16] = ACTIONS(802),
    [anon_sym_int32] = ACTIONS(802),
    [anon_sym_int64] = ACTIONS(802),
    [anon_sym_int128] = ACTIONS(802),
    [anon_sym_string] = ACTIONS(802),
    [anon_sym_bytes] = ACTIONS(802),
    [anon_sym_bool] = ACTIONS(802),
    [anon_sym_AT] = ACTIONS(800),
    [anon_sym_DASH] = ACTIONS(802),
    [anon_sym_LBRACK] = ACTIONS(800),
    [anon_sym_RBRACK] = ACTIONS(800),
    [anon_sym_LBRACE] = ACTIONS(800),
    [anon_sym_RBRACE] = ACTIONS(800),
    [anon_sym_LT] = ACTIONS(802),
    [anon_sym_GT] = ACTIONS(802),
    [anon_sym_STAR] = ACTIONS(800),
    [anon_sym_len] = ACTIONS(802),
    [anon_sym_close] = ACTIONS(802),
    [anon_sym_and] = ACTIONS(802),
    [anon_sym_or] = ACTIONS(802),
    [anon_sym_div] = ACTIONS(802),
    [anon_sym_mod] = ACTIONS(802),
    [anon_sym_quo] = ACTIONS(802),
    [anon_sym_rem] = ACTIONS(802),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(800),
    [anon_sym_BANG] = ACTIONS(802),
    [anon_sym_PLUS] = ACTIONS(802),
    [anon_sym_SLASH] = ACTIONS(802),
    [anon_sym_PIPE] = ACTIONS(802),
    [anon_sym_AMP] = ACTIONS(802),
    [anon_sym_PIPE_PIPE] = ACTIONS(800),
    [anon_sym_AMP_AMP] = ACTIONS(800),
    [anon_sym_EQ_EQ] = ACTIONS(800),
    [anon_sym_EQ_TILDE] = ACTIONS(800),
    [anon_sym_BANG_TILDE] = ACTIONS(800),
    [anon_sym_BANG_EQ] = ACTIONS(800),
    [anon_sym_LT_EQ] = ACTIONS(800),
    [anon_sym_GT_EQ] = ACTIONS(800),
    [sym_bottom] = ACTIONS(800),
    [anon_sym_true] = ACTIONS(802),
    [anon_sym_false] = ACTIONS(802),
    [sym_null] = ACTIONS(802),
    [sym_number] = ACTIONS(802),
    [sym_float] = ACTIONS(802),
    [anon_sym_DQUOTE] = ACTIONS(802),
    [anon_sym_SQUOTE] = ACTIONS(802),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(800),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(800),
    [anon_sym_POUND_DQUOTE] = ACTIONS(802),
    [anon_sym_POUND_SQUOTE] = ACTIONS(802),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(800),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(800),
    [sym_comment] = ACTIONS(3),
  },
  [178] = {
    [ts_builtin_sym_end] = ACTIONS(826),
    [sym_identifier] = ACTIONS(828),
    [anon_sym_COMMA] = ACTIONS(826),
    [anon_sym__] = ACTIONS(828),
    [anon_sym_LPAREN] = ACTIONS(826),
    [anon_sym_let] = ACTIONS(828),
    [anon_sym_if] = ACTIONS(828),
    [anon_sym_for] = ACTIONS(828),
    [anon_sym_number] = ACTIONS(828),
    [anon_sym_float] = ACTIONS(828),
    [anon_sym_float32] = ACTIONS(828),
    [anon_sym_float64] = ACTIONS(828),
    [anon_sym_uint] = ACTIONS(828),
    [anon_sym_uint8] = ACTIONS(828),
    [anon_sym_uint16] = ACTIONS(828),
    [anon_sym_uint32] = ACTIONS(828),
    [anon_sym_uint64] = ACTIONS(828),
    [anon_sym_uint128] = ACTIONS(828),
    [anon_sym_int] = ACTIONS(828),
    [anon_sym_int8] = ACTIONS(828),
    [anon_sym_int16] = ACTIONS(828),
    [anon_sym_int32] = ACTIONS(828),
    [anon_sym_int64] = ACTIONS(828),
    [anon_sym_int128] = ACTIONS(828),
    [anon_sym_string] = ACTIONS(828),
    [anon_sym_bytes] = ACTIONS(828),
    [anon_sym_bool] = ACTIONS(828),
    [anon_sym_AT] = ACTIONS(826),
    [anon_sym_DASH] = ACTIONS(812),
    [anon_sym_LBRACK] = ACTIONS(826),
    [anon_sym_RBRACK] = ACTIONS(826),
    [anon_sym_LBRACE] = ACTIONS(826),
    [anon_sym_RBRACE] = ACTIONS(826),
    [anon_sym_LT] = ACTIONS(814),
    [anon_sym_GT] = ACTIONS(814),
    [anon_sym_STAR] = ACTIONS(804),
    [anon_sym_len] = ACTIONS(828),
    [anon_sym_close] = ACTIONS(828),
    [anon_sym_and] = ACTIONS(828),
    [anon_sym_or] = ACTIONS(828),
    [anon_sym_div] = ACTIONS(828),
    [anon_sym_mod] = ACTIONS(828),
    [anon_sym_quo] = ACTIONS(828),
    [anon_sym_rem] = ACTIONS(828),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(826),
    [anon_sym_BANG] = ACTIONS(828),
    [anon_sym_PLUS] = ACTIONS(812),
    [anon_sym_SLASH] = ACTIONS(806),
    [anon_sym_PIPE] = ACTIONS(816),
    [anon_sym_AMP] = ACTIONS(818),
    [anon_sym_PIPE_PIPE] = ACTIONS(820),
    [anon_sym_AMP_AMP] = ACTIONS(822),
    [anon_sym_EQ_EQ] = ACTIONS(824),
    [anon_sym_EQ_TILDE] = ACTIONS(824),
    [anon_sym_BANG_TILDE] = ACTIONS(824),
    [anon_sym_BANG_EQ] = ACTIONS(824),
    [anon_sym_LT_EQ] = ACTIONS(824),
    [anon_sym_GT_EQ] = ACTIONS(824),
    [sym_bottom] = ACTIONS(826),
    [anon_sym_true] = ACTIONS(828),
    [anon_sym_false] = ACTIONS(828),
    [sym_null] = ACTIONS(828),
    [sym_number] = ACTIONS(828),
    [sym_float] = ACTIONS(828),
    [anon_sym_DQUOTE] = ACTIONS(828),
    [anon_sym_SQUOTE] = ACTIONS(828),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(826),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(826),
    [anon_sym_POUND_DQUOTE] = ACTIONS(828),
    [anon_sym_POUND_SQUOTE] = ACTIONS(828),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(826),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(826),
    [sym_comment] = ACTIONS(3),
  },
  [179] = {
    [ts_builtin_sym_end] = ACTIONS(830),
    [sym_identifier] = ACTIONS(832),
    [anon_sym_COMMA] = ACTIONS(830),
    [anon_sym__] = ACTIONS(832),
    [anon_sym_LPAREN] = ACTIONS(830),
    [anon_sym_let] = ACTIONS(832),
    [anon_sym_if] = ACTIONS(832),
    [anon_sym_for] = ACTIONS(832),
    [anon_sym_number] = ACTIONS(832),
    [anon_sym_float] = ACTIONS(832),
    [anon_sym_float32] = ACTIONS(832),
    [anon_sym_float64] = ACTIONS(832),
    [anon_sym_uint] = ACTIONS(832),
    [anon_sym_uint8] = ACTIONS(832),
    [anon_sym_uint16] = ACTIONS(832),
    [anon_sym_uint32] = ACTIONS(832),
    [anon_sym_uint64] = ACTIONS(832),
    [anon_sym_uint128] = ACTIONS(832),
    [anon_sym_int] = ACTIONS(832),
    [anon_sym_int8] = ACTIONS(832),
    [anon_sym_int16] = ACTIONS(832),
    [anon_sym_int32] = ACTIONS(832),
    [anon_sym_int64] = ACTIONS(832),
    [anon_sym_int128] = ACTIONS(832),
    [anon_sym_string] = ACTIONS(832),
    [anon_sym_bytes] = ACTIONS(832),
    [anon_sym_bool] = ACTIONS(832),
    [anon_sym_AT] = ACTIONS(830),
    [anon_sym_DASH] = ACTIONS(812),
    [anon_sym_LBRACK] = ACTIONS(830),
    [anon_sym_RBRACK] = ACTIONS(830),
    [anon_sym_LBRACE] = ACTIONS(830),
    [anon_sym_RBRACE] = ACTIONS(830),
    [anon_sym_LT] = ACTIONS(814),
    [anon_sym_GT] = ACTIONS(814),
    [anon_sym_STAR] = ACTIONS(804),
    [anon_sym_len] = ACTIONS(832),
    [anon_sym_close] = ACTIONS(832),
    [anon_sym_and] = ACTIONS(832),
    [anon_sym_or] = ACTIONS(832),
    [anon_sym_div] = ACTIONS(832),
    [anon_sym_mod] = ACTIONS(832),
    [anon_sym_quo] = ACTIONS(832),
    [anon_sym_rem] = ACTIONS(832),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(830),
    [anon_sym_BANG] = ACTIONS(832),
    [anon_sym_PLUS] = ACTIONS(812),
    [anon_sym_SLASH] = ACTIONS(806),
    [anon_sym_PIPE] = ACTIONS(816),
    [anon_sym_AMP] = ACTIONS(818),
    [anon_sym_PIPE_PIPE] = ACTIONS(820),
    [anon_sym_AMP_AMP] = ACTIONS(822),
    [anon_sym_EQ_EQ] = ACTIONS(824),
    [anon_sym_EQ_TILDE] = ACTIONS(824),
    [anon_sym_BANG_TILDE] = ACTIONS(824),
    [anon_sym_BANG_EQ] = ACTIONS(824),
    [anon_sym_LT_EQ] = ACTIONS(824),
    [anon_sym_GT_EQ] = ACTIONS(824),
    [sym_bottom] = ACTIONS(830),
    [anon_sym_true] = ACTIONS(832),
    [anon_sym_false] = ACTIONS(832),
    [sym_null] = ACTIONS(832),
    [sym_number] = ACTIONS(832),
    [sym_float] = ACTIONS(832),
    [anon_sym_DQUOTE] = ACTIONS(832),
    [anon_sym_SQUOTE] = ACTIONS(832),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(830),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(830),
    [anon_sym_POUND_DQUOTE] = ACTIONS(832),
    [anon_sym_POUND_SQUOTE] = ACTIONS(832),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(830),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(830),
    [sym_comment] = ACTIONS(3),
  },
  [180] = {
    [ts_builtin_sym_end] = ACTIONS(758),
    [sym_identifier] = ACTIONS(760),
    [anon_sym_COMMA] = ACTIONS(758),
    [anon_sym__] = ACTIONS(760),
    [anon_sym_LPAREN] = ACTIONS(758),
    [anon_sym_let] = ACTIONS(760),
    [anon_sym_if] = ACTIONS(760),
    [anon_sym_for] = ACTIONS(760),
    [anon_sym_number] = ACTIONS(760),
    [anon_sym_float] = ACTIONS(760),
    [anon_sym_float32] = ACTIONS(760),
    [anon_sym_float64] = ACTIONS(760),
    [anon_sym_uint] = ACTIONS(760),
    [anon_sym_uint8] = ACTIONS(760),
    [anon_sym_uint16] = ACTIONS(760),
    [anon_sym_uint32] = ACTIONS(760),
    [anon_sym_uint64] = ACTIONS(760),
    [anon_sym_uint128] = ACTIONS(760),
    [anon_sym_int] = ACTIONS(760),
    [anon_sym_int8] = ACTIONS(760),
    [anon_sym_int16] = ACTIONS(760),
    [anon_sym_int32] = ACTIONS(760),
    [anon_sym_int64] = ACTIONS(760),
    [anon_sym_int128] = ACTIONS(760),
    [anon_sym_string] = ACTIONS(760),
    [anon_sym_bytes] = ACTIONS(760),
    [anon_sym_bool] = ACTIONS(760),
    [anon_sym_AT] = ACTIONS(758),
    [anon_sym_DASH] = ACTIONS(760),
    [anon_sym_LBRACK] = ACTIONS(758),
    [anon_sym_RBRACK] = ACTIONS(758),
    [anon_sym_LBRACE] = ACTIONS(758),
    [anon_sym_RBRACE] = ACTIONS(758),
    [anon_sym_LT] = ACTIONS(760),
    [anon_sym_GT] = ACTIONS(760),
    [anon_sym_STAR] = ACTIONS(758),
    [anon_sym_len] = ACTIONS(760),
    [anon_sym_close] = ACTIONS(760),
    [anon_sym_and] = ACTIONS(760),
    [anon_sym_or] = ACTIONS(760),
    [anon_sym_div] = ACTIONS(760),
    [anon_sym_mod] = ACTIONS(760),
    [anon_sym_quo] = ACTIONS(760),
    [anon_sym_rem] = ACTIONS(760),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(758),
    [anon_sym_BANG] = ACTIONS(760),
    [anon_sym_PLUS] = ACTIONS(760),
    [anon_sym_SLASH] = ACTIONS(760),
    [anon_sym_PIPE] = ACTIONS(760),
    [anon_sym_AMP] = ACTIONS(760),
    [anon_sym_PIPE_PIPE] = ACTIONS(758),
    [anon_sym_AMP_AMP] = ACTIONS(758),
    [anon_sym_EQ_EQ] = ACTIONS(758),
    [anon_sym_EQ_TILDE] = ACTIONS(758),
    [anon_sym_BANG_TILDE] = ACTIONS(758),
    [anon_sym_BANG_EQ] = ACTIONS(758),
    [anon_sym_LT_EQ] = ACTIONS(758),
    [anon_sym_GT_EQ] = ACTIONS(758),
    [sym_bottom] = ACTIONS(758),
    [anon_sym_true] = ACTIONS(760),
    [anon_sym_false] = ACTIONS(760),
    [sym_null] = ACTIONS(760),
    [sym_number] = ACTIONS(760),
    [sym_float] = ACTIONS(760),
    [anon_sym_DQUOTE] = ACTIONS(760),
    [anon_sym_SQUOTE] = ACTIONS(760),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(758),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(758),
    [anon_sym_POUND_DQUOTE] = ACTIONS(760),
    [anon_sym_POUND_SQUOTE] = ACTIONS(760),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(758),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(758),
    [sym_comment] = ACTIONS(3),
  },
  [181] = {
    [ts_builtin_sym_end] = ACTIONS(800),
    [sym_identifier] = ACTIONS(802),
    [anon_sym_COMMA] = ACTIONS(800),
    [anon_sym__] = ACTIONS(802),
    [anon_sym_LPAREN] = ACTIONS(800),
    [anon_sym_let] = ACTIONS(802),
    [anon_sym_if] = ACTIONS(802),
    [anon_sym_for] = ACTIONS(802),
    [anon_sym_number] = ACTIONS(802),
    [anon_sym_float] = ACTIONS(802),
    [anon_sym_float32] = ACTIONS(802),
    [anon_sym_float64] = ACTIONS(802),
    [anon_sym_uint] = ACTIONS(802),
    [anon_sym_uint8] = ACTIONS(802),
    [anon_sym_uint16] = ACTIONS(802),
    [anon_sym_uint32] = ACTIONS(802),
    [anon_sym_uint64] = ACTIONS(802),
    [anon_sym_uint128] = ACTIONS(802),
    [anon_sym_int] = ACTIONS(802),
    [anon_sym_int8] = ACTIONS(802),
    [anon_sym_int16] = ACTIONS(802),
    [anon_sym_int32] = ACTIONS(802),
    [anon_sym_int64] = ACTIONS(802),
    [anon_sym_int128] = ACTIONS(802),
    [anon_sym_string] = ACTIONS(802),
    [anon_sym_bytes] = ACTIONS(802),
    [anon_sym_bool] = ACTIONS(802),
    [anon_sym_AT] = ACTIONS(800),
    [anon_sym_DASH] = ACTIONS(812),
    [anon_sym_LBRACK] = ACTIONS(800),
    [anon_sym_RBRACK] = ACTIONS(800),
    [anon_sym_LBRACE] = ACTIONS(800),
    [anon_sym_RBRACE] = ACTIONS(800),
    [anon_sym_LT] = ACTIONS(802),
    [anon_sym_GT] = ACTIONS(802),
    [anon_sym_STAR] = ACTIONS(804),
    [anon_sym_len] = ACTIONS(802),
    [anon_sym_close] = ACTIONS(802),
    [anon_sym_and] = ACTIONS(802),
    [anon_sym_or] = ACTIONS(802),
    [anon_sym_div] = ACTIONS(802),
    [anon_sym_mod] = ACTIONS(802),
    [anon_sym_quo] = ACTIONS(802),
    [anon_sym_rem] = ACTIONS(802),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(800),
    [anon_sym_BANG] = ACTIONS(802),
    [anon_sym_PLUS] = ACTIONS(812),
    [anon_sym_SLASH] = ACTIONS(806),
    [anon_sym_PIPE] = ACTIONS(802),
    [anon_sym_AMP] = ACTIONS(802),
    [anon_sym_PIPE_PIPE] = ACTIONS(800),
    [anon_sym_AMP_AMP] = ACTIONS(800),
    [anon_sym_EQ_EQ] = ACTIONS(800),
    [anon_sym_EQ_TILDE] = ACTIONS(800),
    [anon_sym_BANG_TILDE] = ACTIONS(800),
    [anon_sym_BANG_EQ] = ACTIONS(800),
    [anon_sym_LT_EQ] = ACTIONS(800),
    [anon_sym_GT_EQ] = ACTIONS(800),
    [sym_bottom] = ACTIONS(800),
    [anon_sym_true] = ACTIONS(802),
    [anon_sym_false] = ACTIONS(802),
    [sym_null] = ACTIONS(802),
    [sym_number] = ACTIONS(802),
    [sym_float] = ACTIONS(802),
    [anon_sym_DQUOTE] = ACTIONS(802),
    [anon_sym_SQUOTE] = ACTIONS(802),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(800),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(800),
    [anon_sym_POUND_DQUOTE] = ACTIONS(802),
    [anon_sym_POUND_SQUOTE] = ACTIONS(802),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(800),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(800),
    [sym_comment] = ACTIONS(3),
  },
  [182] = {
    [ts_builtin_sym_end] = ACTIONS(834),
    [sym_identifier] = ACTIONS(836),
    [anon_sym_COMMA] = ACTIONS(834),
    [anon_sym__] = ACTIONS(836),
    [anon_sym_LPAREN] = ACTIONS(834),
    [anon_sym_let] = ACTIONS(836),
    [anon_sym_if] = ACTIONS(836),
    [anon_sym_for] = ACTIONS(836),
    [anon_sym_number] = ACTIONS(836),
    [anon_sym_float] = ACTIONS(836),
    [anon_sym_float32] = ACTIONS(836),
    [anon_sym_float64] = ACTIONS(836),
    [anon_sym_uint] = ACTIONS(836),
    [anon_sym_uint8] = ACTIONS(836),
    [anon_sym_uint16] = ACTIONS(836),
    [anon_sym_uint32] = ACTIONS(836),
    [anon_sym_uint64] = ACTIONS(836),
    [anon_sym_uint128] = ACTIONS(836),
    [anon_sym_int] = ACTIONS(836),
    [anon_sym_int8] = ACTIONS(836),
    [anon_sym_int16] = ACTIONS(836),
    [anon_sym_int32] = ACTIONS(836),
    [anon_sym_int64] = ACTIONS(836),
    [anon_sym_int128] = ACTIONS(836),
    [anon_sym_string] = ACTIONS(836),
    [anon_sym_bytes] = ACTIONS(836),
    [anon_sym_bool] = ACTIONS(836),
    [anon_sym_AT] = ACTIONS(834),
    [anon_sym_DASH] = ACTIONS(836),
    [anon_sym_LBRACK] = ACTIONS(834),
    [anon_sym_RBRACK] = ACTIONS(834),
    [anon_sym_LBRACE] = ACTIONS(834),
    [anon_sym_RBRACE] = ACTIONS(834),
    [anon_sym_LT] = ACTIONS(836),
    [anon_sym_GT] = ACTIONS(836),
    [anon_sym_STAR] = ACTIONS(834),
    [anon_sym_len] = ACTIONS(836),
    [anon_sym_close] = ACTIONS(836),
    [anon_sym_and] = ACTIONS(836),
    [anon_sym_or] = ACTIONS(836),
    [anon_sym_div] = ACTIONS(836),
    [anon_sym_mod] = ACTIONS(836),
    [anon_sym_quo] = ACTIONS(836),
    [anon_sym_rem] = ACTIONS(836),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(834),
    [anon_sym_BANG] = ACTIONS(836),
    [anon_sym_PLUS] = ACTIONS(836),
    [anon_sym_SLASH] = ACTIONS(836),
    [anon_sym_PIPE] = ACTIONS(836),
    [anon_sym_AMP] = ACTIONS(836),
    [anon_sym_PIPE_PIPE] = ACTIONS(834),
    [anon_sym_AMP_AMP] = ACTIONS(834),
    [anon_sym_EQ_EQ] = ACTIONS(834),
    [anon_sym_EQ_TILDE] = ACTIONS(834),
    [anon_sym_BANG_TILDE] = ACTIONS(834),
    [anon_sym_BANG_EQ] = ACTIONS(834),
    [anon_sym_LT_EQ] = ACTIONS(834),
    [anon_sym_GT_EQ] = ACTIONS(834),
    [sym_bottom] = ACTIONS(834),
    [anon_sym_true] = ACTIONS(836),
    [anon_sym_false] = ACTIONS(836),
    [sym_null] = ACTIONS(836),
    [sym_number] = ACTIONS(836),
    [sym_float] = ACTIONS(836),
    [anon_sym_DQUOTE] = ACTIONS(836),
    [anon_sym_SQUOTE] = ACTIONS(836),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(834),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(834),
    [anon_sym_POUND_DQUOTE] = ACTIONS(836),
    [anon_sym_POUND_SQUOTE] = ACTIONS(836),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(834),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(834),
    [sym_comment] = ACTIONS(3),
  },
  [183] = {
    [ts_builtin_sym_end] = ACTIONS(838),
    [sym_identifier] = ACTIONS(840),
    [anon_sym_COMMA] = ACTIONS(838),
    [anon_sym__] = ACTIONS(840),
    [anon_sym_LPAREN] = ACTIONS(838),
    [anon_sym_let] = ACTIONS(840),
    [anon_sym_if] = ACTIONS(840),
    [anon_sym_for] = ACTIONS(840),
    [anon_sym_number] = ACTIONS(840),
    [anon_sym_float] = ACTIONS(840),
    [anon_sym_float32] = ACTIONS(840),
    [anon_sym_float64] = ACTIONS(840),
    [anon_sym_uint] = ACTIONS(840),
    [anon_sym_uint8] = ACTIONS(840),
    [anon_sym_uint16] = ACTIONS(840),
    [anon_sym_uint32] = ACTIONS(840),
    [anon_sym_uint64] = ACTIONS(840),
    [anon_sym_uint128] = ACTIONS(840),
    [anon_sym_int] = ACTIONS(840),
    [anon_sym_int8] = ACTIONS(840),
    [anon_sym_int16] = ACTIONS(840),
    [anon_sym_int32] = ACTIONS(840),
    [anon_sym_int64] = ACTIONS(840),
    [anon_sym_int128] = ACTIONS(840),
    [anon_sym_string] = ACTIONS(840),
    [anon_sym_bytes] = ACTIONS(840),
    [anon_sym_bool] = ACTIONS(840),
    [anon_sym_AT] = ACTIONS(838),
    [anon_sym_DASH] = ACTIONS(812),
    [anon_sym_LBRACK] = ACTIONS(838),
    [anon_sym_LBRACE] = ACTIONS(838),
    [anon_sym_RBRACE] = ACTIONS(838),
    [anon_sym_LT] = ACTIONS(814),
    [anon_sym_GT] = ACTIONS(814),
    [anon_sym_STAR] = ACTIONS(804),
    [anon_sym_len] = ACTIONS(840),
    [anon_sym_close] = ACTIONS(840),
    [anon_sym_and] = ACTIONS(840),
    [anon_sym_or] = ACTIONS(840),
    [anon_sym_div] = ACTIONS(840),
    [anon_sym_mod] = ACTIONS(840),
    [anon_sym_quo] = ACTIONS(840),
    [anon_sym_rem] = ACTIONS(840),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(838),
    [anon_sym_BANG] = ACTIONS(840),
    [anon_sym_PLUS] = ACTIONS(812),
    [anon_sym_SLASH] = ACTIONS(806),
    [anon_sym_PIPE] = ACTIONS(816),
    [anon_sym_AMP] = ACTIONS(818),
    [anon_sym_PIPE_PIPE] = ACTIONS(820),
    [anon_sym_AMP_AMP] = ACTIONS(822),
    [anon_sym_EQ_EQ] = ACTIONS(824),
    [anon_sym_EQ_TILDE] = ACTIONS(824),
    [anon_sym_BANG_TILDE] = ACTIONS(824),
    [anon_sym_BANG_EQ] = ACTIONS(824),
    [anon_sym_LT_EQ] = ACTIONS(824),
    [anon_sym_GT_EQ] = ACTIONS(824),
    [sym_bottom] = ACTIONS(838),
    [anon_sym_true] = ACTIONS(840),
    [anon_sym_false] = ACTIONS(840),
    [sym_null] = ACTIONS(840),
    [sym_number] = ACTIONS(840),
    [sym_float] = ACTIONS(840),
    [anon_sym_DQUOTE] = ACTIONS(840),
    [anon_sym_SQUOTE] = ACTIONS(840),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(838),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(838),
    [anon_sym_POUND_DQUOTE] = ACTIONS(840),
    [anon_sym_POUND_SQUOTE] = ACTIONS(840),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(838),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(838),
    [sym_comment] = ACTIONS(3),
  },
  [184] = {
    [sym_arguments] = STATE(166),
    [sym_identifier] = ACTIONS(604),
    [anon_sym_COMMA] = ACTIONS(602),
    [anon_sym_DOT] = ACTIONS(604),
    [anon_sym__] = ACTIONS(604),
    [anon_sym_LPAREN] = ACTIONS(606),
    [anon_sym_if] = ACTIONS(604),
    [anon_sym_for] = ACTIONS(604),
    [anon_sym_number] = ACTIONS(604),
    [anon_sym_float] = ACTIONS(604),
    [anon_sym_float32] = ACTIONS(604),
    [anon_sym_float64] = ACTIONS(604),
    [anon_sym_uint] = ACTIONS(604),
    [anon_sym_uint8] = ACTIONS(604),
    [anon_sym_uint16] = ACTIONS(604),
    [anon_sym_uint32] = ACTIONS(604),
    [anon_sym_uint64] = ACTIONS(604),
    [anon_sym_uint128] = ACTIONS(604),
    [anon_sym_int] = ACTIONS(604),
    [anon_sym_int8] = ACTIONS(604),
    [anon_sym_int16] = ACTIONS(604),
    [anon_sym_int32] = ACTIONS(604),
    [anon_sym_int64] = ACTIONS(604),
    [anon_sym_int128] = ACTIONS(604),
    [anon_sym_string] = ACTIONS(604),
    [anon_sym_bytes] = ACTIONS(604),
    [anon_sym_bool] = ACTIONS(604),
    [anon_sym_DASH] = ACTIONS(604),
    [anon_sym_LBRACK] = ACTIONS(602),
    [anon_sym_RBRACK] = ACTIONS(602),
    [anon_sym_LBRACE] = ACTIONS(602),
    [anon_sym_LT] = ACTIONS(604),
    [anon_sym_GT] = ACTIONS(604),
    [anon_sym_EQ] = ACTIONS(842),
    [anon_sym_STAR] = ACTIONS(602),
    [anon_sym_len] = ACTIONS(604),
    [anon_sym_close] = ACTIONS(604),
    [anon_sym_and] = ACTIONS(604),
    [anon_sym_or] = ACTIONS(604),
    [anon_sym_div] = ACTIONS(604),
    [anon_sym_mod] = ACTIONS(604),
    [anon_sym_quo] = ACTIONS(604),
    [anon_sym_rem] = ACTIONS(604),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(602),
    [anon_sym_BANG] = ACTIONS(604),
    [anon_sym_PLUS] = ACTIONS(604),
    [anon_sym_SLASH] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(604),
    [anon_sym_AMP] = ACTIONS(604),
    [anon_sym_PIPE_PIPE] = ACTIONS(602),
    [anon_sym_AMP_AMP] = ACTIONS(602),
    [anon_sym_EQ_EQ] = ACTIONS(602),
    [anon_sym_EQ_TILDE] = ACTIONS(602),
    [anon_sym_BANG_TILDE] = ACTIONS(602),
    [anon_sym_BANG_EQ] = ACTIONS(602),
    [anon_sym_LT_EQ] = ACTIONS(602),
    [anon_sym_GT_EQ] = ACTIONS(602),
    [sym_bottom] = ACTIONS(602),
    [anon_sym_true] = ACTIONS(604),
    [anon_sym_false] = ACTIONS(604),
    [sym_null] = ACTIONS(604),
    [sym_number] = ACTIONS(604),
    [sym_float] = ACTIONS(604),
    [anon_sym_DQUOTE] = ACTIONS(604),
    [anon_sym_SQUOTE] = ACTIONS(604),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(602),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(602),
    [anon_sym_POUND_DQUOTE] = ACTIONS(604),
    [anon_sym_POUND_SQUOTE] = ACTIONS(604),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(602),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(602),
    [sym_comment] = ACTIONS(3),
  },
  [185] = {
    [ts_builtin_sym_end] = ACTIONS(844),
    [sym_identifier] = ACTIONS(846),
    [anon_sym_COMMA] = ACTIONS(844),
    [anon_sym_package] = ACTIONS(846),
    [anon_sym_import] = ACTIONS(846),
    [anon_sym__] = ACTIONS(846),
    [anon_sym_LPAREN] = ACTIONS(844),
    [anon_sym_let] = ACTIONS(846),
    [anon_sym_if] = ACTIONS(846),
    [anon_sym_for] = ACTIONS(846),
    [anon_sym_number] = ACTIONS(846),
    [anon_sym_float] = ACTIONS(846),
    [anon_sym_float32] = ACTIONS(846),
    [anon_sym_float64] = ACTIONS(846),
    [anon_sym_uint] = ACTIONS(846),
    [anon_sym_uint8] = ACTIONS(846),
    [anon_sym_uint16] = ACTIONS(846),
    [anon_sym_uint32] = ACTIONS(846),
    [anon_sym_uint64] = ACTIONS(846),
    [anon_sym_uint128] = ACTIONS(846),
    [anon_sym_int] = ACTIONS(846),
    [anon_sym_int8] = ACTIONS(846),
    [anon_sym_int16] = ACTIONS(846),
    [anon_sym_int32] = ACTIONS(846),
    [anon_sym_int64] = ACTIONS(846),
    [anon_sym_int128] = ACTIONS(846),
    [anon_sym_string] = ACTIONS(846),
    [anon_sym_bytes] = ACTIONS(846),
    [anon_sym_bool] = ACTIONS(846),
    [anon_sym_AT] = ACTIONS(844),
    [anon_sym_DASH] = ACTIONS(846),
    [anon_sym_LBRACK] = ACTIONS(844),
    [anon_sym_LBRACE] = ACTIONS(844),
    [anon_sym_RBRACE] = ACTIONS(844),
    [anon_sym_LT] = ACTIONS(846),
    [anon_sym_GT] = ACTIONS(846),
    [anon_sym_STAR] = ACTIONS(844),
    [anon_sym_len] = ACTIONS(846),
    [anon_sym_close] = ACTIONS(846),
    [anon_sym_and] = ACTIONS(846),
    [anon_sym_or] = ACTIONS(846),
    [anon_sym_div] = ACTIONS(846),
    [anon_sym_mod] = ACTIONS(846),
    [anon_sym_quo] = ACTIONS(846),
    [anon_sym_rem] = ACTIONS(846),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(844),
    [anon_sym_BANG] = ACTIONS(846),
    [anon_sym_PLUS] = ACTIONS(846),
    [anon_sym_EQ_TILDE] = ACTIONS(844),
    [anon_sym_BANG_TILDE] = ACTIONS(844),
    [anon_sym_BANG_EQ] = ACTIONS(844),
    [anon_sym_LT_EQ] = ACTIONS(844),
    [anon_sym_GT_EQ] = ACTIONS(844),
    [sym_bottom] = ACTIONS(844),
    [anon_sym_true] = ACTIONS(846),
    [anon_sym_false] = ACTIONS(846),
    [sym_null] = ACTIONS(846),
    [sym_number] = ACTIONS(846),
    [sym_float] = ACTIONS(846),
    [anon_sym_DQUOTE] = ACTIONS(846),
    [anon_sym_SQUOTE] = ACTIONS(846),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(844),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(844),
    [anon_sym_POUND_DQUOTE] = ACTIONS(846),
    [anon_sym_POUND_SQUOTE] = ACTIONS(846),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(844),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(844),
    [sym_comment] = ACTIONS(3),
  },
  [186] = {
    [ts_builtin_sym_end] = ACTIONS(848),
    [sym_identifier] = ACTIONS(850),
    [anon_sym_COMMA] = ACTIONS(848),
    [anon_sym_package] = ACTIONS(850),
    [anon_sym_import] = ACTIONS(850),
    [anon_sym__] = ACTIONS(850),
    [anon_sym_LPAREN] = ACTIONS(848),
    [anon_sym_let] = ACTIONS(850),
    [anon_sym_if] = ACTIONS(850),
    [anon_sym_for] = ACTIONS(850),
    [anon_sym_number] = ACTIONS(850),
    [anon_sym_float] = ACTIONS(850),
    [anon_sym_float32] = ACTIONS(850),
    [anon_sym_float64] = ACTIONS(850),
    [anon_sym_uint] = ACTIONS(850),
    [anon_sym_uint8] = ACTIONS(850),
    [anon_sym_uint16] = ACTIONS(850),
    [anon_sym_uint32] = ACTIONS(850),
    [anon_sym_uint64] = ACTIONS(850),
    [anon_sym_uint128] = ACTIONS(850),
    [anon_sym_int] = ACTIONS(850),
    [anon_sym_int8] = ACTIONS(850),
    [anon_sym_int16] = ACTIONS(850),
    [anon_sym_int32] = ACTIONS(850),
    [anon_sym_int64] = ACTIONS(850),
    [anon_sym_int128] = ACTIONS(850),
    [anon_sym_string] = ACTIONS(850),
    [anon_sym_bytes] = ACTIONS(850),
    [anon_sym_bool] = ACTIONS(850),
    [anon_sym_AT] = ACTIONS(848),
    [anon_sym_DASH] = ACTIONS(850),
    [anon_sym_LBRACK] = ACTIONS(848),
    [anon_sym_LBRACE] = ACTIONS(848),
    [anon_sym_RBRACE] = ACTIONS(848),
    [anon_sym_LT] = ACTIONS(850),
    [anon_sym_GT] = ACTIONS(850),
    [anon_sym_STAR] = ACTIONS(848),
    [anon_sym_len] = ACTIONS(850),
    [anon_sym_close] = ACTIONS(850),
    [anon_sym_and] = ACTIONS(850),
    [anon_sym_or] = ACTIONS(850),
    [anon_sym_div] = ACTIONS(850),
    [anon_sym_mod] = ACTIONS(850),
    [anon_sym_quo] = ACTIONS(850),
    [anon_sym_rem] = ACTIONS(850),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(848),
    [anon_sym_BANG] = ACTIONS(850),
    [anon_sym_PLUS] = ACTIONS(850),
    [anon_sym_EQ_TILDE] = ACTIONS(848),
    [anon_sym_BANG_TILDE] = ACTIONS(848),
    [anon_sym_BANG_EQ] = ACTIONS(848),
    [anon_sym_LT_EQ] = ACTIONS(848),
    [anon_sym_GT_EQ] = ACTIONS(848),
    [sym_bottom] = ACTIONS(848),
    [anon_sym_true] = ACTIONS(850),
    [anon_sym_false] = ACTIONS(850),
    [sym_null] = ACTIONS(850),
    [sym_number] = ACTIONS(850),
    [sym_float] = ACTIONS(850),
    [anon_sym_DQUOTE] = ACTIONS(850),
    [anon_sym_SQUOTE] = ACTIONS(850),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(848),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(848),
    [anon_sym_POUND_DQUOTE] = ACTIONS(850),
    [anon_sym_POUND_SQUOTE] = ACTIONS(850),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(848),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(848),
    [sym_comment] = ACTIONS(3),
  },
  [187] = {
    [ts_builtin_sym_end] = ACTIONS(852),
    [sym_identifier] = ACTIONS(854),
    [anon_sym_COMMA] = ACTIONS(852),
    [anon_sym_package] = ACTIONS(854),
    [anon_sym_import] = ACTIONS(854),
    [anon_sym__] = ACTIONS(854),
    [anon_sym_LPAREN] = ACTIONS(852),
    [anon_sym_let] = ACTIONS(854),
    [anon_sym_if] = ACTIONS(854),
    [anon_sym_for] = ACTIONS(854),
    [anon_sym_number] = ACTIONS(854),
    [anon_sym_float] = ACTIONS(854),
    [anon_sym_float32] = ACTIONS(854),
    [anon_sym_float64] = ACTIONS(854),
    [anon_sym_uint] = ACTIONS(854),
    [anon_sym_uint8] = ACTIONS(854),
    [anon_sym_uint16] = ACTIONS(854),
    [anon_sym_uint32] = ACTIONS(854),
    [anon_sym_uint64] = ACTIONS(854),
    [anon_sym_uint128] = ACTIONS(854),
    [anon_sym_int] = ACTIONS(854),
    [anon_sym_int8] = ACTIONS(854),
    [anon_sym_int16] = ACTIONS(854),
    [anon_sym_int32] = ACTIONS(854),
    [anon_sym_int64] = ACTIONS(854),
    [anon_sym_int128] = ACTIONS(854),
    [anon_sym_string] = ACTIONS(854),
    [anon_sym_bytes] = ACTIONS(854),
    [anon_sym_bool] = ACTIONS(854),
    [anon_sym_AT] = ACTIONS(852),
    [anon_sym_DASH] = ACTIONS(854),
    [anon_sym_LBRACK] = ACTIONS(852),
    [anon_sym_LBRACE] = ACTIONS(852),
    [anon_sym_RBRACE] = ACTIONS(852),
    [anon_sym_LT] = ACTIONS(854),
    [anon_sym_GT] = ACTIONS(854),
    [anon_sym_STAR] = ACTIONS(852),
    [anon_sym_len] = ACTIONS(854),
    [anon_sym_close] = ACTIONS(854),
    [anon_sym_and] = ACTIONS(854),
    [anon_sym_or] = ACTIONS(854),
    [anon_sym_div] = ACTIONS(854),
    [anon_sym_mod] = ACTIONS(854),
    [anon_sym_quo] = ACTIONS(854),
    [anon_sym_rem] = ACTIONS(854),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(852),
    [anon_sym_BANG] = ACTIONS(854),
    [anon_sym_PLUS] = ACTIONS(854),
    [anon_sym_EQ_TILDE] = ACTIONS(852),
    [anon_sym_BANG_TILDE] = ACTIONS(852),
    [anon_sym_BANG_EQ] = ACTIONS(852),
    [anon_sym_LT_EQ] = ACTIONS(852),
    [anon_sym_GT_EQ] = ACTIONS(852),
    [sym_bottom] = ACTIONS(852),
    [anon_sym_true] = ACTIONS(854),
    [anon_sym_false] = ACTIONS(854),
    [sym_null] = ACTIONS(854),
    [sym_number] = ACTIONS(854),
    [sym_float] = ACTIONS(854),
    [anon_sym_DQUOTE] = ACTIONS(854),
    [anon_sym_SQUOTE] = ACTIONS(854),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(852),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(852),
    [anon_sym_POUND_DQUOTE] = ACTIONS(854),
    [anon_sym_POUND_SQUOTE] = ACTIONS(854),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(852),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(852),
    [sym_comment] = ACTIONS(3),
  },
  [188] = {
    [ts_builtin_sym_end] = ACTIONS(750),
    [sym_identifier] = ACTIONS(752),
    [anon_sym_COMMA] = ACTIONS(750),
    [anon_sym__] = ACTIONS(752),
    [anon_sym_LPAREN] = ACTIONS(750),
    [anon_sym_let] = ACTIONS(752),
    [anon_sym_if] = ACTIONS(752),
    [anon_sym_for] = ACTIONS(752),
    [anon_sym_number] = ACTIONS(752),
    [anon_sym_float] = ACTIONS(752),
    [anon_sym_float32] = ACTIONS(752),
    [anon_sym_float64] = ACTIONS(752),
    [anon_sym_uint] = ACTIONS(752),
    [anon_sym_uint8] = ACTIONS(752),
    [anon_sym_uint16] = ACTIONS(752),
    [anon_sym_uint32] = ACTIONS(752),
    [anon_sym_uint64] = ACTIONS(752),
    [anon_sym_uint128] = ACTIONS(752),
    [anon_sym_int] = ACTIONS(752),
    [anon_sym_int8] = ACTIONS(752),
    [anon_sym_int16] = ACTIONS(752),
    [anon_sym_int32] = ACTIONS(752),
    [anon_sym_int64] = ACTIONS(752),
    [anon_sym_int128] = ACTIONS(752),
    [anon_sym_string] = ACTIONS(752),
    [anon_sym_bytes] = ACTIONS(752),
    [anon_sym_bool] = ACTIONS(752),
    [anon_sym_AT] = ACTIONS(750),
    [anon_sym_DASH] = ACTIONS(752),
    [anon_sym_LBRACK] = ACTIONS(750),
    [anon_sym_RBRACK] = ACTIONS(750),
    [anon_sym_LBRACE] = ACTIONS(750),
    [anon_sym_RBRACE] = ACTIONS(750),
    [anon_sym_LT] = ACTIONS(752),
    [anon_sym_GT] = ACTIONS(752),
    [anon_sym_STAR] = ACTIONS(750),
    [anon_sym_len] = ACTIONS(752),
    [anon_sym_close] = ACTIONS(752),
    [anon_sym_and] = ACTIONS(752),
    [anon_sym_or] = ACTIONS(752),
    [anon_sym_div] = ACTIONS(752),
    [anon_sym_mod] = ACTIONS(752),
    [anon_sym_quo] = ACTIONS(752),
    [anon_sym_rem] = ACTIONS(752),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(750),
    [anon_sym_BANG] = ACTIONS(752),
    [anon_sym_PLUS] = ACTIONS(752),
    [anon_sym_EQ_TILDE] = ACTIONS(750),
    [anon_sym_BANG_TILDE] = ACTIONS(750),
    [anon_sym_BANG_EQ] = ACTIONS(750),
    [anon_sym_LT_EQ] = ACTIONS(750),
    [anon_sym_GT_EQ] = ACTIONS(750),
    [sym_bottom] = ACTIONS(750),
    [anon_sym_true] = ACTIONS(752),
    [anon_sym_false] = ACTIONS(752),
    [sym_null] = ACTIONS(752),
    [sym_number] = ACTIONS(752),
    [sym_float] = ACTIONS(752),
    [anon_sym_DQUOTE] = ACTIONS(752),
    [anon_sym_SQUOTE] = ACTIONS(752),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(750),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(750),
    [anon_sym_POUND_DQUOTE] = ACTIONS(752),
    [anon_sym_POUND_SQUOTE] = ACTIONS(752),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(750),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(750),
    [sym_comment] = ACTIONS(3),
  },
  [189] = {
    [ts_builtin_sym_end] = ACTIONS(768),
    [sym_identifier] = ACTIONS(770),
    [anon_sym_COMMA] = ACTIONS(768),
    [anon_sym__] = ACTIONS(770),
    [anon_sym_LPAREN] = ACTIONS(768),
    [anon_sym_let] = ACTIONS(770),
    [anon_sym_if] = ACTIONS(770),
    [anon_sym_for] = ACTIONS(770),
    [anon_sym_number] = ACTIONS(770),
    [anon_sym_float] = ACTIONS(770),
    [anon_sym_float32] = ACTIONS(770),
    [anon_sym_float64] = ACTIONS(770),
    [anon_sym_uint] = ACTIONS(770),
    [anon_sym_uint8] = ACTIONS(770),
    [anon_sym_uint16] = ACTIONS(770),
    [anon_sym_uint32] = ACTIONS(770),
    [anon_sym_uint64] = ACTIONS(770),
    [anon_sym_uint128] = ACTIONS(770),
    [anon_sym_int] = ACTIONS(770),
    [anon_sym_int8] = ACTIONS(770),
    [anon_sym_int16] = ACTIONS(770),
    [anon_sym_int32] = ACTIONS(770),
    [anon_sym_int64] = ACTIONS(770),
    [anon_sym_int128] = ACTIONS(770),
    [anon_sym_string] = ACTIONS(770),
    [anon_sym_bytes] = ACTIONS(770),
    [anon_sym_bool] = ACTIONS(770),
    [anon_sym_AT] = ACTIONS(768),
    [anon_sym_DASH] = ACTIONS(770),
    [anon_sym_LBRACK] = ACTIONS(768),
    [anon_sym_RBRACK] = ACTIONS(768),
    [anon_sym_LBRACE] = ACTIONS(768),
    [anon_sym_RBRACE] = ACTIONS(768),
    [anon_sym_LT] = ACTIONS(770),
    [anon_sym_GT] = ACTIONS(770),
    [anon_sym_STAR] = ACTIONS(768),
    [anon_sym_len] = ACTIONS(770),
    [anon_sym_close] = ACTIONS(770),
    [anon_sym_and] = ACTIONS(770),
    [anon_sym_or] = ACTIONS(770),
    [anon_sym_div] = ACTIONS(770),
    [anon_sym_mod] = ACTIONS(770),
    [anon_sym_quo] = ACTIONS(770),
    [anon_sym_rem] = ACTIONS(770),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(768),
    [anon_sym_BANG] = ACTIONS(770),
    [anon_sym_PLUS] = ACTIONS(770),
    [anon_sym_EQ_TILDE] = ACTIONS(768),
    [anon_sym_BANG_TILDE] = ACTIONS(768),
    [anon_sym_BANG_EQ] = ACTIONS(768),
    [anon_sym_LT_EQ] = ACTIONS(768),
    [anon_sym_GT_EQ] = ACTIONS(768),
    [sym_bottom] = ACTIONS(768),
    [anon_sym_true] = ACTIONS(770),
    [anon_sym_false] = ACTIONS(770),
    [sym_null] = ACTIONS(770),
    [sym_number] = ACTIONS(770),
    [sym_float] = ACTIONS(770),
    [anon_sym_DQUOTE] = ACTIONS(770),
    [anon_sym_SQUOTE] = ACTIONS(770),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(768),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(768),
    [anon_sym_POUND_DQUOTE] = ACTIONS(770),
    [anon_sym_POUND_SQUOTE] = ACTIONS(770),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(768),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(768),
    [sym_comment] = ACTIONS(3),
  },
  [190] = {
    [ts_builtin_sym_end] = ACTIONS(856),
    [sym_identifier] = ACTIONS(858),
    [anon_sym_COMMA] = ACTIONS(856),
    [anon_sym__] = ACTIONS(858),
    [anon_sym_LPAREN] = ACTIONS(856),
    [anon_sym_let] = ACTIONS(858),
    [anon_sym_if] = ACTIONS(858),
    [anon_sym_for] = ACTIONS(858),
    [anon_sym_number] = ACTIONS(858),
    [anon_sym_float] = ACTIONS(858),
    [anon_sym_float32] = ACTIONS(858),
    [anon_sym_float64] = ACTIONS(858),
    [anon_sym_uint] = ACTIONS(858),
    [anon_sym_uint8] = ACTIONS(858),
    [anon_sym_uint16] = ACTIONS(858),
    [anon_sym_uint32] = ACTIONS(858),
    [anon_sym_uint64] = ACTIONS(858),
    [anon_sym_uint128] = ACTIONS(858),
    [anon_sym_int] = ACTIONS(858),
    [anon_sym_int8] = ACTIONS(858),
    [anon_sym_int16] = ACTIONS(858),
    [anon_sym_int32] = ACTIONS(858),
    [anon_sym_int64] = ACTIONS(858),
    [anon_sym_int128] = ACTIONS(858),
    [anon_sym_string] = ACTIONS(858),
    [anon_sym_bytes] = ACTIONS(858),
    [anon_sym_bool] = ACTIONS(858),
    [anon_sym_AT] = ACTIONS(856),
    [anon_sym_DASH] = ACTIONS(858),
    [anon_sym_LBRACK] = ACTIONS(856),
    [anon_sym_RBRACK] = ACTIONS(856),
    [anon_sym_LBRACE] = ACTIONS(856),
    [anon_sym_RBRACE] = ACTIONS(856),
    [anon_sym_LT] = ACTIONS(858),
    [anon_sym_GT] = ACTIONS(858),
    [anon_sym_STAR] = ACTIONS(856),
    [anon_sym_len] = ACTIONS(858),
    [anon_sym_close] = ACTIONS(858),
    [anon_sym_and] = ACTIONS(858),
    [anon_sym_or] = ACTIONS(858),
    [anon_sym_div] = ACTIONS(858),
    [anon_sym_mod] = ACTIONS(858),
    [anon_sym_quo] = ACTIONS(858),
    [anon_sym_rem] = ACTIONS(858),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(856),
    [anon_sym_BANG] = ACTIONS(858),
    [anon_sym_PLUS] = ACTIONS(858),
    [anon_sym_EQ_TILDE] = ACTIONS(856),
    [anon_sym_BANG_TILDE] = ACTIONS(856),
    [anon_sym_BANG_EQ] = ACTIONS(856),
    [anon_sym_LT_EQ] = ACTIONS(856),
    [anon_sym_GT_EQ] = ACTIONS(856),
    [sym_bottom] = ACTIONS(856),
    [anon_sym_true] = ACTIONS(858),
    [anon_sym_false] = ACTIONS(858),
    [sym_null] = ACTIONS(858),
    [sym_number] = ACTIONS(858),
    [sym_float] = ACTIONS(858),
    [anon_sym_DQUOTE] = ACTIONS(858),
    [anon_sym_SQUOTE] = ACTIONS(858),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(856),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(856),
    [anon_sym_POUND_DQUOTE] = ACTIONS(858),
    [anon_sym_POUND_SQUOTE] = ACTIONS(858),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(856),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(856),
    [sym_comment] = ACTIONS(3),
  },
  [191] = {
    [ts_builtin_sym_end] = ACTIONS(738),
    [sym_identifier] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(738),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(738),
    [anon_sym_let] = ACTIONS(740),
    [anon_sym_if] = ACTIONS(740),
    [anon_sym_for] = ACTIONS(740),
    [anon_sym_number] = ACTIONS(740),
    [anon_sym_float] = ACTIONS(740),
    [anon_sym_float32] = ACTIONS(740),
    [anon_sym_float64] = ACTIONS(740),
    [anon_sym_uint] = ACTIONS(740),
    [anon_sym_uint8] = ACTIONS(740),
    [anon_sym_uint16] = ACTIONS(740),
    [anon_sym_uint32] = ACTIONS(740),
    [anon_sym_uint64] = ACTIONS(740),
    [anon_sym_uint128] = ACTIONS(740),
    [anon_sym_int] = ACTIONS(740),
    [anon_sym_int8] = ACTIONS(740),
    [anon_sym_int16] = ACTIONS(740),
    [anon_sym_int32] = ACTIONS(740),
    [anon_sym_int64] = ACTIONS(740),
    [anon_sym_int128] = ACTIONS(740),
    [anon_sym_string] = ACTIONS(740),
    [anon_sym_bytes] = ACTIONS(740),
    [anon_sym_bool] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(738),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_LBRACK] = ACTIONS(738),
    [anon_sym_RBRACK] = ACTIONS(738),
    [anon_sym_LBRACE] = ACTIONS(738),
    [anon_sym_RBRACE] = ACTIONS(738),
    [anon_sym_LT] = ACTIONS(740),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(738),
    [anon_sym_len] = ACTIONS(740),
    [anon_sym_close] = ACTIONS(740),
    [anon_sym_and] = ACTIONS(740),
    [anon_sym_or] = ACTIONS(740),
    [anon_sym_div] = ACTIONS(740),
    [anon_sym_mod] = ACTIONS(740),
    [anon_sym_quo] = ACTIONS(740),
    [anon_sym_rem] = ACTIONS(740),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(738),
    [anon_sym_BANG] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_EQ_TILDE] = ACTIONS(738),
    [anon_sym_BANG_TILDE] = ACTIONS(738),
    [anon_sym_BANG_EQ] = ACTIONS(738),
    [anon_sym_LT_EQ] = ACTIONS(738),
    [anon_sym_GT_EQ] = ACTIONS(738),
    [sym_bottom] = ACTIONS(738),
    [anon_sym_true] = ACTIONS(740),
    [anon_sym_false] = ACTIONS(740),
    [sym_null] = ACTIONS(740),
    [sym_number] = ACTIONS(740),
    [sym_float] = ACTIONS(740),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(738),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(738),
    [anon_sym_POUND_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND_SQUOTE] = ACTIONS(740),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(738),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(738),
    [sym_comment] = ACTIONS(3),
  },
  [192] = {
    [ts_builtin_sym_end] = ACTIONS(860),
    [sym_identifier] = ACTIONS(862),
    [anon_sym_COMMA] = ACTIONS(860),
    [anon_sym__] = ACTIONS(862),
    [anon_sym_LPAREN] = ACTIONS(860),
    [anon_sym_let] = ACTIONS(862),
    [anon_sym_if] = ACTIONS(862),
    [anon_sym_for] = ACTIONS(862),
    [anon_sym_number] = ACTIONS(862),
    [anon_sym_float] = ACTIONS(862),
    [anon_sym_float32] = ACTIONS(862),
    [anon_sym_float64] = ACTIONS(862),
    [anon_sym_uint] = ACTIONS(862),
    [anon_sym_uint8] = ACTIONS(862),
    [anon_sym_uint16] = ACTIONS(862),
    [anon_sym_uint32] = ACTIONS(862),
    [anon_sym_uint64] = ACTIONS(862),
    [anon_sym_uint128] = ACTIONS(862),
    [anon_sym_int] = ACTIONS(862),
    [anon_sym_int8] = ACTIONS(862),
    [anon_sym_int16] = ACTIONS(862),
    [anon_sym_int32] = ACTIONS(862),
    [anon_sym_int64] = ACTIONS(862),
    [anon_sym_int128] = ACTIONS(862),
    [anon_sym_string] = ACTIONS(862),
    [anon_sym_bytes] = ACTIONS(862),
    [anon_sym_bool] = ACTIONS(862),
    [anon_sym_AT] = ACTIONS(860),
    [anon_sym_DASH] = ACTIONS(862),
    [anon_sym_LBRACK] = ACTIONS(860),
    [anon_sym_RBRACK] = ACTIONS(860),
    [anon_sym_LBRACE] = ACTIONS(860),
    [anon_sym_RBRACE] = ACTIONS(860),
    [anon_sym_LT] = ACTIONS(862),
    [anon_sym_GT] = ACTIONS(862),
    [anon_sym_STAR] = ACTIONS(860),
    [anon_sym_len] = ACTIONS(862),
    [anon_sym_close] = ACTIONS(862),
    [anon_sym_and] = ACTIONS(862),
    [anon_sym_or] = ACTIONS(862),
    [anon_sym_div] = ACTIONS(862),
    [anon_sym_mod] = ACTIONS(862),
    [anon_sym_quo] = ACTIONS(862),
    [anon_sym_rem] = ACTIONS(862),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(860),
    [anon_sym_BANG] = ACTIONS(862),
    [anon_sym_PLUS] = ACTIONS(862),
    [anon_sym_EQ_TILDE] = ACTIONS(860),
    [anon_sym_BANG_TILDE] = ACTIONS(860),
    [anon_sym_BANG_EQ] = ACTIONS(860),
    [anon_sym_LT_EQ] = ACTIONS(860),
    [anon_sym_GT_EQ] = ACTIONS(860),
    [sym_bottom] = ACTIONS(860),
    [anon_sym_true] = ACTIONS(862),
    [anon_sym_false] = ACTIONS(862),
    [sym_null] = ACTIONS(862),
    [sym_number] = ACTIONS(862),
    [sym_float] = ACTIONS(862),
    [anon_sym_DQUOTE] = ACTIONS(862),
    [anon_sym_SQUOTE] = ACTIONS(862),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(860),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(860),
    [anon_sym_POUND_DQUOTE] = ACTIONS(862),
    [anon_sym_POUND_SQUOTE] = ACTIONS(862),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(860),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(860),
    [sym_comment] = ACTIONS(3),
  },
  [193] = {
    [ts_builtin_sym_end] = ACTIONS(742),
    [sym_identifier] = ACTIONS(744),
    [anon_sym_COMMA] = ACTIONS(742),
    [anon_sym__] = ACTIONS(744),
    [anon_sym_LPAREN] = ACTIONS(742),
    [anon_sym_let] = ACTIONS(744),
    [anon_sym_if] = ACTIONS(744),
    [anon_sym_for] = ACTIONS(744),
    [anon_sym_number] = ACTIONS(744),
    [anon_sym_float] = ACTIONS(744),
    [anon_sym_float32] = ACTIONS(744),
    [anon_sym_float64] = ACTIONS(744),
    [anon_sym_uint] = ACTIONS(744),
    [anon_sym_uint8] = ACTIONS(744),
    [anon_sym_uint16] = ACTIONS(744),
    [anon_sym_uint32] = ACTIONS(744),
    [anon_sym_uint64] = ACTIONS(744),
    [anon_sym_uint128] = ACTIONS(744),
    [anon_sym_int] = ACTIONS(744),
    [anon_sym_int8] = ACTIONS(744),
    [anon_sym_int16] = ACTIONS(744),
    [anon_sym_int32] = ACTIONS(744),
    [anon_sym_int64] = ACTIONS(744),
    [anon_sym_int128] = ACTIONS(744),
    [anon_sym_string] = ACTIONS(744),
    [anon_sym_bytes] = ACTIONS(744),
    [anon_sym_bool] = ACTIONS(744),
    [anon_sym_AT] = ACTIONS(742),
    [anon_sym_DASH] = ACTIONS(744),
    [anon_sym_LBRACK] = ACTIONS(742),
    [anon_sym_RBRACK] = ACTIONS(742),
    [anon_sym_LBRACE] = ACTIONS(742),
    [anon_sym_RBRACE] = ACTIONS(742),
    [anon_sym_LT] = ACTIONS(744),
    [anon_sym_GT] = ACTIONS(744),
    [anon_sym_STAR] = ACTIONS(742),
    [anon_sym_len] = ACTIONS(744),
    [anon_sym_close] = ACTIONS(744),
    [anon_sym_and] = ACTIONS(744),
    [anon_sym_or] = ACTIONS(744),
    [anon_sym_div] = ACTIONS(744),
    [anon_sym_mod] = ACTIONS(744),
    [anon_sym_quo] = ACTIONS(744),
    [anon_sym_rem] = ACTIONS(744),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(742),
    [anon_sym_BANG] = ACTIONS(744),
    [anon_sym_PLUS] = ACTIONS(744),
    [anon_sym_EQ_TILDE] = ACTIONS(742),
    [anon_sym_BANG_TILDE] = ACTIONS(742),
    [anon_sym_BANG_EQ] = ACTIONS(742),
    [anon_sym_LT_EQ] = ACTIONS(742),
    [anon_sym_GT_EQ] = ACTIONS(742),
    [sym_bottom] = ACTIONS(742),
    [anon_sym_true] = ACTIONS(744),
    [anon_sym_false] = ACTIONS(744),
    [sym_null] = ACTIONS(744),
    [sym_number] = ACTIONS(744),
    [sym_float] = ACTIONS(744),
    [anon_sym_DQUOTE] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(744),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(742),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(742),
    [anon_sym_POUND_DQUOTE] = ACTIONS(744),
    [anon_sym_POUND_SQUOTE] = ACTIONS(744),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(742),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(742),
    [sym_comment] = ACTIONS(3),
  },
  [194] = {
    [ts_builtin_sym_end] = ACTIONS(734),
    [sym_identifier] = ACTIONS(736),
    [anon_sym_COMMA] = ACTIONS(734),
    [anon_sym__] = ACTIONS(736),
    [anon_sym_LPAREN] = ACTIONS(734),
    [anon_sym_let] = ACTIONS(736),
    [anon_sym_if] = ACTIONS(736),
    [anon_sym_for] = ACTIONS(736),
    [anon_sym_number] = ACTIONS(736),
    [anon_sym_float] = ACTIONS(736),
    [anon_sym_float32] = ACTIONS(736),
    [anon_sym_float64] = ACTIONS(736),
    [anon_sym_uint] = ACTIONS(736),
    [anon_sym_uint8] = ACTIONS(736),
    [anon_sym_uint16] = ACTIONS(736),
    [anon_sym_uint32] = ACTIONS(736),
    [anon_sym_uint64] = ACTIONS(736),
    [anon_sym_uint128] = ACTIONS(736),
    [anon_sym_int] = ACTIONS(736),
    [anon_sym_int8] = ACTIONS(736),
    [anon_sym_int16] = ACTIONS(736),
    [anon_sym_int32] = ACTIONS(736),
    [anon_sym_int64] = ACTIONS(736),
    [anon_sym_int128] = ACTIONS(736),
    [anon_sym_string] = ACTIONS(736),
    [anon_sym_bytes] = ACTIONS(736),
    [anon_sym_bool] = ACTIONS(736),
    [anon_sym_AT] = ACTIONS(734),
    [anon_sym_DASH] = ACTIONS(736),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(734),
    [anon_sym_LBRACE] = ACTIONS(734),
    [anon_sym_RBRACE] = ACTIONS(734),
    [anon_sym_LT] = ACTIONS(736),
    [anon_sym_GT] = ACTIONS(736),
    [anon_sym_STAR] = ACTIONS(734),
    [anon_sym_len] = ACTIONS(736),
    [anon_sym_close] = ACTIONS(736),
    [anon_sym_and] = ACTIONS(736),
    [anon_sym_or] = ACTIONS(736),
    [anon_sym_div] = ACTIONS(736),
    [anon_sym_mod] = ACTIONS(736),
    [anon_sym_quo] = ACTIONS(736),
    [anon_sym_rem] = ACTIONS(736),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(734),
    [anon_sym_BANG] = ACTIONS(736),
    [anon_sym_PLUS] = ACTIONS(736),
    [anon_sym_EQ_TILDE] = ACTIONS(734),
    [anon_sym_BANG_TILDE] = ACTIONS(734),
    [anon_sym_BANG_EQ] = ACTIONS(734),
    [anon_sym_LT_EQ] = ACTIONS(734),
    [anon_sym_GT_EQ] = ACTIONS(734),
    [sym_bottom] = ACTIONS(734),
    [anon_sym_true] = ACTIONS(736),
    [anon_sym_false] = ACTIONS(736),
    [sym_null] = ACTIONS(736),
    [sym_number] = ACTIONS(736),
    [sym_float] = ACTIONS(736),
    [anon_sym_DQUOTE] = ACTIONS(736),
    [anon_sym_SQUOTE] = ACTIONS(736),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(734),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(734),
    [anon_sym_POUND_DQUOTE] = ACTIONS(736),
    [anon_sym_POUND_SQUOTE] = ACTIONS(736),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(734),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(734),
    [sym_comment] = ACTIONS(3),
  },
  [195] = {
    [ts_builtin_sym_end] = ACTIONS(746),
    [sym_identifier] = ACTIONS(748),
    [anon_sym_COMMA] = ACTIONS(746),
    [anon_sym__] = ACTIONS(748),
    [anon_sym_LPAREN] = ACTIONS(746),
    [anon_sym_let] = ACTIONS(748),
    [anon_sym_if] = ACTIONS(748),
    [anon_sym_for] = ACTIONS(748),
    [anon_sym_number] = ACTIONS(748),
    [anon_sym_float] = ACTIONS(748),
    [anon_sym_float32] = ACTIONS(748),
    [anon_sym_float64] = ACTIONS(748),
    [anon_sym_uint] = ACTIONS(748),
    [anon_sym_uint8] = ACTIONS(748),
    [anon_sym_uint16] = ACTIONS(748),
    [anon_sym_uint32] = ACTIONS(748),
    [anon_sym_uint64] = ACTIONS(748),
    [anon_sym_uint128] = ACTIONS(748),
    [anon_sym_int] = ACTIONS(748),
    [anon_sym_int8] = ACTIONS(748),
    [anon_sym_int16] = ACTIONS(748),
    [anon_sym_int32] = ACTIONS(748),
    [anon_sym_int64] = ACTIONS(748),
    [anon_sym_int128] = ACTIONS(748),
    [anon_sym_string] = ACTIONS(748),
    [anon_sym_bytes] = ACTIONS(748),
    [anon_sym_bool] = ACTIONS(748),
    [anon_sym_AT] = ACTIONS(746),
    [anon_sym_DASH] = ACTIONS(748),
    [anon_sym_LBRACK] = ACTIONS(746),
    [anon_sym_RBRACK] = ACTIONS(746),
    [anon_sym_LBRACE] = ACTIONS(746),
    [anon_sym_RBRACE] = ACTIONS(746),
    [anon_sym_LT] = ACTIONS(748),
    [anon_sym_GT] = ACTIONS(748),
    [anon_sym_STAR] = ACTIONS(746),
    [anon_sym_len] = ACTIONS(748),
    [anon_sym_close] = ACTIONS(748),
    [anon_sym_and] = ACTIONS(748),
    [anon_sym_or] = ACTIONS(748),
    [anon_sym_div] = ACTIONS(748),
    [anon_sym_mod] = ACTIONS(748),
    [anon_sym_quo] = ACTIONS(748),
    [anon_sym_rem] = ACTIONS(748),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(746),
    [anon_sym_BANG] = ACTIONS(748),
    [anon_sym_PLUS] = ACTIONS(748),
    [anon_sym_EQ_TILDE] = ACTIONS(746),
    [anon_sym_BANG_TILDE] = ACTIONS(746),
    [anon_sym_BANG_EQ] = ACTIONS(746),
    [anon_sym_LT_EQ] = ACTIONS(746),
    [anon_sym_GT_EQ] = ACTIONS(746),
    [sym_bottom] = ACTIONS(746),
    [anon_sym_true] = ACTIONS(748),
    [anon_sym_false] = ACTIONS(748),
    [sym_null] = ACTIONS(748),
    [sym_number] = ACTIONS(748),
    [sym_float] = ACTIONS(748),
    [anon_sym_DQUOTE] = ACTIONS(748),
    [anon_sym_SQUOTE] = ACTIONS(748),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(746),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(746),
    [anon_sym_POUND_DQUOTE] = ACTIONS(748),
    [anon_sym_POUND_SQUOTE] = ACTIONS(748),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(746),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(746),
    [sym_comment] = ACTIONS(3),
  },
  [196] = {
    [sym_attribute] = STATE(204),
    [ts_builtin_sym_end] = ACTIONS(864),
    [sym_identifier] = ACTIONS(866),
    [anon_sym_COMMA] = ACTIONS(864),
    [anon_sym__] = ACTIONS(866),
    [anon_sym_LPAREN] = ACTIONS(864),
    [anon_sym_let] = ACTIONS(866),
    [anon_sym_if] = ACTIONS(866),
    [anon_sym_for] = ACTIONS(866),
    [anon_sym_number] = ACTIONS(866),
    [anon_sym_float] = ACTIONS(866),
    [anon_sym_float32] = ACTIONS(866),
    [anon_sym_float64] = ACTIONS(866),
    [anon_sym_uint] = ACTIONS(866),
    [anon_sym_uint8] = ACTIONS(866),
    [anon_sym_uint16] = ACTIONS(866),
    [anon_sym_uint32] = ACTIONS(866),
    [anon_sym_uint64] = ACTIONS(866),
    [anon_sym_uint128] = ACTIONS(866),
    [anon_sym_int] = ACTIONS(866),
    [anon_sym_int8] = ACTIONS(866),
    [anon_sym_int16] = ACTIONS(866),
    [anon_sym_int32] = ACTIONS(866),
    [anon_sym_int64] = ACTIONS(866),
    [anon_sym_int128] = ACTIONS(866),
    [anon_sym_string] = ACTIONS(866),
    [anon_sym_bytes] = ACTIONS(866),
    [anon_sym_bool] = ACTIONS(866),
    [anon_sym_AT] = ACTIONS(25),
    [anon_sym_DASH] = ACTIONS(866),
    [anon_sym_LBRACK] = ACTIONS(864),
    [anon_sym_LBRACE] = ACTIONS(864),
    [anon_sym_RBRACE] = ACTIONS(864),
    [anon_sym_LT] = ACTIONS(866),
    [anon_sym_GT] = ACTIONS(866),
    [anon_sym_STAR] = ACTIONS(864),
    [anon_sym_len] = ACTIONS(866),
    [anon_sym_close] = ACTIONS(866),
    [anon_sym_and] = ACTIONS(866),
    [anon_sym_or] = ACTIONS(866),
    [anon_sym_div] = ACTIONS(866),
    [anon_sym_mod] = ACTIONS(866),
    [anon_sym_quo] = ACTIONS(866),
    [anon_sym_rem] = ACTIONS(866),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(864),
    [anon_sym_BANG] = ACTIONS(866),
    [anon_sym_PLUS] = ACTIONS(866),
    [anon_sym_EQ_TILDE] = ACTIONS(864),
    [anon_sym_BANG_TILDE] = ACTIONS(864),
    [anon_sym_BANG_EQ] = ACTIONS(864),
    [anon_sym_LT_EQ] = ACTIONS(864),
    [anon_sym_GT_EQ] = ACTIONS(864),
    [sym_bottom] = ACTIONS(864),
    [anon_sym_true] = ACTIONS(866),
    [anon_sym_false] = ACTIONS(866),
    [sym_null] = ACTIONS(866),
    [sym_number] = ACTIONS(866),
    [sym_float] = ACTIONS(866),
    [anon_sym_DQUOTE] = ACTIONS(866),
    [anon_sym_SQUOTE] = ACTIONS(866),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(864),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(864),
    [anon_sym_POUND_DQUOTE] = ACTIONS(866),
    [anon_sym_POUND_SQUOTE] = ACTIONS(866),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(864),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(864),
    [sym_comment] = ACTIONS(3),
  },
  [197] = {
    [ts_builtin_sym_end] = ACTIONS(868),
    [sym_identifier] = ACTIONS(870),
    [anon_sym_COMMA] = ACTIONS(868),
    [anon_sym__] = ACTIONS(870),
    [anon_sym_LPAREN] = ACTIONS(868),
    [anon_sym_let] = ACTIONS(870),
    [anon_sym_if] = ACTIONS(870),
    [anon_sym_for] = ACTIONS(870),
    [anon_sym_number] = ACTIONS(870),
    [anon_sym_float] = ACTIONS(870),
    [anon_sym_float32] = ACTIONS(870),
    [anon_sym_float64] = ACTIONS(870),
    [anon_sym_uint] = ACTIONS(870),
    [anon_sym_uint8] = ACTIONS(870),
    [anon_sym_uint16] = ACTIONS(870),
    [anon_sym_uint32] = ACTIONS(870),
    [anon_sym_uint64] = ACTIONS(870),
    [anon_sym_uint128] = ACTIONS(870),
    [anon_sym_int] = ACTIONS(870),
    [anon_sym_int8] = ACTIONS(870),
    [anon_sym_int16] = ACTIONS(870),
    [anon_sym_int32] = ACTIONS(870),
    [anon_sym_int64] = ACTIONS(870),
    [anon_sym_int128] = ACTIONS(870),
    [anon_sym_string] = ACTIONS(870),
    [anon_sym_bytes] = ACTIONS(870),
    [anon_sym_bool] = ACTIONS(870),
    [anon_sym_AT] = ACTIONS(868),
    [anon_sym_DASH] = ACTIONS(870),
    [anon_sym_LBRACK] = ACTIONS(868),
    [anon_sym_RBRACK] = ACTIONS(868),
    [anon_sym_LBRACE] = ACTIONS(868),
    [anon_sym_RBRACE] = ACTIONS(868),
    [anon_sym_LT] = ACTIONS(870),
    [anon_sym_GT] = ACTIONS(870),
    [anon_sym_STAR] = ACTIONS(868),
    [anon_sym_len] = ACTIONS(870),
    [anon_sym_close] = ACTIONS(870),
    [anon_sym_and] = ACTIONS(870),
    [anon_sym_or] = ACTIONS(870),
    [anon_sym_div] = ACTIONS(870),
    [anon_sym_mod] = ACTIONS(870),
    [anon_sym_quo] = ACTIONS(870),
    [anon_sym_rem] = ACTIONS(870),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(868),
    [anon_sym_BANG] = ACTIONS(870),
    [anon_sym_PLUS] = ACTIONS(870),
    [anon_sym_EQ_TILDE] = ACTIONS(868),
    [anon_sym_BANG_TILDE] = ACTIONS(868),
    [anon_sym_BANG_EQ] = ACTIONS(868),
    [anon_sym_LT_EQ] = ACTIONS(868),
    [anon_sym_GT_EQ] = ACTIONS(868),
    [sym_bottom] = ACTIONS(868),
    [anon_sym_true] = ACTIONS(870),
    [anon_sym_false] = ACTIONS(870),
    [sym_null] = ACTIONS(870),
    [sym_number] = ACTIONS(870),
    [sym_float] = ACTIONS(870),
    [anon_sym_DQUOTE] = ACTIONS(870),
    [anon_sym_SQUOTE] = ACTIONS(870),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(868),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(868),
    [anon_sym_POUND_DQUOTE] = ACTIONS(870),
    [anon_sym_POUND_SQUOTE] = ACTIONS(870),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(868),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(868),
    [sym_comment] = ACTIONS(3),
  },
  [198] = {
    [ts_builtin_sym_end] = ACTIONS(730),
    [sym_identifier] = ACTIONS(732),
    [anon_sym_COMMA] = ACTIONS(730),
    [anon_sym__] = ACTIONS(732),
    [anon_sym_LPAREN] = ACTIONS(730),
    [anon_sym_let] = ACTIONS(732),
    [anon_sym_if] = ACTIONS(732),
    [anon_sym_for] = ACTIONS(732),
    [anon_sym_number] = ACTIONS(732),
    [anon_sym_float] = ACTIONS(732),
    [anon_sym_float32] = ACTIONS(732),
    [anon_sym_float64] = ACTIONS(732),
    [anon_sym_uint] = ACTIONS(732),
    [anon_sym_uint8] = ACTIONS(732),
    [anon_sym_uint16] = ACTIONS(732),
    [anon_sym_uint32] = ACTIONS(732),
    [anon_sym_uint64] = ACTIONS(732),
    [anon_sym_uint128] = ACTIONS(732),
    [anon_sym_int] = ACTIONS(732),
    [anon_sym_int8] = ACTIONS(732),
    [anon_sym_int16] = ACTIONS(732),
    [anon_sym_int32] = ACTIONS(732),
    [anon_sym_int64] = ACTIONS(732),
    [anon_sym_int128] = ACTIONS(732),
    [anon_sym_string] = ACTIONS(732),
    [anon_sym_bytes] = ACTIONS(732),
    [anon_sym_bool] = ACTIONS(732),
    [anon_sym_AT] = ACTIONS(730),
    [anon_sym_DASH] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(730),
    [anon_sym_RBRACK] = ACTIONS(730),
    [anon_sym_LBRACE] = ACTIONS(730),
    [anon_sym_RBRACE] = ACTIONS(730),
    [anon_sym_LT] = ACTIONS(732),
    [anon_sym_GT] = ACTIONS(732),
    [anon_sym_STAR] = ACTIONS(730),
    [anon_sym_len] = ACTIONS(732),
    [anon_sym_close] = ACTIONS(732),
    [anon_sym_and] = ACTIONS(732),
    [anon_sym_or] = ACTIONS(732),
    [anon_sym_div] = ACTIONS(732),
    [anon_sym_mod] = ACTIONS(732),
    [anon_sym_quo] = ACTIONS(732),
    [anon_sym_rem] = ACTIONS(732),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(730),
    [anon_sym_BANG] = ACTIONS(732),
    [anon_sym_PLUS] = ACTIONS(732),
    [anon_sym_EQ_TILDE] = ACTIONS(730),
    [anon_sym_BANG_TILDE] = ACTIONS(730),
    [anon_sym_BANG_EQ] = ACTIONS(730),
    [anon_sym_LT_EQ] = ACTIONS(730),
    [anon_sym_GT_EQ] = ACTIONS(730),
    [sym_bottom] = ACTIONS(730),
    [anon_sym_true] = ACTIONS(732),
    [anon_sym_false] = ACTIONS(732),
    [sym_null] = ACTIONS(732),
    [sym_number] = ACTIONS(732),
    [sym_float] = ACTIONS(732),
    [anon_sym_DQUOTE] = ACTIONS(732),
    [anon_sym_SQUOTE] = ACTIONS(732),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(730),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(730),
    [anon_sym_POUND_DQUOTE] = ACTIONS(732),
    [anon_sym_POUND_SQUOTE] = ACTIONS(732),
    [anon_sym_POUND_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(730),
    [anon_sym_POUND_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(730),
    [sym_comment] = ACTIONS(3),
  },
  [199] = {
    [ts_builtin_sym_end] = ACTIONS(788),
    [sym_identifier] = ACTIONS(790),
    [anon_sym_COMMA] = ACTIONS(788),
    [anon_sym__] = ACTIONS(790),
    [anon_sym_LPAREN] = ACTIONS(788),
    [anon_sym_let] = ACTIONS(790),
    [anon_sym_if] = ACTIONS(790),
    [anon_sym_for] = ACTIONS(790),
    [anon_sym_number] = ACTIONS(790),
    [anon_sym_float] = ACTIONS(790),
    [anon_sym_float32] = ACTIONS(790),
    [anon_sym_float64] = ACTIONS(790),
    [anon_sym_uint] = ACTIONS(790),
    [anon_sym_uint8] = ACTIONS(790),
    [anon_sym_uint16] = ACTIONS(790),
    [anon_sym_uint32] = ACTIONS(790),
    [anon_sym_uint64] = AC