.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_file_strerror.mdoc -- get string representation for a zip error
.\" Copyright (C) 2003-2021 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_FILE_STRERROR" "3" "December 18, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_file_strerror\fR,
\fBzip_strerror\fR
\- get string representation for a zip error
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIconst char *\fR
.br
.PD 0
.HP 4n
\fBzip_file_strerror\fR(\fIzip_file_t\ *file\fR);
.PD
.PP
\fIconst char *\fR
.br
.PD 0
.HP 4n
\fBzip_strerror\fR(\fIzip_t\ *archive\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_strerror\fR()
function returns a string describing the last error for the zip archive
\fIarchive\fR,
while the
\fBzip_file_strerror\fR()
function does the same for a zip file
\fIfile\fR
(one file in an archive).
The returned string must not be modified or freed, and becomes invalid when
\fIarchive\fR
or
\fIfile\fR,
respectively,
is closed or on the next call to
\fBzip_strerror\fR()
or
\fBzip_file_strerror\fR(),
respectively,
for the same archive.
.SH "RETURN VALUES"
\fBzip_file_strerror\fR()
and
\fBzip_strerror\fR()
return a pointer to the error string.
.SH "SEE ALSO"
libzip(3),
zip_error_strerror(3)
.SH "HISTORY"
\fBzip_file_strerror\fR()
and
\fBzip_strerror\fR()
were added in libzip 0.6.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
