/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameClassVisitor;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NsNameNameClass;
import com.thaiopensource.relaxng.output.xsd.basic.Wildcard;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WildcardBuilder
implements NameClassVisitor<VoidValue> {
    private boolean inExcept = false;
    private final String inheritedNamespace;
    private Wildcard wildcard = null;
    private Set<Name> excludedNames;
    private Set<String> namespaces;
    private String inNs = null;

    static Wildcard createWildcard(NameClass nameClass, String string) {
        WildcardBuilder wildcardBuilder = new WildcardBuilder(string);
        nameClass.accept(wildcardBuilder);
        return wildcardBuilder.wildcard;
    }

    private void combineWildcard(Wildcard wildcard) {
        this.wildcard = this.wildcard == null ? wildcard : Wildcard.union(this.wildcard, wildcard);
    }

    private WildcardBuilder(String string) {
        this.inheritedNamespace = string;
    }

    @Override
    public VoidValue visitChoice(ChoiceNameClass choiceNameClass) {
        List<NameClass> list = choiceNameClass.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.get(i).accept(this);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitAnyName(AnyNameNameClass anyNameNameClass) {
        if (!this.inExcept) {
            if (anyNameNameClass.getExcept() != null) {
                this.namespaces = new HashSet<String>();
                this.excludedNames = new HashSet<Name>();
                this.inExcept = true;
                anyNameNameClass.getExcept().accept(this);
                this.inExcept = false;
            } else {
                this.namespaces = Collections.emptySet();
                this.excludedNames = Collections.emptySet();
            }
            this.combineWildcard(new Wildcard(false, this.namespaces, this.excludedNames));
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitNsName(NsNameNameClass nsNameNameClass) {
        String string = this.resolve(nsNameNameClass.getNs());
        if (!this.inExcept) {
            if (nsNameNameClass.getExcept() != null) {
                this.namespaces = null;
                this.excludedNames = new HashSet<Name>();
                this.inNs = string;
                this.inExcept = true;
                nsNameNameClass.getExcept().accept(this);
                this.inExcept = false;
                this.inNs = null;
            } else {
                this.excludedNames = Collections.emptySet();
            }
            this.namespaces = new HashSet<String>();
            this.namespaces.add(string);
            this.combineWildcard(new Wildcard(true, this.namespaces, this.excludedNames));
        } else if (this.inNs == null) {
            this.namespaces.add(string);
        }
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitName(NameNameClass nameNameClass) {
        if (this.inExcept) {
            String string = this.resolve(nameNameClass.getNamespaceUri());
            if (this.inNs == null || this.inNs.equals(string)) {
                this.excludedNames.add(new Name(string, nameNameClass.getLocalName()));
            }
        }
        return VoidValue.VOID;
    }

    private String resolve(String string) {
        if (string == NameNameClass.INHERIT_NS) {
            return this.inheritedNamespace;
        }
        return string;
    }
}

