'use client';
'use strict';

var dayjs = require('dayjs');
var getTimezoneOffset = require('./get-timezone-offset.cjs');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

var dayjs__default = /*#__PURE__*/_interopDefault(dayjs);

const updateTimezone = (date, timezone, direction) => {
  if (!date) {
    return null;
  }
  if (!timezone) {
    return date;
  }
  let offset = getTimezoneOffset.getTimezoneOffset(date, timezone);
  if (direction === "remove") {
    offset *= -1;
  }
  return dayjs__default.default(date).add(offset, "minutes").toDate();
};
function shiftTimezone(direction, date, timezone, disabled) {
  if (disabled || !date) {
    return date;
  }
  if (Array.isArray(date)) {
    return date.map((d) => updateTimezone(d, timezone, direction));
  }
  return updateTimezone(date, timezone, direction);
}

exports.shiftTimezone = shiftTimezone;
//# sourceMappingURL=shift-timezone.cjs.map
