<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# trie

```go
import "github.com/zyedidia/generic/trie"
```

Package trie provides an implementation of a ternary search trie.

<details><summary>Example</summary>
<p>

```go
package main

import (
	"fmt"

	"github.com/zyedidia/generic/trie"
)

func main() {
	tr := trie.New[int]()
	tr.Put("foo", 1)
	tr.Put("fo", 2)
	tr.Put("bar", 3)

	fmt.Println(tr.Contains("f"))
	fmt.Println(tr.KeysWithPrefix(""))
	fmt.Println(tr.KeysWithPrefix("f"))
}
```

#### Output

```
false
[bar fo foo]
[fo foo]
```

</p>
</details>

## Index

- [type Trie](<#type-trie>)
  - [func New[V any]() *Trie[V]](<#func-new>)
  - [func (t *Trie[V]) Contains(key string) bool](<#func-triev-contains>)
  - [func (t *Trie[V]) Get(key string) (v V, ok bool)](<#func-triev-get>)
  - [func (t *Trie[V]) Keys() (queue []string)](<#func-triev-keys>)
  - [func (t *Trie[V]) KeysWithPrefix(prefix string) (queue []string)](<#func-triev-keyswithprefix>)
  - [func (t *Trie[V]) LongestPrefix(query string) string](<#func-triev-longestprefix>)
  - [func (t *Trie[V]) Put(key string, val V)](<#func-triev-put>)
  - [func (t *Trie[V]) Remove(key string)](<#func-triev-remove>)
  - [func (t *Trie[V]) Size() int](<#func-triev-size>)


## type [Trie](<https://github.com/zyedidia/generic/blob/master/trie/trie.go#L9-L12>)

A Trie is a data structure that supports common prefix operations.

```go
type Trie[V any] struct {
    // contains filtered or unexported fields
}
```

### func [New](<https://github.com/zyedidia/generic/blob/master/trie/trie.go#L22>)

```go
func New[V any]() *Trie[V]
```

New returns an empty trie.

### func \(\*Trie\[V\]\) [Contains](<https://github.com/zyedidia/generic/blob/master/trie/trie.go#L32>)

```go
func (t *Trie[V]) Contains(key string) bool
```

Contains returns whether this trie contains 'key'.

### func \(\*Trie\[V\]\) [Get](<https://github.com/zyedidia/generic/blob/master/trie/trie.go#L41>)

```go
func (t *Trie[V]) Get(key string) (v V, ok bool)
```

Get returns the value associated with 'key'.

### func \(\*Trie\[V\]\) [Keys](<https://github.com/zyedidia/generic/blob/master/trie/trie.go#L136>)

```go
func (t *Trie[V]) Keys() (queue []string)
```

Keys returns all keys in the trie.

### func \(\*Trie\[V\]\) [KeysWithPrefix](<https://github.com/zyedidia/generic/blob/master/trie/trie.go#L141>)

```go
func (t *Trie[V]) KeysWithPrefix(prefix string) (queue []string)
```

KeysWithPrefix returns all keys with prefix 'prefix'.

### func \(\*Trie\[V\]\) [LongestPrefix](<https://github.com/zyedidia/generic/blob/master/trie/trie.go#L111>)

```go
func (t *Trie[V]) LongestPrefix(query string) string
```

LongestPrefix returns the key that is the longest prefix of 'query'.

### func \(\*Trie\[V\]\) [Put](<https://github.com/zyedidia/generic/blob/master/trie/trie.go#L69>)

```go
func (t *Trie[V]) Put(key string, val V)
```

Put associates 'val' with 'key'.

### func \(\*Trie\[V\]\) [Remove](<https://github.com/zyedidia/generic/blob/master/trie/trie.go#L80>)

```go
func (t *Trie[V]) Remove(key string)
```

Remove removes the value associated with 'key'.

### func \(\*Trie\[V\]\) [Size](<https://github.com/zyedidia/generic/blob/master/trie/trie.go#L27>)

```go
func (t *Trie[V]) Size() int
```

Size returns the size of the trie.



Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)
