<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# mapset

```go
import "github.com/zyedidia/generic/mapset"
```

Package mapset provides an implementation of a set using the built\-in map.

<details><summary>Example</summary>
<p>

```go
package main

import (
	"fmt"

	"github.com/zyedidia/generic/mapset"
)

func main() {
	set := mapset.New[string]()
	set.Put("foo")
	set.Put("bar")
	set.Put("baz")

	fmt.Println("foo", set.Has("foo"))
	fmt.Println("quux", set.Has("quux"))

	set.Remove("foo")
	fmt.Println("foo", set.Has("foo"))
	fmt.Println("bar", set.Has("bar"))

	set.Clear()
	fmt.Println("foo", set.Has("foo"))
	fmt.Println("bar", set.Has("bar"))
}
```

#### Output

```
foo true
quux false
foo false
bar true
foo false
bar false
```

</p>
</details>

## Index

- [type Set](<#type-set>)
  - [func New[K comparable]() Set[K]](<#func-new>)
  - [func Of[K comparable](vals ...K) Set[K]](<#func-of>)
  - [func (s Set[K]) Clear()](<#func-setk-clear>)
  - [func (s Set[K]) Each(fn func(key K))](<#func-setk-each>)
  - [func (s Set[K]) Has(val K) bool](<#func-setk-has>)
  - [func (s Set[K]) Put(val K)](<#func-setk-put>)
  - [func (s Set[K]) Remove(val K)](<#func-setk-remove>)
  - [func (s Set[K]) Size() int](<#func-setk-size>)


## type [Set](<https://github.com/zyedidia/generic/blob/master/mapset/set.go#L7-L9>)

Set implements a hashset, using the hashmap as the underlying storage.

```go
type Set[K comparable] struct {
    // contains filtered or unexported fields
}
```

### func [New](<https://github.com/zyedidia/generic/blob/master/mapset/set.go#L12>)

```go
func New[K comparable]() Set[K]
```

New returns an empty hashset.

### func [Of](<https://github.com/zyedidia/generic/blob/master/mapset/set.go#L19>)

```go
func Of[K comparable](vals ...K) Set[K]
```

Of returns a new hashset initialized with the given 'vals'

### func \(Set\[K\]\) [Clear](<https://github.com/zyedidia/generic/blob/master/mapset/set.go#L44>)

```go
func (s Set[K]) Clear()
```

Clear removes all elements from the set.

### func \(Set\[K\]\) [Each](<https://github.com/zyedidia/generic/blob/master/mapset/set.go#L54>)

```go
func (s Set[K]) Each(fn func(key K))
```

Each calls 'fn' on every item in the set in no particular order.

### func \(Set\[K\]\) [Has](<https://github.com/zyedidia/generic/blob/master/mapset/set.go#L33>)

```go
func (s Set[K]) Has(val K) bool
```

Has returns true only if 'val' is in the set.

### func \(Set\[K\]\) [Put](<https://github.com/zyedidia/generic/blob/master/mapset/set.go#L28>)

```go
func (s Set[K]) Put(val K)
```

Put adds 'val' to the set.

### func \(Set\[K\]\) [Remove](<https://github.com/zyedidia/generic/blob/master/mapset/set.go#L39>)

```go
func (s Set[K]) Remove(val K)
```

Remove removes 'val' from the set.

### func \(Set\[K\]\) [Size](<https://github.com/zyedidia/generic/blob/master/mapset/set.go#L49>)

```go
func (s Set[K]) Size() int
```

Size returns the number of elements in the set.



Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)
